/*
 @licstart  The following is the entire license notice for the JavaScript code in this file.

 The MIT License (MIT)

 Copyright (C) 1997-2020 by Dimitri van Heesch

 Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 and associated documentation files (the "Software"), to deal in the Software without restriction,
 including without limitation the rights to use, copy, modify, merge, publish, distribute,
 sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all copies or
 substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 @licend  The above is the entire license notice for the JavaScript code in this file
*/
var NAVTREE =
[
  [ "StarPU Handbook", "index.html", [
    [ "Introduction", "index.html", [
      [ "Motivation", "index.html#Motivation", null ],
      [ "StarPU in a Nutshell", "index.html#StarPUInANutshell", [
        [ "Codelet and Tasks", "index.html#CodeletAndTasks", null ],
        [ "StarPU Data Management Library", "index.html#StarPUDataManagementLibrary", null ]
      ] ],
      [ "Application Taskification", "index.html#ApplicationTaskification", null ],
      [ "Research Papers", "index.html#ResearchPapers", null ]
    ] ],
    [ "Documentation Organization", "DocOrganization.html", null ],
    [ "Glossary", "Glossary.html", null ],
    [ "------— StarPU Installation ------—", "IntroInstallation.html", null ],
    [ "Building and Installing StarPU", "BuildingAndInstallingStarPU.html", [
      [ "Installing a Binary Package", "BuildingAndInstallingStarPU.html#InstallingABinaryPackage", null ],
      [ "Installing a Source Package", "BuildingAndInstallingStarPU.html#InstallingASourcePackage", [
        [ "Installing the Spack Package", "BuildingAndInstallingStarPU.html#SpackInstallation", null ]
      ] ],
      [ "Building from Source", "BuildingAndInstallingStarPU.html#InstallingFromSource", [
        [ "Optional Dependencies", "BuildingAndInstallingStarPU.html#OptionalDependencies", null ],
        [ "Getting Sources", "BuildingAndInstallingStarPU.html#GettingSources", null ],
        [ "Configuring StarPU", "BuildingAndInstallingStarPU.html#ConfiguringStarPU", null ],
        [ "Building StarPU", "BuildingAndInstallingStarPU.html#BuildingStarPU", null ],
        [ "Installing StarPU", "BuildingAndInstallingStarPU.html#InstallingStarPU", null ]
      ] ]
    ] ],
    [ "Compilation Configuration", "CompilationConfiguration.html", [
      [ "Common Configuration", "CompilationConfiguration.html#CommonConfiguration", null ],
      [ "Configuring Workers", "CompilationConfiguration.html#ConfiguringWorkers", null ],
      [ "Extension Configuration", "CompilationConfiguration.html#ExtensionConfiguration", null ],
      [ "Advanced Configuration", "CompilationConfiguration.html#AdvancedConfiguration", null ]
    ] ],
    [ "Execution Configuration Through Environment Variables", "ExecutionConfigurationThroughEnvironmentVariables.html", [
      [ "Configuring Workers", "ExecutionConfigurationThroughEnvironmentVariables.html#EnvConfiguringWorkers", [
        [ "General Configuration", "ExecutionConfigurationThroughEnvironmentVariables.html#Basic", null ],
        [ "CPU Workers", "ExecutionConfigurationThroughEnvironmentVariables.html#cpuWorkers", null ],
        [ "CUDA Workers", "ExecutionConfigurationThroughEnvironmentVariables.html#cudaWorkers", null ],
        [ "OpenCL Workers", "ExecutionConfigurationThroughEnvironmentVariables.html#openclWorkers", null ],
        [ "Maxeler FPGA Workers", "ExecutionConfigurationThroughEnvironmentVariables.html#maxfpgaWorkers", null ],
        [ "MPI Master Slave Workers", "ExecutionConfigurationThroughEnvironmentVariables.html#mpimsWorkers", null ],
        [ "TCP/IP Master Slave Workers", "ExecutionConfigurationThroughEnvironmentVariables.html#tcpipmsWorkers", null ],
        [ "HIP Workers", "ExecutionConfigurationThroughEnvironmentVariables.html#hipWorkers", null ],
        [ "MPI Configuration", "ExecutionConfigurationThroughEnvironmentVariables.html#mpiConf", null ]
      ] ],
      [ "Configuring The Scheduling Engine", "ExecutionConfigurationThroughEnvironmentVariables.html#ConfiguringTheSchedulingEngine", null ],
      [ "Configuring The Heteroprio Scheduler", "ExecutionConfigurationThroughEnvironmentVariables.html#ConfiguringHeteroprio", [
        [ "Configuring LAHeteroprio", "ExecutionConfigurationThroughEnvironmentVariables.html#ConfiguringLaHeteroprio", null ],
        [ "Configuring AutoHeteroprio", "ExecutionConfigurationThroughEnvironmentVariables.html#ConfiguringAutoHeteroprio", null ]
      ] ],
      [ "Extensions", "ExecutionConfigurationThroughEnvironmentVariables.html#Extensions", null ],
      [ "Miscellaneous And Debug", "ExecutionConfigurationThroughEnvironmentVariables.html#MiscellaneousAndDebug", null ],
      [ "Configuring The Hypervisor", "ExecutionConfigurationThroughEnvironmentVariables.html#ConfiguringTheHypervisor", null ]
    ] ],
    [ "Configuration and Initialization", "ConfigurationAndInitialization.html", null ],
    [ "------— StarPU Basics ------—", "IntroBasics.html", null ],
    [ "StarPU Applications, setting up Your Own Code", "StarPUApplications.html", [
      [ "Setting Flags for Compiling, Linking and Running Applications", "StarPUApplications.html#SettingFlagsForCompilingLinkingAndRunningApplications", null ],
      [ "Integrating StarPU in a Build System", "StarPUApplications.html#IntegratingStarPUInABuildSystem", [
        [ "Integrating StarPU in a Make Build System", "StarPUApplications.html#StarPUInMake", null ],
        [ "Integrating StarPU in a CMake Build System", "StarPUApplications.html#StarPUInCMake", null ]
      ] ],
      [ "Running a Basic StarPU Application", "StarPUApplications.html#RunningABasicStarPUApplication", null ],
      [ "Running a Basic StarPU Application on Microsoft Visual C", "StarPUApplications.html#RunningABasicStarPUApplicationOnMicrosoft", null ],
      [ "Kernel Threads Started by StarPU", "StarPUApplications.html#KernelThreadsStartedByStarPU", null ],
      [ "Enabling OpenCL", "StarPUApplications.html#EnablingOpenCL", null ],
      [ "Storing Performance Model Files", "StarPUApplications.html#Storing_Performance_Model_Files", null ]
    ] ],
    [ "Basic Examples", "BasicExamples.html", [
      [ "Hello World", "BasicExamples.html#HelloWorldUsingStarPUAPI", [
        [ "Required Headers", "BasicExamples.html#RequiredHeaders", null ],
        [ "Defining A Codelet", "BasicExamples.html#DefiningACodelet", null ],
        [ "Submitting A Task", "BasicExamples.html#SubmittingATask", null ],
        [ "Execution Of Hello World", "BasicExamples.html#ExecutionOfHelloWorld", null ],
        [ "Passing Arguments To The Codelet", "BasicExamples.html#PassingArgumentsToTheCodelet", null ],
        [ "Defining A Callback", "BasicExamples.html#DefiningACallback", null ],
        [ "Where To Execute A Codelet", "BasicExamples.html#WhereToExecuteACodelet", null ]
      ] ],
      [ "Vector Scaling", "BasicExamples.html#VectorScalingUsingStarPUAPI", [
        [ "Source Code of Vector Scaling", "BasicExamples.html#SourceCodeOfVectorScaling", null ],
        [ "Execution of Vector Scaling", "BasicExamples.html#ExecutionOfVectorScaling", null ]
      ] ],
      [ "Vector Scaling on an Hybrid CPU/GPU Machine", "BasicExamples.html#VectorScalingOnAnHybridCPUGPUMachine", [
        [ "Definition of the CUDA Kernel", "BasicExamples.html#DefinitionOfTheCUDAKernel", null ],
        [ "Definition of the OpenCL Kernel", "BasicExamples.html#DefinitionOfTheOpenCLKernel", null ],
        [ "Definition of the Main Code", "BasicExamples.html#DefinitionOfTheMainCode", null ],
        [ "Execution of Hybrid Vector Scaling", "BasicExamples.html#ExecutionOfHybridVectorScaling", null ]
      ] ]
    ] ],
    [ "Full source code for the ’Scaling a Vector’ example", "FullSourceCodeVectorScal.html", [
      [ "Main Application", "FullSourceCodeVectorScal.html#MainApplication", null ],
      [ "CPU Kernel", "FullSourceCodeVectorScal.html#CPUKernel", null ],
      [ "CUDA Kernel", "FullSourceCodeVectorScal.html#CUDAKernel", null ],
      [ "OpenCL Kernel", "FullSourceCodeVectorScal.html#OpenCLKernel", [
        [ "Invoking the Kernel", "FullSourceCodeVectorScal.html#InvokingtheKernel", null ],
        [ "Source of the Kernel", "FullSourceCodeVectorScal.html#SourceoftheKernel", null ]
      ] ]
    ] ],
    [ "Tasks In StarPU", "TasksInStarPU.html", [
      [ "Task Granularity", "TasksInStarPU.html#TaskGranularity", null ],
      [ "Task Submission", "TasksInStarPU.html#TaskSubmission", null ],
      [ "Task Priorities", "TasksInStarPU.html#TaskPriorities", null ],
      [ "Setting Many Data Handles For a Task", "TasksInStarPU.html#SettingManyDataHandlesForATask", null ],
      [ "Setting a Variable Number Of Data Handles For a Task", "TasksInStarPU.html#SettingVariableDataHandlesForATask", null ],
      [ "Insert Task Utility", "TasksInStarPU.html#InsertTaskUtility", null ],
      [ "Other Task Utility Functions", "TasksInStarPU.html#OtherTaskUtility", null ]
    ] ],
    [ "Data Management", "DataManagement.html", [
      [ "Data Interface", "DataManagement.html#DataInterface", [
        [ "Variable Data Interface", "DataManagement.html#VariableDataInterface", null ],
        [ "Vector Data Interface", "DataManagement.html#VectorDataInterface", null ],
        [ "Matrix Data Interface", "DataManagement.html#MatrixDataInterface", null ],
        [ "Block Data Interface", "DataManagement.html#BlockDataInterface", null ],
        [ "Tensor Data Interface", "DataManagement.html#TensorDataInterface", null ],
        [ "Ndim Data Interface", "DataManagement.html#NdimDataInterface", null ],
        [ "BCSR Data Interface", "DataManagement.html#BCSRDataInterface", null ],
        [ "CSR Data Interface", "DataManagement.html#CSRDataInterface", null ],
        [ "COO Data Interface", "DataManagement.html#COODataInterface", null ]
      ] ],
      [ "Partitioning Data", "DataManagement.html#PartitioningData", null ],
      [ "Asynchronous Partitioning", "DataManagement.html#AsynchronousPartitioning", null ],
      [ "Commute Data Access", "DataManagement.html#DataCommute", null ],
      [ "Data Reduction", "DataManagement.html#DataReduction", null ],
      [ "Concurrent Data Accesses", "DataManagement.html#ConcurrentDataAccess", null ],
      [ "Temporary Buffers", "DataManagement.html#TemporaryBuffers", [
        [ "Temporary Data", "DataManagement.html#TemporaryData", null ],
        [ "Scratch Data", "DataManagement.html#ScratchData", null ]
      ] ]
    ] ],
    [ "Scheduling", "Scheduling.html", [
      [ "Task Scheduling Policies", "Scheduling.html#TaskSchedulingPolicy", [
        [ "Non Performance Modelling Policies", "Scheduling.html#NonPerformanceModelingPolicies", null ],
        [ "Performance Model-Based Task Scheduling Policies", "Scheduling.html#DMTaskSchedulingPolicy", null ],
        [ "Modularized Schedulers", "Scheduling.html#ExistingModularizedSchedulers", null ]
      ] ],
      [ "Task Distribution Vs Data Transfer", "Scheduling.html#TaskDistributionVsDataTransfer", null ]
    ] ],
    [ "Examples in StarPU Sources", "ExamplesInStarPUSources.html", null ],
    [ "------— StarPU Applications ------—", "IntroApplications.html", null ],
    [ "A Stencil Application", "StencilApplication.html", [
      [ "The Original Application", "StencilApplication.html#StencilOriginal", null ],
      [ "The StarPU Application", "StencilApplication.html#StencilStarPU", null ],
      [ "The StarPU MPI Application", "StencilApplication.html#StencilStarPUMPI", null ]
    ] ],
    [ "------— StarPU Performances ------—", "IntroPerformances.html", null ],
    [ "Benchmarking StarPU", "BenchmarkingStarPU.html", [
      [ "Task Size Overhead", "BenchmarkingStarPU.html#TaskSizeOverhead", null ],
      [ "Data Transfer Latency", "BenchmarkingStarPU.html#DataTransferLatency", null ],
      [ "Matrix-Matrix Multiplication", "BenchmarkingStarPU.html#MatrixMatrixMultiplication", null ],
      [ "Cholesky Factorization", "BenchmarkingStarPU.html#CholeskyFactorization", null ],
      [ "LU Factorization", "BenchmarkingStarPU.html#LUFactorization", null ],
      [ "Simulated Benchmarks", "BenchmarkingStarPU.html#SimulatedBenchmarks", null ]
    ] ],
    [ "Online Performance Tools", "OnlinePerformanceTools.html", [
      [ "On-line Performance Feedback", "OnlinePerformanceTools.html#On-linePerformanceFeedback", [
        [ "Enabling On-line Performance Monitoring", "OnlinePerformanceTools.html#EnablingOn-linePerformanceMonitoring", null ],
        [ "Per-task Feedback", "OnlinePerformanceTools.html#Per-taskFeedback", null ],
        [ "Per-codelet Feedback", "OnlinePerformanceTools.html#Per-codeletFeedback", null ],
        [ "Per-worker Feedback", "OnlinePerformanceTools.html#Per-workerFeedback", null ],
        [ "Bus-related Feedback", "OnlinePerformanceTools.html#Bus-relatedFeedback", null ],
        [ "MPI-related Feedback", "OnlinePerformanceTools.html#MPI-relatedFeedback", null ]
      ] ],
      [ "Task And Worker Profiling", "OnlinePerformanceTools.html#TaskAndWorkerProfiling", null ],
      [ "Performance Model Example", "OnlinePerformanceTools.html#PerformanceModelExample", null ],
      [ "Performance Monitoring Counters", "OnlinePerformanceTools.html#PerformanceMonitoringCounters", [
        [ "Objectives", "OnlinePerformanceTools.html#PerfMonCountObjectives", null ],
        [ "Entities", "OnlinePerformanceTools.html#PerfMonCountEntities", [
          [ "Performance Counter", "OnlinePerformanceTools.html#PerfMonCountCounter", null ],
          [ "Performance Counter Type", "OnlinePerformanceTools.html#PerfMonCountCounterType", null ],
          [ "Performance Counter Scope", "OnlinePerformanceTools.html#PerfMonCountCounterScope", null ],
          [ "Performance Counter Set", "OnlinePerformanceTools.html#PerfMonCountCounterSet", null ],
          [ "Performance Counter Sample", "OnlinePerformanceTools.html#PerfMonCountCounterSample", null ],
          [ "Performance Counter Listener", "OnlinePerformanceTools.html#PerfMonCountCounterListener", null ],
          [ "Application Programming Interface", "OnlinePerformanceTools.html#PerfMonCountCounterAPI", null ]
        ] ],
        [ "Implementation Details", "OnlinePerformanceTools.html#PerfMonCountCounterImplementation", [
          [ "Performance Counter Registration", "OnlinePerformanceTools.html#PerfMonCountCounterImplRegistration", null ],
          [ "Performance Sample Updaters", "OnlinePerformanceTools.html#PerfMonCountCounterImplUpdaters", null ],
          [ "Counter operations", "OnlinePerformanceTools.html#PerfMonCountCounterImplOperations", null ],
          [ "Runtime checks", "OnlinePerformanceTools.html#PerfMonCountCounterImplRuntime", null ]
        ] ],
        [ "Exported Counters", "OnlinePerformanceTools.html#PerfMonCountCounterExported", [
          [ "Global Scope", "OnlinePerformanceTools.html#PerfMonCountCounterExportedGlobal", null ],
          [ "Per-worker Scope", "OnlinePerformanceTools.html#PerfMonCountCounterExportedPerWorker", null ],
          [ "Per-Codelet Scope", "OnlinePerformanceTools.html#PerfMonCountCounterExportedPerCodelet", null ]
        ] ],
        [ "Sequence of operations", "OnlinePerformanceTools.html#PerfMonCountCounterSequence", null ]
      ] ],
      [ "Performance Steering Knobs", "OnlinePerformanceTools.html#PerfKnobs", [
        [ "Objectives", "OnlinePerformanceTools.html#PerfKnobsObjectives", null ],
        [ "Entities", "OnlinePerformanceTools.html#PerfKnobsEntities", [
          [ "Performance Steering Knob", "OnlinePerformanceTools.html#PerfKnobsEntitiesKnob", null ],
          [ "Knob Type", "OnlinePerformanceTools.html#PerfKnobsEntitiesKnobType", null ],
          [ "Knob Scope", "OnlinePerformanceTools.html#PerfKnobsEntitiesKnobScope", null ],
          [ "Knob Group", "OnlinePerformanceTools.html#PerfKnobsEntitiesKnobGroup", null ]
        ] ],
        [ "Application Programming Interface", "OnlinePerformanceTools.html#PerfKnobsAPI", null ],
        [ "Implementation Details", "OnlinePerformanceTools.html#PerfKnobsImpl", null ],
        [ "Exported Steering Knobs", "OnlinePerformanceTools.html#PerfKnobsExported", [
          [ "Global Scope", "OnlinePerformanceTools.html#PerfKnobsExportedGlobal", null ],
          [ "Per-worker Scope", "OnlinePerformanceTools.html#PerfKnobsExportedPerWorker", null ],
          [ "Per-Scheduler Scope", "OnlinePerformanceTools.html#PerfKnobsExportedPerScheduler", null ]
        ] ],
        [ "Sequence of operations", "OnlinePerformanceTools.html#PerfKnobsSequence", null ]
      ] ]
    ] ],
    [ "Offline Performance Tools", "OfflinePerformanceTools.html", [
      [ "Generating Traces With FxT", "OfflinePerformanceTools.html#GeneratingTracesWithFxT", [
        [ "Creating a Gantt Diagram", "OfflinePerformanceTools.html#CreatingAGanttDiagram", [
          [ "Zooming in Gantt Diagram", "OfflinePerformanceTools.html#ZoomingInGantt", null ],
          [ "Colors in Gantt Diagram", "OfflinePerformanceTools.html#ColorsInGantt", null ],
          [ "Curves in Gantt Diagram", "OfflinePerformanceTools.html#CurvesInGantt", null ],
          [ "States in Gantt Diagram", "OfflinePerformanceTools.html#StatesInGantt", null ],
          [ "Transfers in Gantt Diagram", "OfflinePerformanceTools.html#TransfersInGantt", null ],
          [ "Scheduler in Gantt Diagram", "OfflinePerformanceTools.html#SchedulerInGantt", null ],
          [ "Main Thread in Gantt Diagram", "OfflinePerformanceTools.html#MainThreadInGantt", null ],
          [ "Statistics in Gantt Diagram", "OfflinePerformanceTools.html#StatisticsInGantt", null ]
        ] ],
        [ "Creating a DAG With Graphviz", "OfflinePerformanceTools.html#CreatingADAGWithGraphviz", null ],
        [ "Getting Task Details", "OfflinePerformanceTools.html#TraceTaskDetails", null ],
        [ "Getting Scheduling Task Details", "OfflinePerformanceTools.html#TraceSchedTaskDetails", null ],
        [ "Monitoring Activity", "OfflinePerformanceTools.html#MonitoringActivity", null ],
        [ "Getting Modular Schedular Animation", "OfflinePerformanceTools.html#Animation", null ],
        [ "Analyzing Time Between MPI Data Transfer and Use by Tasks", "OfflinePerformanceTools.html#TimeBetweenSendRecvDataUse", null ],
        [ "Number of events in trace files", "OfflinePerformanceTools.html#NumberEvents", null ],
        [ "Limiting The Scope Of The Trace", "OfflinePerformanceTools.html#LimitingScopeTrace", null ]
      ] ],
      [ "Performance Of Codelets", "OfflinePerformanceTools.html#PerformanceOfCodelets", null ],
      [ "Energy Of Codelets", "OfflinePerformanceTools.html#EnergyOfCodelets", null ],
      [ "Data trace and tasks length", "OfflinePerformanceTools.html#DataTrace", null ],
      [ "Trace Statistics", "OfflinePerformanceTools.html#TraceStatistics", null ],
      [ "PAPI counters", "OfflinePerformanceTools.html#PapiCounters", null ],
      [ "Theoretical Lower Bound On Execution Time", "OfflinePerformanceTools.html#TheoreticalLowerBoundOnExecutionTime", null ],
      [ "Trace visualization with StarVZ", "OfflinePerformanceTools.html#starvz", null ],
      [ "StarPU Eclipse Plugin", "OfflinePerformanceTools.html#EclipsePlugin", [
        [ "Eclipse Installation", "OfflinePerformanceTools.html#EclipseInstallation", null ],
        [ "StarPU Eclipse Plugin Compilation and Installation", "OfflinePerformanceTools.html#PluginInstallation", null ],
        [ "StarPU Eclipse Plugin Instruction", "OfflinePerformanceTools.html#PluginInstruction", null ]
      ] ],
      [ "Memory Feedback", "OfflinePerformanceTools.html#MemoryFeedback", null ],
      [ "Data Statistics", "OfflinePerformanceTools.html#DataStatistics", null ],
      [ "Tracing MPI applications", "OfflinePerformanceTools.html#TraceMpi", null ],
      [ "Verbose Traces", "OfflinePerformanceTools.html#VerboseTraces", null ]
    ] ],
    [ "------— StarPU FAQs ------—", "IntroFAQ.html", null ],
    [ "Check List When Performance Are Not There", "CheckListWhenPerformanceAreNotThere.html", [
      [ "Check Task Size", "CheckListWhenPerformanceAreNotThere.html#CheckTaskSize", null ],
      [ "Configuration Which May Improve Performance", "CheckListWhenPerformanceAreNotThere.html#ConfigurationImprovePerformance", null ],
      [ "Data Related Features Which May Improve Performance", "CheckListWhenPerformanceAreNotThere.html#DataRelatedFeaturesToImprovePerformance", null ],
      [ "Task Related Features Which May Improve Performance", "CheckListWhenPerformanceAreNotThere.html#TaskRelatedFeaturesToImprovePerformance", null ],
      [ "Scheduling Related Features Which May Improve Performance", "CheckListWhenPerformanceAreNotThere.html#SchedulingRelatedFeaturesToImprovePerformance", null ],
      [ "CUDA-specific Optimizations", "CheckListWhenPerformanceAreNotThere.html#CUDA-specificOptimizations", null ],
      [ "OpenCL-specific Optimizations", "CheckListWhenPerformanceAreNotThere.html#OpenCL-specificOptimizations", null ],
      [ "Detecting Stuck Conditions", "CheckListWhenPerformanceAreNotThere.html#DetectionStuckConditions", null ],
      [ "How to Limit Memory Used By StarPU And Cache Buffer Allocations", "CheckListWhenPerformanceAreNotThere.html#HowToLimitMemoryPerNode", null ],
      [ "How To Reduce The Memory Footprint Of Internal Data Structures", "CheckListWhenPerformanceAreNotThere.html#HowToReduceTheMemoryFootprintOfInternalDataStructures", null ],
      [ "How To Reuse Memory", "CheckListWhenPerformanceAreNotThere.html#HowtoReuseMemory", null ],
      [ "Performance Model Calibration", "CheckListWhenPerformanceAreNotThere.html#PerformanceModelCalibration", null ],
      [ "Profiling", "CheckListWhenPerformanceAreNotThere.html#Profiling", null ],
      [ "Overhead Profiling", "CheckListWhenPerformanceAreNotThere.html#OverheadProfiling", null ]
    ] ],
    [ "Frequently Asked Questions", "FrequentlyAskedQuestions.html", [
      [ "How To Initialize A Computation Library Once For Each Worker?", "FrequentlyAskedQuestions.html#HowToInitializeAComputationLibraryOnceForEachWorker", null ],
      [ "Hardware Topology", "FrequentlyAskedQuestions.html#HardwareTopology", [
        [ "Interoperability hwloc", "FrequentlyAskedQuestions.html#InteroperabilityHWLOC", null ],
        [ "Memory", "FrequentlyAskedQuestions.html#TopologyMemory", null ],
        [ "Workers", "FrequentlyAskedQuestions.html#TopologyWorkers", null ],
        [ "Bus", "FrequentlyAskedQuestions.html#TopologyBus", null ]
      ] ],
      [ "Using The Driver API", "FrequentlyAskedQuestions.html#UsingTheDriverAPI", null ],
      [ "On-GPU Rendering", "FrequentlyAskedQuestions.html#On-GPURendering", null ],
      [ "Using StarPU With MKL 11 (Intel Composer XE 2013)", "FrequentlyAskedQuestions.html#UsingStarPUWithMKL", null ],
      [ "Thread Binding on NetBSD", "FrequentlyAskedQuestions.html#ThreadBindingOnNetBSD", null ],
      [ "StarPU permanently eats 100% of all CPUs", "FrequentlyAskedQuestions.html#StarPUEatsCPUs", null ],
      [ "Interleaving StarPU and non-StarPU code", "FrequentlyAskedQuestions.html#PauseResume", null ],
      [ "When running with CUDA or OpenCL devices, I am seeing less CPU cores", "FrequentlyAskedQuestions.html#GPUEatingCores", null ],
      [ "StarPU does not see my CUDA device", "FrequentlyAskedQuestions.html#CUDADrivers", null ],
      [ "StarPU does not see my OpenCL device", "FrequentlyAskedQuestions.html#OpenCLDrivers", null ],
      [ "There seems to be errors when copying to and from CUDA devices", "FrequentlyAskedQuestions.html#CUDACopyError", null ],
      [ "I keep getting a \"Incorrect performance model file\" error", "FrequentlyAskedQuestions.html#IncorrectPerformanceModelFile", null ]
    ] ],
    [ "------— StarPU Language Bindings ------—", "IntroLanguage.html", null ],
    [ "The StarPU Native Fortran Support", "NativeFortranSupport.html", [
      [ "Implementation Details and Specificities", "NativeFortranSupport.html#NFImplementation", [
        [ "Prerequisites", "NativeFortranSupport.html#NFPrerequisites", null ],
        [ "Configuration", "NativeFortranSupport.html#NFConfiguration", null ],
        [ "Examples", "NativeFortranSupport.html#NFExamples", null ],
        [ "Compiling a Native Fortran Application", "NativeFortranSupport.html#NFAppCompile", null ]
      ] ],
      [ "Fortran Translation for Common StarPU API Idioms", "NativeFortranSupport.html#NFIdioms", null ],
      [ "Uses, Initialization and Shutdown", "NativeFortranSupport.html#NFInitExit", null ],
      [ "Fortran Flavor of StarPU's Variadic Insert_task", "NativeFortranSupport.html#NFInsertTask", null ],
      [ "Functions and Subroutines Expecting Data Structures Arguments", "NativeFortranSupport.html#NFStructs", null ],
      [ "Additional Notes about the Native Fortran Support", "NativeFortranSupport.html#NFNotes", [
        [ "Using StarPU with Older Fortran Compilers", "NativeFortranSupport.html#NFOldFortran", null ],
        [ "Valid API Mixes and Language Mixes", "NativeFortranSupport.html#NFAPIMIX", null ]
      ] ]
    ] ],
    [ "StarPU Java Interface", "StarPUJavaInterface.html", null ],
    [ "Python Interface", "PythonInterface.html", [
      [ "Installation of the Python Interface", "PythonInterface.html#Installation", null ],
      [ "Python Parallelism", "PythonInterface.html#PythonParallelism", null ],
      [ "Using StarPU in Python", "PythonInterface.html#ImplementingStarPUInPython", [
        [ "Submitting Tasks", "PythonInterface.html#SubmittingTasks", null ],
        [ "Returning Future Object", "PythonInterface.html#ReturningFutureObject", null ],
        [ "Submit Python Objects Supporting The Buffer Protocol", "PythonInterface.html#SubmitPythonBuffer", [
          [ "Access Mode Annotation", "PythonInterface.html#AnnotationAccess", null ],
          [ "Methods", "PythonInterface.html#MethodsAcquireRelease", null ]
        ] ]
      ] ],
      [ "StarPU Data Interface for Python Objects", "PythonInterface.html#StarPUPYInterface", [
        [ "Interface for Ordinary Python Objects", "PythonInterface.html#PythonObject", null ],
        [ "Interface for Python Objects Supporting Buffer Protocol", "PythonInterface.html#PythonBuffer", [
          [ "Methods", "PythonInterface.html#Methods", null ]
        ] ],
        [ "Interface for Empty Numpy Array", "PythonInterface.html#EmptyNumpy", null ],
        [ "Array Partitioning", "PythonInterface.html#HandlePartition", null ]
      ] ],
      [ "Benchmark", "PythonInterface.html#Benchmark", null ],
      [ "Running Python Functions as Pipeline Jobs (Imitating Joblib Library)", "PythonInterface.html#ImitatingJoblibLibrary", [
        [ "Examples", "PythonInterface.html#JobLibraryExamples", null ],
        [ "Parallel Parameters", "PythonInterface.html#ParallelParameters", null ],
        [ "Performances", "PythonInterface.html#JobLibPerformances", null ]
      ] ],
      [ "Multiple Interpreters", "PythonInterface.html#MultipleInterpreters", null ],
      [ "Master Slave Support", "PythonInterface.html#StarpupyMasterSlave", null ]
    ] ],
    [ "The StarPU OpenMP Runtime Support (SORS)", "OpenMPRuntimeSupport.html", [
      [ "Implementation Details and Specificities", "OpenMPRuntimeSupport.html#OMPImplementation", [
        [ "Main Thread", "OpenMPRuntimeSupport.html#OMPMainThread", null ],
        [ "Extended Task Semantics", "OpenMPRuntimeSupport.html#OMPTaskSemantics", null ]
      ] ],
      [ "Configuration", "OpenMPRuntimeSupport.html#OMPConfiguration", null ],
      [ "Initialization and Shutdown", "OpenMPRuntimeSupport.html#OMPInitExit", null ],
      [ "Parallel Regions and Worksharing", "OpenMPRuntimeSupport.html#OMPSharing", [
        [ "Parallel Regions", "OpenMPRuntimeSupport.html#OMPParallel", null ],
        [ "Parallel For", "OpenMPRuntimeSupport.html#OMPFor", null ],
        [ "Sections", "OpenMPRuntimeSupport.html#OMPSections", null ],
        [ "Single", "OpenMPRuntimeSupport.html#OMPSingle", null ]
      ] ],
      [ "Tasks", "OpenMPRuntimeSupport.html#OMPTask", [
        [ "Explicit Tasks", "OpenMPRuntimeSupport.html#OMPTaskExplicit", null ],
        [ "Data Dependencies", "OpenMPRuntimeSupport.html#OMPDataDependencies", null ],
        [ "TaskWait and TaskGroup", "OpenMPRuntimeSupport.html#OMPTaskSyncs", null ]
      ] ],
      [ "Synchronization Support", "OpenMPRuntimeSupport.html#OMPSynchronization", [
        [ "Simple Locks", "OpenMPRuntimeSupport.html#OMPSimpleLock", null ],
        [ "Nestable Locks", "OpenMPRuntimeSupport.html#OMPNestableLock", null ],
        [ "Critical Sections", "OpenMPRuntimeSupport.html#OMPCritical", null ],
        [ "Barriers", "OpenMPRuntimeSupport.html#OMPBarrier", null ]
      ] ],
      [ "Example: An OpenMP LLVM Support", "OpenMPRuntimeSupport.html#OMPLLVM", null ],
      [ "OpenMP Standard Functions in StarPU", "OpenMPRuntimeSupport.html#OMPStandard", null ]
    ] ],
    [ "------— StarPU Extensions ------—", "IntroExtensions.html", null ],
    [ "Advanced Tasks In StarPU", "AdvancedTasksInStarPU.html", [
      [ "Task Dependencies", "AdvancedTasksInStarPU.html#TaskDependencies", [
        [ "Sequential Consistency", "AdvancedTasksInStarPU.html#SequentialConsistency", null ],
        [ "Tasks And Tags Dependencies", "AdvancedTasksInStarPU.html#TasksAndTagsDependencies", null ]
      ] ],
      [ "Waiting For Tasks", "AdvancedTasksInStarPU.html#WaitingForTasks", null ],
      [ "Using Multiple Implementations Of A Codelet", "AdvancedTasksInStarPU.html#UsingMultipleImplementationsOfACodelet", null ],
      [ "Enabling Implementation According To Capabilities", "AdvancedTasksInStarPU.html#EnablingImplementationAccordingToCapabilities", null ],
      [ "Getting Task Children", "AdvancedTasksInStarPU.html#GettingTaskChildren", null ],
      [ "Parallel Tasks", "AdvancedTasksInStarPU.html#ParallelTasks", [
        [ "Fork-mode Parallel Tasks", "AdvancedTasksInStarPU.html#Fork-modeParallelTasks", null ],
        [ "SPMD-mode Parallel Tasks", "AdvancedTasksInStarPU.html#SPMD-modeParallelTasks", null ],
        [ "Parallel Tasks Performance", "AdvancedTasksInStarPU.html#ParallelTasksPerformance", null ],
        [ "Combined Workers", "AdvancedTasksInStarPU.html#CombinedWorkers", null ],
        [ "Concurrent Parallel Tasks", "AdvancedTasksInStarPU.html#ConcurrentParallelTasks", null ]
      ] ],
      [ "Synchronization Tasks", "AdvancedTasksInStarPU.html#SynchronizationTasks", null ]
    ] ],
    [ "Advanced Data Management", "AdvancedDataManagement.html", [
      [ "Data Interface with Variable Size", "AdvancedDataManagement.html#VariableSizeDataInterface", null ],
      [ "Data Management Allocation", "AdvancedDataManagement.html#DataManagementAllocation", null ],
      [ "Data Access", "AdvancedDataManagement.html#DataAccess", null ],
      [ "Data Prefetch", "AdvancedDataManagement.html#DataPrefetch", null ],
      [ "Manual Partitioning", "AdvancedDataManagement.html#ManualPartitioning", null ],
      [ "Data handles helpers", "AdvancedDataManagement.html#DataHandlesHelpers", null ],
      [ "Handles data buffer pointers", "AdvancedDataManagement.html#DataPointers", null ],
      [ "Defining A New Data Filter", "AdvancedDataManagement.html#DefiningANewDataFilter", null ],
      [ "Defining A New Data Interface", "AdvancedDataManagement.html#DefiningANewDataInterface", [
        [ "Data registration", "AdvancedDataManagement.html#DefiningANewDataInterface_registration", null ],
        [ "Data footprint", "AdvancedDataManagement.html#DefiningANewDataInterface_footprint", null ],
        [ "Data allocation", "AdvancedDataManagement.html#DefiningANewDataInterface_allocation", null ],
        [ "Data copy", "AdvancedDataManagement.html#DefiningANewDataInterface_copy", null ],
        [ "Data pack/peek/unpack", "AdvancedDataManagement.html#DefiningANewDataInterface_pack", null ],
        [ "Pointers inside the data interface", "AdvancedDataManagement.html#DefiningANewDataInterface_pointers", null ],
        [ "Helpers", "AdvancedDataManagement.html#DefiningANewDataInterface_helpers", null ]
      ] ],
      [ "The Multiformat Interface", "AdvancedDataManagement.html#TheMultiformatInterface", null ],
      [ "Specifying A Target Node For Task Data", "AdvancedDataManagement.html#SpecifyingATargetNode", null ]
    ] ],
    [ "Advanced Scheduling", "AdvancedScheduling.html", [
      [ "Energy-based Scheduling", "AdvancedScheduling.html#Energy-basedScheduling", [
        [ "Measuring energy and power with StarPU", "AdvancedScheduling.html#MeasuringEnergyandPower", null ]
      ] ],
      [ "Static Scheduling", "AdvancedScheduling.html#StaticScheduling", null ],
      [ "Configuring Heteroprio", "AdvancedScheduling.html#configuringHeteroprio", [
        [ "Using locality aware Heteroprio", "AdvancedScheduling.html#LAHeteroprio", null ],
        [ "Using Heteroprio in auto-calibration mode", "AdvancedScheduling.html#AutoHeteroprio", null ]
      ] ]
    ] ],
    [ "Scheduling Contexts", "SchedulingContexts.html", [
      [ "General Ideas", "SchedulingContexts.html#ContextGeneralIdeas", null ],
      [ "Creating A Context", "SchedulingContexts.html#CreatingAContext", [
        [ "Creating A Context With The Default Behavior", "SchedulingContexts.html#CreatingAContextWithTheDefaultBehavior", null ]
      ] ],
      [ "Creating A Context To Partition a GPU", "SchedulingContexts.html#CreatingAGPUContext", null ],
      [ "Modifying A Context", "SchedulingContexts.html#ModifyingAContext", null ],
      [ "Submitting Tasks To A Context", "SchedulingContexts.html#SubmittingTasksToAContext", null ],
      [ "Deleting A Context", "SchedulingContexts.html#DeletingAContext", null ],
      [ "Emptying A Context", "SchedulingContexts.html#EmptyingAContext", null ]
    ] ],
    [ "Scheduling Context Hypervisor", "SchedulingContextHypervisor.html", [
      [ "What Is The Hypervisor", "SchedulingContextHypervisor.html#WhatIsTheHypervisor", null ],
      [ "Start the Hypervisor", "SchedulingContextHypervisor.html#StartTheHypervisor", null ],
      [ "Interrogate The Runtime", "SchedulingContextHypervisor.html#InterrogateTheRuntime", null ],
      [ "Trigger the Hypervisor", "SchedulingContextHypervisor.html#TriggerTheHypervisor", null ],
      [ "Resizing Strategies", "SchedulingContextHypervisor.html#ResizingStrategies", null ],
      [ "Defining A New Hypervisor Policy", "SchedulingContextHypervisor.html#DefiningANewHypervisorPolicy", null ]
    ] ],
    [ "How To Define A New Scheduling Policy", "HowToDefineANewSchedulingPolicy.html", [
      [ "Introduction", "HowToDefineANewSchedulingPolicy.html#NewSchedulingPolicy_Introduction", null ],
      [ "Helper functions for defining a scheduling policy (Basic or modular)", "HowToDefineANewSchedulingPolicy.html#SchedulingHelpers", null ],
      [ "Defining A New Basic Scheduling Policy", "HowToDefineANewSchedulingPolicy.html#DefiningANewBasicSchedulingPolicy", null ],
      [ "Defining A New Modular Scheduling Policy", "HowToDefineANewSchedulingPolicy.html#DefiningANewModularSchedulingPolicy", [
        [ "Interface", "HowToDefineANewSchedulingPolicy.html#Interface", null ],
        [ "Building a Modularized Scheduler", "HowToDefineANewSchedulingPolicy.html#BuildAModularizedScheduler", [
          [ "Pre-implemented Components", "HowToDefineANewSchedulingPolicy.html#PreImplementedComponents", null ],
          [ "Progression And Validation Rules", "HowToDefineANewSchedulingPolicy.html#ProgressionAndValidationRules", null ],
          [ "Locking in modularized schedulers", "HowToDefineANewSchedulingPolicy.html#ModularizedSchedulerLocking", null ],
          [ "Implementing a Modularized Scheduler", "HowToDefineANewSchedulingPolicy.html#ImplementAModularizedScheduler", null ]
        ] ],
        [ "Management of parallel task", "HowToDefineANewSchedulingPolicy.html#ModularizedSchedulersAndParallelTasks", null ],
        [ "Writing a Scheduling Component", "HowToDefineANewSchedulingPolicy.html#WriteASchedulingComponent", [
          [ "Generic Scheduling Component", "HowToDefineANewSchedulingPolicy.html#GenericSchedulingComponent", null ],
          [ "Instantiation : Redefining the Interface", "HowToDefineANewSchedulingPolicy.html#InstantiationRedefineInterface", null ],
          [ "Detailed Progression and Validation Rules", "HowToDefineANewSchedulingPolicy.html#DetailedProgressionAndValidationRules", null ]
        ] ]
      ] ],
      [ "Using a New Scheduling Policy", "HowToDefineANewSchedulingPolicy.html#UsingaNewSchedulingPolicy", null ],
      [ "Graph-based Scheduling", "HowToDefineANewSchedulingPolicy.html#GraphScheduling", null ],
      [ "Debugging Scheduling", "HowToDefineANewSchedulingPolicy.html#DebuggingScheduling", null ]
    ] ],
    [ "CUDA Support", "CUDASupport.html", null ],
    [ "OpenCL Support", "OpenCLSupport.html", null ],
    [ "Maxeler FPGA Support", "MaxFPGASupport.html", [
      [ "Introduction", "MaxFPGASupport.html#Introduction", null ],
      [ "Porting Applications to Maxeler FPGA", "MaxFPGASupport.html#PortingApplicationsToMaxFPGA", [
        [ "StarPU/Maxeler FPGA Application", "MaxFPGASupport.html#MaxFPGAExample", null ],
        [ "Data Transfers in StarPU/Maxeler FPGA Applications", "MaxFPGASupport.html#MaxFPGADataTransfers", null ],
        [ "Maxeler FPGA Configuration", "MaxFPGASupport.html#MaxFPGAConfiguration", null ],
        [ "Launching Programs: Simulation", "MaxFPGASupport.html#MaxFPGALaunchingprograms", null ]
      ] ]
    ] ],
    [ "Out Of Core", "OutOfCore.html", [
      [ "Introduction", "OutOfCore.html#OutOfCore_Introduction", null ],
      [ "Use a new disk memory", "OutOfCore.html#UseANewDiskMemory", null ],
      [ "Data Registration", "OutOfCore.html#OOCDataRegistration", null ],
      [ "Using Wont Use", "OutOfCore.html#OOCWontUse", null ],
      [ "Examples: disk_copy", "OutOfCore.html#ExampleDiskCopy", null ],
      [ "Examples: disk_compute", "OutOfCore.html#ExampleDiskCompute", null ],
      [ "Performances", "OutOfCore.html#Performances", null ],
      [ "Feedback Figures", "OutOfCore.html#FeedBackFigures", null ],
      [ "Disk functions", "OutOfCore.html#DiskFunctions", null ]
    ] ],
    [ "MPI Support", "MPISupport.html", [
      [ "Building with MPI support", "MPISupport.html#MPIBuild", null ],
      [ "Example Used In This Documentation", "MPISupport.html#ExampleDocumentation", null ],
      [ "About Not Using The MPI Support", "MPISupport.html#NotUsingMPISupport", null ],
      [ "Simple Example", "MPISupport.html#SimpleExample", null ],
      [ "How to Initialize StarPU-MPI", "MPISupport.html#MPIInitialization", null ],
      [ "Point To Point Communication", "MPISupport.html#PointToPointCommunication", null ],
      [ "Exchanging User Defined Data Interface", "MPISupport.html#ExchangingUserDefinedDataInterface", null ],
      [ "MPI Insert Task Utility", "MPISupport.html#MPIInsertTaskUtility", null ],
      [ "Other MPI Utility Functions", "MPISupport.html#MPITaskUtility", null ],
      [ "Pruning MPI Task Insertion", "MPISupport.html#MPIInsertPruning", null ],
      [ "Temporary Data", "MPISupport.html#MPITemporaryData", null ],
      [ "Per-node Data", "MPISupport.html#MPIPerNodeData", null ],
      [ "Inter-node reduction", "MPISupport.html#MPIMpiRedux", null ],
      [ "Priorities", "MPISupport.html#MPIPriorities", null ],
      [ "MPI Cache Support", "MPISupport.html#MPICache", null ],
      [ "MPI Data Migration", "MPISupport.html#MPIMigration", null ],
      [ "MPI Collective Operations", "MPISupport.html#MPICollective", null ],
      [ "Make StarPU-MPI Progression Thread Execute Tasks", "MPISupport.html#MPIDriver", null ],
      [ "Debugging MPI", "MPISupport.html#MPIDebug", null ],
      [ "More MPI examples", "MPISupport.html#MPIExamples", null ],
      [ "Using the NewMadeleine communication library", "MPISupport.html#Nmad", null ],
      [ "MPI Master Slave Support", "MPISupport.html#MPIMasterSlave", null ],
      [ "MPI Checkpoint Support", "MPISupport.html#MPICheckpoint", null ]
    ] ],
    [ "TCP/IP Support", "TCPIPSupport.html", [
      [ "TCP/IP Master Slave Support", "TCPIPSupport.html#TCPIPMasterSlave", null ]
    ] ],
    [ "Transactions", "Transactions.html", [
      [ "General Ideas", "Transactions.html#TransactionsIdeas", null ],
      [ "Usage", "Transactions.html#TransactionsUsage", [
        [ "Epoch Cancellation", "Transactions.html#TransactionsEpochCancel", null ],
        [ "Transactions Enabled Codelets", "Transactions.html#TransactionsCodelets", null ],
        [ "Transaction Creation", "Transactions.html#TransactionsCreation", null ],
        [ "Transaction Tasks", "Transactions.html#TransactionsTasks", null ],
        [ "Epoch Transition", "Transactions.html#TransactionsEpochNext", null ],
        [ "Transaction Closing", "Transactions.html#TransactionsClosing", null ]
      ] ],
      [ "Known limitations", "Transactions.html#TransactionsLimitations", null ]
    ] ],
    [ "Fault Tolerance", "FaultTolerance.html", [
      [ "Introduction", "FaultTolerance.html#FaultTolerance_Introduction", null ],
      [ "Retrying tasks", "FaultTolerance.html#TaskRetry", null ]
    ] ],
    [ "FFT Support", "FFTSupport.html", [
      [ "Compilation", "FFTSupport.html#FFTCompilation", null ]
    ] ],
    [ "SOCL OpenCL Extensions", "SOCLOpenclExtensions.html", null ],
    [ "Hierarchical DAGS", "HierarchicalDAGS.html", [
      [ "An Example", "HierarchicalDAGS.html#BubblesExamples", [
        [ "Initial Version", "HierarchicalDAGS.html#BubblesInitialVersion", null ],
        [ "Bubble Version", "HierarchicalDAGS.html#BubblesBubbleVersion", null ]
      ] ]
    ] ],
    [ "Creating Parallel Workers On A Machine", "ParallelWorker.html", [
      [ "General Ideas", "ParallelWorker.html#ParallelWorkerGeneralIdeas", null ],
      [ "Workers Creating Parallel Workers", "ParallelWorker.html#CreatingParallel", null ],
      [ "Example Of Constraining OpenMP", "ParallelWorker.html#ExampleOfConstrainingOpenMP", null ],
      [ "Creating Custom Parallel Workers", "ParallelWorker.html#CreatingCustomParallelWorkers", null ],
      [ "Parallel Workers With Scheduling", "ParallelWorker.html#ParallelWorkersWithSchedulingContextsAPI", null ]
    ] ],
    [ "Interoperability Support", "InteroperabilitySupport.html", [
      [ "StarPU Resource Management", "InteroperabilitySupport.html#ResourceManagement", [
        [ "Linking a program with the starpurm module", "InteroperabilitySupport.html#Build", null ],
        [ "Initialization and Shutdown", "InteroperabilitySupport.html#InitExit", null ],
        [ "Default Context", "InteroperabilitySupport.html#DefCTX", null ],
        [ "Temporary Contexts", "InteroperabilitySupport.html#TmpCTXS", null ]
      ] ]
    ] ],
    [ "SimGrid Support", "SimGridSupport.html", [
      [ "Preparing Your Application For Simulation", "SimGridSupport.html#Preparing", null ],
      [ "Calibration", "SimGridSupport.html#Calibration", null ],
      [ "Simulation", "SimGridSupport.html#Simulation", null ],
      [ "Simulation On Another Machine", "SimGridSupport.html#SimulationOnAnotherMachine", null ],
      [ "Simulation Examples", "SimGridSupport.html#SimulationExamples", null ],
      [ "Simulations On Fake Machines", "SimGridSupport.html#FakeSimulations", null ],
      [ "Tweaking Simulation", "SimGridSupport.html#TweakingSimulation", null ],
      [ "MPI Applications", "SimGridSupport.html#SimulationMPIApplications", null ],
      [ "Debugging Applications", "SimGridSupport.html#SimulationDebuggingApplications", null ],
      [ "Memory Usage", "SimGridSupport.html#SimulationMemoryUsage", null ]
    ] ],
    [ "Debugging Tools", "DebuggingTools.html", [
      [ "TroubleShooting In General", "DebuggingTools.html#DebuggingInGeneral", null ],
      [ "Using The Gdb Debugger", "DebuggingTools.html#UsingGdb", null ],
      [ "Using Other Debugging Tools", "DebuggingTools.html#UsingOtherDebugger", null ],
      [ "Watchdog Support", "DebuggingTools.html#WatchdogSupport", null ],
      [ "Using The Temanejo Task Debugger", "DebuggingTools.html#UsingTheTemanejoTaskDebugger", null ]
    ] ],
    [ "Helpers", "Helpers.html", null ],
    [ "The GNU Free Documentation License", "GNUFreeDocumentationLicense.html", [
      [ "ADDENDUM: How to use this License for your documents", "GNUFreeDocumentationLicense.html#ADDENDUM", null ]
    ] ],
    [ "", "Files.html", null ],
    [ "Deprecated List", "deprecated.html", null ],
    [ "Modules", "modules.html", "modules" ],
    [ "Namespaces", "namespaces.html", [
      [ "Namespace List", "namespaces.html", "namespaces_dup" ]
    ] ],
    [ "Data Structures", "annotated.html", [
      [ "Data Structures", "annotated.html", "annotated_dup" ],
      [ "Data Structure Index", "classes.html", null ],
      [ "Data Fields", "functions.html", [
        [ "All", "functions.html", "functions_dup" ],
        [ "Variables", "functions_vars.html", "functions_vars" ]
      ] ]
    ] ],
    [ "Files", "files.html", [
      [ "File List", "files.html", "files_dup" ],
      [ "Globals", "globals.html", [
        [ "All", "globals.html", "globals_dup" ],
        [ "Functions", "globals_func.html", "globals_func" ],
        [ "Variables", "globals_vars.html", null ],
        [ "Typedefs", "globals_type.html", null ],
        [ "Enumerations", "globals_enum.html", null ],
        [ "Enumerator", "globals_eval.html", null ],
        [ "Macros", "globals_defs.html", "globals_defs" ]
      ] ]
    ] ]
  ] ]
];

var NAVTREEINDEX =
[
"AdvancedDataManagement.html",
"NativeFortranSupport.html#NFImplementation",
"functions_vars.html",
"group__API__Codelet__And__Tasks.html#ga95fcc50dde65c79b011c1269fc926dd8",
"group__API__Data__Interfaces.html#ga487b41c917f6317221d85ab626afd353",
"group__API__Data__Management.html#gga1fb3a1ff8622747d653d1b5f41bc41dbaab55b4cef9cfedeacae7012cd52e5389",
"group__API__Initialization__and__Termination.html#ga8372a8e258ff7e39b313e8c0992905b3",
"group__API__MPI__Support.html#gacb05635d95f946f099a1772c8bd59c8b",
"group__API__OpenMP__Runtime__Support.html#ga478c43dbbdd549ebe481610fd42e1b92",
"group__API__Perf__Steering.html#ggaa8f9f7eab09618e42e51577cd0b51486aa15e67713b78b1310fc9bdd20eb6120c",
"group__API__SC__Hypervisor.html#gae897baba953584f77fda8c65ae7b25d1",
"group__API__Theoretical__Lower__Bound__on__Execution__Time.html#ga284f3571becb60b2354cc1ce121e4778",
"interfacefstarpu__mod_1_1fstarpu__block__get__ldz.html",
"interfacefstarpu__mod_1_1fstarpu__insert__task.html",
"interfacefstarpu__mod_1_1fstarpu__tensor__get__ptr.html",
"starpu__driver_8h_source.html"
];

var SYNCONMSG = 'click to disable panel synchronisation';
var SYNCOFFMSG = 'click to enable panel synchronisation';