! Module to contain all the Gauss-Fermi quadrature points
! It has been created by an automatic script created by:
! Nick Papior Andersen, 2013, nickpapior@gmail.com
! If you ever need to use this please contact the author for approval

! We have employed the Stieltjes and moment algorithm together with the Golub-Welsch
! for an efficient and fairly accurate stability of the orthogonal polynomials.

module m_gauss_fermi_20

  implicit none

  integer, parameter :: p = selected_real_kind(14,300)

  integer, parameter :: G_NF_MIN_N  =  2
  integer, parameter :: G_NF_MAX_N  = 17
  integer, parameter :: G_NF_MIN_kT = -20
  integer, parameter :: G_NF_MAX_kT = 5
  
  private
  public :: G_NF_MIN_N
  public :: G_NF_MAX_N
  public :: G_NF_MIN_kT
  public :: G_NF_MAX_kT
  public :: GaussFermi_20
  
contains

  ! Die routine for the Gauss-Fermi routines
  subroutine GD(NkT)
    integer, intent(in) :: NkT
    write(*,*) 'Error in Gauss-Fermi ',NkT
    call die('Error in number of points for Gauss-Fermi, see output.')
  end subroutine GD
  
  subroutine GaussFermi_20(NkT,N,x,w)
    integer, intent(in) :: NkT, N
    real(p), intent(out) :: x(N), w(N)
    
    if ( NkT == -20 ) then
       call GF_m20(N,x,w)
    else if ( NkT == -19 ) then
       call GF_m19(N,x,w)
    else if ( NkT == -18 ) then
       call GF_m18(N,x,w)
    else if ( NkT == -17 ) then
       call GF_m17(N,x,w)
    else if ( NkT == -16 ) then
       call GF_m16(N,x,w)
    else if ( NkT == -15 ) then
       call GF_m15(N,x,w)
    else if ( NkT == -14 ) then
       call GF_m14(N,x,w)
    else if ( NkT == -13 ) then
       call GF_m13(N,x,w)
    else if ( NkT == -12 ) then
       call GF_m12(N,x,w)
    else if ( NkT == -11 ) then
       call GF_m11(N,x,w)
    else if ( NkT == -10 ) then
       call GF_m10(N,x,w)
    else if ( NkT == -9 ) then
       call GF_m9(N,x,w)
    else if ( NkT == -8 ) then
       call GF_m8(N,x,w)
    else if ( NkT == -7 ) then
       call GF_m7(N,x,w)
    else if ( NkT == -6 ) then
       call GF_m6(N,x,w)
    else if ( NkT == -5 ) then
       call GF_m5(N,x,w)
    else if ( NkT == -4 ) then
       call GF_m4(N,x,w)
    else if ( NkT == -3 ) then
       call GF_m3(N,x,w)
    else if ( NkT == -2 ) then
       call GF_m2(N,x,w)
    else if ( NkT == -1 ) then
       call GF_m1(N,x,w)
    else if ( NkT == 0 ) then
       call GF_0(N,x,w)
    else if ( NkT == 1 ) then
       call GF_1(N,x,w)
    else if ( NkT == 2 ) then
       call GF_2(N,x,w)
    else if ( NkT == 3 ) then
       call GF_3(N,x,w)
    else if ( NkT == 4 ) then
       call GF_4(N,x,w)
    else if ( NkT == 5 ) then
       call GF_5(N,x,w)
    else
       call die('Could not figure out the Gauss-Fermi &
             &quadratue method you asked for.')
    end if
  end subroutine GaussFermi_20
  
  
! [-20kT;20kT]
subroutine GF_m20(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-15.59867303367737_p
w(1)=10.40132051428237_p
x(2)=-3.761795385779469_p
w(2)=9.598679485717634_p
else if(N==3)then
x(1)=-17.56069649765479_p
w(1)=6.008952930584389_p
x(2)=-9.213297065049524_p
w(2)=9.514823872000891_p
x(3)=-1.155163237984193_p
w(3)=4.476223197414720_p
else if(N==4)then
x(1)=-18.43110167936692_p
w(1)=3.928597355186571_p
x(2)=-12.55786732440998_p
w(2)=7.327544557337053_p
x(3)=-5.008594179087197_p
w(3)=7.006530491869156_p
x(4)=6.702889517635314e-1_p
w(4)=1.737327595607220_p
else if(N==5)then
x(1)=-18.89088523902874_p
w(1)=2.799945406006051_p
x(2)=-14.55275916855889_p
w(2)=5.634773940632636_p
x(3)=-8.251981910573264_p
w(3)=6.589982822650146_p
x(4)=-2.226852888248768_p
w(4)=4.558890064718732_p
x(5)=2.575086458230640_p
w(5)=4.164077659924346e-1_p
else if(N==6)then
x(1)=-19.16421809399776_p
w(1)=2.119708998819026_p
x(2)=-15.813154919631_p
w(2)=4.448839076316927_p
x(3)=-10.62463314047906_p
w(3)=5.710492872456068_p
x(4)=-4.896134716540399_p
w(4)=5.411434506713876_p
x(5)=-2.111506022327539e-1_p
w(5)=2.255795335111716_p
x(6)=4.857651401000771_p
w(6)=5.372921058238753e-2_p
else if(N==7)then
x(1)=-19.34117653243938_p
w(1)=1.675745259326253_p
x(2)=-16.65857538058366_p
w(2)=3.609041664042510_p
x(3)=-12.34272737777965_p
w(3)=4.887018206312804_p
x(4)=-7.200485581932322_p
w(4)=5.212243668820300_p
x(5)=-2.338187925567373_p
w(5)=3.913546863649269_p
x(6)=1.639490888554141_p
w(6)=6.979109288836742e-1_p
x(7)=7.459745620549046_p
w(7)=4.493408965188188e-3_p
else if(N==8)then
x(1)=-19.46373593508086_p
w(1)=1.366650744142428_p
x(2)=-17.25758429043355_p
w(2)=2.994121071031107_p
x(3)=-13.61824082670469_p
w(3)=4.195410548256462_p
x(4)=-9.076356604739374_p
w(4)=4.767822884966940_p
x(5)=-4.360942100953520_p
w(5)=4.437853079622878_p
x(6)=-3.646875121392799e-1_p
w(6)=2.117028768924127_p
x(7)=3.700494013037138_p
w(7)=1.208004255897069e-1_p
x(8)=10.19247913497534_p
w(8)=3.124774663519425e-4_p
else if(N==9)then
x(1)=-19.55355098681389_p
w(1)=1.139313416501413_p
x(2)=-17.70352827165166_p
w(2)=2.526166029369919_p
x(3)=-14.59807507414011_p
w(3)=3.623752666522090_p
x(4)=-10.60052119648688_p
w(4)=4.288242233271245_p
x(5)=-6.210974714697989_p
w(5)=4.371776126062535_p
x(6)=-2.103962132623514_p
w(6)=3.304197271332130_p
x(7)=1.393833039994892_p
w(7)=7.320054847513291e-1_p
x(8)=5.944060589851464_p
w(8)=1.452316520017411e-2_p
x(9)=12.78248521575057_p
w(9)=2.360698916383701e-5_p
else if(N==10)then
x(1)=-19.62225901080295_p
w(1)=9.649412333230646e-1_p
x(2)=-18.04859963327016_p
w(2)=2.158384633242793_p
x(3)=-15.37339372519317_p
w(3)=3.149010208466617_p
x(4)=-11.85310485183662_p
w(4)=3.832410254716738_p
x(5)=-7.842658325687960_p
w(5)=4.110740108222656_p
x(6)=-3.809955532577848_p
w(6)=3.759030691877248_p
x(7)=-3.183195284433635e-1_p
w(7)=1.864396083853086_p
x(8)=3.216748483912065_p
w(8)=1.594364089099684e-1_p
x(9)=8.164681405241929_p
w(9)=1.647831097582594e-3_p
x(10)=14.92775308335847_p
w(10)=2.546290244773960e-6_p
else if(N==11)then
x(1)=-19.67630599693755_p
w(1)=8.275061946149956e-1_p
x(2)=-18.32236152188141_p
w(2)=1.863266686564533_p
x(3)=-15.99866347522886_p
w(3)=2.753010387715556_p
x(4)=-12.89084131886601_p
w(4)=3.419509488028388_p
x(5)=-9.257300085081985_p
w(5)=3.792350904913853_p
x(6)=-5.431503341817039_p
w(6)=3.767500186338983_p
x(7)=-1.866842172510273_p
w(7)=2.832426902987297_p
x(8)=1.267798298977151_p
w(8)=7.171819904384925e-1_p
x(9)=5.100171517511978_p
w(9)=2.703374801227246e-2_p
x(10)=10.2026695692584_p
w(10)=2.130613267095731e-4_p
x(11)=16.48980254502072_p
w(11)=4.490589190352702e-7_p
else if(N==12)then
x(1)=-19.71961055704474_p
w(1)=7.172226265673938e-1_p
x(2)=-18.54313410283905_p
w(2)=1.623233335970129_p
x(3)=-16.50916213807616_p
w(3)=2.421695526564775_p
x(4)=-13.75503317462824_p
w(4)=3.054469429598229_p
x(5)=-10.472950664936_p
w(5)=3.468900794763556_p
x(6)=-6.908592754751589_p
w(6)=3.603785258117362_p
x(7)=-3.385346330848689_p
w(7)=3.252188329524811_p
x(8)=-2.773353803050196e-1_p
w(8)=1.662336491179974_p
x(9)=2.863332822526781_p
w(9)=1.916829927384610e-1_p
x(10)=6.934757834434397_p
w(10)=4.450677278151888e-3_p
x(11)=11.97571349442136_p
w(11)=3.441306792871580e-5_p
x(12)=17.53922690315489_p
w(12)=1.246292276411197e-7_p
else if(N==13)then
x(1)=-19.75481621705047_p
w(1)=6.274600814751272e-1_p
x(2)=-18.72352001204363_p
w(2)=1.425822209448764_p
x(3)=-16.93024780075465_p
w(3)=2.143362791643910_p
x(4)=-14.47861270099725_p
w(4)=2.735577898839480_p
x(5)=-11.51429606297446_p
w(5)=3.162167552195970_p
x(6)=-8.222928243289612_p
w(6)=3.381210527878477_p
x(7)=-4.839580903066797_p
w(7)=3.304419766887340_p
x(8)=-1.685218130775579_p
w(8)=2.474569429473660_p
x(9)=1.156214330619049_p
w(9)=7.026560670055685e-1_p
x(10)=4.484009452979002_p
w(10)=4.194623407220074e-2_p
x(11)=8.640858167532080_p
w(11)=8.002136805098544e-4_p
x(12)=13.45816027397486_p
w(12)=7.178751895219697e-6_p
x(13)=18.22588935512556_p
w(13)=4.864709766647128e-8_p
else if(N==14)then
x(1)=-19.78380647569621_p
w(1)=5.534766165060695e-1_p
x(2)=-18.87264963463487_p
w(2)=1.261777810343188_p
x(3)=-17.28097134228053_p
w(3)=1.908253861178637_p
x(4)=-15.08831348217869_p
w(4)=2.458308394707868_p
x(5)=-12.40696544061302_p
w(5)=2.880557308710050_p
x(6)=-9.379968573836699_p
w(6)=3.143969835800046_p
x(7)=-6.184375486734386_p
w(7)=3.202229762825877_p
x(8)=-3.055532966607127_p
w(8)=2.859557459572191_p
x(9)=-2.500202885944745e-1_p
w(9)=1.503090639118121_p
x(10)=2.580176575682321_p
w(10)=2.197387290491946e-1_p
x(11)=6.064715169487112_p
w(11)=8.871663420433752e-3_p
x(12)=10.17641333376771_p
w(12)=1.659677849552954e-4_p
x(13)=14.66227573332085_p
w(13)=1.926953382507272e-6_p
x(14)=18.67938119589457_p
w(14)=2.402998469081621e-8_p
else if(N==15)then
x(1)=-19.80795489864422_p
w(1)=4.918039126435061e-1_p
x(2)=-18.99726856484434_p
w(2)=1.124132751537360_p
x(3)=-17.57579932382172_p
w(3)=1.708416622407423_p
x(4)=-15.60556594881437_p
w(4)=2.217376973850220_p
x(5)=-13.17442993644958_p
w(5)=2.626218454748595_p
x(6)=-10.39441935670572_p
w(6)=2.911000718421491_p
x(7)=-7.402582723292077_p
w(7)=3.042478585805467_p
x(8)=-4.372460737944334_p
w(8)=2.938338861243308_p
x(9)=-1.539463113671009_p
w(9)=2.193551070268916_p
x(10)=1.060280043773983_p
w(10)=6.866741118414242e-1_p
x(11)=4.012187332947213_p
w(11)=5.797856427063726e-2_p
x(12)=7.552206230248563_p
w(12)=1.988095009716674e-3_p
x(13)=11.52534421329753_p
w(13)=4.061529563609457e-5_p
x(14)=15.62240114565031_p
w(14)=6.487340790564656e-7_p
x(15)=18.98672961672772_p
w(15)=1.392222042146725e-8_p
else if(N==16)then
x(1)=-19.82827900479504_p
w(1)=4.398667677240725e-1_p
x(2)=-19.10242464772059_p
w(2)=1.007598473720464_p
x(3)=-17.8257852723432_p
w(3)=1.537466148737668_p
x(4)=-16.04739379034064_p
w(4)=2.007680622347150_p
x(5)=-13.83693177814241_p
w(5)=2.398404424941340_p
x(6)=-11.28337326138337_p
w(6)=2.690695769369126_p
x(7)=-8.494938754698270_p
w(7)=2.863792707500883_p
x(8)=-5.604121904034713_p
w(8)=2.877677129386221_p
x(9)=-2.788840384040310_p
w(9)=2.546224071576382_p
x(10)=-2.288592743241292e-1_p
w(10)=1.372419918354849_p
x(11)=2.350552768676034_p
w(11)=2.429419738890086e-1_p
x(12)=5.410400382446161_p
w(12)=1.472726149479599e-2_p
x(13)=8.917335784287886_p
w(13)=4.926911689424368e-4_p
x(14)=12.68931607184307_p
w(14)=1.176626834621012e-5_p
x(15)=16.38114004299875_p
w(15)=2.645215848782107e-7_p
x(16)=19.20154202005743_p
w(16)=8.999165747611671e-9_p
else if(N==17)then
x(1)=-19.8455438343348_p
w(1)=3.957254109791287e-1_p
x(2)=-19.19194383837665_p
w(2)=9.081218063009984e-1_p
x(3)=-18.03944437364895_p
w(3)=1.390300618434493_p
x(4)=-16.42729865734709_p
w(4)=1.824650215780263_p
x(5)=-14.41144623947854_p
w(5)=2.195120669767669_p
x(6)=-12.0634272340407_p
w(6)=2.486460411430269_p
x(7)=-9.470026606329778_p
w(7)=2.682907248403787_p
x(8)=-6.735412131435421_p
w(8)=2.761227326311980_p
x(9)=-3.992505511340659_p
w(9)=2.641440292862853_p
x(10)=-1.418303819849203_p
w(10)=1.966808475321028_p
x(11)=9.786419035501960e-1_p
w(11)=6.691052182257944e-1_p
x(12)=3.638371794644828_p
w(12)=7.410405945477683e-2_p
x(13)=6.737023298321497_p
w(13)=3.886606383767130e-3_p
x(14)=10.14802055581822_p
w(14)=1.375073459498128e-4_p
x(15)=13.68127968581017_p
w(15)=4.000635089264158e-6_p
x(16)=16.97988007039039_p
w(16)=1.260785911514548e-7_p
x(17)=19.35628187540244_p
w(17)=6.283565069820510e-9_p
else
call GD(-20)
end if
end subroutine GF_m20

! [-19kT;20kT]
subroutine GF_m19(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-14.80201384845804_p
w(1)=9.919647996235318_p
x(2)=-3.526768461246872_p
w(2)=9.080352007306324_p
else if(N==3)then
x(1)=-16.66602199863151_p
w(1)=5.749159197033382_p
x(2)=-8.682924739485763_p
w(2)=9.091369467809750_p
x(3)=-9.856482315685142e-1_p
w(3)=4.159471338698511_p
else if(N==4)then
x(1)=-17.4942801236706_p
w(1)=3.770220679451346_p
x(2)=-11.85931926275119_p
w(2)=7.027549034695458_p
x(3)=-4.631482768578961_p
w(3)=6.664640438383952_p
x(4)=8.528578614548181e-1_p
w(4)=1.537589851010888_p
else if(N==5)then
x(1)=-17.93261128685109_p
w(1)=2.694496539429023_p
x(2)=-13.75876211336014_p
w(2)=5.419917743505448_p
x(3)=-7.703396020921679_p
w(3)=6.322792930507849_p
x(4)=-1.942353929345299_p
w(4)=4.225704668799712_p
x(5)=2.819570858037820_p
w(5)=3.370881212996102e-1_p
else if(N==6)then
x(1)=-18.19371751424358_p
w(1)=2.044814730368659_p
x(2)=-14.96165831685473_p
w(2)=4.289905009510115_p
x(3)=-9.961346079559677_p
w(3)=5.498735511382058_p
x(4)=-4.458945394275677_p
w(4)=5.154247702926374_p
x(5)=4.234417167382091e-2_p
w(5)=1.972563911969954_p
x(6)=5.174480602893378_p
w(6)=3.973313738448372e-2_p
else if(N==7)then
x(1)=-18.363161114445_p
w(1)=1.619770865618262_p
x(2)=-15.77058865440059_p
w(2)=3.487276757499290_p
x(3)=-11.60215917343925_p
w(3)=4.717423012097536_p
x(4)=-6.645265880960495_p
w(4)=5.010290351875943_p
x(5)=-1.990276753698328_p
w(5)=3.608074245483305_p
x(6)=1.929576306174160_p
w(6)=5.540410096106411e-1_p
x(7)=7.830510899424055_p
w(7)=3.123761356666993e-3_p
else if(N==8)then
x(1)=-18.48087879337144_p
w(1)=1.322923047492224_p
x(2)=-16.34561331880095_p
w(2)=2.897470348234238_p
x(3)=-12.82494832144549_p
w(3)=4.056908015341740_p
x(4)=-8.436921682735784_p
w(4)=4.599964256326818_p
x(5)=-3.901979784271001_p
w(5)=4.215566121626455_p
x(6)=-6.185882238628133e-2_p
w(6)=1.819719028941604_p
x(7)=4.048720977480168_p
w(7)=8.723802865554871e-2_p
x(8)=10.58530827051269_p
w(8)=2.111569230149148e-4_p
else if(N==9)then
x(1)=-18.56743579782043_p
w(1)=1.103852207435257_p
x(2)=-16.7752027559799_p
w(2)=2.446947880725858_p
x(3)=-13.76793910616725_p
w(3)=3.508071593602397_p
x(4)=-9.900390891306841_p
w(4)=4.145305650721084_p
x(5)=-5.664956155225952_p
w(5)=4.199928128132266_p
x(6)=-1.731464467461535_p
w(6)=3.015372670238304_p
x(7)=1.713730041538123_p
w(7)=5.704990900491569e-1_p
x(8)=6.323138596563636_p
w(8)=1.000658147151100e-2_p
x(9)=13.14890209281749_p
w(9)=1.620116580793973e-5_p
else if(N==10)then
x(1)=-18.63380771560105_p
w(1)=9.354204439720168e-1_p
x(2)=-17.10843636920994_p
w(2)=2.091941891769819_p
x(3)=-14.51612849664529_p
w(3)=3.050696550032293_p
x(4)=-11.10726731550789_p
w(4)=3.709011429358677_p
x(5)=-7.230300343484985_p
w(5)=3.966164568635892_p
x(6)=-3.352453416665540_p
w(6)=3.552154368525843_p
x(7)=8.103376818082604e-3_p
w(7)=1.578983836254324_p
x(8)=3.572641127037177_p
w(8)=1.144979525364054e-1_p
x(9)=8.541877178465629_p
w(9)=1.127117971338030e-3_p
x(10)=15.22462053574003_p
w(10)=1.844485033521796e-6_p
else if(N==11)then
x(1)=-18.68607577901969_p
w(1)=8.025164193048255e-1_p
x(2)=-17.37312078615918_p
w(2)=1.806709268124689_p
x(3)=-15.12033278600543_p
w(3)=2.668500039718618_p
x(4)=-12.10891811278915_p
w(4)=3.312098795665081_p
x(5)=-8.592115387366100_p
w(5)=3.666537240127904_p
x(6)=-4.900943337791249_p
w(6)=3.612091351570148_p
x(7)=-1.485490918703625_p
w(7)=2.559017302614015_p
x(8)=1.601850367888142_p
w(8)=5.536624915556801e-1_p
x(9)=5.472917378641752_p
w(9)=1.871853953423547e-2_p
x(10)=10.55525658591977_p
w(10)=1.482078060501073e-4_p
x(11)=16.70658143638395_p
w(11)=3.475203963319713e-7_p
else if(N==12)then
x(1)=-18.72797838185096_p
w(1)=6.958081373302561e-1_p
x(2)=-17.5867017988744_p
w(2)=1.574560335502396_p
x(3)=-15.61398525232468_p
w(3)=2.348414159246174_p
x(4)=-12.94388416215761_p
w(4)=2.960387504858416_p
x(5)=-9.764554161300262_p
w(5)=3.357978629835649_p
x(6)=-6.318592976585890_p
w(6)=3.474743110700210_p
x(7)=-2.931514724539450_p
w(7)=3.055391343065140_p
x(8)=6.473960306561870e-2_p
w(8)=1.392117615204387_p
x(9)=3.222436006784204_p
w(9)=1.375097308874552e-1_p
x(10)=7.303751376208289_p
w(10)=3.064654322252919e-3_p
x(11)=12.29056569225551_p
w(11)=2.468046892367553e-5_p
x(12)=17.69040420931132_p
w(12)=1.021203819024982e-7_p
else if(N==13)then
x(1)=-18.76205892460779_p
w(1)=6.089176115244114e-1_p
x(2)=-17.76129286666446_p
w(2)=1.383535073528333_p
x(3)=-16.02139825303501_p
w(3)=2.079314248557461_p
x(4)=-13.64350714404637_p
w(4)=2.652676687908223_p
x(5)=-10.77013299413039_p
w(5)=3.063681001557017_p
x(6)=-7.583961040581398_p
w(6)=3.268593902460974_p
x(7)=-4.320334643294626_p
w(7)=3.159792661281568_p
x(8)=-1.295994795208930_p
w(8)=2.215099291922876_p
x(9)=1.501902209044498_p
w(9)=5.387409797252680e-1_p
x(10)=4.855500638362868_p
w(10)=2.908586408505619e-2_p
x(11)=8.992262363642110_p
w(11)=5.572979021234348e-4_p
x(12)=13.72985855582371_p
w(12)=5.341498243946580e-6_p
x(13)=18.33107057239099_p
w(13)=4.159008763096447e-8_p
else if(N==14)then
x(1)=-18.79013404808421_p
w(1)=5.372719076237112e-1_p
x(2)=-17.90569413212742_p
w(2)=1.224722304260031_p
x(3)=-16.36090186741823_p
w(3)=1.851859094450235_p
x(4)=-14.23339284751535_p
w(4)=2.384827392686403_p
x(5)=-11.63296221284763_p
w(5)=2.792638336911254_p
x(6)=-8.700082765989107_p
w(6)=3.043650022989376_p
x(7)=-5.610763205570302_p
w(7)=3.084372276415705_p
x(8)=-2.603187676880914_p
w(8)=2.670189659546331_p
x(9)=1.055268287841097e-1_p
w(9)=1.246864148415397_p
x(10)=2.944041846540634_p
w(10)=1.573742226456331e-1_p
x(11)=6.433011384938859_p
w(11)=6.111094863775196e-3_p
x(12)=10.50177032819762_p
w(12)=1.180329439344875e-4_p
x(13)=14.89128389263727_p
w(13)=1.488621817332951e-6_p
x(14)=18.75403804879424_p
w(14)=2.116804000774465e-8_p
else if(N==15)then
x(1)=-18.81352904312972_p
w(1)=4.775250310183406e-1_p
x(2)=-18.02641027916623_p
w(2)=1.091409343714269_p
x(3)=-16.64642659318121_p
w(3)=1.658419626467359_p
x(4)=-14.73410972859897_p
w(4)=2.151875060856004_p
x(5)=-12.37534004655433_p
w(5)=2.547353585769911_p
x(6)=-9.679979933277416_p
w(6)=2.820761472089287_p
x(7)=-6.783574915661422_p
w(7)=2.940082875682025_p
x(8)=-3.861302049668461_p
w(8)=2.800909516420139_p
x(9)=-1.142830756014551_p
w(9)=1.946520053563210_p
x(10)=1.416387598801437_p
w(10)=5.235511350947064e-1_p
x(11)=4.385341515051858_p
w(11)=4.018152498044217e-2_p
x(12)=7.906606789608047_p
w(12)=1.380599838707301e-3_p
x(13)=11.82031762793559_p
w(13)=2.964665601212826e-5_p
x(14)=15.81284626131559_p
w(14)=5.188671342212345e-7_p
x(15)=19.04121858075797_p
w(15)=1.252409584050099e-8_p
else if(N==16)then
x(1)=-18.83322587816078_p
w(1)=4.271920296371743e-1_p
x(2)=-18.12831031800561_p
w(2)=9.784987372562867e-1_p
x(3)=-16.88862204699291_p
w(3)=1.492861775246209_p
x(4)=-15.16201796334324_p
w(4)=1.948977558191611_p
x(5)=-13.01659091524818_p
w(5)=2.327341717294567_p
x(6)=-10.53951024493716_p
w(6)=2.609043037553060_p
x(7)=-7.837448133892308_p
w(7)=2.772188749315109_p
x(8)=-5.043081788077865_p
w(8)=2.767833143614354_p
x(9)=-2.336850003919267_p
w(9)=2.362699902727101_p
x(10)=1.382011669679488e-1_p
w(10)=1.129178019984671_p
x(11)=2.719646343632344_p
w(11)=1.737006455938013e-1_p
x(12)=5.780589145196516_p
w(12)=1.012792355812574e-2_p
x(13)=9.251319339028267_p
w(13)=3.477054920041496e-4_p
x(14)=12.95271337309813_p
w(14)=8.831797863204703e-6_p
x(15)=16.53870435233465_p
w(15)=2.180623457787388e-7_p
x(16)=19.24246469906012_p
w(16)=8.217359588117245e-9_p
else if(N==17)then
x(1)=-18.84996312899902_p
w(1)=3.844004137352051e-1_p
x(2)=-18.21508624799676_p
w(2)=8.820816376133804e-1_p
x(3)=-17.09569737239768_p
w(3)=1.350278135682055_p
x(4)=-15.53010805560749_p
w(4)=1.771776019598514_p
x(5)=-13.57297154979366_p
w(5)=2.130815395149653_p
x(6)=-11.29432762480858_p
w(6)=2.412248460468402_p
x(7)=-8.779526119279085_p
w(7)=2.599841502337440_p
x(8)=-6.132177582875289_p
w(8)=2.666694005154217_p
x(9)=-3.487409474150216_p
w(9)=2.508864501297054_p
x(10)=-1.014991715425673_p
w(10)=1.731081790966432_p
x(11)=1.343946792247461_p
w(11)=5.078250837382490e-1_p
x(12)=4.014310220730153_p
w(12)=5.130233784802923e-2_p
x(13)=7.095539134359087_p
w(13)=2.688469931241848e-3_p
x(14)=10.45803030626998_p
w(14)=9.905070877628298e-5_p
x(15)=13.91409806174278_p
w(15)=3.086902825925309e-6_p
x(16)=17.11035550012987_p
w(16)=1.066095469093496e-7_p
x(17)=19.38783884131601_p
w(17)=5.800621395353464e-9_p
else
call GD(-19)
end if
end subroutine GF_m19

! [-18kT;20kT]
subroutine GF_m18(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-14.00466040017455_p
w(1)=9.439548791426242_p
x(2)=-3.289241464221691_p
w(2)=8.560451221742584_p
else if(N==3)then
x(1)=-15.77083004875027_p
w(1)=5.490611546826972_p
x(2)=-8.150662088481210_p
w(2)=8.668234419175816_p
x(3)=-8.100989974466448e-1_p
w(3)=3.841154047166038_p
else if(N==4)then
x(1)=-16.55710499031385_p
w(1)=3.612712865249376_p
x(2)=-11.15927315184599_p
w(2)=6.728657739172970_p
x(3)=-4.252927412528630_p
w(3)=6.315432925443690_p
x(4)=1.047506771194953_p
w(4)=1.343196483302789_p
else if(N==5)then
x(1)=-16.97410147040976_p
w(1)=2.589632799147632_p
x(2)=-12.96370908113172_p
w(2)=5.205974808685591_p
x(3)=-7.153348998591445_p
w(3)=6.054106692453654_p
x(4)=-1.655261438900875_p
w(4)=3.882753898611219_p
x(5)=3.081791953296005_p
w(5)=2.675318142707299e-1_p
else if(N==6)then
x(1)=-17.2230645995405_p
w(1)=1.970300131408036_p
x(2)=-14.10946254515665_p
w(2)=4.131609572972544_p
x(3)=-9.296912531876515_p
w(3)=5.286848128817716_p
x(4)=-4.022049075881587_p
w(4)=4.886242233808265_p
x(5)=3.063677934107849e-1_p
w(5)=1.696188168580425_p
x(6)=5.509689781269182_p
w(6)=2.881177758184152e-2_p
else if(N==7)then
x(1)=-17.38505946419808_p
w(1)=1.564011468037103_p
x(2)=-14.88220534349225_p
w(2)=3.365875987266629_p
x(3)=-10.86092355255177_p
w(3)=4.547850597145925_p
x(4)=-6.090168290733474_p
w(4)=4.804411057222649_p
x(5)=-1.642339699806992_p
w(5)=3.286545671308521_p
x(6)=2.238344858713840_p
w(6)=4.291697570959085e-1_p
x(7)=8.217264760907447_p
w(7)=2.135475092091002e-3_p
else if(N==8)then
x(1)=-17.49798861951526_p
w(1)=1.279276776212160_p
x(2)=-15.43349904539375_p
w(2)=2.800936513081890_p
x(3)=-12.03146609522474_p
w(3)=3.918308509581146_p
x(4)=-7.797809748303476_p
w(4)=4.430500802369413_p
x(5)=-3.445831014047271_p
w(5)=3.978001229680828_p
x(6)=2.500239418891446e-1_p
w(6)=1.531158056856494_p
x(7)=4.414887051643838_p
w(7)=6.167704976993410e-2_p
x(8)=10.98819486901697_p
w(8)=1.410756169617484e-4_p
else if(N==9)then
x(1)=-17.58131811138877_p
w(1)=1.068395626044800_p
x(2)=-15.84688050436631_p
w(2)=2.367701580714540_p
x(3)=-12.93789822130904_p
w(3)=3.392197799707287_p
x(4)=-9.200783006017421_p
w(4)=4.001471196811665_p
x(5)=-5.121232932679288_p
w(5)=4.021323064663708_p
x(6)=-1.360425311255653_p
w(6)=2.709136572314975_p
x(7)=2.050792322873771_p
w(7)=4.329670983440062e-1_p
x(8)=6.714823874818757_p
w(8)=6.795994860208736e-3_p
x(9)=13.51627580179711_p
w(9)=1.107970763459367e-5_p
else if(N==10)then
x(1)=-17.64536295153109_p
w(1)=9.058818152050181e-1_p
x(2)=-16.16831743844611_p
w(2)=2.025434128081036_p
x(3)=-13.65902436210208_p
w(3)=2.952193155645364_p
x(4)=-10.36192604504332_p
w(4)=3.585032257324877_p
x(5)=-6.619519265891999_p
w(5)=3.818713707020811_p
x(6)=-2.899127031759332_p
w(6)=3.326728947750663_p
x(7)=3.429732925458923e-1_p
w(7)=1.304715840640362_p
x(8)=3.944401727577970_p
w(8)=8.053477109324279e-2_p
x(9)=8.926441263879566_p
w(9)=7.640509339632469e-4_p
x(10)=15.51567517905408_p
w(10)=1.339473489184909e-6_p
else if(N==11)then
x(1)=-17.69585228743225_p
w(1)=7.775086397012476e-1_p
x(2)=-16.42392227594055_p
w(2)=1.750093938820012_p
x(3)=-14.24214083058659_p
w(3)=2.583841134999269_p
x(4)=-11.32737777736609_p
w(4)=3.204298543831496_p
x(5)=-7.927988653831029_p
w(5)=3.539315563950425_p
x(6)=-4.373535891360794_p
w(6)=3.447408333698111_p
x(7)=-1.105257074053834_p
w(7)=2.268900546565879_p
x(8)=1.951876266490602_p
w(8)=4.157469269856267e-1_p
x(9)=5.857041085656726_p
w(9)=1.278351917482725e-2_p
x(10)=10.91096063988585_p
w(10)=1.025953028120615e-4_p
x(11)=16.91591954728042_p
w(11)=2.701391206239074e-7_p
else if(N==12)then
x(1)=-17.73635179788054_p
w(1)=6.743787594945614e-1_p
x(2)=-16.63030385288754_p
w(2)=1.525841178437612_p
x(3)=-14.71891755336776_p
w(3)=2.275020231668960_p
x(4)=-12.13302265268999_p
w(4)=2.866033352268963_p
x(5)=-9.056891278802599_p
w(5)=3.246257888747169_p
x(6)=-5.730635480429669_p
w(6)=3.341611044907277_p
x(7)=-2.481918967677833_p
w(7)=2.837912895460584_p
x(8)=4.152954140245762e-1_p
w(8)=1.134263416299464_p
x(9)=3.596565159591151_p
w(9)=9.657245613675007e-2_p
x(10)=7.680195082009480_p
w(10)=2.091037431537345e-3_p
x(11)=12.60539134090708_p
w(11)=1.766831036138296e-5_p
x(12)=17.83537193451581_p
w(12)=8.400558669955722e-8_p
else if(N==13)then
x(1)=-17.76930638437291_p
w(1)=5.903625454769478e-1_p
x(2)=-16.79909437146885_p
w(2)=1.341210170913622_p
x(3)=-15.11263707218093_p
w(3)=2.015177717055004_p
x(4)=-12.80862507845129_p
w(4)=2.569575914093538_p
x(5)=-10.02650585950604_p
w(5)=2.964686914239602_p
x(6)=-6.946352040457850_p
w(6)=3.154017859734185_p
x(7)=-3.804639931188628_p
w(7)=3.003468724782304_p
x(8)=-9.072599608295405e-1_p
w(8)=1.939947518533051_p
x(9)=1.862711305714538_p
w(9)=4.012770454021992e-1_p
x(10)=5.238086083271202_p
w(10)=1.988574107965157e-2_p
x(11)=9.347981581514881_p
w(11)=3.858510791057281e-4_p
x(12)=13.99954765475587_p
w(12)=3.975124161482706e-6_p
x(13)=18.43177962890019_p
w(13)=3.565545463780199e-8_p
else if(N==14)then
x(1)=-17.79646579730428_p
w(1)=5.210561782908528e-1_p
x(2)=-16.93876333973306_p
w(2)=1.187634843360114_p
x(3)=-15.44090638660075_p
w(3)=1.795393184401260_p
x(4)=-13.3786523414416_p
w(4)=2.311193975050039_p
x(5)=-10.85936876558005_p
w(5)=2.704369702224087_p
x(6)=-8.021152547644951_p
w(6)=2.942261025645873_p
x(7)=-5.039591493210470_p
w(7)=2.961010269734978_p
x(8)=-2.154933674430962_p
w(8)=2.458745838078632_p
x(9)=4.694840482134804e-1_p
w(9)=1.003821877356365_p
x(10)=3.322299428163277_p
w(10)=1.102585790376933e-1_p
x(11)=6.808916270051483_p
w(11)=4.169714193661222e-3_p
x(12)=10.82902596466292_p
w(12)=8.365571217878396e-5_p
x(13)=15.11732786247547_p
w(13)=1.151403563037226e-6_p
x(14)=18.82561563241946_p
w(14)=1.867952911831759e-8_p
else if(N==15)then
x(1)=-17.81910691551216_p
w(1)=4.632363523580620e-1_p
x(2)=-17.05557368810281_p
w(2)=1.058658356984690_p
x(3)=-15.71711714733197_p
w(3)=1.608363707710204_p
x(4)=-13.86280244753092_p
w(4)=2.086253055545409_p
x(5)=-11.57657430824252_p
w(5)=2.468233845279939_p
x(6)=-8.966247406121633_p
w(6)=2.729866427461728_p
x(7)=-6.166236052278245_p
w(7)=2.835022479020826_p
x(8)=-3.353978335986277_p
w(8)=2.649525595347440_p
x(9)=-7.461349083015161e-1_p
w(9)=1.685097353254745_p
x(10)=1.786798863819437_p
w(10)=3.873250304753438e-1_p
x(11)=4.769389739527885_p
w(11)=2.744321480403225e-2_p
x(12)=8.265917722731398_p
w(12)=9.525637062219661e-4_p
x(13)=12.11545275655557_p
w(13)=2.160428150224542e-5_p
x(14)=16.00009605208263_p
w(14)=4.156611036708666e-7_p
x(15)=19.09359045421573_p
w(15)=1.127757948768128e-8_p
else if(N==16)then
x(1)=-17.83817609773773_p
w(1)=4.145085260510243e-1_p
x(2)=-17.1542152000967_p
w(2)=9.493749282119189e-1_p
x(3)=-15.95151364451953_p
w(3)=1.448207767862643_p
x(4)=-14.27676750403064_p
w(4)=1.890177588893128_p
x(5)=-12.19651301800929_p
w(5)=2.256085533109700_p
x(6)=-9.796190985773723_p
w(6)=2.526950656106519_p
x(7)=-7.181145094262869_p
w(7)=2.679162966868865_p
x(8)=-4.484836068777382_p
w(8)=2.650933494465697_p
x(9)=-1.888696741373308_p
w(9)=2.156357061449907_p
x(10)=5.135246227773537e-1_p
w(10)=8.996990045860825e-1_p
x(11)=3.102547660465101_p
w(11)=1.213949172941188e-1_p
x(12)=6.158492683399166_p
w(12)=6.896416918551028e-3_p
x(13)=9.588153081176875_p
w(13)=2.443378117132375e-4_p
x(14)=13.21513646851683_p
w(14)=6.625985478875053e-6_p
x(15)=16.69324873265215_p
w(15)=1.800464443105415e-7_p
x(16)=19.28190791896192_p
w(16)=7.507036343614156e-9_p
else if(N==17)then
x(1)=-17.85438543489579_p
w(1)=3.730675491346825e-1_p
x(2)=-17.23824575701137_p
w(2)=8.560202986678050e-1_p
x(3)=-16.15199828455743_p
w(3)=1.310213303868332_p
x(4)=-14.63302440315336_p
w(4)=1.718822135876931_p
x(5)=-12.73471438481063_p
w(5)=2.066358693631068_p
x(6)=-10.52565903103024_p
w(6)=2.337722251398728_p
x(7)=-8.089907798255259_p
w(7)=2.515932329933598_p
x(8)=-5.530907977877256_p
w(8)=2.568647590975861_p
x(9)=-2.986306837894199_p
w(9)=2.360349636225330_p
x(10)=-6.111222691205194e-1_p
w(10)=1.482412926890492_p
x(11)=1.722790526105229_p
w(11)=3.735532062705291e-1_p
x(12)=4.400966153824971_p
w(12)=3.497955871184243e-2_p
x(13)=7.459332462353505_p
w(13)=1.846895254886142e-3_p
x(14)=10.76935276321363_p
w(14)=7.115827140341116e-5_p
x(15)=14.14528618554185_p
w(15)=2.382432083674649e-6_p
x(16)=17.23816157055314_p
w(16)=9.026981163383763e-8_p
x(17)=19.41833847879787_p
w(17)=5.355443397026285e-9_p
else
call GD(-18)
end if
end subroutine GF_m18

! [-17kT;20kT]
subroutine GF_m17(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-13.20653109731271_p
w(1)=8.961195778684186_p
x(2)=-3.048806166519431_p
w(2)=8.038804260654036_p
else if(N==3)then
x(1)=-14.87507742256882_p
w(1)=5.233409170562020_p
x(2)=-7.616420389914561_p
w(2)=8.245050900510764_p
x(3)=-6.275454349274373e-1_p
w(3)=3.521539968265440_p
else if(N==4)then
x(1)=-15.61955670516592_p
w(1)=3.456119324476084_p
x(2)=-10.4576773753809_p
w(2)=6.430815683741999_p
x(3)=-3.872989114645088_p
w(3)=5.957230300830478_p
x(4)=1.255948448744942_p
w(4)=1.155834730289662_p
else if(N==5)then
x(1)=-16.0153487376352_p
w(1)=2.485369979124143_p
x(2)=-12.16758606571751_p
w(2)=4.992918252059089_p
x(3)=-6.601994056445894_p
w(3)=5.783044798826847_p
x(4)=-1.364705414969166_p
w(4)=3.530846412862173_p
x(5)=3.363263353473191_p
w(5)=2.078205964659708e-1_p
else if(N==6)then
x(1)=-16.25225953210077_p
w(1)=1.896163542999327_p
x(2)=-13.25658020181107_p
w(2)=3.973918359291831_p
x(3)=-8.631451483742426_p
w(3)=5.074499541021058_p
x(4)=-3.585835256824536_p
w(4)=4.604615520069230_p
x(5)=5.831486160538371e-1_p
w(5)=1.430333753314383_p
x(6)=5.864134434169061_p
w(6)=2.046932264239474e-2_p
else if(N==7)then
x(1)=-16.40687681381489_p
w(1)=1.508453034525829_p
x(2)=-13.99345885419895_p
w(2)=3.244791533496040_p
x(3)=-10.11914451105168_p
w(3)=4.378116839400620_p
x(4)=-5.535663858068832_p
w(4)=4.592958631462726_p
x(5)=-1.293388898895921_p
w(5)=2.950438214188720_p
x(6)=2.567451978796770_p
w(6)=3.238066379012539e-1_p
x(7)=8.620245721241545_p
w(7)=1.435148363035090e-3_p
else if(N==8)then
x(1)=-16.51507243718583_p
w(1)=1.235693589255458_p
x(2)=-14.52128148745909_p
w(2)=2.704469064222922_p
x(3)=-11.23791353336787_p
w(3)=3.779483219090900_p
x(4)=-7.159371169560992_p
w(4)=4.258728607478827_p
x(5)=-2.993001924579380_p
w(5)=3.721646215755527_p
x(6)=5.736093954707906e-1_p
w(6)=1.257196773097410_p
x(7)=4.799204961397511_p
w(7)=4.268933234477660e-2_p
x(8)=11.40037155182933_p
w(8)=9.323809240148909e-5_p
else if(N==9)then
x(1)=-16.59520310025756_p
w(1)=1.032930184603446_p
x(2)=-14.91859073491239_p
w(2)=2.288390740890582_p
x(3)=-12.10803691555681_p
w(3)=3.276047120275758_p
x(4)=-8.501923301505844_p
w(4)=3.856412503050405_p
x(5)=-4.580428121323540_p
w(5)=3.833425742576692_p
x(6)=-9.893555502626445e-1_p
w(6)=2.388651727850846_p
x(7)=2.406450895295535_p
w(7)=3.195835479671480e-1_p
x(8)=7.118798913626699_p
w(8)=4.550913496503603e-3_p
x(9)=13.88323411540596_p
w(9)=7.558626841366519e-6_p
else if(N==10)then
x(1)=-16.65692779865832_p
w(1)=8.763172763921173e-1_p
x(2)=-15.22826055637836_p
w(2)=1.958838868328841_p
x(3)=-12.80213365955216_p
w(3)=2.853447614332536_p
x(4)=-9.617219251614602_p
w(4)=3.460302856211039_p
x(5)=-6.010723890185490_p
w(5)=3.667235164346748_p
x(6)=-2.450176283719860_p
w(6)=3.079358434145776_p
x(7)=6.891491983647164e-1_p
w(7)=1.048478958792928_p
x(8)=4.332022962827848_p
w(8)=5.550638609426605e-2_p
x(9)=9.317877111014061_p
w(9)=5.135047889313856e-4_p
x(10)=15.79998011100672_p
w(10)=9.759050383799111e-7_p
else if(N==11)then
x(1)=-16.70563766662886_p
w(1)=7.524772261047993e-1_p
x(2)=-15.47477839440822_p
w(2)=1.693404896089263_p
x(3)=-13.36412427920936_p
w(3)=2.498997492986762_p
x(4)=-10.546314289588_p
w(4)=3.096007432384940_p
x(5)=-7.265181117540489_p
w(5)=3.410163714870527_p
x(6)=-3.849890524808325_p
w(6)=3.270109251853740_p
x(7)=-7.242038128529581e-1_p
w(7)=1.966743964927957_p
x(8)=2.319213927341493_p
w(8)=3.034106826627969e-1_p
x(9)=6.252230626868759_p
w(9)=8.614459120520833e-3_p
x(10)=11.26922603879962_p
w(10)=7.070736048874171e-5_p
x(11)=17.11751957976531_p
w(11)=2.109764270252051e-7_p
else if(N==12)then
x(1)=-16.74473257109337_p
w(1)=6.529298670391044e-1_p
x(2)=-15.67395037411845_p
w(2)=1.477063148144858_p
x(3)=-13.82398824248335_p
w(3)=2.201486057076816_p
x(4)=-11.32251981132641_p
w(4)=2.771339109809992_p
x(5)=-8.350141652146320_p
w(5)=3.133474191100291_p
x(6)=-5.145210246069122_p
w(6)=3.202650086745709_p
x(7)=-2.036457888495347_p
w(7)=2.596875535153390_p
x(8)=7.772253842157985e-1_p
w(8)=8.963093655906584e-1_p
x(9)=3.985649183608175_p
w(9)=6.644575344126247e-2_p
x(10)=8.063709315377126_p
w(10)=1.414225236127778e-3_p
x(11)=12.91967716160281_p
w(11)=1.263062514809058e-5_p
x(12)=17.97414247243731_p
w(12)=6.937486657618380e-8_p
else if(N==13)then
x(1)=-16.77656011614289_p
w(1)=5.717909124642273e-1_p
x(2)=-15.8369331259517_p
w(2)=1.298836834426069_p
x(3)=-14.20398851644992_p
w(3)=1.950931054004669_p
x(4)=-11.97402305910641_p
w(4)=2.486226630107372_p
x(5)=-9.283545986289472_p
w(5)=2.865033852987681_p
x(6)=-6.310441510510302_p
w(6)=3.036656308649943_p
x(7)=-3.293081539252783_p
w(7)=2.831461650379096_p
x(8)=-5.167866546608352e-1_p
w(8)=1.655146325352007_p
x(9)=2.239900900243954_p
w(9)=2.902343991814627e-1_p
x(10)=5.631402686496996_p
w(10)=1.341340787947681e-2_p
x(11)=9.707611445656466_p
w(11)=2.656735630103662e-4_p
x(12)=14.26683123482207_p
w(12)=2.959693602953878e-6_p
x(13)=18.52810457140832_p
w(13)=3.064960563816987e-8_p
else if(N==14)then
x(1)=-16.80280303503613_p
w(1)=5.048260083532201e-1_p
x(2)=-15.97186461185745_p
w(2)=1.150506405374575_p
x(3)=-14.52100526601017_p
w(3)=1.738838086303701_p
x(4)=-12.52413787508841_p
w(4)=2.237371174556065_p
x(5)=-10.08628520399795_p
w(5)=2.615655241716710_p
x(6)=-7.343415881772455_p
w(6)=2.839388933535103_p
x(7)=-4.471423078171773_p
w(7)=2.829752941672517_p
x(8)=-1.710367116737799_p
w(8)=2.223174694793622_p
x(9)=8.447204322455860e-1_p
w(9)=7.819595177686742e-1_p
x(10)=3.714833003108612_p
w(10)=7.564770648142008e-2_p
x(11)=7.192056606259204_p
w(11)=2.819313862912804e-3_p
x(12)=11.15779464094821_p
w(12)=5.910656979966261e-5_p
x(13)=15.34014482905663_p
w(13)=8.918392269928146e-7_p
x(14)=18.89419596081514_p
w(14)=1.651067638482131e-8_p
else if(N==15)then
x(1)=-16.82468964915857_p
w(1)=4.489349261021484e-1_p
x(2)=-16.08476510101427_p
w(2)=1.025872118295511_p
x(3)=-14.78788820856849_p
w(3)=1.558233960352153_p
x(4)=-12.99168194262764_p
w(4)=2.020482117481697_p
x(5)=-10.77821141673955_p
w(5)=2.388793198610455_p
x(6)=-8.253394672404619_p
w(6)=2.638088059028398_p
x(7)=-5.550982072802818_p
w(7)=2.726081914908312_p
x(8)=-2.850988037098246_p
w(8)=2.479805530718105_p
x(9)=-3.469310308264816e-1_p
w(9)=1.416534643227970_p
x(10)=2.172718381163772_p
w(10)=2.780179952151631e-1_p
x(11)=5.163922262412095_p
w(11)=1.848629685410203e-2_p
x(12)=8.629782881773858_p
w(12)=6.532132540249422e-4_p
x(13)=12.41041645501096_p
w(13)=1.572157592453331e-5_p
x(14)=16.18399641662106_p
w(14)=3.335499693108085e-7_p
x(15)=19.14390562238682_p
w(15)=1.016429068357253e-8_p
else if(N==16)then
x(1)=-16.84313064660408_p
w(1)=4.018137009180974e-1_p
x(2)=-16.18014473492551_p
w(2)=9.202204766062303e-1_p
x(3)=-15.01447474468534_p
w(3)=1.403491661011672_p
x(4)=-13.39167401179625_p
w(4)=1.831257644906191_p
x(5)=-11.37676146607535_p
w(5)=2.184587827385398_p
x(6)=-9.053546110346321_p
w(6)=2.444281216576926_p
x(7)=-6.526326570216923_p
w(7)=2.584094596604559_p
x(8)=-3.929985045757377_p
w(8)=2.523940508682190_p
x(9)=-1.443674459654162_p
w(9)=1.926184940760560_p
x(10)=8.999277232197406e-1_p
w(10)=6.922610960666833e-1_p
x(11)=3.499122717660363_p
w(11)=8.303813670437805e-2_p
x(12)=6.543722374561368_p
w(12)=4.652093755586169e-3_p
x(13)=9.927508131590137_p
w(13)=1.710138925488549e-4_p
x(14)=13.47631941060065_p
w(14)=4.969708439364000e-6_p
x(15)=16.84469199305491_p
w(15)=1.488979391967085e-7_p
x(16)=19.31991319045934_p
w(16)=6.860823687661570e-9_p
else if(N==17)then
x(1)=-16.85881160907103_p
w(1)=3.617245911806304e-1_p
x(2)=-16.26142708572844_p
w(2)=8.299321235695392e-1_p
x(3)=-15.20835972298454_p
w(3)=1.270095581110521_p
x(4)=-13.73607440242143_p
w(4)=1.665769738529478_p
x(5)=-11.89672679144502_p
w(5)=2.001714077134301_p
x(6)=-9.757523451577228_p
w(6)=2.262791762009085_p
x(7)=-7.401388157460422_p
w(7)=2.430842866838494_p
x(8)=-4.932083511719341_p
w(8)=2.465416899620228_p
x(9)=-2.489559753983665_p
w(9)=2.191394779804376_p
x(10)=-2.040963540000293e-1_p
w(10)=1.229089305151045_p
x(11)=2.116338276942324_p
w(11)=2.664010079055492e-1_p
x(12)=4.797895625953370_p
w(12)=2.351392362459417e-2_p
x(13)=7.828060259983818_p
w(13)=1.260466596753668e-3_p
x(14)=11.08169708467367_p
w(14)=5.099534752310443e-5_p
x(15)=14.37464415182591_p
w(15)=1.839433070803663e-6_p
x(16)=17.36326029664428_p
w(16)=7.653835213459835e-8_p
x(17)=19.44780886390387_p
w(17)=4.944683041907068e-9_p
else
call GD(-17)
end if
end subroutine GF_m17

! [-16kT;20kT]
subroutine GF_m16(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-12.40753465201264_p
w(1)=8.484775024585637_p
x(2)=-2.804962927462904_p
w(2)=7.515225085888377_p
else if(N==3)then
x(1)=-13.97871882444216_p
w(1)=4.977653631752325_p
x(2)=-7.080130276374050_p
w(2)=7.821264527617179_p
x(3)=-4.368134292249274e-1_p
w(3)=3.201081951104511_p
else if(N==4)then
x(1)=-14.68161651440259_p
w(1)=3.300482267450682_p
x(2)=-9.754496717440986_p
w(2)=6.133906702316693_p
x(3)=-3.491706173977817_p
w(3)=5.588165738375565_p
x(4)=1.480136561129027_p
w(4)=9.774454023310746e-1_p
else if(N==5)then
x(1)=-15.0563477359366_p
w(1)=2.381718989751556_p
x(2)=-11.37039321638922_p
w(2)=4.780690963106662_p
x(3)=-6.049559304325510_p
w(3)=5.508356514610822_p
x(4)=-1.069478284477758_p
w(4)=3.171487350262856_p
x(5)=3.665530080403538_p
w(5)=1.577462927421185e-1_p
else if(N==6)then
x(1)=-15.28130453765092_p
w(1)=1.822397780840029_p
x(2)=-12.40303722111804_p
w(2)=3.816775678842428_p
x(3)=-7.965139187327803_p
w(3)=4.861198529261999_p
x(4)=-3.150660272880753_p
w(4)=4.306254996114948_p
x(5)=8.752263980707270e-1_p
w(5)=1.179136674523835_p
x(6)=6.238654403829151_p
w(6)=1.423645089077486e-2_p
else if(N==7)then
x(1)=-15.42862046265241_p
w(1)=1.453076066512887_p
x(2)=-13.10439484097261_p
w(2)=3.123958612425985_p
x(3)=-9.376988456020472_p
w(3)=4.207961523794805_p
x(4)=-4.982340841917591_p
w(4)=4.373634782862321_p
x(5)=-9.418930995348429e-1_p
w(5)=2.602815582603770_p
x(6)=2.918403768487746_p
w(6)=2.376055730279236e-1_p
x(7)=9.039579442060948_p
w(7)=9.479692463223152e-4_p
else if(N==8)then
x(1)=-15.53213863995694_p
w(1)=1.192151519290592_p
x(2)=-13.60900873924768_p
w(2)=2.608006520165728_p
x(3)=-10.44443672871811_p
w(3)=3.640263649266322_p
x(4)=-6.522045421271438_p
w(4)=4.083615844102486_p
x(5)=-2.543812670794632_p
w(5)=3.443077045826614_p
x(6)=9.117944435157664e-1_p
w(6)=1.003894636523362_p
x(7)=5.201749733911055_p
w(7)=2.892989397684168e-2_p
x(8)=11.82085348297658_p
w(8)=6.100132206930065e-5_p
else if(N==9)then
x(1)=-15.60909662434586_p
w(1)=9.974405460508446e-1_p
x(2)=-13.9903669170696_p
w(2)=2.208972910287980_p
x(3)=-11.27845449801472_p
w(3)=3.159513954908344_p
x(4)=-7.804089626065540_p
w(4)=3.709656130775207_p
x(5)=-4.043242791400699_p
w(5)=3.632838911863608_p
x(6)=-6.160766255887665e-1_p
w(6)=2.059307786694731_p
x(7)=2.781842525687419_p
w(7)=2.292587865683837e-1_p
x(8)=7.534669719719148_p
w(8)=3.005933639560950e-3_p
x(9)=14.24830558748348_p
w(9)=5.149685356202640e-6_p
else if(N==10)then
x(1)=-15.66850586542385_p
w(1)=8.467173370532748e-1_p
x(2)=-14.28828666557805_p
w(2)=1.892129134387439_p
x(3)=-11.94551948135358_p
w(3)=2.754393580717796_p
x(4)=-8.873319595673319_p
w(4)=3.334581060388275_p
x(5)=-5.404424785491805_p
w(5)=3.510021164024529_p
x(6)=-2.005419842151144_p
w(6)=2.807479103753890_p
x(7)=1.049604228706764_p
w(7)=8.168278782319931e-1_p
x(8)=4.735363800632829_p
w(8)=3.750782094662481e-2_p
x(9)=9.715627891709442_p
w(9)=3.423171285988190e-4_p
x(10)=16.07664998542366_p
w(10)=7.138415936563394e-7_p
else if(N==11)then
x(1)=-15.71543455925574_p
w(1)=7.274152232503995e-1_p
x(2)=-14.52570447520414_p
w(2)=1.636622437594059_p
x(3)=-12.48632885321222_p
w(3)=2.413922636670013_p
x(4)=-9.765847136836292_p
w(4)=2.987083841100940_p
x(5)=-6.604030769323194_p
w(5)=3.278284718730394_p
x(6)=-3.330631955879042_p
w(6)=3.075961892955640_p
x(7)=-3.396795415428703e-1_p
w(7)=1.659772223003542_p
x(8)=2.704837481894022_p
w(8)=2.151578852138097e-1_p
x(9)=6.658124329492407_p
w(9)=5.730547684098771e-3_p
x(10)=11.62945360966331_p
w(10)=4.853869165242950e-5_p
x(11)=17.31114648325041_p
w(11)=1.655794666618833e-7_p
else if(N==12)then
x(1)=-15.75312290445245_p
w(1)=6.314556766970227e-1_p
x(2)=-14.71765399171988_p
w(2)=1.428210261966891_p
x(3)=-12.92923397572458_p
w(3)=2.127776129851786_p
x(4)=-10.51246614190685_p
w(4)=2.676212067499131_p
x(5)=-7.644538649414305_p
w(5)=3.019226674059369_p
x(6)=-4.562917906047844_p
w(6)=3.055323112215123_p
x(7)=-1.594488150737637_p
w(7)=2.331050046079593_p
x(8)=1.153416927737750_p
w(8)=6.849604747752553e-1_p
x(9)=4.389460999039117_p
w(9)=4.482814149397040e-2_p
x(10)=8.453874391831619_p
w(10)=9.484479237045542e-4_p
x(11)=13.23289024668626_p
w(11)=9.020397759254141e-6_p
x(12)=18.10675785576993_p
w(12)=5.751440912587059e-8_p
else if(N==13)then
x(1)=-15.78382200902048_p
w(1)=5.531977658825608e-1_p
x(2)=-14.87481983494489_p
w(2)=1.256401710129788_p
x(3)=-13.29548291185317_p
w(3)=1.886546076181981_p
x(4)=-11.13977254927113_p
w(4)=2.402563363004894_p
x(5)=-8.541422817949508_p
w(5)=2.764497599090779_p
x(6)=-5.676667400528481_p
w(6)=2.915236790646504_p
x(7)=-2.786159514269548_p
w(7)=2.639089093469485_p
x(8)=-1.216447104836428e-1_p
w(8)=1.369457437413566_p
x(9)=2.634311408318399_p
w(9)=2.038943387276103e-1_p
x(10)=6.035043986126381_p
w(10)=8.931722190311011e-3_p
x(11)=10.07071671046277_p
w(11)=1.819819333011419e-4_p
x(12)=14.53131252250755_p
w(12)=2.205388884170208e-6_p
x(13)=18.62014316640097_p
w(13)=2.641435032244045e-8_p
else if(N==14)then
x(1)=-15.80914738514788_p
w(1)=4.885771541206033e-1_p
x(2)=-15.00500706731315_p
w(2)=1.113325742335415_p
x(3)=-13.60122385847171_p
w(3)=1.682170981443309_p
x(4)=-11.66990712721473_p
w(4)=2.163310346955181_p
x(5)=-9.313839635631558_p
w(5)=2.526356562620763_p
x(6)=-6.667182444802088_p
w(6)=2.734387677453630_p
x(7)=-3.906913523018585_p
w(7)=2.687214914366052_p
x(8)=-1.268404600959800_p
w(8)=1.963889423768725_p
x(9)=1.233994130395808_p
w(9)=5.879500609051773e-1_p
x(10)=4.121348336222607_p
w(10)=5.088512909599819e-2_p
x(11)=7.582032616407222_p
w(11)=1.889765756275643e-3_p
x(12)=11.48767169770561_p
w(12)=4.164513802001132e-5_p
x(13)=15.55948027414091_p
w(13)=6.918988271155574e-7_p
x(14)=18.95986327256097_p
w(14)=1.461603942035704e-8_p
else if(N==15)then
x(1)=-15.83027864376392_p
w(1)=4.346171000240404e-1_p
x(2)=-15.11399232155303_p
w(2)=9.930410877006151e-1_p
x(3)=-13.85876115528702_p
w(3)=1.508011622338256_p
x(4)=-12.12079555117964_p
w(4)=1.954524754980466_p
x(5)=-9.980351382708561_p
w(5)=2.308939097742083_p
x(6)=-7.541646276655499_p
w(6)=2.545074574719582_p
x(7)=-4.938338579660830_p
w(7)=2.611400337182364_p
x(8)=-2.352621607006034_p
w(8)=2.287081973085486_p
x(9)=5.788421035030732e-2_p
w(9)=1.150804083079086_p
x(10)=2.574888562251574_p
w(10)=1.937567653557121e-1_p
x(11)=5.568488496018540_p
w(11)=1.229166646571611e-2_p
x(12)=8.997824845689379_p
w(12)=4.453427503488491e-4_p
x(13)=12.70486680057519_p
w(13)=1.142774298781632e-5_p
x(14)=16.3644027178808_p
w(14)=2.681389948423926e-7_p
x(15)=19.19222449547944_p
w(15)=9.168275990272169e-9_p
else if(N==16)then
x(1)=-15.84809073703999_p
w(1)=3.891043949696100e-1_p
x(2)=-15.20610564141058_p
w(2)=8.910272287572005e-1_p
x(3)=-14.07752353445203_p
w(3)=1.358697817458340_p
x(4)=-12.50677689969813_p
w(4)=1.772188008361425_p
x(5)=-10.55741635983846_p
w(5)=2.112782752625715_p
x(6)=-8.311744240696957_p
w(6)=2.360826730470527_p
x(7)=-5.873377793811165_p
w(7)=2.486002715955954_p
x(8)=-3.379179299761526_p
w(8)=2.382722761527010_p
x(9)=-1.000295620746737_p
w(9)=1.674375191368512_p
x(10)=1.300024647589236_p
w(10)=5.133632621590968e-1_p
x(11)=3.909037600231389_p
w(11)=5.567583073149576e-2_p
x(12)=6.935872442721466_p
w(12)=3.110309785716790e-3_p
x(13)=10.26904038384921_p
w(13)=1.192495341707509e-4_p
x(14)=13.73599436523198_p
w(14)=3.727156935761803e-6_p
x(15)=16.99296050199061_p
w(15)=1.233401202439626e-7_p
x(16)=19.3565215844194_p
w(16)=6.272185791276533e-9_p
else if(N==17)then
x(1)=-15.86324270729722_p
w(1)=3.503687913076936e-1_p
x(2)=-15.28463605658773_p
w(2)=8.038100900525017e-1_p
x(3)=-14.26479729118447_p
w(3)=1.229911778095594_p
x(4)=-12.83929128021305_p
w(4)=1.612594744661209_p
x(5)=-11.05907425709135_p
w(5)=1.936832430551825_p
x(6)=-8.990051679167244_p
w(6)=2.187324166848903_p
x(7)=-6.714249651263040_p
w(7)=2.344037690070818_p
x(8)=-4.336294146414899_p
w(8)=2.354485136481787_p
x(9)=-1.997191370344670_p
w(9)=1.997795446862883_p
x(10)=2.092761996304726e-1_p
w(10)=9.819515740200845e-1_p
x(11)=2.525259152499329_p
w(11)=1.843965728182508e-1_p
x(12)=5.204612212395362_p
w(12)=1.559882185359915e-2_p
x(13)=8.201365554303562_p
w(13)=8.549113635374183e-4_p
x(14)=11.39476306500673_p
w(14)=3.646500463534469e-5_p
x(15)=14.60197382351309_p
w(15)=1.420932276543946e-6_p
x(16)=17.48561890669805_p
w(16)=6.498309602240008e-8_p
x(17)=19.47627764329336_p
w(17)=4.565321632289758e-9_p
else
call GD(-16)
end if
end subroutine GF_m16

! [-15kT;20kT]
subroutine GF_m15(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-11.60757003070167_p
w(1)=8.010479912344408_p
x(2)=-2.557094522615516_p
w(2)=6.989520391496713_p
else if(N==3)then
x(1)=-13.08170786167232_p
w(1)=4.723444954689006_p
x(2)=-6.541752073911494_p
w(2)=7.396058156645526_p
x(3)=-2.364748313960855e-1_p
w(3)=2.880497192506588_p
else if(N==4)then
x(1)=-13.74326745812851_p
w(1)=3.145837655348002_p
x(2)=-9.049721625534541_p
w(2)=5.837718650170097_p
x(3)=-3.109052510475885_p
w(3)=5.206276547353221_p
x(4)=1.722277643674406_p
w(4)=8.101674509697998e-1_p
else if(N==5)then
x(1)=-14.09709562530293_p
w(1)=2.278683487376088_p
x(2)=-10.57215109626482_p
w(2)=4.569189885393182_p
x(3)=-5.496365777793332_p
w(3)=5.228273860607080_p
x(4)=-7.679490387712081e-1_p
w(4)=2.807043902161798_p
x(5)=3.990150807218497_p
w(5)=1.168091683029724e-1_p
else if(N==6)then
x(1)=-14.31020458010408_p
w(1)=1.748988182847054_p
x(2)=-11.54887755919319_p
w(2)=3.660095449074938_p
x(3)=-7.298229039122787_p
w(3)=4.646207289986700_p
x(4)=-2.716753836519706_p
w(4)=3.988019457789879_p
x(5)=1.185421954535464_p
w(5)=9.470044074695504e-1_p
x(6)=6.634064482461104_p
w(6)=9.685516672998880e-3_p
else if(N==7)then
x(1)=-14.45030027593148_p
w(1)=1.397854206326032_p
x(2)=-12.21507442540818_p
w(2)=3.003289847518284_p
x(3)=-8.634677375455544_p
w(3)=4.037007554539871_p
x(4)=-4.430909515813568_p
w(4)=4.143292055485685_p
x(5)=-5.856704381298989e-1_p
w(5)=2.248570898863751_p
x(6)=3.292499032605277_p
w(6)=1.693703564043981e-1_p
x(7)=9.475245414596991_p
w(7)=6.153847030998951e-4_p
else if(N==8)then
x(1)=-14.54919723675115_p
w(1)=1.148624259573718_p
x(2)=-12.69673865849571_p
w(2)=2.511473319477710_p
x(3)=-9.651215791306948_p
w(3)=3.500421793469816_p
x(4)=-5.886383484812564_p
w(4)=3.903631834346955_p
x(5)=-2.098214354922444_p
w(5)=3.139661745777555_p
x(6)=1.267597362160440_p
w(6)=7.769475317473203e-1_p
x(7)=5.622461989883024_p
w(7)=1.920027542914551e-2_p
x(8)=12.24841745004296_p
w(8)=3.954401889961144e-5_p
else if(N==9)then
x(1)=-14.62300542637601_p
w(1)=9.619089598526911e-1_p
x(2)=-13.06224806418091_p
w(2)=2.129397355752050_p
x(3)=-10.44927019090841_p
w(3)=3.042460158240688_p
x(4)=-7.107630411009958_p
w(4)=3.560491572991381_p
x(5)=-3.510410859011995_p
w(5)=3.415212326096638_p
x(6)=-2.376706972831173e-1_p
w(6)=1.728764368733618_p
x(7)=3.177770465146780_p
w(7)=1.598028694767408e-1_p
x(8)=7.961962685131487_p
w(8)=1.959184703057021e-3_p
x(9)=14.60994266093062_p
w(9)=3.507994255964994e-6_p
else if(N==10)then
x(1)=-14.68010148579897_p
w(1)=8.170705340820106e-1_p
x(2)=-13.34842114647449_p
w(2)=1.825271576825795_p
x(3)=-11.08925983498175_p
w(3)=2.654943665884487_p
x(4)=-8.130447887360829_p
w(4)=3.207506410839538_p
x(5)=-4.801252038890203_p
w(5)=3.344557410982316_p
x(6)=-1.564065723127900_p
w(6)=2.510406251817047_p
x(7)=1.427237599343070_p
w(7)=6.151521347843357e-1_p
x(8)=5.154169879921271_p
w(8)=2.486533575160706e-2_p
x(9)=10.11907334967507_p
w(9)=2.264583068449287e-4_p
x(10)=16.34486793859308_p
w(10)=5.245671396464993e-7_p
else if(N==11)then
x(1)=-14.725246271008_p
w(1)=7.023138905612840e-1_p
x(2)=-13.57671976970755_p
w(2)=1.579721499539986_p
x(3)=-11.60881252242559_p
w(3)=2.328555028546627_p
x(4)=-8.986131020572364_p
w(4)=2.877320993764191_p
x(5)=-5.944976956292304_p
w(5)=3.142444025913796_p
x(6)=-2.816290113706362_p
w(6)=2.860033847378987_p
x(7)=5.165575298016132e-2_p
w(7)=1.357505391475096_p
x(8)=3.109335125676516_p
w(8)=1.483074021739941e-1_p
x(9)=7.074310580713250_p
w(9)=3.764887791989675e-3_p
x(10)=11.99100125022247_p
w(10)=3.320608747684512e-5_p
x(11)=17.49662835192995_p
w(11)=1.306076914819767e-7_p
else if(N==12)then
x(1)=-14.76152557098383_p
w(1)=6.099488769246263e-1_p
x(2)=-13.76143064089593_p
w(2)=1.379262132438818_p
x(3)=-12.03470132057402_p
w(3)=2.053843784039510_p
x(4)=-9.702978465647902_p
w(4)=2.580520234764564_p
x(5)=-6.940388912021529_p
w(5)=2.902888967375078_p
x(6)=-3.984464745933042_p
w(6)=2.896021898894213_p
x(7)=-1.154581113247010_p
w(7)=2.042106895239783_p
x(8)=1.546526956191763_p
w(8)=5.050873475976859e-1_p
x(9)=4.807649173428922_p
w(9)=2.968269461673142e-2_p
x(10)=8.850228779897877_p
w(10)=6.309855808955388e-4_p
x(11)=13.54448125783469_p
w(11)=6.438506048925337e-6_p
x(12)=18.2332874970636_p
w(12)=4.786316632556019e-8_p
else if(N==13)then
x(1)=-14.79109443162807_p
w(1)=5.345768762473653e-1_p
x(2)=-13.91276795161882_p
w(2)=1.213887843791377_p
x(3)=-12.38715860066261_p
w(3)=1.821986100354202_p
x(4)=-10.30596513659666_p
w(4)=2.318495088969005_p
x(5)=-7.800358200745833_p
w(5)=2.662732462003360_p
x(6)=-5.045588574822271_p
w(6)=2.787798118142332_p
x(7)=-2.284108002674746_p
w(7)=2.421573208696157_p
x(8)=2.816901951417553e-1_p
w(8)=1.093701009818614_p
x(9)=3.046357643053096_p
w(9)=1.392491820636495e-1_p
x(10)=6.448565034528675_p
w(10)=5.874688035354543e-3_p
x(11)=10.43683132392948_p
w(11)=1.240577802040695e-4_p
x(12)=14.79259740009386_p
w(12)=1.645119351771843e-6_p
x(13)=18.7080015467004_p
w(13)=2.282014667251454e-8_p
else if(N==14)then
x(1)=-14.81550087675891_p
w(1)=4.723042892153009e-1_p
x(2)=-14.03820212611472_p
w(2)=1.076078630771419_p
x(3)=-12.68159408794875_p
w(3)=1.625362395885267_p
x(4)=-10.81603357658209_p
w(4)=2.088945156106600_p
x(5)=-8.542198634531868_p
w(5)=2.436265161916767_p
x(6)=-5.992857526843933_p
w(6)=2.626230203919175_p
x(7)=-3.346766758046049_p
w(7)=2.528823202018304_p
x(8)=-8.270597239145404e-1_p
w(8)=1.685057293642006_p
x(9)=1.639706932457396_p
w(9)=4.260492361566950e-1_p
x(10)=4.541416789422749_p
w(10)=3.359865273422399e-2_p
x(11)=7.978417431935154_p
w(11)=1.256260497915870e-3_p
x(12)=11.81823464139411_p
w(12)=2.927028162232572e-5_p
x(13)=15.7750898141588_p
w(13)=5.377386784723212e-7_p
x(14)=19.02270348619729_p
w(14)=1.295714409799733e-8_p
else if(N==15)then
x(1)=-14.83587564476947_p
w(1)=4.202782991682084e-1_p
x(2)=-14.14326510134105_p
w(2)=9.601532334567187e-1_p
x(3)=-12.92976283239535_p
w(3)=1.457672595015745_p
x(4)=-11.25020331007245_p
w(4)=1.888330600572226_p
x(5)=-9.183123370389545_p
w(5)=2.228535580603528_p
x(6)=-6.831297489728732_p
w(6)=2.450264400849504_p
x(7)=-4.328953471631874_p
w(7)=2.488167535613501_p
x(8)=-1.858718618854929_p
w(8)=2.067465736771655_p
x(9)=4.718819784471176e-1_p
w(9)=8.994644601214477e-1_p
x(10)=2.993597704433465_p
w(10)=1.312843267471411e-1_p
x(11)=5.982607022738540_p
w(11)=8.073043414791056e-3_p
x(12)=9.369644830127417_p
w(12)=3.019678086832748e-4_p
x(13)=12.99845460429369_p
w(13)=8.299463954919936e-6_p
x(14)=16.54118058264899_p
w(14)=2.159583497057316e-7_p
x(15)=19.23860732316326_p
w(15)=8.275666741011193e-9_p
else if(N==16)then
x(1)=-14.85305787883714_p
w(1)=3.763766555786952e-1_p
x(2)=-14.23210630349679_p
w(2)=8.617849201919873e-1_p
x(3)=-13.14068280605178_p
w(3)=1.313806236989030_p
x(4)=-11.62212598609189_p
w(4)=1.712929216560661_p
x(5)=-9.738580545968061_p
w(5)=2.040575823584179_p
x(6)=-7.571006446335651_p
w(6)=2.276258916128754_p
x(7)=-5.222796998540657_p
w(7)=2.383327859054875_p
x(8)=-2.833023207677650_p
w(8)=2.222065097300033_p
x(9)=-5.561153663652100e-1_p
w(9)=1.407471823012336_p
x(10)=1.715973974277330_p
w(10)=3.666113814027950e-1_p
x(11)=4.331813328557103_p
w(11)=3.664459239035393e-2_p
x(12)=7.334520468980240_p
w(12)=2.062008787161995e-3_p
x(13)=10.61239107782849_p
w(13)=8.286917741792213e-5_p
x(14)=13.9938929117987_p
w(14)=2.795609314945188e-6_p
x(15)=17.13798844457571_p
w(15)=1.023382054652810e-7_p
x(16)=19.39177367828478_p
w(16)=5.735320963850149e-9_p
else if(N==17)then
x(1)=-14.86768004324244_p
w(1)=3.389967136366605e-1_p
x(2)=-14.30787992708332_p
w(2)=7.776453702793135e-1_p
x(3)=-13.3213305138014_p
w(3)=1.189645081538385_p
x(4)=-11.94271692347189_p
w(4)=1.559265464569543_p
x(5)=-10.22184045600982_p
w(5)=1.871644703474843_p
x(6)=-8.223414244526083_p
w(6)=2.111113853418664_p
x(7)=-6.028863564313912_p
w(7)=2.254647853154646_p
x(8)=-3.744230651154262_p
w(8)=2.232171421088148_p
x(9)=-1.508600264833519_p
w(9)=1.777140290331524_p
x(10)=6.325126958631766e-1_p
w(10)=7.528032576793490e-1_p
x(11)=2.949747731300512_p
w(11)=1.241014421874811e-1_p
x(12)=5.620602607259503_p
w(12)=1.022122312537592e-2_p
x(13)=8.578877253285603_p
w(13)=5.764479489165944e-4_p
x(14)=11.70824198747614_p
w(14)=2.602358534442287e-5_p
x(15)=14.82707976396452_p
w(15)=1.098362798988107e-6_p
x(16)=17.60520988814082_p
w(16)=5.524549344152670e-8_p
x(17)=19.50377202498411_p
w(17)=4.214634562776444e-9_p
else
call GD(-15)
end if
end subroutine GF_m15

! [-14kT;20kT]
subroutine GF_m14(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-10.80652733276859_p
w(1)=7.538498854262962_p
x(2)=-2.304430856767426_p
w(2)=6.461501975204257_p
else if(N==3)then
x(1)=-12.18399872713082_p
w(1)=4.470874764748139_p
x(2)=-6.001287947544221_p
w(2)=6.968249881172690_p
x(3)=-2.478525887305564e-2_p
w(3)=2.560876183546391_p
else if(N==4)then
x(1)=-12.80449581374713_p
w(1)=2.992210456201725_p
x(2)=-8.343381452837448_p
w(2)=5.541887650733794_p
x(3)=-2.724869989979754_p
w(3)=4.809677495727553_p
x(4)=1.984831222806008_p
w(4)=6.562252268041475e-1_p
else if(N==5)then
x(1)=-13.13759322438451_p
w(1)=2.176256374727140_p
x(2)=-9.772909652697393_p
w(2)=4.358240313170322_p
x(3)=-4.942842831298137_p
w(3)=4.940328756024897_p
x(4)=-4.579694314601175e-1_p
w(4)=2.440928459000592_p
x(5)=4.338681406011870_p
w(5)=8.424692654426884e-2_p
else if(N==6)then
x(1)=-13.33896830458304_p
w(1)=1.675909843158042_p
x(2)=-10.69416973240304_p
w(2)=3.503746701546021_p
x(3)=-6.631077604336837_p
w(3)=4.428405360813438_p
x(4)=-2.284071322696148_p
w(4)=3.647248793120013_p
x(5)=1.516767980212818_p
w(5)=7.382493664243607e-1_p
x(6)=7.051141510271330_p
w(6)=6.440764405344880e-3_p
else if(N==7)then
x(1)=-13.47192933132109_p
w(1)=1.342752340640446_p
x(2)=-11.32557852628542_p
w(2)=2.882666596046186_p
x(3)=-7.892506927661978_p
w(3)=3.864692613652714_p
x(4)=-3.882181626553763_p
w(4)=3.897763459010463_p
x(5)=-2.218094215199400e-1_p
w(5)=1.894543538676478_p
x(6)=3.690786537261425_p
w(6)=1.171896563203391e-1_p
x(7)=9.927036999849866_p
w(7)=3.926251205940173e-4_p
else if(N==8)then
x(1)=-13.56626019804303_p
w(1)=1.105080099796742_p
x(2)=-11.78454129575056_p
w(2)=2.414774808426220_p
x(3)=-8.858475519497194_p
w(3)=3.359635702182922_p
x(4)=-5.253071298122138_p
w(4)=3.716499236478462_p
x(5)=-1.655545435954633_p
w(5)=2.810563562510747_p
x(6)=1.643983320475834_p
w(6)=5.809382861888754e-1_p
x(7)=6.061151253171272_p
w(7)=1.248370685391215e-2_p
x(8)=12.68158618795276_p
w(8)=2.542702933910387e-5_p
else if(N==9)then
x(1)=-13.6369374298425_p
w(1)=9.263143645878879e-1_p
x(2)=-12.13428069975576_p
w(2)=2.049601398110844_p
x(3)=-9.620630853773944_p
w(3)=2.924695564060607_p
x(4)=-6.412989697937128_p
w(4)=3.407823447506779_p
x(5)=-2.982593395943650_p
w(5)=3.175380516639711_p
x(6)=1.494916191352380e-1_p
w(6)=1.406662038006109_p
x(7)=3.594698600984726_p
w(7)=1.082604688091195e-1_p
x(8)=8.400120875033577_p
w(8)=1.260639469611222e-3_p
x(9)=14.96655086343229_p
w(9)=2.392276552388534e-6_p
else if(N==10)then
x(1)=-13.69171999847003_p
w(1)=7.873626125927948e-1_p
x(2)=-12.4086955499811_p
w(2)=1.758223556208651_p
x(3)=-10.23345370717983_p
w(3)=2.554977262920034_p
x(4)=-7.388892558801517_p
w(4)=3.078520623583710_p
x(5)=-4.201958804620082_p
w(5)=3.167217666265396_p
x(6)=-1.124455111928318_p
w(6)=2.190539675705373_p
x(7)=1.824662543259538_p
w(7)=4.468276534462946e-1_p
x(8)=5.588091139980826_p
w(8)=1.618264066431663e-2_p
x(9)=10.52752701487642_p
w(9)=1.487505898849732e-4_p
x(10)=16.60390097864635_p
w(10)=3.874907649122579e-7_p
else if(N==11)then
x(1)=-13.73507699928962_p
w(1)=6.771620332546457e-1_p
x(2)=-12.62784883299645_p
w(2)=1.522669415905551_p
x(3)=-10.73165009415312_p
w(3)=2.242810049123273_p
x(4)=-8.207369872152951_p
w(4)=2.766403045945153_p
x(5)=-5.288588369743109_p
w(5)=3.000719163900526_p
x(6)=-2.307100105195871_p
w(6)=2.617356967636456_p
x(7)=4.536915977866475e-1_p
w(7)=1.070962417013593_p
x(8)=3.532926874548194_p
w(8)=9.945098654746762e-2_p
x(9)=7.500326375854223_p
w(9)=2.443995607514454e-3_p
x(10)=12.35318546039932_p
w(10)=2.265098054224737e-5_p
x(11)=17.6738559985774_p
w(11)=1.035524965876851e-7_p
else if(N==12)then
x(1)=-13.76994409928094_p
w(1)=5.884000846276992e-1_p
x(2)=-12.80530066990922_p
w(2)=1.330192223118695_p
x(3)=-11.14045028188021_p
w(3)=1.979625623611013_p
x(4)=-8.894210092481099_p
w(4)=2.484066614433215_p
x(5)=-6.238098478694810_p
w(5)=2.783459411057282_p
x(6)=-3.410616913137459_p
w(6)=2.719849512187150_p
x(7)=-7.143043647631616e-1_p
w(7)=1.735760913213736_p
x(8)=1.958762751475419_p
w(8)=3.589176151960385e-1_p
x(9)=5.239765913548898_p
w(9)=1.930759490650666e-2_p
x(10)=9.252267657322449_p
w(10)=4.166020503291754e-4_p
x(11)=13.85388832004595_p
w(11)=4.595086364266990e-6_p
x(12)=18.35382572017462_p
w(12)=3.997919048900008e-8_p
else if(N==13)then
x(1)=-13.79838038631612_p
w(1)=5.159202793857288e-1_p
x(2)=-12.95079458471266_p
w(2)=1.171273283502765_p
x(3)=-11.47906473585452_p
w(3)=1.757201883948742_p
x(4)=-9.472720151123559_p
w(4)=2.233889164949489_p
x(5)=-7.060646617102471_p
w(5)=2.559185578331794_p
x(6)=-4.417901424350787_p
w(6)=2.651353924614919_p
x(7)=-1.786613409422321_p
w(7)=2.175305414641396_p
x(8)=6.970928796435937e-1_p
w(8)=8.393918051186117e-1_p
x(9)=3.476067822258977_p
w(9)=9.257515717611747e-2_p
x(10)=6.871485134628751_p
w(10)=3.818889728425831e-3_p
x(11)=10.80545900643945_p
w(11)=8.419942482041147e-5_p
x(12)=15.05029771424226_p
w(12)=1.228883738359989e-6_p
x(13)=18.79179291230295_p
w(13)=1.976067344905587e-8_p
else if(N==14)then
x(1)=-13.82186607449559_p
w(1)=4.560006227954732e-1_p
x(2)=-13.07146426632228_p
w(2)=1.038746727999376_p
x(3)=-11.76215671597924_p
w(3)=1.568373127182383_p
x(4)=-9.962612379322648_p
w(4)=2.014180936328971_p
x(5)=-7.771582416969307_p
w(5)=2.345052178780199_p
x(6)=-5.320970497872779_p
w(6)=2.513269754143292_p
x(7)=-2.791618136795156_p
w(7)=2.348882746181900_p
x(8)=-3.833055781403003e-1_p
w(8)=1.395417636902261_p
x(9)=2.063696328739681_p
w(9)=2.974252447513675e-1_p
x(10)=4.974513791730882_p
w(10)=2.180230100574679e-2_p
x(11)=8.380756583789692_p
w(11)=8.285938951165442e-4_p
x(12)=12.1490447705184_p
w(12)=2.052926250336100e-5_p
x(13)=15.98674102794288_p
w(13)=4.187372783271262e-7_p
x(14)=19.08280370964505_p
w(14)=1.150135238770062e-8_p
else if(N==15)then
x(1)=-13.84148285446759_p
w(1)=4.059126999256598e-1_p
x(2)=-13.17259577880534_p
w(2)=9.271930813492448e-1_p
x(3)=-12.00092742040765_p
w(3)=1.407185046512430_p
x(4)=-10.37998260311375_p
w(4)=1.821829008949855_p
x(5)=-8.386697169493372_p
w(5)=2.147372472660739_p
x(6)=-6.122739988147349_p
w(6)=2.352739259077020_p
x(7)=-3.723584997831476_p
w(7)=2.352270252914634_p
x(8)=-1.368338331242161_p
w(8)=1.819623654266176_p
x(9)=8.987718892538201e-1_p
w(9)=6.737842386143351e-1_p
x(10)=3.428738151558815_p
w(10)=8.664001306803705e-2_p
x(11)=6.405772018409500_p
w(11)=5.241188980816030e-3_p
x(12)=9.744822930513482_p
w(12)=2.037074477132471e-4_p
x(13)=13.29082517356608_p
w(13)=6.023958080480530e-6_p
x(14)=16.71420665647077_p
w(14)=1.742680911975906e-7_p
x(15)=19.28311403863226_p
w(15)=7.474387268820590e-9_p
else if(N==16)then
x(1)=-13.85803397481837_p
w(1)=3.636254561800490e-1_p
x(2)=-13.25815731454062_p
w(2)=8.324803753878970e-1_p
x(3)=-12.20398151935224_p
w(3)=1.268790642452037_p
x(4)=-10.7377852457076_p
w(4)=1.653426691627713_p
x(5)=-8.920388457079611_p
w(5)=1.967824111287966_p
x(6)=-6.831626702482287_p
w(6)=2.190040428671849_p
x(7)=-4.575218099243794_p
w(7)=2.273605883144643_p
x(8)=-2.291877460922814_p
w(8)=2.036199013239085_p
x(9)=-1.077018345534434e-1_p
w(9)=1.136638716615709_p
x(10)=2.149293316360647_p
w(10)=2.522442450261720e-1_p
x(11)=4.766874125043365_p
w(11)=2.370952775660249e-2_p
x(12)=7.739227489644482_p
w(12)=1.356142586486647e-3_p
x(13)=10.95718766709039_p
w(13)=5.740765141813026e-5_p
x(14)=14.24974747587224_p
w(14)=2.097541507256978e-6_p
x(15)=17.27971805852789_p
w(15)=8.505301135950031e-8_p
x(16)=19.42570951786963_p
w(16)=5.245072478486783e-9_p
else if(N==17)then
x(1)=-13.8721252711792_p
w(1)=3.276039916058349e-1_p
x(2)=-13.33116785759604_p
w(2)=7.514266498155525e-1_p
x(3)=-12.37798415777544_p
w(3)=1.149273495365436_p
x(4)=-11.04640496003297_p
w(4)=1.505738567379102_p
x(5)=-9.385134206049964_p
w(5)=1.806048579076950_p
x(6)=-7.457837276575983_p
w(6)=2.033827656473759_p
x(7)=-5.345718094950008_p
w(7)=2.161247769953418_p
x(8)=-3.156626589228561_p
w(8)=2.093377777739646_p
x(9)=-1.022225867444307_p
w(9)=1.530892057527028_p
x(10)=1.069068286446880_p
w(10)=5.521501705511970e-1_p
x(11)=3.389598931354672_p
w(11)=8.138729324748564e-2_p
x(12)=6.045336860629606_p
w(12)=6.620837607770443e-3_p
x(13)=8.960210188997728_p
w(13)=3.865425822177236e-4_p
x(14)=12.02181769205871_p
w(14)=1.853994503816886e-5_p
x(15)=15.0497702351354_p
w(15)=8.496788460618810e-7_p
x(16)=17.72201103339586_p
w(16)=4.702777807590687e-8_p
x(17)=19.53031877789259_p
w(17)=3.890160035029094e-9_p
else
call GD(-14)
end if
end subroutine GF_m14

! [-13kT;20kT]
subroutine GF_m13(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-10.00429027843279_p
w(1)=7.068991696415148_p
x(2)=-2.046000860679432_p
w(2)=5.931010561850551_p
else if(N==3)then
x(1)=-11.28554899564229_p
w(1)=4.220014301197976_p
x(2)=-5.458794043159830_p
w(2)=6.536162319346579_p
x(3)=2.003918949331666e-1_p
w(3)=2.243825637721143_p
else if(N==4)then
x(1)=-11.8652932529664_p
w(1)=2.839607018600504_p
x(2)=-7.635563141453814_p
w(2)=5.245808192698806_p
x(3)=-2.338765188456291_p
w(3)=4.396838433300635_p
x(4)=2.270493241725938_p
w(4)=5.177486136657526e-1_p
else if(N==5)then
x(1)=-12.17784665692331_p
w(1)=2.074414407765707_p
x(2)=-8.972761209892331_p
w(2)=4.147552591959923_p
x(3)=-4.389531972968300_p
w(3)=4.641151434695219_p
x(4)=-1.367785640396914e-1_p
w(4)=2.077791542603522_p
x(5)=4.712661357792804_p
w(5)=5.909228124132800e-2_p
else if(N==6)then
x(1)=-12.36760934567335_p
w(1)=1.603123506628418_p
x(2)=-9.839016126053242_p
w(2)=3.347529415940021_p
x(3)=-5.964176911221692_p
w(3)=4.206079529463115_p
x(4)=-1.852082146925906_p
w(4)=3.282532339792695_p
x(5)=1.872394953379042_p
w(5)=5.565540168776083e-1_p
x(6)=7.490606583130453_p
w(6)=4.183449563842003e-3_p
else if(N==7)then
x(1)=-12.49352478804909_p
w(1)=1.287723844150780_p
x(2)=-10.43601388986216_p
w(2)=2.761924681900327_p
x(3)=-7.150871208413591_p
w(3)=3.690153593398606_p
x(4)=-3.336998322341939_p
w(4)=3.631838463455905_p
x(5)=1.533564861653469e-1_p
w(5)=1.549440486944906_p
x(6)=4.114041724425886_p
w(6)=7.867492930788110e-2_p
x(7)=10.39451465468719_p
w(7)=2.462591072937468e-4_p
else if(N==8)then
x(1)=-12.58334196990106_p
w(1)=1.061480213740170_p
x(2)=-10.87250254573882_p
w(2)=2.317788603820697_p
x(3)=-8.066501193100509_p
w(3)=3.217428398427951_p
x(4)=-4.622945960170628_p
w(4)=3.518862230162991_p
x(5)=-1.214248166759280_p
w(5)=2.457913331848562_p
x(6)=2.043660416121222_p
w(6)=4.185583615764695e-1_p
x(7)=6.517498351547172_p
w(7)=7.954880057219615e-3_p
x(8)=13.11862085978246_p
w(8)=1.623863163846115e-5_p
else if(N==9)then
x(1)=-12.65090219393455_p
w(1)=8.906309188461304e-1_p
x(2)=-11.20652186732269_p
w(2)=1.969504112129237_p
x(3)=-8.792722711102545_p
w(3)=2.805942895986523_p
x(4)=-5.720738659387905_p
w(4)=3.249934125153502_p
x(5)=-2.460177501658637_p
w(5)=2.907962796737636_p
x(6)=5.496180700399834e-1_p
w(6)=1.103897077871685_p
x(7)=4.032775894736060_p
w(7)=7.132746781567743e-2_p
x(8)=8.848499926748769_p
w(8)=8.012285014673564e-4_p
x(9)=15.31652337161774_p
w(9)=1.635223840735665e-6_p
else if(N==10)then
x(1)=-12.70336814917371_p
w(1)=7.575752553792050e-1_p
x(2)=-11.46915012482338_p
w(2)=1.690928323506537_p
x(3)=-9.378230040905613_p
w(3)=2.454318798043053_p
x(4)=-6.649036756100286_p
w(4)=2.946730077216243_p
x(5)=-3.607386832538040_p
w(5)=2.972981159400886_p
x(6)=-6.838341355346301e-1_p
w(6)=1.854402927228967_p
x(7)=2.244008401590007_p
w(7)=3.126221372666473e-1_p
x(8)=6.036695210258692_p
w(8)=1.034621953878877e-2_p
x(9)=10.94023410037635_p
w(9)=9.707280926832218e-5_p
x(10)=16.85311317336821_p
w(10)=2.878761034825314e-7_p
else if(N==11)then
x(1)=-12.74493215922807_p
w(1)=6.519449725202072e-1_p
x(2)=-11.67912352444627_p
w(2)=1.465422259705605_p
x(3)=-9.854939962202614_p
w(3)=2.156565758765503_p
x(4)=-7.429837116866649_p
w(4)=2.653826280264608_p
x(5)=-4.635587473552577_p
w(5)=2.850138210289729_p
x(6)=-1.802689833072239_p
w(6)=2.344292355783502_p
x(7)=8.706006064370732e-1_p
w(7)=8.112747929182138e-1_p
x(8)=3.975513069982342_p
w(8)=6.495373610505706e-2_p
x(9)=7.935655215024597_p
w(9)=1.568394453755013e-3_p
x(10)=12.71528406070156_p
w(10)=1.541493221994336e-5_p
x(11)=17.842781302784_p
w(11)=8.252729846863844e-8_p
else if(N==12)then
x(1)=-12.77838303930461_p
w(1)=5.667970029254209e-1_p
x(2)=-11.84929044268122_p
w(2)=1.280965002766202_p
x(3)=-10.24655949391376_p
w(3)=1.905031688111041_p
x(4)=-8.086365809239144_p
w(4)=2.386542145837079_p
x(5)=-5.538205356770961_p
w(5)=2.659314424881075_p
x(6)=-2.842074027816821_p
w(6)=2.520679845398150_p
x(7)=-2.701095550752886e-1_p
w(7)=1.422311990223399_p
x(8)=2.391717042871218_p
w(8)=2.457351088414597e-1_p
x(9)=5.685289288814416_p
w(9)=1.234863825259334e-2_p
x(10)=9.659442042924478_p
w(10)=2.730969943810781e-4_p
x(11)=14.16054163900884_p
w(11)=3.280521382255918e-6_p
x(12)=18.46848916814251_p
w(12)=3.351351620035514e-8_p
else if(N==13)then
x(1)=-12.80568373060879_p
w(1)=4.972175731452486e-1_p
x(2)=-11.98892181288306_p
w(2)=1.128528803870722_p
x(3)=-10.57126539240927_p
w(3)=1.692124506571402_p
x(4)=-8.640195975336901_p
w(4)=2.148541699932083_p
x(5)=-6.322683122249567_p
w(5)=2.452946496200522_p
x(6)=-3.794430598262941_p
w(6)=2.501491946764733_p
x(7)=-1.292443874333250_p
w(7)=1.899819865329514_p
x(8)=1.128423869249380_p
w(8)=6.168094483490779e-1_p
x(9)=3.923153173494498_p
w(9)=6.000914152382695e-2_p
x(10)=7.303289122286613_p
w(10)=2.454919846790844e-3_p
x(11)=11.17607446083303_p
w(11)=5.692009359952379e-5_p
x(12)=15.3040347791311_p
w(12)=9.194897147687900e-7_p
x(13)=18.87163631010171_p
w(13)=1.714846394256816e-8_p
else if(N==14)then
x(1)=-12.82824626551933_p
w(1)=4.396573041119518e-1_p
x(2)=-12.10481211929693_p
w(2)=1.001305714207424_p
x(3)=-10.84296466812574_p
w(3)=1.511148894936065_p
x(4)=-9.109769108297016_p
w(4)=1.938875052040933_p
x(5)=-7.002286724094136_p
w(5)=2.252176989144322_p
x(6)=-4.652202212336259_p
w(6)=2.392876859391742_p
x(7)=-2.241798321038321_p
w(7)=2.141266842012453_p
x(8)=6.688305247102254e-2_p
w(8)=1.108023574380861_p
x(9)=2.507115466875353_p
w(9)=2.001945037333803e-1_p
x(10)=5.420049286275702_p
w(10)=1.391933708663252e-2_p
x(11)=8.788567765573626_p
w(11)=5.424769508341165e-4_p
x(12)=12.47964926882538_p
w(12)=1.437329869373904e-5_p
x(13)=16.19421526981019_p
w(13)=3.267494859967686e-7_p
x(14)=19.14025181048653_p
w(14)=1.022092200704034e-8_p
else if(N==15)then
x(1)=-12.84710309144624_p
w(1)=3.915127208521686e-1_p
x(2)=-12.2020002024203_p
w(2)=8.941401735949417e-1_p
x(3)=-11.07229917173214_p
w(3)=1.356505269028319_p
x(4)=-9.510235064365185_p
w(4)=1.754915426159676_p
x(5)=-7.591300076134945_p
w(5)=2.065108187006615_p
x(6)=-5.416494012712244_p
w(6)=2.250977107313897_p
x(7)=-3.123030519161646_p
w(7)=2.198031106015819_p
x(8)=-8.794026741785702e-1_p
w(8)=1.546984598868107_p
x(9)=1.341984075809548_p
w(9)=4.825191186972377e-1_p
x(10)=3.879893532883897_p
w(10)=5.580159415229290e-2_p
x(11)=6.837457037990129_p
w(11)=3.365668049562044e-3_p
x(12)=10.12291880333111_p
w(12)=1.367699558220522e-4_p
x(13)=13.58162035974935_p
w(13)=4.370913339473071e-6_p
x(14)=16.88336932611678_p
w(14)=1.409039953916975e-7_p
x(15)=19.32580413559912_p
w(15)=6.753905974262845e-9_p
else if(N==16)then
x(1)=-12.86302145785302_p
w(1)=3.508442571267198e-1_p
x(2)=-12.28427226314875_p
w(2)=8.030962123554579e-1_p
x(3)=-11.26745708387647_p
w(3)=1.223615191543145_p
x(4)=-9.853838370256977_p
w(4)=1.593600897781237_p
x(5)=-8.103019241045379_p
w(5)=1.894299033227837_p
x(6)=-6.093999983802430_p
w(6)=2.101267181455988_p
x(7)=-3.931416129504010_p
w(7)=2.153031743058926_p
x(8)=-1.755523841899364_p
w(8)=1.820274786503134_p
x(9)=3.491606588058133e-1_p
w(9)=8.764513775598645e-1_p
x(10)=2.600786717694320_p
w(10)=1.674951353104655e-1_p
x(11)=5.213585199828131_p
w(11)=1.509993642842122e-2_p
x(12)=8.149538039482520_p
w(12)=8.851988758004003e-4_p
x(13)=11.30304504500413_p
w(13)=3.965687635101285e-5_p
x(14)=14.50329291780375_p
w(14)=1.574561987730521e-6_p
x(15)=17.41809986432078_p
w(15)=7.080351310725565e-8_p
x(16)=19.45836859719585_p
w(16)=4.796850765087895e-9_p
else if(N==17)then
x(1)=-12.87658050457998_p
w(1)=3.161849463150523e-1_p
x(2)=-12.35451158607544_p
w(2)=7.251390261601489e-1_p
x(3)=-11.43479015818615_p
w(3)=1.108767176667971_p
x(4)=-10.15042531452172_p
w(4)=1.451951729318500_p
x(5)=-8.549099839164692_p
w(5)=1.739883291829077_p
x(6)=-6.693625246893774_p
w(6)=1.954904277886350_p
x(7)=-4.665447064985308_p
w(7)=2.061503334841564_p
x(8)=-2.574103007117694_p
w(8)=1.931700662516634_p
x(9)=-5.352709706924784e-1_p
w(9)=1.266369997926027_p
x(10)=1.521906483532664_p
w(10)=3.869512584382400e-1_p
x(11)=3.844309614002263_p
w(11)=5.213207544722592e-2_p
x(12)=6.478274551081279_p
w(12)=4.242731527056940e-3_p
x(13)=9.344965492173870_p
w(13)=2.578590318693605e-4_p
x(14)=12.33516790460222_p
w(14)=1.318880364700135e-5_p
x(15)=15.26985828186274_p
w(15)=6.578842067841021e-7_p
x(16)=17.8360054995664_p
w(16)=4.008245565924392e-8_p
x(17)=19.55594424240348_p
w(17)=3.589671234680578e-9_p
else
call GD(-13)
end if
end subroutine GF_m13

! [-12kT;20kT]
subroutine GF_m12(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-9.200741325402063_p
w(1)=6.602046403078735_p
x(2)=-1.780566203262795_p
w(2)=5.397959739053588_p
else if(N==3)then
x(1)=-10.38632416862712_p
w(1)=3.970893262217781_p
x(2)=-4.914387949617676_p
w(2)=6.097467654446303_p
x(3)=4.416755014824907e-1_p
w(3)=1.931645225468239_p
else if(N==4)then
x(1)=-10.92566010439014_p
w(1)=2.688002300596429_p
x(2)=-6.926436889574820_p
w(2)=4.948488274777034_p
x(3)=-1.949960636877234_p
w(3)=3.966983907637220_p
x(4)=2.582159135804822_p
w(4)=3.965316591216407e-1_p
else if(N==5)then
x(1)=-11.21786976993764_p
w(1)=1.973109433332580_p
x(2)=-8.171859375381368_p
w(2)=3.936647409879150_p
x(3)=-3.837061367992930_p
w(3)=4.326309301375190_p
x(4)=1.990813247573482e-1_p
w(4)=1.723688961947849_p
x(5)=5.113604140036883_p
w(5)=4.025103559755498e-2_p
else if(N==6)then
x(1)=-11.39614819011027_p
w(1)=1.530569099872184_p
x(2)=-8.983566487614675_p
w(2)=3.191132441459507_p
x(3)=-5.298190030404834_p
w(3)=3.976611973433673_p
x(4)=-1.419496279523881_p
w(4)=2.894693236691720_p
x(5)=2.255376298762285_p
w(5)=4.043470514450175e-1_p
x(6)=7.953100704399126_p
w(6)=2.652339230222617e-3_p
else if(N==7)then
x(1)=-11.51510910697427_p
w(1)=1.232706235884138_p
x(2)=-9.546521791665501_p
w(2)=2.640829433985591_p
x(3)=-6.410295792689592_p
w(3)=3.512031808269645_p
x(4)=-2.796067124330552_p
w(4)=3.339602096888417_p
x(5)=5.441882187832536e-1_p
w(5)=1.223440030271044_p
x(6)=4.562762643100718_p
w(6)=5.124462528870882e-2_p
x(7)=10.87695290006233_p
w(7)=1.519115447792877e-4_p
else if(N==8)then
x(1)=-11.60046026872764_p
w(1)=1.017775702742123_p
x(2)=-9.960729811152305_p
w(2)=2.220348876152850_p
x(3)=-7.275661867006554_p
w(3)=3.073058310530844_p
x(4)=-3.996984819573969_p
w(4)=3.305909375097487_p
x(5)=-7.715936040901930e-1_p
w(5)=2.087874329734200_p
x(6)=2.468882296778754_p
w(6)=2.900588529240975e-1_p
x(7)=6.991056574357545_p
w(7)=4.970379363418677e-3_p
x(8)=13.55752490101336_p
w(8)=1.031558730441016e-5_p
else if(N==9)then
x(1)=-11.66491161379519_p
w(1)=8.548254902424313e-1_p
x(2)=-10.27904378124333_p
w(2)=1.888994980647389_p
x(3)=-7.965789113983571_p
w(3)=2.685773206423581_p
x(4)=-5.031609512097860_p
w(4)=3.084119412644471_p
x(5)=-1.942948198023356_p
w(5)=2.608682274824281_p
x(6)=9.672362838462248e-1_p
w(6)=8.313623048756434e-1_p
x(7)=4.491881484872827_p
w(7)=4.574404722180978e-2_p
x(8)=9.306363852280032_p
w(8)=5.033035256637982e-4_p
x(9)=15.65827969871621_p
w(9)=1.121727054303881e-6_p
else if(N==10)then
x(1)=-11.71505468442229_p
w(1)=7.276839875170226e-1_p
x(2)=-10.52983759043055_p
w(2)=1.623306555747522_p
x(3)=-8.523761200256844_p
w(3)=2.352697467559780_p
x(4)=-5.911394210840356_p
w(4)=2.810671036212589_p
x(5)=-3.018351092026578_p
w(5)=2.755384745606303_p
x(6)=-2.382339139077151e-1_p
w(6)=1.513078443131616_p
x(7)=2.686781797148830_p
w(7)=2.106181129748726e-1_p
x(8)=6.499476300914306_p
w(8)=6.502600766398600e-3_p
x(9)=11.35637050050971_p
w(9)=6.297742768724385e-5_p
x(10)=17.09197610128963_p
w(10)=2.151885329923319e-7_p
else if(N==11)then
x(1)=-11.75481886284342_p
w(1)=6.266428466409337e-1_p
x(2)=-10.7305859814106_p
w(2)=1.407918446374603_p
x(3)=-8.978814247694910_p
w(3)=2.069636442072234_p
x(4)=-6.653904524433391_p
w(4)=2.538757070654898_p
x(5)=-3.986852691768322_p
w(5)=2.686219994733766_p
x(6)=-1.301667075782772_p
w(6)=2.040623848028690_p
x(7)=1.306459730750640_p
w(7)=5.878264389819963e-1_p
x(8)=4.436739037862812_p
w(8)=4.137501506190332e-2_p
x(9)=8.379724930125082_p
w(9)=9.955012853061307e-4_p
x(10)=13.07654032546324_p
w(10)=1.047218734824466e-5_p
x(11)=18.00341448822024_p
w(11)=6.611064391977287e-8_p
else if(N==12)then
x(1)=-11.78684835465174_p
w(1)=5.451230219815008e-1_p
x(2)=-10.89343472668176_p
w(2)=1.231530968929023_p
x(3)=-9.353134047834494_p
w(3)=1.829927161193324_p
x(4)=-7.279723967250859_p
w(4)=2.287438247801259_p
x(5)=-4.841413906537706_p
w(5)=2.527820569058335_p
x(6)=-2.279207426383356_p
w(6)=2.291900105621315_p
x(7)=1.825824405517033e-1_p
w(7)=1.116066524324004_p
x(8)=2.846296716409024_p
w(8)=1.622469614088391e-1_p
x(9)=6.143639332846568_p
w(9)=7.772375319741458e-3_p
x(10)=10.07115876502858_p
w(10)=1.778344942764158e-4_p
x(11)=14.46386887190238_p
w(11)=2.343810819169569e-6_p
x(12)=18.57741417668256_p
w(12)=2.818988639700766e-8_p
else if(N==13)then
x(1)=-11.81300950439668_p
w(1)=4.784547441671408e-1_p
x(2)=-11.02717864317295_p
w(2)=1.085613930386347_p
x(3)=-9.663845766881485_p
w(3)=1.626652153475459_p
x(4)=-7.808606986377337_p
w(4)=2.062121517414353_p
x(5)=-5.586999608780451_p
w(5)=2.342487680484467_p
x(6)=-3.176054220927218_p
w(6)=2.332062225564540_p
x(7)=-7.990648028421968e-1_p
w(7)=1.600066499460647_p
x(8)=1.579104587463202_p
w(8)=4.329527972304315e-1_p
x(9)=4.387089008042649_p
w(9)=3.799409570168471e-2_p
x(10)=7.743427927699648_p
w(10)=1.561451321011500e-3_p
x(11)=11.54812536520777_p
w(11)=3.834269713998430e-5_p
x(12)=15.55344306664251_p
w(12)=6.893177123510029e-7_p
x(13)=18.94765551828359_p
w(13)=1.491138884430195e-8_p
else if(N==14)then
x(1)=-11.83464573577167_p
w(1)=4.232624263102555e-1_p
x(2)=-11.13827009980947_p
w(2)=9.637220510192027e-1_p
x(3)=-9.924088043290633_p
w(3)=1.453610439355671_p
x(4)=-8.257672941617338_p
w(4)=1.862799396931193_p
x(5)=-6.234713560987522_p
w(5)=2.156721228887154_p
x(6)=-3.987394474094117_p
w(6)=2.260943521596661_p
x(7)=-1.696938310126135_p
w(7)=1.901189299095971_p
x(8)=5.282350542930473e-1_p
w(8)=8.384800147958034e-1_p
x(9)=2.970426000694204_p
w(9)=1.301624742278175e-1_p
x(10)=5.877389713872519_p
w(10)=8.752288611002029e-3_p
x(11)=9.201341131929858_p
w(11)=3.526875004994071e-4_p
x(12)=12.8095838550182_p
w(12)=1.004917796201471e-5_p
x(13)=16.39730948117019_p
w(13)=2.555309077313632e-7_p
x(14)=19.1951360562631_p
w(14)=9.092224195295241e-9_p
else if(N==15)then
x(1)=-11.85274002596973_p
w(1)=3.770681683724624e-1_p
x(2)=-11.2314991031288_p
w(2)=8.609663823088035e-1_p
x(3)=-10.14393652424361_p
w(3)=1.305570036700274_p
x(4)=-8.641097026869852_p
w(4)=1.687425244475581_p
x(5)=-6.797241530087372_p
w(5)=1.981162548267712_p
x(6)=-4.713242187776893_p
w(6)=2.142455414272585_p
x(7)=-2.527937602701172_p
w(7)=2.018405532752773_p
x(8)=-3.884448189751040e-1_p
w(8)=1.259480772424212_p
x(9)=1.804262854089359_p
w(9)=3.300918006620422e-1_p
x(10)=4.346432165637593_p
w(10)=3.514642960286168e-2_p
x(11)=7.277117175122985_p
w(11)=2.139094000386408e-3_p
x(12)=10.50347292264188_p
w(12)=9.142675341426979e-5_p
x(13)=13.87048094670436_p
w(13)=3.171278380460765e-6_p
x(14)=17.04856943512317_p
w(14)=1.141558135301797e-7_p
x(15)=19.36673658386024_p
w(15)=6.105022595481824e-9_p
else if(N==16)then
x(1)=-11.86802349303977_p
w(1)=3.380242667090972e-1_p
x(2)=-11.31046890012152_p
w(2)=7.736085849324295e-1_p
x(3)=-10.33115878367123_p
w(3)=1.178228430285195_p
x(4)=-8.970397190712978_p
w(4)=1.533328434174018_p
x(5)=-7.286716312113432_p
w(5)=1.819615223362018_p
x(6)=-5.358658137630911_p
w(6)=2.008393974773542_p
x(7)=-3.292260701133031_p
w(7)=2.016009887433685_p
x(8)=-1.222698493971586_p
w(8)=1.573016552302501_p
x(9)=8.190082694684622e-1_p
w(9)=6.420874535147413e-1_p
x(10)=3.070591674814139_p
w(10)=1.076138299775435e-1_p
x(11)=5.671279580330624_p
w(11)=9.477229750254081e-3_p
x(12)=8.564980475202345_p
w(12)=5.737029885919055e-4_p
x(13)=11.64956722424705_p
w(13)=2.732573820020561e-5_p
x(14)=14.75426831906763_p
w(14)=1.182767342102162e-6_p
x(15)=17.55309291504484_p
w(15)=5.903659936871116e-8_p
x(16)=19.48978986085121_p
w(16)=4.386565392497800e-9_p
else if(N==17)then
x(1)=-11.88104849105887_p
w(1)=3.047319423010876e-1_p
x(2)=-11.37792642902242_p
w(2)=6.987620886080337e-1_p
x(3)=-10.49179050398891_p
w(3)=1.068083550804505_p
x(4)=-9.254871105475706_p
w(4)=1.397809517281416_p
x(5)=-7.713932811428994_p
w(5)=1.672880868038927_p
x(6)=-5.931192465724531_p
w(6)=1.873370712061887_p
x(7)=-3.988844131682687_p
w(7)=1.951667351976574_p
x(8)=-1.996852736646050_p
w(8)=1.740468185748965_p
x(9)=-4.364877154765702e-2_p
w(9)=9.973820263207309e-1_p
x(10)=1.993152208422513_p
w(10)=2.592876717014286e-1_p
x(11)=4.313180998664268_p
w(11)=3.268960732280947e-2_p
x(12)=6.918868265084193_p
w(12)=2.691517381700996e-3_p
x(13)=9.732731439432307_p
w(13)=1.711846990285758e-4_p
x(14)=12.64796589865819_p
w(14)=9.370483882805842e-6_p
x(15)=15.48716293840319_p
w(15)=5.098865652519059e-7_p
x(16)=17.94718190319077_p
w(16)=3.420362973924751e-8_p
x(17)=19.58067435567178_p
w(17)=3.311151524105424e-9_p
else
call GD(-12)
end if
end subroutine GF_m12

! [-11kT;20kT]
subroutine GF_m11(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-8.395770813453943_p
w(1)=6.137601686236605_p
x(2)=-1.506529013535173_p
w(2)=4.862415013263560_p
else if(N==3)then
x(1)=-9.486304946888474_p
w(1)=3.723461836239651_p
x(2)=-4.368241284651463_p
w(2)=5.649030870176421_p
x(3)=7.022679307101610e-1_p
w(3)=1.627523993084093_p
else if(N==4)then
x(1)=-9.985610353871801_p
w(1)=2.537317487398513_p
x(2)=-6.216289563815995_p
w(2)=4.648318815201158_p
x(3)=-1.557092227453081_p
w(3)=3.520619819112285_p
x(4)=2.922866236277457_p
w(4)=2.937605777882092e-1_p
else if(N==5)then
x(1)=-10.2576877686292_p
w(1)=1.872253287814218_p
x(2)=-7.370446362312767_p
w(2)=3.724724894109440_p
x(3)=-3.286059395124210_p
w(3)=3.990320327503141_p
x(4)=5.538146393274360e-1_p
w(4)=1.386129861823630_p
x(5)=5.542992106407241_p
w(5)=2.658832824973530e-2_p
else if(N==6)then
x(1)=-10.42461490615925_p
w(1)=1.458154804690207_p
x(2)=-8.128037714717264_p
w(2)=3.034057596597517_p
x(3)=-4.633979063746035_p
w(3)=3.736052262073579_p
x(4)=-9.839512114967908e-1_p
w(4)=2.487847944260798_p
x(5)=2.668552107943582_p
w(5)=2.822636054961459e-1_p
x(6)=8.439151939343079_p
w(6)=1.640486381918211e-3_p
else if(N==7)then
x(1)=-10.53671184504037_p
w(1)=1.177613704698216_p
x(2)=-8.657290979277965_p
w(2)=2.519029720032802_p
x(3)=-5.671478764207510_p
w(3)=3.328151428506683_p
x(4)=-2.259660131609442_p
w(4)=3.015440159290214_p
x(5)=9.555585699591013e-1_p
w(5)=9.272992151654632e-1_p
x(6)=5.037181000379899_p
w(6)=3.239023781573763e-2_p
x(7)=11.37328276559092_p
w(7)=9.223399105023975e-5_p
else if(N==8)then
x(1)=-10.61763734700873_p
w(1)=9.739021511843163e-1_p
x(2)=-9.049360962971134_p
w(2)=2.122216459435057_p
x(3)=-6.486443779974810_p
w(3)=2.925322955454309_p
x(4)=-3.376226840404537_p
w(4)=3.071106818334557_p
x(5)=-3.234913389693414e-1_p
w(5)=1.711229056765106_p
x(6)=2.921302585405625_p
w(6)=1.931858496051453e-1_p
x(7)=7.481251828425338_p
w(7)=3.046879524154085e-3_p
x(8)=13.99606242456523_p
w(8)=6.529197519951584e-6_p
else if(N==9)then
x(1)=-10.67898101293347_p
w(1)=8.188531202314795e-1_p
x(2)=-9.351941090883225_p
w(2)=1.807912487096766_p
x(3)=-7.140157093171188_p
w(3)=2.563485622744644_p
x(4)=-4.346517348042249_p
w(4)=2.906177345790103_p
x(5)=-1.429631559942011_p
w(5)=2.276497265832611_p
x(6)=1.406815324581661_p
w(6)=5.981911610545557e-1_p
x(7)=4.971678411410148_p
w(7)=2.858624466683331e-2_p
x(8)=9.772881207766293_p
w(8)=3.126789580289524e-4_p
x(9)=15.99030679213564_p
w(9)=7.731251442009827e-7_p
else if(N==10)then
x(1)=-10.72679125212109_p
w(1)=6.976544628221484e-1_p
x(2)=-9.590828905729163_p
w(2)=1.555240557318506_p
x(3)=-7.670283275978863_p
w(3)=2.249670743295798_p
x(4)=-5.176651635028157_p
w(4)=2.667921789322297_p
x(5)=-2.435379135330747_p
w(5)=2.507132987600686_p
x(6)=2.174505492832257e-1_p
w(6)=1.181599112794142_p
x(7)=3.153819546567332_p
w(7)=1.367359102055055e-1_p
x(8)=6.975860319499843_p
w(8)=4.020327839994600e-3_p
x(9)=11.7750434430808_p
w(9)=4.064640152741211e-5_p
x(10)=17.32007621541783_p
w(10)=1.618995582546013e-7_p
else if(N==11)then
x(1)=-10.76474664585624_p
w(1)=6.012275850704497e-1_p
x(2)=-9.782293165863258_p
w(2)=1.350066781670043_p
x(3)=-8.103454256325881_p
w(3)=1.981721682214760_p
x(4)=-5.880081445339471_p
w(4)=2.419778294594614_p
x(5)=-3.343356896403592_p
w(5)=2.502548668919738_p
x(6)=-8.011855856633090e-1_p
w(6)=1.711937108674780_p
x(7)=1.764821715044844_p
w(7)=4.063629481664193e-1_p
x(8)=4.916061567228953_p
w(8)=2.574115751838173e-2_p
x(9)=8.831906104263373_p
w(9)=6.253132385379265e-4_p
x(10)=13.43616879414741_p
w(10)=7.106203337898397e-6_p
x(11)=18.1558205364365_p
w(11)=5.322910275776076e-8_p
else if(N==12)then
x(1)=-10.79534801937605_p
w(1)=5.233547095059782e-1_p
x(2)=-9.937780352122667_p
w(2)=1.181817329105819_p
x(3)=-8.460317508146845_p
w(3)=1.754096880838796_p
x(4)=-6.474668420900128_p
w(4)=2.185883577517822_p
x(5)=-4.148614692267356_p
w(5)=2.384778535738501_p
x(6)=-1.721613779388306_p
w(6)=2.028349109383685_p
x(7)=6.490328313423083e-1_p
w(7)=8.333114165820783e-1_p
x(8)=3.322755729623237_p
w(8)=1.034900689266117e-1_p
x(9)=6.614188967358097_p
w(9)=4.818280801844672e-3_p
x(10)=10.48678160491774_p
w(10)=1.150907542652704e-4_p
x(11)=14.76330130153131_p
w(11)=1.676555762400546e-6_p
x(12)=18.68075420775871_p
w(12)=2.378900204273255e-8_p
else if(N==13)then
x(1)=-10.82036442802406_p
w(1)=4.596120536128287e-1_p
x(2)=-10.06560401227198_p
w(2)=1.042469487022442_p
x(3)=-8.756921722309670_p
w(3)=1.560624365311174_p
x(4)=-6.978248823701669_p
w(4)=1.974062640515688_p
x(5)=-4.854305370930364_p
w(5)=2.225234662214433_p
x(6)=-2.563494772120569_p
w(6)=2.135364742687776_p
x(7)=-3.023934046396440e-1_p
w(7)=1.287973584535053_p
x(8)=2.051738562318661_p
w(8)=2.901295849497158e-1_p
x(9)=4.867191190202978_p
w(9)=2.353607399095056e-2_p
x(10)=8.191319179075448_p
w(10)=9.832251021721502e-4_p
x(11)=11.92103536184377_p
w(11)=2.574868425093158e-5_p
x(12)=15.79817410517606_p
w(12)=5.178838611497249e-7_p
x(13)=19.01997806540654_p
w(13)=1.298981882923863e-8_p
else if(N==14)then
x(1)=-10.84107019035443_p
w(1)=4.067992239151113e-1_p
x(2)=-10.17187090215506_p
w(2)=9.259469003536280e-1_p
x(3)=-9.005621832259759_p
w(3)=1.395634189660970_p
x(4)=-7.406556661533095_p
w(4)=1.785567158730956_p
x(5)=-5.469411599571014_p
w(5)=2.057092581313706_p
x(6)=-3.327501389955961_p
w(6)=2.111357539031582_p
x(7)=-1.155431410708700_p
w(7)=1.628243703729814_p
x(8)=1.005633727703521_p
w(8)=6.017593491786768e-1_p
x(9)=3.453490913732422_p
w(9)=8.195569254799762e-2_p
x(10)=6.345872819206938_p
w(10)=5.425328728886540e-3_p
x(11)=9.618540447909462_p
w(11)=2.278053339147026e-4_p
x(12)=13.13837612563566_p
w(12)=7.018585266094309e-6_p
x(13)=16.59583804179499_p
w(13)=2.002945630094046e-7_p
x(14)=19.24754483859615_p
w(14)=8.095091892609290e-9_p
else if(N==15)then
x(1)=-10.85839853802782_p
w(1)=3.625646847922260e-1_p
x(2)=-10.26112019413763_p
w(2)=8.276308638924222e-1_p
x(3)=-9.215918439171890_p
w(3)=1.254281669661753_p
x(4)=-7.772755513592232_p
w(4)=1.619082148390656_p
x(5)=-6.004947905396373_p
w(5)=1.894516700221679_p
x(6)=-4.013847712911351_p
w(6)=2.023071850190381_p
x(7)=-1.938422721904421_p
w(7)=1.806303011322118_p
x(8)=1.093529974443582e-1_p
w(8)=9.734969176365120e-1_p
x(9)=2.287391290222080_p
w(9)=2.159692743151847e-1_p
x(10)=4.827589704641907_p
w(10)=2.168994607531931e-2_p
x(11)=7.724190587331059_p
w(11)=1.346361358284519e-3_p
x(12)=10.88600860973151_p
w(12)=6.087212827861887e-5_p
x(13)=14.15704947486519_p
w(13)=2.301324443355055e-6_p
x(14)=17.20972103962333_p
w(14)=9.267122107273977e-8_p
x(15)=19.40596979303705_p
w(15)=5.519686052638443e-9_p
else if(N==16)then
x(1)=-10.87304428515616_p
w(1)=3.251530931701422e-1_p
x(2)=-10.33677092255591_p
w(2)=7.439829365835928e-1_p
x(3)=-9.395153051589677_p
w(3)=1.132551469383218_p
x(4)=-8.087614632830629_p
w(4)=1.472404394615770_p
x(5)=-6.471816035724812_p
w(5)=1.743093743209031_p
x(6)=-4.626308063940087_p
w(6)=1.908778820836778_p
x(7)=-2.658550681147112_p
w(7)=1.855041885167708_p
x(8)=-6.906042547919797e-1_p
w(8)=1.300030084053463_p
x(9)=1.306054811250844_p
w(9)=4.456198689712411e-1_p
x(10)=3.558312895661544_p
w(10)=6.710316749967368e-2_p
x(11)=6.139275708611559_p
w(11)=5.868161422555276e-3_p
x(12)=8.985067931761360_p
w(12)=3.693448591221416e-4_p
x(13)=11.99634961693991_p
w(13)=1.878721653254202e-5_p
x(14)=15.00241904103259_p
w(14)=8.891981269757076e-7_p
x(15)=17.68466510774918_p
w(15)=4.930264419097778e-8_p
x(16)=19.52001173650427_p
w(16)=4.010565452963950e-9_p
else if(N==17)then
x(1)=-10.88553287832535_p
w(1)=2.932342075708025e-1_p
x(2)=-10.40143281086022_p
w(2)=6.722663008608207e-1_p
x(3)=-9.549041679049481_p
w(3)=1.027157756196641_p
x(4)=-8.359869283534083_p
w(4)=1.343155144702666_p
x(5)=-6.879903117775918_p
w(5)=1.604570424929765_p
x(6)=-5.171103097851907_p
w(6)=1.787514983533790_p
x(7)=-3.316824399276278_p
w(7)=1.825998108333120_p
x(8)=-1.424122713714933_p
w(8)=1.515371062800291_p
x(9)=4.576869932535265e-1_p
w(9)=7.422799988881250e-1_p
x(10)=2.483932667389938_p
w(10)=1.665487820072506e-1_p
x(11)=4.795404819084077_p
w(11)=2.010833608730928e-2_p
x(12)=7.366565683983146_p
w(12)=1.691380449459665e-3_p
x(13)=10.12308496649293_p
w(13)=1.131343702123598e-4_p
x(14)=12.95988260548811_p
w(14)=6.650889812847314e-6_p
x(15)=15.70151062103114_p
w(15)=3.956074835996946e-7_p
x(16)=18.05553448392845_p
w(16)=2.921984209904943e-8_p
x(17)=19.604534697857_p
w(17)=3.052772238967954e-9_p
else
call GD(-11)
end if
end subroutine GF_m11

! [-10kT;20kT]
subroutine GF_m10(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-7.589291732010103_p
w(1)=5.675311630917914_p
x(2)=-1.221802315179583_p
w(2)=4.324733765920149_p
else if(N==3)then
x(1)=-8.585498676928687_p
w(1)=3.477521278533976_p
x(2)=-3.820537380418453_p
w(2)=5.186810428173626_p
x(3)=9.860586941016460e-1_p
w(3)=1.335713690130462_p
else if(N==4)then
x(1)=-9.045179384751814_p
w(1)=2.387378970075148_p
x(2)=-5.505563387661283_p
w(2)=4.342717728253810_p
x(3)=-1.157949218995689_p
w(3)=3.060178344748263_p
x(4)=3.295720860392943_p
w(4)=2.097703537608435e-1_p
else if(N==5)then
x(1)=-9.297342793203605_p
w(1)=1.771690193504575_p
x(2)=-6.568891340060641_p
w(2)=3.510434416124677_p
x(3)=-2.736957949520165_p
w(3)=3.627082932062207_p
x(4)=9.323512849149416e-1_p
w(4)=1.073828270344980_p
x(5)=6.002275863401147_p
w(5)=1.700958480162427e-2_p
else if(N==6)then
x(1)=-9.453053256720825_p
w(1)=1.385737234197770_p
x(2)=-7.272742816190305_p
w(2)=2.875479475407540_p
x(3)=-3.972597318249562_p
w(3)=3.478621033421440_p
x(4)=-5.417087530915958e-1_p
w(4)=2.070313444512388_p
x(5)=3.114364832997058_p
w(5)=1.889048187567273e-1_p
x(6)=8.949131953028953_p
w(6)=9.893905421979857e-4_p
else if(N==7)then
x(1)=-9.558372410208580_p
w(1)=1.122323142985300_p
x(2)=-7.768577257159650_p
w(2)=2.395970139518840_p
x(3)=-4.935332826327664_p
w(3)=3.135014112747289_p
x(4)=-1.727137824114400_p
w(4)=2.655972392142699_p
x(5)=1.392524111103397_p
w(5)=6.708351508836242e-1_p
x(6)=5.537282502541991_p
w(6)=1.987528328176080e-2_p
x(7)=11.88203319876427_p
w(7)=5.517527854937248e-5_p
else if(N==8)then
x(1)=-9.634902050034958_p
w(1)=9.297690071788082e-1_p
x(2)=-8.138578611705816_p
w(2)=2.023020089420019_p
x(3)=-5.699494963850885_p
w(3)=2.772213240615140_p
x(4)=-2.761555494330091_p
w(4)=2.806424096896104_p
x(5)=1.355215892025068e-1_p
w(5)=1.343097033906912_p
x(6)=3.401916927883148_p
w(6)=1.236841953398337e-1_p
x(7)=7.987382576335993_p
w(7)=1.833608296983040e-3_p
x(8)=14.43179395767679_p
w(8)=4.125184263382057e-6_p
else if(N==9)then
x(1)=-9.693130874784098_p
w(1)=7.826483228864770e-1_p
x(2)=-8.425342318601782_p
w(2)=1.726002024469871_p
x(3)=-6.316275705264057_p
w(3)=2.437883270621511_p
x(4)=-3.666532634879946_p
w(4)=2.709819993214697_p
x(5)=-9.173753335588440e-1_p
w(5)=1.916191495633630_p
x(6)=1.872320768515649_p
w(6)=4.098813357670217e-1_p
x(7)=5.471665741962838_p
w(7)=1.742616278553446e-2_p
x(8)=10.24712238491548_p
w(8)=1.922554944479056e-4_p
x(9)=16.31120050317988_p
w(9)=5.359648730220045e-7_p
else if(N==10)then
x(1)=-9.738593806037896_p
w(1)=6.674353813569719e-1_p
x(2)=-8.652222268066222_p
w(2)=1.486543171717188_p
x(3)=-6.818126380434363_p
w(3)=2.144477018907607_p
x(4)=-4.445704949844794_p
w(4)=2.514505180003534_p
x(5)=-1.858235796392003_p
w(5)=2.221967562859337_p
x(6)=6.891095990308351e-1_p
w(6)=8.769713750129243e-1_p
x(7)=3.645337407729202_p
w(7)=8.567265069228566e-2_p
x(8)=7.465207676002463_p
w(8)=2.446816251553419e-3_p
x(9)=12.19529453706253_p
w(9)=2.611741014472232e-5_p
x(10)=17.53711900153056_p
w(10)=1.226265175475490e-7_p
else if(N==11)then
x(1)=-9.774728603397543_p
w(1)=5.756570947319515e-1_p
x(2)=-8.834323980985243_p
w(2)=1.291722805532966_p
x(3)=-7.229114065521910_p
w(3)=1.892306052813502_p
x(4)=-5.109062456165782_p
w(4)=2.294450208149888_p
x(5)=-2.705964523922639_p
w(5)=2.290792741997199_p
x(6)=-2.966548076567191e-1_p
w(6)=1.371245640608630_p
x(7)=2.248344888749461_p
w(7)=2.678139691812029e-1_p
x(8)=5.412807385602179_p
w(8)=1.566308963289977e-2_p
x(9)=9.291511898193029_p
w(9)=3.889315397268639e-4_p
x(10)=13.79336309358158_p
w(10)=4.819580177830810e-6_p
x(11)=18.30011499723298_p
w(11)=4.306991899613573e-8_p
else if(N==12)then
x(1)=-9.803892952723961_p
w(1)=5.014569554586406e-1_p
x(2)=-8.982391955954855_p
w(2)=1.131709465427239_p
x(3)=-7.568310501444850_p
w(3)=1.677174382521835_p
x(4)=-5.671732217463602_p
w(4)=2.080342693201396_p
x(5)=-3.460847395703675_p
w(5)=2.223778593294252_p
x(6)=-1.167495789197888_p
w(6)=1.729669886263247_p
x(7)=1.134578212771495_p
w(7)=5.889722972004393e-1_p
x(8)=3.820809305968885_p
w(8)=6.392157193250712e-2_p
x(9)=7.096271509381735_p
w(9)=2.944263675883942e-3_p
x(10)=10.90563409666608_p
w(10)=7.406655111911368e-5_p
x(11)=15.05828091738807_p
w(11)=1.201175231417579e-6_p
x(12)=18.77867744873037_p
w(12)=2.013627228959274e-8_p
else if(N==13)then
x(1)=-9.827757682701696_p
w(1)=4.406599241599753e-1_p
x(2)=-9.104251501772001_p
w(2)=9.990027184210537e-1_p
x(3)=-7.850654666332148_p
w(3)=1.493770027020673_p
x(4)=-6.149535004405003_p
w(4)=1.883357770528045_p
x(5)=-4.125514470290270_p
w(5)=2.096912699707313_p
x(6)=-1.956884121847351_p
w(6)=1.903606776394946_p
x(7)=2.031097150686909e-1_p
w(7)=9.819583882121899e-1_p
x(8)=2.547891821344767_p
w(8)=1.858583520080691e-1_p
x(9)=5.362678849279321_p
w(9)=1.428782097741692e-2_p
x(10)=8.646348693081668_p
w(10)=6.132723701246061e-4_p
x(11)=12.29420836651747_p
w(11)=1.724569260466430e-5_p
x(12)=16.03790066523636_p
w(12)=3.900113207263058e-7_p
x(13)=19.0887344239615_p
w(13)=1.133433149270216e-8_p
else if(N==14)then
x(1)=-9.847527412103609_p
w(1)=3.902425487064471e-1_p
x(2)=-9.205659422312493_p
w(2)=8.879039443981926e-1_p
x(3)=-8.087698001881607_p
w(3)=1.337012932551688_p
x(4)=-6.556746579606898_p
w(4)=1.706488347807298_p
x(5)=-4.707121070382296_p
w(5)=1.950518452882697_p
x(6)=-2.673402709408502_p
w(6)=1.935849079267139_p
x(7)=-6.138936577074455e-1_p
w(7)=1.329958396059746_p
x(8)=1.503423927594341_p
w(8)=4.084878527209578e-1_p
x(9)=3.955725659025188_p
w(9)=5.011425679342152e-2_p
x(10)=6.824817503985116_p
w(10)=3.318270621015599e-3_p
x(11)=10.03960552421645_p
w(11)=1.462519283588685e-4_p
x(12)=13.46554981391895_p
w(12)=4.898518771836724e-6_p
x(13)=16.78963474979552_p
w(13)=1.573700529582569e-7_p
x(14)=19.29756650371917_p
w(14)=7.212275454254559e-9_p
else if(N==15)then
x(1)=-9.864085278177402_p
w(1)=3.479806990541345e-1_p
x(2)=-9.290901470192999_p
w(2)=7.940699209230428e-1_p
x(3)=-8.288354349951188_p
w(3)=1.202477479239207_p
x(4)=-6.905472630600919_p
w(4)=1.549394293696912_p
x(5)=-5.215007638383464_p
w(5)=1.803347536622882_p
x(6)=-3.319311502934922_p
w(6)=1.886466054168800_p
x(7)=-1.353454486766144_p
w(7)=1.557766449413705_p
x(8)=6.196868491163861e-1_p
w(8)=7.089975761453912e-1_p
x(9)=2.792125536423395_p
w(9)=1.355254375258983e-1_p
x(10)=5.322533129492165_p
w(10)=1.313813960417040e-2_p
x(11)=8.178100380221768_p
w(11)=8.396770656136301e-4_p
x(12)=11.27003514561759_p
w(12)=4.038227923136239e-5_p
x(13)=14.44097366594092_p
w(13)=1.670728146894724e-6_p
x(14)=17.36675228822943_p
w(14)=7.538009134110386e-8_p
x(15)=19.44356164113946_p
w(15)=4.990838056132290e-9_p
else if(N==16)then
x(1)=-9.878089560188625_p
w(1)=3.122120834428534e-1_p
x(2)=-9.363210776788664_p
w(2)=7.141654415231283e-1_p
x(3)=-8.459531761772615_p
w(3)=1.086453691770223_p
x(4)=-7.205704720245197_p
w(4)=1.410465679111016_p
x(5)=-5.658787828723046_p
w(5)=1.663501253957279_p
x(6)=-3.897850916121057_p
w(6)=1.797997886075068_p
x(7)=-2.030628816778858_p
w(7)=1.661755695743794_p
x(8)=-1.546530779963948e-1_p
w(8)=1.015976423154707_p
x(9)=1.813563169647237_p
w(9)=2.929429550634643e-1_p
x(10)=4.063190838756555_p
w(10)=4.073642726582500e-2_p
x(11)=6.616888582529393_p
w(11)=3.587955154689269e-3_p
x(12)=9.409300349955751_p
w(12)=2.362985274234193e-4_p
x(13)=12.34298215664566_p
w(13)=1.289200407279168e-5_p
x(14)=15.24749918958455_p
w(14)=6.691431541703986e-7_p
x(15)=17.81279362588974_p
w(15)=4.123577824384438e-8_p
x(16)=19.54907221072372_p
w(16)=3.665587106005877e-9_p
else if(N==17)then
x(1)=-9.890038630687476_p
w(1)=2.816754929842814e-1_p
x(2)=-9.425058666328299_p
w(2)=6.456056865155968e-1_p
x(3)=-8.606621651101589_p
w(3)=9.858829423722065e-1_p
x(4)=-7.465597185060716_p
w(4)=1.287712340693749_p
x(5)=-6.047389450073071_p
w(5)=1.534090217754746_p
x(6)=-4.414111493958568_p
w(6)=1.694333512040863_p
x(7)=-2.650253973813418_p
w(7)=1.676479762419970_p
x(8)=-8.535626093576398e-1_p
w(8)=1.258725846246016_p
x(9)=9.740019150723755e-1_p
w(9)=5.193041708903542e-1_p
x(10)=2.994435092346815_p
w(10)=1.029461364722725e-1_p
x(11)=5.290126851928153_p
w(11)=1.215628420973584e-2_p
x(12)=7.820811490043210_p
w(12)=1.053492961510388e-3_p
x(13)=10.515594144543_p
w(13)=7.445929317380801e-5_p
x(14)=13.27058936637259_p
w(14)=4.716890152635630e-6_p
x(15)=15.91273681924192_p
w(15)=3.072924011099505e-7_p
x(16)=18.16106339288157_p
w(16)=2.498816125683017e-8_p
x(17)=19.62755056984133_p
w(17)=2.812872691085305e-9_p
else
call GD(-10)
end if
end subroutine GF_m10

! [-9kT;20kT]
subroutine GF_m9(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-6.781261007598280_p
w(1)=5.214313933241932_p
x(2)=-9.236271069251561e-1_p
w(2)=3.785809466886638_p
else if(N==3)then
x(1)=-7.683956869931176_p
w(1)=3.232595016685687_p
x(2)=-3.271358172118469_p
w(2)=4.705940062305396_p
x(3)=1.297712245810398_p
w(3)=1.061588321137487_p
else if(N==4)then
x(1)=-8.104435957755598_p
w(1)=2.237840227797133_p
x(2)=-4.794888156976136_p
w(2)=4.027615377949893_p
x(3)=-7.491626801759315e-1_p
w(3)=2.590762282008713_p
x(4)=3.703822670983710_p
w(4)=1.439055123728307e-1_p
else if(N==5)then
x(1)=-8.336902577054209_p
w(1)=1.671143624101328_p
x(2)=-5.767740342975560_p
w(2)=3.291475301194127_p
x(3)=-2.189622151184312_p
w(3)=3.231059636590580_p
x(4)=1.340208766137067_p
w(4)=7.959198512438004e-1_p
x(5)=6.492878059401209_p
w(5)=1.052498699873477e-2_p
else if(N==6)then
x(1)=-8.481527031379439_p
w(1)=1.313083088783916_p
x(2)=-6.418132078077912_p
w(2)=2.713984251239614_p
x(3)=-3.315184368651285_p
w(3)=3.196365374080487_p
x(4)=-8.744178219711947e-2_p
w(4)=1.655069631190718_p
x(5)=3.594744725890299_p
w(5)=1.210393726406693e-1_p
x(6)=9.483199946807362_p
w(6)=5.816821931657303e-4_p
else if(N==7)then
x(1)=-8.580144424159798_p
w(1)=1.066646248955072_p
x(2)=-6.880732929252725_p
w(2)=2.270719861537864_p
x(3)=-4.203003668861545_p
w(3)=2.927084169372894_p
x(4)=-1.196316733378523_p
w(4)=2.262848984140133_p
x(5)=1.859870780199591_p
w(5)=4.609450844414711e-1_p
x(6)=6.062831577354516_p
w(6)=1.184648658750000e-2_p
x(7)=12.40127734164515_p
w(7)=3.256509363432705e-5_p
else if(N==8)then
x(1)=-8.652293191088095_p
w(1)=8.852378375976856e-1_p
x(2)=-7.228632597017931_p
w(2)=1.922138390574304_p
x(3)=-4.915675067802076_p
w(3)=2.610330862868236_p
x(4)=-2.153245397330902_p
w(4)=2.503732428002517_p
x(5)=6.120177201344736e-1_p
w(5)=1.001398170330912_p
x(6)=3.911101875175370_p
w(6)=7.619905255782608e-2_p
x(7)=8.508620952648915_p
w(7)=1.084051521186748e-3_p
x(8)=14.86213137618922_p
w(8)=2.606675902752281e-6_p
else if(N==9)then
x(1)=-8.707389624864607_p
w(1)=7.461074158875417e-1_p
x(2)=-7.499427840474748_p
w(2)=1.642830525819187_p
x(3)=-5.494767023936232_p
w(3)=2.306862882736783_p
x(4)=-2.992724826037195_p
w(4)=2.486336569512105_p
x(5)=-4.013297955522520e-1_p
w(5)=1.540449385905672_p
x(6)=2.366811904614568_p
w(6)=2.670452945905685e-1_p
x(7)=5.991223384078729_p
w(7)=1.037386290172412e-2_p
x(8)=10.72805926928284_p
w(8)=1.170886936219228e-4_p
x(9)=16.61970530139824_p
w(9)=3.740813656404096e-7_p
else if(N==10)then
x(1)=-8.750484845923605_p
w(1)=6.369440732717507e-1_p
x(2)=-7.714157283754879_p
w(2)=1.416894119344241_p
x(3)=-5.967757959341165_p
w(3)=2.035752164994055_p
x(4)=-3.719650513306559_p
w(4)=2.344099249379898_p
x(5)=-1.285215804311708_p
w(5)=1.898202325645848_p
x(6)=1.182785158263967_p
w(6)=6.148380523295576e-1_p
x(7)=4.161049467295089_p
w(7)=5.190968674799223e-2_p
x(8)=7.966815868181119_p
w(8)=1.466914533972475e-3_p
x(9)=12.61610624502617_p
w(9)=1.672036497165794e-5_p
x(10)=17.74293008799595_p
w(10)=9.351628357940051e-8_p
else if(N==11)then
x(1)=-8.784783207141682_p
w(1)=5.498633286364464e-1_p
x(2)=-7.886790557708066_p
w(2)=1.232639865823694_p
x(3)=-6.356155694849083_p
w(3)=1.800459813635659_p
x(4)=-4.341768633372384_p
w(4)=2.158600872241683_p
x(5)=-2.074972602332233_p
w(5)=2.042024309059111_p
x(6)=2.181887799495059e-1_p
w(6)=1.038500556560215_p
x(7)=2.758594793990860_p
w(7)=1.684580041332980e-1_p
x(8)=5.926219831408048_p
w(8)=9.333666631896123e-3_p
x(9)=9.757800401221894_p
w(9)=2.396793703431113e-4_p
x(10)=14.14730624465837_p
w(10)=3.269020355062818e-6_p
x(11)=18.43645951527889_p
w(11)=3.501586978406363e-8_p
else if(N==12)then
x(1)=-8.812498517839252_p
w(1)=4.793729370353292e-1_p
x(2)=-8.027361135152992_p
w(2)=1.081012295136837_p
x(3)=-6.677399140646678_p
w(3)=1.598497716600185_p
x(4)=-4.871649398714381_p
w(4)=1.968079152387203_p
x(5)=-2.779116111889269_p
w(5)=2.035869321026434_p
x(6)=-6.130257950378780e-1_p
w(6)=1.404258358062248_p
x(7)=1.643888400601749_p
w(7)=3.928818084802487e-1_p
x(8)=4.339787303962539_p
w(8)=3.832876988532670e-2_p
x(9)=7.589187058172581_p
w(9)=1.774737918654783e-3_p
x(10)=11.32700472465003_p
w(10)=4.742421576683212e-5_p
x(11)=15.34826862296432_p
w(11)=8.622880631151326e-7_p
x(12)=18.87136470563532_p
w(12)=1.709227328140092e-8_p
else if(N==13)then
x(1)=-8.835202162689333_p
w(1)=4.215503881635509e-1_p
x(2)=-8.143196872318153_p
w(2)=9.550560755236202e-1_p
x(3)=-6.945274658772105_p
w(3)=1.425599955381913_p
x(4)=-5.323045924192617_p
w(4)=1.788168319735871_p
x(5)=-3.401709898509982_p
w(5)=1.950732448996891_p
x(6)=-1.355044093460505_p
w(6)=1.632502456953907_p
x(7)=7.238667060298266e-1_p
w(7)=7.034654764950838e-1_p
x(8)=3.068091937175875_p
w(8)=1.141451771072863e-1_p
x(9)=5.872721330785353_p
w(9)=8.512156259696710e-3_p
x(10)=9.107873913085097_p
w(10)=3.791157166717043e-4_p
x(11)=12.66703472284468_p
w(11)=1.152542762709422e-5_p
x(12)=16.27232141408308_p
w(12)=2.944625964364892e-7_p
x(13)=19.15405743783176_p
w(13)=9.903854334307632e-9_p
else if(N==14)then
x(1)=-8.854028318673006_p
w(1)=3.735515013738572e-1_p
x(2)=-8.239699035859623_p
w(2)=8.494636879939915e-1_p
x(3)=-7.170504455924797_p
w(3)=1.277373584146928_p
x(4)=-5.708705192479734_p
w(4)=1.624286334066461_p
x(5)=-3.948799818329189_p
w(5)=1.832258936681879_p
x(6)=-2.025454245660261_p
w(6)=1.725164384721142_p
x(7)=-6.692174210312418e-2_p
w(7)=1.023756508618957_p
x(8)=2.024793488633587_p
w(8)=2.623240517039120e-1_p
x(9)=4.476260528498852_p
w(9)=2.984335689828623e-2_p
x(10)=7.313531400538301_p
w(10)=2.004136929940861e-3_p
x(11)=10.46395660861618_p
w(11)=9.336902136239119e-5_p
x(12)=13.79063034511032_p
w(12)=3.417600925829982e-6_p
x(13)=16.97855510213107_p
w(13)=1.239419393540389e-7_p
x(14)=19.34528932800708_p
w(14)=6.428986930547911e-9_p
else if(N==15)then
x(1)=-8.869809568033377_p
w(1)=3.332810172168815e-1_p
x(2)=-8.320896495249128_p
w(2)=7.601755036271300e-1_p
x(3)=-7.361399882175414_p
w(3)=1.149865271166867_p
x(4)=-6.039621668526137_p
w(4)=1.477445017549931_p
x(5)=-4.428217579466354_p
w(5)=1.704394500731205_p
x(6)=-2.630570642231445_p
w(6)=1.723696816455899_p
x(7)=-7.701010999145831e-1_p
w(7)=1.276870244386203_p
x(8)=1.148245676733769_p
w(8)=4.841381751778433e-1_p
x(9)=3.318331797875487_p
w(9)=8.188674908165691e-2_p
x(10)=5.830405983056804_p
w(10)=7.822942909464850e-3_p
x(11)=8.638257967380424_p
w(11)=5.191796141707701e-4_p
x(12)=11.65505247979604_p
w(12)=2.670256134314133e-5_p
x(13)=14.72191074155817_p
w(13)=1.213702872007498e-6_p
x(14)=17.5196065726963_p
w(14)=6.143482345756713e-8_p
x(15)=19.47956959705997_p
w(15)=4.512278304933086e-9_p
else if(N==16)then
x(1)=-8.883167338695971_p
w(1)=2.991707004980809e-1_p
x(2)=-8.389834154956072_p
w(2)=6.840647693641339e-1_p
x(3)=-7.524425397251862_p
w(3)=1.039701072429130_p
x(4)=-6.324972901743073_p
w(4)=1.346833276525641_p
x(5)=-4.848283557028623_p
w(5)=1.578567913853443_p
x(6)=-3.174323783211064_p
w(6)=1.669036224444083_p
x(7)=-1.407687110865959_p
w(7)=1.430251254652288_p
x(8)=3.912473946139803e-1_p
w(8)=7.431210884827582e-1_p
x(9)=2.343458943083032_p
w(9)=1.829029923662017e-1_p
x(10)=4.584260133038253_p
w(10)=2.414632415218567e-2_p
x(11)=7.103437558995609_p
w(11)=2.168110457678734e-3_p
x(12)=9.837168215167614_p
w(12)=1.502986696392775e-4_p
x(13)=12.68905367272048_p
w(13)=8.832251388412893e-6_p
x(14)=15.4892747243571_p
w(14)=5.040952565280937e-7_p
x(15)=17.93746563109703_p
w(15)=3.453795326761325e-8_p
x(16)=19.57700897095613_p
w(16)=3.348707126632194e-9_p
else if(N==17)then
x(1)=-8.894572698144996_p
w(1)=2.700291027614551e-1_p
x(2)=-8.448843297340066_p
w(2)=6.187021758821409e-1_p
x(3)=-7.664641009099261_p
w(3)=9.440680807876319e-1_p
x(4)=-6.572308041613953_p
w(4)=1.230963952313302_p
x(5)=-5.216925249177594_p
w(5)=1.459824852207509_p
x(6)=-3.661171873942179_p
w(6)=1.588703814399533_p
x(7)=-1.989517508544233_p
w(7)=1.493844184780876_p
x(8)=-2.807241368878972e-1_p
w(8)=9.835615702887962e-1_p
x(9)=1.509833205921527_p
w(9)=3.409834361824975e-1_p
x(10)=3.524122238611430_p
w(10)=6.150527378706714e-2_p
x(11)=5.796489574112762_p
w(11)=7.233797408846603e-3_p
x(12)=8.281050322874474_p
w(12)=6.507348343956975e-4_p
x(13)=10.90982211162017_p
w(13)=4.881819880736799e-5_p
x(14)=13.57976166262512_p
w(14)=3.343339791431561e-6_p
x(15)=16.12068828467419_p
w(15)=2.389766796301350e-7_p
x(16)=18.2637751997054_p
w(16)=2.138929871643774e-8_p
x(17)=19.64974712065126_p
w(17)=2.589941966418141e-9_p
else
call GD(-9)
end if
end subroutine GF_m9

! [-8kT;20kT]
subroutine GF_m8(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-5.971704675701586_p
w(1)=4.752845636566684_p
x(2)=-6.083142034088783e-1_p
w(2)=3.247489767745058_p
else if(N==3)then
x(1)=-6.781800523456189_p
w(1)=2.987687745381641_p
x(2)=-2.720442215163608_p
w(2)=4.201207705403942_p
x(3)=1.642709906376241_p
w(3)=8.114399535261602e-1_p
else if(N==4)then
x(1)=-7.163500348134665_p
w(1)=2.088029023020643_p
x(2)=-4.085072616488508_p
w(2)=3.696809808857624_p
x(3)=-3.258655818723942e-1_p
w(3)=2.120948802728832_p
x(4)=4.150205836532960_p
w(4)=9.454776970464217e-2_p
else if(N==5)then
x(1)=-7.376473800023875_p
w(1)=1.570109983250492_p
x(2)=-4.967769316829408_p
w(2)=3.063933115622076_p
x(3)=-1.642751271527844_p
w(3)=2.799511719138403_p
x(4)=1.783202015902746_p
w(4)=5.604896319347712e-1_p
x(5)=7.016202222382366_p
w(5)=6.290954365999614e-3_p
else if(N==6)then
x(1)=-7.510129841276741_p
w(1)=1.239791273494288_p
x(2)=-5.564846596255666_p
w(2)=2.547088969475053_p
x(3)=-2.662651683875416_p
w(3)=2.879537635662885_p
x(4)=3.857773083548456e-1_p
w(4)=1.259372550951851_p
x(5)=4.111072281378489_p
w(5)=7.421163427932090e-2_p
x(6)=10.04123286989157_p
w(6)=3.333404483455682e-4_p
else if(N==7)then
x(1)=-7.602102698643689_p
w(1)=1.010271132635113_p
x(2)=-5.994248892750777_p
w(2)=2.141638505446676_p
x(3)=-3.475798694077626_p
w(3)=2.696005617525215_p
x(4)=-6.628043652149608e-1_p
w(4)=1.845704725724801_p
x(5)=2.361625015464231_p
w(5)=2.998332003469512e-1_p
x(6)=6.613398733818157_p
w(6)=6.863226118659522e-3_p
x(7)=12.9285926321051_p
w(7)=1.899651432686858e-5_p
else if(N==8)then
x(1)=-7.669865064723057_p
w(1)=8.400761057907791e-1_p
x(2)=-6.319874028311561_p
w(2)=1.818461116199616_p
x(3)=-4.136082704884028_p
w(3)=2.433996977916565_p
x(4)=-1.550191879249619_p
w(4)=2.158139375871044_p
x(5)=1.113083570946755_p
w(5)=7.037864345983883e-1_p
x(6)=4.448730580226069_p
w(6)=4.524362794911607e-2_p
x(7)=9.044017364770074_p
w(7)=6.301153454472182e-4_p
x(8)=15.2844125574425_p
w(8)=1.650640785923050e-6_p
else if(N==9)then
x(1)=-7.721798114910716_p
w(1)=7.090509690892541e-1_p
x(2)=-6.574457483950654_p
w(2)=1.557610305996586_p
x(3)=-4.676480564505091_p
w(3)=2.166698233094071_p
x(4)=-2.325738476437171_p
w(4)=2.225360339551694_p
x(5)=1.254274907430638e-1_p
w(5)=1.170005276100062_p
x(6)=2.892208813351588_p
w(6)=1.655023220320984e-1_p
x(7)=6.529649169909757_p
w(7)=6.037002280488012e-3_p
x(8)=11.21456931965465_p
w(8)=7.069308517175648e-5_p
x(9)=16.91475032936431_p
w(9)=2.630823169299346e-7_p
else if(N==10)then
x(1)=-7.762497025653968_p
w(1)=6.060356494970156e-1_p
x(2)=-6.776837017949622_p
w(2)=1.345706433507991_p
x(3)=-5.119837912656369_p
w(3)=1.920997152319500_p
x(4)=-2.999637413933128_p
w(4)=2.147370232371910_p
x(5)=-7.123402421099648e-1_p
w(5)=1.543307605549390_p
x(6)=1.703862644397107_p
w(6)=4.055581610202633e-1_p
x(7)=4.700319282786359_p
w(7)=3.048252109826735e-2_p
x(8)=8.479924711280626_p
w(8)=8.669034264404211e-4_p
x(9)=13.03641327392798_p
w(9)=1.067371568166719e-5_p
x(10)=17.93745378059966_p
w(10)=7.180528337283294e-8_p
else if(N==11)then
x(1)=-7.794937244451466_p
w(1)=5.237265368481367e-1_p
x(2)=-6.939856041936061_p
w(2)=1.172365041584350_p
x(3)=-5.485097853315126_p
w(3)=1.704446795692465_p
x(4)=-3.579333246612314_p
w(4)=2.005347029383468_p
x(5)=-1.449296381337203_p
w(5)=1.750469500278397_p
x(6)=7.506752093959339e-1_p
w(6)=7.369788503252672e-1_p
x(7)=3.296073135574617_p
w(7)=1.013995528220380e-1_p
x(8)=6.455495355748236_p
w(8)=5.453416414629516e-3_p
x(9)=10.22998119997621_p
w(9)=1.464335563378386e-4_p
x(10)=14.49718420050079_p
w(10)=2.218809985050550e-6_p
x(11)=18.56505747225271_p
w(11)=2.859666810423903e-8_p
else if(N==12)then
x(1)=-7.821186952333012_p
w(1)=4.570023068152286e-1_p
x(2)=-7.072820997550120_p
w(2)=1.029367172506436_p
x(3)=-5.787996392132366_p
w(3)=1.516816606791264_p
x(4)=-4.075392267199113_p
w(4)=1.844274760352710_p
x(5)=-2.103902971753859_p
w(5)=1.810606651576772_p
x(6)=-5.203522968622715e-2_p
w(6)=1.071475147451883_p
x(7)=2.180325221914073_p
w(7)=2.473391964173919e-1_p
x(8)=4.878787326491413_p
w(8)=2.236667097473119e-2_p
x(9)=8.092210617195635_p
w(9)=1.056027978754365e-3_p
x(10)=11.75015572609857_p
w(10)=3.022845681292059e-5_p
x(11)=15.63275401199774_p
w(11)=6.204444563815367e-7_p
x(12)=18.95900776374486_p
w(12)=1.454530295893991e-8_p
else if(N==13)then
x(1)=-7.842716509332211_p
w(1)=4.021983827134461e-1_p
x(2)=-7.182550112136539_p
w(2)=9.103394815680746e-1_p
x(3)=-6.041115086087547_p
w(3)=1.355183637278637_p
x(4)=-4.499581345681529_p
w(4)=1.685122876636211_p
x(5)=-2.683929870848734_p
w(5)=1.776894424767631_p
x(6)=-7.545924642074915e-1_p
w(6)=1.326879859285885_p
x(7)=1.266170847979860_p
w(7)=4.710315130887102e-1_p
x(8)=3.612016680830423_p
w(8)=6.746169765802262e-2_p
x(9)=6.396472725598064_p
w(9)=4.983204883273206e-3_p
x(10)=9.575230827999725_p
w(10)=2.324057284160886e-4_p
x(11)=13.03890008597667_p
w(11)=7.689119668559117e-6_p
x(12)=16.50116640623993_p
w(12)=2.229196105747055e-7_p
x(13)=19.21608207911637_p
w(13)=8.664156887859074e-9_p
else if(N==14)then
x(1)=-7.860588681793580_p
w(1)=3.566532218685011e-1_p
x(2)=-7.274081682140988_p
w(2)=8.103872669769843e-1_p
x(3)=-6.254314077894150_p
w(3)=1.216003246058374_p
x(4)=-4.863084435093517_p
w(4)=1.536557617221260_p
x(5)=-3.195561932791648_p
w(5)=1.694636401314506_p
x(6)=-1.382661228485295_p
w(6)=1.472987055485500_p
x(7)=4.925004515625423e-1_p
w(7)=7.346583438033202e-1_p
x(8)=2.571457338848513_p
w(8)=1.598424510790697e-1_p
x(9)=5.014081808998209_p
w(9)=1.735184442901269e-2_p
x(10)=7.811319195640160_p
w(10)=1.196166976327472e-3_p
x(11)=10.89100184209795_p
w(11)=5.930125412518534e-5_p
x(12)=14.11315235285709_p
w(12)=2.384263061239193e-6_p
x(13)=17.16247918988797_p
w(13)=9.784918349487689e-8_p
x(14)=19.39080170526937_p
w(14)=5.732517027523616e-9_p
else if(N==15)then
x(1)=-7.875584866407307_p
w(1)=3.184026459361601e-1_p
x(2)=-7.351182925318809_p
w(2)=7.257478832279375e-1_p
x(3)=-6.435281283806439_p
w(3)=1.095885008863694_p
x(4)=-5.175735990657218_p
w(4)=1.401477898838611_p
x(5)=-3.645593430194391_p
w(5)=1.591989018710133_p
x(6)=-1.947975195020591_p
w(6)=1.524507199258202_p
x(7)=-1.830054556976156e-1_p
w(7)=9.799431266421142e-1_p
x(8)=1.699685384941487_p
w(8)=3.096182945424584e-1_p
x(9)=3.865244307359582_p
w(9)=4.784238263692592e-2_p
x(10)=6.350359743304643_p
w(10)=4.584981787504652e-3_p
x(11)=9.104069389187678_p
w(11)=3.184211728382847e-4_p
x(12)=12.04055841523528_p
w(12)=1.760602536266129e-5_p
x(13)=14.99953315884018_p
w(13)=8.824279186532189e-7_p
x(14)=17.6682442048272_p
w(14)=5.016333427464224e-8_p
x(15)=19.51405098783133_p
w(15)=4.078547556755944e-9_p
else if(N==16)then
x(1)=-7.888289196136095_p
w(1)=2.859740242616357e-1_p
x(2)=-7.416707262588569_p
w(2)=6.535117004808724e-1_p
x(3)=-6.590023731530689_p
w(3)=9.918440799121055e-1_p
x(4)=-5.445859214980700_p
w(4)=1.280190465938164_p
x(5)=-4.041177604350580_p
w(5)=1.484160504777805_p
x(6)=-2.456634641376376_p
w(6)=1.511982413007024_p
x(7)=-7.868362549789114e-1_p
w(7)=1.163163554611448_p
x(8)=9.537173715869917e-1_p
w(8)=5.051141352181564e-1_p
x(9)=2.896311649393016_p
w(9)=1.089868362495220e-1_p
x(10)=5.120474494063581_p
w(10)=1.401037949602913e-2_p
x(11)=7.598254083725203_p
w(11)=1.295775620514806e-3_p
x(12)=10.26815904575382_p
w(12)=9.507979086992757e-5_p
x(13)=13.03415823082434_p
w(13)=6.042718873947642e-6_p
x(14)=15.72752763842049_p
w(14)=3.802053547972584e-7_p
x(15)=18.05867940714494_p
w(15)=2.896606566670933e-8_p
x(16)=19.60385965343948_p
w(16)=3.057301319620419e-9_p
else if(N==17)then
x(1)=-7.899145107678217_p
w(1)=2.582467948487994e-1_p
x(2)=-7.472843620488046_p
w(2)=5.914107512286879e-1_p
x(3)=-6.723260595888749_p
w(3)=9.013455943720807e-1_p
x(4)=-5.680368506099103_p
w(4)=1.171898792452107_p
x(5)=-4.389248349169230_p
w(5)=1.378738324208295_p
x(6)=-2.913332663971585_p
w(6)=1.462485130390069_p
x(7)=-1.333699302152281_p
w(7)=1.271518701748276_p
x(8)=3.008149573929773e-1_p
w(8)=7.136785514378027e-1_p
x(9)=2.068218632116622_p
w(9)=2.106638081209538e-1_p
x(10)=4.072004863761322_p
w(10)=3.567291334119704e-2_p
x(11)=6.313660133169044_p
w(11)=4.242752361471407e-3_p
x(12)=8.746732274926849_p
w(12)=3.988194230542896e-4_p
x(13)=11.30533330586263_p
w(13)=3.189476656354608e-5_p
x(14)=13.88708441134323_p
w(14)=2.368833131930793e-6_p
x(15)=16.32522606987368_p
w(15)=1.860730789679944e-7_p
x(16)=18.36368378007344_p
w(16)=1.832357069305715e-8_p
x(17)=19.67114955620571_p
w(17)=2.382602050656032e-9_p
else
call GD(-8)
end if
end subroutine GF_m8

! [-7kT;20kT]
subroutine GF_m7(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-5.160733114853993_p
w(1)=4.287642164921619_p
x(2)=-2.708839151233660e-1_p
w(2)=2.713269299471002_p
else if(N==3)then
x(1)=-5.879252112888746_p
w(1)=2.740839456724664_p
x(2)=-2.166732082146450_p
w(2)=3.668241031116912_p
x(3)=2.027308177440120_p
w(3)=5.918309765510453e-1_p
else if(N==4)then
x(1)=-6.222569935468277_p
w(1)=1.936645459024179_p
x(2)=-3.376972624122389_p
w(2)=3.341429001811851_p
x(3)=1.186197559597608e-1_p
w(3)=1.663511115015575_p
x(4)=4.637821397019751_p
w(4)=5.932588854101645e-2_p
else if(N==5)then
x(1)=-6.416221774860592_p
w(1)=1.467641304828916_p
x(2)=-4.170004643556186_p
w(2)=2.821282206673497_p
x(3)=-1.093054040833285_p
w(3)=2.335741700135707_p
x(4)=2.267015135257485_p
w(4)=3.726187106759188e-1_p
x(5)=7.573649280305298_p
w(5)=3.627542078581931e-3_p
else if(N==6)then
x(1)=-6.538999822732485_p
w(1)=1.165130040820573_p
x(2)=-4.713771301337083_p
w(2)=2.370397174517604_p
x(3)=-2.014997737305568_p
w(3)=2.518741674769943_p
x(4)=8.861540400409341e-1_p
w(4)=9.029124815362424e-1_p
x(5)=4.664224450417225_p
w(5)=4.354386306947446e-2_p
x(6)=10.62274304616691_p
w(6)=1.862296787837900e-4_p
else if(N==7)then
x(1)=-6.624354102215460_p
w(1)=9.526368526040033e-1_p
x(2)=-5.109806281345127_p
w(2)=2.005739688300875_p
x(3)=-2.754882617112850_p
w(3)=2.430381249899809_p
x(4)=-1.195548406463175e-1_p
w(4)=1.423875882136933_p
x(5)=2.900685424074296_p
w(5)=1.843992610266270e-1_p
x(6)=7.188393472275004_p
w(6)=3.867554885775409e-3_p
x(7)=13.46104713486325_p
w(7)=1.097553859799215e-5_p
else if(N==8)then
x(1)=-6.687696174268565_p
w(1)=7.938565909799433e-1_p
x(2)=-5.412801614655458_p
w(2)=1.709911977705334_p
x(3)=-3.361977949036843_p
w(3)=2.234175256606921_p
x(4)=-9.488738783901637e-1_p
w(4)=1.773284813242743_p
x(5)=1.645441805409692_p
w(5)=4.633851524913462e-1_p
x(6)=5.014330461732060_p
w(6)=2.593623349954502e-2_p
x(7)=9.592512445915229_p
w(7)=3.603903561640388e-4_p
x(8)=15.69599465194961_p
w(8)=1.049510624352865e-6_p
else if(N==9)then
x(1)=-6.736416696186147_p
w(1)=6.711415952951164e-1_p
x(2)=-5.650809835333556_p
w(2)=1.468836012411220_p
x(3)=-3.862510039830144_p
w(3)=2.010921556965255_p
x(4)=-1.664932311461130_p
w(4)=1.918202383451111_p
x(5)=6.713825338378422e-1_p
w(5)=8.305576455139705e-1_p
x(6)=3.449306029351486_p
w(6)=9.777213114404681e-2_p
x(7)=7.086192808374283_p
w(7)=3.437603207155254e-3_p
x(8)=11.7054474174959_p
w(8)=4.234985938613626e-5_p
x(9)=17.19548047134388_p
w(9)=1.865453602401886e-7_p
else if(N==10)then
x(1)=-6.774678873670132_p
w(1)=5.744348436318728e-1_p
x(2)=-5.840560438234746_p
w(2)=1.271844615136642_p
x(3)=-4.275266665905496_p
w(3)=1.795640754609407_p
x(4)=-2.286397891864407_p
w(4)=1.912491180528187_p
x(5)=-1.328277671373218e-1_p
w(5)=1.177164081698949_p
x(6)=2.256339091878789_p
w(6)=2.514391132951414e-1_p
x(7)=5.262310260715168_p
w(7)=1.738466799171635e-2_p
x(8)=9.003728321096094_p
w(8)=5.053523471309699e-4_p
x(9)=13.45512112848316_p
w(9)=6.799647386138452e-6_p
x(10)=18.1207498535954_p
w(10)=5.550618768695928e-8_p
else if(N==11)then
x(1)=-6.805230507104853_p
w(1)=4.970178811047055e-1_p
x(2)=-5.993761395877528_p
w(2)=1.110015461896648_p
x(3)=-4.616670626234015_p
w(3)=1.600983232683890_p
x(4)=-2.822906171083201_p
w(4)=1.824258845705502_p
x(5)=-8.253735256819088e-1_p
w(5)=1.419920634371941_p
x(6)=1.308080345215107_p
w(6)=4.868850175823191e-1_p
x(7)=3.860438857419226_p
w(7)=5.861269207796801e-2_p
x(8)=6.999815651685316_p
w(8)=3.127416374897404e-3_p
x(9)=10.70722888575614_p
w(9)=8.875129858113331e-5_p
x(10)=14.84220385327184_p
w(10)=1.507843495244886e-6_p
x(11)=18.68615025788215_p
w(11)=2.345267440052733e-8_p
else if(N==12)then
x(1)=-6.829991262741053_p
w(1)=4.341522229086019e-1_p
x(2)=-6.118968454248535_p
w(2)=9.760707118395439e-1_p
x(3)=-4.900694304224746_p
w(3)=1.429712359481375_p
x(4)=-3.284119671722383_p
w(4)=1.700848102330215_p
x(5)=-1.434214468513098_p
w(5)=1.540258970106564_p
x(6)=5.235525657008154e-1_p
w(6)=7.591223009638043e-1_p
x(7)=2.745647540928326_p
w(7)=1.473761353520887e-1_p
x(8)=5.436805628216865_p
w(8)=1.273029598224190e-2_p
x(9)=8.604605746782456_p
w(9)=6.207140831760596e-4_p
x(10)=12.1743375103606_p
w(10)=1.919134994089511e-5_p
x(11)=15.91126754773389_p
w(11)=4.475895112678526e-7_p
x(12)=19.04180846545813_p
w(12)=1.240555773558364e-8_p
else if(N==13)then
x(1)=-6.850328380978110_p
w(1)=3.824394822208905e-1_p
x(2)=-6.222474121002586_p
w(2)=8.642809210670598e-1_p
x(3)=-5.138659530080925_p
w(3)=1.280692022451171_p
x(4)=-3.680174973543334_p
w(4)=1.568193101025074_p
x(5)=-1.972571760462532_p
w(5)=1.563852119527583_p
x(6)=-1.493071793851068e-1_p
w(6)=1.005493173647896_p
x(7)=1.835059205725664_p
w(7)=2.944216800585427e-1_p
x(8)=4.178780846480316_p
w(8)=3.852250330277787e-2_p
x(9)=6.933100699911602_p
w(9)=2.869807431858718e-3_p
x(10)=10.04774680238419_p
w(10)=1.413539091043266e-4_p
x(11)=13.40919854119024_p
w(11)=5.122938990652911e-6_p
x(12)=16.72420408546893_p
w(12)=1.692250498913542e-7_p
x(13)=19.27494569038024_p
w(13)=7.586621954598492e-9_p
else if(N==14)then
x(1)=-6.867231898764568_p
w(1)=3.394060455536055e-1_p
x(2)=-6.308943647574845_p
w(2)=7.702012827971001e-1_p
x(3)=-5.339525752514054_p
w(3)=1.151484047207874_p
x(4)=-4.020767480242014_p
w(4)=1.438816478195605_p
x(5)=-2.448369728655112_p
w(5)=1.526611800630993_p
x(6)=-7.415621105596267e-1_p
w(6)=1.183066626967851_p
x(7)=1.071818012703037_p
w(7)=4.878340173576262e-1_p
x(8)=3.143739027339065_p
w(8)=9.287391374639357e-2_p
x(9)=5.568140759188486_p
w(9)=9.872038380208593e-3_p
x(10)=8.317495403072117_p
w(10)=7.059810963722326e-4_p
x(11)=11.32014966192555_p
w(11)=3.748619060488881e-5_p
x(12)=14.43267031229413_p
w(12)=1.663724926001129e-6_p
x(13)=17.34131575827988_p
w(13)=7.743154832752264e-8_p
x(14)=19.43419265927694_p
w(14)=5.111911241670498e-9_p
else if(N==15)then
x(1)=-6.881431138332864_p
w(1)=3.032223972320763e-1_p
x(2)=-6.381875945691082_p
w(2)=6.903893503046330e-1_p
x(3)=-5.510330996653168_p
w(3)=1.039412762889532_p
x(4)=-4.314559654194312_p
w(4)=1.318115115762428_p
x(5)=-2.868238149208551_p
w(5)=1.456988654198124_p
x(6)=-1.270288392187159_p
w(6)=1.282176771199145_p
x(7)=4.153483921698319e-1_p
w(7)=6.945950887375052e-1_p
x(8)=2.276896327528787_p
w(8)=1.860202493479916e-1_p
x(9)=4.431745881226730_p
w(9)=2.713699688993996e-2_p
x(10)=6.881578775714682_p
w(10)=2.648003526530871e-3_p
x(11)=9.574946845809983_p
w(11)=1.938086756998937e-4_p
x(12)=12.42605978714396_p
w(12)=1.157871222213745e-5_p
x(13)=15.27353668051378_p
w(13)=6.421999408463027e-7_p
x(14)=17.81264505618312_p
w(14)=4.103202741793705e-8_p
x(15)=19.54706349752414_p
w(15)=3.684825121635830e-9_p
else if(N==16)then
x(1)=-6.893472303492340_p
w(1)=2.725140491679817e-1_p
x(2)=-6.443928344161391_p
w(2)=6.221677568906770e-1_p
x(3)=-5.656606613310227_p
w(3)=9.419740572399006e-1_p
x(4)=-4.568989434456848_p
w(4)=1.207949368816271_p
x(5)=-3.238531365190497_p
w(5)=1.373101002277452_p
x(6)=-1.744877696780455_p
w(6)=1.315970238411161_p
x(7)=-1.623908194710485e-1_p
w(7)=8.776598005452764e-1_p
x(8)=1.538512499311387_p
w(8)=3.184299226206284e-1_p
x(9)=3.471628018281721_p
w(9)=6.234014216375976e-2_p
x(10)=5.670795993549212_p
w(10)=7.974400308404099e-3_p
x(11)=8.100693026475604_p
w(11)=7.664380873127613e-4_p
x(12)=10.70176839194176_p
w(12)=5.984405430419622e-5_p
x(13)=13.37790467923184_p
w(13)=4.129582663338444e-6_p
x(14)=15.96206195411139_p
w(14)=2.871162774987857e-7_p
x(15)=18.17644630114421_p
w(15)=2.432154476431732e-8_p
x(16)=19.62966226505809_p
w(16)=2.789006589864951e-9_p
else if(N==17)then
x(1)=-6.903770733331423_p
w(1)=2.462331766333536e-1_p
x(2)=-6.497144122523279_p
w(2)=5.634400831484974e-1_p
x(3)=-5.782718193473556_p
w(3)=8.569680636454379e-1_p
x(4)=-4.790306826103409_p
w(4)=1.108496919044999_p
x(5)=-3.565314204376758_p
w(5)=1.285283898302330_p
x(6)=-2.171333247534049_p
w(6)=1.304579550551023_p
x(7)=-6.794728812659186e-1_p
w(7)=1.013164830789180_p
x(8)=8.983667136012305e-1_p
w(8)=4.766813325730321e-1_p
x(9)=2.650433532663217_p
w(9)=1.231797588419403e-1_p
x(10)=4.636889221304993_p
w(10)=2.016320972933812e-2_p
x(11)=6.840851594908129_p
w(11)=2.455399235884199e-3_p
x(12)=9.217323064758160_p
w(12)=2.426300832563272e-4_p
x(13)=11.70170347000081_p
w(13)=2.077089768504834e-5_p
x(14)=14.19225985197774_p
w(14)=1.677966017344836e-6_p
x(15)=16.52623003005208_p
w(15)=1.450535009956536e-7_p
x(16)=18.4608118588625_p
w(16)=1.570755425786588e-8_p
x(17)=19.6917834834925_p
w(17)=2.189591698802351e-9_p
else
call GD(-7)
end if
end subroutine GF_m7

! [-6kT;20kT]
subroutine GF_m6(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-4.348502865336883_p
w(1)=3.813107630570035_p
x(2)=9.542121163992059e-2_p
w(2)=2.189368052506541_p
else if(N==3)then
x(1)=-4.976661450139854_p
w(1)=2.488332554995962_p
x(2)=-1.607619732087622_p
w(2)=3.105733256487208_p
x(3)=2.458386861005491_p
w(3)=4.084098715934070e-1_p
else if(N==4)then
x(1)=-5.281948520115039_p
w(1)=1.781174464677868_p
x(2)=-2.671069114164974_p
w(2)=2.950238223501112_p
x(3)=5.929548523299287e-1_p
w(3)=1.235604231553960_p
x(4)=5.169587965691794_p
w(4)=3.545876334363784e-2_p
else if(N==5)then
x(1)=-5.456395643561548_p
w(1)=1.361902414223199_p
x(2)=-3.375606555665535_p
w(2)=2.553230484701171_p
x(3)=-5.343310499904622e-1_p
w(3)=1.852615403161075_p
x(4)=2.796739090716747_p
w(4)=2.327121981139140e-1_p
x(5)=8.166648081310145_p
w(5)=2.015182877217246e-3_p
else if(N==6)then
x(1)=-5.568339364421923_p
w(1)=1.087694909539238_p
x(2)=-3.866032945010959_p
w(2)=2.176281523872520_p
x(3)=-1.370120040542423_p
w(3)=2.109980908673724_p
x(4)=1.422420435485568_p
w(4)=6.039540992826594e-1_p
x(5)=5.254694139487069_p
w(5)=2.446276250963168e-2_p
x(6)=11.22678876007366_p
w(6)=1.014791988024861e-4_p
else if(N==7)then
x(1)=-5.647052866368687_p
w(1)=8.926628577558688e-1_p
x(2)=-4.228310628639323_p
w(2)=1.857562043721918_p
x(3)=-2.040494754252576_p
w(3)=2.117699931838145_p
x(4)=4.430131525632711e-1_p
w(4)=1.025121668067407_p
x(5)=3.478721474675468_p
w(5)=1.073015034922593e-1_p
x(6)=7.787111207952142_p
w(6)=2.121382220789390e-3_p
x(7)=13.99522759183564_p
w(7)=6.295980188578532e-6_p
else if(N==8)then
x(1)=-5.705901824879999_p
w(1)=7.457373834257846e-1_p
x(2)=-4.508107017433455_p
w(2)=1.592538496443459_p
x(3)=-2.594405915690020_p
w(3)=1.998035174633168_p
x(4)=-3.423856013839783e-1_p
w(4)=1.366655225316506_p
x(5)=2.214528565416017_p
w(5)=2.849263146808643e-1_p
x(6)=5.607253821080482_p
w(6)=1.437942813215358e-2_p
x(7)=10.15296274343714_p
w(7)=2.029892007657930e-4_p
x(8)=16.09436315032897_p
w(8)=6.712438761234255e-7_p
else if(N==9)then
x(1)=-5.751335529384781_p
w(1)=6.317021924341399e-1_p
x(2)=-4.729026976108780_p
w(2)=1.373558892429904_p
x(3)=-3.054049131045526_p
w(3)=1.829029494004365_p
x(4)=-1.007038495605833_p
w(4)=1.564876916637168_p
x(5)=1.245414247126946_p
w(5)=5.461395799866907e-1_p
x(6)=4.038012398132364_p
w(6)=5.522635363781873e-2_p
x(7)=7.660095906861573_p
w(7)=1.916924568397920e-3_p
x(8)=12.19943070450905_p
w(8)=2.519595855033419e-5_p
x(9)=17.46128196799994_p
w(9)=1.334195426351633e-7_p
else if(N==10)then
x(1)=-5.787103239434783_p
w(1)=5.415836751314285e-1_p
x(2)=-4.905762627033689_p
w(2)=1.193041891284661_p
x(3)=-3.435153044942290_p
w(3)=1.651634254872166_p
x(4)=-1.579206140249288_p
w(4)=1.629035991178900_p
x(5)=4.626318758681371e-1_p
w(5)=8.303995519867988e-1_p
x(6)=2.842463053921576_p
w(6)=1.468379127890101e-1_p
x(7)=5.846121420085099_p
w(7)=9.647262569182477e-3_p
x(8)=9.537399970025307_p
w(8)=2.907740496343260e-4_p
x(9)=13.87113515553287_p
w(9)=4.326029630329522e-6_p
x(10)=18.29298979029812_p
w(10)=4.318516508186907e-8_p
else if(N==11)then
x(1)=-5.815722791557438_p
w(1)=4.692699698765908e-1_p
x(2)=-5.048860498864744_p
w(2)=1.043804052198881_p
x(3)=-3.751833491332059_p
w(3)=1.483974097336030_p
x(4)=-2.073025681507808_p
w(4)=1.602214181073741_p
x(5)=-1.962557283967550e-1_p
w(5)=1.069987054230506_p
x(6)=1.896332754122684_p
w(6)=2.987540318310236e-1_p
x(7)=4.450827211015477_p
w(7)=3.265589144881112e-2_p
x(8)=7.558384528939087_p
w(8)=1.761965282667531e-3_p
x(9)=11.18870784904492_p
w(9)=5.339404773255821e-5_p
x(10)=15.18161748891224_p
w(10)=1.026442834088612e-6_p
x(11)=18.80001482454944_p
w(11)=1.930775970424752e-8_p
else if(N==12)then
x(1)=-5.838961088823413_p
w(1)=4.104259904798092e-1_p
x(2)=-5.166094535562420_p
w(2)=9.196831424109778e-1_p
x(3)=-4.016302381266631_p
w(3)=1.332528567353682_p
x(4)=-2.498848316892733_p
w(4)=1.525720000284664_p
x(5)=-7.662108749769638e-1_p
w(5)=1.228105172897785_p
x(6)=1.122370742158479_p
w(6)=4.950426880956639e-1_p
x(7)=3.340156440742143_p
w(7)=8.351680054434134e-2_p
x(8)=6.012844160997261_p
w(8)=7.080228753641350e-3_p
x(9)=9.125649172759648_p
w(9)=3.606159586017167e-4_p
x(10)=12.59881195208525_p
w(10)=1.214190163373417e-5_p
x(11)=16.183396562117_p
w(11)=3.237952123584881e-7_p
x(12)=19.11997886239693_p
w(12)=1.060056403895580e-8_p
else if(N==13)then
x(1)=-5.858079410905574_p
w(1)=3.619331152617477e-1_p
x(2)=-5.263210819529554_p
w(2)=8.156984414241560e-1_p
x(3)=-4.238586590818151_p
w(3)=1.198509265019163_p
x(4)=-2.865944311286080_p
w(4)=1.427383887001674_p
x(5)=-1.266197109710844_p
w(5)=1.303865196697647_p
x(6)=4.695646090318132e-1_p
w(6)=6.996994021860049e-1_p
x(7)=2.433563792437978_p
w(7)=1.723383768786631e-1_p
x(8)=4.767229346433985_p
w(8)=2.133179028423030e-2_p
x(9)=7.481818668068901_p
w(9)=1.627320853002190e-3_p
x(10)=10.52476322918549_p
w(10)=8.534210899716300e-5_p
x(11)=13.77735242121064_p
w(11)=3.409894749947387e-6_p
x(12)=16.9412509243988_p
w(12)=1.288193025191852e-7_p
x(13)=19.33078895343914_p
w(13)=6.647239253574613e-9_p
else if(N==14)then
x(1)=-5.873993218989689_p
w(1)=3.215146209479690e-1_p
x(2)=-5.344488078767368_p
w(2)=7.279195386103484e-1_p
x(3)=-4.426709325482453_p
w(3)=1.080956384809184_p
x(4)=-3.182816665758462_p
w(4)=1.323097694280672_p
x(5)=-1.707205300432277_p
w(5)=1.316073102506926_p
x(6)=-9.539016421854712e-2_p
w(6)=8.760311612953370e-1_p
x(7)=1.677315294689562_p
w(7)=2.991878283650300e-1_p
x(8)=3.740953972307481_p
w(8)=5.175259817760119e-2_p
x(9)=6.137437007244381_p
w(9)=5.505663968256112e-3_p
x(10)=8.831406590905171_p
w(10)=4.122692943874998e-4_p
x(11)=11.75082926216486_p
w(11)=2.359341368405300e-5_p
x(12)=14.74877420033932_p
w(12)=1.161437435472893e-6_p
x(13)=17.51500832537002_p
w(13)=6.141205255066170e-8_p
x(14)=19.47555286133221_p
w(14)=4.557693509348885e-9_p
else if(N==15)then
x(1)=-5.887378485659822_p
w(1)=2.874818453689588e-1_p
x(2)=-5.413147746405806_p
w(2)=6.532653804432358e-1_p
x(3)=-4.587030046224553_p
w(3)=9.781461253159618e-1_p
x(4)=-3.457046783589239_p
w(4)=1.221063660131219_p
x(5)=-2.096833341451587_p
w(5)=1.286941781113792_p
x(6)=-5.933488558415571e-1_p
w(6)=1.002587049676129_p
x(7)=1.033245309852672_p
w(7)=4.506998705577532e-1_p
x(8)=2.880878947203411_p
w(8)=1.056610608530002e-1_p
x(9)=5.016607746735066_p
w(9)=1.499531767836289e-2_p
x(10)=7.423307776357913_p
w(10)=1.508374320661290e-3_p
x(11)=10.05032903037449_p
w(11)=1.171152865618719e-4_p
x(12)=12.81109015605283_p
w(12)=7.597518828516940e-6_p
x(13)=15.54365230164913_p
w(13)=4.678686604560026e-7_p
x(14)=17.95281286398844_p
w(14)=3.361661452291816e-8_p
x(15)=19.57866603663023_p
w(15)=3.326837460300749e-9_p
else if(N==16)then
x(1)=-5.898742567879644_p
w(1)=2.585628663940207e-1_p
x(2)=-5.471644602384684_p
w(2)=5.893180663660901e-1_p
x(3)=-4.724582784963227_p
w(3)=8.882061107196113e-1_p
x(4)=-3.695200202345456_p
w(4)=1.125116467886067_p
x(5)=-2.441306119798643_p
w(5)=1.234282576484327_p
x(6)=-1.037066204849136_p
w(6)=1.076005625404861_p
x(7)=4.738310533573025e-1_p
w(7)=6.047148477291218e-1_p
x(8)=2.149379560392484_p
w(8)=1.868940916686924e-1_p
x(9)=4.068284276374623_p
w(9)=3.442561646822470e-2_p
x(10)=6.234260192178345_p
w(10)=4.459951950592269e-3_p
x(11)=8.610152326943084_p
w(11)=4.489144948289093e-4_p
x(12)=11.13751827500771_p
w(12)=3.748793697649095e-5_p
x(13)=13.71993146486534_p
w(13)=2.819504524971453e-6_p
x(14)=16.19271276968113_p
w(14)=2.170850284123723e-7_p
x(15)=18.29079401846504_p
w(15)=2.044192484852859e-8_p
x(16)=19.65445588841529_p
w(16)=2.541685313383915e-9_p
else if(N==17)then
x(1)=-5.908472030521075_p
w(1)=2.337858320950253e-1_p
x(2)=-5.521871627536560_p
w(2)=5.341712119956946e-1_p
x(3)=-4.843363565619027_p
w(3)=8.093689437314417e-1_p
x(4)=-3.902849850923046_p
w(4)=1.036755889414196_p
x(5)=-2.746148006353760_p
w(5)=1.170123095782261_p
x(6)=-1.434635084884528_p
w(6)=1.104568772789827_p
x(7)=-2.033436305490965e-2_p
w(7)=7.397647838776593e-1_p
x(8)=1.518377068202089_p
w(8)=2.925447286134205e-1_p
x(9)=3.256274244055288_p
w(9)=6.868615611664276e-2_p
x(10)=5.217565356036096_p
w(10)=1.114150576428489e-2_p
x(11)=7.377346183694353_p
w(11)=1.403379149812879e-3_p
x(12)=9.692322214813231_p
w(12)=1.465804094558665e-4_p
x(13)=12.09853588854692_p
w(13)=1.348623250556669e-5_p
x(14)=14.49501973225287_p
w(14)=1.188419523648026e-6_p
x(15)=16.72360580029162_p
w(15)=1.132037623378334e-7_p
x(16)=18.55519365512336_p
w(16)=1.347131269974612e-8_p
x(17)=19.71167547753279_p
w(17)=2.009750293290792e-9_p
else
call GD(-6)
end if
end subroutine GF_m6

! [-5kT;20kT]
subroutine GF_m5(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-3.535013171521889_p
w(1)=3.320510309967803_p
x(2)=4.997484374262894e-1_p
w(2)=1.686205036460161_p
else if(N==3)then
x(1)=-4.074476156351720_p
w(1)=2.223428915989621_p
x(2)=-1.037834832157918_p
w(2)=2.518900928081476_p
x(3)=2.943209324129581_p
w(3)=2.643855023568667e-1_p
else if(N==4)then
x(1)=-4.342056014365794_p
w(1)=1.616812952099877_p
x(2)=-1.966486731341010_p
w(2)=2.512359627753226_p
x(3)=1.107636502207669_p
w(3)=8.574073505013086e-1_p
x(4)=5.748540096961195_p
w(4)=2.013541607355321e-2_p
else if(N==5)then
x(1)=-4.497346530364790_p
w(1)=1.249306738854639_p
x(2)=-2.585369014647003_p
w(2)=2.245442582044609_p
x(3)=4.321319453223704e-2_p
w(3)=1.374770703940269_p
x(4)=3.376562677296252_p
w(4)=1.361184474537865e-1_p
x(5)=8.796710629211518_p
w(5)=1.076874134660027e-3_p
else if(N==6)then
x(1)=-4.598432399051288_p
w(1)=1.004713204905436_p
x(2)=-3.022779819603206_p
w(2)=1.952419360523283_p
x(3)=-7.222321278627883e-1_p
w(3)=1.662375457222179_p
x(4)=2.002738291102682_p
w(4)=3.739873093188593e-1_p
x(5)=5.882769315446245_p
w(5)=1.316603507137489e-2_p
x(6)=11.85188931832156_p
w(6)=5.397938683248477e-5_p
else if(N==7)then
x(1)=-4.670415768489634_p
w(1)=8.281821544264052e-1_p
x(2)=-3.350807925751825_p
w(2)=1.687506917549255_p
x(3)=-1.330432480353435_p
w(3)=1.750831175693214_p
x(4)=1.036047391262755_p
w(4)=6.798561071147610e-1_p
x(5)=4.096388749885596_p
w(5)=5.920210067747510e-2_p
x(6)=8.408807964716795_p
w(6)=1.133295637242037e-3_p
x(7)=14.52732520363361_p
w(7)=3.595329611767749e-6_p
else if(N==8)then
x(1)=-4.724647631740649_p
w(1)=6.939920254903696e-1_p
x(2)=-3.606656781626158_p
w(2)=1.458979001262282_p
x(3)=-1.833175321638279_p
w(3)=1.711551593481683_p
x(4)=2.798047617330778e-1_p
w(4)=9.706797396571222e-1_p
x(5)=2.823910776183572_p
w(5)=1.636786795243658e-1_p
x(6)=6.226851651755226_p
w(6)=7.721189912247000e-3_p
x(7)=10.7241893637608_p
w(7)=1.126845680747856e-4_p
x(8)=16.47725173913994_p
w(8)=4.325318198268213e-7_p
else if(N==9)then
x(1)=-4.766686175109391_p
w(1)=5.893217013497015e-1_p
x(2)=-3.809825039328539_p
w(2)=1.266061841094590_p
x(3)=-2.251798160835723_p
w(3)=1.606436586796081_p
x(4)=-3.447481785333253e-1_p
w(4)=1.182866499036803_p
x(5)=1.855250765699240_p
w(5)=3.310419214424131e-1_p
x(6)=4.657724719744532_p
w(6)=2.992429211575403e-2_p
x(7)=8.250651240719735_p
w(7)=1.047508425113341e-3_p
x(8)=12.69524340114548_p
w(8)=1.489990476676049e-5_p
x(9)=17.71180277580807_p
w(9)=9.626274154646029e-8_p
else if(N==10)then
x(1)=-4.799877145877042_p
w(1)=5.063065551362921e-1_p
x(2)=-3.973036975081897_p
w(2)=1.104777135486420_p
x(3)=-2.600494757384479_p
w(3)=1.476210021533147_p
x(4)=-8.741858610580695e-1_p
w(4)=1.297319118241054_p
x(5)=1.084462684353418_p
w(5)=5.355849883143040e-1_p
x(6)=3.462892644473121_p
w(6)=8.113258969061787e-2_p
x(7)=6.450914356188001_p
w(7)=5.216920490911683e-3_p
x(8)=10.0801382883476_p
w(8)=1.652331927637589e-4_p
x(9)=14.28340430605379_p
w(9)=2.750538801684228e-6_p
x(10)=18.45445379413133_p
w(10)=3.380365356872986e-8_p
else if(N==11)then
x(1)=-4.826502302389271_p
w(1)=4.394890566903927e-1_p
x(2)=-4.105646302108816_p
w(2)=9.700894808115460e-1_p
x(3)=-2.891614226684142_p
w(3)=1.342895711420387_p
x(4)=-1.328234076025712_p
w(4)=1.329178672187302_p
x(5)=4.482496866756617e-1_p
w(5)=7.357641350543567e-1_p
x(6)=2.519133421028127_p
w(6)=1.706947364383807e-1_p
x(7)=5.066178584732237_p
w(7)=1.759501346737382e-2_p
x(8)=8.130481375221574_p
w(8)=9.759219979199684e-4_p
x(9)=11.67361450479848_p
w(9)=3.190222392628776e-5_p
x(10)=15.51475628156698_p
w(10)=7.001874046894827e-7_p
x(11)=18.90696321576852_p
w(11)=1.594897491446377e-8_p
else if(N==12)then
x(1)=-4.848169903273034_p
w(1)=3.849731835600325e-1_p
x(2)=-4.214610915572636_p
w(2)=8.572206825861131e-1_p
x(3)=-3.135774826000416_p
w(3)=1.216744030268640_p
x(4)=-1.719494570527471_p
w(4)=1.305104212167278_p
x(5)=-9.207292911202383e-2_p
w(5)=8.970127966766683e-1_p
x(6)=1.751757599345748_p
w(6)=2.963281191756687e-1_p
x(7)=3.963165577043072_p
w(7)=4.526366657130888e-2_p
x(8)=6.606007082679090_p
w(8)=3.853572482366511e-3_p
x(9)=9.654673798953121_p
w(9)=2.071805255281132e-4_p
x(10)=13.02288913065303_p
w(10)=7.658426844327318e-6_p
x(11)=16.44880698507394_p
w(11)=2.349159334024809e-7_p
x(12)=19.19374285195429_p
w(12)=9.071582118971552e-9_p
else if(N==13)then
x(1)=-4.866031405388228_p
w(1)=3.399436421242721e-1_p
x(2)=-4.305106416845628_p
w(2)=7.621083842688482e-1_p
x(3)=-3.341745630760419_p
w(3)=1.101734525671773_p
x(4)=-2.057479299373662_p
w(4)=1.248836065086892_p
x(5)=-5.598746824098710e-1_p
w(5)=1.003884051472741_p
x(6)=1.111646099097810_p
w(6)=4.426733586374233e-1_p
x(7)=3.062678747831567_p
w(7)=9.508250445269974e-2_p
x(8)=5.376188409806002_p
w(8)=1.149002891572217e-2_p
x(9)=8.041932182176748_p
w(9)=9.092475176528790e-4_p
x(10)=11.00567365369142_p
w(10)=5.116605412252531e-5_p
x(11)=14.14284227579559_p
w(11)=2.268076673008973e-6_p
x(12)=17.15218521518536_p
w(12)=9.832336793696776e-8_p
x(13)=19.38375788099613_p
w(13)=5.825776221445858e-9_p
else if(N==14)then
x(1)=-4.880925107135021_p
w(1)=3.023365615949343e-1_p
x(2)=-4.381008334735780_p
w(2)=6.814455142658752e-1_p
x(3)=-3.516607616380185_p
w(3)=9.987877343418760e-1_p
x(4)=-2.350100830030498_p
w(4)=1.176957019374869_p
x(5)=-9.695053823569442e-1_p
w(5)=1.058212703083839_p
x(6)=5.654912729580541e-1_p
w(6)=5.876921426264217e-1_p
x(7)=2.312919872137530_p
w(7)=1.702080261717771e-1_p
x(8)=4.361902543175456_p
w(8)=2.780760993699368e-2_p
x(9)=6.721092974354112_p
w(9)=3.014066860317742e-3_p
x(10)=9.352469798237271_p
w(10)=2.383146968019223e-4_p
x(11)=12.18252361765124_p
w(11)=1.478936514380537e-5_p
x(12)=15.06111286597192_p
w(12)=8.112404192064243e-7_p
x(13)=17.6835445559926_p
w(13)=4.880706830555689e-8_p
x(14)=19.51497638195045_p
w(14)=4.061627607960787e-9_p
else if(N==15)then
x(1)=-4.893471812054876_p
w(1)=2.706153378217993e-1_p
x(2)=-4.445248772700147_p
w(2)=6.125841803853782e-1_p
x(3)=-3.666023908222569_p
w(3)=9.074376501724802e-1_p
x(4)=-2.604142467495483_p
w(4)=1.099664636515302_p
x(5)=-1.330409060606756_p
w(5)=1.070892025993107_p
x(6)=9.075925949146936e-2_p
w(6)=7.119139871249159e-1_p
x(7)=1.677690289050129_p
w(7)=2.674110263575257e-1_p
x(8)=3.511191175314536_p
w(8)=5.717859322669214e-2_p
x(9)=5.618674359302743_p
w(9)=8.094245329498706e-3_p
x(10)=7.974891761489674_p
w(10)=8.480319073802707e-4_p
x(11)=10.529715473668_p
w(11)=7.028493445242326e-5_p
x(12)=13.19523765645459_p
w(12)=4.974853747280445e-6_p
x(13)=15.80966417210077_p
w(13)=3.412257933144981e-7_p
x(14)=18.08878214833228_p
w(14)=2.757911682721124e-8_p
x(15)=19.60892016296866_p
w(15)=3.000774875703173e-9_p
else if(N==16)then
x(1)=-4.904138711186775_p
w(1)=2.436186896027218e-1_p
x(2)=-4.500071384978873_p
w(2)=5.534144198678739e-1_p
x(3)=-3.794512632294284_p
w(3)=8.266605369683534e-1_p
x(4)=-2.825416018713599_p
w(4)=1.022729098871332_p
x(5)=-1.649481250503604_p
w(5)=1.054648808222219_p
x(6)=-3.276311181013393e-1_p
w(6)=8.043209056898489e-1_p
x(7)=1.130722720081090_p
w(7)=3.771678379841412e-1_p
x(8)=2.787751178250156_p
w(8)=1.029716818634645e-1_p
x(9)=4.684939272682115_p
w(9)=1.844324597628626e-2_p
x(10)=6.810034648417334_p
w(10)=2.454157960012260e-3_p
x(11)=9.126107128526366_p
w(11)=2.604785990259906e-4_p
x(12)=11.57498737629703_p
w(12)=2.337756255578050e-5_p
x(13)=14.05992969536951_p
w(13)=1.923429190896445e-6_p
x(14)=16.41936009204669_p
w(14)=1.643235324672153e-7_p
x(15)=18.40177202544469_p
w(15)=1.719401529831397e-8_p
x(16)=19.67828181517127_p
w(16)=2.313390635004612e-9_p
else if(N==17)then
x(1)=-4.913282619770089_p
w(1)=2.204566774860170e-1_p
x(2)=-4.547212558207952_p
w(2)=5.022533892233528e-1_p
x(3)=-3.905684164427955_p
w(3)=7.552720003456840e-1_p
x(4)=-3.018859489863494_p
w(4)=9.491737322904167e-1_p
x(5)=-1.932243331598126_p
w(5)=1.020321021108807_p
x(6)=-6.998219529378917e-1_p
w(6)=8.628366281966012e-1_p
x(7)=6.527471986615967e-1_p
w(7)=4.867566006210698e-1_p
x(8)=2.164956503906273_p
w(8)=1.659216742833441e-1_p
x(9)=3.884646487024418_p
w(9)=3.680022278692933e-2_p
x(10)=5.812942908136693_p
w(10)=6.033085739055605e-3_p
x(11)=7.922529852764609_p
w(11)=7.926778823429941e-4_p
x(12)=10.17129406198134_p
w(12)=8.796149845650823e-5_p
x(13)=12.4954874734916_p
w(13)=8.731537032317220e-6_p
x(14)=14.79514425480385_p
w(14)=8.415959100669544e-7_p
x(15)=16.91729567228191_p
w(15)=8.843485658558792e-8_p
x(16)=18.64687923895842_p
w(16)=1.155608790274044e-8_p
x(17)=19.73085398880204_p
w(17)=1.842000843065406e-9_p
else
call GD(-5)
end if
end subroutine GF_m5

! [-4kT;20kT]
subroutine GF_m4(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-2.719496713984646_p
w(1)=2.798301252063006_p
x(2)=9.542764997457031e-1_p
w(2)=1.219848673793650_p
else if(N==3)then
x(1)=-3.173012632990873_p
w(1)=1.934931358549189_p
x(2)=-4.480599896994276e-1_p
w(2)=1.923952943958192_p
x(3)=3.489201449348225_p
w(3)=1.592656233492749e-1_p
else if(N==4)then
x(1)=-3.403334652801557_p
w(1)=1.434844815787320_p
x(2)=-1.259190038859078_p
w(2)=2.024494885341758_p
x(3)=1.674332305350226_p
w(3)=5.479787545729997e-1_p
x(4)=6.378100739312801_p
w(4)=1.083147015457917e-2_p
else if(N==5)then
x(1)=-3.539485743323353_p
w(1)=1.123045274186963_p
x(2)=-1.798397891525864_p
w(2)=1.883079245447433_p
x(3)=6.529136583531887e-1_p
w(3)=9.370003408896080e-1_p
x(4)=4.009797722163537_p
w(4)=7.447249160451849e-2_p
x(5)=9.465518696645498_p
w(5)=5.525737281331948e-4_p
else if(N==6)then
x(1)=-3.629623676891069_p
w(1)=9.107797927647495e-1_p
x(2)=-2.184363354823215_p
w(2)=1.682136414084184_p
x(3)=-6.052153842023029e-2_p
w(3)=1.204876283548037_p
x(4)=2.633650837031906_p
w(4)=2.135386168674908e-1_p
x(5)=6.548763409193670_p
w(5)=6.790757711555261e-3_p
x(6)=12.49595591553623_p
w(6)=2.806088063910535e-5_p
else if(N==7)then
x(1)=-3.694712403905061_p
w(1)=7.548643092667308e-1_p
x(2)=-2.478002537622574_p
w(2)=1.480639477454082_p
x(3)=-6.179234663297539e-1_p
w(3)=1.339737441432377_p
x(4)=1.670482648633667_p
w(4)=4.112661880664745e-1_p
x(5)=4.753788578107135_p
w(5)=3.105055089032537e-2_p
x(6)=9.052815017951236_p
w(6)=5.899093209623297e-4_p
x(7)=15.05328619531927_p
w(7)=2.049425704436516e-6_p
else if(N==8)then
x(1)=-3.744146027880347_p
w(1)=6.350889446131784e-1_p
x(2)=-2.709211569466338_p
w(2)=1.296703374655704_p
x(3)=-1.074866420773909_p
w(3)=1.368970377094676_p
x(4)=9.306815541903634e-1_p
w(4)=6.251662266867796e-1_p
x(5)=3.475338950120969_p
w(5)=8.813968932435687e-2_p
x(6)=6.872656881299914_p
w(6)=4.019339940839988e-3_p
x(7)=11.30505649252823_p
w(7)=6.169240003389807e-5_p
x(8)=16.84276247933977_p
w(8)=2.811410872203150e-7_p
else if(N==9)then
x(1)=-3.782641173214409_p
w(1)=5.410639152609780e-1_p
x(2)=-2.893928603473856_p
w(2)=1.136001336606903_p
x(3)=-1.454455587706490_p
w(3)=1.329621695544973_p
x(4)=3.337082845529452e-1_p
w(4)=8.102038046937357e-1_p
x(5)=2.506245705389476_p
w(5)=1.850904826401370e-1_p
x(6)=5.307736905071599_p
w(6)=1.559869311234313e-2_p
x(7)=8.857293236726097_p
w(7)=5.611635757766129e-4_p
x(8)=13.19166595726325_p
w(8)=8.764368424779279e-6_p
x(9)=17.94696644260667_p
w(9)=7.005338523454121e-8_p
else if(N==10)then
x(1)=-3.813142948747776_p
w(1)=4.661250727684342e-1_p
x(2)=-3.043036605625228_p
w(2)=9.985064506437289e-1_p
x(3)=-1.771134781213497_p
w(3)=1.253688675251249_p
x(4)=-1.626148037488350e-1_p
w(4)=9.401665682222319e-1_p
x(5)=1.741990522085521_p
w(5)=3.141794300329429e-1_p
x(6)=4.117263319634361_p
w(6)=4.263722235611513e-2_p
x(7)=7.076047025714577_p
w(7)=2.751965856716795e-3_p
x(8)=10.63124174676843_p
w(8)=9.276551300621736e-5_p
x(9)=14.69098136750633_p
w(9)=1.748606211323556e-6_p
x(10)=18.60552872387544_p
w(10)=2.660601964541094e-8_p
else if(N==11)then
x(1)=-3.837687620256652_p
w(1)=4.055568773212902e-1_p
x(2)=-3.164692159668400_p
w(2)=8.817619037277343e-1_p
x(3)=-2.036411508209886_p
w(3)=1.162636472536551_p
x(4)=-5.829799666505974e-1_p
w(4)=1.011232520126525_p
x(5)=1.119738952329945_p
w(5)=4.558365636455926e-1_p
x(6)=3.177928691202067_p
w(6)=9.138253317344279e-2_p
x(7)=5.705533414359719_p
w(7)=9.191963816260669e-3_p
x(8)=8.715541686683562_p
w(8)=5.316623261943893e-4_p
x(9)=12.16124156212969_p
w(9)=1.893725653467496e-5_p
x(10)=15.84107358993868_p
w(10)=4.787152262387374e-7_p
x(11)=19.00734403737174_p
w(11)=1.321130403577364e-8_p
else if(N==12)then
x(1)=-3.857717349813536_p
w(1)=3.559635242341943e-1_p
x(2)=-3.265015444841606_p
w(2)=7.827072746181788e-1_p
x(3)=-2.259748643860541_p
w(3)=1.068816944391015_p
x(4)=-9.429627655961811e-1_p
w(4)=1.033360050369715_p
x(5)=5.996077999944199e-1_p
w(5)=5.880562664731549e-1_p
x(6)=2.416374162828756_p
w(6)=1.634867658078988e-1_p
x(7)=4.613582316608333_p
w(7)=2.358178070270471e-2_p
x(8)=7.215604568038229_p
w(8)=2.054580481009621e-3_p
x(9)=10.19113649330486_p
w(9)=1.177430919851524e-4_p
x(10)=13.4459806660867_p
w(10)=4.817002988952119e-6_p
x(11)=16.70727143308225_p
w(11)=1.709130386300071e-7_p
x(12)=19.26333928248596_p
w(12)=7.770772670169595e-9_p
else if(N==13)then
x(1)=-3.874268803685094_p
w(1)=3.148743463818781e-1_p
x(2)=-3.348591865073080_p
w(2)=6.984340100327532e-1_p
x(3)=-2.448850225294378_p
w(3)=9.785934588365102e-1_p
x(4)=-1.253319889756932_p
w(4)=1.020759841167505_p
x(5)=1.558648721038777e-1_p
w(5)=6.948240648789626e-1_p
x(6)=1.785008365410621_p
w(6)=2.542694320401895e-1_p
x(7)=3.721963047539293_p
w(7)=4.982823704070461e-2_p
x(8)=6.004671787500202_p
w(8)=6.033664317579716e-3_p
x(9)=8.612908960877087_p
w(9)=5.008138716878877e-4_p
x(10)=11.48998203516824_p
w(10)=3.046923507226825e-5_p
x(11)=14.50524923480139_p
w(11)=1.507718181174696e-6_p
x(12)=17.35696561033623_p
w(12)=7.523053724358714e-8_p
x(13)=19.43400686201958_p
w(13)=5.105094165463511e-9_p
else if(N==14)then
x(1)=-3.888099687130590_p
w(1)=2.804670109321691e-1_p
x(2)=-3.418877763632679_p
w(2)=6.264217027003341e-1_p
x(3)=-2.609931796475318_p
w(3)=8.948513140122363e-1_p
x(4)=-1.522157798020391_p
w(4)=9.863162698692221e-1_p
x(5)=-2.283366281625022e-1_p
w(5)=7.692853126732241e-1_p
x(6)=1.251352729139890_p
w(6)=3.539546487983437e-1_p
x(7)=2.980041356053733_p
w(7)=9.061466525643494e-2_p
x(8)=5.005321486741800_p
w(8)=1.447153324778599e-2_p
x(9)=7.318436854864335_p
w(9)=1.621224374064362e-3_p
x(10)=9.880233032290354_p
w(10)=1.364001582434720e-4_p
x(11)=12.61481864990648_p
w(11)=9.234422982001365e-6_p
x(12)=15.36942680937407_p
w(12)=5.669374573209957e-7_p
x(13)=17.84696942525369_p
w(13)=3.885764804133208e-8_p
x(14)=19.55256323188418_p
w(14)=3.616510690654910e-9_p
else if(N==15)then
x(1)=-3.899773176755704_p
w(1)=2.513774502516415e-1_p
x(2)=-3.478503374187377_p
w(2)=5.645693413023131e-1_p
x(3)=-2.747985157123567_p
w(3)=8.185907058719639e-1_p
x(4)=-1.755957085255247_p
w(4)=9.397012582356349e-1_p
x(5)=-5.643623166846795e-1_p
w(5)=8.122559427364073e-1_p
x(6)=7.926880357802765e-1_p
w(6)=4.510762566052105e-1_p
x(7)=2.352900359283641_p
w(7)=1.460915897387672e-1_p
x(8)=4.166659220491386_p
w(8)=2.969482470017400e-2_p
x(9)=6.237010247397706_p
w(9)=4.276354747804532e-3_p
x(10)=8.535837145169525_p
w(10)=4.707787360939909e-4_p
x(11)=11.01271942458945_p
w(11)=4.189753334323413e-5_p
x(12)=13.57818580720449_p
w(12)=3.250945533883353e-6_p
x(13)=16.0714348710226_p
w(13)=2.490987947505294e-7_p
x(14)=18.22062820233743_p
w(14)=2.264975823337469e-8_p
x(15)=19.63789211688608_p
w(15)=2.703215185489215e-9_p
else if(N==16)then
x(1)=-3.909714496152418_p
w(1)=2.265699621381046e-1_p
x(2)=-3.529491540698608_p
w(2)=5.111549513356768e-1_p
x(3)=-2.867015697638959_p
w(3)=7.498454845421233e-1_p
x(4)=-1.960056517323353_p
w(4)=8.874480738880618e-1_p
x(5)=-8.602638498964631e-1_p
w(5)=8.288733656970350e-1_p
x(6)=3.929654135790356e-1_p
w(6)=5.360027522862743e-1_p
x(7)=1.815385495437166_p
w(7)=2.133492864676882e-1_p
x(8)=3.453304215000425_p
w(8)=5.378871039818401e-2_p
x(9)=5.320358336329229_p
w(9)=9.621803607279555e-3_p
x(10)=7.397487070351203_p
w(10)=1.329807319548068e-3_p
x(11)=9.648163864041555_p
w(11)=1.497623151346959e-4_p
x(12)=12.01385663985418_p
w(12)=1.451378095988482e-5_p
x(13)=14.39767669956981_p
w(13)=1.311005270670927e-6_p
x(14)=16.64194857208833_p
w(14)=1.245046097986403e-7_p
x(15)=18.50945945746057_p
w(15)=1.446837319408005e-8_p
x(16)=19.701185169736_p
w(16)=2.102332401793369e-9_p
else if(N==17)then
x(1)=-3.918249369050399_p
w(1)=2.052476147555685e-1_p
x(2)=-3.573414617390576_p
w(2)=4.647763707662376e-1_p
x(3)=-2.970242920487992_p
w(3)=6.881885991379391e-1_p
x(4)=-2.138908046686611_p
w(4)=8.336727354768388e-1_p
x(5)=-1.122085041276904_p
w(5)=8.256259648397192e-1_p
x(6)=4.076798824686492e-2_p
w(6)=6.029439079498236e-1_p
x(7)=1.348884151893164_p
w(7)=2.869932360771795e-1_p
x(8)=2.839561778714687_p
w(8)=8.792862515675051e-2_p
x(9)=4.534171241229017_p
w(9)=1.906458147796574e-2_p
x(10)=6.422159160477221_p
w(10)=3.206882073877103e-3_p
x(11)=8.475945977186687_p
w(11)=4.426560549805583e-4_p
x(12)=10.65391591661805_p
w(12)=5.243830318713310e-5_p
x(13)=12.89230771567484_p
w(13)=5.637192516674853e-6_p
x(14)=15.09248963203133_p
w(14)=5.958584163272123e-7_p
x(15)=17.10729430564639_p
w(15)=6.913793960579639e-8_p
x(16)=18.73594094428717_p
w(16)=9.912384340745388e-9_p
x(17)=19.7493506490613_p
w(17)=1.685331964718323e-9_p
else
call GD(-4)
end if
end subroutine GF_m4

! [-3kT;20kT]
subroutine GF_m3(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-1.899026163517452_p
w(1)=2.236588540418063_p
x(2)=1.474548226390046_p
w(2)=8.119988090945250e-1_p
else if(N==3)then
x(1)=-2.271699756309935_p
w(1)=1.607668025257257_p
x(2)=1.762876650700092e-1_p
w(2)=1.352286611210778_p
x(3)=4.103889501041373_p
w(3)=8.863271304455264e-2_p
else if(N==4)then
x(1)=-2.465822645246648_p
w(1)=1.221561154299015_p
x(2)=-5.395327558711692e-1_p
w(2)=1.502957355290956_p
x(3)=2.304678449687522_p
w(3)=3.185694903006692e-1_p
x(4)=7.062451531753508_p
w(4)=5.499349621948611e-3_p
else if(N==5)then
x(1)=-2.583021354124762_p
w(1)=9.715594256857147e-1_p
x(2)=-1.009587687844184_p
w(2)=1.462780630689223_p
x(3)=1.310276780142568_p
w(3)=5.758777434218986e-1_p
x(4)=4.699259437444258_p
w(4)=3.809787777191346e-2_p
x(5)=10.1749908371077_p
w(5)=2.716719438384666e-4_p
else if(N==6)then
x(1)=-2.662143005606560_p
w(1)=7.962840082582432e-1_p
x(2)=-1.348343667765059_p
w(2)=1.351909562850815_p
x(3)=6.307252313855010e-1_p
w(3)=7.845808445934581e-1_p
x(4)=3.319626818795520_p
w(4)=1.124427859146020e-1_p
x(5)=7.253257894695984_p
w(5)=3.355871008837062e-3_p
x(6)=13.15620788213959_p
w(6)=1.427688663271773e-5_p
else if(N==7)then
x(1)=-2.720144083096478_p
w(1)=6.647258397022427e-1_p
x(2)=-1.608822353554075_p
w(2)=1.220227844257277_p
x(3)=1.099603427765233e-1_p
w(3)=9.217476225288475e-1_p
x(4)=2.355101268667485_p
w(4)=2.260714234786887e-1_p
x(5)=5.451009284861322_p
w(5)=1.551424817043242e-2_p
x(6)=9.718665892402182_p
w(6)=2.992022289862543e-4_p
x(7)=15.56899350444421_p
w(7)=1.169146114283458e-6_p
else if(N==8)then
x(1)=-2.764570368921917_p
w(1)=5.623249844622001e-1_p
x(2)=-1.815416809625913_p
w(2)=1.089028708037467_p
x(3)=-3.103106258201946e-1_p
w(3)=9.891242021855650e-1_p
x(4)=1.623042439282659_p
w(4)=3.613490195483726e-1_p
x(5)=4.169376566531819_p
w(5)=4.469784561169001e-2_p
x(6)=7.544560033299692_p
w(6)=2.029081876464145e-3_p
x(7)=11.89455452035781_p
w(7)=3.332332643581949e-5_p
x(8)=17.18945588864407_p
w(8)=1.844643936388032e-7_p
else if(N==9)then
x(1)=-2.799351127793002_p
w(1)=4.812311633942068e-1_p
x(2)=-1.981355580401099_p
w(2)=9.680127952374578e-1_p
x(3)=-6.561219121179280e-1_p
w(3)=1.001294330584705_p
x(4)=1.042778197560238_p
w(4)=4.939434574533501e-1_p
x(5)=3.201136752100582_p
w(5)=9.596773711653812e-2_p
x(6)=5.987601604013397_p
w(6)=7.837959665029072e-3_p
x(7)=9.479701317710598_p
w(7)=2.947242719383610e-4_p
x(8)=13.68760736582019_p
w(8)=5.130395699634283e-6_p
x(9)=18.16696813182221_p
w(9)=5.139366335001781e-8_p
else if(N==10)then
x(1)=-2.827031092220042_p
w(1)=4.161447008589070e-1_p
x(2)=-2.115959644279501_p
w(2)=8.605418474143821e-1_p
x(3)=-9.435153516019765e-1_p
w(3)=9.765651403161771e-1_p
x(4)=5.690577377093047e-1_p
w(4)=6.043742386721851e-1_p
x(5)=2.441580206613977_p
w(5)=1.680791508274225e-1_p
x(6)=4.804887497099951_p
w(6)=2.141294186131451e-2_p
x(7)=7.721205913573651_p
w(7)=1.416736676694038e-3_p
x(8)=11.19019309871823_p
w(8)=5.146005202519744e-5_p
x(9)=15.0930822358549_p
w(9)=1.111793501245482e-6_p
x(10)=18.74670074725223_p
w(10)=2.103997965559869e-8_p
else if(N==11)then
x(1)=-2.849391466647514_p
w(1)=3.632286615767912e-1_p
x(2)=-2.226274218989301_p
w(2)=7.667831957790713e-1_p
x(3)=-1.184197195611528_p
w(3)=9.305073618595898e-1_p
x(4)=1.738842221482688e-1_p
w(4)=6.832528029888514e-1_p
x(5)=1.828228631351418_p
w(5)=2.536638046844873e-1_p
x(6)=3.872643388083994_p
w(6)=4.619113151936127e-2_p
x(7)=6.368269358257568_p
w(7)=4.663977641346811e-3_p
x(8)=9.313250165298481_p
w(8)=2.849050316788813e-4_p
x(9)=12.65104824253017_p
w(9)=1.116944430993453e-5_p
x(10)=16.16018494435796_p
w(10)=3.280208026571157e-7_p
x(11)=19.10154188632905_p
w(11)=1.096629799654453e-8_p
else if(N==12)then
x(1)=-2.867700926225207_p
w(1)=3.196836604937183e-1_p
x(2)=-2.317609654917503_p
w(2)=6.855892917890986e-1_p
x(3)=-1.387150922066861_p
w(3)=8.740860219932282e-1_p
x(4)=-1.608681099841802e-1_p
w(4)=7.300937584179239e-1_p
x(5)=1.321112573501069_p
w(5)=3.422473516972486e-1_p
x(6)=3.118068738753105_p
w(6)=8.388751286743473e-2_p
x(7)=5.290416154598057_p
w(7)=1.185682935830729e-2_p
x(8)=7.841258464641808_p
w(8)=1.073576794594388e-3_p
x(9)=10.73469610486599_p
w(9)=6.619336074940201e-5_p
x(10)=13.86765611243298_p
w(10)=3.021418364910086e-6_p
x(11)=16.95869425202797_p
w(11)=1.246629179634672e-7_p
x(12)=19.32902395007407_p
w(12)=6.659002261600236e-9_p
else if(N==13)then
x(1)=-2.882876180421500_p
w(1)=2.834510912248607e-1_p
x(2)=-2.393967516495575_p
w(2)=6.154085664032451e-1_p
x(3)=-1.559410008893141_p
w(3)=8.142223531664177e-1_p
x(4)=-4.475287397266580e-1_p
w(4)=7.496248938330787e-1_p
x(5)=8.936862229034644e-1_p
w(5)=4.239080661269412e-1_p
x(6)=2.494470001604444_p
w(6)=1.336099102144205e-1_p
x(7)=4.410381792446624_p
w(7)=2.497810543755974e-2_p
x(8)=6.652043098835143_p
w(8)=3.093319504750151e-3_p
x(9)=9.194460654888754_p
w(9)=2.719582404196153e-4_p
x(10)=11.9773682019341_p
w(10)=1.802162960711044e-5_p
x(11)=14.86429871732111_p
w(11)=1.001581314322440e-6_p
x(12)=17.55564764762682_p
w(12)=5.767936791814603e-8_p
x(13)=19.48170105107451_p
w(13)=4.470605662523251e-9_p
else if(N==14)then
x(1)=-2.895590605455140_p
w(1)=2.529984865429256e-1_p
x(2)=-2.458382667623555_p
w(2)=5.546799120958074e-1_p
x(3)=-1.706541013861669_p
w(3)=7.549519856697964e-1_p
x(4)=-6.949582745067074e-1_p
w(4)=7.484047047197278e-1_p
x(5)=5.278527758122137e-1_p
w(5)=4.917412684928752e-1_p
x(6)=1.970132314301898_p
w(6)=1.919494004738099e-1_p
x(7)=3.678354309286140_p
w(7)=4.560357672177767e-2_p
x(8)=5.670220964955984_p
w(8)=7.317356978984919e-3_p
x(9)=7.929089823476611_p
w(9)=8.571865397367081e-4_p
x(10)=10.41444578470982_p
w(10)=7.729776530870065e-5_p
x(11)=13.04745736122864_p
w(11)=5.742984146775133e-6_p
x(12)=15.67358152495498_p
w(12)=3.963343338679043e-7_p
x(13)=18.00539721096176_p
w(13)=3.097735014886821e-8_p
x(14)=19.58842151681606_p
w(14)=3.216007395975602e-9_p
else if(N==15)then
x(1)=-2.906346983063025_p
w(1)=2.271696468893235e-1_p
x(2)=-2.513178163597184_p
w(2)=5.019858553711319e-1_p
x(3)=-1.832978861470986_p
w(3)=6.984474961581606e-1_p
x(4)=-9.098491284780066e-1_p
w(4)=7.327447714743665e-1_p
x(5)=2.109694722326101e-1_p
w(5)=5.425539120173367e-1_p
x(6)=1.522693344177929_p
w(6)=2.539277840208712e-1_p
x(7)=3.060227808019410_p
w(7)=7.437310784321825e-2_p
x(8)=4.846033257115021_p
w(8)=1.488562579154144e-2_p
x(9)=6.871017763020998_p
w(9)=2.213932454727833e-3_p
x(10)=9.105883810327484_p
w(10)=2.580885432299769e-4_p
x(11)=11.49912839162374_p
w(11)=2.480613188231543e-5_p
x(12)=13.95975779660764_p
w(12)=2.119807933626563e-6_p
x(13)=16.32893100045844_p
w(13)=1.819649626532957e-7_p
x(14)=18.34847644866862_p
w(14)=1.861284001226999e-8_p
x(15)=19.66565463433124_p
w(15)=2.431061971346425e-9_p
else if(N==16)then
x(1)=-2.915526489964257_p
w(1)=2.050807189150388e-1_p
x(2)=-2.560150163397041_p
w(2)=4.560976353372423e-1_p
x(3)=-1.942274894764926_p
w(3)=6.457470555676023e-1_p
x(4)=-1.097451164003695_p
w(4)=7.078180692128189e-1_p
x(5)=-6.604677083738693e-2_p
w(5)=5.762507900952847e-1_p
x(6)=1.136001812047401_p
w(6)=3.143091308882644e-1_p
x(7)=2.531605310451986_p
w(7)=1.106971942996597e-1_p
x(8)=4.144895281444295_p
w(8)=2.688118081083382e-2_p
x(9)=5.973636868305720_p
w(9)=4.900436212256835e-3_p
x(10)=7.996259202113643_p
w(10)=7.098491560485710e-4_p
x(11)=10.17612398082308_p
w(11)=8.531817288476926e-5_p
x(12)=12.45396072965399_p
w(12)=8.969749323362047e-6_p
x(13)=14.73307211396723_p
w(13)=8.926203485066403e-7_p
x(14)=16.86050754206302_p
w(14)=9.439323146520832e-8_p
x(15)=18.61397271501091_p
w(15)=1.217490063325447e-8_p
x(16)=19.72321641039307_p
w(16)=1.906849344494569e-9_p
else if(N==17)then
x(1)=-2.923422179538762_p
w(1)=1.860476069666371e-1_p
x(2)=-2.600701521204353_p
w(2)=4.159740696877292e-1_p
x(3)=-2.037286627471556_p
w(3)=5.972268170508853e-1_p
x(4)=-1.261989500002568_p
w(4)=6.774911692008561e-1_p
x(5)=-3.099337606715348e-1_p
w(5)=5.946967421944789e-1_p
x(6)=7.981967602830967e-1_p
w(6)=3.687266372466651e-1_p
x(7)=2.074476488855203_p
w(7)=1.528003796067152e-1_p
x(8)=3.541782943939086_p
w(8)=4.407520334354223e-2_p
x(9)=5.203640995836692_p
w(9)=9.594159497967868e-3_p
x(10)=7.044669177332448_p
w(10)=1.674983295877783e-3_p
x(11)=9.037359397786821_p
w(11)=2.444143715234034e-4_p
x(12)=11.14003396685002_p
w(12)=3.105272942095969e-5_p
x(13)=13.28888218734695_p
w(13)=3.628536601759584e-6_p
x(14)=15.38701758353138_p
w(14)=4.216730446317404e-7_p
x(15)=17.29366478830163_p
w(15)=5.407344042940493e-8_p
x(16)=18.82247966173714_p
w(16)=8.498419692770887e-9_p
x(17)=19.76720151494118_p
w(17)=1.538782902061353e-9_p
else
call GD(-3)
end if
end subroutine GF_m3

! [-2kT;20kT]
subroutine GF_m2(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-1.066220034097021_p
w(1)=1.641100367047104_p
x(2)=2.078596438135421_p
w(2)=4.858276419347147e-1_p
else if(N==3)then
x(1)=-1.367378184155468_p
w(1)=1.231437228597912_p
x(2)=8.548587922947828e-1_p
w(2)=8.502144576059103e-1_p
x(3)=4.794837578776174_p
w(3)=4.527632277799609e-2_p
else if(N==4)then
x(1)=-1.527993574929365_p
w(1)=9.629640629654683e-1_p
x(2)=2.093491836446447e-1_p
w(2)=9.942104992883578e-1_p
x(3)=3.008748597549466_p
w(3)=1.671302725038385e-1_p
x(4)=7.806682557812393_p
w(4)=2.623174224154177e-3_p
else if(N==5)then
x(1)=-1.627141291295531_p
w(1)=7.809010949786521e-1_p
x(2)=-2.067055602664016e-1_p
w(2)=1.012717922197117_p
x(3)=2.030058980224111_p
w(3)=3.149626245711612e-1_p
x(4)=5.447623694628670_p
w(4)=1.821869783204629e-2_p
x(5)=10.92700246918326_p
w(5)=1.276694028421301e-4_p
else if(N==6)then
x(1)=-1.695510825115220_p
w(1)=6.484966341531939e-1_p
x(2)=-5.063758745806705e-1_p
w(2)=9.718990448608179e-1_p
x(3)=1.369259824956508_p
w(3)=4.501645956425062e-1_p
x(4)=4.063264866668415_p
w(4)=5.477286950293045e-2_p
x(5)=7.997101219365847_p
w(5)=1.587741444909788e-3_p
x(6)=13.82884637859542_p
w(6)=7.123377460572033e-6_p
else if(N==7)then
x(1)=-1.746403262092347_p
w(1)=5.464865195019724e-1_p
x(2)=-7.376651112934576e-1_p
w(2)=9.043611665178904e-1_p
x(3)=8.710454971597642e-1_p
w(3)=5.552731486870083e-1_p
x(4)=3.095346767862448_p
w(4)=1.132649378368052e-1_p
x(5)=6.188416328469295_p
w(5)=7.393736582069630e-3_p
x(6)=10.40601900292482_p
w(6)=1.478307452516695e-4_p
x(7)=16.07031287459467_p
w(7)=6.691108212438693e-7_p
else if(N==8)then
x(1)=-1.785721163040611_p
w(1)=4.657575369927372e-1_p
x(2)=-9.215359523349475e-1_p
w(2)=8.272369567538141e-1_p
x(3)=4.761427682967577e-1_p
w(3)=6.241455177568237e-1_p
x(4)=2.366461521175846_p
w(4)=1.873360908945970e-1_p
x(5)=4.906092201368669_p
w(5)=2.144089179838517e-2_p
x(6)=8.242790421247697_p
w(6)=9.931303082875164e-4_p
x(7)=12.49171682313924_p
w(7)=1.776227183088199e-5_p
x(8)=17.51631440949639_p
w(8)=1.222053432082104e-7_p
else if(N==9)then
x(1)=-1.816686337312994_p
w(1)=4.010532153024359e-1_p
x(2)=-1.069600451477005_p
w(2)=7.500979897174870e-1_p
x(3)=1.558098514637523e-1_p
w(3)=6.591164871902898e-1_p
x(4)=1.795625670422265_p
w(4)=2.662119324184376e-1_p
x(5)=3.940674764491016_p
w(5)=4.649335643686979e-2_p
x(6)=6.697250487413956_p
w(6)=3.800293946708710e-3_p
x(7)=10.11775219335386_p
w(7)=1.517065366510772e-4_p
x(8)=14.18205084345062_p
w(8)=2.989454102205599e-6_p
x(9)=18.37220431726115_p
w(9)=3.797883677017655e-8_p
else if(N==10)then
x(1)=-1.841456386384392_p
w(1)=3.486077924520480e-1_p
x(2)=-1.190103102957234_p
w(2)=6.776780034329719e-1_p
x(3)=-1.079725909839038e-1_p
w(3)=6.672704754520542e-1_p
x(4)=1.335872609328849_p
w(4)=3.395676359743460e-1_p
x(5)=3.186123274555454_p
w(5)=8.275053840681112e-2_p
x(6)=5.525207522089249_p
w(6)=1.031289558258739e-2_p
x(7)=8.386387242035706_p
w(7)=7.117417701317623e-4_p
x(8)=11.75661770428649_p
w(8)=2.820220355127338e-5_p
x(9)=15.48904816471687_p
w(9)=7.070064208445755e-7_p
x(10)=18.87851379765881_p
w(10)=1.670089638571560e-8_p
else if(N==11)then
x(1)=-1.861557425470005_p
w(1)=3.056147811804173e-1_p
x(2)=-1.289216839596177_p
w(2)=6.118635118630098e-1_p
x(3)=-3.277504731119256e-1_p
w(3)=6.565671876213264e-1_p
x(4)=9.574042113901489e-1_p
w(4)=4.004539010854893e-1_p
x(5)=2.579794942974852_p
w(5)=1.277731891904749e-1_p
x(6)=4.602548541009325_p
w(6)=2.219813915408123e-2_p
x(7)=7.054147322167680_p
w(7)=2.300378105396708e-3_p
x(8)=9.923512310147238_p
w(8)=1.501414219935640e-4_p
x(9)=13.14262647633145_p
w(9)=6.545047578032554e-6_p
x(10)=16.47183515777422_p
w(10)=2.251981369086063e-7_p
x(11)=19.18995628618291_p
w(11)=9.113914730978274e-9_p
else if(N==12)then
x(1)=-1.878083205920260_p
w(1)=2.699865950132723e-1_p
x(2)=-1.371569809470452_p
w(2)=5.530596642289293e-1_p
x(3)=-5.126427952285567e-1_p
w(3)=6.338296236326283e-1_p
x(4)=6.405106908324324e-1_p
w(4)=4.458142714930681e-1_p
x(5)=2.081770581681559_p
w(5)=1.774258124158033e-1_p
x(6)=3.856732247736341_p
w(6)=4.045504014032932e-2_p
x(7)=5.993015027772227_p
w(7)=5.768430142437869e-3_p
x(8)=8.482884787496188_p
w(8)=5.497829722762855e-4_p
x(9)=11.2851875993184_p
w(9)=3.680258109790869e-5_p
x(10)=14.28761475103272_p
w(10)=1.889542487935061e-6_p
x(11)=17.20308314176847_p
w(11)=9.111517632006593e-8_p
x(12)=19.39105823232656_p
w(12)=5.704311999092882e-9_p
else if(N==13)then
x(1)=-1.891828868415554_p
w(1)=2.401632834735923e-1_p
x(2)=-1.440648470353505_p
w(2)=5.009670423900126e-1_p
x(3)=-6.694835267234795e-1_p
w(3)=6.041848196826285e-1_p
x(4)=3.716558344116760e-1_p
w(4)=4.756410470330316e-1_p
x(5)=1.665339713678553_p
w(5)=2.271601484864355e-1_p
x(6)=3.241547061016198_p
w(6)=6.506409539224592e-2_p
x(7)=5.126910201055491_p
w(7)=1.204138690406700e-2_p
x(8)=7.318027982249643_p
w(8)=1.549321332092600e-3_p
x(9)=9.786522687971908_p
w(9)=1.455669573027876e-4_p
x(10)=12.46766498656767_p
w(10)=1.058443496289631e-5_p
x(11)=15.21983607898072_p
w(11)=6.646970847968614e-7_p
x(12)=17.74836124707999_p
w(12)=4.428842023695865e-8_p
x(13)=19.52700963320332_p
w(13)=3.909942247681275e-9_p
else if(N==14)then
x(1)=-1.903381891070975_p
w(1)=2.149677112333740e-1_p
x(2)=-1.499102952781264_p
w(2)=4.549906721976356e-1_p
x(3)=-8.035148908059161e-1_p
w(3)=5.711905303008138e-1_p
x(4)=1.411866556159305e-1_p
w(4)=4.917467142508735e-1_p
x(5)=1.311984246529449_p
w(5)=2.730740265711014e-1_p
x(6)=2.725766118333033_p
w(6)=9.497391384894500e-2_p
x(7)=4.406786255540569_p
w(7)=2.188987168413697e-2_p
x(8)=6.355997441002074_p
w(8)=3.601843718466878e-3_p
x(9)=8.552949719494160_p
w(9)=4.455046381491452e-4_p
x(10)=10.95504092588035_p
w(10)=4.335956689536721e-5_p
x(11)=13.48031954010245_p
w(11)=3.556354072343666e-6_p
x(12)=15.97354646789067_p
w(12)=2.770493173394032e-7_p
x(13)=18.15899460796538_p
w(13)=2.471345942009025e-8_p
x(14)=19.62266313982269_p
w(14)=2.854578085185966e-9_p
else if(N==15)then
x(1)=-1.913183251907535_p
w(1)=1.935014630532769e-1_p
x(2)=-1.548968558690417_p
w(2)=4.144466839899232e-1_p
x(3)=-9.188274390560646e-1_p
w(3)=5.371786685840868e-1_p
x(4)=-5.802767671659056e-2_p
w(4)=4.967111501494608e-1_p
x(5)=1.008498453102012_p
w(5)=3.124805264400630e-1_p
x(6)=2.287387160534650_p
w(6)=1.283686476980975e-1_p
x(7)=3.799145060041077_p
w(7)=3.572981931180202e-2_p
x(8)=5.548338192529540_p
w(8)=7.231476435743660e-3_p
x(9)=7.520433803932533_p
w(9)=1.123767747326725e-3_p
x(10)=9.684989391948525_p
w(10)=1.396936202622326e-4_p
x(11)=11.98888776150603_p
w(11)=1.458275424782703e-5_p
x(12)=14.33989842767502_p
w(12)=1.378768519828668e-6_p
x(13)=16.58220540866389_p
w(13)=1.329512921589993e-7_p
x(14)=18.47249003447152_p
w(14)=1.529618059661652e-8_p
x(15)=19.69228405733691_p
w(15)=2.181535512347795e-9_p
else if(N==16)then
x(1)=-1.921568874745178_p
w(1)=1.750709398073304e-1_p
x(2)=-1.591824801459587_p
w(2)=3.786616659262076e-1_p
x(3)=-1.018654159760660_p
w(3)=5.036029949888362e-1_p
x(4)=-2.314192104191669e-1_p
w(4)=4.931887843009306e-1_p
x(5)=7.452289590430614e-1_p
w(5)=3.440044783228693e-1_p
x(6)=1.910429894329551_p
w(6)=1.630787820452803e-1_p
x(7)=3.280110757905363_p
w(7)=5.351109020849094e-2_p
x(8)=4.861284324029938_p
w(8)=1.294152523499084e-2_p
x(9)=6.644249302989509_p
w(9)=2.440115379139874e-3_p
x(10)=8.606251655153043_p
w(10)=3.732796376688049e-4_p
x(11)=10.70997026240606_p
w(11)=4.814637041606301e-5_p
x(12)=12.89527309176452_p
w(12)=5.516352278540603e-6_p
x(13)=15.06612192660068_p
w(13)=6.068682302194751e-7_p
x(14)=17.07513634894392_p
w(14)=7.157412816756772e-8_p
x(15)=18.7154563541789_p
w(15)=1.023960607523507e-8_p
x(16)=19.74442931123554_p
w(16)=1.725414859494258e-9_p
else if(N==17)then
x(1)=-1.928798136756771_p
w(1)=1.591347112356378e-1_p
x(2)=-1.628909977393534_p
w(2)=3.470162755788110e-1_p
x(3)=-1.105576294125973_p
w(3)=4.713198774032770e-1_p
x(4)=-3.832316866761541e-1_p
w(4)=4.835454503452575e-1_p
x(5)=5.149528415692981e-1_p
w(5)=3.673716269425317e-1_p
x(6)=1.583019429537562_p
w(6)=1.969891654950345e-1_p
x(7)=2.832108423446134_p
w(7)=7.471466821936787e-2_p
x(8)=4.270404346061794_p
w(8)=2.111760816439906e-2_p
x(9)=5.892209113295132_p
w(9)=4.704270723011005e-3_p
x(10)=7.680235514008999_p
w(10)=8.600072976802088e-4_p
x(11)=9.606743398656306_p
w(11)=1.334105702881976e-4_p
x(12)=11.62965093982683_p
w(12)=1.826014003939780e-5_p
x(13)=13.68521895197925_p
w(13)=2.327759236519343e-6_p
x(14)=15.67878141419991_p
w(14)=2.981391054270032e-7_p
x(15)=17.47652674439262_p
w(15)=4.228765085259463e-8_p
x(16)=18.90661808473451_p
w(16)=7.279039157598189e-9_p
x(17)=19.78444561664107_p
w(17)=1.401451712419436e-9_p
else
call GD(-2)
end if
end subroutine GF_m2

! [-1kT;20kT]
subroutine GF_m1(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-2.078078135432576e-1_p
w(1)=1.057154562344903_p
x(2)=2.782856287477634_p
w(2)=2.561071231121658e-1_p
else if(N==3)then
x(1)=-4.523067451964153e-1_p
w(1)=8.263160333132147e-1_p
x(2)=1.608118380601964_p
w(2)=4.658083596761051e-1_p
x(3)=5.568247225618970_p
w(3)=2.113729246774953e-2_p
else if(N==4)then
x(1)=-5.849979564472317e-1_p
w(1)=6.654927506126811e-1_p
x(2)=1.008686701513450_p
w(2)=5.675664656827896e-1_p
x(3)=3.792831744391969_p
w(3)=7.903193338739728e-2_p
x(4)=8.615428141409778_p
w(4)=1.170535774201170e-3_p
else if(N==5)then
x(1)=-6.685827776209760e-1_p
w(1)=5.509929156986340e-1_p
x(2)=6.290520441187147e-1_p
w(2)=6.011118784897146e-1_p
x(3)=2.822008198216213_p
w(3)=1.529521594355647e-1_p
x(4)=6.256476418392828_p
w(4)=8.147441515796506e-3_p
x(5)=11.72160003125201_p
w(5)=5.729031735941469e-5_p
else if(N==6)then
x(1)=-7.273992767333894e-1_p
w(1)=4.643135581149367e-1_p
x(2)=3.569465252435143e-1_p
w(2)=5.972671107980448e-1_p
x(3)=2.169003418392102_p
w(3)=2.261510791678605e-1_p
x(4)=4.864943784160322_p
w(4)=2.480736707349611e-2_p
x(5)=8.780209271955981_p
w(5)=7.190718207978373e-4_p
x(6)=14.50773509684213_p
w(6)=3.498481933325867e-6_p
else if(N==7)then
x(1)=-7.717710800726797e-1_p
w(1)=3.956208445853512e-1_p
x(2)=1.476262073917522e-1_p
w(2)=5.728107238134230e-1_p
x(3)=1.682079485287854_p
w(3)=2.892336168579239e-1_p
x(4)=3.892634842047798_p
w(4)=5.215982545508237e-2_p
x(5)=6.965790137444456_p
w(5)=3.365106153007974e-3_p
x(6)=11.11360984827843_p
w(6)=7.118331524970849e-5_p
x(7)=16.55255163914606_p
w(7)=3.852770310827367e-7_p
else if(N==8)then
x(1)=-8.063047631146560e-1_p
w(1)=3.402278498282588e-1_p
x(2)=-1.813966624592739e-2_p
w(2)=5.377782607741222e-1_p
x(3)=1.302024402910146_p
w(3)=3.370509814261492e-1_p
x(4)=3.164990227880200_p
w(4)=8.795571877576699e-2_p
x(5)=5.684712563029843_p
w(5)=9.768118961805579e-3_p
x(6)=8.966988309499243_p
w(6)=4.713234112832201e-4_p
x(7)=13.09479484687303_p
w(7)=9.350514452027514e-6_p
x(8)=17.82234236094696_p
w(8)=8.176523132805852e-8_p
else if(N==9)then
x(1)=-8.336538470746396e-1_p
w(1)=2.951811031360888e-1_p
x(2)=-1.513589397199741e-1_p
w(2)=4.985862138761929e-1_p
x(3)=9.980466668386914e-1_p
w(3)=3.685465949183925e-1_p
x(4)=2.599726723781685_p
w(4)=1.278739447179903e-1_p
x(5)=4.723832334870893_p
w(5)=2.121580572236412e-2_p
x(6)=7.436207857394840_p
w(6)=1.779713957724812e-3_p
x(7)=10.77073101446243_p
w(7)=7.654571114693494e-5_p
x(8)=14.67345423953839_p
w(8)=1.735169502888511e-6_p
x(9)=18.56300631164319_p
w(9)=2.824766599824757e-8_p
else if(N==10)then
x(1)=-8.556416696697222e-1_p
w(1)=2.582222785950941e-1_p
x(2)=-2.597689483639785e-1_p
w(2)=4.590277611053850e-1_p
x(3)=7.504792547996523e-1_p
w(3)=3.855027290529676e-1_p
x(4)=2.148503414237521_p
w(4)=1.674197298639321e-1_p
x(5)=3.975227141563591_p
w(5)=3.794757221124472e-2_p
x(6)=6.277283619461572_p
w(6)=4.776878751297711e-3_p
x(7)=9.071152926794174_p
w(7)=3.489995524794778e-4_p
x(8)=12.32964332439898_p
w(8)=1.527324911900732e-5_p
x(9)=15.8779111270752_p
w(9)=4.497812961235606e-7_p
x(10)=19.00141398712293_p
w(10)=1.329425338133536e-8_p
else if(N==11)then
x(1)=-8.735665343135179e-1_p
w(1)=2.276104556534078e-1_p
x(2)=-3.490284045205150e-1_p
w(2)=4.211390956947352e-1_p
x(3)=5.458768176765028e-1_p
w(3)=3.908659947505750e-1_p
x(4)=1.780490876160855_p
w(4)=2.031173700862628e-1_p
x(5)=3.375721012993713_p
w(5)=5.914149591874034e-2_p
x(6)=5.366230520476260_p
w(6)=1.020172201971419e-2_p
x(7)=7.762626617389010_p
w(7)=1.103762464990245e-3_p
x(8)=10.54581885631093_p
w(8)=7.781541978243380e-5_p
x(9)=13.63519057399781_p
w(9)=3.810988556175820e-6_p
x(10)=16.77557794694785_p
w(10)=1.548828655655176e-7_p
x(11)=19.27290811536459_p
w(11)=7.577439402055198e-9_p
else if(N==12)then
x(1)=-8.883636239518541e-1_p
w(1)=2.020182850808107e-1_p
x(2)=-4.233137649696186e-1_p
w(2)=3.858916716570791e-1_p
x(3)=3.747255325245379e-1_p
w(3)=3.876741031165455e-1_p
x(4)=1.475133931157608_p
w(4)=2.328839857942361e-1_p
x(5)=2.885295525136240_p
w(5)=8.325994512544463e-2_p
x(6)=4.630789248679316_p
w(6)=1.851524650649992e-2_p
x(7)=6.720509953480407_p
w(7)=2.720983601407894e-3_p
x(8)=9.140072770451484_p
w(8)=2.759780673529861e-4_p
x(9)=11.84208929102764_p
w(9)=2.023671877877199e-5_p
x(10)=14.70528086217616_p
w(10)=1.178201918270973e-6_p
x(11)=17.44031170704103_p
w(11)=6.670569235885105e-8_p
x(12)=19.44964894327067_p
w(12)=4.881302937341475e-9_p
else if(N==13)then
x(1)=-9.007165581151327e-1_p
w(1)=1.804332053980984e-1_p
x(2)=-4.857438766355617e-1_p
w(2)=3.536466622881433e-1_p
x(3)=2.300890003220723e-1_p
w(3)=3.785613053589350e-1_p
x(4)=1.218210167129451_p
w(4)=2.558970210043287e-1_p
x(5)=2.477190158099498_p
w(5)=1.085005586174131e-1_p
x(6)=4.025080146580491_p
w(6)=2.977549733508324e-2_p
x(7)=5.870256683909782_p
w(7)=5.605409591342655e-3_p
x(8)=8.002117878658760_p
w(8)=7.585754925171567e-4_p
x(9)=10.38871825535088_p
w(9)=7.679970665167325e-5_p
x(10)=12.96041498024451_p
w(10)=6.172593587823810e-6_p
x(11)=15.57150531949546_p
w(11)=4.406186398315261e-7_p
x(12)=17.93513405893552_p
w(12)=3.403928723713190e-8_p
x(13)=19.57006489696688_p
w(13)=3.413041144700660e-9_p
else if(N==14)then
x(1)=-9.111331711550708e-1_p
w(1)=1.620776561692692e-1_p
x(2)=-5.386787009787692e-1_p
w(2)=3.244311596875852e-1_p
x(3)=1.067785034110307e-1_p
w(3)=3.656109524149645e-1_p
x(4)=9.995506016391986e-1_p
w(4)=2.722497168417121e-1_p
x(5)=2.132773931717326_p
w(5)=1.331760208553119e-1_p
x(6)=3.518194436605947_p
w(6)=4.364098873437369e-2_p
x(7)=5.163688119530732_p
w(7)=1.009256902277737e-2_p
x(8)=7.061897816850720_p
w(8)=1.728507665769972e-3_p
x(9)=9.189658388056937_p
w(9)=2.276322202861278e-4_p
x(10)=11.50167565118863_p
w(10)=2.407340830377234e-5_p
x(11)=13.91305407933492_p
w(11)=2.192594992345689e-6_p
x(12)=16.26913923466671_p
w(12)=1.935941151267162e-7_p
x(13)=18.30784807984619_p
w(13)=1.971995773571251e-8_p
x(14)=19.65537471460475_p
w(14)=2.527650207430609e-9_p
else if(N==15)then
x(1)=-9.199966006153726e-1_p
w(1)=1.463492841061634e-1_p
x(2)=-5.839270078194401e-1_p
w(2)=2.981002265299145e-1_p
x(3)=8.304044046925833e-4_p
w(3)=3.503777745208787e-1_p
x(4)=8.116720790934191e-1_p
w(4)=2.825869284904646e-1_p
x(5)=1.838661682636958_p
w(5)=1.559476635449656e-1_p
x(6)=3.088392187226868_p
w(6)=5.946698560996398e-2_p
x(7)=4.567888352627901_p
w(7)=1.637459316691649e-2_p
x(8)=6.272483785624347_p
w(8)=3.414538502366781e-3_p
x(9)=8.184806422707950_p
w(9)=5.595252842842042e-4_p
x(10)=10.27286454535759_p
w(10)=7.464889345990982e-5_p
x(11)=12.48170872998708_p
w(11)=8.510832119026072e-6_p
x(12)=14.71836914169446_p
w(12)=8.943368458239393e-7_p
x(13)=16.83119264385435_p
w(13)=9.712212340628012e-8_p
x(14)=18.59276882530315_p
w(14)=1.256427973002074e-8_p
x(15)=19.71783895069956_p
w(15)=1.952323073956100e-9_p
else if(N==16)then
x(1)=-9.276000770311494e-1_p
w(1)=1.327770759393042e-1_p
x(2)=-6.228918294368466e-1_p
w(2)=2.744296009294387e-1_p
x(3)=-9.083507180026983e-2_p
w(3)=3.339749914027833e-1_p
x(4)=6.489285364852757e-1_p
w(4)=2.878124944687822e-1_p
x(5)=1.584986582618796_p
w(5)=1.759141551875334e-1_p
x(6)=2.719877192251520_p
w(6)=7.644336779431296e-2_p
x(7)=4.059417265701616_p
w(7)=2.446395644811014e-2_p
x(8)=5.601026467932384_p
w(8)=6.032654653086414e-3_p
x(9)=7.331553300811773_p
w(9)=1.189236366525589e-3_p
x(10)=9.227157681629118_p
w(10)=1.933906648717739e-4_p
x(11)=11.24946237366142_p
w(11)=2.691002613419030e-5_p
x(12)=13.33757145473608_p
w(12)=3.375290844740448e-6_p
x(13)=15.39668508812408_p
w(13)=4.118704520827503e-7_p
x(14)=17.28583987450632_p
w(14)=5.425524415200357e-8_p
x(15)=18.81400494185795_p
w(15)=8.602890609381653e-9_p
x(16)=19.76486480580928_p
w(16)=1.556754679570846e-9_p
else if(N==17)then
x(1)=-9.341709845433294e-1_p
w(1)=1.209892612910832e-1_p
x(2)=-6.566736393798296e-1_p
w(2)=2.531673485497491e-1_p
x(3)=-1.706447173347968e-1_p
w(3)=3.171732880570564e-1_p
x(4)=5.069675945727491e-1_p
w(4)=2.888906863477371e-1_p
x(5)=1.364313835221696_p
w(5)=1.925946002334287e-1_p
x(6)=2.400876789835004_p
w(6)=9.373028155905565e-2_p
x(7)=3.621041452775635_p
w(7)=3.419648322353692e-2_p
x(8)=5.023707036125807_p
w(8)=9.748866493871567e-3_p
x(9)=6.598968600091762_p
w(9)=2.252256117286383e-3_p
x(10)=8.328463936633577_p
w(10)=4.342314702614137e-4_p
x(11)=10.1838689021819_p
w(11)=7.198252981701427e-5_p
x(12)=12.12257423196023_p
w(12)=1.066060168577697e-5_p
x(13)=14.0811631100221_p
w(13)=1.487898537970275e-6_p
x(14)=15.96771487972827_p
w(14)=2.105333311680940e-7_p
x(15)=17.65592313160491_p
w(15)=3.305264283342504e-8_p
x(16)=18.98843928066302_p
w(16)=6.225402240183852e-9_p
x(17)=19.80111246909597_p
w(17)=1.272585610363353e-9_p
else
call GD(-1)
end if
end subroutine GF_m1

! [0kT;20kT]
subroutine GF_0(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=6.905366097034107e-1_p
w(1)=5.746622256022194e-1_p
x(2)=3.592369113059146_p
w(2)=1.184849528965723e-1_p
else if(N==3)then
x(1)=4.840024498707995e-1_p
w(1)=4.633273621850556e-1_p
x(2)=2.446481123918459_p
w(2)=2.207763778666485e-1_p
x(3)=6.423460615360121_p
w(3)=9.043438447087540e-3_p
else if(N==4)then
x(1)=3.708144795596844e-1_p
w(1)=3.821749717934190e-1_p
x(2)=1.873098577411824_p
w(2)=2.764940406032944e-1_p
x(3)=4.654707614891986_p
w(3)=3.398889070066326e-2_p
x(4)=9.487569530700499_p
w(4)=4.892754014150878e-4_p
else if(N==5)then
x(1)=2.983816964537942e-1_p
w(1)=3.219625822396813e-1_p
x(2)=1.513595552612061_p
w(2)=3.009236818876643e-1_p
x(3)=3.685293199205558_p
w(3)=6.681089923493698e-2_p
x(4)=7.121920923122270_p
w(4)=3.425334381193591e-3_p
x(5)=12.55184010198775_p
w(5)=2.468075531560949e-5_p
else if(N==6)then
x(1)=2.465869808444293e-1_p
w(1)=2.747365258711622e-1_p
x(2)=1.256950072398602_p
w(2)=3.066816701805964e-1_p
x(3)=3.032572048958998_p
w(3)=1.008695418868429e-1_p
x(4)=5.719668757161128_p
w(4)=1.054460469694755e-2_p
x(5)=9.597590104091454_p
w(5)=3.131295861570481e-4_p
x(6)=15.18122967277488_p
w(6)=1.706277085609257e-6_p
else if(N==7)then
x(1)=2.071733355044010e-1_p
w(1)=2.364055543127234e-1_p
x(2)=1.060859378365405_p
w(2)=3.009721193531482e-1_p
x(3)=2.549404334764319_p
w(3)=1.318820375460349e-1_p
x(4)=4.742093807550726_p
w(4)=2.238406134770009e-2_p
x(5)=7.778876677875569_p
w(5)=1.469628861895314e-3_p
x(6)=11.83607885685083_p
w(6)=3.355268632165619e-5_p
x(7)=17.00895814561992_p
w(7)=2.243909681365102e-7_p
else if(N==8)then
x(1)=1.763738884414053e-1_p
w(1)=2.049905233577231e-1_p
x(2)=9.067609151406660e-1_p
w(2)=2.884663863935446e-1_p
x(3)=2.176574035117496_p
w(3)=1.571309198226198e-1_p
x(4)=4.014841767678537_p
w(4)=3.808180147337479e-2_p
x(5)=6.500763343455906_p
w(5)=4.254948319699631e-3_p
x(6)=9.713215297889938_p
w(6)=2.176631283220947e-4_p
x(7)=13.69889898993647_p
w(7)=4.880661433621628e-6_p
x(8)=18.10563755637385_p
w(8)=5.534207404047916e-8_p
else if(N==9)then
x(1)=1.519002192044170e-1_p
w(1)=1.791050703949638e-1_p
x(2)=7.835992349545350e-1_p
w(2)=2.724041926790921e-1_p
x(3)=1.881605672876344_p
w(3)=1.756494360800099e-1_p
x(4)=3.453330698315108_p
w(4)=5.593170463436919e-2_p
x(5)=5.545742123304552_p
w(5)=9.209638860487163e-3_p
x(6)=8.200802180000208_p
w(6)=8.081298793296319e-4_p
x(7)=11.43489981481802_p
w(7)=3.797857607024529e-5_p
x(8)=15.15807052630015_p
w(8)=1.006243893011702e-6_p
x(9)=18.73908060047862_p
w(9)=2.115057672325852e-8_p
else if(N==10)then
x(1)=1.321587566066044e-1_p
w(1)=1.576260358531522e-1_p
x(2)=6.837113587637336e-1_p
w(2)=2.548914005574359e-1_p
x(3)=1.643598264943470_p
w(3)=1.877449643215169e-1_p
x(4)=3.007796002345969_p
w(4)=7.413013932919849e-2_p
x(5)=4.803944861831943_p
w(5)=1.643994029065446e-2_p
x(6)=7.057272100954898_p
w(6)=2.138679621251575e-3_p
x(7)=9.772242556684386_p
w(7)=1.675252626563694e-4_p
x(8)=12.90597234299344_p
w(8)=8.195841949644954e-6_p
x(9)=16.2571978891663_p
w(9)=2.868102758734056e-7_p
x(10)=19.11541270737028_p
w(10)=1.061070027160473e-8_p
else if(N==11)then
x(1)=1.160142522301939e-1_p
w(1)=1.396617103493293e-1_p
x(2)=6.016263629459188e-1_p
w(2)=2.372096181559801e-1_p
x(3)=1.448404632582103_p
w(3)=1.943487958310655e-1_p
x(4)=2.646626600797466_p
w(4)=9.122037928715143e-2_p
x(5)=4.211554085554075_p
w(5)=2.563226164073556e-2_p
x(6)=6.159496600778008_p
w(6)=4.515462603819153e-3_p
x(7)=8.490556028585994_p
w(7)=5.168650168140863e-4_p
x(8)=11.17725408753302_p
w(8)=3.976275979567244e-5_p
x(9)=14.12606687671438_p
w(9)=2.209724162103790e-6_p
x(10)=17.06991274894891_p
w(10)=1.068290461507820e-7_p
x(11)=19.35042507355394_p
w(11)=6.300892631770638e-9_p
else if(N==12)then
x(1)=1.026477938878647e-1_p
w(1)=1.245164598766120e-1_p
x(2)=5.333775969404961e-1_p
w(2)=2.200941041998854e-1_p
x(3)=1.286138125874309_p
w(3)=1.965764658150337e-1_p
x(4)=2.348756316051825_p
w(4)=1.062413570632109e-1_p
x(5)=3.728357425650616_p
w(5)=3.619785851102099e-2_p
x(6)=5.435723040323848_p
w(6)=8.123642077724940e-3_p
x(7)=7.469627016698039_p
w(7)=1.249345517969259e-3_p
x(8)=9.810094673252243_p
w(8)=1.361305183656348e-4_p
x(9)=12.40287884261344_p
w(9)=1.102816434687449e-5_p
x(10)=15.11862290655453_p
w(10)=7.336400735533589e-7_p
x(11)=17.66948786906039_p
w(11)=4.894308448645597e-8_p
x(12)=19.50480367431605_p
w(12)=4.171463944676689e-9_p
else if(N==13)then
x(1)=9.145915800796238e-2_p
w(1)=1.116491200520873e-1_p
x(2)=4.760392385902768e-1_p
w(2)=2.039346548969456e-1_p
x(3)=1.149686222068920_p
w(3)=1.954938249887513e-1_p
x(4)=2.099590168711990_p
w(4)=1.186995345884289e-1_p
x(5)=3.327530639755115_p
w(5)=4.744368678936864e-2_p
x(6)=4.840436306328388_p
w(6)=1.298538370047972e-2_p
x(7)=6.636883974787623_p
w(7)=2.533000326613364e-3_p
x(8)=8.701610225374569_p
w(8)=3.640516051909364e-4_p
x(9)=10.99866337550485_p
w(9)=4.002000512722738e-5_p
x(10)=13.45351995567507_p
w(10)=3.580318757005833e-6_p
x(11)=15.91782252941329_p
w(11)=2.920609673557256e-7_p
x(12)=18.11542228413821_p
w(12)=2.619331338548554e-8_p
x(13)=19.61086017919125_p
w(13)=2.972760999005648e-9_p
else if(N==14)then
x(1)=8.200109615393797e-2_p
w(1)=1.006370874555654e-1_p
x(2)=4.274166487378887e-1_p
w(2)=1.889093000901600e-1_p
x(3)=1.033801030514381_p
w(3)=1.920163562536063e-1_p
x(4)=1.888684191639171_p
w(4)=1.284637186161999e-1_p
x(5)=2.990403050203590_p
w(5)=5.870872940907412e-2_p
x(6)=4.343010910382036_p
w(6)=1.896901308731873e-2_p
x(7)=5.945208225279724_p
w(7)=4.502338170620262e-3_p
x(8)=7.785115751542271_p
w(8)=8.112981890277137e-4_p
x(9)=9.836895050050924_p
w(9)=1.145850386157848e-4_p
x(10)=12.05229425306829_p
w(10)=1.325129371305058e-5_p
x(11)=14.3439702392825_p
w(11)=1.347600146965841e-6_p
x(12)=16.55929372102563_p
w(12)=1.353234603812042e-7_p
x(13)=18.45160930005931_p
w(13)=1.573914244769017e-8_p
x(14)=19.6865429751178_p
w(14)=2.232140660311589e-9_p
else if(N==15)then
x(1)=7.393513494508311e-2_p
w(1)=9.114822519913050e-2_p
x(2)=3.858382152878291e-1_p
w(2)=1.750700182774802e-1_p
x(3)=9.345266632476661e-1_p
w(3)=1.868829560239184e-1_p
x(4)=1.708359563150926_p
w(4)=1.356457957090617e-1_p
x(5)=2.703543040409458_p
w(5)=6.944641363403854e-2_p
x(6)=3.921928427985752_p
w(6)=2.583014013584760e-2_p
x(7)=5.362337867741981_p
w(7)=7.231223509564019e-3_p
x(8)=7.015463489469431_p
w(8)=1.573459835686179e-3_p
x(9)=8.861797134907963_p
w(9)=2.738954088722005e-4_p
x(10)=10.86749464788998_p
w(10)=3.945061517400884e-5_p
x(11)=12.97585171078714_p
w(11)=4.938037257917014e-6_p
x(12)=15.09383589465859_p
w(12)=5.790899374554416e-7_p
x(13)=17.07512612198807_p
w(13)=7.096631274596643e-8_p
x(14)=18.70907665257274_p
w(14)=1.031453010807247e-8_p
x(15)=19.74230400520064_p
w(15)=1.741980004564276e-9_p
else if(N==16)then
x(1)=6.700144901979534e-2_p
w(1)=8.291955128054990e-2_p
x(2)=3.500130075443184e-1_p
w(2)=1.623964804369464e-1_p
x(3)=8.488267344231203e-1_p
w(3)=1.806660595934003e-1_p
x(4)=1.552839544411604_p
w(4)=1.404981768752304e-1_p
x(5)=2.457027721976978_p
w(5)=7.925820715014753e-2_p
x(6)=3.561560414445437_p
w(6)=3.326365112806385e-2_p
x(7)=4.865279167661211_p
w(7)=1.072233653201580e-2_p
x(8)=6.360857034242875_p
w(8)=2.737717870081180e-3_p
x(9)=8.033117552019529_p
w(9)=5.688042919056654e-4_p
x(10)=9.856969109709377_p
w(10)=9.888937690090215e-5_p
x(11)=11.79285836694382_p
w(11)=1.491798404145379e-5_p
x(12)=13.77940778314659_p
w(12)=2.057001313398721e-6_p
x(13)=15.72372016964358_p
w(13)=2.792341084361468e-7_p
x(14)=17.49206006064172_p
w(14)=4.112465498675332e-8_p
x(15)=18.90944959576087_p
w(15)=7.219280174176737e-9_p
x(16)=19.78450778460082_p
w(16)=1.400151389405812e-9_p
else if(N==17)then
x(1)=6.099798133251978e-2_p
w(1)=7.574121764662350e-2_p
x(2)=3.189315908168672e-1_p
w(2)=1.508291937779176e-1_p
x(3)=7.743344321532305e-1_p
w(3)=1.737961646657497e-1_p
x(4)=1.417692369118488_p
w(4)=1.433377762381213e-1_p
x(5)=2.243362735443435_p
w(5)=8.789287576870722e-2_p
x(6)=3.250254893065116_p
w(6)=4.095155397992387e-2_p
x(7)=4.437123874248629_p
w(7)=1.491162629253517e-2_p
x(8)=5.798158195437080_p
w(8)=4.368613039782934e-3_p
x(9)=7.321330826823492_p
w(9)=1.056359567682870e-3_p
x(10)=8.987308325705799_p
w(10)=2.160334937592576e-4_p
x(11)=10.7669922544558_p
w(11)=3.844831219479907e-5_p
x(12)=12.61731054963091_p
w(12)=6.186431558392573e-6_p
x(13)=14.47552319025214_p
w(13)=9.484371233088032e-7_p
x(14)=16.25300679238021_p
w(14)=1.485566686621393e-7_p
x(15)=17.83143999651618_p
w(15)=2.582310885469672e-8_p
x(16)=19.06781695027127_p
w(16)=5.315519705981011e-9_p
x(17)=19.817188122823_p
w(17)=1.151814584614871e-9_p
else
call GD(0)
end if
end subroutine GF_0

! [1kT;20kT]
subroutine GF_1(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=1.631820361509391_p
w(1)=2.640316398959334e-1_p
x(2)=4.490295145025447_p
w(2)=4.923004556113577e-2_p
else if(N==3)then
x(1)=1.446041426684863_p
w(1)=2.167934958906810e-1_p
x(2)=3.359037398840869_p
w(2)=9.286179528685433e-2_p
x(3)=7.345569895664654_p
w(3)=3.606394279533881e-3_p
else if(N==4)then
x(1)=1.343705779415806_p
w(1)=1.814238180582268e-1_p
x(2)=2.797698632068868_p
w(2)=1.180462624648825e-1_p
x(3)=5.578255791620268_p
w(3)=1.359734223392907e-2_p
x(4)=10.40903736386413_p
w(4)=1.942627000308138e-4_p
else if(N==5)then
x(1)=1.277429170871603_p
w(1)=1.544085317209832e-1_p
x(2)=2.446261179688152_p
w(2)=1.304641630253978e-1_p
x(3)=4.604343111337845_p
w(3)=2.700314209619667e-2_p
x(4)=8.028836135646216_p
w(4)=1.375459793754534e-3_p
x(5)=13.39786769579302_p
w(5)=1.038882073701667e-5_p
else if(N==6)then
x(1)=1.229531338274538_p
w(1)=1.326957322499658e-1_p
x(2)=2.195638134634466_p
w(2)=1.348778453573468e-1_p
x(3)=3.946910813418745_p
w(3)=4.127284731120347e-2_p
x(4)=6.612757925780194_p
w(4)=4.281479738323583e-3_p
x(5)=10.43473982774769_p
w(5)=1.329403762440317e-4_p
x(6)=15.83002340503259_p
w(6)=8.404239856012387e-7_p
else if(N==7)then
x(1)=1.192982111715311_p
w(1)=1.148235167159037e-1_p
x(2)=2.005495848569531_p
w(2)=1.340874771459376e-1_p
x(3)=3.463170444281634_p
w(3)=5.457163050746523e-2_p
x(4)=5.629583721483674_p
w(4)=9.139514459835338e-3_p
x(5)=8.615237966226363_p
w(5)=6.237448152024678e-4_p
x(6)=12.56065098617382_p
w(6)=1.566839621968201e-5_p
x(7)=17.43011575223994_p
w(7)=1.334165052252268e-7_p
else if(N==8)then
x(1)=1.164425488963650_p
w(1)=1.000441118227371e-1_p
x(2)=1.857287285432770_p
w(2)=1.300260248893624e-1_p
x(3)=3.093119659848662_p
w(3)=6.570402023024442e-2_p
x(4)=4.902536398355223_p
w(4)=1.559029307848960e-2_p
x(5)=7.342408927621206_p
w(5)=1.795790781804868e-3_p
x(6)=10.47059788080353_p
w(6)=9.885604147673958e-5_p
x(7)=14.29378298349721_p
w(7)=2.550564720499962e-6_p
x(8)=18.36297880852571_p
w(8)=3.804823361621802e-8_p
else if(N==9)then
x(1)=1.141731720015883_p
w(1)=8.777428735153178e-2_p
x(2)=1.739580705470705_p
w(2)=1.240891632556367e-1_p
x(3)=2.802643651093910_p
w(3)=7.420741631684656e-2_p
x(4)=4.344083041680611_p
w(4)=2.295124853039570e-2_p
x(5)=6.394704476342512_p
w(5)=3.860805441188231e-3_p
x(6)=8.980933737999274_p
w(6)=3.594646440258957e-4_p
x(7)=12.10091594867498_p
w(7)=1.869673991272380e-5_p
x(8)=15.62850295105454_p
w(8)=5.872019266851415e-7_p
x(9)=18.89923291286082_p
w(9)=1.597560493202212e-8_p
else if(N==10)then
x(1)=1.123416329012360_p
w(1)=7.752540889460055e-2_p
x(2)=1.644556843274109_p
w(2)=1.172203269801525e-1_p
x(3)=2.569842468410844_p
w(3)=8.013342722426006e-2_p
x(4)=3.902993996323516_p
w(4)=3.051307835848948e-2_p
x(5)=5.660651299393292_p
w(5)=6.850116225372997e-3_p
x(6)=7.855385359886804_p
w(6)=9.353454386116613e-4_p
x(7)=10.48091887356708_p
w(7)=7.939940192418988e-5_p
x(8)=13.4779364716315_p
w(8)=4.390199586343072e-6_p
x(9)=16.62195145727623_p
w(9)=1.842318425398206e-7_p
x(10)=19.21990209243095_p
w(10)=8.502228880037965e-9_p
else if(N==11)then
x(1)=1.108427268781370_p
w(1)=6.890374294903058e-2_p
x(2)=1.566734069734556_p
w(2)=1.100231852370997e-1_p
x(3)=2.380029263335139_p
w(3)=8.379363673644036e-2_p
x(4)=3.546958637163584_p
w(4)=3.770401413307721e-2_p
x(5)=5.075899158010220_p
w(5)=1.063008033666140e-2_p
x(6)=6.972628399081833_p
w(6)=1.947260706298480e-3_p
x(7)=9.229544951477401_p
w(7)=2.382240220807677e-4_p
x(8)=11.81035535276383_p
w(8)=2.017854272255500e-5_p
x(9)=14.60923032143072_p
w(9)=1.283401121706213e-6_p
x(10)=17.35159108668223_p
w(10)=7.414770472174814e-8_p
x(11)=19.42211104329995_p
w(11)=5.244831753970231e-9_p
else if(N==12)then
x(1)=1.096007639217780_p
w(1)=6.159816830656922e-2_p
x(2)=1.502192311915733_p
w(2)=1.028676074428996e-1_p
x(3)=2.223023311492512_p
w(3)=8.559107414265611e-2_p
x(4)=3.254526396535476_p
w(4)=4.414083460286632e-2_p
x(5)=4.600064630700720_p
w(5)=1.496512046510468e-2_p
x(6)=6.261778165400133_p
w(6)=3.462677346516992e-3_p
x(7)=8.232134870903471_p
w(7)=5.632554369246691e-4_p
x(8)=10.48569969787551_p
w(8)=6.645735920582702e-5_p
x(9)=12.96131780313937_p
w(9)=5.992453363758987e-6_p
x(10)=15.52304096449983_p
w(10)=4.582641739557295e-7_p
x(11)=17.88844522370771_p
w(11)=3.607432386042418e-8_p
x(12)=19.55623431901526_p
w(12)=3.562464236921194e-9_p
else if(N==13)then
x(1)=1.085603214232979_p
w(1)=5.536384291776777e-2_p
x(2)=1.448070130089477_p
w(2)=9.596932352680619e-2_p
x(3)=2.091556260800493_p
w(3)=8.592772213870863e-2_p
x(4)=3.010866033210275_p
w(4)=4.961581595247148e-2_p
x(5)=4.206275480415156_p
w(5)=1.958531187020513e-2_p
x(6)=5.677828915255419_p
w(6)=5.482659736680869e-3_p
x(7)=7.418587635611496_p
w(7)=1.121509839338556e-3_p
x(8)=9.409397160054358_p
w(8)=1.724830019726123e-4_p
x(9)=11.6101285980445_p
w(9)=2.072356592612560e-5_p
x(10)=13.94186479261898_p
w(10)=2.075858463757624e-6_p
x(11)=16.25531703956248_p
w(11)=1.942499215348430e-7_p
x(12)=18.28772769680671_p
w(12)=2.021388613545594e-8_p
x(13)=19.64917664197957_p
w(13)=2.584920439208805e-9_p
else if(N==14)then
x(1)=1.076801114598821_p
w(1)=5.000762757544391e-2_p
x(2)=1.402238759433223_p
w(2)=8.944506160561747e-2_p
x(3)=1.980305793932453_p
w(3)=8.516134718925819e-2_p
x(4)=2.805380935824817_p
w(4)=5.405753098396850e-2_p
x(5)=3.875853978859500_p
w(5)=2.423679209854998e-2_p
x(6)=5.190494724438752_p
w(6)=7.949114782170563e-3_p
x(7)=6.743086625010244_p
w(7)=1.963648197978760e-3_p
x(8)=8.518609315530322_p
w(8)=3.751826206165726e-4_p
x(9)=10.48848448066193_p
w(9)=5.717262501297264e-5_p
x(10)=12.6015985878617_p
w(10)=7.269317896217168e-6_p
x(11)=14.76892776233636_p
w(11)=8.290386373986409e-7_p
x(12)=16.84138658327256_p
w(12)=9.487482150947472e-8_p
x(13)=18.58920020231517_p
w(13)=1.258044534915515e-8_p
x(14)=19.71599805570287_p
w(14)=1.966651834916396e-9_p
else if(N==15)then
x(1)=1.069288829248461_p
w(1)=4.537638937699287e-2_p
x(2)=1.363087405697124_p
w(2)=8.334930788608344e-2_p
x(3)=1.885289785391289_p
w(3)=8.359068051978646e-2_p
x(4)=2.630293507813374_p
w(4)=5.748775016822232e-2_p
x(5)=3.595372822479774_p
w(5)=2.871031964335721e-2_p
x(6)=4.778500585141018_p
w(6)=1.076309149308552e-2_p
x(7)=6.174146334941038_p
w(7)=3.114362286475641e-3_p
x(8)=7.770232292155792_p
w(8)=7.131253729958732e-4_p
x(9)=9.545273883301094_p
w(9)=1.326328250176611e-4_p
x(10)=11.46352511077953_p
w(10)=2.072761391965826e-5_p
x(11)=13.46685164493035_p
w(11)=2.860742475045692e-6_p
x(12)=15.4629669012453_p
w(12)=3.755342115912605e-7_p
x(13)=17.312002028589_p
w(13)=5.197350461706030e-8_p
x(14)=18.82060963976123_p
w(14)=8.470802242828992e-9_p
x(15)=19.76554534256152_p
w(15)=1.550139065208518e-9_p
else if(N==16)then
x(1)=1.062826373339093_p
w(1)=4.134794498151568e-2_p
x(2)=1.329378684122918_p
w(2)=7.769830439935139e-2_p
x(3)=1.803473543541328_p
w(3)=8.145525021944811e-2_p
x(4)=2.479765509111905_p
w(4)=5.998461979053755e-2_p
x(5)=3.354914980261726_p
w(5)=3.285181206689382e-2_p
x(6)=4.426398829303925_p
w(6)=1.380548200765006e-2_p
x(7)=5.689280414546303_p
w(7)=4.569859070241644e-3_p
x(8)=7.133674219951834_p
w(8)=1.219833630873148e-3_p
x(9)=8.742822887063104_p
w(9)=2.686836881766764e-4_p
x(10)=10.49031818808825_p
w(10)=5.017457506838616e-5_p
x(11)=12.33553617356447_p
w(11)=8.239722378428444e-6_p
x(12)=14.21704199730315_p
w(12)=1.253161617802958e-6_p
x(13)=16.04454541227931_p
w(13)=1.896125193588434e-7_p
x(14)=17.69224334954694_p
w(14)=3.121973897490573e-8_p
x(15)=19.00117287166139_p
w(15)=6.055426458443483e-9_p
x(16)=19.80325133816638_p
w(16)=1.255631725330365e-9_p
else if(N==17)then
x(1)=1.057227025469984_p
w(1)=3.782413678711415e-2_p
x(2)=1.300149162478770_p
w(2)=7.248550073347898e-2_p
x(3)=1.732507402275816_p
w(3)=7.894177645809988e-2_p
x(4)=2.349330162438958_p
w(4)=6.165510479820591e-2_p
x(5)=3.146991276809771_p
w(5)=3.656105549528758e-2_p
x(6)=4.122673735291151_p
w(6)=1.695476365972352e-2_p
x(7)=5.271934956751233_p
w(7)=6.301077174341042e-3_p
x(8)=6.586566365053619_p
w(8)=1.918458169024383e-3_p
x(9)=8.053154181590520_p
w(9)=4.885962441072006e-4_p
x(10)=9.651394634328296_p
w(10)=1.064740611764347e-4_p
x(11)=11.35141388908837_p
w(11)=2.042411557908094e-5_p
x(12)=13.10988694643741_p
w(12)=3.582288682005103e-6_p
x(13)=14.86517470971737_p
w(13)=6.047383647405188e-7_p
x(14)=16.53248872424309_p
w(14)=1.049694812993692e-7_p
x(15)=18.00185307641779_p
w(15)=2.019138227374449e-8_p
x(16)=19.14426530244915_p
w(16)=4.533709891496901e-9_p
x(17)=19.83258616564637_p
w(17)=1.039310845028384e-9_p
else
call GD(1)
end if
end subroutine GF_1

! [2kT;20kT]
subroutine GF_2(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=2.604156508872104_p
w(1)=1.077982035903202e-1_p
x(2)=5.444125952163239_p
w(2)=1.912980539149866e-2_p
else if(N==3)then
x(1)=2.427796899042051_p
w(1)=8.927120824936108e-2_p
x(2)=4.319036798971879_p
w(2)=3.627962636610445e-2_p
x(3)=8.309085549385808_p
w(3)=1.377174366353345e-3_p
else if(N==4)then
x(1)=2.330237276212805_p
w(1)=7.518851449951941e-2_p
x(2)=3.761403436082566_p
w(2)=4.645008710840284e-2_p
x(3)=6.538040709109110_p
w(3)=5.214361516746572e-3_p
x(4)=11.35517927671473_p
w(4)=7.504585715006266e-5_p
else if(N==5)then
x(1)=2.266398617182669_p
w(1)=6.421921983472509e-2_p
x(2)=3.410722136853104_p
w(2)=5.171727749038433e-2_p
x(3)=5.554760717050657_p
w(3)=1.044713412155040e-2_p
x(4)=8.954029616697973_p
w(4)=5.399909412067773e-4_p
x(5)=14.23067376662548_p
w(5)=4.386593952287334e-6_p
else if(N==6)then
x(1)=2.219994611806529_p
w(1)=5.528086078458969e-2_p
x(2)=3.160577291663940_p
w(2)=5.380069169527438e-2_p
x(3)=4.889897585750665_p
w(3)=1.609112329985043e-2_p
x(4)=7.523276546468887_p
w(4)=1.698764493475419e-3_p
x(5)=11.27097650214831_p
w(5)=5.614224275511202e-5_p
x(6)=16.43283623889544_p
w(6)=4.264658738513286e-7_p
else if(N==7)then
x(1)=2.184652830693360_p
w(1)=4.789003344988578e-2_p
x(2)=2.972083406962431_p
w(2)=5.375468772726229e-2_p
x(3)=4.403742068628649_p
w(3)=2.137805276203867e-2_p
x(4)=6.535519022375777_p
w(4)=3.635861380787933e-3_p
x(5)=9.457103189132093_p
w(5)=2.619223561965320e-4_p
x(6)=13.27037525858942_p
w(6)=7.369525107788442e-6_p
x(7)=17.80757434707239_p
w(7)=8.178053987788752e-8_p
else if(N==8)then
x(1)=2.157131007476870_p
w(1)=4.176740678733483e-2_p
x(2)=2.826238257610885_p
w(2)=5.234889561885685e-2_p
x(3)=4.034532488221480_p
w(3)=2.582312472799233e-2_p
x(4)=5.809410558264638_p
w(4)=6.195149519029207e-3_p
x(5)=8.193125801705468_p
w(5)=7.472308521054619e-4_p
x(6)=11.22398773619679_p
w(6)=4.482328887542879e-5_p
x(7)=14.86673312207604_p
w(7)=1.351492672819572e-6_p
x(8)=18.59166115808052_p
w(8)=2.669495194735051e-8_p
else if(N==9)then
x(1)=2.135313922669408_p
w(1)=3.667650908236596e-2_p
x(2)=2.711079170683877_p
w(2)=5.014564093714773e-2_p
x(3)=3.746475172282563_p
w(3)=2.924547113428538e-2_p
x(4)=5.254268782191066_p
w(4)=9.100699624187742e-3_p
x(5)=7.254889477386194_p
w(5)=1.591195282732627e-3_p
x(6)=9.762463865732272_p
w(6)=1.588853624930734e-4_p
x(7)=12.75626077226811_p
w(7)=9.247381632099083e-6_p
x(8)=16.07601912239229_p
w(8)=3.479707739893252e-7_p
x(9)=19.0423645363414_p
w(9)=1.220620027740848e-8_p
else if(N==10)then
x(1)=2.117737881963641_p
w(1)=3.241786233889726e-2_p
x(2)=2.618531414054059_p
w(2)=4.752753873761340e-2_p
x(3)=3.516789822180320_p
w(3)=3.166445196147267e-2_p
x(4)=4.817485061680349_p
w(4)=1.207452329906733e-2_p
x(5)=6.529991850309021_p
w(5)=2.798281334450922e-3_p
x(6)=8.658123926999320_p
w(6)=4.052456645739201e-4_p
x(7)=11.18514834970038_p
w(7)=3.760769965298634e-5_p
x(8)=14.03561273385341_p
w(8)=2.371128326052859e-6_p
x(9)=16.96644813109749_p
w(9)=1.199648372980730e-7_p
x(10)=19.31423598446624_p
w(10)=6.852927049838326e-9_p
else if(N==11)then
x(1)=2.103373939639035_p
w(1)=2.883066275435815e-2_p
x(2)=2.543010343285888_p
w(2)=4.474225658947517e-2_p
x(3)=3.330339986697370_p
w(3)=3.319870689927588e-2_p
x(4)=4.466130882883260_p
w(4)=1.489737680419496e-2_p
x(5)=5.953820158431270_p
w(5)=4.308690417509971e-3_p
x(6)=7.792544039233543_p
w(6)=8.298848555637104e-4_p
x(7)=9.967984552076542_p
w(7)=1.093486733099560e-4_p
x(8)=12.43506221165096_p
w(8)=1.027307663447553e-5_p
x(9)=15.07706959719962_p
w(9)=7.525169403340697e-7_p
x(10)=17.61685344518384_p
w(10)=5.201765487009982e-8_p
x(11)=19.48750370174193_p
w(11)=4.376901402551680e-9_p
else if(N==12)then
x(1)=2.091485583792504_p
w(1)=2.578757954234655e-2_p
x(2)=2.480561858324605_p
w(2)=4.194409131342745e-2_p
x(3)=3.176705508424928_p
w(3)=3.400175705814798e-2_p
x(4)=4.178447239106376_p
w(4)=1.742502570222404e-2_p
x(5)=5.485939503164572_p
w(5)=6.025857564183703e-3_p
x(6)=7.096158265921896_p
w(6)=1.455406860311552e-3_p
x(7)=8.996752736257770_p
w(7)=2.522646656395681e-4_p
x(8)=11.15694121829272_p
w(8)=3.243352219236074e-5_p
x(9)=13.50915209490049_p
w(9)=3.274011395598134e-6_p
x(10)=15.91279518813176_p
w(10)=2.889016234543429e-7_p
x(11)=18.09463320035983_p
w(11)=2.679628358089855e-8_p
x(12)=19.6035880794323_p
w(12)=3.044043037234850e-9_p
else if(N==13)then
x(1)=2.081535390976825_p
w(1)=2.318815265972964e-2_p
x(2)=2.428322119259672_p
w(2)=3.922522246407027e-2_p
x(3)=3.048490229613655_p
w(3)=3.422704893936817e-2_p
x(4)=3.939437707191292_p
w(4)=1.958075109536086e-2_p
x(5)=5.099496315818234_p
w(5)=7.843466979161166e-3_p
x(6)=6.524682678399095_p
w(6)=2.277479952387774e-3_p
x(7)=8.204327978365448_p
w(7)=4.922895725257017e-4_p
x(8)=10.11569853596314_p
w(8)=8.148236743653453e-5_p
x(9)=12.21466780051184_p
w(9)=1.075542498909359e-5_p
x(10)=14.41877070938523_p
w(10)=1.211354159187772e-6_p
x(11)=16.57966866903598_p
w(11)=1.302444094690451e-7_p
x(12)=18.45024570406497_p
w(12)=1.568207041066237e-8_p
x(13)=19.68473908160167_p
w(13)=2.246150600665886e-9_p
else if(N==14)then
x(1)=2.073124050535202_p
w(1)=2.095294592770291e-2_p
x(2)=2.384174218904080_p
w(2)=3.663747238892637e-2_p
x(3)=2.940307005685606_p
w(3)=3.401168957687804e-2_p
x(4)=3.738415428553424_p
w(4)=2.133911665032320e-2_p
x(5)=4.775854017143033_p
w(5)=9.664264745024298e-3_p
x(6)=6.048280660437747_p
w(6)=3.269228107475509e-3_p
x(7)=7.546457421747884_p
w(7)=8.475304748063367e-4_p
x(8)=9.252757184742933_p
w(8)=1.726471553307647e-4_p
x(9)=11.13596164717972_p
w(9)=2.851888371293499e-5_p
x(10)=13.14248025101837_p
w(10)=4.002933098843348e-6_p
x(11)=15.1825606232655_p
w(11)=5.133594141309607e-7_p
x(12)=17.11213763146966_p
w(12)=6.695958963585133e-8_p
x(13)=18.71929243347671_p
w(13)=1.008932551914100e-8_p
x(14)=19.74352261142903_p
w(14)=1.730210379758252e-9_p
else if(N==15)then
x(1)=2.065949954155465_p
w(1)=1.901884276724557e-2_p
x(2)=2.346524964459097_p
w(2)=3.420692903973410e-2_p
x(3)=2.848145282113892_p
w(3)=3.347080488510153e-2_p
x(4)=3.567555200223405_p
w(4)=2.270920675101198e-2_p
x(5)=4.501631193102281_p
w(5)=1.140985265230983e-2_p
x(6)=5.645982545580332_p
w(6)=4.389324716111913e-3_p
x(7)=6.992577379767433_p
w(7)=1.325031587383609e-3_p
x(8)=8.527301067514276_p
w(8)=3.210710483324710e-4_p
x(9)=10.22681869659472_p
w(9)=6.408176276312471e-5_p
x(10)=12.05366081022723_p
w(10)=1.090726845054012e-5_p
x(11)=13.9487634275353_p
w(11)=1.664885781622945e-6_p
x(12)=15.82145413900679_p
w(12)=2.450096800625037e-7_p
x(13)=17.5392931767145_p
w(13)=3.826157004226854e-8_p
x(14)=18.92635712390272_p
w(14)=6.969634570945005e-9_p
x(15)=19.78738944884475_p
w(15)=1.376707902780700e-9_p
else if(N==16)then
x(1)=2.059781887220568_p
w(1)=1.733538834527905e-2_p
x(2)=2.314156092997994_p
w(2)=3.194358287401983e-2_p
x(3)=2.768962987857280_p
w(3)=3.269736069151481e-2_p
x(4)=3.420996772049068_p
w(4)=2.372075992864464e-2_p
x(5)=4.266954944544636_p
w(5)=1.302361468657388e-2_p
x(6)=5.302560658849874_p
w(6)=5.590320161823576e-3_p
x(7)=6.520793681136084_p
w(7)=1.920495878604833e-3_p
x(8)=7.910091403691291_p
w(8)=5.391241973334455e-4_p
x(9)=9.452318307702507_p
w(9)=1.264231381608120e-4_p
x(10)=11.1198419578394_p
w(10)=2.544923557345829e-5_p
x(11)=12.87123507181502_p
w(11)=4.563316030111430e-6_p
x(12)=14.64551647646501_p
w(12)=7.670899358442559e-7_p
x(13)=16.35568814523109_p
w(13)=1.294398572752204e-7_p
x(14)=17.88440972816172_p
w(14)=2.379199700399832e-8_p
x(15)=19.08838516984242_p
w(15)=5.083045151069318e-9_p
x(16)=19.82095545770763_p
w(16)=1.123425161735874e-9_p
else if(N==17)then
x(1)=2.054440210314890_p
w(1)=1.586198210355985e-2_p
x(2)=2.286122771477038_p
w(2)=2.984760053966821e-2_p
x(3)=2.700415014046125_p
w(3)=3.176444063448934e-2_p
x(4)=3.294267159604629_p
w(4)=2.441399561421296e-2_p
x(5)=4.064376486122288_p
w(5)=1.446944621950384e-2_p
x(6)=5.006664115059268_p
w(6)=6.825311719864128e-3_p
x(7)=6.114958317860094_p
w(7)=2.620149335483376e-3_p
x(8)=7.379622295022721_p
w(8)=8.344849537188258e-4_p
x(9)=8.786153675874253_p
w(9)=2.247964049572058e-4_p
x(10)=10.31335013137531_p
w(10)=5.237725962997789e-5_p
x(11)=11.93070525977558_p
w(11)=1.086050602401111e-5_p
x(12)=13.5949451820856_p
w(12)=2.081197682353947e-6_p
x(13)=15.24598272235826_p
w(13)=3.873596811464633e-7_p
x(14)=16.8033411892126_p
w(14)=7.450064127713087e-8_p
x(15)=18.16558486204081_p
w(15)=1.583070986672320e-8_p
x(16)=19.21715423119852_p
w(16)=3.866585700625465e-9_p
x(17)=19.84719242759374_p
w(17)=9.354068073316957e-10_p
else
call GD(2)
end if
end subroutine GF_2

! [3kT;20kT]
subroutine GF_3(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=3.592754235582684_p
w(1)=4.139253558202507e-2_p
x(2)=6.425395387310172_p
w(2)=7.194813930563371e-3_p
else if(N==3)then
x(1)=3.420112031927095_p
w(1)=3.439387302097506e-2_p
x(2)=5.302140550271797_p
w(2)=1.367812172631267e-2_p
x(3)=9.291674974198978_p
w(3)=5.153547653007119e-4_p
else if(N==4)then
x(1)=3.324096560331936_p
w(1)=2.901801472420316e-2_p
x(2)=4.743579170423125_p
w(2)=1.757650353086796e-2_p
x(3)=7.512082328560341_p
w(3)=1.963979497899386e-3_p
x(4)=12.30209631651095_p
w(4)=2.885175961793120e-5_p
else if(N==5)then
x(1)=3.260659624945308_p
w(1)=2.476862266337154e-2_p
x(2)=4.389770065402633_p
w(2)=1.963520858212888e-2_p
x(3)=6.515983792426032_p
w(3)=3.970164950730161e-3_p
x(4)=9.877101096736412_p
w(4)=2.114510901603457e-4_p
x(5)=15.02385120666591_p
w(5)=1.902226197504976e-6_p
else if(N==6)then
x(1)=3.214466162462584_p
w(1)=2.128444458853622e-2_p
x(2)=4.137590428824335_p
w(2)=2.046191455503558e-2_p
x(3)=5.842941831592210_p
w(3)=6.146050256289834e-3_p
x(4)=8.433779993889431_p
w(4)=6.707293059113575e-4_p
x(5)=12.08884534843463_p
w(5)=2.398472513946666e-5_p
x(6)=16.97556788477019_p
w(6)=2.260816759797958e-7_p
else if(N==7)then
x(1)=3.179455544909692_p
w(1)=1.840789229711041e-2_p
x(2)=3.948900250455510_p
w(2)=2.045566710873474e-2_p
x(3)=5.354245794894272_p
w(3)=8.174819684357544e-3_p
x(4)=7.443930884729139_p
w(4)=1.434946172454822e-3_p
x(5)=10.28966047375645_p
w(5)=1.104346966487454e-4_p
x(6)=13.95173969272876_p
w(6)=3.537605509003004e-6_p
x(7)=18.13818795266648_p
w(7)=5.194777316686865e-8_p
else if(N==8)then
x(1)=3.152328024639911_p
w(1)=1.603119723728654e-2_p
x(2)=3.803886074197522_p
w(2)=1.992061488391943e-2_p
x(3)=4.985554578184921_p
w(3)=9.868091599524996e-3_p
x(4)=6.720423196407090_p
w(4)=2.435303318131252e-3_p
x(5)=9.039324930522502_p
w(5)=3.108498320428216e-4_p
x(6)=11.96099287140376_p
w(6)=2.054042614985308e-5_p
x(7)=15.40838189778432_p
w(7)=7.330630196718392e-7_p
x(8)=18.79159254646094_p
w(8)=1.915251387847573e-8_p
else if(N==9)then
x(1)=3.130907535737152_p
w(1)=1.405928664369333e-2_p
x(2)=3.689989004949990_p
w(2)=1.907758422042525e-2_p
x(3)=4.699406976429323_p
w(3)=1.116159482608882e-2_p
x(4)=6.169639874729913_p
w(4)=3.559734725382234e-3_p
x(5)=8.113476859910667_p
w(5)=6.536885784528187e-4_p
x(6)=10.53380994276696_p
w(6)=7.059957488981118e-5_p
x(7)=13.3910366429625_p
w(7)=4.640763784504025e-6_p
x(8)=16.49473465947534_p
w(8)=2.107340710563303e-7_p
x(9)=19.16866331235152_p
w(9)=9.445800618416745e-9_p
else if(N==10)then
x(1)=3.113705086128692_p
w(1)=1.241273386280408e-2_p
x(2)=3.598845144700710_p
w(2)=1.807541363400198e-2_p
x(3)=4.472228819705410_p
w(3)=1.206777419245787e-2_p
x(4)=5.737797891071089_p
w(4)=4.699520146943055e-3_p
x(5)=7.399702096867041_p
w(5)=1.136651712211549e-3_p
x(6)=9.454499240217769_p
w(6)=1.758947018864413e-4_p
x(7)=11.87522973752869_p
w(7)=1.797500598475229e-5_p
x(8)=14.57146921977844_p
w(8)=1.301174063107570e-6_p
x(9)=17.28713365019564_p
w(9)=7.952040849334481e-8_p
x(10)=19.39846997228917_p
w(10)=5.561827106017001e-9_p
else if(N==11)then
x(1)=3.099683264623260_p
w(1)=1.102799058623603e-2_p
x(2)=3.524732655754994_p
w(2)=1.700980398773859e-2_p
x(3)=4.288494100348519_p
w(3)=1.263557288344985e-2_p
x(4)=5.391468808240363_p
w(4)=5.771626490347420e-3_p
x(5)=6.833505003178335_p
w(5)=1.732692611552984e-3_p
x(6)=8.608699585571314_p
w(6)=3.534232321210341e-4_p
x(7)=10.69647432504361_p
w(7)=5.046203711028815e-5_p
x(8)=13.04344297867331_p
w(8)=5.288989931603699e-6_p
x(9)=15.52403760357551_p
w(9)=4.480395643652063e-7_p
x(10)=17.86350314281075_p
w(10)=3.698940008112758e-8_p
x(11)=19.54656030769188_p
w(11)=3.665136194252387e-9_p
else if(N==12)then
x(1)=3.088104037905064_p
w(1)=9.854954054584145e-3_p
x(2)=3.463632335600541_p
w(2)=1.594004878789339e-2_p
x(3)=4.137582080528960_p
w(3)=1.292577010437549e-2_p
x(4)=5.108664112044164_p
w(4)=6.723385123845033e-3_p
x(5)=6.374583617581051_p
w(5)=2.401925896704591e-3_p
x(6)=7.928663596129430_p
w(6)=6.100156387340570e-4_p
x(7)=9.754367272424144_p
w(7)=1.132817342615258e-4_p
x(8)=11.81586047565106_p
w(8)=1.595062146867999e-5_p
x(9)=14.04003054359928_p
w(9)=1.810228978590671e-6_p
x(10)=16.28384971240771_p
w(10)=1.846172530310365e-7_p
x(11)=18.28661153996701_p
w(11)=2.010001828175806e-8_p
x(12)=19.6467805167234_p
w(12)=2.604471629138258e-9_p
else if(N==13)then
x(1)=3.078431393558961_p
w(1)=8.854215570685896e-3_p
x(2)=3.412651521170797_p
w(2)=1.490138449343430e-2_p
x(3)=4.011992957260599_p
w(3)=1.299798102211833e-2_p
x(4)=4.874281111864228_p
w(4)=7.528358934710224e-3_p
x(5)=5.996207564587701_p
w(5)=3.102382605028869e-3_p
x(6)=7.371079233384828_p
w(6)=9.416790384409201e-4_p
x(7)=8.985240945876717_p
w(7)=2.162121312667786e-4_p
x(8)=10.81265072556906_p
w(8)=3.868585199574174e-5_p
x(9)=12.80562418687965_p
w(9)=5.632203210737158e-6_p
x(10)=14.87921793150308_p
w(10)=7.151338993935859e-7_p
x(11)=16.88792483507834_p
w(11)=8.832684432862989e-8_p
x(12)=18.60196713073695_p
w(12)=1.224922746394453e-8_p
x(13)=19.71745280540329_p
w(13)=1.951725452974580e-9_p
else if(N==14)then
x(1)=3.070268603963589_p
w(1)=7.994691116903525e-3_p
x(2)=3.369663301486413_p
w(2)=1.391350249855270e-2_p
x(3)=3.906288628702575_p
w(3)=1.290484657530699e-2_p
x(4)=4.677588141532698_p
w(4)=8.179400026677820e-3_p
x(5)=5.679848784560146_p
w(5)=3.796971046113355e-3_p
x(6)=6.906698142677919_p
w(6)=1.335967167830033e-3_p
x(7)=8.346667637591457_p
w(7)=3.653711617685835e-4_p
x(8)=9.979827429694085_p
w(8)=7.967751579593965e-5_p
x(9)=11.77258005290023_p
w(9)=1.431873040170583e-5_p
x(10)=13.669425201617_p
w(10)=2.225044177363652e-6_p
x(11)=15.58091890655724_p
w(11)=3.212874631638248e-7_p
x(12)=17.36934966668518_p
w(12)=4.769259517622423e-8_p
x(13)=18.84113751039209_p
w(13)=8.128179689788222e-9_p
x(14)=19.76902563517438_p
w(14)=1.520822394662339e-9_p
else if(N==15)then
x(1)=3.063316995184491_p
w(1)=7.251735436328387e-3_p
x(2)=3.333074225730543_p
w(2)=1.298622765845662e-2_p
x(3)=3.816436987460871_p
w(3)=1.269019904228394e-2_p
x(4)=4.510747405058865_p
w(4)=8.681945566933878e-3_p
x(5)=5.412219741366764_p
w(5)=4.456731593142345e-3_p
x(6)=6.514939931492966_p
w(6)=1.775504833688481e-3_p
x(7)=7.809158207319122_p
w(7)=5.622193780735356e-4_p
x(8)=9.279073480139846_p
w(8)=1.447282531096515e-4_p
x(9)=10.89969302400306_p
w(9)=3.110132190424691e-5_p
x(10)=12.63214912325091_p
w(10)=5.781856605692023e-6_p
x(11)=14.41704514585278_p
w(11)=9.778763621963647e-7_p
x(12)=16.16618072160471_p
w(12)=1.613548617448166e-7_p
x(13)=17.75532742317078_p
w(13)=2.836930455400896e-8_p
x(14)=19.02573970851022_p
w(14)=5.750679108712838e-9_p
x(15)=19.80775415559774_p
w(15)=1.220854060038171e-9_p
else if(N==16)then
x(1)=3.057348254276264_p
w(1)=6.605684483590209e-3_p
x(2)=3.301670650041038_p
w(2)=1.212323941992931e-2_p
x(3)=3.739390899609513_p
w(3)=1.238920987792945e-2_p
x(4)=4.367903264323863_p
w(4)=9.048687418239006e-3_p
x(5)=5.183528261719926_p
w(5)=5.061472591255552e-3_p
x(6)=6.180851592925035_p
w(6)=2.241313664614365e-3_p
x(7)=7.351505185534862_p
w(7)=8.037610484446585e-4_p
x(8)=8.682639425027547_p
w(8)=2.382121494951697e-4_p
x(9)=10.15491701655301_p
w(9)=5.965611969425944e-5_p
x(10)=11.73968476307008_p
w(10)=1.297999745692658e-5_p
x(11)=13.39507231501721_p
w(11)=2.546557440764967e-6_p
x(12)=15.06109521273429_p
w(12)=4.736085496951811e-7_p
x(13)=16.65466920644952_p
w(13)=8.906931053581058e-8_p
x(14)=18.06725659254592_p
w(14)=1.823004596051097e-8_p
x(15)=19.17062400676075_p
w(15)=4.273370134812034e-9_p
x(16)=19.83754800845421_p
w(16)=1.003222441267604e-9_p
else if(N==17)then
x(1)=3.052185440444911_p
w(1)=6.040741493274287e-3_p
x(2)=3.274514589540353_p
w(2)=1.132448310853204e-2_p
x(3)=3.672809294525574_p
w(3)=1.202939038467687e-2_p
x(4)=4.244596408479477_p
w(4)=9.295779138371053e-3_p
x(5)=4.986394973283639_p
w(5)=5.598923151074818e-3_p
x(6)=5.893285301688294_p
w(6)=2.715298806893124e-3_p
x(7)=6.958027890697742_p
w(7)=1.083516907977363e-3_p
x(8)=8.169972294183999_p
w(8)=3.624214114791541e-4_p
x(9)=9.513711941469477_p
w(9)=1.035773365817583e-4_p
x(10)=10.96728941454411_p
w(10)=2.586927095613247e-5_p
x(11)=12.49979305164229_p
w(11)=5.810429191012567e-6_p
x(12)=14.06835036147022_p
w(12)=1.218193160777904e-6_p
x(13)=15.61486736118718_p
w(13)=2.500535738881074e-7_p
x(14)=17.06357060260128_p
w(14)=5.322600893606821e-8_p
x(15)=18.32159831389459_p
w(15)=1.246129395524017e-8_p
x(16)=19.28610633184595_p
w(16)=3.299506673046717e-9_p
x(17)=19.86094436228538_p
w(17)=8.400365912178617e-10_p
else
call GD(3)
end if
end subroutine GF_3

! [4kT;20kT]
subroutine GF_4(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=4.588340281722103_p
w(1)=1.548038708671674e-2_p
x(2)=7.418073089387108_p
w(2)=2.669538769939375e-3_p
else if(N==3)then
x(1)=4.416928265616171_p
w(1)=1.287575986770055e-2_p
x(2)=6.294329225082810_p
w(2)=5.082604744418166e-3_p
x(3)=10.2798563377613_p
w(3)=1.915612445373999e-4_p
else if(N==4)then
x(1)=4.320904357772226_p
w(1)=1.085455564901312e-2_p
x(2)=5.731915621896119_p
w(2)=6.547281415619322e-3_p
x(3)=8.486863101046010_p
w(3)=7.368700430335432e-4_p
x(4)=13.23148828790923_p
w(4)=1.121874899013252e-5_p
else if(N==5)then
x(1)=4.256916166984260_p
w(1)=9.237646706420759e-3_p
x(2)=5.373017265318424_p
w(2)=7.324699024464210e-3_p
x(3)=7.475967903346289_p
w(3)=1.503107897468441e-3_p
x(4)=10.7849552514442_p
w(4)=8.361182578714438e-5_p
x(5)=15.75916997651095_p
w(5)=8.604025155661335e-7_p
else if(N==6)then
x(1)=4.210406094219129_p
w(1)=7.910587494424635e-3_p
x(2)=5.118012387764424_p
w(2)=7.628632249842789e-3_p
x(3)=6.795458580039534_p
w(3)=2.333836140073970e-3_p
x(4)=9.333936965417386_p
w(4)=2.662743781209272e-4_p
x(5)=12.87762058674757_p
w(5)=1.046969528647964e-5_p
x(6)=17.45335485798041_p
w(6)=1.258989073182046e-7_p
else if(N==7)then
x(1)=4.175387599103899_p
w(1)=6.820237536467139e-3_p
x(2)=4.928650553866930_p
w(2)=7.612978067584612e-3_p
x(3)=6.305115528290185_p
w(3)=3.100364345119545e-3_p
x(4)=8.345632897759799_p
w(4)=5.674151884854031e-4_p
x(5)=11.10409152370173_p
w(5)=4.715081692039128e-5_p
x(6)=14.59714433345946_p
w(6)=1.745710321519012e-6_p
x(7)=18.42383792277332_p
w(7)=3.419175751033792e-8_p
else if(N==8)then
x(1)=4.148411304681973_p
w(1)=5.923673070141512e-3_p
x(2)=4.784061078560221_p
w(2)=7.397850519382393e-3_p
x(3)=5.937504719335696_p
w(3)=3.731491402790671e-3_p
x(4)=7.627072098670406_p
w(4)=9.566093776023991e-4_p
x(5)=9.873088239009059_p
w(5)=1.302998505078010e-4_p
x(6)=12.67441962223163_p
w(6)=9.578745821255482e-6_p
x(7)=15.91426932045211_p
w(7)=4.088516743124666e-7_p
x(8)=18.96496163530584_p
w(8)=1.403873577533739e-8_p
else if(N==9)then
x(1)=4.127208069537670_p
w(1)=5.182796465023719e-3_p
x(2)=4.671074307969074_p
w(2)=7.068986446259734e-3_p
x(3)=5.653585216169133_p
w(3)=4.205903891348925e-3_p
x(4)=7.082232885635232_p
w(4)=1.388272065695540e-3_p
x(5)=8.963130693243293_p
w(5)=2.697121544993372e-4_p
x(6)=11.28826981000754_p
w(6)=3.174121484581460e-5_p
x(7)=13.99982198474622_p
w(7)=2.375479521844075e-6_p
x(8)=16.88249910556819_p
w(8)=1.307404283845197e-7_p
x(9)=19.2794693952815_p
w(9)=7.399032821599249e-9_p
else if(N==10)then
x(1)=4.110244588226466_p
w(1)=4.566303117597023e-3_p
x(2)=4.581034819480526_p
w(2)=6.683201676854233e-3_p
x(3)=5.429076956475412_p
w(3)=4.531340925204430e-3_p
x(4)=6.656447296682215_p
w(4)=1.820035850075254e-3_p
x(5)=8.262867608532245_p
w(5)=4.625835769222390e-4_p
x(6)=10.23821243586712_p
w(6)=7.695900985574772e-5_p
x(7)=12.54569422716139_p
w(7)=8.715242933301516e-6_p
x(8)=15.08171386196317_p
w(8)=7.281905711875244e-7_p
x(9)=17.58312721852927_p
w(9)=5.372266482764384e-8_p
x(10)=19.47332686512613_p
w(10)=4.543977876486180e-9_p
else if(N==11)then
x(1)=4.096462089545388_p
w(1)=4.049412271498314e-3_p
x(2)=4.508077416486161_p
w(2)=6.276469869871701e-3_p
x(3)=5.248119753394989_p
w(3)=4.728602780163163e-3_p
x(4)=6.315939098128607_p
w(4)=2.220803978946544e-3_p
x(5)=7.708371809391314_p
w(5)=6.967273562120795e-4_p
x(6)=9.415114240294637_p
w(6)=1.513104408118615e-4_p
x(7)=11.40968742337243_p
w(7)=2.353278834761083e-5_p
x(8)=13.63120627253766_p
w(8)=2.765055285912994e-6_p
x(9)=15.94761430770369_p
w(9)=2.715593930467459e-7_p
x(10)=18.09122258811932_p
w(10)=2.667679407753554e-8_p
x(11)=19.59966199642072_p
w(11)=3.079331807820398e-9_p
else if(N==12)then
x(1)=4.085112227614582_p
w(1)=3.612728262800440e-3_p
x(2)=4.448111009028632_p
w(2)=5.870720969013843e-3_p
x(3)=5.099928660289741_p
w(3)=4.822132705542266e-3_p
x(4)=6.038582609733199_p
w(4)=2.571811200351386e-3_p
x(5)=7.259700276003989_p
w(5)=9.556813628436102e-4_p
x(6)=8.753567595591552_p
w(6)=2.564975957064206e-4_p
x(7)=10.4998267383018_p
w(7)=5.126201417796570e-5_p
x(8)=12.45804680717978_p
w(8)=7.938394008382709e-6_p
x(9)=14.5506891395439_p
w(9)=1.016102063226908e-6_p
x(10)=16.63456540739833_p
w(10)=1.197889457005922e-7_p
x(11)=18.46427278608223_p
w(11)=1.522996482441207e-8_p
x(12)=19.68601316227642_p
w(12)=2.231238054817975e-9_p
else if(N==13)then
x(1)=4.075654336901756_p
w(1)=3.241083030660646e-3_p
x(2)=4.398207883276631_p
w(2)=5.478736025115968e-3_p
x(3)=4.976924632168807_p
w(3)=4.835254147381634e-3_p
x(4)=5.809230780630994_p
w(4)=2.864473201233091e-3_p
x(5)=6.890374913215468_p
w(5)=1.222941813125227e-3_p
x(6)=8.211502081811503_p
w(6)=3.899314515466802e-4_p
x(7)=9.756342425681060_p
w(7)=9.548272477102670e-5_p
x(8)=11.49586124826958_p
w(8)=1.853724604370527e-5_p
x(9)=13.37941742976645_p
w(9)=2.986105012235166e-6_p
x(10)=15.32077008023635_p
w(10)=4.281283718143409e-7_p
x(11)=17.17901171879641_p
w(11)=6.065271408905196e-8_p
x(12)=18.7428479772806_p
w(12)=9.634830927130878e-9_p
x(13)=19.74742450069321_p
w(13)=1.695849075740164e-9_p
else if(N==14)then
x(1)=4.067690015064221_p
w(1)=2.922570795266631e-3_p
x(2)=4.356225716683200_p
w(2)=5.107463148051318e-3_p
x(3)=4.873634937648938_p
w(3)=4.788178534741398e-3_p
x(4)=5.617150894970043_p
w(4)=3.097407413869536e-3_p
x(5)=6.582057376763992_p
w(5)=1.484484346654446e-3_p
x(6)=7.760412213805594_p
w(6)=5.459282857280590e-4_p
x(7)=9.138883476684843_p
w(7)=1.581011981459093e-4_p
x(8)=10.69549643934641_p
w(8)=3.703277979189051e-5_p
x(9)=12.39463956157713_p
w(9)=7.261667954243848e-6_p
x(10)=14.17956909164941_p
w(10)=1.251875801493474e-6_p
x(11)=15.96219443480694_p
w(11)=2.035884352835835e-7_p
x(12)=17.61229769341471_p
w(12)=3.430796769974803e-8_p
x(13)=18.95470248588458_p
w(13)=6.578676791972470e-9_p
x(14)=19.79256274473762_p
w(14)=1.335571419392410e-9_p
else if(N==15)then
x(1)=4.060920478529201_p
w(1)=2.647791876821996e-3_p
x(2)=4.320566220636869_p
w(2)=4.760198397859320e-3_p
x(3)=4.786016726277117_p
w(3)=4.697489116290546e-3_p
x(4)=5.454524361829992_p
w(4)=3.273738997899864e-3_p
x(5)=6.321608915623964_p
w(5)=1.729781045979724e-3_p
x(6)=7.380202634233650_p
w(6)=7.172166883134220e-4_p
x(7)=8.619187990818821_p
w(7)=2.390934020191969e-4_p
x(8)=10.02131104102669_p
w(8)=6.558751958765318e-5_p
x(9)=11.56017021392108_p
w(9)=1.521695164205251e-5_p
x(10)=13.1959055054814_p
w(10)=3.096506329366931e-6_p
x(11)=14.86942318116525_p
w(11)=5.809164148350075e-7_p
x(12)=16.49579720066875_p
w(12)=1.074012511069068e-7_p
x(13)=17.95959296284103_p
w(13)=2.119659077605022e-8_p
x(14)=19.11872047360395_p
w(14)=4.758639230567209e-9_p
x(15)=19.82666701851851_p
w(15)=1.081017031211879e-9_p
else if(N==16)then
x(1)=4.055118102640877_p
w(1)=2.409274439104747e-3_p
x(2)=4.290016544485610_p
w(2)=4.437996898252110e-3_p
x(3)=4.711024852952110_p
w(3)=4.576326966129460e-3_p
x(4)=5.315523597381851_p
w(4)=3.399048856058876e-3_p
x(5)=6.099357255270445_p
w(5)=1.951833217589814e-3_p
x(6)=7.056258155356202_p
w(6)=8.962448778984374e-4_p
x(7)=8.176832976544739_p
w(7)=3.367182424560336e-4_p
x(8)=9.447166906475090_p
w(8)=1.056625807361430e-4_p
x(9)=10.84691085898364_p
w(9)=2.833140286097546e-5_p
x(10)=12.3466564600728_p
w(10)=6.677158856571209e-6_p
x(11)=13.90449471090671_p
w(11)=1.435400712745682e-6_p
x(12)=15.46197594065813_p
w(12)=2.954347108686540e-7_p
x(13)=16.94046730454225_p
w(13)=6.183941042288139e-8_p
x(14)=18.24040423794216_p
w(14)=1.404939337119818e-8_p
x(15)=19.2478465652289_p
w(15)=3.598335323175126e-9_p
x(16)=19.85304089003209_p
w(16)=8.941502206772418e-10_p
else if(N==17)then
x(1)=4.050107010698436_p
w(1)=2.201036109984058e-3_p
x(2)=4.263642379833596_p
w(2)=4.140576371606474e-3_p
x(3)=4.646326793270017_p
w(3)=4.434855960640408e-3_p
x(4)=5.195720371822378_p
w(4)=3.479965481032873e-3_p
x(5)=5.908021470596017_p
w(5)=2.146694481799395e-3_p
x(6)=6.777677894032583_p
w(6)=1.076087595052998e-3_p
x(7)=7.796670618400974_p
w(7)=4.479933325237102e-4_p
x(8)=8.953548516983490_p
w(8)=1.578151994658919e-4_p
x(9)=10.23216050684381_p
w(9)=4.796381179639400e-5_p
x(10)=11.60998068534664_p
w(10)=1.286748000343453e-5_p
x(11)=13.05596147555794_p
w(11)=3.135602050472810e-6_p
x(12)=14.52799604282925_p
w(12)=7.198125040136609e-7_p
x(13)=15.97039414053643_p
w(13)=1.628916309232910e-7_p
x(14)=17.31238902657344_p
w(14)=3.830598677013128e-8_p
x(15)=18.46959819235796_p
w(15)=9.850643945307467e-9_p
x(16)=19.35107472415082_p
w(16)=2.817238433565342e-9_p
x(17)=19.87384507714227_p
w(17)=7.526959252822371e-10_p
else
call GD(4)
end if
end subroutine GF_4

! [5kT;20kT]
subroutine GF_5(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=5.586637675572304_p
w(1)=5.729919326068659e-3_p
x(2)=8.414977462999193_p
w(2)=9.854271018957892e-4_p
else if(N==3)then
x(1)=5.415345743368873_p
w(1)=4.765060743836314e-3_p
x(2)=7.288956960629574_p
w(2)=1.879041101091836e-3_p
x(3)=11.26582366742588_p
w(3)=7.124458303629819e-5_p
else if(N==4)then
x(1)=5.318492266111581_p
w(1)=4.007418803772536e-3_p
x(2)=6.720351216919161_p
w(2)=2.426011564085568e-3_p
x(3)=9.454534958776955_p
w(3)=2.774510070701427e-4_p
x(4)=14.12841253753213_p
w(4)=4.465053036201610e-6_p
else if(N==5)then
x(1)=5.253538663721575_p
w(1)=3.395656820041314e-3_p
x(2)=6.355480586044349_p
w(2)=2.714937752123324e-3_p
x(3)=8.428494609643645_p
w(3)=5.707249768373896e-4_p
x(4)=11.66964227156154_p
w(4)=3.361738080169872e-5_p
x(5)=16.42564448562698_p
w(5)=4.094981607210403e-7_p
else if(N==6)then
x(1)=5.206562588988941_p
w(1)=2.895026435193266e-3_p
x(2)=6.097743798052928_p
w(2)=2.821895573164122e-3_p
x(3)=7.742300385125431_p
w(3)=8.868241956806655e-4_p
x(4)=10.21820183659351_p
w(4)=1.068323979086848e-4_p
x(5)=13.63121510919923_p
w(5)=4.694201395522812e-6_p
x(6)=17.86755515161592_p
w(6)=7.362462218724736e-8_p
else if(N==7)then
x(1)=5.171461503389670_p
w(1)=2.486407463200588e-3_p
x(2)=5.907888943410228_p
w(2)=2.807446286483889e-3_p
x(3)=7.251806430588576_p
w(3)=1.174266896869676e-3_p
x(4)=9.235945252717517_p
w(4)=2.258421990111722e-4_p
x(5)=11.89560831004652_p
w(5)=2.047199704673842e-5_p
x(6)=15.20299961553695_p
w(6)=8.883370766929204e-7_p
x(7)=18.66890596089362_p
w(7)=2.324827569179193e-8_p
else if(N==8)then
x(1)=5.144588948219451_p
w(1)=2.152380267161233e-3_p
x(2)=5.763848948799164_p
w(2)=2.718989388668774e-3_p
x(3)=6.886315682050601_p
w(3)=1.406745947846548e-3_p
x(4)=8.525176424994608_p
w(4)=3.771850777187447e-4_p
x(5)=10.69028526235463_p
w(5)=5.524019791458051e-5_p
x(6)=13.36056472543875_p
w(6)=4.560328777589384e-6_p
x(7)=16.38313702448689_p
w(7)=2.347326652098646e-7_p
x(8)=19.11487938825713_p
w(8)=1.048721176844231e-8_p
else if(N==9)then
x(1)=5.123571850473148_p
w(1)=1.877722518714893e-3_p
x(2)=5.651859338666449_p
w(2)=2.589583686682125e-3_p
x(3)=6.605362809046654_p
w(3)=1.577744196750564e-3_p
x(4)=7.988231916439737_p
w(4)=5.423274031841805e-4_p
x(5)=9.800150848066236_p
w(5)=1.121540483554623e-4_p
x(6)=12.02240296702262_p
w(6)=1.448280985121513e-5_p
x(7)=14.58016377290481_p
w(7)=1.242825089969851e-6_p
x(8)=17.23946446358949_p
w(8)=8.308215783494132e-8_p
x(9)=19.37656504840815_p
w(9)=5.857178204002149e-9_p
else if(N==10)then
x(1)=5.106826725904176_p
w(1)=1.650155055767639e-3_p
x(2)=5.562986897911132_p
w(2)=2.440681206010459e-3_p
x(3)=6.384062525911202_p
w(3)=1.691616203853562e-3_p
x(4)=7.569913241068842_p
w(4)=7.048535407701134e-4_p
x(5)=9.116094662237181_p
w(5)=1.892499933116631e-4_p
x(6)=11.00608485166757_p
w(6)=3.403741989079065e-5_p
x(7)=13.19388561476198_p
w(7)=4.296244217362695e-6_p
x(8)=15.5649826810245_p
w(8)=4.160654588449620e-7_p
x(9)=17.85511557107091_p
w(9)=3.696551543843604e-8_p
x(10)=19.53979851766391_p
w(10)=3.733168574125170e-9_p
else if(N==11)then
x(1)=5.093269684654584_p
w(1)=1.460071297433560e-3_p
x(2)=5.491230795246369_p
w(2)=2.285590699171093e-3_p
x(3)=6.206281494983601_p
w(3)=1.757255471654311e-3_p
x(4)=7.236278526308724_p
w(4)=8.532715647137491e-4_p
x(5)=8.575260221493570_p
w(5)=2.810849650442899e-4_p
x(6)=10.20882695965044_p
w(6)=6.529754758124208e-5_p
x(7)=12.10500297956494_p
w(7)=1.111499937042576e-5_p
x(8)=14.19645499884232_p
w(8)=1.470169306294764e-6_p
x(9)=16.34719778130179_p
w(9)=1.676226131325109e-7_p
x(10)=18.30075914800515_p
w(10)=1.949719385732872e-8_p
x(11)=19.64737381159059_p
w(11)=2.593882492811152e-9_p
else if(N==12)then
x(1)=5.082139716291505_p
w(1)=1.300016926959775e-3_p
x(2)=5.432432971042532_p
w(2)=2.132244048924855e-3_p
x(3)=6.061110676028789_p
w(3)=1.784526379209075e-3_p
x(4)=6.965172187592206_p
w(4)=9.810790925425937e-4_p
x(5)=8.138318807278464_p
w(5)=3.808994810803642e-4_p
x(6)=9.568086017101331_p
w(6)=1.084771915326936e-4_p
x(7)=11.23060567690839_p
w(7)=2.342631386591621e-5_p
x(8)=13.08143379838653_p
w(8)=4.004946207959837e-6_p
x(9)=15.03986818113275_p
w(9)=5.795704695407610e-7_p
x(10)=16.96478835722717_p
w(10)=7.891622381639463e-8_p
x(11)=18.62825179349937_p
w(11)=1.164805584942769e-8_p
x(12)=19.721620010324_p
w(12)=1.912892009061793e-9_p
else if(N==13)then
x(1)=5.072890024102191_p
w(1)=1.164203360716191e-3_p
x(2)=5.383633977104764_p
w(2)=1.985133541689322e-3_p
x(3)=5.940919258437475_p
w(3)=1.782553467911912e-3_p
x(4)=6.741471819276999_p
w(4)=1.085695797620471e-3_p
x(5)=7.779191074761887_p
w(5)=4.822552642926835e-4_p
x(6)=9.043312525186177_p
w(6)=1.621203616779851e-4_p
x(7)=10.51521172207868_p
w(7)=4.248812405108085e-5_p
x(8)=12.16323404406327_p
w(8)=8.980345721268435e-6_p
x(9)=13.93448448091754_p
w(9)=1.604858778655958e-6_p
x(10)=15.74264547192811_p
w(10)=2.600450495438689e-7_p
x(11)=17.45299948399762_p
w(11)=4.216124706399101e-8_p
x(12)=18.87337913052748_p
w(12)=7.626396775575174e-9_p
x(13)=19.77485916338137_p
w(13)=1.472811495261829e-9_p
else if(N==14)then
x(1)=5.065119585286496_p
w(1)=1.048114222176671e-3_p
x(2)=5.342678359097023_p
w(2)=1.846597340388420e-3_p
x(3)=5.840219095925183_p
w(3)=1.759071078358296e-3_p
x(4)=6.554490580902016_p
w(4)=1.167194374143413e-3_p
x(5)=7.479819876871744_p
w(5)=5.799172062309625e-4_p
x(6)=8.606907303069896_p
w(6)=2.236771565518609e-4_p
x(7)=9.920783116543502_p
w(7)=6.881040615160497e-5_p
x(8)=11.39769402426922_p
w(8)=1.736422333560161e-5_p
x(9)=13.00044666288455_p
w(9)=3.724836096106550e-6_p
x(10)=14.67177017280443_p
w(10)=7.135102346117847e-7_p
x(11)=16.32593387430238_p
w(11)=1.306407031125312e-7_p
x(12)=17.84114232436466_p
w(12)=2.491604385571854e-8_p
x(13)=19.06035208180685_p
w(13)=5.346188597397697e-9_p
x(14)=19.81426415869606_p
w(14)=1.171361334085642e-9_p
else if(N==15)then
x(1)=5.058528889256187_p
w(1)=9.482024155695359e-4_p
x(2)=5.307964576513374_p
w(2)=1.717650038114080e-3_p
x(3)=5.754970225612579_p
w(3)=1.720312549238764e-3_p
x(4)=6.396462192420243_p
w(4)=1.227224363618503e-3_p
x(5)=7.227276094180742_p
w(5)=6.701359687356664e-4_p
x(6)=8.239362750842739_p
w(6)=2.901346735141834e-4_p
x(7)=9.420434154152108_p
w(7)=1.021189223032766e-4_p
x(8)=10.75199065757215_p
w(8)=2.993221921510277e-5_p
x(9)=12.20651113025087_p
w(9)=7.515858843297438e-6_p
x(10)=13.74359314070885_p
w(10)=1.677099309516166e-6_p
x(11)=15.30508595383812_p
w(11)=3.492120252383317e-7_p
x(12)=16.81006063233372_p
w(12)=7.225241662857754e-8_p
x(13)=18.15227094308909_p
w(13)=1.595257175473808e-8_p
x(14)=19.20556614431934_p
w(14)=3.947084892793270e-9_p
x(15)=19.84421328118793_p
w(15)=9.554040082494504e-10_p
else if(N==16)then
x(1)=5.052890588916983_p
w(1)=8.616613228520878e-4_p
x(2)=5.278281688093894_p
w(2)=1.598511335857214e-3_p
x(3)=5.682139277262641_p
w(3)=1.671140444902242e-3_p
x(4)=6.261611087339045_p
w(4)=1.268229001962545e-3_p
x(5)=7.012049781760376_p
w(5)=7.505701424900170e-4_p
x(6)=7.926469789882182_p
w(6)=3.585191910899781e-4_p
x(7)=8.994624364663057_p
w(7)=1.414956289769953e-4_p
x(8)=10.20170436189163_p
w(8)=4.712893325046960e-5_p
x(9)=11.52655732271721_p
w(9)=1.356024822074825e-5_p
x(10)=12.93931989049455_p
w(10)=3.468118019106402e-6_p
x(11)=14.39846595105486_p
w(11)=8.177898435756158e-7_p
x(12)=15.84759299330524_p
w(12)=1.862444152959983e-7_p
x(13)=17.21296657657643_p
w(13)=4.331207314794378e-8_p
x(14)=18.40402225041686_p
w(14)=1.088560371985469e-8_p
x(15)=19.32024708114727_p
w(15)=3.033292884111162e-9_p
x(16)=19.86749136534237_p
w(16)=7.951144222912238e-10_p
else if(N==17)then
x(1)=5.048029593674442_p
w(1)=7.862530159539164e-4_p
x(2)=5.252699857314790_p
w(2)=1.488939217096900e-3_p
x(3)=5.619409375780600_p
w(3)=1.615261271609999e-3_p
x(4)=6.145557790025575_p
w(4)=1.292929523901185e-3_p
x(5)=6.826989127540888_p
w(5)=8.200419736076489e-4_p
x(6)=7.657621970075587_p
w(6)=4.262155000368302e-4_p
x(7)=8.628805924441442_p
w(7)=1.856003424103105e-4_p
x(8)=9.728435269446802_p
w(8)=6.901608125094821e-5_p
x(9)=10.93977440052893_p
w(9)=2.235304209494191e-5_p
x(10)=12.2399404863504_p
w(10)=6.452937069258577e-6_p
x(11)=13.5980388352295_p
w(11)=1.708216281157268e-6_p
x(12)=14.97308887284568_p
w(12)=4.295582211883387e-7_p
x(13)=16.31217364773774_p
w(13)=1.070892960278893e-7_p
x(14)=17.54975306905083_p
w(14)=2.776399228207601e-8_p
x(15)=18.60973051922521_p
w(15)=7.816630836702979e-9_p
x(16)=19.41220105630691_p
w(16)=2.405822935942336e-9_p
x(17)=19.88593389380667_p
w(17)=6.726880813029259e-10_p
else
call GD(5)
end if
end subroutine GF_5

end module m_gauss_fermi_20
