! Module to contain all the Gauss-Fermi quadrature points
! It has been created by an automatic script created by:
! Nick Papior Andersen, 2013, nickpapior@gmail.com
! If you ever need to use this please contact the author for approval

! We have employed the Stieltjes and moment algorithm together with the Golub-Welsch
! for an efficient and fairly accurate stability of the orthogonal polynomials.

module m_gauss_fermi_17

  implicit none

  integer, parameter :: p = selected_real_kind(14,300)

  integer, parameter :: G_NF_MIN_N  =  2
  integer, parameter :: G_NF_MAX_N  = 17
  integer, parameter :: G_NF_MIN_kT = -20
  integer, parameter :: G_NF_MAX_kT = 5
  
  private
  public :: G_NF_MIN_N
  public :: G_NF_MAX_N
  public :: G_NF_MIN_kT
  public :: G_NF_MAX_kT
  public :: GaussFermi_17
  
contains

  ! Die routine for the Gauss-Fermi routines
  subroutine GD(NkT)
    integer, intent(in) :: NkT
    write(*,*) 'Error in Gauss-Fermi ',NkT
    call die('Error in number of points for Gauss-Fermi, see output.')
  end subroutine GD
  
  subroutine GaussFermi_17(NkT,N,x,w)
    integer, intent(in) :: NkT, N
    real(p), intent(out) :: x(N), w(N)
    
    if ( NkT == -20 ) then
       call GF_m20(N,x,w)
    else if ( NkT == -19 ) then
       call GF_m19(N,x,w)
    else if ( NkT == -18 ) then
       call GF_m18(N,x,w)
    else if ( NkT == -17 ) then
       call GF_m17(N,x,w)
    else if ( NkT == -16 ) then
       call GF_m16(N,x,w)
    else if ( NkT == -15 ) then
       call GF_m15(N,x,w)
    else if ( NkT == -14 ) then
       call GF_m14(N,x,w)
    else if ( NkT == -13 ) then
       call GF_m13(N,x,w)
    else if ( NkT == -12 ) then
       call GF_m12(N,x,w)
    else if ( NkT == -11 ) then
       call GF_m11(N,x,w)
    else if ( NkT == -10 ) then
       call GF_m10(N,x,w)
    else if ( NkT == -9 ) then
       call GF_m9(N,x,w)
    else if ( NkT == -8 ) then
       call GF_m8(N,x,w)
    else if ( NkT == -7 ) then
       call GF_m7(N,x,w)
    else if ( NkT == -6 ) then
       call GF_m6(N,x,w)
    else if ( NkT == -5 ) then
       call GF_m5(N,x,w)
    else if ( NkT == -4 ) then
       call GF_m4(N,x,w)
    else if ( NkT == -3 ) then
       call GF_m3(N,x,w)
    else if ( NkT == -2 ) then
       call GF_m2(N,x,w)
    else if ( NkT == -1 ) then
       call GF_m1(N,x,w)
    else if ( NkT == 0 ) then
       call GF_0(N,x,w)
    else if ( NkT == 1 ) then
       call GF_1(N,x,w)
    else if ( NkT == 2 ) then
       call GF_2(N,x,w)
    else if ( NkT == 3 ) then
       call GF_3(N,x,w)
    else if ( NkT == 4 ) then
       call GF_4(N,x,w)
    else if ( NkT == 5 ) then
       call GF_5(N,x,w)
    else
       call die('Could not figure out the Gauss-Fermi &
             &quadratue method you asked for.')
    end if
  end subroutine GaussFermi_17
  
  
! [-20kT;17kT]
subroutine GF_m20(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-15.59867345606692_p
w(1)=10.40131964076643_p
x(2)=-3.761796093812158_p
w(2)=9.598680319895347_p
else if(N==3)then
x(1)=-17.56069979173628_p
w(1)=6.008945217337787_p
x(2)=-9.213308339286151_p
w(2)=9.514818996940997_p
x(3)=-1.155172063453064_p
w(3)=4.476235746382994_p
else if(N==4)then
x(1)=-18.43112493061279_p
w(1)=3.928540566863464_p
x(2)=-12.55796529416423_p
w(2)=7.327466787701387_p
x(3)=-5.008735577397977_p
w(3)=7.006548553647873_p
x(4)=6.701671280248310e-1_p
w(4)=1.737444052449053_p
else if(N==5)then
x(1)=-18.89101714367339_p
w(1)=2.799616976375877_p
x(2)=-14.55336701320518_p
w(2)=5.634205086007898_p
x(3)=-8.253103772737132_p
w(3)=6.589618508328733_p
x(4)=-2.227992021359036_p
w(4)=4.559660407287009_p
x(5)=2.573506876481976_p
w(5)=4.168989826622603e-1_p
else if(N==6)then
x(1)=-19.16477322522818_p
w(1)=2.118312534383601_p
x(2)=-15.81583435305681_p
w(2)=4.446142821849776_p
x(3)=-10.63014571855891_p
w(3)=5.707804116241256_p
x(4)=-4.903449040576477_p
w(4)=5.411321583455056_p
x(5)=-2.179950178504967e-1_p
w(5)=2.262028627852988_p
x(6)=4.842981170605098_p
w(6)=5.439027687909932e-2_p
else if(N==7)then
x(1)=-19.34282294770618_p
w(1)=1.671578981768088_p
x(2)=-16.66673454594088_p
w(2)=3.600511423223800_p
x(3)=-12.36050171180521_p
w(3)=4.876926673399663_p
x(4)=-7.227240535604426_p
w(4)=5.205556982935205_p
x(5)=-2.366778935962583_p
w(5)=3.926126215803328_p
x(6)=1.604605368673669_p
w(6)=7.144608909744060e-1_p
x(7)=7.372844444301358_p
w(7)=4.838792557287443e-3_p
else if(N==8)then
x(1)=-19.46714912405174_p
w(1)=1.357982531038189_p
x(2)=-17.27476941490847_p
w(2)=2.975754934802135_p
x(3)=-13.65693004117033_p
w(3)=4.171721960954608_p
x(4)=-9.138464657043915_p
w(4)=4.746300126311575_p
x(5)=-4.438062570014111_p
w(5)=4.436979509008103_p
x(6)=-4.406725881717570e-1_p
w(6)=2.176419767657781_p
x(7)=3.569814634296129_p
w(7)=1.344287967336234e-1_p
x(8)=9.866533807924041_p
w(8)=4.123341557628269e-4_p
else if(N==9)then
x(1)=-19.55876541619175_p
w(1)=1.126040268577728_p
x(2)=-17.73004865739251_p
w(2)=2.497434176684309_p
x(3)=-14.65901043178307_p
w(3)=3.584795536600240_p
x(4)=-10.70205014725487_p
w(4)=4.247857253554309_p
x(5)=-6.347689162597326_p
w(5)=4.346615191754204_p
x(6)=-2.249241754825420_p
w(6)=3.360485213531700_p
x(7)=1.222590104852166_p
w(7)=8.174106169857190e-1_p
x(8)=5.614617502390292_p
w(8)=1.931526316855018e-2_p
x(9)=11.98505294595816_p
w(9)=4.643980501793332e-5_p
else if(N==10)then
x(1)=-19.62870688959095_p
w(1)=9.485023123121491e-1_p
x(2)=-18.08162170477744_p
w(2)=2.122277694461176_p
x(3)=-15.45031915931528_p
w(3)=3.098445864491149_p
x(4)=-11.98438835235841_p
w(4)=3.776041041451250_p
x(5)=-8.027734150713457_p
w(5)=4.062905789149695_p
x(6)=-4.028017560898869_p
w(6)=3.763799982793855_p
x(7)=-5.375500753475974e-1_p
w(7)=2.016588130594368_p
x(8)=2.884292000860877_p
w(8)=2.086011911358562e-1_p
x(9)=7.551265529691458_p
w(9)=2.829689938874814e-3_p
x(10)=13.54611479299547_p
w(10)=8.264333405511067e-6_p
else if(N==11)then
x(1)=-19.68335607333939_p
w(1)=8.095109263479533e-1_p
x(2)=-18.35865225353123_p
w(2)=1.823319607629635_p
x(3)=-16.08404898726367_p
w(3)=2.695786088089468_p
x(4)=-13.0390258256182_p
w(4)=3.352704126255575_p
x(5)=-9.472384995329332_p
w(5)=3.727922052042959_p
x(6)=-5.701581216397624_p
w(6)=3.731358693595448_p
x(7)=-2.151238014553434_p
w(7)=2.935595473692913_p
x(8)=9.406883772574681e-1_p
w(8)=8.800096510095714e-1_p
x(9)=4.558631687134680_p
w(9)=4.329919086761249e-2_p
x(10)=9.262085351625206_p
w(10)=4.918559846626065e-4_p
x(11)=14.59563118729569_p
w(11)=2.295145979003940e-6_p
else if(N==12)then
x(1)=-19.7268318465181_p
w(1)=6.987738613112976e-1_p
x(2)=-18.58045079693825_p
w(2)=1.581949357600546_p
x(3)=-16.59762123516899_p
w(3)=2.361562902311704_p
x(4)=-13.91044696987771_p
w(4)=2.982012427613531_p
x(5)=-10.70309763114421_p
w(5)=3.393899523070106_p
x(6)=-7.208797830211451_p
w(6)=3.543330071600919_p
x(7)=-3.727271423533749_p
w(7)=3.268302402158114_p
x(8)=-6.254648167639967e-1_p
w(8)=1.879440825328576_p
x(9)=2.378749640351109_p
w(9)=2.817335322956744e-1_p
x(10)=6.159386712262236_p
w(10)=8.886555690067530e-3_p
x(11)=10.70229480782231_p
w(11)=1.076052929741271e-4_p
x(12)=15.27865874297962_p
w(12)=8.963882672402927e-7_p
else if(N==13)then
x(1)=-19.76196127422934_p
w(1)=6.091933563446249e-1_p
x(2)=-18.76055441571298_p
w(2)=1.384690900181149_p
x(3)=-17.0185449260844_p
w(3)=2.082693221802623_p
x(4)=-14.6351833366145_p
w(4)=2.660791319477781_p
x(5)=-11.74953546168351_p
w(5)=3.081209073814335_p
x(6)=-8.537442925258292_p
w(6)=3.306479388975007_p
x(7)=-5.217163428607554_p
w(7)=3.267360437844975_p
x(8)=-2.081214557670656_p
w(8)=2.609097687783605_p
x(9)=7.088283994269705e-1_p
w(9)=9.213435263703109e-1_p
x(10)=3.812086939791711_p
w(10)=7.510373549057978e-2_p
x(11)=7.621532308236519_p
w(11)=2.006989815931323e-3_p
x(12)=11.87449013817485_p
w(12)=2.987932436049290e-5_p
x(13)=15.7264452143646_p
w(13)=4.434364951557083e-7_p
else if(N==14)then
x(1)=-19.79074095644075_p
w(1)=5.357384626085041e-1_p
x(2)=-18.90867843674096_p
w(2)=1.221640951847411_p
x(3)=-17.36725964537723_p
w(3)=1.848471834226315_p
x(4)=-15.24241724566845_p
w(4)=2.383356485686765_p
x(5)=-12.64101481304547_p
w(5)=2.796893259139937_p
x(6)=-9.698306245100204_p
w(6)=3.061062487914386_p
x(7)=-6.579151037580277_p
w(7)=3.138319982174640_p
x(8)=-3.495356556178533_p
w(8)=2.888141384572706_p
x(9)=-7.019355580780169e-1_p
w(9)=1.758201485262031_p
x(10)=1.987961261769963_p
w(10)=3.483157693775436e-1_p
x(11)=5.194549356521587_p
w(11)=1.932528727178832e-2_p
x(12)=8.915207172645973_p
w(12)=5.219877466137702e-4_p
x(13)=12.80843846029792_p
w(13)=1.032543876228127e-5_p
x(14)=16.02774570688287_p
w(14)=2.573943737762378e-7_p
else if(N==15)then
x(1)=-19.81460901270883_p
w(1)=4.747753841626267e-1_p
x(2)=-19.03190691787986_p
w(2)=1.085450714630514_p
x(3)=-17.65905647155771_p
w(3)=1.650357652720540_p
x(4)=-15.7550927187531_p
w(4)=2.143634813651666_p
x(5)=-13.40342046536059_p
w(5)=2.542063511674819_p
x(6)=-10.7098039158364_p
w(6)=2.823873153625512_p
x(7)=-7.802094500733642_p
w(7)=2.964543743223303_p
x(8)=-4.837497373859575_p
w(8)=2.905293227223617_p
x(9)=-2.026319520982570_p
w(9)=2.348980730851976_p
x(10)=5.174563379369453e-1_p
w(10)=9.440888246397098e-1_p
x(11)=3.251265053091929_p
w(11)=1.115267608086187e-1_p
x(12)=6.482264921067623_p
w(12)=5.248493800683926e-3_p
x(13)=10.03486390871943_p
w(13)=1.584824794758707e-4_p
x(14)=13.54478907712419_p
w(14)=4.300483776059612e-6_p
x(15)=16.23699851684003_p
w(15)=1.666849392963071e-7_p
else if(N==16)then
x(1)=-19.83462024116207_p
w(1)=4.236330696314058e-1_p
x(2)=-19.13548569553161_p
w(2)=9.706049418409732e-1_p
x(3)=-17.9054826226257_p
w(3)=1.481598965107762_p
x(4)=-16.19117110540196_p
w(4)=1.935997458408571_p
x(5)=-14.05855702225804_p
w(5)=2.315231522713252_p
x(6)=-11.59152536724346_p
w(6)=2.601988757005732_p
x(7)=-8.891140755797279_p
w(7)=2.778416348051765_p
x(8)=-6.078404310446877_p
w(8)=2.814856700996462_p
x(9)=-3.309239311514304_p
w(9)=2.586973745741098_p
x(10)=-7.670223366822336e-1_p
w(10)=1.649470000434330_p
x(11)=1.675749420556819_p
w(11)=4.056363828953928e-1_p
x(12)=4.475422521505465_p
w(12)=3.396697165652553e-2_p
x(13)=7.652277415087038_p
w(13)=1.566919665244822e-3_p
x(14)=10.98967786904593_p
w(14)=5.597357091212132e-5_p
x(15)=14.12412263510786_p
w(15)=2.086365724192382e-6_p
x(16)=16.38692558809765_p
w(16)=1.165766251575091e-7_p
else if(N==17)then
x(1)=-19.85156160848632_p
w(1)=3.803152039204988e-1_p
x(2)=-19.22335866088326_p
w(2)=8.729133673516537e-1_p
x(3)=-18.11535392760823_p
w(3)=1.336862624380105_p
x(4)=-16.56474269356213_p
w(4)=1.755525196580698_p
x(5)=-14.6244167654728_p
w(5)=2.113882848443732_p
x(6)=-12.36174347081495_p
w(6)=2.397943772030140_p
x(7)=-9.857812801395232_p
w(7)=2.593911290357091_p
x(8)=-7.208328929275991_p
w(8)=2.683727274368294_p
x(9)=-4.530812988771418_p
w(9)=2.614821547288762_p
x(10)=-1.981413956380207_p
w(10)=2.136467330162108_p
x(11)=3.570979734600805e-1_p
w(11)=9.527474641947585e-1_p
x(12)=2.810943923106095_p
w(12)=1.497055053052352e-1_p
x(13)=5.630301630350694_p
w(13)=1.063060323961725e-2_p
x(14)=8.697500441883502_p
w(14)=5.219909821684225e-4_p
x(15)=11.79655729687993_p
w(15)=2.271246873524091e-5_p
x(16)=14.58158895123883_p
w(16)=1.143378361618259e-6_p
x(17)=16.49744297712611_p
w(17)=8.620981961260290e-8_p
else
call GD(-20)
end if
end subroutine GF_m20

! [-19kT;17kT]
subroutine GF_m19(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-14.80201431467502_p
w(1)=9.919647034445845_p
x(2)=-3.526769238787772_p
w(2)=9.080352929757575_p
else if(N==3)then
x(1)=-16.66602579161419_p
w(1)=5.749150322343491_p
x(2)=-8.682937678884599_p
w(2)=9.091363952985089_p
x(3)=-9.856585465580465e-1_p
w(3)=4.159485688874839_p
else if(N==4)then
x(1)=-17.49430749475189_p
w(1)=3.770153850158676_p
x(2)=-11.8594344242178_p
w(2)=7.027457894688680_p
x(3)=-4.631648000463584_p
w(3)=6.664666077713002_p
x(4)=8.527075958014507e-1_p
w(4)=1.537722141643063_p
else if(N==5)then
x(1)=-17.93276709093941_p
w(1)=2.694108665516925_p
x(2)=-13.75947952917241_p
w(2)=5.419247278576045_p
x(3)=-7.704716398201749_p
w(3)=6.322373506281766_p
x(4)=-1.943689570757746_p
w(4)=4.226672128899500_p
x(5)=2.817583930829120_p
w(5)=3.375983849291837e-1_p
else if(N==6)then
x(1)=-18.19436415506345_p
w(1)=2.043188242359196_p
x(2)=-14.96477778946728_p
w(2)=4.286768674821396_p
x(3)=-9.967753321919101_p
w(3)=5.495630517038215_p
x(4)=-4.467381369568274_p
w(4)=5.154393141543760_p
x(5)=3.419610180318804e-2_p
w(5)=1.979677266683587_p
x(6)=5.156317064717022_p
w(6)=4.034212175726431e-2_p
else if(N==7)then
x(1)=-18.36502585655067_p
w(1)=1.615052565925370_p
x(2)=-15.77982546987132_p
w(2)=3.477626763476061_p
x(3)=-11.62225536129773_p
w(3)=4.706055427138865_p
x(4)=-6.675383735766459_p
w(4)=5.003100448333371_p
x(5)=-2.022186258639350_p
w(5)=3.624304873081668_p
x(6)=1.887989789295669_p
w(6)=5.704462452651623e-1_p
x(7)=7.726302956647471_p
w(7)=3.413640982922677e-3_p
else if(N==8)then
x(1)=-18.48461404731053_p
w(1)=1.313437851952411_p
x(2)=-16.36441131367594_p
w(2)=2.877393932791850_p
x(3)=-12.86722109885699_p
w(3)=4.031096482904487_p
x(4)=-8.504585453290243_p
w(4)=4.576879357575923_p
x(5)=-3.985159751256857_p
w(5)=4.218079238093771_p
x(6)=-1.458623997776184e-1_p
w(6)=1.884008633147661_p
x(7)=3.898385149443024_p
w(7)=9.881417345299330e-2_p
x(8)=10.21049854522932_p
w(8)=2.902942843239049e-4_p
else if(N==9)then
x(1)=-18.57297128757392_p
w(1)=1.089763113189107_p
x(2)=-16.80334416848055_p
w(2)=2.416477744795848_p
x(3)=-13.83253754983483_p
w(3)=3.466860121106480_p
x(4)=-10.00779765739283_p
w(4)=4.102935955788849_p
x(5)=-5.808721866803169_p
w(5)=4.175769689377568_p
x(6)=-1.882977762418447_p
w(6)=3.085170571762561_p
x(7)=1.524454249730258_p
w(7)=6.492587459136070e-1_p
x(8)=5.958792732086573_p
w(8)=1.372993576083525e-2_p
x(9)=12.27124562010131_p
w(9)=3.408650856426488e-5_p
else if(N==10)then
x(1)=-18.64051073613572_p
w(1)=9.183323573941388e-1_p
x(2)=-17.14275314855611_p
w(2)=2.054437126169845_p
x(3)=-14.59600962358568_p
w(3)=2.998272831511247_p
x(4)=-11.24338749662119_p
w(4)=3.650865887395600_p
x(5)=-7.421501656195960_p
w(5)=3.918104089844843_p
x(6)=-3.575413838324347_p
w(6)=3.567685044978005_p
x(7)=-2.213053352415958e-1_p
w(7)=1.736127031114001_p
x(8)=3.212017613123580_p
w(8)=1.541523676948090e-1_p
x(9)=7.882236271858847_p
w(9)=2.016789715372539e-3_p
x(10)=13.75766482173931_p
w(10)=6.438385558977143e-6_p
else if(N==11)then
x(1)=-18.69331444828382_p
w(1)=7.840409189802231e-1_p
x(2)=-17.41037192231134_p
w(2)=1.765720367161809_p
x(3)=-15.20792643369936_p
w(3)=2.609865821364896_p
x(4)=-12.2607641611265_p
w(4)=3.243878794056088_p
x(5)=-8.811996396155688_p
w(5)=3.601519792547415_p
x(6)=-5.175279001301505_p
w(6)=3.580794840019941_p
x(7)=-1.772679526208013_p
w(7)=2.683802690120231_p
x(8)=1.254187536549385_p
w(8)=6.990315380695485e-1_p
x(9)=4.896810843477335_p
w(9)=3.098487741197289e-2_p
x(10)=9.562429307748047_p
w(10)=3.584369716103586e-4_p
x(11)=14.74360446102203_p
w(11)=1.887499685056904e-6_p
else if(N==12)then
x(1)=-18.73534018111631_p
w(1)=6.770013496233852e-1_p
x(2)=-17.62473604398222_p
w(2)=1.532495061187956_p
x(3)=-15.70410345079068_p
w(3)=2.287209748768685_p
x(4)=-13.10207801944499_p
w(4)=2.886815417274816_p
x(5)=-9.998433890154521_p
w(5)=3.282328467033971_p
x(6)=-6.622489049546799_p
w(6)=3.416160451873911_p
x(7)=-3.274339452354353_p
w(7)=3.089232748594479_p
x(8)=-2.920784472848708e-1_p
w(8)=1.613237060508151_p
x(9)=2.708923042200312_p
w(9)=2.090957576133828e-1_p
x(10)=6.489607790262161_p
w(10)=6.342196725658013e-3_p
x(11)=10.9638922527456_p
w(11)=8.093700482703123e-5_p
x(12)=15.38150875912772_p
w(12)=7.679941986943251e-7_p
else if(N==13)then
x(1)=-18.76931151754123_p
w(1)=5.903767352076075e-1_p
x(2)=-17.79887773138407_p
w(2)=1.341802508464423_p
x(3)=-16.11097425820876_p
w(3)=2.017810338297307_p
x(4)=-13.80223990444972_p
w(4)=2.576996088796171_p
x(5)=-11.00833372262431_p
w(5)=2.982102575359241_p
x(6)=-7.901636932601614_p
w(6)=3.194530886123705_p
x(7)=-4.699234507896736_p
w(7)=3.131422137684583_p
x(8)=-1.691905842071197_p
w(8)=2.377086093197097_p
x(9)=1.033920222020365_p
w(9)=7.325249689733681e-1_p
x(10)=4.150719463068556_p
w(10)=5.387259739758680e-2_p
x(11)=7.931724651801642_p
w(11)=1.451386513240816e-3_p
x(12)=12.09612422581125_p
w(12)=2.325708031724213e-5_p
x(13)=15.79930042579888_p
w(13)=3.911087727520044e-7_p
else if(N==14)then
x(1)=-18.79715279882615_p
w(1)=5.193188165254223e-1_p
x(2)=-17.94215518429671_p
w(2)=1.184112020819125_p
x(3)=-16.44819860458087_p
w(3)=1.791413557345102_p
x(4)=-14.38921470956625_p
w(4)=2.309146858693801_p
x(5)=-11.8694035634105_p
w(5)=2.708409773720057_p
x(6)=-9.021113140532192_p
w(6)=2.960910091660939_p
x(7)=-6.007261010045447_p
w(7)=3.024298421402013_p
x(8)=-3.041128335978084_p
w(8)=2.722374601782226_p
x(9)=-3.538745789893619e-1_p
w(9)=1.506447347683489_p
x(10)=2.322963657340058_p
w(10)=2.594084013810218e-1_p
x(11)=5.528021473406572_p
w(11)=1.376592978898760e-2_p
x(12)=9.198867751113612_p
w(12)=3.856087253857676e-4_p
x(13)=12.99324424891073_p
w(13)=8.302983611692907e-6_p
x(14)=16.08082139604216_p
w(14)=2.316922405239698e-7_p
else if(N==15)then
x(1)=-18.82025042034235_p
w(1)=4.603248732137558e-1_p
x(2)=-18.06139426553181_p
w(2)=1.052347848468113_p
x(3)=-16.7304930435055_p
w(3)=1.599824233179865_p
x(4)=-14.88502459615907_p
w(4)=2.077531596707691_p
x(5)=-12.60628958815717_p
w(5)=2.462695416945864_p
x(6)=-9.997655766659294_p
w(6)=2.733580380637437_p
x(7)=-7.184920838397451_p
w(7)=2.863901140960875_p
x(8)=-4.325461196133677_p
w(8)=2.780282300422353_p
x(9)=-1.627842069839164_p
w(9)=2.133757721956265_p
x(10)=8.534936842194651e-1_p
w(10)=7.517434876151771e-1_p
x(11)=3.592649430400182_p
w(11)=8.011844252007787e-2_p
x(12)=6.800904030914467_p
w(12)=3.768792921189406e-3_p
x(13)=10.28949389129171_p
w(13)=1.200173842781481e-4_p
x(14)=13.69788357596987_p
w(14)=3.559037496422868e-6_p
x(15)=16.27680557296098_p
w(15)=1.522329833482173e-7_p
else if(N==16)then
x(1)=-18.83962160747631_p
w(1)=4.108192372069525e-1_p
x(2)=-18.16165182093357_p
w(2)=9.411966591112653e-1_p
x(3)=-16.9689781962064_p
w(3)=1.436555110264620_p
x(4)=-15.30693185718008_p
w(4)=1.876793117386608_p
x(5)=-13.23983866225307_p
w(5)=2.243724715926048_p
x(6)=-10.84961541972327_p
w(6)=2.520182789051382_p
x(7)=-8.235426098081341_p
w(7)=2.687652523685877_p
x(8)=-5.517487645890474_p
w(8)=2.710847442757128_p
x(9)=-2.853438961078299_p
w(9)=2.431964183987979_p
x(10)=-4.064955783343300e-1_p
w(10)=1.411800084431704_p
x(11)=2.016480346220778_p
w(11)=3.031332839747203e-1_p
x(12)=4.813126340305847_p
w(12)=2.414248109956998e-2_p
x(13)=7.950544193391287_p
w(13)=1.142977189232469e-3_p
x(14)=11.21547248376828_p
w(14)=4.348131819178648e-5_p
x(15)=14.25096963652229_p
w(15)=1.769210901014331e-6_p
x(16)=16.41759560964166_p
w(16)=1.076012410430599e-7_p
else if(N==17)then
x(1)=-18.85602561162106_p
w(1)=3.688760512094687e-1_p
x(2)=-18.2467314914656_p
w(2)=8.466192270870514e-1_p
x(3)=-17.17214973739303_p
w(3)=1.296475982801451_p
x(4)=-15.66849338295968_p
w(4)=1.702229422106356_p
x(5)=-13.78729894418749_p
w(5)=2.049187338199332_p
x(6)=-11.59431426342494_p
w(6)=2.323536069663619_p
x(7)=-9.168957866910592_p
w(7)=2.511250505999116_p
x(8)=-6.605778601349380_p
w(8)=2.592026754931604_p
x(9)=-4.023121069992544_p
w(9)=2.498259743992403_p
x(10)=-1.575139575545714_p
w(10)=1.935688733212635_p
x(11)=7.032023122201095e-1_p
w(11)=7.601346328189870e-1_p
x(12)=3.156009884886658_p
w(12)=1.077206727885578e-1_p
x(13)=5.956322305530918_p
w(13)=7.587453732469844e-3_p
x(14)=8.972773636010398_p
w(14)=3.882273116655671e-4_p
x(15)=11.99533378512691_p
w(15)=1.807883323277416e-5_p
x(16)=14.68715647456339_p
w(16)=9.893111008383579e-7_p
x(17)=16.52164291244351_p
w(17)=8.020436989741982e-8_p
else
call GD(-19)
end if
end subroutine GF_m19

! [-18kT;17kT]
subroutine GF_m18(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-14.00466091772538_p
w(1)=9.439547726404228_p
x(2)=-3.289242323756743_p
w(2)=8.560452247426376_p
else if(N==3)then
x(1)=-15.77083444576159_p
w(1)=5.490601266830961_p
x(2)=-8.150677036966215_p
w(2)=8.668228155510468_p
x(3)=-8.101111785626492e-1_p
w(3)=3.841170551489174_p
else if(N==4)then
x(1)=-16.5571374088143_p
w(1)=3.612633738331741_p
x(2)=-11.15940933826683_p
w(2)=6.728550325084794_p
x(3)=-4.253121518141339_p
w(3)=6.315469482989053_p
x(4)=1.047319368153658_p
w(4)=1.343346427425015_p
else if(N==5)then
x(1)=-16.97428629490594_p
w(1)=2.589172760126227_p
x(2)=-12.96455938525414_p
w(2)=5.205181406278479_p
x(3)=-7.154908735434091_p
w(3)=6.053625437886413_p
x(4)=-1.656836963993421_p
w(4)=3.883966226544964_p
x(5)=3.079275368634706_p
w(5)=2.680541429945218e-1_p
else if(N==6)then
x(1)=-17.22381908610035_p
w(1)=1.968402612959621_p
x(2)=-14.1131000573802_p
w(2)=4.127956104210539_p
x(3)=-9.304369008021206_p
w(3)=5.283263741712109_p
x(4)=-4.031778802041751_p
w(4)=4.886808691008926_p
x(5)=2.965885921090576e-1_p
w(5)=1.704205504386804_p
x(6)=5.487126748136240_p
w(6)=2.936331955260319e-2_p
else if(N==7)then
x(1)=-17.38716939568472_p
w(1)=1.558673380279081_p
x(2)=-14.89265094149324_p
w(2)=3.354972348554637_p
x(3)=-10.88361513288931_p
w(3)=4.535072353206614_p
x(4)=-6.123996145610546_p
w(4)=4.796831953830024_p
x(5)=-1.677961518286936_p
w(5)=3.307070652165102_p
x(6)=2.188660984358697_p
w(6)=4.450042214975082e-1_p
x(7)=8.092259556260849_p
w(7)=2.375064297638100e-3_p
else if(N==8)then
x(1)=-17.50206609786905_p
w(1)=1.268923727476900_p
x(2)=-15.45400838630034_p
w(2)=2.779049265342851_p
x(3)=-12.0775273580354_p
w(3)=3.890274368782675_p
x(4)=-7.871284349425602_p
w(4)=4.405927128870467_p
x(5)=-3.535140887305422_p
w(5)=3.985333654768348_p
x(6)=1.567175244161087e-1_p
w(6)=1.599019441658797_p
x(7)=4.242334284493614_p
w(7)=7.126927292970872e-2_p
x(8)=10.55817849003571_p
w(8)=2.031140008556623e-4_p
else if(N==9)then
x(1)=-17.58717968060028_p
w(1)=1.053478125765131_p
x(2)=-15.87666556910215_p
w(2)=2.335473061584990_p
x(3)=-13.00619632372918_p
w(3)=3.348731154957110_p
x(4)=-9.314067675478071_p
w(4)=3.957226351335842_p
x(5)=-5.271800341341488_p
w(5)=3.999193398677755_p
x(6)=-1.518364435011347_p
w(6)=2.792933239507337_p
x(7)=1.841356024715264_p
w(7)=5.032969898001899e-1_p
x(8)=6.312826856131188_p
w(8)=9.642621741516264e-3_p
x(9)=12.55362465368076_p
w(9)=2.503046073208214e-5_p
else if(N==10)then
x(1)=-17.65231872142746_p
w(1)=8.881509017827386e-1_p
x(2)=-16.20391448326143_p
w(2)=1.986550626380348_p
x(3)=-13.74181611284454_p
w(3)=2.897955979835666_p
x(4)=-10.50276334784331_p
w(4)=3.525230757273667_p
x(5)=-6.816511239885358_p
w(5)=3.770990021982712_p
x(6)=-3.126303782065771_p
w(6)=3.355930758161323_p
x(7)=1.015277975806254e-1_p
w(7)=1.462046853875027_p
x(8)=3.553886538305344_p
w(8)=1.117116687015212e-1_p
x(9)=8.218238024010942_p
w(9)=1.427374148981320e-3_p
x(10)=13.9628760121891_p
w(10)=5.031688619563482e-6_p
else if(N==11)then
x(1)=-17.70327616480694_p
w(1)=7.585617222561506e-1_p
x(2)=-16.46211479225457_p
w(2)=1.708086551413923_p
x(3)=-14.33188961913128_p
w(3)=2.523844034055089_p
x(4)=-11.48276392418726_p
w(4)=3.134763187751464_p
x(5)=-8.152384603204325_p
w(5)=3.474027570006264_p
x(6)=-4.651414756604394_p
w(6)=3.423033446389101_p
x(7)=-1.395732553683406_p
w(7)=2.414342165575853_p
x(8)=1.581344654869959_p
w(8)=5.411891788003501e-1_p
x(9)=5.244931689260796_p
w(9)=2.189024264269048e-2_p
x(10)=9.864178189163718_p
w(10)=2.603178277775962e-4_p
x(11)=14.88595141641215_p
w(11)=1.557111940808634e-6_p
else if(N==12)then
x(1)=-17.74385128016332_p
w(1)=6.552213032195138e-1_p
x(2)=-16.66903983935602_p
w(2)=1.483013883798436_p
x(3)=-14.81065128664883_p
w(3)=2.212782028817880_p
x(4)=-12.29389902140759_p
w(4)=2.791421881322496_p
x(5)=-9.294290715535679_p
w(5)=3.170155639533228_p
x(6)=-6.037696680447591_p
w(6)=3.285940893423286_p
x(7)=-2.824928769353557_p
w(7)=2.893304487193535_p
x(8)=4.711005428647558e-2_p
w(8)=1.351637512047026_p
x(9)=3.052743404884319_p
w(9)=1.519713856662491e-1_p
x(10)=6.825970027922552_p
w(10)=4.489483919317958e-3_p
x(11)=11.22451596806101_p
w(11)=6.081542454817731e-5_p
x(12)=15.48022128110802_p
w(12)=6.594650884179045e-7_p
else if(N==13)then
x(1)=-17.77666420425977_p
w(1)=5.715535220782386e-1_p
x(2)=-16.83721680971452_p
w(2)=1.298892021806443_p
x(3)=-15.2034566318157_p
w(3)=1.952869976502691_p
x(4)=-12.96944194380767_p
w(4)=2.493059906911974_p
x(5)=-10.267503849679_p
w(5)=2.882621822781272_p
x(6)=-7.266813285866039_p
w(6)=3.081147625752804_p
x(7)=-4.183989048857619_p
w(7)=2.986948500655418_p
x(8)=-1.304133038158493_p
w(8)=2.126958600674895_p
x(9)=1.371433236086335_p
w(9)=5.667797799476108e-1_p
x(10)=4.499530702797245_p
w(10)=3.810543763497069e-2_p
x(11)=8.245157145800951_p
w(11)=1.044325266282788e-3_p
x(12)=12.31552848966646_p
w(12)=1.810839321059257e-5_p
x(13)=15.86928606881727_p
w(13)=3.454247932004098e-7_p
else if(N==14)then
x(1)=-17.8035668581853_p
w(1)=5.028932422393954e-1_p
x(2)=-16.97564574546676_p
w(2)=1.146564321832749_p
x(3)=-15.52918193746291_p
w(3)=1.734309381474278_p
x(4)=-13.53612791736675_p
w(4)=2.234831649432822_p
x(5)=-11.09807115977562_p
w(5)=2.619673446945975_p
x(6)=-8.344596603955132_p
w(6)=2.859983164784236_p
x(7)=-5.437140615440571_p
w(7)=2.906431906444293_p
x(8)=-2.590392742909367_p
w(8)=2.538906581930381_p
x(9)=-7.391745885418110e-4_p
w(9)=1.257498719054311_p
x(10)=2.671078147081393_p
w(10)=1.889002788314171e-1_p
x(11)=5.868299060502450_p
w(11)=9.716341614686371e-3_p
x(12)=9.483687683295678_p
w(12)=2.840477632026203e-4_p
x(13)=13.17537680825545_p
w(13)=6.682782148377203e-6_p
x(14)=16.13191967192151_p
w(14)=2.087007074412340e-7_p
else if(N==15)then
x(1)=-17.825893849844_p
w(1)=4.458689932301865e-1_p
x(2)=-17.0908938674922_p
w(2)=1.019228763317405_p
x(3)=-15.80196747682876_p
w(3)=1.549253246597473_p
x(4)=-14.01505103291931_p
w(4)=2.011346647810837_p
x(5)=-11.80937545267913_p
w(5)=2.383146324214671_p
x(6)=-9.285998737915831_p
w(6)=2.642817137294983_p
x(7)=-6.568930384416120_p
w(7)=2.761420444870993_p
x(8)=-3.816283457543275_p
w(8)=2.645550985194649_p
x(9)=-1.230833028598453_p
w(9)=1.900251442380776_p
x(10)=1.200789593135581_p
w(10)=5.816553151457251e-1_p
x(11)=3.944356543876568_p
w(11)=5.667690882098687e-2_p
x(12)=7.123765616390222_p
w(12)=2.689916808187848e-3_p
x(13)=10.5438976352793_p
w(13)=9.076058101369320e-5_p
x(14)=13.84833591789701_p
w(14)=2.948497479822182e-6_p
x(15)=16.31523008864666_p
w(15)=1.390652348056485e-7_p
else if(N==16)then
x(1)=-17.84462481643984_p
w(1)=3.980005377325568e-1_p
x(2)=-17.18782887621618_p
w(2)=9.117742154370582e-1_p
x(3)=-16.03250648479225_p
w(3)=1.391479940317501_p
x(4)=-14.42277137384955_p
w(4)=1.817523855009441_p
x(5)=-12.42129345208187_p
w(5)=2.172082759825226_p
x(6)=-10.10807692350745_p
w(6)=2.438064685294144_p
x(7)=-7.580539936083776_p
w(7)=2.595908715442774_p
x(8)=-4.958552169971221_p
w(8)=2.602181106237075_p
x(9)=-2.401051756148047_p
w(9)=2.258715015955701_p
x(10)=-4.152684487020965e-2_p
w(10)=1.175274220358781_p
x(11)=2.369727415060675_p
w(11)=2.211435164612977e-1_p
x(12)=5.158108994050737_p
w(12)=1.698560440752883e-2_p
x(13)=8.251142289118743_p
w(13)=8.304398262089051e-4_p
x(14)=11.4402031326093_p
w(14)=3.376054886150035e-5_p
x(15)=14.37542697165596_p
w(15)=1.501668989429604e-6_p
x(16)=16.44727762420337_p
w(16)=9.930745907373808e-8_p
else if(N==17)then
x(1)=-17.86049129175462_p
w(1)=3.574324873176918e-1_p
x(2)=-17.27011410242106_p
w(2)=8.203126327516759e-1_p
x(3)=-16.22897407612648_p
w(3)=1.256062859039425_p
x(4)=-14.77231067703262_p
w(4)=1.648880991821926_p
x(5)=-12.95032247203561_p
w(5)=1.984387618440207_p
x(6)=-10.827175109409_p
w(6)=2.248907687885379_p
x(7)=-8.480709976401441_p
w(7)=2.428007665277024_p
x(8)=-6.004591366881733_p
w(8)=2.498038040083469_p
x(9)=-3.518392562423410_p
w(9)=2.370959666300923_p
x(10)=-1.170260065922279_p
w(10)=1.716663530223689_p
x(11)=1.059499839856764_p
w(11)=5.884510924999344e-1_p
x(12)=3.511442958796679_p
w(12)=7.621424166664950e-2_p
x(13)=6.287224358782962_p
w(13)=5.378119921530673e-3_p
x(14)=9.249029976325499_p
w(14)=2.880183953919732e-4_p
x(15)=12.19260511413914_p
w(15)=1.439098448256662e-5_p
x(16)=14.79065796783072_p
w(16)=8.566273531377919e-7_p
x(17)=16.54512007692616_p
w(17)=7.459385091335585e-8_p
else
call GD(-18)
end if
end subroutine GF_m18

! [-17kT;17kT]
subroutine GF_m17(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-13.20653167545944_p
w(1)=8.961194591999419_p
x(2)=-3.048807123747635_p
w(2)=8.038805408000581_p
else if(N==3)then
x(1)=-14.87508255666571_p
w(1)=5.233397176835314_p
x(2)=-7.616437780178649_p
w(2)=8.245043763213355_p
x(3)=-6.275599844543825e-1_p
w(3)=3.521559059951331_p
else if(N==4)then
x(1)=-15.61959534683288_p
w(1)=3.456025040950349_p
x(2)=-10.45783943014302_p
w(2)=6.430688366170666_p
x(3)=-3.873218390200487_p
w(3)=5.957282600740420_p
x(4)=1.255712020044146_p
w(4)=1.156003992138565_p
else if(N==5)then
x(1)=-16.01556892313208_p
w(1)=2.484822031287826_p
x(2)=-12.16859805804282_p
w(2)=4.991975712152490_p
x(3)=-6.603842926305109_p
w(3)=5.782496357217617_p
x(4)=-1.366576901218642_p
w(4)=3.532359415625310_p
x(5)=3.360054240789021_p
w(5)=2.083464837167574e-1_p
else if(N==6)then
x(1)=-16.25314105181588_p
w(1)=1.893946854685451_p
x(2)=-13.26082712325683_p
w(2)=3.969657932275655_p
x(3)=-8.640136358714049_p
w(3)=5.070367571676770_p
x(4)=-3.597052588581064_p
w(4)=4.605838007969258_p
x(5)=5.713134758782737e-1_p
w(5)=1.439229625297240_p
x(6)=5.836018075724711_p
w(6)=2.096000809562735e-2_p
else if(N==7)then
x(1)=-16.40926085126611_p
w(1)=1.502422272828106_p
x(2)=-14.00525380604821_p
w(2)=3.232491699252268_p
x(3)=-10.14472089962127_p
w(3)=4.363793174281724_p
x(4)=-5.573547939092929_p
w(4)=4.585209169169881_p
x(5)=-1.333203851923756_p
w(5)=2.975806419257578_p
x(6)=2.508021608182954_p
w(6)=3.386471805088662e-1_p
x(7)=8.470296287235946_p
w(7)=1.630084701577669e-3_p
else if(N==8)then
x(1)=-16.51951112982818_p
w(1)=1.224424868809805_p
x(2)=-14.54359399539749_p
w(2)=2.680678754335170_p
x(3)=-11.28794873797539_p
w(3)=3.749146337778464_p
x(4)=-7.238858189752730_p
w(4)=4.232828569602136_p
x(5)=-3.088442980421672_p
w(5)=3.735534482181927_p
x(6)=4.694539711256687e-1_p
w(6)=1.326802069264222_p
x(7)=4.601665848678605_p
w(7)=5.044355227392162e-2_p
x(8)=10.90834178764471_p
w(8)=1.413657543555166e-4_p
else if(N==9)then
x(1)=-16.60139382838178_p
w(1)=1.017176810256393_p
x(2)=-14.95003170424274_p
w(2)=2.254395775600103_p
x(3)=-12.18004447548061_p
w(3)=3.230346401274487_p
x(4)=-8.621027319253429_p
w(4)=3.810462384315082_p
x(5)=-4.737421575349613_p
w(5)=3.814749994384468_p
x(6)=-1.154186338502417_p
w(6)=2.485884432869944_p
x(7)=2.174668336197556_p
w(7)=3.802724005416679e-1_p
x(8)=6.676305601370296_p
w(8)=6.693398031938262e-3_p
x(9)=12.83118507154028_p
w(9)=1.840272591508303e-5_p
else if(N==10)then
x(1)=-16.66413287273213_p
w(1)=8.579525952666155e-1_p
x(2)=-15.26511769434347_p
w(2)=1.918602515466777_p
x(3)=-12.88777568668348_p
w(3)=2.797456000347023_p
x(4)=-9.762619341382708_p
w(4)=3.399000227031205_p
x(5)=-6.213083755189354_p
w(5)=3.620639702751594_p
x(6)=-2.680936048030332_p
w(6)=3.125216096862753_p
x(7)=4.334699040861114e-1_p
w(7)=1.200706843874395_p
x(8)=3.909911707628686_p
w(8)=7.941849484150000e-2_p
x(9)=8.558742759600360_p
w(9)=1.003577593335289e-3_p
x(10)=14.16135568388113_p
w(10)=3.945964800754720e-6_p
else if(N==11)then
x(1)=-16.71324282844557_p
w(1)=7.330691095743337e-1_p
x(2)=-15.51389023847539_p
w(2)=1.650406083655046_p
x(3)=-13.45596668403289_p
w(3)=2.437692403037870_p
x(4)=-10.70509843823367_p
w(4)=3.025276680224627_p
x(5)=-7.493755402949731_p
w(5)=3.345037321075617_p
x(6)=-4.130499162938724_p
w(6)=3.255391015185783_p
x(7)=-1.019022015294249_p
w(7)=2.129795370704739_p
x(8)=1.923612296077009_p
w(8)=4.078669130874115e-1_p
x(9)=5.602636953704852_p
w(9)=1.527532610924005e-2_p
x(10)=10.1668112207624_p
w(10)=1.884887345858581e-4_p
x(11)=15.02262271518191_p
w(11)=1.288610746746692e-6_p
else if(N==12)then
x(1)=-16.75236650893104_p
w(1)=6.334301411781146e-1_p
x(2)=-15.71337002578335_p
w(2)=1.433495915960548_p
x(3)=-13.91728751767663_p
w(3)=2.138257978108434_p
x(4)=-11.4859657498481_p
w(4)=2.695778281977993_p
x(5)=-8.590808691394059_p
w(5)=3.057177228718607_p
x(6)=-5.454806085491906_p
w(6)=3.151369776549689_p
x(7)=-2.379163754410102_p
w(7)=2.677210531555339_p
x(8)=3.946506524741188e-1_p
w(8)=1.101854266669471_p
x(9)=3.410263595996804_p
w(9)=1.082263073875095e-1_p
x(10)=7.168059100707922_p
w(10)=3.153340563871330e-3_p
x(11)=11.48374402941904_p
w(11)=4.566383010773479e-5_p
x(12)=15.57484930842781_p
w(12)=5.675003168829340e-7_p
else if(N==13)then
x(1)=-16.78402050040613_p
w(1)=5.527206672552391e-1_p
x(2)=-15.8755782649555_p
w(2)=1.255951207720391_p
x(3)=-14.29601077532318_p
w(3)=1.887854939340536_p
x(4)=-12.1368332597141_p
w(4)=2.408944670609252_p
x(5)=-9.527147371616264_p
w(5)=2.782651133302450_p
x(6)=-6.633232649661747_p
w(6)=2.965728114445879_p
x(7)=-3.671940650504340_p
w(7)=2.830799083636185_p
x(8)=-9.164277486543799e-1_p
w(8)=1.861703100030483_p
x(9)=1.722908493889640_p
w(9)=4.262889216987194e-1_p
x(10)=4.858151213870222_p
w(10)=2.659584483122482e-2_p
x(11)=8.561427866235434_p
w(11)=7.479046095593399e-4_p
x(12)=12.53241107462691_p
w(12)=1.410705735899354e-5_p
x(13)=15.93646390461531_p
w(13)=3.054627228372926e-7_p
else if(N==14)then
x(1)=-16.80998413057286_p
w(1)=4.864591400798338e-1_p
x(2)=-16.00915571676996_p
w(2)=1.108990968709999_p
x(3)=-14.61022519114205_p
w(3)=1.677145460330537_p
x(4)=-12.68319201308207_p
w(4)=2.160382427947279_p
x(5)=-10.32709413217418_p
w(5)=2.530611351472911_p
x(6)=-7.668936548159426_p
w(6)=2.757982909324869_p
x(7)=-4.869224487375677_p
w(7)=2.783024257908110_p
x(8)=-2.143149717731194_p
w(8)=2.334562333043291_p
x(9)=3.600213855092099e-1_p
w(9)=1.019229231800353_p
x(10)=3.032434929853342_p
w(10)=1.345990435985365e-1_p
x(11)=6.214983619294389_p
w(11)=6.798607938946918e-3_p
x(12)=9.769313590661083_p
w(12)=2.086954673559066e-4_p
x(13)=13.35465662392805_p
w(13)=5.384274561414316e-6_p
x(14)=16.18108865264315_p
w(14)=1.881034160956348e-7_p
else if(N==15)then
x(1)=-16.83154015544616_p
w(1)=4.314055183829368e-1_p
x(2)=-16.12041048728281_p
w(2)=9.860876513914536e-1_p
x(3)=-14.87349280696571_p
w(3)=1.498633362003333_p
x(4)=-13.14520072881213_p
w(4)=1.945058003718323_p
x(5)=-11.01273768695242_p
w(5)=2.303366467856625_p
x(6)=-8.574962529040587_p
w(6)=2.551419249277749_p
x(7)=-5.954432143319693_p
w(7)=2.656270319654980_p
x(8)=-3.310451553020455_p
w(8)=2.497611066844018_p
x(9)=-8.337582207488922e-1_p
w(9)=1.651799439808755_p
x(10)=1.560976465656355_p
w(10)=4.368507342021006e-1_p
x(11)=4.306014316345240_p
w(11)=3.951812700051767e-2_p
x(12)=7.450486448460736_p
w(12)=1.908933452907132e-3_p
x(13)=10.79778811092879_p
w(13)=6.855400258301702e-5_p
x(14)=13.99604482700774_p
w(14)=2.445349333352820e-6_p
x(15)=16.35230580691937_p
w(15)=1.270543859787875e-7_p
else if(N==16)then
x(1)=-16.84963060484566_p
w(1)=3.851750539715240e-1_p
x(2)=-16.2140209446129_p
w(2)=8.823326698204884e-1_p
x(3)=-15.09607852619705_p
w(3)=1.346364049291397_p
x(4)=-13.53871345161649_p
w(4)=1.758172242755678_p
x(5)=-11.60296907010848_p
w(5)=2.100269650249093_p
x(6)=-9.367007317030241_p
w(6)=2.355535085858182_p
x(7)=-6.926699897603412_p
w(7)=2.502764057085938_p
x(8)=-4.402062900158792_p
w(8)=2.486776837013889_p
x(9)=-1.951957460164343_p
w(9)=2.064268071193763_p
x(10)=3.304139863741906e-1_p
w(10)=9.482426013530697e-1_p
x(11)=2.735725989868949_p
w(11)=1.576346282055217e-1_p
x(12)=5.509960914954999_p
w(12)=1.183634586402858e-2_p
x(13)=8.553753740611169_p
w(13)=6.011358406249569e-4_p
x(14)=11.66365037952538_p
w(14)=2.620408463417585e-5_p
x(15)=14.49744137231041_p
w(15)=1.275774862047944e-6_p
x(16)=16.4759946003464_p
w(16)=9.163730650555165e-8_p
else if(N==17)then
x(1)=-16.86495928823781_p
w(1)=3.459828504282678e-1_p
x(2)=-16.29351001861567_p
w(2)=7.939893458668023e-1_p
x(3)=-15.28583637580726_p
w(3)=1.215615347427912_p
x(4)=-13.87621456450881_p
w(4)=1.595465777937512_p
x(5)=-12.11352626646839_p
w(5)=1.919456486031010_p
x(6)=-10.0604017398525_p
w(6)=2.173993394059933_p
x(7)=-7.793227043146913_p
w(7)=2.343953593397396_p
x(8)=-5.405116911047879_p
w(8)=2.400674567900993_p
x(9)=-3.017069093867494_p
w(9)=2.229192967488564_p
x(10)=-7.651982136955030e-1_p
w(10)=1.483023896602111_p
x(11)=1.427704459810877_p
w(11)=4.415563410386480e-1_p
x(12)=3.876888628054473_p
w(12)=5.308265177203939e-2_p
x(13)=6.622648777588368_p
w(13)=3.787327244247206e-3_p
x(14)=9.526000209623520_p
w(14)=2.131842979314667e-4_p
x(15)=12.3882106231683_p
w(15)=1.145689818088906e-5_p
x(16)=14.8920673734818_p
w(16)=7.422592832584170e-7_p
x(17)=16.56789006899662_p
w(17)=6.934916976857856e-8_p
else
call GD(-17)
end if
end subroutine GF_m17

! [-16kT;17kT]
subroutine GF_m16(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-12.4075353022923_p
w(1)=8.484773693323840_p
x(2)=-2.804964002388345_p
w(2)=7.515226377811952_p
else if(N==3)then
x(1)=-13.97872486549097_p
w(1)=4.977639530891198_p
x(2)=-7.080150656746724_p
w(2)=7.821256379336135_p
x(3)=-4.368310271980400e-1_p
w(3)=3.201104160908459_p
else if(N==4)then
x(1)=-14.68166287861543_p
w(1)=3.300369183576380_p
x(2)=-9.754690792482265_p
w(2)=6.133754939086341_p
x(3)=-3.491978545031110_p
w(3)=5.588240692584975_p
x(4)=1.479834691632156_p
w(4)=9.776352558880966e-1_p
else if(N==5)then
x(1)=-15.05661114626854_p
w(1)=2.381063617670458_p
x(2)=-11.37160250516473_p
w(2)=4.779567123135581_p
x(3)=-6.051757814573739_p
w(3)=5.507739145196116_p
x(4)=-1.071719381088566_p
w(4)=3.173364100586053_p
x(5)=3.661410525724334_p
w(5)=1.582660845475844e-1_p
else if(N==6)then
x(1)=-15.28233551325269_p
w(1)=1.819805703011753_p
x(2)=-12.40799996099246_p
w(2)=3.811804353718911_p
x(3)=-7.975258219190181_p
w(3)=4.856449112353586_p
x(4)=-3.163583160821692_p
w(4)=4.308459987413249_p
x(5)=8.607842504958064e-1_p
w(5)=1.188815987210712_p
x(6)=6.203514454813225_p
w(6)=1.466492742758150e-2_p
else if(N==7)then
x(1)=-15.43130927790021_p
w(1)=1.446275407375620_p
x(2)=-13.11768742507434_p
w(2)=3.110113615395100_p
x(3)=-9.405749440732439_p
w(3)=4.191964842477787_p
x(4)=-5.024611178231070_p
w(4)=4.366092846562186_p
x(5)=-9.865066599393245e-1_p
w(5)=2.633370015726548_p
x(6)=2.847299870690791_p
w(6)=2.510792858789611e-1_p
x(7)=8.859789630705293_p
w(7)=1.104057719589329e-3_p
else if(N==8)then
x(1)=-15.53695579445821_p
w(1)=1.179923833083171_p
x(2)=-13.63320652898914_p
w(2)=2.582232794148059_p
x(3)=-10.49860384041925_p
w(3)=3.607571013731988_p
x(4)=-6.607673667301819_p
w(4)=4.056684214378464_p
x(5)=-2.645341715828780_p
w(5)=3.465458502134189_p
x(6)=7.949694657281411e-1_p
w(6)=1.072984883533390_p
x(7)=4.976246410688918_p
w(7)=3.504686075523122e-2_p
x(8)=11.25961440247491_p
w(8)=9.796937130023962e-5_p
else if(N==9)then
x(1)=-15.61561748254036_p
w(1)=9.808492613477631e-1_p
x(2)=-14.02346471189122_p
w(2)=2.173216689271379_p
x(3)=-11.35415163884326_p
w(3)=3.111625606238150_p
x(4)=-7.928886795365265_p
w(4)=3.662253938108696_p
x(5)=-4.206154883414266_p
w(5)=3.619545880073918_p
x(6)=-7.886316938503826e-1_p
w(6)=2.168102340215923_p
x(7)=2.525515033342633_p
w(7)=2.797986047154667e-1_p
x(8)=7.048741383233274_p
w(8)=4.594194601775294e-3_p
x(9)=13.10294249656083_p
w(9)=1.355656272170646e-5_p
else if(N==10)then
x(1)=-15.67595570672538_p
w(1)=8.277307760303807e-1_p
x(2)=-14.32637771422558_p
w(2)=1.850573054849380_p
x(3)=-12.03393498794082_p
w(3)=2.696721461315418_p
x(4)=-9.023088570833018_p
w(4)=3.271978764239492_p
x(5)=-5.611627022579458_p
w(5)=3.465678844099472_p
x(6)=-2.239296705949334_p
w(6)=2.872561609517968_p
x(7)=7.772301298132602e-1_p
w(7)=9.586339112193498e-1_p
x(8)=4.279953361795479_p
w(8)=5.541725411305968e-2_p
x(9)=8.903168074552914_p
w(9)=7.012896854398585e-4_p
x(10)=14.35276697434695_p
w(10)=3.106065832740490e-6_p
else if(N==11)then
x(1)=-15.72321647493181_p
w(1)=7.075577095716731e-1_p
x(2)=-14.56571015279917_p
w(2)=1.592663550243436_p
x(3)=-12.5801934608858_p
w(3)=2.351373933979527_p
x(4)=-9.927862306903187_p
w(4)=2.915305743452616_p
x(5)=-6.836377296710880_p
w(5)=3.213926452576204_p
x(6)=-3.613084784765772_p
w(6)=3.074348222457441_p
x(7)=-6.405368297351235e-1_p
w(7)=1.835126922708054_p
x(8)=2.282141297851026_p
w(8)=2.990264804105405e-1_p
x(9)=5.969509924888081_p
w(9)=1.053386012674949e-2_p
x(10)=10.46977790995936_p
w(10)=1.361258356847009e-4_p
x(11)=15.15359960268809_p
w(11)=1.069773866970207e-6_p
else if(N==12)then
x(1)=-15.76088759117497_p
w(1)=6.116233316257468e-1_p
x(2)=-14.7577365113572_p
w(2)=1.383928566261922_p
x(3)=-13.0240410126276_p
w(3)=2.063609435405669_p
x(4)=-10.67834965930405_p
w(4)=2.599811128691732_p
x(5)=-7.888171204580576_p
w(5)=2.943084838620255_p
x(6)=-4.874297278341343_p
w(6)=3.010526195667126_p
x(7)=-1.936815788338632_p
w(7)=2.438375503477141_p
x(8)=7.532565704559651e-1_p
w(8)=8.712300272951923e-1_p
x(9)=3.781342897784601_p
w(9)=7.557772047771993e-2_p
x(10)=7.515422857134531_p
w(10)=2.198560394833337e-3_p
x(11)=11.74114721687226_p
w(11)=3.427384313989711e-5_p
x(12)=15.6654570702387_p
w(12)=4.893753144264044e-7_p
else if(N==13)then
x(1)=-15.79138186993739_p
w(1)=5.338743322630122e-1_p
x(2)=-14.91397040922258_p
w(2)=1.212969661453374_p
x(3)=-13.38866030225177_p
w(3)=1.822743157141473_p
x(4)=-11.30446958655453_p
w(4)=2.324599139087266_p
x(5)=-8.787395820254913_p
w(5)=2.682019497533928_p
x(6)=-6.001232627135203_p
w(6)=2.847344260891008_p
x(7)=-3.163595602000894_p
w(7)=2.659011438514931_p
x(8)=-5.266580545939479e-1_p
w(8)=1.587048750078998_p
x(9)=2.089545698807238_p
w(9)=3.115159522328436e-1_p
x(10)=5.226150966804202_p
w(10)=1.832932328101284e-2_p
x(11)=8.880110014568652_p
w(11)=5.332902482515670e-4_p
x(12)=12.74648467789171_p
w(12)=1.099797248725450e-5_p
x(13)=16.00089893627984_p
w(13)=2.704372073395942e-7_p
else if(N==14)then
x(1)=-15.81640586230228_p
w(1)=4.700132488525657e-1_p
x(2)=-15.04269210813083_p
w(2)=1.071383288506718_p
x(3)=-13.69134789874065_p
w(3)=1.619904127112985_p
x(4)=-11.83045148978122_p
w(4)=2.085761543280992_p
x(5)=-9.556570916417387_p
w(5)=2.441118544093010_p
x(6)=-6.994367919271565_p
w(6)=2.654444243186450_p
x(7)=-4.304036790052908_p
w(7)=2.651610812279077_p
x(8)=-1.698967265296924_p
w(8)=2.107301972045687_p
x(9)=7.311053171133076e-1_p
w(9)=7.996455016873245e-1_p
x(10)=3.406925852811268_p
w(10)=9.394129617157129e-2_p
x(11)=6.567649029338762_p
w(11)=4.718001615099024e-3_p
x(12)=10.05537868299111_p
w(12)=1.529796972689473e-4_p
x(13)=13.53091185528996_p
w(13)=4.342983133930513e-6_p
x(14)=16.22837708757522_p
w(14)=1.696239093903387e-7_p
else if(N==15)then
x(1)=-15.83719040381466_p
w(1)=4.169316620074913e-1_p
x(2)=-15.14995007915362_p
w(2)=9.529172145439309e-1_p
x(3)=-13.94508537274106_p
w(3)=1.447950181821843_p
x(4)=-12.2755098888534_p
w(4)=1.878636906128604_p
x(5)=-10.21645252116821_p
w(5)=2.223285991221832_p
x(6)=-7.864716101738662_p
w(6)=2.459134020200774_p
x(7)=-5.341821653387801_p
w(7)=2.547167468855180_p
x(8)=-2.808388093952100_p
w(8)=2.332250204188278_p
x(9)=-4.344071116110791e-1_p
w(9)=1.394767423056548_p
x(10)=1.935317227625483_p
w(10)=3.183746029812776e-1_p
x(11)=4.677177958362761_p
w(11)=2.718309034811053e-2_p
x(12)=7.780684804710534_p
w(12)=1.347429311822382e-3_p
x(13)=11.05087314796031_p
w(13)=5.173005077800584e-5_p
x(14)=14.14091578911808_p
w(14)=2.030332408783824e-6_p
x(15)=16.38806638583897_p
w(15)=1.160869134748263e-7_p
else if(N==16)then
x(1)=-15.85463989141969_p
w(1)=3.723403888521026e-1_p
x(2)=-15.2402331226097_p
w(2)=8.528658235281621e-1_p
x(3)=-14.15970813134268_p
w(3)=1.301195523075103_p
x(4)=-12.6547880283906_p
w(4)=1.698715654525005_p
x(5)=-10.78492617026408_p
w(5)=2.028235890636962_p
x(6)=-8.626532823094761_p
w(6)=2.272444257198970_p
x(7)=-6.274189826555760_p
w(7)=2.407553706956500_p
x(8)=-3.848558750562204_p
w(8)=2.361672244631706_p
x(9)=-1.505539213030480_p
w(9)=1.847194040043556_p
x(10)=7.119946448079252e-1_p
w(10)=7.392236714411371e-1_p
x(11)=3.114427639505805_p
w(11)=1.099295429546247e-1_p
x(12)=5.868249657770165_p
w(12)=8.174165693644722e-3_p
x(13)=8.858048318782052_p
w(13)=4.336571692525589e-4_p
x(14)=11.88559443445352_p
w(14)=2.033502845462457e-5_p
x(15)=14.61696444018724_p
w(15)=1.084862364774902e-6_p
x(16)=16.50376928621464_p
w(16)=8.453824661435725e-8_p
else if(N==17)then
x(1)=-15.86943039743754_p
w(1)=3.345250649272045e-1_p
x(2)=-15.31692363463711_p
w(2)=7.676440558803455e-1_p
x(3)=-14.34274842183527_p
w(3)=1.175123459060235_p
x(4)=-12.98023013916198_p
w(4)=1.541965559823165_p
x(5)=-11.27695964079811_p
w(5)=1.854357166455047_p
x(6)=-9.294091670829719_p
w(6)=2.098697251366204_p
x(7)=-7.106715627409838_p
w(7)=2.258725759459389_p
x(8)=-4.807795433563710_p
w(8)=2.298270255967106_p
x(9)=-2.519467196774940_p
w(9)=2.068673853527577_p
x(10)=-3.576985308169430e-1_p
w(10)=1.241650752707430_p
x(11)=1.809143084310024_p
w(11)=3.211110286776606e-1_p
x(12)=4.251898677342512_p
w(12)=3.643781259151888e-2_p
x(13)=6.962223730345087_p
w(13)=2.650755663450277e-3_p
x(14)=9.803407913803172_p
w(14)=1.574639570951065e-4_p
x(15)=12.58199147818643_p
w(15)=9.123039369232784e-6_p
x(16)=14.99136183775331_p
w(16)=6.435893777323087e-7_p
x(17)=16.58996828586779_p
w(17)=6.444361698416119e-8_p
else
call GD(-16)
end if
end subroutine GF_m16

! [-15kT;17kT]
subroutine GF_m15(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-11.60757076763049_p
w(1)=8.010478407745657_p
x(2)=-2.557095741107714_p
w(2)=6.989521856757240_p
else if(N==3)then
x(1)=-13.08171502848473_p
w(1)=4.723428240486947_p
x(2)=-6.541776144323830_p
w(2)=7.396048857092818_p
x(3)=-2.364964133838371e-1_p
w(3)=2.880523166923133_p
else if(N==4)then
x(1)=-13.74332346843382_p
w(1)=3.145701100118933_p
x(2)=-9.049955572871664_p
w(2)=5.837536763872663_p
x(3)=-3.109378051215745_p
w(3)=5.206383940022727_p
x(4)=1.721887447114317_p
w(4)=8.103784604885742e-1_p
else if(N==5)then
x(1)=-14.09741202261427_p
w(1)=2.277896481269577_p
x(2)=-10.57360170952793_p
w(2)=4.567845365936054_p
x(3)=-5.498987182581311_p
w(3)=5.227593492573630_p
x(4)=-7.706580119459855e-1_p
w(4)=2.809352279983728_p
x(5)=3.984827842358096_p
w(5)=1.173126447399082e-1_p
else if(N==6)then
x(1)=-14.31141103945385_p
w(1)=1.745955512731533_p
x(2)=-11.55467907954754_p
w(2)=3.654294167097131_p
x(3)=-7.310015540256932_p
w(3)=4.640775765700641_p
x(4)=-2.731628772301074_p
w(4)=3.991638188948762_p
x(5)=1.167660046898310_p
w(5)=9.572841669484746e-1_p
x(6)=6.590027288297661_p
w(6)=1.005246307635622e-2_p
else if(N==7)then
x(1)=-14.45332581649672_p
w(1)=1.390203337186720_p
x(2)=-12.23001791690587_p
w(2)=2.987747742156581_p
x(3)=-8.666924816845819_p
w(3)=4.019228889607684_p
x(4)=-4.477860971443716_p
w(4)=4.136566527128772_p
x(5)=-6.358607047349062e-1_p
w(5)=2.284316843214654_p
x(6)=3.207493548418573_p
w(6)=1.811985637580027e-1_p
x(7)=9.259878873685306_p
w(7)=7.383614504846196e-4_p
else if(N==8)then
x(1)=-14.55440773721142_p
w(1)=1.135400438433080_p
x(2)=-12.72289079800328_p
w(2)=2.483651666742687_p
x(3)=-9.709636209826950_p
w(3)=3.465357313749116_p
x(4)=-5.978186760894991_p
w(4)=3.876160399818189_p
x(5)=-2.205797765794594_p
w(5)=3.172438529039655_p
x(6)=1.136017200759601_p
w(6)=8.430131094689854e-1_p
x(7)=5.365809623980452_p
w(7)=2.391112724920951e-2_p
x(8)=11.61049372273909_p
w(8)=6.768000197423070e-5_p
else if(N==9)then
x(1)=-14.62985511933479_p
w(1)=9.444835783412536e-1_p
x(2)=-13.09699133119736_p
w(2)=2.091899607060601_p
x(3)=-10.52860419932613_p
w(3)=2.992460551297826_p
x(4)=-7.237915937491403_p
w(4)=3.512010630059382_p
x(5)=-3.678612640000058_p
w(5)=3.409805784665969_p
x(6)=-4.192250087123363e-1_p
w(6)=1.845810602589244_p
x(7)=2.894719732679203_p
w(7)=2.003999537477541e-1_p
x(8)=7.429569668579949_p
w(8)=3.119543239541221e-3_p
x(9)=13.36795227172097_p
w(9)=1.001350132779036e-5_p
else if(N==10)then
x(1)=-14.6877904036222_p
w(1)=7.974769807308211e-1_p
x(2)=-13.38771348442602_p
w(2)=1.782436808267768_p
x(3)=-11.18035384068273_p
w(3)=2.595682702482270_p
x(4)=-8.284345356189188_p
w(4)=3.143872822391388_p
x(5)=-5.012653423941333_p
w(5)=3.304070181407345_p
x(6)=-1.800920600211763_p
w(6)=2.596155404090286_p
x(7)=1.135556190568979_p
w(7)=7.418367658998376e-1_p
x(8)=4.663734980219381_p
w(8)=3.797884945306733e-2_p
x(9)=9.250875966461566_p
w(9)=4.872951850282691e-4_p
x(10)=14.53683219146618_p
w(10)=2.454595086375940e-6_p
else if(N==11)then
x(1)=-14.73319970741767_p
w(1)=6.820206202530869e-1_p
x(2)=-13.61758976596525_p
w(2)=1.534838969273624_p
x(3)=-11.70461613073716_p
w(3)=2.264838967362016_p
x(4)=-9.151179379777346_p
w(4)=2.804683824221098_p
x(5)=-6.180602036350325_p
w(5)=3.079729518605136_p
x(6)=-3.099697239290138_p
w(6)=2.875561231038788_p
x(7)=-2.575909461529287e-1_p
w(7)=1.537799658416040_p
x(8)=2.657723800526275_p
w(8)=2.132461069825035e-1_p
x(9)=6.345076307574232_p
w(9)=7.182379345004646e-3_p
x(10)=10.77250050331308_p
w(10)=9.809813108901496e-5_p
x(11)=15.27889244461925_p
w(11)=8.908745115874633e-7_p
else if(N==12)then
x(1)=-14.76941672016273_p
w(1)=5.897950797237725e-1_p
x(2)=-13.80215192453298_p
w(2)=1.334295604219852_p
x(3)=-12.13094877009227_p
w(3)=1.988799060008291_p
x(4)=-9.871143582858901_p
w(4)=2.503415375383578_p
x(5)=-7.186620180939798_p
w(5)=2.827397290018701_p
x(6)=-4.296750234504011_p
w(6)=2.860622012408765_p
x(7)=-1.497090754980710_p
w(7)=2.176010509462369_p
x(8)=1.125615743725944_p
w(8)=6.663156028129749e-1_p
x(9)=4.165674688917043_p
w(9)=5.180134547009902e-2_p
x(10)=7.867570846645960_p
w(10)=1.522238980527035e-3_p
x(11)=11.99629212686938_p
w(11)=2.572317624874040e-5_p
x(12)=15.75211884547394_p
w(12)=4.228377189446006e-7_p
else if(N==13)then
x(1)=-14.79875016678663_p
w(1)=5.150096314326343e-1_p
x(2)=-13.95240378797489_p
w(2)=1.169934039909759_p
x(3)=-12.48143532246347_p
w(3)=1.757505649224700_p
x(4)=-10.47242283229929_p
w(4)=2.239951709253200_p
x(5)=-8.048422077952857_p
w(5)=2.580463722787990_p
x(6)=-5.371248600799102_p
w(6)=2.724556335079213_p
x(7)=-2.659342124365957_p
w(7)=2.467011503244956_p
x(8)=-1.320223402068741e-1_p
w(8)=1.311472910325271_p
x(9)=2.472137844756654_p
w(9)=2.212253042045182e-1_p
x(10)=5.603048506915222_p
w(10)=1.248189539336663e-2_p
x(11)=9.200752601669727_p
w(11)=3.787419071642601e-4_p
x(12)=12.95746862006027_p
w(12)=8.582061921528728e-6_p
x(13)=16.06265888530681_p
w(13)=2.396782029408214e-7_p
else if(N==14)then
x(1)=-14.82283362727094_p
w(1)=4.535514288407894e-1_p
x(2)=-14.07626378753294_p
w(2)=1.033730196201203_p
x(3)=-12.77257488246683_p
w(3)=1.562562344318146_p
x(4)=-10.9779634553777_p
w(4)=2.010917322454298_p
x(5)=-8.786630109439301_p
w(5)=2.351037041386248_p
x(6)=-6.321199783283756_p
w(6)=2.548627869404329_p
x(7)=-3.742176764431808_p
w(7)=2.508717391025301_p
x(8)=-1.256758496558384_p
w(8)=1.857459947474023_p
x(9)=1.115136909314135_p
w(9)=6.057343137696245e-1_p
x(10)=3.794242173360495_p
w(10)=6.429808197764793e-2_p
x(11)=6.925842479396235_p
w(11)=3.248754981741557e-3_p
x(12)=10.34150406836754_p
w(12)=1.119123030994381e-4_p
x(13)=13.70397933119552_p
w(13)=3.507346146515688e-6_p
x(14)=16.27383416334844_p
w(14)=1.530202992217101e-7_p
else if(N==15)then
x(1)=-14.84284593963496_p
w(1)=4.024438925425846e-1_p
x(2)=-14.179520161597_p
w(2)=9.197081461401223e-1_p
x(3)=-13.01676588777865_p
w(3)=1.397185028419252_p
x(4)=-11.40602480249936_p
w(4)=1.812044436778012_p
x(5)=-9.420618948690962_p
w(5)=2.142802197387774_p
x(6)=-7.155482407905192_p
w(6)=2.365559321175184_p
x(7)=-4.731597640416235_p
w(7)=2.432140962015592_p
x(8)=-2.310300925824087_p
w(8)=2.144981115269859_p
x(9)=-2.992060932672489e-2_p
w(9)=1.138417004020451_p
x(10)=2.324629431523615_p
w(10)=2.252682533095361e-1_p
x(11)=5.057347799567365_p
w(11)=1.846279750520707e-2_p
x(12)=8.113960738951945_p
w(12)=9.463113478584422e-4_p
x(13)=11.30285671312148_p
w(13)=3.900485724880272e-5_p
x(14)=14.28286142797512_p
w(14)=1.687672734066775e-6_p
x(15)=16.42254533376384_p
w(15)=1.060614818118168e-7_p
else if(N==16)then
x(1)=-14.85965383291851_p
w(1)=3.594935079628871e-1_p
x(2)=-14.26647183683886_p
w(2)=8.233657852998383e-1_p
x(3)=-13.22341277740267_p
w(3)=1.255958967260848_p
x(4)=-11.77103326466259_p
w(4)=1.639123804141673_p
x(5)=-9.967243108127384_p
w(5)=1.955910298841967_p
x(6)=-7.886819471378928_p
w(6)=2.188556830416903_p
x(7)=-5.623380356686224_p
w(7)=2.309215528113007_p
x(8)=-3.298612715930774_p
w(8)=2.222838129351957_p
x(9)=-1.060461241795548_p
w(9)=1.608962827487752_p
x(10)=1.105771935482985_p
w(10)=5.555366011266198e-1_p
x(11)=3.505545570982692_p
w(11)=7.511179777429319e-2_p
x(12)=6.232523224865201_p
w(12)=5.597555062186804e-3_p
x(13)=9.163684127367420_p
w(13)=3.118506843373930e-4_p
x(14)=12.10581612218166_p
w(14)=1.577966473520993e-5_p
x(15)=14.73395275488286_p
w(15)=9.233512644052146e-7_p
x(16)=16.53062419136996_p
w(16)=7.796262886940635e-8_p
else if(N==17)then
x(1)=-14.87390562108756_p
w(1)=3.230565055434035e-1_p
x(2)=-14.34036048605019_p
w(2)=7.412700112712853e-1_p
x(3)=-13.39972510640217_p
w(3)=1.134574327955947_p
x(4)=-12.08438930863201_p
w(4)=1.488356157561501_p
x(5)=-10.44068602159487_p
w(5)=1.789037769878652_p
x(6)=-8.528372518844213_p
w(6)=2.022871301090987_p
x(7)=-6.421448468951243_p
w(7)=2.171736621068008_p
x(8)=-4.213165323420578_p
w(8)=2.188309521378205_p
x(9)=-2.025594733009659_p
w(9)=1.885262667610985_p
x(10)=5.511210722426975e-2_p
w(10)=1.002384858276130_p
x(11)=2.204667451789283_p
w(11)=2.264933999637352e-1_p
x(12)=4.635958978860589_p
w(12)=2.467854446839926e-2_p
x(13)=7.305564966569861_p
w(13)=1.844605212486236e-3_p
x(14)=10.08097023733503_p
w(14)=1.160881733331857e-4_p
x(15)=12.77379131391858_p
w(15)=7.266813717248817e-6_p
x(16)=15.08852172608354_p
w(16)=5.583834679529963e-7_p
x(17)=16.61136992138207_p
w(17)=5.985265412892400e-8_p
else
call GD(-15)
end if
end subroutine GF_m15

! [-14kT;17kT]
subroutine GF_m14(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-10.80652817480737_p
w(1)=7.538497139879658_p
x(2)=-2.304432252835981_p
w(2)=6.461503650249340_p
else if(N==3)then
x(1)=-12.18400730418715_p
w(1)=4.470854780013084_p
x(2)=-6.001316607939311_p
w(2)=6.968239309320212_p
x(3)=-2.481213411178641e-2_p
w(3)=2.560906700795701_p
else if(N==4)then
x(1)=-12.80456395210484_p
w(1)=2.992044408496672_p
x(2)=-8.343665336751595_p
w(2)=5.541668583323363_p
x(3)=-2.725261669344798_p
w(3)=4.809830941259478_p
x(4)=1.984320488943176_p
w(4)=6.564568570494840e-1_p
else if(N==5)then
x(1)=-13.13797472700609_p
w(1)=2.175307708613790_p
x(2)=-9.774655959600345_p
w(2)=4.356627160471585_p
x(3)=-4.945975292258946_p
w(3)=4.939605944170613_p
x(4)=-4.612793734289672e-1_p
w(4)=2.443735941440662_p
x(5)=4.331759237004412_p
w(5)=8.472403543234736e-2_p
else if(N==6)then
x(1)=-13.34038019454449_p
w(1)=1.672361646630648_p
x(2)=-10.70095065763006_p
w(2)=3.496980996879627_p
x(3)=-6.644791544578895_p
w(3)=4.422245301591459_p
x(4)=-2.301182270884240_p
w(4)=3.652814108198527_p
x(5)=1.494770010897149_p
w(5)=7.488500163115974e-1_p
x(6)=6.995821114309407_p
w(6)=6.748720517139168e-3_p
else if(N==7)then
x(1)=-13.47532412250979_p
w(1)=1.334169674012022_p
x(2)=-11.34232729034182_p
w(2)=2.865277423760482_p
x(3)=-7.928532920905814_p
w(3)=3.845059608574851_p
x(4)=-3.934053676113572_p
w(4)=3.892777983653043_p
x(5)=-2.785832627704399e-1_p
w(5)=1.935010375939942_p
x(6)=3.589329086859038_p
w(6)=1.272177691912316e-1_p
x(7)=9.669435559312991_p
w(7)=4.879549974260883e-4_p
else if(N==8)then
x(1)=-13.57187590679272_p
w(1)=1.090830803294644_p
x(2)=-11.81270021001365_p
w(2)=2.384860991037941_p
x(3)=-8.921223824900331_p
w(3)=3.322233654082191_p
x(4)=-5.350963924974799_p
w(4)=3.689270831705558_p
x(5)=-1.769248658211384_p
w(5)=2.855213669921719_p
x(6)=1.495332945176262_p
w(6)=6.415166616090965e-1_p
x(7)=5.769960291443776_p
w(7)=1.602751545631440e-2_p
x(8)=11.95936965161512_p
w(8)=4.666302153417326e-5_p
else if(N==9)then
x(1)=-13.64411223811785_p
w(1)=9.080649751705235e-1_p
x(2)=-12.17064481296117_p
w(2)=2.010397883176485_p
x(3)=-9.703512434080324_p
w(3)=2.872697801884396_p
x(4)=-6.548466491359272_p
w(4)=3.358816600478238_p
x(5)=-3.155374548018083_p
w(5)=3.180899390684439_p
x(6)=-4.281830190640596e-2_p
w(6)=1.527294387334033_p
x(7)=3.282781227689779_p
w(7)=1.397256988308987e-1_p
x(8)=7.818144855734690_p
w(8)=2.096631149257200e-3_p
x(9)=13.62532836399359_p
w(9)=7.421420727316948e-6_p
else if(N==10)then
x(1)=-13.69964105052504_p
w(1)=7.671802242103852e-1_p
x(2)=-12.44914945913181_p
w(2)=1.714160088181437_p
x(3)=-10.32711045277713_p
w(3)=2.494241394559113_p
x(4)=-7.546621648839483_p
w(4)=3.014225339231048_p
x(5)=-4.416788961113733_p
w(5)=3.132838808213688_p
x(6)=-1.364660143234506_p
w(6)=2.296448943027862_p
x(7)=1.511045953421154_p
w(7)=5.549861790094317e-1_p
x(8)=5.060859258289771_p
w(8)=2.558099226189268e-2_p
x(9)=9.601172522733657_p
w(9)=3.368736920539659e-4_p
x(10)=14.71333483358142_p
w(10)=1.947742085887721e-6_p
else if(N==11)then
x(1)=-13.74319588891914_p
w(1)=6.564488387668951e-1_p
x(2)=-12.66954881321972_p
w(2)=1.476905877548364_p
x(3)=-10.82929506250104_p
w(3)=2.178018411103995_p
x(4)=-8.375214305890674_p
w(4)=2.693155750411703_p
x(5)=-5.526889082471272_p
w(5)=2.940937214892254_p
x(6)=-2.590697954882590_p
w(6)=2.654186363283561_p
x(7)=1.331267642619188e-1_p
w(7)=1.247441448541065_p
x(8)=3.050773075483444_p
w(8)=1.479908561720620e-1_p
x(9)=6.728805006461822_p
w(9)=4.844711406685539e-3_p
x(10)=11.07437729511963_p
w(10)=7.057383964426359e-5_p
x(11)=15.39853893521153_p
w(11)=7.441627679381930e-7_p
else if(N==12)then
x(1)=-13.77795671509798_p
w(1)=5.679378639198265e-1_p
x(2)=-12.84663254509617_p
w(2)=1.284575675391219_p
x(3)=-11.23805886046731_p
w(3)=1.913775661924819_p
x(4)=-9.064470066819014_p
w(4)=2.406433732726152_p
x(5)=-6.486477462645431_p
w(5)=2.709345066600262_p
x(6)=-3.722825854516691_p
w(6)=2.697741318402056_p
x(7)=-1.058395485021587_p
w(7)=1.892372016529410_p
x(8)=1.514170577520804_p
w(8)=4.918704287553883e-1_p
x(9)=4.562816086409310_p
w(9)=3.488222832620482e-2_p
x(10)=8.223974145768638_p
w(10)=1.047120966070126e-3_p
x(11)=12.24874462568402_p
w(11)=1.931056500249870e-5_p
x(12)=15.83491778805835_p
w(12)=3.660225862890896e-7_p
else if(N==13)then
x(1)=-13.80612776461797_p
w(1)=4.961202470490093e-1_p
x(2)=-12.99089194066604_p
w(2)=1.126826876859099_p
x(3)=-11.57437476445126_p
w(3)=1.692103137868202_p
x(4)=-9.640787292034481_p
w(4)=2.154897547337873_p
x(5)=-7.310456556842775_p
w(5)=2.477563406240858_p
x(6)=-4.743833082436847_p
w(6)=2.595142069891800_p
x(7)=-2.159256430613915_p
w(7)=2.250300127953108_p
x(8)=2.708407849828074e-1_p
w(8)=1.045562208396402_p
x(9)=2.871053696329326_p
w(9)=1.528058439307997e-1_p
x(10)=5.988317648040072_p
w(10)=8.404400808731005e-3_p
x(11)=9.522881567398194_p
w(11)=2.680069235435690e-4_p
x(12)=13.16509095682114_p
w(12)=6.704256377786929e-6_p
x(13)=16.12181370591021_p
w(13)=2.126131931270559e-7_p
else if(N==14)then
x(1)=-13.82926943591365_p
w(1)=4.370683383182905e-1_p
x(2)=-13.10988211175773_p
w(2)=9.960172305064198e-1_p
x(3)=-11.85393812614154_p
w(3)=1.505089153064035_p
x(4)=-10.12580240344992_p
w(4)=1.935775570086226_p
x(5)=-8.017442478233638_p
w(5)=2.260117921216620_p
x(6)=-5.649839245737752_p
w(6)=2.439343530365493_p
x(7)=-3.184261095661558_p
w(7)=2.349702039145887_p
x(8)=-8.145658412572913e-1_p
w(8)=1.589064523734504_p
x(9)=1.514421828208604_p
w(9)=4.423030956474212e-1_p
x(10)=4.193917139237124_p
w(10)=4.321395347584374e-2_p
x(11)=7.289085092102172_p
w(11)=2.220732421080185e-3_p
x(12)=10.62730036237782_p
w(12)=8.172790771635903e-5_p
x(13)=13.873705512234_p
w(13)=2.836158785102776e-6_p
x(14)=16.31750933388316_p
w(14)=1.380806750810964e-7_p
else if(N==15)then
x(1)=-13.84850847797549_p
w(1)=3.879376588497011e-1_p
x(2)=-13.20913034650195_p
w(2)=8.864483339366176e-1_p
x(3)=-12.08856097603363_p
w(3)=1.346312963764704_p
x(4)=-10.53680559988281_p
w(4)=1.745225609195687_p
x(5)=-8.625367758013143_p
w(5)=2.061756333629769_p
x(6)=-6.447558607054815_p
w(6)=2.270037989805197_p
x(7)=-4.124367926287264_p
w(7)=2.308218725052637_p
x(8)=-1.815944298497209_p
w(8)=1.932100592846463_p
x(9)=3.830431829226337e-1_p
w(9)=8.939420493455555e-1_p
x(10)=2.729268327631555_p
w(10)=1.549356681254175e-1_p
x(11)=5.445982963581623_p
w(11)=1.239247639442573e-2_p
x(12)=8.449896570526587_p
w(12)=6.614944679643739e-4_p
x(13)=11.55344035057673_p
w(13)=2.939337504682543e-5_p
x(14)=14.42180185749927_p
w(14)=1.404452271246784e-6_p
x(15)=16.45577595780893_p
w(15)=9.688753993316991e-8_p
else if(N==16)then
x(1)=-13.86467390309781_p
w(1)=3.466305042060550e-1_p
x(2)=-13.29274529255292_p
w(2)=7.938223034849465e-1_p
x(3)=-12.28721488496048_p
w(3)=1.210633931472767_p
x(4)=-10.88749856426374_p
w(4)=1.579354460964125_p
x(5)=-9.150022882462851_p
w(5)=1.883185045223993_p
x(6)=-7.148088840951117_p
w(6)=2.103488608623161_p
x(7)=-4.974751290708625_p
w(7)=2.206050319808017_p
x(8)=-2.752729982782532_p
w(8)=2.065208464728412_p
x(9)=-6.144853106140926e-1_p
w(9)=1.355222411439235_p
x(10)=1.513928674972047_p
w(10)=4.020013255117972e-1_p
x(11)=3.908608991320401_p
w(11)=5.036382756984659e-2_p
x(12)=6.602312213300902_p
w(12)=3.802873222793307e-3_p
x(13)=9.470308432152482_p
w(13)=2.236096887242715e-4_p
x(14)=12.32409793041074_p
w(14)=1.224574896752942e-5_p
x(15)=14.84836797667745_p
w(15)=7.865689589769710e-7_p
x(16)=16.55658157631222_p
w(16)=7.186719692706580e-8_p
else if(N==17)then
x(1)=-13.87838623432856_p
w(1)=3.115737940593074e-1_p
x(2)=-13.36382763295029_p
w(2)=7.148584534851850e-1_p
x(3)=-12.45678550374334_p
w(3)=1.093950931772817_p
x(4)=-11.18873326748916_p
w(4)=1.434604214006602_p
x(5)=-9.604788403734545_p
w(5)=1.723421185489927_p
x(6)=-7.763414100758695_p
w(6)=1.946276595995134_p
x(7)=-5.737787131846584_p
w(7)=2.082018907983920_p
x(8)=-3.621847684447939_p
w(8)=2.067116001641862_p
x(9)=-1.534882011204867_p
w(9)=1.676364443136334_p
x(10)=4.765096863911150e-1_p
w(10)=7.767457739099134e-1_p
x(11)=2.614635791927387_p
w(11)=1.551935093367331e-1_p
x(12)=5.028511431319395_p
w(12)=1.650849632946802e-2_p
x(13)=7.652276181506255_p
w(13)=1.276711564383392e-3_p
x(14)=10.35839880183404_p
w(14)=8.544067890451130e-5_p
x(15)=12.96345691532371_p
w(15)=5.790451049309916e-6_p
x(16)=15.18353064419493_p
w(16)=4.847337367472044e-7_p
x(17)=16.63210996882467_p
w(17)=5.555372083715948e-8_p
else
call GD(-14)
end if
end subroutine GF_m14

! [-13kT;17kT]
subroutine GF_m13(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-10.00429124932421_p
w(1)=7.068989725610612_p
x(2)=-2.046002479863678_p
w(2)=5.931012493316865_p
else if(N==3)then
x(1)=-11.28555935631688_p
w(1)=4.219990185053187_p
x(2)=-5.458828459089826_p
w(2)=6.536150418998962_p
x(3)=2.003578610720387e-1_p
w(3)=2.243861614875327_p
else if(N==4)then
x(1)=-11.86537673914586_p
w(1)=2.839403677700240_p
x(2)=-7.635909904004778_p
w(2)=5.245543279106786_p
x(3)=-2.339239979594487_p
w(3)=4.397056441574183_p
x(4)=2.269816220339945_p
w(4)=5.179988205462673e-1_p
else if(N==5)then
x(1)=-12.17830828844318_p
w(1)=2.073266902769607_p
x(2)=-8.974870142555158_p
w(2)=4.145612991587406_p
x(3)=-4.393280802489891_p
w(3)=4.640432642989471_p
x(4)=-1.408721427085028e-1_p
w(4)=2.081155749987563_p
x(5)=4.703602668796209_p
w(5)=5.953393159342930e-2_p
else if(N==6)then
x(1)=-12.36926072678517_p
w(1)=1.598974692751445_p
x(2)=-9.846935072579903_p
w(2)=3.339650457819284_p
x(3)=-5.980101026443433_p
w(3)=4.199186184232603_p
x(4)=-1.871767546837540_p
w(4)=3.290644600753789_p
x(5)=1.844993503558144_p
w(5)=5.671097558522374e-1_p
x(6)=7.420969993231530_p
w(6)=4.436527518116377e-3_p
else if(N==7)then
x(1)=-12.49732098019154_p
w(1)=1.278128998295717_p
x(2)=-10.45471804804681_p
w(2)=2.742547411866592_p
x(3)=-7.190941855976044_p
w(3)=3.668659068279499_p
x(4)=-3.393959470952355_p
w(4)=3.629903874659867_p
x(5)=8.870465077260788e-2_p
w(5)=1.593562890694571_p
x(6)=3.993239790864056_p
w(6)=8.688099820662383e-2_p
x(7)=10.08703679083783_p
w(7)=3.189769246056156e-4_p
else if(N==8)then
x(1)=-12.58937104110987_p
w(1)=1.046185723407298_p
x(2)=-10.90270017036188_p
w(2)=2.285763713466363_p
x(3)=-8.133593419074131_p
w(3)=3.177793247560852_p
x(4)=-4.726698518070208_p
w(4)=3.493079002107623_p
x(5)=-1.334358773800148_p
w(5)=2.514983851775727_p
x(6)=1.875455205108296_p
w(6)=4.716038806447675e-1_p
x(7)=6.188177035563199_p
w(7)=1.056065055643678e-2_p
x(8)=12.30455341354975_p
w(8)=3.214940840882789e-5_p
else if(N==9)then
x(1)=-12.65839579882268_p
w(1)=8.715743728883389e-1_p
x(2)=-11.24446774970629_p
w(2)=1.928648601861491_p
x(3)=-8.879021127876801_p
w(3)=2.752107852735559_p
x(4)=-5.861000369838166_p
w(4)=3.201228366795022_p
x(5)=-2.636835115422249_p
w(5)=2.927709405682996_p
x(6)=3.443313848151111e-1_p
w(6)=1.222449652174983_p
x(7)=3.689876783216850_p
w(7)=9.488285605926643e-2_p
x(8)=8.213736074669610_p
w(8)=1.395588392350574e-3_p
x(9)=13.87426122289541_p
w(9)=5.522337470236608e-6_p
else if(N==10)then
x(1)=-12.71151299069085_p
w(1)=7.368258792825435e-1_p
x(2)=-11.5107177912271_p
w(2)=1.645696724233924_p
x(3)=-9.474309096023550_p
w(3)=2.392251878769367_p
x(4)=-6.810229939550714_p
w(4)=2.882302221415407_p
x(5)=-3.824756633550324_p
w(5)=2.947775962013988_p
x(6)=-9.284467815403007e-1_p
w(6)=1.977320085376823_p
x(7)=1.905945980178340_p
w(7)=4.006489132201272e-1_p
x(8)=5.470822055862072_p
w(8)=1.694717169314826e-2_p
x(9)=9.953308811493800_p
w(9)=2.318308508941163e-4_p
x(10)=14.88212026980886_p
w(10)=1.552071254967686e-6_p
else if(N==11)then
x(1)=-12.75320941979742_p
w(1)=6.308303683236083e-1_p
x(2)=-11.72161323310879_p
w(2)=1.418828165240198_p
x(3)=-9.954310495273052_p
w(3)=2.090811668523083_p
x(4)=-7.600189326882711_p
w(4)=2.580313770703968_p
x(5)=-4.875829827264421_p
w(5)=2.795196010620262_p
x(6)=-2.086050374732545_p
w(6)=2.405757085271108_p
x(7)=5.353858866793992e-1_p
w(7)=9.749384979499641e-1_p
x(8)=3.461340324567018_p
w(8)=1.000406472352532e-1_p
x(9)=7.120108234499708_p
w(9)=3.234671806828536e-3_p
x(10)=11.37478685789561_p
w(10)=5.070979809059984e-5_p
x(11)=15.51260205358635_p
w(11)=6.234551128399933e-7_p
else if(N==12)then
x(1)=-12.78651124734259_p
w(1)=5.460417058965070e-1_p
x(2)=-11.89119966274211_p
w(2)=1.234739848729066_p
x(3)=-10.34543478141579_p
w(3)=1.838465912159746_p
x(4)=-8.258493695401190_p
w(4)=2.308618803372051_p
x(5)=-5.788172318827285_p
w(5)=2.587677408391554_p
x(6)=-3.153194030020472_p
w(6)=2.516695458143610_p
x(7)=-6.181418972412461e-1_p
w(7)=1.593865236478256_p
x(8)=1.920905166038523_p
w(8)=3.500664200533518e-1_p
x(9)=4.972215427139281_p
w(9)=2.310065503087151e-2_p
x(10)=8.584065686395006_p
w(10)=7.159486431255328e-4_p
x(11)=12.49807362706712_p
w(11)=1.450464619662907e-5_p
x(12)=15.91394478461323_p
w(12)=3.173831407761885e-7_p
else if(N==13)then
x(1)=-12.81351774448843_p
w(1)=4.771978220295873e-1_p
x(2)=-12.02945250959805_p
w(2)=1.083624631237269_p
x(3)=-10.6675298065169_p
w(3)=1.626480076302219_p
x(4)=-8.809688893722434_p
w(4)=2.069274848426316_p
x(5)=-6.573809833022888_p
w(5)=2.372626107004963_p
x(6)=-4.119662057230073_p
w(6)=2.455736905853831_p
x(7)=-1.662810091046534_p
w(7)=2.005834765111500_p
x(8)=6.856060788710914e-1_p
w(8)=8.006344248870108e-1_p
x(9)=3.286266718388141_p
w(9)=1.027991804650724e-1_p
x(10)=6.381392103833568_p
w(10)=5.598992320653270e-3_p
x(11)=9.846001421573948_p
w(11)=1.890325775085814e-4_p
x(12)=13.36909062093274_p
w(12)=5.243959309371980e-6_p
x(13)=16.17843514548037_p
w(13)=1.887522377304662e-7_p
else if(N==14)then
x(1)=-12.83571589268631_p
w(1)=4.205569220627833e-1_p
x(2)=-12.1435618445204_p
w(2)=9.582249691292459e-1_p
x(3)=-10.93547953503701_p
w(3)=1.447441203639021_p
x(4)=-9.274067321839054_p
w(4)=1.860223859154543_p
x(5)=-7.249238385887743_p
w(5)=2.167952205924234_p
x(6)=-4.980817634706069_p
w(6)=2.324670896767226_p
x(7)=-2.630785976876155_p
w(7)=2.168913168466199_p
x(8)=-3.694317103219635e-1_p
w(8)=1.310710742699081_p
x(9)=1.930730689764470_p
w(9)=3.111827658775173e-1_p
x(10)=4.605366536857340_p
w(10)=2.855583197169421e-2_p
x(11)=7.656872521954738_p
w(11)=1.507633428172454e-3_p
x(12)=10.91236963554143_p
w(12)=5.959867905886804e-5_p
x(13)=14.03994742607478_p
w(13)=2.296509552762590e-6_p
x(14)=16.35945217824411_p
w(14)=1.246191466484532e-7_p
else if(N==15)then
x(1)=-12.85418023772155_p
w(1)=3.734069549706525e-1_p
x(2)=-12.23879310845074_p
w(2)=8.531215518661412e-1_p
x(3)=-11.16050542975072_p
w(3)=1.295299339827026_p
x(4)=-9.667931844148095_p
w(4)=1.678098470092346_p
x(5)=-7.830874867946900_p
w(5)=1.979890439973238_p
x(6)=-5.741342437667558_p
w(6)=2.171477157850616_p
x(7)=-3.520823762187134_p
w(7)=2.171085778062534_p
x(8)=-1.324296605934193_p
w(8)=1.692481036137405_p
x(9)=8.079981230733865e-1_p
w(9)=6.726633569033729e-1_p
x(10)=3.149165828526783_p
w(10)=1.037676350767748e-1_p
x(11)=5.842511179775614_p
w(11)=8.226697590721269e-3_p
x(12)=8.788057697754224_p
w(12)=4.603997656070845e-4_p
x(13)=11.80232480695919_p
w(13)=2.214223601892228e-5_p
x(14)=14.5576650225424_p
w(14)=1.170090935410959e-6_p
x(15)=16.48779132815658_p
w(15)=8.848408577425190e-8_p
else if(N==16)then
x(1)=-12.86970200674789_p
w(1)=3.337462240204702e-1_p
x(2)=-12.31906412494648_p
w(2)=7.642216708546680e-1_p
x(3)=-11.3511436922055_p
w(3)=1.165192178731401_p
x(4)=-10.0042490638858_p
w(4)=1.519345576755284_p
x(5)=-8.333403466271752_p
w(5)=1.809887542265370_p
x(6)=-6.410640078180593_p
w(6)=2.016593365388062_p
x(7)=-4.328908108971357_p
w(7)=2.095371373376566_p
x(8)=-2.211143999031429_p
w(8)=1.883254518946569_p
x(9)=-1.644202049191911e-1_p
w(9)=1.096305706540740_p
x(10)=1.938058442700145_p
w(10)=2.801579192414626e-1_p
x(11)=4.323016240763829_p
w(11)=3.319147639055713e-2_p
x(12)=6.977131235149653_p
w(12)=2.564507030479505e-3_p
x(13)=9.777558771013345_p
w(13)=1.599173886042922e-4_p
x(14)=12.54022515417626_p
w(14)=9.505183223628999e-6_p
x(15)=14.96017695614457_p
w(15)=6.706013707889871e-7_p
x(16)=16.58166345180961_p
w(16)=6.621264762315597e-8_p
else if(N==17)then
x(1)=-12.88287388392935_p
w(1)=3.000724756649600e-1_p
x(2)=-12.38733421650902_p
w(2)=6.883976889499183e-1_p
x(3)=-11.51395444520356_p
w(3)=1.053229884424638_p
x(4)=-10.29331616505816_p
w(4)=1.380661309407031_p
x(5)=-8.769377494667298_p
w(5)=1.657385994296990_p
x(6)=-6.999445946211718_p
w(6)=1.868511349558260_p
x(7)=-5.056208204108886_p
w(7)=1.987972146245885_p
x(8)=-3.034477324898059_p
w(8)=1.929629339007678_p
x(9)=-1.045858862140540_p
w(9)=1.442981640962275_p
x(10)=9.098137594912711e-1_p
w(10)=5.757711255701996e-1_p
x(11)=3.038959691022094_p
w(11)=1.035244253782752e-1_p
x(12)=5.428969958788367_p
w(12)=1.091774825499276e-2_p
x(13)=8.001949505925973_p
w(13)=8.792114335416759e-4_p
x(14)=10.63540080172355_p
w(14)=6.279117422008235e-5_p
x(15)=13.15083895452971_p
w(15)=4.616062322336125e-6_p
x(16)=15.27637547480131_p
w(16)=4.210102305234296e-7_p
x(17)=16.65220323045892_p
w(17)=5.152605900439057e-8_p
else
call GD(-13)
end if
end subroutine GF_m13

! [-12kT;17kT]
subroutine GF_m12(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-9.200742456042471_p
w(1)=6.602044115633489_p
x(2)=-1.780568107806647_p
w(2)=5.397961987160613_p
else if(N==3)then
x(1)=-10.3863368076672_p
w(1)=3.970863877125444_p
x(2)=-4.914429641985950_p
w(2)=6.097454521449105_p
x(3)=4.416316008877266e-1_p
w(3)=1.931687704219552_p
else if(N==4)then
x(1)=-10.92576313529904_p
w(1)=2.687751517356124_p
x(2)=-6.926863204901167_p
w(2)=4.948167143296244_p
x(3)=-1.950541221483607_p
w(3)=3.967290884338368_p
x(4)=2.581250256041192_p
w(4)=3.967965578033653e-1_p
else if(N==5)then
x(1)=-11.21843009983356_p
w(1)=1.971717215761075_p
x(2)=-8.174412871402319_p
w(2)=3.934312883095552_p
x(3)=-3.841551390306517_p
w(3)=4.325683828595125_p
x(4)=1.939507449477599e-1_p
w(4)=1.727642340470230_p
x(5)=5.101676008525814_p
w(5)=4.064983487212049e-2_p
else if(N==6)then
x(1)=-11.39807722008786_p
w(1)=1.525724567383510_p
x(2)=-8.992799058540577_p
w(2)=3.181980439792194_p
x(3)=-5.316621556613638_p
w(3)=3.969062538750914_p
x(4)=-1.442178620742682_p
w(4)=2.905940698158476_p
x(5)=2.221100775592533_p
w(5)=4.144420101675787e-1_p
x(6)=7.865303978411294_p
w(6)=2.855848541427160e-3_p
else if(N==7)then
x(1)=-11.5193372339851_p
w(1)=1.222023287016134_p
x(2)=-9.567320213394940_p
w(2)=2.619341575101195_p
x(3)=-6.454629694288291_p
w(3)=3.488779722227766_p
x(4)=-2.858215121724472_p
w(4)=3.342424609375382_p
x(5)=4.700250815665081e-1_p
w(5)=1.269504533940544_p
x(6)=4.419362929696853_p
w(6)=5.772586300818684e-2_p
x(7)=10.51094600115_p
w(7)=2.065121248934152e-4_p
else if(N==8)then
x(1)=-11.60690643499255_p
w(1)=1.001427822815635_p
x(2)=-9.992973433167711_p
w(2)=2.186225452617355_p
x(3)=-7.347041758049852_p
w(3)=3.031396092631264_p
x(4)=-4.106206490914939_p
w(4)=3.283344820347903_p
x(5)=-8.987632899888480e-1_p
w(5)=2.156464562415614_p
x(6)=2.278540234542453_p
w(6)=3.342805765988931e-1_p
x(7)=6.619812993641204_p
w(7)=6.844612783585803e-3_p
x(8)=12.6443137254357_p
w(8)=2.216258385131641e-5_p
else if(N==9)then
x(1)=-11.67271487576458_p
w(1)=8.349860441027386e-1_p
x(2)=-10.3185163458196_p
w(2)=1.846562214641730_p
x(3)=-8.055325414794348_p
w(3)=2.630328597587630_p
x(4)=-5.176121070253812_p
w(4)=3.036960382134800_p
x(5)=-2.122941580495308_p
w(5)=2.645590749914520_p
x(6)=7.463733695937830e-1_p
w(6)=9.418504047527821e-1_p
x(7)=4.115888312098274_p
w(7)=6.280296792816419e-2_p
x(8)=8.615523447368220_p
w(8)=9.206138082929615e-4_p
x(9)=14.1140337981546_p
w(9)=4.127923442886238e-6_p
else if(N==10)then
x(1)=-11.72341333995121_p
w(1)=7.063938114460412e-1_p
x(2)=-10.57246160037728_p
w(2)=1.576980581651811_p
x(3)=-8.622091629972260_p
w(3)=2.289486578119641_p
x(4)=-6.075593959119445_p
w(4)=2.746897327440784_p
x(5)=-3.237301488755445_p
w(5)=2.743258676917767_p
x(6)=-4.891092007372474e-1_p
w(6)=1.646934868393716_p
x(7)=2.321976247697380_p
w(7)=2.788426577294476e-1_p
x(8)=5.893023290823553_p
w(8)=1.105144263078054e-2_p
x(9)=10.3064833031016_p
w(9)=1.589164077665110e-4_p
x(10)=15.0430951419501_p
w(10)=1.242056346592778e-6_p
else if(N==11)then
x(1)=-11.76324614986285_p
w(1)=6.051487194472583e-1_p
x(2)=-10.77381771421488_p
w(2)=1.360554476271502_p
x(3)=-9.079771121407806_p
w(3)=2.003064126493512_p
x(4)=-6.826408378365451_p
w(4)=2.465481898838468_p
x(5)=-4.228159223802281_p
w(5)=2.638898654463132_p
x(6)=-1.584977010098415_p
w(6)=2.127804054090604_p
x(7)=9.531214196043446e-1_p
w(7)=7.309218845377353e-1_p
x(8)=3.889159914805004_p
w(8)=6.595636577898678e-2_p
x(9)=7.518341449728744_p
w(9)=2.138990013895426e-3_p
x(10)=11.6730932635513_p
w(10)=3.640904925314135e-5_p
x(11)=15.62116785412712_p
w(11)=5.238097536953452e-7_p
else if(N==12)then
x(1)=-11.7950851769818_p
w(1)=5.240929391367143e-1_p
x(2)=-10.93588161492895_p
w(2)=1.184747280124248_p
x(3)=-9.453162051326560_p
w(3)=1.762758862398215_p
x(4)=-7.453439336131408_p
w(4)=2.209562588925353_p
x(5)=-5.092272764345202_p
w(5)=2.460350939431462_p
x(6)=-2.588363749954780_p
w(6)=2.311277768970948_p
x(7)=-1.726752560259344e-1_p
w(7)=1.291454683662001_p
x(8)=2.347187991656362_p
w(8)=2.402025970461920e-1_p
x(9)=5.393235197354650_p
w(9)=1.506046680746340e-2_p
x(10)=8.947241315939467_p
w(10)=4.867966049003772e-4_p
x(11)=12.74385518473344_p
w(11)=1.090405241198422e-5_p
x(12)=15.98929737397549_p
w(12)=2.756341921812437e-7_p
else if(N==13)then
x(1)=-11.82092417396944_p
w(1)=4.582309320153369e-1_p
x(2)=-11.0681089013943_p
w(2)=1.040294240086193_p
x(3)=-9.760969068934354_p
w(3)=1.560553508928964_p
x(4)=-7.979299086979901_p
w(4)=1.982819886072800_p
x(5)=-5.838902830572230_p
w(5)=2.264486811265689_p
x(6)=-3.499502485502199_p
w(6)=2.301449771093275_p
x(7)=-1.168500317237192_p
w(7)=1.734108192847544_p
x(8)=1.115894018497602_p
w(8)=5.867611355089818e-1_p
x(9)=3.717417639053191_p
w(9)=6.747148825838721e-2_p
x(10)=6.781668676723014_p
w(10)=3.692913039286804e-3_p
x(11)=10.16959751441898_p
w(11)=1.329484921119513e-4_p
x(12)=13.5692195983677_p
w(12)=4.107510139889882e-6_p
x(13)=16.2325963617474_p
w(13)=1.676753913717203e-7_p
else if(N==14)then
x(1)=-11.8421764301692_p
w(1)=4.040075428348218e-1_p
x(2)=-11.17732253045472_p
w(2)=9.203262315764392e-1_p
x(3)=-10.01725510701306_p
w(3)=1.389554435867995_p
x(4)=-8.422892444102978_p
w(4)=1.784081502336049_p
x(5)=-6.482332587421815_p
w(5)=2.073844575679147_p
x(6)=-4.314809474281025_p
w(6)=2.201549251604852_p
x(7)=-2.081862258427320_p
w(7)=1.960566959045625_p
x(8)=8.254697797233107e-2_p
w(8)=1.035323535113506_p
x(9)=2.365163895730004_p
w(9)=2.111137589894786e-1_p
x(10)=5.027922958255512_p
w(10)=1.857593608937712e-2_p
x(11)=8.028675814329334_p
w(11)=1.016988018731647e-3_p
x(12)=11.19630775681284_p
w(12)=4.341104582302899e-5_p
x(13)=14.20257359513392_p
w(13)=1.862119827548684e-6_p
x(14)=16.39971229222828_p
w(14)=1.124724285799277e-7_p
else if(N==15)then
x(1)=-11.85986413983488_p
w(1)=3.588435785591951e-1_p
x(2)=-11.26852493471932_p
w(2)=8.197051509994779e-1_p
x(3)=-10.2326456172186_p
w(3)=1.244093392110422_p
x(4)=-8.799511014083267_p
w(4)=1.610533162841366_p
x(5)=-7.037380925316805_p
w(5)=1.896766236678741_p
x(6)=-5.037362829202070_p
w(6)=2.068048674723533_p
x(7)=-2.921642782650259_p
w(7)=2.014899742220607_p
x(8)=-8.332166321697393e-1_p
w(8)=1.429809532382567_p
x(9)=1.248218141024150_p
w(9)=4.837476944965333e-1_p
x(10)=3.583907990415668_p
w(10)=6.781668908814631e-2_p
x(11)=6.246335507086344_p
w(11)=5.405351008111972e-3_p
x(12)=9.127993859194389_p
w(12)=3.191640313044863e-4_p
x(13)=12.04921187966094_p
w(13)=1.667695382472713e-5_p
x(14)=14.69038705016201_p
w(14)=9.759216958786350e-7_p
x(15)=16.51862426259289_p
w(15)=8.077857693607412e-8_p
else if(N==16)then
x(1)=-11.8747406490671_p
w(1)=3.208336283010970e-1_p
x(2)=-11.34544237190107_p
w(2)=7.345447906315434e-1_p
x(3)=-10.41523807947008_p
w(3)=1.119592625240198_p
x(4)=-9.121372448487406_p
w(4)=1.459000129262256_p
x(5)=-7.517573253519903_p
w(5)=1.735726620278248_p
x(6)=-5.674879123494085_p
w(6)=1.926762595160719_p
x(7)=-3.686572853180690_p
w(7)=1.973059130626257_p
x(8)=-1.673476163280355_p
w(8)=1.672539181750314_p
x(9)=2.937004297118780e-1_p
w(9)=8.462570362597971e-1_p
x(10)=2.379053231652942_p
w(10)=1.883192328789480e-1_p
x(11)=4.748080090759134_p
w(11)=2.153156207477435e-2_p
x(12)=7.356480050933455_p
w(12)=1.717458901070652e-3_p
x(13)=10.08506441831078_p
w(13)=1.140980546854746e-4_p
x(14)=12.75398716855205_p
w(14)=7.380242650784503e-6_p
x(15)=15.06935186976739_p
w(15)=5.721683077557093e-7_p
x(16)=16.60589159153539_p
w(16)=6.096323469934668e-8_p
else if(N==17)then
x(1)=-11.88737073412583_p
w(1)=2.885464636111766e-1_p
x(2)=-11.4108922895088_p
w(2)=6.618714488972011e-1_p
x(3)=-10.57126488973294_p
w(3)=1.012377353204956_p
x(4)=-9.398210671838122_p
w(4)=1.326452627394253_p
x(5)=-7.934604005638623_p
w(5)=1.590729477196270_p
x(6)=-6.236782022782175_p
w(6)=1.788878615018015_p
x(7)=-4.377325674234333_p
w(7)=1.886971604605413_p
x(8)=-2.451530193675539_p
w(8)=1.769600582351956_p
x(9)=-5.558783381934376e-1_p
w(9)=1.191803107953983_p
x(10)=1.357955948908028_p
w(10)=4.075830969222865e-1_p
x(11)=3.477194172020716_p
w(11)=6.739433308247623e-2_p
x(12)=5.836731429090420_p
w(12)=7.144571563166696e-3_p
x(13)=8.354166285815914_p
w(13)=6.026392129638619e-4_p
x(14)=10.91168035459358_p
w(14)=4.608655512525142e-5_p
x(15)=13.335792811814_p
w(15)=3.681654694996979e-6_p
x(16)=15.36704644548488_p
w(16)=3.658196120278186e-7_p
x(17)=16.67166433662556_p
w(17)=4.775055201103781e-8_p
else
call GD(-12)
end if
end subroutine GF_m12

! [-11kT;17kT]
subroutine GF_m11(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-8.395772144538208_p
w(1)=6.137599003786554_p
x(2)=-1.506531290500061_p
w(2)=4.862417656375388_p
else if(N==3)then
x(1)=-9.486320526077202_p
w(1)=3.723425667058446_p
x(2)=-4.368292254458845_p
w(2)=5.649016910025678_p
x(3)=7.022101548852763e-1_p
w(3)=1.627574083077818_p
else if(N==4)then
x(1)=-9.985738421108092_p
w(1)=2.537006018910796_p
x(2)=-6.216816913510857_p
w(2)=4.647929660765305_p
x(3)=-1.557809686282642_p
w(3)=3.521046656719834_p
x(4)=2.921630662083379_p
w(4)=2.940343237660065e-1_p
else if(N==5)then
x(1)=-10.25836962755084_p
w(1)=1.870560107018063_p
x(2)=-7.373543813715141_p
w(2)=3.721916878117457_p
x(3)=-3.291437837863182_p
w(3)=3.989942702551042_p
x(4)=5.472932481950805e-1_p
w(4)=1.390657822352362_p
x(5)=5.527190266979624_p
w(5)=2.693915012301825e-2_p
else if(N==6)then
x(1)=-10.42686348286373_p
w(1)=1.452510525363685_p
x(2)=-8.138773361056021_p
w(2)=3.023469362796009_p
x(3)=-4.655215877544650_p
w(3)=3.728070956785581_p
x(4)=-1.010183588801947_p
w(4)=2.502673443858582_p
x(5)=2.625573252584732_p
w(5)=2.914918588078739e-1_p
x(6)=8.328345204084149_p
w(6)=1.800512550211144e-3_p
else if(N==7)then
x(1)=-10.54139926238818_p
w(1)=1.165775338878409_p
x(2)=-8.680302309222224_p
w(2)=2.495340851943813_p
x(3)=-5.720219552594197_p
w(3)=3.303430961380442_p
x(4)=-2.327054771909553_p
w(4)=3.024978191689000_p
x(5)=8.698826980779411e-1_p
w(5)=9.730256343910354e-1_p
x(6)=4.867551877779102_p
w(6)=3.733307049444592e-2_p
x(7)=10.93910555153901_p
w(7)=1.326113847962134e-4_p
else if(N==8)then
x(1)=-10.62449916295378_p
w(1)=9.565063087080691e-1_p
x(2)=-9.083628556517954_p
w(2)=2.086046676093971_p
x(3)=-6.561966213975734_p
w(3)=2.881993543759574_p
x(4)=-3.490368008098686_p
w(4)=3.054230007760604_p
x(5)=-4.588679136910671e-1_p
w(5)=1.788628674914749_p
x(6)=2.706209407037920_p
w(6)=2.282295022135832e-1_p
x(7)=7.064094569354008_p
w(7)=4.366640255128167e-3_p
x(8)=12.97691932342553_p
w(8)=1.530645626435493e-5_p
else if(N==9)then
x(1)=-10.68708165821498_p
w(1)=7.982633977002507e-1_p
x(2)=-9.392866983953903_p
w(2)=1.764003084158567_p
x(3)=-7.232694252184980_p
w(3)=2.506760206261696_p
x(4)=-4.494597469738215_p
w(4)=2.862430594308302_p
x(5)=-1.612805671235146_p
w(5)=2.332111087148784_p
x(6)=1.167554057841402_p
w(6)=6.952828223280726e-1_p
x(7)=4.560442427051306_p
w(7)=4.056009993891243e-2_p
x(8)=9.022595516172963_p
w(8)=6.022672362567026e-4_p
x(9)=14.34403502988516_p
w(9)=3.101081100854705e-6_p
else if(N==10)then
x(1)=-10.73535177406518_p
w(1)=6.758550318853829e-1_p
x(2)=-9.634439988164369_p
w(2)=1.507911498311795_p
x(3)=-7.770654917835776_p
w(3)=2.185570179185348_p
x(4)=-5.343286074030847_p
w(4)=2.606006074021521_p
x(5)=-2.655003980393288_p
w(5)=2.512499994033901_p
x(6)=-4.233470029785030e-2_p
w(6)=1.317840972778995_p
x(7)=2.760221560526392_p
w(7)=1.871238329029812e-1_p
x(8)=6.326774774618730_p
w(8)=7.099502071295153e-3_p
x(9)=10.65984619742424_p
w(9)=1.085767768445330e-4_p
x(10)=15.1962256205619_p
w(10)=9.981938771573450e-7_p
else if(N==11)then
x(1)=-10.77331400901936_p
w(1)=5.793801988770675e-1_p
x(2)=-9.826209615866087_p
w(2)=1.302007646766380_p
x(3)=-8.205827224885175_p
w(3)=1.914523706984309_p
x(4)=-6.054290345371263_p
w(4)=2.347508013122062_p
x(5)=-3.584725547950519_p
w(5)=2.466728416305235_p
x(6)=-1.085540684824067_p
w(6)=1.822122447023246_p
x(7)=1.390041042132330_p
w(7)=5.238452419228091e-1_p
x(8)=4.333709732881506_p
w(8)=4.247267628577019e-2_p
x(9)=7.922803720729254_p
w(9)=1.401738014528957e-3_p
x(10)=11.96865237746419_p
w(10)=2.613359055695575e-5_p
x(11)=15.72434318745567_p
w(11)=4.412699777304066e-7_p
else if(N==12)then
x(1)=-10.80368506837182_p
w(1)=5.020719688563087e-1_p
x(2)=-9.980716926229681_p
w(2)=1.134537017460064_p
x(3)=-8.561358363426361_p
w(3)=1.686475820650144_p
x(4)=-6.649618726597851_p
w(4)=2.108564407750155_p
x(5)=-4.399510506070960_p
w(5)=2.324060255001394_p
x(6)=-2.028360125214762_p
w(6)=2.075387869758953_p
x(7)=2.825811393352760e-1_p
w(7)=9.998283066955912e-1_p
x(8)=2.793707614195528_p
w(8)=1.590778052188507e-1_p
x(9)=5.825169752171991_p
w(9)=9.675448300739067e-3_p
x(10)=9.312861871158432_p
w(10)=3.293143129119822e-4_p
x(11)=12.98567691342837_p
w(11)=8.206450959744786e-6_p
x(12)=16.06107876251133_p
w(12)=2.397058710883340e-7_p
else if(N==13)then
x(1)=-10.82835253457455_p
w(1)=4.392032069141789e-1_p
x(2)=-10.10689284510891_p
w(2)=9.967865949678030e-1_p
x(3)=-8.854786630294795_p
w(3)=1.494191289334006_p
x(4)=-7.149855651406810_p
w(4)=1.895080562168256_p
x(5)=-5.106302816947021_p
w(5)=2.151167944989548_p
x(6)=-2.884091160362440_p
w(6)=2.125689608874167_p
x(7)=-6.734939945178189e-1_p
w(7)=1.441412036993216_p
x(8)=1.564848126371730_p
w(8)=4.106913061861169e-1_p
x(9)=4.163892456921361_p
w(9)=4.328445832462961e-2_p
x(10)=7.188509753997683_p
w(10)=2.413007203717703e-3_p
x(11)=10.4931390877213_p
w(11)=9.327293643481403e-5_p
x(12)=13.7652451682278_p
w(12)=3.222247763793416e-6_p
x(13)=16.28437161165064_p
w(13)=1.490221031761543e-7_p
else if(N==14)then
x(1)=-10.84865566740735_p
w(1)=3.874063870062408e-1_p
x(2)=-10.21119060907027_p
w(2)=8.822807769487676e-1_p
x(3)=-9.099341378587752_p
w(3)=1.331327763708736_p
x(4)=-7.572463604049299_p
w(4)=1.707040802084780_p
x(5)=-5.717157723125233_p
w(5)=1.976585180031867_p
x(6)=-3.652619285601042_p
w(6)=2.065259112364234_p
x(7)=-1.536792169157242_p
w(7)=1.720802480028750_p
x(8)=5.459050707227635e-1_p
w(8)=7.783184438384654e-1_p
x(9)=2.818128080773260_p
w(9)=1.383709059906901e-1_p
x(10)=5.460862269887994_p
w(10)=1.190964543486590e-2_p
x(11)=8.403942845062099_p
w(11)=6.819568982879122e-4_p
x(12)=11.4787072267902_p
w(12)=3.159231895992370e-5_p
x(13)=14.36146499666527_p
w(13)=1.512010407541617e-6_p
x(14)=16.43833922334992_p
w(14)=1.014968883280055e-7_p
else if(N==15)then
x(1)=-10.86556411072677_p
w(1)=3.442357633357739e-1_p
x(2)=-10.29834809345031_p
w(2)=7.861656744399270e-1_p
x(3)=-9.305044750031444_p
w(3)=1.192615651926288_p
x(4)=-7.931691518582420_p
w(4)=1.542310491788054_p
x(5)=-6.245219379874820_p
w(5)=1.811612614960583_p
x(6)=-4.336305316313598_p
w(6)=1.956723443677142_p
x(7)=-2.327257238596235_p
w(7)=1.832706797471444_p
x(8)=-3.392180060786624e-1_p
w(8)=1.154328755823915_p
x(9)=1.706323881563394_p
w(9)=3.322226099045136e-1_p
x(10)=4.032827853044497_p
w(10)=4.334326326413285e-2_p
x(11)=6.656838988475941_p
w(11)=3.517691628025845e-3_p
x(12)=9.469241009151444_p
w(12)=2.204527674568952e-4_p
x(13)=12.29380655757025_p
w(13)=1.256062634701893e-5_p
x(14)=14.81991264914863_p
w(14)=8.148423709843790e-7_p
x(15)=16.5483073386281_p
w(15)=7.370596783050132e-8_p
else if(N==16)then
x(1)=-10.8797931947638_p
w(1)=3.078826084596857e-1_p
x(2)=-10.37189896872838_p
w(2)=7.047634958711294e-1_p
x(3)=-9.479550933988651_p
w(3)=1.073771383898392_p
x(4)=-8.238989458664198_p
w(4)=1.398155889460712_p
x(5)=-6.702793912567893_p
w(5)=1.660188579669028_p
x(6)=-4.941352982394218_p
w(6)=1.832082429429781_p
x(7)=-3.048506659904363_p
w(7)=1.833172569753788_p
x(8)=-1.138273195732509_p
w(8)=1.432480022638888_p
x(9)=7.641723712846339e-1_p
w(9)=6.201134046219808e-1_p
x(10)=2.837115122113997_p
w(10)=1.224084554941226e-1_p
x(11)=5.183062565350696_p
w(11)=1.376752438002925e-2_p
x(12)=7.739844854822377_p
w(12)=1.142782542035068e-3_p
x(13)=10.39244831754367_p
w(13)=8.123667352801038e-5_p
x(14)=12.96517888759378_p
w(14)=5.732663114420295e-6_p
x(15)=15.17587041281766_p
w(15)=4.885193160910200e-7_p
x(16)=16.62928756386364_p
w(16)=5.608641133304983e-8_p
else if(N==17)then
x(1)=-10.89187968967029_p
w(1)=2.769870057133227e-1_p
x(2)=-10.43451809187367_p
w(2)=6.352557605907084e-1_p
x(3)=-9.628761585340211_p
w(3)=9.713410159619776e-1_p
x(4)=-8.503516584214603_p
w(4)=1.271854223669595_p
x(5)=-7.100677184892811_p
w(5)=1.523094816500992_p
x(6)=-5.475853516205510_p
w(6)=1.706146234812836_p
x(7)=-3.701888183892394_p
w(7)=1.774836193715805_p
x(8)=-1.872985264319909_p
w(8)=1.580810038448891_p
x(9)=-6.105641787420349e-2_p
w(9)=9.360393901593843e-1_p
x(10)=1.823099421540069_p
w(10)=2.756503957589384e-1_p
x(11)=3.928642920857220_p
w(11)=4.292320817826500e-2_p
x(12)=6.251182830360173_p
w(12)=4.630011511517676e-3_p
x(13)=8.708498346222108_p
w(13)=4.112762909488799e-4_p
x(14)=11.18694019084646_p
w(14)=3.378874281774435e-5_p
x(15)=13.51817953098091_p
w(15)=2.937926293531456e-6_p
x(16)=15.45553725284547_p
w(16)=3.179700714171370e-7_p
x(17)=16.69050777912957_p
w(17)=4.420957675308852e-8_p
else
call GD(-11)
end if
end subroutine GF_m11

! [-10kT;17kT]
subroutine GF_m10(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-7.589293317799717_p
w(1)=5.675308450974539_p
x(2)=-1.221805089539950_p
w(2)=4.324736906525302_p
else if(N==3)then
x(1)=-8.585518089460997_p
w(1)=3.477476294226838_p
x(2)=-3.820600287002342_p
w(2)=5.186796624215998_p
x(3)=9.859809916734862e-1_p
w(3)=1.335772439057004_p
else if(N==4)then
x(1)=-9.045339691139358_p
w(1)=2.386989524937307_p
x(2)=-5.506219375957538_p
w(2)=4.342248477058029_p
x(3)=-1.158847364557352_p
w(3)=3.060761983595770_p
x(4)=3.294020130227178_p
w(4)=2.100453719087345e-1_p
else if(N==5)then
x(1)=-9.298174012250554_p
w(1)=1.769627779741384_p
x(2)=-6.572651598947979_p
w(2)=3.507068116415916_p
x(3)=-2.743399219921117_p
w(3)=3.627196193183040_p
x(4)=9.239439695766682e-1_p
w(4)=1.078843384788776_p
x(5)=5.981218610771055_p
w(5)=1.730988337072465e-2_p
else if(N==6)then
x(1)=-9.455666142994861_p
w(1)=1.379182815614464_p
x(2)=-7.285178447901681_p
w(2)=2.863303363885024_p
x(3)=-3.996918607549651_p
w(3)=3.470674150974466_p
x(4)=-5.722407989624906e-1_p
w(4)=2.088833167172895_p
x(5)=3.060435862406012_p
w(5)=1.969394909160354e-1_p
x(6)=8.809234457379818_p
w(6)=1.112368936956157e-3_p
else if(N==7)then
x(1)=-9.563541375753102_p
w(1)=1.109275921042711_p
x(2)=-7.793888594334601_p
w(2)=2.370041835238012_p
x(3)=-4.988516127804511_p
w(3)=3.109416094619822_p
x(4)=-1.799884866012575_p
w(4)=2.674047690085084_p
x(5)=1.292974470000071_p
w(5)=7.136612380174170e-1_p
x(6)=5.337397513440266_p
w(6)=2.351797140319770e-2_p
x(7)=11.36914601446164_p
w(7)=8.460709359661871e-5_p
else if(N==8)then
x(1)=-9.642172045703139_p
w(1)=9.113468007288031e-1_p
x(2)=-8.174813256071433_p
w(2)=1.984908208229830_p
x(3)=-5.778905705907356_p
w(3)=2.727819036489792_p
x(4)=-2.879955117979985_p
w(4)=2.798364985999780_p
x(5)=-9.787856041139398e-3_p
w(5)=1.424765152072822_p
x(6)=3.159464042476433_p
w(6)=1.500863184166143e-1_p
x(7)=7.520118921905813_p
w(7)=2.744251340219154e-3_p
x(8)=13.3006861854268_p
w(8)=1.060422198007661e-5_p
else if(N==9)then
x(1)=-9.701513019163855_p
w(1)=7.613509019113355e-1_p
x(2)=-8.467626469083831_p
w(2)=1.680751276585537_p
x(3)=-6.411504219609984_p
w(3)=2.380369061541668_p
x(4)=-3.817351163213357_p
w(4)=2.672198586049331_p
x(5)=-1.104221888402370_p
w(5)=1.989459764966093_p
x(6)=1.611813594414002_p
w(6)=4.899338417457021e-1_p
x(7)=5.022954886071084_p
w(7)=2.558853890279260e-2_p
x(8)=9.433948775057447_p
w(8)=3.910435974747396e-4_p
x(9)=14.56377031411907_p
w(9)=2.342199906013603e-6_p
else if(N==10)then
x(1)=-9.747341763707329_p
w(1)=6.451652388511934e-1_p
x(2)=-8.696735891913317_p
w(2)=1.438327453269261_p
x(3)=-6.920276904494960_p
w(3)=2.079852564123116_p
x(4)=-4.614062560010983_p
w(4)=2.456309258406856_p
x(5)=-2.077913091505547_p
w(5)=2.248764141166130_p
x(6)=4.171376348283552e-1_p
w(6)=1.005842114462018_p
x(7)=3.221113366143105_p
w(7)=1.212132923302396e-1_p
x(8)=6.771305860593264_p
w(8)=4.496501069110489e-3_p
x(9)=11.01250611075114_p
w(9)=7.398825829558808e-5_p
x(10)=15.34153472235577_p
w(10)=8.055636204390715e-7_p
else if(N==11)then
x(1)=-9.783423999452127_p
w(1)=5.534886352513821e-1_p
x(2)=-8.878855135263606_p
w(2)=1.243063659774039_p
x(3)=-7.332690804804080_p
w(3)=1.824755084327539_p
x(4)=-5.284410750351385_p
w(4)=2.224398971940025_p
x(5)=-2.946359284961229_p
w(5)=2.271415665424187_p
x(6)=-5.842616907280223e-1_p
w(6)=1.497030654762735_p
x(7)=1.849209724556943_p
w(7)=3.582080179219391e-1_p
x(8)=4.794273753649565_p
w(8)=2.675462051521155e-2_p
x(9)=8.332739254884070_p
w(9)=9.109137929056756e-4_p
x(10)=12.26081935190682_p
w(10)=1.876112858836566e-5_p
x(11)=15.82225346411725_p
w(11)=3.726612890465594e-7_p
else if(N==12)then
x(1)=-9.812320001841279_p
w(1)=4.799488867100098e-1_p
x(2)=-9.025759255061551_p
w(2)=1.084011588659307_p
x(3)=-7.670189334851389_p
w(3)=1.609309975221986_p
x(4)=-5.847467410521123_p
w(4)=2.004385178773259_p
x(5)=-3.710770774248443_p
w(5)=2.173626232181554_p
x(6)=-1.472215427106184_p
w(6)=1.805512284187641_p
x(7)=7.527078811380765e-1_p
w(7)=7.350088313929867e-1_p
x(8)=3.260509892791669_p
w(8)=1.018832442221250e-1_p
x(9)=6.267258563541208_p
w(9)=6.130977843900179e-3_p
x(10)=9.680256648669411_p
w(10)=2.217649425391371e-4_p
x(11)=13.2231428025344_p
w(11)=6.184658767521620e-6_p
x(12)=16.12939697909972_p
w(12)=2.087057648579045e-7_p
else if(N==13)then
x(1)=-9.835810394690913_p
w(1)=4.200896328577788e-1_p
x(2)=-9.145848425566925_p
w(2)=9.530234215567536e-1_p
x(3)=-7.949114551369811_p
w(3)=1.427167961049121_p
x(4)=-6.321693116313946_p
w(4)=1.805249537480131_p
x(5)=-4.376754566080670_p
w(5)=2.029338444104473_p
x(6)=-2.273845846886105_p
w(6)=1.920755707779132_p
x(7)=-1.734563699449964e-1_p
w(7)=1.141123769056417_p
x(8)=2.034768365208701_p
w(8)=2.744750063854283e-1_p
x(9)=4.624899461742827_p
w(9)=2.719095081945897e-2_p
x(10)=7.601245971547463_p
w(10)=1.562960834288846e-3_p
x(11)=10.81608333953366_p
w(11)=6.530124489862141e-5_p
x(12)=13.9569522816586_p
w(12)=2.531849688423484e-6_p
x(13)=16.33383603534424_p
w(13)=1.324822716688038e-7_p
else if(N==14)then
x(1)=-9.855159974013194_p
w(1)=3.707323086647303e-1_p
x(2)=-9.245202748705399_p
w(2)=8.440245976123573e-1_p
x(3)=-8.181845540169528_p
w(3)=1.272589769487975_p
x(4)=-6.723042844263836_p
w(4)=1.628550764272015_p
x(5)=-4.954304160646556_p
w(5)=1.874050182870875_p
x(6)=-2.995081425008641_p
w(6)=1.908996395217508_p
x(7)=-9.935280477552063e-1_p
w(7)=1.450976349882773_p
x(8)=1.025239933666812_p
w(8)=5.542609072729536e-1_p
x(9)=3.289416723743270_p
w(9)=8.785129567253497e-2_p
x(10)=5.903422924095048_p
w(10)=7.533690394709679e-3_p
x(11)=8.782100742402344_p
w(11)=4.547980643121669e-4_p
x(12)=11.75916066100427_p
w(12)=2.297708860416052e-5_p
x(13)=14.51651613083081_p
w(13)=1.229432503791184e-6_p
x(14)=16.47538246561027_p
w(14)=9.156598809731347e-8_p
else if(N==15)then
x(1)=-9.871285559795991_p
w(1)=3.295654577263289e-1_p
x(2)=-9.328293422603055_p
w(2)=7.524499688323362e-1_p
x(3)=-8.377791171410101_p
w(3)=1.140732094001837_p
x(4)=-7.064682625958723_p
w(4)=1.473038422136435_p
x(5)=-5.454854082672052_p
w(5)=1.723043095631989_p
x(6)=-3.639004420101411_p
w(6)=1.832641334772359_p
x(7)=-1.737415831939224_p
w(7)=1.618202143193358_p
x(8)=1.624469452992203e-1_p
w(8)=8.826364686614441e-1_p
x(9)=2.183992409269077_p
w(9)=2.181578770821669e-1_p
x(10)=4.495093886003959_p
w(10)=2.714762245286066e-2_p
x(11)=7.073388371187241_p
w(11)=2.268891373129156e-3_p
x(12)=9.811324058337318_p
w(12)=1.517716043763952e-4_p
x(13)=12.53581957918726_p
w(13)=9.461792863873378e-6_p
x(14)=14.94619562246011_p
w(14)=6.810305009603163e-7_p
x(15)=16.57687294580843_p
w(15)=6.720785529498567e-8_p
else if(N==16)then
x(1)=-9.884864275886221_p
w(1)=2.948776181788177e-1_p
x(2)=-9.398460105908532_p
w(2)=6.748330609414218e-1_p
x(3)=-8.544156030058963_p
w(3)=1.027621214999900_p
x(4)=-7.357270161086132_p
w(4)=1.336523683376514_p
x(5)=-5.889432910975969_p
w(5)=1.582337256021736_p
x(6)=-4.210777258296840_p
w(6)=1.729284774904829_p
x(7)=-2.415286693726823_p
w(7)=1.668089631911542_p
x(8)=-6.025496248611156e-1_p
w(8)=1.169687557476571_p
x(9)=1.250981979095048_p
w(9)=4.301004592263674e-1_p
x(10)=3.311869639081905_p
w(10)=7.718403770722360e-2_p
x(11)=5.627199776430973_p
w(11)=8.687560792139972e-3_p
x(12)=8.126700194711495_p
w(12)=7.558446678760692e-4_p
x(13)=10.69932967017922_p
w(13)=5.773337205854456e-5_p
x(14)=13.17360251380565_p
w(14)=4.455023664138248e-6_p
x(15)=15.27971610168097_p
w(15)=4.173466729075796e-7_p
x(16)=16.65187279280599_p
w(16)=5.155250555788853e-8_p
else if(N==17)then
x(1)=-9.896404746899082_p
w(1)=2.653806065879055e-1_p
x(2)=-9.458234062576237_p
w(2)=6.085125580744327e-1_p
x(3)=-8.686506846933668_p
w(3)=9.300333920365351e-1_p
x(4)=-7.609374246073090_p
w(4)=1.216646134705432_p
x(5)=-6.267892152741531_p
w(5)=1.453827307526707_p
x(6)=-4.717245955798945_p
w(6)=1.618127552321197_p
x(7)=-3.030701244328092_p
w(7)=1.645305396241806_p
x(8)=-1.297790768123541_p
w(8)=1.359974060969004_p
x(9)=4.434032369061257e-1_p
w(9)=6.936079034650323e-1_p
x(10)=2.306430568129333_p
w(10)=1.785420395405354e-1_p
x(11)=4.392455819142184_p
w(11)=2.680796434037102e-2_p
x(12)=6.671706216983536_p
w(12)=2.973474863808805e-3_p
x(13)=9.064510007144149_p
w(13)=2.795542984331337e-4_p
x(14)=11.4608838340703_p
w(14)=2.474950676953138e-5_p
x(15)=13.69786699776203_p
w(15)=2.345693535525242e-6_p
x(16)=15.54184528472593_p
w(16)=2.764414692891960e-7_p
x(17)=16.70874796693441_p
w(17)=4.088686598396461e-8_p
else
call GD(-10)
end if
end subroutine GF_m10

! [-9kT;17kT]
subroutine GF_m9(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-6.781262921325728_p
w(1)=5.214310121793816_p
x(2)=-9.236305633919341e-1_p
w(2)=3.785813238996531_p
else if(N==3)then
x(1)=-7.683981331038435_p
w(1)=3.232538485847425_p
x(2)=-3.271436599535245_p
w(2)=4.705928398271333_p
x(3)=1.297605299113407_p
w(3)=1.061656476671588_p
else if(N==4)then
x(1)=-8.104637952029515_p
w(1)=2.237350300278609_p
x(2)=-4.795708061585425_p
w(2)=4.027056742484135_p
x(3)=-7.503051187317704e-1_p
w(3)=2.591543176606358_p
x(4)=3.701452583555964_p
w(4)=1.441731414212441e-1_p
else if(N==5)then
x(1)=-8.337916638092072_p
w(1)=1.668630504715201_p
x(2)=-5.772302463795411_p
w(2)=3.287470603239009_p
x(3)=-2.197337673029684_p
w(3)=3.232006278241328_p
x(4)=1.329224825678318_p
w(4)=8.012411540226112e-1_p
x(5)=6.464657826912528_p
w(5)=1.077482057219736e-2_p
else if(N==6)then
x(1)=-8.484550221117074_p
w(1)=1.305506668178683_p
x(2)=-6.432460929207997_p
w(2)=2.700108431973236_p
x(3)=-3.342829930537576_p
w(3)=3.189274957253908_p
x(4)=-1.233025558364213e-1_p
w(4)=1.676871687779929_p
x(5)=3.527137760786197_p
w(5)=1.276876096270559e-1_p
x(6)=9.306651361531857_p
w(6)=6.740059775350252e-4_p
else if(N==7)then
x(1)=-8.585809763092811_p
w(1)=1.052357447449795_p
x(2)=-6.908385596107308_p
w(2)=2.242597080086292_p
x(3)=-4.260522107092922_p
w(3)=2.901670202488064_p
x(4)=-1.274712211537888_p
w(4)=2.290488847813314_p
x(5)=1.743780489223158_p
w(5)=4.985128321162171e-1_p
x(6)=5.828253518411049_p
w(6)=1.444321639980881e-2_p
x(7)=11.7984170248312_p
w(7)=5.373443685719937e-5_p
else if(N==8)then
x(1)=-8.659956834401926_p
w(1)=8.658306221079742e-1_p
x(2)=-7.266735230186191_p
w(2)=1.882262155924764_p
x(3)=-4.998587131839734_p
w(3)=2.565863692766868_p
x(4)=-2.275257538117317_p
w(4)=2.507859946314863_p
x(5)=4.544813979047815e-1_p
w(5)=1.081456787616164_p
x(6)=3.638684597938295_p
w(6)=9.514239438482258e-2_p
x(7)=7.986851623721781_p
w(7)=1.700383629306357e-3_p
x(8)=13.61402726694806_p
w(8)=7.378045585279026e-6_p
else if(N==9)then
x(1)=-8.716033021905528_p
w(1)=7.241576442740560e-1_p
x(2)=-7.542948049252414_p
w(2)=1.596425034960919_p
x(3)=-5.592284674322548_p
w(3)=2.249327091046476_p
x(4)=-3.145343358246030_p
w(4)=2.458522735964678_p
x(5)=-5.932103898257808e-1_p
w(5)=1.626848609850657_p
x(6)=2.082367982117741_p
w(6)=3.287996767957787e-1_p
x(7)=5.502672561624784_p
w(7)=1.578859104651182e-2_p
x(8)=9.848490573834468_p
w(8)=2.521978666117778e-4_p
x(9)=14.77286871690191_p
w(9)=1.778984659273027e-6_p
else if(N==10)then
x(1)=-8.759402553569240_p
w(1)=6.142515528176390e-1_p
x(2)=-7.759468488339349_p
w(2)=1.367947344698855_p
x(3)=-6.071354131072399_p
w(3)=1.971163454469514_p
x(4)=-3.888867836890869_p
w(4)=2.292450062184258_p
x(5)=-1.504951384730589_p
w(5)=1.948122025974875_p
x(6)=8.950383999896107e-1_p
w(6)=7.273987393786983e-1_p
x(7)=3.704497442752536_p
w(7)=7.592915725009852e-2_p
x(8)=7.225768530383989_p
w(8)=2.810051599320335e-3_p
x(9)=11.36353972149183_p
w(9)=5.031968449040709e-5_p
x(10)=15.47909897958351_p
w(10)=6.527325974839712e-7_p
else if(N==11)then
x(1)=-8.793591790176794_p
w(1)=5.274144576756358e-1_p
x(2)=-7.931849116639797_p
w(2)=1.183507924938967_p
x(3)=-6.460665715246120_p
w(3)=1.732968717552121_p
x(4)=-4.517541813956818_p
w(4)=2.092714917286605_p
x(5)=-2.313543062862085_p
w(5)=2.044348424017321_p
x(6)=-7.596570426070588e-2_p
w(6)=1.168360415874401_p
x(7)=2.332726442651775_p
w(7)=2.336961677589746e-1_p
x(8)=5.269998192195980_p
w(8)=1.651116193025329e-2_p
x(9)=8.747341060926695_p
w(9)=5.873818327639347e-4_p
x(10)=12.54895754872423_p
w(10)=1.347649228542119e-5_p
x(11)=15.91504059956121_p
w(11)=3.154310193355531e-7_p
else if(N==12)then
x(1)=-8.821002879579643_p
w(1)=4.576743285836083e-1_p
x(2)=-8.071085293800568_p
w(2)=1.033002628226175_p
x(3)=-6.779892658690506_p
w(3)=1.530703384997310_p
x(4)=-5.047590214321394_p
w(4)=1.894802893286419_p
x(5)=-3.026980826196977_p
w(5)=2.001465746627412_p
x(6)=-9.173341140186994e-1_p
w(6)=1.504500590639708_p
x(7)=1.242631219813880_p
w(7)=5.107226051638711e-1_p
x(8)=3.747113117915194_p
w(8)=6.326226295328036e-2_p
x(9)=6.718696750342195_p
w(9)=3.835333416300303e-3_p
x(10)=10.04872884641536_p
w(10)=1.487366950791119e-4_p
x(11)=13.45587858362071_p
w(11)=4.668313297042076e-6_p
x(12)=16.19436423293749_p
w(12)=1.818878871921369e-7_p
else if(N==13)then
x(1)=-8.843308492793911_p
w(1)=4.008487948877087e-1_p
x(2)=-8.185038541674883_p
w(2)=9.088696105045553e-1_p
x(3)=-7.044142368989929_p
w(3)=1.359073406503659_p
x(4)=-5.495284269926136_p
w(4)=1.711846115550769_p
x(5)=-3.651173167921357_p
w(5)=1.893564944931154_p
x(6)=-1.668322101842432_p
w(6)=1.680087955522669_p
x(7)=3.372322994690511e-1_p
w(7)=8.525696509724046e-1_p
x(8)=2.526913383824353_p
w(8)=1.754556345495691e-1_p
x(9)=5.099535173145765_p
w(9)=1.675533948755484e-2_p
x(10)=8.019180085539315_p
w(10)=1.004157545763317e-3_p
x(11)=11.13788088695553_p
w(11)=4.563986237520434e-5_p
x(12)=14.14414623513685_p
w(12)=1.992683485189830e-6_p
x(13)=16.38106557417398_p
w(13)=1.177886793129854e-7_p
else if(N==14)then
x(1)=-8.861698378590914_p
w(1)=3.539501706274550e-1_p
x(2)=-8.279411195030805_p
w(2)=8.054472031927670e-1_p
x(3)=-7.264921337584853_p
w(3)=1.213028884021787_p
x(4)=-5.875003901432941_p
w(4)=1.547587468468440_p
x(5)=-4.194551740064801_p
w(5)=1.762550174534647_p
x(6)=-2.342773597314689_p
w(6)=1.724156024867816_p
x(7)=-4.481980859117656e-1_p
w(7)=1.161116452453452_p
x(8)=1.524515302436253_p
w(8)=3.730701169404985e-1_p
x(9)=3.778356169385260_p
w(9)=5.419070064140224e-2_p
x(10)=6.354820168574310_p
w(10)=4.706591576347643e-3_p
x(11)=9.162559868551687_p
w(11)=3.017848794300208e-4_p
x(12)=12.03726520657851_p
w(12)=1.670500622157816e-5_p
x(13)=14.66763633353045_p
w(13)=1.001012022897620e-6_p
x(14)=16.51089154238768_p
w(14)=8.256805991391941e-8_p
else if(N==15)then
x(1)=-8.877036148741430_p
w(1)=3.148025506285932e-1_p
x(2)=-8.358404810461268_p
w(2)=7.184662208425835e-1_p
x(3)=-7.451011475435118_p
w(3)=1.088199405102591_p
x(4)=-6.198784179363209_p
w(4)=1.401982979068747_p
x(5)=-4.666921537396549_p
w(5)=1.628552889273938_p
x(6)=-2.946336922092324_p
w(6)=1.688529025384057_p
x(7)=-1.150524985537839_p
w(7)=1.369489429259885_p
x(8)=6.772524555812427e-1_p
w(8)=6.344526537805818e-1_p
x(9)=2.681877082636203_p
w(9)=1.373892213345062e-1_p
x(10)=4.969782838715581_p
w(10)=1.669573223245311e-2_p
x(11)=7.495338147502801_p
w(11)=1.451313334226104e-3_p
x(12)=10.15376088974299_p
w(12)=1.041800739031279e-4_p
x(13)=12.7749706339244_p
w(13)=7.129532556059873e-6_p
x(14)=15.06919960412089_p
w(14)=5.697100106530463e-7_p
x(15)=16.60435340009415_p
w(15)=6.123171545170637e-8_p
else if(N==16)then
x(1)=-8.889960449053087_p
w(1)=2.817926216790729e-1_p
x(2)=-8.425163020945245_p
w(2)=6.446761431675339e-1_p
x(3)=-7.609158972733077_p
w(3)=9.809476684516418e-1_p
x(4)=-6.476458742103839_p
w(4)=1.273559973087767_p
x(5)=-5.078005352509086_p
w(5)=1.500438116080913_p
x(6)=-3.484020598476946_p
w(6)=1.612994017910385_p
x(7)=-1.786833428562137_p
w(7)=1.470151029970054_p
x(8)=-6.160837342690587e-2_p
w(8)=8.998647810907512e-1_p
x(9)=1.757173721598244_p
w(9)=2.823724473124188e-1_p
x(10)=3.802530919257728_p
w(10)=4.736866456506790e-2_p
x(11)=6.079719201309745_p
w(11)=5.415921777192089e-3_p
x(12)=8.516512147386470_p
w(12)=4.971434063734766e-4_p
x(13)=11.00532750344143_p
w(13)=4.096428235688713e-5_p
x(14)=13.37906976518835_p
w(14)=3.463961701296303e-6_p
x(15)=15.38087877462383_p
w(15)=3.567126957615363e-7_p
x(16)=16.67366866535826_p
w(16)=4.733442219559995e-8_p
else if(N==17)then
x(1)=-8.900951559653407_p
w(1)=2.537045730939053e-1_p
x(2)=-8.482072078033834_p
w(2)=5.815759157184741e-1_p
x(3)=-7.744589779515189_p
w(3)=8.882960217860805e-1_p
x(4)=-6.715985307252210_p
w(4)=1.160414166685425_p
x(5)=-5.436667685648719_p
w(5)=1.381693668027651_p
x(6)=-3.961722772663888_p
w(6)=1.521007803762163_p
x(7)=-2.364377918395292_p
w(7)=1.490088980102794_p
x(8)=-7.232357673342601e-1_p
w(8)=1.111191408949450_p
x(9)=9.624660445984471e-1_p
w(9)=4.824014614104573e-1_p
x(10)=2.808174583502044_p
w(10)=1.111930795343381e-1_p
x(11)=4.867706748533883_p
w(11)=1.645301344256863e-2_p
x(12)=7.097683002270918_p
w(12)=1.893683758051435e-3_p
x(13)=9.421761269668963_p
w(13)=1.893181490793904e-4_p
x(14)=11.73321853691225_p
w(14)=1.811441247299571e-5_p
x(15)=13.87473149784727_p
w(15)=1.873830140820031e-6_p
x(16)=15.62597201184937_p
w(16)=2.403599173919278e-7_p
x(17)=16.72639931800779_p
w(17)=3.776737785549403e-8_p
else
call GD(-9)
end if
end subroutine GF_m9

! [-8kT;17kT]
subroutine GF_m8(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-5.971707017365154_p
w(1)=4.752841020114531_p
x(2)=-6.083186240833602e-1_p
w(2)=3.247494344858988_p
else if(N==3)then
x(1)=-6.781831696956620_p
w(1)=2.987616005666101_p
x(2)=-2.720541096840488_p
w(2)=4.201201759634405_p
x(3)=1.642559083722088_p
w(3)=8.115175996730124e-1_p
else if(N==4)then
x(1)=-7.163756384464139_p
w(1)=2.087409619930253_p
x(2)=-4.086101169455088_p
w(2)=3.696161903991879_p
x(3)=-3.273472745535432e-1_p
w(3)=2.121964583743865_p
x(4)=4.146861913213069_p
w(4)=9.479925730752314e-2_p
else if(N==5)then
x(1)=-7.377710173703738_p
w(1)=1.567051677788033_p
x(2)=-4.973290747768622_p
w(2)=3.059239620023140_p
x(3)=-1.652010255795663_p
w(3)=2.801708054005383_p
x(4)=1.768685531764978_p
w(4)=5.658432792503003e-1_p
x(5)=6.978178674748532_p
w(5)=6.492733906662589e-3_p
else if(N==6)then
x(1)=-7.513607841067302_p
w(1)=1.231088214338927_p
x(2)=-5.581240541321031_p
w(2)=2.531493869765474_p
x(3)=-2.693812306571378_p
w(3)=2.874557309082085_p
x(4)=3.431902214612960e-1_p
w(4)=1.283359149435152_p
x(5)=4.026507676157831_p
w(5)=7.943578853998491e-2_p
x(6)=9.818734798621946_p
w(6)=4.010338118977832e-4_p
else if(N==7)then
x(1)=-7.608268936418122_p
w(1)=9.947382762148399e-1_p
x(2)=-6.024220521625083_p
w(2)=2.111502676029635_p
x(3)=-3.537376630157953_p
w(3)=2.672508828566447_p
x(4)=-7.475231141661839e-1_p
w(4)=1.882363108493457_p
x(5)=2.226107906597027_p
w(5)=3.305326110934314e-1_p
x(6)=6.339262663847655_p
w(6)=8.655822650375440e-3_p
x(7)=12.22404397051134_p
w(7)=3.404192533428069e-5_p
else if(N==8)then
x(1)=-7.677899345062428_p
w(1)=8.197509458649512e-1_p
x(2)=-6.359693373670651_p
w(2)=1.777111667440969_p
x(3)=-4.221954014833597_p
w(3)=2.391060451591208_p
x(4)=-1.675419879018974_p
w(4)=2.177023886691377_p
x(5)=9.405881885089056e-1_p
w(5)=7.761200081816817e-1_p
x(6)=4.143705885910227_p
w(6)=5.822352865188078e-2_p
x(7)=8.463126913800162_p
w(7)=1.039715752257054e-3_p
x(8)=13.91550231080596_p
w(8)=5.160799195391054e-6_p
else if(N==9)then
x(1)=-7.730676947017248_p
w(1)=6.865222905716567e-1_p
x(2)=-6.619055927749939_p
w(2)=1.510320628604937_p
x(3)=-4.775767088289644_p
w(3)=2.110375307701541_p
x(4)=-2.479243189506716_p
w(4)=2.211701057779074_p
x(5)=-7.379730990054349e-2_p
w(5)=1.261633347563375_p
x(6)=2.581396021884274_p
w(6)=2.100803987412692e-1_p
x(7)=5.998710380471745_p
w(7)=9.539274064212276e-3_p
x(8)=10.26504718796371_p
w(8)=1.617009691265668e-4_p
x(9)=14.9710870606316_p
w(9)=1.358978327309866e-6_p
else if(N==10)then
x(1)=-7.771562357671502_p
w(1)=5.829839667766921e-1_p
x(2)=-6.822812520078077_p
w(2)=1.296250611614509_p
x(3)=-5.224450134296747_p
w(3)=1.857348150983490_p
x(4)=-3.168734288372929_p
w(4)=2.106294285286748_p
x(5)=-9.331489012529177e-1_p
w(5)=1.613727311624107_p
x(6)=1.396842304117728_p
w(6)=4.958660582471473e-1_p
x(7)=4.209759134202808_p
w(7)=4.609605347274569e-2_p
x(8)=7.689244337429928_p
w(8)=1.734217672860082e-3_p
x(9)=11.7120052453425_p
w(9)=3.417837334279666e-5_p
x(10)=15.60904485480141_p
w(10)=5.309218786434829e-7_p
else if(N==11)then
x(1)=-7.803840300586519_p
w(1)=5.010509948324977e-1_p
x(2)=-6.985330524455881_p
w(2)=1.122942010308118_p
x(3)=-5.590189783310617_p
w(3)=1.637682691563856_p
x(4)=-3.754654627947153_p
w(4)=1.946681571343773_p
x(5)=-1.685767847560104_p
w(5)=1.778122535417922_p
x(6)=4.459175079757761e-1_p
w(6)=8.577474943612305e-1_p
x(7)=2.841594740840038_p
w(7)=1.457251631409056e-1_p
x(8)=5.759938355270926_p
w(8)=9.996865889872357e-3_p
x(9)=9.165758156908707_p
w(9)=3.760805755784179e-4_p
x(10)=12.83244932931657_p
w(10)=9.690018336348004e-6_p
x(11)=16.00286132549825_p
w(11)=2.675214297367789e-7_p
else if(N==12)then
x(1)=-7.829752545886711_p
w(1)=4.351594940238319e-1_p
x(2)=-7.116807333402348_p
w(2)=9.811967311043306e-1_p
x(3)=-5.890813429851951_p
w(3)=1.449596123895226_p
x(4)=-4.250799511807596_p
w(4)=1.775860255306484_p
x(5)=-2.348771892939534_p
w(5)=1.797881841203068_p
x(6)=-3.589678220951670e-1_p
w(6)=1.185208874476920_p
x(7)=1.756388895468493_p
w(7)=3.347725092054917e-1_p
x(8)=4.252660222382332_p
w(8)=3.818583387908435e-2_p
x(9)=7.178645460827246_p
w(9)=2.370608643275530e-3_p
x(10)=10.41756390044528_p
w(10)=9.940473302069846e-5_p
x(11)=13.68353799033221_p
w(11)=3.529875588651564e-6_p
x(12)=16.25609657237709_p
w(12)=1.586271981977827e-7_p
else if(N==13)then
x(1)=-7.850862498891559_p
w(1)=3.814058140592301e-1_p
x(2)=-7.224555238979063_p
w(2)=8.640729801506620e-1_p
x(3)=-6.140146443360581_p
w(3)=1.289122335177654_p
x(4)=-4.671287165527650_p
w(4)=1.612132986301904_p
x(5)=-2.930515416951089_p
w(5)=1.735609063503804_p
x(6)=-1.065410570668344_p
w(6)=1.402856694957751_p
x(7)=8.647585415709379e-1_p
w(7)=5.966928099508843e-1_p
x(8)=3.041523836809914_p
w(8)=1.076249406671525e-1_p
x(9)=5.586836438826393_p
w(9)=1.014391972062689e-2_p
x(10)=8.441593454535964_p
w(10)=6.402897566213408e-4_p
x(11)=11.45798328726235_p
w(11)=3.185505843964516e-5_p
x(12)=14.32665593207586_p
w(12)=1.570958217874965e-6_p
x(13)=16.42613708858563_p
w(13)=1.047105714282618e-7_p
else if(N==14)then
x(1)=-7.868284047873020_p
w(1)=3.369961104475136e-1_p
x(2)=-7.313892366580827_p
w(2)=7.663417737231845e-1_p
x(3)=-6.348793483043042_p
w(3)=1.152045258921734_p
x(4)=-5.028877802636505_p
w(4)=1.462210905081525_p
x(5)=-3.438846823706363_p
w(5)=1.635926821887553_p
x(6)=-1.695413705209403_p
w(6)=1.502563524691933_p
x(7)=1.049616690903795e-1_p
w(7)=8.710063573351517e-1_p
x(8)=2.046474101734804_p
w(8)=2.375518239395165e-1_p
x(9)=4.283969814909094_p
w(9)=3.257382231017233e-2_p
x(10)=6.814258105699585_p
w(10)=2.906598097787077e-3_p
x(11)=9.544720277274388_p
w(11)=1.993349658465022e-4_p
x(12)=12.31262839707122_p
w(12)=1.214310180688237e-5_p
x(13)=14.81475157623431_p
w(13)=8.160654373701007e-7_p
x(14)=16.54491622659878_p
w(14)=7.440435808171968e-8_p
else if(N==15)then
x(1)=-7.882827045589676_p
w(1)=2.998920246827246e-1_p
x(2)=-7.388746421493343_p
w(2)=6.840420549707030e-1_p
x(3)=-6.524890927377397_p
w(3)=1.034547276357591_p
x(4)=-5.334427537196742_p
w(4)=1.327730033452815_p
x(5)=-3.882253814287390_p
w(5)=1.523701768046309_p
x(6)=-2.258888478253803_p
w(6)=1.514939524467127_p
x(7)=-5.629425517593257e-1_p
w(7)=1.094188527821390_p
x(8)=1.210468049289195_p
w(8)=4.268729585316606e-1_p
x(9)=3.199736882973973_p
w(9)=8.332366784709705e-2_p
x(10)=5.455934673622052_p
w(10)=1.009910238818480e-2_p
x(11)=7.922036436718543_p
w(11)=9.211955492478621e-4_p
x(12)=10.49606835027996_p
w(12)=7.132391182319076e-5_p
x(13)=13.0109926122037_p
w(13)=5.374256313635119e-6_p
x(14)=15.1888992136115_p
w(14)=4.769603184647385e-7_p
x(15)=16.63078115831798_p
w(15)=5.573021420570531e-8_p
else if(N==16)then
x(1)=-7.895091267814565_p
w(1)=2.685797967975427e-1_p
x(2)=-7.452062130700522_p
w(2)=6.141470799911360e-1_p
x(3)=-6.674714405850434_p
w(3)=9.333737066486713e-1_p
x(4)=-5.596909190170114_p
w(4)=1.208205206577585_p
x(5)=-4.269213806614824_p
w(5)=1.411290728752773_p
x(6)=-2.761957245342068_p
w(6)=1.475072443904685_p
x(7)=-1.161634229913055_p
w(7)=1.235964271901434_p
x(8)=4.905440447926840e-1_p
w(8)=6.456063437535933e-1_p
x(9)=2.284463710475485_p
w(9)=1.760154508844808e-1_p
x(10)=4.308069141179966_p
w(10)=2.838413758936865e-2_p
x(11)=6.539852854254806_p
w(11)=3.338826154266056e-3_p
x(12)=8.908743669911487_p
w(12)=3.253032725644030e-4_p
x(13)=11.31006578230855_p
w(13)=2.902550318155300e-5_p
x(14)=13.58140491341443_p
w(14)=2.694845883643077e-6_p
x(15)=15.47935544437715_p
w(15)=3.049889902185094e-7_p
x(16)=16.69469671525069_p
w(16)=4.340736370608627e-8_p
else if(N==17)then
x(1)=-7.905528363432610_p
w(1)=2.419170051343633e-1_p
x(2)=-7.506078701229883_p
w(2)=5.543212697644858e-1_p
x(3)=-6.803140892685255_p
w(3)=8.458208397091849e-1_p
x(4)=-5.823643490020466_p
w(4)=1.102344095258320_p
x(5)=-4.607589975333663_p
w(5)=1.304354169758851_p
x(6)=-3.210180947221084_p
w(6)=1.408457971029792_p
x(7)=-1.702780795133855_p
w(7)=1.300776127772903_p
x(8)=-1.445624227182290e-1_p
w(8)=8.496391023113086e-1_p
x(9)=1.500319761710670_p
w(9)=3.145285033963945e-1_p
x(10)=3.327790834600997_p
w(10)=6.689611801870984e-2_p
x(11)=5.353449960681362_p
w(11)=9.940744618733365e-3_p
x(12)=7.528499331990928_p
w(12)=1.196654123418585e-3_p
x(13)=9.779812874004785_p
w(13)=1.277731198378965e-4_p
x(14)=12.00365943981962_p
w(14)=1.324952502485487e-5_p
x(15)=14.04865993114645_p
w(15)=1.497618909912601e-6_p
x(16)=15.70792367205597_p
w(16)=2.089761133633032e-7_p
x(17)=16.74347641136127_p
w(17)=3.483716837086469e-8_p
else
call GD(-8)
end if
end subroutine GF_m8

! [-7kT;17kT]
subroutine GF_m7(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-5.160736022548279_p
w(1)=4.287636525090670_p
x(2)=-2.708897469494259e-1_p
w(2)=2.713274899963728_p
else if(N==3)then
x(1)=-5.879292284797354_p
w(1)=2.740747672360502_p
x(2)=-2.166858431510232_p
w(2)=3.668246663580413_p
x(3)=2.027090045054115_p
w(3)=5.919170891134830e-1_p
else if(N==4)then
x(1)=-6.222896027517081_p
w(1)=1.935860123575268_p
x(2)=-3.378266165909356_p
w(2)=3.340713560976192_p
x(3)=1.166536359269868e-1_p
w(3)=1.664784213897694_p
x(4)=4.633044125582289_p
w(4)=5.955352660524307e-2_p
else if(N==5)then
x(1)=-6.417725537003646_p
w(1)=1.463933910758820_p
x(2)=-4.176655349293349_p
w(2)=2.815929640071388_p
x(3)=-1.104223685678832_p
w(3)=2.339586429294920_p
x(4)=2.247657820219903_p
w(4)=3.776758818430997e-1_p
x(5)=7.522162556728443_p
w(5)=3.785563086170645e-3_p
else if(N==6)then
x(1)=-6.542971408303836_p
w(1)=1.155218275761665_p
x(2)=-4.732355125004242_p
w(2)=2.353250071064079_p
x(3)=-2.049841458838613_p
w(3)=2.517461613095290_p
x(4)=8.350007188326999e-1_p
w(4)=9.273026369751436e-1_p
x(5)=4.558790421786641_p
w(5)=4.744412130688696e-2_p
x(6)=10.34301513056628_p
w(6)=2.347068513344095e-4_p
else if(N==7)then
x(1)=-6.631011838215531_p
w(1)=9.359026427047791e-1_p
x(2)=-5.141988584866721_p
w(2)=1.974002397362189_p
x(3)=-2.820088430931061_p
w(3)=2.411320209044603_p
x(4)=-2.118305359532565e-1_p
w(4)=1.466881906825608_p
x(5)=2.742719703329469_p
w(5)=2.077153293487078e-1_p
x(6)=6.869385016462267_p
w(6)=5.067381148605207e-3_p
x(7)=12.64301341648597_p
w(7)=2.155861990583446e-5_p
else if(N==8)then
x(1)=-6.696067488497947_p
w(1)=7.727175836169726e-1_p
x(2)=-5.454119904852670_p
w(2)=1.667570796885193_p
x(3)=-3.450107080181987_p
w(3)=2.195249861657661_p
x(4)=-1.077496479689759_p
w(4)=1.807120486943834_p
x(5)=1.455050528559139_p
w(5)=5.231628925219152e-1_p
x(6)=4.673942208039724_p
w(6)=3.445818570367529e-2_p
x(7)=8.947654428233301_p
w(7)=6.279853857240017e-4_p
x(8)=14.20386541565012_p
w(8)=3.632339422769604e-6_p
else if(N==9)then
x(1)=-6.745497620986552_p
w(1)=6.481362195184688e-1_p
x(2)=-5.696280079979070_p
w(2)=1.421081700030282_p
x(3)=-3.962904853958420_p
w(3)=1.957805646869293_p
x(4)=-1.818714103100167_p
w(4)=1.922500076672055_p
x(5)=4.617117209232151e-1_p
w(5)=9.176550664701579e-1_p
x(6)=3.109935417131366_p
w(6)=1.279782842931635e-1_p
x(7)=6.510085438108853_p
w(7)=5.650224306457351e-3_p
x(8)=10.68237966267819_p
w(8)=1.031627975417541e-4_p
x(9)=15.15831142947061_p
w(9)=1.044096977871918e-6_p
else if(N==10)then
x(1)=-6.783863420275978_p
w(1)=5.511120772439800e-1_p
x(2)=-5.887026717869694_p
w(2)=1.222222631927140_p
x(3)=-4.380339818487441_p
w(3)=1.734437448668849_p
x(4)=-2.454425540018957_p
w(4)=1.886957240194983_p
x(5)=-3.569737984705444e-1_p
w(5)=1.260045795820795_p
x(6)=1.926977031410937_p
w(6)=3.178703558266795e-1_p
x(7)=4.735970998604333_p
w(7)=2.718445957054332e-2_p
x(8)=8.160756709981907_p
w(8)=1.057782864319309e-3_p
x(9)=12.05696108820964_p
w(9)=2.319956336162851e-5_p
x(10)=15.73154542772472_p
w(10)=4.333737467464611e-7_p
else if(N==11)then
x(1)=-6.814203815349297_p
w(1)=4.741915019973248e-1_p
x(2)=-6.039505733291122_p
w(2)=1.060582756618693_p
x(3)=-4.721883163359842_p
w(3)=1.536076758258046_p
x(4)=-2.996785815149571_p
w(4)=1.777260967651484_p
x(5)=-1.060552421692687_p
w(5)=1.471913596407921_p
x(6)=9.884934535396616e-1_p
w(6)=5.875655148282949e-1_p
x(7)=3.375816606708274_p
w(7)=8.712789738494937e-2_p
x(8)=6.263098709558358_p
w(8)=5.945984742506257e-3_p
x(9)=9.587108513021324_p
w(9)=2.392432012025534e-4_p
x(10)=13.11070952136818_p
w(10)=6.976694793840089e-6_p
x(11)=16.08588612911456_p
w(11)=2.272691825742702e-7_p
else if(N==12)then
x(1)=-6.838597177979984_p
w(1)=4.122311593994243e-1_p
x(2)=-6.163092484724718_p
w(2)=9.279734523297131e-1_p
x(3)=-5.003449321322828_p
w(3)=1.363925558543529_p
x(4)=-3.458090845195243_p
w(4)=1.640776936673862_p
x(5)=-1.675743201403371_p
w(5)=1.553718955336555_p
x(6)=2.097912307035459e-1_p
w(6)=8.710521535163581e-1_p
x(7)=2.296581432110104_p
w(7)=2.072505329514899e-1_p
x(8)=4.776071385494067_p
w(8)=2.246470951642204e-2_p
x(9)=7.646245605883527_p
w(9)=1.448922076324275e-3_p
x(10)=10.78604224901396_p
w(10)=6.623232293831372e-5_p
x(11)=13.90581054725779_p
w(11)=2.673989160950641e-6_p
x(12)=16.31471400127888_p
w(12)=1.383986202143074e-7_p
else if(N==13)then
x(1)=-6.858495840836079_p
w(1)=3.616136781192337e-1_p
x(2)=-6.264535706822794_p
w(2)=8.181311220045689e-1_p
x(3)=-5.237529930971327_p
w(3)=1.215761890791830_p
x(4)=-3.850567768011081_p
w(4)=1.501142430818618_p
x(5)=-2.215364251726624_p
w(5)=1.544752467808760_p
x(6)=-4.605170514409148e-1_p
w(6)=1.099796996147352_p
x(7)=1.414783918210400_p
w(7)=3.896350864984812e-1_p
x(8)=3.578029268024760_p
w(8)=6.360666034273633e-2_p
x(9)=6.085821969184561_p
w(9)=6.042118352118016e-3_p
x(10)=8.867757225709287_p
w(10)=4.054299386980345e-4_p
x(11)=11.77585375372094_p
w(11)=2.221067822260332e-5_p
x(12)=14.50433825514015_p
w(12)=1.240505603372172e-6_p
x(13)=16.469128786579_p
w(13)=9.304817526598338e-8_p
else if(N==14)then
x(1)=-6.874936666663841_p
w(1)=3.197439519230318e-1_p
x(2)=-6.348760285252217_p
w(2)=7.262938928304282e-1_p
x(3)=-5.433792294927835_p
w(3)=1.088438398785937_p
x(4)=-4.185393172398310_p
w(4)=1.368760579708207_p
x(5)=-2.688107421182016_p
w(5)=1.484802498107463_p
x(6)=-1.050890133395393_p
w(6)=1.241974181193461_p
x(7)=6.729395161219547e-1_p
w(7)=6.062276821348199e-1_p
x(8)=2.592386054517613_p
w(8)=1.436216042741119e-1_p
x(9)=4.805126430207365_p
w(9)=1.913216416733081e-2_p
x(10)=7.280943342121979_p
w(10)=1.775796320530700e-3_p
x(11)=9.927982170834303_p
w(11)=1.311154529147237e-4_p
x(12)=12.58487633038951_p
w(12)=8.827115464763812e-6_p
x(13)=14.95780716943637_p
w(13)=6.660533616733613e-7_p
x(14)=16.57750698159345_p
w(14)=6.698733584017390e-8_p
else if(N==15)then
x(1)=-6.888674947228501_p
w(1)=2.847245132027595e-1_p
x(2)=-6.419414068523208_p
w(2)=6.488302178099173e-1_p
x(3)=-5.599703277716388_p
w(3)=9.788255807928646e-1_p
x(4)=-4.472220362239609_p
w(4)=1.247536726233966_p
x(5)=-3.101807864270015_p
w(5)=1.401057535291021_p
x(6)=-1.576219891523027_p
w(6)=1.303011455647365_p
x(7)=3.131805723249386e-2_p
w(7)=8.125620446411512e-1_p
x(8)=1.766156126261773_p
w(8)=2.688281340694241e-1_p
x(9)=3.736695426817490_p
w(9)=4.888421664092491e-2_p
x(10)=5.952593806559581_p
w(10)=6.017264000978260e-3_p
x(11)=8.352834803723459_p
w(11)=5.805183217405669e-4_p
x(12)=10.83777142441871_p
w(12)=4.871523203268114e-5_p
x(13)=13.24363761647292_p
w(13)=4.052949512656556e-6_p
x(14)=15.30528195655163_p
w(14)=3.995601680080543e-7_p
x(15)=16.65618919748858_p
w(15)=5.066057192260444e-8_p
else if(N==16)then
x(1)=-6.900271015730552_p
w(1)=2.551435172524474e-1_p
x(2)=-6.479238738704531_p
w(2)=5.829509432927583e-1_p
x(3)=-5.741051662865021_p
w(3)=8.841317966796690e-1_p
x(4)=-4.719128930714355_p
w(4)=1.138362136558449_p
x(5)=-3.463941253742302_p
w(5)=1.309193889804197_p
x(6)=-2.045016090977737_p
w(6)=1.305194716704301_p
x(7)=-5.358519719045531e-1_p
w(7)=9.729941544033768e-1_p
x(8)=1.060099530639593_p
w(8)=4.292950002289913e-1_p
x(9)=2.833230317826320_p
w(9)=1.047204153531488e-1_p
x(10)=4.827350635306481_p
w(10)=1.665292592904779e-2_p
x(11)=7.006850461360462_p
w(11)=2.037146318169966e-3_p
x(12)=9.302863616357035_p
w(12)=2.118431203861370e-4_p
x(13)=11.61318104979519_p
w(13)=2.054125112140954e-5_p
x(14)=13.78044921557536_p
w(14)=2.097604145032484e-6_p
x(15)=15.57515176388952_p
w(15)=2.608056283774976e-7_p
x(16)=16.71497893430556_p
w(16)=3.974856010039248e-8_p
else if(N==17)then
x(1)=-6.910147471612942_p
w(1)=2.299336401956597e-1_p
x(2)=-6.530323530468375_p
w(2)=5.264951911808078e-1_p
x(3)=-5.862354229528465_p
w(3)=8.019766813707550e-1_p
x(4)=-4.932774875515501_p
w(4)=1.040799228792682_p
x(5)=-3.781435953748173_p
w(5)=1.217455905275293_p
x(6)=-2.463408487150588_p
w(6)=1.271087194978589_p
x(7)=-1.044084909830026_p
w(7)=1.074220048125722_p
x(8)=4.446878650425828e-1_p
w(8)=6.002489856694535e-1_p
x(9)=2.059631099769648_p
w(9)=1.928648903438921e-1_p
x(10)=3.864247915118435_p
w(10)=3.906026921612171e-2_p
x(11)=5.848760236551021_p
w(11)=5.921611995948940e-3_p
x(12)=7.963554712223360_p
w(12)=7.507161664172629e-4_p
x(13)=10.13823443304477_p
w(13)=8.596481079940791e-5_p
x(14)=12.27193576879356_p
w(14)=9.685766553642342e-6_p
x(15)=14.21955316269447_p
w(15)=1.197435605469177e-6_p
x(16)=15.78771245768528_p
w(16)=1.816468376327744e-7_p
x(17)=16.7599942404122_p
w(17)=3.208326046776933e-8_p
else
call GD(-7)
end if
end subroutine GF_m7

! [-6kT;17kT]
subroutine GF_m6(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-4.348506532070260_p
w(1)=3.813100709680877_p
x(2)=9.541323108213728e-2_p
w(2)=2.189374934057478_p
else if(N==3)then
x(1)=-4.976713760043598_p
w(1)=2.488214597925167_p
x(2)=-1.607783992086379_p
w(2)=3.105759094686920_p
x(3)=2.458063109370809_p
w(3)=4.085019511262665e-1_p
else if(N==4)then
x(1)=-5.282365076384290_p
w(1)=1.780179787999948_p
x(2)=-2.672698930149487_p
w(2)=2.949516671254655_p
x(3)=5.902785357703345e-1_p
w(3)=1.237122309877281_p
x(4)=5.162674601871790_p
w(4)=3.565687460647115e-2_p
else if(N==5)then
x(1)=-5.458215678239480_p
w(1)=1.357443992013856_p
x(2)=-3.383558756644709_p
w(2)=2.547415630603006_p
x(3)=-5.479449241251632e-1_p
w(3)=1.858318111224497_p
x(4)=2.770770846334690_p
w(4)=2.371628831437436e-1_p
x(5)=8.096624683355270_p
w(5)=2.135026753252111e-3_p
else if(N==6)then
x(1)=-5.572831244161947_p
w(1)=1.076542872527061_p
x(2)=-3.886851705606297_p
w(2)=2.158094878276247_p
x(3)=-1.408886961393671_p
w(3)=2.113881710696417_p
x(4)=1.360387441615260_p
w(4)=6.265880744144833e-1_p
x(5)=5.123753939543318_p
w(5)=2.723271050810966e-2_p
x(6)=10.87637575576978_p
w(6)=1.353973160366356e-4_p
else if(N==7)then
x(1)=-5.654174011694218_p
w(1)=8.748418352430514e-1_p
x(2)=-4.262484168837737_p
w(2)=1.825027300651063_p
x(3)=-2.108840367912176_p
w(3)=2.106104378649679_p
x(4)=3.412976003471693e-1_p
w(4)=1.069807251083888_p
x(5)=3.295185655553857_p
w(5)=1.237802037597479e-1_p
x(6)=7.417433693964341_p
w(6)=2.900997260319468e-3_p
x(7)=13.05228790204626_p
w(7)=1.367709060530367e-5_p
else if(N==8)then
x(1)=-5.714562696888700_p
w(1)=7.239490394816023e-1_p
x(2)=-4.550621262711326_p
w(2)=1.550022433668861_p
x(3)=-2.683987622378942_p
w(3)=1.966585617518508_p
x(4)=-4.754718420131500e-1_p
w(4)=1.411871335165772_p
x(5)=2.003353255010558_p
w(5)=3.299105085470735e-1_p
x(6)=5.228535101275028_p
w(6)=1.975908731909482e-2_p
x(7)=9.439038323224072_p
w(7)=3.750478825032085e-4_p
x(8)=14.47810854566876_p
w(8)=2.574154939229849e-6_p
else if(N==9)then
x(1)=-5.760574569249797_p
w(1)=6.083734466635151e-1_p
x(2)=-4.775095702967344_p
w(2)=1.326035914887155_p
x(3)=-3.154759874566767_p
w(3)=1.782196919877552_p
x(4)=-1.161221263939870_p
w(4)=1.588095006253456_p
x(5)=1.021801969956518_p
w(5)=6.198822804841089e-1_p
x(6)=3.668015830053626_p
w(6)=7.454125881120219e-2_p
x(7)=7.035755058078052_p
w(7)=3.284463301825171e-3_p
x(8)=11.09921117482771_p
w(8)=6.554680550887381e-5_p
x(9)=15.33455708106719_p
w(9)=8.066540308474839e-7_p
else if(N==10)then
x(1)=-5.796369440904694_p
w(1)=5.181235191013466e-1_p
x(2)=-4.952488918744047_p
w(2)=1.143826609400886_p
x(3)=-3.539989813837543_p
w(3)=1.595356788254368_p
x(4)=-1.745588151605677_p
w(4)=1.623470344365057_p
x(5)=2.317483944301281e-1_p
w(5)=9.136596090633249e-1_p
x(6)=2.488259914637196_p
w(6)=1.917771575237421e-1_p
x(7)=5.282038234443626_p
w(7)=1.560735009211249e-2_p
x(8)=8.639293699435465_p
w(8)=6.381649790328406e-4_p
x(9)=12.39749172972702_p
w(9)=1.574608731501975e-5_p
x(10)=15.84681803116134_p
w(10)=3.548711683426112e-7_p
else if(N==11)then
x(1)=-5.824734086912493_p
w(1)=4.464095322350635e-1_p
x(2)=-5.094678915236740_p
w(2)=9.948352049478494e-1_p
x(3)=-3.856568592119103_p
w(3)=1.422865157642014_p
x(4)=-2.244559225413272_p
w(4)=1.572312908578709_p
x(5)=-4.324120798400081e-1_p
w(5)=1.138415891359233_p
x(6)=1.558147888445943_p
w(6)=3.738631474927614e-1_p
x(7)=3.934653325080507_p
w(7)=5.013902694325294e-2_p
x(8)=6.778473098068100_p
w(8)=3.478241948327400e-3_p
x(9)=10.01050112851113_p
w(9)=1.513081490440430e-4_p
x(10)=13.3832029206601_p
w(10)=5.031116552008197e-6_p
x(11)=16.1642991826461_p
w(11)=1.933255473675049e-7_p
else if(N==12)then
x(1)=-5.847579357320504_p
w(1)=3.885292796731158e-1_p
x(2)=-5.210188704695894_p
w(2)=8.720543156785978e-1_p
x(3)=-4.118485947624793_p
w(3)=1.269688366366020_p
x(4)=-2.670408007111420_p
w(4)=1.478993040131959_p
x(5)=-1.005254650103345_p
w(5)=1.267061167067915_p
x(6)=7.971319769816153e-1_p
w(6)=5.906625330450979e-1_p
x(7)=2.864226427440757_p
w(7)=1.216538988995877e-1_p
x(8)=5.316178344404838_p
w(8)=1.291054005608606e-2_p
x(9)=8.120639768052879_p
w(9)=8.763381987543911e-4_p
x(10)=11.15345898397357_p
w(10)=4.401443857908709e-5_p
x(11)=14.12243195398825_p
w(11)=2.029422960497910e-6_p
x(12)=16.37034128894849_p
w(12)=1.207596801541562e-7_p
else if(N==13)then
x(1)=-5.866243960729810_p
w(1)=3.411646158940068e-1_p
x(2)=-5.305184526782811_p
w(2)=7.699985203114948e-1_p
x(3)=-4.336862162598623_p
w(3)=1.135900289145138_p
x(4)=-3.034101675167292_p
w(4)=1.370401809664604_p
x(5)=-1.504997852309234_p
w(5)=1.311347919136998_p
x(6)=1.536830200829489e-1_p
w(6)=7.959465597907034e-1_p
x(7)=1.991397820167872_p
w(7)=2.375286216630737e-1_p
x(8)=4.135344711238260_p
w(8)=3.637065370271509e-2_p
x(9)=6.595530809671561_p
w(9)=3.545057827590732e-3_p
x(10)=9.296951454941004_p
w(10)=2.550587730009564e-4_p
x(11)=12.09098292563191_p
w(11)=1.547414587873483e-5_p
x(12)=14.67708439919814_p
w(12)=9.810551697756437e-7_p
x(13)=16.5101211353546_p
w(13)=8.262797948923753e-8_p
else if(N==14)then
x(1)=-5.881686042830567_p
w(1)=3.019277557614656e-1_p
x(2)=-5.384185635762064_p
w(2)=6.844337717010391e-1_p
x(3)=-4.520392279419185_p
w(3)=1.019771289190710_p
x(4)=-3.345449712073794_p
w(4)=1.260602293368406_p
x(5)=-1.942627320214772_p
w(5)=1.297516522955828_p
x(6)=-4.042180975261833e-1_p
w(6)=9.538410528021013e-1_p
x(7)=1.262557870616806_p
w(7)=3.893069592111764e-1_p
x(8)=3.162197510658343_p
w(8)=8.290306897926664e-2_p
x(9)=5.340660564576276_p
w(9)=1.100591612877729e-2_p
x(10)=7.754105035126173_p
w(10)=1.074077931676212e-3_p
x(11)=10.31176283564209_p
w(11)=8.591387746235072e-5_p
x(12)=12.85366562947147_p
w(12)=6.417446942117721e-6_p
x(13)=15.09677203852764_p
w(13)=5.441444092394111e-7_p
x(14)=16.60871575473604_p
w(14)=6.023909369239976e-8_p
else if(N==15)then
x(1)=-5.894605158110733_p
w(1)=2.690680417224676e-1_p
x(2)=-5.450551606363026_p
w(2)=6.120963742349088e-1_p
x(3)=-4.675846612491133_p
w(3)=9.190759125431475e-1_p
x(4)=-3.612956199243196_p
w(4)=1.156213604348794_p
x(5)=-2.326321692256445_p
w(5)=1.249711792613979_p
x(6)=-8.956807467462161e-1_p
w(6)=1.051583834037455_p
x(7)=6.399103105172381e-1_p
w(7)=5.537794730006718e-1_p
x(8)=2.346554337484910_p
w(8)=1.591501427667156e-1_p
x(9)=4.291529996027817_p
w(9)=2.786068501294859e-2_p
x(10)=6.458844836328076_p
w(10)=3.535767453565972e-3_p
x(11)=8.787105123525210_p
w(11)=3.633746203588916e-4_p
x(12)=11.17841758154985_p
w(12)=3.320266315833583e-5_p
x(13)=13.47268590752662_p
w(13)=3.057876408878504e-6_p
x(14)=15.4183513989461_p
w(14)=3.348598149751250e-7_p
x(15)=16.68061166209863_p
w(15)=4.598395984859064e-8_p
else if(N==16)then
x(1)=-5.905521355629742_p
w(1)=2.412797420295294e-1_p
x(2)=-5.506815204964638_p
w(2)=5.504598156644394e-1_p
x(3)=-4.808507265164992_p
w(3)=8.316202174850581e-1_p
x(4)=-3.843805564993367_p
w(4)=1.059934852610027_p
x(5)=-2.663068785622413_p
w(5)=1.184871884127874_p
x(6)=-1.332213623877299_p
w(6)=1.095052042436891_p
x(7)=9.706142718946380e-2_p
w(7)=7.039420522115427e-1_p
x(8)=1.652057463607354_p
w(8)=2.645075982655932e-1_p
x(9)=3.402822680572798_p
w(9)=5.983436698846711e-2_p
x(10)=5.359244654191202_p
w(10)=9.588308143113388e-3_p
x(11)=7.479997553023727_p
w(11)=1.231009962563505e-3_p
x(12)=9.698361832947208_p
w(12)=1.373398868493332e-4_p
x(13)=11.91433422705383_p
w(13)=1.452111695323004e-5_p
x(14)=13.97606769734582_p
w(14)=1.633463890689419e-6_p
x(15)=15.66828452590706_p
w(15)=2.230085671914634e-7_p
x(16)=16.73453829345325_p
w(16)=3.633699488847892e-8_p
else if(N==17)then
x(1)=-5.914827571035133_p
w(1)=2.175736737823369e-1_p
x(2)=-5.554911510836621_p
w(2)=4.975547823047875e-1_p
x(3)=-4.922516481875809_p
w(3)=7.554327897783376e-1_p
x(4)=-4.043971876439452_p
w(4)=9.725046625542232e-1_p
x(5)=-2.959087626792253_p
w(5)=1.113403963242604_p
x(6)=-1.721409594491528_p
w(6)=1.098076811051094_p
x(7)=-3.837461577357560e-1_p
w(7)=8.207090024152781e-1_p
x(8)=1.051362896174806_p
w(8)=3.890199339222364e-1_p
x(9)=2.641338897818205_p
w(9)=1.119572396714483e-1_p
x(10)=4.416288315035626_p
w(10)=2.222702457101349e-2_p
x(11)=6.352765696752149_p
w(11)=3.482112958432744e-3_p
x(12)=8.402276934049667_p
w(12)=4.677588046685489e-4_p
x(13)=10.49661763873252_p
w(13)=5.766679027919035e-5_p
x(14)=12.53780042631333_p
w(14)=7.076879597343821e-6_p
x(15)=14.38733129867579_p
w(15)=9.576994177403166e-7_p
x(16)=15.86535854654136_p
w(16)=1.578190991783942e-7_p
x(17)=16.77596863391981_p
w(17)=2.949350067032241e-8_p
else
call GD(-6)
end if
end subroutine GF_m6

! [-5kT;17kT]
subroutine GF_m5(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-3.535017871741132_p
w(1)=3.320501845594580_p
x(2)=4.997370350224848e-1_p
w(2)=1.686213461495162_p
else if(N==3)then
x(1)=-4.074544897288176_p
w(1)=2.223277761357275_p
x(2)=-1.038053498252300_p
w(2)=2.518957997038584_p
x(3)=2.942715876327482_p
w(3)=2.644795486938820e-1_p
else if(N==4)then
x(1)=-4.342588303525332_p
w(1)=1.615563637252474_p
x(2)=-1.968546297611719_p
w(2)=2.511749525872498_p
x(3)=1.103895555761758_p
w(3)=8.591012008402560e-1_p
x(4)=5.738400156210354_p
w(4)=2.030094312451329e-2_p
else if(N==5)then
x(1)=-4.499531323777837_p
w(1)=1.244025916959549_p
x(2)=-2.594787783534664_p
w(2)=2.239640762228942_p
x(3)=2.635492317727904e-2_p
w(3)=1.382132259975742_p
x(4)=3.341609010277830_p
w(4)=1.397515945939500e-1_p
x(5)=8.701127611923608_p
w(5)=1.164773331559137e-3_p
else if(N==6)then
x(1)=-4.603450255638870_p
w(1)=9.923927563563836e-1_p
x(2)=-3.045769728660483_p
w(2)=1.934267068862402_p
x(3)=-7.654138244193570e-1_p
w(3)=1.671990971789200_p
x(4)=1.927062392921544_p
w(4)=3.929470453085747e-1_p
x(5)=5.720851165828101_p
w(5)=1.504028355094573e-2_p
x(6)=11.41506626774724_p
w(6)=7.718122223564442e-5_p
else if(N==7)then
x(1)=-4.677947280942514_p
w(1)=8.095128733795091e-1_p
x(2)=-3.386623111543129_p
w(2)=1.655616319967001_p
x(3)=-1.401614009193910_p
w(3)=1.749168694802099_p
x(4)=9.224311943112791e-1_p
w(4)=7.206990466883927e-1_p
x(5)=3.884018934639788_p
w(5)=7.008397885302270e-2_p
x(6)=7.982128154900784_p
w(6)=1.625684029625207e-3_p
x(7)=13.44894697910301_p
w(7)=8.709370092779196e-6_p
else if(N==8)then
x(1)=-4.733531818538633_p
w(1)=6.718289437120512e-1_p
x(2)=-3.649961318717935_p
w(2)=1.417685815458907_p
x(3)=-1.923488951157736_p
w(3)=1.691455223719599_p
x(4)=1.401730096242650e-1_p
w(4)=1.019994728187005_p
x(5)=2.589256960152549_p
w(5)=1.945302409323319e-1_p
x(6)=5.806509186456331_p
w(6)=1.099682518044493e-2_p
x(7)=9.935816580868122_p
w(7)=2.216924025500095e-4_p
x(8)=14.73749956041269_p
w(8)=1.837496852667353e-6_p
else if(N==9)then
x(1)=-4.776024059328290_p
w(1)=5.659217517138125e-1_p
x(2)=-3.856131977312620_p
w(2)=1.219973635639544_p
x(3)=-2.352005839952042_p
w(3)=1.570033259647819_p
x(4)=-5.006147796613488e-1_p
w(4)=1.220787536137882_p
x(5)=1.614303075016683_p
w(5)=3.864292924572399e-1_p
x(6)=4.254969423322398_p
w(6)=4.165216242212939e-2_p
x(7)=7.574669245691359_p
w(7)=1.875533180107735e-3_p
x(8)=11.51427050129142_p
w(8)=4.150941242994385e-5_p
x(9)=15.49996792730105_p
w(9)=6.264787758927377e-7_p
else if(N==10)then
x(1)=-4.809174048122607_p
w(1)=4.829327640827217e-1_p
x(2)=-4.019715053511936_p
w(2)=1.056978843400452_p
x(3)=-2.704300204458499_p
w(3)=1.428616616613650_p
x(4)=-1.039252359259697_p
w(4)=1.312532102435601_p
x(5)=8.428498567493744e-1_p
w(5)=6.072257688369722e-1_p
x(6)=3.081805225432900_p
w(6)=1.092971477331923e-1_p
x(7)=5.846835576142517_p
w(7)=8.739999341405638e-3_p
x(8)=9.123847899371283_p
w(8)=3.810819526259523e-4_p
x(9)=12.7327433874016_p
w(9)=1.069132025939549e-5_p
x(10)=15.955123531301_p
w(10)=2.913728609544157e-7_p
else if(N==11)then
x(1)=-4.835507509170512_p
w(1)=4.167930419878392e-1_p
x(2)=-4.151274311244299_p
w(2)=9.224324296189901e-1_p
x(3)=-2.995145739945243_p
w(3)=1.288756734439566_p
x(4)=-1.497048343775336_p
w(4)=1.320656088876284_p
x(5)=2.074781802051552e-1_p
w(5)=8.070324585443536e-1_p
x(6)=2.159400745642563_p
w(6)=2.210662872177409e-1_p
x(7)=4.516957489430439_p
w(7)=2.787622297306577e-2_p
x(8)=7.305095168387181_p
w(8)=2.003057118489370e-3_p
x(9)=10.43507185746337_p
w(9)=9.518734869920488e-5_p
x(10)=13.64946759887544_p
w(10)=3.634371793569209e-6_p
x(11)=16.23829966022908_p
w(11)=1.645929202690663e-7_p
else if(N==12)then
x(1)=-4.856762170193977_p
w(1)=3.632772757631964e-1_p
x(2)=-4.258447205835732_p
w(2)=8.107759057400976e-1_p
x(3)=-3.236742883797295_p
w(3)=1.159454513943936_p
x(4)=-1.887895154902632_p
w(4)=1.277309509257562_p
x(5)=-3.311291421813251e-1_p
w(5)=9.526075121597792e-1_p
x(6)=1.410840230761335_p
w(6)=3.673897950549504e-1_p
x(7)=3.459040096922792_p
w(7)=6.808295843192665e-2_p
x(8)=5.871841317882730_p
w(8)=7.262192557576345e-3_p
x(9)=8.601008563263582_p
w(9)=5.248127733320052e-4_p
x(10)=11.51915375023088_p
w(10)=2.918307763762948e-5_p
x(11)=14.33319846450244_p
w(11)=1.542993671260868e-6_p
x(12)=16.42310975174888_p
w(12)=1.053360763770981e-7_p
else if(N==13)then
x(1)=-4.874159530935898_p
w(1)=3.193897022069058e-1_p
x(2)=-4.346794859852993_p
w(2)=7.174667436652071e-1_p
x(3)=-3.438862978031859_p
w(3)=1.043568978814182_p
x(4)=-2.222514669926330_p
w(4)=1.207461342328724_p
x(5)=-7.958898583385648e-1_p
w(5)=1.035851633269110_p
x(6)=7.862561751518177e-1_p
w(6)=5.246996242811713e-1_p
x(7)=2.596614438349691_p
w(7)=1.358580344545366e-1_p
x(8)=4.712169798243294_p
w(8)=2.019730334078782e-2_p
x(9)=7.115067821796652_p
w(9)=2.050831470054876e-3_p
x(10)=9.728496643985082_p
w(10)=1.594888860975714e-4_p
x(11)=12.40291224534843_p
w(11)=1.077417839839270e-5_p
x(12)=14.84482927705707_p
w(12)=7.768959433183161e-7_p
x(13)=16.54919846865646_p
w(13)=7.329862293379925e-8_p
else if(N==14)then
x(1)=-4.888576592765336_p
w(1)=2.829654915319358e-1_p
x(2)=-4.420415214647007_p
w(2)=6.389027718588254e-1_p
x(3)=-3.609216683504404_p
w(3)=9.411977435372586e-1_p
x(4)=-2.509846764056953_p
w(4)=1.126938939863172_p
x(5)=-1.200809275744560_p
w(5)=1.065927742091835_p
x(6)=2.527363577102221e-1_p
w(6)=6.670166728333786e-1_p
x(7)=1.878942600489547_p
w(7)=2.308827313267768e-1_p
x(8)=3.754959795677915_p
w(8)=4.596582961183369e-2_p
x(9)=5.889471531332369_p
w(9)=6.212607410801547e-3_p
x(10)=8.233027352978032_p
w(10)=6.435162877511356e-4_p
x(11)=10.69552355837825_p
w(11)=5.609551769398655e-5_p
x(12)=13.11870119536807_p
w(12)=4.666261224349908e-6_p
x(13)=15.23164545019264_p
w(13)=4.448673028533251e-7_p
x(14)=16.63859729074084_p
w(14)=5.408995183087811e-8_p
else if(N==15)then
x(1)=-4.900655469913684_p
w(1)=2.524116892997021e-1_p
x(2)=-4.482368524243145_p
w(2)=5.722557386784680e-1_p
x(3)=-3.753858246616871_p
w(3)=8.513127876259614e-1_p
x(4)=-2.757459759046669_p
w(4)=1.044700227629698_p
x(5)=-1.555384339332795_p
w(5)=1.057993428021888_p
x(6)=-2.112435152289771e-1_p
w(6)=7.767299439307888e-1_p
x(7)=1.270412803353901_p
w(7)=3.443097212886783e-1_p
x(8)=2.952105875622860_p
w(8)=8.921861689998496e-2_p
x(9)=4.862925741707570_p
w(9)=1.548097720353270e-2_p
x(10)=6.973852947367082_p
w(10)=2.050952395837659e-3_p
x(11)=9.224267790140193_p
w(11)=2.260087241821900e-4_p
x(12)=11.51759911644177_p
w(12)=2.258508531240424e-5_p
x(13)=13.69795940467724_p
w(13)=2.307964419951334e-6_p
x(14)=15.52813231329629_p
w(14)=2.806763817349273e-7_p
x(15)=16.70408491282981_p
w(15)=4.166490571480144e-8_p
else if(N==16)then
x(1)=-4.910874704303017_p
w(1)=2.265364547531714e-1_p
x(2)=-4.534970745176055_p
w(2)=5.153068799288381e-1_p
x(3)=-3.877544721054766_p
w(3)=7.725184762998362e-1_p
x(4)=-2.971723340524432_p
w(4)=9.653983454457332e-1_p
x(5)=-1.866838803896806_p
w(5)=1.026122409631526_p
x(6)=-6.197172194038411e-1_p
w(6)=8.480656337526585e-1_p
x(7)=7.454494712129111e-1_p
w(7)=4.615857410311748e-1_p
x(8)=2.269271227711791_p
w(8)=1.518866776934295e-1_p
x(9)=3.992008262823719_p
w(9)=3.302935266492654e-2_p
x(10)=5.902707293491034_p
w(10)=5.427783152677965e-3_p
x(11)=7.958644339191736_p
w(11)=7.371406731663672e-4_p
x(12)=10.09477378583831_p
w(12)=8.866131908557639e-5_p
x(13)=12.21322888263708_p
w(13)=1.025455591015480e-5_p
x(14)=14.16815960921931_p
w(14)=1.272410583859491e-6_p
x(15)=15.7587857591845_p
w(15)=1.906239113416392e-7_p
x(16)=16.7533995813116_p
w(16)=3.315311266172639e-8_p
else if(N==17)then
x(1)=-4.919596673395155_p
w(1)=2.044344154494495e-1_p
x(2)=-4.579997079987207_p
w(2)=4.663093122140946e-1_p
x(3)=-3.984028694085104_p
w(3)=7.033882336844102e-1_p
x(4)=-3.157952866335644_p
w(4)=8.912080151570207e-1_p
x(5)=-2.141112061857589_p
w(5)=9.808514626234361e-1_p
x(6)=-9.820926806950053e-1_p
w(6)=8.842496373383216e-1_p
x(7)=2.857338994182127e-1_p
w(7)=5.680158114656568e-1_p
x(8)=1.680936509610899_p
w(8)=2.315057057614618e-1_p
x(9)=3.244994855209670_p
w(9)=6.202705975511936e-2_p
x(10)=4.982640370282302_p
w(10)=1.236819598156609e-2_p
x(11)=6.864683576037640_p
w(11)=2.023214529501173e-3_p
x(12)=8.844147419249161_p
w(12)=2.895699457449425e-4_p
x(13)=10.85459741761632_p
w(13)=3.857525966516273e-5_p
x(14)=12.80104489180894_p
w(14)=5.167814259175836e-6_p
x(15)=14.5519419779839_p
w(15)=7.660371406084552e-7_p
x(16)=15.94089343640813_p
w(16)=1.370165012476928e-7_p
x(17)=16.79141693284878_p
w(17)=2.705639260607932e-8_p
else
call GD(-5)
end if
end subroutine GF_m5

! [-4kT;17kT]
subroutine GF_m4(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-2.719502851640109_p
w(1)=2.798291069198396_p
x(2)=9.542593674731112e-1_p
w(2)=1.219858817320037_p
else if(N==3)then
x(1)=-3.173103658792604_p
w(1)=1.934740887147321_p
x(2)=-4.483608571412800e-1_p
w(2)=1.924052328235087_p
x(3)=3.488428165261347_p
w(3)=1.593566711360256e-1_p
else if(N==4)then
x(1)=-3.404012679708831_p
w(1)=1.433310015125823_p
x(2)=-1.261812852503952_p
w(2)=2.024161758211770_p
x(3)=1.668968575360930_p
w(3)=5.497140547428843e-1_p
x(4)=6.363014764420148_p
w(4)=1.096405843795670e-2_p
else if(N==5)then
x(1)=-3.542075975393447_p
w(1)=1.116964861820356_p
x(2)=-1.809451646501317_p
w(2)=1.878088897821206_p
x(3)=6.316203339529751e-1_p
w(3)=9.452605060475613e-1_p
x(4)=3.962684489931785_p
w(4)=7.722079441429887e-2_p
x(5)=9.334685207086537_p
w(5)=6.148264150109638e-4_p
else if(N==6)then
x(1)=-3.635141086501107_p
w(1)=8.975664472695762e-1_p
x(2)=-2.209359219167381_p
w(2)=1.665792752204847_p
x(3)=-1.090844534899105e-1_p
w(3)=1.218951817343886_p
x(4)=2.541165200501825_p
w(4)=2.277944521284710e-1_p
x(5)=6.349422484220991_p
w(5)=8.000823943494167e-3_p
x(6)=11.95478446767023_p
w(6)=4.359362815901112e-5_p
else if(N==7)then
x(1)=-3.702569204920164_p
w(1)=7.358120004233369e-1_p
x(2)=-2.514998127354546_p
w(2)=1.451698593276608_p
x(3)=-6.921904815411190e-1_p
w(3)=1.348091957247782_p
x(4)=1.542153333588048_p
w(4)=4.438469035447241e-1_p
x(5)=4.509050127672887_p
w(5)=3.780232599023801e-2_p
x(6)=8.562172889254878_p
w(6)=8.925300706677941e-4_p
x(7)=13.83034282116136_p
w(7)=5.575965076616892e-6_p
else if(N==8)then
x(1)=-3.753162581854844_p
w(1)=6.130378110177470e-1_p
x(2)=-2.752806739476064_p
w(2)=1.258912322110719_p
x(3)=-1.165657772647944_p
w(3)=1.362639081348454_p
x(4)=7.816243320315487e-1_p
w(4)=6.699354736635510e-1_p
x(5)=3.214652095860036_p
w(5)=1.075458099739829e-1_p
x(6)=6.406934352962145_p
w(6)=5.948254067279830e-3_p
x(7)=10.4365252205975_p
w(7)=1.298131034111627e-4_p
x(8)=14.98161155114939_p
w(8)=1.321233289199877e-6_p
else if(N==9)then
x(1)=-3.791997635113779_p
w(1)=5.180426764120589e-1_p
x(2)=-2.940023591494531_p
w(2)=1.093392283920725_p
x(3)=-1.553616192953771_p
w(3)=1.307670694867502_p
x(4)=1.736017810436488e-1_p
w(4)=8.534672507897656e-1_p
x(5)=2.244999091462228_p
w(5)=2.220960145672767e-1_p
x(6)=4.869819056627178_p
w(6)=2.240140517079740e-2_p
x(7)=8.125846404799901_p
w(7)=1.052854442422246e-3_p
x(8)=11.92635323530509_p
w(8)=2.621751301087206e-5_p
x(9)=15.65481548867529_p
w(9)=4.888348749840782e-7_p
else if(N==10)then
x(1)=-3.822400976294866_p
w(1)=4.432446691746639e-1_p
x(2)=-3.089271343224711_p
w(2)=9.539054549356774e-1_p
x(3)=-1.873222827628764_p
w(3)=1.219351669488375_p
x(4)=-3.280871821339356e-1_p
w(4)=9.703959541781487e-1_p
x(5)=1.485809691247318_p
w(5)=3.670864291159106e-1_p
x(6)=3.707416031540174_p
w(6)=5.915197366301474e-2_p
x(7)=6.429341888659124_p
w(7)=4.780865015120862e-3_p
x(8)=9.613478216896436_p
w(8)=2.253671360942610e-4_p
x(9)=13.06196980914081_p
w(9)=7.264075063392301e-6_p
x(10)=16.05676713820021_p
w(10)=2.397363642780047e-7_p
else if(N==11)then
x(1)=-3.846626154725377_p
w(1)=3.833921106172001e-1_p
x(2)=-3.209783920046698_p
w(2)=8.369534594783868e-1_p
x(3)=-2.138014154869203_p
w(3)=1.119904655278464_p
x(4)=-7.498691022232570e-1_p
w(4)=1.023237245285769_p
x(5)=8.700670634862682e-1_p
w(5)=5.163495347932150e-1_p
x(6)=2.794448664104065_p
w(6)=1.220916111010745e-1_p
x(7)=5.121498395483123_p
w(7)=1.502249697832730e-2_p
x(8)=7.842107699235981_p
w(8)=1.136415495340364e-3_p
x(9)=10.86003581583362_p
w(9)=5.958745883227365e-5_p
x(10)=13.90914427735598_p
w(10)=2.629857469261780e-6_p
x(11)=16.30810435956047_p
w(11)=1.401743549602990e-7_p
else if(N==12)then
x(1)=-3.866230668896734_p
w(1)=3.347987809223056e-1_p
x(2)=-3.308291397478205_p
w(2)=7.387720587969057e-1_p
x(3)=-2.358796942057576_p
w(3)=1.021078399203200_p
x(4)=-1.108275497169841_p
w(4)=1.027379912984780_p
x(5)=3.566170765252094e-1_p
w(5)=6.453700340457114e-1_p
x(6)=2.056573454302586_p
w(6)=2.098778162788148e-1_p
x(7)=4.079975899866037_p
w(7)=3.653689370768356e-2_p
x(8)=6.442059776749377_p
w(8)=4.004077887154765e-3_p
x(9)=9.086626210945496_p
w(9)=3.113368418753118e-4_p
x(10)=11.88255276521687_p
w(10)=1.930904145549427e-5_p
x(11)=14.53798560351494_p
w(11)=1.174998856905951e-6_p
x(12)=16.47315998744177_p
w(12)=9.180968971790290e-8_p
else if(N==13)then
x(1)=-3.882314094950068_p
w(1)=2.948327445578559e-1_p
x(2)=-3.389730383038656_p
w(2)=6.559974120448810e-1_p
x(3)=-2.544155079166840_p
w(3)=9.283556379790430e-1_p
x(4)=-1.414847712498608_p
w(4)=9.998623853227360e-1_p
x(5)=-8.033256731513552e-2_p
w(5)=7.401172394795159e-1_p
x(6)=1.445817689344254_p
w(6)=3.133174889206136e-1_p
x(7)=3.230617238231398_p
w(7)=7.346340018270885e-2_p
x(8)=5.307246166085408_p
w(8)=1.092563751699330e-2_p
x(9)=7.643664811943069_p
w(9)=1.170610753437511e-3_p
x(10)=10.16180092487852_p
w(10)=9.915172566792637e-5_p
x(11)=12.71126630295188_p
w(11)=7.497266911467523e-6_p
x(12)=15.00756435080558_p
w(12)=6.158407527662175e-7_p
x(13)=16.58645130848278_p
w(13)=6.492731620551927e-8_p
else if(N==14)then
x(1)=-3.895669025404715_p
w(1)=2.615806665847974e-1_p
x(2)=-3.457761948369652_p
w(2)=5.858190743232576e-1_p
x(3)=-2.700873139343931_p
w(3)=8.438472358860678e-1_p
x(4)=-1.678387241134505_p
w(4)=9.543130912908088e-1_p
x(5)=-4.573779266960314e-1_p
w(5)=7.979091840918926e-1_p
x(6)=9.298342905972991e-1_p
w(6)=4.188553445944402e-1_p
x(7)=2.524705903559907_p
w(7)=1.273422114657492e-1_p
x(8)=4.369336299778803_p
w(8)=2.461473068224386e-2_p
x(9)=6.450615087967546_p
w(9)=3.445983282793259e-3_p
x(10)=8.717099083562342_p
w(10)=3.820580974512631e-4_p
x(11)=11.07880894649823_p
w(11)=3.650085222438466e-5_p
x(12)=13.3797608243494_p
w(12)=3.393055565906038e-6_p
x(13)=15.36246651534151_p
w(13)=3.638340053883536e-7_p
x(14)=16.667211000081_p
w(14)=4.847713559743280e-8_p
else if(N==15)then
x(1)=-3.906877813386895_p
w(1)=2.336274635330130e-1_p
x(2)=-3.515135049438242_p
w(2)=5.259535066915785e-1_p
x(3)=-2.834304686506874_p
w(3)=7.679675983368788e-1_p
x(4)=-1.905949070594755_p
w(4)=9.000719711685043e-1_p
x(5)=-7.857174164308418e-1_p
w(5)=8.234851382229458e-1_p
x(6)=4.864108705004905e-1_p
w(6)=5.136725484382323e-1_p
x(7)=1.928371288416705_p
w(7)=1.958812528225766e-1_p
x(8)=3.582015318245628_p
w(8)=4.774818224358492e-2_p
x(9)=5.449677467051663_p
w(9)=8.409977468649237e-3_p
x(10)=7.496917574240392_p
w(10)=1.175192858834775e-3_p
x(11)=9.663834601552965_p
w(11)=1.397069997702713e-4_p
x(12)=11.85498538546164_p
w(12)=1.533259802926848e-5_p
x(13)=13.91934062230186_p
w(13)=1.742256737087102e-6_p
x(14)=15.63467808831186_p
w(14)=2.352083910604352e-7_p
x(15)=16.726649017513_p
w(15)=3.767070752615648e-8_p
else if(N==16)then
x(1)=-3.916375812167204_p
w(1)=2.099097498275486e-1_p
x(2)=-3.563939753889705_p
w(2)=4.745654739601531e-1_p
x(3)=-2.948680405717435_p
w(3)=7.003352107343845e-1_p
x(4)=-2.103311135473348_p
w(4)=8.429785666840134e-1_p
x(5)=-1.073406872660992_p
w(5)=8.244954084794216e-1_p
x(6)=1.001624357003887e-1_p
w(6)=5.893259072115702e-1_p
x(7)=1.417203595217956_p
w(7)=2.732391709293942e-1_p
x(8)=2.912422837390038_p
w(8)=8.206948396333327e-2_p
x(9)=4.599397965911445_p
w(9)=1.770305875619137e-2_p
x(10)=6.456858177533810_p
w(10)=3.024874583552434e-3_p
x(11)=8.442250047325006_p
w(11)=4.375649628052004e-4_p
x(12)=10.49171735011151_p
w(12)=5.699881798214295e-5_p
x(13)=12.50963751199111_p
w(13)=7.233389624728028e-6_p
x(14)=14.35667329841046_p
w(14)=9.912119420305163e-7_p
x(15)=15.84670868039564_p
w(15)=1.628280087536604e-7_p
x(16)=16.77159060142809_p
w(16)=3.017850789017443e-8_p
else if(N==17)then
x(1)=-3.924493603245919_p
w(1)=1.896166823170283e-1_p
x(2)=-3.605784527433604_p
w(2)=4.301839666472278e-1_p
x(3)=-3.047356236290886_p
w(3)=6.402377083777250e-1_p
x(4)=-2.275241024684652_p
w(4)=7.864448863477127e-1_p
x(5)=-1.326618148437912_p
w(5)=8.085216883042513e-1_p
x(6)=-2.397097871737733e-1_p
w(6)=6.426557472956748e-1_p
x(7)=9.732851860782241e-1_p
w(7)=3.517308427394866e-1_p
x(8)=2.336363272658514_p
w(8)=1.275867430352906e-1_p
x(9)=3.869382580313264_p
w(9)=3.305390806496680e-2_p
x(10)=5.562177683250090_p
w(10)=6.747006213608200e-3_p
x(11)=7.383867476869423_p
w(11)=1.162313185711751e-3_p
x(12)=9.288740306547188_p
w(12)=1.781349779815974e-4_p
x(13)=11.21188319032775_p
w(13)=2.573174236896900e-5_p
x(14)=13.06152070941084_p
w(14)=3.771061788464317e-6_p
x(15)=14.7133723119293_p
w(15)=6.126191480833291e-7_p
x(16)=16.0143648127325_p
w(16)=1.188275562536830e-7_p
x(17)=16.80635896212776_p
w(17)=2.476090625856882e-8_p
else
call GD(-4)
end if
end subroutine GF_m4

! [-3kT;17kT]
subroutine GF_m3(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-1.899034379121886_p
w(1)=2.236576719160609_p
x(2)=1.474520949701195_p
w(2)=8.120105910137567e-1_p
else if(N==3)then
x(1)=-2.271821225599189_p
w(1)=1.607437579471288_p
x(2)=1.758548587253503e-1_p
w(2)=1.352433870417437_p
x(3)=4.102640611031021_p
w(3)=8.871586028564005e-2_p
else if(N==4)then
x(1)=-2.466680826497430_p
w(1)=1.219762176645035_p
x(2)=-5.429327694653978e-1_p
w(2)=1.503049667405473_p
x(3)=2.296811464700477_p
w(3)=3.201744840854957e-1_p
x(4)=7.039660752846113_p
w(4)=5.600982038361931e-3_p
else if(N==5)then
x(1)=-2.586041245375145_p
w(1)=9.649155943483673e-1_p
x(2)=-1.022515796077967_p
w(2)=1.459497224678681_p
x(3)=1.282840268690223_p
w(3)=5.838329707119136e-1_p
x(4)=4.635736917522646_p
w(4)=4.002734896685762e-2_p
x(5)=9.995605698651211_p
w(5)=3.141714685458126e-4_p
else if(N==6)then
x(1)=-2.668093496229122_p
w(1)=7.828242959858882e-1_p
x(2)=-1.375187905802512_p
w(2)=1.339507914407227_p
x(3)=5.751808609868591e-1_p
w(3)=8.000469415400008e-1_p
x(4)=3.206751428310824_p
w(4)=1.220815250464284e-1_p
x(5)=7.008891347956487_p
w(5)=4.102166204831947e-3_p
x(6)=12.49080211274873_p
w(6)=2.446698998924507e-5_p
else if(N==7)then
x(1)=-2.728206767592039_p
w(1)=6.461578093165402e-1_p
x(2)=-1.646551347865196_p
w(2)=1.197174396624884_p
x(3)=3.147402935700791e-2_p
w(3)=9.365793417299452e-1_p
x(4)=2.209130254369711_p
w(4)=2.487191558633846e-1_p
x(5)=5.169890215658846_p
w(5)=1.947265027016257e-2_p
x(6)=9.156333549655708_p
w(6)=4.803629076891465e-4_p
x(7)=14.19423297892894_p
w(7)=3.593461759880156e-6_p
else if(N==8)then
x(1)=-2.773601880556622_p
w(1)=5.412646419705204e-1_p
x(2)=-1.858809270084058_p
w(2)=1.057890777611533_p
x(3)=-4.022737234062047e-1_p
w(3)=9.948764160745248e-1_p
x(4)=1.461361600373872_p
w(4)=3.953467774054515e-1_p
x(5)=3.880000011808789_p
w(5)=5.600262068406987e-2_p
x(6)=7.029071290942812_p
w(6)=3.129771145301274e-3_p
x(7)=10.9397639002665_p
w(7)=7.534866491893680e-5_p
x(8)=15.21032903560212_p
w(8)=9.566180461272757e-7_p
else if(N==9)then
x(1)=-2.808622804208674_p
w(1)=4.594150584637742e-1_p
x(2)=-2.026769740281705_p
w(2)=9.319414602821042e-1_p
x(3)=-7.544871420748690e-1_p
w(3)=9.947611198814961e-1_p
x(4)=8.750207420148205e-1_p
w(4)=5.320468774255556e-1_p
x(5)=2.917022232606007_p
w(5)=1.181983011286267e-1_p
x(6)=5.511637826332137_p
w(6)=1.162630995279590e-2_p
x(7)=8.688453392461826_p
w(7)=5.812780365680054e-4_p
x(8)=12.33438128965499_p
w(8)=1.652207916240181e-5_p
x(9)=15.79949036842141_p
w(9)=3.829242826586253e-7_p
else if(N==10)then
x(1)=-2.836159846860828_p
w(1)=3.945205122345347e-1_p
x(2)=-2.161317798821631_p
w(2)=8.219752303337469e-1_p
x(3)=-1.043776297668485_p
w(3)=9.584996898020282e-1_p
x(4)=4.000931998932289e-1_p
w(4)=6.383864160934525e-1_p
x(5)=2.167626450532844_p
w(5)=2.019482768482309e-1_p
x(6)=4.364228053131124_p
w(6)=3.056304006864613e-2_p
x(7)=7.028760116022224_p
w(7)=2.556975828121931e-3_p
x(8)=10.10737562543545_p
w(8)=1.320324905700582e-4_p
x(9)=13.3845734979239_p
w(9)=4.938965441754641e-6_p
x(10)=16.152096409684_p
w(10)=1.975095928050874e-7_p
else if(N==11)then
x(1)=-2.858184033340252_p
w(1)=3.422942758337068e-1_p
x(2)=-2.270435082026078_p
w(2)=7.273947950624492e-1_p
x(3)=-1.283524223381862_p
w(3)=9.033209426813243e-1_p
x(4)=6.558126063059595e-3_p
w(4)=7.073236661125902e-1_p
x(5)=1.565674446996173_p
w(5)=2.962482627174369e-1_p
x(6)=3.463568061393709_p
w(6)=6.346485983019517e-2_p
x(7)=5.747225763532892_p
w(7)=7.865938729570190e-3_p
x(8)=8.388836553546874_p
w(8)=6.354202209505499e-4_p
x(9)=11.28474127888064_p
w(9)=3.712391262636339e-5_p
x(10)=14.16200133714336_p
w(10)=1.905739275206035e-6_p
x(11)=16.3739488500145_p
w(11)=1.193342406857772e-7_p
else if(N==12)then
x(1)=-2.876065599451849_p
w(1)=2.996888111507518e-1_p
x(2)=-2.359969435628141_p
w(2)=6.464681467094341e-1_p
x(3)=-1.483803169658988_p
w(3)=8.404368459507120e-1_p
x(4)=-3.246333876660414e-1_p
w(4)=7.416620590030382e-1_p
x(5)=1.069813494626084_p
w(5)=3.881024997591164e-1_p
x(6)=2.737094950231723_p
w(6)=1.109711415516054e-1_p
x(7)=4.725783040234046_p
w(7)=1.889512916659350e-2_p
x(8)=7.026070734991975_p
w(8)=2.165962490273781e-3_p
x(9)=9.576921107703900_p
w(9)=1.829897855734944e-4_p
x(10)=12.24321072375448_p
w(10)=1.274889303744832e-5_p
x(11)=14.73676382761763_p
w(11)=8.958051676324730e-7_p
x(12)=16.5206437339419_p
w(12)=7.990906198918693e-8_p
else if(N==13)then
x(1)=-2.890777248157893_p
w(1)=2.645049001050709e-1_p
x(2)=-2.434237255613481_p
w(2)=5.772331763509962e-1_p
x(3)=-1.652370657126260_p
w(3)=7.764132869393048e-1_p
x(4)=-6.063751007353413e-1_p
w(4)=7.487684098197713e-1_p
x(5)=6.531217230865413e-1_p
w(5)=4.670887173219355e-1_p
x(6)=2.138317551846358_p
w(6)=1.702257721393251e-1_p
x(7)=3.892495961501925_p
w(7)=3.785683162070383e-2_p
x(8)=5.919551482522060_p
w(8)=5.769649438839192e-3_p
x(9)=8.180746148665239_p
w(9)=6.595209162891340e-4_p
x(10)=10.59641049218078_p
w(10)=6.128672505021615e-5_p
x(11)=13.01578443917498_p
w(11)=5.212969761777723e-6_p
x(12)=15.16534853568941_p
w(12)=4.884303319506145e-7_p
x(13)=16.6219781528893_p
w(13)=5.739698568143674e-8_p
else if(N==14)then
x(1)=-2.903023588285708_p
w(1)=2.351294863594894e-1_p
x(2)=-2.496459300009280_p
w(2)=5.178510952784887e-1_p
x(3)=-1.795272989239725_p
w(3)=7.147741197521716e-1_p
x(4)=-8.479625518871962e-1_p
w(4)=7.367108128219799e-1_p
x(5)=2.975331468729421e-1_p
w(5)=5.274967718679814e-1_p
x(6)=1.635797369233817_p
w(6)=2.357125008481742e-1_p
x(7)=3.200223247747688_p
w(7)=6.599583535318583e-2_p
x(8)=5.004029182650144_p
w(8)=1.278556074757442e-2_p
x(9)=7.023384911274374_p
w(9)=1.879850440101765e-3_p
x(10)=9.205868645343141_p
w(10)=2.248016488104494e-4_p
x(11)=11.46128818510232_p
w(11)=2.366757002026663e-5_p
x(12)=13.63671903949296_p
w(12)=2.466620884108251e-6_p
x(13)=15.48932250513849_p
w(13)=2.975217734899583e-7_p
x(14)=16.69462249946251_p
w(14)=4.334373009575516e-8_p
else if(N==15)then
x(1)=-2.913324591650508_p
w(1)=2.103606029107651e-1_p
x(2)=-2.549067488032417_p
w(2)=4.667207811875319e-1_p
x(3)=-1.917257720035131_p
w(3)=6.572132674379135e-1_p
x(4)=-1.056444284157152_p
w(4)=7.123702039509590e-1_p
x(5)=-9.459586733034812e-3_p
w(5)=5.680922937932906e-1_p
x(6)=1.207549090627876_p
w(6)=3.009776604676543e-1_p
x(7)=2.616374239334104_p
w(7)=1.030406647193100e-1_p
x(8)=4.234966607432193_p
w(8)=2.457344874167970e-2_p
x(9)=6.050835672477313_p
w(9)=4.475210231433821e-3_p
x(10)=8.027530359539201_p
w(10)=6.654160972885917e-4_p
x(11)=10.10545576679795_p
w(11)=8.582801547224320e-5_p
x(12)=12.19035621015245_p
w(12)=1.038671928214841e-5_p
x(13)=14.13679100212912_p
w(13)=1.314963589147902e-6_p
x(14)=15.73807741005568_p
w(14)=1.969672271509622e-7_p
x(15)=16.7483490401574_p
w(15)=3.397096849496439e-8_p
else if(N==16)then
x(1)=-2.922070479824117_p
w(1)=1.892892442024661e-1_p
x(2)=-2.593920120516664_p
w(2)=4.224940203951568e-1_p
x(3)=-2.022075408871029_p
w(3)=6.043815566092311e-1_p
x(4)=-1.237353817928438_p
w(4)=6.809175168878842e-1_p
x(5)=-2.768315965407724e-1_p
w(5)=5.906645071601604e-1_p
x(6)=8.378615727654314e-1_p
w(6)=3.603452717221972e-1_p
x(7)=2.117532522471958_p
w(7)=1.471231473854147e-1_p
x(8)=3.580750142955595_p
w(8)=4.216401032345694e-2_p
x(9)=5.223762197618896_p
w(9)=9.247084260711287e-3_p
x(10)=7.021048987668452_p
w(10)=1.660927193509000e-3_p
x(11)=8.930432751034900_p
w(11)=2.575029393423958e-4_p
x(12)=10.88893260574659_p
w(12)=3.648763154645805e-5_p
x(13)=12.80342858412628_p
w(13)=5.095253370694971e-6_p
x(14)=14.54162069230625_p
w(14)=7.718910771722210e-7_p
x(15)=15.93213320287151_p
w(15)=1.389231651910520e-7_p
x(16)=16.78914324569112_p
w(16)=2.739567609199874e-8_p
else if(N==17)then
x(1)=-2.929558581495469_p
w(1)=1.712184787862794e-1_p
x(2)=-2.632453671848871_p
w(2)=3.840532177367284e-1_p
x(3)=-2.112706799069386_p
w(3)=5.563622055071421e-1_p
x(4)=-1.395131106763507_p
w(4)=6.459497965475438e-1_p
x(5)=-5.112746696248329e-1_p
w(5)=5.984525476091541e-1_p
x(6)=5.153145866928651e-1_p
w(6)=4.099682769405817e-1_p
x(7)=1.686418189382298_p
w(7)=1.951846157543243e-1_p
x(8)=3.018183805511644_p
w(8)=6.594413703536932e-2_p
x(9)=4.513109176979303_p
w(9)=1.704983220422137e-2_p
x(10)=6.154032036014764_p
w(10)=3.614400294420492e-3_p
x(11)=7.909858741222906_p
w(11)=6.604325766008084e-4_p
x(12)=9.735766081600453_p
w(12)=1.088919220619467e-4_p
x(13)=11.56829237310457_p
w(13)=1.711310040563632e-5_p
x(14)=13.31916155374004_p
w(14)=2.749031068769924e-6_p
x(15)=14.87166061702477_p
w(15)=4.896360080059667e-7_p
x(16)=16.08584115447385_p
w(16)=1.028961330404660e-7_p
x(17)=16.82081792767195_p
w(17)=2.259632231879260e-8_p
else
call GD(-3)
end if
end subroutine GF_m3

! [-2kT;17kT]
subroutine GF_m2(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-1.066231486205983_p
w(1)=1.641087424122901_p
x(2)=2.078550066243035_p
w(2)=4.858405455206951e-1_p
else if(N==3)then
x(1)=-1.367542631207700_p
w(1)=1.231178783213335_p
x(2)=8.542006890457252e-1_p
w(2)=8.504013571123481e-1_p
x(3)=4.792751176848546_p
w(3)=4.534782931791302e-2_p
else if(N==4)then
x(1)=-1.529074177930031_p
w(1)=9.610312400640189e-1_p
x(2)=2.047996140788907e-1_p
w(2)=9.947410384425088e-1_p
x(3)=2.996981058277439_p
w(3)=1.684581575369743e-1_p
x(4)=7.771684546294089_p
w(4)=2.697533600094255e-3_p
else if(N==5)then
x(1)=-1.630600652296069_p
w(1)=7.742869712095435e-1_p
x(2)=-2.219733707724270e-1_p
w(2)=1.011541498438655_p
x(3)=1.994136138273744_p
w(3)=3.214648401803090e-1_p
x(4)=5.361982747456203_p
w(4)=1.947907267693685e-2_p
x(5)=10.68098985520081_p
w(5)=1.555871381521997e-4_p
else if(N==6)then
x(1)=-1.701802146873808_p
w(1)=6.359714581460651e-1_p
x(2)=-5.351811839608925e-1_p
w(2)=9.647240623403334e-1_p
x(3)=1.304505745935828_p
w(3)=4.635107370180747e-1_p
x(4)=3.925871923725371_p
w(4)=6.068028929921063e-2_p
x(5)=7.698705633193636_p
w(5)=2.027737412353795e-3_p
x(6)=13.01795615545722_p
w(6)=1.368542755856313e-5_p
else if(N==7)then
x(1)=-1.754540286852271_p
w(1)=5.298394487848439e-1_p
x(2)=-7.760018136240506e-1_p
w(2)=8.893777386828380e-1_p
x(3)=7.862879732819272e-1_p
w(3)=5.707486343082269e-1_p
x(4)=2.928722482498600_p
w(4)=1.271090148795459e-1_p
x(5)=5.866159408921468_p
w(5)=9.597252906368810e-3_p
x(6)=9.763320992355975_p
w(6)=2.535472795581032e-4_p
x(7)=14.53877531619897_p
w(7)=2.332802214543844e-6_p
else if(N==8)then
x(1)=-1.794644778167290_p
w(1)=4.471434628836214e-1_p
x(2)=-9.645234150617658e-1_p
w(2)=8.055962849487139e-1_p
x(3)=3.811325492858100e-1_p
w(3)=6.357738871903947e-1_p
x(4)=2.189039999247627_p
w(4)=2.091644027653147e-1_p
x(5)=4.584925140352395_p
w(5)=2.760328477885899e-2_p
x(6)=7.672326036497712_p
w(6)=1.602575763784979e-3_p
x(7)=11.44412072251579_p
w(7)=4.337438169313350e-5_p
x(8)=15.4237763414032_p
w(8)=6.969312142824688e-7_p
else if(N==9)then
x(1)=-1.825765111189189_p
w(1)=3.818428005402159e-1_p
x(2)=-1.114090914180324_p
w(2)=7.237917998298524e-1_p
x(3)=5.673797815800424e-2_p
w(3)=6.634206226913929e-1_p
x(4)=1.616669181254224_p
w(4)=2.930201912901752e-1_p
x(5)=3.631159091932845_p
w(5)=5.869284052933698e-2_p
x(6)=6.179674073123985_p
w(6)=5.833344576924308e-3_p
x(7)=9.261744061158897_p
w(7)=3.156786074840870e-4_p
x(8)=12.73735667745523_p
w(8)=1.039075088193919e-5_p
x(9)=15.93445520805545_p
w(9)=3.008273323184393e-7_p
else if(N==10)then
x(1)=-1.850360395027037_p
w(1)=3.295623368247644e-1_p
x(2)=-1.234316860192237_p
w(2)=6.485114784029021e-1_p
x(3)=-2.074544908121553e-1_p
w(3)=6.633333490802116e-1_p
x(4)=1.159675639186170_p
w(4)=3.670389505594241e-1_p
x(5)=2.891738738631421_p
w(5)=1.019204269756095e-1_p
x(6)=5.051193372618169_p
w(6)=1.514350611117554e-2_p
x(7)=7.644486114195597_p
w(7)=1.337764800369806e-3_p
x(8)=10.60481533998605_p
w(8)=7.663432710682317e-5_p
x(9)=13.70006807211803_p
w(9)=3.359781841553641e-6_p
x(10)=16.24147703293452_p
w(10)=1.627801905971076e-7_p
else if(N==11)then
x(1)=-1.870119413131123_p
w(1)=2.871470120200286e-1_p
x(2)=-1.332169894858284_p
w(2)=5.812278250547831e-1_p
x(3)=-4.254396181500339e-1_p
w(3)=6.450480549649339e-1_p
x(4)=7.860964846875971e-1_p
w(4)=4.246085575284704e-1_p
x(5)=2.301156408568825_p
w(5)=1.532169519322375e-1_p
x(6)=4.165892995698748_p
w(6)=3.129670129788586e-2_p
x(7)=6.393333060113171_p
w(7)=4.008174720084061e-3_p
x(8)=8.944749635428195_p
w(8)=3.501914504560635e-4_p
x(9)=11.70863232971632_p
w(9)=2.301684845544960e-5_p
x(10)=14.4079025053737_p
w(10)=1.382355324208490e-6_p
x(11)=16.4360744323107_p
w(11)=1.014709370544541e-7_p
else if(N==12)then
x(1)=-1.886224141342502_p
w(1)=2.523106652163721e-1_p
x(2)=-1.412739703471818_p
w(2)=5.219512174803549e-1_p
x(3)=-6.072173065681944e-1_p
w(3)=6.160840846714587e-1_p
x(4)=4.752384059583535e-1_p
w(4)=4.639248122550312e-1_p
x(5)=1.818352191012723_p
w(5)=2.070351978281647e-1_p
x(6)=3.452680002750458_p
w(6)=5.490484832904989e-2_p
x(7)=5.395318228081113_p
w(7)=9.451403609485456e-3_p
x(8)=7.623322420131452_p
w(8)=1.150036617267460e-3_p
x(9)=10.07144110766131_p
w(9)=1.065531357782677e-4_p
x(10)=12.6007799759159_p
w(10)=8.397763382286806e-6_p
x(11)=14.9295727625267_p
w(11)=6.833335204925322e-7_p
x(12)=16.56571616693594_p
w(12)=6.940373077264889e-8_p
else if(N==13)then
x(1)=-1.899518982876401_p
w(1)=2.233774332963608e-1_p
x(2)=-1.479786692922193_p
w(2)=4.700665796080005e-1_p
x(3)=-7.601901221130041e-1_p
w(3)=5.817135143869888e-1_p
x(4)=2.130555860318097e-1_p
w(4)=4.864022363300788e-1_p
x(5)=1.416217344282090_p
w(5)=2.580889882360105e-1_p
x(6)=2.866174196197731_p
w(6)=8.517438166582166e-2_p
x(7)=4.580933805601461_p
w(7)=1.871788500493832e-2_p
x(8)=6.548327627523011_p
w(8)=2.978457536074122e-3_p
x(9)=8.725897254936950_p
w(9)=3.667776100885607e-4_p
x(10)=11.03198054964798_p
w(10)=3.765753075443402e-5_p
x(11)=13.31629474570591_p
w(11)=3.620497017377372e-6_p
x(12)=15.3182887808108_p
w(12)=3.873362809851617e-7_p
x(13)=16.65588056674047_p
w(13)=5.060518139637740e-8_p
else if(N==14)then
x(1)=-1.910619117688599_p
w(1)=1.991020233439182e-1_p
x(2)=-1.536124521618982_p
w(2)=4.247448876784465e-1_p
x(3)=-8.899740051584208e-1_p
w(3)=5.453651036030462e-1_p
x(4)=-1.041356716677652e-2_p
w(4)=4.950027965922630e-1_p
x(5)=1.076169213799296_p
w(5)=3.024821938334590e-1_p
x(6)=2.375731225577466_p
w(6)=1.201374165203585e-1_p
x(7)=3.904505484896553_p
w(7)=3.247484009105205e-2_p
x(8)=5.657966945283423_p
w(8)=6.461285419353952e-3_p
x(9)=7.607288529037018_p
w(9)=1.008986003026644e-3_p
x(10)=9.699016883250769_p
w(10)=1.310746589725428e-4_p
x(11)=11.84273025126198_p
w(11)=1.528830545888077e-5_p
x(12)=13.88952535894981_p
w(12)=1.791846310266654e-6_p
x(13)=15.61233452562736_p
w(13)=2.431092919763008e-7_p
x(14)=16.72090030685619_p
w(14)=3.863863851144036e-8_p
else if(N==15)then
x(1)=-1.919980842778720_p
w(1)=1.785463213263721e-1_p
x(2)=-1.583885133087147_p
w(2)=3.851355389507843e-1_p
x(3)=-1.000903816335229_p
w(3)=5.091405669299469e-1_p
x(4)=-2.025111447076590e-1_p
w(4)=4.930469702277518e-1_p
x(5)=7.850728711194507e-1_p
w(5)=3.380701530157910e-1_p
x(6)=1.959825939885491_p
w(6)=1.571867140375622e-1_p
x(7)=3.334485348862711_p
w(7)=5.080408880780495e-2_p
x(8)=4.909613722042595_p
w(8)=1.222929925361861e-2_p
x(9)=6.665714822162287_p
w(9)=2.335393080036440e-3_p
x(10)=8.565348993580006_p
w(10)=3.723267625936661e-4_p
x(11)=10.54889659076044_p
w(11)=5.239158000731793e-5_p
x(12)=12.52358055389369_p
w(12)=7.018640919805355e-6_p
x(13)=14.35033306623345_p
w(13)=9.917659385069421e-7_p
x(14)=15.83844369226838_p
w(14)=1.647266897318562e-7_p
x(15)=16.76923272491746_p
w(15)=3.053777886665739e-8_p
else if(N==16)then
x(1)=-1.927948153006160_p
w(1)=1.609942575903917e-1_p
x(2)=-1.624703633977635_p
w(2)=3.504491703934928e-1_p
x(3)=-1.096369356931562_p
w(3)=4.742515782441865e-1_p
x(4)=-3.688223758610825e-1_p
w(4)=4.835652012518164e-1_p
x(5)=5.333820879640694e-1_p
w(5)=3.642596291685768e-1_p
x(6)=1.602899788354946_p
w(6)=1.936710963821954e-1_p
x(7)=2.848244448446748_p
w(7)=7.316024654040755e-2_p
x(8)=4.272873371377513_p
w(8)=2.078111267161235e-2_p
x(9)=5.864140356176056_p
w(9)=4.718980120720476e-3_p
x(10)=7.594840784192317_p
w(10)=8.989062638149186e-4_p
x(11)=9.422946830067900_p
w(11)=1.502135512088584e-4_p
x(12)=11.28626156516022_p
w(12)=2.325112729070565e-5_p
x(13)=13.09454824237485_p
w(13)=3.582661409133866e-6_p
x(14)=14.72306284018116_p
w(14)=6.005674928866630e-7_p
x(15)=16.01515805482706_p
w(15)=1.183207658804294e-7_p
x(16)=16.80609182009053_p
w(16)=2.478821391088809e-8_p
else if(N==17)then
x(1)=-1.934784221842946_p
w(1)=1.458924366021612e-1_p
x(2)=-1.659848590861063_p
w(2)=3.199871713822892e-1_p
x(3)=-1.179049510772471_p
w(3)=4.413388626510950e-1_p
x(4)=-5.137023367486503e-1_p
w(4)=4.690418197393239e-1_p
x(5)=3.139733270350510e-1_p
w(5)=3.815529171872806e-1_p
x(6)=1.293455045008131_p
w(6)=2.273597577370710e-1_p
x(7)=2.429079229613281_p
w(7)=9.847998527248372e-2_p
x(8)=3.725423149623170_p
w(8)=3.236901235665376e-2_p
x(9)=5.174931213617728_p
w(9)=8.551519974086702e-3_p
x(10)=6.757590222408254_p
w(10)=1.903346883302792e-3_p
x(11)=8.442363649545745_p
w(11)=3.711667416442025e-4_p
x(12)=10.18505216104727_p
w(12)=6.612860007819914e-5_p
x(13)=11.92373263504448_p
w(13)=1.134311448850467e-5_p
x(14)=13.57396763661072_p
w(14)=2.001036146954473e-6_p
x(15)=15.02688478113842_p
w(15)=3.908975512648711e-7_p
x(16)=16.15540577067285_p
w(16)=8.891553558851225e-8_p
x(17)=16.83481917513868_p
w(17)=2.055240345070844e-8_p
else
call GD(-2)
end if
end subroutine GF_m2

! [-1kT;17kT]
subroutine GF_m1(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-2.078249491565899e-1_p
w(1)=1.057141448146585_p
x(2)=2.782771570117854_p
w(2)=2.561201979722612e-1_p
else if(N==3)then
x(1)=-4.525373385783947e-1_p
w(1)=8.260574378705465e-1_p
x(2)=1.607054367777175_p
w(2)=4.660089462995135e-1_p
x(3)=5.564628542724011_p
w(3)=2.119526194878651e-2_p
else if(N==4)then
x(1)=-5.863701316083394e-1_p
w(1)=6.636815356644564e-1_p
x(2)=1.002332723746023_p
w(2)=5.683416992852575e-1_p
x(3)=3.774930680264241_p
w(3)=8.001610384228250e-2_p
x(4)=8.560808030053634_p
w(4)=1.222307326850124e-3_p
else if(N==5)then
x(1)=-6.725178425916302e-1_p
w(1)=5.453108980171044e-1_p
x(2)=6.105530012174867e-1_p
w(2)=6.014861997404184e-1_p
x(3)=2.774495408028895_p
w(3)=1.574739253453470e-1_p
x(4)=6.141085568859288_p
w(4)=8.915702700848526e-3_p
x(5)=11.38497646067263_p
w(5)=7.492031512818561e-5_p
else if(N==6)then
x(1)=-7.339857714966892e-1_p
w(1)=4.542395221131654e-1_p
x(2)=3.254820825802775e-1_p
w(2)=5.945199522600391e-1_p
x(3)=2.092317200878220_p
w(3)=2.353996231432812e-1_p
x(4)=4.698127134403158_p
w(4)=2.812754336509351e-2_p
x(5)=8.417169240020083_p
w(5)=9.673475835778090e-4_p
x(6)=13.5299938973613_p
w(6)=7.657653689503177e-6_p
else if(N==7)then
x(1)=-7.799210418043456e-1_p
w(1)=3.826430099373397e-1_p
x(2)=1.080963861270198e-1_p
w(2)=5.653544628806348e-1_p
x(3)=1.588397738028945_p
w(3)=3.008560717874109e-1_p
x(4)=3.702042178494667_p
w(4)=5.974019663005399e-2_p
x(5)=6.596641507407438_p
w(5)=4.534976018816430e-3_p
x(6)=10.38084817852172_p
w(6)=1.314021998878488e-4_p
x(7)=14.86211440679575_p
w(7)=1.526664702895787e-6_p
else if(N==8)then
x(1)=-8.150702470526328e-1_p
w(1)=3.258522373188856e-1_p
x(2)=-6.122868273264056e-2_p
w(2)=5.257927301166373e-1_p
x(3)=1.201226599186751_p
w(3)=3.477581101011037e-1_p
x(4)=2.968798333882173_p
w(4)=1.000918073580340e-1_p
x(5)=5.327901521013362_p
w(5)=1.294221331752801e-2_p
x(6)=8.335382113786709_p
w(6)=7.992500665141095e-4_p
x(7)=11.94750277286499_p
w(7)=2.478730689695922e-5_p
x(8)=15.62202813133582_p
w(8)=5.105332467602165e-7_p
else if(N==9)then
x(1)=-8.424977233132351e-1_p
w(1)=2.803513703798802e-1_p
x(2)=-1.953250818486058e-1_p
w(2)=4.830017767746235e-1_p
x(3)=8.956416908086531e-1_p
w(3)=3.759877586087954e-1_p
x(4)=2.406314263940262_p
w(4)=1.434743440937336e-1_p
x(5)=4.385983387701314_p
w(5)=2.743637707732636e-2_p
x(6)=6.872627615980469_p
w(6)=2.834515464566451e-3_p
x(7)=9.844353114716492_p
w(7)=1.687425110002174e-4_p
x(8)=13.13389077377364_p
w(8)=6.524428477688370e-6_p
x(9)=16.06007566037493_p
w(9)=2.367804431833984e-7_p
else if(N==10)then
x(1)=-8.642835507038894e-1_p
w(1)=2.434811359425722e-1_p
x(2)=-3.031291351828703e-1_p
w(2)=4.408858403577618e-1_p
x(3)=6.494459529210828e-1_p
w(3)=3.885343326557757e-1_p
x(4)=1.961505155900247_p
w(4)=1.846194176744695e-1_p
x(5)=3.657827607991743_p
w(5)=4.778557771416990e-2_p
x(6)=5.766673033901316_p
w(6)=7.223679083213952e-3_p
x(7)=8.275420579683809_p
w(7)=6.851556519256313e-4_p
x(8)=11.10460362124149_p
w(8)=4.408640145318910e-5_p
x(9)=14.00773773784573_p
w(9)=2.286556178557004e-6_p
x(10)=16.3251929557688_p
w(10)=1.340813260545729e-7_p
else if(N==11)then
x(1)=-8.818637596305580e-1_p
w(1)=2.132653208620658e-1_p
x(2)=-3.909732582340404e-1_p
w(2)=4.013554097880191e-1_p
x(3)=4.478686394693415e-1_p
w(3)=3.892715672479134e-1_p
x(4)=1.601459823328208_p
w(4)=2.199350021589125e-1_p
x(5)=3.078332318158697_p
w(5)=7.249085251167264e-2_p
x(6)=4.899505371902725_p
w(6)=1.474732765321045e-2_p
x(7)=7.058633390387903_p
w(7)=1.990571175116787e-3_p
x(8)=9.508881265034805_p
w(8)=1.903014892570780e-4_p
x(9)=12.13081741662776_p
w(9)=1.420382479713279e-5_p
x(10)=14.64655738967852_p
w(10)=1.003301595803614e-6_p
x(11)=16.49466501566098_p
w(11)=8.610628581269455e-8_p
else if(N==12)then
x(1)=-8.962493260521182e-1_p
w(1)=1.882367522025194e-1_p
x(2)=-4.634229202241362e-1_p
w(2)=3.651938570452654e-1_p
x(3)=2.806458256073071e-1_p
w(3)=3.818032049453866e-1_p
x(4)=1.304656350707120_p
w(4)=2.476753338396421e-1_p
x(5)=2.606755791780931_p
w(5)=9.939098328238249e-2_p
x(6)=4.201575347323735_p
w(6)=2.570759220026449e-2_p
x(7)=6.087094479860441_p
w(7)=4.586617512260553e-3_p
x(8)=8.232900490391787_p
w(8)=5.997258303717708e-4_p
x(9)=10.56938093158271_p
w(9)=6.147966683139515e-5_p
x(10)=12.95467257124268_p
w(10)=5.518228504015213e-6_p
x(11)=15.11633739257336_p
w(11)=5.212590460906625e-7_p
x(12)=16.60849350291992_p
w(12)=6.010637217497741e-8_p
else if(N==13)then
x(1)=-9.081666736355817e-1_p
w(1)=1.672981531553789e-1_p
x(2)=-5.238275355754706e-1_p
w(2)=3.325807877266485e-1_p
x(3)=1.403880392588243e-1_p
w(3)=3.690372165263405e-1_p
x(4)=1.056392794044927_p
w(4)=2.675505020182100e-1_p
x(5)=2.216108390154379_p
w(5)=1.262805180401758e-1_p
x(6)=3.628488894081624_p
w(6)=3.985293807231724e-2_p
x(7)=5.294102195455990_p
w(7)=8.929370326498190e-3_p
x(8)=7.192536213553811_p
w(8)=1.504899965360696e-3_p
x(9)=9.278375194433563_p
w(9)=2.013960783294922e-4_p
x(10)=11.46788807197248_p
w(10)=2.300187714757583e-5_p
x(11)=13.61244779442957_p
w(11)=2.510923041503182e-6_p
x(12)=15.46640325257645_p
w(12)=3.069418419703657e-7_p
x(13)=16.68823334976083_p
w(13)=4.446755622479539e-8_p
else if(N==14)then
x(1)=-9.181478802250871e-1_p
w(1)=1.496204336351413e-1_p
x(2)=-5.746844280240878e-1_p
w(2)=3.033913818961200e-1_p
x(3)=2.162472083278078e-2_p
w(3)=3.531383323734418e-1_p
x(4)=8.462495343834843e-1_p
w(4)=2.801875467019158e-1_p
x(5)=1.887750236106596_p
w(5)=1.513349933809441e-1_p
x(6)=3.150280703655648_p
w(6)=5.647445710242011e-2_p
x(7)=4.635547868743053_p
w(7)=1.530982046790803e-2_p
x(8)=6.329854162555077_p
w(8)=3.184457729303617e-3_p
x(9)=8.201553946623893_p
w(9)=5.331141011470228e-4_p
x(10)=10.19594371176072_p
w(10)=7.573888791117934e-5_p
x(11)=12.22268600317694_p
w(11)=9.836948474456320e-6_p
x(12)=14.13799322891952_p
w(12)=1.300203988007042e-6_p
x(13)=15.73155414733257_p
w(13)=1.983705786840493e-7_p
x(14)=16.74609408129702_p
w(14)=3.431955231927087e-8_p
else if(N==15)then
x(1)=-9.265895454844396e-1_p
w(1)=1.345701587390221e-1_p
x(2)=-6.178832541560436e-1_p
w(2)=2.773619796936124e-1_p
x(3)=-7.978381928837129e-2_p
w(3)=3.356343967815434e-1_p
x(4)=6.666073650695723e-1_p
w(4)=2.866641795339761e-1_p
x(5)=1.608382271394830_p
w(5)=1.733010306505450e-1_p
x(6)=2.745881933179527_p
w(6)=7.459337455608890e-2_p
x(7)=4.080887602732423_p
w(7)=2.378623454824273e-2_p
x(8)=5.604345267591627_p
w(8)=5.910555771530011e-3_p
x(9)=7.293412669497577_p
w(9)=1.196406429037336e-3_p
x(10)=9.109770086235654_p
w(10)=2.059127465221984e-4_p
x(11)=10.99368834948332_p
w(11)=3.177507839696083e-5_p
x(12)=12.85435464885534_p
w(12)=4.729624720826249e-6_p
x(13)=14.55988194316856_p
w(13)=7.471207498511528e-7_p
x(14)=15.93583563846527_p
w(14)=1.374968399741366e-7_p
x(15)=16.7893341577305_p
w(15)=2.734801863454463e-8_p
else if(N==16)then
x(1)=-9.337919974066380e-1_p
w(1)=1.216579782440441e-1_p
x(2)=-6.548732274984342e-1_p
w(2)=2.541789802772336e-1_p
x(3)=-1.670256026058042e-1_p
w(3)=3.175606732447962e-1_p
x(4)=5.117455377882820e-1_p
w(4)=2.881862301097136e-1_p
x(5)=1.368256966276810_p
w(5)=1.915023483466918e-1_p
x(6)=2.400012111467879_p
w(6)=9.316096372616352e-2_p
x(7)=3.608194759027231_p
w(7)=3.417797001684914e-2_p
x(8)=4.986913133901174_p
w(8)=9.894761863639020e-3_p
x(9)=6.519412004068601_p
w(9)=2.357315042245437e-3_p
x(10)=8.177570685504916_p
w(10)=4.797143323740521e-4_p
x(11)=9.919315043459987_p
w(11)=8.686141383377192e-5_p
x(12)=11.68335275325576_p
w(12)=1.474632954518039e-5_p
x(13)=13.38280368945155_p
w(13)=2.513677018100279e-6_p
x(14)=14.9009743455679_p
w(14)=4.666151081492420e-7_p
x(15)=16.09583868984329_p
w(15)=1.005370118071413e-7_p
x(16)=16.82246047969817_p
w(16)=2.234257909492483e-8_p
else if(N==17)then
x(1)=-9.399859371891337e-1_p
w(1)=1.105017728181071e-1_p
x(2)=-6.867795520702888e-1_p
w(2)=2.335247730419618e-1_p
x(3)=-2.425914505059866e-1_p
w(3)=2.995929175428169e-1_p
x(4)=3.772724136804697e-1_p
w(4)=2.859000582662664e-1_p
x(5)=1.160062051429202_p
w(5)=2.057404594323966e-1_p
x(6)=2.101313343398058_p
w(6)=1.112188818735345e-1_p
x(7)=3.201274824208316_p
w(7)=4.610832432777327e-2_p
x(8)=4.456107145092526_p
w(8)=1.524808242130072e-2_p
x(9)=5.853455922302887_p
w(9)=4.184666446074050e-3_p
x(10)=7.372065004493054_p
w(10)=9.861170866210334e-4_p
x(11)=8.980873783746942_p
w(11)=2.063491868513059e-4_p
x(12)=10.6362255677894_p
w(12)=3.989162138382547e-5_p
x(13)=12.27795127323579_p
w(13)=7.491435077656197e-6_p
x(14)=13.82582565872415_p
w(14)=1.453818405302568e-6_p
x(15)=15.1790521953984_p
w(15)=3.115493400012832e-7_p
x(16)=16.22310749232319_p
w(16)=7.663018611728561e-8_p
x(17)=16.84838032882335_p
w(17)=1.862074999381493e-8_p
else
call GD(-1)
end if
end subroutine GF_m1

! [0kT;17kT]
subroutine GF_0(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=6.905081015899720e-1_p
w(1)=5.746499831837049e-1_p
x(2)=3.592202831868456_p
w(2)=1.184971559768641e-1_p
else if(N==3)then
x(1)=4.836568886891163e-1_p
w(1)=4.631011088265420e-1_p
x(2)=2.444660586237987_p
w(2)=2.209581322645082e-1_p
x(3)=6.416952433875451_p
w(3)=9.087898069518768e-3_p
else if(N==4)then
x(1)=3.690092328617859e-1_p
w(1)=3.807429054177404e-1_p
x(2)=1.863849061936230_p
w(2)=2.772308251319702e-1_p
x(3)=4.627154502860371_p
w(3)=3.464987712331504e-2_p
x(4)=9.401330368745372_p
w(4)=5.235314875433483e-4_p
else if(N==5)then
x(1)=2.938201758802985e-1_p
w(1)=3.179163077849436e-1_p
x(2)=1.490445018499085_p
w(2)=3.017856659291797e-1_p
x(3)=3.622224552888690_p
w(3)=6.954508728027176e-2_p
x(4)=6.966936139458789_p
w(4)=3.864662426592606e-3_p
x(5)=12.0946598099244_p
w(5)=3.541573958130318e-5_p
else if(N==6)then
x(1)=2.395812743520017e-1_p
w(1)=2.680390724910078e-1_p
x(2)=1.221471672682146_p
w(2)=3.061631782552705e-1_p
x(3)=2.940874724378862_p
w(3)=1.062116274747912e-1_p
x(4)=5.517639495396949_p
w(4)=1.228112356284652e-2_p
x(5)=9.157875662729161_p
w(5)=4.478214752340773e-4_p
x(6)=14.01786684488898_p
w(6)=4.315901418821371e-6_p
else if(N==7)then
x(1)=1.988742799986999e-1_p
w(1)=2.280316864993593e-1_p
x(2)=1.018758617723388_p
w(2)=2.980737175253074e-1_p
x(3)=2.443938446656377_p
w(3)=1.387144289198593e-1_p
x(4)=4.523700127427123_p
w(4)=2.619314085960927e-2_p
x(5)=7.356108752201775_p
w(5)=2.065972626615435e-3_p
x(6)=11.00299853896208_p
w(6)=6.718322803641147e-5_p
x(7)=15.16139195558878_p
w(7)=1.009501781885771e-6_p
else if(N==8)then
x(1)=1.676231153757234e-1_p
w(1)=1.957973124208050e-1_p
x(2)=8.622191957876454e-1_p
w(2)=2.830784461500324e-1_p
x(3)=2.067016612548929_p
w(3)=1.639216434116145e-1_p
x(4)=3.796710089324878_p
w(4)=4.412905042780681e-2_p
x(5)=6.103657119285773_p
w(5)=5.816355001025864e-3_p
x(6)=9.013556799461812_p
w(6)=3.898423617419335e-4_p
x(7)=12.44531151271816_p
w(7)=1.411320896654533e-5_p
x(8)=15.80451096196781_p
w(8)=3.761785760198283e-7_p
else if(N==9)then
x(1)=1.431546700262203e-1_p
w(1)=1.696286793954172e-1_p
x(2)=7.389165607455570e-1_p
w(2)=2.648671813355652e-1_p
x(3)=1.772847367713833_p
w(3)=1.812092294956639e-1_p
x(4)=3.242440914057534_p
w(4)=6.380067626989652e-2_p
x(5)=5.176045400865793_p
w(5)=1.220808204845650e-2_p
x(6)=7.586133324695212_p
w(6)=1.339927687390562e-3_p
x(7)=10.43222816977995_p
w(7)=8.907660233263903e-5_p
x(8)=13.52093834932527_p
w(8)=4.099639357961777e-6_p
x(9)=16.17626617776679_p
w(9)=1.866864885019639e-7_p
else if(N==10)then
x(1)=1.236554212577022e-1_p
w(1)=1.481860879221686e-1_p
x(2)=6.401089484523034e-1_p
w(2)=2.456819751751527e-1_p
x(3)=1.538074965881028_p
w(3)=1.913714636238581e-1_p
x(4)=2.806892550224606_p
w(4)=8.306024372054981e-2_p
x(5)=4.460658365507471_p
w(5)=2.113894061552767e-2_p
x(6)=6.506184107330670_p
w(6)=3.336905231479980e-3_p
x(7)=8.917856576940526_p
w(7)=3.446517243735746e-4_p
x(8)=11.60348545613597_p
w(8)=2.520199075106787e-5_p
x(9)=14.30574037742154_p
w(9)=1.558814607932145e-6_p
x(10)=16.40322508380594_p
w(10)=1.103420996132266e-7_p
else if(N==11)then
x(1)=1.078723899271763e-1_p
w(1)=1.304465396051304e-1_p
x(2)=5.597407916199846e-1_p
w(2)=2.267967253752519e-1_p
x(3)=1.347322226213045_p
w(3)=1.957555629779804e-1_p
x(4)=2.456622082356005_p
w(4)=1.003605159012900e-1_p
x(5)=3.892827214640003_p
w(5)=3.201344317929016e-2_p
x(6)=5.659651923945419_p
w(6)=6.695536527343529e-3_p
x(7)=7.739484811558599_p
w(7)=9.670413184382986e-4_p
x(8)=10.07810892388574_p
w(8)=1.022320335272057e-4_p
x(9)=12.54884399526157_p
w(9)=8.740300748594439e-6_p
x(10)=14.87687430540117_p
w(10)=7.290495617693296e-7_p
x(11)=16.54970011149929_p
w(11)=7.289200669631574e-8_p
else if(N==12)then
x(1)=9.492135832758763e-2_p
w(1)=1.156332281862031e-1_p
x(2)=4.935148045525160e-1_p
w(2)=2.088827479089082e-1_p
x(3)=1.190040518905517_p
w(3)=1.957681859607481e-1_p
x(4)=2.169718399002382_p
w(4)=1.148315957327487e-1_p
x(5)=3.432136795485248_p
w(5)=4.398861148398861e-2_p
x(6)=4.978851212718236_p
w(6)=1.152595195570126e-2_p
x(7)=6.797327194392720_p
w(7)=2.169530785350790e-3_p
x(8)=8.851761671050413_p
w(8)=3.079958922508295e-4_p
x(9)=11.06818455442468_p
w(9)=3.521997399718743e-5_p
x(10)=13.30311144922014_p
w(10)=3.621686972075475e-6_p
x(11)=15.29639281270209_p
w(11)=3.977091660980960e-7_p
x(12)=16.64895046113847_p
w(12)=5.188453401773289e-8_p
else if(N==13)then
x(1)=8.416511170412651e-2_p
w(1)=1.031541272491217e-1_p
x(2)=4.383133999306240e-1_p
w(2)=1.922516287609221e-1_p
x(3)=1.058743340390749_p
w(3)=1.926494011304323e-1_p
x(4)=1.931184399886371_p
w(4)=1.261624619152794e-1_p
x(5)=3.051805029466723_p
w(5)=5.620217218140490e-2_p
x(6)=4.420452196510694_p
w(6)=1.771919320883627e-2_p
x(7)=6.027960044509857_p
w(7)=4.136225863537140e-3_p
x(8)=7.849097689512806_p
w(8)=7.465022168419695e-4_p
x(9)=9.835625927581095_p
w(9)=1.094165398611621e-4_p
x(10)=11.90209766886503_p
w(10)=1.398786647191617e-5_p
x(11)=13.90297543290413_p
w(11)=1.740248152716627e-6_p
x(12)=15.60926566769155_p
w(12)=2.430519377135571e-7_p
x(13)=16.71901025610705_p
w(13)=3.892776961208523e-8_p
else if(N==14)then
x(1)=7.513549198687408e-2_p
w(1)=9.255473244813260e-2_p
x(2)=3.918304711705085e-1_p
w(2)=1.770074148641883e-1_p
x(3)=9.479678170386239e-1_p
w(3)=1.874007476501847e-1_p
x(4)=1.730388829005585_p
w(4)=1.344251468258461e-1_p
x(5)=2.733300595891330_p
w(5)=6.792156945528395e-2_p
x(6)=3.955169845770198_p
w(6)=2.499549108684818e-2_p
x(7)=5.389049983606848_p
w(7)=6.976764030082887e-3_p
x(8)=7.016465780382579_p
w(8)=1.536468724125685e-3_p
x(9)=8.803609290613643_p
w(9)=2.779156482259450e-4_p
x(10)=10.69452575199147_p
w(10)=4.344222557666399e-5_p
x(11)=12.59956451146337_p
w(11)=6.311420807202608e-6_p
x(12)=14.38121516951211_p
w(12)=9.428055071111947e-7_p
x(13)=15.84669202753393_p
w(13)=1.616152198139967e-7_p
x(14)=16.7701791566744_p
w(14)=3.036053985552247e-8_p
else if(N==15)then
x(1)=6.748250301330652e-2_p
w(1)=8.348305444463826e-2_p
x(2)=3.523307783589287e-1_p
w(2)=1.631390392606784e-1_p
x(3)=8.536357014324375e-1_p
w(3)=1.807888840492905e-1_p
x(4)=1.559574785529415_p
w(4)=1.399137882647087e-1_p
x(5)=2.463364185866943_p
w(5)=7.861063705506872e-2_p
x(6)=3.562393013449244_p
w(6)=3.297868965986698e-2_p
x(7)=4.851135933439802_p
w(7)=1.070570364387929e-2_p
x(8)=6.315713163493034_p
w(8)=2.788282805788443e-3_p
x(9)=7.931282621449738_p
w(9)=6.032515199481068e-4_p
x(10)=9.658625726603557_p
w(10)=1.127551679218537e-4_p
x(11)=11.43808598206119_p
w(11)=1.917138903988674e-5_p
x(12)=13.18144571429357_p
w(12)=3.180717855068804e-6_p
x(13)=14.76477893884394_p
w(13)=5.622724230168613e-7_p
x(14)=16.03004630693868_p
w(14)=1.145203481848969e-7_p
x(15)=16.80863129947297_p
w(15)=2.438911357748486e-8_p
else if(N==16)then
x(1)=6.094035157960948e-2_p
w(1)=7.566397473660418e-2_p
x(2)=3.184887008670217e-1_p
w(2)=1.505752849426717e-1_p
x(3)=7.726439688848356e-1_p
w(3)=1.733794129698187e-1_p
x(4)=1.412944476233372_p
w(4)=1.430242332174715e-1_p
x(5)=2.232248167191534_p
w(5)=8.793608230751263e-2_p
x(6)=3.227152480246695_p
w(6)=4.126821531863058e-2_p
x(7)=4.393009906440950_p
w(7)=1.524629517387027e-2_p
x(8)=5.719170764901728_p
w(8)=4.582945593949820e-3_p
x(9)=7.186792910706833_p
w(9)=1.156361868052473e-3_p
x(10)=8.767016193399717_p
w(10)=2.529293856460864e-4_p
x(11)=10.41771110361606_p
w(11)=4.985855515690200e-5_p
x(12)=12.07878426387696_p
w(12)=9.317066815585297e-6_p
x(13)=13.66724003752614_p
w(13)=1.760721201881102e-6_p
x(14)=15.074867303068_p
w(14)=3.620484575649613e-7_p
x(15)=16.17402051635563_p
w(15)=8.520220439477548e-8_p
x(16)=16.8382300211562_p
w(16)=2.005250473849874e-8_p
else if(N==17)then
x(1)=5.530431431853574e-2_p
w(1)=6.888047009418090e-2_p
x(2)=2.892777223627393e-1_p
w(2)=1.392168724394983e-1_p
x(3)=7.025932703290620e-1_p
w(3)=1.655778558092757e-1_p
x(4)=1.286075187529969_p
w(4)=1.441753147770931e-1_p
x(5)=2.032622750477524_p
w(5)=9.573987241655685e-2_p
x(6)=2.938299415657628_p
w(6)=4.949352683656336e-2_p
x(7)=3.998981062169139_p
w(7)=2.045075472497533e-2_p
x(8)=5.206321905320234_p
w(8)=6.958676860513041e-3_p
x(9)=6.545708776090768_p
w(9)=2.006114669432402e-3_p
x(10)=7.995147187082710_p
w(10)=5.037768094086886e-4_p
x(11)=9.523502096421236_p
w(11)=1.136552131058064e-4_p
x(12)=11.08775338223754_p
w(12)=2.393021083013417e-5_p
x(13)=12.62979458439292_p
w(13)=4.933210658880796e-6_p
x(14)=14.07399182027308_p
w(14)=1.054566084074995e-6_p
x(15)=15.32779325902085_p
w(15)=2.478775991377481e-7_p
x(16)=16.28882677750478_p
w(16)=6.584655277004980e-8_p
x(17)=16.8614848511493_p
w(17)=1.679824057394001e-8_p
else
call GD(0)
end if
end subroutine GF_0

! [1kT;17kT]
subroutine GF_1(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=1.631767251019347_p
w(1)=2.640209672703485e-1_p
x(2)=4.489949690558311_p
w(2)=4.924067884849806e-2_p
else if(N==3)then
x(1)=1.445481257365014_p
w(1)=2.166179772634270e-1_p
x(2)=3.355802857754615_p
w(2)=9.300479774234460e-2_p
x(3)=7.333578385274591_p
w(3)=3.638871113074883e-3_p
else if(N==4)then
x(1)=1.341206193415990_p
w(1)=1.804572180816765e-1_p
x(2)=2.783905358370213_p
w(2)=1.185812917433494e-1_p
x(3)=5.535823059808759_p
w(3)=1.400723732035448e-2_p
x(4)=10.27294993822629_p
w(4)=2.158989734661444e-4_p
else if(N==5)then
x(1)=1.271928131094971_p
w(1)=1.519930514038587e-1_p
x(2)=2.416629429119105_p
w(2)=1.311449339829319e-1_p
x(3)=4.520997316754867_p
w(3)=2.849298844250778e-2_p
x(4)=7.822582580766891_p
w(4)=1.613912958496666e-3_p
x(5)=12.78704303650508_p
w(5)=1.675933105147597e-5_p
else if(N==6)then
x(1)=1.221780380929221_p
w(1)=1.289812128588621e-1_p
x(2)=2.154450299094100_p
w(2)=1.349423439450923e-1_p
x(3)=3.836940273817437_p
w(3)=4.398835580657005e-2_p
x(4)=6.369168120008198_p
w(4)=5.143249503971191e-3_p
x(5)=9.905973033896695_p
w(5)=2.040054240549865e-4_p
x(6)=14.46921205086056_p
w(6)=2.478580295849462e-6_p
else if(N==7)then
x(1)=1.184186108463820_p
w(1)=1.103292295197055e-1_p
x(2)=1.959094680841499_p
w(2)=1.330526068768587e-1_p
x(3)=3.343130154492482_p
w(3)=5.798040880199223e-2_p
x(4)=5.379184309606297_p
w(4)=1.094522630358445e-2_p
x(5)=8.131734076499168_p
w(5)=9.192296725466688e-4_p
x(6)=11.61780965002209_p
w(6)=3.426707903222295e-5_p
x(7)=15.43240134002453_p
w(7)=6.778651268161025e-7_p
else if(N==8)then
x(1)=1.155344776288387_p
w(1)=9.517398320498674e-2_p
x(2)=1.809566856255602_p
w(2)=1.278118765126330e-1_p
x(3)=2.972081298521761_p
w(3)=6.914413711998317e-2_p
x(4)=4.659159122457901_p
w(4)=1.839529323111462e-2_p
x(5)=6.899990502577567_p
w(5)=2.540092561854167e-3_p
x(6)=9.696051327247480_p
w(6)=1.879122918099042e-4_p
x(7)=12.92894482090565_p
w(7)=8.071736412698941e-6_p
x(8)=15.96974955344073_p
w(8)=2.794600522168799e-7_p
else if(N==9)then
x(1)=1.132762278075129_p
w(1)=8.277986357216835e-2_p
x(2)=1.692536237751954_p
w(2)=1.208239147480658e-1_p
x(3)=2.684823939048569_p
w(3)=7.716043680646575e-2_p
x(4)=4.112846827746830_p
w(4)=2.657213953063902e-2_p
x(5)=5.989351219127465_p
w(5)=5.253147622504758e-3_p
x(6)=8.309998445697982_p
w(6)=6.225775507371532e-4_p
x(7)=11.01660876079303_p
w(7)=4.682645383247845e-5_p
x(8)=13.89282260891209_p
w(8)=2.592194827169495e-6_p
x(9)=16.28231805491158_p
w(9)=1.476396060586281e-7_p
else if(N==10)then
x(1)=1.114758834191972_p
w(1)=7.255951880393506e-2_p
x(2)=1.599189441750255_p
w(2)=1.131056837522887e-1_p
x(3)=2.457159458064927_p
w(3)=8.227682609900250e-2_p
x(4)=3.685503633673442_p
w(4)=3.463013059619661e-2_p
x(5)=5.288427873853282_p
w(5)=8.993188963574653e-3_p
x(6)=7.259775610333589_p
w(6)=1.509035687053130e-3_p
x(7)=9.563273534872428_p
w(7)=1.716938825868927e-4_p
x(8)=12.09466261000128_p
w(8)=1.440909594907186e-5_p
x(9)=14.59043152281184_p
w(9)=1.068434525196715e-6_p
x(10)=16.47512929147029_p
w(10)=9.080373466271701e-8_p
else if(N==11)then
x(1)=1.100178442068246_p
w(1)=6.405796295501180e-2_p
x(2)=1.523522229508304_p
w(2)=1.052683541991536e-1_p
x(3)=2.273283304256723_p
w(3)=8.497586929353843e-2_p
x(4)=3.343351894994363_p
w(4)=4.196320623163591e-2_p
x(5)=4.733243600295666_p
w(5)=1.350721859463716e-2_p
x(6)=6.436422021620091_p
w(6)=2.964942149733764e-3_p
x(7)=8.427542064436937_p
w(7)=4.634498987739183e-4_p
x(8)=10.6454164540387_p
w(8)=5.466001986574874e-5_p
x(9)=12.95759532635551_p
w(9)=5.389479073046628e-6_p
x(10)=15.09647077459103_p
w(10)=5.317027044514977e-7_p
x(11)=16.60086463887446_p
w(11)=6.159471868329575e-8_p
else if(N==12)then
x(1)=1.088206799313091_p
w(1)=5.692532681350256e-2_p
x(2)=1.461327460814915_p
w(2)=9.766056426571305e-2_p
x(3)=2.122437355479994_p
w(3)=8.578492290547227e-2_p
x(4)=3.064297305483286_p
w(4)=4.822383974295330e-2_p
x(5)=4.283821448468302_p
w(5)=1.845801152614756e-2_p
x(6)=5.774576675843193_p
w(6)=5.020077871648984e-3_p
x(7)=7.517729828440332_p
w(7)=1.009184984955076e-3_p
x(8)=9.472879447508012_p
w(8)=1.568446396917161e-4_p
x(9)=11.56217509116431_p
w(9)=2.014184150521890e-5_p
x(10)=13.64229213135055_p
w(10)=2.382842947067306e-6_p
x(11)=15.46811884104189_p
w(11)=3.040238030720101e-7_p
x(12)=16.68685179552361_p
w(12)=4.466050663207862e-8_p
else if(N==13)then
x(1)=1.078257551613719_p
w(1)=5.089206930300047e-2_p
x(2)=1.409583215578301_p
w(2)=9.046716705888093e-2_p
x(3)=1.997047194824277_p
w(3)=8.518507794079618e-2_p
x(4)=2.833233465515854_p
w(4)=5.327453998496032e-2_p
x(5)=3.913669662427361_p
w(5)=2.351104846101484e-2_p
x(6)=5.232173806332806_p
w(6)=7.617806824920067e-3_p
x(7)=6.774185473426846_p
w(7)=1.878721518285376e-3_p
x(8)=8.510994157531224_p
w(8)=3.661234208749371e-4_p
x(9)=10.39176202754121_p
w(9)=5.915099181968702e-5_p
x(10)=12.33007198860723_p
w(10)=8.505470522849691e-6_p
x(11)=14.18504098720706_p
w(11)=1.208634594754673e-6_p
x(12)=15.74572572772205_p
w(12)=1.925485183832856e-7_p
x(13)=16.74803099662206_p
w(13)=3.396065771691931e-8_p
else if(N==14)then
x(1)=1.069900026948518_p
w(1)=4.574933767031199e-2_p
x(2)=1.366071786177760_p
w(2)=8.377349451961059e-2_p
x(3)=1.891630238896526_p
w(3)=8.357777686795174e-2_p
x(4)=2.639465629609159_p
w(4)=5.712241773112689e-2_p
x(5)=3.604452567372924_p
w(5)=2.838656485935434e-2_p
x(6)=4.780700875864198_p
w(6)=1.063921804051604e-2_p
x(7)=6.156606710843849_p
w(7)=3.108144748290417e-3_p
x(8)=7.710757805791875_p
w(8)=7.311661813324471e-4_p
x(9)=9.407478811545815_p
w(9)=1.437804509347387e-4_p
x(10)=11.18986306219568_p
w(10)=2.485029609269670e-5_p
x(11)=12.96975741580044_p
w(11)=4.051828033385177e-6_p
x(12)=14.61705013941358_p
w(12)=6.845882632671925e-7_p
x(13)=15.95689944983615_p
w(13)=1.315813846398573e-7_p
x(14)=16.7930148335341_p
w(14)=2.675564332525173e-8_p
else if(N==15)then
x(1)=1.062812240900158_p
w(1)=4.133409097438352e-2_p
x(2)=1.329134957220165_p
w(2)=7.760596132822864e-2_p
x(3)=1.802125551008626_p
w(3)=8.128079855767140e-2_p
x(4)=2.475205560780541_p
w(4)=5.986089480491153e-2_p
x(5)=3.343044437999554_p
w(5)=3.288016920785610e-2_p
x(6)=4.400055669095458_p
w(6)=1.393398528703690e-2_p
x(7)=5.636749497031131_p
w(7)=4.694536918237483e-3_p
x(8)=7.036604286401134_p
w(8)=1.294349410244928e-3_p
x(9)=8.573291701419111_p
w(9)=3.011932013404796e-4_p
x(10)=10.2068285651643_p
w(10)=6.143414272578014e-5_p
x(11)=11.87803063465819_p
w(11)=1.155141353035478e-5_p
x(12)=13.50198046264268_p
w(12)=2.140566276280453e-6_p
x(13)=14.963380770288_p
w(13)=4.234061369045609e-7_p
x(14)=16.12042928207217_p
w(14)=9.523794409384955e-8_p
x(15)=16.82701267061886_p
w(15)=2.166232211946538e-8_p
else if(N==16)then
x(1)=1.056749614936772_p
w(1)=3.751800818832018e-2_p
x(2)=1.297512332350833_p
w(2)=7.195726627049384e-2_p
x(3)=1.725466044714314_p
w(3)=7.853706729461207e-2_p
x(4)=2.334647333352282_p
w(4)=6.162621381693802e-2_p
x(5)=3.119791044402622_p
w(5)=3.686255245326682e-2_p
x(6)=4.075620406645171_p
w(6)=1.734742932122628e-2_p
x(7)=5.194195252878867_p
w(7)=6.600224954724771e-3_p
x(8)=6.462433340877342_p
w(8)=2.083859026463664e-3_p
x(9)=7.860186650374335_p
w(9)=5.605877497970703e-4_p
x(10)=9.357979890269410_p
w(10)=1.324236407701220e-4_p
x(11)=10.91381183377664_p
w(11)=2.852559445797056e-5_p
x(12)=12.46919921943113_p
w(12)=5.883051375543610e-6_p
x(13)=13.94555597599865_p
w(13)=1.233913762149710e-6_p
x(14)=15.24345757123015_p
w(14)=2.808701823028358e-7_p
x(15)=16.24919840964532_p
w(15)=7.205062786488529e-8_p
x(16)=16.85331090900718_p
w(16)=1.792182782720181e-8_p
else if(N==17)then
x(1)=1.051523698074637_p
w(1)=3.419924905909280e-2_p
x(2)=1.270231845172672_p
w(2)=6.680182639423687e-2_p
x(3)=1.659296208335130_p
w(3)=7.552759678721117e-2_p
x(4)=2.213376449051470_p
w(4)=6.256851824703230e-2_p
x(5)=2.927430655860324_p
w(5)=4.026832169320941e-2_p
x(6)=3.796496401926436_p
w(6)=2.073940372584565e-2_p
x(7)=4.813795657972063_p
w(7)=8.762472917236846e-3_p
x(8)=5.968747737632816_p
w(8)=3.109573202568973e-3_p
x(9)=7.245510913010734_p
w(9)=9.486769571482510e-4_p
x(10)=8.621557615167722_p
w(10)=2.551142335963651e-4_p
x(11)=10.06576214487798_p
w(11)=6.228702798704421e-5_p
x(12)=11.53596626716419_p
w(12)=1.432472169822199e-5_p
x(13)=12.97648228044088_p
w(13)=3.247521804394145e-6_p
x(14)=14.31660706296191_p
w(14)=7.650506926467890e-7_p
x(15)=15.47208686452874_p
w(15)=1.970582811041221e-7_p
x(16)=16.35216062149786_p
w(16)=5.643178298179674e-8_p
x(17)=16.87405993310079_p
w(17)=1.508942147222690e-8_p
else
call GD(1)
end if
end subroutine GF_1

! [2kT;17kT]
subroutine GF_2(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=2.604049553163498_p
w(1)=1.077893310145503e-1_p
x(2)=5.443386249492912_p
w(2)=1.913863862904592e-2_p
else if(N==3)then
x(1)=2.426840450454859_p
w(1)=8.914632800429902e-2_p
x(2)=4.313228697443070_p
w(2)=3.638168188948423e-2_p
x(3)=8.286904259802343_p
w(3)=1.399959749812929e-3_p
else if(N==4)then
x(1)=2.326657671290884_p
w(1)=7.460622412878946e-2_p
x(2)=3.740835452454608_p
w(2)=4.677959320573677e-2_p
x(3)=6.473621793760132_p
w(3)=5.453925482276762e-3_p
x(4)=11.14407457460603_p
w(4)=8.822682679317286e-5_p
else if(N==5)then
x(1)=2.259552347343269_p
w(1)=6.294365653692967e-2_p
x(2)=3.372621810182264_p
w(2)=5.210505069079933e-2_p
x(3)=5.446011058827127_p
w(3)=1.120619491911258e-2_p
x(4)=8.684031943487112_p
w(4)=6.649345989546226e-4_p
x(5)=13.43550613085304_p
w(5)=8.132897799965478e-6_p
else if(N==6)then
x(1)=2.211101683169617_p
w(1)=5.345957958826518e-2_p
x(2)=3.112037635945756_p
w(2)=5.388826341635730e-2_p
x(3)=4.758423334523322_p
w(3)=1.737206373829039e-2_p
x(4)=7.231770515455685_p
w(4)=2.113389482147276e-3_p
x(5)=10.64182754032469_p
w(5)=9.320526517653389e-5_p
x(6)=14.87293626657045_p
w(6)=1.468153359489230e-6_p
else if(N==7)then
x(1)=2.174962024801076_p
w(1)=4.576228393207329e-2_p
x(2)=2.919814022027059_p
w(2)=5.334677523131162e-2_p
x(3)=4.266565526381743_p
w(3)=2.292940506276623e-2_p
x(4)=6.248907767709876_p
w(4)=4.464853974031617e-3_p
x(5)=8.906128922510421_p
w(5)=4.064970125983686e-4_p
x(6)=12.21058872123745_p
w(6)=1.768968130223022e-5_p
x(7)=15.67178790874483_p
w(7)=4.647495128052898e-7_p
else if(N==8)then
x(1)=2.147340584713668_p
w(1)=3.950127774979421e-2_p
x(2)=2.773828214431670_p
w(2)=5.142111295006812e-2_p
x(3)=3.899723705628392_p
w(3)=2.736617296280857e-2_p
x(4)=5.537584356501237_p
w(4)=7.447014546651707e-3_p
x(5)=7.700601935861164_p
w(5)=1.096719802945868e-3_p
x(6)=10.36870027207915_p
w(6)=9.077709529976468e-5_p
x(7)=13.38845387398748_p
w(7)=4.684590711586451e-6_p
x(8)=16.11650344724416_p
w(8)=2.099453163403873e-7_p
else if(N==9)then
x(1)=2.125771455971050_p
w(1)=3.437535175093288e-2_p
x(2)=2.660248747630003_p
w(2)=4.875701625972805e-2_p
x(3)=3.617463127138057_p
w(3)=3.056822153754456e-2_p
x(4)=5.000066749383770_p
w(4)=1.068688262641039e-2_p
x(5)=6.810244705321172_p
w(5)=2.225686941228492e-3_p
x(6)=9.030666924019826_p
w(6)=2.882461941774091e-4_p
x(7)=11.58641410348489_p
w(7)=2.478624776363231e-5_p
x(8)=14.24317745226741_p
w(8)=1.660731545233259e-6_p
x(9)=16.37754314255834_p
w(9)=1.173542655065898e-7_p
else if(N==10)then
x(1)=2.108611220124172_p
w(1)=3.014429260067892e-2_p
x(2)=2.570078192255003_p
w(2)=4.576612475066438e-2_p
x(3)=3.394930400488588_p
w(3)=3.263710684216261e-2_p
x(4)=4.581136095134111_p
w(4)=1.385575525542916e-2_p
x(5)=6.125951683705019_p
w(5)=3.752605565103443e-3_p
x(6)=8.014337751715217_p
w(6)=6.773044306053684e-4_p
x(7)=10.2005205550075_p
w(7)=8.565567943131506e-5_p
x(8)=12.56976855641405_p
w(8)=8.309942987342327e-6_p
x(9)=14.85773644732055_p
w(9)=7.397395593860420e-7_p
x(10)=16.54042481373032_p
w(10)=7.483697423552771e-8_p
else if(N==11)then
x(1)=2.094736424343082_p
w(1)=2.662181396782065e-2_p
x(2)=2.497259863721065_p
w(2)=4.269845332237147e-2_p
x(3)=3.216012912675264_p
w(3)=3.376132551335399e-2_p
x(4)=4.246855020538494_p
w(4)=1.672585225884005e-2_p
x(5)=5.584856225428972_p
w(5)=5.566913187925342e-3_p
x(6)=7.217012657762416_p
w(6)=1.298905013424594e-3_p
x(7)=9.111795960756716_p
w(7)=2.215615955023127e-4_p
x(8)=11.20178469207834_p
w(8)=2.935064014982019e-5_p
x(9)=13.35086936210568_p
w(9)=3.351647026203921e-6_p
x(10)=15.30264360496138_p
w(10)=3.904807045737656e-7_p
x(11)=16.64779609309166_p
w(11)=5.201647715429161e-8_p
else if(N==12)then
x(1)=2.083359332712664_p
w(1)=2.366440967377206e-2_p
x(2)=2.437589425499462_p
w(2)=3.969901641338059e-2_p
x(3)=3.069810914966246_p
w(3)=3.414452274522625e-2_p
x(4)=3.975082663684065_p
w(4)=1.917120935498265e-2_p
x(5)=5.147622084180735_p
w(5)=7.531905526818729e-3_p
x(6)=6.576173963751116_p
w(6)=2.156657288601935e-3_p
x(7)=8.237452174119785_p
w(7)=4.668792102303198e-4_p
x(8)=10.087047171149_p
w(8)=7.993542098727184e-5_p
x(9)=12.04415566152622_p
w(9)=1.158292071785793e-5_p
x(10)=13.96762343056278_p
w(10)=1.579305254926092e-6_p
x(11)=15.62963605326741_p
w(11)=2.334139610351163e-7_p
x(12)=16.72191710269756_p
w(12)=3.836966254874915e-8_p
else if(N==13)then
x(1)=2.073914698272507_p
w(1)=2.116132687077877e-2_p
x(2)=2.388070048860822_p
w(2)=3.684682346352939e-2_p
x(3)=2.948694401761298_p
w(3)=3.397186472870945e-2_p
x(4)=3.750713372621151_p
w(4)=2.114539123045424e-2_p
x(5)=4.788168458647349_p
w(5)=9.517924133547217e-3_p
x(6)=6.051278276389264_p
w(6)=3.220594714827873e-3_p
x(7)=7.522058356574916_p
w(7)=8.465442080550345e-4_p
x(8)=9.168995528854701_p
w(8)=1.792080816051111e-4_p
x(9)=10.93913591911187_p
w(9)=3.206397875414703e-5_p
x(10)=12.74610614284164_p
w(10)=5.201494192252009e-6_p
x(11)=14.45520962658051_p
w(11)=8.443042545392764e-7_p
x(12)=15.87441810366415_p
w(12)=1.528872145651977e-7_p
x(13)=16.77507563204652_p
w(13)=2.954767358105669e-8_p
else if(N==14)then
x(1)=2.065988504371661_p
w(1)=1.902661390270673e-2_p
x(2)=2.346516472184399_p
w(2)=3.418034745979107e-2_p
x(3)=2.847170649868449_p
w(3)=3.339799843310456e-2_p
x(4)=3.563075125235612_p
w(4)=2.265515531693654e-2_p
x(5)=4.488441814810699_p
w(5)=1.142026024393779e-2_p
x(6)=5.614726679606881_p
w(6)=4.438778627786900e-3_p
x(7)=6.927598398480326_p
w(7)=1.370448235434429e-3_p
x(8)=8.403528882191173_p
w(8)=3.464509809511801e-4_p
x(9)=10.00531584212501_p
w(9)=7.440459040919549e-5_p
x(10)=11.67563580553623_p
w(10)=1.426705315162069e-5_p
x(11)=13.32874160937161_p
w(11)=2.614877271912282e-6_p
x(12)=14.84288466231454_p
w(12)=4.992106451230436e-7_p
x(13)=16.06114792220936_p
w(13)=1.072082703356214e-7_p
x(14)=16.81442654042307_p
w(14)=2.350319879411148e-8_p
else if(N==15)then
x(1)=2.059271921529582_p
w(1)=1.719308000207312e-2_p
x(2)=2.311303520975090_p
w(2)=3.171371808766902e-2_p
x(3)=2.761192154056674_p
w(3)=3.254579306250674e-2_p
x(4)=3.404413068365961_p
w(4)=2.373822940574727e-2_p
x(5)=4.235519684209565_p
w(5)=1.316482208122821e-2_p
x(6)=5.247011227832194_p
w(6)=5.750074579183011e-3_p
x(7)=6.427195487907372_p
w(7)=2.032693954169097e-3_p
x(8)=7.757855121357854_p
w(8)=5.970721462081853e-4_p
x(9)=9.211510669975302_p
w(9)=1.501070119830244e-4_p
x(10)=10.74772223746938_p
w(10)=3.352691928760713e-5_p
x(11)=12.30831017321962_p
w(11)=6.987335412844354e-6_p
x(12)=13.81235342912324_p
w(12)=1.446970038239182e-6_p
x(13)=15.15366077942147_p
w(13)=3.197459519956980e-7_p
x(14)=16.20618720663462_p
w(14)=7.917001105906040e-8_p
x(15)=16.84433810330396_p
w(15)=1.917212674630840e-8_p
else if(N==16)then
x(1)=2.053530807853499_p
w(1)=1.560777924758365e-2_p
x(2)=2.281201539193012_p
w(2)=2.944685740173577e-2_p
x(3)=2.687716689245298_p
w(3)=3.150972263553712e-2_p
x(4)=3.268959533239045_p
w(4)=2.444726866344024e-2_p
x(5)=4.019899985703232_p
w(5)=1.470639735946543e-2_p
x(6)=4.933923644676976_p
w(6)=7.094363120916911e-3_p
x(7)=6.001312377688820_p
w(7)=2.814416157963137e-3_p
x(8)=7.207570570927638_p
w(8)=9.398130969085848e-4_p
x(9)=8.531633283390217_p
w(9)=2.707820394639735e-4_p
x(10)=9.943621385074069_p
w(10)=6.931949966611846e-5_p
x(11)=11.40197892689655_p
w(11)=1.635902241965505e-5_p
x(12)=12.85029398981487_p
w(12)=3.728567742994605e-6_p
x(13)=14.21485258574746_p
w(13)=8.677689532373829e-7_p
x(14)=15.4051439848171_p
w(14)=2.182526297318610e-7_p
x(15)=16.32073995745179_p
w(15)=6.085218376631362e-8_p
x(16)=16.86758932682412_p
w(16)=1.595698584439716e-8_p
else if(N==17)then
x(1)=2.048585043045261_p
w(1)=1.422864781720288e-2_p
x(2)=2.255265850268792_p
w(2)=2.737175281157500e-2_p
x(3)=2.624418252431456_p
w(3)=3.036072172793849e-2_p
x(4)=3.152339863790463_p
w(4)=2.483942626043528e-2_p
x(5)=3.834438705353506_p
w(5)=1.602349282054928e-2_p
x(6)=4.664859691917179_p
w(6)=8.419044890353040e-3_p
x(7)=5.635402325714516_p
w(7)=3.688263615296697e-3_p
x(8)=6.734283348902927_p
w(8)=1.375699196539122e-3_p
x(9)=7.944892175487206_p
w(9)=4.462777796492662e-4_p
x(10)=9.244354820060764_p
w(10)=1.289605194059643e-4_p
x(11)=10.60175251444233_p
w(11)=3.416488549836256e-5_p
x(12)=11.976088080499_p
w(12)=8.597473281961945e-6_p
x(13)=13.31444759577571_p
w(13)=2.144861971874352e-6_p
x(14)=14.5513164399122_p
w(14)=5.564531963639534e-7_p
x(15)=15.61064615193241_p
w(15)=1.567586453259973e-7_p
x(16)=16.41259813483015_p
w(16)=4.827104831105481e-8_p
x(17)=16.88601215531752_p
w(17)=1.350100896176316e-8_p
else
call GD(2)
end if
end subroutine GF_2

! [3kT;17kT]
subroutine GF_3(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=3.592531801561399_p
w(1)=4.138539187768009e-2_p
x(2)=6.423801482435628_p
w(2)=7.201918296685636e-3_p
else if(N==3)then
x(1)=3.418458259497965_p
w(1)=3.431006581800818e-2_p
x(2)=5.291835546015647_p
w(2)=1.374643794916070e-2_p
x(3)=9.251231625580330_p
w(3)=5.308064071968435e-4_p
else if(N==4)then
x(1)=3.318952512132467_p
w(1)=2.869173108956825e-2_p
x(2)=4.713462247677248_p
w(2)=1.776082313635954e-2_p
x(3)=7.416763587754385_p
w(3)=2.098066630655778e-3_p
x(4)=11.9845063596259_p
w(4)=3.668931778216115e-5_p
else if(N==5)then
x(1)=3.252057649384178_p
w(1)=2.414072476375344e-2_p
x(2)=4.341208854132333_p
w(2)=1.982515407718574e-2_p
x(3)=6.376562748058045_p
w(3)=4.341653770140648e-3_p
x(4)=9.530935390168016_p
w(4)=2.756580835222470e-4_p
x(5)=14.02112670975951_p
w(5)=4.119479763650214e-6_p
else if(N==6)then
x(1)=3.204078421757191_p
w(1)=2.044796112208321e-2_p
x(2)=4.080234883854343_p
w(2)=2.050026134393082e-2_p
x(3)=5.686809683512835_p
w(3)=6.727376234164953e-3_p
x(4)=8.088198729020426_p
w(4)=8.674466636758344e-4_p
x(5)=11.34964153173774_p
w(5)=4.336198375090645e-5_p
x(6)=15.22453770070857_p
w(6)=9.028267600066411e-7_p
else if(N==7)then
x(1)=3.168544833607495_p
w(1)=1.746363081125452e-2_p
x(2)=3.889491566757813_p
w(2)=2.027275071100903e-2_p
x(3)=5.197569111715270_p
w(3)=8.849714599278271e-3_p
x(4)=7.117028381272754_p
w(4)=1.810365540275926e-3_p
x(5)=9.665123451842403_p
w(5)=1.811795316557508e-4_p
x(6)=12.77045381848726_p
w(6)=9.342899360565357e-6_p
x(7)=15.87939748134882_p
w(7)=3.260815316701649e-7_p
else if(N==8)then
x(1)=3.141533713905535_p
w(1)=1.504465340788178e-2_p
x(2)=3.745646776895098_p
w(2)=1.951565668588629e-2_p
x(3)=4.835030824096171_p
w(3)=1.052049559510240e-2_p
x(4)=6.417121668352402_p
w(4)=2.984608358370468e-3_p
x(5)=8.492312503295283_p
w(5)=4.745222948527176e-4_p
x(6)=11.02033019005335_p
w(6)=4.443574770795841e-5_p
x(7)=13.81716646349245_p
w(7)=2.778387731817917e-6_p
x(8)=16.24503940243173_p
w(8)=1.596968322930564e-7_p
else if(N==9)then
x(1)=3.120530637442854_p
w(1)=1.306993062622122e-2_p
x(2)=3.634349940790766_p
w(2)=1.848067225072971e-2_p
x(3)=4.557532783473141_p
w(3)=1.170745657614553e-2_p
x(4)=5.890099713143750_p
w(4)=4.239132954530715e-3_p
x(5)=7.626224827017472_p
w(5)=9.411961745197315e-4_p
x(6)=9.737301925886015_p
w(6)=1.344235629589886e-4_p
x(7)=12.13327860126243_p
w(7)=1.332133788913426e-5_p
x(8)=14.56811301911934_p
w(8)=1.082845526092961e-6_p
x(9)=16.46204692745825_p
w(9)=9.384584460867598e-8_p
else if(N==10)then
x(1)=3.103878788159731_p
w(1)=1.144397893626873e-2_p
x(2)=3.546388501616942_p
w(2)=1.732612601513277e-2_p
x(3)=4.339716724582901_p
w(3)=1.245837292397359e-2_p
x(4)=5.480643291193021_p
w(4)=5.447486968147864e-3_p
x(5)=6.961243476231647_p
w(5)=1.557789054079544e-3_p
x(6)=8.759405362513624_p
w(6)=3.049461069582026e-4_p
x(7)=10.82087498490374_p
w(7)=4.316555609195868e-5_p
x(8)=13.02276619669602_p
w(8)=4.863955292255322e-6_p
x(9)=15.10533567597728_p
w(9)=5.188395620755922e-7_p
x(10)=16.59909411049392_p
w(10)=6.181885872575315e-8_p
else if(N==11)then
x(1)=3.090454354129129_p
w(1)=1.009325167457932e-2_p
x(2)=3.475620036098582_p
w(2)=1.614707323050522e-2_p
x(3)=4.165255566414573_p
w(3)=1.285078938138321e-2_p
x(4)=5.154860685143548_p
w(4)=6.526376746461370e-3_p
x(5)=6.436123430337529_p
w(5)=2.275826172258953e-3_p
x(6)=7.991279276314737_p
w(6)=5.690285977029770e-4_p
x(7)=9.783536294677564_p
w(7)=1.065827729857450e-4_p
x(8)=11.74033902815457_p
w(8)=1.593676090186555e-5_p
x(9)=13.72436795817613_p
w(9)=2.111574936733805e-6_p
x(10)=15.49391564534163_p
w(10)=2.893333286750514e-7_p
x(11)=16.69042324616784_p
w(11)=4.392932166327765e-8_p
else if(N==12)then
x(1)=3.079474031730675_p
w(1)=8.961369507891720e-3_p
x(2)=3.417812920431963_p
w(2)=1.499799271078215e-2_p
x(3)=4.023166066005341_p
w(3)=1.296523256361964e-2_p
x(4)=4.890696509767597_p
w(4)=7.432956233817322e-3_p
x(5)=6.012428364830784_p
w(5)=3.039906682636452e-3_p
x(6)=7.373769662613443_p
w(6)=9.240946417282207e-4_p
x(7)=8.947902030504981_p
w(7)=2.166910033768824e-4_p
x(8)=10.68708620365263_p
w(8)=4.106180948207181e-5_p
x(9)=12.50878035801686_p
w(9)=6.733961719882112e-6_p
x(10)=14.27602426767649_p
w(10)=1.057906850028272e-6_p
x(11)=15.77993042497874_p
w(11)=1.802324409569319e-7_p
x(12)=16.75405945044734_p
w(12)=3.292002040339760e-8_p
else if(N==13)then
x(1)=3.070378484970710_p
w(1)=8.004992992406488e-3_p
x(2)=3.369969887510794_p
w(2)=1.390812400142082e-2_p
x(3)=3.905797469504062_p
w(3)=1.287333557741904e-2_p
x(4)=4.673137847677731_p
w(4)=8.154440782734359e-3_p
x(5)=5.664639393359216_p
w(5)=3.800154649240827e-3_p
x(6)=6.868133613388905_p
w(6)=1.354846072311215e-3_p
x(7)=8.263127290080538_p
w(7)=3.817557920803677e-4_p
x(8)=9.815840669585697_p
w(8)=8.817627265911580e-5_p
x(9)=11.47188317816973_p
w(9)=1.752933252865299e-5_p
x(10)=13.14605944234968_p
w(10)=3.212574580995739e-6_p
x(11)=14.71122832485481_p
w(11)=5.946772727421475e-7_p
x(12)=15.99460073354064_p
w(12)=1.217999050741570e-7_p
x(13)=16.80005832573004_p
w(13)=2.564980603424155e-8_p
else if(N==14)then
x(1)=3.062759706085409_p
w(1)=7.190600261527754e-3_p
x(2)=3.329917099149909_p
w(2)=1.289135234499079e-2_p
x(3)=3.807666584108146_p
w(3)=1.263404030069995e-2_p
x(4)=4.491601580305806_p
w(4)=8.697257534750057e-3_p
x(5)=5.375083335833204_p
w(5)=4.518110229732489e-3_p
x(6)=6.447847811319287_p
w(6)=1.838627947174499e-3_p
x(7)=7.693712077949101_p
w(7)=6.034893177019405e-4_p
x(8)=9.087529295582433_p
w(8)=1.646503954389674e-4_p
x(9)=10.59100928461493_p
w(9)=3.874586153741863e-5_p
x(10)=12.14707686593598_p
w(10)=8.259715390497047e-6_p
x(11)=13.67329665074893_p
w(11)=1.701937395903157e-6_p
x(12)=15.05702832835409_p
w(12)=3.662567044598968e-7_p
x(13)=16.15886798162076_p
w(13)=8.748458642869912e-8_p
x(14)=16.83433592850369_p
w(14)=2.058673457317930e-8_p
else if(N==15)then
x(1)=3.056314420671578_p
w(1)=6.492062189458783e-3_p
x(2)=3.296045374011968_p
w(2)=1.195242876983780e-2_p
x(3)=3.724749354380013_p
w(3)=1.229365422588343e-2_p
x(4)=4.338414214883236_p
w(4)=9.078429212695359e-3_p
x(5)=5.131110334706430_p
w(5)=5.167909188987689e-3_p
x(6)=6.094100447872688_p
w(6)=2.350618557458920e-3_p
x(7)=7.214293145800507_p
w(7)=8.773636531844486e-4_p
x(8)=8.472265986251415_p
w(8)=2.757225776686206e-4_p
x(9)=9.839721874941064_p
w(9)=7.513313137595164e-5_p
x(10)=11.27618100631019_p
w(10)=1.841910529590597e-5_p
x(11)=12.72505145866944_p
w(11)=4.259341219730535e-6_p
x(12)=14.11003546902895_p
w(12)=9.849853581935493e-7_p
x(13)=15.33431679556077_p
w(13)=2.424967337878412e-7_p
x(14)=16.28686816432178_p
w(14)=6.582696653057725e-8_p
x(15)=16.86053849145984_p
w(15)=1.691224058232479e-8_p
else if(N==16)then
x(1)=3.050813404904148_p
w(1)=5.888841532957022e-3_p
x(2)=3.267142074872046_p
w(2)=1.109082952763114e-2_p
x(3)=3.654032465629071_p
w(3)=1.188746161185540e-2_p
x(4)=4.207880972512696_p
w(4)=9.319623517369240e-3_p
x(5)=4.923422122755512_p
w(5)=5.734889629639744e-3_p
x(6)=5.793161504077579_p
w(6)=2.867600863283683e-3_p
x(7)=6.806310694944253_p
w(7)=1.194182125110468e-3_p
x(8)=7.947447341147904_p
w(8)=4.236022225349975e-4_p
x(9)=9.194881374008611_p
w(9)=1.311377878083019e-4_p
x(10)=10.51861466815711_p
w(10)=3.646949701626945e-5_p
x(11)=11.87791907126214_p
w(11)=9.443344427028884e-6_p
x(12)=13.21891131690213_p
w(12)=2.379280529753257e-6_p
x(13)=14.47311801603944_p
w(13)=6.136615083949694e-7_p
x(14)=15.5588988327453_p
w(14)=1.700621913434386e-7_p
x(15)=16.38827790344362_p
w(15)=5.135404736838581e-8_p
x(16)=16.88100523780121_p
w(16)=1.415645557866403e-8_p
else if(N==17)then
x(1)=3.046080799050368_p
w(1)=5.364658962350628e-3_p
x(2)=3.242278901579148_p
w(2)=1.030312591862795e-2_p
x(3)=3.593219908142927_p
w(3)=1.144174917283616e-2_p
x(4)=4.095691786823298_p
w(4)=9.443436711227918e-3_p
x(5)=4.745032072280555_p
w(5)=6.213191118291754e-3_p
x(6)=5.534770589300126_p
w(6)=3.370114343646122e-3_p
x(7)=6.455885136075434_p
w(7)=1.542073415142479e-3_p
x(8)=7.495863362680908_p
w(8)=6.073306262340982e-4_p
x(9)=8.637604895155114_p
w(9)=2.101687796404225e-4_p
x(10)=9.858105788861737_p
w(10)=6.542094749227757e-5_p
x(11)=11.12691476965477_p
w(11)=1.883895969632427e-5_p
x(12)=12.40451951373744_p
w(12)=5.191780589723789e-6_p
x(13)=13.64110108874635_p
w(13)=1.424853226902388e-6_p
x(14)=14.77649704075828_p
w(14)=4.064354148067784e-7_p
x(15)=15.7426427564997_p
w(15)=1.248891492153100e-7_p
x(16)=16.46983561674985_p
w(16)=4.122707723850331e-8_p
x(17)=16.89728966354731_p
w(17)=1.203372170898911e-8_p
else
call GD(3)
end if
end subroutine GF_3

! [4kT;17kT]
subroutine GF_4(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=4.587876868418037_p
w(1)=1.547477795132183e-2_p
x(2)=7.414667161374084_p
w(2)=2.675108567111585e-3_p
else if(N==3)then
x(1)=4.414109651734725_p
w(1)=1.282194569745422e-2_p
x(2)=6.276507635795241_p
w(2)=5.126218276674276e-3_p
x(3)=10.20804613630408_p
w(3)=2.017225443049114e-4_p
else if(N==4)then
x(1)=4.313632377504169_p
w(1)=1.068028868151381e-2_p
x(2)=5.688982025969934_p
w(2)=6.644297279094986e-3_p
x(3)=8.350121777086683_p
w(3)=8.094854429844105e-4_p
x(4)=12.77174242160603_p
w(4)=1.581511484020643e-5_p
else if(N==5)then
x(1)=4.246164975462120_p
w(1)=8.940284923815484e-3_p
x(2)=5.311991564444493_p
w(2)=7.410537472932366e-3_p
x(3)=7.300488389726175_p
w(3)=1.680528316358231e-3_p
x(4)=10.35057666842016_p
w(4)=1.163408196926743e-4_p
x(5)=14.53593021055941_p
w(5)=2.194985634654591e-6_p
else if(N==6)then
x(1)=4.198221597775609_p
w(1)=7.538149920173673e-3_p
x(2)=5.050465187413399_p
w(2)=7.638688312662369e-3_p
x(3)=6.611459696737387_p
w(3)=2.592502729955095e-3_p
x(4)=8.928177386765427_p
w(4)=3.592538780455378e-4_p
x(5)=12.02027704430253_p
w(5)=2.071523399997749e-5_p
x(6)=15.52577768312552_p
w(6)=5.764435967572054e-7_p
else if(N==7)then
x(1)=4.163002931813033_p
w(1)=6.413025642031195e-3_p
x(2)=4.861005224394240_p
w(2)=7.525150058786783e-3_p
x(3)=6.126616206310114_p
w(3)=3.387592962849499e-3_p
x(4)=7.974369097866464_p
w(4)=7.367820751092477e-4_p
x(5)=10.40040174143595_p
w(5)=8.202777726651915e-5_p
x(6)=13.29208117092336_p
w(6)=5.074151705558950e-6_p
x(7)=16.05777084246198_p
w(7)=2.338506846064527e-7_p
else if(N==8)then
x(1)=4.136398385750642_p
w(1)=5.506372160912233e-3_p
x(2)=4.719085347936576_p
w(2)=7.216725294705256e-3_p
x(3)=5.769468386811186_p
w(3)=3.999372920403097e-3_p
x(4)=7.289328343225610_p
w(4)=1.196167454768374e-3_p
x(5)=9.267480209887202_p
w(5)=2.072698110835299e-4_p
x(6)=11.64474487530396_p
w(6)=2.216776497991979e-5_p
x(7)=14.21261403078996_p
w(7)=1.688225757454445e-6_p
x(8)=16.35691281149508_p
w(8)=1.228858235459700e-7_p
else if(N==9)then
x(1)=4.115815406479634_p
w(1)=4.769877112535362e-3_p
x(2)=4.609865309057788_p
w(2)=6.809904254836532e-3_p
x(3)=5.497404635275884_p
w(3)=4.421860690205723e-3_p
x(4)=6.775090845915776_p
w(4)=1.676501473134877e-3_p
x(5)=8.430151770387321_p
w(5)=4.001432275814650e-4_p
x(6)=10.42375884054437_p
w(6)=6.350678933162918e-5_p
x(7)=12.65295987293189_p
w(7)=7.298169934131045e-6_p
x(8)=14.86669614694791_p
w(8)=7.193409340455239e-7_p
x(9)=16.53665585797858_p
w(9)=7.545993964533393e-8_p
else if(N==10)then
x(1)=4.099564976631314_p
w(1)=4.166034045696497e-3_p
x(2)=4.523927904847155_p
w(2)=6.364014669748928e-3_p
x(3)=5.284716551739718_p
w(3)=4.678052199520333e-3_p
x(4)=6.376694841222015_p
w(4)=2.129774857096831e-3_p
x(5)=7.787551891491747_p
w(5)=6.481190022893790e-4_p
x(6)=9.489042826264086_p
w(6)=1.385056600432560e-4_p
x(7)=11.41959486891987_p
w(7)=2.206938791835693e-5_p
x(8)=13.45091934053993_p
w(8)=2.896747787375841e-6_p
x(9)=15.33294503177874_p
w(9)=3.687840423316529e-7_p
x(10)=16.65156808561009_p
w(10)=5.116429012000386e-8_p
else if(N==11)then
x(1)=4.086510846881587_p
w(1)=3.666256525652420e-3_p
x(2)=4.455047377101364_p
w(2)=5.913856398358604e-3_p
x(3)=5.114956309777525_p
w(3)=4.800387754289259e-3_p
x(4)=6.060534336718547_p
w(4)=2.526383404459666e-3_p
x(5)=7.280617360953906_p
w(5)=9.301140538402049e-4_p
x(6)=8.753504949432998_p
w(6)=2.506847265634066e-4_p
x(7)=10.43792565348177_p
w(7)=5.182224932303952e-5_p
x(8)=12.25754380272236_p
w(8)=8.778209302607514e-6_p
x(9)=14.07637222745289_p
w(9)=1.349787656329875e-6_p
x(10)=15.67022656778557_p
w(10)=2.163179008544333e-7_p
x(11)=16.72897303563351_p
w(11)=3.709108701675163e-8_p
else if(N==12)then
x(1)=4.075866248160612_p
w(1)=3.248810195746238e-3_p
x(2)=4.398963921685168_p
w(2)=5.478833001628937e-3_p
x(3)=4.977116614335766_p
w(3)=4.820932300581937e-3_p
x(4)=5.804783105877384_p
w(4)=2.852704252613662e-3_p
x(5)=6.872103261732804_p
w(5)=1.223875449884501e-3_p
x(6)=8.161846389361299_p
w(6)=3.971951482775156e-4_p
x(7)=9.644283013794704_p
w(7)=1.013500202484632e-4_p
x(8)=11.26913273478985_p
w(8)=2.133427425819079e-5_p
x(9)=12.95346750750363_p
w(9)=3.966854106539669e-6_p
x(10)=14.56640814214891_p
w(10)=7.168654317133494e-7_p
x(11)=15.91899841630488_p
w(11)=1.399564524396168e-7_p
x(12)=16.78339957682712_p
w(12)=2.819920327277711e-8_p
else if(N==13)then
x(1)=4.067072466143472_p
w(1)=2.897100990857310e-3_p
x(2)=4.352677637071432_p
w(2)=5.068958039491507e-3_p
x(3)=4.863564371293114_p
w(3)=4.767369519139477e-3_p
x(4)=5.594614178616130_p
w(4)=3.106331695129053e-3_p
x(5)=6.537222690442946_p
w(5)=1.510498942865949e-3_p
x(6)=7.677402746033162_p
w(6)=5.705453309216351e-4_p
x(7)=8.992682119106716_p
w(7)=1.730722897297644e-4_p
x(8)=10.4475487620155_p
w(8)=4.376961320942759e-5_p
x(9)=11.98696421400733_p
w(9)=9.690937089631370e-6_p
x(10)=13.52805836261117_p
w(10)=2.007068065083443e-6_p
x(11)=14.95238747232785_p
w(11)=4.225386716574184e-7_p
x(12)=16.10627166597665_p
w(12)=9.734295257344661e-8_p
x(13)=16.82304313243811_p
w(13)=2.221031034152586e-8_p
else if(N==14)then
x(1)=4.059723875635756_p
w(1)=2.598368129402935e-3_p
x(2)=4.314023536454804_p
w(2)=4.688645008187355e-3_p
x(3)=4.768850945803797_p
w(3)=4.661978832454920e-3_p
x(4)=5.419596826253718_p
w(4)=3.291619791018857e-3_p
x(5)=6.258790896268404_p
w(5)=1.776205605224718e-3_p
x(6)=7.274894932182518_p
w(6)=7.609907333070768e-4_p
x(7)=8.450336085812900_p
w(7)=2.666352111013197e-4_p
x(8)=9.758757783412150_p
w(8)=7.877098646468158e-5_p
x(9)=11.16128789438532_p
w(9)=2.036224473295222e-5_p
x(10)=12.6018141188916_p
w(10)=4.831688538957216e-6_p
x(11)=14.00205380732817_p
w(11)=1.118399565462285e-6_p
x(12)=15.25899387463883_p
w(12)=2.704263786820127e-7_p
x(13)=16.25004589019523_p
w(13)=7.148631434369115e-8_p
x(14)=16.8527760219778_p
w(14)=1.797574114867176e-8_p
else if(N==15)then
x(1)=4.053520217412009_p
w(1)=2.342714935921912e-3_p
x(2)=4.281405913592567_p
w(2)=4.339048565046083e-3_p
x(3)=4.688992107207690_p
w(3)=4.521945841203153e-3_p
x(4)=5.272183450579605_p
w(4)=3.416359090381408e-3_p
x(5)=6.024503827800082_p
w(5)=2.012354884695025e-3_p
x(6)=6.936316035739250_p
w(6)=9.585806719434994e-4_p
x(7)=7.993530420279601_p
w(7)=3.793027872503444e-4_p
x(8)=9.175859632088612_p
w(8)=1.279373350502113e-4_p
x(9)=10.45454521096808_p
w(9)=3.788201364421393e-5_p
x(10)=11.78953492336713_p
w(10)=1.020992321697686e-5_p
x(11)=13.12640473684803_p
w(11)=2.620461324696639e-6_p
x(12)=14.39401032833179_p
w(12)=6.756957673147547e-7_p
x(13)=15.50499467181045_p
w(13)=1.847151225360198e-7_p
x(14)=16.3624468219194_p
w(14)=5.473238273542960e-8_p
x(15)=16.87562952297545_p
w(15)=1.486548329944378e-8_p
else if(N==16)then
x(1)=4.048235372169332_p
w(1)=2.122396968021144e-3_p
x(2)=4.253626867801615_p
w(2)=4.019492358143025e-3_p
x(3)=4.621014178681905_p
w(3)=4.360152731854007e-3_p
x(4)=5.146783975808155_p
w(4)=3.489596749682613e-3_p
x(5)=5.825318948857258_p
w(5)=2.214608001396474e-3_p
x(6)=6.648488233796260_p
w(6)=1.154495730741941e-3_p
x(7)=7.604776389642542_p
w(7)=5.067506917185780e-4_p
x(8)=8.678130533612348_p
w(8)=1.915409233108323e-4_p
x(9)=9.846508839654357_p
w(9)=6.386937592769640e-5_p
x(10)=11.08011785757255_p
w(10)=1.933054950676506e-5_p
x(11)=12.33945918523495_p
w(11)=5.496839946447017e-6_p
x(12)=13.57360118656186_p
w(12)=1.530344468552071e-6_p
x(13)=14.71958093461897_p
w(13)=4.365741920318381e-7_p
x(14)=15.70445040787866_p
w(14)=1.328754122635554e-7_p
x(15)=16.45177882440906_p
w(15)=4.329387126358659e-8_p
x(16)=16.89356452247445_p
w(16)=1.251023977501612e-8_p
else if(N==17)then
x(1)=4.043696423175873_p
w(1)=1.931299350435246e-3_p
x(2)=4.229772487379928_p
w(2)=3.728330757938811e-3_p
x(3)=4.562658162201488_p
w(3)=4.186048714451315e-3_p
x(4)=5.039175917192876_p
w(4)=3.520344875055647e-3_p
x(5)=5.654445061530973_p
w(5)=2.381840152780004e-3_p
x(6)=6.401547522238984_p
w(6)=1.341703985293349e-3_p
x(7)=7.270927916424251_p
w(7)=6.439181240485012e-4_p
x(8)=8.249607659868182_p
w(8)=2.685987767907575e-4_p
x(9)=9.320221593754180_p
w(9)=9.939324044768377e-5_p
x(10)=10.45987380764372_p
w(10)=3.338965572511054e-5_p
x(11)=11.6388662015401_p
w(11)=1.046362634334644e-5_p
x(12)=12.81949003852636_p
w(12)=3.158788600146805e-6_p
x(13)=13.95529501977086_p
w(13)=9.528094849016184e-7_p
x(14)=14.99154889646442_p
w(14)=2.981920025771495e-7_p
x(15)=15.86785850515954_p
w(15)=9.963998401801290e-8_p
x(16)=16.52383506497614_p
w(16)=3.514743243740629e-8_p
x(17)=16.90789277935819_p
w(17)=1.068161955683743e-8_p
else
call GD(4)
end if
end subroutine GF_4

! [5kT;17kT]
subroutine GF_5(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=5.585685789315574_p
w(1)=5.725618818548050e-3_p
x(2)=8.407819620313749_p
w(2)=9.896882711936876e-4_p
else if(N==3)then
x(1)=5.410674985136263_p
w(1)=4.731817918761507e-3_p
x(2)=7.259132695202500_p
w(2)=1.905753064516841e-3_p
x(3)=11.14263302944446_p
w(3)=7.773610646338923e-5_p
else if(N==4)then
x(1)=5.308458147519289_p
w(1)=3.917571135093787e-3_p
x(2)=6.660887862795100_p
w(2)=2.474821506488775e-3_p
x(3)=9.264531354803113_p
w(3)=3.157663923211336e-4_p
x(4)=13.4903179746552_p
w(4)=7.148055838042882e-6_p
else if(N==5)then
x(1)=5.240243559162211_p
w(1)=3.257978059294296e-3_p
x(2)=6.279896750005975_p
w(2)=2.751660990256872e-3_p
x(3)=8.211341983976922_p
w(3)=6.541421878572413e-4_p
x(4)=11.13547064198207_p
w(4)=5.029473166132618e-5_p
x(5)=14.97981904854982_p
w(5)=1.231120672001938e-6_p
else if(N==6)then
x(1)=5.192296185971829_p
w(1)=2.731625723895412e-3_p
x(2)=6.018594510465442_p
w(2)=2.821599092013318e-3_p
x(3)=7.527020846682468_p
w(3)=1.000645532952065e-3_p
x(4)=9.746050194108145_p
w(4)=1.508568374989204e-4_p
x(5)=12.64913294518026_p
w(5)=1.019911683139000e-5_p
x(6)=15.78159453269065_p
w(6)=3.807865506333071e-7_p
else if(N==7)then
x(1)=5.157379438772944_p
w(1)=2.312898192437754e-3_p
x(2)=5.830942750533400_p
w(2)=2.764259735334109e-3_p
x(3)=7.049062305992718_p
w(3)=1.294980462889660e-3_p
x(4)=8.816130722719498_p
w(4)=3.023033063006101e-4_p
x(5)=11.10755011014033_p
w(5)=3.785739937645715e-5_p
x(6)=13.77379631311535_p
w(6)=2.837105473864295e-6_p
x(7)=16.21051071404576_p
w(7)=1.708879292843860e-7_p
else if(N==8)then
x(1)=5.131179999645178_p
w(1)=1.977877196232444e-3_p
x(2)=5.691309064912246_p
w(2)=2.637028600384088e-3_p
x(3)=6.698958807791200_p
w(3)=1.514778726700453e-3_p
x(4)=8.149960353920568_p
w(4)=4.814850063871101e-4_p
x(5)=10.02211482973692_p
w(5)=9.169663700225861e-5_p
x(6)=12.23903927685544_p
w(6)=1.129493745287783e-5_p
x(7)=14.5749180348222_p
w(7)=1.050529118956625e-6_p
x(8)=16.4541490155796_p
w(8)=9.545646354972219e-8_p
else if(N==9)then
x(1)=5.111021140240781_p
w(1)=1.707370233240015e-3_p
x(2)=5.584423705549130_p
w(2)=2.476454713927189e-3_p
x(3)=6.433481456393730_p
w(3)=1.660781484959776e-3_p
x(4)=7.651206514241347_p
w(4)=6.640487038660193e-4_p
x(5)=9.218392343043792_p
w(5)=1.715600728317642e-4_p
x(6)=11.0869842743198_p
w(6)=3.046493209145148e-5_p
x(7)=13.14388346720437_p
w(7)=4.079687998952340e-6_p
x(8)=15.13971215052134_p
w(8)=4.863399811647864e-7_p
x(9)=16.60247330457158_p
w(9)=6.092084540492697e-8_p
else if(N==10)then
x(1)=5.095178384116013_p
w(1)=1.486731319136499e-3_p
x(2)=5.500699347170253_p
w(2)=2.304367150160453e-3_p
x(3)=6.226748780171750_p
w(3)=1.743889542724898e-3_p
x(4)=7.265790240113408_p
w(4)=8.321005961864848e-4_p
x(5)=8.601526413856901_p
w(5)=2.710839726779549e-4_p
x(6)=10.20028469123762_p
w(6)=6.360711352337512e-5_p
x(7)=11.99453821252926_p
w(7)=1.146415201348892e-5_p
x(8)=13.85357082639644_p
w(8)=1.755543228737399e-6_p
x(9)=15.54141760716101_p
w(9)=2.653189845214899e-7_p
x(10)=16.69846472008827_p
w(10)=4.238110532485806e-8_p
else if(N==11)then
x(1)=5.082501421960169_p
w(1)=1.304935055395759e-3_p
x(2)=5.433848381513870_p
w(2)=2.133175704183227e-3_p
x(3)=6.062297572501661_p
w(3)=1.777669550817263e-3_p
x(4)=6.960663830813893_p
w(4)=9.755059329001750e-4_p
x(5)=8.115217352726793_p
w(5)=3.812261091871733e-4_p
x(6)=9.500860392296113_p
w(6)=1.113088420010318e-4_p
x(7)=11.0726595301107_p
w(7)=2.550795471832604e-5_p
x(8)=12.75201547233681_p
w(8)=4.908545652232452e-6_p
x(9)=14.40674737649601_p
w(9)=8.751171901314291e-7_p
x(10)=15.83229195195278_p
w(10)=1.629961786454772e-7_p
x(11)=16.76380623535127_p
w(11)=3.128151777305357e-8_p
else if(N==12)then
x(1)=5.072199256653432_p
w(1)=1.153681161615962e-3_p
x(2)=5.379596802623467_p
w(2)=1.969532236935228e-3_p
x(3)=5.929163300154380_p
w(3)=1.774851939135543e-3_p
x(4)=6.714389474327972_p
w(4)=1.090354495637853e-3_p
x(5)=7.723721681384369_p
w(5)=4.931845668205378e-4_p
x(6)=8.937711404659439_p
w(6)=1.716392534310143e-4_p
x(7)=10.32427731067646_p
w(7)=4.784801694209802e-5_p
x(8)=11.83147670522374_p
w(8)=1.122278273668335e-5_p
x(9)=13.37739116761895_p
w(9)=2.368276154232976e-6_p
x(10)=14.83888950751527_p
w(10)=4.910822640025407e-7_p
x(11)=16.04738664349254_p
w(11)=1.091809600383073e-7_p
x(12)=16.8101569948746_p
w(12)=2.409710854459952e-8_p
else if(N==13)then
x(1)=5.063713464488886_p
w(1)=1.026684325899676e-3_p
x(2)=5.334951418817323_p
w(2)=1.816665061377286e-3_p
x(3)=5.819774569350126_p
w(3)=1.746064781563820e-3_p
x(4)=6.512426698001421_p
w(4)=1.176828158400580e-3_p
x(5)=7.403167081521411_p
w(5)=5.999520861861977e-4_p
x(6)=8.476518882267662_p
w(6)=2.410682520945688e-4_p
x(7)=9.708447502398515_p
w(7)=7.901166075748023e-5_p
x(8)=11.06227564679223_p
w(8)=2.194409816335655e-5_p
x(9)=12.48315908630309_p
w(9)=5.420699159138909e-6_p
x(10)=13.89164973827126_p
w(10)=1.268190859463476e-6_p
x(11)=15.17889418521292_p
w(11)=3.026363788424919e-7_p
x(12)=16.20983310575318_p
w(12)=7.796961127486949e-8_p
x(13)=16.84416868464086_p
w(13)=1.916929005297798e-8_p
else if(N==14)then
x(1)=5.056640685337000_p
w(1)=9.191449334136531e-4_p
x(2)=5.297762482859831_p
w(2)=1.675814685886670e-3_p
x(3)=5.728747147192721_p
w(3)=1.699641696068421e-3_p
x(4)=6.344564082374890_p
w(4)=1.237397187570626e-3_p
x(5)=7.136973002956279_p
w(5)=6.967623710084717e-4_p
x(6)=8.093416215514260_p
w(6)=3.154894095965935e-4_p
x(7)=9.195257067455062_p
w(7)=1.183948311364481e-4_p
x(8)=10.41532836496211_p
w(8)=3.798167827892040e-5_p
x(9)=11.71472134342473_p
w(9)=1.080735319296001e-5_p
x(10)=13.03900425244174_p
w(10)=2.856366171545573e-6_p
x(11)=14.31479115130952_p
w(11)=7.417198807483301e-7_p
x(12)=15.44900290179719_p
w(12)=2.007813295953285e-7_p
x(13)=16.33497372390758_p
w(13)=5.844080012212650e-8_p
x(14)=16.86983725231144_p
w(14)=1.563540696274757e-8_p
else if(N==15)then
x(1)=5.050683661221357_p
w(1)=8.273631445510032e-4_p
x(2)=5.266452221476413_p
w(2)=1.547100467365249e-3_p
x(3)=5.652157300903673_p
w(3)=1.641868840562599e-3_p
x(4)=6.203426145862437_p
w(4)=1.275561424070098e-3_p
x(5)=6.913258767533178_p
w(5)=7.809056153432879e-4_p
x(6)=7.771312476220207_p
w(6)=3.909942751603540e-4_p
x(7)=8.762761156266656_p
w(7)=1.645287696618911e-4_p
x(8)=9.866752814514482_p
w(8)=5.972241615181079e-5_p
x(9)=11.05444462177744_p
w(9)=1.925610605158053e-5_p
x(10)=12.28669669666193_p
w(10)=5.712519484106452e-6_p
x(11)=13.51180089884073_p
w(11)=1.626965659998254e-6_p
x(12)=14.66419048735841_p
w(12)=4.668634547613433e-7_p
x(13)=15.66589672460952_p
w(13)=1.412022755964922e-7_p
x(14)=16.43313490819423_p
w(14)=4.546942210184256e-8_p
x(15)=16.88967184361366_p
w(15)=1.301052730024458e-8_p
else if(N==16)then
x(1)=5.045619411255917_p
w(1)=7.484590656689274e-4_p
x(2)=5.239840641307069_p
w(2)=1.430037422729195e-3_p
x(3)=5.587085581065477_p
w(3)=1.577361828449446e-3_p
x(4)=6.083560322855190_p
w(4)=1.295072137719831e-3_p
x(5)=6.723291751103955_p
w(5)=8.512886305648907e-4_p
x(6)=7.497658484749345_p
w(6)=4.643163971829860e-4_p
x(7)=8.394630410081428_p
w(7)=2.154531717704700e-4_p
x(8)=9.397760981355454_p
w(8)=8.699639314455915e-5_p
x(9)=10.48493275425076_p
w(9)=3.131134618107989e-5_p
x(10)=11.62689787619414_p
w(10)=1.032829592365390e-5_p
x(11)=12.78578434476278_p
w(11)=3.226820673745839e-6_p
x(12)=13.9139862014084_p
w(12)=9.918585954561963e-7_p
x(13)=14.95422681650451_p
w(13)=3.122632183100662e-7_p
x(14)=15.84197048187051_p
w(14)=1.040210557494446e-7_p
x(15)=16.51139676153426_p
w(15)=3.643216201013909e-8_p
x(16)=16.90530882080698_p
w(16)=1.100470142625346e-8_p
else if(N==17)then
x(1)=5.041278015144829_p
w(1)=6.801694310945620e-4_p
x(2)=5.217030514726936_p
w(2)=1.323840941284152e-3_p
x(3)=5.531320468015633_p
w(3)=1.509437940892464e-3_p
x(4)=5.980855485723056_p
w(4)=1.299500990474312e-3_p
x(5)=6.560515246776990_p
w(5)=9.079587134984140e-4_p
x(6)=7.263041105213270_p
w(6)=5.330012519480390e-4_p
x(7)=8.078517063093599_p
w(7)=2.690636208907630e-4_p
x(8)=8.993691066554421_p
w(8)=1.191600382709394e-4_p
x(9)=9.991145552692110_p
w(9)=4.724707118643410e-5_p
x(10)=11.04834242924652_p
w(10)=1.715565718859800e-5_p
x(11)=12.13662740291281_p
w(11)=5.855661550206650e-6_p
x(12)=13.2203939292994_p
w(12)=1.936194168535790e-6_p
x(13)=14.256782030527_p
w(13)=6.411000058081710e-7_p
x(14)=15.19649364121017_p
w(14)=2.196089556640700e-7_p
x(15)=15.98643370410774_p
w(15)=7.954550568478480e-8_p
x(16)=16.57470922034575_p
w(16)=2.988715592186640e-8_p
x(17)=16.91785066931466_p
w(17)=9.435671238573389e-9_p
else
call GD(5)
end if
end subroutine GF_5

end module m_gauss_fermi_17
