/*
 * This declarations of the PIC16F1764 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2016.
 *
 * This file is generated automatically by the cinc2h.pl, 2016-04-13 17:23:13 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC16F1764_H__
#define __PIC16F1764_H__

//==============================================================================
//
//	Register Addresses
//
//==============================================================================

#ifndef NO_ADDR_DEFINES

#define INDF0_ADDR              0x0000
#define INDF1_ADDR              0x0001
#define PCL_ADDR                0x0002
#define STATUS_ADDR             0x0003
#define FSR0_ADDR               0x0004
#define FSR0L_ADDR              0x0004
#define FSR0H_ADDR              0x0005
#define FSR1_ADDR               0x0006
#define FSR1L_ADDR              0x0006
#define FSR1H_ADDR              0x0007
#define BSR_ADDR                0x0008
#define WREG_ADDR               0x0009
#define PCLATH_ADDR             0x000A
#define INTCON_ADDR             0x000B
#define PORTA_ADDR              0x000C
#define PORTC_ADDR              0x000E
#define PIR1_ADDR               0x0011
#define PIR2_ADDR               0x0012
#define PIR3_ADDR               0x0013
#define PIR4_ADDR               0x0014
#define TMR0_ADDR               0x0015
#define TMR1_ADDR               0x0016
#define TMR1L_ADDR              0x0016
#define TMR1H_ADDR              0x0017
#define T1CON_ADDR              0x0018
#define T1GCON_ADDR             0x0019
#define T2TMR_ADDR              0x001A
#define TMR2_ADDR               0x001A
#define PR2_ADDR                0x001B
#define T2PR_ADDR               0x001B
#define T2CON_ADDR              0x001C
#define T2HLT_ADDR              0x001D
#define T2CLKCON_ADDR           0x001E
#define T2RST_ADDR              0x001F
#define TRISA_ADDR              0x008C
#define TRISC_ADDR              0x008E
#define PIE1_ADDR               0x0091
#define PIE2_ADDR               0x0092
#define PIE3_ADDR               0x0093
#define PIE4_ADDR               0x0094
#define OPTION_REG_ADDR         0x0095
#define PCON_ADDR               0x0096
#define WDTCON_ADDR             0x0097
#define OSCTUNE_ADDR            0x0098
#define OSCCON_ADDR             0x0099
#define OSCSTAT_ADDR            0x009A
#define ADRES_ADDR              0x009B
#define ADRESL_ADDR             0x009B
#define ADRESH_ADDR             0x009C
#define ADCON0_ADDR             0x009D
#define ADCON1_ADDR             0x009E
#define ADCON2_ADDR             0x009F
#define LATA_ADDR               0x010C
#define LATC_ADDR               0x010E
#define CMOUT_ADDR              0x010F
#define CM1CON0_ADDR            0x0110
#define CM1CON1_ADDR            0x0111
#define CM1NSEL_ADDR            0x0112
#define CM1PSEL_ADDR            0x0113
#define CM2CON0_ADDR            0x0114
#define CM2CON1_ADDR            0x0115
#define CM2NSEL_ADDR            0x0116
#define CM2PSEL_ADDR            0x0117
#define ANSELA_ADDR             0x018C
#define ANSELC_ADDR             0x018E
#define PMADR_ADDR              0x0191
#define PMADRL_ADDR             0x0191
#define PMADRH_ADDR             0x0192
#define PMDAT_ADDR              0x0193
#define PMDATL_ADDR             0x0193
#define PMDATH_ADDR             0x0194
#define PMCON1_ADDR             0x0195
#define PMCON2_ADDR             0x0196
#define VREGCON_ADDR            0x0197
#define RC1REG_ADDR             0x0199
#define RCREG_ADDR              0x0199
#define RCREG1_ADDR             0x0199
#define TX1REG_ADDR             0x019A
#define TXREG_ADDR              0x019A
#define TXREG1_ADDR             0x019A
#define SP1BRG_ADDR             0x019B
#define SP1BRGL_ADDR            0x019B
#define SPBRG_ADDR              0x019B
#define SPBRG1_ADDR             0x019B
#define SPBRGL_ADDR             0x019B
#define SP1BRGH_ADDR            0x019C
#define SPBRGH_ADDR             0x019C
#define SPBRGH1_ADDR            0x019C
#define RC1STA_ADDR             0x019D
#define RCSTA_ADDR              0x019D
#define RCSTA1_ADDR             0x019D
#define TX1STA_ADDR             0x019E
#define TXSTA_ADDR              0x019E
#define TXSTA1_ADDR             0x019E
#define BAUD1CON_ADDR           0x019F
#define BAUDCON_ADDR            0x019F
#define BAUDCON1_ADDR           0x019F
#define BAUDCTL_ADDR            0x019F
#define BAUDCTL1_ADDR           0x019F
#define WPUA_ADDR               0x020C
#define WPUC_ADDR               0x020E
#define SSP1BUF_ADDR            0x0211
#define SSPBUF_ADDR             0x0211
#define SSP1ADD_ADDR            0x0212
#define SSPADD_ADDR             0x0212
#define SSP1MSK_ADDR            0x0213
#define SSPMSK_ADDR             0x0213
#define SSP1STAT_ADDR           0x0214
#define SSPSTAT_ADDR            0x0214
#define SSP1CON_ADDR            0x0215
#define SSP1CON1_ADDR           0x0215
#define SSPCON_ADDR             0x0215
#define SSPCON1_ADDR            0x0215
#define SSP1CON2_ADDR           0x0216
#define SSPCON2_ADDR            0x0216
#define SSP1CON3_ADDR           0x0217
#define SSPCON3_ADDR            0x0217
#define BORCON_ADDR             0x021D
#define FVRCON_ADDR             0x021E
#define ZCD1CON_ADDR            0x021F
#define ODCONA_ADDR             0x028C
#define ODCONC_ADDR             0x028E
#define CCPR1_ADDR              0x0291
#define CCPR1L_ADDR             0x0291
#define CCPR1H_ADDR             0x0292
#define CCP1CON_ADDR            0x0293
#define CCP1CAP_ADDR            0x0294
#define CCPTMRS_ADDR            0x029E
#define SLRCONA_ADDR            0x030C
#define SLRCONC_ADDR            0x030E
#define INLVLA_ADDR             0x038C
#define INLVLC_ADDR             0x038E
#define IOCAP_ADDR              0x0391
#define IOCAN_ADDR              0x0392
#define IOCAF_ADDR              0x0393
#define IOCCP_ADDR              0x0397
#define IOCCN_ADDR              0x0398
#define IOCCF_ADDR              0x0399
#define MD1CON0_ADDR            0x039B
#define MD1CON1_ADDR            0x039C
#define MD1SRC_ADDR             0x039D
#define MD1CARL_ADDR            0x039E
#define MD1CARH_ADDR            0x039F
#define HIDRVC_ADDR             0x040E
#define T4TMR_ADDR              0x0413
#define TMR4_ADDR               0x0413
#define PR4_ADDR                0x0414
#define T4PR_ADDR               0x0414
#define T4CON_ADDR              0x0415
#define T4HLT_ADDR              0x0416
#define T4CLKCON_ADDR           0x0417
#define T4RST_ADDR              0x0418
#define T6TMR_ADDR              0x041A
#define TMR6_ADDR               0x041A
#define PR6_ADDR                0x041B
#define T6PR_ADDR               0x041B
#define T6CON_ADDR              0x041C
#define T6HLT_ADDR              0x041D
#define T6CLKCON_ADDR           0x041E
#define T6RST_ADDR              0x041F
#define TMR3_ADDR               0x0493
#define TMR3L_ADDR              0x0493
#define TMR3H_ADDR              0x0494
#define T3CON_ADDR              0x0495
#define T3GCON_ADDR             0x0496
#define TMR5_ADDR               0x049A
#define TMR5L_ADDR              0x049A
#define TMR5H_ADDR              0x049B
#define T5CON_ADDR              0x049C
#define T5GCON_ADDR             0x049D
#define OPA1NCHS_ADDR           0x050F
#define OPA1PCHS_ADDR           0x0510
#define OPA1CON_ADDR            0x0511
#define OPA1ORS_ADDR            0x0512
#define DACLD_ADDR              0x0590
#define DAC1CON0_ADDR           0x0591
#define DAC1CON1_ADDR           0x0592
#define DAC1REF_ADDR            0x0592
#define DAC1REFL_ADDR           0x0592
#define DAC1CON2_ADDR           0x0593
#define DAC1REFH_ADDR           0x0593
#define DAC3CON0_ADDR           0x0597
#define DAC3CON1_ADDR           0x0598
#define DAC3REF_ADDR            0x0598
#define PWM3DCL_ADDR            0x0617
#define PWM3DCH_ADDR            0x0618
#define PWM3CON_ADDR            0x0619
#define COG1PHR_ADDR            0x068D
#define COG1PHF_ADDR            0x068E
#define COG1BLKR_ADDR           0x068F
#define COG1BLKF_ADDR           0x0690
#define COG1DBR_ADDR            0x0691
#define COG1DBF_ADDR            0x0692
#define COG1CON0_ADDR           0x0693
#define COG1CON1_ADDR           0x0694
#define COG1RIS0_ADDR           0x0695
#define COG1RIS1_ADDR           0x0696
#define COG1RSIM0_ADDR          0x0697
#define COG1RSIM1_ADDR          0x0698
#define COG1FIS0_ADDR           0x0699
#define COG1FIS1_ADDR           0x069A
#define COG1FSIM0_ADDR          0x069B
#define COG1FSIM1_ADDR          0x069C
#define COG1ASD0_ADDR           0x069D
#define COG1ASD1_ADDR           0x069E
#define COG1STR_ADDR            0x069F
#define PRG1RTSS_ADDR           0x0794
#define PRG1FTSS_ADDR           0x0795
#define PRG1INS_ADDR            0x0796
#define PRG1CON0_ADDR           0x0797
#define PRG1CON1_ADDR           0x0798
#define PRG1CON2_ADDR           0x0799
#define PWMEN_ADDR              0x0D8E
#define PWMLD_ADDR              0x0D8F
#define PWMOUT_ADDR             0x0D90
#define PWM5PH_ADDR             0x0D91
#define PWM5PHL_ADDR            0x0D91
#define PWM5PHH_ADDR            0x0D92
#define PWM5DC_ADDR             0x0D93
#define PWM5DCL_ADDR            0x0D93
#define PWM5DCH_ADDR            0x0D94
#define PWM5PR_ADDR             0x0D95
#define PWM5PRL_ADDR            0x0D95
#define PWM5PRH_ADDR            0x0D96
#define PWM5OF_ADDR             0x0D97
#define PWM5OFL_ADDR            0x0D97
#define PWM5OFH_ADDR            0x0D98
#define PWM5TMR_ADDR            0x0D99
#define PWM5TMRL_ADDR           0x0D99
#define PWM5TMRH_ADDR           0x0D9A
#define PWM5CON_ADDR            0x0D9B
#define PWM5INTCON_ADDR         0x0D9C
#define PWM5INTE_ADDR           0x0D9C
#define PWM5INTF_ADDR           0x0D9D
#define PWM5INTFLG_ADDR         0x0D9D
#define PWM5CLKCON_ADDR         0x0D9E
#define PWM5LDCON_ADDR          0x0D9F
#define PWM5OFCON_ADDR          0x0DA0
#define PPSLOCK_ADDR            0x0E0F
#define INTPPS_ADDR             0x0E10
#define T0CKIPPS_ADDR           0x0E11
#define T1CKIPPS_ADDR           0x0E12
#define T1GPPS_ADDR             0x0E13
#define CCP1PPS_ADDR            0x0E14
#define COG1INPPS_ADDR          0x0E16
#define T2CKIPPS_ADDR           0x0E19
#define T3CKIPPS_ADDR           0x0E1A
#define T3GPPS_ADDR             0x0E1B
#define T4CKIPPS_ADDR           0x0E1C
#define T5CKIPPS_ADDR           0x0E1D
#define T5GPPS_ADDR             0x0E1E
#define T6CKIPPS_ADDR           0x0E1F
#define SSPCLKPPS_ADDR          0x0E20
#define SSPDATPPS_ADDR          0x0E21
#define SSPSSPPS_ADDR           0x0E22
#define RXPPS_ADDR              0x0E24
#define CKPPS_ADDR              0x0E25
#define CLCIN0PPS_ADDR          0x0E28
#define CLCIN1PPS_ADDR          0x0E29
#define CLCIN2PPS_ADDR          0x0E2A
#define CLCIN3PPS_ADDR          0x0E2B
#define PRG1RPPS_ADDR           0x0E2C
#define PRG1FPPS_ADDR           0x0E2D
#define MD1CHPPS_ADDR           0x0E30
#define MD1CLPPS_ADDR           0x0E31
#define MD1MODPPS_ADDR          0x0E32
#define RA0PPS_ADDR             0x0E90
#define RA1PPS_ADDR             0x0E91
#define RA2PPS_ADDR             0x0E92
#define RA4PPS_ADDR             0x0E94
#define RA5PPS_ADDR             0x0E95
#define RC0PPS_ADDR             0x0EA0
#define RC1PPS_ADDR             0x0EA1
#define RC2PPS_ADDR             0x0EA2
#define RC3PPS_ADDR             0x0EA3
#define RC4PPS_ADDR             0x0EA4
#define RC5PPS_ADDR             0x0EA5
#define CLCDATA_ADDR            0x0F0F
#define CLC1CON_ADDR            0x0F10
#define CLC1POL_ADDR            0x0F11
#define CLC1SEL0_ADDR           0x0F12
#define CLC1SEL1_ADDR           0x0F13
#define CLC1SEL2_ADDR           0x0F14
#define CLC1SEL3_ADDR           0x0F15
#define CLC1GLS0_ADDR           0x0F16
#define CLC1GLS1_ADDR           0x0F17
#define CLC1GLS2_ADDR           0x0F18
#define CLC1GLS3_ADDR           0x0F19
#define CLC2CON_ADDR            0x0F1A
#define CLC2POL_ADDR            0x0F1B
#define CLC2SEL0_ADDR           0x0F1C
#define CLC2SEL1_ADDR           0x0F1D
#define CLC2SEL2_ADDR           0x0F1E
#define CLC2SEL3_ADDR           0x0F1F
#define CLC2GLS0_ADDR           0x0F20
#define CLC2GLS1_ADDR           0x0F21
#define CLC2GLS2_ADDR           0x0F22
#define CLC2GLS3_ADDR           0x0F23
#define CLC3CON_ADDR            0x0F24
#define CLC3POL_ADDR            0x0F25
#define CLC3SEL0_ADDR           0x0F26
#define CLC3SEL1_ADDR           0x0F27
#define CLC3SEL2_ADDR           0x0F28
#define CLC3SEL3_ADDR           0x0F29
#define CLC3GLS0_ADDR           0x0F2A
#define CLC3GLS1_ADDR           0x0F2B
#define CLC3GLS2_ADDR           0x0F2C
#define CLC3GLS3_ADDR           0x0F2D
#define STATUS_SHAD_ADDR        0x0FE4
#define WREG_SHAD_ADDR          0x0FE5
#define BSR_SHAD_ADDR           0x0FE6
#define PCLATH_SHAD_ADDR        0x0FE7
#define FSR0L_SHAD_ADDR         0x0FE8
#define FSR0H_SHAD_ADDR         0x0FE9
#define FSR1L_SHAD_ADDR         0x0FEA
#define FSR1H_SHAD_ADDR         0x0FEB
#define STKPTR_ADDR             0x0FED
#define TOSL_ADDR               0x0FEE
#define TOSH_ADDR               0x0FEF

#endif // #ifndef NO_ADDR_DEFINES

//==============================================================================
//
//	Register Definitions
//
//==============================================================================

extern __at(0x0000) __sfr INDF0;
extern __at(0x0001) __sfr INDF1;
extern __at(0x0002) __sfr PCL;

//==============================================================================
//        STATUS Bits

extern __at(0x0003) __sfr STATUS;

typedef struct
  {
  unsigned C                    : 1;
  unsigned DC                   : 1;
  unsigned Z                    : 1;
  unsigned NOT_PD               : 1;
  unsigned NOT_TO               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUSbits_t;

extern __at(0x0003) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _NOT_PD                 0x08
#define _NOT_TO                 0x10

//==============================================================================

extern __at(0x0004) __sfr FSR0;
extern __at(0x0004) __sfr FSR0L;
extern __at(0x0005) __sfr FSR0H;
extern __at(0x0006) __sfr FSR1;
extern __at(0x0006) __sfr FSR1L;
extern __at(0x0007) __sfr FSR1H;

//==============================================================================
//        BSR Bits

extern __at(0x0008) __sfr BSR;

typedef union
  {
  struct
    {
    unsigned BSR0               : 1;
    unsigned BSR1               : 1;
    unsigned BSR2               : 1;
    unsigned BSR3               : 1;
    unsigned BSR4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned BSR                : 5;
    unsigned                    : 3;
    };
  } __BSRbits_t;

extern __at(0x0008) volatile __BSRbits_t BSRbits;

#define _BSR0                   0x01
#define _BSR1                   0x02
#define _BSR2                   0x04
#define _BSR3                   0x08
#define _BSR4                   0x10

//==============================================================================

extern __at(0x0009) __sfr WREG;
extern __at(0x000A) __sfr PCLATH;

//==============================================================================
//        INTCON Bits

extern __at(0x000B) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned IOCIF              : 1;
    unsigned INTF               : 1;
    unsigned TMR0IF             : 1;
    unsigned IOCIE              : 1;
    unsigned INTE               : 1;
    unsigned TMR0IE             : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __INTCONbits_t;

extern __at(0x000B) volatile __INTCONbits_t INTCONbits;

#define _IOCIF                  0x01
#define _INTF                   0x02
#define _TMR0IF                 0x04
#define _T0IF                   0x04
#define _IOCIE                  0x08
#define _INTE                   0x10
#define _TMR0IE                 0x20
#define _T0IE                   0x20
#define _PEIE                   0x40
#define _GIE                    0x80

//==============================================================================


//==============================================================================
//        PORTA Bits

extern __at(0x000C) __sfr PORTA;

typedef union
  {
  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA                 : 6;
    unsigned                    : 2;
    };
  } __PORTAbits_t;

extern __at(0x000C) volatile __PORTAbits_t PORTAbits;

#define _RA0                    0x01
#define _RA1                    0x02
#define _RA2                    0x04
#define _RA3                    0x08
#define _RA4                    0x10
#define _RA5                    0x20

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x000E) __sfr PORTC;

typedef union
  {
  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned RC3                : 1;
    unsigned RC4                : 1;
    unsigned RC5                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RC                 : 6;
    unsigned                    : 2;
    };
  } __PORTCbits_t;

extern __at(0x000E) volatile __PORTCbits_t PORTCbits;

#define _RC0                    0x01
#define _RC1                    0x02
#define _RC2                    0x04
#define _RC3                    0x08
#define _RC4                    0x10
#define _RC5                    0x20

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x0011) __sfr PIR1;

typedef union
  {
  struct
    {
    unsigned TMR1IF             : 1;
    unsigned TMR2IF             : 1;
    unsigned CCP1IF             : 1;
    unsigned SSP1IF             : 1;
    unsigned TXIF               : 1;
    unsigned RCIF               : 1;
    unsigned ADIF               : 1;
    unsigned TMR1GIF            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCPIF              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIR1bits_t;

extern __at(0x0011) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _CCP1IF                 0x04
#define _CCPIF                  0x04
#define _SSP1IF                 0x08
#define _TXIF                   0x10
#define _RCIF                   0x20
#define _ADIF                   0x40
#define _TMR1GIF                0x80

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x0012) __sfr PIR2;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned BCL1IF               : 1;
  unsigned                      : 1;
  unsigned C1IF                 : 1;
  unsigned C2IF                 : 1;
  unsigned OSFIF                : 1;
  } __PIR2bits_t;

extern __at(0x0012) volatile __PIR2bits_t PIR2bits;

#define _BCL1IF                 0x08
#define _C1IF                   0x20
#define _C2IF                   0x40
#define _OSFIF                  0x80

//==============================================================================


//==============================================================================
//        PIR3 Bits

extern __at(0x0013) __sfr PIR3;

typedef struct
  {
  unsigned CLC1IF               : 1;
  unsigned CLC2IF               : 1;
  unsigned CLC3IF               : 1;
  unsigned                      : 1;
  unsigned ZCDIF                : 1;
  unsigned COG1IF               : 1;
  unsigned PWM5IF               : 1;
  unsigned                      : 1;
  } __PIR3bits_t;

extern __at(0x0013) volatile __PIR3bits_t PIR3bits;

#define _CLC1IF                 0x01
#define _CLC2IF                 0x02
#define _CLC3IF                 0x04
#define _ZCDIF                  0x10
#define _COG1IF                 0x20
#define _PWM5IF                 0x40

//==============================================================================


//==============================================================================
//        PIR4 Bits

extern __at(0x0014) __sfr PIR4;

typedef struct
  {
  unsigned TMR4IF               : 1;
  unsigned TMR6IF               : 1;
  unsigned TMR3IF               : 1;
  unsigned TMR3GIF              : 1;
  unsigned TMR5IF               : 1;
  unsigned TMR5GIF              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIR4bits_t;

extern __at(0x0014) volatile __PIR4bits_t PIR4bits;

#define _TMR4IF                 0x01
#define _TMR6IF                 0x02
#define _TMR3IF                 0x04
#define _TMR3GIF                0x08
#define _TMR5IF                 0x10
#define _TMR5GIF                0x20

//==============================================================================

extern __at(0x0015) __sfr TMR0;
extern __at(0x0016) __sfr TMR1;
extern __at(0x0016) __sfr TMR1L;
extern __at(0x0017) __sfr TMR1H;

//==============================================================================
//        T1CON Bits

extern __at(0x0018) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned ON                 : 1;
    unsigned                    : 1;
    unsigned NOT_SYNC           : 1;
    unsigned OSCEN              : 1;
    unsigned CKPS0              : 1;
    unsigned CKPS1              : 1;
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    };

  struct
    {
    unsigned TMRON              : 1;
    unsigned                    : 1;
    unsigned SYNC               : 1;
    unsigned SOSCEN             : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned T1CS0              : 1;
    unsigned T1CS1              : 1;
    };

  struct
    {
    unsigned TMR1ON             : 1;
    unsigned                    : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned T1OSCEN            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR1CS0            : 1;
    unsigned TMR1CS1            : 1;
    };

  struct
    {
    unsigned T1ON               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CKPS               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR1CS             : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned T1CS               : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned CS                 : 2;
    };
  } __T1CONbits_t;

extern __at(0x0018) volatile __T1CONbits_t T1CONbits;

#define _T1CON_ON               0x01
#define _T1CON_TMRON            0x01
#define _T1CON_TMR1ON           0x01
#define _T1CON_T1ON             0x01
#define _T1CON_NOT_SYNC         0x04
#define _T1CON_SYNC             0x04
#define _T1CON_NOT_T1SYNC       0x04
#define _T1CON_OSCEN            0x08
#define _T1CON_SOSCEN           0x08
#define _T1CON_T1OSCEN          0x08
#define _T1CON_CKPS0            0x10
#define _T1CON_T1CKPS0          0x10
#define _T1CON_CKPS1            0x20
#define _T1CON_T1CKPS1          0x20
#define _T1CON_CS0              0x40
#define _T1CON_T1CS0            0x40
#define _T1CON_TMR1CS0          0x40
#define _T1CON_CS1              0x80
#define _T1CON_T1CS1            0x80
#define _T1CON_TMR1CS1          0x80

//==============================================================================


//==============================================================================
//        T1GCON Bits

extern __at(0x0019) __sfr T1GCON;

typedef union
  {
  struct
    {
    unsigned GSS0               : 1;
    unsigned GSS1               : 1;
    unsigned GVAL               : 1;
    unsigned GGO_NOT_DONE       : 1;
    unsigned GSPM               : 1;
    unsigned GTM                : 1;
    unsigned GPOL               : 1;
    unsigned GE                 : 1;
    };

  struct
    {
    unsigned T1GSS0             : 1;
    unsigned T1GSS1             : 1;
    unsigned T1GVAL             : 1;
    unsigned T1GGO_NOT_DONE     : 1;
    unsigned T1GSPM             : 1;
    unsigned T1GTM              : 1;
    unsigned T1GPOL             : 1;
    unsigned T1GE               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR1GE             : 1;
    };

  struct
    {
    unsigned T1GSS              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned GSS                : 2;
    unsigned                    : 6;
    };
  } __T1GCONbits_t;

extern __at(0x0019) volatile __T1GCONbits_t T1GCONbits;

#define _GSS0                   0x01
#define _T1GSS0                 0x01
#define _GSS1                   0x02
#define _T1GSS1                 0x02
#define _GVAL                   0x04
#define _T1GVAL                 0x04
#define _GGO_NOT_DONE           0x08
#define _T1GGO_NOT_DONE         0x08
#define _GSPM                   0x10
#define _T1GSPM                 0x10
#define _GTM                    0x20
#define _T1GTM                  0x20
#define _GPOL                   0x40
#define _T1GPOL                 0x40
#define _GE                     0x80
#define _T1GE                   0x80
#define _TMR1GE                 0x80

//==============================================================================

extern __at(0x001A) __sfr T2TMR;
extern __at(0x001A) __sfr TMR2;
extern __at(0x001B) __sfr PR2;
extern __at(0x001B) __sfr T2PR;

//==============================================================================
//        T2CON Bits

extern __at(0x001C) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned OUTPS0             : 1;
    unsigned OUTPS1             : 1;
    unsigned OUTPS2             : 1;
    unsigned OUTPS3             : 1;
    unsigned CKPS0              : 1;
    unsigned CKPS1              : 1;
    unsigned CKPS2              : 1;
    unsigned ON                 : 1;
    };

  struct
    {
    unsigned T2OUTPS0           : 1;
    unsigned T2OUTPS1           : 1;
    unsigned T2OUTPS2           : 1;
    unsigned T2OUTPS3           : 1;
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned T2CKPS2            : 1;
    unsigned T2ON               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR2ON             : 1;
    };

  struct
    {
    unsigned T2OUTPS            : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned OUTPS              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T2CKPS             : 3;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CKPS               : 3;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x001C) volatile __T2CONbits_t T2CONbits;

#define _T2CON_OUTPS0           0x01
#define _T2CON_T2OUTPS0         0x01
#define _T2CON_OUTPS1           0x02
#define _T2CON_T2OUTPS1         0x02
#define _T2CON_OUTPS2           0x04
#define _T2CON_T2OUTPS2         0x04
#define _T2CON_OUTPS3           0x08
#define _T2CON_T2OUTPS3         0x08
#define _T2CON_CKPS0            0x10
#define _T2CON_T2CKPS0          0x10
#define _T2CON_CKPS1            0x20
#define _T2CON_T2CKPS1          0x20
#define _T2CON_CKPS2            0x40
#define _T2CON_T2CKPS2          0x40
#define _T2CON_ON               0x80
#define _T2CON_T2ON             0x80
#define _T2CON_TMR2ON           0x80

//==============================================================================


//==============================================================================
//        T2HLT Bits

extern __at(0x001D) __sfr T2HLT;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned MODE4              : 1;
    unsigned CKSYNC             : 1;
    unsigned CKPOL              : 1;
    unsigned PSYNC              : 1;
    };

  struct
    {
    unsigned T2MODE0            : 1;
    unsigned T2MODE1            : 1;
    unsigned T2MODE2            : 1;
    unsigned T2MODE3            : 1;
    unsigned T2MODE4            : 1;
    unsigned T2CKSYNC           : 1;
    unsigned T2CKPOL            : 1;
    unsigned T2PSYNC            : 1;
    };

  struct
    {
    unsigned T2MODE             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned MODE               : 5;
    unsigned                    : 3;
    };
  } __T2HLTbits_t;

extern __at(0x001D) volatile __T2HLTbits_t T2HLTbits;

#define _T2HLT_MODE0            0x01
#define _T2HLT_T2MODE0          0x01
#define _T2HLT_MODE1            0x02
#define _T2HLT_T2MODE1          0x02
#define _T2HLT_MODE2            0x04
#define _T2HLT_T2MODE2          0x04
#define _T2HLT_MODE3            0x08
#define _T2HLT_T2MODE3          0x08
#define _T2HLT_MODE4            0x10
#define _T2HLT_T2MODE4          0x10
#define _T2HLT_CKSYNC           0x20
#define _T2HLT_T2CKSYNC         0x20
#define _T2HLT_CKPOL            0x40
#define _T2HLT_T2CKPOL          0x40
#define _T2HLT_PSYNC            0x80
#define _T2HLT_T2PSYNC          0x80

//==============================================================================


//==============================================================================
//        T2CLKCON Bits

extern __at(0x001E) __sfr T2CLKCON;

typedef union
  {
  struct
    {
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    unsigned CS2                : 1;
    unsigned CS3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CS0              : 1;
    unsigned T2CS1              : 1;
    unsigned T2CS2              : 1;
    unsigned T2CS3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CS                 : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned T2CS               : 4;
    unsigned                    : 4;
    };
  } __T2CLKCONbits_t;

extern __at(0x001E) volatile __T2CLKCONbits_t T2CLKCONbits;

#define _T2CLKCON_CS0           0x01
#define _T2CLKCON_T2CS0         0x01
#define _T2CLKCON_CS1           0x02
#define _T2CLKCON_T2CS1         0x02
#define _T2CLKCON_CS2           0x04
#define _T2CLKCON_T2CS2         0x04
#define _T2CLKCON_CS3           0x08
#define _T2CLKCON_T2CS3         0x08

//==============================================================================


//==============================================================================
//        T2RST Bits

extern __at(0x001F) __sfr T2RST;

typedef union
  {
  struct
    {
    unsigned RSEL0              : 1;
    unsigned RSEL1              : 1;
    unsigned RSEL2              : 1;
    unsigned RSEL3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2RSEL0            : 1;
    unsigned T2RSEL1            : 1;
    unsigned T2RSEL2            : 1;
    unsigned T2RSEL3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2RSEL             : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned RSEL               : 4;
    unsigned                    : 4;
    };
  } __T2RSTbits_t;

extern __at(0x001F) volatile __T2RSTbits_t T2RSTbits;

#define _RSEL0                  0x01
#define _T2RSEL0                0x01
#define _RSEL1                  0x02
#define _T2RSEL1                0x02
#define _RSEL2                  0x04
#define _T2RSEL2                0x04
#define _RSEL3                  0x08
#define _T2RSEL3                0x08

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x008C) __sfr TRISA;

typedef struct
  {
  unsigned TRISA0               : 1;
  unsigned TRISA1               : 1;
  unsigned TRISA2               : 1;
  unsigned                      : 1;
  unsigned TRISA4               : 1;
  unsigned TRISA5               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __TRISAbits_t;

extern __at(0x008C) volatile __TRISAbits_t TRISAbits;

#define _TRISA0                 0x01
#define _TRISA1                 0x02
#define _TRISA2                 0x04
#define _TRISA4                 0x10
#define _TRISA5                 0x20

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x008E) __sfr TRISC;

typedef union
  {
  struct
    {
    unsigned TRISC0             : 1;
    unsigned TRISC1             : 1;
    unsigned TRISC2             : 1;
    unsigned TRISC3             : 1;
    unsigned TRISC4             : 1;
    unsigned TRISC5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISC              : 6;
    unsigned                    : 2;
    };
  } __TRISCbits_t;

extern __at(0x008E) volatile __TRISCbits_t TRISCbits;

#define _TRISC0                 0x01
#define _TRISC1                 0x02
#define _TRISC2                 0x04
#define _TRISC3                 0x08
#define _TRISC4                 0x10
#define _TRISC5                 0x20

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x0091) __sfr PIE1;

typedef union
  {
  struct
    {
    unsigned TMR1IE             : 1;
    unsigned TMR2IE             : 1;
    unsigned CCP1IE             : 1;
    unsigned SSP1IE             : 1;
    unsigned TXIE               : 1;
    unsigned RCIE               : 1;
    unsigned ADIE               : 1;
    unsigned TMR1GIE            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCPIE              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIE1bits_t;

extern __at(0x0091) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _CCP1IE                 0x04
#define _CCPIE                  0x04
#define _SSP1IE                 0x08
#define _TXIE                   0x10
#define _RCIE                   0x20
#define _ADIE                   0x40
#define _TMR1GIE                0x80

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x0092) __sfr PIE2;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned BCL1IE               : 1;
  unsigned                      : 1;
  unsigned C1IE                 : 1;
  unsigned C2IE                 : 1;
  unsigned OSFIE                : 1;
  } __PIE2bits_t;

extern __at(0x0092) volatile __PIE2bits_t PIE2bits;

#define _BCL1IE                 0x08
#define _C1IE                   0x20
#define _C2IE                   0x40
#define _OSFIE                  0x80

//==============================================================================


//==============================================================================
//        PIE3 Bits

extern __at(0x0093) __sfr PIE3;

typedef struct
  {
  unsigned CLC1IE               : 1;
  unsigned CLC2IE               : 1;
  unsigned CLC3IE               : 1;
  unsigned                      : 1;
  unsigned ZCDIE                : 1;
  unsigned COGIE                : 1;
  unsigned PWM5IE               : 1;
  unsigned                      : 1;
  } __PIE3bits_t;

extern __at(0x0093) volatile __PIE3bits_t PIE3bits;

#define _CLC1IE                 0x01
#define _CLC2IE                 0x02
#define _CLC3IE                 0x04
#define _ZCDIE                  0x10
#define _COGIE                  0x20
#define _PWM5IE                 0x40

//==============================================================================


//==============================================================================
//        PIE4 Bits

extern __at(0x0094) __sfr PIE4;

typedef struct
  {
  unsigned TMR4IE               : 1;
  unsigned TMR6IE               : 1;
  unsigned TMR3IE               : 1;
  unsigned TMR3GIE              : 1;
  unsigned TMR5IE               : 1;
  unsigned TMR5GIE              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIE4bits_t;

extern __at(0x0094) volatile __PIE4bits_t PIE4bits;

#define _TMR4IE                 0x01
#define _TMR6IE                 0x02
#define _TMR3IE                 0x04
#define _TMR3GIE                0x08
#define _TMR5IE                 0x10
#define _TMR5GIE                0x20

//==============================================================================


//==============================================================================
//        OPTION_REG Bits

extern __at(0x0095) __sfr OPTION_REG;

typedef union
  {
  struct
    {
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PS2                : 1;
    unsigned PSA                : 1;
    unsigned TMR0SE             : 1;
    unsigned TMR0CS             : 1;
    unsigned INTEDG             : 1;
    unsigned NOT_WPUEN          : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PS                 : 3;
    unsigned                    : 5;
    };
  } __OPTION_REGbits_t;

extern __at(0x0095) volatile __OPTION_REGbits_t OPTION_REGbits;

#define _PS0                    0x01
#define _PS1                    0x02
#define _PS2                    0x04
#define _PSA                    0x08
#define _TMR0SE                 0x10
#define _T0SE                   0x10
#define _TMR0CS                 0x20
#define _T0CS                   0x20
#define _INTEDG                 0x40
#define _NOT_WPUEN              0x80

//==============================================================================


//==============================================================================
//        PCON Bits

extern __at(0x0096) __sfr PCON;

typedef struct
  {
  unsigned NOT_BOR              : 1;
  unsigned NOT_POR              : 1;
  unsigned NOT_RI               : 1;
  unsigned NOT_RMCLR            : 1;
  unsigned NOT_RWDT             : 1;
  unsigned                      : 1;
  unsigned STKUNF               : 1;
  unsigned STKOVF               : 1;
  } __PCONbits_t;

extern __at(0x0096) volatile __PCONbits_t PCONbits;

#define _NOT_BOR                0x01
#define _NOT_POR                0x02
#define _NOT_RI                 0x04
#define _NOT_RMCLR              0x08
#define _NOT_RWDT               0x10
#define _STKUNF                 0x40
#define _STKOVF                 0x80

//==============================================================================


//==============================================================================
//        WDTCON Bits

extern __at(0x0097) __sfr WDTCON;

typedef union
  {
  struct
    {
    unsigned SWDTEN             : 1;
    unsigned WDTPS0             : 1;
    unsigned WDTPS1             : 1;
    unsigned WDTPS2             : 1;
    unsigned WDTPS3             : 1;
    unsigned WDTPS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WDTPS              : 5;
    unsigned                    : 2;
    };
  } __WDTCONbits_t;

extern __at(0x0097) volatile __WDTCONbits_t WDTCONbits;

#define _SWDTEN                 0x01
#define _WDTPS0                 0x02
#define _WDTPS1                 0x04
#define _WDTPS2                 0x08
#define _WDTPS3                 0x10
#define _WDTPS4                 0x20

//==============================================================================


//==============================================================================
//        OSCTUNE Bits

extern __at(0x0098) __sfr OSCTUNE;

typedef union
  {
  struct
    {
    unsigned TUN0               : 1;
    unsigned TUN1               : 1;
    unsigned TUN2               : 1;
    unsigned TUN3               : 1;
    unsigned TUN4               : 1;
    unsigned TUN5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TUN                : 6;
    unsigned                    : 2;
    };
  } __OSCTUNEbits_t;

extern __at(0x0098) volatile __OSCTUNEbits_t OSCTUNEbits;

#define _TUN0                   0x01
#define _TUN1                   0x02
#define _TUN2                   0x04
#define _TUN3                   0x08
#define _TUN4                   0x10
#define _TUN5                   0x20

//==============================================================================


//==============================================================================
//        OSCCON Bits

extern __at(0x0099) __sfr OSCCON;

typedef union
  {
  struct
    {
    unsigned SCS0               : 1;
    unsigned SCS1               : 1;
    unsigned                    : 1;
    unsigned IRCF0              : 1;
    unsigned IRCF1              : 1;
    unsigned IRCF2              : 1;
    unsigned IRCF3              : 1;
    unsigned SPLLEN             : 1;
    };

  struct
    {
    unsigned SCS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned IRCF               : 4;
    unsigned                    : 1;
    };
  } __OSCCONbits_t;

extern __at(0x0099) volatile __OSCCONbits_t OSCCONbits;

#define _SCS0                   0x01
#define _SCS1                   0x02
#define _IRCF0                  0x08
#define _IRCF1                  0x10
#define _IRCF2                  0x20
#define _IRCF3                  0x40
#define _SPLLEN                 0x80

//==============================================================================


//==============================================================================
//        OSCSTAT Bits

extern __at(0x009A) __sfr OSCSTAT;

typedef struct
  {
  unsigned HFIOFS               : 1;
  unsigned LFIOFR               : 1;
  unsigned MFIOFR               : 1;
  unsigned HFIOFL               : 1;
  unsigned HFIOFR               : 1;
  unsigned OSTS                 : 1;
  unsigned PLLR                 : 1;
  unsigned SOSCR                : 1;
  } __OSCSTATbits_t;

extern __at(0x009A) volatile __OSCSTATbits_t OSCSTATbits;

#define _HFIOFS                 0x01
#define _LFIOFR                 0x02
#define _MFIOFR                 0x04
#define _HFIOFL                 0x08
#define _HFIOFR                 0x10
#define _OSTS                   0x20
#define _PLLR                   0x40
#define _SOSCR                  0x80

//==============================================================================

extern __at(0x009B) __sfr ADRES;
extern __at(0x009B) __sfr ADRESL;
extern __at(0x009C) __sfr ADRESH;

//==============================================================================
//        ADCON0 Bits

extern __at(0x009D) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned CHS4               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ADGO               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 5;
    unsigned                    : 1;
    };
  } __ADCON0bits_t;

extern __at(0x009D) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _GO_NOT_DONE            0x02
#define _ADGO                   0x02
#define _GO                     0x02
#define _CHS0                   0x04
#define _CHS1                   0x08
#define _CHS2                   0x10
#define _CHS3                   0x20
#define _CHS4                   0x40

//==============================================================================


//==============================================================================
//        ADCON1 Bits

extern __at(0x009E) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned ADPREF0            : 1;
    unsigned ADPREF1            : 1;
    unsigned ADNREF             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned ADPREF             : 2;
    unsigned                    : 6;
    };
  } __ADCON1bits_t;

extern __at(0x009E) volatile __ADCON1bits_t ADCON1bits;

#define _ADPREF0                0x01
#define _ADPREF1                0x02
#define _ADNREF                 0x04
#define _ADFM                   0x80

//==============================================================================


//==============================================================================
//        ADCON2 Bits

extern __at(0x009F) __sfr ADCON2;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TRIGSEL0           : 1;
    unsigned TRIGSEL1           : 1;
    unsigned TRIGSEL2           : 1;
    unsigned TRIGSEL3           : 1;
    unsigned TRIGSEL4           : 1;
    };

  struct
    {
    unsigned                    : 3;
    unsigned TRIGSEL            : 5;
    };
  } __ADCON2bits_t;

extern __at(0x009F) volatile __ADCON2bits_t ADCON2bits;

#define _TRIGSEL0               0x08
#define _TRIGSEL1               0x10
#define _TRIGSEL2               0x20
#define _TRIGSEL3               0x40
#define _TRIGSEL4               0x80

//==============================================================================


//==============================================================================
//        LATA Bits

extern __at(0x010C) __sfr LATA;

typedef struct
  {
  unsigned LATA0                : 1;
  unsigned LATA1                : 1;
  unsigned LATA2                : 1;
  unsigned                      : 1;
  unsigned LATA4                : 1;
  unsigned LATA5                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __LATAbits_t;

extern __at(0x010C) volatile __LATAbits_t LATAbits;

#define _LATA0                  0x01
#define _LATA1                  0x02
#define _LATA2                  0x04
#define _LATA4                  0x10
#define _LATA5                  0x20

//==============================================================================


//==============================================================================
//        LATC Bits

extern __at(0x010E) __sfr LATC;

typedef union
  {
  struct
    {
    unsigned LATC0              : 1;
    unsigned LATC1              : 1;
    unsigned LATC2              : 1;
    unsigned LATC3              : 1;
    unsigned LATC4              : 1;
    unsigned LATC5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LATC               : 6;
    unsigned                    : 2;
    };
  } __LATCbits_t;

extern __at(0x010E) volatile __LATCbits_t LATCbits;

#define _LATC0                  0x01
#define _LATC1                  0x02
#define _LATC2                  0x04
#define _LATC3                  0x08
#define _LATC4                  0x10
#define _LATC5                  0x20

//==============================================================================


//==============================================================================
//        CMOUT Bits

extern __at(0x010F) __sfr CMOUT;

typedef struct
  {
  unsigned MC1OUT               : 1;
  unsigned MC2OUT               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __CMOUTbits_t;

extern __at(0x010F) volatile __CMOUTbits_t CMOUTbits;

#define _MC1OUT                 0x01
#define _MC2OUT                 0x02

//==============================================================================


//==============================================================================
//        CM1CON0 Bits

extern __at(0x0110) __sfr CM1CON0;

typedef union
  {
  struct
    {
    unsigned SYNC               : 1;
    unsigned HYS                : 1;
    unsigned Reserved           : 1;
    unsigned ZLF                : 1;
    unsigned POL                : 1;
    unsigned                    : 1;
    unsigned OUT                : 1;
    unsigned ON                 : 1;
    };

  struct
    {
    unsigned C1SYNC             : 1;
    unsigned C1HYS              : 1;
    unsigned C1SP               : 1;
    unsigned C1ZLF              : 1;
    unsigned C1POL              : 1;
    unsigned                    : 1;
    unsigned C1OUT              : 1;
    unsigned C1ON               : 1;
    };
  } __CM1CON0bits_t;

extern __at(0x0110) volatile __CM1CON0bits_t CM1CON0bits;

#define _CM1CON0_SYNC           0x01
#define _CM1CON0_C1SYNC         0x01
#define _CM1CON0_HYS            0x02
#define _CM1CON0_C1HYS          0x02
#define _CM1CON0_Reserved       0x04
#define _CM1CON0_C1SP           0x04
#define _CM1CON0_ZLF            0x08
#define _CM1CON0_C1ZLF          0x08
#define _CM1CON0_POL            0x10
#define _CM1CON0_C1POL          0x10
#define _CM1CON0_OUT            0x40
#define _CM1CON0_C1OUT          0x40
#define _CM1CON0_ON             0x80
#define _CM1CON0_C1ON           0x80

//==============================================================================


//==============================================================================
//        CM1CON1 Bits

extern __at(0x0111) __sfr CM1CON1;

typedef union
  {
  struct
    {
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C1INTN             : 1;
    unsigned C1INTP             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __CM1CON1bits_t;

extern __at(0x0111) volatile __CM1CON1bits_t CM1CON1bits;

#define _CM1CON1_INTN           0x01
#define _CM1CON1_C1INTN         0x01
#define _CM1CON1_INTP           0x02
#define _CM1CON1_C1INTP         0x02

//==============================================================================


//==============================================================================
//        CM1NSEL Bits

extern __at(0x0112) __sfr CM1NSEL;

typedef union
  {
  struct
    {
    unsigned NCH0               : 1;
    unsigned NCH1               : 1;
    unsigned NCH2               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C1NCH0             : 1;
    unsigned C1NCH1             : 1;
    unsigned C1NCH2             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C1NCH              : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned NCH                : 3;
    unsigned                    : 5;
    };
  } __CM1NSELbits_t;

extern __at(0x0112) volatile __CM1NSELbits_t CM1NSELbits;

#define _NCH0                   0x01
#define _C1NCH0                 0x01
#define _NCH1                   0x02
#define _C1NCH1                 0x02
#define _NCH2                   0x04
#define _C1NCH2                 0x04

//==============================================================================


//==============================================================================
//        CM1PSEL Bits

extern __at(0x0113) __sfr CM1PSEL;

typedef union
  {
  struct
    {
    unsigned PCH0               : 1;
    unsigned PCH1               : 1;
    unsigned PCH2               : 1;
    unsigned PCH3               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C1PCH0             : 1;
    unsigned C1PCH1             : 1;
    unsigned C1PCH2             : 1;
    unsigned C1PCH3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PCH                : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned C1PCH              : 4;
    unsigned                    : 4;
    };
  } __CM1PSELbits_t;

extern __at(0x0113) volatile __CM1PSELbits_t CM1PSELbits;

#define _PCH0                   0x01
#define _C1PCH0                 0x01
#define _PCH1                   0x02
#define _C1PCH1                 0x02
#define _PCH2                   0x04
#define _C1PCH2                 0x04
#define _PCH3                   0x08
#define _C1PCH3                 0x08

//==============================================================================


//==============================================================================
//        CM2CON0 Bits

extern __at(0x0114) __sfr CM2CON0;

typedef union
  {
  struct
    {
    unsigned SYNC               : 1;
    unsigned HYS                : 1;
    unsigned Reserved           : 1;
    unsigned ZLF                : 1;
    unsigned POL                : 1;
    unsigned                    : 1;
    unsigned OUT                : 1;
    unsigned ON                 : 1;
    };

  struct
    {
    unsigned C2SYNC             : 1;
    unsigned C2HYS              : 1;
    unsigned C2SP               : 1;
    unsigned C2ZLF              : 1;
    unsigned C2POL              : 1;
    unsigned                    : 1;
    unsigned C2OUT              : 1;
    unsigned C2ON               : 1;
    };
  } __CM2CON0bits_t;

extern __at(0x0114) volatile __CM2CON0bits_t CM2CON0bits;

#define _CM2CON0_SYNC           0x01
#define _CM2CON0_C2SYNC         0x01
#define _CM2CON0_HYS            0x02
#define _CM2CON0_C2HYS          0x02
#define _CM2CON0_Reserved       0x04
#define _CM2CON0_C2SP           0x04
#define _CM2CON0_ZLF            0x08
#define _CM2CON0_C2ZLF          0x08
#define _CM2CON0_POL            0x10
#define _CM2CON0_C2POL          0x10
#define _CM2CON0_OUT            0x40
#define _CM2CON0_C2OUT          0x40
#define _CM2CON0_ON             0x80
#define _CM2CON0_C2ON           0x80

//==============================================================================


//==============================================================================
//        CM2CON1 Bits

extern __at(0x0115) __sfr CM2CON1;

typedef union
  {
  struct
    {
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C2INTN             : 1;
    unsigned C2INTP             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __CM2CON1bits_t;

extern __at(0x0115) volatile __CM2CON1bits_t CM2CON1bits;

#define _CM2CON1_INTN           0x01
#define _CM2CON1_C2INTN         0x01
#define _CM2CON1_INTP           0x02
#define _CM2CON1_C2INTP         0x02

//==============================================================================


//==============================================================================
//        CM2NSEL Bits

extern __at(0x0116) __sfr CM2NSEL;

typedef union
  {
  struct
    {
    unsigned NCH0               : 1;
    unsigned NCH1               : 1;
    unsigned NCH2               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C2NCH0             : 1;
    unsigned C2NCH1             : 1;
    unsigned C2NCH2             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned NCH                : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned C2NCH              : 3;
    unsigned                    : 5;
    };
  } __CM2NSELbits_t;

extern __at(0x0116) volatile __CM2NSELbits_t CM2NSELbits;

#define _CM2NSEL_NCH0           0x01
#define _CM2NSEL_C2NCH0         0x01
#define _CM2NSEL_NCH1           0x02
#define _CM2NSEL_C2NCH1         0x02
#define _CM2NSEL_NCH2           0x04
#define _CM2NSEL_C2NCH2         0x04

//==============================================================================


//==============================================================================
//        CM2PSEL Bits

extern __at(0x0117) __sfr CM2PSEL;

typedef union
  {
  struct
    {
    unsigned PCH0               : 1;
    unsigned PCH1               : 1;
    unsigned PCH2               : 1;
    unsigned PCH3               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C2PCH0             : 1;
    unsigned C2PCH1             : 1;
    unsigned C2PCH2             : 1;
    unsigned C2PCH3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C2PCH              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned PCH                : 4;
    unsigned                    : 4;
    };
  } __CM2PSELbits_t;

extern __at(0x0117) volatile __CM2PSELbits_t CM2PSELbits;

#define _CM2PSEL_PCH0           0x01
#define _CM2PSEL_C2PCH0         0x01
#define _CM2PSEL_PCH1           0x02
#define _CM2PSEL_C2PCH1         0x02
#define _CM2PSEL_PCH2           0x04
#define _CM2PSEL_C2PCH2         0x04
#define _CM2PSEL_PCH3           0x08
#define _CM2PSEL_C2PCH3         0x08

//==============================================================================


//==============================================================================
//        ANSELA Bits

extern __at(0x018C) __sfr ANSELA;

typedef struct
  {
  unsigned ANSA0                : 1;
  unsigned ANSA1                : 1;
  unsigned ANSA2                : 1;
  unsigned                      : 1;
  unsigned ANSA4                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ANSELAbits_t;

extern __at(0x018C) volatile __ANSELAbits_t ANSELAbits;

#define _ANSA0                  0x01
#define _ANSA1                  0x02
#define _ANSA2                  0x04
#define _ANSA4                  0x10

//==============================================================================


//==============================================================================
//        ANSELC Bits

extern __at(0x018E) __sfr ANSELC;

typedef union
  {
  struct
    {
    unsigned ANSC0              : 1;
    unsigned ANSC1              : 1;
    unsigned ANSC2              : 1;
    unsigned ANSC3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ANSC               : 4;
    unsigned                    : 4;
    };
  } __ANSELCbits_t;

extern __at(0x018E) volatile __ANSELCbits_t ANSELCbits;

#define _ANSC0                  0x01
#define _ANSC1                  0x02
#define _ANSC2                  0x04
#define _ANSC3                  0x08

//==============================================================================

extern __at(0x0191) __sfr PMADR;
extern __at(0x0191) __sfr PMADRL;
extern __at(0x0192) __sfr PMADRH;
extern __at(0x0193) __sfr PMDAT;
extern __at(0x0193) __sfr PMDATL;
extern __at(0x0194) __sfr PMDATH;

//==============================================================================
//        PMCON1 Bits

extern __at(0x0195) __sfr PMCON1;

typedef struct
  {
  unsigned RD                   : 1;
  unsigned WR                   : 1;
  unsigned WREN                 : 1;
  unsigned WRERR                : 1;
  unsigned FREE                 : 1;
  unsigned LWLO                 : 1;
  unsigned CFGS                 : 1;
  unsigned                      : 1;
  } __PMCON1bits_t;

extern __at(0x0195) volatile __PMCON1bits_t PMCON1bits;

#define _RD                     0x01
#define _WR                     0x02
#define _WREN                   0x04
#define _WRERR                  0x08
#define _FREE                   0x10
#define _LWLO                   0x20
#define _CFGS                   0x40

//==============================================================================

extern __at(0x0196) __sfr PMCON2;

//==============================================================================
//        VREGCON Bits

extern __at(0x0197) __sfr VREGCON;

typedef struct
  {
  unsigned Reserved             : 1;
  unsigned VREGPM               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __VREGCONbits_t;

extern __at(0x0197) volatile __VREGCONbits_t VREGCONbits;

#define _VREGCON_Reserved       0x01
#define _VREGCON_VREGPM         0x02

//==============================================================================

extern __at(0x0199) __sfr RC1REG;
extern __at(0x0199) __sfr RCREG;
extern __at(0x0199) __sfr RCREG1;
extern __at(0x019A) __sfr TX1REG;
extern __at(0x019A) __sfr TXREG;
extern __at(0x019A) __sfr TXREG1;
extern __at(0x019B) __sfr SP1BRG;
extern __at(0x019B) __sfr SP1BRGL;
extern __at(0x019B) __sfr SPBRG;
extern __at(0x019B) __sfr SPBRG1;
extern __at(0x019B) __sfr SPBRGL;
extern __at(0x019C) __sfr SP1BRGH;
extern __at(0x019C) __sfr SPBRGH;
extern __at(0x019C) __sfr SPBRGH1;

//==============================================================================
//        RC1STA Bits

extern __at(0x019D) __sfr RC1STA;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RC1STAbits_t;

extern __at(0x019D) volatile __RC1STAbits_t RC1STAbits;

#define _RX9D                   0x01
#define _OERR                   0x02
#define _FERR                   0x04
#define _ADDEN                  0x08
#define _CREN                   0x10
#define _SREN                   0x20
#define _RX9                    0x40
#define _SPEN                   0x80

//==============================================================================


//==============================================================================
//        RCSTA Bits

extern __at(0x019D) __sfr RCSTA;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RCSTAbits_t;

extern __at(0x019D) volatile __RCSTAbits_t RCSTAbits;

#define _RCSTA_RX9D             0x01
#define _RCSTA_OERR             0x02
#define _RCSTA_FERR             0x04
#define _RCSTA_ADDEN            0x08
#define _RCSTA_CREN             0x10
#define _RCSTA_SREN             0x20
#define _RCSTA_RX9              0x40
#define _RCSTA_SPEN             0x80

//==============================================================================


//==============================================================================
//        RCSTA1 Bits

extern __at(0x019D) __sfr RCSTA1;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RCSTA1bits_t;

extern __at(0x019D) volatile __RCSTA1bits_t RCSTA1bits;

#define _RCSTA1_RX9D            0x01
#define _RCSTA1_OERR            0x02
#define _RCSTA1_FERR            0x04
#define _RCSTA1_ADDEN           0x08
#define _RCSTA1_CREN            0x10
#define _RCSTA1_SREN            0x20
#define _RCSTA1_RX9             0x40
#define _RCSTA1_SPEN            0x80

//==============================================================================


//==============================================================================
//        TX1STA Bits

extern __at(0x019E) __sfr TX1STA;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TX1STAbits_t;

extern __at(0x019E) volatile __TX1STAbits_t TX1STAbits;

#define _TX1STA_TX9D            0x01
#define _TX1STA_TRMT            0x02
#define _TX1STA_BRGH            0x04
#define _TX1STA_SENDB           0x08
#define _TX1STA_SYNC            0x10
#define _TX1STA_TXEN            0x20
#define _TX1STA_TX9             0x40
#define _TX1STA_CSRC            0x80

//==============================================================================


//==============================================================================
//        TXSTA Bits

extern __at(0x019E) __sfr TXSTA;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TXSTAbits_t;

extern __at(0x019E) volatile __TXSTAbits_t TXSTAbits;

#define _TXSTA_TX9D             0x01
#define _TXSTA_TRMT             0x02
#define _TXSTA_BRGH             0x04
#define _TXSTA_SENDB            0x08
#define _TXSTA_SYNC             0x10
#define _TXSTA_TXEN             0x20
#define _TXSTA_TX9              0x40
#define _TXSTA_CSRC             0x80

//==============================================================================


//==============================================================================
//        TXSTA1 Bits

extern __at(0x019E) __sfr TXSTA1;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TXSTA1bits_t;

extern __at(0x019E) volatile __TXSTA1bits_t TXSTA1bits;

#define _TXSTA1_TX9D            0x01
#define _TXSTA1_TRMT            0x02
#define _TXSTA1_BRGH            0x04
#define _TXSTA1_SENDB           0x08
#define _TXSTA1_SYNC            0x10
#define _TXSTA1_TXEN            0x20
#define _TXSTA1_TX9             0x40
#define _TXSTA1_CSRC            0x80

//==============================================================================


//==============================================================================
//        BAUD1CON Bits

extern __at(0x019F) __sfr BAUD1CON;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUD1CONbits_t;

extern __at(0x019F) volatile __BAUD1CONbits_t BAUD1CONbits;

#define _ABDEN                  0x01
#define _WUE                    0x02
#define _BRG16                  0x08
#define _SCKP                   0x10
#define _RCIDL                  0x40
#define _ABDOVF                 0x80

//==============================================================================


//==============================================================================
//        BAUDCON Bits

extern __at(0x019F) __sfr BAUDCON;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCONbits_t;

extern __at(0x019F) volatile __BAUDCONbits_t BAUDCONbits;

#define _BAUDCON_ABDEN          0x01
#define _BAUDCON_WUE            0x02
#define _BAUDCON_BRG16          0x08
#define _BAUDCON_SCKP           0x10
#define _BAUDCON_RCIDL          0x40
#define _BAUDCON_ABDOVF         0x80

//==============================================================================


//==============================================================================
//        BAUDCON1 Bits

extern __at(0x019F) __sfr BAUDCON1;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCON1bits_t;

extern __at(0x019F) volatile __BAUDCON1bits_t BAUDCON1bits;

#define _BAUDCON1_ABDEN         0x01
#define _BAUDCON1_WUE           0x02
#define _BAUDCON1_BRG16         0x08
#define _BAUDCON1_SCKP          0x10
#define _BAUDCON1_RCIDL         0x40
#define _BAUDCON1_ABDOVF        0x80

//==============================================================================


//==============================================================================
//        BAUDCTL Bits

extern __at(0x019F) __sfr BAUDCTL;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCTLbits_t;

extern __at(0x019F) volatile __BAUDCTLbits_t BAUDCTLbits;

#define _BAUDCTL_ABDEN          0x01
#define _BAUDCTL_WUE            0x02
#define _BAUDCTL_BRG16          0x08
#define _BAUDCTL_SCKP           0x10
#define _BAUDCTL_RCIDL          0x40
#define _BAUDCTL_ABDOVF         0x80

//==============================================================================


//==============================================================================
//        BAUDCTL1 Bits

extern __at(0x019F) __sfr BAUDCTL1;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCTL1bits_t;

extern __at(0x019F) volatile __BAUDCTL1bits_t BAUDCTL1bits;

#define _BAUDCTL1_ABDEN         0x01
#define _BAUDCTL1_WUE           0x02
#define _BAUDCTL1_BRG16         0x08
#define _BAUDCTL1_SCKP          0x10
#define _BAUDCTL1_RCIDL         0x40
#define _BAUDCTL1_ABDOVF        0x80

//==============================================================================


//==============================================================================
//        WPUA Bits

extern __at(0x020C) __sfr WPUA;

typedef union
  {
  struct
    {
    unsigned WPUA0              : 1;
    unsigned WPUA1              : 1;
    unsigned WPUA2              : 1;
    unsigned WPUA3              : 1;
    unsigned WPUA4              : 1;
    unsigned WPUA5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned WPUA               : 6;
    unsigned                    : 2;
    };
  } __WPUAbits_t;

extern __at(0x020C) volatile __WPUAbits_t WPUAbits;

#define _WPUA0                  0x01
#define _WPUA1                  0x02
#define _WPUA2                  0x04
#define _WPUA3                  0x08
#define _WPUA4                  0x10
#define _WPUA5                  0x20

//==============================================================================


//==============================================================================
//        WPUC Bits

extern __at(0x020E) __sfr WPUC;

typedef union
  {
  struct
    {
    unsigned WPUC0              : 1;
    unsigned WPUC1              : 1;
    unsigned WPUC2              : 1;
    unsigned WPUC3              : 1;
    unsigned WPUC4              : 1;
    unsigned WPUC5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned WPUC               : 6;
    unsigned                    : 2;
    };
  } __WPUCbits_t;

extern __at(0x020E) volatile __WPUCbits_t WPUCbits;

#define _WPUC0                  0x01
#define _WPUC1                  0x02
#define _WPUC2                  0x04
#define _WPUC3                  0x08
#define _WPUC4                  0x10
#define _WPUC5                  0x20

//==============================================================================


//==============================================================================
//        SSP1BUF Bits

extern __at(0x0211) __sfr SSP1BUF;

typedef union
  {
  struct
    {
    unsigned SSP1BUF0           : 1;
    unsigned SSP1BUF1           : 1;
    unsigned SSP1BUF2           : 1;
    unsigned SSP1BUF3           : 1;
    unsigned SSP1BUF4           : 1;
    unsigned SSP1BUF5           : 1;
    unsigned SSP1BUF6           : 1;
    unsigned SSP1BUF7           : 1;
    };

  struct
    {
    unsigned BUF0               : 1;
    unsigned BUF1               : 1;
    unsigned BUF2               : 1;
    unsigned BUF3               : 1;
    unsigned BUF4               : 1;
    unsigned BUF5               : 1;
    unsigned BUF6               : 1;
    unsigned BUF7               : 1;
    };
  } __SSP1BUFbits_t;

extern __at(0x0211) volatile __SSP1BUFbits_t SSP1BUFbits;

#define _SSP1BUF0               0x01
#define _BUF0                   0x01
#define _SSP1BUF1               0x02
#define _BUF1                   0x02
#define _SSP1BUF2               0x04
#define _BUF2                   0x04
#define _SSP1BUF3               0x08
#define _BUF3                   0x08
#define _SSP1BUF4               0x10
#define _BUF4                   0x10
#define _SSP1BUF5               0x20
#define _BUF5                   0x20
#define _SSP1BUF6               0x40
#define _BUF6                   0x40
#define _SSP1BUF7               0x80
#define _BUF7                   0x80

//==============================================================================


//==============================================================================
//        SSPBUF Bits

extern __at(0x0211) __sfr SSPBUF;

typedef union
  {
  struct
    {
    unsigned SSP1BUF0           : 1;
    unsigned SSP1BUF1           : 1;
    unsigned SSP1BUF2           : 1;
    unsigned SSP1BUF3           : 1;
    unsigned SSP1BUF4           : 1;
    unsigned SSP1BUF5           : 1;
    unsigned SSP1BUF6           : 1;
    unsigned SSP1BUF7           : 1;
    };

  struct
    {
    unsigned BUF0               : 1;
    unsigned BUF1               : 1;
    unsigned BUF2               : 1;
    unsigned BUF3               : 1;
    unsigned BUF4               : 1;
    unsigned BUF5               : 1;
    unsigned BUF6               : 1;
    unsigned BUF7               : 1;
    };
  } __SSPBUFbits_t;

extern __at(0x0211) volatile __SSPBUFbits_t SSPBUFbits;

#define _SSPBUF_SSP1BUF0        0x01
#define _SSPBUF_BUF0            0x01
#define _SSPBUF_SSP1BUF1        0x02
#define _SSPBUF_BUF1            0x02
#define _SSPBUF_SSP1BUF2        0x04
#define _SSPBUF_BUF2            0x04
#define _SSPBUF_SSP1BUF3        0x08
#define _SSPBUF_BUF3            0x08
#define _SSPBUF_SSP1BUF4        0x10
#define _SSPBUF_BUF4            0x10
#define _SSPBUF_SSP1BUF5        0x20
#define _SSPBUF_BUF5            0x20
#define _SSPBUF_SSP1BUF6        0x40
#define _SSPBUF_BUF6            0x40
#define _SSPBUF_SSP1BUF7        0x80
#define _SSPBUF_BUF7            0x80

//==============================================================================


//==============================================================================
//        SSP1ADD Bits

extern __at(0x0212) __sfr SSP1ADD;

typedef union
  {
  struct
    {
    unsigned SSP1ADD0           : 1;
    unsigned SSP1ADD1           : 1;
    unsigned SSP1ADD2           : 1;
    unsigned SSP1ADD3           : 1;
    unsigned SSP1ADD4           : 1;
    unsigned SSP1ADD5           : 1;
    unsigned SSP1ADD6           : 1;
    unsigned SSP1ADD7           : 1;
    };

  struct
    {
    unsigned ADD0               : 1;
    unsigned ADD1               : 1;
    unsigned ADD2               : 1;
    unsigned ADD3               : 1;
    unsigned ADD4               : 1;
    unsigned ADD5               : 1;
    unsigned ADD6               : 1;
    unsigned ADD7               : 1;
    };
  } __SSP1ADDbits_t;

extern __at(0x0212) volatile __SSP1ADDbits_t SSP1ADDbits;

#define _SSP1ADD0               0x01
#define _ADD0                   0x01
#define _SSP1ADD1               0x02
#define _ADD1                   0x02
#define _SSP1ADD2               0x04
#define _ADD2                   0x04
#define _SSP1ADD3               0x08
#define _ADD3                   0x08
#define _SSP1ADD4               0x10
#define _ADD4                   0x10
#define _SSP1ADD5               0x20
#define _ADD5                   0x20
#define _SSP1ADD6               0x40
#define _ADD6                   0x40
#define _SSP1ADD7               0x80
#define _ADD7                   0x80

//==============================================================================


//==============================================================================
//        SSPADD Bits

extern __at(0x0212) __sfr SSPADD;

typedef union
  {
  struct
    {
    unsigned SSP1ADD0           : 1;
    unsigned SSP1ADD1           : 1;
    unsigned SSP1ADD2           : 1;
    unsigned SSP1ADD3           : 1;
    unsigned SSP1ADD4           : 1;
    unsigned SSP1ADD5           : 1;
    unsigned SSP1ADD6           : 1;
    unsigned SSP1ADD7           : 1;
    };

  struct
    {
    unsigned ADD0               : 1;
    unsigned ADD1               : 1;
    unsigned ADD2               : 1;
    unsigned ADD3               : 1;
    unsigned ADD4               : 1;
    unsigned ADD5               : 1;
    unsigned ADD6               : 1;
    unsigned ADD7               : 1;
    };
  } __SSPADDbits_t;

extern __at(0x0212) volatile __SSPADDbits_t SSPADDbits;

#define _SSPADD_SSP1ADD0        0x01
#define _SSPADD_ADD0            0x01
#define _SSPADD_SSP1ADD1        0x02
#define _SSPADD_ADD1            0x02
#define _SSPADD_SSP1ADD2        0x04
#define _SSPADD_ADD2            0x04
#define _SSPADD_SSP1ADD3        0x08
#define _SSPADD_ADD3            0x08
#define _SSPADD_SSP1ADD4        0x10
#define _SSPADD_ADD4            0x10
#define _SSPADD_SSP1ADD5        0x20
#define _SSPADD_ADD5            0x20
#define _SSPADD_SSP1ADD6        0x40
#define _SSPADD_ADD6            0x40
#define _SSPADD_SSP1ADD7        0x80
#define _SSPADD_ADD7            0x80

//==============================================================================


//==============================================================================
//        SSP1MSK Bits

extern __at(0x0213) __sfr SSP1MSK;

typedef union
  {
  struct
    {
    unsigned SSP1MSK0           : 1;
    unsigned SSP1MSK1           : 1;
    unsigned SSP1MSK2           : 1;
    unsigned SSP1MSK3           : 1;
    unsigned SSP1MSK4           : 1;
    unsigned SSP1MSK5           : 1;
    unsigned SSP1MSK6           : 1;
    unsigned SSP1MSK7           : 1;
    };

  struct
    {
    unsigned MSK0               : 1;
    unsigned MSK1               : 1;
    unsigned MSK2               : 1;
    unsigned MSK3               : 1;
    unsigned MSK4               : 1;
    unsigned MSK5               : 1;
    unsigned MSK6               : 1;
    unsigned MSK7               : 1;
    };
  } __SSP1MSKbits_t;

extern __at(0x0213) volatile __SSP1MSKbits_t SSP1MSKbits;

#define _SSP1MSK0               0x01
#define _MSK0                   0x01
#define _SSP1MSK1               0x02
#define _MSK1                   0x02
#define _SSP1MSK2               0x04
#define _MSK2                   0x04
#define _SSP1MSK3               0x08
#define _MSK3                   0x08
#define _SSP1MSK4               0x10
#define _MSK4                   0x10
#define _SSP1MSK5               0x20
#define _MSK5                   0x20
#define _SSP1MSK6               0x40
#define _MSK6                   0x40
#define _SSP1MSK7               0x80
#define _MSK7                   0x80

//==============================================================================


//==============================================================================
//        SSPMSK Bits

extern __at(0x0213) __sfr SSPMSK;

typedef union
  {
  struct
    {
    unsigned SSP1MSK0           : 1;
    unsigned SSP1MSK1           : 1;
    unsigned SSP1MSK2           : 1;
    unsigned SSP1MSK3           : 1;
    unsigned SSP1MSK4           : 1;
    unsigned SSP1MSK5           : 1;
    unsigned SSP1MSK6           : 1;
    unsigned SSP1MSK7           : 1;
    };

  struct
    {
    unsigned MSK0               : 1;
    unsigned MSK1               : 1;
    unsigned MSK2               : 1;
    unsigned MSK3               : 1;
    unsigned MSK4               : 1;
    unsigned MSK5               : 1;
    unsigned MSK6               : 1;
    unsigned MSK7               : 1;
    };
  } __SSPMSKbits_t;

extern __at(0x0213) volatile __SSPMSKbits_t SSPMSKbits;

#define _SSPMSK_SSP1MSK0        0x01
#define _SSPMSK_MSK0            0x01
#define _SSPMSK_SSP1MSK1        0x02
#define _SSPMSK_MSK1            0x02
#define _SSPMSK_SSP1MSK2        0x04
#define _SSPMSK_MSK2            0x04
#define _SSPMSK_SSP1MSK3        0x08
#define _SSPMSK_MSK3            0x08
#define _SSPMSK_SSP1MSK4        0x10
#define _SSPMSK_MSK4            0x10
#define _SSPMSK_SSP1MSK5        0x20
#define _SSPMSK_MSK5            0x20
#define _SSPMSK_SSP1MSK6        0x40
#define _SSPMSK_MSK6            0x40
#define _SSPMSK_SSP1MSK7        0x80
#define _SSPMSK_MSK7            0x80

//==============================================================================


//==============================================================================
//        SSP1STAT Bits

extern __at(0x0214) __sfr SSP1STAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSP1STATbits_t;

extern __at(0x0214) volatile __SSP1STATbits_t SSP1STATbits;

#define _BF                     0x01
#define _UA                     0x02
#define _R_NOT_W                0x04
#define _S                      0x08
#define _P                      0x10
#define _D_NOT_A                0x20
#define _CKE                    0x40
#define _SMP                    0x80

//==============================================================================


//==============================================================================
//        SSPSTAT Bits

extern __at(0x0214) __sfr SSPSTAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSPSTATbits_t;

extern __at(0x0214) volatile __SSPSTATbits_t SSPSTATbits;

#define _SSPSTAT_BF             0x01
#define _SSPSTAT_UA             0x02
#define _SSPSTAT_R_NOT_W        0x04
#define _SSPSTAT_S              0x08
#define _SSPSTAT_P              0x10
#define _SSPSTAT_D_NOT_A        0x20
#define _SSPSTAT_CKE            0x40
#define _SSPSTAT_SMP            0x80

//==============================================================================


//==============================================================================
//        SSP1CON Bits

extern __at(0x0215) __sfr SSP1CON;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP1CONbits_t;

extern __at(0x0215) volatile __SSP1CONbits_t SSP1CONbits;

#define _SSPM0                  0x01
#define _SSPM1                  0x02
#define _SSPM2                  0x04
#define _SSPM3                  0x08
#define _CKP                    0x10
#define _SSPEN                  0x20
#define _SSPOV                  0x40
#define _WCOL                   0x80

//==============================================================================


//==============================================================================
//        SSP1CON1 Bits

extern __at(0x0215) __sfr SSP1CON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP1CON1bits_t;

extern __at(0x0215) volatile __SSP1CON1bits_t SSP1CON1bits;

#define _SSP1CON1_SSPM0         0x01
#define _SSP1CON1_SSPM1         0x02
#define _SSP1CON1_SSPM2         0x04
#define _SSP1CON1_SSPM3         0x08
#define _SSP1CON1_CKP           0x10
#define _SSP1CON1_SSPEN         0x20
#define _SSP1CON1_SSPOV         0x40
#define _SSP1CON1_WCOL          0x80

//==============================================================================


//==============================================================================
//        SSPCON Bits

extern __at(0x0215) __sfr SSPCON;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCONbits_t;

extern __at(0x0215) volatile __SSPCONbits_t SSPCONbits;

#define _SSPCON_SSPM0           0x01
#define _SSPCON_SSPM1           0x02
#define _SSPCON_SSPM2           0x04
#define _SSPCON_SSPM3           0x08
#define _SSPCON_CKP             0x10
#define _SSPCON_SSPEN           0x20
#define _SSPCON_SSPOV           0x40
#define _SSPCON_WCOL            0x80

//==============================================================================


//==============================================================================
//        SSPCON1 Bits

extern __at(0x0215) __sfr SSPCON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCON1bits_t;

extern __at(0x0215) volatile __SSPCON1bits_t SSPCON1bits;

#define _SSPCON1_SSPM0          0x01
#define _SSPCON1_SSPM1          0x02
#define _SSPCON1_SSPM2          0x04
#define _SSPCON1_SSPM3          0x08
#define _SSPCON1_CKP            0x10
#define _SSPCON1_SSPEN          0x20
#define _SSPCON1_SSPOV          0x40
#define _SSPCON1_WCOL           0x80

//==============================================================================


//==============================================================================
//        SSP1CON2 Bits

extern __at(0x0216) __sfr SSP1CON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSP1CON2bits_t;

extern __at(0x0216) volatile __SSP1CON2bits_t SSP1CON2bits;

#define _SEN                    0x01
#define _RSEN                   0x02
#define _PEN                    0x04
#define _RCEN                   0x08
#define _ACKEN                  0x10
#define _ACKDT                  0x20
#define _ACKSTAT                0x40
#define _GCEN                   0x80

//==============================================================================


//==============================================================================
//        SSPCON2 Bits

extern __at(0x0216) __sfr SSPCON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSPCON2bits_t;

extern __at(0x0216) volatile __SSPCON2bits_t SSPCON2bits;

#define _SSPCON2_SEN            0x01
#define _SSPCON2_RSEN           0x02
#define _SSPCON2_PEN            0x04
#define _SSPCON2_RCEN           0x08
#define _SSPCON2_ACKEN          0x10
#define _SSPCON2_ACKDT          0x20
#define _SSPCON2_ACKSTAT        0x40
#define _SSPCON2_GCEN           0x80

//==============================================================================


//==============================================================================
//        SSP1CON3 Bits

extern __at(0x0217) __sfr SSP1CON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSP1CON3bits_t;

extern __at(0x0217) volatile __SSP1CON3bits_t SSP1CON3bits;

#define _DHEN                   0x01
#define _AHEN                   0x02
#define _SBCDE                  0x04
#define _SDAHT                  0x08
#define _BOEN                   0x10
#define _SCIE                   0x20
#define _PCIE                   0x40
#define _ACKTIM                 0x80

//==============================================================================


//==============================================================================
//        SSPCON3 Bits

extern __at(0x0217) __sfr SSPCON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSPCON3bits_t;

extern __at(0x0217) volatile __SSPCON3bits_t SSPCON3bits;

#define _SSPCON3_DHEN           0x01
#define _SSPCON3_AHEN           0x02
#define _SSPCON3_SBCDE          0x04
#define _SSPCON3_SDAHT          0x08
#define _SSPCON3_BOEN           0x10
#define _SSPCON3_SCIE           0x20
#define _SSPCON3_PCIE           0x40
#define _SSPCON3_ACKTIM         0x80

//==============================================================================


//==============================================================================
//        BORCON Bits

extern __at(0x021D) __sfr BORCON;

typedef struct
  {
  unsigned BORRDY               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned BORFS                : 1;
  unsigned SBOREN               : 1;
  } __BORCONbits_t;

extern __at(0x021D) volatile __BORCONbits_t BORCONbits;

#define _BORRDY                 0x01
#define _BORFS                  0x40
#define _SBOREN                 0x80

//==============================================================================


//==============================================================================
//        FVRCON Bits

extern __at(0x021E) __sfr FVRCON;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned TSRNG                : 1;
  unsigned TSEN                 : 1;
  unsigned FVRRDY               : 1;
  unsigned FVREN                : 1;
  } __FVRCONbits_t;

extern __at(0x021E) volatile __FVRCONbits_t FVRCONbits;

#define _TSRNG                  0x10
#define _TSEN                   0x20
#define _FVRRDY                 0x40
#define _FVREN                  0x80

//==============================================================================


//==============================================================================
//        ZCD1CON Bits

extern __at(0x021F) __sfr ZCD1CON;

typedef struct
  {
  unsigned ZCD1INTN             : 1;
  unsigned ZCD1INTP             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ZCD1POL              : 1;
  unsigned ZCD1OUT              : 1;
  unsigned                      : 1;
  unsigned ZCD1EN               : 1;
  } __ZCD1CONbits_t;

extern __at(0x021F) volatile __ZCD1CONbits_t ZCD1CONbits;

#define _ZCD1INTN               0x01
#define _ZCD1INTP               0x02
#define _ZCD1POL                0x10
#define _ZCD1OUT                0x20
#define _ZCD1EN                 0x80

//==============================================================================


//==============================================================================
//        ODCONA Bits

extern __at(0x028C) __sfr ODCONA;

typedef struct
  {
  unsigned ODA0                 : 1;
  unsigned ODA1                 : 1;
  unsigned ODA2                 : 1;
  unsigned                      : 1;
  unsigned ODA4                 : 1;
  unsigned ODA5                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ODCONAbits_t;

extern __at(0x028C) volatile __ODCONAbits_t ODCONAbits;

#define _ODA0                   0x01
#define _ODA1                   0x02
#define _ODA2                   0x04
#define _ODA4                   0x10
#define _ODA5                   0x20

//==============================================================================


//==============================================================================
//        ODCONC Bits

extern __at(0x028E) __sfr ODCONC;

typedef union
  {
  struct
    {
    unsigned ODC0               : 1;
    unsigned ODC1               : 1;
    unsigned ODC2               : 1;
    unsigned ODC3               : 1;
    unsigned ODC4               : 1;
    unsigned ODC5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ODC                : 6;
    unsigned                    : 2;
    };
  } __ODCONCbits_t;

extern __at(0x028E) volatile __ODCONCbits_t ODCONCbits;

#define _ODC0                   0x01
#define _ODC1                   0x02
#define _ODC2                   0x04
#define _ODC3                   0x08
#define _ODC4                   0x10
#define _ODC5                   0x20

//==============================================================================

extern __at(0x0291) __sfr CCPR1;
extern __at(0x0291) __sfr CCPR1L;
extern __at(0x0292) __sfr CCPR1H;

//==============================================================================
//        CCP1CON Bits

extern __at(0x0293) __sfr CCP1CON;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned FMT                : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned CCP1MODE0          : 1;
    unsigned CCP1MODE1          : 1;
    unsigned CCP1MODE2          : 1;
    unsigned CCP1MODE3          : 1;
    unsigned CCP1FMT            : 1;
    unsigned CCP1OUT            : 1;
    unsigned                    : 1;
    unsigned CCP1EN             : 1;
    };

  struct
    {
    unsigned MODE               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned CCP1MODE           : 4;
    unsigned                    : 4;
    };
  } __CCP1CONbits_t;

extern __at(0x0293) volatile __CCP1CONbits_t CCP1CONbits;

#define _MODE0                  0x01
#define _CCP1MODE0              0x01
#define _MODE1                  0x02
#define _CCP1MODE1              0x02
#define _MODE2                  0x04
#define _CCP1MODE2              0x04
#define _MODE3                  0x08
#define _CCP1MODE3              0x08
#define _FMT                    0x10
#define _CCP1FMT                0x10
#define _OUT                    0x20
#define _CCP1OUT                0x20
#define _EN                     0x80
#define _CCP1EN                 0x80

//==============================================================================


//==============================================================================
//        CCP1CAP Bits

extern __at(0x0294) __sfr CCP1CAP;

typedef union
  {
  struct
    {
    unsigned CTS0               : 1;
    unsigned CTS1               : 1;
    unsigned CTS2               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1CTS0           : 1;
    unsigned CCP1CTS1           : 1;
    unsigned CCP1CTS2           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CTS                : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned CCP1CTS            : 3;
    unsigned                    : 5;
    };
  } __CCP1CAPbits_t;

extern __at(0x0294) volatile __CCP1CAPbits_t CCP1CAPbits;

#define _CTS0                   0x01
#define _CCP1CTS0               0x01
#define _CTS1                   0x02
#define _CCP1CTS1               0x02
#define _CTS2                   0x04
#define _CCP1CTS2               0x04

//==============================================================================


//==============================================================================
//        CCPTMRS Bits

extern __at(0x029E) __sfr CCPTMRS;

typedef union
  {
  struct
    {
    unsigned C1TSEL0            : 1;
    unsigned C1TSEL1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned P3TSEL0            : 1;
    unsigned P3TSEL1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C1TSEL             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned P3TSEL             : 2;
    unsigned                    : 2;
    };
  } __CCPTMRSbits_t;

extern __at(0x029E) volatile __CCPTMRSbits_t CCPTMRSbits;

#define _C1TSEL0                0x01
#define _C1TSEL1                0x02
#define _P3TSEL0                0x10
#define _P3TSEL1                0x20

//==============================================================================


//==============================================================================
//        SLRCONA Bits

extern __at(0x030C) __sfr SLRCONA;

typedef struct
  {
  unsigned SLRA0                : 1;
  unsigned SLRA1                : 1;
  unsigned SLRA2                : 1;
  unsigned                      : 1;
  unsigned SLRA4                : 1;
  unsigned SLRA5                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __SLRCONAbits_t;

extern __at(0x030C) volatile __SLRCONAbits_t SLRCONAbits;

#define _SLRA0                  0x01
#define _SLRA1                  0x02
#define _SLRA2                  0x04
#define _SLRA4                  0x10
#define _SLRA5                  0x20

//==============================================================================


//==============================================================================
//        SLRCONC Bits

extern __at(0x030E) __sfr SLRCONC;

typedef union
  {
  struct
    {
    unsigned SLRC0              : 1;
    unsigned SLRC1              : 1;
    unsigned SLRC2              : 1;
    unsigned SLRC3              : 1;
    unsigned SLRC4              : 1;
    unsigned SLRC5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SLRC               : 6;
    unsigned                    : 2;
    };
  } __SLRCONCbits_t;

extern __at(0x030E) volatile __SLRCONCbits_t SLRCONCbits;

#define _SLRC0                  0x01
#define _SLRC1                  0x02
#define _SLRC2                  0x04
#define _SLRC3                  0x08
#define _SLRC4                  0x10
#define _SLRC5                  0x20

//==============================================================================


//==============================================================================
//        INLVLA Bits

extern __at(0x038C) __sfr INLVLA;

typedef union
  {
  struct
    {
    unsigned INLVLA0            : 1;
    unsigned INLVLA1            : 1;
    unsigned INLVLA2            : 1;
    unsigned INLVLA3            : 1;
    unsigned INLVLA4            : 1;
    unsigned INLVLA5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned INLVLA             : 6;
    unsigned                    : 2;
    };
  } __INLVLAbits_t;

extern __at(0x038C) volatile __INLVLAbits_t INLVLAbits;

#define _INLVLA0                0x01
#define _INLVLA1                0x02
#define _INLVLA2                0x04
#define _INLVLA3                0x08
#define _INLVLA4                0x10
#define _INLVLA5                0x20

//==============================================================================


//==============================================================================
//        INLVLC Bits

extern __at(0x038E) __sfr INLVLC;

typedef union
  {
  struct
    {
    unsigned INLVLC0            : 1;
    unsigned INLVLC1            : 1;
    unsigned INLVLC2            : 1;
    unsigned INLVLC3            : 1;
    unsigned INLVLC4            : 1;
    unsigned INLVLC5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned INLVLC             : 6;
    unsigned                    : 2;
    };
  } __INLVLCbits_t;

extern __at(0x038E) volatile __INLVLCbits_t INLVLCbits;

#define _INLVLC0                0x01
#define _INLVLC1                0x02
#define _INLVLC2                0x04
#define _INLVLC3                0x08
#define _INLVLC4                0x10
#define _INLVLC5                0x20

//==============================================================================


//==============================================================================
//        IOCAP Bits

extern __at(0x0391) __sfr IOCAP;

typedef union
  {
  struct
    {
    unsigned IOCAP0             : 1;
    unsigned IOCAP1             : 1;
    unsigned IOCAP2             : 1;
    unsigned IOCAP3             : 1;
    unsigned IOCAP4             : 1;
    unsigned IOCAP5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCAP              : 6;
    unsigned                    : 2;
    };
  } __IOCAPbits_t;

extern __at(0x0391) volatile __IOCAPbits_t IOCAPbits;

#define _IOCAP0                 0x01
#define _IOCAP1                 0x02
#define _IOCAP2                 0x04
#define _IOCAP3                 0x08
#define _IOCAP4                 0x10
#define _IOCAP5                 0x20

//==============================================================================


//==============================================================================
//        IOCAN Bits

extern __at(0x0392) __sfr IOCAN;

typedef union
  {
  struct
    {
    unsigned IOCAN0             : 1;
    unsigned IOCAN1             : 1;
    unsigned IOCAN2             : 1;
    unsigned IOCAN3             : 1;
    unsigned IOCAN4             : 1;
    unsigned IOCAN5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCAN              : 6;
    unsigned                    : 2;
    };
  } __IOCANbits_t;

extern __at(0x0392) volatile __IOCANbits_t IOCANbits;

#define _IOCAN0                 0x01
#define _IOCAN1                 0x02
#define _IOCAN2                 0x04
#define _IOCAN3                 0x08
#define _IOCAN4                 0x10
#define _IOCAN5                 0x20

//==============================================================================


//==============================================================================
//        IOCAF Bits

extern __at(0x0393) __sfr IOCAF;

typedef union
  {
  struct
    {
    unsigned IOCAF0             : 1;
    unsigned IOCAF1             : 1;
    unsigned IOCAF2             : 1;
    unsigned IOCAF3             : 1;
    unsigned IOCAF4             : 1;
    unsigned IOCAF5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCAF              : 6;
    unsigned                    : 2;
    };
  } __IOCAFbits_t;

extern __at(0x0393) volatile __IOCAFbits_t IOCAFbits;

#define _IOCAF0                 0x01
#define _IOCAF1                 0x02
#define _IOCAF2                 0x04
#define _IOCAF3                 0x08
#define _IOCAF4                 0x10
#define _IOCAF5                 0x20

//==============================================================================


//==============================================================================
//        IOCCP Bits

extern __at(0x0397) __sfr IOCCP;

typedef union
  {
  struct
    {
    unsigned IOCCP0             : 1;
    unsigned IOCCP1             : 1;
    unsigned IOCCP2             : 1;
    unsigned IOCCP3             : 1;
    unsigned IOCCP4             : 1;
    unsigned IOCCP5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCCP              : 6;
    unsigned                    : 2;
    };
  } __IOCCPbits_t;

extern __at(0x0397) volatile __IOCCPbits_t IOCCPbits;

#define _IOCCP0                 0x01
#define _IOCCP1                 0x02
#define _IOCCP2                 0x04
#define _IOCCP3                 0x08
#define _IOCCP4                 0x10
#define _IOCCP5                 0x20

//==============================================================================


//==============================================================================
//        IOCCN Bits

extern __at(0x0398) __sfr IOCCN;

typedef union
  {
  struct
    {
    unsigned IOCCN0             : 1;
    unsigned IOCCN1             : 1;
    unsigned IOCCN2             : 1;
    unsigned IOCCN3             : 1;
    unsigned IOCCN4             : 1;
    unsigned IOCCN5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCCN              : 6;
    unsigned                    : 2;
    };
  } __IOCCNbits_t;

extern __at(0x0398) volatile __IOCCNbits_t IOCCNbits;

#define _IOCCN0                 0x01
#define _IOCCN1                 0x02
#define _IOCCN2                 0x04
#define _IOCCN3                 0x08
#define _IOCCN4                 0x10
#define _IOCCN5                 0x20

//==============================================================================


//==============================================================================
//        IOCCF Bits

extern __at(0x0399) __sfr IOCCF;

typedef union
  {
  struct
    {
    unsigned IOCCF0             : 1;
    unsigned IOCCF1             : 1;
    unsigned IOCCF2             : 1;
    unsigned IOCCF3             : 1;
    unsigned IOCCF4             : 1;
    unsigned IOCCF5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned IOCCF              : 6;
    unsigned                    : 2;
    };
  } __IOCCFbits_t;

extern __at(0x0399) volatile __IOCCFbits_t IOCCFbits;

#define _IOCCF0                 0x01
#define _IOCCF1                 0x02
#define _IOCCF2                 0x04
#define _IOCCF3                 0x08
#define _IOCCF4                 0x10
#define _IOCCF5                 0x20

//==============================================================================


//==============================================================================
//        MD1CON0 Bits

extern __at(0x039B) __sfr MD1CON0;

typedef union
  {
  struct
    {
    unsigned BIT                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned OPOL               : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned MD1BIT             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned MD1OPOL            : 1;
    unsigned MD1OUT             : 1;
    unsigned                    : 1;
    unsigned MD1EN              : 1;
    };
  } __MD1CON0bits_t;

extern __at(0x039B) volatile __MD1CON0bits_t MD1CON0bits;

#define _MD1CON0_BIT            0x01
#define _MD1CON0_MD1BIT         0x01
#define _MD1CON0_OPOL           0x10
#define _MD1CON0_MD1OPOL        0x10
#define _MD1CON0_OUT            0x20
#define _MD1CON0_MD1OUT         0x20
#define _MD1CON0_EN             0x80
#define _MD1CON0_MD1EN          0x80

//==============================================================================


//==============================================================================
//        MD1CON1 Bits

extern __at(0x039C) __sfr MD1CON1;

typedef union
  {
  struct
    {
    unsigned CLSYNC             : 1;
    unsigned CLPOL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CHSYNC             : 1;
    unsigned CHPOL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MD1CLSYNC          : 1;
    unsigned MD1CLPOL           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned MD1CHSYNC          : 1;
    unsigned MD1CHPOL           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __MD1CON1bits_t;

extern __at(0x039C) volatile __MD1CON1bits_t MD1CON1bits;

#define _CLSYNC                 0x01
#define _MD1CLSYNC              0x01
#define _CLPOL                  0x02
#define _MD1CLPOL               0x02
#define _CHSYNC                 0x10
#define _MD1CHSYNC              0x10
#define _CHPOL                  0x20
#define _MD1CHPOL               0x20

//==============================================================================


//==============================================================================
//        MD1SRC Bits

extern __at(0x039D) __sfr MD1SRC;

typedef union
  {
  struct
    {
    unsigned MS0                : 1;
    unsigned MS1                : 1;
    unsigned MS2                : 1;
    unsigned MS3                : 1;
    unsigned MS4                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MD1MS0             : 1;
    unsigned MD1MS1             : 1;
    unsigned MD1MS2             : 1;
    unsigned MD1MS3             : 1;
    unsigned MD1MS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MS                 : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned MD1MS              : 5;
    unsigned                    : 3;
    };
  } __MD1SRCbits_t;

extern __at(0x039D) volatile __MD1SRCbits_t MD1SRCbits;

#define _MS0                    0x01
#define _MD1MS0                 0x01
#define _MS1                    0x02
#define _MD1MS1                 0x02
#define _MS2                    0x04
#define _MD1MS2                 0x04
#define _MS3                    0x08
#define _MD1MS3                 0x08
#define _MS4                    0x10
#define _MD1MS4                 0x10

//==============================================================================


//==============================================================================
//        MD1CARL Bits

extern __at(0x039E) __sfr MD1CARL;

typedef union
  {
  struct
    {
    unsigned CL0                : 1;
    unsigned CL1                : 1;
    unsigned CL2                : 1;
    unsigned CL3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MD1CL0             : 1;
    unsigned MD1CL1             : 1;
    unsigned MD1CL2             : 1;
    unsigned MD1CL3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MD1CL              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned CL                 : 4;
    unsigned                    : 4;
    };
  } __MD1CARLbits_t;

extern __at(0x039E) volatile __MD1CARLbits_t MD1CARLbits;

#define _CL0                    0x01
#define _MD1CL0                 0x01
#define _CL1                    0x02
#define _MD1CL1                 0x02
#define _CL2                    0x04
#define _MD1CL2                 0x04
#define _CL3                    0x08
#define _MD1CL3                 0x08

//==============================================================================


//==============================================================================
//        MD1CARH Bits

extern __at(0x039F) __sfr MD1CARH;

typedef union
  {
  struct
    {
    unsigned CH0                : 1;
    unsigned CH1                : 1;
    unsigned CH2                : 1;
    unsigned CH3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MD1CH0             : 1;
    unsigned MD1CH1             : 1;
    unsigned MD1CH2             : 1;
    unsigned MD1CH3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CH                 : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned MD1CH              : 4;
    unsigned                    : 4;
    };
  } __MD1CARHbits_t;

extern __at(0x039F) volatile __MD1CARHbits_t MD1CARHbits;

#define _CH0                    0x01
#define _MD1CH0                 0x01
#define _CH1                    0x02
#define _MD1CH1                 0x02
#define _CH2                    0x04
#define _MD1CH2                 0x04
#define _CH3                    0x08
#define _MD1CH3                 0x08

//==============================================================================


//==============================================================================
//        HIDRVC Bits

extern __at(0x040E) __sfr HIDRVC;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned HIDC4                : 1;
  unsigned HIDC5                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __HIDRVCbits_t;

extern __at(0x040E) volatile __HIDRVCbits_t HIDRVCbits;

#define _HIDC4                  0x10
#define _HIDC5                  0x20

//==============================================================================

extern __at(0x0413) __sfr T4TMR;
extern __at(0x0413) __sfr TMR4;
extern __at(0x0414) __sfr PR4;
extern __at(0x0414) __sfr T4PR;

//==============================================================================
//        T4CON Bits

extern __at(0x0415) __sfr T4CON;

typedef union
  {
  struct
    {
    unsigned OUTPS0             : 1;
    unsigned OUTPS1             : 1;
    unsigned OUTPS2             : 1;
    unsigned OUTPS3             : 1;
    unsigned CKPS0              : 1;
    unsigned CKPS1              : 1;
    unsigned CKPS2              : 1;
    unsigned ON                 : 1;
    };

  struct
    {
    unsigned T4OUTPS0           : 1;
    unsigned T4OUTPS1           : 1;
    unsigned T4OUTPS2           : 1;
    unsigned T4OUTPS3           : 1;
    unsigned T4CKPS0            : 1;
    unsigned T4CKPS1            : 1;
    unsigned T4CKPS2            : 1;
    unsigned T4ON               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR4ON             : 1;
    };

  struct
    {
    unsigned OUTPS              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned T4OUTPS            : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T4CKPS             : 3;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CKPS               : 3;
    unsigned                    : 1;
    };
  } __T4CONbits_t;

extern __at(0x0415) volatile __T4CONbits_t T4CONbits;

#define _T4CON_OUTPS0           0x01
#define _T4CON_T4OUTPS0         0x01
#define _T4CON_OUTPS1           0x02
#define _T4CON_T4OUTPS1         0x02
#define _T4CON_OUTPS2           0x04
#define _T4CON_T4OUTPS2         0x04
#define _T4CON_OUTPS3           0x08
#define _T4CON_T4OUTPS3         0x08
#define _T4CON_CKPS0            0x10
#define _T4CON_T4CKPS0          0x10
#define _T4CON_CKPS1            0x20
#define _T4CON_T4CKPS1          0x20
#define _T4CON_CKPS2            0x40
#define _T4CON_T4CKPS2          0x40
#define _T4CON_ON               0x80
#define _T4CON_T4ON             0x80
#define _T4CON_TMR4ON           0x80

//==============================================================================


//==============================================================================
//        T4HLT Bits

extern __at(0x0416) __sfr T4HLT;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned MODE4              : 1;
    unsigned CKSYNC             : 1;
    unsigned CKPOL              : 1;
    unsigned PSYNC              : 1;
    };

  struct
    {
    unsigned T4MODE0            : 1;
    unsigned T4MODE1            : 1;
    unsigned T4MODE2            : 1;
    unsigned T4MODE3            : 1;
    unsigned T4MODE4            : 1;
    unsigned T4CKSYNC           : 1;
    unsigned T4CKPOL            : 1;
    unsigned T4PSYNC            : 1;
    };

  struct
    {
    unsigned MODE               : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned T4MODE             : 5;
    unsigned                    : 3;
    };
  } __T4HLTbits_t;

extern __at(0x0416) volatile __T4HLTbits_t T4HLTbits;

#define _T4HLT_MODE0            0x01
#define _T4HLT_T4MODE0          0x01
#define _T4HLT_MODE1            0x02
#define _T4HLT_T4MODE1          0x02
#define _T4HLT_MODE2            0x04
#define _T4HLT_T4MODE2          0x04
#define _T4HLT_MODE3            0x08
#define _T4HLT_T4MODE3          0x08
#define _T4HLT_MODE4            0x10
#define _T4HLT_T4MODE4          0x10
#define _T4HLT_CKSYNC           0x20
#define _T4HLT_T4CKSYNC         0x20
#define _T4HLT_CKPOL            0x40
#define _T4HLT_T4CKPOL          0x40
#define _T4HLT_PSYNC            0x80
#define _T4HLT_T4PSYNC          0x80

//==============================================================================


//==============================================================================
//        T4CLKCON Bits

extern __at(0x0417) __sfr T4CLKCON;

typedef union
  {
  struct
    {
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    unsigned CS2                : 1;
    unsigned CS3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T4CS0              : 1;
    unsigned T4CS1              : 1;
    unsigned T4CS2              : 1;
    unsigned T4CS3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CS                 : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned T4CS               : 4;
    unsigned                    : 4;
    };
  } __T4CLKCONbits_t;

extern __at(0x0417) volatile __T4CLKCONbits_t T4CLKCONbits;

#define _T4CLKCON_CS0           0x01
#define _T4CLKCON_T4CS0         0x01
#define _T4CLKCON_CS1           0x02
#define _T4CLKCON_T4CS1         0x02
#define _T4CLKCON_CS2           0x04
#define _T4CLKCON_T4CS2         0x04
#define _T4CLKCON_CS3           0x08
#define _T4CLKCON_T4CS3         0x08

//==============================================================================


//==============================================================================
//        T4RST Bits

extern __at(0x0418) __sfr T4RST;

typedef union
  {
  struct
    {
    unsigned RSEL0              : 1;
    unsigned RSEL1              : 1;
    unsigned RSEL2              : 1;
    unsigned RSEL3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T4RSEL0            : 1;
    unsigned T4RSEL1            : 1;
    unsigned T4RSEL2            : 1;
    unsigned T4RSEL3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RSEL               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned T4RSEL             : 4;
    unsigned                    : 4;
    };
  } __T4RSTbits_t;

extern __at(0x0418) volatile __T4RSTbits_t T4RSTbits;

#define _T4RST_RSEL0            0x01
#define _T4RST_T4RSEL0          0x01
#define _T4RST_RSEL1            0x02
#define _T4RST_T4RSEL1          0x02
#define _T4RST_RSEL2            0x04
#define _T4RST_T4RSEL2          0x04
#define _T4RST_RSEL3            0x08
#define _T4RST_T4RSEL3          0x08

//==============================================================================

extern __at(0x041A) __sfr T6TMR;
extern __at(0x041A) __sfr TMR6;
extern __at(0x041B) __sfr PR6;
extern __at(0x041B) __sfr T6PR;

//==============================================================================
//        T6CON Bits

extern __at(0x041C) __sfr T6CON;

typedef union
  {
  struct
    {
    unsigned OUTPS0             : 1;
    unsigned OUTPS1             : 1;
    unsigned OUTPS2             : 1;
    unsigned OUTPS3             : 1;
    unsigned CKPS0              : 1;
    unsigned CKPS1              : 1;
    unsigned CKPS2              : 1;
    unsigned ON                 : 1;
    };

  struct
    {
    unsigned T6OUTPS0           : 1;
    unsigned T6OUTPS1           : 1;
    unsigned T6OUTPS2           : 1;
    unsigned T6OUTPS3           : 1;
    unsigned T6CKPS0            : 1;
    unsigned T6CKPS1            : 1;
    unsigned T6CKPS2            : 1;
    unsigned T6ON               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR6ON             : 1;
    };

  struct
    {
    unsigned OUTPS              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned T6OUTPS            : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T6CKPS             : 3;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CKPS               : 3;
    unsigned                    : 1;
    };
  } __T6CONbits_t;

extern __at(0x041C) volatile __T6CONbits_t T6CONbits;

#define _T6CON_OUTPS0           0x01
#define _T6CON_T6OUTPS0         0x01
#define _T6CON_OUTPS1           0x02
#define _T6CON_T6OUTPS1         0x02
#define _T6CON_OUTPS2           0x04
#define _T6CON_T6OUTPS2         0x04
#define _T6CON_OUTPS3           0x08
#define _T6CON_T6OUTPS3         0x08
#define _T6CON_CKPS0            0x10
#define _T6CON_T6CKPS0          0x10
#define _T6CON_CKPS1            0x20
#define _T6CON_T6CKPS1          0x20
#define _T6CON_CKPS2            0x40
#define _T6CON_T6CKPS2          0x40
#define _T6CON_ON               0x80
#define _T6CON_T6ON             0x80
#define _T6CON_TMR6ON           0x80

//==============================================================================


//==============================================================================
//        T6HLT Bits

extern __at(0x041D) __sfr T6HLT;

typedef union
  {
  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned MODE3              : 1;
    unsigned MODE4              : 1;
    unsigned CKSYNC             : 1;
    unsigned CKPOL              : 1;
    unsigned PSYNC              : 1;
    };

  struct
    {
    unsigned T6MODE0            : 1;
    unsigned T6MODE1            : 1;
    unsigned T6MODE2            : 1;
    unsigned T6MODE3            : 1;
    unsigned T6MODE4            : 1;
    unsigned T6CKSYNC           : 1;
    unsigned T6CKPOL            : 1;
    unsigned T6PSYNC            : 1;
    };

  struct
    {
    unsigned MODE               : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned T6MODE             : 5;
    unsigned                    : 3;
    };
  } __T6HLTbits_t;

extern __at(0x041D) volatile __T6HLTbits_t T6HLTbits;

#define _T6HLT_MODE0            0x01
#define _T6HLT_T6MODE0          0x01
#define _T6HLT_MODE1            0x02
#define _T6HLT_T6MODE1          0x02
#define _T6HLT_MODE2            0x04
#define _T6HLT_T6MODE2          0x04
#define _T6HLT_MODE3            0x08
#define _T6HLT_T6MODE3          0x08
#define _T6HLT_MODE4            0x10
#define _T6HLT_T6MODE4          0x10
#define _T6HLT_CKSYNC           0x20
#define _T6HLT_T6CKSYNC         0x20
#define _T6HLT_CKPOL            0x40
#define _T6HLT_T6CKPOL          0x40
#define _T6HLT_PSYNC            0x80
#define _T6HLT_T6PSYNC          0x80

//==============================================================================


//==============================================================================
//        T6CLKCON Bits

extern __at(0x041E) __sfr T6CLKCON;

typedef union
  {
  struct
    {
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    unsigned CS2                : 1;
    unsigned CS3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T6CS0              : 1;
    unsigned T6CS1              : 1;
    unsigned T6CS2              : 1;
    unsigned T6CS3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CS                 : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned T6CS               : 4;
    unsigned                    : 4;
    };
  } __T6CLKCONbits_t;

extern __at(0x041E) volatile __T6CLKCONbits_t T6CLKCONbits;

#define _T6CLKCON_CS0           0x01
#define _T6CLKCON_T6CS0         0x01
#define _T6CLKCON_CS1           0x02
#define _T6CLKCON_T6CS1         0x02
#define _T6CLKCON_CS2           0x04
#define _T6CLKCON_T6CS2         0x04
#define _T6CLKCON_CS3           0x08
#define _T6CLKCON_T6CS3         0x08

//==============================================================================


//==============================================================================
//        T6RST Bits

extern __at(0x041F) __sfr T6RST;

typedef union
  {
  struct
    {
    unsigned RSEL0              : 1;
    unsigned RSEL1              : 1;
    unsigned RSEL2              : 1;
    unsigned RSEL3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T6RSEL0            : 1;
    unsigned T6RSEL1            : 1;
    unsigned T6RSEL2            : 1;
    unsigned T6RSEL3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T6RSEL             : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned RSEL               : 4;
    unsigned                    : 4;
    };
  } __T6RSTbits_t;

extern __at(0x041F) volatile __T6RSTbits_t T6RSTbits;

#define _T6RST_RSEL0            0x01
#define _T6RST_T6RSEL0          0x01
#define _T6RST_RSEL1            0x02
#define _T6RST_T6RSEL1          0x02
#define _T6RST_RSEL2            0x04
#define _T6RST_T6RSEL2          0x04
#define _T6RST_RSEL3            0x08
#define _T6RST_T6RSEL3          0x08

//==============================================================================

extern __at(0x0493) __sfr TMR3;
extern __at(0x0493) __sfr TMR3L;
extern __at(0x0494) __sfr TMR3H;

//==============================================================================
//        T3CON Bits

extern __at(0x0495) __sfr T3CON;

typedef union
  {
  struct
    {
    unsigned ON                 : 1;
    unsigned                    : 1;
    unsigned NOT_SYNC           : 1;
    unsigned                    : 1;
    unsigned CKPS0              : 1;
    unsigned CKPS1              : 1;
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    };

  struct
    {
    unsigned TMRON              : 1;
    unsigned                    : 1;
    unsigned SYNC               : 1;
    unsigned                    : 1;
    unsigned T3CKPS0            : 1;
    unsigned T3CKPS1            : 1;
    unsigned T3CS0              : 1;
    unsigned T3CS1              : 1;
    };

  struct
    {
    unsigned TMR3ON             : 1;
    unsigned                    : 1;
    unsigned NOT_T3SYNC         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR3CS0            : 1;
    unsigned TMR3CS1            : 1;
    };

  struct
    {
    unsigned T3ON               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CKPS               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T3CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR3CS             : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned T3CS               : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned CS                 : 2;
    };
  } __T3CONbits_t;

extern __at(0x0495) volatile __T3CONbits_t T3CONbits;

#define _T3CON_ON               0x01
#define _T3CON_TMRON            0x01
#define _T3CON_TMR3ON           0x01
#define _T3CON_T3ON             0x01
#define _T3CON_NOT_SYNC         0x04
#define _T3CON_SYNC             0x04
#define _T3CON_NOT_T3SYNC       0x04
#define _T3CON_CKPS0            0x10
#define _T3CON_T3CKPS0          0x10
#define _T3CON_CKPS1            0x20
#define _T3CON_T3CKPS1          0x20
#define _T3CON_CS0              0x40
#define _T3CON_T3CS0            0x40
#define _T3CON_TMR3CS0          0x40
#define _T3CON_CS1              0x80
#define _T3CON_T3CS1            0x80
#define _T3CON_TMR3CS1          0x80

//==============================================================================


//==============================================================================
//        T3GCON Bits

extern __at(0x0496) __sfr T3GCON;

typedef union
  {
  struct
    {
    unsigned GSS0               : 1;
    unsigned GSS1               : 1;
    unsigned GVAL               : 1;
    unsigned GGO_NOT_DONE       : 1;
    unsigned GSPM               : 1;
    unsigned GTM                : 1;
    unsigned GPOL               : 1;
    unsigned GE                 : 1;
    };

  struct
    {
    unsigned T3GSS0             : 1;
    unsigned T3GSS1             : 1;
    unsigned T3GVAL             : 1;
    unsigned T3GGO_NOT_DONE     : 1;
    unsigned T3GSPM             : 1;
    unsigned T3GTM              : 1;
    unsigned T3GPOL             : 1;
    unsigned T3GE               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR3GE             : 1;
    };

  struct
    {
    unsigned GSS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned T3GSS              : 2;
    unsigned                    : 6;
    };
  } __T3GCONbits_t;

extern __at(0x0496) volatile __T3GCONbits_t T3GCONbits;

#define _T3GCON_GSS0            0x01
#define _T3GCON_T3GSS0          0x01
#define _T3GCON_GSS1            0x02
#define _T3GCON_T3GSS1          0x02
#define _T3GCON_GVAL            0x04
#define _T3GCON_T3GVAL          0x04
#define _T3GCON_GGO_NOT_DONE    0x08
#define _T3GCON_T3GGO_NOT_DONE  0x08
#define _T3GCON_GSPM            0x10
#define _T3GCON_T3GSPM          0x10
#define _T3GCON_GTM             0x20
#define _T3GCON_T3GTM           0x20
#define _T3GCON_GPOL            0x40
#define _T3GCON_T3GPOL          0x40
#define _T3GCON_GE              0x80
#define _T3GCON_T3GE            0x80
#define _T3GCON_TMR3GE          0x80

//==============================================================================

extern __at(0x049A) __sfr TMR5;
extern __at(0x049A) __sfr TMR5L;
extern __at(0x049B) __sfr TMR5H;

//==============================================================================
//        T5CON Bits

extern __at(0x049C) __sfr T5CON;

typedef union
  {
  struct
    {
    unsigned ON                 : 1;
    unsigned                    : 1;
    unsigned NOT_SYNC           : 1;
    unsigned                    : 1;
    unsigned CKPS0              : 1;
    unsigned CKPS1              : 1;
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    };

  struct
    {
    unsigned TMRON              : 1;
    unsigned                    : 1;
    unsigned SYNC               : 1;
    unsigned                    : 1;
    unsigned T5CKPS0            : 1;
    unsigned T5CKPS1            : 1;
    unsigned T5CS0              : 1;
    unsigned T5CS1              : 1;
    };

  struct
    {
    unsigned TMR5ON             : 1;
    unsigned                    : 1;
    unsigned NOT_T5SYNC         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR5CS0            : 1;
    unsigned TMR5CS1            : 1;
    };

  struct
    {
    unsigned T5ON               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CKPS               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T5CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned CS                 : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned T5CS               : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR5CS             : 2;
    };
  } __T5CONbits_t;

extern __at(0x049C) volatile __T5CONbits_t T5CONbits;

#define _T5CON_ON               0x01
#define _T5CON_TMRON            0x01
#define _T5CON_TMR5ON           0x01
#define _T5CON_T5ON             0x01
#define _T5CON_NOT_SYNC         0x04
#define _T5CON_SYNC             0x04
#define _T5CON_NOT_T5SYNC       0x04
#define _T5CON_CKPS0            0x10
#define _T5CON_T5CKPS0          0x10
#define _T5CON_CKPS1            0x20
#define _T5CON_T5CKPS1          0x20
#define _T5CON_CS0              0x40
#define _T5CON_T5CS0            0x40
#define _T5CON_TMR5CS0          0x40
#define _T5CON_CS1              0x80
#define _T5CON_T5CS1            0x80
#define _T5CON_TMR5CS1          0x80

//==============================================================================


//==============================================================================
//        T5GCON Bits

extern __at(0x049D) __sfr T5GCON;

typedef union
  {
  struct
    {
    unsigned GSS0               : 1;
    unsigned GSS1               : 1;
    unsigned GVAL               : 1;
    unsigned GGO_NOT_DONE       : 1;
    unsigned GSPM               : 1;
    unsigned GTM                : 1;
    unsigned GPOL               : 1;
    unsigned GE                 : 1;
    };

  struct
    {
    unsigned T5GSS0             : 1;
    unsigned T5GSS1             : 1;
    unsigned T5GVAL             : 1;
    unsigned T5GGO_NOT_DONE     : 1;
    unsigned T5GSPM             : 1;
    unsigned T5GTM              : 1;
    unsigned T5GPOL             : 1;
    unsigned T5GE               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TMR5GE             : 1;
    };

  struct
    {
    unsigned GSS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned T5GSS              : 2;
    unsigned                    : 6;
    };
  } __T5GCONbits_t;

extern __at(0x049D) volatile __T5GCONbits_t T5GCONbits;

#define _T5GCON_GSS0            0x01
#define _T5GCON_T5GSS0          0x01
#define _T5GCON_GSS1            0x02
#define _T5GCON_T5GSS1          0x02
#define _T5GCON_GVAL            0x04
#define _T5GCON_T5GVAL          0x04
#define _T5GCON_GGO_NOT_DONE    0x08
#define _T5GCON_T5GGO_NOT_DONE  0x08
#define _T5GCON_GSPM            0x10
#define _T5GCON_T5GSPM          0x10
#define _T5GCON_GTM             0x20
#define _T5GCON_T5GTM           0x20
#define _T5GCON_GPOL            0x40
#define _T5GCON_T5GPOL          0x40
#define _T5GCON_GE              0x80
#define _T5GCON_T5GE            0x80
#define _T5GCON_TMR5GE          0x80

//==============================================================================

extern __at(0x050F) __sfr OPA1NCHS;
extern __at(0x0510) __sfr OPA1PCHS;

//==============================================================================
//        OPA1CON Bits

extern __at(0x0511) __sfr OPA1CON;

typedef union
  {
  struct
    {
    unsigned ORM0               : 1;
    unsigned ORM1               : 1;
    unsigned ORPOL              : 1;
    unsigned                    : 1;
    unsigned UG                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned OPA1ORM0           : 1;
    unsigned OPA1ORM1           : 1;
    unsigned OPA1ORPOL          : 1;
    unsigned                    : 1;
    unsigned OPA1UG             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned OPA1EN             : 1;
    };

  struct
    {
    unsigned OPA1ORM            : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned ORM                : 2;
    unsigned                    : 6;
    };
  } __OPA1CONbits_t;

extern __at(0x0511) volatile __OPA1CONbits_t OPA1CONbits;

#define _OPA1CON_ORM0           0x01
#define _OPA1CON_OPA1ORM0       0x01
#define _OPA1CON_ORM1           0x02
#define _OPA1CON_OPA1ORM1       0x02
#define _OPA1CON_ORPOL          0x04
#define _OPA1CON_OPA1ORPOL      0x04
#define _OPA1CON_UG             0x10
#define _OPA1CON_OPA1UG         0x10
#define _OPA1CON_EN             0x80
#define _OPA1CON_OPA1EN         0x80

//==============================================================================

extern __at(0x0512) __sfr OPA1ORS;

//==============================================================================
//        DACLD Bits

extern __at(0x0590) __sfr DACLD;

typedef struct
  {
  unsigned DAC1LD               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __DACLDbits_t;

extern __at(0x0590) volatile __DACLDbits_t DACLDbits;

#define _DAC1LD                 0x01

//==============================================================================


//==============================================================================
//        DAC1CON0 Bits

extern __at(0x0591) __sfr DAC1CON0;

typedef union
  {
  struct
    {
    unsigned NSS0               : 1;
    unsigned                    : 1;
    unsigned PSS0               : 1;
    unsigned PSS1               : 1;
    unsigned                    : 1;
    unsigned OE1                : 1;
    unsigned FM                 : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned DACNSS0            : 1;
    unsigned                    : 1;
    unsigned DACPSS0            : 1;
    unsigned DACPSS1            : 1;
    unsigned                    : 1;
    unsigned OE                 : 1;
    unsigned DACFM              : 1;
    unsigned DACEN              : 1;
    };

  struct
    {
    unsigned DAC1NSS0           : 1;
    unsigned                    : 1;
    unsigned DAC1PSS0           : 1;
    unsigned DAC1PSS1           : 1;
    unsigned                    : 1;
    unsigned DACOE1             : 1;
    unsigned DAC1FM             : 1;
    unsigned DAC1EN             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DACOE              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DAC1OE1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned DACPSS             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS                : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned DAC1PSS            : 2;
    unsigned                    : 4;
    };
  } __DAC1CON0bits_t;

extern __at(0x0591) volatile __DAC1CON0bits_t DAC1CON0bits;

#define _DAC1CON0_NSS0          0x01
#define _DAC1CON0_DACNSS0       0x01
#define _DAC1CON0_DAC1NSS0      0x01
#define _DAC1CON0_PSS0          0x04
#define _DAC1CON0_DACPSS0       0x04
#define _DAC1CON0_DAC1PSS0      0x04
#define _DAC1CON0_PSS1          0x08
#define _DAC1CON0_DACPSS1       0x08
#define _DAC1CON0_DAC1PSS1      0x08
#define _DAC1CON0_OE1           0x20
#define _DAC1CON0_OE            0x20
#define _DAC1CON0_DACOE1        0x20
#define _DAC1CON0_DACOE         0x20
#define _DAC1CON0_DAC1OE1       0x20
#define _DAC1CON0_FM            0x40
#define _DAC1CON0_DACFM         0x40
#define _DAC1CON0_DAC1FM        0x40
#define _DAC1CON0_EN            0x80
#define _DAC1CON0_DACEN         0x80
#define _DAC1CON0_DAC1EN        0x80

//==============================================================================


//==============================================================================
//        DAC1CON1 Bits

extern __at(0x0592) __sfr DAC1CON1;

typedef union
  {
  struct
    {
    unsigned REF0               : 1;
    unsigned REF1               : 1;
    unsigned REF2               : 1;
    unsigned REF3               : 1;
    unsigned REF4               : 1;
    unsigned REF5               : 1;
    unsigned REF6               : 1;
    unsigned REF7               : 1;
    };

  struct
    {
    unsigned DAC1REF0           : 1;
    unsigned DAC1REF1           : 1;
    unsigned DAC1REF2           : 1;
    unsigned DAC1REF3           : 1;
    unsigned DAC1REF4           : 1;
    unsigned DAC1REF5           : 1;
    unsigned DAC1REF6           : 1;
    unsigned DAC1REF7           : 1;
    };

  struct
    {
    unsigned R0                 : 1;
    unsigned R1                 : 1;
    unsigned R2                 : 1;
    unsigned R3                 : 1;
    unsigned R4                 : 1;
    unsigned R5                 : 1;
    unsigned R6                 : 1;
    unsigned R7                 : 1;
    };

  struct
    {
    unsigned DAC1R0             : 1;
    unsigned DAC1R1             : 1;
    unsigned DAC1R2             : 1;
    unsigned DAC1R3             : 1;
    unsigned DAC1R4             : 1;
    unsigned DAC1R5             : 1;
    unsigned DAC1R6             : 1;
    unsigned DAC1R7             : 1;
    };
  } __DAC1CON1bits_t;

extern __at(0x0592) volatile __DAC1CON1bits_t DAC1CON1bits;

#define _REF0                   0x01
#define _DAC1REF0               0x01
#define _R0                     0x01
#define _DAC1R0                 0x01
#define _REF1                   0x02
#define _DAC1REF1               0x02
#define _R1                     0x02
#define _DAC1R1                 0x02
#define _REF2                   0x04
#define _DAC1REF2               0x04
#define _R2                     0x04
#define _DAC1R2                 0x04
#define _REF3                   0x08
#define _DAC1REF3               0x08
#define _R3                     0x08
#define _DAC1R3                 0x08
#define _REF4                   0x10
#define _DAC1REF4               0x10
#define _R4                     0x10
#define _DAC1R4                 0x10
#define _REF5                   0x20
#define _DAC1REF5               0x20
#define _R5                     0x20
#define _DAC1R5                 0x20
#define _REF6                   0x40
#define _DAC1REF6               0x40
#define _R6                     0x40
#define _DAC1R6                 0x40
#define _REF7                   0x80
#define _DAC1REF7               0x80
#define _R7                     0x80
#define _DAC1R7                 0x80

//==============================================================================

extern __at(0x0592) __sfr DAC1REF;

//==============================================================================
//        DAC1REFL Bits

extern __at(0x0592) __sfr DAC1REFL;

typedef union
  {
  struct
    {
    unsigned REF0               : 1;
    unsigned REF1               : 1;
    unsigned REF2               : 1;
    unsigned REF3               : 1;
    unsigned REF4               : 1;
    unsigned REF5               : 1;
    unsigned REF6               : 1;
    unsigned REF7               : 1;
    };

  struct
    {
    unsigned DAC1REF0           : 1;
    unsigned DAC1REF1           : 1;
    unsigned DAC1REF2           : 1;
    unsigned DAC1REF3           : 1;
    unsigned DAC1REF4           : 1;
    unsigned DAC1REF5           : 1;
    unsigned DAC1REF6           : 1;
    unsigned DAC1REF7           : 1;
    };

  struct
    {
    unsigned R0                 : 1;
    unsigned R1                 : 1;
    unsigned R2                 : 1;
    unsigned R3                 : 1;
    unsigned R4                 : 1;
    unsigned R5                 : 1;
    unsigned R6                 : 1;
    unsigned R7                 : 1;
    };

  struct
    {
    unsigned DAC1R0             : 1;
    unsigned DAC1R1             : 1;
    unsigned DAC1R2             : 1;
    unsigned DAC1R3             : 1;
    unsigned DAC1R4             : 1;
    unsigned DAC1R5             : 1;
    unsigned DAC1R6             : 1;
    unsigned DAC1R7             : 1;
    };
  } __DAC1REFLbits_t;

extern __at(0x0592) volatile __DAC1REFLbits_t DAC1REFLbits;

#define _DAC1REFL_REF0          0x01
#define _DAC1REFL_DAC1REF0      0x01
#define _DAC1REFL_R0            0x01
#define _DAC1REFL_DAC1R0        0x01
#define _DAC1REFL_REF1          0x02
#define _DAC1REFL_DAC1REF1      0x02
#define _DAC1REFL_R1            0x02
#define _DAC1REFL_DAC1R1        0x02
#define _DAC1REFL_REF2          0x04
#define _DAC1REFL_DAC1REF2      0x04
#define _DAC1REFL_R2            0x04
#define _DAC1REFL_DAC1R2        0x04
#define _DAC1REFL_REF3          0x08
#define _DAC1REFL_DAC1REF3      0x08
#define _DAC1REFL_R3            0x08
#define _DAC1REFL_DAC1R3        0x08
#define _DAC1REFL_REF4          0x10
#define _DAC1REFL_DAC1REF4      0x10
#define _DAC1REFL_R4            0x10
#define _DAC1REFL_DAC1R4        0x10
#define _DAC1REFL_REF5          0x20
#define _DAC1REFL_DAC1REF5      0x20
#define _DAC1REFL_R5            0x20
#define _DAC1REFL_DAC1R5        0x20
#define _DAC1REFL_REF6          0x40
#define _DAC1REFL_DAC1REF6      0x40
#define _DAC1REFL_R6            0x40
#define _DAC1REFL_DAC1R6        0x40
#define _DAC1REFL_REF7          0x80
#define _DAC1REFL_DAC1REF7      0x80
#define _DAC1REFL_R7            0x80
#define _DAC1REFL_DAC1R7        0x80

//==============================================================================


//==============================================================================
//        DAC1CON2 Bits

extern __at(0x0593) __sfr DAC1CON2;

typedef union
  {
  struct
    {
    unsigned REF8               : 1;
    unsigned REF9               : 1;
    unsigned REF10              : 1;
    unsigned REF11              : 1;
    unsigned REF12              : 1;
    unsigned REF13              : 1;
    unsigned REF14              : 1;
    unsigned REF15              : 1;
    };

  struct
    {
    unsigned DAC1REF8           : 1;
    unsigned DAC1REF9           : 1;
    unsigned DAC1REF10          : 1;
    unsigned DAC1REF11          : 1;
    unsigned DAC1REF12          : 1;
    unsigned DAC1REF13          : 1;
    unsigned DAC1REF14          : 1;
    unsigned DAC1REF15          : 1;
    };

  struct
    {
    unsigned R8                 : 1;
    unsigned R9                 : 1;
    unsigned R10                : 1;
    unsigned R11                : 1;
    unsigned R12                : 1;
    unsigned R13                : 1;
    unsigned R14                : 1;
    unsigned R15                : 1;
    };

  struct
    {
    unsigned DAC1R8             : 1;
    unsigned DAC1R9             : 1;
    unsigned DAC1R10            : 1;
    unsigned DAC1R11            : 1;
    unsigned DAC1R12            : 1;
    unsigned DAC1R13            : 1;
    unsigned DAC1R14            : 1;
    unsigned DAC1R15            : 1;
    };
  } __DAC1CON2bits_t;

extern __at(0x0593) volatile __DAC1CON2bits_t DAC1CON2bits;

#define _REF8                   0x01
#define _DAC1REF8               0x01
#define _R8                     0x01
#define _DAC1R8                 0x01
#define _REF9                   0x02
#define _DAC1REF9               0x02
#define _R9                     0x02
#define _DAC1R9                 0x02
#define _REF10                  0x04
#define _DAC1REF10              0x04
#define _R10                    0x04
#define _DAC1R10                0x04
#define _REF11                  0x08
#define _DAC1REF11              0x08
#define _R11                    0x08
#define _DAC1R11                0x08
#define _REF12                  0x10
#define _DAC1REF12              0x10
#define _R12                    0x10
#define _DAC1R12                0x10
#define _REF13                  0x20
#define _DAC1REF13              0x20
#define _R13                    0x20
#define _DAC1R13                0x20
#define _REF14                  0x40
#define _DAC1REF14              0x40
#define _R14                    0x40
#define _DAC1R14                0x40
#define _REF15                  0x80
#define _DAC1REF15              0x80
#define _R15                    0x80
#define _DAC1R15                0x80

//==============================================================================


//==============================================================================
//        DAC1REFH Bits

extern __at(0x0593) __sfr DAC1REFH;

typedef union
  {
  struct
    {
    unsigned REF8               : 1;
    unsigned REF9               : 1;
    unsigned REF10              : 1;
    unsigned REF11              : 1;
    unsigned REF12              : 1;
    unsigned REF13              : 1;
    unsigned REF14              : 1;
    unsigned REF15              : 1;
    };

  struct
    {
    unsigned DAC1REF8           : 1;
    unsigned DAC1REF9           : 1;
    unsigned DAC1REF10          : 1;
    unsigned DAC1REF11          : 1;
    unsigned DAC1REF12          : 1;
    unsigned DAC1REF13          : 1;
    unsigned DAC1REF14          : 1;
    unsigned DAC1REF15          : 1;
    };

  struct
    {
    unsigned R8                 : 1;
    unsigned R9                 : 1;
    unsigned R10                : 1;
    unsigned R11                : 1;
    unsigned R12                : 1;
    unsigned R13                : 1;
    unsigned R14                : 1;
    unsigned R15                : 1;
    };

  struct
    {
    unsigned DAC1R8             : 1;
    unsigned DAC1R9             : 1;
    unsigned DAC1R10            : 1;
    unsigned DAC1R11            : 1;
    unsigned DAC1R12            : 1;
    unsigned DAC1R13            : 1;
    unsigned DAC1R14            : 1;
    unsigned DAC1R15            : 1;
    };
  } __DAC1REFHbits_t;

extern __at(0x0593) volatile __DAC1REFHbits_t DAC1REFHbits;

#define _DAC1REFH_REF8          0x01
#define _DAC1REFH_DAC1REF8      0x01
#define _DAC1REFH_R8            0x01
#define _DAC1REFH_DAC1R8        0x01
#define _DAC1REFH_REF9          0x02
#define _DAC1REFH_DAC1REF9      0x02
#define _DAC1REFH_R9            0x02
#define _DAC1REFH_DAC1R9        0x02
#define _DAC1REFH_REF10         0x04
#define _DAC1REFH_DAC1REF10     0x04
#define _DAC1REFH_R10           0x04
#define _DAC1REFH_DAC1R10       0x04
#define _DAC1REFH_REF11         0x08
#define _DAC1REFH_DAC1REF11     0x08
#define _DAC1REFH_R11           0x08
#define _DAC1REFH_DAC1R11       0x08
#define _DAC1REFH_REF12         0x10
#define _DAC1REFH_DAC1REF12     0x10
#define _DAC1REFH_R12           0x10
#define _DAC1REFH_DAC1R12       0x10
#define _DAC1REFH_REF13         0x20
#define _DAC1REFH_DAC1REF13     0x20
#define _DAC1REFH_R13           0x20
#define _DAC1REFH_DAC1R13       0x20
#define _DAC1REFH_REF14         0x40
#define _DAC1REFH_DAC1REF14     0x40
#define _DAC1REFH_R14           0x40
#define _DAC1REFH_DAC1R14       0x40
#define _DAC1REFH_REF15         0x80
#define _DAC1REFH_DAC1REF15     0x80
#define _DAC1REFH_R15           0x80
#define _DAC1REFH_DAC1R15       0x80

//==============================================================================


//==============================================================================
//        DAC3CON0 Bits

extern __at(0x0597) __sfr DAC3CON0;

typedef union
  {
  struct
    {
    unsigned NSS                : 1;
    unsigned                    : 1;
    unsigned PSS0               : 1;
    unsigned PSS1               : 1;
    unsigned                    : 1;
    unsigned OE1                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned DACNSS             : 1;
    unsigned                    : 1;
    unsigned DACPSS0            : 1;
    unsigned DACPSS1            : 1;
    unsigned                    : 1;
    unsigned DACOE1             : 1;
    unsigned                    : 1;
    unsigned DACEN              : 1;
    };

  struct
    {
    unsigned DAC3NSS            : 1;
    unsigned                    : 1;
    unsigned DAC3PSS0           : 1;
    unsigned DAC3PSS1           : 1;
    unsigned                    : 1;
    unsigned DAC3OE1            : 1;
    unsigned                    : 1;
    unsigned DAC3EN             : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned DAC3PSS            : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned DACPSS             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS                : 2;
    unsigned                    : 4;
    };
  } __DAC3CON0bits_t;

extern __at(0x0597) volatile __DAC3CON0bits_t DAC3CON0bits;

#define _DAC3CON0_NSS           0x01
#define _DAC3CON0_DACNSS        0x01
#define _DAC3CON0_DAC3NSS       0x01
#define _DAC3CON0_PSS0          0x04
#define _DAC3CON0_DACPSS0       0x04
#define _DAC3CON0_DAC3PSS0      0x04
#define _DAC3CON0_PSS1          0x08
#define _DAC3CON0_DACPSS1       0x08
#define _DAC3CON0_DAC3PSS1      0x08
#define _DAC3CON0_OE1           0x20
#define _DAC3CON0_DACOE1        0x20
#define _DAC3CON0_DAC3OE1       0x20
#define _DAC3CON0_EN            0x80
#define _DAC3CON0_DACEN         0x80
#define _DAC3CON0_DAC3EN        0x80

//==============================================================================


//==============================================================================
//        DAC3CON1 Bits

extern __at(0x0598) __sfr DAC3CON1;

typedef union
  {
  struct
    {
    unsigned DACR0              : 1;
    unsigned DACR1              : 1;
    unsigned DACR2              : 1;
    unsigned DACR3              : 1;
    unsigned DACR4              : 1;
    unsigned REF5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned R0                 : 1;
    unsigned R1                 : 1;
    unsigned R2                 : 1;
    unsigned R3                 : 1;
    unsigned R4                 : 1;
    unsigned DAC3REF5           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DAC3R0             : 1;
    unsigned DAC3R1             : 1;
    unsigned DAC3R2             : 1;
    unsigned DAC3R3             : 1;
    unsigned DAC3R4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned REF0               : 1;
    unsigned REF1               : 1;
    unsigned REF2               : 1;
    unsigned REF3               : 1;
    unsigned REF4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DAC3REF0           : 1;
    unsigned DAC3REF1           : 1;
    unsigned DAC3REF2           : 1;
    unsigned DAC3REF3           : 1;
    unsigned DAC3REF4           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DAC3R              : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned DAC3REF            : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned REF                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned R                  : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned DACR               : 5;
    unsigned                    : 3;
    };
  } __DAC3CON1bits_t;

extern __at(0x0598) volatile __DAC3CON1bits_t DAC3CON1bits;

#define _DAC3CON1_DACR0         0x01
#define _DAC3CON1_R0            0x01
#define _DAC3CON1_DAC3R0        0x01
#define _DAC3CON1_REF0          0x01
#define _DAC3CON1_DAC3REF0      0x01
#define _DAC3CON1_DACR1         0x02
#define _DAC3CON1_R1            0x02
#define _DAC3CON1_DAC3R1        0x02
#define _DAC3CON1_REF1          0x02
#define _DAC3CON1_DAC3REF1      0x02
#define _DAC3CON1_DACR2         0x04
#define _DAC3CON1_R2            0x04
#define _DAC3CON1_DAC3R2        0x04
#define _DAC3CON1_REF2          0x04
#define _DAC3CON1_DAC3REF2      0x04
#define _DAC3CON1_DACR3         0x08
#define _DAC3CON1_R3            0x08
#define _DAC3CON1_DAC3R3        0x08
#define _DAC3CON1_REF3          0x08
#define _DAC3CON1_DAC3REF3      0x08
#define _DAC3CON1_DACR4         0x10
#define _DAC3CON1_R4            0x10
#define _DAC3CON1_DAC3R4        0x10
#define _DAC3CON1_REF4          0x10
#define _DAC3CON1_DAC3REF4      0x10
#define _DAC3CON1_REF5          0x20
#define _DAC3CON1_DAC3REF5      0x20

//==============================================================================


//==============================================================================
//        DAC3REF Bits

extern __at(0x0598) __sfr DAC3REF;

typedef union
  {
  struct
    {
    unsigned DACR0              : 1;
    unsigned DACR1              : 1;
    unsigned DACR2              : 1;
    unsigned DACR3              : 1;
    unsigned DACR4              : 1;
    unsigned REF5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned R0                 : 1;
    unsigned R1                 : 1;
    unsigned R2                 : 1;
    unsigned R3                 : 1;
    unsigned R4                 : 1;
    unsigned DAC3REF5           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DAC3R0             : 1;
    unsigned DAC3R1             : 1;
    unsigned DAC3R2             : 1;
    unsigned DAC3R3             : 1;
    unsigned DAC3R4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned REF0               : 1;
    unsigned REF1               : 1;
    unsigned REF2               : 1;
    unsigned REF3               : 1;
    unsigned REF4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DAC3REF0           : 1;
    unsigned DAC3REF1           : 1;
    unsigned DAC3REF2           : 1;
    unsigned DAC3REF3           : 1;
    unsigned DAC3REF4           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DAC3R              : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned DAC3REF            : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned REF                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned DACR               : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned R                  : 5;
    unsigned                    : 3;
    };
  } __DAC3REFbits_t;

extern __at(0x0598) volatile __DAC3REFbits_t DAC3REFbits;

#define _DAC3REF_DACR0          0x01
#define _DAC3REF_R0             0x01
#define _DAC3REF_DAC3R0         0x01
#define _DAC3REF_REF0           0x01
#define _DAC3REF_DAC3REF0       0x01
#define _DAC3REF_DACR1          0x02
#define _DAC3REF_R1             0x02
#define _DAC3REF_DAC3R1         0x02
#define _DAC3REF_REF1           0x02
#define _DAC3REF_DAC3REF1       0x02
#define _DAC3REF_DACR2          0x04
#define _DAC3REF_R2             0x04
#define _DAC3REF_DAC3R2         0x04
#define _DAC3REF_REF2           0x04
#define _DAC3REF_DAC3REF2       0x04
#define _DAC3REF_DACR3          0x08
#define _DAC3REF_R3             0x08
#define _DAC3REF_DAC3R3         0x08
#define _DAC3REF_REF3           0x08
#define _DAC3REF_DAC3REF3       0x08
#define _DAC3REF_DACR4          0x10
#define _DAC3REF_R4             0x10
#define _DAC3REF_DAC3R4         0x10
#define _DAC3REF_REF4           0x10
#define _DAC3REF_DAC3REF4       0x10
#define _DAC3REF_REF5           0x20
#define _DAC3REF_DAC3REF5       0x20

//==============================================================================


//==============================================================================
//        PWM3DCL Bits

extern __at(0x0617) __sfr PWM3DCL;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DC0                : 1;
    unsigned DC1                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM3DC0            : 1;
    unsigned PWM3DC1            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWMPW0             : 1;
    unsigned PWMPW1             : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned PWMPW              : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned DC                 : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned PWM3DC             : 2;
    };
  } __PWM3DCLbits_t;

extern __at(0x0617) volatile __PWM3DCLbits_t PWM3DCLbits;

#define _DC0                    0x40
#define _PWM3DC0                0x40
#define _PWMPW0                 0x40
#define _DC1                    0x80
#define _PWM3DC1                0x80
#define _PWMPW1                 0x80

//==============================================================================


//==============================================================================
//        PWM3DCH Bits

extern __at(0x0618) __sfr PWM3DCH;

typedef union
  {
  struct
    {
    unsigned DC2                : 1;
    unsigned DC3                : 1;
    unsigned DC4                : 1;
    unsigned DC5                : 1;
    unsigned DC6                : 1;
    unsigned DC7                : 1;
    unsigned DC8                : 1;
    unsigned DC9                : 1;
    };

  struct
    {
    unsigned PWM3DC2            : 1;
    unsigned PWM3DC3            : 1;
    unsigned PWM3DC4            : 1;
    unsigned PWM3DC5            : 1;
    unsigned PWM3DC6            : 1;
    unsigned PWM3DC7            : 1;
    unsigned PWM3DC8            : 1;
    unsigned PWM3DC9            : 1;
    };

  struct
    {
    unsigned PWMPW2             : 1;
    unsigned PWMPW3             : 1;
    unsigned PWMPW4             : 1;
    unsigned PWMPW5             : 1;
    unsigned PWMPW6             : 1;
    unsigned PWMPW7             : 1;
    unsigned PWMPW8             : 1;
    unsigned PWMPW9             : 1;
    };
  } __PWM3DCHbits_t;

extern __at(0x0618) volatile __PWM3DCHbits_t PWM3DCHbits;

#define _DC2                    0x01
#define _PWM3DC2                0x01
#define _PWMPW2                 0x01
#define _DC3                    0x02
#define _PWM3DC3                0x02
#define _PWMPW3                 0x02
#define _DC4                    0x04
#define _PWM3DC4                0x04
#define _PWMPW4                 0x04
#define _DC5                    0x08
#define _PWM3DC5                0x08
#define _PWMPW5                 0x08
#define _DC6                    0x10
#define _PWM3DC6                0x10
#define _PWMPW6                 0x10
#define _DC7                    0x20
#define _PWM3DC7                0x20
#define _PWMPW7                 0x20
#define _DC8                    0x40
#define _PWM3DC8                0x40
#define _PWMPW8                 0x40
#define _DC9                    0x80
#define _PWM3DC9                0x80
#define _PWMPW9                 0x80

//==============================================================================


//==============================================================================
//        PWM3CON Bits

extern __at(0x0619) __sfr PWM3CON;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM3POL            : 1;
    unsigned PWM3OUT            : 1;
    unsigned                    : 1;
    unsigned PWM3EN             : 1;
    };
  } __PWM3CONbits_t;

extern __at(0x0619) volatile __PWM3CONbits_t PWM3CONbits;

#define _PWM3CON_POL            0x10
#define _PWM3CON_PWM3POL        0x10
#define _PWM3CON_OUT            0x20
#define _PWM3CON_PWM3OUT        0x20
#define _PWM3CON_EN             0x80
#define _PWM3CON_PWM3EN         0x80

//==============================================================================


//==============================================================================
//        COG1PHR Bits

extern __at(0x068D) __sfr COG1PHR;

typedef union
  {
  struct
    {
    unsigned PHR0               : 1;
    unsigned PHR1               : 1;
    unsigned PHR2               : 1;
    unsigned PHR3               : 1;
    unsigned PHR4               : 1;
    unsigned PHR5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1PHR0             : 1;
    unsigned G1PHR1             : 1;
    unsigned G1PHR2             : 1;
    unsigned G1PHR3             : 1;
    unsigned G1PHR4             : 1;
    unsigned G1PHR5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1PHR              : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned PHR                : 6;
    unsigned                    : 2;
    };
  } __COG1PHRbits_t;

extern __at(0x068D) volatile __COG1PHRbits_t COG1PHRbits;

#define _PHR0                   0x01
#define _G1PHR0                 0x01
#define _PHR1                   0x02
#define _G1PHR1                 0x02
#define _PHR2                   0x04
#define _G1PHR2                 0x04
#define _PHR3                   0x08
#define _G1PHR3                 0x08
#define _PHR4                   0x10
#define _G1PHR4                 0x10
#define _PHR5                   0x20
#define _G1PHR5                 0x20

//==============================================================================


//==============================================================================
//        COG1PHF Bits

extern __at(0x068E) __sfr COG1PHF;

typedef union
  {
  struct
    {
    unsigned PHF0               : 1;
    unsigned PHF1               : 1;
    unsigned PHF2               : 1;
    unsigned PHF3               : 1;
    unsigned PHF4               : 1;
    unsigned PHF5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1PHF0             : 1;
    unsigned G1PHF1             : 1;
    unsigned G1PHF2             : 1;
    unsigned G1PHF3             : 1;
    unsigned G1PHF4             : 1;
    unsigned G1PHF5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1PHF              : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned PHF                : 6;
    unsigned                    : 2;
    };
  } __COG1PHFbits_t;

extern __at(0x068E) volatile __COG1PHFbits_t COG1PHFbits;

#define _PHF0                   0x01
#define _G1PHF0                 0x01
#define _PHF1                   0x02
#define _G1PHF1                 0x02
#define _PHF2                   0x04
#define _G1PHF2                 0x04
#define _PHF3                   0x08
#define _G1PHF3                 0x08
#define _PHF4                   0x10
#define _G1PHF4                 0x10
#define _PHF5                   0x20
#define _G1PHF5                 0x20

//==============================================================================


//==============================================================================
//        COG1BLKR Bits

extern __at(0x068F) __sfr COG1BLKR;

typedef union
  {
  struct
    {
    unsigned BLKR0              : 1;
    unsigned BLKR1              : 1;
    unsigned BLKR2              : 1;
    unsigned BLKR3              : 1;
    unsigned BLKR4              : 1;
    unsigned BLKR5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1BLKR0            : 1;
    unsigned G1BLKR1            : 1;
    unsigned G1BLKR2            : 1;
    unsigned G1BLKR3            : 1;
    unsigned G1BLKR4            : 1;
    unsigned G1BLKR5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned BLKR               : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned G1BLKR             : 6;
    unsigned                    : 2;
    };
  } __COG1BLKRbits_t;

extern __at(0x068F) volatile __COG1BLKRbits_t COG1BLKRbits;

#define _BLKR0                  0x01
#define _G1BLKR0                0x01
#define _BLKR1                  0x02
#define _G1BLKR1                0x02
#define _BLKR2                  0x04
#define _G1BLKR2                0x04
#define _BLKR3                  0x08
#define _G1BLKR3                0x08
#define _BLKR4                  0x10
#define _G1BLKR4                0x10
#define _BLKR5                  0x20
#define _G1BLKR5                0x20

//==============================================================================


//==============================================================================
//        COG1BLKF Bits

extern __at(0x0690) __sfr COG1BLKF;

typedef union
  {
  struct
    {
    unsigned BLKF0              : 1;
    unsigned BLKF1              : 1;
    unsigned BLKF2              : 1;
    unsigned BLKF3              : 1;
    unsigned BLKF4              : 1;
    unsigned BLKF5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1BLKF0            : 1;
    unsigned G1BLKF1            : 1;
    unsigned G1BLKF2            : 1;
    unsigned G1BLKF3            : 1;
    unsigned G1BLKF4            : 1;
    unsigned G1BLKF5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned BLKF               : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned G1BLKF             : 6;
    unsigned                    : 2;
    };
  } __COG1BLKFbits_t;

extern __at(0x0690) volatile __COG1BLKFbits_t COG1BLKFbits;

#define _BLKF0                  0x01
#define _G1BLKF0                0x01
#define _BLKF1                  0x02
#define _G1BLKF1                0x02
#define _BLKF2                  0x04
#define _G1BLKF2                0x04
#define _BLKF3                  0x08
#define _G1BLKF3                0x08
#define _BLKF4                  0x10
#define _G1BLKF4                0x10
#define _BLKF5                  0x20
#define _G1BLKF5                0x20

//==============================================================================


//==============================================================================
//        COG1DBR Bits

extern __at(0x0691) __sfr COG1DBR;

typedef union
  {
  struct
    {
    unsigned DBR0               : 1;
    unsigned DBR1               : 1;
    unsigned DBR2               : 1;
    unsigned DBR3               : 1;
    unsigned DBR4               : 1;
    unsigned DBR5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1DBR0             : 1;
    unsigned G1DBR1             : 1;
    unsigned G1DBR2             : 1;
    unsigned G1DBR3             : 1;
    unsigned G1DBR4             : 1;
    unsigned G1DBR5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1DBR              : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned DBR                : 6;
    unsigned                    : 2;
    };
  } __COG1DBRbits_t;

extern __at(0x0691) volatile __COG1DBRbits_t COG1DBRbits;

#define _DBR0                   0x01
#define _G1DBR0                 0x01
#define _DBR1                   0x02
#define _G1DBR1                 0x02
#define _DBR2                   0x04
#define _G1DBR2                 0x04
#define _DBR3                   0x08
#define _G1DBR3                 0x08
#define _DBR4                   0x10
#define _G1DBR4                 0x10
#define _DBR5                   0x20
#define _G1DBR5                 0x20

//==============================================================================


//==============================================================================
//        COG1DBF Bits

extern __at(0x0692) __sfr COG1DBF;

typedef union
  {
  struct
    {
    unsigned DBF0               : 1;
    unsigned DBF1               : 1;
    unsigned DBF2               : 1;
    unsigned DBF3               : 1;
    unsigned DBF4               : 1;
    unsigned DBF5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1DBF0             : 1;
    unsigned G1DBF1             : 1;
    unsigned G1DBF2             : 1;
    unsigned G1DBF3             : 1;
    unsigned G1DBF4             : 1;
    unsigned G1DBF5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DBF                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned G1DBF              : 6;
    unsigned                    : 2;
    };
  } __COG1DBFbits_t;

extern __at(0x0692) volatile __COG1DBFbits_t COG1DBFbits;

#define _DBF0                   0x01
#define _G1DBF0                 0x01
#define _DBF1                   0x02
#define _G1DBF1                 0x02
#define _DBF2                   0x04
#define _G1DBF2                 0x04
#define _DBF3                   0x08
#define _G1DBF3                 0x08
#define _DBF4                   0x10
#define _G1DBF4                 0x10
#define _DBF5                   0x20
#define _G1DBF5                 0x20

//==============================================================================


//==============================================================================
//        COG1CON0 Bits

extern __at(0x0693) __sfr COG1CON0;

typedef union
  {
  struct
    {
    unsigned MD0                : 1;
    unsigned MD1                : 1;
    unsigned MD2                : 1;
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    unsigned                    : 1;
    unsigned LD                 : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned G1MD0              : 1;
    unsigned G1MD1              : 1;
    unsigned G1MD2              : 1;
    unsigned G1CS0              : 1;
    unsigned G1CS1              : 1;
    unsigned                    : 1;
    unsigned G1LD               : 1;
    unsigned G1EN               : 1;
    };

  struct
    {
    unsigned MD                 : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned G1MD               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned G1CS               : 2;
    unsigned                    : 3;
    };

  struct
    {
    unsigned                    : 3;
    unsigned CS                 : 2;
    unsigned                    : 3;
    };
  } __COG1CON0bits_t;

extern __at(0x0693) volatile __COG1CON0bits_t COG1CON0bits;

#define _COG1CON0_MD0           0x01
#define _COG1CON0_G1MD0         0x01
#define _COG1CON0_MD1           0x02
#define _COG1CON0_G1MD1         0x02
#define _COG1CON0_MD2           0x04
#define _COG1CON0_G1MD2         0x04
#define _COG1CON0_CS0           0x08
#define _COG1CON0_G1CS0         0x08
#define _COG1CON0_CS1           0x10
#define _COG1CON0_G1CS1         0x10
#define _COG1CON0_LD            0x40
#define _COG1CON0_G1LD          0x40
#define _COG1CON0_EN            0x80
#define _COG1CON0_G1EN          0x80

//==============================================================================


//==============================================================================
//        COG1CON1 Bits

extern __at(0x0694) __sfr COG1CON1;

typedef union
  {
  struct
    {
    unsigned POLA               : 1;
    unsigned POLB               : 1;
    unsigned POLC               : 1;
    unsigned POLD               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned FDBS               : 1;
    unsigned RDBS               : 1;
    };

  struct
    {
    unsigned G1POLA             : 1;
    unsigned G1POLB             : 1;
    unsigned G1POLC             : 1;
    unsigned G1POLD             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned G1FDBS             : 1;
    unsigned G1RDBS             : 1;
    };
  } __COG1CON1bits_t;

extern __at(0x0694) volatile __COG1CON1bits_t COG1CON1bits;

#define _POLA                   0x01
#define _G1POLA                 0x01
#define _POLB                   0x02
#define _G1POLB                 0x02
#define _POLC                   0x04
#define _G1POLC                 0x04
#define _POLD                   0x08
#define _G1POLD                 0x08
#define _FDBS                   0x40
#define _G1FDBS                 0x40
#define _RDBS                   0x80
#define _G1RDBS                 0x80

//==============================================================================


//==============================================================================
//        COG1RIS0 Bits

extern __at(0x0695) __sfr COG1RIS0;

typedef union
  {
  struct
    {
    unsigned RIS0               : 1;
    unsigned RIS1               : 1;
    unsigned RIS2               : 1;
    unsigned RIS3               : 1;
    unsigned RIS4               : 1;
    unsigned RIS5               : 1;
    unsigned RIS6               : 1;
    unsigned RIS7               : 1;
    };

  struct
    {
    unsigned G1RIS0             : 1;
    unsigned G1RIS1             : 1;
    unsigned G1RIS2             : 1;
    unsigned G1RIS3             : 1;
    unsigned G1RIS4             : 1;
    unsigned G1RIS5             : 1;
    unsigned G1RIS6             : 1;
    unsigned G1RIS7             : 1;
    };
  } __COG1RIS0bits_t;

extern __at(0x0695) volatile __COG1RIS0bits_t COG1RIS0bits;

#define _RIS0                   0x01
#define _G1RIS0                 0x01
#define _RIS1                   0x02
#define _G1RIS1                 0x02
#define _RIS2                   0x04
#define _G1RIS2                 0x04
#define _RIS3                   0x08
#define _G1RIS3                 0x08
#define _RIS4                   0x10
#define _G1RIS4                 0x10
#define _RIS5                   0x20
#define _G1RIS5                 0x20
#define _RIS6                   0x40
#define _G1RIS6                 0x40
#define _RIS7                   0x80
#define _G1RIS7                 0x80

//==============================================================================


//==============================================================================
//        COG1RIS1 Bits

extern __at(0x0696) __sfr COG1RIS1;

typedef union
  {
  struct
    {
    unsigned RIS8               : 1;
    unsigned RIS9               : 1;
    unsigned RIS10              : 1;
    unsigned RIS11              : 1;
    unsigned RIS12              : 1;
    unsigned RIS13              : 1;
    unsigned RIS14              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1RIS8             : 1;
    unsigned G1RIS9             : 1;
    unsigned G1RIS10            : 1;
    unsigned G1RIS11            : 1;
    unsigned G1RIS12            : 1;
    unsigned G1RIS13            : 1;
    unsigned G1RIS14            : 1;
    unsigned                    : 1;
    };
  } __COG1RIS1bits_t;

extern __at(0x0696) volatile __COG1RIS1bits_t COG1RIS1bits;

#define _RIS8                   0x01
#define _G1RIS8                 0x01
#define _RIS9                   0x02
#define _G1RIS9                 0x02
#define _RIS10                  0x04
#define _G1RIS10                0x04
#define _RIS11                  0x08
#define _G1RIS11                0x08
#define _RIS12                  0x10
#define _G1RIS12                0x10
#define _RIS13                  0x20
#define _G1RIS13                0x20
#define _RIS14                  0x40
#define _G1RIS14                0x40

//==============================================================================


//==============================================================================
//        COG1RSIM0 Bits

extern __at(0x0697) __sfr COG1RSIM0;

typedef union
  {
  struct
    {
    unsigned RSIM0              : 1;
    unsigned RSIM1              : 1;
    unsigned RSIM2              : 1;
    unsigned RSIM3              : 1;
    unsigned RSIM4              : 1;
    unsigned RSIM5              : 1;
    unsigned RSIM6              : 1;
    unsigned RSIM7              : 1;
    };

  struct
    {
    unsigned G1RSIM0            : 1;
    unsigned G1RSIM1            : 1;
    unsigned G1RSIM2            : 1;
    unsigned G1RSIM3            : 1;
    unsigned G1RSIM4            : 1;
    unsigned G1RSIM5            : 1;
    unsigned G1RSIM6            : 1;
    unsigned G1RSIM7            : 1;
    };
  } __COG1RSIM0bits_t;

extern __at(0x0697) volatile __COG1RSIM0bits_t COG1RSIM0bits;

#define _RSIM0                  0x01
#define _G1RSIM0                0x01
#define _RSIM1                  0x02
#define _G1RSIM1                0x02
#define _RSIM2                  0x04
#define _G1RSIM2                0x04
#define _RSIM3                  0x08
#define _G1RSIM3                0x08
#define _RSIM4                  0x10
#define _G1RSIM4                0x10
#define _RSIM5                  0x20
#define _G1RSIM5                0x20
#define _RSIM6                  0x40
#define _G1RSIM6                0x40
#define _RSIM7                  0x80
#define _G1RSIM7                0x80

//==============================================================================


//==============================================================================
//        COG1RSIM1 Bits

extern __at(0x0698) __sfr COG1RSIM1;

typedef union
  {
  struct
    {
    unsigned RSIM8              : 1;
    unsigned RSIM9              : 1;
    unsigned RSIM10             : 1;
    unsigned RSIM11             : 1;
    unsigned RSIM12             : 1;
    unsigned RSIM13             : 1;
    unsigned RSIM14             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1RSIM8            : 1;
    unsigned G1RSIM9            : 1;
    unsigned G1RSIM10           : 1;
    unsigned G1RSIM11           : 1;
    unsigned G1RSIM12           : 1;
    unsigned G1RSIM13           : 1;
    unsigned G1RSIM14           : 1;
    unsigned                    : 1;
    };
  } __COG1RSIM1bits_t;

extern __at(0x0698) volatile __COG1RSIM1bits_t COG1RSIM1bits;

#define _RSIM8                  0x01
#define _G1RSIM8                0x01
#define _RSIM9                  0x02
#define _G1RSIM9                0x02
#define _RSIM10                 0x04
#define _G1RSIM10               0x04
#define _RSIM11                 0x08
#define _G1RSIM11               0x08
#define _RSIM12                 0x10
#define _G1RSIM12               0x10
#define _RSIM13                 0x20
#define _G1RSIM13               0x20
#define _RSIM14                 0x40
#define _G1RSIM14               0x40

//==============================================================================


//==============================================================================
//        COG1FIS0 Bits

extern __at(0x0699) __sfr COG1FIS0;

typedef union
  {
  struct
    {
    unsigned FIS0               : 1;
    unsigned FIS1               : 1;
    unsigned FIS2               : 1;
    unsigned FIS3               : 1;
    unsigned FIS4               : 1;
    unsigned FIS5               : 1;
    unsigned FIS6               : 1;
    unsigned FIS7               : 1;
    };

  struct
    {
    unsigned G1FIS0             : 1;
    unsigned G1FIS1             : 1;
    unsigned G1FIS2             : 1;
    unsigned G1FIS3             : 1;
    unsigned G1FIS4             : 1;
    unsigned G1FIS5             : 1;
    unsigned G1FIS6             : 1;
    unsigned G1FIS7             : 1;
    };
  } __COG1FIS0bits_t;

extern __at(0x0699) volatile __COG1FIS0bits_t COG1FIS0bits;

#define _FIS0                   0x01
#define _G1FIS0                 0x01
#define _FIS1                   0x02
#define _G1FIS1                 0x02
#define _FIS2                   0x04
#define _G1FIS2                 0x04
#define _FIS3                   0x08
#define _G1FIS3                 0x08
#define _FIS4                   0x10
#define _G1FIS4                 0x10
#define _FIS5                   0x20
#define _G1FIS5                 0x20
#define _FIS6                   0x40
#define _G1FIS6                 0x40
#define _FIS7                   0x80
#define _G1FIS7                 0x80

//==============================================================================


//==============================================================================
//        COG1FIS1 Bits

extern __at(0x069A) __sfr COG1FIS1;

typedef union
  {
  struct
    {
    unsigned FIS8               : 1;
    unsigned FIS9               : 1;
    unsigned FIS10              : 1;
    unsigned FIS11              : 1;
    unsigned FIS12              : 1;
    unsigned FIS13              : 1;
    unsigned FIS14              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1FIS8             : 1;
    unsigned G1FIS9             : 1;
    unsigned G1FIS10            : 1;
    unsigned G1FIS11            : 1;
    unsigned G1FIS12            : 1;
    unsigned G1FIS13            : 1;
    unsigned G1FIS14            : 1;
    unsigned                    : 1;
    };
  } __COG1FIS1bits_t;

extern __at(0x069A) volatile __COG1FIS1bits_t COG1FIS1bits;

#define _FIS8                   0x01
#define _G1FIS8                 0x01
#define _FIS9                   0x02
#define _G1FIS9                 0x02
#define _FIS10                  0x04
#define _G1FIS10                0x04
#define _FIS11                  0x08
#define _G1FIS11                0x08
#define _FIS12                  0x10
#define _G1FIS12                0x10
#define _FIS13                  0x20
#define _G1FIS13                0x20
#define _FIS14                  0x40
#define _G1FIS14                0x40

//==============================================================================


//==============================================================================
//        COG1FSIM0 Bits

extern __at(0x069B) __sfr COG1FSIM0;

typedef union
  {
  struct
    {
    unsigned FSIM0              : 1;
    unsigned FSIM1              : 1;
    unsigned FSIM2              : 1;
    unsigned FSIM3              : 1;
    unsigned FSIM4              : 1;
    unsigned FSIM5              : 1;
    unsigned FSIM6              : 1;
    unsigned FSIM7              : 1;
    };

  struct
    {
    unsigned G1FSIM0            : 1;
    unsigned G1FSIM1            : 1;
    unsigned G1FSIM2            : 1;
    unsigned G1FSIM3            : 1;
    unsigned G1FSIM4            : 1;
    unsigned G1FSIM5            : 1;
    unsigned G1FSIM6            : 1;
    unsigned G1FSIM7            : 1;
    };
  } __COG1FSIM0bits_t;

extern __at(0x069B) volatile __COG1FSIM0bits_t COG1FSIM0bits;

#define _FSIM0                  0x01
#define _G1FSIM0                0x01
#define _FSIM1                  0x02
#define _G1FSIM1                0x02
#define _FSIM2                  0x04
#define _G1FSIM2                0x04
#define _FSIM3                  0x08
#define _G1FSIM3                0x08
#define _FSIM4                  0x10
#define _G1FSIM4                0x10
#define _FSIM5                  0x20
#define _G1FSIM5                0x20
#define _FSIM6                  0x40
#define _G1FSIM6                0x40
#define _FSIM7                  0x80
#define _G1FSIM7                0x80

//==============================================================================


//==============================================================================
//        COG1FSIM1 Bits

extern __at(0x069C) __sfr COG1FSIM1;

typedef union
  {
  struct
    {
    unsigned FSIM8              : 1;
    unsigned FSIM9              : 1;
    unsigned FSIM10             : 1;
    unsigned FSIM11             : 1;
    unsigned FSIM12             : 1;
    unsigned FSIM13             : 1;
    unsigned FSIM14             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1FSIM8            : 1;
    unsigned G1FSIM9            : 1;
    unsigned G1FSIM10           : 1;
    unsigned G1FSIM11           : 1;
    unsigned G1FSIM12           : 1;
    unsigned G1FSIM13           : 1;
    unsigned G1FSIM14           : 1;
    unsigned                    : 1;
    };
  } __COG1FSIM1bits_t;

extern __at(0x069C) volatile __COG1FSIM1bits_t COG1FSIM1bits;

#define _FSIM8                  0x01
#define _G1FSIM8                0x01
#define _FSIM9                  0x02
#define _G1FSIM9                0x02
#define _FSIM10                 0x04
#define _G1FSIM10               0x04
#define _FSIM11                 0x08
#define _G1FSIM11               0x08
#define _FSIM12                 0x10
#define _G1FSIM12               0x10
#define _FSIM13                 0x20
#define _G1FSIM13               0x20
#define _FSIM14                 0x40
#define _G1FSIM14               0x40

//==============================================================================


//==============================================================================
//        COG1ASD0 Bits

extern __at(0x069D) __sfr COG1ASD0;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ASDAC0             : 1;
    unsigned ASDAC1             : 1;
    unsigned ASDBD0             : 1;
    unsigned ASDBD1             : 1;
    unsigned ASREN              : 1;
    unsigned ASE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned G1ASDAC0           : 1;
    unsigned G1ASDAC1           : 1;
    unsigned G1ASDBD0           : 1;
    unsigned G1ASDBD1           : 1;
    unsigned ARSEN              : 1;
    unsigned G1ASE              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned G1ARSEN            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned G1ASREN            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned G1ASDAC            : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned ASDAC              : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ASDBD              : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 4;
    unsigned G1ASDBD            : 2;
    unsigned                    : 2;
    };
  } __COG1ASD0bits_t;

extern __at(0x069D) volatile __COG1ASD0bits_t COG1ASD0bits;

#define _ASDAC0                 0x04
#define _G1ASDAC0               0x04
#define _ASDAC1                 0x08
#define _G1ASDAC1               0x08
#define _ASDBD0                 0x10
#define _G1ASDBD0               0x10
#define _ASDBD1                 0x20
#define _G1ASDBD1               0x20
#define _ASREN                  0x40
#define _ARSEN                  0x40
#define _G1ARSEN                0x40
#define _G1ASREN                0x40
#define _ASE                    0x80
#define _G1ASE                  0x80

//==============================================================================


//==============================================================================
//        COG1ASD1 Bits

extern __at(0x069E) __sfr COG1ASD1;

typedef union
  {
  struct
    {
    unsigned AS0E               : 1;
    unsigned AS1E               : 1;
    unsigned AS2E               : 1;
    unsigned AS3E               : 1;
    unsigned AS4E               : 1;
    unsigned AS5E               : 1;
    unsigned AS6E               : 1;
    unsigned AS7E               : 1;
    };

  struct
    {
    unsigned G1AS0E             : 1;
    unsigned G1AS1E             : 1;
    unsigned G1AS2E             : 1;
    unsigned G1AS3E             : 1;
    unsigned G1AS4E             : 1;
    unsigned G1AS5E             : 1;
    unsigned G1AS6E             : 1;
    unsigned G1AS7E             : 1;
    };
  } __COG1ASD1bits_t;

extern __at(0x069E) volatile __COG1ASD1bits_t COG1ASD1bits;

#define _AS0E                   0x01
#define _G1AS0E                 0x01
#define _AS1E                   0x02
#define _G1AS1E                 0x02
#define _AS2E                   0x04
#define _G1AS2E                 0x04
#define _AS3E                   0x08
#define _G1AS3E                 0x08
#define _AS4E                   0x10
#define _G1AS4E                 0x10
#define _AS5E                   0x20
#define _G1AS5E                 0x20
#define _AS6E                   0x40
#define _G1AS6E                 0x40
#define _AS7E                   0x80
#define _G1AS7E                 0x80

//==============================================================================


//==============================================================================
//        COG1STR Bits

extern __at(0x069F) __sfr COG1STR;

typedef union
  {
  struct
    {
    unsigned STRA               : 1;
    unsigned STRB               : 1;
    unsigned STRC               : 1;
    unsigned STRD               : 1;
    unsigned SDATA              : 1;
    unsigned SDATB              : 1;
    unsigned SDATC              : 1;
    unsigned SDATD              : 1;
    };

  struct
    {
    unsigned G1STRA             : 1;
    unsigned G1STRB             : 1;
    unsigned G1STRC             : 1;
    unsigned G1STRD             : 1;
    unsigned G1SDATA            : 1;
    unsigned G1SDATB            : 1;
    unsigned G1SDATC            : 1;
    unsigned G1SDATD            : 1;
    };
  } __COG1STRbits_t;

extern __at(0x069F) volatile __COG1STRbits_t COG1STRbits;

#define _STRA                   0x01
#define _G1STRA                 0x01
#define _STRB                   0x02
#define _G1STRB                 0x02
#define _STRC                   0x04
#define _G1STRC                 0x04
#define _STRD                   0x08
#define _G1STRD                 0x08
#define _SDATA                  0x10
#define _G1SDATA                0x10
#define _SDATB                  0x20
#define _G1SDATB                0x20
#define _SDATC                  0x40
#define _G1SDATC                0x40
#define _SDATD                  0x80
#define _G1SDATD                0x80

//==============================================================================


//==============================================================================
//        PRG1RTSS Bits

extern __at(0x0794) __sfr PRG1RTSS;

typedef union
  {
  struct
    {
    unsigned RTSS0              : 1;
    unsigned RTSS1              : 1;
    unsigned RTSS2              : 1;
    unsigned RTSS3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG1RTSS0           : 1;
    unsigned RG1RTSS1           : 1;
    unsigned RG1RTSS2           : 1;
    unsigned RG1RTSS3           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG1RTSS            : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned RTSS               : 4;
    unsigned                    : 4;
    };
  } __PRG1RTSSbits_t;

extern __at(0x0794) volatile __PRG1RTSSbits_t PRG1RTSSbits;

#define _RTSS0                  0x01
#define _RG1RTSS0               0x01
#define _RTSS1                  0x02
#define _RG1RTSS1               0x02
#define _RTSS2                  0x04
#define _RG1RTSS2               0x04
#define _RTSS3                  0x08
#define _RG1RTSS3               0x08

//==============================================================================


//==============================================================================
//        PRG1FTSS Bits

extern __at(0x0795) __sfr PRG1FTSS;

typedef union
  {
  struct
    {
    unsigned FTSS0              : 1;
    unsigned FTSS1              : 1;
    unsigned FTSS2              : 1;
    unsigned FTSS3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG1FTSS0           : 1;
    unsigned RG1FTSS1           : 1;
    unsigned RG1FTSS2           : 1;
    unsigned RG1FTSS3           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned FTSS               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned RG1FTSS            : 4;
    unsigned                    : 4;
    };
  } __PRG1FTSSbits_t;

extern __at(0x0795) volatile __PRG1FTSSbits_t PRG1FTSSbits;

#define _FTSS0                  0x01
#define _RG1FTSS0               0x01
#define _FTSS1                  0x02
#define _RG1FTSS1               0x02
#define _FTSS2                  0x04
#define _RG1FTSS2               0x04
#define _FTSS3                  0x08
#define _RG1FTSS3               0x08

//==============================================================================


//==============================================================================
//        PRG1INS Bits

extern __at(0x0796) __sfr PRG1INS;

typedef union
  {
  struct
    {
    unsigned INS0               : 1;
    unsigned INS1               : 1;
    unsigned INS2               : 1;
    unsigned INS3               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG1INS0            : 1;
    unsigned RG1INS1            : 1;
    unsigned RG1INS2            : 1;
    unsigned RG1INS3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG1INS             : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned INS                : 4;
    unsigned                    : 4;
    };
  } __PRG1INSbits_t;

extern __at(0x0796) volatile __PRG1INSbits_t PRG1INSbits;

#define _INS0                   0x01
#define _RG1INS0                0x01
#define _INS1                   0x02
#define _RG1INS1                0x02
#define _INS2                   0x04
#define _RG1INS2                0x04
#define _INS3                   0x08
#define _RG1INS3                0x08

//==============================================================================


//==============================================================================
//        PRG1CON0 Bits

extern __at(0x0797) __sfr PRG1CON0;

typedef union
  {
  struct
    {
    unsigned GO                 : 1;
    unsigned OS                 : 1;
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned REDG               : 1;
    unsigned FEDG               : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned RG1GO              : 1;
    unsigned RG1OS              : 1;
    unsigned RG1MODE0           : 1;
    unsigned RG1MODE1           : 1;
    unsigned RG1REDG            : 1;
    unsigned RG1FEDG            : 1;
    unsigned                    : 1;
    unsigned RG1EN              : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned MODE               : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned RG1MODE            : 2;
    unsigned                    : 4;
    };
  } __PRG1CON0bits_t;

extern __at(0x0797) volatile __PRG1CON0bits_t PRG1CON0bits;

#define _PRG1CON0_GO            0x01
#define _PRG1CON0_RG1GO         0x01
#define _PRG1CON0_OS            0x02
#define _PRG1CON0_RG1OS         0x02
#define _PRG1CON0_MODE0         0x04
#define _PRG1CON0_RG1MODE0      0x04
#define _PRG1CON0_MODE1         0x08
#define _PRG1CON0_RG1MODE1      0x08
#define _PRG1CON0_REDG          0x10
#define _PRG1CON0_RG1REDG       0x10
#define _PRG1CON0_FEDG          0x20
#define _PRG1CON0_RG1FEDG       0x20
#define _PRG1CON0_EN            0x80
#define _PRG1CON0_RG1EN         0x80

//==============================================================================


//==============================================================================
//        PRG1CON1 Bits

extern __at(0x0798) __sfr PRG1CON1;

typedef union
  {
  struct
    {
    unsigned RPOL               : 1;
    unsigned FPOL               : 1;
    unsigned RDY                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG1RPOL            : 1;
    unsigned RG1FPOL            : 1;
    unsigned RG1RDY             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PRG1CON1bits_t;

extern __at(0x0798) volatile __PRG1CON1bits_t PRG1CON1bits;

#define _RPOL                   0x01
#define _RG1RPOL                0x01
#define _FPOL                   0x02
#define _RG1FPOL                0x02
#define _RDY                    0x04
#define _RG1RDY                 0x04

//==============================================================================


//==============================================================================
//        PRG1CON2 Bits

extern __at(0x0799) __sfr PRG1CON2;

typedef union
  {
  struct
    {
    unsigned ISET0              : 1;
    unsigned ISET1              : 1;
    unsigned ISET2              : 1;
    unsigned ISET3              : 1;
    unsigned ISET4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG1ISET0           : 1;
    unsigned RG1ISET1           : 1;
    unsigned RG1ISET2           : 1;
    unsigned RG1ISET3           : 1;
    unsigned RG1ISET4           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG1ISET            : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned ISET               : 5;
    unsigned                    : 3;
    };
  } __PRG1CON2bits_t;

extern __at(0x0799) volatile __PRG1CON2bits_t PRG1CON2bits;

#define _ISET0                  0x01
#define _RG1ISET0               0x01
#define _ISET1                  0x02
#define _RG1ISET1               0x02
#define _ISET2                  0x04
#define _RG1ISET2               0x04
#define _ISET3                  0x08
#define _RG1ISET3               0x08
#define _ISET4                  0x10
#define _RG1ISET4               0x10

//==============================================================================


//==============================================================================
//        PWMEN Bits

extern __at(0x0D8E) __sfr PWMEN;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned MPWM5EN              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PWMENbits_t;

extern __at(0x0D8E) volatile __PWMENbits_t PWMENbits;

#define _MPWM5EN                0x10

//==============================================================================


//==============================================================================
//        PWMLD Bits

extern __at(0x0D8F) __sfr PWMLD;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned MPWM5LD              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PWMLDbits_t;

extern __at(0x0D8F) volatile __PWMLDbits_t PWMLDbits;

#define _MPWM5LD                0x10

//==============================================================================


//==============================================================================
//        PWMOUT Bits

extern __at(0x0D90) __sfr PWMOUT;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned MPWM5OUT             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PWMOUTbits_t;

extern __at(0x0D90) volatile __PWMOUTbits_t PWMOUTbits;

#define _MPWM5OUT               0x10

//==============================================================================

extern __at(0x0D91) __sfr PWM5PH;

//==============================================================================
//        PWM5PHL Bits

extern __at(0x0D91) __sfr PWM5PHL;

typedef struct
  {
  unsigned PWM5PHL0             : 1;
  unsigned PWM5PHL1             : 1;
  unsigned PWM5PHL2             : 1;
  unsigned PWM5PHL3             : 1;
  unsigned PWM5PHL4             : 1;
  unsigned PWM5PHL5             : 1;
  unsigned PWM5PHL6             : 1;
  unsigned PWM5PHL7             : 1;
  } __PWM5PHLbits_t;

extern __at(0x0D91) volatile __PWM5PHLbits_t PWM5PHLbits;

#define _PWM5PHL0               0x01
#define _PWM5PHL1               0x02
#define _PWM5PHL2               0x04
#define _PWM5PHL3               0x08
#define _PWM5PHL4               0x10
#define _PWM5PHL5               0x20
#define _PWM5PHL6               0x40
#define _PWM5PHL7               0x80

//==============================================================================


//==============================================================================
//        PWM5PHH Bits

extern __at(0x0D92) __sfr PWM5PHH;

typedef struct
  {
  unsigned PWM5PHH0             : 1;
  unsigned PWM5PHH1             : 1;
  unsigned PWM5PHH2             : 1;
  unsigned PWM5PHH3             : 1;
  unsigned PWM5PHH4             : 1;
  unsigned PWM5PHH5             : 1;
  unsigned PWM5PHH6             : 1;
  unsigned PWM5PHH7             : 1;
  } __PWM5PHHbits_t;

extern __at(0x0D92) volatile __PWM5PHHbits_t PWM5PHHbits;

#define _PWM5PHH0               0x01
#define _PWM5PHH1               0x02
#define _PWM5PHH2               0x04
#define _PWM5PHH3               0x08
#define _PWM5PHH4               0x10
#define _PWM5PHH5               0x20
#define _PWM5PHH6               0x40
#define _PWM5PHH7               0x80

//==============================================================================

extern __at(0x0D93) __sfr PWM5DC;

//==============================================================================
//        PWM5DCL Bits

extern __at(0x0D93) __sfr PWM5DCL;

typedef struct
  {
  unsigned PWM5DCL0             : 1;
  unsigned PWM5DCL1             : 1;
  unsigned PWM5DCL2             : 1;
  unsigned PWM5DCL3             : 1;
  unsigned PWM5DCL4             : 1;
  unsigned PWM5DCL5             : 1;
  unsigned PWM5DCL6             : 1;
  unsigned PWM5DCL7             : 1;
  } __PWM5DCLbits_t;

extern __at(0x0D93) volatile __PWM5DCLbits_t PWM5DCLbits;

#define _PWM5DCL0               0x01
#define _PWM5DCL1               0x02
#define _PWM5DCL2               0x04
#define _PWM5DCL3               0x08
#define _PWM5DCL4               0x10
#define _PWM5DCL5               0x20
#define _PWM5DCL6               0x40
#define _PWM5DCL7               0x80

//==============================================================================


//==============================================================================
//        PWM5DCH Bits

extern __at(0x0D94) __sfr PWM5DCH;

typedef struct
  {
  unsigned PWM5DCH0             : 1;
  unsigned PWM5DCH1             : 1;
  unsigned PWM5DCH2             : 1;
  unsigned PWM5DCH3             : 1;
  unsigned PWM5DCH4             : 1;
  unsigned PWM5DCH5             : 1;
  unsigned PWM5DCH6             : 1;
  unsigned PWM5DCH7             : 1;
  } __PWM5DCHbits_t;

extern __at(0x0D94) volatile __PWM5DCHbits_t PWM5DCHbits;

#define _PWM5DCH0               0x01
#define _PWM5DCH1               0x02
#define _PWM5DCH2               0x04
#define _PWM5DCH3               0x08
#define _PWM5DCH4               0x10
#define _PWM5DCH5               0x20
#define _PWM5DCH6               0x40
#define _PWM5DCH7               0x80

//==============================================================================

extern __at(0x0D95) __sfr PWM5PR;

//==============================================================================
//        PWM5PRL Bits

extern __at(0x0D95) __sfr PWM5PRL;

typedef struct
  {
  unsigned PWM5PRL0             : 1;
  unsigned PWM5PRL1             : 1;
  unsigned PWM5PRL2             : 1;
  unsigned PWM5PRL3             : 1;
  unsigned PWM5PRL4             : 1;
  unsigned PWM5PRL5             : 1;
  unsigned PWM5PRL6             : 1;
  unsigned PWM5PRL7             : 1;
  } __PWM5PRLbits_t;

extern __at(0x0D95) volatile __PWM5PRLbits_t PWM5PRLbits;

#define _PWM5PRL0               0x01
#define _PWM5PRL1               0x02
#define _PWM5PRL2               0x04
#define _PWM5PRL3               0x08
#define _PWM5PRL4               0x10
#define _PWM5PRL5               0x20
#define _PWM5PRL6               0x40
#define _PWM5PRL7               0x80

//==============================================================================


//==============================================================================
//        PWM5PRH Bits

extern __at(0x0D96) __sfr PWM5PRH;

typedef struct
  {
  unsigned PWM5PRH0             : 1;
  unsigned PWM5PRH1             : 1;
  unsigned PWM5PRH2             : 1;
  unsigned PWM5PRH3             : 1;
  unsigned PWM5PRH4             : 1;
  unsigned PWM5PRH5             : 1;
  unsigned PWM5PRH6             : 1;
  unsigned PWM5PRH7             : 1;
  } __PWM5PRHbits_t;

extern __at(0x0D96) volatile __PWM5PRHbits_t PWM5PRHbits;

#define _PWM5PRH0               0x01
#define _PWM5PRH1               0x02
#define _PWM5PRH2               0x04
#define _PWM5PRH3               0x08
#define _PWM5PRH4               0x10
#define _PWM5PRH5               0x20
#define _PWM5PRH6               0x40
#define _PWM5PRH7               0x80

//==============================================================================

extern __at(0x0D97) __sfr PWM5OF;

//==============================================================================
//        PWM5OFL Bits

extern __at(0x0D97) __sfr PWM5OFL;

typedef struct
  {
  unsigned PWM5OFL0             : 1;
  unsigned PWM5OFL1             : 1;
  unsigned PWM5OFL2             : 1;
  unsigned PWM5OFL3             : 1;
  unsigned PWM5OFL4             : 1;
  unsigned PWM5OFL5             : 1;
  unsigned PWM5OFL6             : 1;
  unsigned PWM5OFL7             : 1;
  } __PWM5OFLbits_t;

extern __at(0x0D97) volatile __PWM5OFLbits_t PWM5OFLbits;

#define _PWM5OFL0               0x01
#define _PWM5OFL1               0x02
#define _PWM5OFL2               0x04
#define _PWM5OFL3               0x08
#define _PWM5OFL4               0x10
#define _PWM5OFL5               0x20
#define _PWM5OFL6               0x40
#define _PWM5OFL7               0x80

//==============================================================================


//==============================================================================
//        PWM5OFH Bits

extern __at(0x0D98) __sfr PWM5OFH;

typedef struct
  {
  unsigned PWM5OFH0             : 1;
  unsigned PWM5OFH1             : 1;
  unsigned PWM5OFH2             : 1;
  unsigned PWM5OFH3             : 1;
  unsigned PWM5OFH4             : 1;
  unsigned PWM5OFH5             : 1;
  unsigned PWM5OFH6             : 1;
  unsigned PWM5OFH7             : 1;
  } __PWM5OFHbits_t;

extern __at(0x0D98) volatile __PWM5OFHbits_t PWM5OFHbits;

#define _PWM5OFH0               0x01
#define _PWM5OFH1               0x02
#define _PWM5OFH2               0x04
#define _PWM5OFH3               0x08
#define _PWM5OFH4               0x10
#define _PWM5OFH5               0x20
#define _PWM5OFH6               0x40
#define _PWM5OFH7               0x80

//==============================================================================

extern __at(0x0D99) __sfr PWM5TMR;

//==============================================================================
//        PWM5TMRL Bits

extern __at(0x0D99) __sfr PWM5TMRL;

typedef struct
  {
  unsigned PWM5TMRL0            : 1;
  unsigned PWM5TMRL1            : 1;
  unsigned PWM5TMRL2            : 1;
  unsigned PWM5TMRL3            : 1;
  unsigned PWM5TMRL4            : 1;
  unsigned PWM5TMRL5            : 1;
  unsigned PWM5TMRL6            : 1;
  unsigned PWM5TMRL7            : 1;
  } __PWM5TMRLbits_t;

extern __at(0x0D99) volatile __PWM5TMRLbits_t PWM5TMRLbits;

#define _PWM5TMRL0              0x01
#define _PWM5TMRL1              0x02
#define _PWM5TMRL2              0x04
#define _PWM5TMRL3              0x08
#define _PWM5TMRL4              0x10
#define _PWM5TMRL5              0x20
#define _PWM5TMRL6              0x40
#define _PWM5TMRL7              0x80

//==============================================================================


//==============================================================================
//        PWM5TMRH Bits

extern __at(0x0D9A) __sfr PWM5TMRH;

typedef struct
  {
  unsigned PWM5TMRH0            : 1;
  unsigned PWM5TMRH1            : 1;
  unsigned PWM5TMRH2            : 1;
  unsigned PWM5TMRH3            : 1;
  unsigned PWM5TMRH4            : 1;
  unsigned PWM5TMRH5            : 1;
  unsigned PWM5TMRH6            : 1;
  unsigned PWM5TMRH7            : 1;
  } __PWM5TMRHbits_t;

extern __at(0x0D9A) volatile __PWM5TMRHbits_t PWM5TMRHbits;

#define _PWM5TMRH0              0x01
#define _PWM5TMRH1              0x02
#define _PWM5TMRH2              0x04
#define _PWM5TMRH3              0x08
#define _PWM5TMRH4              0x10
#define _PWM5TMRH5              0x20
#define _PWM5TMRH6              0x40
#define _PWM5TMRH7              0x80

//==============================================================================


//==============================================================================
//        PWM5CON Bits

extern __at(0x0D9B) __sfr PWM5CON;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM5MODE0          : 1;
    unsigned PWM5MODE1          : 1;
    unsigned POL                : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned PWM5POL            : 1;
    unsigned PWM5OUT            : 1;
    unsigned                    : 1;
    unsigned PWM5EN             : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PWM5MODE           : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned MODE               : 2;
    unsigned                    : 4;
    };
  } __PWM5CONbits_t;

extern __at(0x0D9B) volatile __PWM5CONbits_t PWM5CONbits;

#define _PWM5CON_PWM5MODE0      0x04
#define _PWM5CON_MODE0          0x04
#define _PWM5CON_PWM5MODE1      0x08
#define _PWM5CON_MODE1          0x08
#define _PWM5CON_POL            0x10
#define _PWM5CON_PWM5POL        0x10
#define _PWM5CON_OUT            0x20
#define _PWM5CON_PWM5OUT        0x20
#define _PWM5CON_EN             0x80
#define _PWM5CON_PWM5EN         0x80

//==============================================================================


//==============================================================================
//        PWM5INTCON Bits

extern __at(0x0D9C) __sfr PWM5INTCON;

typedef union
  {
  struct
    {
    unsigned PRIE               : 1;
    unsigned DCIE               : 1;
    unsigned PHIE               : 1;
    unsigned OFIE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PWM5PRIE           : 1;
    unsigned PWM5DCIE           : 1;
    unsigned PWM5PHIE           : 1;
    unsigned PWM5OFIE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PWM5INTCONbits_t;

extern __at(0x0D9C) volatile __PWM5INTCONbits_t PWM5INTCONbits;

#define _PRIE                   0x01
#define _PWM5PRIE               0x01
#define _DCIE                   0x02
#define _PWM5DCIE               0x02
#define _PHIE                   0x04
#define _PWM5PHIE               0x04
#define _OFIE                   0x08
#define _PWM5OFIE               0x08

//==============================================================================


//==============================================================================
//        PWM5INTE Bits

extern __at(0x0D9C) __sfr PWM5INTE;

typedef union
  {
  struct
    {
    unsigned PRIE               : 1;
    unsigned DCIE               : 1;
    unsigned PHIE               : 1;
    unsigned OFIE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PWM5PRIE           : 1;
    unsigned PWM5DCIE           : 1;
    unsigned PWM5PHIE           : 1;
    unsigned PWM5OFIE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PWM5INTEbits_t;

extern __at(0x0D9C) volatile __PWM5INTEbits_t PWM5INTEbits;

#define _PWM5INTE_PRIE          0x01
#define _PWM5INTE_PWM5PRIE      0x01
#define _PWM5INTE_DCIE          0x02
#define _PWM5INTE_PWM5DCIE      0x02
#define _PWM5INTE_PHIE          0x04
#define _PWM5INTE_PWM5PHIE      0x04
#define _PWM5INTE_OFIE          0x08
#define _PWM5INTE_PWM5OFIE      0x08

//==============================================================================


//==============================================================================
//        PWM5INTF Bits

extern __at(0x0D9D) __sfr PWM5INTF;

typedef union
  {
  struct
    {
    unsigned PRIF               : 1;
    unsigned DCIF               : 1;
    unsigned PHIF               : 1;
    unsigned OFIF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PWM5PRIF           : 1;
    unsigned PWM5DCIF           : 1;
    unsigned PWM5PHIF           : 1;
    unsigned PWM5OFIF           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PWM5INTFbits_t;

extern __at(0x0D9D) volatile __PWM5INTFbits_t PWM5INTFbits;

#define _PRIF                   0x01
#define _PWM5PRIF               0x01
#define _DCIF                   0x02
#define _PWM5DCIF               0x02
#define _PHIF                   0x04
#define _PWM5PHIF               0x04
#define _OFIF                   0x08
#define _PWM5OFIF               0x08

//==============================================================================


//==============================================================================
//        PWM5INTFLG Bits

extern __at(0x0D9D) __sfr PWM5INTFLG;

typedef union
  {
  struct
    {
    unsigned PRIF               : 1;
    unsigned DCIF               : 1;
    unsigned PHIF               : 1;
    unsigned OFIF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PWM5PRIF           : 1;
    unsigned PWM5DCIF           : 1;
    unsigned PWM5PHIF           : 1;
    unsigned PWM5OFIF           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PWM5INTFLGbits_t;

extern __at(0x0D9D) volatile __PWM5INTFLGbits_t PWM5INTFLGbits;

#define _PWM5INTFLG_PRIF        0x01
#define _PWM5INTFLG_PWM5PRIF    0x01
#define _PWM5INTFLG_DCIF        0x02
#define _PWM5INTFLG_PWM5DCIF    0x02
#define _PWM5INTFLG_PHIF        0x04
#define _PWM5INTFLG_PWM5PHIF    0x04
#define _PWM5INTFLG_OFIF        0x08
#define _PWM5INTFLG_PWM5OFIF    0x08

//==============================================================================


//==============================================================================
//        PWM5CLKCON Bits

extern __at(0x0D9E) __sfr PWM5CLKCON;

typedef union
  {
  struct
    {
    unsigned PWM5CS0            : 1;
    unsigned PWM5CS1            : 1;
    unsigned PWM5CS2            : 1;
    unsigned                    : 1;
    unsigned PWM5PS0            : 1;
    unsigned PWM5PS1            : 1;
    unsigned PWM5PS2            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    unsigned CS2                : 1;
    unsigned                    : 1;
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PS2                : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CS                 : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned PWM5CS             : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 4;
    unsigned PS                 : 3;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned PWM5PS             : 3;
    unsigned                    : 1;
    };
  } __PWM5CLKCONbits_t;

extern __at(0x0D9E) volatile __PWM5CLKCONbits_t PWM5CLKCONbits;

#define _PWM5CLKCON_PWM5CS0     0x01
#define _PWM5CLKCON_CS0         0x01
#define _PWM5CLKCON_PWM5CS1     0x02
#define _PWM5CLKCON_CS1         0x02
#define _PWM5CLKCON_PWM5CS2     0x04
#define _PWM5CLKCON_CS2         0x04
#define _PWM5CLKCON_PWM5PS0     0x10
#define _PWM5CLKCON_PS0         0x10
#define _PWM5CLKCON_PWM5PS1     0x20
#define _PWM5CLKCON_PS1         0x20
#define _PWM5CLKCON_PWM5PS2     0x40
#define _PWM5CLKCON_PS2         0x40

//==============================================================================


//==============================================================================
//        PWM5LDCON Bits

extern __at(0x0D9F) __sfr PWM5LDCON;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LDA                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM5LD             : 1;
    };
  } __PWM5LDCONbits_t;

extern __at(0x0D9F) volatile __PWM5LDCONbits_t PWM5LDCONbits;

#define _LDA                    0x80
#define _PWM5LD                 0x80

//==============================================================================


//==============================================================================
//        PWM5OFCON Bits

extern __at(0x0DA0) __sfr PWM5OFCON;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned OFO                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM5OFMC           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PWM5OFCONbits_t;

extern __at(0x0DA0) volatile __PWM5OFCONbits_t PWM5OFCONbits;

#define _OFO                    0x10
#define _PWM5OFMC               0x10

//==============================================================================


//==============================================================================
//        PPSLOCK Bits

extern __at(0x0E0F) __sfr PPSLOCK;

typedef struct
  {
  unsigned PPSLOCKED            : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PPSLOCKbits_t;

extern __at(0x0E0F) volatile __PPSLOCKbits_t PPSLOCKbits;

#define _PPSLOCKED              0x01

//==============================================================================

extern __at(0x0E10) __sfr INTPPS;
extern __at(0x0E11) __sfr T0CKIPPS;
extern __at(0x0E12) __sfr T1CKIPPS;
extern __at(0x0E13) __sfr T1GPPS;
extern __at(0x0E14) __sfr CCP1PPS;
extern __at(0x0E16) __sfr COG1INPPS;
extern __at(0x0E19) __sfr T2CKIPPS;
extern __at(0x0E1A) __sfr T3CKIPPS;
extern __at(0x0E1B) __sfr T3GPPS;
extern __at(0x0E1C) __sfr T4CKIPPS;
extern __at(0x0E1D) __sfr T5CKIPPS;
extern __at(0x0E1E) __sfr T5GPPS;
extern __at(0x0E1F) __sfr T6CKIPPS;
extern __at(0x0E20) __sfr SSPCLKPPS;
extern __at(0x0E21) __sfr SSPDATPPS;
extern __at(0x0E22) __sfr SSPSSPPS;
extern __at(0x0E24) __sfr RXPPS;
extern __at(0x0E25) __sfr CKPPS;
extern __at(0x0E28) __sfr CLCIN0PPS;
extern __at(0x0E29) __sfr CLCIN1PPS;
extern __at(0x0E2A) __sfr CLCIN2PPS;
extern __at(0x0E2B) __sfr CLCIN3PPS;
extern __at(0x0E2C) __sfr PRG1RPPS;
extern __at(0x0E2D) __sfr PRG1FPPS;
extern __at(0x0E30) __sfr MD1CHPPS;
extern __at(0x0E31) __sfr MD1CLPPS;
extern __at(0x0E32) __sfr MD1MODPPS;
extern __at(0x0E90) __sfr RA0PPS;
extern __at(0x0E91) __sfr RA1PPS;
extern __at(0x0E92) __sfr RA2PPS;
extern __at(0x0E94) __sfr RA4PPS;
extern __at(0x0E95) __sfr RA5PPS;
extern __at(0x0EA0) __sfr RC0PPS;
extern __at(0x0EA1) __sfr RC1PPS;
extern __at(0x0EA2) __sfr RC2PPS;
extern __at(0x0EA3) __sfr RC3PPS;
extern __at(0x0EA4) __sfr RC4PPS;
extern __at(0x0EA5) __sfr RC5PPS;

//==============================================================================
//        CLCDATA Bits

extern __at(0x0F0F) __sfr CLCDATA;

typedef struct
  {
  unsigned MCLC1OUT             : 1;
  unsigned MCLC2OUT             : 1;
  unsigned MCLC3OUT             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __CLCDATAbits_t;

extern __at(0x0F0F) volatile __CLCDATAbits_t CLCDATAbits;

#define _MCLC1OUT               0x01
#define _MCLC2OUT               0x02
#define _MCLC3OUT               0x04

//==============================================================================


//==============================================================================
//        CLC1CON Bits

extern __at(0x0F10) __sfr CLC1CON;

typedef union
  {
  struct
    {
    unsigned LC1MODE0           : 1;
    unsigned LC1MODE1           : 1;
    unsigned LC1MODE2           : 1;
    unsigned LC1INTN            : 1;
    unsigned LC1INTP            : 1;
    unsigned LC1OUT             : 1;
    unsigned                    : 1;
    unsigned LC1EN              : 1;
    };

  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned LC1MODE            : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned MODE               : 3;
    unsigned                    : 5;
    };
  } __CLC1CONbits_t;

extern __at(0x0F10) volatile __CLC1CONbits_t CLC1CONbits;

#define _CLC1CON_LC1MODE0       0x01
#define _CLC1CON_MODE0          0x01
#define _CLC1CON_LC1MODE1       0x02
#define _CLC1CON_MODE1          0x02
#define _CLC1CON_LC1MODE2       0x04
#define _CLC1CON_MODE2          0x04
#define _CLC1CON_LC1INTN        0x08
#define _CLC1CON_INTN           0x08
#define _CLC1CON_LC1INTP        0x10
#define _CLC1CON_INTP           0x10
#define _CLC1CON_LC1OUT         0x20
#define _CLC1CON_OUT            0x20
#define _CLC1CON_LC1EN          0x80
#define _CLC1CON_EN             0x80

//==============================================================================


//==============================================================================
//        CLC1POL Bits

extern __at(0x0F11) __sfr CLC1POL;

typedef union
  {
  struct
    {
    unsigned LC1G1POL           : 1;
    unsigned LC1G2POL           : 1;
    unsigned LC1G3POL           : 1;
    unsigned LC1G4POL           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LC1POL             : 1;
    };

  struct
    {
    unsigned G1POL              : 1;
    unsigned G2POL              : 1;
    unsigned G3POL              : 1;
    unsigned G4POL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    };
  } __CLC1POLbits_t;

extern __at(0x0F11) volatile __CLC1POLbits_t CLC1POLbits;

#define _LC1G1POL               0x01
#define _G1POL                  0x01
#define _LC1G2POL               0x02
#define _G2POL                  0x02
#define _LC1G3POL               0x04
#define _G3POL                  0x04
#define _LC1G4POL               0x08
#define _G4POL                  0x08
#define _LC1POL                 0x80
#define _POL                    0x80

//==============================================================================


//==============================================================================
//        CLC1SEL0 Bits

extern __at(0x0F12) __sfr CLC1SEL0;

typedef union
  {
  struct
    {
    unsigned LC1D1S0            : 1;
    unsigned LC1D1S1            : 1;
    unsigned LC1D1S2            : 1;
    unsigned LC1D1S3            : 1;
    unsigned LC1D1S4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D1S0               : 1;
    unsigned D1S1               : 1;
    unsigned D1S2               : 1;
    unsigned D1S3               : 1;
    unsigned D1S4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D1S                : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned LC1D1S             : 5;
    unsigned                    : 3;
    };
  } __CLC1SEL0bits_t;

extern __at(0x0F12) volatile __CLC1SEL0bits_t CLC1SEL0bits;

#define _LC1D1S0                0x01
#define _D1S0                   0x01
#define _LC1D1S1                0x02
#define _D1S1                   0x02
#define _LC1D1S2                0x04
#define _D1S2                   0x04
#define _LC1D1S3                0x08
#define _D1S3                   0x08
#define _LC1D1S4                0x10
#define _D1S4                   0x10

//==============================================================================


//==============================================================================
//        CLC1SEL1 Bits

extern __at(0x0F13) __sfr CLC1SEL1;

typedef union
  {
  struct
    {
    unsigned LC1D2S0            : 1;
    unsigned LC1D2S1            : 1;
    unsigned LC1D2S2            : 1;
    unsigned LC1D2S3            : 1;
    unsigned LC1D2S4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D2S0               : 1;
    unsigned D2S1               : 1;
    unsigned D2S2               : 1;
    unsigned D2S3               : 1;
    unsigned D2S4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC1D2S             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned D2S                : 5;
    unsigned                    : 3;
    };
  } __CLC1SEL1bits_t;

extern __at(0x0F13) volatile __CLC1SEL1bits_t CLC1SEL1bits;

#define _LC1D2S0                0x01
#define _D2S0                   0x01
#define _LC1D2S1                0x02
#define _D2S1                   0x02
#define _LC1D2S2                0x04
#define _D2S2                   0x04
#define _LC1D2S3                0x08
#define _D2S3                   0x08
#define _LC1D2S4                0x10
#define _D2S4                   0x10

//==============================================================================


//==============================================================================
//        CLC1SEL2 Bits

extern __at(0x0F14) __sfr CLC1SEL2;

typedef union
  {
  struct
    {
    unsigned LC1D3S0            : 1;
    unsigned LC1D3S1            : 1;
    unsigned LC1D3S2            : 1;
    unsigned LC1D3S3            : 1;
    unsigned LC1D3S4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D3S0               : 1;
    unsigned D3S1               : 1;
    unsigned D3S2               : 1;
    unsigned D3S3               : 1;
    unsigned D3S4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC1D3S             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned D3S                : 5;
    unsigned                    : 3;
    };
  } __CLC1SEL2bits_t;

extern __at(0x0F14) volatile __CLC1SEL2bits_t CLC1SEL2bits;

#define _LC1D3S0                0x01
#define _D3S0                   0x01
#define _LC1D3S1                0x02
#define _D3S1                   0x02
#define _LC1D3S2                0x04
#define _D3S2                   0x04
#define _LC1D3S3                0x08
#define _D3S3                   0x08
#define _LC1D3S4                0x10
#define _D3S4                   0x10

//==============================================================================


//==============================================================================
//        CLC1SEL3 Bits

extern __at(0x0F15) __sfr CLC1SEL3;

typedef union
  {
  struct
    {
    unsigned LC1D4S0            : 1;
    unsigned LC1D4S1            : 1;
    unsigned LC1D4S2            : 1;
    unsigned LC1D4S3            : 1;
    unsigned LC1D4S4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D4S0               : 1;
    unsigned D4S1               : 1;
    unsigned D4S2               : 1;
    unsigned D4S3               : 1;
    unsigned D4S4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC1D4S             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned D4S                : 5;
    unsigned                    : 3;
    };
  } __CLC1SEL3bits_t;

extern __at(0x0F15) volatile __CLC1SEL3bits_t CLC1SEL3bits;

#define _LC1D4S0                0x01
#define _D4S0                   0x01
#define _LC1D4S1                0x02
#define _D4S1                   0x02
#define _LC1D4S2                0x04
#define _D4S2                   0x04
#define _LC1D4S3                0x08
#define _D4S3                   0x08
#define _LC1D4S4                0x10
#define _D4S4                   0x10

//==============================================================================


//==============================================================================
//        CLC1GLS0 Bits

extern __at(0x0F16) __sfr CLC1GLS0;

typedef union
  {
  struct
    {
    unsigned LC1G1D1N           : 1;
    unsigned LC1G1D1T           : 1;
    unsigned LC1G1D2N           : 1;
    unsigned LC1G1D2T           : 1;
    unsigned LC1G1D3N           : 1;
    unsigned LC1G1D3T           : 1;
    unsigned LC1G1D4N           : 1;
    unsigned LC1G1D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC1GLS0bits_t;

extern __at(0x0F16) volatile __CLC1GLS0bits_t CLC1GLS0bits;

#define _LC1G1D1N               0x01
#define _D1N                    0x01
#define _LC1G1D1T               0x02
#define _D1T                    0x02
#define _LC1G1D2N               0x04
#define _D2N                    0x04
#define _LC1G1D2T               0x08
#define _D2T                    0x08
#define _LC1G1D3N               0x10
#define _D3N                    0x10
#define _LC1G1D3T               0x20
#define _D3T                    0x20
#define _LC1G1D4N               0x40
#define _D4N                    0x40
#define _LC1G1D4T               0x80
#define _D4T                    0x80

//==============================================================================


//==============================================================================
//        CLC1GLS1 Bits

extern __at(0x0F17) __sfr CLC1GLS1;

typedef union
  {
  struct
    {
    unsigned LC1G2D1N           : 1;
    unsigned LC1G2D1T           : 1;
    unsigned LC1G2D2N           : 1;
    unsigned LC1G2D2T           : 1;
    unsigned LC1G2D3N           : 1;
    unsigned LC1G2D3T           : 1;
    unsigned LC1G2D4N           : 1;
    unsigned LC1G2D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC1GLS1bits_t;

extern __at(0x0F17) volatile __CLC1GLS1bits_t CLC1GLS1bits;

#define _CLC1GLS1_LC1G2D1N      0x01
#define _CLC1GLS1_D1N           0x01
#define _CLC1GLS1_LC1G2D1T      0x02
#define _CLC1GLS1_D1T           0x02
#define _CLC1GLS1_LC1G2D2N      0x04
#define _CLC1GLS1_D2N           0x04
#define _CLC1GLS1_LC1G2D2T      0x08
#define _CLC1GLS1_D2T           0x08
#define _CLC1GLS1_LC1G2D3N      0x10
#define _CLC1GLS1_D3N           0x10
#define _CLC1GLS1_LC1G2D3T      0x20
#define _CLC1GLS1_D3T           0x20
#define _CLC1GLS1_LC1G2D4N      0x40
#define _CLC1GLS1_D4N           0x40
#define _CLC1GLS1_LC1G2D4T      0x80
#define _CLC1GLS1_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC1GLS2 Bits

extern __at(0x0F18) __sfr CLC1GLS2;

typedef union
  {
  struct
    {
    unsigned LC1G3D1N           : 1;
    unsigned LC1G3D1T           : 1;
    unsigned LC1G3D2N           : 1;
    unsigned LC1G3D2T           : 1;
    unsigned LC1G3D3N           : 1;
    unsigned LC1G3D3T           : 1;
    unsigned LC1G3D4N           : 1;
    unsigned LC1G3D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC1GLS2bits_t;

extern __at(0x0F18) volatile __CLC1GLS2bits_t CLC1GLS2bits;

#define _CLC1GLS2_LC1G3D1N      0x01
#define _CLC1GLS2_D1N           0x01
#define _CLC1GLS2_LC1G3D1T      0x02
#define _CLC1GLS2_D1T           0x02
#define _CLC1GLS2_LC1G3D2N      0x04
#define _CLC1GLS2_D2N           0x04
#define _CLC1GLS2_LC1G3D2T      0x08
#define _CLC1GLS2_D2T           0x08
#define _CLC1GLS2_LC1G3D3N      0x10
#define _CLC1GLS2_D3N           0x10
#define _CLC1GLS2_LC1G3D3T      0x20
#define _CLC1GLS2_D3T           0x20
#define _CLC1GLS2_LC1G3D4N      0x40
#define _CLC1GLS2_D4N           0x40
#define _CLC1GLS2_LC1G3D4T      0x80
#define _CLC1GLS2_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC1GLS3 Bits

extern __at(0x0F19) __sfr CLC1GLS3;

typedef union
  {
  struct
    {
    unsigned LC1G4D1N           : 1;
    unsigned LC1G4D1T           : 1;
    unsigned LC1G4D2N           : 1;
    unsigned LC1G4D2T           : 1;
    unsigned LC1G4D3N           : 1;
    unsigned LC1G4D3T           : 1;
    unsigned LC1G4D4N           : 1;
    unsigned LC1G4D4T           : 1;
    };

  struct
    {
    unsigned G4D1N              : 1;
    unsigned G4D1T              : 1;
    unsigned G4D2N              : 1;
    unsigned G4D2T              : 1;
    unsigned G4D3N              : 1;
    unsigned G4D3T              : 1;
    unsigned G4D4N              : 1;
    unsigned G4D4T              : 1;
    };
  } __CLC1GLS3bits_t;

extern __at(0x0F19) volatile __CLC1GLS3bits_t CLC1GLS3bits;

#define _LC1G4D1N               0x01
#define _G4D1N                  0x01
#define _LC1G4D1T               0x02
#define _G4D1T                  0x02
#define _LC1G4D2N               0x04
#define _G4D2N                  0x04
#define _LC1G4D2T               0x08
#define _G4D2T                  0x08
#define _LC1G4D3N               0x10
#define _G4D3N                  0x10
#define _LC1G4D3T               0x20
#define _G4D3T                  0x20
#define _LC1G4D4N               0x40
#define _G4D4N                  0x40
#define _LC1G4D4T               0x80
#define _G4D4T                  0x80

//==============================================================================


//==============================================================================
//        CLC2CON Bits

extern __at(0x0F1A) __sfr CLC2CON;

typedef union
  {
  struct
    {
    unsigned LC2MODE0           : 1;
    unsigned LC2MODE1           : 1;
    unsigned LC2MODE2           : 1;
    unsigned LC2INTN            : 1;
    unsigned LC2INTP            : 1;
    unsigned LC2OUT             : 1;
    unsigned                    : 1;
    unsigned LC2EN              : 1;
    };

  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned MODE               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned LC2MODE            : 3;
    unsigned                    : 5;
    };
  } __CLC2CONbits_t;

extern __at(0x0F1A) volatile __CLC2CONbits_t CLC2CONbits;

#define _CLC2CON_LC2MODE0       0x01
#define _CLC2CON_MODE0          0x01
#define _CLC2CON_LC2MODE1       0x02
#define _CLC2CON_MODE1          0x02
#define _CLC2CON_LC2MODE2       0x04
#define _CLC2CON_MODE2          0x04
#define _CLC2CON_LC2INTN        0x08
#define _CLC2CON_INTN           0x08
#define _CLC2CON_LC2INTP        0x10
#define _CLC2CON_INTP           0x10
#define _CLC2CON_LC2OUT         0x20
#define _CLC2CON_OUT            0x20
#define _CLC2CON_LC2EN          0x80
#define _CLC2CON_EN             0x80

//==============================================================================


//==============================================================================
//        CLC2POL Bits

extern __at(0x0F1B) __sfr CLC2POL;

typedef union
  {
  struct
    {
    unsigned LC2G1POL           : 1;
    unsigned LC2G2POL           : 1;
    unsigned LC2G3POL           : 1;
    unsigned LC2G4POL           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LC2POL             : 1;
    };

  struct
    {
    unsigned G1POL              : 1;
    unsigned G2POL              : 1;
    unsigned G3POL              : 1;
    unsigned G4POL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    };
  } __CLC2POLbits_t;

extern __at(0x0F1B) volatile __CLC2POLbits_t CLC2POLbits;

#define _CLC2POL_LC2G1POL       0x01
#define _CLC2POL_G1POL          0x01
#define _CLC2POL_LC2G2POL       0x02
#define _CLC2POL_G2POL          0x02
#define _CLC2POL_LC2G3POL       0x04
#define _CLC2POL_G3POL          0x04
#define _CLC2POL_LC2G4POL       0x08
#define _CLC2POL_G4POL          0x08
#define _CLC2POL_LC2POL         0x80
#define _CLC2POL_POL            0x80

//==============================================================================


//==============================================================================
//        CLC2SEL0 Bits

extern __at(0x0F1C) __sfr CLC2SEL0;

typedef union
  {
  struct
    {
    unsigned LC2D1S0            : 1;
    unsigned LC2D1S1            : 1;
    unsigned LC2D1S2            : 1;
    unsigned LC2D1S3            : 1;
    unsigned LC2D1S4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D1S0               : 1;
    unsigned D1S1               : 1;
    unsigned D1S2               : 1;
    unsigned D1S3               : 1;
    unsigned D1S4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC2D1S             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned D1S                : 5;
    unsigned                    : 3;
    };
  } __CLC2SEL0bits_t;

extern __at(0x0F1C) volatile __CLC2SEL0bits_t CLC2SEL0bits;

#define _CLC2SEL0_LC2D1S0       0x01
#define _CLC2SEL0_D1S0          0x01
#define _CLC2SEL0_LC2D1S1       0x02
#define _CLC2SEL0_D1S1          0x02
#define _CLC2SEL0_LC2D1S2       0x04
#define _CLC2SEL0_D1S2          0x04
#define _CLC2SEL0_LC2D1S3       0x08
#define _CLC2SEL0_D1S3          0x08
#define _CLC2SEL0_LC2D1S4       0x10
#define _CLC2SEL0_D1S4          0x10

//==============================================================================


//==============================================================================
//        CLC2SEL1 Bits

extern __at(0x0F1D) __sfr CLC2SEL1;

typedef union
  {
  struct
    {
    unsigned LC2D2S0            : 1;
    unsigned LC2D2S1            : 1;
    unsigned LC2D2S2            : 1;
    unsigned LC2D2S3            : 1;
    unsigned LC2D2S4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D2S0               : 1;
    unsigned D2S1               : 1;
    unsigned D2S2               : 1;
    unsigned D2S3               : 1;
    unsigned D2S4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D2S                : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned LC2D2S             : 5;
    unsigned                    : 3;
    };
  } __CLC2SEL1bits_t;

extern __at(0x0F1D) volatile __CLC2SEL1bits_t CLC2SEL1bits;

#define _CLC2SEL1_LC2D2S0       0x01
#define _CLC2SEL1_D2S0          0x01
#define _CLC2SEL1_LC2D2S1       0x02
#define _CLC2SEL1_D2S1          0x02
#define _CLC2SEL1_LC2D2S2       0x04
#define _CLC2SEL1_D2S2          0x04
#define _CLC2SEL1_LC2D2S3       0x08
#define _CLC2SEL1_D2S3          0x08
#define _CLC2SEL1_LC2D2S4       0x10
#define _CLC2SEL1_D2S4          0x10

//==============================================================================


//==============================================================================
//        CLC2SEL2 Bits

extern __at(0x0F1E) __sfr CLC2SEL2;

typedef union
  {
  struct
    {
    unsigned LC2D3S0            : 1;
    unsigned LC2D3S1            : 1;
    unsigned LC2D3S2            : 1;
    unsigned LC2D3S3            : 1;
    unsigned LC2D3S4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D3S0               : 1;
    unsigned D3S1               : 1;
    unsigned D3S2               : 1;
    unsigned D3S3               : 1;
    unsigned D3S4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC2D3S             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned D3S                : 5;
    unsigned                    : 3;
    };
  } __CLC2SEL2bits_t;

extern __at(0x0F1E) volatile __CLC2SEL2bits_t CLC2SEL2bits;

#define _CLC2SEL2_LC2D3S0       0x01
#define _CLC2SEL2_D3S0          0x01
#define _CLC2SEL2_LC2D3S1       0x02
#define _CLC2SEL2_D3S1          0x02
#define _CLC2SEL2_LC2D3S2       0x04
#define _CLC2SEL2_D3S2          0x04
#define _CLC2SEL2_LC2D3S3       0x08
#define _CLC2SEL2_D3S3          0x08
#define _CLC2SEL2_LC2D3S4       0x10
#define _CLC2SEL2_D3S4          0x10

//==============================================================================


//==============================================================================
//        CLC2SEL3 Bits

extern __at(0x0F1F) __sfr CLC2SEL3;

typedef union
  {
  struct
    {
    unsigned LC2D4S0            : 1;
    unsigned LC2D4S1            : 1;
    unsigned LC2D4S2            : 1;
    unsigned LC2D4S3            : 1;
    unsigned LC2D4S4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D4S0               : 1;
    unsigned D4S1               : 1;
    unsigned D4S2               : 1;
    unsigned D4S3               : 1;
    unsigned D4S4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC2D4S             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned D4S                : 5;
    unsigned                    : 3;
    };
  } __CLC2SEL3bits_t;

extern __at(0x0F1F) volatile __CLC2SEL3bits_t CLC2SEL3bits;

#define _CLC2SEL3_LC2D4S0       0x01
#define _CLC2SEL3_D4S0          0x01
#define _CLC2SEL3_LC2D4S1       0x02
#define _CLC2SEL3_D4S1          0x02
#define _CLC2SEL3_LC2D4S2       0x04
#define _CLC2SEL3_D4S2          0x04
#define _CLC2SEL3_LC2D4S3       0x08
#define _CLC2SEL3_D4S3          0x08
#define _CLC2SEL3_LC2D4S4       0x10
#define _CLC2SEL3_D4S4          0x10

//==============================================================================


//==============================================================================
//        CLC2GLS0 Bits

extern __at(0x0F20) __sfr CLC2GLS0;

typedef union
  {
  struct
    {
    unsigned LC2G1D1N           : 1;
    unsigned LC2G1D1T           : 1;
    unsigned LC2G1D2N           : 1;
    unsigned LC2G1D2T           : 1;
    unsigned LC2G1D3N           : 1;
    unsigned LC2G1D3T           : 1;
    unsigned LC2G1D4N           : 1;
    unsigned LC2G1D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC2GLS0bits_t;

extern __at(0x0F20) volatile __CLC2GLS0bits_t CLC2GLS0bits;

#define _CLC2GLS0_LC2G1D1N      0x01
#define _CLC2GLS0_D1N           0x01
#define _CLC2GLS0_LC2G1D1T      0x02
#define _CLC2GLS0_D1T           0x02
#define _CLC2GLS0_LC2G1D2N      0x04
#define _CLC2GLS0_D2N           0x04
#define _CLC2GLS0_LC2G1D2T      0x08
#define _CLC2GLS0_D2T           0x08
#define _CLC2GLS0_LC2G1D3N      0x10
#define _CLC2GLS0_D3N           0x10
#define _CLC2GLS0_LC2G1D3T      0x20
#define _CLC2GLS0_D3T           0x20
#define _CLC2GLS0_LC2G1D4N      0x40
#define _CLC2GLS0_D4N           0x40
#define _CLC2GLS0_LC2G1D4T      0x80
#define _CLC2GLS0_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC2GLS1 Bits

extern __at(0x0F21) __sfr CLC2GLS1;

typedef union
  {
  struct
    {
    unsigned LC2G2D1N           : 1;
    unsigned LC2G2D1T           : 1;
    unsigned LC2G2D2N           : 1;
    unsigned LC2G2D2T           : 1;
    unsigned LC2G2D3N           : 1;
    unsigned LC2G2D3T           : 1;
    unsigned LC2G2D4N           : 1;
    unsigned LC2G2D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC2GLS1bits_t;

extern __at(0x0F21) volatile __CLC2GLS1bits_t CLC2GLS1bits;

#define _CLC2GLS1_LC2G2D1N      0x01
#define _CLC2GLS1_D1N           0x01
#define _CLC2GLS1_LC2G2D1T      0x02
#define _CLC2GLS1_D1T           0x02
#define _CLC2GLS1_LC2G2D2N      0x04
#define _CLC2GLS1_D2N           0x04
#define _CLC2GLS1_LC2G2D2T      0x08
#define _CLC2GLS1_D2T           0x08
#define _CLC2GLS1_LC2G2D3N      0x10
#define _CLC2GLS1_D3N           0x10
#define _CLC2GLS1_LC2G2D3T      0x20
#define _CLC2GLS1_D3T           0x20
#define _CLC2GLS1_LC2G2D4N      0x40
#define _CLC2GLS1_D4N           0x40
#define _CLC2GLS1_LC2G2D4T      0x80
#define _CLC2GLS1_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC2GLS2 Bits

extern __at(0x0F22) __sfr CLC2GLS2;

typedef union
  {
  struct
    {
    unsigned LC2G3D1N           : 1;
    unsigned LC2G3D1T           : 1;
    unsigned LC2G3D2N           : 1;
    unsigned LC2G3D2T           : 1;
    unsigned LC2G3D3N           : 1;
    unsigned LC2G3D3T           : 1;
    unsigned LC2G3D4N           : 1;
    unsigned LC2G3D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC2GLS2bits_t;

extern __at(0x0F22) volatile __CLC2GLS2bits_t CLC2GLS2bits;

#define _CLC2GLS2_LC2G3D1N      0x01
#define _CLC2GLS2_D1N           0x01
#define _CLC2GLS2_LC2G3D1T      0x02
#define _CLC2GLS2_D1T           0x02
#define _CLC2GLS2_LC2G3D2N      0x04
#define _CLC2GLS2_D2N           0x04
#define _CLC2GLS2_LC2G3D2T      0x08
#define _CLC2GLS2_D2T           0x08
#define _CLC2GLS2_LC2G3D3N      0x10
#define _CLC2GLS2_D3N           0x10
#define _CLC2GLS2_LC2G3D3T      0x20
#define _CLC2GLS2_D3T           0x20
#define _CLC2GLS2_LC2G3D4N      0x40
#define _CLC2GLS2_D4N           0x40
#define _CLC2GLS2_LC2G3D4T      0x80
#define _CLC2GLS2_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC2GLS3 Bits

extern __at(0x0F23) __sfr CLC2GLS3;

typedef union
  {
  struct
    {
    unsigned LC2G4D1N           : 1;
    unsigned LC2G4D1T           : 1;
    unsigned LC2G4D2N           : 1;
    unsigned LC2G4D2T           : 1;
    unsigned LC2G4D3N           : 1;
    unsigned LC2G4D3T           : 1;
    unsigned LC2G4D4N           : 1;
    unsigned LC2G4D4T           : 1;
    };

  struct
    {
    unsigned G4D1N              : 1;
    unsigned G4D1T              : 1;
    unsigned G4D2N              : 1;
    unsigned G4D2T              : 1;
    unsigned G4D3N              : 1;
    unsigned G4D3T              : 1;
    unsigned G4D4N              : 1;
    unsigned G4D4T              : 1;
    };
  } __CLC2GLS3bits_t;

extern __at(0x0F23) volatile __CLC2GLS3bits_t CLC2GLS3bits;

#define _CLC2GLS3_LC2G4D1N      0x01
#define _CLC2GLS3_G4D1N         0x01
#define _CLC2GLS3_LC2G4D1T      0x02
#define _CLC2GLS3_G4D1T         0x02
#define _CLC2GLS3_LC2G4D2N      0x04
#define _CLC2GLS3_G4D2N         0x04
#define _CLC2GLS3_LC2G4D2T      0x08
#define _CLC2GLS3_G4D2T         0x08
#define _CLC2GLS3_LC2G4D3N      0x10
#define _CLC2GLS3_G4D3N         0x10
#define _CLC2GLS3_LC2G4D3T      0x20
#define _CLC2GLS3_G4D3T         0x20
#define _CLC2GLS3_LC2G4D4N      0x40
#define _CLC2GLS3_G4D4N         0x40
#define _CLC2GLS3_LC2G4D4T      0x80
#define _CLC2GLS3_G4D4T         0x80

//==============================================================================


//==============================================================================
//        CLC3CON Bits

extern __at(0x0F24) __sfr CLC3CON;

typedef union
  {
  struct
    {
    unsigned LC3MODE0           : 1;
    unsigned LC3MODE1           : 1;
    unsigned LC3MODE2           : 1;
    unsigned LC3INTN            : 1;
    unsigned LC3INTP            : 1;
    unsigned LC3OUT             : 1;
    unsigned                    : 1;
    unsigned LC3EN              : 1;
    };

  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned MODE               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned LC3MODE            : 3;
    unsigned                    : 5;
    };
  } __CLC3CONbits_t;

extern __at(0x0F24) volatile __CLC3CONbits_t CLC3CONbits;

#define _CLC3CON_LC3MODE0       0x01
#define _CLC3CON_MODE0          0x01
#define _CLC3CON_LC3MODE1       0x02
#define _CLC3CON_MODE1          0x02
#define _CLC3CON_LC3MODE2       0x04
#define _CLC3CON_MODE2          0x04
#define _CLC3CON_LC3INTN        0x08
#define _CLC3CON_INTN           0x08
#define _CLC3CON_LC3INTP        0x10
#define _CLC3CON_INTP           0x10
#define _CLC3CON_LC3OUT         0x20
#define _CLC3CON_OUT            0x20
#define _CLC3CON_LC3EN          0x80
#define _CLC3CON_EN             0x80

//==============================================================================


//==============================================================================
//        CLC3POL Bits

extern __at(0x0F25) __sfr CLC3POL;

typedef union
  {
  struct
    {
    unsigned LC3G1POL           : 1;
    unsigned LC3G2POL           : 1;
    unsigned LC3G3POL           : 1;
    unsigned LC3G4POL           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LC3POL             : 1;
    };

  struct
    {
    unsigned G1POL              : 1;
    unsigned G2POL              : 1;
    unsigned G3POL              : 1;
    unsigned G4POL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    };
  } __CLC3POLbits_t;

extern __at(0x0F25) volatile __CLC3POLbits_t CLC3POLbits;

#define _CLC3POL_LC3G1POL       0x01
#define _CLC3POL_G1POL          0x01
#define _CLC3POL_LC3G2POL       0x02
#define _CLC3POL_G2POL          0x02
#define _CLC3POL_LC3G3POL       0x04
#define _CLC3POL_G3POL          0x04
#define _CLC3POL_LC3G4POL       0x08
#define _CLC3POL_G4POL          0x08
#define _CLC3POL_LC3POL         0x80
#define _CLC3POL_POL            0x80

//==============================================================================


//==============================================================================
//        CLC3SEL0 Bits

extern __at(0x0F26) __sfr CLC3SEL0;

typedef union
  {
  struct
    {
    unsigned LC3D1S0            : 1;
    unsigned LC3D1S1            : 1;
    unsigned LC3D1S2            : 1;
    unsigned LC3D1S3            : 1;
    unsigned LC3D1S4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D1S0               : 1;
    unsigned D1S1               : 1;
    unsigned D1S2               : 1;
    unsigned D1S3               : 1;
    unsigned D1S4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D1S                : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned LC3D1S             : 5;
    unsigned                    : 3;
    };
  } __CLC3SEL0bits_t;

extern __at(0x0F26) volatile __CLC3SEL0bits_t CLC3SEL0bits;

#define _CLC3SEL0_LC3D1S0       0x01
#define _CLC3SEL0_D1S0          0x01
#define _CLC3SEL0_LC3D1S1       0x02
#define _CLC3SEL0_D1S1          0x02
#define _CLC3SEL0_LC3D1S2       0x04
#define _CLC3SEL0_D1S2          0x04
#define _CLC3SEL0_LC3D1S3       0x08
#define _CLC3SEL0_D1S3          0x08
#define _CLC3SEL0_LC3D1S4       0x10
#define _CLC3SEL0_D1S4          0x10

//==============================================================================


//==============================================================================
//        CLC3SEL1 Bits

extern __at(0x0F27) __sfr CLC3SEL1;

typedef union
  {
  struct
    {
    unsigned LC3D2S0            : 1;
    unsigned LC3D2S1            : 1;
    unsigned LC3D2S2            : 1;
    unsigned LC3D2S3            : 1;
    unsigned LC3D2S4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D2S0               : 1;
    unsigned D2S1               : 1;
    unsigned D2S2               : 1;
    unsigned D2S3               : 1;
    unsigned D2S4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D2S                : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned LC3D2S             : 5;
    unsigned                    : 3;
    };
  } __CLC3SEL1bits_t;

extern __at(0x0F27) volatile __CLC3SEL1bits_t CLC3SEL1bits;

#define _CLC3SEL1_LC3D2S0       0x01
#define _CLC3SEL1_D2S0          0x01
#define _CLC3SEL1_LC3D2S1       0x02
#define _CLC3SEL1_D2S1          0x02
#define _CLC3SEL1_LC3D2S2       0x04
#define _CLC3SEL1_D2S2          0x04
#define _CLC3SEL1_LC3D2S3       0x08
#define _CLC3SEL1_D2S3          0x08
#define _CLC3SEL1_LC3D2S4       0x10
#define _CLC3SEL1_D2S4          0x10

//==============================================================================


//==============================================================================
//        CLC3SEL2 Bits

extern __at(0x0F28) __sfr CLC3SEL2;

typedef union
  {
  struct
    {
    unsigned LC3D3S0            : 1;
    unsigned LC3D3S1            : 1;
    unsigned LC3D3S2            : 1;
    unsigned LC3D3S3            : 1;
    unsigned LC3D3S4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D3S0               : 1;
    unsigned D3S1               : 1;
    unsigned D3S2               : 1;
    unsigned D3S3               : 1;
    unsigned D3S4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC3D3S             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned D3S                : 5;
    unsigned                    : 3;
    };
  } __CLC3SEL2bits_t;

extern __at(0x0F28) volatile __CLC3SEL2bits_t CLC3SEL2bits;

#define _CLC3SEL2_LC3D3S0       0x01
#define _CLC3SEL2_D3S0          0x01
#define _CLC3SEL2_LC3D3S1       0x02
#define _CLC3SEL2_D3S1          0x02
#define _CLC3SEL2_LC3D3S2       0x04
#define _CLC3SEL2_D3S2          0x04
#define _CLC3SEL2_LC3D3S3       0x08
#define _CLC3SEL2_D3S3          0x08
#define _CLC3SEL2_LC3D3S4       0x10
#define _CLC3SEL2_D3S4          0x10

//==============================================================================


//==============================================================================
//        CLC3SEL3 Bits

extern __at(0x0F29) __sfr CLC3SEL3;

typedef union
  {
  struct
    {
    unsigned LC3D4S0            : 1;
    unsigned LC3D4S1            : 1;
    unsigned LC3D4S2            : 1;
    unsigned LC3D4S3            : 1;
    unsigned LC3D4S4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D4S0               : 1;
    unsigned D4S1               : 1;
    unsigned D4S2               : 1;
    unsigned D4S3               : 1;
    unsigned D4S4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D4S                : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned LC3D4S             : 5;
    unsigned                    : 3;
    };
  } __CLC3SEL3bits_t;

extern __at(0x0F29) volatile __CLC3SEL3bits_t CLC3SEL3bits;

#define _CLC3SEL3_LC3D4S0       0x01
#define _CLC3SEL3_D4S0          0x01
#define _CLC3SEL3_LC3D4S1       0x02
#define _CLC3SEL3_D4S1          0x02
#define _CLC3SEL3_LC3D4S2       0x04
#define _CLC3SEL3_D4S2          0x04
#define _CLC3SEL3_LC3D4S3       0x08
#define _CLC3SEL3_D4S3          0x08
#define _CLC3SEL3_LC3D4S4       0x10
#define _CLC3SEL3_D4S4          0x10

//==============================================================================


//==============================================================================
//        CLC3GLS0 Bits

extern __at(0x0F2A) __sfr CLC3GLS0;

typedef union
  {
  struct
    {
    unsigned LC3G1D1N           : 1;
    unsigned LC3G1D1T           : 1;
    unsigned LC3G1D2N           : 1;
    unsigned LC3G1D2T           : 1;
    unsigned LC3G1D3N           : 1;
    unsigned LC3G1D3T           : 1;
    unsigned LC3G1D4N           : 1;
    unsigned LC3G1D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC3GLS0bits_t;

extern __at(0x0F2A) volatile __CLC3GLS0bits_t CLC3GLS0bits;

#define _CLC3GLS0_LC3G1D1N      0x01
#define _CLC3GLS0_D1N           0x01
#define _CLC3GLS0_LC3G1D1T      0x02
#define _CLC3GLS0_D1T           0x02
#define _CLC3GLS0_LC3G1D2N      0x04
#define _CLC3GLS0_D2N           0x04
#define _CLC3GLS0_LC3G1D2T      0x08
#define _CLC3GLS0_D2T           0x08
#define _CLC3GLS0_LC3G1D3N      0x10
#define _CLC3GLS0_D3N           0x10
#define _CLC3GLS0_LC3G1D3T      0x20
#define _CLC3GLS0_D3T           0x20
#define _CLC3GLS0_LC3G1D4N      0x40
#define _CLC3GLS0_D4N           0x40
#define _CLC3GLS0_LC3G1D4T      0x80
#define _CLC3GLS0_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC3GLS1 Bits

extern __at(0x0F2B) __sfr CLC3GLS1;

typedef union
  {
  struct
    {
    unsigned LC3G2D1N           : 1;
    unsigned LC3G2D1T           : 1;
    unsigned LC3G2D2N           : 1;
    unsigned LC3G2D2T           : 1;
    unsigned LC3G2D3N           : 1;
    unsigned LC3G2D3T           : 1;
    unsigned LC3G2D4N           : 1;
    unsigned LC3G2D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC3GLS1bits_t;

extern __at(0x0F2B) volatile __CLC3GLS1bits_t CLC3GLS1bits;

#define _CLC3GLS1_LC3G2D1N      0x01
#define _CLC3GLS1_D1N           0x01
#define _CLC3GLS1_LC3G2D1T      0x02
#define _CLC3GLS1_D1T           0x02
#define _CLC3GLS1_LC3G2D2N      0x04
#define _CLC3GLS1_D2N           0x04
#define _CLC3GLS1_LC3G2D2T      0x08
#define _CLC3GLS1_D2T           0x08
#define _CLC3GLS1_LC3G2D3N      0x10
#define _CLC3GLS1_D3N           0x10
#define _CLC3GLS1_LC3G2D3T      0x20
#define _CLC3GLS1_D3T           0x20
#define _CLC3GLS1_LC3G2D4N      0x40
#define _CLC3GLS1_D4N           0x40
#define _CLC3GLS1_LC3G2D4T      0x80
#define _CLC3GLS1_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC3GLS2 Bits

extern __at(0x0F2C) __sfr CLC3GLS2;

typedef union
  {
  struct
    {
    unsigned LC3G3D1N           : 1;
    unsigned LC3G3D1T           : 1;
    unsigned LC3G3D2N           : 1;
    unsigned LC3G3D2T           : 1;
    unsigned LC3G3D3N           : 1;
    unsigned LC3G3D3T           : 1;
    unsigned LC3G3D4N           : 1;
    unsigned LC3G3D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC3GLS2bits_t;

extern __at(0x0F2C) volatile __CLC3GLS2bits_t CLC3GLS2bits;

#define _CLC3GLS2_LC3G3D1N      0x01
#define _CLC3GLS2_D1N           0x01
#define _CLC3GLS2_LC3G3D1T      0x02
#define _CLC3GLS2_D1T           0x02
#define _CLC3GLS2_LC3G3D2N      0x04
#define _CLC3GLS2_D2N           0x04
#define _CLC3GLS2_LC3G3D2T      0x08
#define _CLC3GLS2_D2T           0x08
#define _CLC3GLS2_LC3G3D3N      0x10
#define _CLC3GLS2_D3N           0x10
#define _CLC3GLS2_LC3G3D3T      0x20
#define _CLC3GLS2_D3T           0x20
#define _CLC3GLS2_LC3G3D4N      0x40
#define _CLC3GLS2_D4N           0x40
#define _CLC3GLS2_LC3G3D4T      0x80
#define _CLC3GLS2_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC3GLS3 Bits

extern __at(0x0F2D) __sfr CLC3GLS3;

typedef union
  {
  struct
    {
    unsigned LC3G4D1N           : 1;
    unsigned LC3G4D1T           : 1;
    unsigned LC3G4D2N           : 1;
    unsigned LC3G4D2T           : 1;
    unsigned LC3G4D3N           : 1;
    unsigned LC3G4D3T           : 1;
    unsigned LC3G4D4N           : 1;
    unsigned LC3G4D4T           : 1;
    };

  struct
    {
    unsigned G4D1N              : 1;
    unsigned G4D1T              : 1;
    unsigned G4D2N              : 1;
    unsigned G4D2T              : 1;
    unsigned G4D3N              : 1;
    unsigned G4D3T              : 1;
    unsigned G4D4N              : 1;
    unsigned G4D4T              : 1;
    };
  } __CLC3GLS3bits_t;

extern __at(0x0F2D) volatile __CLC3GLS3bits_t CLC3GLS3bits;

#define _CLC3GLS3_LC3G4D1N      0x01
#define _CLC3GLS3_G4D1N         0x01
#define _CLC3GLS3_LC3G4D1T      0x02
#define _CLC3GLS3_G4D1T         0x02
#define _CLC3GLS3_LC3G4D2N      0x04
#define _CLC3GLS3_G4D2N         0x04
#define _CLC3GLS3_LC3G4D2T      0x08
#define _CLC3GLS3_G4D2T         0x08
#define _CLC3GLS3_LC3G4D3N      0x10
#define _CLC3GLS3_G4D3N         0x10
#define _CLC3GLS3_LC3G4D3T      0x20
#define _CLC3GLS3_G4D3T         0x20
#define _CLC3GLS3_LC3G4D4N      0x40
#define _CLC3GLS3_G4D4N         0x40
#define _CLC3GLS3_LC3G4D4T      0x80
#define _CLC3GLS3_G4D4T         0x80

//==============================================================================


//==============================================================================
//        STATUS_SHAD Bits

extern __at(0x0FE4) __sfr STATUS_SHAD;

typedef struct
  {
  unsigned C_SHAD               : 1;
  unsigned DC_SHAD              : 1;
  unsigned Z_SHAD               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUS_SHADbits_t;

extern __at(0x0FE4) volatile __STATUS_SHADbits_t STATUS_SHADbits;

#define _C_SHAD                 0x01
#define _DC_SHAD                0x02
#define _Z_SHAD                 0x04

//==============================================================================

extern __at(0x0FE5) __sfr WREG_SHAD;
extern __at(0x0FE6) __sfr BSR_SHAD;
extern __at(0x0FE7) __sfr PCLATH_SHAD;
extern __at(0x0FE8) __sfr FSR0L_SHAD;
extern __at(0x0FE9) __sfr FSR0H_SHAD;
extern __at(0x0FEA) __sfr FSR1L_SHAD;
extern __at(0x0FEB) __sfr FSR1H_SHAD;
extern __at(0x0FED) __sfr STKPTR;
extern __at(0x0FEE) __sfr TOSL;
extern __at(0x0FEF) __sfr TOSH;

//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define _CONFIG1                0x8007
#define _CONFIG2                0x8008

//----------------------------- CONFIG1 Options -------------------------------

#define _FOSC_LP                0x3FF8  // LP Oscillator, Low-power crystal connected between OSC1 and OSC2 pins.
#define _FOSC_XT                0x3FF9  // XT Oscillator, Crystal/resonator connected between OSC1 and OSC2 pins.
#define _FOSC_HS                0x3FFA  // HS Oscillator, High-speed crystal/resonator connected between OSC1 and OSC2 pins.
#define _FOSC_EXTRC             0x3FFB  // EXTRC oscillator: External RC circuit connected to CLKIN pin.
#define _FOSC_INTOSC            0x3FFC  // INTOSC oscillator: I/O function on CLKIN pin.
#define _FOSC_ECL               0x3FFD  // ECL, External Clock, Low Power Mode (0-0.5 MHz): device clock supplied to CLKIN pins.
#define _FOSC_ECM               0x3FFE  // ECM, External Clock, Medium Power Mode (0.5-4 MHz): device clock supplied to CLKIN pins.
#define _FOSC_ECH               0x3FFF  // ECH, External Clock, High Power Mode (4-20 MHz): device clock supplied to CLKIN pins.
#define _WDTE_OFF               0x3FE7  // WDT disabled.
#define _WDTE_SWDTEN            0x3FEF  // WDT controlled by the SWDTEN bit in the WDTCON register.
#define _WDTE_NSLEEP            0x3FF7  // WDT enabled while running and disabled in Sleep.
#define _WDTE_ON                0x3FFF  // WDT enabled.
#define _PWRTE_ON               0x3FDF  // PWRT enabled.
#define _PWRTE_OFF              0x3FFF  // PWRT disabled.
#define _MCLRE_OFF              0x3FBF  // MCLR/VPP pin function is digital input.
#define _MCLRE_ON               0x3FFF  // MCLR/VPP pin function is MCLR.
#define _CP_ON                  0x3F7F  // Program memory code protection is enabled.
#define _CP_OFF                 0x3FFF  // Program memory code protection is disabled.
#define _BOREN_OFF              0x39FF  // Brown-out Reset disabled.
#define _BOREN_SBODEN           0x3BFF  // Brown-out Reset controlled by the SBOREN bit in the BORCON register.
#define _BOREN_NSLEEP           0x3DFF  // Brown-out Reset enabled while running and disabled in Sleep.
#define _BOREN_ON               0x3FFF  // Brown-out Reset enabled.
#define _CLKOUTEN_ON            0x37FF  // CLKOUT function is enabled on the CLKOUT pin.
#define _CLKOUTEN_OFF           0x3FFF  // CLKOUT function is disabled. I/O or oscillator function on the CLKOUT pin.
#define _IESO_OFF               0x2FFF  // Internal/External Switchover Mode is disabled.
#define _IESO_ON                0x3FFF  // Internal/External Switchover Mode is enabled.
#define _FCMEN_OFF              0x1FFF  // Fail-Safe Clock Monitor is disabled.
#define _FCMEN_ON               0x3FFF  // Fail-Safe Clock Monitor is enabled.

//----------------------------- CONFIG2 Options -------------------------------

#define _WRT_ALL                0x3FFC  // 000h to 1FFFh write protected, no addresses may be modified by EECON control.
#define _WRT_HALF               0x3FFD  // 000h to FFFh write protected, 1000h to 1FFFh may be modified by EECON control.
#define _WRT_BOOT               0x3FFE  // 000h to 1FFh write protected, 200h to 1FFFh may be modified by EECON control.
#define _WRT_OFF                0x3FFF  // Write protection off.
#define _PPS1WAY_OFF            0x3FFB  // The PPSLOCK bit can be set and cleared repeatedly by software.
#define _PPS1WAY_ON             0x3FFF  // The PPSLOCK bit cannot be cleared once it is set by software.
#define _ZCD_ON                 0x3F7F  // Zero-cross detect circuit is enabled at POR.
#define _ZCD_OFF                0x3FFF  // Zero-cross detect circuit is disabled at POR.
#define _PLLEN_OFF              0x3EFF  // 4x PLL is enabled when software sets the SPLLEN bit.
#define _PLLEN_ON               0x3FFF  // 4x PLL is always enabled.
#define _STVREN_OFF             0x3DFF  // Stack Overflow or Underflow will not cause a Reset.
#define _STVREN_ON              0x3FFF  // Stack Overflow or Underflow will cause a Reset.
#define _BORV_HI                0x3BFF  // Brown-out Reset Voltage (Vbor), high trip point selected.
#define _BORV_LO                0x3FFF  // Brown-out Reset Voltage (Vbor), low trip point selected.
#define _LPBOR_ON               0x37FF  // Low-Power BOR is enabled.
#define _LPBOR_OFF              0x3FFF  // Low-Power BOR is disabled.
#define _DEBUG_ON               0x2FFF  // In-Circuit Debugger enabled, ICSPCLK and ICSPDAT are dedicated to the debugger.
#define _DEBUG_OFF              0x3FFF  // In-Circuit Debugger disabled, ICSPCLK and ICSPDAT are general purpose I/O pins.
#define _LVP_OFF                0x1FFF  // High-voltage on MCLR/VPP must be used for programming.
#define _LVP_ON                 0x3FFF  // Low-voltage programming enabled.

//==============================================================================

#define _DEVID1                 0x8006

#define _IDLOC0                 0x8000
#define _IDLOC1                 0x8001
#define _IDLOC2                 0x8002
#define _IDLOC3                 0x8003

//==============================================================================

#ifndef NO_BIT_DEFINES

#define ADON                    ADCON0bits.ADON                 // bit 0
#define GO_NOT_DONE             ADCON0bits.GO_NOT_DONE          // bit 1, shadows bit in ADCON0bits
#define ADGO                    ADCON0bits.ADGO                 // bit 1, shadows bit in ADCON0bits
#define GO                      ADCON0bits.GO                   // bit 1, shadows bit in ADCON0bits
#define CHS0                    ADCON0bits.CHS0                 // bit 2
#define CHS1                    ADCON0bits.CHS1                 // bit 3
#define CHS2                    ADCON0bits.CHS2                 // bit 4
#define CHS3                    ADCON0bits.CHS3                 // bit 5
#define CHS4                    ADCON0bits.CHS4                 // bit 6

#define ADPREF0                 ADCON1bits.ADPREF0              // bit 0
#define ADPREF1                 ADCON1bits.ADPREF1              // bit 1
#define ADNREF                  ADCON1bits.ADNREF               // bit 2
#define ADFM                    ADCON1bits.ADFM                 // bit 7

#define TRIGSEL0                ADCON2bits.TRIGSEL0             // bit 3
#define TRIGSEL1                ADCON2bits.TRIGSEL1             // bit 4
#define TRIGSEL2                ADCON2bits.TRIGSEL2             // bit 5
#define TRIGSEL3                ADCON2bits.TRIGSEL3             // bit 6
#define TRIGSEL4                ADCON2bits.TRIGSEL4             // bit 7

#define ANSA0                   ANSELAbits.ANSA0                // bit 0
#define ANSA1                   ANSELAbits.ANSA1                // bit 1
#define ANSA2                   ANSELAbits.ANSA2                // bit 2
#define ANSA4                   ANSELAbits.ANSA4                // bit 4

#define ANSC0                   ANSELCbits.ANSC0                // bit 0
#define ANSC1                   ANSELCbits.ANSC1                // bit 1
#define ANSC2                   ANSELCbits.ANSC2                // bit 2
#define ANSC3                   ANSELCbits.ANSC3                // bit 3

#define ABDEN                   BAUD1CONbits.ABDEN              // bit 0
#define WUE                     BAUD1CONbits.WUE                // bit 1
#define BRG16                   BAUD1CONbits.BRG16              // bit 3
#define SCKP                    BAUD1CONbits.SCKP               // bit 4
#define RCIDL                   BAUD1CONbits.RCIDL              // bit 6
#define ABDOVF                  BAUD1CONbits.ABDOVF             // bit 7

#define BORRDY                  BORCONbits.BORRDY               // bit 0
#define BORFS                   BORCONbits.BORFS                // bit 6
#define SBOREN                  BORCONbits.SBOREN               // bit 7

#define BSR0                    BSRbits.BSR0                    // bit 0
#define BSR1                    BSRbits.BSR1                    // bit 1
#define BSR2                    BSRbits.BSR2                    // bit 2
#define BSR3                    BSRbits.BSR3                    // bit 3
#define BSR4                    BSRbits.BSR4                    // bit 4

#define CTS0                    CCP1CAPbits.CTS0                // bit 0, shadows bit in CCP1CAPbits
#define CCP1CTS0                CCP1CAPbits.CCP1CTS0            // bit 0, shadows bit in CCP1CAPbits
#define CTS1                    CCP1CAPbits.CTS1                // bit 1, shadows bit in CCP1CAPbits
#define CCP1CTS1                CCP1CAPbits.CCP1CTS1            // bit 1, shadows bit in CCP1CAPbits
#define CTS2                    CCP1CAPbits.CTS2                // bit 2, shadows bit in CCP1CAPbits
#define CCP1CTS2                CCP1CAPbits.CCP1CTS2            // bit 2, shadows bit in CCP1CAPbits

#define MODE0                   CCP1CONbits.MODE0               // bit 0, shadows bit in CCP1CONbits
#define CCP1MODE0               CCP1CONbits.CCP1MODE0           // bit 0, shadows bit in CCP1CONbits
#define MODE1                   CCP1CONbits.MODE1               // bit 1, shadows bit in CCP1CONbits
#define CCP1MODE1               CCP1CONbits.CCP1MODE1           // bit 1, shadows bit in CCP1CONbits
#define MODE2                   CCP1CONbits.MODE2               // bit 2, shadows bit in CCP1CONbits
#define CCP1MODE2               CCP1CONbits.CCP1MODE2           // bit 2, shadows bit in CCP1CONbits
#define MODE3                   CCP1CONbits.MODE3               // bit 3, shadows bit in CCP1CONbits
#define CCP1MODE3               CCP1CONbits.CCP1MODE3           // bit 3, shadows bit in CCP1CONbits
#define FMT                     CCP1CONbits.FMT                 // bit 4, shadows bit in CCP1CONbits
#define CCP1FMT                 CCP1CONbits.CCP1FMT             // bit 4, shadows bit in CCP1CONbits
#define OUT                     CCP1CONbits.OUT                 // bit 5, shadows bit in CCP1CONbits
#define CCP1OUT                 CCP1CONbits.CCP1OUT             // bit 5, shadows bit in CCP1CONbits
#define EN                      CCP1CONbits.EN                  // bit 7, shadows bit in CCP1CONbits
#define CCP1EN                  CCP1CONbits.CCP1EN              // bit 7, shadows bit in CCP1CONbits

#define C1TSEL0                 CCPTMRSbits.C1TSEL0             // bit 0
#define C1TSEL1                 CCPTMRSbits.C1TSEL1             // bit 1
#define P3TSEL0                 CCPTMRSbits.P3TSEL0             // bit 4
#define P3TSEL1                 CCPTMRSbits.P3TSEL1             // bit 5

#define LC1G1D1N                CLC1GLS0bits.LC1G1D1N           // bit 0, shadows bit in CLC1GLS0bits
#define D1N                     CLC1GLS0bits.D1N                // bit 0, shadows bit in CLC1GLS0bits
#define LC1G1D1T                CLC1GLS0bits.LC1G1D1T           // bit 1, shadows bit in CLC1GLS0bits
#define D1T                     CLC1GLS0bits.D1T                // bit 1, shadows bit in CLC1GLS0bits
#define LC1G1D2N                CLC1GLS0bits.LC1G1D2N           // bit 2, shadows bit in CLC1GLS0bits
#define D2N                     CLC1GLS0bits.D2N                // bit 2, shadows bit in CLC1GLS0bits
#define LC1G1D2T                CLC1GLS0bits.LC1G1D2T           // bit 3, shadows bit in CLC1GLS0bits
#define D2T                     CLC1GLS0bits.D2T                // bit 3, shadows bit in CLC1GLS0bits
#define LC1G1D3N                CLC1GLS0bits.LC1G1D3N           // bit 4, shadows bit in CLC1GLS0bits
#define D3N                     CLC1GLS0bits.D3N                // bit 4, shadows bit in CLC1GLS0bits
#define LC1G1D3T                CLC1GLS0bits.LC1G1D3T           // bit 5, shadows bit in CLC1GLS0bits
#define D3T                     CLC1GLS0bits.D3T                // bit 5, shadows bit in CLC1GLS0bits
#define LC1G1D4N                CLC1GLS0bits.LC1G1D4N           // bit 6, shadows bit in CLC1GLS0bits
#define D4N                     CLC1GLS0bits.D4N                // bit 6, shadows bit in CLC1GLS0bits
#define LC1G1D4T                CLC1GLS0bits.LC1G1D4T           // bit 7, shadows bit in CLC1GLS0bits
#define D4T                     CLC1GLS0bits.D4T                // bit 7, shadows bit in CLC1GLS0bits

#define LC1G4D1N                CLC1GLS3bits.LC1G4D1N           // bit 0, shadows bit in CLC1GLS3bits
#define G4D1N                   CLC1GLS3bits.G4D1N              // bit 0, shadows bit in CLC1GLS3bits
#define LC1G4D1T                CLC1GLS3bits.LC1G4D1T           // bit 1, shadows bit in CLC1GLS3bits
#define G4D1T                   CLC1GLS3bits.G4D1T              // bit 1, shadows bit in CLC1GLS3bits
#define LC1G4D2N                CLC1GLS3bits.LC1G4D2N           // bit 2, shadows bit in CLC1GLS3bits
#define G4D2N                   CLC1GLS3bits.G4D2N              // bit 2, shadows bit in CLC1GLS3bits
#define LC1G4D2T                CLC1GLS3bits.LC1G4D2T           // bit 3, shadows bit in CLC1GLS3bits
#define G4D2T                   CLC1GLS3bits.G4D2T              // bit 3, shadows bit in CLC1GLS3bits
#define LC1G4D3N                CLC1GLS3bits.LC1G4D3N           // bit 4, shadows bit in CLC1GLS3bits
#define G4D3N                   CLC1GLS3bits.G4D3N              // bit 4, shadows bit in CLC1GLS3bits
#define LC1G4D3T                CLC1GLS3bits.LC1G4D3T           // bit 5, shadows bit in CLC1GLS3bits
#define G4D3T                   CLC1GLS3bits.G4D3T              // bit 5, shadows bit in CLC1GLS3bits
#define LC1G4D4N                CLC1GLS3bits.LC1G4D4N           // bit 6, shadows bit in CLC1GLS3bits
#define G4D4N                   CLC1GLS3bits.G4D4N              // bit 6, shadows bit in CLC1GLS3bits
#define LC1G4D4T                CLC1GLS3bits.LC1G4D4T           // bit 7, shadows bit in CLC1GLS3bits
#define G4D4T                   CLC1GLS3bits.G4D4T              // bit 7, shadows bit in CLC1GLS3bits

#define LC1G1POL                CLC1POLbits.LC1G1POL            // bit 0, shadows bit in CLC1POLbits
#define G1POL                   CLC1POLbits.G1POL               // bit 0, shadows bit in CLC1POLbits
#define LC1G2POL                CLC1POLbits.LC1G2POL            // bit 1, shadows bit in CLC1POLbits
#define G2POL                   CLC1POLbits.G2POL               // bit 1, shadows bit in CLC1POLbits
#define LC1G3POL                CLC1POLbits.LC1G3POL            // bit 2, shadows bit in CLC1POLbits
#define G3POL                   CLC1POLbits.G3POL               // bit 2, shadows bit in CLC1POLbits
#define LC1G4POL                CLC1POLbits.LC1G4POL            // bit 3, shadows bit in CLC1POLbits
#define G4POL                   CLC1POLbits.G4POL               // bit 3, shadows bit in CLC1POLbits
#define LC1POL                  CLC1POLbits.LC1POL              // bit 7, shadows bit in CLC1POLbits
#define POL                     CLC1POLbits.POL                 // bit 7, shadows bit in CLC1POLbits

#define LC1D1S0                 CLC1SEL0bits.LC1D1S0            // bit 0, shadows bit in CLC1SEL0bits
#define D1S0                    CLC1SEL0bits.D1S0               // bit 0, shadows bit in CLC1SEL0bits
#define LC1D1S1                 CLC1SEL0bits.LC1D1S1            // bit 1, shadows bit in CLC1SEL0bits
#define D1S1                    CLC1SEL0bits.D1S1               // bit 1, shadows bit in CLC1SEL0bits
#define LC1D1S2                 CLC1SEL0bits.LC1D1S2            // bit 2, shadows bit in CLC1SEL0bits
#define D1S2                    CLC1SEL0bits.D1S2               // bit 2, shadows bit in CLC1SEL0bits
#define LC1D1S3                 CLC1SEL0bits.LC1D1S3            // bit 3, shadows bit in CLC1SEL0bits
#define D1S3                    CLC1SEL0bits.D1S3               // bit 3, shadows bit in CLC1SEL0bits
#define LC1D1S4                 CLC1SEL0bits.LC1D1S4            // bit 4, shadows bit in CLC1SEL0bits
#define D1S4                    CLC1SEL0bits.D1S4               // bit 4, shadows bit in CLC1SEL0bits

#define LC1D2S0                 CLC1SEL1bits.LC1D2S0            // bit 0, shadows bit in CLC1SEL1bits
#define D2S0                    CLC1SEL1bits.D2S0               // bit 0, shadows bit in CLC1SEL1bits
#define LC1D2S1                 CLC1SEL1bits.LC1D2S1            // bit 1, shadows bit in CLC1SEL1bits
#define D2S1                    CLC1SEL1bits.D2S1               // bit 1, shadows bit in CLC1SEL1bits
#define LC1D2S2                 CLC1SEL1bits.LC1D2S2            // bit 2, shadows bit in CLC1SEL1bits
#define D2S2                    CLC1SEL1bits.D2S2               // bit 2, shadows bit in CLC1SEL1bits
#define LC1D2S3                 CLC1SEL1bits.LC1D2S3            // bit 3, shadows bit in CLC1SEL1bits
#define D2S3                    CLC1SEL1bits.D2S3               // bit 3, shadows bit in CLC1SEL1bits
#define LC1D2S4                 CLC1SEL1bits.LC1D2S4            // bit 4, shadows bit in CLC1SEL1bits
#define D2S4                    CLC1SEL1bits.D2S4               // bit 4, shadows bit in CLC1SEL1bits

#define LC1D3S0                 CLC1SEL2bits.LC1D3S0            // bit 0, shadows bit in CLC1SEL2bits
#define D3S0                    CLC1SEL2bits.D3S0               // bit 0, shadows bit in CLC1SEL2bits
#define LC1D3S1                 CLC1SEL2bits.LC1D3S1            // bit 1, shadows bit in CLC1SEL2bits
#define D3S1                    CLC1SEL2bits.D3S1               // bit 1, shadows bit in CLC1SEL2bits
#define LC1D3S2                 CLC1SEL2bits.LC1D3S2            // bit 2, shadows bit in CLC1SEL2bits
#define D3S2                    CLC1SEL2bits.D3S2               // bit 2, shadows bit in CLC1SEL2bits
#define LC1D3S3                 CLC1SEL2bits.LC1D3S3            // bit 3, shadows bit in CLC1SEL2bits
#define D3S3                    CLC1SEL2bits.D3S3               // bit 3, shadows bit in CLC1SEL2bits
#define LC1D3S4                 CLC1SEL2bits.LC1D3S4            // bit 4, shadows bit in CLC1SEL2bits
#define D3S4                    CLC1SEL2bits.D3S4               // bit 4, shadows bit in CLC1SEL2bits

#define LC1D4S0                 CLC1SEL3bits.LC1D4S0            // bit 0, shadows bit in CLC1SEL3bits
#define D4S0                    CLC1SEL3bits.D4S0               // bit 0, shadows bit in CLC1SEL3bits
#define LC1D4S1                 CLC1SEL3bits.LC1D4S1            // bit 1, shadows bit in CLC1SEL3bits
#define D4S1                    CLC1SEL3bits.D4S1               // bit 1, shadows bit in CLC1SEL3bits
#define LC1D4S2                 CLC1SEL3bits.LC1D4S2            // bit 2, shadows bit in CLC1SEL3bits
#define D4S2                    CLC1SEL3bits.D4S2               // bit 2, shadows bit in CLC1SEL3bits
#define LC1D4S3                 CLC1SEL3bits.LC1D4S3            // bit 3, shadows bit in CLC1SEL3bits
#define D4S3                    CLC1SEL3bits.D4S3               // bit 3, shadows bit in CLC1SEL3bits
#define LC1D4S4                 CLC1SEL3bits.LC1D4S4            // bit 4, shadows bit in CLC1SEL3bits
#define D4S4                    CLC1SEL3bits.D4S4               // bit 4, shadows bit in CLC1SEL3bits

#define MCLC1OUT                CLCDATAbits.MCLC1OUT            // bit 0
#define MCLC2OUT                CLCDATAbits.MCLC2OUT            // bit 1
#define MCLC3OUT                CLCDATAbits.MCLC3OUT            // bit 2

#define NCH0                    CM1NSELbits.NCH0                // bit 0, shadows bit in CM1NSELbits
#define C1NCH0                  CM1NSELbits.C1NCH0              // bit 0, shadows bit in CM1NSELbits
#define NCH1                    CM1NSELbits.NCH1                // bit 1, shadows bit in CM1NSELbits
#define C1NCH1                  CM1NSELbits.C1NCH1              // bit 1, shadows bit in CM1NSELbits
#define NCH2                    CM1NSELbits.NCH2                // bit 2, shadows bit in CM1NSELbits
#define C1NCH2                  CM1NSELbits.C1NCH2              // bit 2, shadows bit in CM1NSELbits

#define PCH0                    CM1PSELbits.PCH0                // bit 0, shadows bit in CM1PSELbits
#define C1PCH0                  CM1PSELbits.C1PCH0              // bit 0, shadows bit in CM1PSELbits
#define PCH1                    CM1PSELbits.PCH1                // bit 1, shadows bit in CM1PSELbits
#define C1PCH1                  CM1PSELbits.C1PCH1              // bit 1, shadows bit in CM1PSELbits
#define PCH2                    CM1PSELbits.PCH2                // bit 2, shadows bit in CM1PSELbits
#define C1PCH2                  CM1PSELbits.C1PCH2              // bit 2, shadows bit in CM1PSELbits
#define PCH3                    CM1PSELbits.PCH3                // bit 3, shadows bit in CM1PSELbits
#define C1PCH3                  CM1PSELbits.C1PCH3              // bit 3, shadows bit in CM1PSELbits

#define MC1OUT                  CMOUTbits.MC1OUT                // bit 0
#define MC2OUT                  CMOUTbits.MC2OUT                // bit 1

#define ASDAC0                  COG1ASD0bits.ASDAC0             // bit 2, shadows bit in COG1ASD0bits
#define G1ASDAC0                COG1ASD0bits.G1ASDAC0           // bit 2, shadows bit in COG1ASD0bits
#define ASDAC1                  COG1ASD0bits.ASDAC1             // bit 3, shadows bit in COG1ASD0bits
#define G1ASDAC1                COG1ASD0bits.G1ASDAC1           // bit 3, shadows bit in COG1ASD0bits
#define ASDBD0                  COG1ASD0bits.ASDBD0             // bit 4, shadows bit in COG1ASD0bits
#define G1ASDBD0                COG1ASD0bits.G1ASDBD0           // bit 4, shadows bit in COG1ASD0bits
#define ASDBD1                  COG1ASD0bits.ASDBD1             // bit 5, shadows bit in COG1ASD0bits
#define G1ASDBD1                COG1ASD0bits.G1ASDBD1           // bit 5, shadows bit in COG1ASD0bits
#define ASREN                   COG1ASD0bits.ASREN              // bit 6, shadows bit in COG1ASD0bits
#define ARSEN                   COG1ASD0bits.ARSEN              // bit 6, shadows bit in COG1ASD0bits
#define G1ARSEN                 COG1ASD0bits.G1ARSEN            // bit 6, shadows bit in COG1ASD0bits
#define G1ASREN                 COG1ASD0bits.G1ASREN            // bit 6, shadows bit in COG1ASD0bits
#define ASE                     COG1ASD0bits.ASE                // bit 7, shadows bit in COG1ASD0bits
#define G1ASE                   COG1ASD0bits.G1ASE              // bit 7, shadows bit in COG1ASD0bits

#define AS0E                    COG1ASD1bits.AS0E               // bit 0, shadows bit in COG1ASD1bits
#define G1AS0E                  COG1ASD1bits.G1AS0E             // bit 0, shadows bit in COG1ASD1bits
#define AS1E                    COG1ASD1bits.AS1E               // bit 1, shadows bit in COG1ASD1bits
#define G1AS1E                  COG1ASD1bits.G1AS1E             // bit 1, shadows bit in COG1ASD1bits
#define AS2E                    COG1ASD1bits.AS2E               // bit 2, shadows bit in COG1ASD1bits
#define G1AS2E                  COG1ASD1bits.G1AS2E             // bit 2, shadows bit in COG1ASD1bits
#define AS3E                    COG1ASD1bits.AS3E               // bit 3, shadows bit in COG1ASD1bits
#define G1AS3E                  COG1ASD1bits.G1AS3E             // bit 3, shadows bit in COG1ASD1bits
#define AS4E                    COG1ASD1bits.AS4E               // bit 4, shadows bit in COG1ASD1bits
#define G1AS4E                  COG1ASD1bits.G1AS4E             // bit 4, shadows bit in COG1ASD1bits
#define AS5E                    COG1ASD1bits.AS5E               // bit 5, shadows bit in COG1ASD1bits
#define G1AS5E                  COG1ASD1bits.G1AS5E             // bit 5, shadows bit in COG1ASD1bits
#define AS6E                    COG1ASD1bits.AS6E               // bit 6, shadows bit in COG1ASD1bits
#define G1AS6E                  COG1ASD1bits.G1AS6E             // bit 6, shadows bit in COG1ASD1bits
#define AS7E                    COG1ASD1bits.AS7E               // bit 7, shadows bit in COG1ASD1bits
#define G1AS7E                  COG1ASD1bits.G1AS7E             // bit 7, shadows bit in COG1ASD1bits

#define BLKF0                   COG1BLKFbits.BLKF0              // bit 0, shadows bit in COG1BLKFbits
#define G1BLKF0                 COG1BLKFbits.G1BLKF0            // bit 0, shadows bit in COG1BLKFbits
#define BLKF1                   COG1BLKFbits.BLKF1              // bit 1, shadows bit in COG1BLKFbits
#define G1BLKF1                 COG1BLKFbits.G1BLKF1            // bit 1, shadows bit in COG1BLKFbits
#define BLKF2                   COG1BLKFbits.BLKF2              // bit 2, shadows bit in COG1BLKFbits
#define G1BLKF2                 COG1BLKFbits.G1BLKF2            // bit 2, shadows bit in COG1BLKFbits
#define BLKF3                   COG1BLKFbits.BLKF3              // bit 3, shadows bit in COG1BLKFbits
#define G1BLKF3                 COG1BLKFbits.G1BLKF3            // bit 3, shadows bit in COG1BLKFbits
#define BLKF4                   COG1BLKFbits.BLKF4              // bit 4, shadows bit in COG1BLKFbits
#define G1BLKF4                 COG1BLKFbits.G1BLKF4            // bit 4, shadows bit in COG1BLKFbits
#define BLKF5                   COG1BLKFbits.BLKF5              // bit 5, shadows bit in COG1BLKFbits
#define G1BLKF5                 COG1BLKFbits.G1BLKF5            // bit 5, shadows bit in COG1BLKFbits

#define BLKR0                   COG1BLKRbits.BLKR0              // bit 0, shadows bit in COG1BLKRbits
#define G1BLKR0                 COG1BLKRbits.G1BLKR0            // bit 0, shadows bit in COG1BLKRbits
#define BLKR1                   COG1BLKRbits.BLKR1              // bit 1, shadows bit in COG1BLKRbits
#define G1BLKR1                 COG1BLKRbits.G1BLKR1            // bit 1, shadows bit in COG1BLKRbits
#define BLKR2                   COG1BLKRbits.BLKR2              // bit 2, shadows bit in COG1BLKRbits
#define G1BLKR2                 COG1BLKRbits.G1BLKR2            // bit 2, shadows bit in COG1BLKRbits
#define BLKR3                   COG1BLKRbits.BLKR3              // bit 3, shadows bit in COG1BLKRbits
#define G1BLKR3                 COG1BLKRbits.G1BLKR3            // bit 3, shadows bit in COG1BLKRbits
#define BLKR4                   COG1BLKRbits.BLKR4              // bit 4, shadows bit in COG1BLKRbits
#define G1BLKR4                 COG1BLKRbits.G1BLKR4            // bit 4, shadows bit in COG1BLKRbits
#define BLKR5                   COG1BLKRbits.BLKR5              // bit 5, shadows bit in COG1BLKRbits
#define G1BLKR5                 COG1BLKRbits.G1BLKR5            // bit 5, shadows bit in COG1BLKRbits

#define POLA                    COG1CON1bits.POLA               // bit 0, shadows bit in COG1CON1bits
#define G1POLA                  COG1CON1bits.G1POLA             // bit 0, shadows bit in COG1CON1bits
#define POLB                    COG1CON1bits.POLB               // bit 1, shadows bit in COG1CON1bits
#define G1POLB                  COG1CON1bits.G1POLB             // bit 1, shadows bit in COG1CON1bits
#define POLC                    COG1CON1bits.POLC               // bit 2, shadows bit in COG1CON1bits
#define G1POLC                  COG1CON1bits.G1POLC             // bit 2, shadows bit in COG1CON1bits
#define POLD                    COG1CON1bits.POLD               // bit 3, shadows bit in COG1CON1bits
#define G1POLD                  COG1CON1bits.G1POLD             // bit 3, shadows bit in COG1CON1bits
#define FDBS                    COG1CON1bits.FDBS               // bit 6, shadows bit in COG1CON1bits
#define G1FDBS                  COG1CON1bits.G1FDBS             // bit 6, shadows bit in COG1CON1bits
#define RDBS                    COG1CON1bits.RDBS               // bit 7, shadows bit in COG1CON1bits
#define G1RDBS                  COG1CON1bits.G1RDBS             // bit 7, shadows bit in COG1CON1bits

#define DBF0                    COG1DBFbits.DBF0                // bit 0, shadows bit in COG1DBFbits
#define G1DBF0                  COG1DBFbits.G1DBF0              // bit 0, shadows bit in COG1DBFbits
#define DBF1                    COG1DBFbits.DBF1                // bit 1, shadows bit in COG1DBFbits
#define G1DBF1                  COG1DBFbits.G1DBF1              // bit 1, shadows bit in COG1DBFbits
#define DBF2                    COG1DBFbits.DBF2                // bit 2, shadows bit in COG1DBFbits
#define G1DBF2                  COG1DBFbits.G1DBF2              // bit 2, shadows bit in COG1DBFbits
#define DBF3                    COG1DBFbits.DBF3                // bit 3, shadows bit in COG1DBFbits
#define G1DBF3                  COG1DBFbits.G1DBF3              // bit 3, shadows bit in COG1DBFbits
#define DBF4                    COG1DBFbits.DBF4                // bit 4, shadows bit in COG1DBFbits
#define G1DBF4                  COG1DBFbits.G1DBF4              // bit 4, shadows bit in COG1DBFbits
#define DBF5                    COG1DBFbits.DBF5                // bit 5, shadows bit in COG1DBFbits
#define G1DBF5                  COG1DBFbits.G1DBF5              // bit 5, shadows bit in COG1DBFbits

#define DBR0                    COG1DBRbits.DBR0                // bit 0, shadows bit in COG1DBRbits
#define G1DBR0                  COG1DBRbits.G1DBR0              // bit 0, shadows bit in COG1DBRbits
#define DBR1                    COG1DBRbits.DBR1                // bit 1, shadows bit in COG1DBRbits
#define G1DBR1                  COG1DBRbits.G1DBR1              // bit 1, shadows bit in COG1DBRbits
#define DBR2                    COG1DBRbits.DBR2                // bit 2, shadows bit in COG1DBRbits
#define G1DBR2                  COG1DBRbits.G1DBR2              // bit 2, shadows bit in COG1DBRbits
#define DBR3                    COG1DBRbits.DBR3                // bit 3, shadows bit in COG1DBRbits
#define G1DBR3                  COG1DBRbits.G1DBR3              // bit 3, shadows bit in COG1DBRbits
#define DBR4                    COG1DBRbits.DBR4                // bit 4, shadows bit in COG1DBRbits
#define G1DBR4                  COG1DBRbits.G1DBR4              // bit 4, shadows bit in COG1DBRbits
#define DBR5                    COG1DBRbits.DBR5                // bit 5, shadows bit in COG1DBRbits
#define G1DBR5                  COG1DBRbits.G1DBR5              // bit 5, shadows bit in COG1DBRbits

#define FIS0                    COG1FIS0bits.FIS0               // bit 0, shadows bit in COG1FIS0bits
#define G1FIS0                  COG1FIS0bits.G1FIS0             // bit 0, shadows bit in COG1FIS0bits
#define FIS1                    COG1FIS0bits.FIS1               // bit 1, shadows bit in COG1FIS0bits
#define G1FIS1                  COG1FIS0bits.G1FIS1             // bit 1, shadows bit in COG1FIS0bits
#define FIS2                    COG1FIS0bits.FIS2               // bit 2, shadows bit in COG1FIS0bits
#define G1FIS2                  COG1FIS0bits.G1FIS2             // bit 2, shadows bit in COG1FIS0bits
#define FIS3                    COG1FIS0bits.FIS3               // bit 3, shadows bit in COG1FIS0bits
#define G1FIS3                  COG1FIS0bits.G1FIS3             // bit 3, shadows bit in COG1FIS0bits
#define FIS4                    COG1FIS0bits.FIS4               // bit 4, shadows bit in COG1FIS0bits
#define G1FIS4                  COG1FIS0bits.G1FIS4             // bit 4, shadows bit in COG1FIS0bits
#define FIS5                    COG1FIS0bits.FIS5               // bit 5, shadows bit in COG1FIS0bits
#define G1FIS5                  COG1FIS0bits.G1FIS5             // bit 5, shadows bit in COG1FIS0bits
#define FIS6                    COG1FIS0bits.FIS6               // bit 6, shadows bit in COG1FIS0bits
#define G1FIS6                  COG1FIS0bits.G1FIS6             // bit 6, shadows bit in COG1FIS0bits
#define FIS7                    COG1FIS0bits.FIS7               // bit 7, shadows bit in COG1FIS0bits
#define G1FIS7                  COG1FIS0bits.G1FIS7             // bit 7, shadows bit in COG1FIS0bits

#define FIS8                    COG1FIS1bits.FIS8               // bit 0, shadows bit in COG1FIS1bits
#define G1FIS8                  COG1FIS1bits.G1FIS8             // bit 0, shadows bit in COG1FIS1bits
#define FIS9                    COG1FIS1bits.FIS9               // bit 1, shadows bit in COG1FIS1bits
#define G1FIS9                  COG1FIS1bits.G1FIS9             // bit 1, shadows bit in COG1FIS1bits
#define FIS10                   COG1FIS1bits.FIS10              // bit 2, shadows bit in COG1FIS1bits
#define G1FIS10                 COG1FIS1bits.G1FIS10            // bit 2, shadows bit in COG1FIS1bits
#define FIS11                   COG1FIS1bits.FIS11              // bit 3, shadows bit in COG1FIS1bits
#define G1FIS11                 COG1FIS1bits.G1FIS11            // bit 3, shadows bit in COG1FIS1bits
#define FIS12                   COG1FIS1bits.FIS12              // bit 4, shadows bit in COG1FIS1bits
#define G1FIS12                 COG1FIS1bits.G1FIS12            // bit 4, shadows bit in COG1FIS1bits
#define FIS13                   COG1FIS1bits.FIS13              // bit 5, shadows bit in COG1FIS1bits
#define G1FIS13                 COG1FIS1bits.G1FIS13            // bit 5, shadows bit in COG1FIS1bits
#define FIS14                   COG1FIS1bits.FIS14              // bit 6, shadows bit in COG1FIS1bits
#define G1FIS14                 COG1FIS1bits.G1FIS14            // bit 6, shadows bit in COG1FIS1bits

#define FSIM0                   COG1FSIM0bits.FSIM0             // bit 0, shadows bit in COG1FSIM0bits
#define G1FSIM0                 COG1FSIM0bits.G1FSIM0           // bit 0, shadows bit in COG1FSIM0bits
#define FSIM1                   COG1FSIM0bits.FSIM1             // bit 1, shadows bit in COG1FSIM0bits
#define G1FSIM1                 COG1FSIM0bits.G1FSIM1           // bit 1, shadows bit in COG1FSIM0bits
#define FSIM2                   COG1FSIM0bits.FSIM2             // bit 2, shadows bit in COG1FSIM0bits
#define G1FSIM2                 COG1FSIM0bits.G1FSIM2           // bit 2, shadows bit in COG1FSIM0bits
#define FSIM3                   COG1FSIM0bits.FSIM3             // bit 3, shadows bit in COG1FSIM0bits
#define G1FSIM3                 COG1FSIM0bits.G1FSIM3           // bit 3, shadows bit in COG1FSIM0bits
#define FSIM4                   COG1FSIM0bits.FSIM4             // bit 4, shadows bit in COG1FSIM0bits
#define G1FSIM4                 COG1FSIM0bits.G1FSIM4           // bit 4, shadows bit in COG1FSIM0bits
#define FSIM5                   COG1FSIM0bits.FSIM5             // bit 5, shadows bit in COG1FSIM0bits
#define G1FSIM5                 COG1FSIM0bits.G1FSIM5           // bit 5, shadows bit in COG1FSIM0bits
#define FSIM6                   COG1FSIM0bits.FSIM6             // bit 6, shadows bit in COG1FSIM0bits
#define G1FSIM6                 COG1FSIM0bits.G1FSIM6           // bit 6, shadows bit in COG1FSIM0bits
#define FSIM7                   COG1FSIM0bits.FSIM7             // bit 7, shadows bit in COG1FSIM0bits
#define G1FSIM7                 COG1FSIM0bits.G1FSIM7           // bit 7, shadows bit in COG1FSIM0bits

#define FSIM8                   COG1FSIM1bits.FSIM8             // bit 0, shadows bit in COG1FSIM1bits
#define G1FSIM8                 COG1FSIM1bits.G1FSIM8           // bit 0, shadows bit in COG1FSIM1bits
#define FSIM9                   COG1FSIM1bits.FSIM9             // bit 1, shadows bit in COG1FSIM1bits
#define G1FSIM9                 COG1FSIM1bits.G1FSIM9           // bit 1, shadows bit in COG1FSIM1bits
#define FSIM10                  COG1FSIM1bits.FSIM10            // bit 2, shadows bit in COG1FSIM1bits
#define G1FSIM10                COG1FSIM1bits.G1FSIM10          // bit 2, shadows bit in COG1FSIM1bits
#define FSIM11                  COG1FSIM1bits.FSIM11            // bit 3, shadows bit in COG1FSIM1bits
#define G1FSIM11                COG1FSIM1bits.G1FSIM11          // bit 3, shadows bit in COG1FSIM1bits
#define FSIM12                  COG1FSIM1bits.FSIM12            // bit 4, shadows bit in COG1FSIM1bits
#define G1FSIM12                COG1FSIM1bits.G1FSIM12          // bit 4, shadows bit in COG1FSIM1bits
#define FSIM13                  COG1FSIM1bits.FSIM13            // bit 5, shadows bit in COG1FSIM1bits
#define G1FSIM13                COG1FSIM1bits.G1FSIM13          // bit 5, shadows bit in COG1FSIM1bits
#define FSIM14                  COG1FSIM1bits.FSIM14            // bit 6, shadows bit in COG1FSIM1bits
#define G1FSIM14                COG1FSIM1bits.G1FSIM14          // bit 6, shadows bit in COG1FSIM1bits

#define PHF0                    COG1PHFbits.PHF0                // bit 0, shadows bit in COG1PHFbits
#define G1PHF0                  COG1PHFbits.G1PHF0              // bit 0, shadows bit in COG1PHFbits
#define PHF1                    COG1PHFbits.PHF1                // bit 1, shadows bit in COG1PHFbits
#define G1PHF1                  COG1PHFbits.G1PHF1              // bit 1, shadows bit in COG1PHFbits
#define PHF2                    COG1PHFbits.PHF2                // bit 2, shadows bit in COG1PHFbits
#define G1PHF2                  COG1PHFbits.G1PHF2              // bit 2, shadows bit in COG1PHFbits
#define PHF3                    COG1PHFbits.PHF3                // bit 3, shadows bit in COG1PHFbits
#define G1PHF3                  COG1PHFbits.G1PHF3              // bit 3, shadows bit in COG1PHFbits
#define PHF4                    COG1PHFbits.PHF4                // bit 4, shadows bit in COG1PHFbits
#define G1PHF4                  COG1PHFbits.G1PHF4              // bit 4, shadows bit in COG1PHFbits
#define PHF5                    COG1PHFbits.PHF5                // bit 5, shadows bit in COG1PHFbits
#define G1PHF5                  COG1PHFbits.G1PHF5              // bit 5, shadows bit in COG1PHFbits

#define PHR0                    COG1PHRbits.PHR0                // bit 0, shadows bit in COG1PHRbits
#define G1PHR0                  COG1PHRbits.G1PHR0              // bit 0, shadows bit in COG1PHRbits
#define PHR1                    COG1PHRbits.PHR1                // bit 1, shadows bit in COG1PHRbits
#define G1PHR1                  COG1PHRbits.G1PHR1              // bit 1, shadows bit in COG1PHRbits
#define PHR2                    COG1PHRbits.PHR2                // bit 2, shadows bit in COG1PHRbits
#define G1PHR2                  COG1PHRbits.G1PHR2              // bit 2, shadows bit in COG1PHRbits
#define PHR3                    COG1PHRbits.PHR3                // bit 3, shadows bit in COG1PHRbits
#define G1PHR3                  COG1PHRbits.G1PHR3              // bit 3, shadows bit in COG1PHRbits
#define PHR4                    COG1PHRbits.PHR4                // bit 4, shadows bit in COG1PHRbits
#define G1PHR4                  COG1PHRbits.G1PHR4              // bit 4, shadows bit in COG1PHRbits
#define PHR5                    COG1PHRbits.PHR5                // bit 5, shadows bit in COG1PHRbits
#define G1PHR5                  COG1PHRbits.G1PHR5              // bit 5, shadows bit in COG1PHRbits

#define RIS0                    COG1RIS0bits.RIS0               // bit 0, shadows bit in COG1RIS0bits
#define G1RIS0                  COG1RIS0bits.G1RIS0             // bit 0, shadows bit in COG1RIS0bits
#define RIS1                    COG1RIS0bits.RIS1               // bit 1, shadows bit in COG1RIS0bits
#define G1RIS1                  COG1RIS0bits.G1RIS1             // bit 1, shadows bit in COG1RIS0bits
#define RIS2                    COG1RIS0bits.RIS2               // bit 2, shadows bit in COG1RIS0bits
#define G1RIS2                  COG1RIS0bits.G1RIS2             // bit 2, shadows bit in COG1RIS0bits
#define RIS3                    COG1RIS0bits.RIS3               // bit 3, shadows bit in COG1RIS0bits
#define G1RIS3                  COG1RIS0bits.G1RIS3             // bit 3, shadows bit in COG1RIS0bits
#define RIS4                    COG1RIS0bits.RIS4               // bit 4, shadows bit in COG1RIS0bits
#define G1RIS4                  COG1RIS0bits.G1RIS4             // bit 4, shadows bit in COG1RIS0bits
#define RIS5                    COG1RIS0bits.RIS5               // bit 5, shadows bit in COG1RIS0bits
#define G1RIS5                  COG1RIS0bits.G1RIS5             // bit 5, shadows bit in COG1RIS0bits
#define RIS6                    COG1RIS0bits.RIS6               // bit 6, shadows bit in COG1RIS0bits
#define G1RIS6                  COG1RIS0bits.G1RIS6             // bit 6, shadows bit in COG1RIS0bits
#define RIS7                    COG1RIS0bits.RIS7               // bit 7, shadows bit in COG1RIS0bits
#define G1RIS7                  COG1RIS0bits.G1RIS7             // bit 7, shadows bit in COG1RIS0bits

#define RIS8                    COG1RIS1bits.RIS8               // bit 0, shadows bit in COG1RIS1bits
#define G1RIS8                  COG1RIS1bits.G1RIS8             // bit 0, shadows bit in COG1RIS1bits
#define RIS9                    COG1RIS1bits.RIS9               // bit 1, shadows bit in COG1RIS1bits
#define G1RIS9                  COG1RIS1bits.G1RIS9             // bit 1, shadows bit in COG1RIS1bits
#define RIS10                   COG1RIS1bits.RIS10              // bit 2, shadows bit in COG1RIS1bits
#define G1RIS10                 COG1RIS1bits.G1RIS10            // bit 2, shadows bit in COG1RIS1bits
#define RIS11                   COG1RIS1bits.RIS11              // bit 3, shadows bit in COG1RIS1bits
#define G1RIS11                 COG1RIS1bits.G1RIS11            // bit 3, shadows bit in COG1RIS1bits
#define RIS12                   COG1RIS1bits.RIS12              // bit 4, shadows bit in COG1RIS1bits
#define G1RIS12                 COG1RIS1bits.G1RIS12            // bit 4, shadows bit in COG1RIS1bits
#define RIS13                   COG1RIS1bits.RIS13              // bit 5, shadows bit in COG1RIS1bits
#define G1RIS13                 COG1RIS1bits.G1RIS13            // bit 5, shadows bit in COG1RIS1bits
#define RIS14                   COG1RIS1bits.RIS14              // bit 6, shadows bit in COG1RIS1bits
#define G1RIS14                 COG1RIS1bits.G1RIS14            // bit 6, shadows bit in COG1RIS1bits

#define RSIM0                   COG1RSIM0bits.RSIM0             // bit 0, shadows bit in COG1RSIM0bits
#define G1RSIM0                 COG1RSIM0bits.G1RSIM0           // bit 0, shadows bit in COG1RSIM0bits
#define RSIM1                   COG1RSIM0bits.RSIM1             // bit 1, shadows bit in COG1RSIM0bits
#define G1RSIM1                 COG1RSIM0bits.G1RSIM1           // bit 1, shadows bit in COG1RSIM0bits
#define RSIM2                   COG1RSIM0bits.RSIM2             // bit 2, shadows bit in COG1RSIM0bits
#define G1RSIM2                 COG1RSIM0bits.G1RSIM2           // bit 2, shadows bit in COG1RSIM0bits
#define RSIM3                   COG1RSIM0bits.RSIM3             // bit 3, shadows bit in COG1RSIM0bits
#define G1RSIM3                 COG1RSIM0bits.G1RSIM3           // bit 3, shadows bit in COG1RSIM0bits
#define RSIM4                   COG1RSIM0bits.RSIM4             // bit 4, shadows bit in COG1RSIM0bits
#define G1RSIM4                 COG1RSIM0bits.G1RSIM4           // bit 4, shadows bit in COG1RSIM0bits
#define RSIM5                   COG1RSIM0bits.RSIM5             // bit 5, shadows bit in COG1RSIM0bits
#define G1RSIM5                 COG1RSIM0bits.G1RSIM5           // bit 5, shadows bit in COG1RSIM0bits
#define RSIM6                   COG1RSIM0bits.RSIM6             // bit 6, shadows bit in COG1RSIM0bits
#define G1RSIM6                 COG1RSIM0bits.G1RSIM6           // bit 6, shadows bit in COG1RSIM0bits
#define RSIM7                   COG1RSIM0bits.RSIM7             // bit 7, shadows bit in COG1RSIM0bits
#define G1RSIM7                 COG1RSIM0bits.G1RSIM7           // bit 7, shadows bit in COG1RSIM0bits

#define RSIM8                   COG1RSIM1bits.RSIM8             // bit 0, shadows bit in COG1RSIM1bits
#define G1RSIM8                 COG1RSIM1bits.G1RSIM8           // bit 0, shadows bit in COG1RSIM1bits
#define RSIM9                   COG1RSIM1bits.RSIM9             // bit 1, shadows bit in COG1RSIM1bits
#define G1RSIM9                 COG1RSIM1bits.G1RSIM9           // bit 1, shadows bit in COG1RSIM1bits
#define RSIM10                  COG1RSIM1bits.RSIM10            // bit 2, shadows bit in COG1RSIM1bits
#define G1RSIM10                COG1RSIM1bits.G1RSIM10          // bit 2, shadows bit in COG1RSIM1bits
#define RSIM11                  COG1RSIM1bits.RSIM11            // bit 3, shadows bit in COG1RSIM1bits
#define G1RSIM11                COG1RSIM1bits.G1RSIM11          // bit 3, shadows bit in COG1RSIM1bits
#define RSIM12                  COG1RSIM1bits.RSIM12            // bit 4, shadows bit in COG1RSIM1bits
#define G1RSIM12                COG1RSIM1bits.G1RSIM12          // bit 4, shadows bit in COG1RSIM1bits
#define RSIM13                  COG1RSIM1bits.RSIM13            // bit 5, shadows bit in COG1RSIM1bits
#define G1RSIM13                COG1RSIM1bits.G1RSIM13          // bit 5, shadows bit in COG1RSIM1bits
#define RSIM14                  COG1RSIM1bits.RSIM14            // bit 6, shadows bit in COG1RSIM1bits
#define G1RSIM14                COG1RSIM1bits.G1RSIM14          // bit 6, shadows bit in COG1RSIM1bits

#define STRA                    COG1STRbits.STRA                // bit 0, shadows bit in COG1STRbits
#define G1STRA                  COG1STRbits.G1STRA              // bit 0, shadows bit in COG1STRbits
#define STRB                    COG1STRbits.STRB                // bit 1, shadows bit in COG1STRbits
#define G1STRB                  COG1STRbits.G1STRB              // bit 1, shadows bit in COG1STRbits
#define STRC                    COG1STRbits.STRC                // bit 2, shadows bit in COG1STRbits
#define G1STRC                  COG1STRbits.G1STRC              // bit 2, shadows bit in COG1STRbits
#define STRD                    COG1STRbits.STRD                // bit 3, shadows bit in COG1STRbits
#define G1STRD                  COG1STRbits.G1STRD              // bit 3, shadows bit in COG1STRbits
#define SDATA                   COG1STRbits.SDATA               // bit 4, shadows bit in COG1STRbits
#define G1SDATA                 COG1STRbits.G1SDATA             // bit 4, shadows bit in COG1STRbits
#define SDATB                   COG1STRbits.SDATB               // bit 5, shadows bit in COG1STRbits
#define G1SDATB                 COG1STRbits.G1SDATB             // bit 5, shadows bit in COG1STRbits
#define SDATC                   COG1STRbits.SDATC               // bit 6, shadows bit in COG1STRbits
#define G1SDATC                 COG1STRbits.G1SDATC             // bit 6, shadows bit in COG1STRbits
#define SDATD                   COG1STRbits.SDATD               // bit 7, shadows bit in COG1STRbits
#define G1SDATD                 COG1STRbits.G1SDATD             // bit 7, shadows bit in COG1STRbits

#define REF0                    DAC1CON1bits.REF0               // bit 0, shadows bit in DAC1CON1bits
#define DAC1REF0                DAC1CON1bits.DAC1REF0           // bit 0, shadows bit in DAC1CON1bits
#define R0                      DAC1CON1bits.R0                 // bit 0, shadows bit in DAC1CON1bits
#define DAC1R0                  DAC1CON1bits.DAC1R0             // bit 0, shadows bit in DAC1CON1bits
#define REF1                    DAC1CON1bits.REF1               // bit 1, shadows bit in DAC1CON1bits
#define DAC1REF1                DAC1CON1bits.DAC1REF1           // bit 1, shadows bit in DAC1CON1bits
#define R1                      DAC1CON1bits.R1                 // bit 1, shadows bit in DAC1CON1bits
#define DAC1R1                  DAC1CON1bits.DAC1R1             // bit 1, shadows bit in DAC1CON1bits
#define REF2                    DAC1CON1bits.REF2               // bit 2, shadows bit in DAC1CON1bits
#define DAC1REF2                DAC1CON1bits.DAC1REF2           // bit 2, shadows bit in DAC1CON1bits
#define R2                      DAC1CON1bits.R2                 // bit 2, shadows bit in DAC1CON1bits
#define DAC1R2                  DAC1CON1bits.DAC1R2             // bit 2, shadows bit in DAC1CON1bits
#define REF3                    DAC1CON1bits.REF3               // bit 3, shadows bit in DAC1CON1bits
#define DAC1REF3                DAC1CON1bits.DAC1REF3           // bit 3, shadows bit in DAC1CON1bits
#define R3                      DAC1CON1bits.R3                 // bit 3, shadows bit in DAC1CON1bits
#define DAC1R3                  DAC1CON1bits.DAC1R3             // bit 3, shadows bit in DAC1CON1bits
#define REF4                    DAC1CON1bits.REF4               // bit 4, shadows bit in DAC1CON1bits
#define DAC1REF4                DAC1CON1bits.DAC1REF4           // bit 4, shadows bit in DAC1CON1bits
#define R4                      DAC1CON1bits.R4                 // bit 4, shadows bit in DAC1CON1bits
#define DAC1R4                  DAC1CON1bits.DAC1R4             // bit 4, shadows bit in DAC1CON1bits
#define REF5                    DAC1CON1bits.REF5               // bit 5, shadows bit in DAC1CON1bits
#define DAC1REF5                DAC1CON1bits.DAC1REF5           // bit 5, shadows bit in DAC1CON1bits
#define R5                      DAC1CON1bits.R5                 // bit 5, shadows bit in DAC1CON1bits
#define DAC1R5                  DAC1CON1bits.DAC1R5             // bit 5, shadows bit in DAC1CON1bits
#define REF6                    DAC1CON1bits.REF6               // bit 6, shadows bit in DAC1CON1bits
#define DAC1REF6                DAC1CON1bits.DAC1REF6           // bit 6, shadows bit in DAC1CON1bits
#define R6                      DAC1CON1bits.R6                 // bit 6, shadows bit in DAC1CON1bits
#define DAC1R6                  DAC1CON1bits.DAC1R6             // bit 6, shadows bit in DAC1CON1bits
#define REF7                    DAC1CON1bits.REF7               // bit 7, shadows bit in DAC1CON1bits
#define DAC1REF7                DAC1CON1bits.DAC1REF7           // bit 7, shadows bit in DAC1CON1bits
#define R7                      DAC1CON1bits.R7                 // bit 7, shadows bit in DAC1CON1bits
#define DAC1R7                  DAC1CON1bits.DAC1R7             // bit 7, shadows bit in DAC1CON1bits

#define REF8                    DAC1CON2bits.REF8               // bit 0, shadows bit in DAC1CON2bits
#define DAC1REF8                DAC1CON2bits.DAC1REF8           // bit 0, shadows bit in DAC1CON2bits
#define R8                      DAC1CON2bits.R8                 // bit 0, shadows bit in DAC1CON2bits
#define DAC1R8                  DAC1CON2bits.DAC1R8             // bit 0, shadows bit in DAC1CON2bits
#define REF9                    DAC1CON2bits.REF9               // bit 1, shadows bit in DAC1CON2bits
#define DAC1REF9                DAC1CON2bits.DAC1REF9           // bit 1, shadows bit in DAC1CON2bits
#define R9                      DAC1CON2bits.R9                 // bit 1, shadows bit in DAC1CON2bits
#define DAC1R9                  DAC1CON2bits.DAC1R9             // bit 1, shadows bit in DAC1CON2bits
#define REF10                   DAC1CON2bits.REF10              // bit 2, shadows bit in DAC1CON2bits
#define DAC1REF10               DAC1CON2bits.DAC1REF10          // bit 2, shadows bit in DAC1CON2bits
#define R10                     DAC1CON2bits.R10                // bit 2, shadows bit in DAC1CON2bits
#define DAC1R10                 DAC1CON2bits.DAC1R10            // bit 2, shadows bit in DAC1CON2bits
#define REF11                   DAC1CON2bits.REF11              // bit 3, shadows bit in DAC1CON2bits
#define DAC1REF11               DAC1CON2bits.DAC1REF11          // bit 3, shadows bit in DAC1CON2bits
#define R11                     DAC1CON2bits.R11                // bit 3, shadows bit in DAC1CON2bits
#define DAC1R11                 DAC1CON2bits.DAC1R11            // bit 3, shadows bit in DAC1CON2bits
#define REF12                   DAC1CON2bits.REF12              // bit 4, shadows bit in DAC1CON2bits
#define DAC1REF12               DAC1CON2bits.DAC1REF12          // bit 4, shadows bit in DAC1CON2bits
#define R12                     DAC1CON2bits.R12                // bit 4, shadows bit in DAC1CON2bits
#define DAC1R12                 DAC1CON2bits.DAC1R12            // bit 4, shadows bit in DAC1CON2bits
#define REF13                   DAC1CON2bits.REF13              // bit 5, shadows bit in DAC1CON2bits
#define DAC1REF13               DAC1CON2bits.DAC1REF13          // bit 5, shadows bit in DAC1CON2bits
#define R13                     DAC1CON2bits.R13                // bit 5, shadows bit in DAC1CON2bits
#define DAC1R13                 DAC1CON2bits.DAC1R13            // bit 5, shadows bit in DAC1CON2bits
#define REF14                   DAC1CON2bits.REF14              // bit 6, shadows bit in DAC1CON2bits
#define DAC1REF14               DAC1CON2bits.DAC1REF14          // bit 6, shadows bit in DAC1CON2bits
#define R14                     DAC1CON2bits.R14                // bit 6, shadows bit in DAC1CON2bits
#define DAC1R14                 DAC1CON2bits.DAC1R14            // bit 6, shadows bit in DAC1CON2bits
#define REF15                   DAC1CON2bits.REF15              // bit 7, shadows bit in DAC1CON2bits
#define DAC1REF15               DAC1CON2bits.DAC1REF15          // bit 7, shadows bit in DAC1CON2bits
#define R15                     DAC1CON2bits.R15                // bit 7, shadows bit in DAC1CON2bits
#define DAC1R15                 DAC1CON2bits.DAC1R15            // bit 7, shadows bit in DAC1CON2bits

#define DAC1LD                  DACLDbits.DAC1LD                // bit 0

#define TSRNG                   FVRCONbits.TSRNG                // bit 4
#define TSEN                    FVRCONbits.TSEN                 // bit 5
#define FVRRDY                  FVRCONbits.FVRRDY               // bit 6
#define FVREN                   FVRCONbits.FVREN                // bit 7

#define HIDC4                   HIDRVCbits.HIDC4                // bit 4
#define HIDC5                   HIDRVCbits.HIDC5                // bit 5

#define INLVLA0                 INLVLAbits.INLVLA0              // bit 0
#define INLVLA1                 INLVLAbits.INLVLA1              // bit 1
#define INLVLA2                 INLVLAbits.INLVLA2              // bit 2
#define INLVLA3                 INLVLAbits.INLVLA3              // bit 3
#define INLVLA4                 INLVLAbits.INLVLA4              // bit 4
#define INLVLA5                 INLVLAbits.INLVLA5              // bit 5

#define INLVLC0                 INLVLCbits.INLVLC0              // bit 0
#define INLVLC1                 INLVLCbits.INLVLC1              // bit 1
#define INLVLC2                 INLVLCbits.INLVLC2              // bit 2
#define INLVLC3                 INLVLCbits.INLVLC3              // bit 3
#define INLVLC4                 INLVLCbits.INLVLC4              // bit 4
#define INLVLC5                 INLVLCbits.INLVLC5              // bit 5

#define IOCIF                   INTCONbits.IOCIF                // bit 0
#define INTF                    INTCONbits.INTF                 // bit 1
#define TMR0IF                  INTCONbits.TMR0IF               // bit 2, shadows bit in INTCONbits
#define T0IF                    INTCONbits.T0IF                 // bit 2, shadows bit in INTCONbits
#define IOCIE                   INTCONbits.IOCIE                // bit 3
#define INTE                    INTCONbits.INTE                 // bit 4
#define TMR0IE                  INTCONbits.TMR0IE               // bit 5, shadows bit in INTCONbits
#define T0IE                    INTCONbits.T0IE                 // bit 5, shadows bit in INTCONbits
#define PEIE                    INTCONbits.PEIE                 // bit 6
#define GIE                     INTCONbits.GIE                  // bit 7

#define IOCAF0                  IOCAFbits.IOCAF0                // bit 0
#define IOCAF1                  IOCAFbits.IOCAF1                // bit 1
#define IOCAF2                  IOCAFbits.IOCAF2                // bit 2
#define IOCAF3                  IOCAFbits.IOCAF3                // bit 3
#define IOCAF4                  IOCAFbits.IOCAF4                // bit 4
#define IOCAF5                  IOCAFbits.IOCAF5                // bit 5

#define IOCAN0                  IOCANbits.IOCAN0                // bit 0
#define IOCAN1                  IOCANbits.IOCAN1                // bit 1
#define IOCAN2                  IOCANbits.IOCAN2                // bit 2
#define IOCAN3                  IOCANbits.IOCAN3                // bit 3
#define IOCAN4                  IOCANbits.IOCAN4                // bit 4
#define IOCAN5                  IOCANbits.IOCAN5                // bit 5

#define IOCAP0                  IOCAPbits.IOCAP0                // bit 0
#define IOCAP1                  IOCAPbits.IOCAP1                // bit 1
#define IOCAP2                  IOCAPbits.IOCAP2                // bit 2
#define IOCAP3                  IOCAPbits.IOCAP3                // bit 3
#define IOCAP4                  IOCAPbits.IOCAP4                // bit 4
#define IOCAP5                  IOCAPbits.IOCAP5                // bit 5

#define IOCCF0                  IOCCFbits.IOCCF0                // bit 0
#define IOCCF1                  IOCCFbits.IOCCF1                // bit 1
#define IOCCF2                  IOCCFbits.IOCCF2                // bit 2
#define IOCCF3                  IOCCFbits.IOCCF3                // bit 3
#define IOCCF4                  IOCCFbits.IOCCF4                // bit 4
#define IOCCF5                  IOCCFbits.IOCCF5                // bit 5

#define IOCCN0                  IOCCNbits.IOCCN0                // bit 0
#define IOCCN1                  IOCCNbits.IOCCN1                // bit 1
#define IOCCN2                  IOCCNbits.IOCCN2                // bit 2
#define IOCCN3                  IOCCNbits.IOCCN3                // bit 3
#define IOCCN4                  IOCCNbits.IOCCN4                // bit 4
#define IOCCN5                  IOCCNbits.IOCCN5                // bit 5

#define IOCCP0                  IOCCPbits.IOCCP0                // bit 0
#define IOCCP1                  IOCCPbits.IOCCP1                // bit 1
#define IOCCP2                  IOCCPbits.IOCCP2                // bit 2
#define IOCCP3                  IOCCPbits.IOCCP3                // bit 3
#define IOCCP4                  IOCCPbits.IOCCP4                // bit 4
#define IOCCP5                  IOCCPbits.IOCCP5                // bit 5

#define LATA0                   LATAbits.LATA0                  // bit 0
#define LATA1                   LATAbits.LATA1                  // bit 1
#define LATA2                   LATAbits.LATA2                  // bit 2
#define LATA4                   LATAbits.LATA4                  // bit 4
#define LATA5                   LATAbits.LATA5                  // bit 5

#define LATC0                   LATCbits.LATC0                  // bit 0
#define LATC1                   LATCbits.LATC1                  // bit 1
#define LATC2                   LATCbits.LATC2                  // bit 2
#define LATC3                   LATCbits.LATC3                  // bit 3
#define LATC4                   LATCbits.LATC4                  // bit 4
#define LATC5                   LATCbits.LATC5                  // bit 5

#define CH0                     MD1CARHbits.CH0                 // bit 0, shadows bit in MD1CARHbits
#define MD1CH0                  MD1CARHbits.MD1CH0              // bit 0, shadows bit in MD1CARHbits
#define CH1                     MD1CARHbits.CH1                 // bit 1, shadows bit in MD1CARHbits
#define MD1CH1                  MD1CARHbits.MD1CH1              // bit 1, shadows bit in MD1CARHbits
#define CH2                     MD1CARHbits.CH2                 // bit 2, shadows bit in MD1CARHbits
#define MD1CH2                  MD1CARHbits.MD1CH2              // bit 2, shadows bit in MD1CARHbits
#define CH3                     MD1CARHbits.CH3                 // bit 3, shadows bit in MD1CARHbits
#define MD1CH3                  MD1CARHbits.MD1CH3              // bit 3, shadows bit in MD1CARHbits

#define CL0                     MD1CARLbits.CL0                 // bit 0, shadows bit in MD1CARLbits
#define MD1CL0                  MD1CARLbits.MD1CL0              // bit 0, shadows bit in MD1CARLbits
#define CL1                     MD1CARLbits.CL1                 // bit 1, shadows bit in MD1CARLbits
#define MD1CL1                  MD1CARLbits.MD1CL1              // bit 1, shadows bit in MD1CARLbits
#define CL2                     MD1CARLbits.CL2                 // bit 2, shadows bit in MD1CARLbits
#define MD1CL2                  MD1CARLbits.MD1CL2              // bit 2, shadows bit in MD1CARLbits
#define CL3                     MD1CARLbits.CL3                 // bit 3, shadows bit in MD1CARLbits
#define MD1CL3                  MD1CARLbits.MD1CL3              // bit 3, shadows bit in MD1CARLbits

#define CLSYNC                  MD1CON1bits.CLSYNC              // bit 0, shadows bit in MD1CON1bits
#define MD1CLSYNC               MD1CON1bits.MD1CLSYNC           // bit 0, shadows bit in MD1CON1bits
#define CLPOL                   MD1CON1bits.CLPOL               // bit 1, shadows bit in MD1CON1bits
#define MD1CLPOL                MD1CON1bits.MD1CLPOL            // bit 1, shadows bit in MD1CON1bits
#define CHSYNC                  MD1CON1bits.CHSYNC              // bit 4, shadows bit in MD1CON1bits
#define MD1CHSYNC               MD1CON1bits.MD1CHSYNC           // bit 4, shadows bit in MD1CON1bits
#define CHPOL                   MD1CON1bits.CHPOL               // bit 5, shadows bit in MD1CON1bits
#define MD1CHPOL                MD1CON1bits.MD1CHPOL            // bit 5, shadows bit in MD1CON1bits

#define MS0                     MD1SRCbits.MS0                  // bit 0, shadows bit in MD1SRCbits
#define MD1MS0                  MD1SRCbits.MD1MS0               // bit 0, shadows bit in MD1SRCbits
#define MS1                     MD1SRCbits.MS1                  // bit 1, shadows bit in MD1SRCbits
#define MD1MS1                  MD1SRCbits.MD1MS1               // bit 1, shadows bit in MD1SRCbits
#define MS2                     MD1SRCbits.MS2                  // bit 2, shadows bit in MD1SRCbits
#define MD1MS2                  MD1SRCbits.MD1MS2               // bit 2, shadows bit in MD1SRCbits
#define MS3                     MD1SRCbits.MS3                  // bit 3, shadows bit in MD1SRCbits
#define MD1MS3                  MD1SRCbits.MD1MS3               // bit 3, shadows bit in MD1SRCbits
#define MS4                     MD1SRCbits.MS4                  // bit 4, shadows bit in MD1SRCbits
#define MD1MS4                  MD1SRCbits.MD1MS4               // bit 4, shadows bit in MD1SRCbits

#define ODA0                    ODCONAbits.ODA0                 // bit 0
#define ODA1                    ODCONAbits.ODA1                 // bit 1
#define ODA2                    ODCONAbits.ODA2                 // bit 2
#define ODA4                    ODCONAbits.ODA4                 // bit 4
#define ODA5                    ODCONAbits.ODA5                 // bit 5

#define ODC0                    ODCONCbits.ODC0                 // bit 0
#define ODC1                    ODCONCbits.ODC1                 // bit 1
#define ODC2                    ODCONCbits.ODC2                 // bit 2
#define ODC3                    ODCONCbits.ODC3                 // bit 3
#define ODC4                    ODCONCbits.ODC4                 // bit 4
#define ODC5                    ODCONCbits.ODC5                 // bit 5

#define PS0                     OPTION_REGbits.PS0              // bit 0
#define PS1                     OPTION_REGbits.PS1              // bit 1
#define PS2                     OPTION_REGbits.PS2              // bit 2
#define PSA                     OPTION_REGbits.PSA              // bit 3
#define TMR0SE                  OPTION_REGbits.TMR0SE           // bit 4, shadows bit in OPTION_REGbits
#define T0SE                    OPTION_REGbits.T0SE             // bit 4, shadows bit in OPTION_REGbits
#define TMR0CS                  OPTION_REGbits.TMR0CS           // bit 5, shadows bit in OPTION_REGbits
#define T0CS                    OPTION_REGbits.T0CS             // bit 5, shadows bit in OPTION_REGbits
#define INTEDG                  OPTION_REGbits.INTEDG           // bit 6
#define NOT_WPUEN               OPTION_REGbits.NOT_WPUEN        // bit 7

#define SCS0                    OSCCONbits.SCS0                 // bit 0
#define SCS1                    OSCCONbits.SCS1                 // bit 1
#define IRCF0                   OSCCONbits.IRCF0                // bit 3
#define IRCF1                   OSCCONbits.IRCF1                // bit 4
#define IRCF2                   OSCCONbits.IRCF2                // bit 5
#define IRCF3                   OSCCONbits.IRCF3                // bit 6
#define SPLLEN                  OSCCONbits.SPLLEN               // bit 7

#define HFIOFS                  OSCSTATbits.HFIOFS              // bit 0
#define LFIOFR                  OSCSTATbits.LFIOFR              // bit 1
#define MFIOFR                  OSCSTATbits.MFIOFR              // bit 2
#define HFIOFL                  OSCSTATbits.HFIOFL              // bit 3
#define HFIOFR                  OSCSTATbits.HFIOFR              // bit 4
#define OSTS                    OSCSTATbits.OSTS                // bit 5
#define PLLR                    OSCSTATbits.PLLR                // bit 6
#define SOSCR                   OSCSTATbits.SOSCR               // bit 7

#define TUN0                    OSCTUNEbits.TUN0                // bit 0
#define TUN1                    OSCTUNEbits.TUN1                // bit 1
#define TUN2                    OSCTUNEbits.TUN2                // bit 2
#define TUN3                    OSCTUNEbits.TUN3                // bit 3
#define TUN4                    OSCTUNEbits.TUN4                // bit 4
#define TUN5                    OSCTUNEbits.TUN5                // bit 5

#define NOT_BOR                 PCONbits.NOT_BOR                // bit 0
#define NOT_POR                 PCONbits.NOT_POR                // bit 1
#define NOT_RI                  PCONbits.NOT_RI                 // bit 2
#define NOT_RMCLR               PCONbits.NOT_RMCLR              // bit 3
#define NOT_RWDT                PCONbits.NOT_RWDT               // bit 4
#define STKUNF                  PCONbits.STKUNF                 // bit 6
#define STKOVF                  PCONbits.STKOVF                 // bit 7

#define TMR1IE                  PIE1bits.TMR1IE                 // bit 0
#define TMR2IE                  PIE1bits.TMR2IE                 // bit 1
#define CCP1IE                  PIE1bits.CCP1IE                 // bit 2, shadows bit in PIE1bits
#define CCPIE                   PIE1bits.CCPIE                  // bit 2, shadows bit in PIE1bits
#define SSP1IE                  PIE1bits.SSP1IE                 // bit 3
#define TXIE                    PIE1bits.TXIE                   // bit 4
#define RCIE                    PIE1bits.RCIE                   // bit 5
#define ADIE                    PIE1bits.ADIE                   // bit 6
#define TMR1GIE                 PIE1bits.TMR1GIE                // bit 7

#define BCL1IE                  PIE2bits.BCL1IE                 // bit 3
#define C1IE                    PIE2bits.C1IE                   // bit 5
#define C2IE                    PIE2bits.C2IE                   // bit 6
#define OSFIE                   PIE2bits.OSFIE                  // bit 7

#define CLC1IE                  PIE3bits.CLC1IE                 // bit 0
#define CLC2IE                  PIE3bits.CLC2IE                 // bit 1
#define CLC3IE                  PIE3bits.CLC3IE                 // bit 2
#define ZCDIE                   PIE3bits.ZCDIE                  // bit 4
#define COGIE                   PIE3bits.COGIE                  // bit 5
#define PWM5IE                  PIE3bits.PWM5IE                 // bit 6

#define TMR4IE                  PIE4bits.TMR4IE                 // bit 0
#define TMR6IE                  PIE4bits.TMR6IE                 // bit 1
#define TMR3IE                  PIE4bits.TMR3IE                 // bit 2
#define TMR3GIE                 PIE4bits.TMR3GIE                // bit 3
#define TMR5IE                  PIE4bits.TMR5IE                 // bit 4
#define TMR5GIE                 PIE4bits.TMR5GIE                // bit 5

#define TMR1IF                  PIR1bits.TMR1IF                 // bit 0
#define TMR2IF                  PIR1bits.TMR2IF                 // bit 1
#define CCP1IF                  PIR1bits.CCP1IF                 // bit 2, shadows bit in PIR1bits
#define CCPIF                   PIR1bits.CCPIF                  // bit 2, shadows bit in PIR1bits
#define SSP1IF                  PIR1bits.SSP1IF                 // bit 3
#define TXIF                    PIR1bits.TXIF                   // bit 4
#define RCIF                    PIR1bits.RCIF                   // bit 5
#define ADIF                    PIR1bits.ADIF                   // bit 6
#define TMR1GIF                 PIR1bits.TMR1GIF                // bit 7

#define BCL1IF                  PIR2bits.BCL1IF                 // bit 3
#define C1IF                    PIR2bits.C1IF                   // bit 5
#define C2IF                    PIR2bits.C2IF                   // bit 6
#define OSFIF                   PIR2bits.OSFIF                  // bit 7

#define CLC1IF                  PIR3bits.CLC1IF                 // bit 0
#define CLC2IF                  PIR3bits.CLC2IF                 // bit 1
#define CLC3IF                  PIR3bits.CLC3IF                 // bit 2
#define ZCDIF                   PIR3bits.ZCDIF                  // bit 4
#define COG1IF                  PIR3bits.COG1IF                 // bit 5
#define PWM5IF                  PIR3bits.PWM5IF                 // bit 6

#define TMR4IF                  PIR4bits.TMR4IF                 // bit 0
#define TMR6IF                  PIR4bits.TMR6IF                 // bit 1
#define TMR3IF                  PIR4bits.TMR3IF                 // bit 2
#define TMR3GIF                 PIR4bits.TMR3GIF                // bit 3
#define TMR5IF                  PIR4bits.TMR5IF                 // bit 4
#define TMR5GIF                 PIR4bits.TMR5GIF                // bit 5

#define RD                      PMCON1bits.RD                   // bit 0
#define WR                      PMCON1bits.WR                   // bit 1
#define WREN                    PMCON1bits.WREN                 // bit 2
#define WRERR                   PMCON1bits.WRERR                // bit 3
#define FREE                    PMCON1bits.FREE                 // bit 4
#define LWLO                    PMCON1bits.LWLO                 // bit 5
#define CFGS                    PMCON1bits.CFGS                 // bit 6

#define RA0                     PORTAbits.RA0                   // bit 0
#define RA1                     PORTAbits.RA1                   // bit 1
#define RA2                     PORTAbits.RA2                   // bit 2
#define RA3                     PORTAbits.RA3                   // bit 3
#define RA4                     PORTAbits.RA4                   // bit 4
#define RA5                     PORTAbits.RA5                   // bit 5

#define RC0                     PORTCbits.RC0                   // bit 0
#define RC1                     PORTCbits.RC1                   // bit 1
#define RC2                     PORTCbits.RC2                   // bit 2
#define RC3                     PORTCbits.RC3                   // bit 3
#define RC4                     PORTCbits.RC4                   // bit 4
#define RC5                     PORTCbits.RC5                   // bit 5

#define PPSLOCKED               PPSLOCKbits.PPSLOCKED           // bit 0

#define RPOL                    PRG1CON1bits.RPOL               // bit 0, shadows bit in PRG1CON1bits
#define RG1RPOL                 PRG1CON1bits.RG1RPOL            // bit 0, shadows bit in PRG1CON1bits
#define FPOL                    PRG1CON1bits.FPOL               // bit 1, shadows bit in PRG1CON1bits
#define RG1FPOL                 PRG1CON1bits.RG1FPOL            // bit 1, shadows bit in PRG1CON1bits
#define RDY                     PRG1CON1bits.RDY                // bit 2, shadows bit in PRG1CON1bits
#define RG1RDY                  PRG1CON1bits.RG1RDY             // bit 2, shadows bit in PRG1CON1bits

#define ISET0                   PRG1CON2bits.ISET0              // bit 0, shadows bit in PRG1CON2bits
#define RG1ISET0                PRG1CON2bits.RG1ISET0           // bit 0, shadows bit in PRG1CON2bits
#define ISET1                   PRG1CON2bits.ISET1              // bit 1, shadows bit in PRG1CON2bits
#define RG1ISET1                PRG1CON2bits.RG1ISET1           // bit 1, shadows bit in PRG1CON2bits
#define ISET2                   PRG1CON2bits.ISET2              // bit 2, shadows bit in PRG1CON2bits
#define RG1ISET2                PRG1CON2bits.RG1ISET2           // bit 2, shadows bit in PRG1CON2bits
#define ISET3                   PRG1CON2bits.ISET3              // bit 3, shadows bit in PRG1CON2bits
#define RG1ISET3                PRG1CON2bits.RG1ISET3           // bit 3, shadows bit in PRG1CON2bits
#define ISET4                   PRG1CON2bits.ISET4              // bit 4, shadows bit in PRG1CON2bits
#define RG1ISET4                PRG1CON2bits.RG1ISET4           // bit 4, shadows bit in PRG1CON2bits

#define FTSS0                   PRG1FTSSbits.FTSS0              // bit 0, shadows bit in PRG1FTSSbits
#define RG1FTSS0                PRG1FTSSbits.RG1FTSS0           // bit 0, shadows bit in PRG1FTSSbits
#define FTSS1                   PRG1FTSSbits.FTSS1              // bit 1, shadows bit in PRG1FTSSbits
#define RG1FTSS1                PRG1FTSSbits.RG1FTSS1           // bit 1, shadows bit in PRG1FTSSbits
#define FTSS2                   PRG1FTSSbits.FTSS2              // bit 2, shadows bit in PRG1FTSSbits
#define RG1FTSS2                PRG1FTSSbits.RG1FTSS2           // bit 2, shadows bit in PRG1FTSSbits
#define FTSS3                   PRG1FTSSbits.FTSS3              // bit 3, shadows bit in PRG1FTSSbits
#define RG1FTSS3                PRG1FTSSbits.RG1FTSS3           // bit 3, shadows bit in PRG1FTSSbits

#define INS0                    PRG1INSbits.INS0                // bit 0, shadows bit in PRG1INSbits
#define RG1INS0                 PRG1INSbits.RG1INS0             // bit 0, shadows bit in PRG1INSbits
#define INS1                    PRG1INSbits.INS1                // bit 1, shadows bit in PRG1INSbits
#define RG1INS1                 PRG1INSbits.RG1INS1             // bit 1, shadows bit in PRG1INSbits
#define INS2                    PRG1INSbits.INS2                // bit 2, shadows bit in PRG1INSbits
#define RG1INS2                 PRG1INSbits.RG1INS2             // bit 2, shadows bit in PRG1INSbits
#define INS3                    PRG1INSbits.INS3                // bit 3, shadows bit in PRG1INSbits
#define RG1INS3                 PRG1INSbits.RG1INS3             // bit 3, shadows bit in PRG1INSbits

#define RTSS0                   PRG1RTSSbits.RTSS0              // bit 0, shadows bit in PRG1RTSSbits
#define RG1RTSS0                PRG1RTSSbits.RG1RTSS0           // bit 0, shadows bit in PRG1RTSSbits
#define RTSS1                   PRG1RTSSbits.RTSS1              // bit 1, shadows bit in PRG1RTSSbits
#define RG1RTSS1                PRG1RTSSbits.RG1RTSS1           // bit 1, shadows bit in PRG1RTSSbits
#define RTSS2                   PRG1RTSSbits.RTSS2              // bit 2, shadows bit in PRG1RTSSbits
#define RG1RTSS2                PRG1RTSSbits.RG1RTSS2           // bit 2, shadows bit in PRG1RTSSbits
#define RTSS3                   PRG1RTSSbits.RTSS3              // bit 3, shadows bit in PRG1RTSSbits
#define RG1RTSS3                PRG1RTSSbits.RG1RTSS3           // bit 3, shadows bit in PRG1RTSSbits

#define DC2                     PWM3DCHbits.DC2                 // bit 0, shadows bit in PWM3DCHbits
#define PWM3DC2                 PWM3DCHbits.PWM3DC2             // bit 0, shadows bit in PWM3DCHbits
#define PWMPW2                  PWM3DCHbits.PWMPW2              // bit 0, shadows bit in PWM3DCHbits
#define DC3                     PWM3DCHbits.DC3                 // bit 1, shadows bit in PWM3DCHbits
#define PWM3DC3                 PWM3DCHbits.PWM3DC3             // bit 1, shadows bit in PWM3DCHbits
#define PWMPW3                  PWM3DCHbits.PWMPW3              // bit 1, shadows bit in PWM3DCHbits
#define DC4                     PWM3DCHbits.DC4                 // bit 2, shadows bit in PWM3DCHbits
#define PWM3DC4                 PWM3DCHbits.PWM3DC4             // bit 2, shadows bit in PWM3DCHbits
#define PWMPW4                  PWM3DCHbits.PWMPW4              // bit 2, shadows bit in PWM3DCHbits
#define DC5                     PWM3DCHbits.DC5                 // bit 3, shadows bit in PWM3DCHbits
#define PWM3DC5                 PWM3DCHbits.PWM3DC5             // bit 3, shadows bit in PWM3DCHbits
#define PWMPW5                  PWM3DCHbits.PWMPW5              // bit 3, shadows bit in PWM3DCHbits
#define DC6                     PWM3DCHbits.DC6                 // bit 4, shadows bit in PWM3DCHbits
#define PWM3DC6                 PWM3DCHbits.PWM3DC6             // bit 4, shadows bit in PWM3DCHbits
#define PWMPW6                  PWM3DCHbits.PWMPW6              // bit 4, shadows bit in PWM3DCHbits
#define DC7                     PWM3DCHbits.DC7                 // bit 5, shadows bit in PWM3DCHbits
#define PWM3DC7                 PWM3DCHbits.PWM3DC7             // bit 5, shadows bit in PWM3DCHbits
#define PWMPW7                  PWM3DCHbits.PWMPW7              // bit 5, shadows bit in PWM3DCHbits
#define DC8                     PWM3DCHbits.DC8                 // bit 6, shadows bit in PWM3DCHbits
#define PWM3DC8                 PWM3DCHbits.PWM3DC8             // bit 6, shadows bit in PWM3DCHbits
#define PWMPW8                  PWM3DCHbits.PWMPW8              // bit 6, shadows bit in PWM3DCHbits
#define DC9                     PWM3DCHbits.DC9                 // bit 7, shadows bit in PWM3DCHbits
#define PWM3DC9                 PWM3DCHbits.PWM3DC9             // bit 7, shadows bit in PWM3DCHbits
#define PWMPW9                  PWM3DCHbits.PWMPW9              // bit 7, shadows bit in PWM3DCHbits

#define DC0                     PWM3DCLbits.DC0                 // bit 6, shadows bit in PWM3DCLbits
#define PWM3DC0                 PWM3DCLbits.PWM3DC0             // bit 6, shadows bit in PWM3DCLbits
#define PWMPW0                  PWM3DCLbits.PWMPW0              // bit 6, shadows bit in PWM3DCLbits
#define DC1                     PWM3DCLbits.DC1                 // bit 7, shadows bit in PWM3DCLbits
#define PWM3DC1                 PWM3DCLbits.PWM3DC1             // bit 7, shadows bit in PWM3DCLbits
#define PWMPW1                  PWM3DCLbits.PWMPW1              // bit 7, shadows bit in PWM3DCLbits

#define PWM5DCH0                PWM5DCHbits.PWM5DCH0            // bit 0
#define PWM5DCH1                PWM5DCHbits.PWM5DCH1            // bit 1
#define PWM5DCH2                PWM5DCHbits.PWM5DCH2            // bit 2
#define PWM5DCH3                PWM5DCHbits.PWM5DCH3            // bit 3
#define PWM5DCH4                PWM5DCHbits.PWM5DCH4            // bit 4
#define PWM5DCH5                PWM5DCHbits.PWM5DCH5            // bit 5
#define PWM5DCH6                PWM5DCHbits.PWM5DCH6            // bit 6
#define PWM5DCH7                PWM5DCHbits.PWM5DCH7            // bit 7

#define PWM5DCL0                PWM5DCLbits.PWM5DCL0            // bit 0
#define PWM5DCL1                PWM5DCLbits.PWM5DCL1            // bit 1
#define PWM5DCL2                PWM5DCLbits.PWM5DCL2            // bit 2
#define PWM5DCL3                PWM5DCLbits.PWM5DCL3            // bit 3
#define PWM5DCL4                PWM5DCLbits.PWM5DCL4            // bit 4
#define PWM5DCL5                PWM5DCLbits.PWM5DCL5            // bit 5
#define PWM5DCL6                PWM5DCLbits.PWM5DCL6            // bit 6
#define PWM5DCL7                PWM5DCLbits.PWM5DCL7            // bit 7

#define PRIE                    PWM5INTCONbits.PRIE             // bit 0, shadows bit in PWM5INTCONbits
#define PWM5PRIE                PWM5INTCONbits.PWM5PRIE         // bit 0, shadows bit in PWM5INTCONbits
#define DCIE                    PWM5INTCONbits.DCIE             // bit 1, shadows bit in PWM5INTCONbits
#define PWM5DCIE                PWM5INTCONbits.PWM5DCIE         // bit 1, shadows bit in PWM5INTCONbits
#define PHIE                    PWM5INTCONbits.PHIE             // bit 2, shadows bit in PWM5INTCONbits
#define PWM5PHIE                PWM5INTCONbits.PWM5PHIE         // bit 2, shadows bit in PWM5INTCONbits
#define OFIE                    PWM5INTCONbits.OFIE             // bit 3, shadows bit in PWM5INTCONbits
#define PWM5OFIE                PWM5INTCONbits.PWM5OFIE         // bit 3, shadows bit in PWM5INTCONbits

#define PRIF                    PWM5INTFbits.PRIF               // bit 0, shadows bit in PWM5INTFbits
#define PWM5PRIF                PWM5INTFbits.PWM5PRIF           // bit 0, shadows bit in PWM5INTFbits
#define DCIF                    PWM5INTFbits.DCIF               // bit 1, shadows bit in PWM5INTFbits
#define PWM5DCIF                PWM5INTFbits.PWM5DCIF           // bit 1, shadows bit in PWM5INTFbits
#define PHIF                    PWM5INTFbits.PHIF               // bit 2, shadows bit in PWM5INTFbits
#define PWM5PHIF                PWM5INTFbits.PWM5PHIF           // bit 2, shadows bit in PWM5INTFbits
#define OFIF                    PWM5INTFbits.OFIF               // bit 3, shadows bit in PWM5INTFbits
#define PWM5OFIF                PWM5INTFbits.PWM5OFIF           // bit 3, shadows bit in PWM5INTFbits

#define LDA                     PWM5LDCONbits.LDA               // bit 7, shadows bit in PWM5LDCONbits
#define PWM5LD                  PWM5LDCONbits.PWM5LD            // bit 7, shadows bit in PWM5LDCONbits

#define OFO                     PWM5OFCONbits.OFO               // bit 4, shadows bit in PWM5OFCONbits
#define PWM5OFMC                PWM5OFCONbits.PWM5OFMC          // bit 4, shadows bit in PWM5OFCONbits

#define PWM5OFH0                PWM5OFHbits.PWM5OFH0            // bit 0
#define PWM5OFH1                PWM5OFHbits.PWM5OFH1            // bit 1
#define PWM5OFH2                PWM5OFHbits.PWM5OFH2            // bit 2
#define PWM5OFH3                PWM5OFHbits.PWM5OFH3            // bit 3
#define PWM5OFH4                PWM5OFHbits.PWM5OFH4            // bit 4
#define PWM5OFH5                PWM5OFHbits.PWM5OFH5            // bit 5
#define PWM5OFH6                PWM5OFHbits.PWM5OFH6            // bit 6
#define PWM5OFH7                PWM5OFHbits.PWM5OFH7            // bit 7

#define PWM5OFL0                PWM5OFLbits.PWM5OFL0            // bit 0
#define PWM5OFL1                PWM5OFLbits.PWM5OFL1            // bit 1
#define PWM5OFL2                PWM5OFLbits.PWM5OFL2            // bit 2
#define PWM5OFL3                PWM5OFLbits.PWM5OFL3            // bit 3
#define PWM5OFL4                PWM5OFLbits.PWM5OFL4            // bit 4
#define PWM5OFL5                PWM5OFLbits.PWM5OFL5            // bit 5
#define PWM5OFL6                PWM5OFLbits.PWM5OFL6            // bit 6
#define PWM5OFL7                PWM5OFLbits.PWM5OFL7            // bit 7

#define PWM5PHH0                PWM5PHHbits.PWM5PHH0            // bit 0
#define PWM5PHH1                PWM5PHHbits.PWM5PHH1            // bit 1
#define PWM5PHH2                PWM5PHHbits.PWM5PHH2            // bit 2
#define PWM5PHH3                PWM5PHHbits.PWM5PHH3            // bit 3
#define PWM5PHH4                PWM5PHHbits.PWM5PHH4            // bit 4
#define PWM5PHH5                PWM5PHHbits.PWM5PHH5            // bit 5
#define PWM5PHH6                PWM5PHHbits.PWM5PHH6            // bit 6
#define PWM5PHH7                PWM5PHHbits.PWM5PHH7            // bit 7

#define PWM5PHL0                PWM5PHLbits.PWM5PHL0            // bit 0
#define PWM5PHL1                PWM5PHLbits.PWM5PHL1            // bit 1
#define PWM5PHL2                PWM5PHLbits.PWM5PHL2            // bit 2
#define PWM5PHL3                PWM5PHLbits.PWM5PHL3            // bit 3
#define PWM5PHL4                PWM5PHLbits.PWM5PHL4            // bit 4
#define PWM5PHL5                PWM5PHLbits.PWM5PHL5            // bit 5
#define PWM5PHL6                PWM5PHLbits.PWM5PHL6            // bit 6
#define PWM5PHL7                PWM5PHLbits.PWM5PHL7            // bit 7

#define PWM5PRH0                PWM5PRHbits.PWM5PRH0            // bit 0
#define PWM5PRH1                PWM5PRHbits.PWM5PRH1            // bit 1
#define PWM5PRH2                PWM5PRHbits.PWM5PRH2            // bit 2
#define PWM5PRH3                PWM5PRHbits.PWM5PRH3            // bit 3
#define PWM5PRH4                PWM5PRHbits.PWM5PRH4            // bit 4
#define PWM5PRH5                PWM5PRHbits.PWM5PRH5            // bit 5
#define PWM5PRH6                PWM5PRHbits.PWM5PRH6            // bit 6
#define PWM5PRH7                PWM5PRHbits.PWM5PRH7            // bit 7

#define PWM5PRL0                PWM5PRLbits.PWM5PRL0            // bit 0
#define PWM5PRL1                PWM5PRLbits.PWM5PRL1            // bit 1
#define PWM5PRL2                PWM5PRLbits.PWM5PRL2            // bit 2
#define PWM5PRL3                PWM5PRLbits.PWM5PRL3            // bit 3
#define PWM5PRL4                PWM5PRLbits.PWM5PRL4            // bit 4
#define PWM5PRL5                PWM5PRLbits.PWM5PRL5            // bit 5
#define PWM5PRL6                PWM5PRLbits.PWM5PRL6            // bit 6
#define PWM5PRL7                PWM5PRLbits.PWM5PRL7            // bit 7

#define PWM5TMRH0               PWM5TMRHbits.PWM5TMRH0          // bit 0
#define PWM5TMRH1               PWM5TMRHbits.PWM5TMRH1          // bit 1
#define PWM5TMRH2               PWM5TMRHbits.PWM5TMRH2          // bit 2
#define PWM5TMRH3               PWM5TMRHbits.PWM5TMRH3          // bit 3
#define PWM5TMRH4               PWM5TMRHbits.PWM5TMRH4          // bit 4
#define PWM5TMRH5               PWM5TMRHbits.PWM5TMRH5          // bit 5
#define PWM5TMRH6               PWM5TMRHbits.PWM5TMRH6          // bit 6
#define PWM5TMRH7               PWM5TMRHbits.PWM5TMRH7          // bit 7

#define PWM5TMRL0               PWM5TMRLbits.PWM5TMRL0          // bit 0
#define PWM5TMRL1               PWM5TMRLbits.PWM5TMRL1          // bit 1
#define PWM5TMRL2               PWM5TMRLbits.PWM5TMRL2          // bit 2
#define PWM5TMRL3               PWM5TMRLbits.PWM5TMRL3          // bit 3
#define PWM5TMRL4               PWM5TMRLbits.PWM5TMRL4          // bit 4
#define PWM5TMRL5               PWM5TMRLbits.PWM5TMRL5          // bit 5
#define PWM5TMRL6               PWM5TMRLbits.PWM5TMRL6          // bit 6
#define PWM5TMRL7               PWM5TMRLbits.PWM5TMRL7          // bit 7

#define MPWM5EN                 PWMENbits.MPWM5EN               // bit 4

#define MPWM5LD                 PWMLDbits.MPWM5LD               // bit 4

#define MPWM5OUT                PWMOUTbits.MPWM5OUT             // bit 4

#define RX9D                    RC1STAbits.RX9D                 // bit 0
#define OERR                    RC1STAbits.OERR                 // bit 1
#define FERR                    RC1STAbits.FERR                 // bit 2
#define ADDEN                   RC1STAbits.ADDEN                // bit 3
#define CREN                    RC1STAbits.CREN                 // bit 4
#define SREN                    RC1STAbits.SREN                 // bit 5
#define RX9                     RC1STAbits.RX9                  // bit 6
#define SPEN                    RC1STAbits.SPEN                 // bit 7

#define SLRA0                   SLRCONAbits.SLRA0               // bit 0
#define SLRA1                   SLRCONAbits.SLRA1               // bit 1
#define SLRA2                   SLRCONAbits.SLRA2               // bit 2
#define SLRA4                   SLRCONAbits.SLRA4               // bit 4
#define SLRA5                   SLRCONAbits.SLRA5               // bit 5

#define SLRC0                   SLRCONCbits.SLRC0               // bit 0
#define SLRC1                   SLRCONCbits.SLRC1               // bit 1
#define SLRC2                   SLRCONCbits.SLRC2               // bit 2
#define SLRC3                   SLRCONCbits.SLRC3               // bit 3
#define SLRC4                   SLRCONCbits.SLRC4               // bit 4
#define SLRC5                   SLRCONCbits.SLRC5               // bit 5

#define SSP1ADD0                SSP1ADDbits.SSP1ADD0            // bit 0, shadows bit in SSP1ADDbits
#define ADD0                    SSP1ADDbits.ADD0                // bit 0, shadows bit in SSP1ADDbits
#define SSP1ADD1                SSP1ADDbits.SSP1ADD1            // bit 1, shadows bit in SSP1ADDbits
#define ADD1                    SSP1ADDbits.ADD1                // bit 1, shadows bit in SSP1ADDbits
#define SSP1ADD2                SSP1ADDbits.SSP1ADD2            // bit 2, shadows bit in SSP1ADDbits
#define ADD2                    SSP1ADDbits.ADD2                // bit 2, shadows bit in SSP1ADDbits
#define SSP1ADD3                SSP1ADDbits.SSP1ADD3            // bit 3, shadows bit in SSP1ADDbits
#define ADD3                    SSP1ADDbits.ADD3                // bit 3, shadows bit in SSP1ADDbits
#define SSP1ADD4                SSP1ADDbits.SSP1ADD4            // bit 4, shadows bit in SSP1ADDbits
#define ADD4                    SSP1ADDbits.ADD4                // bit 4, shadows bit in SSP1ADDbits
#define SSP1ADD5                SSP1ADDbits.SSP1ADD5            // bit 5, shadows bit in SSP1ADDbits
#define ADD5                    SSP1ADDbits.ADD5                // bit 5, shadows bit in SSP1ADDbits
#define SSP1ADD6                SSP1ADDbits.SSP1ADD6            // bit 6, shadows bit in SSP1ADDbits
#define ADD6                    SSP1ADDbits.ADD6                // bit 6, shadows bit in SSP1ADDbits
#define SSP1ADD7                SSP1ADDbits.SSP1ADD7            // bit 7, shadows bit in SSP1ADDbits
#define ADD7                    SSP1ADDbits.ADD7                // bit 7, shadows bit in SSP1ADDbits

#define SSP1BUF0                SSP1BUFbits.SSP1BUF0            // bit 0, shadows bit in SSP1BUFbits
#define BUF0                    SSP1BUFbits.BUF0                // bit 0, shadows bit in SSP1BUFbits
#define SSP1BUF1                SSP1BUFbits.SSP1BUF1            // bit 1, shadows bit in SSP1BUFbits
#define BUF1                    SSP1BUFbits.BUF1                // bit 1, shadows bit in SSP1BUFbits
#define SSP1BUF2                SSP1BUFbits.SSP1BUF2            // bit 2, shadows bit in SSP1BUFbits
#define BUF2                    SSP1BUFbits.BUF2                // bit 2, shadows bit in SSP1BUFbits
#define SSP1BUF3                SSP1BUFbits.SSP1BUF3            // bit 3, shadows bit in SSP1BUFbits
#define BUF3                    SSP1BUFbits.BUF3                // bit 3, shadows bit in SSP1BUFbits
#define SSP1BUF4                SSP1BUFbits.SSP1BUF4            // bit 4, shadows bit in SSP1BUFbits
#define BUF4                    SSP1BUFbits.BUF4                // bit 4, shadows bit in SSP1BUFbits
#define SSP1BUF5                SSP1BUFbits.SSP1BUF5            // bit 5, shadows bit in SSP1BUFbits
#define BUF5                    SSP1BUFbits.BUF5                // bit 5, shadows bit in SSP1BUFbits
#define SSP1BUF6                SSP1BUFbits.SSP1BUF6            // bit 6, shadows bit in SSP1BUFbits
#define BUF6                    SSP1BUFbits.BUF6                // bit 6, shadows bit in SSP1BUFbits
#define SSP1BUF7                SSP1BUFbits.SSP1BUF7            // bit 7, shadows bit in SSP1BUFbits
#define BUF7                    SSP1BUFbits.BUF7                // bit 7, shadows bit in SSP1BUFbits

#define SSPM0                   SSP1CONbits.SSPM0               // bit 0
#define SSPM1                   SSP1CONbits.SSPM1               // bit 1
#define SSPM2                   SSP1CONbits.SSPM2               // bit 2
#define SSPM3                   SSP1CONbits.SSPM3               // bit 3
#define CKP                     SSP1CONbits.CKP                 // bit 4
#define SSPEN                   SSP1CONbits.SSPEN               // bit 5
#define SSPOV                   SSP1CONbits.SSPOV               // bit 6
#define WCOL                    SSP1CONbits.WCOL                // bit 7

#define SEN                     SSP1CON2bits.SEN                // bit 0
#define RSEN                    SSP1CON2bits.RSEN               // bit 1
#define PEN                     SSP1CON2bits.PEN                // bit 2
#define RCEN                    SSP1CON2bits.RCEN               // bit 3
#define ACKEN                   SSP1CON2bits.ACKEN              // bit 4
#define ACKDT                   SSP1CON2bits.ACKDT              // bit 5
#define ACKSTAT                 SSP1CON2bits.ACKSTAT            // bit 6
#define GCEN                    SSP1CON2bits.GCEN               // bit 7

#define DHEN                    SSP1CON3bits.DHEN               // bit 0
#define AHEN                    SSP1CON3bits.AHEN               // bit 1
#define SBCDE                   SSP1CON3bits.SBCDE              // bit 2
#define SDAHT                   SSP1CON3bits.SDAHT              // bit 3
#define BOEN                    SSP1CON3bits.BOEN               // bit 4
#define SCIE                    SSP1CON3bits.SCIE               // bit 5
#define PCIE                    SSP1CON3bits.PCIE               // bit 6
#define ACKTIM                  SSP1CON3bits.ACKTIM             // bit 7

#define SSP1MSK0                SSP1MSKbits.SSP1MSK0            // bit 0, shadows bit in SSP1MSKbits
#define MSK0                    SSP1MSKbits.MSK0                // bit 0, shadows bit in SSP1MSKbits
#define SSP1MSK1                SSP1MSKbits.SSP1MSK1            // bit 1, shadows bit in SSP1MSKbits
#define MSK1                    SSP1MSKbits.MSK1                // bit 1, shadows bit in SSP1MSKbits
#define SSP1MSK2                SSP1MSKbits.SSP1MSK2            // bit 2, shadows bit in SSP1MSKbits
#define MSK2                    SSP1MSKbits.MSK2                // bit 2, shadows bit in SSP1MSKbits
#define SSP1MSK3                SSP1MSKbits.SSP1MSK3            // bit 3, shadows bit in SSP1MSKbits
#define MSK3                    SSP1MSKbits.MSK3                // bit 3, shadows bit in SSP1MSKbits
#define SSP1MSK4                SSP1MSKbits.SSP1MSK4            // bit 4, shadows bit in SSP1MSKbits
#define MSK4                    SSP1MSKbits.MSK4                // bit 4, shadows bit in SSP1MSKbits
#define SSP1MSK5                SSP1MSKbits.SSP1MSK5            // bit 5, shadows bit in SSP1MSKbits
#define MSK5                    SSP1MSKbits.MSK5                // bit 5, shadows bit in SSP1MSKbits
#define SSP1MSK6                SSP1MSKbits.SSP1MSK6            // bit 6, shadows bit in SSP1MSKbits
#define MSK6                    SSP1MSKbits.MSK6                // bit 6, shadows bit in SSP1MSKbits
#define SSP1MSK7                SSP1MSKbits.SSP1MSK7            // bit 7, shadows bit in SSP1MSKbits
#define MSK7                    SSP1MSKbits.MSK7                // bit 7, shadows bit in SSP1MSKbits

#define BF                      SSP1STATbits.BF                 // bit 0
#define UA                      SSP1STATbits.UA                 // bit 1
#define R_NOT_W                 SSP1STATbits.R_NOT_W            // bit 2
#define S                       SSP1STATbits.S                  // bit 3
#define P                       SSP1STATbits.P                  // bit 4
#define D_NOT_A                 SSP1STATbits.D_NOT_A            // bit 5
#define CKE                     SSP1STATbits.CKE                // bit 6
#define SMP                     SSP1STATbits.SMP                // bit 7

#define C                       STATUSbits.C                    // bit 0
#define DC                      STATUSbits.DC                   // bit 1
#define Z                       STATUSbits.Z                    // bit 2
#define NOT_PD                  STATUSbits.NOT_PD               // bit 3
#define NOT_TO                  STATUSbits.NOT_TO               // bit 4

#define C_SHAD                  STATUS_SHADbits.C_SHAD          // bit 0
#define DC_SHAD                 STATUS_SHADbits.DC_SHAD         // bit 1
#define Z_SHAD                  STATUS_SHADbits.Z_SHAD          // bit 2

#define GSS0                    T1GCONbits.GSS0                 // bit 0, shadows bit in T1GCONbits
#define T1GSS0                  T1GCONbits.T1GSS0               // bit 0, shadows bit in T1GCONbits
#define GSS1                    T1GCONbits.GSS1                 // bit 1, shadows bit in T1GCONbits
#define T1GSS1                  T1GCONbits.T1GSS1               // bit 1, shadows bit in T1GCONbits
#define GVAL                    T1GCONbits.GVAL                 // bit 2, shadows bit in T1GCONbits
#define T1GVAL                  T1GCONbits.T1GVAL               // bit 2, shadows bit in T1GCONbits
#define GGO_NOT_DONE            T1GCONbits.GGO_NOT_DONE         // bit 3, shadows bit in T1GCONbits
#define T1GGO_NOT_DONE          T1GCONbits.T1GGO_NOT_DONE       // bit 3, shadows bit in T1GCONbits
#define GSPM                    T1GCONbits.GSPM                 // bit 4, shadows bit in T1GCONbits
#define T1GSPM                  T1GCONbits.T1GSPM               // bit 4, shadows bit in T1GCONbits
#define GTM                     T1GCONbits.GTM                  // bit 5, shadows bit in T1GCONbits
#define T1GTM                   T1GCONbits.T1GTM                // bit 5, shadows bit in T1GCONbits
#define GPOL                    T1GCONbits.GPOL                 // bit 6, shadows bit in T1GCONbits
#define T1GPOL                  T1GCONbits.T1GPOL               // bit 6, shadows bit in T1GCONbits
#define GE                      T1GCONbits.GE                   // bit 7, shadows bit in T1GCONbits
#define T1GE                    T1GCONbits.T1GE                 // bit 7, shadows bit in T1GCONbits
#define TMR1GE                  T1GCONbits.TMR1GE               // bit 7, shadows bit in T1GCONbits

#define RSEL0                   T2RSTbits.RSEL0                 // bit 0, shadows bit in T2RSTbits
#define T2RSEL0                 T2RSTbits.T2RSEL0               // bit 0, shadows bit in T2RSTbits
#define RSEL1                   T2RSTbits.RSEL1                 // bit 1, shadows bit in T2RSTbits
#define T2RSEL1                 T2RSTbits.T2RSEL1               // bit 1, shadows bit in T2RSTbits
#define RSEL2                   T2RSTbits.RSEL2                 // bit 2, shadows bit in T2RSTbits
#define T2RSEL2                 T2RSTbits.T2RSEL2               // bit 2, shadows bit in T2RSTbits
#define RSEL3                   T2RSTbits.RSEL3                 // bit 3, shadows bit in T2RSTbits
#define T2RSEL3                 T2RSTbits.T2RSEL3               // bit 3, shadows bit in T2RSTbits

#define TRISA0                  TRISAbits.TRISA0                // bit 0
#define TRISA1                  TRISAbits.TRISA1                // bit 1
#define TRISA2                  TRISAbits.TRISA2                // bit 2
#define TRISA4                  TRISAbits.TRISA4                // bit 4
#define TRISA5                  TRISAbits.TRISA5                // bit 5

#define TRISC0                  TRISCbits.TRISC0                // bit 0
#define TRISC1                  TRISCbits.TRISC1                // bit 1
#define TRISC2                  TRISCbits.TRISC2                // bit 2
#define TRISC3                  TRISCbits.TRISC3                // bit 3
#define TRISC4                  TRISCbits.TRISC4                // bit 4
#define TRISC5                  TRISCbits.TRISC5                // bit 5

#define SWDTEN                  WDTCONbits.SWDTEN               // bit 0
#define WDTPS0                  WDTCONbits.WDTPS0               // bit 1
#define WDTPS1                  WDTCONbits.WDTPS1               // bit 2
#define WDTPS2                  WDTCONbits.WDTPS2               // bit 3
#define WDTPS3                  WDTCONbits.WDTPS3               // bit 4
#define WDTPS4                  WDTCONbits.WDTPS4               // bit 5

#define WPUA0                   WPUAbits.WPUA0                  // bit 0
#define WPUA1                   WPUAbits.WPUA1                  // bit 1
#define WPUA2                   WPUAbits.WPUA2                  // bit 2
#define WPUA3                   WPUAbits.WPUA3                  // bit 3
#define WPUA4                   WPUAbits.WPUA4                  // bit 4
#define WPUA5                   WPUAbits.WPUA5                  // bit 5

#define WPUC0                   WPUCbits.WPUC0                  // bit 0
#define WPUC1                   WPUCbits.WPUC1                  // bit 1
#define WPUC2                   WPUCbits.WPUC2                  // bit 2
#define WPUC3                   WPUCbits.WPUC3                  // bit 3
#define WPUC4                   WPUCbits.WPUC4                  // bit 4
#define WPUC5                   WPUCbits.WPUC5                  // bit 5

#define ZCD1INTN                ZCD1CONbits.ZCD1INTN            // bit 0
#define ZCD1INTP                ZCD1CONbits.ZCD1INTP            // bit 1
#define ZCD1POL                 ZCD1CONbits.ZCD1POL             // bit 4
#define ZCD1OUT                 ZCD1CONbits.ZCD1OUT             // bit 5
#define ZCD1EN                  ZCD1CONbits.ZCD1EN              // bit 7

#endif // #ifndef NO_BIT_DEFINES

#endif // #ifndef __PIC16F1764_H__
