# sage_setup: distribution = sagemath-flint
# distutils: libraries = flint
# distutils: depends = flint/mag.h

################################################################################
# This file is auto-generated by the script
#   SAGE_ROOT/src/sage_setup/autogen/flint_autogen.py.
# From the commit 3e2c3a3e091106a25ca9c6fba28e02f2cbcd654a
# Do not modify by hand! Fix and rerun the script instead.
################################################################################

from libc.stdio cimport FILE
from sage.libs.gmp.types cimport *
from sage.libs.mpfr.types cimport *
from sage.libs.flint.types cimport *

cdef extern from "flint_wrap.h":
    void mag_init(mag_t x) noexcept
    void mag_clear(mag_t x) noexcept
    void mag_swap(mag_t x, mag_t y) noexcept
    mag_ptr _mag_vec_init(slong n) noexcept
    void _mag_vec_clear(mag_ptr v, slong n) noexcept
    slong mag_allocated_bytes(const mag_t x) noexcept
    void mag_zero(mag_t res) noexcept
    void mag_one(mag_t res) noexcept
    void mag_inf(mag_t res) noexcept
    bint mag_is_special(const mag_t x) noexcept
    bint mag_is_zero(const mag_t x) noexcept
    bint mag_is_inf(const mag_t x) noexcept
    bint mag_is_finite(const mag_t x) noexcept
    void mag_init_set(mag_t res, const mag_t x) noexcept
    void mag_set(mag_t res, const mag_t x) noexcept
    void mag_set_d(mag_t res, double x) noexcept
    void mag_set_ui(mag_t res, ulong x) noexcept
    void mag_set_fmpz(mag_t res, const fmpz_t x) noexcept
    void mag_set_d_lower(mag_t res, double x) noexcept
    void mag_set_ui_lower(mag_t res, ulong x) noexcept
    void mag_set_fmpz_lower(mag_t res, const fmpz_t x) noexcept
    void mag_set_d_2exp_fmpz(mag_t res, double x, const fmpz_t y) noexcept
    void mag_set_fmpz_2exp_fmpz(mag_t res, const fmpz_t x, const fmpz_t y) noexcept
    void mag_set_ui_2exp_si(mag_t res, ulong x, slong y) noexcept
    void mag_set_d_2exp_fmpz_lower(mag_t res, double x, const fmpz_t y) noexcept
    void mag_set_fmpz_2exp_fmpz_lower(mag_t res, const fmpz_t x, const fmpz_t y) noexcept
    double mag_get_d(const mag_t x) noexcept
    double mag_get_d_log2_approx(const mag_t x) noexcept
    void mag_get_fmpq(fmpq_t res, const mag_t x) noexcept
    void mag_get_fmpz(fmpz_t res, const mag_t x) noexcept
    void mag_get_fmpz_lower(fmpz_t res, const mag_t x) noexcept
    bint mag_equal(const mag_t x, const mag_t y) noexcept
    int mag_cmp(const mag_t x, const mag_t y) noexcept
    int mag_cmp_2exp_si(const mag_t x, slong y) noexcept
    void mag_min(mag_t res, const mag_t x, const mag_t y) noexcept
    void mag_max(mag_t res, const mag_t x, const mag_t y) noexcept
    void mag_print(const mag_t x) noexcept
    void mag_fprint(FILE * file, const mag_t x) noexcept
    char * mag_dump_str(const mag_t x) noexcept
    int mag_load_str(mag_t x, const char * str) noexcept
    int mag_dump_file(FILE * stream, const mag_t x) noexcept
    int mag_load_file(mag_t x, FILE * stream) noexcept
    void mag_randtest(mag_t res, flint_rand_t state, slong expbits) noexcept
    void mag_randtest_special(mag_t res, flint_rand_t state, slong expbits) noexcept
    void mag_add(mag_t res, const mag_t x, const mag_t y) noexcept
    void mag_add_ui(mag_t res, const mag_t x, ulong y) noexcept
    void mag_add_lower(mag_t res, const mag_t x, const mag_t y) noexcept
    void mag_add_ui_lower(mag_t res, const mag_t x, ulong y) noexcept
    void mag_add_2exp_fmpz(mag_t res, const mag_t x, const fmpz_t e) noexcept
    void mag_add_ui_2exp_si(mag_t res, const mag_t x, ulong y, slong e) noexcept
    void mag_sub(mag_t res, const mag_t x, const mag_t y) noexcept
    void mag_sub_lower(mag_t res, const mag_t x, const mag_t y) noexcept
    void mag_mul_2exp_si(mag_t res, const mag_t x, slong y) noexcept
    void mag_mul_2exp_fmpz(mag_t res, const mag_t x, const fmpz_t y) noexcept
    void mag_mul(mag_t res, const mag_t x, const mag_t y) noexcept
    void mag_mul_ui(mag_t res, const mag_t x, ulong y) noexcept
    void mag_mul_fmpz(mag_t res, const mag_t x, const fmpz_t y) noexcept
    void mag_mul_lower(mag_t res, const mag_t x, const mag_t y) noexcept
    void mag_mul_ui_lower(mag_t res, const mag_t x, ulong y) noexcept
    void mag_mul_fmpz_lower(mag_t res, const mag_t x, const fmpz_t y) noexcept
    void mag_addmul(mag_t z, const mag_t x, const mag_t y) noexcept
    void mag_div(mag_t res, const mag_t x, const mag_t y) noexcept
    void mag_div_ui(mag_t res, const mag_t x, ulong y) noexcept
    void mag_div_fmpz(mag_t res, const mag_t x, const fmpz_t y) noexcept
    void mag_div_lower(mag_t res, const mag_t x, const mag_t y) noexcept
    void mag_inv(mag_t res, const mag_t x) noexcept
    void mag_inv_lower(mag_t res, const mag_t x) noexcept
    void mag_fast_init_set(mag_t x, const mag_t y) noexcept
    void mag_fast_zero(mag_t res) noexcept
    bint mag_fast_is_zero(const mag_t x) noexcept
    void mag_fast_mul(mag_t res, const mag_t x, const mag_t y) noexcept
    void mag_fast_addmul(mag_t z, const mag_t x, const mag_t y) noexcept
    void mag_fast_add_2exp_si(mag_t res, const mag_t x, slong e) noexcept
    void mag_fast_mul_2exp_si(mag_t res, const mag_t x, slong e) noexcept
    void mag_pow_ui(mag_t res, const mag_t x, ulong e) noexcept
    void mag_pow_fmpz(mag_t res, const mag_t x, const fmpz_t e) noexcept
    void mag_pow_ui_lower(mag_t res, const mag_t x, ulong e) noexcept
    void mag_pow_fmpz_lower(mag_t res, const mag_t x, const fmpz_t e) noexcept
    void mag_sqrt(mag_t res, const mag_t x) noexcept
    void mag_sqrt_lower(mag_t res, const mag_t x) noexcept
    void mag_rsqrt(mag_t res, const mag_t x) noexcept
    void mag_rsqrt_lower(mag_t res, const mag_t x) noexcept
    void mag_hypot(mag_t res, const mag_t x, const mag_t y) noexcept
    void mag_root(mag_t res, const mag_t x, ulong n) noexcept
    void mag_log(mag_t res, const mag_t x) noexcept
    void mag_log_lower(mag_t res, const mag_t x) noexcept
    void mag_neg_log(mag_t res, const mag_t x) noexcept
    void mag_neg_log_lower(mag_t res, const mag_t x) noexcept
    void mag_log_ui(mag_t res, ulong n) noexcept
    void mag_log1p(mag_t res, const mag_t x) noexcept
    void mag_exp(mag_t res, const mag_t x) noexcept
    void mag_exp_lower(mag_t res, const mag_t x) noexcept
    void mag_expinv(mag_t res, const mag_t x) noexcept
    void mag_expinv_lower(mag_t res, const mag_t x) noexcept
    void mag_expm1(mag_t res, const mag_t x) noexcept
    void mag_exp_tail(mag_t res, const mag_t x, ulong N) noexcept
    void mag_binpow_uiui(mag_t res, ulong m, ulong n) noexcept
    void mag_geom_series(mag_t res, const mag_t x, ulong N) noexcept
    void mag_const_pi(mag_t res) noexcept
    void mag_const_pi_lower(mag_t res) noexcept
    void mag_atan(mag_t res, const mag_t x) noexcept
    void mag_atan_lower(mag_t res, const mag_t x) noexcept
    void mag_cosh(mag_t res, const mag_t x) noexcept
    void mag_cosh_lower(mag_t res, const mag_t x) noexcept
    void mag_sinh(mag_t res, const mag_t x) noexcept
    void mag_sinh_lower(mag_t res, const mag_t x) noexcept
    void mag_fac_ui(mag_t res, ulong n) noexcept
    void mag_rfac_ui(mag_t res, ulong n) noexcept
    void mag_bin_uiui(mag_t res, ulong n, ulong k) noexcept
    void mag_bernoulli_div_fac_ui(mag_t res, ulong n) noexcept
    void mag_polylog_tail(mag_t res, const mag_t z, slong s, ulong d, ulong N) noexcept
    void mag_hurwitz_zeta_uiui(mag_t res, ulong s, ulong a) noexcept

from .mag_macros cimport *
