/* Copyright 2022 - 2025 R. Thomas
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef LIEF_ASM_RISCV_REGISTER_H
#define LIEF_ASM_RISCV_REGISTER_H
namespace LIEF {
namespace assembly {
namespace riscv {
enum class REG;
const char* get_register_name(REG r);

enum class REG {
  NoRegister = 0,
  FCSR = 1,
  FFLAGS = 2,
  FRM = 3,
  SF_VCIX_STATE = 4,
  SSP = 5,
  VL = 6,
  VLENB = 7,
  VTYPE = 8,
  VXRM = 9,
  VXSAT = 10,
  DUMMY_REG_PAIR_WITH_X0 = 11,
  T0 = 12,
  T1 = 13,
  T2 = 14,
  T3 = 15,
  T4 = 16,
  T5 = 17,
  T6 = 18,
  T7 = 19,
  T8 = 20,
  T9 = 21,
  T10 = 22,
  T11 = 23,
  T12 = 24,
  T13 = 25,
  T14 = 26,
  T15 = 27,
  V0 = 28,
  V1 = 29,
  V2 = 30,
  V3 = 31,
  V4 = 32,
  V5 = 33,
  V6 = 34,
  V7 = 35,
  V8 = 36,
  V9 = 37,
  V10 = 38,
  V11 = 39,
  V12 = 40,
  V13 = 41,
  V14 = 42,
  V15 = 43,
  V16 = 44,
  V17 = 45,
  V18 = 46,
  V19 = 47,
  V20 = 48,
  V21 = 49,
  V22 = 50,
  V23 = 51,
  V24 = 52,
  V25 = 53,
  V26 = 54,
  V27 = 55,
  V28 = 56,
  V29 = 57,
  V30 = 58,
  V31 = 59,
  X0 = 60,
  X1 = 61,
  X2 = 62,
  X3 = 63,
  X4 = 64,
  X5 = 65,
  X6 = 66,
  X7 = 67,
  X8 = 68,
  X9 = 69,
  X10 = 70,
  X11 = 71,
  X12 = 72,
  X13 = 73,
  X14 = 74,
  X15 = 75,
  X16 = 76,
  X17 = 77,
  X18 = 78,
  X19 = 79,
  X20 = 80,
  X21 = 81,
  X22 = 82,
  X23 = 83,
  X24 = 84,
  X25 = 85,
  X26 = 86,
  X27 = 87,
  X28 = 88,
  X29 = 89,
  X30 = 90,
  X31 = 91,
  F0_D = 92,
  F1_D = 93,
  F2_D = 94,
  F3_D = 95,
  F4_D = 96,
  F5_D = 97,
  F6_D = 98,
  F7_D = 99,
  F8_D = 100,
  F9_D = 101,
  F10_D = 102,
  F11_D = 103,
  F12_D = 104,
  F13_D = 105,
  F14_D = 106,
  F15_D = 107,
  F16_D = 108,
  F17_D = 109,
  F18_D = 110,
  F19_D = 111,
  F20_D = 112,
  F21_D = 113,
  F22_D = 114,
  F23_D = 115,
  F24_D = 116,
  F25_D = 117,
  F26_D = 118,
  F27_D = 119,
  F28_D = 120,
  F29_D = 121,
  F30_D = 122,
  F31_D = 123,
  F0_F = 124,
  F1_F = 125,
  F2_F = 126,
  F3_F = 127,
  F4_F = 128,
  F5_F = 129,
  F6_F = 130,
  F7_F = 131,
  F8_F = 132,
  F9_F = 133,
  F10_F = 134,
  F11_F = 135,
  F12_F = 136,
  F13_F = 137,
  F14_F = 138,
  F15_F = 139,
  F16_F = 140,
  F17_F = 141,
  F18_F = 142,
  F19_F = 143,
  F20_F = 144,
  F21_F = 145,
  F22_F = 146,
  F23_F = 147,
  F24_F = 148,
  F25_F = 149,
  F26_F = 150,
  F27_F = 151,
  F28_F = 152,
  F29_F = 153,
  F30_F = 154,
  F31_F = 155,
  F0_H = 156,
  F1_H = 157,
  F2_H = 158,
  F3_H = 159,
  F4_H = 160,
  F5_H = 161,
  F6_H = 162,
  F7_H = 163,
  F8_H = 164,
  F9_H = 165,
  F10_H = 166,
  F11_H = 167,
  F12_H = 168,
  F13_H = 169,
  F14_H = 170,
  F15_H = 171,
  F16_H = 172,
  F17_H = 173,
  F18_H = 174,
  F19_H = 175,
  F20_H = 176,
  F21_H = 177,
  F22_H = 178,
  F23_H = 179,
  F24_H = 180,
  F25_H = 181,
  F26_H = 182,
  F27_H = 183,
  F28_H = 184,
  F29_H = 185,
  F30_H = 186,
  F31_H = 187,
  F0_Q = 188,
  F1_Q = 189,
  F2_Q = 190,
  F3_Q = 191,
  F4_Q = 192,
  F5_Q = 193,
  F6_Q = 194,
  F7_Q = 195,
  F8_Q = 196,
  F9_Q = 197,
  F10_Q = 198,
  F11_Q = 199,
  F12_Q = 200,
  F13_Q = 201,
  F14_Q = 202,
  F15_Q = 203,
  F16_Q = 204,
  F17_Q = 205,
  F18_Q = 206,
  F19_Q = 207,
  F20_Q = 208,
  F21_Q = 209,
  F22_Q = 210,
  F23_Q = 211,
  F24_Q = 212,
  F25_Q = 213,
  F26_Q = 214,
  F27_Q = 215,
  F28_Q = 216,
  F29_Q = 217,
  F30_Q = 218,
  F31_Q = 219,
  X0_H = 220,
  X1_H = 221,
  X2_H = 222,
  X3_H = 223,
  X4_H = 224,
  X5_H = 225,
  X6_H = 226,
  X7_H = 227,
  X8_H = 228,
  X9_H = 229,
  X10_H = 230,
  X11_H = 231,
  X12_H = 232,
  X13_H = 233,
  X14_H = 234,
  X15_H = 235,
  X16_H = 236,
  X17_H = 237,
  X18_H = 238,
  X19_H = 239,
  X20_H = 240,
  X21_H = 241,
  X22_H = 242,
  X23_H = 243,
  X24_H = 244,
  X25_H = 245,
  X26_H = 246,
  X27_H = 247,
  X28_H = 248,
  X29_H = 249,
  X30_H = 250,
  X31_H = 251,
  X0_Pair = 252,
  X0_W = 253,
  X1_W = 254,
  X2_W = 255,
  X3_W = 256,
  X4_W = 257,
  X5_W = 258,
  X6_W = 259,
  X7_W = 260,
  X8_W = 261,
  X9_W = 262,
  X10_W = 263,
  X11_W = 264,
  X12_W = 265,
  X13_W = 266,
  X14_W = 267,
  X15_W = 268,
  X16_W = 269,
  X17_W = 270,
  X18_W = 271,
  X19_W = 272,
  X20_W = 273,
  X21_W = 274,
  X22_W = 275,
  X23_W = 276,
  X24_W = 277,
  X25_W = 278,
  X26_W = 279,
  X27_W = 280,
  X28_W = 281,
  X29_W = 282,
  X30_W = 283,
  X31_W = 284,
  V0M2 = 285,
  V0M4 = 286,
  V0M8 = 287,
  V2M2 = 288,
  V4M2 = 289,
  V4M4 = 290,
  V6M2 = 291,
  V8M2 = 292,
  V8M4 = 293,
  V8M8 = 294,
  V10M2 = 295,
  V12M2 = 296,
  V12M4 = 297,
  V14M2 = 298,
  V16M2 = 299,
  V16M4 = 300,
  V16M8 = 301,
  V18M2 = 302,
  V20M2 = 303,
  V20M4 = 304,
  V22M2 = 305,
  V24M2 = 306,
  V24M4 = 307,
  V24M8 = 308,
  V26M2 = 309,
  V28M2 = 310,
  V28M4 = 311,
  V30M2 = 312,
  X2_X3 = 313,
  X4_X5 = 314,
  X6_X7 = 315,
  X8_X9 = 316,
  X10_X11 = 317,
  X12_X13 = 318,
  X14_X15 = 319,
  X16_X17 = 320,
  X18_X19 = 321,
  X20_X21 = 322,
  X22_X23 = 323,
  X24_X25 = 324,
  X26_X27 = 325,
  X28_X29 = 326,
  X30_X31 = 327,
  V1_V2 = 328,
  V2_V3 = 329,
  V3_V4 = 330,
  V4_V5 = 331,
  V5_V6 = 332,
  V6_V7 = 333,
  V7_V8 = 334,
  V8_V9 = 335,
  V9_V10 = 336,
  V10_V11 = 337,
  V11_V12 = 338,
  V12_V13 = 339,
  V13_V14 = 340,
  V14_V15 = 341,
  V15_V16 = 342,
  V16_V17 = 343,
  V17_V18 = 344,
  V18_V19 = 345,
  V19_V20 = 346,
  V20_V21 = 347,
  V21_V22 = 348,
  V22_V23 = 349,
  V23_V24 = 350,
  V24_V25 = 351,
  V25_V26 = 352,
  V26_V27 = 353,
  V27_V28 = 354,
  V28_V29 = 355,
  V29_V30 = 356,
  V30_V31 = 357,
  V0_V1 = 358,
  V2M2_V4M2 = 359,
  V4M2_V6M2 = 360,
  V6M2_V8M2 = 361,
  V8M2_V10M2 = 362,
  V10M2_V12M2 = 363,
  V12M2_V14M2 = 364,
  V14M2_V16M2 = 365,
  V16M2_V18M2 = 366,
  V18M2_V20M2 = 367,
  V20M2_V22M2 = 368,
  V22M2_V24M2 = 369,
  V24M2_V26M2 = 370,
  V26M2_V28M2 = 371,
  V28M2_V30M2 = 372,
  V0M2_V2M2 = 373,
  V4M4_V8M4 = 374,
  V8M4_V12M4 = 375,
  V12M4_V16M4 = 376,
  V16M4_V20M4 = 377,
  V20M4_V24M4 = 378,
  V24M4_V28M4 = 379,
  V0M4_V4M4 = 380,
  V1_V2_V3 = 381,
  V2_V3_V4 = 382,
  V3_V4_V5 = 383,
  V4_V5_V6 = 384,
  V5_V6_V7 = 385,
  V6_V7_V8 = 386,
  V7_V8_V9 = 387,
  V8_V9_V10 = 388,
  V9_V10_V11 = 389,
  V10_V11_V12 = 390,
  V11_V12_V13 = 391,
  V12_V13_V14 = 392,
  V13_V14_V15 = 393,
  V14_V15_V16 = 394,
  V15_V16_V17 = 395,
  V16_V17_V18 = 396,
  V17_V18_V19 = 397,
  V18_V19_V20 = 398,
  V19_V20_V21 = 399,
  V20_V21_V22 = 400,
  V21_V22_V23 = 401,
  V22_V23_V24 = 402,
  V23_V24_V25 = 403,
  V24_V25_V26 = 404,
  V25_V26_V27 = 405,
  V26_V27_V28 = 406,
  V27_V28_V29 = 407,
  V28_V29_V30 = 408,
  V29_V30_V31 = 409,
  V0_V1_V2 = 410,
  V2M2_V4M2_V6M2 = 411,
  V4M2_V6M2_V8M2 = 412,
  V6M2_V8M2_V10M2 = 413,
  V8M2_V10M2_V12M2 = 414,
  V10M2_V12M2_V14M2 = 415,
  V12M2_V14M2_V16M2 = 416,
  V14M2_V16M2_V18M2 = 417,
  V16M2_V18M2_V20M2 = 418,
  V18M2_V20M2_V22M2 = 419,
  V20M2_V22M2_V24M2 = 420,
  V22M2_V24M2_V26M2 = 421,
  V24M2_V26M2_V28M2 = 422,
  V26M2_V28M2_V30M2 = 423,
  V0M2_V2M2_V4M2 = 424,
  V1_V2_V3_V4 = 425,
  V2_V3_V4_V5 = 426,
  V3_V4_V5_V6 = 427,
  V4_V5_V6_V7 = 428,
  V5_V6_V7_V8 = 429,
  V6_V7_V8_V9 = 430,
  V7_V8_V9_V10 = 431,
  V8_V9_V10_V11 = 432,
  V9_V10_V11_V12 = 433,
  V10_V11_V12_V13 = 434,
  V11_V12_V13_V14 = 435,
  V12_V13_V14_V15 = 436,
  V13_V14_V15_V16 = 437,
  V14_V15_V16_V17 = 438,
  V15_V16_V17_V18 = 439,
  V16_V17_V18_V19 = 440,
  V17_V18_V19_V20 = 441,
  V18_V19_V20_V21 = 442,
  V19_V20_V21_V22 = 443,
  V20_V21_V22_V23 = 444,
  V21_V22_V23_V24 = 445,
  V22_V23_V24_V25 = 446,
  V23_V24_V25_V26 = 447,
  V24_V25_V26_V27 = 448,
  V25_V26_V27_V28 = 449,
  V26_V27_V28_V29 = 450,
  V27_V28_V29_V30 = 451,
  V28_V29_V30_V31 = 452,
  V0_V1_V2_V3 = 453,
  V2M2_V4M2_V6M2_V8M2 = 454,
  V4M2_V6M2_V8M2_V10M2 = 455,
  V6M2_V8M2_V10M2_V12M2 = 456,
  V8M2_V10M2_V12M2_V14M2 = 457,
  V10M2_V12M2_V14M2_V16M2 = 458,
  V12M2_V14M2_V16M2_V18M2 = 459,
  V14M2_V16M2_V18M2_V20M2 = 460,
  V16M2_V18M2_V20M2_V22M2 = 461,
  V18M2_V20M2_V22M2_V24M2 = 462,
  V20M2_V22M2_V24M2_V26M2 = 463,
  V22M2_V24M2_V26M2_V28M2 = 464,
  V24M2_V26M2_V28M2_V30M2 = 465,
  V0M2_V2M2_V4M2_V6M2 = 466,
  V1_V2_V3_V4_V5 = 467,
  V2_V3_V4_V5_V6 = 468,
  V3_V4_V5_V6_V7 = 469,
  V4_V5_V6_V7_V8 = 470,
  V5_V6_V7_V8_V9 = 471,
  V6_V7_V8_V9_V10 = 472,
  V7_V8_V9_V10_V11 = 473,
  V8_V9_V10_V11_V12 = 474,
  V9_V10_V11_V12_V13 = 475,
  V10_V11_V12_V13_V14 = 476,
  V11_V12_V13_V14_V15 = 477,
  V12_V13_V14_V15_V16 = 478,
  V13_V14_V15_V16_V17 = 479,
  V14_V15_V16_V17_V18 = 480,
  V15_V16_V17_V18_V19 = 481,
  V16_V17_V18_V19_V20 = 482,
  V17_V18_V19_V20_V21 = 483,
  V18_V19_V20_V21_V22 = 484,
  V19_V20_V21_V22_V23 = 485,
  V20_V21_V22_V23_V24 = 486,
  V21_V22_V23_V24_V25 = 487,
  V22_V23_V24_V25_V26 = 488,
  V23_V24_V25_V26_V27 = 489,
  V24_V25_V26_V27_V28 = 490,
  V25_V26_V27_V28_V29 = 491,
  V26_V27_V28_V29_V30 = 492,
  V27_V28_V29_V30_V31 = 493,
  V0_V1_V2_V3_V4 = 494,
  V1_V2_V3_V4_V5_V6 = 495,
  V2_V3_V4_V5_V6_V7 = 496,
  V3_V4_V5_V6_V7_V8 = 497,
  V4_V5_V6_V7_V8_V9 = 498,
  V5_V6_V7_V8_V9_V10 = 499,
  V6_V7_V8_V9_V10_V11 = 500,
  V7_V8_V9_V10_V11_V12 = 501,
  V8_V9_V10_V11_V12_V13 = 502,
  V9_V10_V11_V12_V13_V14 = 503,
  V10_V11_V12_V13_V14_V15 = 504,
  V11_V12_V13_V14_V15_V16 = 505,
  V12_V13_V14_V15_V16_V17 = 506,
  V13_V14_V15_V16_V17_V18 = 507,
  V14_V15_V16_V17_V18_V19 = 508,
  V15_V16_V17_V18_V19_V20 = 509,
  V16_V17_V18_V19_V20_V21 = 510,
  V17_V18_V19_V20_V21_V22 = 511,
  V18_V19_V20_V21_V22_V23 = 512,
  V19_V20_V21_V22_V23_V24 = 513,
  V20_V21_V22_V23_V24_V25 = 514,
  V21_V22_V23_V24_V25_V26 = 515,
  V22_V23_V24_V25_V26_V27 = 516,
  V23_V24_V25_V26_V27_V28 = 517,
  V24_V25_V26_V27_V28_V29 = 518,
  V25_V26_V27_V28_V29_V30 = 519,
  V26_V27_V28_V29_V30_V31 = 520,
  V0_V1_V2_V3_V4_V5 = 521,
  V1_V2_V3_V4_V5_V6_V7 = 522,
  V2_V3_V4_V5_V6_V7_V8 = 523,
  V3_V4_V5_V6_V7_V8_V9 = 524,
  V4_V5_V6_V7_V8_V9_V10 = 525,
  V5_V6_V7_V8_V9_V10_V11 = 526,
  V6_V7_V8_V9_V10_V11_V12 = 527,
  V7_V8_V9_V10_V11_V12_V13 = 528,
  V8_V9_V10_V11_V12_V13_V14 = 529,
  V9_V10_V11_V12_V13_V14_V15 = 530,
  V10_V11_V12_V13_V14_V15_V16 = 531,
  V11_V12_V13_V14_V15_V16_V17 = 532,
  V12_V13_V14_V15_V16_V17_V18 = 533,
  V13_V14_V15_V16_V17_V18_V19 = 534,
  V14_V15_V16_V17_V18_V19_V20 = 535,
  V15_V16_V17_V18_V19_V20_V21 = 536,
  V16_V17_V18_V19_V20_V21_V22 = 537,
  V17_V18_V19_V20_V21_V22_V23 = 538,
  V18_V19_V20_V21_V22_V23_V24 = 539,
  V19_V20_V21_V22_V23_V24_V25 = 540,
  V20_V21_V22_V23_V24_V25_V26 = 541,
  V21_V22_V23_V24_V25_V26_V27 = 542,
  V22_V23_V24_V25_V26_V27_V28 = 543,
  V23_V24_V25_V26_V27_V28_V29 = 544,
  V24_V25_V26_V27_V28_V29_V30 = 545,
  V25_V26_V27_V28_V29_V30_V31 = 546,
  V0_V1_V2_V3_V4_V5_V6 = 547,
  V1_V2_V3_V4_V5_V6_V7_V8 = 548,
  V2_V3_V4_V5_V6_V7_V8_V9 = 549,
  V3_V4_V5_V6_V7_V8_V9_V10 = 550,
  V4_V5_V6_V7_V8_V9_V10_V11 = 551,
  V5_V6_V7_V8_V9_V10_V11_V12 = 552,
  V6_V7_V8_V9_V10_V11_V12_V13 = 553,
  V7_V8_V9_V10_V11_V12_V13_V14 = 554,
  V8_V9_V10_V11_V12_V13_V14_V15 = 555,
  V9_V10_V11_V12_V13_V14_V15_V16 = 556,
  V10_V11_V12_V13_V14_V15_V16_V17 = 557,
  V11_V12_V13_V14_V15_V16_V17_V18 = 558,
  V12_V13_V14_V15_V16_V17_V18_V19 = 559,
  V13_V14_V15_V16_V17_V18_V19_V20 = 560,
  V14_V15_V16_V17_V18_V19_V20_V21 = 561,
  V15_V16_V17_V18_V19_V20_V21_V22 = 562,
  V16_V17_V18_V19_V20_V21_V22_V23 = 563,
  V17_V18_V19_V20_V21_V22_V23_V24 = 564,
  V18_V19_V20_V21_V22_V23_V24_V25 = 565,
  V19_V20_V21_V22_V23_V24_V25_V26 = 566,
  V20_V21_V22_V23_V24_V25_V26_V27 = 567,
  V21_V22_V23_V24_V25_V26_V27_V28 = 568,
  V22_V23_V24_V25_V26_V27_V28_V29 = 569,
  V23_V24_V25_V26_V27_V28_V29_V30 = 570,
  V24_V25_V26_V27_V28_V29_V30_V31 = 571,
  V0_V1_V2_V3_V4_V5_V6_V7 = 572,
  NUM_TARGET_REGS = 573,
};

}
}
}
#endif
