# Response - Изменение статус-кода { #response-change-status-code }

Вы, вероятно, уже читали о том, что можно установить [статус-код ответа по умолчанию](../tutorial/response-status-code.md){.internal-link target=_blank}.

Но в некоторых случаях нужно вернуть другой статус-код, отличный от значения по умолчанию.

## Пример использования { #use-case }

Например, представьте, что вы хотите по умолчанию возвращать HTTP статус-код «OK» `200`.

Но если данные не существовали, вы хотите создать их и вернуть HTTP статус-код «CREATED» `201`.

При этом вы всё ещё хотите иметь возможность фильтровать и преобразовывать возвращаемые данные с помощью `response_model`.

Для таких случаев вы можете использовать параметр `Response`.

## Использование параметра `Response` { #use-a-response-parameter }

Вы можете объявить параметр типа `Response` в вашей *функции обработки пути* (как и для cookies и HTTP-заголовков).

И затем вы можете установить `status_code` в этом *временном* объекте ответа.

{* ../../docs_src/response_change_status_code/tutorial001_py39.py hl[1,9,12] *}

После этого вы можете вернуть любой объект, который вам нужен, как обычно (`dict`, модель базы данных и т.д.).

И если вы объявили `response_model`, он всё равно будет использоваться для фильтрации и преобразования возвращаемого объекта.

**FastAPI** будет использовать этот *временный* ответ для извлечения статус-кода (а также cookies и HTTP-заголовков) и поместит их в финальный ответ, который содержит возвращаемое вами значение, отфильтрованное любым `response_model`.

Вы также можете объявить параметр `Response` в зависимостях и установить в них статус-код. Но помните, что последнее установленное значение будет иметь приоритет.
