# Ajude o FastAPI - Obtenha ajuda { #help-fastapi-get-help }

Você gosta do **FastAPI**?

Você gostaria de ajudar o FastAPI, outras pessoas usuárias e o autor?

Ou você gostaria de obter ajuda com o **FastAPI**?

Há maneiras muito simples de ajudar (várias envolvem apenas um ou dois cliques).

E também há várias formas de obter ajuda.

## Assine a newsletter { #subscribe-to-the-newsletter }

Você pode assinar a (infrequente) [newsletter do **FastAPI and friends**](newsletter.md){.internal-link target=_blank} para ficar por dentro de:

* Notícias sobre FastAPI e amigos 🚀
* Tutoriais 📝
* Funcionalidades ✨
* Mudanças incompatíveis 🚨
* Dicas e truques ✅

## Siga o FastAPI no X (Twitter) { #follow-fastapi-on-x-twitter }

<a href="https://x.com/fastapi" class="external-link" target="_blank">Siga @fastapi no **X (Twitter)**</a> para receber as últimas notícias sobre o **FastAPI**. 🐦

## Dê uma estrela ao **FastAPI** no GitHub { #star-fastapi-in-github }

Você pode “marcar com estrela” o FastAPI no GitHub (clicando no botão de estrela no canto superior direito): <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>. ⭐️

Ao adicionar uma estrela, outras pessoas conseguirão encontrá-lo com mais facilidade e verão que já foi útil para muita gente.

## Acompanhe o repositório no GitHub para lançamentos { #watch-the-github-repository-for-releases }

Você pode “acompanhar” (watch) o FastAPI no GitHub (clicando no botão “watch” no canto superior direito): <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>. 👀

Lá você pode selecionar “Apenas lançamentos” (Releases only).

Fazendo isso, você receberá notificações (no seu email) sempre que houver um novo lançamento (uma nova versão) do **FastAPI** com correções de bugs e novas funcionalidades.

## Conecte-se com o autor { #connect-with-the-author }

Você pode se conectar <a href="https://tiangolo.com" class="external-link" target="_blank">comigo (Sebastián Ramírez / `tiangolo`)</a>, o autor.

Você pode:

* <a href="https://github.com/tiangolo" class="external-link" target="_blank">Me seguir no **GitHub**</a>.
    * Ver outros projetos Open Source que criei e que podem ajudar você.
    * Me seguir para saber quando eu criar um novo projeto Open Source.
* <a href="https://x.com/tiangolo" class="external-link" target="_blank">Me seguir no **X (Twitter)**</a> ou no <a href="https://fosstodon.org/@tiangolo" class="external-link" target="_blank">Mastodon</a>.
    * Me contar como você usa o FastAPI (adoro saber disso).
    * Ficar sabendo quando eu fizer anúncios ou lançar novas ferramentas.
    * Você também pode <a href="https://x.com/fastapi" class="external-link" target="_blank">seguir @fastapi no X (Twitter)</a> (uma conta separada).
* <a href="https://www.linkedin.com/in/tiangolo/" class="external-link" target="_blank">Me seguir no **LinkedIn**</a>.
    * Ver quando eu fizer anúncios ou lançar novas ferramentas (embora eu use mais o X (Twitter) 🤷‍♂).
* Ler o que escrevo (ou me seguir) no <a href="https://dev.to/tiangolo" class="external-link" target="_blank">**Dev.to**</a> ou no <a href="https://medium.com/@tiangolo" class="external-link" target="_blank">**Medium**</a>.
    * Ler outras ideias, artigos e conhecer ferramentas que criei.
    * Me seguir para ver quando eu publicar algo novo.

## Tweet sobre o **FastAPI** { #tweet-about-fastapi }

<a href="https://x.com/compose/tweet?text=I'm loving @fastapi because... https://github.com/fastapi/fastapi" class="external-link" target="_blank">Tweet sobre o **FastAPI**</a> e conte para mim e para outras pessoas por que você gosta dele. 🎉

Eu adoro saber como o **FastAPI** está sendo usado, o que você tem curtido nele, em qual projeto/empresa você o utiliza, etc.

## Vote no FastAPI { #vote-for-fastapi }

* <a href="https://www.slant.co/options/34241/~fastapi-review" class="external-link" target="_blank">Vote no **FastAPI** no Slant</a>.
* <a href="https://alternativeto.net/software/fastapi/about/" class="external-link" target="_blank">Vote no **FastAPI** no AlternativeTo</a>.
* <a href="https://stackshare.io/pypi-fastapi" class="external-link" target="_blank">Diga que você usa o **FastAPI** no StackShare</a>.

## Ajude outras pessoas com perguntas no GitHub { #help-others-with-questions-in-github }

Você pode tentar ajudar outras pessoas com suas perguntas em:

* <a href="https://github.com/fastapi/fastapi/discussions/categories/questions?discussions_q=category%3AQuestions+is%3Aunanswered" class="external-link" target="_blank">GitHub Discussions</a>
* <a href="https://github.com/fastapi/fastapi/issues?q=is%3Aissue+is%3Aopen+sort%3Aupdated-desc+label%3Aquestion+-label%3Aanswered+" class="external-link" target="_blank">GitHub Issues</a>

Em muitos casos você já pode saber a resposta para aquelas perguntas. 🤓

Se você estiver ajudando muitas pessoas com suas perguntas, você se tornará um(a) [Especialista em FastAPI](fastapi-people.md#fastapi-experts){.internal-link target=_blank} oficial. 🎉

Apenas lembre-se, o ponto mais importante é: tente ser gentil. As pessoas chegam com frustrações e, em muitos casos, não perguntam da melhor forma, mas tente ao máximo ser gentil. 🤗

A ideia é que a comunidade do **FastAPI** seja gentil e acolhedora. Ao mesmo tempo, não aceite bullying ou comportamentos desrespeitosos com outras pessoas. Temos que cuidar uns dos outros.

---

Veja como ajudar outras pessoas com perguntas (em discussions ou issues):

### Entenda a pergunta { #understand-the-question }

* Verifique se você consegue entender qual é o **objetivo** e o caso de uso de quem está perguntando.

* Depois verifique se a pergunta (a grande maioria são perguntas) está **clara**.

* Em muitos casos a pergunta feita é sobre uma solução imaginada pela pessoa usuária, mas pode haver uma solução **melhor**. Se você entender melhor o problema e o caso de uso, pode sugerir uma **solução alternativa** melhor.

* Se você não entender a pergunta, peça mais **detalhes**.

### Reproduza o problema { #reproduce-the-problem }

Na maioria dos casos e na maioria das perguntas há algo relacionado ao **código original** da pessoa.

Em muitos casos ela só copia um fragmento do código, mas isso não é suficiente para **reproduzir o problema**.

* Você pode pedir que forneçam um <a href="https://stackoverflow.com/help/minimal-reproducible-example" class="external-link" target="_blank">exemplo mínimo, reproduzível</a>, que você possa **copiar e colar** e executar localmente para ver o mesmo erro ou comportamento que elas estão vendo, ou para entender melhor o caso de uso.

* Se você estiver muito generoso(a), pode tentar **criar um exemplo** assim você mesmo(a), apenas com base na descrição do problema. Só tenha em mente que isso pode levar bastante tempo e pode ser melhor pedir primeiro que esclareçam o problema.

### Sugira soluções { #suggest-solutions }

* Depois de conseguir entender a pergunta, você pode dar uma possível **resposta**.

* Em muitos casos, é melhor entender o **problema subjacente ou caso de uso**, pois pode haver uma forma melhor de resolver do que aquilo que estão tentando fazer.

### Peça para encerrar { #ask-to-close }

Se a pessoa responder, há uma grande chance de você ter resolvido o problema, parabéns, **você é um(a) herói(na)**! 🦸

* Agora, se isso resolveu o problema, você pode pedir para:

    * No GitHub Discussions: marcar o comentário como a **resposta**.
    * No GitHub Issues: **encerrar** a issue.

## Acompanhe o repositório do GitHub { #watch-the-github-repository }

Você pode “acompanhar” (watch) o FastAPI no GitHub (clicando no botão “watch” no canto superior direito): <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>. 👀

Se você selecionar “Acompanhando” (Watching) em vez de “Apenas lançamentos” (Releases only), receberá notificações quando alguém criar uma nova issue ou pergunta. Você também pode especificar que quer ser notificado(a) apenas sobre novas issues, ou discussions, ou PRs, etc.

Assim você pode tentar ajudar a resolver essas questões.

## Faça perguntas { #ask-questions }

Você pode <a href="https://github.com/fastapi/fastapi/discussions/new?category=questions" class="external-link" target="_blank">criar uma nova pergunta</a> no repositório do GitHub, por exemplo para:

* Fazer uma **pergunta** ou perguntar sobre um **problema**.
* Sugerir uma nova **funcionalidade**.

**Nota**: se você fizer isso, então vou pedir que você também ajude outras pessoas. 😉

## Revise Pull Requests { #review-pull-requests }

Você pode me ajudar revisando pull requests de outras pessoas.

Novamente, por favor tente ao máximo ser gentil. 🤗

---

Veja o que ter em mente e como revisar um pull request:

### Entenda o problema { #understand-the-problem }

* Primeiro, garanta que você **entendeu o problema** que o pull request tenta resolver. Pode haver uma discussão mais longa em uma Discussion ou issue do GitHub.

* Também há uma boa chance de o pull request não ser realmente necessário porque o problema pode ser resolvido de uma **forma diferente**. Aí você pode sugerir ou perguntar sobre isso.

### Não se preocupe com estilo { #dont-worry-about-style }

* Não se preocupe muito com coisas como estilos de mensagens de commit, eu vou fazer squash e merge personalizando o commit manualmente.

* Também não se preocupe com regras de estilo, já há ferramentas automatizadas verificando isso.

E se houver qualquer outra necessidade de estilo ou consistência, vou pedir diretamente, ou vou adicionar commits por cima com as mudanças necessárias.

### Verifique o código { #check-the-code }

* Verifique e leia o código, veja se faz sentido, **execute localmente** e veja se realmente resolve o problema.

* Depois **comente** dizendo que você fez isso, é assim que saberei que você realmente verificou.

/// info | Informação

Infelizmente, eu não posso simplesmente confiar em PRs que têm várias aprovações.

Já aconteceu várias vezes de haver PRs com 3, 5 ou mais aprovações, provavelmente porque a descrição é atraente, mas quando eu verifico os PRs, eles estão quebrados, têm um bug, ou não resolvem o problema que afirmam resolver. 😅

Por isso, é realmente importante que você leia e execute o código, e me avise nos comentários que você fez isso. 🤓

///

* Se o PR puder ser simplificado de alguma forma, você pode pedir isso, mas não há necessidade de ser exigente demais, pode haver muitos pontos de vista subjetivos (e eu terei o meu também 🙈), então é melhor focar nas coisas fundamentais.

### Testes { #tests }

* Me ajude a verificar se o PR tem **testes**.

* Verifique se os testes **falham** antes do PR. 🚨

* Depois verifique se os testes **passam** após o PR. ✅

* Muitos PRs não têm testes, você pode **lembrar** a pessoa de adicionar testes, ou até **sugerir** alguns testes você mesmo(a). Essa é uma das coisas que consomem mais tempo e você pode ajudar muito com isso.

* Depois também comente o que você testou, assim vou saber que você verificou. 🤓

## Crie um Pull Request { #create-a-pull-request }

Você pode [contribuir](contributing.md){.internal-link target=_blank} com o código-fonte fazendo Pull Requests, por exemplo:

* Para corrigir um erro de digitação que você encontrou na documentação.
* Para compartilhar um artigo, vídeo ou podcast que você criou ou encontrou sobre o FastAPI, <a href="https://github.com/fastapi/fastapi/edit/master/docs/en/data/external_links.yml" class="external-link" target="_blank">editando este arquivo</a>.
    * Garanta que você adicione seu link no início da seção correspondente.
* Para ajudar a [traduzir a documentação](contributing.md#translations){.internal-link target=_blank} para seu idioma.
    * Você também pode ajudar a revisar as traduções criadas por outras pessoas.
* Para propor novas seções de documentação.
* Para corrigir uma issue/bug existente.
    * Garanta que você adicione testes.
* Para adicionar uma nova funcionalidade.
    * Garanta que você adicione testes.
    * Garanta que você adicione documentação se for relevante.

## Ajude a manter o FastAPI { #help-maintain-fastapi }

Ajude-me a manter o **FastAPI**! 🤓

Há muito trabalho a fazer e, para a maior parte dele, **VOCÊ** pode ajudar.

As principais tarefas que você pode fazer agora são:

* [Ajudar outras pessoas com perguntas no GitHub](#help-others-with-questions-in-github){.internal-link target=_blank} (veja a seção acima).
* [Revisar Pull Requests](#review-pull-requests){.internal-link target=_blank} (veja a seção acima).

Essas duas tarefas são as que **mais consomem tempo**. Esse é o principal trabalho de manter o FastAPI.

Se você puder me ajudar com isso, **você está me ajudando a manter o FastAPI** e garantindo que ele continue **avançando mais rápido e melhor**. 🚀

## Entre no chat { #join-the-chat }

Entre no 👥 <a href="https://discord.gg/VQjSZaeJmf" class="external-link" target="_blank">servidor de chat do Discord</a> 👥 e converse com outras pessoas da comunidade FastAPI.

/// tip | Dica

Para perguntas, faça-as no <a href="https://github.com/fastapi/fastapi/discussions/new?category=questions" class="external-link" target="_blank">GitHub Discussions</a>, há uma chance muito maior de você receber ajuda pelos [Especialistas em FastAPI](fastapi-people.md#fastapi-experts){.internal-link target=_blank}.

Use o chat apenas para outras conversas gerais.

///

### Não use o chat para perguntas { #dont-use-the-chat-for-questions }

Tenha em mente que, como os chats permitem uma “conversa mais livre”, é fácil fazer perguntas muito gerais e mais difíceis de responder, então você pode acabar não recebendo respostas.

No GitHub, o template vai orientar você a escrever a pergunta certa para que você consiga obter uma boa resposta com mais facilidade, ou até resolver o problema sozinho(a) antes de perguntar. E no GitHub eu consigo garantir que sempre vou responder tudo, mesmo que leve algum tempo. Eu pessoalmente não consigo fazer isso com os sistemas de chat. 😅

As conversas nos sistemas de chat também não são tão fáceis de pesquisar quanto no GitHub, então perguntas e respostas podem se perder na conversa. E somente as que estão no GitHub contam para você se tornar um(a) [Especialista em FastAPI](fastapi-people.md#fastapi-experts){.internal-link target=_blank}, então é bem provável que você receba mais atenção no GitHub.

Por outro lado, há milhares de usuários nos sistemas de chat, então há uma grande chance de você encontrar alguém para conversar por lá quase o tempo todo. 😄

## Patrocine o autor { #sponsor-the-author }

Se o seu **produto/empresa** depende de ou está relacionado ao **FastAPI** e você quer alcançar suas pessoas usuárias, você pode patrocinar o autor (eu) através do <a href="https://github.com/sponsors/tiangolo" class="external-link" target="_blank">GitHub sponsors</a>. Dependendo do nível, você pode obter benefícios extras, como um selo na documentação. 🎁

---

Obrigado! 🚀
