# Changes of Note

- GDAL version 3 is now required. (#3428)
- `readers.tiledb` now defaults to unordered reads. (#3267)
- `readers.tiledb` now supports Hilbert ordering. (#3345)
- `writers.pcd` now writes 32-bit floating point for X, Y and Z by default. (#3286)
- The GDAL error handler is redirected to its destination when PDAL logging stops. (#3244)
- LAZperf version 2.0 is now required if building with LAZperf. (#3459)

# New Command

- Added `pdal eval` to print a classification report from two input point clouds. (#3346)
- Added `pdal chamfer` to calculate the chamfer distance, a metric used to quantify the similarity of two point clouds by evaluating the mean square distance of nearest neighbor correspondences between clouds.

# New Stages

- `filters.gpstimeconvert` allows conversion between the various GPS time standards.
- `filters.teaser` uses the truncated least squares estimation and semidefinite relaxation (TEASER) algorithm to create a rigid transformation between two datasets.
- `readers.draco` reads the [Draco](https://google.github.io/draco/) format.
- `writers.draco` writes the [Draco](https://google.github.io/draco/) format.
- `filters.zsmooth` sets a dimension to a value determined by nearby points. (#3408)

# Removed Stages

- `readers.oci`
- `writers.oci`

# Enhancements

- `pdal pipeline` and `pdal translate` now support a `--dims` option that allows the stored dimensions to be easily controlled. (#3310)
- `readers.las` now reports and terminates on some previously undetected LAS file errors. (#3226)
- Added `override_srs` and `default_srs` options to `readers.gdal` to allow a raster with only NODATA to have an SRS. (#3271)
- Support was added for MSVC 2019. (#3292)
- Added text output of GeoTIFF keys to metadata when reading LAS data. (#3299)
- Added programmatic support to merge summary statistics. (#3321)
- Extra dimension names in a LAS file containing characters deemed illegal by PDAL are now converted by default to legal PDAL dimension names. (#3325)
- The sample filter is now streamable. (#3275)
- Added the `--error_on_failure` option to `filters.reprojection` to allow the program to terminate if a projection operation fails. (#3316)
- Added the `--start` option to `readers.las` to allow skipping some number of points. (#3313)
- Set the `ACCEPT_ENCODING' curl option to enable automatic decompression of HTTP replies.
- Improve error messages for LAS where a specified point format is not permitted. (#3324)
- Add the `--where` option to all writers. (#3319)
- Added a `--nosrs` option to `readers.las` to avoid reading the SRS information. (#3441)
- Improved performance of `readers.ept` in stream mode. (#3331)

# Bug Fixes

- `readers.tindex` could improperly filter based on a provided polygon. This has been fixed (#3236)
- A bug in `filters.eigenvalues` was fixed where improper eigenvalues would be returned if the minimum number of neighbors wasn't satisfied. (#3245)
- A regression in `filters.csf` where an extra loop would substantially slow processing has been fixed. (#3248)
- An infinite loop could occur in `readers.ept` if there was no data to be read. This has been fixed. (#3268)
- A situation where `readers.ept` would attempt to transform an invalid polygon has been fixed. (#3276)
- `readers.obj` is now properly closes its input file at the end of processing. (#3294)
- A bug in auto-scaling/auto-offset has been fixed when the variance of the data is 0. (#3304)
- Trailing NULL bytes are now stripped from WKT when read via `readers.las`. (#3332)
- A crash that could occur in `fitlers.hag` if there were no points to process has been fixed. (#3343)
- The `dimbuilder` utility now sets the exit code as appropriate. (#3353)
- The `pdal` program now sets an error code if no command is provided. (#3354)
- Eliminate some small memory leaks when using XMLSchema. (#3368)
- A check was added for a too-large grid in `writers.gdal`. (#3383)
- `filters.colorization` now properly ignores points outside the input raster in streaming mode. (#3391)
- A bug in handling HTTP `Content-Length` headers of various case has been fixed.
- A bug in the order of reading the min/max values for `readers.bpf` version 1 has been fixed. (#3394)
- Fixed a bug in `readers.i3s` where a clip region might not properly find all the intersecting points. (#3397)
- Replace invalid characters from EPT dimension names to make them valid for PDAL. (#3400)
- Fixed a problem writing LAZ scan angle outside of the range [-90, 90] for LAZ 1.4. (#3288)
- Allow LAS 1.4 to use GeoTIFF SRS for point data record format 0-5. (#3242)
- Set the LAS extended VLR offset to zero if there are no extended VLRs for LAS 1.4. (#3407)
- Add precision for options taking doubles. (#3235)
- Detect filter-only pipelines so applications don't crash with their use. (#3233)
- Fix mapping of large files on Windows NTFS. (#3282)
- Fix reading of PCD files with Linux-style line endings on Windows. (#3424)
- `filters.fps` now returns all points if input contains fewer points than requested. (#3447)
- `filters.head` now returns the specified number of points for _all_ input PointViews in standard mode. (#3448)
