/*******************************************************************************
* Copyright 2023 Intel Corporation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

#include <cstdint>
#include <vector>

namespace dnnl {
namespace impl {
namespace gpu {
namespace jit {

// clang-format off
const std::vector<uint64_t> &get_conv_model_xehpg_dw_data() {
    static std::vector<uint64_t> data = {
        0x000000133e4ccccd, 0x3f80000000000001, 0x3ce0000000000044, 0x3d4000003d200000, 0x3d7c00003d600000, 0x3da000003d8c0000, 0x3dc000003da80000, 0x3de000003dd20000,
        0x3dfc00003df00000, 0x3e0c00003e000000, 0x3e1c00003e100000, 0x3e2800003e200000, 0x3e4000003e340000, 0x3e5200003e480000, 0x3e7000003e600000, 0x3e8000003e7c0000,
        0x3e8c00003e870000, 0x3e9600003e900000, 0x3ea800003ea00000, 0x3eb400003eb00000, 0x3ec600003ec00000, 0x3ed200003ed00000, 0x3ee000003ed80000, 0x3ef000003ee40000,
        0x3f0000003efc0000, 0x3f0700003f040000, 0x3f1000003f0c0000, 0x3f1800003f130000, 0x3f2640003f200000, 0x3f2e00003f280000, 0x3f3b80003f340000, 0x3f4800003f400000,
        0x3f52f0003f500000, 0x3f5ec0003f580000, 0x3f6400003f600000, 0x3f7c00003f700000, 0x000000023f800000, 0x3f80000000000000, 0x3e6000000000000e, 0x3ec000003ea00000,
        0x3f0000003ee00000, 0x3f1c00003f0f0000, 0x3f4000003f280000, 0x3f6000003f520000, 0x3f7c00003f700000, 0x000000bf3f800000, 0x49870000497c0000, 0x49900000498dc000,
        0x49a20000499c0000, 0x49ac440049a56000, 0x49bd000049b40000, 0x49ceb80049c4e000, 0x49dc800049dac000, 0x49f3000049e5b000, 0x4a03400049fc0000, 0x4a0dc0004a070000,
        0x4a1900004a100000, 0x4a2200004a1d8000, 0x4a2b80004a256000, 0x4a3400004a2f0000, 0x4a44e0004a3d0000, 0x4a5ac0004a520000, 0x4a65b0004a5c8000, 0x4a7810004a700000,
        0x4a82b6004a7c0000, 0x4a89d0004a856b00, 0x4a9000004a8dc000, 0x4a9920004a930000, 0x4a9e34004a9c0000, 0x4aa560004aa20000, 0x4aab48004aa8c000, 0x4ab220004aaf0000,
        0x4abd00004ab64000, 0x4ac8d0004ac06000, 0x4ad200004aca8000, 0x4ad800004ad4a000, 0x4ae118004adc8000, 0x4aed4e004ae86000, 0x4af810004af30000, 0x4b0040004afc0000,
        0x4b0700004b03a000, 0x4b0dc0004b09d000, 0x4b12f4004b100000, 0x4b15a0004b13a800, 0x4b18ee004b16c000, 0x4b1e34004b1c4000, 0x4b2560004b220000, 0x4b2f80004b29ec00,
        0x4b3d00004b37c000, 0x4b4864004b400000, 0x4b52f0004b4daa00, 0x4b6100004b580000, 0x4b73a2004b6c4000, 0x4b7c00004b7a0000, 0x4b83a0004b804000, 0x4b8dc0004b870000,
        0x4b9480004b900000, 0x4b9e34004b992000, 0x4ba54b004ba20000, 0x4bac44004ba71000, 0x4bb9ab404bb40000, 0x4bc8fa004bbe2000, 0x4bd800004bd2f000, 0x4be5b0004bdc8000,
        0x4bf810004bf4e600, 0x4c00e8004bfd2000, 0x4c0dc0004c091c00, 0x4c1480004c100000, 0x4c2800004c220000, 0x4c3304004c2f0000, 0x4c3dd8004c391900, 0x4c4e40004c4766e0,
        0x4c5c80004c580000, 0x4c76cc004c65b000, 0x4c8f70004c83a000, 0x4c97e0004c900000, 0x4caf80004ca56000, 0x4cc0be804cb94d80, 0x4ce07d804cd80000, 0x4cf40b004ce5b000,
        0x4d02a0a04d006010, 0x4d0ca0004d0721c0, 0x4d1600004d100000, 0x4d28c0004d241000, 0x4d2ea8004d2cc200, 0x4d4210004d340000, 0x4d52f0004d48fa00, 0x4d6658004d5f2000,
        0x4d7f00004d730000, 0x4d8f8e004d891c00, 0x4daed0804da20000, 0x4dbe50004db64000, 0x4ddf20004dcb4a80, 0x4e0196004df30000, 0x4e1924004e0c0000, 0x4e2e06004e28c000,
        0x4e48fa004e2f0000, 0x4e7300004e5c8000, 0x4eb5e0004e900000, 0x4ef300004ed5c000, 0x4f4000004f192400, 0x000000a04f859800, 0x4260000042100000, 0x42a8000042900000,
        0x4300000042e00000, 0x43100000430f0000, 0x4328000043200000, 0x434f000043400000, 0x4360000043580000, 0x437c000043700000, 0x438c000043800000, 0x439c000043900000,
        0x43a8000043a00000, 0x43c0000043b40000, 0x43cf000043cc0000, 0x43d8000043d20000, 0x43ee000043e00000, 0x43fc000043f00000, 0x4405000044000000, 0x440c0000440a0000,
        0x4416000044100000, 0x4428000044200000, 0x44340000442f0000, 0x44400000443d0000, 0x444cc00044460000, 0x4458000044520000, 0x4464000044600000, 0x447c000044700000,
        0x4484000044800000, 0x448c000044876000, 0x4493000044900000, 0x44a0000044980000, 0x44a8000044a5a000, 0x44b4000044ac8000, 0x44c0000044bb8000, 0x44cf000044c60000,
        0x44d8000044d20000, 0x44e4000044e00000, 0x44fbc00044f00000, 0x4500000044fc0000, 0x4507600045040000, 0x45100000450c0000, 0x451a000045130000, 0x4525000045200000,
        0x452d400045280000, 0x4539a00045340000, 0x4546c00045400000, 0x4555c00045500000, 0x45600000455b6000, 0x45730000456a0000, 0x45800000457c0000, 0x4587f00045840000,
        0x45900000458ca000, 0x459c000045930000, 0x45a8000045a00000, 0x45b5800045b22000, 0x45c0000045bb8000, 0x45d2f00045ca8000, 0x45e0000045dc8000, 0x45fc000045f00000,
        0x4607000046000000, 0x46100000460ca000, 0x4620000046160000, 0x4634000046290000, 0x46400000463d0000, 0x4660000046520000, 0x467d80004671e000, 0x468c000046804000,
        0x469c300046900000, 0x46b5800046a80000, 0x46d5c00046c00000, 0x46fc000046e00000, 0x4710000047070000, 0x4735800047200000, 0x475c800047440000, 0x4787000047750000,
        0x47b4000047930000, 0x47e1000047c78c00, 0x481514804800a000, 0x48600000483d0000, 0x48c00000488e8000, 0x49900000490ca000, 0x3f8000000000000d, 0x41c0000041400000,
        0x4290000042400000, 0x4310000042c00000, 0x43a0000043400000, 0x4440000043d80000, 0x4690000044d80000, 0x3f80000000000004, 0x4080000040000000, 0x0000000141000000,
        0x000000013f800000, 0x000000043f800000, 0x4180000041000000, 0x4280000042000000, 0x3f8000000000000c, 0x40e0000040c00000, 0x4110000041000000, 0x4130000041200000,
        0x4150000041400000, 0x4170000041600000, 0x0000000141800000, 0x000000083f800000, 0x404000003f800000, 0x40c0000040a00000, 0x4110000041000000, 0x4180000041400000,
        0x3f8000000000001d, 0x4080000040400000, 0x40e0000040a00000, 0x4110000041000000, 0x4150000041300000, 0x4188000041800000, 0x41c0000041b80000, 0x41f8000041c80000,
        0x421c000042040000, 0x4240000042240000, 0x42800000424c0000, 0x4296000042860000, 0x42e6000042c00000, 0x4340000042f60000, 0x4540000043d80000, 0x0000000000000001,
        0x0000000000000001, 0x3f80000000000003, 0x4040000040000000, 0x3f80000000000003, 0x4040000040000000, 0x000000323c4ddeae, 0x0000000500000013, 0x00000001000003e8,
        0x012001110000023c, 0x0050260400945804, 0x00220e010030000d, 0x470773ff001d0501, 0x0011bc40e63fffbc, 0xffbc3e5571ff002b, 0x00421a04bc31e99c, 0x3ad17aff003d0a04,
        0x0011bc322605ffbc, 0xffbc2e1950ff004b, 0x00740011bc221c60, 0x006115010066000d, 0x37c0ffbc40543eff, 0xbcff006f0007bc32, 0xbc20501dffbc2d4c, 0x008112010086000d,
        0xe816ffbc38668eff, 0xe2ff008f3a04bc1d, 0xbc022fa7ffbc1513, 0x00bc000700dc0011, 0x00a9010a00ae010d, 0xc4bfffbc312ab5ff, 0x5bff00b77704bc2a, 0xbc1b0d01ffbc2320,
        0x00c9000a00ce010d, 0xc313ffbc2560b0ff, 0xe8ff00d77304bc16, 0xbbf0d4ccffbc0a01, 0x00f2010d01000007, 0x16185bff00ed060e, 0x9505bc00027dffbc, 0xffbbe3dc3fff00fb,
        0x0112010dbc0c53c7, 0xfc9fd7ff010d060e, 0x030ebb90f136ffbb, 0xffbb83fdf4ff011b, 0x01b0000b38003c37, 0x014c020e016c000a, 0x01390806013e0906, 0x9966ffbb79129cff,
        0xe4ff0147000ebbc9, 0xbc04af86ffbc2fb7, 0x01590a06015e1205, 0x3951ffbbc41d16ff, 0x21ff0167a604bb42, 0xb9379bd5ffbb3861, 0x0182000e0190010e, 0x1f6244ff017d010a,
        0x050dbc0543a9ffbc, 0xffbbbe3ad0ff018b, 0x01a2a404bb1791a6, 0x3f1230ff019d1905, 0x120ebab8afb3ff3a, 0xff3bd588d8ff01ab, 0x01f8010d3936abd8, 0x01ca000d01d83204,
        0xd98114ff01c51701, 0x19043c1fa8b5ffb9, 0xff3c55292cff01d3, 0x01ea000d3cf1292e, 0x5a387cff01e5000a, 0x75053cd95e96ff3c, 0xff3d518016ff01f3, 0x021c32043c90029d,
        0x02091201020e1e04, 0x2ba3ff3c2f2ed3ff, 0xeaff0217010e3ccd, 0x3ce5f900ff3d278b, 0x02295c04022e8205, 0xc69fff3d671790ff, 0x27ff023794053db9, 0x3cdc8281ff3d43d6,
        0x0000000500000013, 0x00000001000003e8, 0x012001120000023c, 0x0050220400946204, 0x002212010030000d, 0x1fae6bff001d0401, 0x0011bc1a87bcffbc, 0xffbc188337ff002b,
        0x00420e01bc0e6701, 0x197b47ff003d0701, 0x0011bc1236bdffbc, 0xffbc104ea2ff004b, 0x0074000dbc058ade, 0x0061150100660011, 0x15cdffbc1abcacff, 0xbeff006f1c01bc0e,
        0xbbf632d2ffbc0e8b, 0x0081020d00860011, 0xf1e4ffbc068eadff, 0x8dff008f4804bbf7, 0xbbbef042ffbbe92a, 0x00bc010d00dc0011, 0x00a9000a00ae0007, 0x6759ffbc0f954eff,
        0x7bff00b7000abc09, 0xbbef2e62ffbc0423, 0x00c97a0400ce0007, 0xa154ffbc00b8a4ff, 0xe1ff00d79405bbf7, 0xbc007336ffbbc41a, 0x00f27f0401008305, 0xd81bf9ff00ed000d,
        0x000dbb9c9547ffbb, 0xffbb95c4e2ff00fb, 0x0112010dbb0c51ce, 0x02a2c1ff010d000a, 0x8f05bbd136a7ffbc, 0xffbb89f3bfff011b, 0x01b00007bbcff278, 0x014c1905016c3805,
        0x01390a06013e0205, 0xebd8ff3a596720ff, 0xc8ff0147000a3ba7, 0xba0d454dffbb8b39, 0x0159a604015e000b, 0x87ebffbb2240beff, 0x10ff0167000d3b3a, 0x3c89be7bff3b9d6d,
        0x0182000a0190010d, 0x3587fbff017d000d, 0x000d3c41055dff3b, 0xff3c7d8e05ff018b, 0x01a200063ce9e3ea, 0x0e5107ff019d030e, 0x07063d8aca9eff3d, 0xff3a47b782ff01ab,
        0x01f8010dbba4b527, 0x01ca000d01d82704, 0x4524daff01c50a01, 0x10043b61b9ceffbb, 0xff3bfa0c1aff01d3, 0x01ea000d3ca3ce71, 0x5778faff01e5000a, 0x78053cbca4deff3c,
        0xff3d31454fff01f3, 0x021c4a043c36746d, 0x02090c01020e1901, 0xed01ff3b7bd40aff, 0xf9ff021737043c90, 0x3d3dd85dff3d06c5, 0x0229030e022e9704, 0x94c0ff3d988b04ff,
        0xcfff0237010e3dff, 0x3d5ef037ff3ca9d6, 0x0000000500000013, 0x00000001000003e8, 0x012001120000023c, 0x0050330400946304, 0x0022000d00301604, 0xff1ecbff001d0701,
        0x0801bbf4bedcffbb, 0xffbbf5452cff002b, 0x0042030ebbe8357c, 0xdfc22bff003d0011, 0x0011bbc9cb25ffbb, 0xffbbf16c0aff004b, 0x0074000dbbe27f98, 0x0061000700660011,
        0x2141ffbbee8efbff, 0x80ff006f0007bbdc, 0xbbbfc3b9ffbbdacc, 0x0081510400864b05, 0x3b26ffbbb0d1e7ff, 0x5aff008f0012bb8a, 0xbbbcb797ffbbd428, 0x00bc000700dc0011,
        0x00a9000e00ae010d, 0xfb58ffbc04de97ff, 0x95ff00b79d05bbde, 0xbbe5976effbbc7e7, 0x00c9000e00ce010d, 0xd851ffbc0bd3cfff, 0x41ff00d7ba04bbc5, 0xbbda4109ffbb9bd3,
        0x00f2890401007905, 0xa56a34ff00ed000d, 0x000dbb5a0f7dffbb, 0xffbb413e09ff00fb, 0x0112020dba4a18c7, 0xbf049fff010d060e, 0x8f05bb8e2f0affbb, 0xffbb450c6aff011b,
        0x01b00007bba11f8b, 0x014c1905016c3805, 0x0139140e013e0005, 0x5b07ff3bfc2792ff, 0xd4ff0147000a3ad7, 0xb8f1c4feffbb5ec2, 0x01591b05015e000b, 0x488cff3bb9582bff,
        0xb4ff0167030ebaa7, 0x3b797401ff3c5bd7, 0x0182000a0190010d, 0x11398bff017d000d, 0x000d3c1a6aaeff3b, 0xff3c4ad801ff018b, 0x01a2a8043cbb1cc7, 0xe1b335ff019d7d04,
        0x45053d2a6570ff3c, 0xffb9e09dc1ff01ab, 0x01f8020d3c7525e7, 0x01ca030e01d82001, 0x03edf9ff01c52104, 0x16013cc6abd8ff3c, 0xffba725f2bff01d3, 0x01ea000a3bd47ec5,
        0x882202ff01e58105, 0x000d39a2748cff3c, 0xff3cacab9eff01f3, 0x021c030e3d24bc6a, 0x02096104020e9804, 0x5c9eff3d08472cff, 0x44ff0217010e3d8d, 0x3d522479ff3c828a,
        0x02298f04022e9604, 0xd685ff3dd22d9eff, 0x0bff0237010b3e04, 0x3da07f76ff3cae7a, 0x0000000500000013, 0x00000001000003e8, 0x012001120000023c, 0x0050190100945e04,
        0x0022010e00301201, 0xc2fb34ff001d0904, 0x0801bbb5ab9dffbb, 0xffbbcbfeadff002b, 0x0042020dbbc325d4, 0xc2e450ff003d0011, 0x0011bbb301e3ffbb, 0xffbbb55da5ff004b,
        0x00740011bb9e063d, 0x0061000a0066010d, 0x57f4ffbbbdde34ff, 0x25ff006f0007bbb1, 0xbba0d67affbbb2e5, 0x0081000a0086010d, 0x9e94ffbba82690ff, 0xbcff008f0007bb91,
        0xbb51e067ffbb8bac, 0x00bc001100dc010d, 0x00a9920400ae7c05, 0x1ca5ffbba4cc79ff, 0x0cff00b7010abb85, 0xbb8f545affbbb6d2, 0x00c9650500ce060e, 0xfb94ffbb6ad86aff,
        0x86ff00d77c04bb99, 0xbb0d19e7ffbba52f, 0x00f2970401000007, 0xa14c04ff00ed0011, 0x9505bb8d59dbffbb, 0xffbb574b7bff00fb, 0x01120011bb972554, 0x8e9316ff010d7804,
        0x8605bb703f95ffbb, 0xffba5e8752ff011b, 0x01b09704bb6070d7, 0x014c1c04016c4704, 0x01390c04013e000d, 0xce33ffbb8f56a9ff, 0x81ff01470a04b8d5, 0x3c1463c0ff3aba07,
        0x01594b05015e030e, 0xfa99ff3ca08e59ff, 0x27ff0167060e3c27, 0xbb0af12bff3c02db, 0x018257050190000d, 0x2ebb06ff017d2201, 0x7b053c9f624aff3c, 0xff3c244109ff018b,
        0x01a2030e3b25b031, 0xdfdbcfff019d020d, 0x00073d368c60ff3c, 0xff3d2200e8ff01ab, 0x01f8000b3d985767, 0x01ca020e01d8000a, 0xcafd80ff01c5050d, 0x9f04bb83dc84ffbb,
        0xff39babcfcff01d3, 0x01ea020ebb1870ce, 0xcc7d27ff01e50906, 0x0c0ebb8de880ffb9, 0xff3b526e15ff01f3, 0x021c060e3969f27b, 0x0209010a020e010d, 0x9ed0ffb9d72f09ff,
        0x81ff0217010e3c23, 0x3d160d35ff3c41e3, 0x02290107022e000a, 0xa847ff3c5cdedaff, 0x7dff0237ac043ca6, 0x3d441432ff3cec47, 0x0000000500000013, 0x00000001000003e8,
        0x012001120000023c, 0x00502b0400946704, 0x0022001200301104, 0xa384baff001d020d, 0x010ebb95a344ffbb, 0xffbb9421fdff002b, 0x0042010ebb9dda02, 0x900edfff003d0011,
        0x0f01bb822536ffbb, 0xffbb9e70cbff004b, 0x00740011bb922f6a, 0x0061010d00660007, 0x5775ffbb998ffdff, 0x74ff006f000dbb8c, 0xbb7d2e0dffbb8d6a, 0x008100070086010e,
        0xe568ffbb783b92ff, 0xfdff008f1d01bb34, 0xbb721d6cffbb9219, 0x00bc060e00dc010d, 0x00a98d0400ae000a, 0x5ab9ffbb81ff8dff, 0xf0ff00b70011bb9c, 0xbb432830ffbb7ffc,
        0x00c9a20400ce0007, 0x9a74ffbb8aeb3dff, 0x43ff00d79904bb50, 0xba446d4affbb378d, 0x00f2980401000007, 0x6e9556ff00ed000a, 0x030ebb512452ffbb, 0xffbb5b2f93ff00fb,
        0x0112030ebb0d691b, 0x08bd51ff010d000a, 0x9704b9ef5a9affbb, 0xffbb11b594ff011b, 0x01b000073acc8a60, 0x014c2d05016c3805, 0x0139000d013e0b03, 0x487cffbbac4233ff,
        0x09ff01470c0e3b0c, 0xba3835beff3ac244, 0x01592f05015e000b, 0x56c1ff3b69f2c9ff, 0xa2ff01671404bb56, 0x3c4212e1ff3aa64a, 0x0182000a0190010d, 0x73c733ff017d8b05,
        0x000dbb4aaa3fff3b, 0xff3bfd4a95ff018b, 0x01a2a8043c6d1f02, 0x8dcbb8ff019d030e, 0x000a3d1b961dff3c, 0xff3b36c4d9ff01ab, 0x01f8010d3d39cf61, 0x01ca030e01d83e04,
        0x745a35ff01c51304, 0x16043c3aa60eff3b, 0xffbaf4793cff01d3, 0x01ea68053b62774f, 0x695a05ff01e5000d, 0x80043ce97bc2ff3c, 0xff3c984408ff01f3, 0x021c3f043b26551c,
        0x02091404020e1d01, 0xe8b0ffbb4f5d5eff, 0x61ff02172f043bee, 0x3cb9a05bff3c8456, 0x02296e04022e9704, 0xf221ff3d08512dff, 0x1eff0237010e3d51, 0x3cf80e4dff3c2db4,
        0x0000000500000013, 0x00000001000003e8, 0x012001120000023c, 0x0050400400948104, 0x0022000d00301a04, 0x82b6afff001d0012, 0x0c04bb79e2bbffbb, 0xffbb791308ff002b,
        0x0042060ebb68e289, 0x548fcbff003d4b05, 0x010abb76922affbb, 0xffbb7f59e4ff004b, 0x00740011bb88b336, 0x006162050066000d, 0xbda3ffbb5ee448ff, 0x30ff006f0007bb7e,
        0xbb3d8dabffbb5de3, 0x0081020d00860007, 0xf838ffbb5fdeadff, 0x6fff008f2501bb30, 0xbb0112beffbb5c14, 0x00bc990400dc6805, 0x00a9130e00ae000d, 0xeefeffbb04cbf5ff,
        0x99ff00b70011bb5c, 0xb9f6af94ffbb0674, 0x00c9480500ce000d, 0xcaa7ff3a2bbe78ff, 0x86ff00d7a504bab0, 0x3b13cb97ff3a1203, 0x00f2000a0100010d, 0x522e70ff00ed8d05,
        0x060ebb7eff14ffbb, 0xffbb3a860eff00fb, 0x01128705badd4038, 0x17cf9aff010d0007, 0x0002b9f33121ffbb, 0xffbb3f55d1ff011b, 0x01b00007bb098b9f, 0x014c2d05016c3805,
        0x01391401013e000a, 0x8ef7ff3aa770c7ff, 0xa2ff01472405bae4, 0x3bccaf17ff39a7d2, 0x01591404015e0006, 0x4251ff3a85087dff, 0x9aff0167000a3c1b, 0x3b3b28a1ffbb2b78,
        0x0182000a0190010d, 0x41f7cfff017d8c05, 0x000dbb2a0a2dff3b, 0xff3bcaa20dff018b, 0x01a200063c3db25e, 0x4aff09ff019d000a, 0x08063cf08d2bff3c, 0xff39fc9f79ff01ab,
        0x01f8020dbb962f4b, 0x01ca0f0101d82101, 0x0441fdff01c5060e, 0x000dbbc42046ff39, 0xff3b18349aff01d3, 0x01ea000a3c0bcb94, 0x6b7af3ff01e5060e, 0x81043c722036ff3b,
        0xff3caa5bc4ff01f3, 0x021c030e3c16b2c8, 0x02096604020e9404, 0x6c55ff3c931f00ff, 0x54ff0217010e3d25, 0x3ce2989bff3bfa04, 0x02299004022e9604, 0x8090ff3d6973bbff,
        0x2bff023736053da2, 0x3c6cbf9bff3d81fd, 0x0000000500000013, 0x00000001000003e8, 0x012001110000023c, 0x0050130100944804, 0x00220a0100300012, 0x5ec04fff001d0201,
        0x0e04bb582338ffbb, 0xffbb562bdcff002b, 0x0042060ebb4cc97c, 0x45d9a6ff003d020d, 0x0801bb3b7bd9ffbb, 0xffbb5b7fbeff004b, 0x00740011bb4e44dc, 0x00614b050066010d,
        0xe365ffbb4002b0ff, 0x8cff006f0007bb50, 0xbb277e0dffbb3aea, 0x0081030e00862001, 0x425cffbb22c023ff, 0x6aff008f4b05bb3d, 0xbb3f6cb3ffbb0ea1, 0x00bc8b0500dc0011,
        0x00a9000d00ae0007, 0x9f53ffbb451217ff, 0x0cff00b7000dbb2c, 0xbb0dab1dffbb2a3f, 0x00c9000e00ce010a, 0xfa51ffbb805fc3ff, 0x37ff00d7b804bb46, 0xbab1e7c5ffbb2a2c,
        0x00f2020d01000007, 0x40787dff00ed000a, 0x040ebb206497ffbb, 0xffbb08b9a6ff00fb, 0x0112060dbaa4e58f, 0xf63120ff010d000a, 0x040bba86191cffba, 0xff3b014fa3ff011b,
        0x01b09704bb109e09, 0x014c5404016c020d, 0x0139060e013e000d, 0x0af9ff3af3c5eeff, 0x58ff0147000abb71, 0x3c221295ff3b42c8, 0x01594b05015e000d, 0x8018ff3c424e5dff,
        0x7fff0167000a3b85, 0x3ce4ab38ff3c1ba9, 0x0182240101906d04, 0x425e3fff017d2405, 0x00073c31791fff3b, 0xff3c17f308ff018b, 0x01a2050b3ca6fcc4, 0x90f31bff019d0007,
        0x7d043d03dc94ff3c, 0xff3cedcf8fff01ab, 0x01f8000a3d75a113, 0x01ca060e01d8010d, 0x37f0e7ff01c5b704, 0xae04bc366c89ffbb, 0xff3c1b3201ff01d3, 0x01ea000b3c69ebd4,
        0x9b4442ff01e5010e, 0xbb04ba98f77bffbb, 0xff3c24dd4dff01f3, 0x021c010bbb4320c8, 0x0209020e020e020a, 0xae47ffbb0f2b81ff, 0x40ff0217b5043a82, 0x3c8d160dff3bd904,
        0x0229010d022e060e, 0xda85ff3b024345ff, 0x8aff0237ac043d26, 0x3d11d81fff3ca23b, 0x0000000500000013, 0x00000001000003e8, 0x012001110000023c, 0x0050010e00942101,
        0x0022070400301f04, 0x2a1df1ff001d0012, 0x000ebb1fed8cffbb, 0xffbae9f773ff002b, 0x0042010abb15052b, 0x0fe4baff003d1401, 0x030bbae2a4bbffbb, 0xffbb03bb9aff004b,
        0x0074060ebb4527b0, 0x00610b0400662b04, 0x7db4ffbb2995eaff, 0x11ff006f0e01bb1d, 0xbb0cde3effbb3e88, 0x0081030100864704, 0xf023ffbb32094fff, 0x31ff008f2705bb28,
        0xbb17fee9ffbb5132, 0x00bc000a00dc010d, 0x00a9000d00ae0007, 0xef30ffbb2c556aff, 0x65ff00b7b504bb10, 0xbb39b706ffbb0dc8, 0x00c9000e00ce060e, 0x398dffbb275a92ff,
        0xb1ff00d70007bae6, 0xb937ef28ffbafcd8, 0x00f2ae0401000011, 0xfa1b0dff00edab04, 0x010ebb3fb449ffba, 0xffbb42bc91ff00fb, 0x01120007baaebd0c, 0xd869d8ff010d040e,
        0x030eba83b0d2ffba, 0xffba1e135fff011b, 0x01b099043a8f79ec, 0x014c010e016c5904, 0x01390504013e1304, 0x7cf7ffbb1ea4c7ff, 0xfeff0147000a3b12, 0x3c2e78a6ff3bbf3e,
        0x01590b04015e1a04, 0x48cbffbb6c62a8ff, 0xa1ff0167060eba8b, 0xbb0c4109ff3b8836, 0x0182000d01906305, 0x26c223ff017d070b, 0x71043b9f0d14ff3c, 0xff3c9721c9ff018b,
        0x01a200023d042c22, 0xdc143eff019d020d, 0x010b3ca44db2ff3b, 0xff3c9cc36aff01ab, 0x01f8000bbb94669c, 0x01ca000e01d8010e, 0xd4b879ff01c5050d, 0x050dbbab80a3ffbb,
        0xffbb8368ffff01d3, 0x01ea010abad478ef, 0x075df7ff01e5170e, 0x0a06baeaa1dfff39, 0xff3a51796fff01f3, 0x021c060e3b980ed7, 0x0209010a020e010d, 0x9039ffbaead7a8ff,
        0xacff0217010e3ba0, 0x3c9127f9ff3b8e34, 0x02297a05022e010a, 0xbb43ff3c76f382ff, 0x6cff0237ac043c21, 0x3d1c032dff3cbef9, 0x0000000500000013, 0x00000001000003e8,
        0x012001110000023c, 0x0050220100942a01, 0x00220c0100305b04, 0x049e9bff001d2704, 0x020dbb14a80effbb, 0xffbaf60da0ff002b, 0x00421901bacf5ec5, 0x59a494ff003d2305,
        0x0007bb107648ffbb, 0xffbacbf99eff004b, 0x0074010dbb15ee5c, 0x0061010a00660011, 0x7c38ffbaf76e69ff, 0x25ff006f010ebada, 0xbad61262ffbaaa79, 0x00810e0400864204,
        0x60cbffbaea34dfff, 0x30ff008f6304baad, 0xbb32e8eaffba281c, 0x00bc000700dc000d, 0x00a9040b00aea204, 0xa08fffbb0d4369ff, 0x5fff00b79805bb01, 0xbb0bd648ffba9f99,
        0x00c9740500ce000a, 0xb6f0ffbaec758dff, 0x36ff00d7060ebb07, 0xb9e3b6e3ffbabc89, 0x00f2050d0100010e, 0xcfd7a2ff00ed000a, 0x7b04ba6a0165ffba, 0xffba943bf9ff00fb,
        0x011200073a76d14f, 0xe16719ff010d7905, 0x0002ba6bc330ffba, 0xffb999e6ecff011b, 0x01b001073a8b6f9f, 0x014c0c03016c2d05, 0x0139000d013e0605, 0xeea7ffbb8307b4ff,
        0x94ff0147060ebbe8, 0xbb5b30c6ffba8688, 0x01590706015e0c0e, 0x07f0ff3ae2bf74ff, 0xbaff01670205b98f, 0xba85b52cff3a3541, 0x0182000a01900007, 0xc2f143ff017d000d,
        0x2c013b347e53ffba, 0xff3bddcb91ff018b, 0x01a2000d3b3f6f37, 0xaacbc4ff019d000a, 0x82053bcad580ffb9, 0xff3c6c4fc4ff01ab, 0x01f8010d3b21b18e, 0x01ca0d0e01d8000a,
        0x0d15e4ff01c58004, 0x9404bba234dcff3b, 0xff3c8a9d7dff01d3, 0x01ea0e0e3b44b756, 0x099635ff01e58104, 0x000d3a11eb6dff3c, 0xff3c09ef88ff01f3, 0x021c060e3d348ec7,
        0x02093d04020e9004, 0x4495ff3bae7c5cff, 0x8bff021796043ca3, 0x3c016c1cffbcbd72, 0x0229000a022e4201, 0x3e05ff3d887b25ff, 0xb3ff023796043dc0, 0x3c80f407ff3d385f,
        0x0000000500000013, 0x00000001000003e8, 0x012001110000023c, 0x005089050094020d, 0x002286040030a304, 0xbe7158ff001d7404, 0x4405ba894c59ffba, 0xffb96bdd54ff002b,
        0x0042090eba95da2d, 0xad99d3ff003d0002, 0x000db9857008ffba, 0xff390eb7fcff004b, 0x0074010a3afe3327, 0x006100020066ba04, 0xe770ffbae40e5fff, 0x11ff006f060eba9d,
        0xbb5b7c58ffbb0c5a, 0x008100020086be04, 0x5349ffba98a094ff, 0xb7ff008f060eba25, 0xbad38b2bff393e00, 0x00bc000700dc040e, 0x00a9001100ae9e05, 0xdad6ffbac4e5caff,
        0xe4ff00b7020bba92, 0xbaf75c1effba14a1, 0x00c92f0400ce4904, 0x6120ffbab1d4b9ff, 0xd4ff00d7000aba6c, 0x39ce348bffba0df5, 0x00f2000701009e04, 0x8cb9d4ff00ed2e01,
        0x0002ba9311c9ffbb, 0xffb9cbc56dff00fb, 0x011200073a66bace, 0x422e69ff010da704, 0x050b3850c3baffba, 0xff3ac6d68dff011b, 0x01b001073b2d7f44, 0x014c0804016c3105,
        0x0139000a013e000d, 0xbbe0ffbb9c40ebff, 0x45ff01470007bb33, 0xbb75cd0aff3a74da, 0x0159010b015e010e, 0xd03effbb37c73eff, 0xacff01670c0e3b75, 0xba24ea91ff3a7c92,
        0x018200020190030e, 0x89c733ff017d5e04, 0x6f043c320f0eff3b, 0xff3c65a69dff018b, 0x01a2060eba5ed287, 0x6dae8bff019d010a, 0x00073baa1d51ffb9, 0xff3b14b1d0ff01ab,
        0x01f8010d3c2569b7, 0x01ca150101d82701, 0xa339faff01c5060e, 0x040bbb9cceedffba, 0xff3b4544a0ff01d3, 0x01ea5205ba7e260a, 0xadca70ff01e57104, 0x7d043c6a5e60ff3b,
        0xff3befac3fff01f3, 0x021c060eba621501, 0x02097404020e9104, 0x4fecff3c17c61cff, 0x35ff021796043cb9, 0x3bcf1357ffbcc320, 0x0229000a022e4201, 0xcb38ff3d5a5ea2ff,
        0xc3ff023796043d99, 0x3c4e533eff3d137f, 0x0000000500000013, 0x00000001000003e8, 0x012001110000023c, 0x0050190100942a01, 0x0022001100305504, 0xb39439ff001d010a,
        0x1101babd9a5bffba, 0xffbaa9ead3ff002b, 0x00420007ba8f677c, 0xbf1752ff003d8104, 0x8104bb09db06ffba, 0xffbb139bd4ff004b, 0x00740011bb54c6de, 0x006128010066060e,
        0x71b1ffba9fe58bff, 0xbaff006f3d05ba72, 0xba898c88ffbac435, 0x0081030e00862301, 0x8465ffba69150aff, 0x48ff008f030eba9b, 0xba81b8ceffba200b, 0x00bc000700dc000d,
        0x00a9020b00aea304, 0x051effbaccaaaaff, 0x3eff00b7010abab1, 0xba2f274effbaa9de, 0x00c9010a00ce0011, 0x3b4dffbab048dfff, 0x2aff00d7000aba45, 0xb9e74d4cffba94f3,
        0x00f29c040100010e, 0x9106a9ff00ed0007, 0x7f05ba1d2b08ffba, 0xffbaddf674ff00fb, 0x01129005ba9e3b49, 0x06a74eff010d9804, 0xbc043a1f48ffffba, 0xffba8bd729ff011b,
        0x01b00107bb33447b, 0x014c1c05016c3205, 0x0139020d013e0703, 0x0fe2ffbb29c9f6ff, 0x54ff0147000abc1f, 0x39805c53ffbada34, 0x0159000d015e010a, 0xb7c0ffbb18ae1eff,
        0x7bff0167030b3ab9, 0x380eeae7ff3bbef8, 0x01828f040190030e, 0x73cdf7ff017d6a04, 0x020e3c56096dff3b, 0xffbad51eabff018b, 0x01a2000a3bef620a, 0x9906aaff019d5805,
        0x000d3a4c6664ffba, 0xff3b48a1eaff01ab, 0x01f8010d3cb4d892, 0x01ca0d0e01d8000a, 0x281c10ff01c58204, 0x9404bb76422eff3a, 0xff3c36fe24ff01d3, 0x01ea000db9a8afa7,
        0xf9f0c5ff01e52701, 0x56053b9806f6ffb9, 0xff3c3d91b7ff01f3, 0x021c030e3a5dc6d6, 0x02091d01020e000a, 0x6f40ffbb50bc37ff, 0x92ff02172e043c08, 0x3cac8f21ff3a7004,
        0x02298e04022e3e01, 0x9818ff3d4234dfff, 0xf3ff023796043d80, 0x3c250f62ff3ce225, 0x0000000500000013, 0x00000001000003e8, 0x012001110000023c, 0x005096040094070d,
        0x002200110030020d, 0xaace98ff001d000e, 0x9004ba8397baffba, 0xffba4c5e81ff002b, 0x00428104baaba66a, 0x597b26ff003d4204, 0x7305b9eb1f2cffba, 0xff3a0e1c2bff004b,
        0x00746d05ba078502, 0x0061000d0066a504, 0xdba9ffb988e7caff, 0xf2ff006f58053a10, 0x3a4fd6fdff3af2ac, 0x0081040d00860002, 0xdcf9ffba875e48ff, 0x71ff008f00113adc,
        0xb9909ca0ffba8cf5, 0x00bca20400dc0002, 0x00a9030b00ae0007, 0x4424ff3a07f652ff, 0xafff00b79204badc, 0x3b3b1422ff3aab7b, 0x00c9a70400ce8d05, 0xcbaaff3bba8b92ff,
        0x7eff00d78f053b9b, 0x3b3d2830ff3b0be0, 0x00f2940401006505, 0xb365f6ff00ed9204, 0x9f04bb457f6aff3a, 0xff3b629b82ff00fb, 0x0112a204b8c10fe0, 0x5242f9ff010d9104,
        0xa304ba9fe81dff3a, 0xffbb93bd51ff011b, 0x01b001073ab2a190, 0x014c1905016c3205, 0x01390205013e050b, 0xcecaff3a6c396bff, 0x45ff01472f04ba01, 0xbbc141b8ffbaf927,
        0x0159020d015e0f04, 0xc7ddffbb01f0eaff, 0xf0ff0167030e3b8b, 0x3a2de74bff3b4a0b, 0x0182260101900007, 0xd68806ff017d010d, 0x2c013c05dd3cff3a, 0xff3ba4645fff018b,
        0x01a2840539401c4f, 0x8d81b3ff019d4d04, 0x010d3c0f4f64ff3a, 0xffbadbbb2aff01ab, 0x01f8070b3bd57ce6, 0x01ca0c0401d82004, 0x427cf2ff01c5020d, 0x0a01bc176733ffbb,
        0xffbb0d472cff01d3, 0x01ea7204397f764d, 0xb8b9c5ff01e53505, 0x60053a425376ff3b, 0xff3c4d1591ff01f3, 0x021c7e043b00fdfc, 0x02096804020e7204, 0x074bff3ab28e65ff,
        0x95ff0217000dbbbd, 0x3cca6a4fff3beefe, 0x02299a04022e060e, 0x54d8ffbc5e2e8bff, 0x74ff0237a304bb1b, 0x3c8df3c5ff3baf5f, 0x0000000500000013, 0x00000001000003e8,
        0x012001110000023c, 0x0050190100942a01, 0x0022060e00305704, 0x600111ff001d1501, 0x000dba3baee7ffba, 0xffba7ebd1aff002b, 0x00421d05baefadf6, 0x8f9b58ff003d0012,
        0x2605bb02d467ffba, 0xffbab44f9aff004b, 0x00742401ba81e511, 0x0061030e00669304, 0x3621ffba26d127ff, 0x9eff006f000dba57, 0xbb98cb30ffbab062, 0x0081000e00861d04,
        0x81e6ffba398ad8ff, 0x51ff008f060eba5b, 0xba62e1c5ffb9dc39, 0x00bc740500dc000d, 0x00a94b0500aea204, 0x1a07ffb9f35449ff, 0x3fff00b7130eba55, 0x3a5ce79effb9a0fe,
        0x00c9050b00ce010a, 0x0d35ffba903822ff, 0x64ff00d7a604ba59, 0xb9a034cbffba631f, 0x00f2060e0100040d, 0x3f0a60ff00ed000a, 0x0007b91bd975ffba, 0xffba2e28d3ff00fb,
        0x01127b043a2e0042, 0x28ddfdff010d0002, 0x00073afa07ecffba, 0xffb974e7c0ff011b, 0x01b001073aa9c6f0, 0x014c010a016c3805, 0x0139000a013e000d, 0x562affbb693069ff,
        0xdaff0147000aba81, 0x3a4f4af6ffb9d913, 0x01590301015e1d05, 0xe27dffbb17103fff, 0x99ff0167030b3a0f, 0x398a8917ff3bb225, 0x0182020d0190000a, 0xa5760cff017d060e,
        0x96043b0de449ffba, 0xff3be74990ff018b, 0x01a2010d3a3d0bf8, 0xa74722ff019d7f04, 0x4b0538f0eec2ff3b, 0xff3ce24b95ff01ab, 0x01f8070b3c5056c9, 0x01ca0a0101d85404,
        0x01e886ff01c5000d, 0x4201bbaa703affbb, 0xff3b04f0c0ff01d3, 0x01ea3405ba639a81, 0xb613bfff01e5000d, 0x00023c9d2be8ff3b, 0xff3bbea6ceff01f3, 0x021c4f05b97765cd,
        0x02091301020e2501, 0x601bffbb9a5d5bff, 0xfaff0217000dba9b, 0x3c05d1b4ff3a95bb, 0x0229a504022e060e, 0x58c7ffbbd8b0a5ff, 0x27ff02375405ba31, 0x3c454f08ffbc100f,
        0x0000000500000013, 0x00000001000003e8, 0x012001110000023c, 0x005087050094020d, 0x0022490500307304, 0x21c467ff001d0002, 0x020bb867bd9bffba, 0xffba5f821cff002b,
        0x00420007ba305ef9, 0x23e0d3ff003dad04, 0x000ab8602f00ffba, 0xffba377512ff004b, 0x0074ba0438afd42d, 0x006165040066000e, 0xf899ffba673ef2ff, 0x98ff006fb004bad2,
        0xba3e7506ffb9f75a, 0x0081010a00860011, 0xf6b2ffba1ac592ff, 0xb7ff008f010a399b, 0xba318e6cffbac481, 0x00bcb80400dc0002, 0x00a9001100ae7e04, 0x7352ffba25f893ff,
        0x45ff00b7030bb992, 0xb9f8fcffff39e927, 0x00c9bd0400ce0007, 0x748fffba9876c6ff, 0x1cff00d7010bba20, 0xbacf8dbeff3a8e20, 0x00f2001101007205, 0xb488a3ff00ed6105,
        0x0007ba897550ffb9, 0xffbaa57e83ff00fb, 0x0112ba043a88db2d, 0xbdfb1aff010dac04, 0x000a3a5c19eaffb9, 0xffbab2c5afff011b, 0x01b00107b8899bb3, 0x014c1104016c2d05,
        0x0139000a013e0304, 0xba51ffbb3c47dfff, 0x3eff0147000dbad1, 0x396cedc8ffbab201, 0x01592301015e030e, 0xe7faff3b63329fff, 0x77ff01670b06bb18, 0x3b66ab94ffb89600,
        0x0182000a01900007, 0xaaeaeeff017d8b05, 0x2c01bad2798cffb5, 0xff3b41be76ff018b, 0x01a2010d39746396, 0xb5ee24ff019d000a, 0x000a3ba4405dffba, 0xff3bf5c7ecff01ab,
        0x01f8010d3ca63056, 0x01ca010e01d8000a, 0x37c201ff01c57904, 0x0e0ebba77a62ffb9, 0xffb9857150ff01d3, 0x01ea000d3b89338b, 0x9a1ed2ff01e52901, 0x010e3b253c84ffba,
        0xff3b974c7bff01f3, 0x021cbc043cccbdd8, 0x02092804020e030e, 0xe3bcffbb139a8aff, 0x65ff021740013bc9, 0x3c666bd9ff3d244a, 0x02290002022e9805, 0xaeb2ff3ca85c45ff,
        0x40ff02370002bc79, 0xbc410815ffbbb2b3, 0x0000000500000013, 0x00000001000003e8, 0x012001110000023c, 0x005096040094070d, 0x0022000a0030020d, 0x466f66ff001d020b,
        0x6a04ba0ac770ffba, 0xffb9f75fdfff002b, 0x00427204b962215a, 0x0191e3ff003d2001, 0x0011b96f8ef2ffba, 0xffba2e72caff004b, 0x007458053990baa9, 0x006100020066a404,
        0x6ca7ff392fddf2ff, 0x8eff006fa5043a87, 0x3aafc43aff38a486, 0x0081000a0086040d, 0x6952ffba265539ff, 0xf4ff008f030bb96b, 0xb9578153ff3aa4b5, 0x00bca20400dc0002,
        0x00a9030b00ae8005, 0xa414ff3abb0470ff, 0xffff00b79e04ba9d, 0xba563256ff3a37e9, 0x00c98f0500ce0007, 0x8edeff3ada44a0ff, 0xe1ff00d7a8043b14, 0x3b4dc484ff3b87e1,
        0x00f2000701009104, 0xf6efb4ff00ed7405, 0x860439be4e40ffba, 0xff3a88ba33ff00fb, 0x011292043ae564a9, 0x8c330aff010d8205, 0x6105bb265afbffbb, 0xff3aa5881aff011b,
        0x01b00002b8265b94, 0x014c020d016c3a04, 0x01394b05013e000a, 0xb016ffbab4f2e9ff, 0x8aff0147010dbb2e, 0x3b6c5332ffb8e782, 0x01591601015e1a05, 0x6e7effbb82bb71ff,
        0x75ff01674b053b1c, 0xbbccda03ff3b7f3b, 0x0182720401909904, 0x73a02fff017d4201, 0x000dba150a08ff3b, 0xff3b1289d1ff018b, 0x01a29a043c42d0fa, 0x3d50a6ff019d000a,
        0xa604bcb4f7cbffbc, 0xffba3cafcaff01ab, 0x01f868043aa57abc, 0x01ca010d01d8000a, 0x1d81efff01c56204, 0x00073c0038f7ff3b, 0xffbb5bbcfdff01d3, 0x01ea00073cc8ee9a,
        0xffe0fdff01e5010e, 0x010a3aee4d22ff3b, 0xff3c9aa286ff01f3, 0x021c98043cfb8aa6, 0x0209030b020e6f04, 0x4e96ff3ae6f129ff, 0x99ff0217010b3d03, 0xbc010144ff3c9a5b,
        0x02299d05022e010a, 0x17f0ffb9e99d53ff, 0x93ff02370b0ebbba, 0x3c60a3a7ff3b12b8, 0x0000000500000013, 0x00000001000003e8, 0x012001110000023c, 0x005096040094070d,
        0x00220f0e0030020d, 0xd7188fff001d7104, 0x110eb93cb803ffb9, 0xff38c0c494ff002b, 0x00428104ba4383eb, 0x87d11eff003d6804, 0x0011b93a0941ffb9, 0xffba14720fff004b,
        0x0074580539b9a648, 0x0061010a00669704, 0xf5b9ffb99746c9ff, 0x89ff006f0002baae, 0x3a82f688ff39cda5, 0x00818d050086090b, 0xae99ff38ce2f07ff, 0x68ff008f0002ba1d,
        0xb897363effba1300, 0x00bca20400dc0002, 0x00a9920400ae7605, 0x102bff3a618cfaff, 0x4dff00b792043b21, 0x3a516465ffba2b1e, 0x00c9a80400ce8705, 0xfbc8ff3b596966ff,
        0xa8ff00d78d053b08, 0x3ace2758ff3b403e, 0x00f265050100a704, 0x1b7970ff00ed9404, 0xa2043a9b722eff38, 0xffba19b8a7ff00fb, 0x0112ad04bb2cf487, 0x020e19ff010d020b,
        0x020b3b891990ff3b, 0xffbaccf3aaff011b, 0x01b070053b3fb648, 0x014c3005016c6b05, 0x01390107013e050b, 0xb104ff391a47b2ff, 0x03ff014730013ade, 0x3b8891aaffba9fee,
        0x01597204015e000d, 0xc942ffb9fdeea5ff, 0xa7ff016780043b0b, 0x3a305c3eff3b66bf, 0x018202070190a504, 0x28c48fff017d8a04, 0x010e3beb5451ff39, 0xffbc835120ff018b,
        0x01a2020abb3cc41d, 0x40cccbff019da804, 0x010b3c0b8034ff3c, 0xff3cc716e3ff01ab, 0x01f882043ca0bb62, 0x01ca730501d87404, 0x9e52abff01c55c04, 0x010ebbb035d1ffb6,
        0xff3b236995ff01d3, 0x01ea010ebabb7ced, 0xd9e34eff01e5000a, 0x71053cbec80fff3b, 0xffbc95a03bff01f3, 0x021ca4043b63f8c3, 0x0209020d020e9704, 0x5ba7ffbbed9bcdff,
        0x56ff0217060e3bff, 0x3bae36c2ffbb1940, 0x0229060e022e9205, 0x62ebff3b7379e5ff, 0xe4ff0237b7043c67, 0xbb44e514ff3ac50d, 0x0000000500000013, 0x00000001000003e8,
        0x012001110000023c, 0x00508e0400942a01, 0x00221e0400306504, 0x020ebbff001d0704, 0x2401b9c2a47bffba, 0xffb9a54384ff002b, 0x00423205b89f7c10, 0x1cb11aff003d1001,
        0x0d0eba483e24ffbb, 0xffb99eff11ff004b, 0x0074000d39933a68, 0x0061001200662601, 0xcdd5ffb9f11905ff, 0x30ff006f020abaed, 0x3a8109a1ffba160b, 0x0081960400863105,
        0x415fffbb681ad6ff, 0x3cff008f2301bba4, 0xbb10e6eeffbb202b, 0x00bc740500dc000d, 0x00a91c0500aea204, 0xe693ff3940f7a2ff, 0x0aff00b7130eb995, 0x3a089aafffb96840,
        0x00c9060b00ce010a, 0xe92affba1be14aff, 0x57ff00d7a804b9c4, 0xb81f06f6ffb9f864, 0x00f2050b01000011, 0xdbd578ff00ed9804, 0x5504ba6f5303ffb9, 0xffb9f38fdaff00fb,
        0x0112000ab9312607, 0x9231c6ff010d040d, 0x780539bdfd93ffb9, 0xff39c4ca49ff011b, 0x01b06505b7b6a2a0, 0x014c4b05016c4d04, 0x0139060e013e0f05, 0x511fffba30d09cff,
        0x54ff01474804bb35, 0xbb1fbc47ff3a420e, 0x0159000e015e5305, 0x2c3bff3aa24a14ff, 0x1aff01674201bbac, 0x36889ef5ffbb2d9c, 0x0182020e01900007, 0xf7b1e5ff017d3f01,
        0x140ebb14966eff3a, 0xff39eec18cff018b, 0x01a2000dba75262f, 0x3668bfff019d4201, 0x4001b9626796ff3b, 0xff3c8aefafff01ab, 0x01f8010d3ba056c8, 0x01ca800401d8060e,
        0xee3a29ff01c57404, 0xa3043c24cba0ffb9, 0xffbbb09210ff01d3, 0x01eaac043a0a8300, 0x108339ff01e57e04, 0x010a3b8e7c9affbb, 0xff3be246ecff01f3, 0x021c6e053cb3389e,
        0x02096a04020e6d04, 0x774fffba0c48d9ff, 0x87ff02179304bcc7, 0x3a87ebd7ff3c735c, 0x02298404022e8604, 0x5577ffbadeb4faff, 0x6fff02379104bd0b, 0x3a3779b6ff3c6199,
        0x0000000500000013, 0x00000001000003e8, 0x01201c040000023c, 0x0050011100943305, 0x0022000d00300201, 0x04008fff001d0001, 0x0805b9c90d4fffba, 0xffba31ebc2ff002b,
        0x00420012ba117a2a, 0xdeb596ff003d0804, 0x0504b9b0d0afffb9, 0xffb9bc5e25ff004b, 0x00741404b984dbb0, 0x0061010d00660007, 0x5ebdffba55968eff, 0x4fff006f010d3b39,
        0xbb92ba3affba87ea, 0x008100070086060e, 0x25dbff3b33f14bff, 0xc2ff008f170139da, 0xbbcedde9ffbb098d, 0x00bc010700dc0112, 0x00a9010a00ae0012, 0xcf18ffb9d6eb2dff,
        0xf4ff00b74b05b976, 0xb9e89f43ffb9733f, 0x00c9490500ce000a, 0xa582ffba35a17cff, 0x2bff00d70002ba0d, 0xb8f3d046ffba048d, 0x00f216040100030b, 0xe292a3ff00ed000a,
        0x010e3a9d24e6ffba, 0xffbb6ba6c4ff00fb, 0x01121e01bad3471a, 0x85c65fff010d1c01, 0x010ebba96306ffba, 0xff3b6bb733ff011b, 0x01b00111b8da6c0b, 0x014c010a016c0011,
        0x0139110e013e0207, 0x44e9ffb99e9280ff, 0x2bff01472005ba13, 0xba10dcd5ffb985d2, 0x0159090b015e2001, 0x54cdffb9c43f19ff, 0xfbff01676304ba16, 0xb96039afff38b27f,
        0x0182b70401900002, 0xc8dcf3ff017d9f04, 0x010ab95c8673ffb8, 0xffba663d58ff018b, 0x01a25805b95e46c9, 0xd75830ff019d9904, 0x98043a7bcf4fff39, 0xffba19779bff01ab,
        0x01f8010a3984e6a8, 0x01ca020b01d8070b, 0xb89692ff01c5010b, 0x010dba877293ffb9, 0xffb991bd08ff01d3, 0x01ea7d043b884915, 0x211002ff01e57104, 0x060e3bd48547ff39,
        0xffbb8f13c2ff01f3, 0x021c30053b3a71ba, 0x0209020b020e040b, 0x9bf4ff3a34c38aff, 0xd5ff02170d0e3b2e, 0xbbd80359ffbaeae9, 0x02290007022e010e, 0x7f92ff3b3e2373ff,
        0x4cff0237060e3c55, 0x3bd9fe40ff3a8d0d, 0x0000000500000013, 0x00000001000003e8, 0x012000020000023c, 0x00506e0500948d05, 0x0022690400306e04, 0x1abc5bff001d4a05,
        0x0111ba1b8396ffb8, 0xffb9930f26ff002b, 0x00420112bba05991, 0x9e9306ff003d0011, 0x9504393a07c2ffb9, 0xff3bc2ffc2ff004b, 0x0074010d37221877, 0x006101120066030b,
        0xa3b0ffb960234aff, 0xc6ff006f00073adc, 0xba4b2e84ffb8c0db, 0x0081011100868604, 0x512fffb9eddfccff, 0xb0ff008f0111bb81, 0x3c13d953ff352cc8, 0x00bc011200dca404,
        0x00a9000a00aea204, 0x51bcffb9527476ff, 0x42ff00b70012ba25, 0xba9060c1ff3a22e3, 0x00c9970400ce010e, 0xa130ffbc5f1e7cff, 0x5aff00d7a104bb51, 0xbbbd6713ffba0b2a,
        0x00f2b00401000112, 0xd473c0ff00ed030b, 0xb304b7023ae9ffb9, 0xffba9268b4ff00fb, 0x0112b504b9ef027a, 0x434bb3ff010db304, 0x9b05bb4218c2ff3b, 0xff3c1b4e4fff011b,
        0x01b06404b87aa92f, 0x014c0007016c0111, 0x01395f04013e6105, 0xef8fffb9cdc52bff, 0x88ff01474204ba1d, 0xb955fd7effb9d9ab, 0x0159010d015e000a, 0x47a0ffb887c94eff,
        0xdfff016748043a31, 0x3a335f7affb8f84f, 0x018200070190000a, 0x7f3b50ff017d7405, 0x010d3b614943ffbb, 0xff3b870a4cff018b, 0x01a248043c8d2405, 0x82d656ff019d3405,
        0x0007b9e1d453ff3b, 0xff3b9d99eeff01ab, 0x01f8020e3ca97984, 0x01ca4b0501d80111, 0x0de2e5ff01c57a04, 0x01073a6fe39eff39, 0xffb8f31959ff01d3, 0x01ea9604b9ab3a58,
        0x27687fff01e58404, 0xbb04bc6b428fffbb, 0xffba4a5dceff01f3, 0x021c030ebc1b0b8f, 0x02094b05020e6f04, 0x4e10ff3d082cacff, 0x5fff02179404bbc3, 0x3af528c6ffbb89bd,
        0x02290111022ea404, 0xeee0ffb9915e52ff, 0x5bff0237060ebaff, 0x3a9ed183ffb8f681, 0x0000000500000013, 0x00000001000003e8, 0x0120010e0000023c, 0x00505c0500946105,
        0x0022900400300111, 0xb713b5ff001d8f04, 0x010d3a763d48ffb8, 0xffbb62b124ff002b, 0x0042000aba08f280, 0xf6bd7aff003d030d, 0x81043a5492f3ffba, 0xff3b522b76ff004b,
        0x00740207bb932785, 0x00616f0400660111, 0xe762ffb8f584a7ff, 0x37ff006f72043a5a, 0x3ca73a3fff389e0a, 0x0081090b00860112, 0x3508ffb912d92cff, 0xf3ff008f0002bad7,
        0xbcbc1c4aff3bdecf, 0x00bc820400dc010d, 0x00a9650400ae6704, 0x342affb98ffb74ff, 0xa2ff00b70111bb5d, 0x3c0fa2caff3702df, 0x00c98d0400ce0111, 0x9b76ff38a05e48ff,
        0xc6ff00d79704b9d8, 0x391aef84ffbc1fcc, 0x00f2000201008904, 0x1a47e9ff00ed8304, 0x01123a0ff07effba, 0xff38cf8748ff00fb, 0x0112020b3c7ee75d, 0x93ad55ff010d0111,
        0x00023b8c3bd2ff39, 0xff3a3a9702ff011b, 0x01b00112bacb94b3, 0x014c070e016c8304, 0x01393504013e000d, 0xacdcffb95e33c9ff, 0x01ff01478004b88e, 0x39e8bb56ffb984aa,
        0x01595704015e000d, 0x013effb9ac1ab9ff, 0xebff01674b05ba05, 0xb9a83d14ff3aac60, 0x0182a70401907705, 0x30c91aff017d030e, 0x020ab8686500ff3a, 0xff3a5954eaff018b,
        0x01a2ba04b9b32695, 0x44b0ecff019d050b, 0x000236b7eaf4ffb9, 0xffb99e3a9aff01ab, 0x01f88705baaaae08, 0x01ca780501d80207, 0xf1888aff01c54504, 0xa60439d6aaa3ffb9,
        0xffbad2aff8ff01d3, 0x01ea020e3bdeaabc, 0x621a40ff01e56904, 0x000d3cebbf67ff3c, 0xff38902a28ff01f3, 0x021c030e3b8a006f, 0x0209020d020e000a, 0x7dc1ff3a1a8291ff,
        0x5dff02179c043c51, 0x3c7ae386ff3cf1f2, 0x0229a304022e0007, 0xeab3ffb9006faeff, 0xa8ff0237b7043b63, 0xbb8dd52affb9a253, 0x0000000500000013, 0x00000001000003e8,
        0x0120010e0000023c, 0x00505c0500946105, 0x0022040b0030000a, 0x89df44ff001d4c05, 0x050bba3c610fffb9, 0xff3a88cab7ff002b, 0x00425f04b98b9fca, 0x8f08b0ff003d0a0b,
        0x01113a23dbbbff37, 0xff3997ce20ff004b, 0x007402073bc38ce5, 0x0061700400660111, 0x36bcffb8cba8adff, 0x5fff006f6b043a35, 0x3c62cdc4ffb9b13c, 0x0081001200860111,
        0x3294ff3967f794ff, 0x12ff008f010dba84, 0x3c3112f6ffbc86a4, 0x00bc810400dc010d, 0x00a96d0400ae7204, 0xdfdcffb9a63ce6ff, 0x92ff00b7011139cf, 0x3c38b74fff3916fd,
        0x00c9011100ce9704, 0x05f9ffb901fb95ff, 0x79ff00d77f05bbff, 0x381d3286ffbb050f, 0x00f2000201008804, 0x13083bff00ed0111, 0x0112bac03708ffb9, 0xff38a605caff00fb,
        0x011291043c4bec4f, 0xf557c6ff010d0111, 0x01113c33683eff38, 0xffb90e0637ff011b, 0x01b00111baf5608f, 0x014c020a016c010d, 0x01397c04013ebc04, 0x68d6ffb9302c87ff,
        0x65ff0147060eb615, 0xbaab1215ff373f43, 0x0159af04015e090b, 0x9c7cffb8d792d6ff, 0xb1ff01678a0539a8, 0xb8dcab02ffbac2bb, 0x018200020190ba04, 0x0cca5dff017da204,
        0x000ab9e3fb7affb9, 0xff3937def7ff018b, 0x01a200023aab68da, 0x517f09ff019d010a, 0xbc043a97149effba, 0xffb9d69a9dff01ab, 0x01f8070bbb1b82db, 0x01ca030b01d8020a,
        0x10f7a6ff01c56405, 0x000d3a51be9eff39, 0xffba24e77bff01d3, 0x01ea1b013c4261a2, 0x805325ff01e5060e, 0x7404bb4c0e83ff39, 0xff3baa00c4ff01f3, 0x021c000d3a5b2630,
        0x02099b04020ea204, 0x1d9dffbaad3344ff, 0xd1ff0217060e3a01, 0x3bb7273effbad0db, 0x02296204022e4101, 0x9199ff3a37a307ff, 0xb1ff023786053c6c, 0x3ba01622ffbbb037,
        0x0000000500000013, 0x00000001000003e8, 0x012000020000023c, 0x00506e0500948d05, 0x0022090600300705, 0x7df869ff001d0112, 0xa404ba9334fcffb9, 0xffb9f7a0ffff002b,
        0x0042000d3b1f3833, 0x4d9779ff003d6e04, 0x0207390c5bd5ffb9, 0xff39a6b6dbff004b, 0x0074020d391ffdf3, 0x0061b60400660111, 0xc65bffb8db7edeff, 0xe8ff006f790438c7,
        0xbb0d7b38ff3abd63, 0x0081820400868604, 0x9646ff3894a6f5ff, 0xfaff008f0111bb89, 0x3c16778dff38d482, 0x00bc011200dca404, 0x00a9000a00ae0007, 0x45eeffb8ba7282ff,
        0x2dff00b7000ab9d8, 0xbaca4f7cffb9ec76, 0x00c99a0400cea104, 0xa47cffbba5e24aff, 0x9dff00d791053986, 0xbc4bf18cffbb672b, 0x00f2000701000111, 0x73e6eaff00ed9405,
        0xac04b94a374bff39, 0xff39071426ff00fb, 0x0112b504b9fd05fa, 0x14745fff010db304, 0x9b05bb213d2dff3b, 0xff3bf9f3e3ff011b, 0x01b064043815585d, 0x014c5504016c0111,
        0x01395204013e010e, 0x5edcffb939012bff, 0x0bff0147090bba8c, 0x39ee0ddfffb7bac4, 0x01592005015e3405, 0x2195ff3a61df42ff, 0xa3ff016700073a03, 0x395f16a3ffb90f25,
        0x01824b0501905e04, 0x2583f5ff017d010d, 0x030b3c511fd0ff3b, 0xffba1b3c22ff018b, 0x01a23405bbb6b62f, 0x37fee2ff019d000a, 0x000a3c8e5c74ff3c, 0xff3b96a0b8ff01ab,
        0x01f8020e3c29a2c9, 0x01ca010d01d80111, 0xd69efaff01c5a104, 0x000a38aaab36ffb9, 0xff37486cc7ff01d3, 0x01ea96043a9c1ee8, 0x38358aff01e5010b, 0xb704bbd665e7ff3c,
        0xffb965a27eff01f3, 0x021c030ebb824210, 0x02090007020e6f04, 0xb1a0ffbbecae00ff, 0xe4ff021794043cc3, 0x3aa75d1affbb65fc, 0x02290111022ea504, 0x01b0ffb9764ccbff,
        0xd7ff0237a804bad0, 0x38e17366ff3b23af, 0x0000000500000013, 0x00000001000003e8, 0x012008060000023c, 0x0050000200948404, 0x0022820400300111, 0x02e082ff001d6704,
        0x6405b8b1265fffb9, 0xffba6fd67fff002b, 0x00428104b8be1218, 0x004fbbff003d8004, 0x83043b5677fdff3a, 0xffbc20b4c1ff004b, 0x0074020a3b2ba0f5, 0x0061010a0066010d,
        0xfb0cffb9870e01ff, 0x1eff006f01113aa1, 0x3c2a3f16ff39fbf5, 0x0081020700860112, 0x3380ffba0a72daff, 0xacff008f000739b6, 0xbcfc4d87ffbc53d7, 0x00bc011100dc8504,
        0x00a9001100ae0012, 0xa20affb9b9fdcfff, 0xd1ff00b741013a99, 0xba43d0e1ff3a1104, 0x00c95d0500ce010d, 0xc523ffbca035ceff, 0x04ff00d7020bbb69, 0xbc95d417ffbd69cb,
        0x00f2490501000111, 0x0cca56ff00ed170e, 0x4a05ba00766eff3a, 0xff3aa6c2a5ff00fb, 0x01128c04b8c46dd9, 0x816322ff010d0002, 0x060ebbdf11c4ff3b, 0xffba1d74e5ff011b,
        0x01b00b053a405aaa, 0x014c040e016c170e, 0x01390705013e050d, 0x2034ffbb3c4b47ff, 0x0aff0147010e3988, 0x3b10ec13ffb98752, 0x01590f0e015e0005, 0x36bdff3bcb3c39ff,
        0x28ff01670f0e3b11, 0xb9cc79f6ff3adbd8, 0x018202050190030d, 0x6f8fcbff017d1a0e, 0x0a06baa271abff3a, 0xffbb39fe35ff018b, 0x01a2010abaa5f7b4, 0x637206ff019d000a,
        0x0002bba26845ffbb, 0xffbb08900dff01ab, 0x01f8040ebbbde03c, 0x01ca030d01d81b05, 0x7ad1f7ff01c59d04, 0x000ebb269592ffbb, 0xffbb5e2670ff01d3, 0x01ea000aba3a4250,
        0x1da027ff01e50a06, 0x2405bb713aabffbb, 0xffbb7b9d8fff01f3, 0x021c000abbc2c72b, 0x02090c0e020e1205, 0x7871ffba9240e7ff, 0xd1ff02170a06bb22, 0xbb7a57c5ff3a0a46,
        0x02290906022e0a06, 0xaf2eff3b814364ff, 0xffff0237030d3b01, 0xba6171b0ffbb66c0, 0x0000000500000013, 0x00000001000003e8, 0x0120020a00000233, 0x0050010d00940002,
        0x00225e0500309404, 0xb42ee6ff001d4f05, 0x0111b93e2f7affb8, 0xffb882d3bdff002b, 0x004222053a5db177, 0x0b36ddff003d9504, 0x970439e5b389ff3c, 0xffba6d37e9ff004b,
        0x00740111386bb08c, 0x0061000a0066040b, 0xe6b7ffb903a404ff, 0x0eff006f000a3938, 0xba6b1994ffb8d18a, 0x0081020b00868105, 0xeac6ffb9ab020fff, 0x93ff008fb9043b30,
        0x3c2ca1f2ffba22da, 0x00bc6f0400dc7705, 0x00a9000700ae0111, 0x552dffb985ffacff, 0x35ff00b76204393d, 0x3c00ebc0ff3abf20, 0x00c94b0500ce0112, 0xd4cdff3a1b3e5fff,
        0x9bff00d79404b8f6, 0xba6bcca3ffbbc8cf, 0x00f2a50401008b05, 0xef1ce3ff00ed050b, 0x01113829fdacffb9, 0xff3941b24cff00fb, 0x01128c053b911c41, 0x2acbe3ff010da804,
        0x9505bb3169dcff39, 0xff3a25688eff011b, 0x01b07405ba0cf656, 0x014c000d016c0112, 0x01395405013e070b, 0x7f11ffb501a89aff, 0xeeff01471201ba00, 0xbad92f06ffb96884,
        0x01590207015e9404, 0x2514ffbbb860adff, 0x55ff01679804bba9, 0xbb4be9ebffb88296, 0x018242010190a404, 0x24a515ff017d2801, 0x060e3c05cd69ffb8, 0xffbba6e55aff018b,
        0x01a2060e3bc2d938, 0x8c86d2ff019d5f05, 0x01073b7485e3ff3c, 0xff3c2b785cff01ab, 0x01f801113ca0a831, 0x01ca040b01d8be04, 0xb6eaf0ff01c50012, 0x7a05b785815fffba,
        0xffbaf266fdff01d3, 0x01ea060eb9f7d5d0, 0x19cf24ff01e59c05, 0x0007394cef90ff3b, 0xffb938c980ff01f3, 0x02139004baa0b52d, 0x02097805020e0002, 0x00ddff3c533036ff,
        0x043bc24170ff3d0f, 0xff022000070225a1, 0x523cd2ffbaa06761, 0xeb16ff022eb804bc, 0x133c2677edff3b21, 0xe800000005000000, 0x3300000001000003, 0x040120020a000002,
        0x040050000a0094b7, 0x1100220111003059, 0xb9190473ff001d00, 0x2b060eb82b88b2ff, 0x6cffba19aee3ff00, 0x0700428c04bb28f4, 0xb8bb416bff003d02, 0x4b0207b9e29974ff,
        0x13ff37802c80ff00, 0x040074020bb9ec6b, 0xff0061690400666a, 0xcf1e1bffb92ba34d, 0x13e6ff006f7904bb, 0x01388fcee1ff3b3d, 0xff00818e04008635, 0x9b7e33ffb899230b,
        0xbffeff008f0111b9, 0x0a3afc3b1fff38dc, 0x0e00bc011100dc01, 0xff00a9000200ae06, 0x245964ffb9d0ee4e, 0xbaa4ff00b7bc0438, 0x04bab5cde5ffba30, 0xff00c9010d00ceb8,
        0xfa95baffbbebb2c8, 0xd9ebff00d7bc043b, 0x04bbbe8033ffb9d0, 0x1100f2060e0100b8, 0x392869f5ff00ed01, 0xfb0112bc26b081ff, 0xceff39d22115ff00, 0x0e011200023c8101,
        0x39fd7c5dff010d0f, 0x1b0111ba1e056aff, 0xd8ffb910938dff01, 0x0501b0ab043bcfd5, 0x01014c3301016c74, 0xff01394105013e25, 0x65e547ffb8b9fb58, 0x2cd9ff014701113a,
        0x013bf3da80ff399e, 0xff01590112015e3e, 0xd85be4ff3a49dbc7, 0xa632ff016776043b, 0x07ba3560b7ffbbb5, 0x0501820112019000, 0x39c42d7cff017d7f, 0x8b9004b9a36f03ff,
        0xe2ff3c6ac12bff01, 0x1201a2a1043b338d, 0xb9232e30ff019d00, 0xab0002bc1338b7ff, 0x17ffbae40c88ff01, 0x0501ef01113b172f, 0x0501ca000201cf4e, 0x3a7e09b0ff01c546,
        0x38f0ff3b04f4d9ff, 0x000d01e1050bba97, 0xff393e320bff01dc, 0x01ea5c05b9f3aead, 0x56f5ffbb973186ff, 0xb7040213060eba0a, 0x3aff0200b5040205, 0x3c18a13fff3ac81f,
        0x46661fff020eb804, 0x01073c13b2b8ffbc, 0x28ff0220ac040225, 0x3bcb879eff3b3372, 0x705656ff022e0207, 0x00133c8964baff3c, 0x03e8000000050000, 0x023c000000010000,
        0xb7040120020a0000, 0x420100504d050094, 0x2505002236010030, 0xffb922477fff001d, 0x002b011138c5df15, 0x955bff3a039668ff, 0x0002004270043b96, 0xffba6a41a5ff003d,
        0x004b48053a9bb8c0, 0xefefffb928f5f1ff, 0x02070074a9043b04, 0xccff0061000a0066, 0x385e7903ffb8d02e, 0xf0819eff006f0111, 0x020bbb545277ffb9, 0xe7ff0081b5040086,
        0x3b3c8f7dff39b275, 0x06677aff008f0111, 0x010a3a8648d0ff39, 0x030600bc0b0600dc, 0x3eff00a9010b00ae, 0xba03b896ff399235, 0x5f2de4ff00b70a06, 0x050eba859083ffbb,
        0xa2ff00c9040d00ce, 0x3a26a463ffbb2b3b, 0xa80cb2ff00d70205, 0xb8043ac13c47ff3b, 0x011100f2060e0100, 0xff3906bb2cff00ed, 0x00fb0111bc055a00, 0x694bff39a81a75ff,
        0x0b06011200023c4e, 0xff3899a81fff010d, 0x011b01113b4e7c17, 0x44aeffb8e75294ff, 0x2c0101b070053ba6, 0x2205014c2101016c, 0xc2ff01390d0e013e, 0xbad7d4b5ffb8c558,
        0x1abe56ff0147030e, 0x01123a153037ffbb, 0xf4ff01599104015e, 0xba34c7ddff398170, 0x046a64ff01672801, 0x3e013c4c28bcff3b, 0x7004018201110190, 0xffb988253fff017d,
        0x018b87043a621ce0, 0x40bdff3b6a3c48ff, 0x3f0101a2060e3d8c, 0xffbc0f38c8ff019d, 0x01ab0111ba8b4e28, 0x1bb6ffb9857372ff, 0x001201f801123bf7, 0x8a0401ca7b0501d8,
        0xffb8ffc4f8ff01c5, 0x01d3010738eeeb55, 0x2162ffba88fcc9ff, 0x000201eabe04baf4, 0xffb93c102aff01e5, 0x01f3060e39afd6c7, 0x026eff3ad1ef95ff, 0x9004021c0007ba41,
        0x37ff02090002020e, 0x3c35e8c3ff3c852a, 0x6768ebff02179f04, 0xa4043b96c1caffba, 0x36ff02297705022e, 0xbbfe02abff3b1e4f, 0xa7896bff02378005, 0x0013ba5f8d1eff3b,
        0x03e8000000050000, 0x023c000000010000, 0x8e05012000020000, 0x420100504b050094, 0x4f0400222f010030, 0xffb88988c4ff001d, 0x002b0111b83f7b5e, 0x39a3ff39965a03ff,
        0xb404004245053b3a, 0xffb98ff53aff003d, 0x004b4705bb021bfb, 0xd159ffba815f86ff, 0x0207007401123b33, 0xebff0061010a0066, 0xb931abf5ff371e0a, 0xfc047aff006f4f05,
        0x6e04b9fc5e4cff39, 0x3bff00814f050086, 0xbabcbc38ffbb9c47, 0x9192a0ff008f020e, 0xa404383a5759ff3b, 0xa20400bc011100dc, 0x96ff00a98f0500ae, 0xb8647e4dffb9c927,
        0x80984dff00b7040b, 0x000db9860a88ffba, 0x45ff00c9000a00ce, 0xbb4298bcff3a8eef, 0x014bdbff00d79704, 0x010dbb23cc18ffbc, 0x030b00f201110100, 0xffb9f1871dff00ed,
        0x00fba904b7861d2c, 0xbc5cffbb1b7f7eff, 0x01120112a8043b3f, 0xffb9bc90efff010d, 0x011ba9043cb759e2, 0xf0dbffbc254537ff, 0x011101b06404b955, 0x0011014c4204016c,
        0x45ff01392904013e, 0xba2ef51dffb997a4, 0x26328fff01472005, 0x030bb91bce0bff39, 0x89ff01595504015e, 0xb74a9827ffb970a7, 0xc184caff01670007, 0x00073985751dff37,
        0x000a018274050190, 0xffbb6ef07fff017d, 0x018b010eba4ebe97, 0x38daff3b9f2084ff, 0x010e01a25a043a35, 0xffb961273fff019d, 0x01ab000a3b756de5, 0x4140ff3b885edbff,
        0x011101f868043c2e, 0x000d01ca010701d8, 0xff398a4996ff01c5, 0x01d302073a4688f5, 0x6003ffb73f3f00ff, 0x580501ea000db9ea, 0xff3bad894eff01e5, 0x01f3000a3ab55b35,
        0x99b4ff3bf46d43ff, 0x7204021c030b3c67, 0x92ff02090111020e, 0xbbfec239ffb85f27, 0xe7b59aff02170207, 0x010ab9ac6765ffb8, 0x09ff0229020d022e, 0x39cca986ffb986c5,
        0x0d735dff0237a204, 0x0013399f7198ffbb, 0x03e8000000050000, 0x023c000000010000, 0x8d05012000020000, 0x011100506f050094, 0x97040022a0040030, 0xffb82a9239ff001d,
        0x002b090e398a00f3, 0xbdfdffba5d2d9bff, 0x000a00426e053996, 0xffb9d115fbff003d, 0x004b76043a15f1c4, 0xc137ff3ad86f01ff, 0x010d0074020dbc89, 0x45ff00617e040066,
        0xb9e4b6e9ff398da8, 0x834ad5ff006f9204, 0x02073a1ee715ffbb, 0x8dff008186040086, 0x3aa12b69ffba262c, 0x85c754ff008f0112, 0xa904bc0d1e50ffba, 0xa40400bc011200dc,
        0x22ff00a9a10400ae, 0xb9e617b3ffb89f6a, 0x5ce872ff00b79005, 0x9a0439738e1affb9, 0x3aff00c9930400ce, 0xbc044cfaffba7b70, 0x25fb8aff00d79c04, 0x010dbb11f065ff3b,
        0xb80400f201110100, 0xffb97bdd84ff00ed, 0x00fb9a05b81e7b04, 0xe6ddff3b5a87b9ff, 0x01120112010bb8a4, 0xff3aaca480ff010d, 0x011bb9043bf79c6e, 0xc5e8ffba6a5b3dff,
        0x011101b0640439a1, 0x0011014c4204016c, 0x76ff01390107013e, 0xb9ee4795ffb930d9, 0x04f543ff01472005, 0x030bb8f949aeff39, 0x45ff01590107015e, 0xb8f5501dff386865,
        0xd0057bff0167000e, 0x0007393c61d9ffb9, 0x010a018261050190, 0xffbb543693ff017d, 0x018b010e3aa5add0, 0x5aa7ff3b29e434ff, 0x000d01a25a04baa4, 0xff3b4457e8ff019d,
        0x01ab000ab9341f43, 0x6769ff3b5a3163ff, 0x011101f8020e3c0b, 0x010a01cab30401d8, 0xffb7895331ff01c5, 0x01d3b504b9da7c60, 0xe16cff3b21797dff, 0x010d01ea79053980,
        0xffbc03b395ff01e5, 0x01f3010abaac7890, 0x9a4affba13a5dfff, 0x0112021c030e3baa, 0x49ff0209bc04020e, 0xbaffcfc2ff3a27d4, 0xe40777ff02179f04, 0x93053bc6fc97ffbb,
        0x2bff0229a604022e, 0x39f2ada2ffb9b59b, 0xd8bcbfff0237aa04, 0x0013b9dcf2c8ff3a, 0x03e8000000050000, 0x023c000000010000, 0x8d05012000020000, 0x680500506e050094,
        0x000a002202070030, 0xffb92a1db8ff001d, 0x002b100e38ece08a, 0x919eff385f13d0ff, 0x6e040042070b39cb, 0xffb9c8b90eff003d, 0x004b01113af080e4, 0xcdf4ffb8bc491eff,
        0x020b0074010dbb4d, 0xc8ff006193040066, 0xbb3412d2ff395c68, 0x451873ff006fab04, 0x01073a2ebfd4ffb9, 0x52ff008171050086, 0x39811dcbffba59aa, 0x2039acff008f7605,
        0xa904baa7cbaaff3b, 0xa40400bc011100dc, 0x63ff00a9000a00ae, 0xb9c1460effb830de, 0x30b9f6ff00b79005, 0x010e3942d818ffb9, 0x73ff00c98d0400ce, 0xbaf79391ffbbf26b,
        0x0b5d89ff00d7020d, 0x010d3bcd80e7ffba, 0x030b00f201120100, 0xffb9c96294ff00ed, 0x00fb9a05361a716e, 0xec20ff3b2ed2fbff, 0x01110112010bb883, 0xff3a8a1d34ff010d,
        0x011bae043bc616bf, 0x631bff3ae4f4c5ff, 0xad0401b00112b9d3, 0x9804014c7f05016c, 0x6dff01398d04013e, 0xba43306eff388c34, 0xd54746ff0147000a, 0x01073a3c1c4effb8,
        0x31ff0159010e015e, 0xb9980f9eff36c07a, 0x54adb8ff01678205, 0xbb04b8f80949ffba, 0xb504018200110190, 0xffb9f0c9ceff017d, 0x018b000ab8983513, 0x1039ff38d8f3a0ff,
        0xbd0401a291053a7d, 0xffbb5059d3ff019d, 0x01ab0011ba1cac92, 0xd81bff3a335fc8ff, 0x580501f86f04b9b8, 0x010d01ca5a0401d8, 0xff3a54980cff01c5, 0x01d3000d3bbb81ee,
        0x52e8ff3b77f646ff, 0x640401ea010d3bfe, 0xff39901498ff01e5, 0x01f3010e3baac1cb, 0xa154ffbb87d540ff, 0x8204021c010abc17, 0xf5ff0209010d020e, 0x3c492252ffbb9e3b,
        0xb7e54eff0217020e, 0xa404b8ab24eaffba, 0x41ff02290207022e, 0xbbcfed8affba5048, 0x10f1b6ff0237a804, 0x00133ad13e71ff3c, 0x03e8000000050000, 0x023c000000010000,
        0x8d05012000020000, 0x0a0500506e050094, 0x0111002209060030, 0xffb8d0e8d7ff001d, 0x002ba404ba7fdee1, 0xef5effba014812ff, 0x790400426d053af9, 0xff3861bedfff003d,
        0x004b011138bf4419, 0x41e8ffb991330dff, 0x020b0074010d3bc2, 0xcaff006193040066, 0xbb100f11ff393053, 0x4864cdff006fa804, 0x01073a28b0b7ffb9, 0xdbff008171050086,
        0x394e95f2ffba2e21, 0x8ffce6ff008f9204, 0xa904ba47c25fff3b, 0xa40400bc011200dc, 0xccff00a9000700ae, 0xb9aad932ffb7bd25, 0x2af71eff00b70107, 0xa8043a016eebff38,
        0x5fff00c9a40400ce, 0x3b953bafffbaa84d, 0xa9af15ff00d7010d, 0x010dbcd97906ffba, 0xbe0400f201110100, 0xffb8dd0d4dff00ed, 0x00fbb30439e51f3e, 0x7860ff3b2df4a9ff,
        0x01120112b904396e, 0xffb5d1cbcfff010d, 0x011b0112bb9c0754, 0x362fffb9704ef5ff, 0x410501b094043c0e, 0x0111014c020a016c, 0xecff01397a04013e, 0x3a8698b0ffb7ba6a,
        0x8e1ee9ff0147010d, 0x01123c0c48a6ff3a, 0x2fff01593405015e, 0xba728128ff39fc0d, 0xbde611ff01677a04, 0x010dba055800ffbc, 0x0007018202070190, 0xff3950ed20ff017d,
        0x018b0111b933be08, 0xac2fffb9c77365ff, 0x011201a2020dbbd0, 0xffbac2ad24ff019d, 0x01ab8804bcce5808, 0x1faaff3a9c6f3bff, 0x050b01f8020abb15, 0x010e01ca000a01d8,
        0xffba00fea2ff01c5, 0x01d34b05b9cc0372, 0x8e9bffb9ef7f0dff, 0x010a01ea000d3a3b, 0xff3831732dff01e5, 0x01f39205ba5737c0, 0x3de5ff3a805735ff, 0x0111021c9804b933,
        0xfeff02097405020e, 0x38f676cbffba90ef, 0x8f38c5ff02170007, 0x8005bc316853ffba, 0x6cff02290111022e, 0x3bb249e3ff3a1b37, 0xe76d59ff0237b704, 0x0013baca83f4ff3a,
        0x03e8000000050000, 0x023c000000010000, 0x8d05012000020000, 0x011100506f050094, 0x97040022a0040030, 0xffb83e1c0fff001d, 0x002ba50439237519, 0x1ad4ffba123a60ff,
        0x4b050042550539bf, 0xff3959e299ff003d, 0x004b7204bb0b0fec, 0x6f1bffb9cda4dfff, 0x010d0074020d3b6a, 0x18ff00617d040066, 0xb9a856c1ff398e6d, 0x5614b4ff006f9204,
        0x02073a0fc609ffbb, 0x4dff008186040086, 0x3a70de99ffba0f01, 0x0d70a8ff008f0112, 0xa904bbd949c3ffba, 0x000e00bc011100dc, 0x4cff00a9650400ae, 0xba0416c9ff38225c,
        0x027c2bff00b78f05, 0x9704382062d3ffb9, 0x9bff00c9910400ce, 0xbbb547f6ffb9ddcb, 0x063e7dff00d79c04, 0x0111bab0a3f5ff3b, 0x010b00f2040d0100, 0xff3a1e0b03ff00ed,
        0x00fb8f05b8bf97a9, 0x2095ff3a132ca9ff, 0xb5040112bd043b01, 0xff381b5d04ff010d, 0x011b00073b44ec4c, 0x5481ffbc88c9e5ff, 0xac0401b00112bc1d, 0x060d014ca404016c,
        0x4fff0139040b013e, 0x38b20694ffb85e44, 0x267c4bff0147030e, 0x000abb1cdaa7ff3a, 0x0cff0159a704015e, 0xb936fa8bffba70f5, 0xf4f589ff0167000d, 0xba043a8786f0ffb9,
        0x8b05018202070190, 0xff3a506c0cff017d, 0x018b720538ed734f, 0x00aaff39f48ad7ff, 0xbd0401a28a05b94e, 0xffbb870f3dff019d, 0x01ab060eba3b2c95, 0xe327ff381b4db2ff,
        0x6d0501f89705ba9c, 0x020a01ca820401d8, 0xff3ab5d58fff01c5, 0x01d39804bc89f452, 0x04e4ffbbd1dd8bff, 0x800401ea020db9a3, 0xffbad4e100ff01e5, 0x01f384053a8e197c,
        0xb2b8ffbc218799ff, 0x010d021cb7043b19, 0x35ff0209ab04020e, 0xbae8d4d7ff3b0efd, 0x4bb671ff02179805, 0xb8043ba65767ff3c, 0xb3ff0229000a022e, 0xbc5bb14dffbb653c,
        0x2878bdff0237000a, 0x00133b95105cffbb, 0x03e8000000050000, 0x023c000000010000, 0x00020120020a0000, 0x94040050010d0094, 0x730400226f050030, 0xffb92c35c4ff001d,
        0x002b93043a4c020b, 0x7d17ff389bf34dff, 0x300100422205bb96, 0xffbaea60aaff003d, 0x004b01113b3d9c7a, 0x1b46ff389e9f11ff, 0x860400749704ba36, 0x5aff006182040066,
        0xb9efbf9fff38f577, 0x794790ff006f0111, 0x140e3c01d0f2ffb8, 0x06ff0081030b0086, 0xba015aa6ff3975d5, 0xb0b4e8ff008f2701, 0x7705ba97b8bdff3a, 0x720400bc030d00dc,
        0x19ff00a9011200ae, 0x39748aa5ffb726e7, 0xb41adbff00b78204, 0x7405ba247f1aff39, 0x2cff00c9840400ce, 0xb981d0a9ff3aa255, 0x491321ff00d70112, 0xab04bc81828bff39,
        0x020d00f2a7040100, 0xff39637da7ff00ed, 0x00fb0111ba11cacd, 0x9b1fff39097867ff, 0x01110112ae043bbe, 0xffb850cb03ff010d, 0x011bb704bb313e0c, 0xab53ff392de3b4ff,
        0x2c0101b07005b9ae, 0x2205014c2101016c, 0xacff0139130e013e, 0xbb4a1ad4ffb90dec, 0xc5d6b7ff0147180e, 0x0111bb793013ff39, 0xfaff0159050b015e, 0xba1642e5ff394e22,
        0xbed91aff01672801, 0x42013c206535ff3a, 0x3e01018241010190, 0xff3a6dc5d0ff017d, 0x018b4a05baf18ebf, 0x70a2ff3c7768b5ff, 0x000201a281043bef, 0xff3b32e2a0ff019d,
        0x01ab0002bbad13fe, 0x40bdffbb039033ff, 0x011101f800073adf, 0x001101ca8a0401d8, 0xffb84cbf70ff01c5, 0x01d39905ba4eee33, 0x5e99ff39b28196ff, 0x060e01ea7d05b918,
        0xff3c2de90cff01e5, 0x01f398053b4324e4, 0xec92ff3ae6d0c0ff, 0x0002021c98043c12, 0x27ff02090111020e, 0x3d30f801ff3ae34f, 0x3d6bc9ff02170112, 0xa204bbe8c7fdffba,
        0x6fff02290111022e, 0xbbd40d00ff3ac46d, 0x2a1520ff0237a504, 0x0013b7f661eaffbb, 0x03e8000000050000, 0x023c000000010000, 0x8d05012000020000, 0x011100506f050094,
        0x0d0e00229f040030, 0xffb79413caff001d, 0x002b040eb985ff55, 0x1b75ffbab1dda4ff, 0x600500426d0538d5, 0xff38f22605ff003d, 0x004b010e3916d46a, 0x34a9ff3bdeca31ff,
        0x710500740007bb8f, 0xcbff0061000a0066, 0xbb1462eaff3a213d, 0x7c1ca7ff006f010d, 0x0107ba058372ff38, 0xf8ff0081080b0086, 0xba0df303ff3a825d, 0xd6ed3fff008f8b05,
        0xa9043a93940cffb9, 0x990500bc011100dc, 0x4bff00a9000700ae, 0xb91aa900ff380e65, 0x94c867ff00b7000a, 0x000dbb107e32ffb9, 0x38ff00c9000700ce, 0xbab63169ff3a9fdb,
        0x97c42dff00d79704, 0x0111ba024e2affbb, 0x980500f200070100, 0xff39901002ff00ed, 0x00fb030b36335afe, 0x1200ffb9c4d729ff, 0x030b0112050bb816, 0xff3a1ea783ff010d,
        0x011b010dbb8827ef, 0x5f32ff3b088005ff, 0x010a01b094043c22, 0x0111014c020b016c, 0xd6ff01399104013e, 0xbb063beeff37d931, 0xc0024dff01478c04, 0x89043c449dddff3a,
        0x66ff01597405015e, 0xb9cca876ff35c238, 0xb094c6ff01670111, 0x9204bbc551a5ffb8, 0x8304018290040190, 0xff3a9d452bff017d, 0x018b0112ba538ce8, 0x951fffbb09bd27ff,
        0x010701a201123cb5, 0xff3ab6b4c8ff019d, 0x01ab5d05bacdad27, 0xbb5fffbcc27db8ff, 0x050b01f8020abc48, 0x020d01caa50401d8, 0xff38a91972ff01c5, 0x01d3aa04ba271f6b,
        0xfca9ff3a9b1509ff, 0x020d01ea090bb891, 0xff3a263318ff01e5, 0x01f301113b04067a, 0x25c2ff38f92a6dff, 0xb804021c060eba3f, 0xf6ff0209b704020e, 0xbb7a3029ffb8b48f,
        0xcc22e7ff0217030b, 0x01113b2de500ff3b, 0x83ff02292005022e, 0x39a7f5faff3b17d7, 0x13a002ff02376d05, 0x00133b76a60bff3c, 0x03e8000000050000, 0x0233000000010000,
        0x00020120020a0000, 0x94040050010d0094, 0x680400225e050030, 0xffb8ec1f6dff001d, 0x002b011139143598, 0xe17dffb838bd72ff, 0x9504004222053a11, 0xff3bb6cf42ff003d,
        0x004b0111b890eadb, 0x30fdff38a3ed42ff, 0x8b0400740111ba17, 0xadff006189040066, 0x397cd350ffb6c38b, 0x514d92ff006f000a, 0x810536ec1305ffb9, 0x84ff0081020b0086,
        0x3afe9a08ffb9933f, 0x9f167cff008f9104, 0x0111babcc4c0ff3b, 0x010d00bc020d00dc, 0x81ff00a9410500ae, 0xb899be41ff396b5f, 0x393e07ff00b7000a, 0x00073a5d9e7fffba,
        0xedff00c98e0500ce, 0x3920e5d4ffba173c, 0xa8e452ff00d77a04, 0x9b0539c57102ffb9, 0x4b0500f27a050100, 0xffb8b6f103ff00ed, 0x00fb030bbab9a3c5, 0x1c80ff3a9525a0ff,
        0x010b01120007b92c, 0xff3b23bb2fff010d, 0x011b9c05ba9dd3f4, 0x3c55ffbc13f45dff, 0x011101b07405bb3b, 0xaa04014c060b016c, 0x93ff0139a004013e, 0xb9e0968bff385e22,
        0x58b1dcff01473f01, 0x660539e157b4ff3b, 0xf3ff01593901015e, 0xbad30535ffb9a6b4, 0x74f713ff0167a904, 0x030e398823f2ff3a, 0x2f040182010b0190, 0xffbb2d0ad2ff017d,
        0x018b0007bb95505e, 0x1ac8ffbbb82f5eff, 0x060e01a21801bc09, 0xff38afb268ff019d, 0x01ab7404bb279e9a, 0x12dfff3b301e8dff, 0x011201f80007ba3b, 0x900401ca910501d8,
        0xff3aa85860ff01c5, 0x01d3920538870c64, 0x00f5ff3ac82a35ff, 0xac0401eaae04398d, 0xff3ae06c5dff01e5, 0x01f3b104bb64bc0e, 0x28d0ff3c353a80ff, 0x01070213a4043b39,
        0xe5ff0209000d020e, 0x3a4156f8ffbb8588, 0x258005b9ddc100ff, 0x36e3ff0220011202, 0x053b77729fffb9a1, 0xbb0e5e1eff022e84, 0x000013b7c9595cff, 0x0003e80000000500,
        0x00022a0000000100, 0x94b7040120020a00, 0x3066040050660500, 0x1d01110022540400, 0xc5ffb704776aff00, 0xff002b000ab9e4be, 0x019a02ffb9601e18, 0x3d000d004201113a,
        0xa1ffb93d699eff00, 0xff004b4f0538e079, 0xdf04bdff398769ff, 0x66011100746e053a, 0xa99aff0061020700, 0x04ba008386ff3801, 0xbad9ccf4ff006f6e, 0x867c043b3369f7ff,
        0x63bdff0081790400, 0x05ba8bdf67ff3929, 0xb9334a7bff008f78, 0xdc8f05b78ab977ff, 0xae060e00bc140e00, 0xa731ff00a9050d00, 0x113b10fefeffb913, 0x38c726b0ff00b701,
        0xce030d3b1762b2ff, 0xea2aff00c90a0600, 0x013b0aed48ffb9da, 0x37d62eedff00d730, 0x000111bb090e46ff, 0xed030b00f2060e01, 0x51ffb8b511f5ff00, 0xff00fb010a3918e4,
        0x8d0093ffb9f7f69e, 0x0d020d0112b80439, 0x38ffbbaee1d0ff01, 0xff011b010a3cb197, 0xeac58fffb9d283d9, 0x6c2c0501b070053b, 0x3e2301014c420101, 0x25abff0139030e01,
        0x11b8a5f508ffbaf6, 0x3a01b8d6ff014701, 0x5e010b3b6ed42aff, 0x8f10ff0159011201, 0x113c4896c6ff3abc, 0xb9998226ff016701, 0x904201bb861d65ff, 0x7d4b050182410101,
        0xd3ff39db82f2ff01, 0xff018b0112ba6c6f, 0x6b7c50ffba302e12, 0x9d011101a230053c, 0xe6ffba0f9c55ff01, 0xff01ab3a05bd0949, 0x291400ff3ad13013, 0xc6890401e69004ba,
        0x5a55ff01c1710501, 0x12bac4141effba98, 0xff01d3780501d801, 0xe9c335ff3938f021, 0x0d66ff01e100023a, 0x073be1f285ff3c30, 0x0401fc0112020a00, 0xb845a171ff01f7ae,
        0x059805399523f0ff, 0x58ff3a8a3a3eff02, 0x05021c01073bc46e, 0x3ac86088ff021774, 0x25060eba4b7b46ff, 0x0cff380e3befff02, 0x05000000133a94de, 0x01000003e8000000,
        0x0a0000023c000000, 0x050094b704012002, 0x0400304201005064, 0xff001d020700228f, 0xd88c29ffb774e125, 0xfd43ff002b000739, 0x053af88c3bffba12, 0xff003d0a0b00425f,
        0x43b652ffb8dc76a7, 0x1341ff004b6005b9, 0x0ab99a819eff3b4b, 0x0d00668405007401, 0xb8bf55e0ff006102, 0x6f86053832a5edff, 0x7bffb9046489ff00, 0x110086030bb75435,
        0xb922aef6ff008101, 0x8fa5043b342fa5ff, 0x9fffba9fae70ff00, 0x0e00dc8f0539fae8, 0x0600ae060e00bc14, 0x3904ea00ff00a90c, 0xb7050dbb12e9fdff, 0xd2ff3ad25145ff00,
        0x0600ce030dba85f4, 0xb9af21c5ff00c90a, 0xd730013ade4870ff, 0x09ff37ab58edff00, 0x0201000111badb4a, 0xff00edb80400f200, 0x8557b2ffba08f08f, 0x1ce0ff00fb9105b7,
        0x0e3946e219ffbabe, 0xff010db804011206, 0x56abd2ffbb8642ff, 0xb628ff011b000a38, 0x053ba18f11ff3c02, 0x0b016c011101b074, 0x04013eab04014c03, 0x3805c924ff013986,
        0x47680537c5b733ff, 0xaaff3a82ff0cff01, 0x01015e060bba56c8, 0xb8efcc92ff01592d, 0x675c053a1b59e2ff, 0x2dffb9d6dba3ff01, 0x0b0190030e3981f6, 0xff017d2f04018201,
        0x84c3baffbaf2b084, 0x75edff018b3004bb, 0x04bbce2ce8ffbbb3, 0xff019d390101a2a4, 0x01769bff39caabf3, 0xed9aff01ab010bbb, 0x043b5603c1ff3c7a, 0x0401d8ad0401f8ae,
        0xff01c5000701caa8, 0xbd5572ff3987fa17, 0x5148ff01d30112ba, 0x123b96414eff3988, 0xff01e57e0501ea01, 0x296462ff3ae66a40, 0x9620ff01f37e05ba, 0x04bbc49670ff3acf,
        0x04020e0111021cb7, 0x39cdf38bff0209b5, 0x17010bba55aa9aff, 0xb2ff3aec6915ff02, 0x05022e01123b9aa1, 0x3b8e93a6ff022975, 0x37ba04393f6c55ff, 0x1bffbbb0c965ff02,
        0x05000000133b9623, 0x01000003e8000000, 0x0a00000233000000, 0x050094b704012002, 0x0400304f04005064, 0xff001d010a002237, 0xada76affb94334f9, 0x090fff002b490438,
        0x05ba0874ccff3992, 0xff003d420100425c, 0x9cae97ff39f78015, 0x1507ff004b5d05b8, 0x0a39f0f287ffbad5, 0x0d00668405007401, 0xb89911a1ff006102, 0x6f010b380eeb19ff,
        0x23ff39e927f4ff00, 0x110086030bb8436a, 0xb902258fff008101, 0x8f01113b102623ff, 0x25ff38827c19ff00, 0x0e00dc8f05baf3ad, 0x0e00ae060e00bc0f, 0x3a42dd9cff00a902,
        0xb70111b9a0d158ff, 0xe2ffb9806c72ff00, 0x0e00ce040d3b5599, 0x3ab4dbb8ff00c917, 0xd73001b9ef58bbff, 0x3effb96b6699ff00, 0x0201000111bae04c, 0xff00ed010a00f200,
        0x0b68edffb8ae6547, 0x5b17ff00fbbc0439, 0x02b93495acff3991, 0xff010d9b05011200, 0x84b3d9ff3bc529d6, 0x3d15ff011bb804ba, 0x0536b957b5ffbb83, 0x01016c2c0501b070,
        0x04013e3001014c42, 0x384d0cf1ff013934, 0x470111b92dd0f1ff, 0x09ff3a5e14c3ff01, 0x11015e010b3b9d48, 0x3a961eb8ff015901, 0x6720053c26f1beff, 0x5bffbb87ba59ff01,
        0x040190060eb9db3f, 0xff017d0002018281, 0x899ce6ff39b5885c, 0xf28fff018b0111bb, 0x11bb957916ffb961, 0xff019d4b0501a201, 0xee251cff3999a359, 0xb7c5ff01ab9904b9,
        0x043c1b84a0ff3ae7, 0x0501d8011101f898, 0xff01c5970401ca73, 0x6461e8ffbaf93369, 0xbc8aff01d3000d3a, 0x02ba6cddfcff3987, 0xff01e5740501ea00, 0xb8e5cdff3d0db5f5,
        0x14aaff01f38a043b, 0x04bb77ea0dff3c2f, 0x04020e060e02139f, 0xba0ccb60ff02099b, 0x125cffbbc6d62fff, 0x0112022500073c1e, 0xff391e22e2ff0220, 0x022eb5043ad656c6,
        0x254cffba0c928fff, 0x0005000000133961, 0x0001000003e80000, 0x020a000002330000, 0x66050094b7040120, 0x0f0e00305a050050, 0xc2ff001d65040022, 0x3971c75fffb7bef8,
        0x887875ff002b110e, 0x020dba0a70f9ff3a, 0x82ff003d74040042, 0x39b2abdaffb9ab9b, 0xe5dc3fff004b3e01, 0x020db817ebc9ff3a, 0x70050066010a0074, 0xffb911cf5aff0061,
        0x006fb604b81aaaed, 0x3ec3ff377dade7ff, 0x0007008601113b80, 0xffb94a2500ff0081, 0x008f050b395914cd, 0xf668ffba0cb6b2ff, 0x010b00dc010a3c5b, 0x0c0600ae120e00bc,
        0xff3a8c2ed8ff00a9, 0x00b7030dba4d2de6, 0x1109ff399099a3ff, 0x990500ce9a05baa3, 0xffb9115fb2ff00c9, 0x00d7030b3a53cdf3, 0xb208ffba609190ff, 0x060e0100b80438c1,
        0x7aff00ed011200f2, 0xbba3cdeeff385744, 0x0fef87ff00fb0111, 0x00023c08242dffb9, 0xd9ff010db9040112, 0x38f401cfff3a9f51, 0x22eb17ff011b010d, 0x7005bab4b927ff3b,
        0x4201016c2c0501b0, 0x130e013e2301014c, 0xffb838ee80ff0139, 0x01470112bae99d83, 0xe3a9ff39ae90cfff, 0x0112015e010b3b2a, 0xff3a703123ff0159, 0x016701123c058e32,
        0x72a8ffb8eb66ebff, 0x81040190060ebb2d, 0x91ff017d3f010182, 0x3ad812efffb93b00, 0x34c214ff018b0111, 0x0112bb6f281affb9, 0xbaff019d320501a2, 0xb903c5b8ff3a46af,
        0x97bc09ff01ab2801, 0x94043bf94d77ffba, 0x910401d8011101ef, 0xdbff01c57d0501ca, 0xbab42868ff397c42, 0x0d6518ff01d3000d, 0x8a043aa51834ff3b, 0x023c0c1088ff01e1,
        0x3b93eb0bff01ea00, 0x13b004bb5a2130ff, 0x00aa040205010b02, 0xdeffba1e4e53ff02, 0xff020e0207bb9fe6, 0x0ee858ff39242798, 0x2001110225b304bc, 0x59ff3a47f362ff02,
        0xff022e010b3bc652, 0x908f3eff3aea78f0, 0x0000050000001336, 0x000001000003e800, 0x20020a0000023c00, 0x50010d0094000201, 0x225e050030940400, 0xc18bff001d680400,
        0x1138798ddeffb88b, 0xb77bd0d5ff002b01, 0x42220539b95a64ff, 0x7600ff003d390100, 0x113b850eafffba24, 0x388ba14dff004b01, 0x740111ba2322bdff, 0x612f010066680400,
        0x7affb8755997ff00, 0xff006f020b38a081, 0xbc6e6affb9abc2cc, 0x81020b00868105b7, 0xfbffb93bd9d8ff00, 0xff008fb9043ac5af, 0xd4020effba8803de, 0xbc000a00dc01123b,
        0xa99a0400ae9e0400, 0xdbff37f503ceff00, 0xff00b7a7043a0d73, 0x97168cffb9da4a2b, 0xc9060e00ce9804b8, 0x3dffb8d9a9c0ff00, 0xff00d700113a6ac6, 0x04706affb9b02de7,
        0xf268040100010e3a, 0x8d75ff00ed560400, 0x043b96964affbab4, 0xbb37e134ff00fb8b, 0x12090bb9a89319ff, 0x814bff010d020701, 0x0a3a6ba2cfff390e, 0x39a2ebebff011b01,
        0xb00207bb6c8b7cff, 0x4c060e016c010701, 0x394b04013e5f0401, 0xd4ff3854df37ff01, 0xff01473a013a8e9b, 0x61a9f1ffba6aaf46, 0x590111015e1a0139, 0xbbffb94617a4ff01,
        0xff01677104ba8d46, 0x3dda10ff3c19fada, 0x82011101900e0539, 0x0241ff017d060e01, 0x0eb9a1f434ff38fe, 0xb9d9944dff018b06, 0xa27404bb8e0e12ff, 0xb4f8ff019d6e0401,
        0x043b7ab298ff3983, 0xbc5f67f6ff01ab76, 0xf80203b8941556ff, 0xca420401d8011201, 0xe4ccff01c5060e01, 0x04b8c160c6ff3968, 0xb9405588ff01d357, 0xea2a04ba0cdd26ff,
        0x2f70ff01e5000501, 0x053acf4b08ffba84, 0xbc1ef432ff01f302, 0x1c2405bb723ff1ff, 0x090112020e060302, 0xa4ff39ae06f6ff02, 0xff02170111babe01, 0xf26e07ff39a08710,
        0x290112022ea1043a, 0x75ffba1e2714ff02, 0xff0237a204bba24c, 0x88e45bff3bca4f31, 0x0000050000001339, 0x000001000003e800, 0x20020a0000023c00, 0x5068050094b70401,
        0x2264050030011100, 0x69e4ff001d960400, 0x043932d755ffb778, 0xb8f1eaedff002bb5, 0x4264053b3c075cff, 0x4a2aff003d540500, 0x0439de1470ffb70d, 0xbb822f2bff004b5e,
        0x74020b3b0ba45eff, 0x6169050066020700, 0x70ffba558a70ff00, 0xff006f8405b90379, 0x8129d6ffbafa2184, 0x819304008669053b, 0x78ffb9ba904bff00, 0xff008f010dbbd286,
        0x07f55bff38001cea, 0xbcba0400dc9d0539, 0xa9940500ae010b00, 0x38ff3b900738ff00, 0xff00b7060e3a40f9, 0x9136ddffb8ee09bc, 0xc90c0600ce040d3a, 0xd1ff3806890aff00,
        0xff00d7090ebb317c, 0x811831ff3aa1399f, 0xf2030b01000111ba, 0x2f09ff00edbc0400, 0x0bb98f1200ff38ea, 0x3a45f47eff00fb0a, 0x12bb04b7c889acff, 0x4c91ff010db90401,
        0x0b3b10a736ffbb6a, 0x39247149ff011b01, 0xb07105bbb2cad6ff, 0x4c0002016c540501, 0x393f05013e4f0501, 0x93ff359a843aff01, 0xff0147500539da04, 0x281c54ffbbf47fac,
        0x590112015e7a043a, 0xb5ff3aeb0ddcff01, 0xff01678a04bc6467, 0x2e6ea2ff3b699679, 0x82011201905605b9, 0x4711ff017d030b01, 0x04bb5d15c0ffb9f9, 0xbaa70ab0ff018b6f,
        0xa26205bca82e69ff, 0x294cff019d5d0501, 0x023b1d29e9ffba2f, 0xba7f0a4eff01ab00, 0xf890043aeee81bff, 0xca7c0501d8011201, 0x2d64ff01c5890401, 0x023836e139ffba6f,
        0x3b1d9eaaff01d300, 0xea00023a38adc0ff, 0x4c90ff01e58d0401, 0x043c7a55d8ffbb19, 0x3bdeb164ff01f38a, 0x1ca104bb315310ff, 0x090002020e740502, 0x07ff3bd1c040ff02,
        0xff02170111baad50, 0x2d9ac2ff387c36b3, 0x290112022e0007bb, 0x70ff38a6929dff02, 0xff023780053ab434, 0xc721afff39cf122e, 0x00000500000013b9, 0x000001000003e800,
        0x20020a0000023300, 0x5064050094b70401, 0x22000a00304e0400, 0xe825ff001d460400, 0x04382db51cffb8cb, 0x383edd90ff002b48, 0x420002ba715e81ff, 0xbce0ff003d620500,
        0x05ba13aa45ff38f5, 0xb8d1760fff004b52, 0x74010ab9715075ff, 0x61020d0066840500, 0xe4ffb83263e5ff00, 0xff006f8605b70abb, 0x0fcdd9ffb8dd59fb, 0x8101110086030bb5,
        0x61ffb8f09febff00, 0xff008fa5043ae1f4, 0xcca39bffba6c4ca0, 0xbc140e00dc8f0539, 0xa9011100ae8b0500, 0x30ffb904421eff00, 0xff00b701113a9460, 0x470561ff39426bdd,
        0xc9060100ce3001bb, 0xc9ffbb4ab654ff00, 0xff00d7030d3a1882, 0x4c7580ff3890f5db, 0xf2060e01000111ba, 0x8ed9ff00edba0400, 0x02b81a6726ff392b, 0xb93c5beeff00fb00,
        0x12060eba2ea9ebff, 0x62a2ff010d000201, 0x0abab6a076ff3aea, 0x3bd35537ff011b00, 0xb070053b76e63bff, 0x4c4201016c2c0501, 0x392b04013e300101, 0x92ff38834383ff01,
        0xff01470112b8e669, 0x4720e4ff3a051667, 0x597a04015e7c043b, 0xdeffba74c07aff01, 0xff016781043b8236, 0xcf469dff3bbe59f6, 0x82011101903005ba, 0x8b4eff017da90401,
        0x073af22e0dff3868, 0xbb1d75d4ff018b02, 0xa28d04bcc2dc15ff, 0x22a8ff019d880401, 0x013b38a5d8ff389c, 0xbb90e6caff01ab1e, 0xef9004b94acd18ff, 0xca750501d8011201,
        0x8a58ff01c5001201, 0x05b98df333ffb8a7, 0x39e024f0ff01d376, 0xe174053a43064cff, 0x00023bb22784ff01, 0xff3ba99bc4ff01ea, 0x0213b004bb0ddc10, 0x020077050205010b,
        0xf1eeffb9944512ff, 0x6fff020e0207bb05, 0xbbe8f3a0ff388d2a, 0x022001110225b404, 0x519cff3a2d69feff, 0x20ff022eb5043b9b, 0x393bd0f1ffbadbdd, 0x0000000500000013,
        0x00000001000003e8, 0x0120020a0000023c, 0x005064050094b704, 0x0022390400304f04, 0xa6f945ff001d4305, 0x4101b903add8ffb8, 0xff39539086ff002b, 0x00425c05b8a25d5b,
        0x97aa08ff003d060b, 0x010a37dfc463ff38, 0xff38d14cf1ff004b, 0x0074010ab875149d, 0x0061020d00668405, 0xf7d1ffb80eb687ff, 0x6dff006f0002b6dd, 0x396c6531ffb93fc6,
        0x008101110086030b, 0xc381ffb8c07febff, 0xc1ff008f01123ab4, 0xbab767a0ff389193, 0x00bc0f0e00dc8f05, 0x00a9011100ae030b, 0x0d6dffb8a4f76fff, 0x10ff00b780053ab9,
        0xb9873c5fff3a5e63, 0x00c9170e00ce050d, 0x2745ff3a37e725ff, 0x18ff00d70a06b993, 0xbb1b0bbcffba12d4, 0x00f2060e01000111, 0x093f1eff00edba04, 0x0007b7f70b7eff39,
        0xff362917d0ff00fb, 0x0112bc04b9e8f792, 0x4dc453ff010d010d, 0x030b3b2aeb7bffba, 0xffbbae1de6ff011b, 0x01b0710539decad7, 0x014c0002016c5405, 0x01393d05013e4f05,
        0x89bdff353ab21dff, 0x59ff0147500539a8, 0x39fbfcb2ffbbc3cb, 0x01590112015e7a04, 0xddedff3ac2e68cff, 0x21ff01670112bc35, 0x3b28eb15ffb99704, 0x0182011101905605,
        0xb8c269ff017d030b, 0x6f04bb4210b4ffb9, 0xffba8795d0ff018b, 0x01a26205bc865fdc, 0x08ea21ff019d5d05, 0x00023af3d444ffba, 0xffba4a96ebff01ab, 0x01f877053ac248fd,
        0x01ca760501d80111, 0xc2c84bff01c5b804, 0x00023b16f99affb9, 0xffbbac00ebff01d3, 0x01eab0043b47f7d4, 0x10a22aff01e50207, 0x060ebb326ac6ff3b, 0xff3a7bfe40ff01f3,
        0x021c78053c081bb8, 0x02090112020e060e, 0x1ff0ffba3b3ff2ff, 0x35ff0217030bbaea, 0xbbb3076cffbb8aef, 0x02298005022e8505, 0xfc9fff3987a004ff, 0xe3ff0237b704baa2,
        0xb98bdb87ff3a2b2a, 0x0000000500000013, 0x00000001000003e8, 0x0120010e0000023c, 0x00505c0500946105, 0x0022540500307604, 0x7c280bff001d6c04, 0x000ab9a32df9ff37,
        0xffb912c5feff002b, 0x004279043ab8f2b3, 0x88aab0ff003d0112, 0x80043cdb1f74ff39, 0xff3af3ab51ff004b, 0x00748f04ba97e79b, 0x00618b040066000a, 0x7caaffb99e7e45ff,
        0x2eff006f01113b3f, 0x3bee6c3eff38c702, 0x0081980400860112, 0xa7d0ffbb25b7b4ff, 0x33ff008f00023a12, 0xbc0df375ffbd0d3a, 0x00bc690500dc010d, 0x00a9690400ae6e04,
        0xf35affb996bac9ff, 0xefff00b70107bbd6, 0xba4f7cd1ff3c03d7, 0x00c9011100ce7904, 0x7e5aff35ee0d30ff, 0xa0ff00d77d043b2b, 0xb9955200ff3ab2ce, 0x00f2620401008904,
        0xea9f7dff00ed6104, 0x01113b7d7d2bff39, 0xffb82b716eff00fb, 0x0112b104bb6068d6, 0x953070ff010da804, 0xb804bb11e0bcff39, 0xff3b0670c7ff011b, 0x01b0020eb8eb2c5a,
        0x014c0112016c7804, 0x01392205013e2e01, 0x39feffbafffe36ff, 0x6dff01470012bb4c, 0x39a4d94fffb95844, 0x01594605015e3e01, 0xfc98ff3cced2caff, 0x71ff016769043ce8,
        0x3c9a0b42ff3c2d13, 0x018212050190040d, 0x055890ff017d0705, 0x0002b9a7cb20ffbb, 0xffbb6a18b5ff018b, 0x01a2030bbb09b343, 0xe88130ff019d0b05, 0x040b37314854ff3a,
        0xff39a2e324ff01ab, 0x01f83a05bb568d3c, 0x01ca320401d83904, 0xb927e8ff01c50304, 0x0111b7bc7a22ffb9, 0xff36abc541ff01d3, 0x01ea0111baed181b, 0x9a1ff1ff01e5060e,
        0x0b0eb967abc6ff37, 0xff3a4b149aff01f3, 0x021c180eb9c58249, 0x02090207020e4105, 0x7d49ffb901bc99ff, 0xf5ff0217011139e0, 0xb92b38e8ffb62c19, 0x02290112022e9404,
        0xa076ffb919c304ff, 0x9aff023701123b74, 0xbb89f2b3ffb91945, 0x0000000500000013, 0x00000001000003e8, 0x0120020a0000023c, 0x005064050094b704, 0x0022370400304f04,
        0x7c5105ff001d2904, 0x4b05b8a7762dffb8, 0xff397b13faff002b, 0x00425c05b9eccd4c, 0x5e0270ff003d060b, 0x010a37173b5cff38, 0xff3872e47dff004b, 0x0074010ab8cd0165,
        0x0061020d00668405, 0x8e05ffb82976a9ff, 0xc1ff006f8605373a, 0x37abb053ffb88d98, 0x0081b6040086040b, 0xc0a6ff38f63806ff, 0xacff008fa5043b8b, 0x39c69b2bffba13be,
        0x00bc0c0600dc8f05, 0x00a9000200ae020e, 0x4c04ffb8acdce5ff, 0x62ff00b7040d3b16, 0xb9daf845ff391bdc, 0x00c9050d00ce000a, 0x1438ff3add906bff, 0x23ff00d7030d39b7,
        0xbacdc9b7ffbb86eb, 0x00f2000201000111, 0x0bec94ff00edb804, 0x91053546ebd1ffba, 0xffbaa12153ff00fb, 0x0112060e391e55aa, 0x635177ff010d9305, 0xb804b918a88dffbb,
        0xff3bbc1929ff011b, 0x01b070053b5eb085, 0x014c1401016c2c05, 0x01392a05013e5904, 0x5cc0ffb8184ec6ff, 0x50ff01475b043b3b, 0xb9ef78baffbbca9d, 0x01590111015e030e,
        0xcbc3ff3a69d1e1ff, 0x76ff01677404bb7c, 0xb8fca532ff39eae1, 0x018201070190ae04, 0xf92527ff017d0111, 0x74043a4dcd47ffb8, 0xff3b50a66fff018b, 0x01a20112ba619c81,
        0x176aa1ff019d160e, 0xb7043ad08154ffb7, 0xff3c3cec5aff01ab, 0x01f8050b3b2278a0, 0x01cab70401d8b804, 0x8bb019ff01c5b604, 0x01113b43294bffb8, 0xff3a8a2ebbff01d3,
        0x01ea0112bbb95766, 0xabca94ff01e5060e, 0x72053a165333ffb8, 0xff3be86460ff01f3, 0x021cbd043b45b350, 0x02097a05020e0007, 0x8785ffbafacd51ff, 0x51ff02177605b76a,
        0xba682eb3ff390199, 0x02290002022e7f05, 0xb302ff3980dd20ff, 0x65ff0237060ebb07, 0x3a64caa8ffb93555, 0x0000000500000013, 0x00000001000003e8, 0x0120020a0000023c,
        0x005064050094b704, 0x0022370400304f04, 0x49dadbff001d2904, 0x4704b885f80effb8, 0xff3964ea8aff002b, 0x00425c05b989226e, 0x319b81ff003d060b, 0x010a36f1f5fcff38,
        0xff38425018ff004b, 0x0074010ab8a4013b, 0x0061020d00668405, 0x4003ffb8079256ff, 0x1bff006f86053715, 0x3789599bffb8628e, 0x0081030b0086040b, 0x2b16ff39a56e26ff,
        0xa0ff008fb604baa9, 0x3af32149ffb947bb, 0x00bc010b00dc010a, 0x00a9011200ae010e, 0x29fdff3a250748ff, 0x84ff00b70b063ae2, 0x3a1f70b9ffb9d3a3, 0x00c97a0500ce9a05,
        0x809eff3ba4e61dff, 0x39ff00d7030bb82b, 0x38dee53cffba178b, 0x00f2010e01000111, 0x016650ff00ed050b, 0x030ebaf3992bff37, 0xff3a22d8a5ff00fb, 0x01129805387545e9,
        0x5bc6e5ff010d070b, 0x030bbb215769ff3a, 0xff3b7f83f0ff011b, 0x01b071053bd222b0, 0x014c0002016c5405, 0x01393d05013e4f05, 0x7ffbff36a49223ff, 0x8dff01476b043995,
        0x3a4fd8c7ffbb8184, 0x01592005015e7a04, 0x3e6effbac6d264ff, 0xeeff01678a04bb64, 0xb90b1900ff3b190b, 0x0182011101905605, 0x8dd8adff017d030b, 0x5505bb1a6182ffb9,
        0xffba7988e0ff018b, 0x01a26205bc557103, 0xc9c192ff019d5d05, 0x66053aca78c7ffb9, 0xffbac2580aff01ab, 0x01f8000738c7b2fe, 0x01ca0d0e01d80111, 0x3a2f40ff01c58e05,
        0x76053909d616ffb9, 0xff3a2774d2ff01d3, 0x01ea740539fd9e60, 0x81911cff01e5060e, 0xb7043b362940ff3b, 0xff3a8179d6ff01f3, 0x021cb604bb0dfb52, 0x0209ae04020e010b,
        0x989dffbad57b6aff, 0xc4ff02177205bbbe, 0x37c7112dffbb0293, 0x02298405022e010b, 0x224eff3b93d5b0ff, 0x94ff023780053b3c, 0xb9aa69ebff3a960a, 0x0000000500000013,
        0x00000001000003e8, 0x0120020a00000233, 0x005066050094b704, 0x00220f0e00305a05, 0xbb5c83ff001d6504, 0x110e38e204a6ffb5, 0xff3a58e15fff002b, 0x0042020db9cf016f,
        0x860814ff003d7404, 0x8304396c9d5dffb9, 0xffb9a97f54ff004b, 0x0074020d3a2956e2, 0x006170050066010a, 0x63a4ffb8814f4eff, 0x4dff006fa504b7a8, 0x39f1751cffb9794e,
        0x0081000700860111, 0xaac1ffb933a7d0ff, 0xa6ff008f050b392f, 0x3c2c2535ffb9abcd, 0x00bcba0400dc8f05, 0x00a9011200ae030b, 0x1999ffb8fde600ff, 0x5cff00b701123bb9,
        0xbaa4d5f0ff397385, 0x00c90b0600ce0c06, 0x9076ffb99463bfff, 0x40ff00d7020539dd, 0x3a5f020fffbb1959, 0x00f2060e01000111, 0x2ba679ff00edb904, 0x030b370ed022ff39,
        0xffb6b1d294ff00fb, 0x0112bc04b9ed53eb, 0x98bbf9ff010db904, 0x030b3acca234ffba, 0xffbb8a5dd0ff011b, 0x01b0740539c70d38, 0x014c0011016c0111, 0x01394404013e1701,
        0xd7abffb9453ae5ff, 0x1eff01474f053983, 0x3898dfc8ffba5455, 0x01594101015eaa04, 0x8deaff382f147dff, 0xa8ff01675205b99b, 0xb83823beff3a7cf4, 0x01821b0501901c05,
        0xfa2698ff017d2501, 0x17013bbcdb0bffb9, 0xffbb2e14c3ff018b, 0x01a22605bca964d4, 0x063c61ff019d2505, 0x060e3c37aa27ff3b, 0xffb989a908ff01ab, 0x01f8a1043b0256b5,
        0x01ca900401d89b04, 0x015d86ff01c57805, 0x82053b18d9c9ffba, 0xffb9982b17ff01d3, 0x01ea9f043ab0a948, 0x4771a2ff01e57f05, 0x0111bb9833efffbb, 0xff3a6793f0ff01f3,
        0x02137605bb545e35, 0x0209b504020e0112, 0x0295ff3a121a0cff, 0x05bcaf75c5ffba07, 0xff0220a804022577, 0x376849ff3ba78377, 0xb4b7ff022e7805b9, 0x13389036faffbb54,
        0xe800000005000000, 0x3c00000001000003, 0x040120020a000002, 0x05005066050094b7, 0x0400220111003057, 0x3806f391ff001d64, 0x2b5505b91f73b5ff, 0xafffb723ace2ff00,
        0x04004201113ae6d9, 0x3519dd4aff003daf, 0x4b7c043a7e7ce1ff, 0x81ff3a07ed23ff00, 0x0a0074020dbb31a2, 0xff00617005006601, 0x86b5fbffb84ee575, 0xc688ff006f020bb7,
        0x1138e206afffb9b4, 0xff00810207008601, 0xb7a17eff3805960d, 0x718fff008f050bb9, 0x053c09b75cffb989, 0x0500bcba0400dc8f, 0xff00a9011100ae8b, 0x952ed3ffb889db26,
        0xb42aff00b701123b, 0x0ebb52dd39ff39c7, 0xff00c9050d00ce05, 0xbf1911ffba94031e, 0x9f6bff00d70c0e39, 0x11b93a2a14ff3a85, 0x0400f20002010001, 0xb9343146ff00edbb,
        0xfb910538b00457ff, 0x40ffba80a891ff00, 0x020112060e390cd8, 0x3ace5041ff010d00, 0x1bb804ba626763ff, 0x27ff3b9e225cff01, 0x1201b074053b2015, 0x04014c000d016c01,
        0xff01390011013eaf, 0x801e8effb976dd27, 0xd48dff0147160e37, 0x043aab4717ff36ba, 0xff01599104015e94, 0x2f67c6ffbb457981, 0xd8a6ff0167a504bb, 0x0ebb1c5521ffb8be,
        0x0401824b0401900d, 0xb8e567abff017d48, 0x8b3901bbfa9c58ff, 0x21ff3ae225baff01, 0x0501a21e01b9fcc5, 0xbb4e8f09ff019d35, 0xab1f01bbe2bed9ff, 0xd3ffbb80bd49ff01,
        0x1201f8a1043b4584, 0x0e01ca000701d801, 0x38107b2bff01c506, 0xd30011baf3c924ff, 0x96ff3a2dab0cff01, 0x0201ea9b043b7f4d, 0x3aadcfdcff01e500, 0xf39f04ba914a20ff,
        0xf5ffbb5788e7ff01, 0x04021ca604bb29e4, 0xff02090007020ea4, 0xc2d4c5ff3ad19a4c, 0x5b7eff02170111ba, 0x043c35f060ffba82, 0xff02290002022ea8, 0x3215ebffbb8e88df,
        0x45fdff0237ad043b, 0x13b8867310ff3ac8, 0xe800000005000000, 0x3c00000001000003, 0x040120020a000002, 0x04005064050094b7, 0x0a0022370400304f, 0xb8bc5e55ff001d01,
        0x2b4b053902cc23ff, 0xb9ff3933cf4eff00, 0x0b00425c05b9c102, 0x3835519aff003d06, 0x4b010a374d7a08ff, 0x07ff38483b5bff00, 0x050074010ab85226, 0xff0061020d006684,
        0xddbc40ffb777c250, 0x0036ff006f8605b7, 0x0b372c6357ffb853, 0xff0081b604008604, 0x58a398ff384bdcb1, 0x41d3ff008fb6043b, 0x053ab390a2ffb946, 0x0d00bcb90400dc9d,
        0xff00a9011100ae00, 0x348953ff38f209d3, 0x19d2ff00b70111bb, 0x0b3ade2b97ff38b1, 0xff00c9040d00ce0a, 0x9d2e31ff3981d204, 0x1102ff00d70002b9, 0x0b3980d36effb9a3,
        0x0d00f20111010001, 0xb72b9f00ff00ed01, 0xfb000a3a0ae269ff, 0xbbff3adbe273ff00, 0x0a011201113b8663, 0x38cdb6dfff010d00, 0x1b030bb9029765ff, 0xa5ffbb276d1dff01,
        0x0501b071053a3225, 0x05014c0002016c54, 0xff01393b05013e4f, 0x18c716ff373490ef, 0x3f45ff0147870438, 0x04bb0e2f77ff3ab3, 0xff01590207015e7a, 0xab0dacffbb307a42,
        0xb8cdff01678a04ba, 0x05b905c326ff3b02, 0x0501825805019059, 0xbaed1396ff017d56, 0x8b01113a29414dff, 0x30ffba77630eff01, 0x1201a26105bc52e7, 0xb9074f13ff019d01,
        0xaba4043b6e1565ff, 0xe5ffba61f37eff01, 0x1201f8770539ecaf, 0x0701ca020701d801, 0xb823ca08ff01c501, 0xd37305ba86dc25ff, 0x43ff3ab35394ff01, 0x0401ea020739c6cb,
        0x3acede92ff01e5a6, 0xf3060e3b387a8fff, 0x90ffbaa383cbff01, 0x0e021c78053ba889, 0xff0209030b020e06, 0xe50b90ffbaa045b5, 0xea92ff0217030bb9, 0x04bb766d20ffbb68,
        0xff02290002022eae, 0x9d7905ffb788f11c, 0x578dff0237b704ba, 0x13b8981546ff3a0f, 0xe800000005000000, 0x3c00000001000003, 0x040120020a000002, 0x04005064050094b7,
        0x0b0022340400304f, 0xb94f38ecff001d02, 0x2b3a043806fc49ff, 0xb7ffb978e4ceff00, 0x0b00425c0538808a, 0x38110e24ff003d06, 0x4b000737246051ff, 0x0dffba8d029cff00,
        0x050074010a39e5ee, 0xff0061020d006684, 0xb162b2ffb7463462, 0x89c8ff006f030bb7, 0x04b8929608ff38af, 0xff0081011100867d, 0x8faa74ff38282b23, 0xe8a1ff008fb6043b,
        0x053af60907ffb992, 0x0d00bc000a00dc8f, 0xff00a9030e00ae02, 0x74beb2ffbb237f89, 0x1d81ff00b7140eb9, 0x063937e7b7ffb9c7, 0xff00c9020e00ce0c, 0xa5dcd1ff3adb5708,
        0xdcf6ff00d7030d38, 0x02ba57c042ffbb39, 0x0400f20112010000, 0xb9d6f24bff00edb8, 0xfbbb0437add708ff, 0x0bff3b7a9faaff00, 0x0d01129205baed1d, 0x3aa60ba9ff010d01,
        0x1b9305ba7687eeff, 0x09ffbad50c81ff01, 0x0501b0710536e9d8, 0x05014c2a05016c55, 0xff01391a05013e1c, 0x8b684bffb88cd41f, 0x6e6eff01470111b9, 0x053aa6daedffb68a,
        0xff01595005015e52, 0xd187faffb7bf876b, 0x4424ff01676f043a, 0x05b915952fffbb58, 0x0b01820111019056, 0x39a04b12ff017d03, 0x8b0107bac36728ff, 0xc7ffbc950d5eff01,
        0x0101a25705bbbd0d, 0xb91a1b88ff019d38, 0xab71043bc1cebbff, 0xdaff3b45d37cff01, 0x0401f8b804b89be1, 0x0b01cab60401d8b7, 0xbab13923ff01c501, 0xd30002387715abff,
        0x51ffbb0476cdff01, 0x1201ea01123b3836, 0xb96aa86fff01e500, 0xf3060e3ab5b43aff, 0xe0ffbbdad819ff01, 0x04021c01123bb4ef, 0xff02097505020eba, 0xbe8f00ff3b219f4b,
        0xbc75ff02177f0539, 0x053890c99effbac2, 0xff02297205022e8a, 0x514720ff3b86d470, 0xcf00ff02378b053b, 0x133b262214ffb9bd, 0xe800000005000000, 0x3300000001000003,
        0x040120020a000002, 0x11005068050094b7, 0x0e0022060b003001, 0x36d67548ff001d06, 0x2b9604b935090fff, 0xb6ff3820c818ff00, 0x050042640537f639, 0xb7d4a8a3ff003d54,
        0x4b5e04398ae4bcff, 0xc7ffbb50f968ff00, 0x070074020b3ae299, 0xff00616905006602, 0x0ec083ffba3680f3, 0x4b2bff006f8405b9, 0x053b401a99ffbaca, 0xff00810107008669,
        0x2d0798ff3953b35a, 0x6b00ff008f010dbb, 0x0538b64bd6ff3810, 0x0a00bc060d00dc8f, 0xff00a9020d00ae00, 0xe9a54fffba8b3611, 0xcd89ff00b70c06b8, 0x0ebab88aadff395b,
        0xff00c9020e00ce06, 0x32e128ff3a3d459e, 0xfb90ff00d709063b, 0x12bb18ad66ffb9d0, 0x0700f20107010001, 0x38c174d9ff00ed00, 0xfb020bb9326eafff, 0x47ff3a4d8395ff00,
        0x050112010a389c3d, 0xbb353b2fff010d93, 0x1bb804b941b398ff, 0x6affbb3088a1ff01, 0x0501b071053b99f9, 0x01014c2805016c55, 0xff01393404013e2c, 0xdd4819ff38d3cca7,
        0x0e20ff01476704b8, 0x053984cc9fffbb41, 0xff01595005015e52, 0xa79ff9ff36fca0ff, 0x4176ff016763043a, 0x01b8f4b040ffbb9b, 0x110182580501903d, 0xb8c55094ff017d01,
        0x8b01123c0a3788ff, 0xf3ffba305eb9ff01, 0x1101a27904bc6b43, 0xb969806aff019d01, 0xab56053be9cb85ff, 0xc3ffbb1e411cff01, 0x0501efad0437c89b, 0x0501ca8b0501d88c,
        0x37b7f7a0ff01c587, 0xd301123ae2f648ff, 0x64ffba59044cff01, 0x1101ea030bbbb7f2, 0x3951e6baff01e501, 0x8fc0ff3b464b33ff, 0x89050213ae0438bf, 0xa6ff020084050205,
        0x3b58455affba1acd, 0xbac825ff020e0112, 0x7f05bbc87334ffba, 0xb0ff0220b6040225, 0x39ac3759ffba6701, 0x182ccbff022e8105, 0x000038377688ff3b
    };
    return data;
};
// clang-format on

} // namespace jit
} // namespace gpu
} // namespace impl
} // namespace dnnl
