#version 120

precision mediump int;
precision mediump float;

varying vec2 uv;
uniform float dTime;
uniform float AdaptationScale;
uniform sampler2D inLUM;
uniform sampler2D inOLD;

void main()
{
  float TauCone = 0.01;
  float TauRod = 0.04;

  vec3 Lum = texture2D(inLUM, vec2(0.5, 0.5)).rgb;
  vec3 oldLum = texture2D(inOLD, vec2(0.5, 0.5)).rgb;

  //determin if rods or cones are active
  //Perceptual Effects in Real-time Tone Mapping: Equ(7)    
  vec3 sigma = clamp(vec3(0.4)/(vec3(0.04) + Lum), vec3(0), vec3(1));

  //interpolate tau from taurod and taucone depending on lum
  //Perceptual Effects in Real-time Tone Mapping: Equ(12)
  vec3 Tau = mix(vec3(TauCone), vec3(TauRod), sigma) * vec3(AdaptationScale);

  //calculate adaption
  //Perceptual Effects in Real-time Tone Mapping: Equ(5)
  vec3 tm = (vec3(1) - exp(-(vec3(dTime))/Tau));
  vec3 nlum = oldLum + (Lum - oldLum) * tm;
  
  gl_FragColor = vec4(nlum, 1.0);
}
