! This file is part of mstore.
! SPDX-Identifier: Apache-2.0
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.

module mstore_il16
   use mctc_env_accuracy, only : wp
   use mctc_io_structure, only : structure_type, new
   use mstore_data_record, only : record_type, new_record, select_record
   implicit none
   private

   public :: get_il16_records

contains

subroutine get_il16_records(records)
   type(record_type), allocatable, intent(out) :: records(:)

   records = [ &
      new_record("008", il008), &
      new_record("008A", il008A), &
      new_record("008B", il008B), &
      new_record("144", il144), &
      new_record("144A", il144A), &
      new_record("144B", il144B), &
      new_record("147", il147), &
      new_record("147A", il147A), &
      new_record("147B", il147B), &
      new_record("148", il148), &
      new_record("148A", il148A), &
      new_record("148B", il148B), &
      new_record("150", il150), &
      new_record("150A", il150A), &
      new_record("150B", il150B), &
      new_record("152", il152), &
      new_record("152A", il152A), &
      new_record("152B", il152B), &
      new_record("187", il187), &
      new_record("187A", il187A), &
      new_record("187B", il187B), &
      new_record("202", il202), &
      new_record("202A", il202A), &
      new_record("202B", il202B), &
      new_record("212", il212), &
      new_record("212A", il212A), &
      new_record("212B", il212B), &
      new_record("213", il213), &
      new_record("213A", il213A), &
      new_record("213B", il213B), &
      new_record("214", il214), &
      new_record("214A", il214A), &
      new_record("214B", il214B), &
      new_record("227", il227), &
      new_record("227A", il227A), &
      new_record("227B", il227B), &
      new_record("228", il228), &
      new_record("228A", il228A), &
      new_record("228B", il228B), &
      new_record("229", il229), &
      new_record("229A", il229A), &
      new_record("229B", il229B), &
      new_record("230", il230), &
      new_record("230A", il230A), &
      new_record("230B", il230B), &
      new_record("231", il231), &
      new_record("231A", il231A), &
      new_record("231B", il231B) &
      ]

end subroutine get_il16_records

subroutine il008(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 17
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "N", "C", "N", "C", "C", "C", "H", "H", "H", "H", "H", "H", "H", &
      & "H", "H", "Cl"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  0.04828249900000_wp,  0.05718310800000_wp,  0.17351464000000_wp, &
      &  0.04828249900000_wp,  0.05718310800000_wp,  2.78568287700000_wp, &
      &  2.46093346600000_wp,  0.05718310800000_wp,  3.59955006700000_wp, &
      &  3.99138475100000_wp, -0.22111683800000_wp,  1.58364707200000_wp, &
      &  2.54075549100000_wp, -0.11859920300000_wp, -0.58634418000000_wp, &
      & -2.06104854900000_wp,  0.82802123700000_wp,  4.40357178400000_wp, &
      &  6.72173645100000_wp,  0.21049657800000_wp,  1.72565998000000_wp, &
      &  3.05878607700000_wp,  0.07094031400000_wp,  5.55721170600000_wp, &
      &  3.36822870800000_wp, -0.20768088600000_wp, -2.46191612300000_wp, &
      & -1.68465292600000_wp,  0.14855136000000_wp, -0.92148708500000_wp, &
      & -3.83682406200000_wp,  0.37898454700000_wp,  3.43261167300000_wp, &
      & -1.96215918800000_wp, -0.21741297500000_wp,  6.19219743400000_wp, &
      & -1.85966045000000_wp,  2.87036149900000_wp,  4.74746411900000_wp, &
      &  7.49947207900000_wp, -0.87775882500000_wp,  3.31081883300000_wp, &
      &  7.58490659100000_wp, -0.42915677200000_wp, -0.04737543100000_wp, &
      &  7.00829450000000_wp,  2.24769678500000_wp,  2.03795609700000_wp, &
      &  2.98134510600000_wp,  5.00786836100000_wp,  4.16308525400000_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine il008

subroutine il008A(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "N", "C", "N", "C", "C", "C", "H", "H", "H", "H", "H", "H", "H", &
      & "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  0.04828249900000_wp,  0.05718310800000_wp,  0.17351464000000_wp, &
      &  0.04828249900000_wp,  0.05718310800000_wp,  2.78568287700000_wp, &
      &  2.46093346600000_wp,  0.05718310800000_wp,  3.59955006700000_wp, &
      &  3.99138475100000_wp, -0.22111683800000_wp,  1.58364707200000_wp, &
      &  2.54075549100000_wp, -0.11859920300000_wp, -0.58634418000000_wp, &
      & -2.06104854900000_wp,  0.82802123700000_wp,  4.40357178400000_wp, &
      &  6.72173645100000_wp,  0.21049657800000_wp,  1.72565998000000_wp, &
      &  3.05878607700000_wp,  0.07094031400000_wp,  5.55721170600000_wp, &
      &  3.36822870800000_wp, -0.20768088600000_wp, -2.46191612300000_wp, &
      & -1.68465292600000_wp,  0.14855136000000_wp, -0.92148708500000_wp, &
      & -3.83682406200000_wp,  0.37898454700000_wp,  3.43261167300000_wp, &
      & -1.96215918800000_wp, -0.21741297500000_wp,  6.19219743400000_wp, &
      & -1.85966045000000_wp,  2.87036149900000_wp,  4.74746411900000_wp, &
      &  7.49947207900000_wp, -0.87775882500000_wp,  3.31081883300000_wp, &
      &  7.58490659100000_wp, -0.42915677200000_wp, -0.04737543100000_wp, &
      &  7.00829450000000_wp,  2.24769678500000_wp,  2.03795609700000_wp],&
      & shape(xyz))
   real(wp), parameter :: charge = 1
   call new(self, sym, xyz, charge=charge)
end subroutine il008A

subroutine il008B(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 1
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "Cl"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  0.00000000000000_wp,  0.00000000000000_wp,  0.00000000000000_wp],&
      & shape(xyz))
   real(wp), parameter :: charge = -1
   call new(self, sym, xyz, charge=charge)
end subroutine il008B

subroutine il144(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 18
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "C", "N", "H", "H", "H", "H", "H", "H", "H", "H", "O", "C", "C", &
      & "F", "O", "F", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -0.17411935300000_wp, -0.03752995800000_wp,  0.06309795100000_wp, &
      & -0.17411935300000_wp, -0.03752995800000_wp,  2.92463442900000_wp, &
      &  2.46356018500000_wp, -0.03752995800000_wp,  3.89389378700000_wp, &
      &  3.44788065900000_wp,  1.49809917600000_wp,  3.24904369000000_wp, &
      &  3.46528503500000_wp, -1.65526768700000_wp,  3.21208065000000_wp, &
      &  2.51437491700000_wp, -0.01039349300000_wp,  5.82676222200000_wp, &
      & -1.08256732800000_wp, -1.72091676800000_wp,  3.67827605100000_wp, &
      & -1.13041519000000_wp,  1.61609366700000_wp,  3.68445545500000_wp, &
      & -2.11401756800000_wp, -0.03495993100000_wp, -0.61703333000000_wp, &
      &  0.77437191600000_wp,  1.63295002300000_wp, -0.67406526100000_wp, &
      &  0.77905843700000_wp, -1.70436276800000_wp, -0.67073934300000_wp, &
      &  4.87702373300000_wp, -3.90903049200000_wp,  1.79626014300000_wp, &
      &  6.11231871600000_wp, -2.77855861000000_wp,  0.09133045700000_wp, &
      &  7.36052052700000_wp, -4.44533472800000_wp, -1.93283064000000_wp, &
      &  7.97880107700000_wp, -6.76775127900000_wp, -1.03177149400000_wp, &
      &  6.37449930000000_wp, -0.46029945700000_wp, -0.21314219400000_wp, &
      &  5.63758175300000_wp, -4.81974613900000_wp, -3.83124937000000_wp, &
      &  9.04065700800000_wp, -3.58522594400000_wp, -2.75072294600000_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine il144

subroutine il144A(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 11
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "C", "N", "H", "H", "H", "H", "H", "H", "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -0.17411935300000_wp, -0.03752995800000_wp,  0.06309795100000_wp, &
      & -0.17411935300000_wp, -0.03752995800000_wp,  2.92463442900000_wp, &
      &  2.46356018500000_wp, -0.03752995800000_wp,  3.89389378700000_wp, &
      &  3.44788065900000_wp,  1.49809917600000_wp,  3.24904369000000_wp, &
      &  3.46528503500000_wp, -1.65526768700000_wp,  3.21208065000000_wp, &
      &  2.51437491700000_wp, -0.01039349300000_wp,  5.82676222200000_wp, &
      & -1.08256732800000_wp, -1.72091676800000_wp,  3.67827605100000_wp, &
      & -1.13041519000000_wp,  1.61609366700000_wp,  3.68445545500000_wp, &
      & -2.11401756800000_wp, -0.03495993100000_wp, -0.61703333000000_wp, &
      &  0.77437191600000_wp,  1.63295002300000_wp, -0.67406526100000_wp, &
      &  0.77905843700000_wp, -1.70436276800000_wp, -0.67073934300000_wp],&
      & shape(xyz))
   real(wp), parameter :: charge = 1
   call new(self, sym, xyz, charge=charge)
end subroutine il144A

subroutine il144B(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 7
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "O", "C", "C", "F", "O", "F", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  4.87702373300000_wp, -3.90903049200000_wp,  1.79626014300000_wp, &
      &  6.11231871600000_wp, -2.77855861000000_wp,  0.09133045700000_wp, &
      &  7.36052052700000_wp, -4.44533472800000_wp, -1.93283064000000_wp, &
      &  7.97880107700000_wp, -6.76775127900000_wp, -1.03177149400000_wp, &
      &  6.37449930000000_wp, -0.46029945700000_wp, -0.21314219400000_wp, &
      &  5.63758175300000_wp, -4.81974613900000_wp, -3.83124937000000_wp, &
      &  9.04065700800000_wp, -3.58522594400000_wp, -2.75072294600000_wp],&
      & shape(xyz))
   real(wp), parameter :: charge = -1
   call new(self, sym, xyz, charge=charge)
end subroutine il144B

subroutine il147(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 18
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "C", "N", "H", "H", "H", "H", "H", "H", "H", "H", "O", "C", "C", &
      & "F", "O", "F", "F"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  0.09267216300000_wp, -0.15964405200000_wp,  0.04047793100000_wp, &
      &  0.09267216300000_wp, -0.15964405200000_wp,  2.90165536100000_wp, &
      &  2.73411225500000_wp, -0.15964405200000_wp,  3.86607702000000_wp, &
      &  3.71219663300000_wp,  1.38065270600000_wp,  3.22770868300000_wp, &
      &  2.78991586300000_wp, -0.15110249000000_wp,  5.79635653000000_wp, &
      &  3.74700538600000_wp, -1.75100120500000_wp,  3.16389263700000_wp, &
      & -0.85786001100000_wp,  1.49586930000000_wp,  3.66414090100000_wp, &
      & -0.81471756600000_wp, -1.84212379300000_wp,  3.65807488100000_wp, &
      &  1.04547200700000_wp,  1.50809582700000_wp, -0.69740337700000_wp, &
      &  1.03825325400000_wp, -1.83091771800000_wp, -0.69390738400000_wp, &
      & -1.84735833400000_wp, -0.15121587400000_wp, -0.63865179600000_wp, &
      &  5.29996330700000_wp, -3.87788780800000_wp,  1.62612811200000_wp, &
      &  6.52741592700000_wp, -2.56925255900000_wp,  0.05408395800000_wp, &
      &  7.98252383700000_wp, -4.19496493200000_wp, -1.90285958600000_wp, &
      &  9.52215919100000_wp, -5.85342625500000_wp, -0.75946197800000_wp, &
      &  6.67953886900000_wp, -0.24252743400000_wp, -0.13870588800000_wp, &
      &  9.39779632300000_wp, -2.82200341100000_wp, -3.47358093200000_wp, &
      &  6.36285858800000_wp, -5.53504522100000_wp, -3.32790195500000_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine il147

subroutine il147A(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 11
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "C", "N", "H", "H", "H", "H", "H", "H", "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  0.09267216300000_wp, -0.15964405200000_wp,  0.04047793100000_wp, &
      &  0.09267216300000_wp, -0.15964405200000_wp,  2.90165536100000_wp, &
      &  2.73411225500000_wp, -0.15964405200000_wp,  3.86607702000000_wp, &
      &  3.71219663300000_wp,  1.38065270600000_wp,  3.22770868300000_wp, &
      &  2.78991586300000_wp, -0.15110249000000_wp,  5.79635653000000_wp, &
      &  3.74700538600000_wp, -1.75100120500000_wp,  3.16389263700000_wp, &
      & -0.85786001100000_wp,  1.49586930000000_wp,  3.66414090100000_wp, &
      & -0.81471756600000_wp, -1.84212379300000_wp,  3.65807488100000_wp, &
      &  1.04547200700000_wp,  1.50809582700000_wp, -0.69740337700000_wp, &
      &  1.03825325400000_wp, -1.83091771800000_wp, -0.69390738400000_wp, &
      & -1.84735833400000_wp, -0.15121587400000_wp, -0.63865179600000_wp],&
      & shape(xyz))
   real(wp), parameter :: charge = 1
   call new(self, sym, xyz, charge=charge)
end subroutine il147A

subroutine il147B(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 7
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "O", "C", "C", "F", "O", "F", "F"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  5.29996330700000_wp, -3.87788780800000_wp,  1.62612811200000_wp, &
      &  6.52741592700000_wp, -2.56925255900000_wp,  0.05408395800000_wp, &
      &  7.98252383700000_wp, -4.19496493200000_wp, -1.90285958600000_wp, &
      &  9.52215919100000_wp, -5.85342625500000_wp, -0.75946197800000_wp, &
      &  6.67953886900000_wp, -0.24252743400000_wp, -0.13870588800000_wp, &
      &  9.39779632300000_wp, -2.82200341100000_wp, -3.47358093200000_wp, &
      &  6.36285858800000_wp, -5.53504522100000_wp, -3.32790195500000_wp],&
      & shape(xyz))
   real(wp), parameter :: charge = -1
   call new(self, sym, xyz, charge=charge)
end subroutine il147B

subroutine il148(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 14
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "N", "C", "N", "C", "C", "H", "H", "H", "H", "H", "H", "H", "Cl"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  1.99124207100000_wp, -0.02532232800000_wp, -0.73276015000000_wp, &
      & -0.34882452100000_wp, -0.02528453400000_wp,  0.47604087400000_wp, &
      &  0.06285228600000_wp, -0.02526563600000_wp,  2.99986442100000_wp, &
      &  2.54555539500000_wp, -0.02528453400000_wp,  3.41651120700000_wp, &
      &  3.79655400100000_wp, -0.02528453400000_wp,  1.13190807400000_wp, &
      & -2.84547380700000_wp, -0.02528453400000_wp, -0.74997555400000_wp, &
      &  3.14590244500000_wp, -0.02528453400000_wp,  5.24261012400000_wp, &
      & -1.33673547400000_wp, -0.02526563600000_wp,  4.49291802900000_wp, &
      &  5.83594629000000_wp, -0.02526563600000_wp,  1.01281754200000_wp, &
      &  2.14861845100000_wp, -0.02534122600000_wp, -2.77075404200000_wp, &
      & -2.58045863400000_wp, -0.02524673900000_wp, -2.79840073300000_wp, &
      & -3.90355028700000_wp, -1.71776092500000_wp, -0.20048103000000_wp, &
      & -3.90358808100000_wp,  1.66715406300000_wp, -0.20044323600000_wp, &
      &  2.90547260800000_wp, -0.02528453400000_wp,  8.75521389700000_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine il148

subroutine il148A(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 13
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "N", "C", "N", "C", "C", "H", "H", "H", "H", "H", "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  1.99124207100000_wp, -0.02532232800000_wp, -0.73276015000000_wp, &
      & -0.34882452100000_wp, -0.02528453400000_wp,  0.47604087400000_wp, &
      &  0.06285228600000_wp, -0.02526563600000_wp,  2.99986442100000_wp, &
      &  2.54555539500000_wp, -0.02528453400000_wp,  3.41651120700000_wp, &
      &  3.79655400100000_wp, -0.02528453400000_wp,  1.13190807400000_wp, &
      & -2.84547380700000_wp, -0.02528453400000_wp, -0.74997555400000_wp, &
      &  3.14590244500000_wp, -0.02528453400000_wp,  5.24261012400000_wp, &
      & -1.33673547400000_wp, -0.02526563600000_wp,  4.49291802900000_wp, &
      &  5.83594629000000_wp, -0.02526563600000_wp,  1.01281754200000_wp, &
      &  2.14861845100000_wp, -0.02534122600000_wp, -2.77075404200000_wp, &
      & -2.58045863400000_wp, -0.02524673900000_wp, -2.79840073300000_wp, &
      & -3.90355028700000_wp, -1.71776092500000_wp, -0.20048103000000_wp, &
      & -3.90358808100000_wp,  1.66715406300000_wp, -0.20044323600000_wp],&
      & shape(xyz))
   real(wp), parameter :: charge = 1
   call new(self, sym, xyz, charge=charge)
end subroutine il148A

subroutine il148B(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 1
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "Cl"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  0.00000000000000_wp,  0.00000000000000_wp,  0.00000000000000_wp],&
      & shape(xyz))
   real(wp), parameter :: charge = -1
   call new(self, sym, xyz, charge=charge)
end subroutine il148B

subroutine il150(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 17
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "N", "C", "N", "C", "C", "H", "H", "H", "H", "H", "H", "H", "O", &
      & "N", "O", "O"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  2.37077463900000_wp,  0.08535892300000_wp, -0.42176794400000_wp, &
      & -0.05729649200000_wp,  0.08515105300000_wp,  0.59845732400000_wp, &
      &  0.14195621600000_wp,  0.08498097800000_wp,  3.14764099300000_wp, &
      &  2.58866004500000_wp,  0.08503767000000_wp,  3.76057361800000_wp, &
      &  4.01808657900000_wp,  0.08530223100000_wp,  1.57965975000000_wp, &
      & -2.44940613700000_wp,  0.08516995000000_wp, -0.82159616900000_wp, &
      &  3.18900709500000_wp,  0.08503767000000_wp,  5.58667253500000_wp, &
      & -1.36608291800000_wp,  0.08482980000000_wp,  4.53010783600000_wp, &
      &  6.06044573800000_wp,  0.08541561500000_wp,  1.62231086600000_wp, &
      &  2.69654450200000_wp,  0.08552899800000_wp, -2.43850241800000_wp, &
      & -2.02340520700000_wp,  0.08532112800000_wp, -2.84269591000000_wp, &
      & -3.54722355400000_wp, -1.60692849600000_wp, -0.35608106800000_wp, &
      & -3.54731804000000_wp,  1.77713611600000_wp, -0.35585430100000_wp, &
      &  3.97677716900000_wp,  0.08520774500000_wp,  8.43602028000000_wp, &
      &  1.88978268200000_wp,  0.08535892300000_wp,  9.77797139800000_wp, &
      &  2.01357863200000_wp,  0.08619040200000_wp, 12.11614826300000_wp, &
      & -0.22164596100000_wp,  0.08464082700000_wp,  8.59702493500000_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine il150

subroutine il150A(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 13
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "N", "C", "N", "C", "C", "H", "H", "H", "H", "H", "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  2.37077463900000_wp,  0.08535892300000_wp, -0.42176794400000_wp, &
      & -0.05729649200000_wp,  0.08515105300000_wp,  0.59845732400000_wp, &
      &  0.14195621600000_wp,  0.08498097800000_wp,  3.14764099300000_wp, &
      &  2.58866004500000_wp,  0.08503767000000_wp,  3.76057361800000_wp, &
      &  4.01808657900000_wp,  0.08530223100000_wp,  1.57965975000000_wp, &
      & -2.44940613700000_wp,  0.08516995000000_wp, -0.82159616900000_wp, &
      &  3.18900709500000_wp,  0.08503767000000_wp,  5.58667253500000_wp, &
      & -1.36608291800000_wp,  0.08482980000000_wp,  4.53010783600000_wp, &
      &  6.06044573800000_wp,  0.08541561500000_wp,  1.62231086600000_wp, &
      &  2.69654450200000_wp,  0.08552899800000_wp, -2.43850241800000_wp, &
      & -2.02340520700000_wp,  0.08532112800000_wp, -2.84269591000000_wp, &
      & -3.54722355400000_wp, -1.60692849600000_wp, -0.35608106800000_wp, &
      & -3.54731804000000_wp,  1.77713611600000_wp, -0.35585430100000_wp],&
      & shape(xyz))
   real(wp), parameter :: charge = 1
   call new(self, sym, xyz, charge=charge)
end subroutine il150A

subroutine il150B(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 4
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "O", "N", "O", "O"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  3.97677716900000_wp,  0.08520774500000_wp,  8.43602028000000_wp, &
      &  1.88978268200000_wp,  0.08535892300000_wp,  9.77797139800000_wp, &
      &  2.01357863200000_wp,  0.08619040200000_wp, 12.11614826300000_wp, &
      & -0.22164596100000_wp,  0.08464082700000_wp,  8.59702493500000_wp],&
      & shape(xyz))
   real(wp), parameter :: charge = -1
   call new(self, sym, xyz, charge=charge)
end subroutine il150B

subroutine il152(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 18
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "N", "C", "N", "C", "C", "H", "H", "H", "H", "H", "H", "H", "O", &
      & "Cl", "O", "O", "O"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  2.44033545200000_wp,  0.45274055300000_wp, -0.70407411000000_wp, &
      &  0.12171725100000_wp, -0.39878887600000_wp,  0.20949502300000_wp, &
      &  0.24171485100000_wp, -0.63148973400000_wp,  2.73573741900000_wp, &
      &  2.59740947700000_wp,  0.03365602000000_wp,  3.43036289900000_wp, &
      &  4.00952612000000_wp,  0.73557584200000_wp,  1.32700338500000_wp, &
      & -2.15904973900000_wp, -0.91884146800000_wp, -1.31632643300000_wp, &
      &  3.19777542400000_wp,  0.03365602000000_wp,  5.25646181500000_wp, &
      & -1.31519259800000_wp, -1.23886656500000_wp,  4.00106014800000_wp, &
      &  5.94248904100000_wp,  1.37685435700000_wp,  1.45548585500000_wp, &
      &  2.75582520600000_wp,  0.79795569700000_wp, -2.69174459800000_wp, &
      & -2.01376760400000_wp, -2.81009813700000_wp, -2.14268471200000_wp, &
      & -3.80422628900000_wp, -0.75545575900000_wp, -0.07789450500000_wp, &
      & -2.29019672200000_wp,  0.50633318200000_wp, -2.80854856200000_wp, &
      & -3.99907593500000_wp, -1.87362552500000_wp,  5.88056272100000_wp, &
      & -5.76338081200000_wp,  0.35027961000000_wp,  5.46281989300000_wp, &
      & -4.75611906500000_wp,  1.80665363600000_wp,  3.24036984800000_wp, &
      & -8.29971434500000_wp, -0.60743352200000_wp,  4.89760284900000_wp, &
      & -5.74928345600000_wp,  1.96563628300000_wp,  7.71212294500000_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine il152

subroutine il152A(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 13
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "N", "C", "N", "C", "C", "H", "H", "H", "H", "H", "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  2.44033545200000_wp,  0.45274055300000_wp, -0.70407411000000_wp, &
      &  0.12171725100000_wp, -0.39878887600000_wp,  0.20949502300000_wp, &
      &  0.24171485100000_wp, -0.63148973400000_wp,  2.73573741900000_wp, &
      &  2.59740947700000_wp,  0.03365602000000_wp,  3.43036289900000_wp, &
      &  4.00952612000000_wp,  0.73557584200000_wp,  1.32700338500000_wp, &
      & -2.15904973900000_wp, -0.91884146800000_wp, -1.31632643300000_wp, &
      &  3.19777542400000_wp,  0.03365602000000_wp,  5.25646181500000_wp, &
      & -1.31519259800000_wp, -1.23886656500000_wp,  4.00106014800000_wp, &
      &  5.94248904100000_wp,  1.37685435700000_wp,  1.45548585500000_wp, &
      &  2.75582520600000_wp,  0.79795569700000_wp, -2.69174459800000_wp, &
      & -2.01376760400000_wp, -2.81009813700000_wp, -2.14268471200000_wp, &
      & -3.80422628900000_wp, -0.75545575900000_wp, -0.07789450500000_wp, &
      & -2.29019672200000_wp,  0.50633318200000_wp, -2.80854856200000_wp],&
      & shape(xyz))
   real(wp), parameter :: charge = 1
   call new(self, sym, xyz, charge=charge)
end subroutine il152A

subroutine il152B(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 5
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "O", "Cl", "O", "O", "O"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -3.99907593500000_wp, -1.87362552500000_wp,  5.88056272100000_wp, &
      & -5.76338081200000_wp,  0.35027961000000_wp,  5.46281989300000_wp, &
      & -4.75611906500000_wp,  1.80665363600000_wp,  3.24036984800000_wp, &
      & -8.29971434500000_wp, -0.60743352200000_wp,  4.89760284900000_wp, &
      & -5.74928345600000_wp,  1.96563628300000_wp,  7.71212294500000_wp],&
      & shape(xyz))
   real(wp), parameter :: charge = -1
   call new(self, sym, xyz, charge=charge)
end subroutine il152B

subroutine il187(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 19
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "N", "C", "C", "C", "C", "H", "H", "H", "H", "H", "H", "H", "H", &
      & "H", "H", "H", "H", "Cl"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  2.96292027800000_wp, -0.14609471600000_wp, -0.72427528000000_wp, &
      &  0.18664823600000_wp,  0.16519984600000_wp,  0.03359932800000_wp, &
      &  0.01855710900000_wp, -0.13016432600000_wp,  2.87922431400000_wp, &
      &  2.29658399600000_wp, -1.80697488900000_wp,  3.49546395900000_wp, &
      &  4.37518809900000_wp, -0.71110389000000_wp,  1.75816326700000_wp, &
      & -1.14137560100000_wp,  2.40531883000000_wp, -1.02700938400000_wp, &
      & -0.68591384300000_wp, -1.42162196500000_wp, -0.65713331600000_wp, &
      & -3.11150943200000_wp,  2.35391828300000_wp, -0.40092426600000_wp, &
      & -0.23086782400000_wp,  4.15031070700000_wp, -0.38363327300000_wp, &
      & -1.08995615700000_wp,  2.28307245500000_wp, -3.09087362400000_wp, &
      &  2.98310255100000_wp, -1.76373795900000_wp, -2.01832184400000_wp, &
      &  3.61827725100000_wp,  1.55240990100000_wp, -1.70449504900000_wp, &
      &  5.95477226000000_wp, -2.01388098800000_wp,  1.45403076600000_wp, &
      &  5.13880747500000_wp,  1.03936819200000_wp,  2.57335326500000_wp, &
      &  1.84841658000000_wp, -3.75813587200000_wp,  2.95154412700000_wp, &
      &  2.79275045200000_wp, -1.75500742500000_wp,  5.50460173500000_wp, &
      & -1.81226612200000_wp, -0.99715171300000_wp,  3.30053872300000_wp, &
      &  0.15879367500000_wp,  1.74317774000000_wp,  3.75917522100000_wp, &
      & -1.89989271600000_wp, -4.58910508100000_wp, -1.55692634600000_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine il187

subroutine il187A(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 18
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "N", "C", "C", "C", "C", "H", "H", "H", "H", "H", "H", "H", "H", &
      & "H", "H", "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  2.96292027800000_wp, -0.14609471600000_wp, -0.72427528000000_wp, &
      &  0.18664823600000_wp,  0.16519984600000_wp,  0.03359932800000_wp, &
      &  0.01855710900000_wp, -0.13016432600000_wp,  2.87922431400000_wp, &
      &  2.29658399600000_wp, -1.80697488900000_wp,  3.49546395900000_wp, &
      &  4.37518809900000_wp, -0.71110389000000_wp,  1.75816326700000_wp, &
      & -1.14137560100000_wp,  2.40531883000000_wp, -1.02700938400000_wp, &
      & -0.68591384300000_wp, -1.42162196500000_wp, -0.65713331600000_wp, &
      & -3.11150943200000_wp,  2.35391828300000_wp, -0.40092426600000_wp, &
      & -0.23086782400000_wp,  4.15031070700000_wp, -0.38363327300000_wp, &
      & -1.08995615700000_wp,  2.28307245500000_wp, -3.09087362400000_wp, &
      &  2.98310255100000_wp, -1.76373795900000_wp, -2.01832184400000_wp, &
      &  3.61827725100000_wp,  1.55240990100000_wp, -1.70449504900000_wp, &
      &  5.95477226000000_wp, -2.01388098800000_wp,  1.45403076600000_wp, &
      &  5.13880747500000_wp,  1.03936819200000_wp,  2.57335326500000_wp, &
      &  1.84841658000000_wp, -3.75813587200000_wp,  2.95154412700000_wp, &
      &  2.79275045200000_wp, -1.75500742500000_wp,  5.50460173500000_wp, &
      & -1.81226612200000_wp, -0.99715171300000_wp,  3.30053872300000_wp, &
      &  0.15879367500000_wp,  1.74317774000000_wp,  3.75917522100000_wp],&
      & shape(xyz))
   real(wp), parameter :: charge = 1
   call new(self, sym, xyz, charge=charge)
end subroutine il187A

subroutine il187B(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 1
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "Cl"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  0.00000000000000_wp,  0.00000000000000_wp,  0.00000000000000_wp],&
      & shape(xyz))
   real(wp), parameter :: charge = -1
   call new(self, sym, xyz, charge=charge)
end subroutine il187B

subroutine il202(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 18
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "N", "C", "C", "C", "H", "H", "H", "H", "H", "H", "H", "H", "H", &
      & "H", "H", "H", "Cl"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  2.64314084600000_wp,  0.00869274000000_wp, -0.68003679500000_wp, &
      & -0.07732758800000_wp, -0.32064870600000_wp,  0.03131276000000_wp, &
      & -1.78940043800000_wp,  1.78717056100000_wp, -0.86774327800000_wp, &
      & -2.06511146000000_wp,  1.99623094700000_wp, -3.73438201600000_wp, &
      & -1.03420924000000_wp, -2.92091166900000_wp, -0.55164881100000_wp, &
      & -0.11385599100000_wp, -0.19823225600000_wp,  1.97098420800000_wp, &
      & -0.86254653100000_wp, -3.32960270900000_wp, -2.57178479200000_wp, &
      &  0.08101255300000_wp, -4.25832744400000_wp,  0.56085177700000_wp, &
      &  3.22447725200000_wp,  1.92651895500000_wp, -0.17570672300000_wp, &
      &  3.74723215300000_wp, -1.33250248800000_wp,  0.43977703200000_wp, &
      & -1.00949162400000_wp,  3.51810287600000_wp, -0.03813467000000_wp, &
      & -3.61066165500000_wp,  1.44760569800000_wp,  0.06088697100000_wp, &
      &  2.91860620300000_wp, -0.32886901400000_wp, -2.70206250200000_wp, &
      & -3.00698868800000_wp, -3.04330922100000_wp,  0.05145723900000_wp, &
      & -3.33702933200000_wp,  3.57428443000000_wp, -4.17121107600000_wp, &
      & -0.25492403600000_wp,  2.37995870700000_wp, -4.66705627900000_wp, &
      & -2.88712336800000_wp,  0.28572657000000_wp, -4.56656065000000_wp, &
      & -0.11897714800000_wp, -0.07186627900000_wp,  5.40571237400000_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine il202

subroutine il202A(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 17
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "N", "C", "C", "C", "H", "H", "H", "H", "H", "H", "H", "H", "H", &
      & "H", "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  2.64314084600000_wp,  0.00869274000000_wp, -0.68003679500000_wp, &
      & -0.07732758800000_wp, -0.32064870600000_wp,  0.03131276000000_wp, &
      & -1.78940043800000_wp,  1.78717056100000_wp, -0.86774327800000_wp, &
      & -2.06511146000000_wp,  1.99623094700000_wp, -3.73438201600000_wp, &
      & -1.03420924000000_wp, -2.92091166900000_wp, -0.55164881100000_wp, &
      & -0.11385599100000_wp, -0.19823225600000_wp,  1.97098420800000_wp, &
      & -0.86254653100000_wp, -3.32960270900000_wp, -2.57178479200000_wp, &
      &  0.08101255300000_wp, -4.25832744400000_wp,  0.56085177700000_wp, &
      &  3.22447725200000_wp,  1.92651895500000_wp, -0.17570672300000_wp, &
      &  3.74723215300000_wp, -1.33250248800000_wp,  0.43977703200000_wp, &
      & -1.00949162400000_wp,  3.51810287600000_wp, -0.03813467000000_wp, &
      & -3.61066165500000_wp,  1.44760569800000_wp,  0.06088697100000_wp, &
      &  2.91860620300000_wp, -0.32886901400000_wp, -2.70206250200000_wp, &
      & -3.00698868800000_wp, -3.04330922100000_wp,  0.05145723900000_wp, &
      & -3.33702933200000_wp,  3.57428443000000_wp, -4.17121107600000_wp, &
      & -0.25492403600000_wp,  2.37995870700000_wp, -4.66705627900000_wp, &
      & -2.88712336800000_wp,  0.28572657000000_wp, -4.56656065000000_wp],&
      & shape(xyz))
   real(wp), parameter :: charge = 1
   call new(self, sym, xyz, charge=charge)
end subroutine il202A

subroutine il202B(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 1
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "Cl"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  0.00000000000000_wp,  0.00000000000000_wp,  0.00000000000000_wp],&
      & shape(xyz))
   real(wp), parameter :: charge = -1
   call new(self, sym, xyz, charge=charge)
end subroutine il202B

subroutine il212(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 15
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "N", "C", "C", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", &
      & "Cl"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -1.21312849700000_wp, -2.24884951800000_wp, -1.14753610800000_wp, &
      & -0.02108934200000_wp,  0.04429517700000_wp,  0.00251333600000_wp, &
      & -1.18756050400000_wp,  2.55776302500000_wp, -0.67039919200000_wp, &
      & -3.84321133600000_wp,  2.93359173000000_wp,  0.39748496500000_wp, &
      &  0.09856810800000_wp, -0.14274990100000_wp,  1.93730929100000_wp, &
      &  1.81164251300000_wp,  0.10535222400000_wp, -0.64993346000000_wp, &
      & -1.15042738800000_wp, -2.01458018700000_wp, -3.20004309500000_wp, &
      & -0.05882717000000_wp, -3.88595693800000_wp, -0.63606287100000_wp, &
      & -3.15637152700000_wp, -2.49133915700000_wp, -0.48756820300000_wp, &
      & -4.51521679500000_wp,  4.83382459700000_wp, -0.08800453900000_wp, &
      & -5.20145189100000_wp,  1.57544566100000_wp, -0.38144119100000_wp, &
      & -3.86137160300000_wp,  2.77054617200000_wp,  2.46819001300000_wp, &
      & -1.13689695000000_wp,  2.65784291400000_wp, -2.73815626800000_wp, &
      &  0.14494198300000_wp,  3.98093456600000_wp,  0.03112378700000_wp, &
      &  4.82416809700000_wp,  0.29855780900000_wp, -2.31655840000000_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine il212

subroutine il212A(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 14
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "N", "C", "C", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -1.21312849700000_wp, -2.24884951800000_wp, -1.14753610800000_wp, &
      & -0.02108934200000_wp,  0.04429517700000_wp,  0.00251333600000_wp, &
      & -1.18756050400000_wp,  2.55776302500000_wp, -0.67039919200000_wp, &
      & -3.84321133600000_wp,  2.93359173000000_wp,  0.39748496500000_wp, &
      &  0.09856810800000_wp, -0.14274990100000_wp,  1.93730929100000_wp, &
      &  1.81164251300000_wp,  0.10535222400000_wp, -0.64993346000000_wp, &
      & -1.15042738800000_wp, -2.01458018700000_wp, -3.20004309500000_wp, &
      & -0.05882717000000_wp, -3.88595693800000_wp, -0.63606287100000_wp, &
      & -3.15637152700000_wp, -2.49133915700000_wp, -0.48756820300000_wp, &
      & -4.51521679500000_wp,  4.83382459700000_wp, -0.08800453900000_wp, &
      & -5.20145189100000_wp,  1.57544566100000_wp, -0.38144119100000_wp, &
      & -3.86137160300000_wp,  2.77054617200000_wp,  2.46819001300000_wp, &
      & -1.13689695000000_wp,  2.65784291400000_wp, -2.73815626800000_wp, &
      &  0.14494198300000_wp,  3.98093456600000_wp,  0.03112378700000_wp],&
      & shape(xyz))
   real(wp), parameter :: charge = 1
   call new(self, sym, xyz, charge=charge)
end subroutine il212A

subroutine il212B(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 1
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "Cl"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  0.00000000000000_wp,  0.00000000000000_wp,  0.00000000000000_wp],&
      & shape(xyz))
   real(wp), parameter :: charge = -1
   call new(self, sym, xyz, charge=charge)
end subroutine il212B

subroutine il213(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 18
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "N", "C", "C", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", &
      & "O", "N", "O", "O"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -0.92422718700000_wp, -2.63263396900000_wp, -0.90368586600000_wp, &
      &  0.18413490100000_wp, -0.23186937900000_wp,  0.13381149700000_wp, &
      & -1.16871993600000_wp,  2.18123512200000_wp, -0.55357633200000_wp, &
      & -3.80668293200000_wp,  2.39934729600000_wp,  0.60510915900000_wp, &
      &  0.30379235000000_wp, -0.41893335500000_wp,  2.06860745300000_wp, &
      &  2.01688565200000_wp, -0.17083123000000_wp, -0.51861640100000_wp, &
      & -1.00291537800000_wp, -2.47718510900000_wp, -2.96365727100000_wp, &
      &  0.35761174600000_wp, -4.15786961000000_wp, -0.35413465100000_wp, &
      & -2.81436891800000_wp, -2.95855501100000_wp, -0.13604137400000_wp, &
      & -4.61151723200000_wp,  4.25420784100000_wp,  0.14694509300000_wp, &
      & -5.10322393400000_wp,  0.95742967300000_wp, -0.12489199100000_wp, &
      & -3.73474106400000_wp,  2.23667968200000_wp,  2.67382999600000_wp, &
      & -1.23117538000000_wp,  2.25761784600000_wp, -2.62403571600000_wp, &
      &  0.06126491700000_wp,  3.72024686600000_wp,  0.09276664900000_wp, &
      &  4.85398797400000_wp, -0.52795164700000_wp, -1.28803723500000_wp, &
      &  5.76708467500000_wp, -2.00698348800000_wp,  0.50193012000000_wp, &
      &  8.02368206900000_wp, -2.60559199000000_wp,  0.46205690200000_wp, &
      &  4.24734813600000_wp, -2.77368311700000_wp,  2.22469882000000_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine il213

subroutine il213A(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 14
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "N", "C", "C", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -0.92422718700000_wp, -2.63263396900000_wp, -0.90368586600000_wp, &
      &  0.18413490100000_wp, -0.23186937900000_wp,  0.13381149700000_wp, &
      & -1.16871993600000_wp,  2.18123512200000_wp, -0.55357633200000_wp, &
      & -3.80668293200000_wp,  2.39934729600000_wp,  0.60510915900000_wp, &
      &  0.30379235000000_wp, -0.41893335500000_wp,  2.06860745300000_wp, &
      &  2.01688565200000_wp, -0.17083123000000_wp, -0.51861640100000_wp, &
      & -1.00291537800000_wp, -2.47718510900000_wp, -2.96365727100000_wp, &
      &  0.35761174600000_wp, -4.15786961000000_wp, -0.35413465100000_wp, &
      & -2.81436891800000_wp, -2.95855501100000_wp, -0.13604137400000_wp, &
      & -4.61151723200000_wp,  4.25420784100000_wp,  0.14694509300000_wp, &
      & -5.10322393400000_wp,  0.95742967300000_wp, -0.12489199100000_wp, &
      & -3.73474106400000_wp,  2.23667968200000_wp,  2.67382999600000_wp, &
      & -1.23117538000000_wp,  2.25761784600000_wp, -2.62403571600000_wp, &
      &  0.06126491700000_wp,  3.72024686600000_wp,  0.09276664900000_wp],&
      & shape(xyz))
   real(wp), parameter :: charge = 1
   call new(self, sym, xyz, charge=charge)
end subroutine il213A

subroutine il213B(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 4
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "O", "N", "O", "O"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  4.85398797400000_wp, -0.52795164700000_wp, -1.28803723500000_wp, &
      &  5.76708467500000_wp, -2.00698348800000_wp,  0.50193012000000_wp, &
      &  8.02368206900000_wp, -2.60559199000000_wp,  0.46205690200000_wp, &
      &  4.24734813600000_wp, -2.77368311700000_wp,  2.22469882000000_wp],&
      & shape(xyz))
   real(wp), parameter :: charge = -1
   call new(self, sym, xyz, charge=charge)
end subroutine il213B

subroutine il214(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 19
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "N", "C", "C", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H", &
      & "O", "Cl", "O", "O", "O"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -1.22571407200000_wp, -2.35703633100000_wp, -1.16951362100000_wp, &
      &  0.17262646900000_wp, -0.17704842800000_wp, -0.03074584200000_wp, &
      & -0.97712061800000_wp,  2.43103800000000_wp, -0.51349524300000_wp, &
      & -3.18766539000000_wp,  2.95441651100000_wp,  1.26333851600000_wp, &
      &  0.29228391900000_wp, -0.36411240400000_wp,  1.90405011300000_wp, &
      &  2.00535832400000_wp, -0.11601027900000_wp, -0.68319263700000_wp, &
      & -1.24929785200000_wp, -2.16607951900000_wp, -3.22908818300000_wp, &
      & -0.26741512500000_wp, -4.10900129600000_wp, -0.63097950800000_wp, &
      & -3.15894155500000_wp, -2.38114923400000_wp, -0.44431237500000_wp, &
      & -3.92739862900000_wp,  4.85122897400000_wp,  0.87639822300000_wp, &
      & -4.74806883200000_wp,  1.61044338600000_wp,  1.00973728800000_wp, &
      & -2.54355228600000_wp,  2.90424428600000_wp,  3.23124247100000_wp, &
      & -1.51582480600000_wp,  2.50313104700000_wp, -2.51365682100000_wp, &
      &  0.55818726300000_wp,  3.77019232400000_wp, -0.15595908600000_wp, &
      &  4.90646566400000_wp,  0.96774757700000_wp,  2.00259932400000_wp, &
      &  3.68677981800000_wp,  1.75122797300000_wp,  4.43989231700000_wp, &
      &  5.46571117400000_wp,  1.56879382500000_wp,  6.52962690700000_wp, &
      &  2.65347764700000_wp,  4.32970239500000_wp,  4.15751056300000_wp, &
      &  1.47978773100000_wp, -0.04416289600000_wp,  4.90073979500000_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine il214

subroutine il214A(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 14
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "N", "C", "C", "H", "H", "H", "H", "H", "H", "H", "H", "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -1.22571407200000_wp, -2.35703633100000_wp, -1.16951362100000_wp, &
      &  0.17262646900000_wp, -0.17704842800000_wp, -0.03074584200000_wp, &
      & -0.97712061800000_wp,  2.43103800000000_wp, -0.51349524300000_wp, &
      & -3.18766539000000_wp,  2.95441651100000_wp,  1.26333851600000_wp, &
      &  0.29228391900000_wp, -0.36411240400000_wp,  1.90405011300000_wp, &
      &  2.00535832400000_wp, -0.11601027900000_wp, -0.68319263700000_wp, &
      & -1.24929785200000_wp, -2.16607951900000_wp, -3.22908818300000_wp, &
      & -0.26741512500000_wp, -4.10900129600000_wp, -0.63097950800000_wp, &
      & -3.15894155500000_wp, -2.38114923400000_wp, -0.44431237500000_wp, &
      & -3.92739862900000_wp,  4.85122897400000_wp,  0.87639822300000_wp, &
      & -4.74806883200000_wp,  1.61044338600000_wp,  1.00973728800000_wp, &
      & -2.54355228600000_wp,  2.90424428600000_wp,  3.23124247100000_wp, &
      & -1.51582480600000_wp,  2.50313104700000_wp, -2.51365682100000_wp, &
      &  0.55818726300000_wp,  3.77019232400000_wp, -0.15595908600000_wp],&
      & shape(xyz))
   real(wp), parameter :: charge = 1
   call new(self, sym, xyz, charge=charge)
end subroutine il214A

subroutine il214B(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 5
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "O", "Cl", "O", "O", "O"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  4.90646566400000_wp,  0.96774757700000_wp,  2.00259932400000_wp, &
      &  3.68677981800000_wp,  1.75122797300000_wp,  4.43989231700000_wp, &
      &  5.46571117400000_wp,  1.56879382500000_wp,  6.52962690700000_wp, &
      &  2.65347764700000_wp,  4.32970239500000_wp,  4.15751056300000_wp, &
      &  1.47978773100000_wp, -0.04416289600000_wp,  4.90073979500000_wp],&
      & shape(xyz))
   real(wp), parameter :: charge = -1
   call new(self, sym, xyz, charge=charge)
end subroutine il214B

subroutine il227(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 12
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "C", "N", "H", "H", "H", "H", "H", "H", "H", "H", "Cl"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  1.41789920500000_wp,  2.40947622700000_wp,  3.73194426900000_wp, &
      &  0.25934599500000_wp, -0.08862814900000_wp,  2.86023256700000_wp, &
      &  0.07842362900000_wp, -0.13556894300000_wp,  0.00563138300000_wp, &
      &  1.88957481200000_wp, -0.13641931900000_wp, -0.71242669800000_wp, &
      & -0.83427623000000_wp, -1.71730739100000_wp, -0.67283693900000_wp, &
      & -0.82796454500000_wp,  1.43260127300000_wp, -0.71331487000000_wp, &
      & -1.62799894100000_wp, -0.41324528000000_wp,  3.65066715500000_wp, &
      &  1.49473546400000_wp, -1.67943728200000_wp,  3.34148908500000_wp, &
      &  1.65479525500000_wp,  2.37857920700000_wp,  5.79025271600000_wp, &
      &  3.27122907300000_wp,  2.66542071500000_wp,  2.83997470500000_wp, &
      &  0.19364022200000_wp,  4.01852121600000_wp,  3.25274755300000_wp, &
      &  5.28144399300000_wp, -0.16656044900000_wp, -1.37932989800000_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine il227

subroutine il227A(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 11
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "C", "N", "H", "H", "H", "H", "H", "H", "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  1.41789920500000_wp,  2.40947622700000_wp,  3.73194426900000_wp, &
      &  0.25934599500000_wp, -0.08862814900000_wp,  2.86023256700000_wp, &
      &  0.07842362900000_wp, -0.13556894300000_wp,  0.00563138300000_wp, &
      &  1.88957481200000_wp, -0.13641931900000_wp, -0.71242669800000_wp, &
      & -0.83427623000000_wp, -1.71730739100000_wp, -0.67283693900000_wp, &
      & -0.82796454500000_wp,  1.43260127300000_wp, -0.71331487000000_wp, &
      & -1.62799894100000_wp, -0.41324528000000_wp,  3.65066715500000_wp, &
      &  1.49473546400000_wp, -1.67943728200000_wp,  3.34148908500000_wp, &
      &  1.65479525500000_wp,  2.37857920700000_wp,  5.79025271600000_wp, &
      &  3.27122907300000_wp,  2.66542071500000_wp,  2.83997470500000_wp, &
      &  0.19364022200000_wp,  4.01852121600000_wp,  3.25274755300000_wp],&
      & shape(xyz))
   real(wp), parameter :: charge = 1
   call new(self, sym, xyz, charge=charge)
end subroutine il227A

subroutine il227B(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 1
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "Cl"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  0.00000000000000_wp,  0.00000000000000_wp,  0.00000000000000_wp],&
      & shape(xyz))
   real(wp), parameter :: charge = -1
   call new(self, sym, xyz, charge=charge)
end subroutine il227B

subroutine il228(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 15
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "C", "N", "H", "H", "H", "H", "H", "H", "H", "H", "O", "N", "O", &
      & "O"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -0.23623464600000_wp,  2.64034405100000_wp,  3.61644421700000_wp, &
      &  0.01509891100000_wp, -0.06126491700000_wp,  2.60666913400000_wp, &
      &  0.05319578700000_wp, -0.09263436800000_wp, -0.28648246000000_wp, &
      &  1.86434697000000_wp, -0.09348474500000_wp, -1.00454054200000_wp, &
      & -0.85952296900000_wp, -1.67437281700000_wp, -0.96495078300000_wp, &
      & -0.85319238700000_wp,  1.47555474500000_wp, -1.00542871300000_wp, &
      & -1.57699523600000_wp, -1.26409440700000_wp,  3.25165151200000_wp, &
      &  1.75391138400000_wp, -0.96164376200000_wp,  3.23061886100000_wp, &
      & -0.05502882100000_wp,  2.58567427800000_wp,  5.67480935500000_wp, &
      &  1.27792720100000_wp,  3.90474081400000_wp,  2.76311954900000_wp, &
      & -2.09852181500000_wp,  3.49102310300000_wp,  3.20404931400000_wp, &
      &  4.01502522300000_wp, -0.15590239400000_wp, -3.46834639100000_wp, &
      &  2.63276625000000_wp,  0.00224877400000_wp, -5.52824220700000_wp, &
      &  3.65741347600000_wp, -0.14337351100000_wp, -7.62982537800000_wp, &
      &  0.24046763200000_wp,  0.35402126700000_wp, -5.28227547200000_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine il228

subroutine il228A(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 11
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "C", "N", "H", "H", "H", "H", "H", "H", "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      & -0.23623464600000_wp,  2.64034405100000_wp,  3.61644421700000_wp, &
      &  0.01509891100000_wp, -0.06126491700000_wp,  2.60666913400000_wp, &
      &  0.05319578700000_wp, -0.09263436800000_wp, -0.28648246000000_wp, &
      &  1.86434697000000_wp, -0.09348474500000_wp, -1.00454054200000_wp, &
      & -0.85952296900000_wp, -1.67437281700000_wp, -0.96495078300000_wp, &
      & -0.85319238700000_wp,  1.47555474500000_wp, -1.00542871300000_wp, &
      & -1.57699523600000_wp, -1.26409440700000_wp,  3.25165151200000_wp, &
      &  1.75391138400000_wp, -0.96164376200000_wp,  3.23061886100000_wp, &
      & -0.05502882100000_wp,  2.58567427800000_wp,  5.67480935500000_wp, &
      &  1.27792720100000_wp,  3.90474081400000_wp,  2.76311954900000_wp, &
      & -2.09852181500000_wp,  3.49102310300000_wp,  3.20404931400000_wp],&
      & shape(xyz))
   real(wp), parameter :: charge = 1
   call new(self, sym, xyz, charge=charge)
end subroutine il228A

subroutine il228B(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 4
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "O", "N", "O", "O"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  4.01502522300000_wp, -0.15590239400000_wp, -3.46834639100000_wp, &
      &  2.63276625000000_wp,  0.00224877400000_wp, -5.52824220700000_wp, &
      &  3.65741347600000_wp, -0.14337351100000_wp, -7.62982537800000_wp, &
      &  0.24046763200000_wp,  0.35402126700000_wp, -5.28227547200000_wp],&
      & shape(xyz))
   real(wp), parameter :: charge = -1
   call new(self, sym, xyz, charge=charge)
end subroutine il228B

subroutine il229(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 16
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "C", "N", "H", "H", "H", "H", "H", "H", "H", "H", "O", "Cl", "O", &
      & "O", "O"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  2.03667108300000_wp,  2.05394317900000_wp,  3.71045808500000_wp, &
      &  0.26151918000000_wp, -0.05121157400000_wp,  2.85184218400000_wp, &
      &  0.10595693600000_wp, -0.06755770400000_wp, -0.01165960900000_wp, &
      &  1.91708922300000_wp, -0.06838918400000_wp, -0.72971769100000_wp, &
      & -0.80676182000000_wp, -1.64929615300000_wp, -0.69012793200000_wp, &
      & -0.80043123800000_wp,  1.50063140900000_wp, -0.73060586200000_wp, &
      & -1.65402046800000_wp,  0.17137925000000_wp,  3.61128526500000_wp, &
      &  1.00021306900000_wp, -1.91096651100000_wp,  3.36781296800000_wp, &
      &  2.14457443800000_wp,  2.04475911100000_wp,  5.78036944900000_wp, &
      &  3.94068340200000_wp,  1.76676152000000_wp,  2.94196321600000_wp, &
      &  1.35421543900000_wp,  3.92785216300000_wp,  3.12288558300000_wp, &
      &  7.50784356600000_wp, -3.82214089100000_wp,  0.55476685900000_wp, &
      &  5.38934734700000_wp, -3.49398997300000_wp, -1.14772508000000_wp, &
      &  5.89010583700000_wp, -4.54462093200000_wp, -3.64849397000000_wp, &
      &  3.03998330400000_wp, -4.63128376600000_wp, -0.07719530700000_wp, &
      &  4.86782076800000_wp, -0.63574161800000_wp, -1.45682756100000_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine il229

subroutine il229A(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 11
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "C", "N", "H", "H", "H", "H", "H", "H", "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  2.03667108300000_wp,  2.05394317900000_wp,  3.71045808500000_wp, &
      &  0.26151918000000_wp, -0.05121157400000_wp,  2.85184218400000_wp, &
      &  0.10595693600000_wp, -0.06755770400000_wp, -0.01165960900000_wp, &
      &  1.91708922300000_wp, -0.06838918400000_wp, -0.72971769100000_wp, &
      & -0.80676182000000_wp, -1.64929615300000_wp, -0.69012793200000_wp, &
      & -0.80043123800000_wp,  1.50063140900000_wp, -0.73060586200000_wp, &
      & -1.65402046800000_wp,  0.17137925000000_wp,  3.61128526500000_wp, &
      &  1.00021306900000_wp, -1.91096651100000_wp,  3.36781296800000_wp, &
      &  2.14457443800000_wp,  2.04475911100000_wp,  5.78036944900000_wp, &
      &  3.94068340200000_wp,  1.76676152000000_wp,  2.94196321600000_wp, &
      &  1.35421543900000_wp,  3.92785216300000_wp,  3.12288558300000_wp],&
      & shape(xyz))
   real(wp), parameter :: charge = 1
   call new(self, sym, xyz, charge=charge)
end subroutine il229A

subroutine il229B(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 5
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "O", "Cl", "O", "O", "O"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  7.50784356600000_wp, -3.82214089100000_wp,  0.55476685900000_wp, &
      &  5.38934734700000_wp, -3.49398997300000_wp, -1.14772508000000_wp, &
      &  5.89010583700000_wp, -4.54462093200000_wp, -3.64849397000000_wp, &
      &  3.03998330400000_wp, -4.63128376600000_wp, -0.07719530700000_wp, &
      &  4.86782076800000_wp, -0.63574161800000_wp, -1.45682756100000_wp],&
      & shape(xyz))
   real(wp), parameter :: charge = -1
   call new(self, sym, xyz, charge=charge)
end subroutine il229B

subroutine il230(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 19
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "C", "N", "H", "H", "H", "H", "H", "H", "H", "H", "O", "S", "C", &
      & "O", "O", "H", "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  1.19060296300000_wp,  2.23461988100000_wp,  3.91934839600000_wp, &
      & -0.03019782100000_wp, -0.16909268200000_wp,  2.87892195700000_wp, &
      & -0.03129386200000_wp, -0.20344790000000_wp,  0.01464537600000_wp, &
      &  1.77983842400000_wp, -0.20429827700000_wp, -0.70341270500000_wp, &
      & -0.94401261900000_wp, -1.78518634900000_wp, -0.66384184300000_wp, &
      & -0.93770093400000_wp,  1.36474121300000_wp, -0.70430087700000_wp, &
      & -2.00530163200000_wp, -0.33591769200000_wp,  3.48917117100000_wp, &
      &  0.98256302900000_wp, -1.87407905900000_wp,  3.47133215800000_wp, &
      &  1.18274170300000_wp,  2.12898419800000_wp,  5.99011013600000_wp, &
      &  3.13231531500000_wp,  2.43491193900000_wp,  3.23766753900000_wp, &
      &  0.09956966200000_wp,  3.91099580700000_wp,  3.36373116000000_wp, &
      &  4.61979423200000_wp,  0.76789015600000_wp, -0.77267116300000_wp, &
      &  5.80075959200000_wp,  0.01288793100000_wp, -3.28392803200000_wp, &
      &  7.83391578500000_wp,  2.66564748200000_wp, -4.05964165300000_wp, &
      &  7.44005909400000_wp, -2.21249119000000_wp, -3.03276455000000_wp, &
      &  3.81233321300000_wp, -0.09117927900000_wp, -5.25147293800000_wp, &
      &  8.75160452100000_wp,  2.24656294900000_wp, -5.86737243300000_wp, &
      &  6.67351064300000_wp,  4.37297712000000_wp, -4.20838198600000_wp, &
      &  9.24157267500000_wp,  2.85392088300000_wp, -2.55428593000000_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine il230

subroutine il230A(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 11
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "C", "N", "H", "H", "H", "H", "H", "H", "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  1.19060296300000_wp,  2.23461988100000_wp,  3.91934839600000_wp, &
      & -0.03019782100000_wp, -0.16909268200000_wp,  2.87892195700000_wp, &
      & -0.03129386200000_wp, -0.20344790000000_wp,  0.01464537600000_wp, &
      &  1.77983842400000_wp, -0.20429827700000_wp, -0.70341270500000_wp, &
      & -0.94401261900000_wp, -1.78518634900000_wp, -0.66384184300000_wp, &
      & -0.93770093400000_wp,  1.36474121300000_wp, -0.70430087700000_wp, &
      & -2.00530163200000_wp, -0.33591769200000_wp,  3.48917117100000_wp, &
      &  0.98256302900000_wp, -1.87407905900000_wp,  3.47133215800000_wp, &
      &  1.18274170300000_wp,  2.12898419800000_wp,  5.99011013600000_wp, &
      &  3.13231531500000_wp,  2.43491193900000_wp,  3.23766753900000_wp, &
      &  0.09956966200000_wp,  3.91099580700000_wp,  3.36373116000000_wp],&
      & shape(xyz))
   real(wp), parameter :: charge = 1
   call new(self, sym, xyz, charge=charge)
end subroutine il230A

subroutine il230B(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 8
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "O", "S", "C", "O", "O", "H", "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  4.61979423200000_wp,  0.76789015600000_wp, -0.77267116300000_wp, &
      &  5.80075959200000_wp,  0.01288793100000_wp, -3.28392803200000_wp, &
      &  7.83391578500000_wp,  2.66564748200000_wp, -4.05964165300000_wp, &
      &  7.44005909400000_wp, -2.21249119000000_wp, -3.03276455000000_wp, &
      &  3.81233321300000_wp, -0.09117927900000_wp, -5.25147293800000_wp, &
      &  8.75160452100000_wp,  2.24656294900000_wp, -5.86737243300000_wp, &
      &  6.67351064300000_wp,  4.37297712000000_wp, -4.20838198600000_wp, &
      &  9.24157267500000_wp,  2.85392088300000_wp, -2.55428593000000_wp],&
      & shape(xyz))
   real(wp), parameter :: charge = -1
   call new(self, sym, xyz, charge=charge)
end subroutine il230B

subroutine il231(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 19
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "C", "N", "H", "H", "H", "H", "H", "H", "H", "H", "O", "S", "C", &
      & "O", "O", "F", "F", "F"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  1.50074479300000_wp,  2.34371376200000_wp,  3.47955246600000_wp, &
      &  0.08012438200000_wp, -0.00119052700000_wp,  2.57059426500000_wp, &
      &  0.03796459500000_wp, -0.08295897100000_wp, -0.29538307000000_wp, &
      &  1.84911577900000_wp, -0.08379045000000_wp, -1.01344115100000_wp, &
      & -0.87475416100000_wp, -1.66467852200000_wp, -0.97387028900000_wp, &
      & -0.86842357900000_wp,  1.48523014200000_wp, -1.01432932300000_wp, &
      & -1.88056081900000_wp, -0.02968759500000_wp,  3.23715731300000_wp, &
      &  1.00835778900000_wp, -1.74433047300000_wp,  3.19378810200000_wp, &
      &  1.56112153800000_wp,  2.36036224800000_wp,  5.55042759000000_wp, &
      &  3.44706807600000_wp,  2.35970084400000_wp,  2.76858085700000_wp, &
      &  0.56264701600000_wp,  4.08479390600000_wp,  2.85174769800000_wp, &
      &  4.15416574800000_wp, -0.06016887600000_wp, -3.28084777800000_wp, &
      &  2.26812472300000_wp,  0.01494773300000_wp, -5.39819126400000_wp, &
      &  4.31301611400000_wp,  0.04794234800000_wp, -8.34597483700000_wp, &
      &  0.73980882800000_wp, -2.30801683800000_wp, -5.56203050800000_wp, &
      &  0.81314909400000_wp,  2.38989866600000_wp, -5.45167051000000_wp, &
      &  2.83763144500000_wp,  0.04353928700000_wp,-10.43990461800000_wp, &
      &  5.79265266800000_wp,  2.14017137600000_wp, -8.39510771300000_wp, &
      &  5.82353079000000_wp, -2.02132650800000_wp, -8.40482090400000_wp],&
      & shape(xyz))
   call new(self, sym, xyz)
end subroutine il231

subroutine il231A(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 11
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "C", "C", "N", "H", "H", "H", "H", "H", "H", "H", "H"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  1.50074479300000_wp,  2.34371376200000_wp,  3.47955246600000_wp, &
      &  0.08012438200000_wp, -0.00119052700000_wp,  2.57059426500000_wp, &
      &  0.03796459500000_wp, -0.08295897100000_wp, -0.29538307000000_wp, &
      &  1.84911577900000_wp, -0.08379045000000_wp, -1.01344115100000_wp, &
      & -0.87475416100000_wp, -1.66467852200000_wp, -0.97387028900000_wp, &
      & -0.86842357900000_wp,  1.48523014200000_wp, -1.01432932300000_wp, &
      & -1.88056081900000_wp, -0.02968759500000_wp,  3.23715731300000_wp, &
      &  1.00835778900000_wp, -1.74433047300000_wp,  3.19378810200000_wp, &
      &  1.56112153800000_wp,  2.36036224800000_wp,  5.55042759000000_wp, &
      &  3.44706807600000_wp,  2.35970084400000_wp,  2.76858085700000_wp, &
      &  0.56264701600000_wp,  4.08479390600000_wp,  2.85174769800000_wp],&
      & shape(xyz))
   real(wp), parameter :: charge = 1
   call new(self, sym, xyz, charge=charge)
end subroutine il231A

subroutine il231B(self)
   type(structure_type), intent(out) :: self
   integer, parameter :: nat = 8
   character(len=*), parameter :: sym(nat) = [character(len=4)::&
      & "O", "S", "C", "O", "O", "F", "F", "F"]
   real(wp), parameter :: xyz(3, nat) = reshape([&
      &  4.15416574800000_wp, -0.06016887600000_wp, -3.28084777800000_wp, &
      &  2.26812472300000_wp,  0.01494773300000_wp, -5.39819126400000_wp, &
      &  4.31301611400000_wp,  0.04794234800000_wp, -8.34597483700000_wp, &
      &  0.73980882800000_wp, -2.30801683800000_wp, -5.56203050800000_wp, &
      &  0.81314909400000_wp,  2.38989866600000_wp, -5.45167051000000_wp, &
      &  2.83763144500000_wp,  0.04353928700000_wp,-10.43990461800000_wp, &
      &  5.79265266800000_wp,  2.14017137600000_wp, -8.39510771300000_wp, &
      &  5.82353079000000_wp, -2.02132650800000_wp, -8.40482090400000_wp],&
      & shape(xyz))
   real(wp), parameter :: charge = -1
   call new(self, sym, xyz, charge=charge)
end subroutine il231B

end module mstore_il16
