; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; ## Full FP16 support enabled by default.
; RUN: llc < %s -mtriple=nvptx64-nvidia-cuda -mcpu=sm_53 \
; RUN:          -O0 -disable-post-ra -frame-pointer=all -verify-machineinstrs \
; RUN: | FileCheck -allow-deprecated-dag-overlap -check-prefixes CHECK,CHECK-F16 %s
; RUN: %if ptxas %{                                                           \
; RUN:   llc < %s -mtriple=nvptx64-nvidia-cuda -mcpu=sm_53 \
; RUN:          -O0 -disable-post-ra -frame-pointer=all -verify-machineinstrs \
; RUN:   | %ptxas-verify -arch=sm_53                                          \
; RUN: %}
; ## FP16 support explicitly disabled.
; RUN: llc < %s -mtriple=nvptx64-nvidia-cuda -mcpu=sm_53 \
; RUN:          -O0 -disable-post-ra -frame-pointer=all --nvptx-no-f16-math \
; RUN:           -verify-machineinstrs \
; RUN: | FileCheck -allow-deprecated-dag-overlap -check-prefixes CHECK,CHECK-NOF16 %s
; RUN: %if ptxas %{                                                           \
; RUN:   llc < %s -mtriple=nvptx64-nvidia-cuda -mcpu=sm_53 \
; RUN:          -O0 -disable-post-ra -frame-pointer=all --nvptx-no-f16-math   \
; RUN:           -verify-machineinstrs                                        \
; RUN:   | %ptxas-verify -arch=sm_53                                          \
; RUN: %}
; ## FP16 is not supported by hardware.
; RUN: llc < %s -O0 -mtriple=nvptx64-nvidia-cuda -mcpu=sm_52 \
; RUN:          -disable-post-ra -frame-pointer=all -verify-machineinstrs \
; RUN: | FileCheck -allow-deprecated-dag-overlap -check-prefixes CHECK,CHECK-NOF16 %s
; RUN: %if ptxas %{                                                               \
; RUN:   llc < %s -O0 -mtriple=nvptx64-nvidia-cuda -mcpu=sm_52 \
; RUN:          -disable-post-ra -frame-pointer=all -verify-machineinstrs         \
; RUN:   | %ptxas-verify -arch=sm_52                                              \
; RUN: %}

target datalayout = "e-m:o-i64:64-i128:128-n32:64-S128"

define <2 x half> @test_ret_const() #0 {
; CHECK-LABEL: test_ret_const(
; CHECK:       {
; CHECK-EMPTY:
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    st.param.b32 [func_retval0], 1073757184;
; CHECK-NEXT:    ret;
  ret <2 x half> <half 1.0, half 2.0>
}

define half @test_extract_0(<2 x half> %a) #0 {
; CHECK-LABEL: test_extract_0(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<2>;
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_extract_0_param_0];
; CHECK-NEXT:    { .reg .b16 tmp; mov.b32 {%rs1, tmp}, %r1; }
; CHECK-NEXT:    st.param.b16 [func_retval0], %rs1;
; CHECK-NEXT:    ret;
  %e = extractelement <2 x half> %a, i32 0
  ret half %e
}

define half @test_extract_1(<2 x half> %a) #0 {
; CHECK-LABEL: test_extract_1(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<2>;
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_extract_1_param_0];
; CHECK-NEXT:    { .reg .b16 tmp; mov.b32 {tmp, %rs1}, %r1; }
; CHECK-NEXT:    st.param.b16 [func_retval0], %rs1;
; CHECK-NEXT:    ret;
  %e = extractelement <2 x half> %a, i32 1
  ret half %e
}

define half @test_extract_i(<2 x half> %a, i64 %idx) #0 {
; CHECK-LABEL: test_extract_i(
; CHECK:       {
; CHECK-NEXT:    .reg .pred %p<2>;
; CHECK-NEXT:    .reg .b16 %rs<4>;
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-NEXT:    .reg .b64 %rd<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [test_extract_i_param_1];
; CHECK-NEXT:    ld.param.b32 %r1, [test_extract_i_param_0];
; CHECK-NEXT:    setp.eq.b64 %p1, %rd1, 0;
; CHECK-NEXT:    mov.b32 {%rs1, %rs2}, %r1;
; CHECK-NEXT:    selp.b16 %rs3, %rs1, %rs2, %p1;
; CHECK-NEXT:    st.param.b16 [func_retval0], %rs3;
; CHECK-NEXT:    ret;
  %e = extractelement <2 x half> %a, i64 %idx
  ret half %e
}

define <2 x half> @test_fadd(<2 x half> %a, <2 x half> %b) #0 {
; CHECK-F16-LABEL: test_fadd(
; CHECK-F16:       {
; CHECK-F16-NEXT:    .reg .b32 %r<4>;
; CHECK-F16-EMPTY:
; CHECK-F16-NEXT:  // %bb.0:
; CHECK-F16-NEXT:    ld.param.b32 %r2, [test_fadd_param_1];
; CHECK-F16-NEXT:    ld.param.b32 %r1, [test_fadd_param_0];
; CHECK-F16-NEXT:    add.rn.f16x2 %r3, %r1, %r2;
; CHECK-F16-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-F16-NEXT:    ret;
;
; CHECK-NOF16-LABEL: test_fadd(
; CHECK-NOF16:       {
; CHECK-NOF16-NEXT:    .reg .b16 %rs<7>;
; CHECK-NOF16-NEXT:    .reg .b32 %r<10>;
; CHECK-NOF16-EMPTY:
; CHECK-NOF16-NEXT:  // %bb.0:
; CHECK-NOF16-NEXT:    ld.param.b32 %r2, [test_fadd_param_1];
; CHECK-NOF16-NEXT:    ld.param.b32 %r1, [test_fadd_param_0];
; CHECK-NOF16-NEXT:    mov.b32 {%rs1, %rs2}, %r2;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r3, %rs2;
; CHECK-NOF16-NEXT:    mov.b32 {%rs3, %rs4}, %r1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r4, %rs4;
; CHECK-NOF16-NEXT:    add.rn.f32 %r5, %r4, %r3;
; CHECK-NOF16-NEXT:    cvt.rn.f16.f32 %rs5, %r5;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r6, %rs1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r7, %rs3;
; CHECK-NOF16-NEXT:    add.rn.f32 %r8, %r7, %r6;
; CHECK-NOF16-NEXT:    cvt.rn.f16.f32 %rs6, %r8;
; CHECK-NOF16-NEXT:    mov.b32 %r9, {%rs6, %rs5};
; CHECK-NOF16-NEXT:    st.param.b32 [func_retval0], %r9;
; CHECK-NOF16-NEXT:    ret;
  %r = fadd <2 x half> %a, %b
  ret <2 x half> %r
}

; Check that we can lower fadd with immediate arguments.
define <2 x half> @test_fadd_imm_0(<2 x half> %a) #0 {
; CHECK-F16-LABEL: test_fadd_imm_0(
; CHECK-F16:       {
; CHECK-F16-NEXT:    .reg .b32 %r<4>;
; CHECK-F16-EMPTY:
; CHECK-F16-NEXT:  // %bb.0:
; CHECK-F16-NEXT:    ld.param.b32 %r1, [test_fadd_imm_0_param_0];
; CHECK-F16-NEXT:    mov.b32 %r2, 1073757184;
; CHECK-F16-NEXT:    add.rn.f16x2 %r3, %r1, %r2;
; CHECK-F16-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-F16-NEXT:    ret;
;
; CHECK-NOF16-LABEL: test_fadd_imm_0(
; CHECK-NOF16:       {
; CHECK-NOF16-NEXT:    .reg .b16 %rs<5>;
; CHECK-NOF16-NEXT:    .reg .b32 %r<7>;
; CHECK-NOF16-EMPTY:
; CHECK-NOF16-NEXT:  // %bb.0:
; CHECK-NOF16-NEXT:    ld.param.b32 %r1, [test_fadd_imm_0_param_0];
; CHECK-NOF16-NEXT:    mov.b32 {%rs1, %rs2}, %r1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r2, %rs2;
; CHECK-NOF16-NEXT:    add.rn.f32 %r3, %r2, 0f40000000;
; CHECK-NOF16-NEXT:    cvt.rn.f16.f32 %rs3, %r3;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r4, %rs1;
; CHECK-NOF16-NEXT:    add.rn.f32 %r5, %r4, 0f3F800000;
; CHECK-NOF16-NEXT:    cvt.rn.f16.f32 %rs4, %r5;
; CHECK-NOF16-NEXT:    mov.b32 %r6, {%rs4, %rs3};
; CHECK-NOF16-NEXT:    st.param.b32 [func_retval0], %r6;
; CHECK-NOF16-NEXT:    ret;
  %r = fadd <2 x half> <half 1.0, half 2.0>, %a
  ret <2 x half> %r
}

define <2 x half> @test_fadd_imm_1(<2 x half> %a) #0 {
; CHECK-F16-LABEL: test_fadd_imm_1(
; CHECK-F16:       {
; CHECK-F16-NEXT:    .reg .b32 %r<4>;
; CHECK-F16-EMPTY:
; CHECK-F16-NEXT:  // %bb.0:
; CHECK-F16-NEXT:    ld.param.b32 %r1, [test_fadd_imm_1_param_0];
; CHECK-F16-NEXT:    mov.b32 %r2, 1073757184;
; CHECK-F16-NEXT:    add.rn.f16x2 %r3, %r1, %r2;
; CHECK-F16-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-F16-NEXT:    ret;
;
; CHECK-NOF16-LABEL: test_fadd_imm_1(
; CHECK-NOF16:       {
; CHECK-NOF16-NEXT:    .reg .b16 %rs<5>;
; CHECK-NOF16-NEXT:    .reg .b32 %r<7>;
; CHECK-NOF16-EMPTY:
; CHECK-NOF16-NEXT:  // %bb.0:
; CHECK-NOF16-NEXT:    ld.param.b32 %r1, [test_fadd_imm_1_param_0];
; CHECK-NOF16-NEXT:    mov.b32 {%rs1, %rs2}, %r1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r2, %rs2;
; CHECK-NOF16-NEXT:    add.rn.f32 %r3, %r2, 0f40000000;
; CHECK-NOF16-NEXT:    cvt.rn.f16.f32 %rs3, %r3;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r4, %rs1;
; CHECK-NOF16-NEXT:    add.rn.f32 %r5, %r4, 0f3F800000;
; CHECK-NOF16-NEXT:    cvt.rn.f16.f32 %rs4, %r5;
; CHECK-NOF16-NEXT:    mov.b32 %r6, {%rs4, %rs3};
; CHECK-NOF16-NEXT:    st.param.b32 [func_retval0], %r6;
; CHECK-NOF16-NEXT:    ret;
  %r = fadd <2 x half> %a, <half 1.0, half 2.0>
  ret <2 x half> %r
}

define <2 x half> @test_fsub(<2 x half> %a, <2 x half> %b) #0 {
; CHECK-F16-LABEL: test_fsub(
; CHECK-F16:       {
; CHECK-F16-NEXT:    .reg .b32 %r<4>;
; CHECK-F16-EMPTY:
; CHECK-F16-NEXT:  // %bb.0:
; CHECK-F16-NEXT:    ld.param.b32 %r2, [test_fsub_param_1];
; CHECK-F16-NEXT:    ld.param.b32 %r1, [test_fsub_param_0];
; CHECK-F16-NEXT:    sub.rn.f16x2 %r3, %r1, %r2;
; CHECK-F16-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-F16-NEXT:    ret;
;
; CHECK-NOF16-LABEL: test_fsub(
; CHECK-NOF16:       {
; CHECK-NOF16-NEXT:    .reg .b16 %rs<7>;
; CHECK-NOF16-NEXT:    .reg .b32 %r<10>;
; CHECK-NOF16-EMPTY:
; CHECK-NOF16-NEXT:  // %bb.0:
; CHECK-NOF16-NEXT:    ld.param.b32 %r2, [test_fsub_param_1];
; CHECK-NOF16-NEXT:    ld.param.b32 %r1, [test_fsub_param_0];
; CHECK-NOF16-NEXT:    mov.b32 {%rs1, %rs2}, %r2;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r3, %rs2;
; CHECK-NOF16-NEXT:    mov.b32 {%rs3, %rs4}, %r1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r4, %rs4;
; CHECK-NOF16-NEXT:    sub.rn.f32 %r5, %r4, %r3;
; CHECK-NOF16-NEXT:    cvt.rn.f16.f32 %rs5, %r5;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r6, %rs1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r7, %rs3;
; CHECK-NOF16-NEXT:    sub.rn.f32 %r8, %r7, %r6;
; CHECK-NOF16-NEXT:    cvt.rn.f16.f32 %rs6, %r8;
; CHECK-NOF16-NEXT:    mov.b32 %r9, {%rs6, %rs5};
; CHECK-NOF16-NEXT:    st.param.b32 [func_retval0], %r9;
; CHECK-NOF16-NEXT:    ret;
  %r = fsub <2 x half> %a, %b
  ret <2 x half> %r
}

define <2 x half> @test_fneg(<2 x half> %a) #0 {
; CHECK-F16-LABEL: test_fneg(
; CHECK-F16:       {
; CHECK-F16-NEXT:    .reg .b32 %r<4>;
; CHECK-F16-EMPTY:
; CHECK-F16-NEXT:  // %bb.0:
; CHECK-F16-NEXT:    ld.param.b32 %r1, [test_fneg_param_0];
; CHECK-F16-NEXT:    mov.b32 %r2, 0;
; CHECK-F16-NEXT:    sub.rn.f16x2 %r3, %r2, %r1;
; CHECK-F16-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-F16-NEXT:    ret;
;
; CHECK-NOF16-LABEL: test_fneg(
; CHECK-NOF16:       {
; CHECK-NOF16-NEXT:    .reg .b16 %rs<5>;
; CHECK-NOF16-NEXT:    .reg .b32 %r<8>;
; CHECK-NOF16-EMPTY:
; CHECK-NOF16-NEXT:  // %bb.0:
; CHECK-NOF16-NEXT:    ld.param.b32 %r1, [test_fneg_param_0];
; CHECK-NOF16-NEXT:    mov.b32 {%rs1, %rs2}, %r1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r2, %rs2;
; CHECK-NOF16-NEXT:    mov.b32 %r3, 0f00000000;
; CHECK-NOF16-NEXT:    sub.rn.f32 %r4, %r3, %r2;
; CHECK-NOF16-NEXT:    cvt.rn.f16.f32 %rs3, %r4;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r5, %rs1;
; CHECK-NOF16-NEXT:    sub.rn.f32 %r6, %r3, %r5;
; CHECK-NOF16-NEXT:    cvt.rn.f16.f32 %rs4, %r6;
; CHECK-NOF16-NEXT:    mov.b32 %r7, {%rs4, %rs3};
; CHECK-NOF16-NEXT:    st.param.b32 [func_retval0], %r7;
; CHECK-NOF16-NEXT:    ret;
  %r = fsub <2 x half> <half 0.0, half 0.0>, %a
  ret <2 x half> %r
}

define <2 x half> @test_fmul(<2 x half> %a, <2 x half> %b) #0 {
; CHECK-F16-LABEL: test_fmul(
; CHECK-F16:       {
; CHECK-F16-NEXT:    .reg .b32 %r<4>;
; CHECK-F16-EMPTY:
; CHECK-F16-NEXT:  // %bb.0:
; CHECK-F16-NEXT:    ld.param.b32 %r2, [test_fmul_param_1];
; CHECK-F16-NEXT:    ld.param.b32 %r1, [test_fmul_param_0];
; CHECK-F16-NEXT:    mul.rn.f16x2 %r3, %r1, %r2;
; CHECK-F16-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-F16-NEXT:    ret;
;
; CHECK-NOF16-LABEL: test_fmul(
; CHECK-NOF16:       {
; CHECK-NOF16-NEXT:    .reg .b16 %rs<7>;
; CHECK-NOF16-NEXT:    .reg .b32 %r<10>;
; CHECK-NOF16-EMPTY:
; CHECK-NOF16-NEXT:  // %bb.0:
; CHECK-NOF16-NEXT:    ld.param.b32 %r2, [test_fmul_param_1];
; CHECK-NOF16-NEXT:    ld.param.b32 %r1, [test_fmul_param_0];
; CHECK-NOF16-NEXT:    mov.b32 {%rs1, %rs2}, %r2;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r3, %rs2;
; CHECK-NOF16-NEXT:    mov.b32 {%rs3, %rs4}, %r1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r4, %rs4;
; CHECK-NOF16-NEXT:    mul.rn.f32 %r5, %r4, %r3;
; CHECK-NOF16-NEXT:    cvt.rn.f16.f32 %rs5, %r5;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r6, %rs1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r7, %rs3;
; CHECK-NOF16-NEXT:    mul.rn.f32 %r8, %r7, %r6;
; CHECK-NOF16-NEXT:    cvt.rn.f16.f32 %rs6, %r8;
; CHECK-NOF16-NEXT:    mov.b32 %r9, {%rs6, %rs5};
; CHECK-NOF16-NEXT:    st.param.b32 [func_retval0], %r9;
; CHECK-NOF16-NEXT:    ret;
  %r = fmul <2 x half> %a, %b
  ret <2 x half> %r
}

define <2 x half> @test_fdiv(<2 x half> %a, <2 x half> %b) #0 {
; CHECK-LABEL: test_fdiv(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<7>;
; CHECK-NEXT:    .reg .b32 %r<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r2, [test_fdiv_param_1];
; CHECK-NEXT:    ld.param.b32 %r1, [test_fdiv_param_0];
; CHECK-NEXT:    mov.b32 {%rs1, %rs2}, %r2;
; CHECK-NEXT:    cvt.f32.f16 %r3, %rs2;
; CHECK-NEXT:    mov.b32 {%rs3, %rs4}, %r1;
; CHECK-NEXT:    cvt.f32.f16 %r4, %rs4;
; CHECK-NEXT:    div.rn.f32 %r5, %r4, %r3;
; CHECK-NEXT:    cvt.rn.f16.f32 %rs5, %r5;
; CHECK-NEXT:    cvt.f32.f16 %r6, %rs1;
; CHECK-NEXT:    cvt.f32.f16 %r7, %rs3;
; CHECK-NEXT:    div.rn.f32 %r8, %r7, %r6;
; CHECK-NEXT:    cvt.rn.f16.f32 %rs6, %r8;
; CHECK-NEXT:    mov.b32 %r9, {%rs6, %rs5};
; CHECK-NEXT:    st.param.b32 [func_retval0], %r9;
; CHECK-NEXT:    ret;
  %r = fdiv <2 x half> %a, %b
  ret <2 x half> %r
}

; -- Load two 16x2 inputs and split them into f16 elements
; -- Split into elements
; -- promote to f32.
; -- frem(a[0],b[0]).
; -- frem(a[1],b[1]).
; -- convert back to f16.
; -- merge into f16x2 and return it.
define <2 x half> @test_frem(<2 x half> %a, <2 x half> %b) #0 {
; CHECK-LABEL: test_frem(
; CHECK:       {
; CHECK-NEXT:    .reg .pred %p<3>;
; CHECK-NEXT:    .reg .b16 %rs<7>;
; CHECK-NEXT:    .reg .b32 %r<18>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r2, [test_frem_param_1];
; CHECK-NEXT:    ld.param.b32 %r1, [test_frem_param_0];
; CHECK-NEXT:    mov.b32 {%rs1, %rs2}, %r2;
; CHECK-NEXT:    cvt.f32.f16 %r3, %rs2;
; CHECK-NEXT:    mov.b32 {%rs3, %rs4}, %r1;
; CHECK-NEXT:    cvt.f32.f16 %r4, %rs4;
; CHECK-NEXT:    div.rn.f32 %r5, %r4, %r3;
; CHECK-NEXT:    cvt.rzi.f32.f32 %r6, %r5;
; CHECK-NEXT:    neg.f32 %r7, %r6;
; CHECK-NEXT:    fma.rn.f32 %r8, %r7, %r3, %r4;
; CHECK-NEXT:    testp.infinite.f32 %p1, %r3;
; CHECK-NEXT:    selp.f32 %r9, %r4, %r8, %p1;
; CHECK-NEXT:    cvt.rn.f16.f32 %rs5, %r9;
; CHECK-NEXT:    cvt.f32.f16 %r10, %rs1;
; CHECK-NEXT:    cvt.f32.f16 %r11, %rs3;
; CHECK-NEXT:    div.rn.f32 %r12, %r11, %r10;
; CHECK-NEXT:    cvt.rzi.f32.f32 %r13, %r12;
; CHECK-NEXT:    neg.f32 %r14, %r13;
; CHECK-NEXT:    fma.rn.f32 %r15, %r14, %r10, %r11;
; CHECK-NEXT:    testp.infinite.f32 %p2, %r10;
; CHECK-NEXT:    selp.f32 %r16, %r11, %r15, %p2;
; CHECK-NEXT:    cvt.rn.f16.f32 %rs6, %r16;
; CHECK-NEXT:    mov.b32 %r17, {%rs6, %rs5};
; CHECK-NEXT:    st.param.b32 [func_retval0], %r17;
; CHECK-NEXT:    ret;
  %r = frem <2 x half> %a, %b
  ret <2 x half> %r
}

define void @test_ldst_v2f16(ptr %a, ptr %b) {
; CHECK-LABEL: test_ldst_v2f16(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-NEXT:    .reg .b64 %rd<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd2, [test_ldst_v2f16_param_1];
; CHECK-NEXT:    ld.param.b64 %rd1, [test_ldst_v2f16_param_0];
; CHECK-NEXT:    ld.b32 %r1, [%rd1];
; CHECK-NEXT:    st.b32 [%rd2], %r1;
; CHECK-NEXT:    ret;
  %t1 = load <2 x half>, ptr %a
  store <2 x half> %t1, ptr %b, align 16
  ret void
}

; -- v3 is inconvenient to capture as it's lowered as ld.b64 + fair
;    number of bitshifting instructions that may change at llvm's whim.
;    So we only verify that we only issue correct number of writes using
;    correct offset, but not the values we write.
define void @test_ldst_v3f16(ptr %a, ptr %b) {
; CHECK-LABEL: test_ldst_v3f16(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<2>;
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-NEXT:    .reg .b64 %rd<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd2, [test_ldst_v3f16_param_1];
; CHECK-NEXT:    ld.param.b64 %rd1, [test_ldst_v3f16_param_0];
; CHECK-NEXT:    ld.b64 %rd3, [%rd1];
; CHECK-NEXT:    { .reg .b32 tmp; mov.b64 {tmp, %r1}, %rd3; }
; CHECK-NEXT:    st.b32 [%rd2], %rd3;
; CHECK-NEXT:    { .reg .b16 tmp; mov.b32 {%rs1, tmp}, %r1; }
; CHECK-NEXT:    st.b16 [%rd2+4], %rs1;
; CHECK-NEXT:    ret;
  %t1 = load <3 x half>, ptr %a
  store <3 x half> %t1, ptr %b, align 16
  ret void
}

define void @test_ldst_v4f16(ptr %a, ptr %b) {
; CHECK-LABEL: test_ldst_v4f16(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<3>;
; CHECK-NEXT:    .reg .b64 %rd<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd2, [test_ldst_v4f16_param_1];
; CHECK-NEXT:    ld.param.b64 %rd1, [test_ldst_v4f16_param_0];
; CHECK-NEXT:    ld.v2.b32 {%r1, %r2}, [%rd1];
; CHECK-NEXT:    st.v2.b32 [%rd2], {%r1, %r2};
; CHECK-NEXT:    ret;
  %t1 = load <4 x half>, ptr %a
  store <4 x half> %t1, ptr %b, align 16
  ret void
}

define void @test_ldst_v8f16(ptr %a, ptr %b) {
; CHECK-LABEL: test_ldst_v8f16(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd2, [test_ldst_v8f16_param_1];
; CHECK-NEXT:    ld.param.b64 %rd1, [test_ldst_v8f16_param_0];
; CHECK-NEXT:    ld.v4.b32 {%r1, %r2, %r3, %r4}, [%rd1];
; CHECK-NEXT:    st.v4.b32 [%rd2], {%r1, %r2, %r3, %r4};
; CHECK-NEXT:    ret;
  %t1 = load <8 x half>, ptr %a
  store <8 x half> %t1, ptr %b, align 16
  ret void
}

declare <2 x half> @test_callee(<2 x half> %a, <2 x half> %b) #0

define <2 x half> @test_call(<2 x half> %a, <2 x half> %b) #0 {
; CHECK-LABEL: test_call(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r2, [test_call_param_1];
; CHECK-NEXT:    ld.param.b32 %r1, [test_call_param_0];
; CHECK-NEXT:    { // callseq 0, 0
; CHECK-NEXT:    .param .align 4 .b8 param0[4];
; CHECK-NEXT:    st.param.b32 [param0], %r1;
; CHECK-NEXT:    .param .align 4 .b8 param1[4];
; CHECK-NEXT:    st.param.b32 [param1], %r2;
; CHECK-NEXT:    .param .align 4 .b8 retval0[4];
; CHECK-NEXT:    call.uni (retval0), test_callee, (param0, param1);
; CHECK-NEXT:    ld.param.b32 %r3, [retval0];
; CHECK-NEXT:    } // callseq 0
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %r = call <2 x half> @test_callee(<2 x half> %a, <2 x half> %b)
  ret <2 x half> %r
}

define <2 x half> @test_call_flipped(<2 x half> %a, <2 x half> %b) #0 {
; CHECK-LABEL: test_call_flipped(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r2, [test_call_flipped_param_1];
; CHECK-NEXT:    ld.param.b32 %r1, [test_call_flipped_param_0];
; CHECK-NEXT:    { // callseq 1, 0
; CHECK-NEXT:    .param .align 4 .b8 param0[4];
; CHECK-NEXT:    st.param.b32 [param0], %r2;
; CHECK-NEXT:    .param .align 4 .b8 param1[4];
; CHECK-NEXT:    st.param.b32 [param1], %r1;
; CHECK-NEXT:    .param .align 4 .b8 retval0[4];
; CHECK-NEXT:    call.uni (retval0), test_callee, (param0, param1);
; CHECK-NEXT:    ld.param.b32 %r3, [retval0];
; CHECK-NEXT:    } // callseq 1
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %r = call <2 x half> @test_callee(<2 x half> %b, <2 x half> %a)
  ret <2 x half> %r
}

define <2 x half> @test_tailcall_flipped(<2 x half> %a, <2 x half> %b) #0 {
; CHECK-LABEL: test_tailcall_flipped(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r2, [test_tailcall_flipped_param_1];
; CHECK-NEXT:    ld.param.b32 %r1, [test_tailcall_flipped_param_0];
; CHECK-NEXT:    { // callseq 2, 0
; CHECK-NEXT:    .param .align 4 .b8 param0[4];
; CHECK-NEXT:    st.param.b32 [param0], %r2;
; CHECK-NEXT:    .param .align 4 .b8 param1[4];
; CHECK-NEXT:    st.param.b32 [param1], %r1;
; CHECK-NEXT:    .param .align 4 .b8 retval0[4];
; CHECK-NEXT:    call.uni (retval0), test_callee, (param0, param1);
; CHECK-NEXT:    ld.param.b32 %r3, [retval0];
; CHECK-NEXT:    } // callseq 2
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %r = tail call <2 x half> @test_callee(<2 x half> %b, <2 x half> %a)
  ret <2 x half> %r
}

define <2 x half> @test_select(<2 x half> %a, <2 x half> %b, i1 zeroext %c) #0 {
; CHECK-LABEL: test_select(
; CHECK:       {
; CHECK-NEXT:    .reg .pred %p<2>;
; CHECK-NEXT:    .reg .b16 %rs<3>;
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b8 %rs1, [test_select_param_2];
; CHECK-NEXT:    and.b16 %rs2, %rs1, 1;
; CHECK-NEXT:    setp.ne.b16 %p1, %rs2, 0;
; CHECK-NEXT:    ld.param.b32 %r2, [test_select_param_1];
; CHECK-NEXT:    ld.param.b32 %r1, [test_select_param_0];
; CHECK-NEXT:    selp.b32 %r3, %r1, %r2, %p1;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %r = select i1 %c, <2 x half> %a, <2 x half> %b
  ret <2 x half> %r
}

define <2 x half> @test_select_cc(<2 x half> %a, <2 x half> %b, <2 x half> %c, <2 x half> %d) #0 {
; CHECK-F16-LABEL: test_select_cc(
; CHECK-F16:       {
; CHECK-F16-NEXT:    .reg .pred %p<3>;
; CHECK-F16-NEXT:    .reg .b16 %rs<7>;
; CHECK-F16-NEXT:    .reg .b32 %r<5>;
; CHECK-F16-EMPTY:
; CHECK-F16-NEXT:  // %bb.0:
; CHECK-F16-NEXT:    ld.param.b32 %r4, [test_select_cc_param_3];
; CHECK-F16-NEXT:    ld.param.b32 %r3, [test_select_cc_param_2];
; CHECK-F16-NEXT:    ld.param.b32 %r2, [test_select_cc_param_1];
; CHECK-F16-NEXT:    ld.param.b32 %r1, [test_select_cc_param_0];
; CHECK-F16-NEXT:    setp.neu.f16x2 %p1|%p2, %r3, %r4;
; CHECK-F16-NEXT:    mov.b32 {%rs1, %rs2}, %r2;
; CHECK-F16-NEXT:    mov.b32 {%rs3, %rs4}, %r1;
; CHECK-F16-NEXT:    selp.b16 %rs5, %rs4, %rs2, %p2;
; CHECK-F16-NEXT:    selp.b16 %rs6, %rs3, %rs1, %p1;
; CHECK-F16-NEXT:    st.param.v2.b16 [func_retval0], {%rs6, %rs5};
; CHECK-F16-NEXT:    ret;
;
; CHECK-NOF16-LABEL: test_select_cc(
; CHECK-NOF16:       {
; CHECK-NOF16-NEXT:    .reg .pred %p<3>;
; CHECK-NOF16-NEXT:    .reg .b16 %rs<11>;
; CHECK-NOF16-NEXT:    .reg .b32 %r<9>;
; CHECK-NOF16-EMPTY:
; CHECK-NOF16-NEXT:  // %bb.0:
; CHECK-NOF16-NEXT:    ld.param.b32 %r4, [test_select_cc_param_3];
; CHECK-NOF16-NEXT:    ld.param.b32 %r3, [test_select_cc_param_2];
; CHECK-NOF16-NEXT:    ld.param.b32 %r2, [test_select_cc_param_1];
; CHECK-NOF16-NEXT:    ld.param.b32 %r1, [test_select_cc_param_0];
; CHECK-NOF16-NEXT:    mov.b32 {%rs1, %rs2}, %r4;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r5, %rs1;
; CHECK-NOF16-NEXT:    mov.b32 {%rs3, %rs4}, %r3;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r6, %rs3;
; CHECK-NOF16-NEXT:    setp.neu.f32 %p1, %r6, %r5;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r7, %rs2;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r8, %rs4;
; CHECK-NOF16-NEXT:    setp.neu.f32 %p2, %r8, %r7;
; CHECK-NOF16-NEXT:    mov.b32 {%rs5, %rs6}, %r2;
; CHECK-NOF16-NEXT:    mov.b32 {%rs7, %rs8}, %r1;
; CHECK-NOF16-NEXT:    selp.b16 %rs9, %rs8, %rs6, %p2;
; CHECK-NOF16-NEXT:    selp.b16 %rs10, %rs7, %rs5, %p1;
; CHECK-NOF16-NEXT:    st.param.v2.b16 [func_retval0], {%rs10, %rs9};
; CHECK-NOF16-NEXT:    ret;
  %cc = fcmp une <2 x half> %c, %d
  %r = select <2 x i1> %cc, <2 x half> %a, <2 x half> %b
  ret <2 x half> %r
}

define <2 x float> @test_select_cc_f32_f16(<2 x float> %a, <2 x float> %b,
; CHECK-F16-LABEL: test_select_cc_f32_f16(
; CHECK-F16:       {
; CHECK-F16-NEXT:    .reg .pred %p<3>;
; CHECK-F16-NEXT:    .reg .b32 %r<9>;
; CHECK-F16-NEXT:    .reg .b64 %rd<3>;
; CHECK-F16-EMPTY:
; CHECK-F16-NEXT:  // %bb.0:
; CHECK-F16-NEXT:    ld.param.b32 %r2, [test_select_cc_f32_f16_param_3];
; CHECK-F16-NEXT:    ld.param.b32 %r1, [test_select_cc_f32_f16_param_2];
; CHECK-F16-NEXT:    ld.param.b64 %rd2, [test_select_cc_f32_f16_param_1];
; CHECK-F16-NEXT:    ld.param.b64 %rd1, [test_select_cc_f32_f16_param_0];
; CHECK-F16-NEXT:    setp.neu.f16x2 %p1|%p2, %r1, %r2;
; CHECK-F16-NEXT:    mov.b64 {%r3, %r4}, %rd2;
; CHECK-F16-NEXT:    mov.b64 {%r5, %r6}, %rd1;
; CHECK-F16-NEXT:    selp.f32 %r7, %r6, %r4, %p2;
; CHECK-F16-NEXT:    selp.f32 %r8, %r5, %r3, %p1;
; CHECK-F16-NEXT:    st.param.v2.b32 [func_retval0], {%r8, %r7};
; CHECK-F16-NEXT:    ret;
;
; CHECK-NOF16-LABEL: test_select_cc_f32_f16(
; CHECK-NOF16:       {
; CHECK-NOF16-NEXT:    .reg .pred %p<3>;
; CHECK-NOF16-NEXT:    .reg .b16 %rs<5>;
; CHECK-NOF16-NEXT:    .reg .b32 %r<13>;
; CHECK-NOF16-NEXT:    .reg .b64 %rd<3>;
; CHECK-NOF16-EMPTY:
; CHECK-NOF16-NEXT:  // %bb.0:
; CHECK-NOF16-NEXT:    ld.param.b32 %r2, [test_select_cc_f32_f16_param_3];
; CHECK-NOF16-NEXT:    ld.param.b32 %r1, [test_select_cc_f32_f16_param_2];
; CHECK-NOF16-NEXT:    ld.param.b64 %rd2, [test_select_cc_f32_f16_param_1];
; CHECK-NOF16-NEXT:    ld.param.b64 %rd1, [test_select_cc_f32_f16_param_0];
; CHECK-NOF16-NEXT:    mov.b32 {%rs1, %rs2}, %r2;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r3, %rs1;
; CHECK-NOF16-NEXT:    mov.b32 {%rs3, %rs4}, %r1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r4, %rs3;
; CHECK-NOF16-NEXT:    setp.neu.f32 %p1, %r4, %r3;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r5, %rs2;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r6, %rs4;
; CHECK-NOF16-NEXT:    setp.neu.f32 %p2, %r6, %r5;
; CHECK-NOF16-NEXT:    mov.b64 {%r7, %r8}, %rd2;
; CHECK-NOF16-NEXT:    mov.b64 {%r9, %r10}, %rd1;
; CHECK-NOF16-NEXT:    selp.f32 %r11, %r10, %r8, %p2;
; CHECK-NOF16-NEXT:    selp.f32 %r12, %r9, %r7, %p1;
; CHECK-NOF16-NEXT:    st.param.v2.b32 [func_retval0], {%r12, %r11};
; CHECK-NOF16-NEXT:    ret;
                                           <2 x half> %c, <2 x half> %d) #0 {
  %cc = fcmp une <2 x half> %c, %d
  %r = select <2 x i1> %cc, <2 x float> %a, <2 x float> %b
  ret <2 x float> %r
}

define <2 x half> @test_select_cc_f16_f32(<2 x half> %a, <2 x half> %b,
; CHECK-LABEL: test_select_cc_f16_f32(
; CHECK:       {
; CHECK-NEXT:    .reg .pred %p<3>;
; CHECK-NEXT:    .reg .b16 %rs<7>;
; CHECK-NEXT:    .reg .b32 %r<7>;
; CHECK-NEXT:    .reg .b64 %rd<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd2, [test_select_cc_f16_f32_param_3];
; CHECK-NEXT:    ld.param.b64 %rd1, [test_select_cc_f16_f32_param_2];
; CHECK-NEXT:    ld.param.b32 %r2, [test_select_cc_f16_f32_param_1];
; CHECK-NEXT:    ld.param.b32 %r1, [test_select_cc_f16_f32_param_0];
; CHECK-NEXT:    mov.b64 {%r3, %r4}, %rd2;
; CHECK-NEXT:    mov.b64 {%r5, %r6}, %rd1;
; CHECK-NEXT:    setp.neu.f32 %p1, %r5, %r3;
; CHECK-NEXT:    setp.neu.f32 %p2, %r6, %r4;
; CHECK-NEXT:    mov.b32 {%rs1, %rs2}, %r2;
; CHECK-NEXT:    mov.b32 {%rs3, %rs4}, %r1;
; CHECK-NEXT:    selp.b16 %rs5, %rs4, %rs2, %p2;
; CHECK-NEXT:    selp.b16 %rs6, %rs3, %rs1, %p1;
; CHECK-NEXT:    st.param.v2.b16 [func_retval0], {%rs6, %rs5};
; CHECK-NEXT:    ret;
                                          <2 x float> %c, <2 x float> %d) #0 {
  %cc = fcmp une <2 x float> %c, %d
  %r = select <2 x i1> %cc, <2 x half> %a, <2 x half> %b
  ret <2 x half> %r
}

define <2 x i1> @test_fcmp_une(<2 x half> %a, <2 x half> %b) #0 {
; CHECK-F16-LABEL: test_fcmp_une(
; CHECK-F16:       {
; CHECK-F16-NEXT:    .reg .pred %p<3>;
; CHECK-F16-NEXT:    .reg .b16 %rs<3>;
; CHECK-F16-NEXT:    .reg .b32 %r<3>;
; CHECK-F16-EMPTY:
; CHECK-F16-NEXT:  // %bb.0:
; CHECK-F16-NEXT:    ld.param.b32 %r2, [test_fcmp_une_param_1];
; CHECK-F16-NEXT:    ld.param.b32 %r1, [test_fcmp_une_param_0];
; CHECK-F16-NEXT:    setp.neu.f16x2 %p1|%p2, %r1, %r2;
; CHECK-F16-NEXT:    selp.b16 %rs1, -1, 0, %p1;
; CHECK-F16-NEXT:    st.param.b8 [func_retval0], %rs1;
; CHECK-F16-NEXT:    selp.b16 %rs2, -1, 0, %p2;
; CHECK-F16-NEXT:    st.param.b8 [func_retval0+1], %rs2;
; CHECK-F16-NEXT:    ret;
;
; CHECK-NOF16-LABEL: test_fcmp_une(
; CHECK-NOF16:       {
; CHECK-NOF16-NEXT:    .reg .pred %p<3>;
; CHECK-NOF16-NEXT:    .reg .b16 %rs<7>;
; CHECK-NOF16-NEXT:    .reg .b32 %r<7>;
; CHECK-NOF16-EMPTY:
; CHECK-NOF16-NEXT:  // %bb.0:
; CHECK-NOF16-NEXT:    ld.param.b32 %r2, [test_fcmp_une_param_1];
; CHECK-NOF16-NEXT:    ld.param.b32 %r1, [test_fcmp_une_param_0];
; CHECK-NOF16-NEXT:    mov.b32 {%rs1, %rs2}, %r2;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r3, %rs2;
; CHECK-NOF16-NEXT:    mov.b32 {%rs3, %rs4}, %r1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r4, %rs4;
; CHECK-NOF16-NEXT:    setp.neu.f32 %p1, %r4, %r3;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r5, %rs1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r6, %rs3;
; CHECK-NOF16-NEXT:    setp.neu.f32 %p2, %r6, %r5;
; CHECK-NOF16-NEXT:    selp.b16 %rs5, -1, 0, %p2;
; CHECK-NOF16-NEXT:    st.param.b8 [func_retval0], %rs5;
; CHECK-NOF16-NEXT:    selp.b16 %rs6, -1, 0, %p1;
; CHECK-NOF16-NEXT:    st.param.b8 [func_retval0+1], %rs6;
; CHECK-NOF16-NEXT:    ret;
  %r = fcmp une <2 x half> %a, %b
  ret <2 x i1> %r
}

define <2 x i1> @test_fcmp_ueq(<2 x half> %a, <2 x half> %b) #0 {
; CHECK-F16-LABEL: test_fcmp_ueq(
; CHECK-F16:       {
; CHECK-F16-NEXT:    .reg .pred %p<3>;
; CHECK-F16-NEXT:    .reg .b16 %rs<3>;
; CHECK-F16-NEXT:    .reg .b32 %r<3>;
; CHECK-F16-EMPTY:
; CHECK-F16-NEXT:  // %bb.0:
; CHECK-F16-NEXT:    ld.param.b32 %r2, [test_fcmp_ueq_param_1];
; CHECK-F16-NEXT:    ld.param.b32 %r1, [test_fcmp_ueq_param_0];
; CHECK-F16-NEXT:    setp.equ.f16x2 %p1|%p2, %r1, %r2;
; CHECK-F16-NEXT:    selp.b16 %rs1, -1, 0, %p1;
; CHECK-F16-NEXT:    st.param.b8 [func_retval0], %rs1;
; CHECK-F16-NEXT:    selp.b16 %rs2, -1, 0, %p2;
; CHECK-F16-NEXT:    st.param.b8 [func_retval0+1], %rs2;
; CHECK-F16-NEXT:    ret;
;
; CHECK-NOF16-LABEL: test_fcmp_ueq(
; CHECK-NOF16:       {
; CHECK-NOF16-NEXT:    .reg .pred %p<3>;
; CHECK-NOF16-NEXT:    .reg .b16 %rs<7>;
; CHECK-NOF16-NEXT:    .reg .b32 %r<7>;
; CHECK-NOF16-EMPTY:
; CHECK-NOF16-NEXT:  // %bb.0:
; CHECK-NOF16-NEXT:    ld.param.b32 %r2, [test_fcmp_ueq_param_1];
; CHECK-NOF16-NEXT:    ld.param.b32 %r1, [test_fcmp_ueq_param_0];
; CHECK-NOF16-NEXT:    mov.b32 {%rs1, %rs2}, %r2;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r3, %rs2;
; CHECK-NOF16-NEXT:    mov.b32 {%rs3, %rs4}, %r1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r4, %rs4;
; CHECK-NOF16-NEXT:    setp.equ.f32 %p1, %r4, %r3;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r5, %rs1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r6, %rs3;
; CHECK-NOF16-NEXT:    setp.equ.f32 %p2, %r6, %r5;
; CHECK-NOF16-NEXT:    selp.b16 %rs5, -1, 0, %p2;
; CHECK-NOF16-NEXT:    st.param.b8 [func_retval0], %rs5;
; CHECK-NOF16-NEXT:    selp.b16 %rs6, -1, 0, %p1;
; CHECK-NOF16-NEXT:    st.param.b8 [func_retval0+1], %rs6;
; CHECK-NOF16-NEXT:    ret;
  %r = fcmp ueq <2 x half> %a, %b
  ret <2 x i1> %r
}

define <2 x i1> @test_fcmp_ugt(<2 x half> %a, <2 x half> %b) #0 {
; CHECK-F16-LABEL: test_fcmp_ugt(
; CHECK-F16:       {
; CHECK-F16-NEXT:    .reg .pred %p<3>;
; CHECK-F16-NEXT:    .reg .b16 %rs<3>;
; CHECK-F16-NEXT:    .reg .b32 %r<3>;
; CHECK-F16-EMPTY:
; CHECK-F16-NEXT:  // %bb.0:
; CHECK-F16-NEXT:    ld.param.b32 %r2, [test_fcmp_ugt_param_1];
; CHECK-F16-NEXT:    ld.param.b32 %r1, [test_fcmp_ugt_param_0];
; CHECK-F16-NEXT:    setp.gtu.f16x2 %p1|%p2, %r1, %r2;
; CHECK-F16-NEXT:    selp.b16 %rs1, -1, 0, %p1;
; CHECK-F16-NEXT:    st.param.b8 [func_retval0], %rs1;
; CHECK-F16-NEXT:    selp.b16 %rs2, -1, 0, %p2;
; CHECK-F16-NEXT:    st.param.b8 [func_retval0+1], %rs2;
; CHECK-F16-NEXT:    ret;
;
; CHECK-NOF16-LABEL: test_fcmp_ugt(
; CHECK-NOF16:       {
; CHECK-NOF16-NEXT:    .reg .pred %p<3>;
; CHECK-NOF16-NEXT:    .reg .b16 %rs<7>;
; CHECK-NOF16-NEXT:    .reg .b32 %r<7>;
; CHECK-NOF16-EMPTY:
; CHECK-NOF16-NEXT:  // %bb.0:
; CHECK-NOF16-NEXT:    ld.param.b32 %r2, [test_fcmp_ugt_param_1];
; CHECK-NOF16-NEXT:    ld.param.b32 %r1, [test_fcmp_ugt_param_0];
; CHECK-NOF16-NEXT:    mov.b32 {%rs1, %rs2}, %r2;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r3, %rs2;
; CHECK-NOF16-NEXT:    mov.b32 {%rs3, %rs4}, %r1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r4, %rs4;
; CHECK-NOF16-NEXT:    setp.gtu.f32 %p1, %r4, %r3;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r5, %rs1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r6, %rs3;
; CHECK-NOF16-NEXT:    setp.gtu.f32 %p2, %r6, %r5;
; CHECK-NOF16-NEXT:    selp.b16 %rs5, -1, 0, %p2;
; CHECK-NOF16-NEXT:    st.param.b8 [func_retval0], %rs5;
; CHECK-NOF16-NEXT:    selp.b16 %rs6, -1, 0, %p1;
; CHECK-NOF16-NEXT:    st.param.b8 [func_retval0+1], %rs6;
; CHECK-NOF16-NEXT:    ret;
  %r = fcmp ugt <2 x half> %a, %b
  ret <2 x i1> %r
}

define <2 x i1> @test_fcmp_uge(<2 x half> %a, <2 x half> %b) #0 {
; CHECK-F16-LABEL: test_fcmp_uge(
; CHECK-F16:       {
; CHECK-F16-NEXT:    .reg .pred %p<3>;
; CHECK-F16-NEXT:    .reg .b16 %rs<3>;
; CHECK-F16-NEXT:    .reg .b32 %r<3>;
; CHECK-F16-EMPTY:
; CHECK-F16-NEXT:  // %bb.0:
; CHECK-F16-NEXT:    ld.param.b32 %r2, [test_fcmp_uge_param_1];
; CHECK-F16-NEXT:    ld.param.b32 %r1, [test_fcmp_uge_param_0];
; CHECK-F16-NEXT:    setp.geu.f16x2 %p1|%p2, %r1, %r2;
; CHECK-F16-NEXT:    selp.b16 %rs1, -1, 0, %p1;
; CHECK-F16-NEXT:    st.param.b8 [func_retval0], %rs1;
; CHECK-F16-NEXT:    selp.b16 %rs2, -1, 0, %p2;
; CHECK-F16-NEXT:    st.param.b8 [func_retval0+1], %rs2;
; CHECK-F16-NEXT:    ret;
;
; CHECK-NOF16-LABEL: test_fcmp_uge(
; CHECK-NOF16:       {
; CHECK-NOF16-NEXT:    .reg .pred %p<3>;
; CHECK-NOF16-NEXT:    .reg .b16 %rs<7>;
; CHECK-NOF16-NEXT:    .reg .b32 %r<7>;
; CHECK-NOF16-EMPTY:
; CHECK-NOF16-NEXT:  // %bb.0:
; CHECK-NOF16-NEXT:    ld.param.b32 %r2, [test_fcmp_uge_param_1];
; CHECK-NOF16-NEXT:    ld.param.b32 %r1, [test_fcmp_uge_param_0];
; CHECK-NOF16-NEXT:    mov.b32 {%rs1, %rs2}, %r2;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r3, %rs2;
; CHECK-NOF16-NEXT:    mov.b32 {%rs3, %rs4}, %r1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r4, %rs4;
; CHECK-NOF16-NEXT:    setp.geu.f32 %p1, %r4, %r3;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r5, %rs1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r6, %rs3;
; CHECK-NOF16-NEXT:    setp.geu.f32 %p2, %r6, %r5;
; CHECK-NOF16-NEXT:    selp.b16 %rs5, -1, 0, %p2;
; CHECK-NOF16-NEXT:    st.param.b8 [func_retval0], %rs5;
; CHECK-NOF16-NEXT:    selp.b16 %rs6, -1, 0, %p1;
; CHECK-NOF16-NEXT:    st.param.b8 [func_retval0+1], %rs6;
; CHECK-NOF16-NEXT:    ret;
  %r = fcmp uge <2 x half> %a, %b
  ret <2 x i1> %r
}

define <2 x i1> @test_fcmp_ult(<2 x half> %a, <2 x half> %b) #0 {
; CHECK-F16-LABEL: test_fcmp_ult(
; CHECK-F16:       {
; CHECK-F16-NEXT:    .reg .pred %p<3>;
; CHECK-F16-NEXT:    .reg .b16 %rs<3>;
; CHECK-F16-NEXT:    .reg .b32 %r<3>;
; CHECK-F16-EMPTY:
; CHECK-F16-NEXT:  // %bb.0:
; CHECK-F16-NEXT:    ld.param.b32 %r2, [test_fcmp_ult_param_1];
; CHECK-F16-NEXT:    ld.param.b32 %r1, [test_fcmp_ult_param_0];
; CHECK-F16-NEXT:    setp.ltu.f16x2 %p1|%p2, %r1, %r2;
; CHECK-F16-NEXT:    selp.b16 %rs1, -1, 0, %p1;
; CHECK-F16-NEXT:    st.param.b8 [func_retval0], %rs1;
; CHECK-F16-NEXT:    selp.b16 %rs2, -1, 0, %p2;
; CHECK-F16-NEXT:    st.param.b8 [func_retval0+1], %rs2;
; CHECK-F16-NEXT:    ret;
;
; CHECK-NOF16-LABEL: test_fcmp_ult(
; CHECK-NOF16:       {
; CHECK-NOF16-NEXT:    .reg .pred %p<3>;
; CHECK-NOF16-NEXT:    .reg .b16 %rs<7>;
; CHECK-NOF16-NEXT:    .reg .b32 %r<7>;
; CHECK-NOF16-EMPTY:
; CHECK-NOF16-NEXT:  // %bb.0:
; CHECK-NOF16-NEXT:    ld.param.b32 %r2, [test_fcmp_ult_param_1];
; CHECK-NOF16-NEXT:    ld.param.b32 %r1, [test_fcmp_ult_param_0];
; CHECK-NOF16-NEXT:    mov.b32 {%rs1, %rs2}, %r2;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r3, %rs2;
; CHECK-NOF16-NEXT:    mov.b32 {%rs3, %rs4}, %r1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r4, %rs4;
; CHECK-NOF16-NEXT:    setp.ltu.f32 %p1, %r4, %r3;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r5, %rs1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r6, %rs3;
; CHECK-NOF16-NEXT:    setp.ltu.f32 %p2, %r6, %r5;
; CHECK-NOF16-NEXT:    selp.b16 %rs5, -1, 0, %p2;
; CHECK-NOF16-NEXT:    st.param.b8 [func_retval0], %rs5;
; CHECK-NOF16-NEXT:    selp.b16 %rs6, -1, 0, %p1;
; CHECK-NOF16-NEXT:    st.param.b8 [func_retval0+1], %rs6;
; CHECK-NOF16-NEXT:    ret;
  %r = fcmp ult <2 x half> %a, %b
  ret <2 x i1> %r
}

define <2 x i1> @test_fcmp_ule(<2 x half> %a, <2 x half> %b) #0 {
; CHECK-F16-LABEL: test_fcmp_ule(
; CHECK-F16:       {
; CHECK-F16-NEXT:    .reg .pred %p<3>;
; CHECK-F16-NEXT:    .reg .b16 %rs<3>;
; CHECK-F16-NEXT:    .reg .b32 %r<3>;
; CHECK-F16-EMPTY:
; CHECK-F16-NEXT:  // %bb.0:
; CHECK-F16-NEXT:    ld.param.b32 %r2, [test_fcmp_ule_param_1];
; CHECK-F16-NEXT:    ld.param.b32 %r1, [test_fcmp_ule_param_0];
; CHECK-F16-NEXT:    setp.leu.f16x2 %p1|%p2, %r1, %r2;
; CHECK-F16-NEXT:    selp.b16 %rs1, -1, 0, %p1;
; CHECK-F16-NEXT:    st.param.b8 [func_retval0], %rs1;
; CHECK-F16-NEXT:    selp.b16 %rs2, -1, 0, %p2;
; CHECK-F16-NEXT:    st.param.b8 [func_retval0+1], %rs2;
; CHECK-F16-NEXT:    ret;
;
; CHECK-NOF16-LABEL: test_fcmp_ule(
; CHECK-NOF16:       {
; CHECK-NOF16-NEXT:    .reg .pred %p<3>;
; CHECK-NOF16-NEXT:    .reg .b16 %rs<7>;
; CHECK-NOF16-NEXT:    .reg .b32 %r<7>;
; CHECK-NOF16-EMPTY:
; CHECK-NOF16-NEXT:  // %bb.0:
; CHECK-NOF16-NEXT:    ld.param.b32 %r2, [test_fcmp_ule_param_1];
; CHECK-NOF16-NEXT:    ld.param.b32 %r1, [test_fcmp_ule_param_0];
; CHECK-NOF16-NEXT:    mov.b32 {%rs1, %rs2}, %r2;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r3, %rs2;
; CHECK-NOF16-NEXT:    mov.b32 {%rs3, %rs4}, %r1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r4, %rs4;
; CHECK-NOF16-NEXT:    setp.leu.f32 %p1, %r4, %r3;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r5, %rs1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r6, %rs3;
; CHECK-NOF16-NEXT:    setp.leu.f32 %p2, %r6, %r5;
; CHECK-NOF16-NEXT:    selp.b16 %rs5, -1, 0, %p2;
; CHECK-NOF16-NEXT:    st.param.b8 [func_retval0], %rs5;
; CHECK-NOF16-NEXT:    selp.b16 %rs6, -1, 0, %p1;
; CHECK-NOF16-NEXT:    st.param.b8 [func_retval0+1], %rs6;
; CHECK-NOF16-NEXT:    ret;
  %r = fcmp ule <2 x half> %a, %b
  ret <2 x i1> %r
}


define <2 x i1> @test_fcmp_uno(<2 x half> %a, <2 x half> %b) #0 {
; CHECK-F16-LABEL: test_fcmp_uno(
; CHECK-F16:       {
; CHECK-F16-NEXT:    .reg .pred %p<3>;
; CHECK-F16-NEXT:    .reg .b16 %rs<3>;
; CHECK-F16-NEXT:    .reg .b32 %r<3>;
; CHECK-F16-EMPTY:
; CHECK-F16-NEXT:  // %bb.0:
; CHECK-F16-NEXT:    ld.param.b32 %r2, [test_fcmp_uno_param_1];
; CHECK-F16-NEXT:    ld.param.b32 %r1, [test_fcmp_uno_param_0];
; CHECK-F16-NEXT:    setp.nan.f16x2 %p1|%p2, %r1, %r2;
; CHECK-F16-NEXT:    selp.b16 %rs1, -1, 0, %p1;
; CHECK-F16-NEXT:    st.param.b8 [func_retval0], %rs1;
; CHECK-F16-NEXT:    selp.b16 %rs2, -1, 0, %p2;
; CHECK-F16-NEXT:    st.param.b8 [func_retval0+1], %rs2;
; CHECK-F16-NEXT:    ret;
;
; CHECK-NOF16-LABEL: test_fcmp_uno(
; CHECK-NOF16:       {
; CHECK-NOF16-NEXT:    .reg .pred %p<3>;
; CHECK-NOF16-NEXT:    .reg .b16 %rs<7>;
; CHECK-NOF16-NEXT:    .reg .b32 %r<7>;
; CHECK-NOF16-EMPTY:
; CHECK-NOF16-NEXT:  // %bb.0:
; CHECK-NOF16-NEXT:    ld.param.b32 %r2, [test_fcmp_uno_param_1];
; CHECK-NOF16-NEXT:    ld.param.b32 %r1, [test_fcmp_uno_param_0];
; CHECK-NOF16-NEXT:    mov.b32 {%rs1, %rs2}, %r2;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r3, %rs2;
; CHECK-NOF16-NEXT:    mov.b32 {%rs3, %rs4}, %r1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r4, %rs4;
; CHECK-NOF16-NEXT:    setp.nan.f32 %p1, %r4, %r3;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r5, %rs1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r6, %rs3;
; CHECK-NOF16-NEXT:    setp.nan.f32 %p2, %r6, %r5;
; CHECK-NOF16-NEXT:    selp.b16 %rs5, -1, 0, %p2;
; CHECK-NOF16-NEXT:    st.param.b8 [func_retval0], %rs5;
; CHECK-NOF16-NEXT:    selp.b16 %rs6, -1, 0, %p1;
; CHECK-NOF16-NEXT:    st.param.b8 [func_retval0+1], %rs6;
; CHECK-NOF16-NEXT:    ret;
  %r = fcmp uno <2 x half> %a, %b
  ret <2 x i1> %r
}

define <2 x i1> @test_fcmp_one(<2 x half> %a, <2 x half> %b) #0 {
; CHECK-F16-LABEL: test_fcmp_one(
; CHECK-F16:       {
; CHECK-F16-NEXT:    .reg .pred %p<3>;
; CHECK-F16-NEXT:    .reg .b16 %rs<3>;
; CHECK-F16-NEXT:    .reg .b32 %r<3>;
; CHECK-F16-EMPTY:
; CHECK-F16-NEXT:  // %bb.0:
; CHECK-F16-NEXT:    ld.param.b32 %r2, [test_fcmp_one_param_1];
; CHECK-F16-NEXT:    ld.param.b32 %r1, [test_fcmp_one_param_0];
; CHECK-F16-NEXT:    setp.ne.f16x2 %p1|%p2, %r1, %r2;
; CHECK-F16-NEXT:    selp.b16 %rs1, -1, 0, %p1;
; CHECK-F16-NEXT:    st.param.b8 [func_retval0], %rs1;
; CHECK-F16-NEXT:    selp.b16 %rs2, -1, 0, %p2;
; CHECK-F16-NEXT:    st.param.b8 [func_retval0+1], %rs2;
; CHECK-F16-NEXT:    ret;
;
; CHECK-NOF16-LABEL: test_fcmp_one(
; CHECK-NOF16:       {
; CHECK-NOF16-NEXT:    .reg .pred %p<3>;
; CHECK-NOF16-NEXT:    .reg .b16 %rs<7>;
; CHECK-NOF16-NEXT:    .reg .b32 %r<7>;
; CHECK-NOF16-EMPTY:
; CHECK-NOF16-NEXT:  // %bb.0:
; CHECK-NOF16-NEXT:    ld.param.b32 %r2, [test_fcmp_one_param_1];
; CHECK-NOF16-NEXT:    ld.param.b32 %r1, [test_fcmp_one_param_0];
; CHECK-NOF16-NEXT:    mov.b32 {%rs1, %rs2}, %r2;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r3, %rs2;
; CHECK-NOF16-NEXT:    mov.b32 {%rs3, %rs4}, %r1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r4, %rs4;
; CHECK-NOF16-NEXT:    setp.ne.f32 %p1, %r4, %r3;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r5, %rs1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r6, %rs3;
; CHECK-NOF16-NEXT:    setp.ne.f32 %p2, %r6, %r5;
; CHECK-NOF16-NEXT:    selp.b16 %rs5, -1, 0, %p2;
; CHECK-NOF16-NEXT:    st.param.b8 [func_retval0], %rs5;
; CHECK-NOF16-NEXT:    selp.b16 %rs6, -1, 0, %p1;
; CHECK-NOF16-NEXT:    st.param.b8 [func_retval0+1], %rs6;
; CHECK-NOF16-NEXT:    ret;
  %r = fcmp one <2 x half> %a, %b
  ret <2 x i1> %r
}

define <2 x i1> @test_fcmp_oeq(<2 x half> %a, <2 x half> %b) #0 {
; CHECK-F16-LABEL: test_fcmp_oeq(
; CHECK-F16:       {
; CHECK-F16-NEXT:    .reg .pred %p<3>;
; CHECK-F16-NEXT:    .reg .b16 %rs<3>;
; CHECK-F16-NEXT:    .reg .b32 %r<3>;
; CHECK-F16-EMPTY:
; CHECK-F16-NEXT:  // %bb.0:
; CHECK-F16-NEXT:    ld.param.b32 %r2, [test_fcmp_oeq_param_1];
; CHECK-F16-NEXT:    ld.param.b32 %r1, [test_fcmp_oeq_param_0];
; CHECK-F16-NEXT:    setp.eq.f16x2 %p1|%p2, %r1, %r2;
; CHECK-F16-NEXT:    selp.b16 %rs1, -1, 0, %p1;
; CHECK-F16-NEXT:    st.param.b8 [func_retval0], %rs1;
; CHECK-F16-NEXT:    selp.b16 %rs2, -1, 0, %p2;
; CHECK-F16-NEXT:    st.param.b8 [func_retval0+1], %rs2;
; CHECK-F16-NEXT:    ret;
;
; CHECK-NOF16-LABEL: test_fcmp_oeq(
; CHECK-NOF16:       {
; CHECK-NOF16-NEXT:    .reg .pred %p<3>;
; CHECK-NOF16-NEXT:    .reg .b16 %rs<7>;
; CHECK-NOF16-NEXT:    .reg .b32 %r<7>;
; CHECK-NOF16-EMPTY:
; CHECK-NOF16-NEXT:  // %bb.0:
; CHECK-NOF16-NEXT:    ld.param.b32 %r2, [test_fcmp_oeq_param_1];
; CHECK-NOF16-NEXT:    ld.param.b32 %r1, [test_fcmp_oeq_param_0];
; CHECK-NOF16-NEXT:    mov.b32 {%rs1, %rs2}, %r2;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r3, %rs2;
; CHECK-NOF16-NEXT:    mov.b32 {%rs3, %rs4}, %r1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r4, %rs4;
; CHECK-NOF16-NEXT:    setp.eq.f32 %p1, %r4, %r3;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r5, %rs1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r6, %rs3;
; CHECK-NOF16-NEXT:    setp.eq.f32 %p2, %r6, %r5;
; CHECK-NOF16-NEXT:    selp.b16 %rs5, -1, 0, %p2;
; CHECK-NOF16-NEXT:    st.param.b8 [func_retval0], %rs5;
; CHECK-NOF16-NEXT:    selp.b16 %rs6, -1, 0, %p1;
; CHECK-NOF16-NEXT:    st.param.b8 [func_retval0+1], %rs6;
; CHECK-NOF16-NEXT:    ret;
  %r = fcmp oeq <2 x half> %a, %b
  ret <2 x i1> %r
}

define <2 x i1> @test_fcmp_ogt(<2 x half> %a, <2 x half> %b) #0 {
; CHECK-F16-LABEL: test_fcmp_ogt(
; CHECK-F16:       {
; CHECK-F16-NEXT:    .reg .pred %p<3>;
; CHECK-F16-NEXT:    .reg .b16 %rs<3>;
; CHECK-F16-NEXT:    .reg .b32 %r<3>;
; CHECK-F16-EMPTY:
; CHECK-F16-NEXT:  // %bb.0:
; CHECK-F16-NEXT:    ld.param.b32 %r2, [test_fcmp_ogt_param_1];
; CHECK-F16-NEXT:    ld.param.b32 %r1, [test_fcmp_ogt_param_0];
; CHECK-F16-NEXT:    setp.gt.f16x2 %p1|%p2, %r1, %r2;
; CHECK-F16-NEXT:    selp.b16 %rs1, -1, 0, %p1;
; CHECK-F16-NEXT:    st.param.b8 [func_retval0], %rs1;
; CHECK-F16-NEXT:    selp.b16 %rs2, -1, 0, %p2;
; CHECK-F16-NEXT:    st.param.b8 [func_retval0+1], %rs2;
; CHECK-F16-NEXT:    ret;
;
; CHECK-NOF16-LABEL: test_fcmp_ogt(
; CHECK-NOF16:       {
; CHECK-NOF16-NEXT:    .reg .pred %p<3>;
; CHECK-NOF16-NEXT:    .reg .b16 %rs<7>;
; CHECK-NOF16-NEXT:    .reg .b32 %r<7>;
; CHECK-NOF16-EMPTY:
; CHECK-NOF16-NEXT:  // %bb.0:
; CHECK-NOF16-NEXT:    ld.param.b32 %r2, [test_fcmp_ogt_param_1];
; CHECK-NOF16-NEXT:    ld.param.b32 %r1, [test_fcmp_ogt_param_0];
; CHECK-NOF16-NEXT:    mov.b32 {%rs1, %rs2}, %r2;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r3, %rs2;
; CHECK-NOF16-NEXT:    mov.b32 {%rs3, %rs4}, %r1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r4, %rs4;
; CHECK-NOF16-NEXT:    setp.gt.f32 %p1, %r4, %r3;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r5, %rs1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r6, %rs3;
; CHECK-NOF16-NEXT:    setp.gt.f32 %p2, %r6, %r5;
; CHECK-NOF16-NEXT:    selp.b16 %rs5, -1, 0, %p2;
; CHECK-NOF16-NEXT:    st.param.b8 [func_retval0], %rs5;
; CHECK-NOF16-NEXT:    selp.b16 %rs6, -1, 0, %p1;
; CHECK-NOF16-NEXT:    st.param.b8 [func_retval0+1], %rs6;
; CHECK-NOF16-NEXT:    ret;
  %r = fcmp ogt <2 x half> %a, %b
  ret <2 x i1> %r
}

define <2 x i1> @test_fcmp_oge(<2 x half> %a, <2 x half> %b) #0 {
; CHECK-F16-LABEL: test_fcmp_oge(
; CHECK-F16:       {
; CHECK-F16-NEXT:    .reg .pred %p<3>;
; CHECK-F16-NEXT:    .reg .b16 %rs<3>;
; CHECK-F16-NEXT:    .reg .b32 %r<3>;
; CHECK-F16-EMPTY:
; CHECK-F16-NEXT:  // %bb.0:
; CHECK-F16-NEXT:    ld.param.b32 %r2, [test_fcmp_oge_param_1];
; CHECK-F16-NEXT:    ld.param.b32 %r1, [test_fcmp_oge_param_0];
; CHECK-F16-NEXT:    setp.ge.f16x2 %p1|%p2, %r1, %r2;
; CHECK-F16-NEXT:    selp.b16 %rs1, -1, 0, %p1;
; CHECK-F16-NEXT:    st.param.b8 [func_retval0], %rs1;
; CHECK-F16-NEXT:    selp.b16 %rs2, -1, 0, %p2;
; CHECK-F16-NEXT:    st.param.b8 [func_retval0+1], %rs2;
; CHECK-F16-NEXT:    ret;
;
; CHECK-NOF16-LABEL: test_fcmp_oge(
; CHECK-NOF16:       {
; CHECK-NOF16-NEXT:    .reg .pred %p<3>;
; CHECK-NOF16-NEXT:    .reg .b16 %rs<7>;
; CHECK-NOF16-NEXT:    .reg .b32 %r<7>;
; CHECK-NOF16-EMPTY:
; CHECK-NOF16-NEXT:  // %bb.0:
; CHECK-NOF16-NEXT:    ld.param.b32 %r2, [test_fcmp_oge_param_1];
; CHECK-NOF16-NEXT:    ld.param.b32 %r1, [test_fcmp_oge_param_0];
; CHECK-NOF16-NEXT:    mov.b32 {%rs1, %rs2}, %r2;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r3, %rs2;
; CHECK-NOF16-NEXT:    mov.b32 {%rs3, %rs4}, %r1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r4, %rs4;
; CHECK-NOF16-NEXT:    setp.ge.f32 %p1, %r4, %r3;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r5, %rs1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r6, %rs3;
; CHECK-NOF16-NEXT:    setp.ge.f32 %p2, %r6, %r5;
; CHECK-NOF16-NEXT:    selp.b16 %rs5, -1, 0, %p2;
; CHECK-NOF16-NEXT:    st.param.b8 [func_retval0], %rs5;
; CHECK-NOF16-NEXT:    selp.b16 %rs6, -1, 0, %p1;
; CHECK-NOF16-NEXT:    st.param.b8 [func_retval0+1], %rs6;
; CHECK-NOF16-NEXT:    ret;
  %r = fcmp oge <2 x half> %a, %b
  ret <2 x i1> %r
}

define <2 x i1> @test_fcmp_olt(<2 x half> %a, <2 x half> %b) #0 {
; CHECK-F16-LABEL: test_fcmp_olt(
; CHECK-F16:       {
; CHECK-F16-NEXT:    .reg .pred %p<3>;
; CHECK-F16-NEXT:    .reg .b16 %rs<3>;
; CHECK-F16-NEXT:    .reg .b32 %r<3>;
; CHECK-F16-EMPTY:
; CHECK-F16-NEXT:  // %bb.0:
; CHECK-F16-NEXT:    ld.param.b32 %r2, [test_fcmp_olt_param_1];
; CHECK-F16-NEXT:    ld.param.b32 %r1, [test_fcmp_olt_param_0];
; CHECK-F16-NEXT:    setp.lt.f16x2 %p1|%p2, %r1, %r2;
; CHECK-F16-NEXT:    selp.b16 %rs1, -1, 0, %p1;
; CHECK-F16-NEXT:    st.param.b8 [func_retval0], %rs1;
; CHECK-F16-NEXT:    selp.b16 %rs2, -1, 0, %p2;
; CHECK-F16-NEXT:    st.param.b8 [func_retval0+1], %rs2;
; CHECK-F16-NEXT:    ret;
;
; CHECK-NOF16-LABEL: test_fcmp_olt(
; CHECK-NOF16:       {
; CHECK-NOF16-NEXT:    .reg .pred %p<3>;
; CHECK-NOF16-NEXT:    .reg .b16 %rs<7>;
; CHECK-NOF16-NEXT:    .reg .b32 %r<7>;
; CHECK-NOF16-EMPTY:
; CHECK-NOF16-NEXT:  // %bb.0:
; CHECK-NOF16-NEXT:    ld.param.b32 %r2, [test_fcmp_olt_param_1];
; CHECK-NOF16-NEXT:    ld.param.b32 %r1, [test_fcmp_olt_param_0];
; CHECK-NOF16-NEXT:    mov.b32 {%rs1, %rs2}, %r2;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r3, %rs2;
; CHECK-NOF16-NEXT:    mov.b32 {%rs3, %rs4}, %r1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r4, %rs4;
; CHECK-NOF16-NEXT:    setp.lt.f32 %p1, %r4, %r3;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r5, %rs1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r6, %rs3;
; CHECK-NOF16-NEXT:    setp.lt.f32 %p2, %r6, %r5;
; CHECK-NOF16-NEXT:    selp.b16 %rs5, -1, 0, %p2;
; CHECK-NOF16-NEXT:    st.param.b8 [func_retval0], %rs5;
; CHECK-NOF16-NEXT:    selp.b16 %rs6, -1, 0, %p1;
; CHECK-NOF16-NEXT:    st.param.b8 [func_retval0+1], %rs6;
; CHECK-NOF16-NEXT:    ret;
  %r = fcmp olt <2 x half> %a, %b
  ret <2 x i1> %r
}

define <2 x i1> @test_fcmp_ole(<2 x half> %a, <2 x half> %b) #0 {
; CHECK-F16-LABEL: test_fcmp_ole(
; CHECK-F16:       {
; CHECK-F16-NEXT:    .reg .pred %p<3>;
; CHECK-F16-NEXT:    .reg .b16 %rs<3>;
; CHECK-F16-NEXT:    .reg .b32 %r<3>;
; CHECK-F16-EMPTY:
; CHECK-F16-NEXT:  // %bb.0:
; CHECK-F16-NEXT:    ld.param.b32 %r2, [test_fcmp_ole_param_1];
; CHECK-F16-NEXT:    ld.param.b32 %r1, [test_fcmp_ole_param_0];
; CHECK-F16-NEXT:    setp.le.f16x2 %p1|%p2, %r1, %r2;
; CHECK-F16-NEXT:    selp.b16 %rs1, -1, 0, %p1;
; CHECK-F16-NEXT:    st.param.b8 [func_retval0], %rs1;
; CHECK-F16-NEXT:    selp.b16 %rs2, -1, 0, %p2;
; CHECK-F16-NEXT:    st.param.b8 [func_retval0+1], %rs2;
; CHECK-F16-NEXT:    ret;
;
; CHECK-NOF16-LABEL: test_fcmp_ole(
; CHECK-NOF16:       {
; CHECK-NOF16-NEXT:    .reg .pred %p<3>;
; CHECK-NOF16-NEXT:    .reg .b16 %rs<7>;
; CHECK-NOF16-NEXT:    .reg .b32 %r<7>;
; CHECK-NOF16-EMPTY:
; CHECK-NOF16-NEXT:  // %bb.0:
; CHECK-NOF16-NEXT:    ld.param.b32 %r2, [test_fcmp_ole_param_1];
; CHECK-NOF16-NEXT:    ld.param.b32 %r1, [test_fcmp_ole_param_0];
; CHECK-NOF16-NEXT:    mov.b32 {%rs1, %rs2}, %r2;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r3, %rs2;
; CHECK-NOF16-NEXT:    mov.b32 {%rs3, %rs4}, %r1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r4, %rs4;
; CHECK-NOF16-NEXT:    setp.le.f32 %p1, %r4, %r3;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r5, %rs1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r6, %rs3;
; CHECK-NOF16-NEXT:    setp.le.f32 %p2, %r6, %r5;
; CHECK-NOF16-NEXT:    selp.b16 %rs5, -1, 0, %p2;
; CHECK-NOF16-NEXT:    st.param.b8 [func_retval0], %rs5;
; CHECK-NOF16-NEXT:    selp.b16 %rs6, -1, 0, %p1;
; CHECK-NOF16-NEXT:    st.param.b8 [func_retval0+1], %rs6;
; CHECK-NOF16-NEXT:    ret;
  %r = fcmp ole <2 x half> %a, %b
  ret <2 x i1> %r
}

define <2 x i1> @test_fcmp_ord(<2 x half> %a, <2 x half> %b) #0 {
; CHECK-F16-LABEL: test_fcmp_ord(
; CHECK-F16:       {
; CHECK-F16-NEXT:    .reg .pred %p<3>;
; CHECK-F16-NEXT:    .reg .b16 %rs<3>;
; CHECK-F16-NEXT:    .reg .b32 %r<3>;
; CHECK-F16-EMPTY:
; CHECK-F16-NEXT:  // %bb.0:
; CHECK-F16-NEXT:    ld.param.b32 %r2, [test_fcmp_ord_param_1];
; CHECK-F16-NEXT:    ld.param.b32 %r1, [test_fcmp_ord_param_0];
; CHECK-F16-NEXT:    setp.num.f16x2 %p1|%p2, %r1, %r2;
; CHECK-F16-NEXT:    selp.b16 %rs1, -1, 0, %p1;
; CHECK-F16-NEXT:    st.param.b8 [func_retval0], %rs1;
; CHECK-F16-NEXT:    selp.b16 %rs2, -1, 0, %p2;
; CHECK-F16-NEXT:    st.param.b8 [func_retval0+1], %rs2;
; CHECK-F16-NEXT:    ret;
;
; CHECK-NOF16-LABEL: test_fcmp_ord(
; CHECK-NOF16:       {
; CHECK-NOF16-NEXT:    .reg .pred %p<3>;
; CHECK-NOF16-NEXT:    .reg .b16 %rs<7>;
; CHECK-NOF16-NEXT:    .reg .b32 %r<7>;
; CHECK-NOF16-EMPTY:
; CHECK-NOF16-NEXT:  // %bb.0:
; CHECK-NOF16-NEXT:    ld.param.b32 %r2, [test_fcmp_ord_param_1];
; CHECK-NOF16-NEXT:    ld.param.b32 %r1, [test_fcmp_ord_param_0];
; CHECK-NOF16-NEXT:    mov.b32 {%rs1, %rs2}, %r2;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r3, %rs2;
; CHECK-NOF16-NEXT:    mov.b32 {%rs3, %rs4}, %r1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r4, %rs4;
; CHECK-NOF16-NEXT:    setp.num.f32 %p1, %r4, %r3;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r5, %rs1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r6, %rs3;
; CHECK-NOF16-NEXT:    setp.num.f32 %p2, %r6, %r5;
; CHECK-NOF16-NEXT:    selp.b16 %rs5, -1, 0, %p2;
; CHECK-NOF16-NEXT:    st.param.b8 [func_retval0], %rs5;
; CHECK-NOF16-NEXT:    selp.b16 %rs6, -1, 0, %p1;
; CHECK-NOF16-NEXT:    st.param.b8 [func_retval0+1], %rs6;
; CHECK-NOF16-NEXT:    ret;
  %r = fcmp ord <2 x half> %a, %b
  ret <2 x i1> %r
}

define <2 x i32> @test_fptosi_i32(<2 x half> %a) #0 {
; CHECK-LABEL: test_fptosi_i32(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<3>;
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_fptosi_i32_param_0];
; CHECK-NEXT:    mov.b32 {%rs1, %rs2}, %r1;
; CHECK-NEXT:    cvt.rzi.s32.f16 %r2, %rs2;
; CHECK-NEXT:    cvt.rzi.s32.f16 %r3, %rs1;
; CHECK-NEXT:    st.param.v2.b32 [func_retval0], {%r3, %r2};
; CHECK-NEXT:    ret;
  %r = fptosi <2 x half> %a to <2 x i32>
  ret <2 x i32> %r
}

define <2 x i64> @test_fptosi_i64(<2 x half> %a) #0 {
; CHECK-LABEL: test_fptosi_i64(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<3>;
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-NEXT:    .reg .b64 %rd<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_fptosi_i64_param_0];
; CHECK-NEXT:    mov.b32 {%rs1, %rs2}, %r1;
; CHECK-NEXT:    cvt.rzi.s64.f16 %rd1, %rs2;
; CHECK-NEXT:    cvt.rzi.s64.f16 %rd2, %rs1;
; CHECK-NEXT:    st.param.v2.b64 [func_retval0], {%rd2, %rd1};
; CHECK-NEXT:    ret;
  %r = fptosi <2 x half> %a to <2 x i64>
  ret <2 x i64> %r
}

define <2 x i32> @test_fptoui_2xi32(<2 x half> %a) #0 {
; CHECK-LABEL: test_fptoui_2xi32(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<3>;
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_fptoui_2xi32_param_0];
; CHECK-NEXT:    mov.b32 {%rs1, %rs2}, %r1;
; CHECK-NEXT:    cvt.rzi.u32.f16 %r2, %rs2;
; CHECK-NEXT:    cvt.rzi.u32.f16 %r3, %rs1;
; CHECK-NEXT:    st.param.v2.b32 [func_retval0], {%r3, %r2};
; CHECK-NEXT:    ret;
  %r = fptoui <2 x half> %a to <2 x i32>
  ret <2 x i32> %r
}

define <2 x i64> @test_fptoui_2xi64(<2 x half> %a) #0 {
; CHECK-LABEL: test_fptoui_2xi64(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<3>;
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-NEXT:    .reg .b64 %rd<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_fptoui_2xi64_param_0];
; CHECK-NEXT:    mov.b32 {%rs1, %rs2}, %r1;
; CHECK-NEXT:    cvt.rzi.u64.f16 %rd1, %rs2;
; CHECK-NEXT:    cvt.rzi.u64.f16 %rd2, %rs1;
; CHECK-NEXT:    st.param.v2.b64 [func_retval0], {%rd2, %rd1};
; CHECK-NEXT:    ret;
  %r = fptoui <2 x half> %a to <2 x i64>
  ret <2 x i64> %r
}

define <2 x half> @test_uitofp_2xi32(<2 x i32> %a) #0 {
; CHECK-LABEL: test_uitofp_2xi32(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<3>;
; CHECK-NEXT:    .reg .b32 %r<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.v2.b32 {%r1, %r2}, [test_uitofp_2xi32_param_0];
; CHECK-NEXT:    cvt.rn.f16.u32 %rs1, %r2;
; CHECK-NEXT:    cvt.rn.f16.u32 %rs2, %r1;
; CHECK-NEXT:    st.param.v2.b16 [func_retval0], {%rs2, %rs1};
; CHECK-NEXT:    ret;
  %r = uitofp <2 x i32> %a to <2 x half>
  ret <2 x half> %r
}

define <2 x half> @test_uitofp_2xi64(<2 x i64> %a) #0 {
; CHECK-LABEL: test_uitofp_2xi64(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<3>;
; CHECK-NEXT:    .reg .b64 %rd<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.v2.b64 {%rd1, %rd2}, [test_uitofp_2xi64_param_0];
; CHECK-NEXT:    cvt.rn.f16.u64 %rs1, %rd2;
; CHECK-NEXT:    cvt.rn.f16.u64 %rs2, %rd1;
; CHECK-NEXT:    st.param.v2.b16 [func_retval0], {%rs2, %rs1};
; CHECK-NEXT:    ret;
  %r = uitofp <2 x i64> %a to <2 x half>
  ret <2 x half> %r
}

define <2 x half> @test_sitofp_2xi32(<2 x i32> %a) #0 {
; CHECK-LABEL: test_sitofp_2xi32(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<3>;
; CHECK-NEXT:    .reg .b32 %r<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.v2.b32 {%r1, %r2}, [test_sitofp_2xi32_param_0];
; CHECK-NEXT:    cvt.rn.f16.s32 %rs1, %r2;
; CHECK-NEXT:    cvt.rn.f16.s32 %rs2, %r1;
; CHECK-NEXT:    st.param.v2.b16 [func_retval0], {%rs2, %rs1};
; CHECK-NEXT:    ret;
  %r = sitofp <2 x i32> %a to <2 x half>
  ret <2 x half> %r
}

define <2 x half> @test_sitofp_2xi64(<2 x i64> %a) #0 {
; CHECK-LABEL: test_sitofp_2xi64(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<3>;
; CHECK-NEXT:    .reg .b64 %rd<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.v2.b64 {%rd1, %rd2}, [test_sitofp_2xi64_param_0];
; CHECK-NEXT:    cvt.rn.f16.s64 %rs1, %rd2;
; CHECK-NEXT:    cvt.rn.f16.s64 %rs2, %rd1;
; CHECK-NEXT:    st.param.v2.b16 [func_retval0], {%rs2, %rs1};
; CHECK-NEXT:    ret;
  %r = sitofp <2 x i64> %a to <2 x half>
  ret <2 x half> %r
}


define <2 x half> @test_uitofp_2xi32_fadd(<2 x i32> %a, <2 x half> %b) #0 {
; CHECK-F16-LABEL: test_uitofp_2xi32_fadd(
; CHECK-F16:       {
; CHECK-F16-NEXT:    .reg .b16 %rs<3>;
; CHECK-F16-NEXT:    .reg .b32 %r<6>;
; CHECK-F16-EMPTY:
; CHECK-F16-NEXT:  // %bb.0:
; CHECK-F16-NEXT:    ld.param.v2.b32 {%r1, %r2}, [test_uitofp_2xi32_fadd_param_0];
; CHECK-F16-NEXT:    ld.param.b32 %r3, [test_uitofp_2xi32_fadd_param_1];
; CHECK-F16-NEXT:    cvt.rn.f16.u32 %rs1, %r2;
; CHECK-F16-NEXT:    cvt.rn.f16.u32 %rs2, %r1;
; CHECK-F16-NEXT:    mov.b32 %r4, {%rs2, %rs1};
; CHECK-F16-NEXT:    add.rn.f16x2 %r5, %r3, %r4;
; CHECK-F16-NEXT:    st.param.b32 [func_retval0], %r5;
; CHECK-F16-NEXT:    ret;
;
; CHECK-NOF16-LABEL: test_uitofp_2xi32_fadd(
; CHECK-NOF16:       {
; CHECK-NOF16-NEXT:    .reg .b16 %rs<7>;
; CHECK-NOF16-NEXT:    .reg .b32 %r<11>;
; CHECK-NOF16-EMPTY:
; CHECK-NOF16-NEXT:  // %bb.0:
; CHECK-NOF16-NEXT:    ld.param.v2.b32 {%r1, %r2}, [test_uitofp_2xi32_fadd_param_0];
; CHECK-NOF16-NEXT:    ld.param.b32 %r3, [test_uitofp_2xi32_fadd_param_1];
; CHECK-NOF16-NEXT:    cvt.rn.f16.u32 %rs1, %r1;
; CHECK-NOF16-NEXT:    cvt.rn.f16.u32 %rs2, %r2;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r4, %rs2;
; CHECK-NOF16-NEXT:    mov.b32 {%rs3, %rs4}, %r3;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r5, %rs4;
; CHECK-NOF16-NEXT:    add.rn.f32 %r6, %r5, %r4;
; CHECK-NOF16-NEXT:    cvt.rn.f16.f32 %rs5, %r6;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r7, %rs1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r8, %rs3;
; CHECK-NOF16-NEXT:    add.rn.f32 %r9, %r8, %r7;
; CHECK-NOF16-NEXT:    cvt.rn.f16.f32 %rs6, %r9;
; CHECK-NOF16-NEXT:    mov.b32 %r10, {%rs6, %rs5};
; CHECK-NOF16-NEXT:    st.param.b32 [func_retval0], %r10;
; CHECK-NOF16-NEXT:    ret;
  %c = uitofp <2 x i32> %a to <2 x half>
  %r = fadd <2 x half> %b, %c
  ret <2 x half> %r
}

define <2 x half> @test_sitofp_2xi32_fadd(<2 x i32> %a, <2 x half> %b) #0 {
; CHECK-F16-LABEL: test_sitofp_2xi32_fadd(
; CHECK-F16:       {
; CHECK-F16-NEXT:    .reg .b16 %rs<3>;
; CHECK-F16-NEXT:    .reg .b32 %r<6>;
; CHECK-F16-EMPTY:
; CHECK-F16-NEXT:  // %bb.0:
; CHECK-F16-NEXT:    ld.param.v2.b32 {%r1, %r2}, [test_sitofp_2xi32_fadd_param_0];
; CHECK-F16-NEXT:    ld.param.b32 %r3, [test_sitofp_2xi32_fadd_param_1];
; CHECK-F16-NEXT:    cvt.rn.f16.s32 %rs1, %r2;
; CHECK-F16-NEXT:    cvt.rn.f16.s32 %rs2, %r1;
; CHECK-F16-NEXT:    mov.b32 %r4, {%rs2, %rs1};
; CHECK-F16-NEXT:    add.rn.f16x2 %r5, %r3, %r4;
; CHECK-F16-NEXT:    st.param.b32 [func_retval0], %r5;
; CHECK-F16-NEXT:    ret;
;
; CHECK-NOF16-LABEL: test_sitofp_2xi32_fadd(
; CHECK-NOF16:       {
; CHECK-NOF16-NEXT:    .reg .b16 %rs<7>;
; CHECK-NOF16-NEXT:    .reg .b32 %r<11>;
; CHECK-NOF16-EMPTY:
; CHECK-NOF16-NEXT:  // %bb.0:
; CHECK-NOF16-NEXT:    ld.param.v2.b32 {%r1, %r2}, [test_sitofp_2xi32_fadd_param_0];
; CHECK-NOF16-NEXT:    ld.param.b32 %r3, [test_sitofp_2xi32_fadd_param_1];
; CHECK-NOF16-NEXT:    cvt.rn.f16.s32 %rs1, %r1;
; CHECK-NOF16-NEXT:    cvt.rn.f16.s32 %rs2, %r2;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r4, %rs2;
; CHECK-NOF16-NEXT:    mov.b32 {%rs3, %rs4}, %r3;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r5, %rs4;
; CHECK-NOF16-NEXT:    add.rn.f32 %r6, %r5, %r4;
; CHECK-NOF16-NEXT:    cvt.rn.f16.f32 %rs5, %r6;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r7, %rs1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r8, %rs3;
; CHECK-NOF16-NEXT:    add.rn.f32 %r9, %r8, %r7;
; CHECK-NOF16-NEXT:    cvt.rn.f16.f32 %rs6, %r9;
; CHECK-NOF16-NEXT:    mov.b32 %r10, {%rs6, %rs5};
; CHECK-NOF16-NEXT:    st.param.b32 [func_retval0], %r10;
; CHECK-NOF16-NEXT:    ret;
  %c = sitofp <2 x i32> %a to <2 x half>
  %r = fadd <2 x half> %b, %c
  ret <2 x half> %r
}

define <2 x half> @test_fptrunc_2xfloat(<2 x float> %a) #0 {
; CHECK-LABEL: test_fptrunc_2xfloat(
; CHECK:       {
; CHECK-NEXT:    .reg .b64 %rd<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [test_fptrunc_2xfloat_param_0];
; CHECK-NEXT:    st.param.b32 [func_retval0], %rd1;
; CHECK-NEXT:    ret;
  %r = fptrunc <2 x float> %a to <2 x half>
  ret <2 x half> %r
}

define <2 x half> @test_fptrunc_2xdouble(<2 x double> %a) #0 {
; CHECK-LABEL: test_fptrunc_2xdouble(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<3>;
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-NEXT:    .reg .b64 %rd<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.v2.b64 {%rd1, %rd2}, [test_fptrunc_2xdouble_param_0];
; CHECK-NEXT:    cvt.rn.f16.f64 %rs1, %rd2;
; CHECK-NEXT:    cvt.rn.f16.f64 %rs2, %rd1;
; CHECK-NEXT:    mov.b32 %r1, {%rs2, %rs1};
; CHECK-NEXT:    st.param.b32 [func_retval0], %r1;
; CHECK-NEXT:    ret;
  %r = fptrunc <2 x double> %a to <2 x half>
  ret <2 x half> %r
}

define <2 x float> @test_fpext_2xfloat(<2 x half> %a) #0 {
; CHECK-LABEL: test_fpext_2xfloat(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<3>;
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_fpext_2xfloat_param_0];
; CHECK-NEXT:    mov.b32 {%rs1, %rs2}, %r1;
; CHECK-NEXT:    cvt.f32.f16 %r2, %rs2;
; CHECK-NEXT:    cvt.f32.f16 %r3, %rs1;
; CHECK-NEXT:    st.param.v2.b32 [func_retval0], {%r3, %r2};
; CHECK-NEXT:    ret;
  %r = fpext <2 x half> %a to <2 x float>
  ret <2 x float> %r
}

define <2 x double> @test_fpext_2xdouble(<2 x half> %a) #0 {
; CHECK-LABEL: test_fpext_2xdouble(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<3>;
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-NEXT:    .reg .b64 %rd<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_fpext_2xdouble_param_0];
; CHECK-NEXT:    mov.b32 {%rs1, %rs2}, %r1;
; CHECK-NEXT:    cvt.f64.f16 %rd1, %rs2;
; CHECK-NEXT:    cvt.f64.f16 %rd2, %rs1;
; CHECK-NEXT:    st.param.v2.b64 [func_retval0], {%rd2, %rd1};
; CHECK-NEXT:    ret;
  %r = fpext <2 x half> %a to <2 x double>
  ret <2 x double> %r
}


define <2 x i16> @test_bitcast_2xhalf_to_2xi16(<2 x half> %a) #0 {
; CHECK-LABEL: test_bitcast_2xhalf_to_2xi16(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_bitcast_2xhalf_to_2xi16_param_0];
; CHECK-NEXT:    st.param.b32 [func_retval0], %r1;
; CHECK-NEXT:    ret;
  %r = bitcast <2 x half> %a to <2 x i16>
  ret <2 x i16> %r
}

define <2 x half> @test_bitcast_2xi16_to_2xhalf(<2 x i16> %a) #0 {
; CHECK-LABEL: test_bitcast_2xi16_to_2xhalf(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_bitcast_2xi16_to_2xhalf_param_0];
; CHECK-NEXT:    st.param.b32 [func_retval0], %r1;
; CHECK-NEXT:    ret;
  %r = bitcast <2 x i16> %a to <2 x half>
  ret <2 x half> %r
}

define <2 x half> @test_bitcast_float_to_2xhalf(float %a) #0 {
; CHECK-LABEL: test_bitcast_float_to_2xhalf(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_bitcast_float_to_2xhalf_param_0];
; CHECK-NEXT:    st.param.b32 [func_retval0], %r1;
; CHECK-NEXT:    ret;
  %r = bitcast float %a to <2 x half>
  ret <2 x half> %r
}

define float @test_bitcast_2xhalf_to_float(<2 x half> %a) #0 {
; CHECK-LABEL: test_bitcast_2xhalf_to_float(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_bitcast_2xhalf_to_float_param_0];
; CHECK-NEXT:    st.param.b32 [func_retval0], %r1;
; CHECK-NEXT:    ret;
  %r = bitcast <2 x half> %a to float
  ret float %r
}

declare <2 x half> @llvm.sqrt.f16(<2 x half> %a) #0
declare <2 x half> @llvm.powi.f16.i32(<2 x half> %a, <2 x i32> %b) #0
declare <2 x half> @llvm.sin.f16(<2 x half> %a) #0
declare <2 x half> @llvm.cos.f16(<2 x half> %a) #0
declare <2 x half> @llvm.pow.f16(<2 x half> %a, <2 x half> %b) #0
declare <2 x half> @llvm.exp.f16(<2 x half> %a) #0
declare <2 x half> @llvm.exp2.f16(<2 x half> %a) #0
declare <2 x half> @llvm.log.f16(<2 x half> %a) #0
declare <2 x half> @llvm.log10.f16(<2 x half> %a) #0
declare <2 x half> @llvm.log2.f16(<2 x half> %a) #0
declare <2 x half> @llvm.fma.f16(<2 x half> %a, <2 x half> %b, <2 x half> %c) #0
declare <2 x half> @llvm.fabs.f16(<2 x half> %a) #0
declare <2 x half> @llvm.minnum.f16(<2 x half> %a, <2 x half> %b) #0
declare <2 x half> @llvm.maxnum.f16(<2 x half> %a, <2 x half> %b) #0
declare <2 x half> @llvm.copysign.f16(<2 x half> %a, <2 x half> %b) #0
declare <2 x half> @llvm.floor.f16(<2 x half> %a) #0
declare <2 x half> @llvm.ceil.f16(<2 x half> %a) #0
declare <2 x half> @llvm.trunc.f16(<2 x half> %a) #0
declare <2 x half> @llvm.rint.f16(<2 x half> %a) #0
declare <2 x half> @llvm.nearbyint.f16(<2 x half> %a) #0
declare <2 x half> @llvm.round.f16(<2 x half> %a) #0
declare <2 x half> @llvm.roundeven.f16(<2 x half> %a) #0
declare <2 x half> @llvm.fmuladd.f16(<2 x half> %a, <2 x half> %b, <2 x half> %c) #0

define <2 x half> @test_sqrt(<2 x half> %a) #0 {
; CHECK-LABEL: test_sqrt(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<7>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_sqrt_param_0];
; CHECK-NEXT:    mov.b32 {%rs1, %rs2}, %r1;
; CHECK-NEXT:    cvt.f32.f16 %r2, %rs2;
; CHECK-NEXT:    sqrt.rn.f32 %r3, %r2;
; CHECK-NEXT:    cvt.rn.f16.f32 %rs3, %r3;
; CHECK-NEXT:    cvt.f32.f16 %r4, %rs1;
; CHECK-NEXT:    sqrt.rn.f32 %r5, %r4;
; CHECK-NEXT:    cvt.rn.f16.f32 %rs4, %r5;
; CHECK-NEXT:    mov.b32 %r6, {%rs4, %rs3};
; CHECK-NEXT:    st.param.b32 [func_retval0], %r6;
; CHECK-NEXT:    ret;
  %r = call <2 x half> @llvm.sqrt.f16(<2 x half> %a)
  ret <2 x half> %r
}

;;; Can't do this yet: requires libcall.
; XCHECK-LABEL: test_powi(
;define <2 x half> @test_powi(<2 x half> %a, <2 x i32> %b) #0 {
;  %r = call <2 x half> @llvm.powi.f16.i32(<2 x half> %a, <2 x i32> %b)
;  ret <2 x half> %r
;}

define <2 x half> @test_sin(<2 x half> %a) #0 #1 {
; CHECK-LABEL: test_sin(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<7>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_sin_param_0];
; CHECK-NEXT:    mov.b32 {%rs1, %rs2}, %r1;
; CHECK-NEXT:    cvt.f32.f16 %r2, %rs2;
; CHECK-NEXT:    sin.approx.f32 %r3, %r2;
; CHECK-NEXT:    cvt.rn.f16.f32 %rs3, %r3;
; CHECK-NEXT:    cvt.f32.f16 %r4, %rs1;
; CHECK-NEXT:    sin.approx.f32 %r5, %r4;
; CHECK-NEXT:    cvt.rn.f16.f32 %rs4, %r5;
; CHECK-NEXT:    mov.b32 %r6, {%rs4, %rs3};
; CHECK-NEXT:    st.param.b32 [func_retval0], %r6;
; CHECK-NEXT:    ret;
  %r = call <2 x half> @llvm.sin.f16(<2 x half> %a)
  ret <2 x half> %r
}

define <2 x half> @test_cos(<2 x half> %a) #0 #1 {
; CHECK-LABEL: test_cos(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<7>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_cos_param_0];
; CHECK-NEXT:    mov.b32 {%rs1, %rs2}, %r1;
; CHECK-NEXT:    cvt.f32.f16 %r2, %rs2;
; CHECK-NEXT:    cos.approx.f32 %r3, %r2;
; CHECK-NEXT:    cvt.rn.f16.f32 %rs3, %r3;
; CHECK-NEXT:    cvt.f32.f16 %r4, %rs1;
; CHECK-NEXT:    cos.approx.f32 %r5, %r4;
; CHECK-NEXT:    cvt.rn.f16.f32 %rs4, %r5;
; CHECK-NEXT:    mov.b32 %r6, {%rs4, %rs3};
; CHECK-NEXT:    st.param.b32 [func_retval0], %r6;
; CHECK-NEXT:    ret;
  %r = call <2 x half> @llvm.cos.f16(<2 x half> %a)
  ret <2 x half> %r
}

;;; Can't do this yet: requires libcall.
; XCHECK-LABEL: test_pow(
;define <2 x half> @test_pow(<2 x half> %a, <2 x half> %b) #0 {
;  %r = call <2 x half> @llvm.pow.f16(<2 x half> %a, <2 x half> %b)
;  ret <2 x half> %r
;}

;;; Can't do this yet: requires libcall.
; XCHECK-LABEL: test_exp(
;define <2 x half> @test_exp(<2 x half> %a) #0 {
;  %r = call <2 x half> @llvm.exp.f16(<2 x half> %a)
;  ret <2 x half> %r
;}

;;; Can't do this yet: requires libcall.
; XCHECK-LABEL: test_exp2(
;define <2 x half> @test_exp2(<2 x half> %a) #0 {
;  %r = call <2 x half> @llvm.exp2.f16(<2 x half> %a)
;  ret <2 x half> %r
;}

;;; Can't do this yet: requires libcall.
; XCHECK-LABEL: test_log(
;define <2 x half> @test_log(<2 x half> %a) #0 {
;  %r = call <2 x half> @llvm.log.f16(<2 x half> %a)
;  ret <2 x half> %r
;}

;;; Can't do this yet: requires libcall.
; XCHECK-LABEL: test_log10(
;define <2 x half> @test_log10(<2 x half> %a) #0 {
;  %r = call <2 x half> @llvm.log10.f16(<2 x half> %a)
;  ret <2 x half> %r
;}

;;; Can't do this yet: requires libcall.
; XCHECK-LABEL: test_log2(
;define <2 x half> @test_log2(<2 x half> %a) #0 {
;  %r = call <2 x half> @llvm.log2.f16(<2 x half> %a)
;  ret <2 x half> %r
;}


define <2 x half> @test_fma(<2 x half> %a, <2 x half> %b, <2 x half> %c) #0 {
; CHECK-F16-LABEL: test_fma(
; CHECK-F16:       {
; CHECK-F16-NEXT:    .reg .b32 %r<5>;
; CHECK-F16-EMPTY:
; CHECK-F16-NEXT:  // %bb.0:
; CHECK-F16-NEXT:    ld.param.b32 %r3, [test_fma_param_2];
; CHECK-F16-NEXT:    ld.param.b32 %r2, [test_fma_param_1];
; CHECK-F16-NEXT:    ld.param.b32 %r1, [test_fma_param_0];
; CHECK-F16-NEXT:    fma.rn.f16x2 %r4, %r1, %r2, %r3;
; CHECK-F16-NEXT:    st.param.b32 [func_retval0], %r4;
; CHECK-F16-NEXT:    ret;
;
; CHECK-NOF16-LABEL: test_fma(
; CHECK-NOF16:       {
; CHECK-NOF16-NEXT:    .reg .b16 %rs<9>;
; CHECK-NOF16-NEXT:    .reg .b32 %r<13>;
; CHECK-NOF16-EMPTY:
; CHECK-NOF16-NEXT:  // %bb.0:
; CHECK-NOF16-NEXT:    ld.param.b32 %r3, [test_fma_param_2];
; CHECK-NOF16-NEXT:    ld.param.b32 %r2, [test_fma_param_1];
; CHECK-NOF16-NEXT:    ld.param.b32 %r1, [test_fma_param_0];
; CHECK-NOF16-NEXT:    mov.b32 {%rs1, %rs2}, %r3;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r4, %rs2;
; CHECK-NOF16-NEXT:    mov.b32 {%rs3, %rs4}, %r2;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r5, %rs4;
; CHECK-NOF16-NEXT:    mov.b32 {%rs5, %rs6}, %r1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r6, %rs6;
; CHECK-NOF16-NEXT:    fma.rn.f32 %r7, %r6, %r5, %r4;
; CHECK-NOF16-NEXT:    cvt.rn.f16.f32 %rs7, %r7;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r8, %rs1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r9, %rs3;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r10, %rs5;
; CHECK-NOF16-NEXT:    fma.rn.f32 %r11, %r10, %r9, %r8;
; CHECK-NOF16-NEXT:    cvt.rn.f16.f32 %rs8, %r11;
; CHECK-NOF16-NEXT:    mov.b32 %r12, {%rs8, %rs7};
; CHECK-NOF16-NEXT:    st.param.b32 [func_retval0], %r12;
; CHECK-NOF16-NEXT:    ret;
  %r = call <2 x half> @llvm.fma.f16(<2 x half> %a, <2 x half> %b, <2 x half> %c)
  ret <2 x half> %r
}

define <2 x half> @test_fabs(<2 x half> %a) #0 {
; CHECK-F16-LABEL: test_fabs(
; CHECK-F16:       {
; CHECK-F16-NEXT:    .reg .b32 %r<3>;
; CHECK-F16-EMPTY:
; CHECK-F16-NEXT:  // %bb.0:
; CHECK-F16-NEXT:    ld.param.b32 %r1, [test_fabs_param_0];
; CHECK-F16-NEXT:    and.b32 %r2, %r1, 2147450879;
; CHECK-F16-NEXT:    st.param.b32 [func_retval0], %r2;
; CHECK-F16-NEXT:    ret;
;
; CHECK-NOF16-LABEL: test_fabs(
; CHECK-NOF16:       {
; CHECK-NOF16-NEXT:    .reg .b16 %rs<5>;
; CHECK-NOF16-NEXT:    .reg .b32 %r<7>;
; CHECK-NOF16-EMPTY:
; CHECK-NOF16-NEXT:  // %bb.0:
; CHECK-NOF16-NEXT:    ld.param.b32 %r1, [test_fabs_param_0];
; CHECK-NOF16-NEXT:    mov.b32 {%rs1, %rs2}, %r1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r2, %rs2;
; CHECK-NOF16-NEXT:    abs.f32 %r3, %r2;
; CHECK-NOF16-NEXT:    cvt.rn.f16.f32 %rs3, %r3;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r4, %rs1;
; CHECK-NOF16-NEXT:    abs.f32 %r5, %r4;
; CHECK-NOF16-NEXT:    cvt.rn.f16.f32 %rs4, %r5;
; CHECK-NOF16-NEXT:    mov.b32 %r6, {%rs4, %rs3};
; CHECK-NOF16-NEXT:    st.param.b32 [func_retval0], %r6;
; CHECK-NOF16-NEXT:    ret;
  %r = call <2 x half> @llvm.fabs.f16(<2 x half> %a)
  ret <2 x half> %r
}

define <2 x half> @test_minnum(<2 x half> %a, <2 x half> %b) #0 {
; CHECK-LABEL: test_minnum(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<7>;
; CHECK-NEXT:    .reg .b32 %r<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r2, [test_minnum_param_1];
; CHECK-NEXT:    ld.param.b32 %r1, [test_minnum_param_0];
; CHECK-NEXT:    mov.b32 {%rs1, %rs2}, %r2;
; CHECK-NEXT:    cvt.f32.f16 %r3, %rs2;
; CHECK-NEXT:    mov.b32 {%rs3, %rs4}, %r1;
; CHECK-NEXT:    cvt.f32.f16 %r4, %rs4;
; CHECK-NEXT:    min.f32 %r5, %r4, %r3;
; CHECK-NEXT:    cvt.rn.f16.f32 %rs5, %r5;
; CHECK-NEXT:    cvt.f32.f16 %r6, %rs1;
; CHECK-NEXT:    cvt.f32.f16 %r7, %rs3;
; CHECK-NEXT:    min.f32 %r8, %r7, %r6;
; CHECK-NEXT:    cvt.rn.f16.f32 %rs6, %r8;
; CHECK-NEXT:    mov.b32 %r9, {%rs6, %rs5};
; CHECK-NEXT:    st.param.b32 [func_retval0], %r9;
; CHECK-NEXT:    ret;
  %r = call <2 x half> @llvm.minnum.f16(<2 x half> %a, <2 x half> %b)
  ret <2 x half> %r
}

define <2 x half> @test_maxnum(<2 x half> %a, <2 x half> %b) #0 {
; CHECK-LABEL: test_maxnum(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<7>;
; CHECK-NEXT:    .reg .b32 %r<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r2, [test_maxnum_param_1];
; CHECK-NEXT:    ld.param.b32 %r1, [test_maxnum_param_0];
; CHECK-NEXT:    mov.b32 {%rs1, %rs2}, %r2;
; CHECK-NEXT:    cvt.f32.f16 %r3, %rs2;
; CHECK-NEXT:    mov.b32 {%rs3, %rs4}, %r1;
; CHECK-NEXT:    cvt.f32.f16 %r4, %rs4;
; CHECK-NEXT:    max.f32 %r5, %r4, %r3;
; CHECK-NEXT:    cvt.rn.f16.f32 %rs5, %r5;
; CHECK-NEXT:    cvt.f32.f16 %r6, %rs1;
; CHECK-NEXT:    cvt.f32.f16 %r7, %rs3;
; CHECK-NEXT:    max.f32 %r8, %r7, %r6;
; CHECK-NEXT:    cvt.rn.f16.f32 %rs6, %r8;
; CHECK-NEXT:    mov.b32 %r9, {%rs6, %rs5};
; CHECK-NEXT:    st.param.b32 [func_retval0], %r9;
; CHECK-NEXT:    ret;
  %r = call <2 x half> @llvm.maxnum.f16(<2 x half> %a, <2 x half> %b)
  ret <2 x half> %r
}

define <2 x half> @test_copysign(<2 x half> %a, <2 x half> %b) #0 {
; CHECK-F16-LABEL: test_copysign(
; CHECK-F16:       {
; CHECK-F16-NEXT:    .reg .b32 %r<6>;
; CHECK-F16-EMPTY:
; CHECK-F16-NEXT:  // %bb.0:
; CHECK-F16-NEXT:    ld.param.b32 %r2, [test_copysign_param_1];
; CHECK-F16-NEXT:    ld.param.b32 %r1, [test_copysign_param_0];
; CHECK-F16-NEXT:    and.b32 %r3, %r2, -2147450880;
; CHECK-F16-NEXT:    and.b32 %r4, %r1, 2147450879;
; CHECK-F16-NEXT:    or.b32 %r5, %r4, %r3;
; CHECK-F16-NEXT:    st.param.b32 [func_retval0], %r5;
; CHECK-F16-NEXT:    ret;
;
; CHECK-NOF16-LABEL: test_copysign(
; CHECK-NOF16:       {
; CHECK-NOF16-NEXT:    .reg .b16 %rs<11>;
; CHECK-NOF16-NEXT:    .reg .b32 %r<3>;
; CHECK-NOF16-EMPTY:
; CHECK-NOF16-NEXT:  // %bb.0:
; CHECK-NOF16-NEXT:    ld.param.b32 %r2, [test_copysign_param_1];
; CHECK-NOF16-NEXT:    ld.param.b32 %r1, [test_copysign_param_0];
; CHECK-NOF16-NEXT:    mov.b32 {%rs1, %rs2}, %r2;
; CHECK-NOF16-NEXT:    and.b16 %rs3, %rs2, -32768;
; CHECK-NOF16-NEXT:    mov.b32 {%rs4, %rs5}, %r1;
; CHECK-NOF16-NEXT:    and.b16 %rs6, %rs5, 32767;
; CHECK-NOF16-NEXT:    or.b16 %rs7, %rs6, %rs3;
; CHECK-NOF16-NEXT:    and.b16 %rs8, %rs1, -32768;
; CHECK-NOF16-NEXT:    and.b16 %rs9, %rs4, 32767;
; CHECK-NOF16-NEXT:    or.b16 %rs10, %rs9, %rs8;
; CHECK-NOF16-NEXT:    st.param.v2.b16 [func_retval0], {%rs10, %rs7};
; CHECK-NOF16-NEXT:    ret;
  %r = call <2 x half> @llvm.copysign.f16(<2 x half> %a, <2 x half> %b)
  ret <2 x half> %r
}

define <2 x half> @test_copysign_f32(<2 x half> %a, <2 x float> %b) #0 {
; CHECK-F16-LABEL: test_copysign_f32(
; CHECK-F16:       {
; CHECK-F16-NEXT:    .reg .b16 %rs<3>;
; CHECK-F16-NEXT:    .reg .b32 %r<8>;
; CHECK-F16-NEXT:    .reg .b64 %rd<2>;
; CHECK-F16-EMPTY:
; CHECK-F16-NEXT:  // %bb.0:
; CHECK-F16-NEXT:    ld.param.b64 %rd1, [test_copysign_f32_param_1];
; CHECK-F16-NEXT:    ld.param.b32 %r1, [test_copysign_f32_param_0];
; CHECK-F16-NEXT:    mov.b64 {%r2, %r3}, %rd1;
; CHECK-F16-NEXT:    cvt.rn.f16.f32 %rs1, %r3;
; CHECK-F16-NEXT:    cvt.rn.f16.f32 %rs2, %r2;
; CHECK-F16-NEXT:    mov.b32 %r4, {%rs2, %rs1};
; CHECK-F16-NEXT:    and.b32 %r5, %r4, -2147450880;
; CHECK-F16-NEXT:    and.b32 %r6, %r1, 2147450879;
; CHECK-F16-NEXT:    or.b32 %r7, %r6, %r5;
; CHECK-F16-NEXT:    st.param.b32 [func_retval0], %r7;
; CHECK-F16-NEXT:    ret;
;
; CHECK-NOF16-LABEL: test_copysign_f32(
; CHECK-NOF16:       {
; CHECK-NOF16-NEXT:    .reg .b16 %rs<9>;
; CHECK-NOF16-NEXT:    .reg .b32 %r<6>;
; CHECK-NOF16-NEXT:    .reg .b64 %rd<2>;
; CHECK-NOF16-EMPTY:
; CHECK-NOF16-NEXT:  // %bb.0:
; CHECK-NOF16-NEXT:    ld.param.b64 %rd1, [test_copysign_f32_param_1];
; CHECK-NOF16-NEXT:    ld.param.b32 %r1, [test_copysign_f32_param_0];
; CHECK-NOF16-NEXT:    mov.b64 {%r2, %r3}, %rd1;
; CHECK-NOF16-NEXT:    mov.b32 {%rs1, %rs2}, %r1;
; CHECK-NOF16-NEXT:    and.b16 %rs3, %rs2, 32767;
; CHECK-NOF16-NEXT:    and.b32 %r4, %r3, -2147483648;
; CHECK-NOF16-NEXT:    { .reg .b16 tmp; mov.b32 {tmp, %rs4}, %r4; }
; CHECK-NOF16-NEXT:    or.b16 %rs5, %rs3, %rs4;
; CHECK-NOF16-NEXT:    and.b16 %rs6, %rs1, 32767;
; CHECK-NOF16-NEXT:    and.b32 %r5, %r2, -2147483648;
; CHECK-NOF16-NEXT:    { .reg .b16 tmp; mov.b32 {tmp, %rs7}, %r5; }
; CHECK-NOF16-NEXT:    or.b16 %rs8, %rs6, %rs7;
; CHECK-NOF16-NEXT:    st.param.v2.b16 [func_retval0], {%rs8, %rs5};
; CHECK-NOF16-NEXT:    ret;
  %tb = fptrunc <2 x float> %b to <2 x half>
  %r = call <2 x half> @llvm.copysign.f16(<2 x half> %a, <2 x half> %tb)
  ret <2 x half> %r
}

define <2 x half> @test_copysign_f64(<2 x half> %a, <2 x double> %b) #0 {
; CHECK-F16-LABEL: test_copysign_f64(
; CHECK-F16:       {
; CHECK-F16-NEXT:    .reg .b16 %rs<3>;
; CHECK-F16-NEXT:    .reg .b32 %r<6>;
; CHECK-F16-NEXT:    .reg .b64 %rd<3>;
; CHECK-F16-EMPTY:
; CHECK-F16-NEXT:  // %bb.0:
; CHECK-F16-NEXT:    ld.param.v2.b64 {%rd1, %rd2}, [test_copysign_f64_param_1];
; CHECK-F16-NEXT:    ld.param.b32 %r1, [test_copysign_f64_param_0];
; CHECK-F16-NEXT:    cvt.rn.f16.f64 %rs1, %rd2;
; CHECK-F16-NEXT:    cvt.rn.f16.f64 %rs2, %rd1;
; CHECK-F16-NEXT:    mov.b32 %r2, {%rs2, %rs1};
; CHECK-F16-NEXT:    and.b32 %r3, %r2, -2147450880;
; CHECK-F16-NEXT:    and.b32 %r4, %r1, 2147450879;
; CHECK-F16-NEXT:    or.b32 %r5, %r4, %r3;
; CHECK-F16-NEXT:    st.param.b32 [func_retval0], %r5;
; CHECK-F16-NEXT:    ret;
;
; CHECK-NOF16-LABEL: test_copysign_f64(
; CHECK-NOF16:       {
; CHECK-NOF16-NEXT:    .reg .b16 %rs<9>;
; CHECK-NOF16-NEXT:    .reg .b32 %r<2>;
; CHECK-NOF16-NEXT:    .reg .b64 %rd<7>;
; CHECK-NOF16-EMPTY:
; CHECK-NOF16-NEXT:  // %bb.0:
; CHECK-NOF16-NEXT:    ld.param.v2.b64 {%rd1, %rd2}, [test_copysign_f64_param_1];
; CHECK-NOF16-NEXT:    ld.param.b32 %r1, [test_copysign_f64_param_0];
; CHECK-NOF16-NEXT:    mov.b32 {%rs1, %rs2}, %r1;
; CHECK-NOF16-NEXT:    and.b16 %rs3, %rs2, 32767;
; CHECK-NOF16-NEXT:    and.b64 %rd3, %rd2, -9223372036854775808;
; CHECK-NOF16-NEXT:    shr.u64 %rd4, %rd3, 48;
; CHECK-NOF16-NEXT:    cvt.u16.u64 %rs4, %rd4;
; CHECK-NOF16-NEXT:    or.b16 %rs5, %rs3, %rs4;
; CHECK-NOF16-NEXT:    and.b16 %rs6, %rs1, 32767;
; CHECK-NOF16-NEXT:    and.b64 %rd5, %rd1, -9223372036854775808;
; CHECK-NOF16-NEXT:    shr.u64 %rd6, %rd5, 48;
; CHECK-NOF16-NEXT:    cvt.u16.u64 %rs7, %rd6;
; CHECK-NOF16-NEXT:    or.b16 %rs8, %rs6, %rs7;
; CHECK-NOF16-NEXT:    st.param.v2.b16 [func_retval0], {%rs8, %rs5};
; CHECK-NOF16-NEXT:    ret;
  %tb = fptrunc <2 x double> %b to <2 x half>
  %r = call <2 x half> @llvm.copysign.f16(<2 x half> %a, <2 x half> %tb)
  ret <2 x half> %r
}

define <2 x float> @test_copysign_extended(<2 x half> %a, <2 x half> %b) #0 {
; CHECK-F16-LABEL: test_copysign_extended(
; CHECK-F16:       {
; CHECK-F16-NEXT:    .reg .b16 %rs<3>;
; CHECK-F16-NEXT:    .reg .b32 %r<8>;
; CHECK-F16-EMPTY:
; CHECK-F16-NEXT:  // %bb.0:
; CHECK-F16-NEXT:    ld.param.b32 %r2, [test_copysign_extended_param_1];
; CHECK-F16-NEXT:    ld.param.b32 %r1, [test_copysign_extended_param_0];
; CHECK-F16-NEXT:    and.b32 %r3, %r2, -2147450880;
; CHECK-F16-NEXT:    and.b32 %r4, %r1, 2147450879;
; CHECK-F16-NEXT:    or.b32 %r5, %r4, %r3;
; CHECK-F16-NEXT:    mov.b32 {%rs1, %rs2}, %r5;
; CHECK-F16-NEXT:    cvt.f32.f16 %r6, %rs2;
; CHECK-F16-NEXT:    cvt.f32.f16 %r7, %rs1;
; CHECK-F16-NEXT:    st.param.v2.b32 [func_retval0], {%r7, %r6};
; CHECK-F16-NEXT:    ret;
;
; CHECK-NOF16-LABEL: test_copysign_extended(
; CHECK-NOF16:       {
; CHECK-NOF16-NEXT:    .reg .b16 %rs<11>;
; CHECK-NOF16-NEXT:    .reg .b32 %r<5>;
; CHECK-NOF16-EMPTY:
; CHECK-NOF16-NEXT:  // %bb.0:
; CHECK-NOF16-NEXT:    ld.param.b32 %r2, [test_copysign_extended_param_1];
; CHECK-NOF16-NEXT:    ld.param.b32 %r1, [test_copysign_extended_param_0];
; CHECK-NOF16-NEXT:    mov.b32 {%rs1, %rs2}, %r2;
; CHECK-NOF16-NEXT:    and.b16 %rs3, %rs1, -32768;
; CHECK-NOF16-NEXT:    mov.b32 {%rs4, %rs5}, %r1;
; CHECK-NOF16-NEXT:    and.b16 %rs6, %rs4, 32767;
; CHECK-NOF16-NEXT:    or.b16 %rs7, %rs6, %rs3;
; CHECK-NOF16-NEXT:    and.b16 %rs8, %rs2, -32768;
; CHECK-NOF16-NEXT:    and.b16 %rs9, %rs5, 32767;
; CHECK-NOF16-NEXT:    or.b16 %rs10, %rs9, %rs8;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r3, %rs10;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r4, %rs7;
; CHECK-NOF16-NEXT:    st.param.v2.b32 [func_retval0], {%r4, %r3};
; CHECK-NOF16-NEXT:    ret;
  %r = call <2 x half> @llvm.copysign.f16(<2 x half> %a, <2 x half> %b)
  %xr = fpext <2 x half> %r to <2 x float>
  ret <2 x float> %xr
}

define <2 x half> @test_floor(<2 x half> %a) #0 {
; CHECK-LABEL: test_floor(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_floor_param_0];
; CHECK-NEXT:    mov.b32 {%rs1, %rs2}, %r1;
; CHECK-NEXT:    cvt.rmi.f16.f16 %rs3, %rs2;
; CHECK-NEXT:    cvt.rmi.f16.f16 %rs4, %rs1;
; CHECK-NEXT:    st.param.v2.b16 [func_retval0], {%rs4, %rs3};
; CHECK-NEXT:    ret;
  %r = call <2 x half> @llvm.floor.f16(<2 x half> %a)
  ret <2 x half> %r
}

define <2 x half> @test_ceil(<2 x half> %a) #0 {
; CHECK-LABEL: test_ceil(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_ceil_param_0];
; CHECK-NEXT:    mov.b32 {%rs1, %rs2}, %r1;
; CHECK-NEXT:    cvt.rpi.f16.f16 %rs3, %rs2;
; CHECK-NEXT:    cvt.rpi.f16.f16 %rs4, %rs1;
; CHECK-NEXT:    st.param.v2.b16 [func_retval0], {%rs4, %rs3};
; CHECK-NEXT:    ret;
  %r = call <2 x half> @llvm.ceil.f16(<2 x half> %a)
  ret <2 x half> %r
}

define <2 x half> @test_trunc(<2 x half> %a) #0 {
; CHECK-LABEL: test_trunc(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_trunc_param_0];
; CHECK-NEXT:    mov.b32 {%rs1, %rs2}, %r1;
; CHECK-NEXT:    cvt.rzi.f16.f16 %rs3, %rs2;
; CHECK-NEXT:    cvt.rzi.f16.f16 %rs4, %rs1;
; CHECK-NEXT:    st.param.v2.b16 [func_retval0], {%rs4, %rs3};
; CHECK-NEXT:    ret;
  %r = call <2 x half> @llvm.trunc.f16(<2 x half> %a)
  ret <2 x half> %r
}

define <2 x half> @test_rint(<2 x half> %a) #0 {
; CHECK-LABEL: test_rint(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_rint_param_0];
; CHECK-NEXT:    mov.b32 {%rs1, %rs2}, %r1;
; CHECK-NEXT:    cvt.rni.f16.f16 %rs3, %rs2;
; CHECK-NEXT:    cvt.rni.f16.f16 %rs4, %rs1;
; CHECK-NEXT:    st.param.v2.b16 [func_retval0], {%rs4, %rs3};
; CHECK-NEXT:    ret;
  %r = call <2 x half> @llvm.rint.f16(<2 x half> %a)
  ret <2 x half> %r
}

define <2 x half> @test_nearbyint(<2 x half> %a) #0 {
; CHECK-LABEL: test_nearbyint(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_nearbyint_param_0];
; CHECK-NEXT:    mov.b32 {%rs1, %rs2}, %r1;
; CHECK-NEXT:    cvt.rni.f16.f16 %rs3, %rs2;
; CHECK-NEXT:    cvt.rni.f16.f16 %rs4, %rs1;
; CHECK-NEXT:    st.param.v2.b16 [func_retval0], {%rs4, %rs3};
; CHECK-NEXT:    ret;
  %r = call <2 x half> @llvm.nearbyint.f16(<2 x half> %a)
  ret <2 x half> %r
}

define <2 x half> @test_roundeven(<2 x half> %a) #0 {
; CHECK-LABEL: test_roundeven(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_roundeven_param_0];
; CHECK-NEXT:    mov.b32 {%rs1, %rs2}, %r1;
; CHECK-NEXT:    cvt.rni.f16.f16 %rs3, %rs2;
; CHECK-NEXT:    cvt.rni.f16.f16 %rs4, %rs1;
; CHECK-NEXT:    st.param.v2.b16 [func_retval0], {%rs4, %rs3};
; CHECK-NEXT:    ret;
  %r = call <2 x half> @llvm.roundeven.f16(<2 x half> %a)
  ret <2 x half> %r
}

; check the use of sign mask and 0.5 to implement round
define <2 x half> @test_round(<2 x half> %a) #0 {
; CHECK-LABEL: test_round(
; CHECK:       {
; CHECK-NEXT:    .reg .pred %p<5>;
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<21>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_round_param_0];
; CHECK-NEXT:    mov.b32 {%rs1, %rs2}, %r1;
; CHECK-NEXT:    cvt.f32.f16 %r2, %rs2;
; CHECK-NEXT:    and.b32 %r3, %r2, -2147483648;
; CHECK-NEXT:    or.b32 %r4, %r3, 1056964608;
; CHECK-NEXT:    add.rn.f32 %r5, %r2, %r4;
; CHECK-NEXT:    cvt.rzi.f32.f32 %r6, %r5;
; CHECK-NEXT:    abs.f32 %r7, %r2;
; CHECK-NEXT:    setp.gt.f32 %p1, %r7, 0f4B000000;
; CHECK-NEXT:    selp.f32 %r8, %r2, %r6, %p1;
; CHECK-NEXT:    cvt.rzi.f32.f32 %r9, %r2;
; CHECK-NEXT:    setp.lt.f32 %p2, %r7, 0f3F000000;
; CHECK-NEXT:    selp.f32 %r10, %r9, %r8, %p2;
; CHECK-NEXT:    cvt.rn.f16.f32 %rs3, %r10;
; CHECK-NEXT:    cvt.f32.f16 %r11, %rs1;
; CHECK-NEXT:    and.b32 %r12, %r11, -2147483648;
; CHECK-NEXT:    or.b32 %r13, %r12, 1056964608;
; CHECK-NEXT:    add.rn.f32 %r14, %r11, %r13;
; CHECK-NEXT:    cvt.rzi.f32.f32 %r15, %r14;
; CHECK-NEXT:    abs.f32 %r16, %r11;
; CHECK-NEXT:    setp.gt.f32 %p3, %r16, 0f4B000000;
; CHECK-NEXT:    selp.f32 %r17, %r11, %r15, %p3;
; CHECK-NEXT:    cvt.rzi.f32.f32 %r18, %r11;
; CHECK-NEXT:    setp.lt.f32 %p4, %r16, 0f3F000000;
; CHECK-NEXT:    selp.f32 %r19, %r18, %r17, %p4;
; CHECK-NEXT:    cvt.rn.f16.f32 %rs4, %r19;
; CHECK-NEXT:    mov.b32 %r20, {%rs4, %rs3};
; CHECK-NEXT:    st.param.b32 [func_retval0], %r20;
; CHECK-NEXT:    ret;
  %r = call <2 x half> @llvm.round.f16(<2 x half> %a)
  ret <2 x half> %r
}

define <2 x half> @test_fmuladd(<2 x half> %a, <2 x half> %b, <2 x half> %c) #0 {
; CHECK-F16-LABEL: test_fmuladd(
; CHECK-F16:       {
; CHECK-F16-NEXT:    .reg .b32 %r<5>;
; CHECK-F16-EMPTY:
; CHECK-F16-NEXT:  // %bb.0:
; CHECK-F16-NEXT:    ld.param.b32 %r3, [test_fmuladd_param_2];
; CHECK-F16-NEXT:    ld.param.b32 %r2, [test_fmuladd_param_1];
; CHECK-F16-NEXT:    ld.param.b32 %r1, [test_fmuladd_param_0];
; CHECK-F16-NEXT:    fma.rn.f16x2 %r4, %r1, %r2, %r3;
; CHECK-F16-NEXT:    st.param.b32 [func_retval0], %r4;
; CHECK-F16-NEXT:    ret;
;
; CHECK-NOF16-LABEL: test_fmuladd(
; CHECK-NOF16:       {
; CHECK-NOF16-NEXT:    .reg .b16 %rs<9>;
; CHECK-NOF16-NEXT:    .reg .b32 %r<13>;
; CHECK-NOF16-EMPTY:
; CHECK-NOF16-NEXT:  // %bb.0:
; CHECK-NOF16-NEXT:    ld.param.b32 %r3, [test_fmuladd_param_2];
; CHECK-NOF16-NEXT:    ld.param.b32 %r2, [test_fmuladd_param_1];
; CHECK-NOF16-NEXT:    ld.param.b32 %r1, [test_fmuladd_param_0];
; CHECK-NOF16-NEXT:    mov.b32 {%rs1, %rs2}, %r3;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r4, %rs2;
; CHECK-NOF16-NEXT:    mov.b32 {%rs3, %rs4}, %r2;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r5, %rs4;
; CHECK-NOF16-NEXT:    mov.b32 {%rs5, %rs6}, %r1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r6, %rs6;
; CHECK-NOF16-NEXT:    fma.rn.f32 %r7, %r6, %r5, %r4;
; CHECK-NOF16-NEXT:    cvt.rn.f16.f32 %rs7, %r7;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r8, %rs1;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r9, %rs3;
; CHECK-NOF16-NEXT:    cvt.f32.f16 %r10, %rs5;
; CHECK-NOF16-NEXT:    fma.rn.f32 %r11, %r10, %r9, %r8;
; CHECK-NOF16-NEXT:    cvt.rn.f16.f32 %rs8, %r11;
; CHECK-NOF16-NEXT:    mov.b32 %r12, {%rs8, %rs7};
; CHECK-NOF16-NEXT:    st.param.b32 [func_retval0], %r12;
; CHECK-NOF16-NEXT:    ret;
  %r = call <2 x half> @llvm.fmuladd.f16(<2 x half> %a, <2 x half> %b, <2 x half> %c)
  ret <2 x half> %r
}

define <2 x half> @test_shufflevector(<2 x half> %a) #0 {
; CHECK-LABEL: test_shufflevector(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<3>;
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_shufflevector_param_0];
; CHECK-NEXT:    mov.b32 {%rs1, %rs2}, %r1;
; CHECK-NEXT:    st.param.v2.b16 [func_retval0], {%rs2, %rs1};
; CHECK-NEXT:    ret;
  %s = shufflevector <2 x half> %a, <2 x half> undef, <2 x i32> <i32 1, i32 0>
  ret <2 x half> %s
}

define <2 x half> @test_insertelement(<2 x half> %a, half %x) #0 {
; CHECK-LABEL: test_insertelement(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<3>;
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b16 %rs1, [test_insertelement_param_1];
; CHECK-NEXT:    ld.param.b32 %r1, [test_insertelement_param_0];
; CHECK-NEXT:    { .reg .b16 tmp; mov.b32 {%rs2, tmp}, %r1; }
; CHECK-NEXT:    st.param.v2.b16 [func_retval0], {%rs2, %rs1};
; CHECK-NEXT:    ret;
  %i = insertelement <2 x half> %a, half %x, i64 1
  ret <2 x half> %i
}

define <2 x half> @test_sitofp_2xi16_to_2xhalf(<2 x i16> %a) #0 {
; CHECK-LABEL: test_sitofp_2xi16_to_2xhalf(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_sitofp_2xi16_to_2xhalf_param_0];
; CHECK-NEXT:    mov.b32 {%rs1, %rs2}, %r1;
; CHECK-NEXT:    cvt.rn.f16.s16 %rs3, %rs2;
; CHECK-NEXT:    cvt.rn.f16.s16 %rs4, %rs1;
; CHECK-NEXT:    st.param.v2.b16 [func_retval0], {%rs4, %rs3};
; CHECK-NEXT:    ret;
  %r = sitofp <2 x i16> %a to <2 x half>
  ret <2 x half> %r
}

define <2 x half> @test_uitofp_2xi16_to_2xhalf(<2 x i16> %a) #0 {
; CHECK-LABEL: test_uitofp_2xi16_to_2xhalf(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_uitofp_2xi16_to_2xhalf_param_0];
; CHECK-NEXT:    mov.b32 {%rs1, %rs2}, %r1;
; CHECK-NEXT:    cvt.rn.f16.u16 %rs3, %rs2;
; CHECK-NEXT:    cvt.rn.f16.u16 %rs4, %rs1;
; CHECK-NEXT:    st.param.v2.b16 [func_retval0], {%rs4, %rs3};
; CHECK-NEXT:    ret;
  %r = uitofp <2 x i16> %a to <2 x half>
  ret <2 x half> %r
}

define void @test_store_2xhalf(ptr %p1, ptr %p2, <2 x half> %v) {
; CHECK-LABEL: test_store_2xhalf(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<2>;
; CHECK-NEXT:    .reg .b64 %rd<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_store_2xhalf_param_2];
; CHECK-NEXT:    ld.param.b64 %rd2, [test_store_2xhalf_param_1];
; CHECK-NEXT:    ld.param.b64 %rd1, [test_store_2xhalf_param_0];
; CHECK-NEXT:    st.b32 [%rd1], %r1;
; CHECK-NEXT:    st.b32 [%rd2], 1006648320;
; CHECK-NEXT:    ret;
  store <2 x half> %v, ptr %p1
  store <2 x half> <half 1.0, half 1.0>, ptr %p2
  ret void
}



attributes #0 = { nounwind }
attributes #1 = { "unsafe-fp-math" = "true" }
