; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

; icmp u/s (a ^ signmask), (b ^ signmask) --> icmp s/u a, b

define i1 @slt_to_ult(i8 %x, i8 %y) {
; CHECK-LABEL: @slt_to_ult(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %a = xor i8 %x, 128
  %b = xor i8 %y, 128
  %cmp = icmp slt i8 %a, %b
  ret i1 %cmp
}

; PR33138 - https://bugs.llvm.org/show_bug.cgi?id=33138

define <2 x i1> @slt_to_ult_splat(<2 x i8> %x, <2 x i8> %y) {
; CHECK-LABEL: @slt_to_ult_splat(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult <2 x i8> [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %a = xor <2 x i8> %x, <i8 128, i8 128>
  %b = xor <2 x i8> %y, <i8 128, i8 128>
  %cmp = icmp slt <2 x i8> %a, %b
  ret <2 x i1> %cmp
}

; Make sure that unsigned -> signed works too.

define i1 @ult_to_slt(i8 %x, i8 %y) {
; CHECK-LABEL: @ult_to_slt(
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %a = xor i8 %x, 128
  %b = xor i8 %y, 128
  %cmp = icmp ult i8 %a, %b
  ret i1 %cmp
}

define <2 x i1> @ult_to_slt_splat(<2 x i8> %x, <2 x i8> %y) {
; CHECK-LABEL: @ult_to_slt_splat(
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt <2 x i8> [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %a = xor <2 x i8> %x, <i8 128, i8 128>
  %b = xor <2 x i8> %y, <i8 128, i8 128>
  %cmp = icmp ult <2 x i8> %a, %b
  ret <2 x i1> %cmp
}

; icmp u/s (a ^ maxsignval), (b ^ maxsignval) --> icmp s/u' a, b

define i1 @slt_to_ugt(i8 %x, i8 %y) {
; CHECK-LABEL: @slt_to_ugt(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %a = xor i8 %x, 127
  %b = xor i8 %y, 127
  %cmp = icmp slt i8 %a, %b
  ret i1 %cmp
}

define <2 x i1> @slt_to_ugt_splat(<2 x i8> %x, <2 x i8> %y) {
; CHECK-LABEL: @slt_to_ugt_splat(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt <2 x i8> [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %a = xor <2 x i8> %x, <i8 127, i8 127>
  %b = xor <2 x i8> %y, <i8 127, i8 127>
  %cmp = icmp slt <2 x i8> %a, %b
  ret <2 x i1> %cmp
}

; Make sure that unsigned -> signed works too.

define i1 @ult_to_sgt(i8 %x, i8 %y) {
; CHECK-LABEL: @ult_to_sgt(
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %a = xor i8 %x, 127
  %b = xor i8 %y, 127
  %cmp = icmp ult i8 %a, %b
  ret i1 %cmp
}

define <2 x i1> @ult_to_sgt_splat(<2 x i8> %x, <2 x i8> %y) {
; CHECK-LABEL: @ult_to_sgt_splat(
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt <2 x i8> [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %a = xor <2 x i8> %x, <i8 127, i8 127>
  %b = xor <2 x i8> %y, <i8 127, i8 127>
  %cmp = icmp ult <2 x i8> %a, %b
  ret <2 x i1> %cmp
}

; icmp u/s (a ^ signmask), C --> icmp s/u a, C'

define i1 @sge_to_ugt(i8 %x) {
; CHECK-LABEL: @sge_to_ugt(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i8 [[X:%.*]], -114
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %a = xor i8 %x, 128
  %cmp = icmp sge i8 %a, 15
  ret i1 %cmp
}

define <2 x i1> @sge_to_ugt_splat(<2 x i8> %x) {
; CHECK-LABEL: @sge_to_ugt_splat(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt <2 x i8> [[X:%.*]], splat (i8 -114)
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %a = xor <2 x i8> %x, <i8 128, i8 128>
  %cmp = icmp sge <2 x i8> %a, <i8 15, i8 15>
  ret <2 x i1> %cmp
}

; Make sure that unsigned -> signed works too.

define i1 @uge_to_sgt(i8 %x) {
; CHECK-LABEL: @uge_to_sgt(
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i8 [[X:%.*]], -114
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %a = xor i8 %x, 128
  %cmp = icmp uge i8 %a, 15
  ret i1 %cmp
}

define <2 x i1> @uge_to_sgt_splat(<2 x i8> %x) {
; CHECK-LABEL: @uge_to_sgt_splat(
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt <2 x i8> [[X:%.*]], splat (i8 -114)
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %a = xor <2 x i8> %x, <i8 128, i8 128>
  %cmp = icmp uge <2 x i8> %a, <i8 15, i8 15>
  ret <2 x i1> %cmp
}

; icmp u/s (a ^ maxsignval), C --> icmp s/u' a, C'

define i1 @sge_to_ult(i8 %x) {
; CHECK-LABEL: @sge_to_ult(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i8 [[X:%.*]], 113
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %a = xor i8 %x, 127
  %cmp = icmp sge i8 %a, 15
  ret i1 %cmp
}

define <2 x i1> @sge_to_ult_splat(<2 x i8> %x) {
; CHECK-LABEL: @sge_to_ult_splat(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult <2 x i8> [[X:%.*]], splat (i8 113)
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %a = xor <2 x i8> %x, <i8 127, i8 127>
  %cmp = icmp sge <2 x i8> %a, <i8 15, i8 15>
  ret <2 x i1> %cmp
}

; Make sure that unsigned -> signed works too.

define i1 @uge_to_slt(i8 %x) {
; CHECK-LABEL: @uge_to_slt(
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i8 [[X:%.*]], 113
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %a = xor i8 %x, 127
  %cmp = icmp uge i8 %a, 15
  ret i1 %cmp
}

define <2 x i1> @uge_to_slt_splat(<2 x i8> %x) {
; CHECK-LABEL: @uge_to_slt_splat(
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt <2 x i8> [[X:%.*]], splat (i8 113)
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %a = xor <2 x i8> %x, <i8 127, i8 127>
  %cmp = icmp uge <2 x i8> %a, <i8 15, i8 15>
  ret <2 x i1> %cmp
}

; PR33138, part 2: https://bugs.llvm.org/show_bug.cgi?id=33138
; Bitcast canonicalization ensures that we recognize the signbit constant.

define <8 x i1> @sgt_to_ugt_bitcasted_splat(<2 x i32> %x, <2 x i32> %y) {
; CHECK-LABEL: @sgt_to_ugt_bitcasted_splat(
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast <2 x i32> [[X:%.*]] to <8 x i8>
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast <2 x i32> [[Y:%.*]] to <8 x i8>
; CHECK-NEXT:    [[E:%.*]] = icmp ugt <8 x i8> [[TMP1]], [[TMP2]]
; CHECK-NEXT:    ret <8 x i1> [[E]]
;
  %a = xor <2 x i32> %x, <i32 2155905152, i32 2155905152> ; 0x80808080
  %b = xor <2 x i32> %y, <i32 2155905152, i32 2155905152>
  %c = bitcast <2 x i32> %a to <8 x i8>
  %d = bitcast <2 x i32> %b to <8 x i8>
  %e = icmp sgt <8 x i8> %c, %d
  ret <8 x i1> %e
}

; Bitcast canonicalization ensures that we recognize the signbit constant.

define <2 x i1> @negative_simplify_splat(<4 x i8> %x) {
; CHECK-LABEL: @negative_simplify_splat(
; CHECK-NEXT:    ret <2 x i1> zeroinitializer
;
  %a = or <4 x i8> %x, <i8 0, i8 128, i8 0, i8 128>
  %b = bitcast <4 x i8> %a to <2 x i16>
  %c = icmp sgt <2 x i16> %b, zeroinitializer
  ret <2 x i1> %c
}

define i1 @slt_zero_eq_i1(i32 %a, i1 %b) {
; CHECK-LABEL: @slt_zero_eq_i1(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp sgt i32 [[A:%.*]], -1
; CHECK-NEXT:    [[CMP21:%.*]] = xor i1 [[TMP1]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP21]]
;
  %conv = zext i1 %b to i32
  %cmp1 = lshr i32 %a, 31
  %cmp2 = icmp eq i32 %conv, %cmp1
  ret i1 %cmp2
}

define i1 @slt_zero_eq_i1_fail(i32 %a, i1 %b) {
; CHECK-LABEL: @slt_zero_eq_i1_fail(
; CHECK-NEXT:    [[CONV:%.*]] = zext i1 [[B:%.*]] to i32
; CHECK-NEXT:    [[CMP1:%.*]] = ashr i32 [[A:%.*]], 31
; CHECK-NEXT:    [[CMP2:%.*]] = icmp eq i32 [[CMP1]], [[CONV]]
; CHECK-NEXT:    ret i1 [[CMP2]]
;
  %conv = zext i1 %b to i32
  %cmp1 = ashr i32 %a, 31
  %cmp2 = icmp eq i32 %conv, %cmp1
  ret i1 %cmp2
}

define i1 @slt_zero_eq_ne_0(i32 %a) {
; CHECK-LABEL: @slt_zero_eq_ne_0(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp slt i32 [[A:%.*]], 1
; CHECK-NEXT:    ret i1 [[TMP1]]
;
  %cmp = icmp ne i32 %a, 0
  %conv = zext i1 %cmp to i32
  %cmp1 = lshr i32 %a, 31
  %cmp2 = icmp eq i32 %conv, %cmp1
  ret i1 %cmp2
}

define i1 @slt_zero_ne_ne_0(i32 %a) {
; CHECK-LABEL: @slt_zero_ne_ne_0(
; CHECK-NEXT:    [[CMP21:%.*]] = icmp sgt i32 [[A:%.*]], 0
; CHECK-NEXT:    ret i1 [[CMP21]]
;
  %cmp = icmp ne i32 %a, 0
  %conv = zext i1 %cmp to i32
  %cmp1 = lshr i32 %a, 31
  %cmp2 = icmp ne i32 %conv, %cmp1
  ret i1 %cmp2
}

define <4 x i1> @slt_zero_eq_ne_0_vec(<4 x i32> %a) {
; CHECK-LABEL: @slt_zero_eq_ne_0_vec(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp slt <4 x i32> [[A:%.*]], splat (i32 1)
; CHECK-NEXT:    ret <4 x i1> [[TMP1]]
;
  %cmp = icmp ne <4 x i32> %a, zeroinitializer
  %conv = zext <4 x i1> %cmp to <4 x i32>
  %cmp1 = lshr <4 x i32> %a, <i32 31, i32 31, i32 31, i32 31>
  %cmp2 = icmp eq <4 x i32> %conv, %cmp1
  ret <4 x i1> %cmp2
}

define i1 @slt_zero_ne_ne_b(i32 %a, i32 %b) {
; CHECK-LABEL: @slt_zero_ne_ne_b(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i32 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = icmp slt i32 [[A]], 0
; CHECK-NEXT:    [[CMP21:%.*]] = xor i1 [[TMP1]], [[CMP]]
; CHECK-NEXT:    ret i1 [[CMP21]]
;
  %cmp = icmp ne i32 %a, %b
  %conv = zext i1 %cmp to i32
  %cmp1 = lshr i32 %a, 31
  %cmp2 = icmp ne i32 %conv, %cmp1
  ret i1 %cmp2
}

define i1 @slt_zero_eq_ne_0_fail1(i32 %a) {
; CHECK-LABEL: @slt_zero_eq_ne_0_fail1(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i32 [[A:%.*]], 0
; CHECK-NEXT:    [[CONV:%.*]] = zext i1 [[CMP]] to i32
; CHECK-NEXT:    [[CMP1:%.*]] = ashr i32 [[A]], 31
; CHECK-NEXT:    [[CMP2:%.*]] = icmp eq i32 [[CMP1]], [[CONV]]
; CHECK-NEXT:    ret i1 [[CMP2]]
;
  %cmp = icmp ne i32 %a, 0
  %conv = zext i1 %cmp to i32
  %cmp1 = ashr i32 %a, 31
  %cmp2 = icmp eq i32 %conv, %cmp1
  ret i1 %cmp2
}

define i1 @slt_zero_eq_ne_0_fail2(i32 %a) {
; CHECK-LABEL: @slt_zero_eq_ne_0_fail2(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i32 [[A:%.*]], 0
; CHECK-NEXT:    [[CONV:%.*]] = zext i1 [[CMP]] to i32
; CHECK-NEXT:    [[CMP1:%.*]] = lshr i32 [[A]], 30
; CHECK-NEXT:    [[CMP2:%.*]] = icmp eq i32 [[CMP1]], [[CONV]]
; CHECK-NEXT:    ret i1 [[CMP2]]
;
  %cmp = icmp ne i32 %a, 0
  %conv = zext i1 %cmp to i32
  %cmp1 = lshr i32 %a, 30
  %cmp2 = icmp eq i32 %conv, %cmp1
  ret i1 %cmp2
}
