; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=wasm32 -verify-machineinstrs -disable-wasm-fallthrough-return-opt -wasm-disable-explicit-locals -wasm-keep-registers -mattr=+simd128 | FileCheck %s

define <8 x i32> @sext_mul_v8i8(<8 x i8> %a, <8 x i8> %b) {
; CHECK-LABEL: sext_mul_v8i8:
; CHECK:         .functype sext_mul_v8i8 (i32, v128, v128) -> ()
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i16x8.extmul_low_i8x16_s $push3=, $1, $1
; CHECK-NEXT:    local.tee $push2=, $1=, $pop3
; CHECK-NEXT:    i32x4.extend_high_i16x8_s $push0=, $pop2
; CHECK-NEXT:    v128.store 16($0), $pop0
; CHECK-NEXT:    i32x4.extend_low_i16x8_s $push1=, $1
; CHECK-NEXT:    v128.store 0($0), $pop1
; CHECK-NEXT:    return
  %wide.a = sext <8 x i8> %a to <8 x i32>
  %wide.b = sext <8 x i8> %a to <8 x i32>
  %mul = mul <8 x i32> %wide.a, %wide.b
  ret <8 x i32> %mul
}

define <16 x i32> @sext_mul_v16i8(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: sext_mul_v16i8:
; CHECK:         .functype sext_mul_v16i8 (i32, v128, v128) -> ()
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i16x8.extmul_high_i8x16_s $push7=, $1, $1
; CHECK-NEXT:    local.tee $push6=, $3=, $pop7
; CHECK-NEXT:    i32x4.extend_high_i16x8_s $push0=, $pop6
; CHECK-NEXT:    v128.store 48($0), $pop0
; CHECK-NEXT:    i32x4.extend_low_i16x8_s $push1=, $3
; CHECK-NEXT:    v128.store 32($0), $pop1
; CHECK-NEXT:    i16x8.extmul_low_i8x16_s $push5=, $1, $1
; CHECK-NEXT:    local.tee $push4=, $1=, $pop5
; CHECK-NEXT:    i32x4.extend_high_i16x8_s $push2=, $pop4
; CHECK-NEXT:    v128.store 16($0), $pop2
; CHECK-NEXT:    i32x4.extend_low_i16x8_s $push3=, $1
; CHECK-NEXT:    v128.store 0($0), $pop3
; CHECK-NEXT:    return
  %wide.a = sext <16 x i8> %a to <16 x i32>
  %wide.b = sext <16 x i8> %a to <16 x i32>
  %mul = mul <16 x i32> %wide.a, %wide.b
  ret <16 x i32> %mul
}

define <8 x i32> @sext_mul_v8i16(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: sext_mul_v8i16:
; CHECK:         .functype sext_mul_v8i16 (i32, v128, v128) -> ()
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32x4.extmul_high_i16x8_s $push0=, $1, $1
; CHECK-NEXT:    v128.store 16($0), $pop0
; CHECK-NEXT:    i32x4.extmul_low_i16x8_s $push1=, $1, $1
; CHECK-NEXT:    v128.store 0($0), $pop1
; CHECK-NEXT:    return
  %wide.a = sext <8 x i16> %a to <8 x i32>
  %wide.b = sext <8 x i16> %a to <8 x i32>
  %mul = mul <8 x i32> %wide.a, %wide.b
  ret <8 x i32> %mul
}

define <8 x i32> @zext_mul_v8i8(<8 x i8> %a, <8 x i8> %b) {
; CHECK-LABEL: zext_mul_v8i8:
; CHECK:         .functype zext_mul_v8i8 (i32, v128, v128) -> ()
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i16x8.extmul_low_i8x16_u $push3=, $1, $1
; CHECK-NEXT:    local.tee $push2=, $1=, $pop3
; CHECK-NEXT:    i32x4.extend_high_i16x8_u $push0=, $pop2
; CHECK-NEXT:    v128.store 16($0), $pop0
; CHECK-NEXT:    i32x4.extend_low_i16x8_u $push1=, $1
; CHECK-NEXT:    v128.store 0($0), $pop1
; CHECK-NEXT:    return
  %wide.a = zext <8 x i8> %a to <8 x i32>
  %wide.b = zext <8 x i8> %a to <8 x i32>
  %mul = mul <8 x i32> %wide.a, %wide.b
  ret <8 x i32> %mul
}

define <16 x i32> @zext_mul_v16i8(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: zext_mul_v16i8:
; CHECK:         .functype zext_mul_v16i8 (i32, v128, v128) -> ()
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i16x8.extmul_high_i8x16_u $push7=, $1, $1
; CHECK-NEXT:    local.tee $push6=, $3=, $pop7
; CHECK-NEXT:    i32x4.extend_high_i16x8_u $push0=, $pop6
; CHECK-NEXT:    v128.store 48($0), $pop0
; CHECK-NEXT:    i32x4.extend_low_i16x8_u $push1=, $3
; CHECK-NEXT:    v128.store 32($0), $pop1
; CHECK-NEXT:    i16x8.extmul_low_i8x16_u $push5=, $1, $1
; CHECK-NEXT:    local.tee $push4=, $1=, $pop5
; CHECK-NEXT:    i32x4.extend_high_i16x8_u $push2=, $pop4
; CHECK-NEXT:    v128.store 16($0), $pop2
; CHECK-NEXT:    i32x4.extend_low_i16x8_u $push3=, $1
; CHECK-NEXT:    v128.store 0($0), $pop3
; CHECK-NEXT:    return
  %wide.a = zext <16 x i8> %a to <16 x i32>
  %wide.b = zext <16 x i8> %a to <16 x i32>
  %mul = mul <16 x i32> %wide.a, %wide.b
  ret <16 x i32> %mul
}

define <8 x i32> @zext_mul_v8i16(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: zext_mul_v8i16:
; CHECK:         .functype zext_mul_v8i16 (i32, v128, v128) -> ()
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32x4.extmul_high_i16x8_u $push0=, $1, $1
; CHECK-NEXT:    v128.store 16($0), $pop0
; CHECK-NEXT:    i32x4.extmul_low_i16x8_u $push1=, $1, $1
; CHECK-NEXT:    v128.store 0($0), $pop1
; CHECK-NEXT:    return
  %wide.a = zext <8 x i16> %a to <8 x i32>
  %wide.b = zext <8 x i16> %a to <8 x i32>
  %mul = mul <8 x i32> %wide.a, %wide.b
  ret <8 x i32> %mul
}

define <8 x i32> @sext_zext_mul_v8i8(<8 x i8> %a, <8 x i8> %b) {
; CHECK-LABEL: sext_zext_mul_v8i8:
; CHECK:         .functype sext_zext_mul_v8i8 (i32, v128, v128) -> ()
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i16x8.extend_low_i8x16_s $push2=, $1
; CHECK-NEXT:    i32x4.extend_low_i16x8_s $push3=, $pop2
; CHECK-NEXT:    i16x8.extend_low_i8x16_u $push0=, $1
; CHECK-NEXT:    i32x4.extend_low_i16x8_u $push1=, $pop0
; CHECK-NEXT:    i32x4.mul $push4=, $pop3, $pop1
; CHECK-NEXT:    v128.store 0($0), $pop4
; CHECK-NEXT:    i8x16.shuffle $push11=, $1, $1, 4, 5, 6, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; CHECK-NEXT:    local.tee $push10=, $1=, $pop11
; CHECK-NEXT:    i16x8.extend_low_i8x16_s $push7=, $pop10
; CHECK-NEXT:    i32x4.extend_low_i16x8_s $push8=, $pop7
; CHECK-NEXT:    i16x8.extend_low_i8x16_u $push5=, $1
; CHECK-NEXT:    i32x4.extend_low_i16x8_u $push6=, $pop5
; CHECK-NEXT:    i32x4.mul $push9=, $pop8, $pop6
; CHECK-NEXT:    v128.store 16($0), $pop9
; CHECK-NEXT:    return
  %wide.a = sext <8 x i8> %a to <8 x i32>
  %wide.b = zext <8 x i8> %a to <8 x i32>
  %mul = mul <8 x i32> %wide.a, %wide.b
  ret <8 x i32> %mul
}

define <16 x i32> @sext_zext_mul_v16i8(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: sext_zext_mul_v16i8:
; CHECK:         .functype sext_zext_mul_v16i8 (i32, v128, v128) -> ()
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i16x8.extend_low_i8x16_s $push2=, $1
; CHECK-NEXT:    i32x4.extend_low_i16x8_s $push3=, $pop2
; CHECK-NEXT:    i16x8.extend_low_i8x16_u $push0=, $1
; CHECK-NEXT:    i32x4.extend_low_i16x8_u $push1=, $pop0
; CHECK-NEXT:    i32x4.mul $push4=, $pop3, $pop1
; CHECK-NEXT:    v128.store 0($0), $pop4
; CHECK-NEXT:    i8x16.shuffle $push25=, $1, $1, 12, 13, 14, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; CHECK-NEXT:    local.tee $push24=, $3=, $pop25
; CHECK-NEXT:    i16x8.extend_low_i8x16_s $push7=, $pop24
; CHECK-NEXT:    i32x4.extend_low_i16x8_s $push8=, $pop7
; CHECK-NEXT:    i16x8.extend_low_i8x16_u $push5=, $3
; CHECK-NEXT:    i32x4.extend_low_i16x8_u $push6=, $pop5
; CHECK-NEXT:    i32x4.mul $push9=, $pop8, $pop6
; CHECK-NEXT:    v128.store 48($0), $pop9
; CHECK-NEXT:    i8x16.shuffle $push23=, $1, $1, 8, 9, 10, 11, 12, 13, 14, 15, 0, 0, 0, 0, 0, 0, 0, 0
; CHECK-NEXT:    local.tee $push22=, $3=, $pop23
; CHECK-NEXT:    i16x8.extend_low_i8x16_s $push12=, $pop22
; CHECK-NEXT:    i32x4.extend_low_i16x8_s $push13=, $pop12
; CHECK-NEXT:    i16x8.extend_low_i8x16_u $push10=, $3
; CHECK-NEXT:    i32x4.extend_low_i16x8_u $push11=, $pop10
; CHECK-NEXT:    i32x4.mul $push14=, $pop13, $pop11
; CHECK-NEXT:    v128.store 32($0), $pop14
; CHECK-NEXT:    i8x16.shuffle $push21=, $1, $1, 4, 5, 6, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; CHECK-NEXT:    local.tee $push20=, $1=, $pop21
; CHECK-NEXT:    i16x8.extend_low_i8x16_s $push17=, $pop20
; CHECK-NEXT:    i32x4.extend_low_i16x8_s $push18=, $pop17
; CHECK-NEXT:    i16x8.extend_low_i8x16_u $push15=, $1
; CHECK-NEXT:    i32x4.extend_low_i16x8_u $push16=, $pop15
; CHECK-NEXT:    i32x4.mul $push19=, $pop18, $pop16
; CHECK-NEXT:    v128.store 16($0), $pop19
; CHECK-NEXT:    return
  %wide.a = sext <16 x i8> %a to <16 x i32>
  %wide.b = zext <16 x i8> %a to <16 x i32>
  %mul = mul <16 x i32> %wide.a, %wide.b
  ret <16 x i32> %mul
}

define <8 x i32> @zext_sext_mul_v8i16(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: zext_sext_mul_v8i16:
; CHECK:         .functype zext_sext_mul_v8i16 (i32, v128, v128) -> ()
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32x4.extend_high_i16x8_u $push1=, $1
; CHECK-NEXT:    i32x4.extend_high_i16x8_s $push0=, $1
; CHECK-NEXT:    i32x4.mul $push2=, $pop1, $pop0
; CHECK-NEXT:    v128.store 16($0), $pop2
; CHECK-NEXT:    i32x4.extend_low_i16x8_u $push4=, $1
; CHECK-NEXT:    i32x4.extend_low_i16x8_s $push3=, $1
; CHECK-NEXT:    i32x4.mul $push5=, $pop4, $pop3
; CHECK-NEXT:    v128.store 0($0), $pop5
; CHECK-NEXT:    return
  %wide.a = zext <8 x i16> %a to <8 x i32>
  %wide.b = sext <8 x i16> %a to <8 x i32>
  %mul = mul <8 x i32> %wide.a, %wide.b
  ret <8 x i32> %mul
}
