; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=riscv64 -mattr=+v | FileCheck %s
; RUN: llc < %s -mtriple=riscv32 -mattr=+v | FileCheck %s

; Test that we reverse InstCombinerImpl::transformZExtICmp when unprofitable

define <vscale x 1 x i8> @reverse_zexticmp_i16(<vscale x 1 x i16> %x) {
; CHECK-LABEL: reverse_zexticmp_i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    vsrl.vi v8, v8, 2
; CHECK-NEXT:    vand.vi v8, v8, 1
; CHECK-NEXT:    ret
  %1 = trunc <vscale x 1 x i16> %x to <vscale x 1 x i8>
  %2 = lshr <vscale x 1 x i8> %1, splat (i8 2)
  %3 = and <vscale x 1 x i8> %2, splat (i8 1)
  ret <vscale x 1 x i8> %3
}

define <vscale x 1 x i8> @reverse_zexticmp_i32(<vscale x 1 x i32> %x) {
; CHECK-LABEL: reverse_zexticmp_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vand.vi v8, v8, 4
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    ret
  %1 = trunc <vscale x 1 x i32> %x to <vscale x 1 x i8>
  %2 = lshr <vscale x 1 x i8> %1, splat (i8 2)
  %3 = and <vscale x 1 x i8> %2, splat (i8 1)
  ret <vscale x 1 x i8> %3
}

define <vscale x 1 x i8> @reverse_zexticmp_neg_i32(<vscale x 1 x i32> %x) {
; CHECK-LABEL: reverse_zexticmp_neg_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vand.vi v8, v8, 4
; CHECK-NEXT:    vmseq.vi v0, v8, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    ret
  %1 = trunc <vscale x 1 x i32> %x to <vscale x 1 x i8>
  %2 = xor <vscale x 1 x i8> %1, splat (i8 -1)
  %3 = lshr <vscale x 1 x i8> %2, splat (i8 2)
  %4 = and <vscale x 1 x i8> %3, splat (i8 1)
  ret <vscale x 1 x i8> %4
}

define <vscale x 1 x i8> @reverse_zexticmp_i64(<vscale x 1 x i64> %x) {
; CHECK-LABEL: reverse_zexticmp_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vand.vi v8, v8, 4
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    ret
  %1 = trunc <vscale x 1 x i64> %x to <vscale x 1 x i8>
  %2 = lshr <vscale x 1 x i8> %1, splat (i8 2)
  %3 = and <vscale x 1 x i8> %2, splat (i8 1)
  ret <vscale x 1 x i8> %3
}

define <vscale x 1 x i8> @reverse_zexticmp_neg_i64(<vscale x 1 x i64> %x) {
; CHECK-LABEL: reverse_zexticmp_neg_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vand.vi v8, v8, 4
; CHECK-NEXT:    vmseq.vi v0, v8, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, 1, v0
; CHECK-NEXT:    ret
  %1 = trunc <vscale x 1 x i64> %x to <vscale x 1 x i8>
  %2 = xor <vscale x 1 x i8> %1, splat (i8 -1)
  %3 = lshr <vscale x 1 x i8> %2, splat (i8 2)
  %4 = and <vscale x 1 x i8> %3, splat (i8 1)
  ret <vscale x 1 x i8> %4
}

