; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=CHECK,RV64I
; RUN: llc -mtriple=riscv64 -mattr=+zbb -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=CHECK,RV64ZBB

declare i32 @llvm.ctlz.i32(i32, i1)

define signext i32 @ctlz_i32(i32 signext %a) nounwind {
; RV64I-LABEL: ctlz_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    beqz a0, .LBB0_2
; RV64I-NEXT:  # %bb.1: # %cond.false
; RV64I-NEXT:    srliw a1, a0, 1
; RV64I-NEXT:    lui a2, 349525
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    addi a1, a2, 1365
; RV64I-NEXT:    srliw a2, a0, 2
; RV64I-NEXT:    or a0, a0, a2
; RV64I-NEXT:    srliw a2, a0, 4
; RV64I-NEXT:    or a0, a0, a2
; RV64I-NEXT:    srliw a2, a0, 8
; RV64I-NEXT:    or a0, a0, a2
; RV64I-NEXT:    srliw a2, a0, 16
; RV64I-NEXT:    or a0, a0, a2
; RV64I-NEXT:    not a0, a0
; RV64I-NEXT:    srli a2, a0, 1
; RV64I-NEXT:    and a1, a2, a1
; RV64I-NEXT:    lui a2, 209715
; RV64I-NEXT:    addi a2, a2, 819
; RV64I-NEXT:    sub a0, a0, a1
; RV64I-NEXT:    and a1, a0, a2
; RV64I-NEXT:    srli a0, a0, 2
; RV64I-NEXT:    and a0, a0, a2
; RV64I-NEXT:    lui a2, 61681
; RV64I-NEXT:    add a0, a1, a0
; RV64I-NEXT:    srli a1, a0, 4
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    addi a1, a2, -241
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    slli a1, a0, 8
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    slli a1, a0, 16
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    srliw a0, a0, 24
; RV64I-NEXT:    ret
; RV64I-NEXT:  .LBB0_2:
; RV64I-NEXT:    li a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: ctlz_i32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    clzw a0, a0
; RV64ZBB-NEXT:    ret
  %1 = call i32 @llvm.ctlz.i32(i32 %a, i1 false)
  ret i32 %1
}

define signext i32 @log2_i32(i32 signext %a) nounwind {
; RV64I-LABEL: log2_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    beqz a0, .LBB1_2
; RV64I-NEXT:  # %bb.1: # %cond.false
; RV64I-NEXT:    srliw a1, a0, 1
; RV64I-NEXT:    lui a2, 349525
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    addi a1, a2, 1365
; RV64I-NEXT:    srliw a2, a0, 2
; RV64I-NEXT:    or a0, a0, a2
; RV64I-NEXT:    srliw a2, a0, 4
; RV64I-NEXT:    or a0, a0, a2
; RV64I-NEXT:    srliw a2, a0, 8
; RV64I-NEXT:    or a0, a0, a2
; RV64I-NEXT:    srliw a2, a0, 16
; RV64I-NEXT:    or a0, a0, a2
; RV64I-NEXT:    not a0, a0
; RV64I-NEXT:    srli a2, a0, 1
; RV64I-NEXT:    and a1, a2, a1
; RV64I-NEXT:    lui a2, 209715
; RV64I-NEXT:    addi a2, a2, 819
; RV64I-NEXT:    sub a0, a0, a1
; RV64I-NEXT:    and a1, a0, a2
; RV64I-NEXT:    srli a0, a0, 2
; RV64I-NEXT:    and a0, a0, a2
; RV64I-NEXT:    lui a2, 61681
; RV64I-NEXT:    add a0, a1, a0
; RV64I-NEXT:    srli a1, a0, 4
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    addi a1, a2, -241
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    slli a1, a0, 8
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    slli a1, a0, 16
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    srliw a0, a0, 24
; RV64I-NEXT:    j .LBB1_3
; RV64I-NEXT:  .LBB1_2:
; RV64I-NEXT:    li a0, 32
; RV64I-NEXT:  .LBB1_3: # %cond.end
; RV64I-NEXT:    li a1, 31
; RV64I-NEXT:    sub a0, a1, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: log2_i32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    clzw a0, a0
; RV64ZBB-NEXT:    li a1, 31
; RV64ZBB-NEXT:    sub a0, a1, a0
; RV64ZBB-NEXT:    ret
  %1 = call i32 @llvm.ctlz.i32(i32 %a, i1 false)
  %2 = sub i32 31, %1
  ret i32 %2
}

define signext i32 @log2_ceil_i32(i32 signext %a) nounwind {
; RV64I-LABEL: log2_ceil_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addiw a1, a0, -1
; RV64I-NEXT:    li a0, 32
; RV64I-NEXT:    li a2, 32
; RV64I-NEXT:    beqz a1, .LBB2_2
; RV64I-NEXT:  # %bb.1: # %cond.false
; RV64I-NEXT:    srliw a2, a1, 1
; RV64I-NEXT:    lui a3, 349525
; RV64I-NEXT:    or a1, a1, a2
; RV64I-NEXT:    addi a2, a3, 1365
; RV64I-NEXT:    srliw a3, a1, 2
; RV64I-NEXT:    or a1, a1, a3
; RV64I-NEXT:    srliw a3, a1, 4
; RV64I-NEXT:    or a1, a1, a3
; RV64I-NEXT:    srliw a3, a1, 8
; RV64I-NEXT:    or a1, a1, a3
; RV64I-NEXT:    srliw a3, a1, 16
; RV64I-NEXT:    or a1, a1, a3
; RV64I-NEXT:    not a1, a1
; RV64I-NEXT:    srli a3, a1, 1
; RV64I-NEXT:    and a2, a3, a2
; RV64I-NEXT:    lui a3, 209715
; RV64I-NEXT:    addi a3, a3, 819
; RV64I-NEXT:    sub a1, a1, a2
; RV64I-NEXT:    and a2, a1, a3
; RV64I-NEXT:    srli a1, a1, 2
; RV64I-NEXT:    and a1, a1, a3
; RV64I-NEXT:    lui a3, 61681
; RV64I-NEXT:    add a1, a2, a1
; RV64I-NEXT:    srli a2, a1, 4
; RV64I-NEXT:    add a1, a1, a2
; RV64I-NEXT:    addi a2, a3, -241
; RV64I-NEXT:    and a1, a1, a2
; RV64I-NEXT:    slli a2, a1, 8
; RV64I-NEXT:    add a1, a1, a2
; RV64I-NEXT:    slli a2, a1, 16
; RV64I-NEXT:    add a1, a1, a2
; RV64I-NEXT:    srliw a2, a1, 24
; RV64I-NEXT:  .LBB2_2: # %cond.end
; RV64I-NEXT:    sub a0, a0, a2
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: log2_ceil_i32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    addi a0, a0, -1
; RV64ZBB-NEXT:    clzw a0, a0
; RV64ZBB-NEXT:    li a1, 32
; RV64ZBB-NEXT:    sub a0, a1, a0
; RV64ZBB-NEXT:    ret
  %1 = sub i32 %a, 1
  %2 = call i32 @llvm.ctlz.i32(i32 %1, i1 false)
  %3 = sub i32 32, %2
  ret i32 %3
}

define signext i32 @findLastSet_i32(i32 signext %a) nounwind {
; RV64I-LABEL: findLastSet_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srliw a1, a0, 1
; RV64I-NEXT:    lui a2, 349525
; RV64I-NEXT:    or a1, a0, a1
; RV64I-NEXT:    addi a2, a2, 1365
; RV64I-NEXT:    srliw a3, a1, 2
; RV64I-NEXT:    or a1, a1, a3
; RV64I-NEXT:    srliw a3, a1, 4
; RV64I-NEXT:    or a1, a1, a3
; RV64I-NEXT:    srliw a3, a1, 8
; RV64I-NEXT:    or a1, a1, a3
; RV64I-NEXT:    srliw a3, a1, 16
; RV64I-NEXT:    or a1, a1, a3
; RV64I-NEXT:    not a1, a1
; RV64I-NEXT:    srli a3, a1, 1
; RV64I-NEXT:    and a2, a3, a2
; RV64I-NEXT:    lui a3, 209715
; RV64I-NEXT:    addi a3, a3, 819
; RV64I-NEXT:    sub a1, a1, a2
; RV64I-NEXT:    and a2, a1, a3
; RV64I-NEXT:    srli a1, a1, 2
; RV64I-NEXT:    and a1, a1, a3
; RV64I-NEXT:    lui a3, 61681
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    addi a3, a3, -241
; RV64I-NEXT:    add a1, a2, a1
; RV64I-NEXT:    srli a2, a1, 4
; RV64I-NEXT:    add a1, a1, a2
; RV64I-NEXT:    and a1, a1, a3
; RV64I-NEXT:    slli a2, a1, 8
; RV64I-NEXT:    add a1, a1, a2
; RV64I-NEXT:    slli a2, a1, 16
; RV64I-NEXT:    add a1, a1, a2
; RV64I-NEXT:    srliw a1, a1, 24
; RV64I-NEXT:    xori a1, a1, 31
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: findLastSet_i32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    clzw a1, a0
; RV64ZBB-NEXT:    snez a0, a0
; RV64ZBB-NEXT:    xori a1, a1, 31
; RV64ZBB-NEXT:    addi a0, a0, -1
; RV64ZBB-NEXT:    or a0, a0, a1
; RV64ZBB-NEXT:    ret
  %1 = call i32 @llvm.ctlz.i32(i32 %a, i1 true)
  %2 = xor i32 31, %1
  %3 = icmp eq i32 %a, 0
  %4 = select i1 %3, i32 -1, i32 %2
  ret i32 %4
}

define i32 @ctlz_lshr_i32(i32 signext %a) {
; RV64I-LABEL: ctlz_lshr_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srliw a0, a0, 1
; RV64I-NEXT:    beqz a0, .LBB4_2
; RV64I-NEXT:  # %bb.1: # %cond.false
; RV64I-NEXT:    srliw a1, a0, 1
; RV64I-NEXT:    lui a2, 349525
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    addi a1, a2, 1365
; RV64I-NEXT:    srliw a2, a0, 2
; RV64I-NEXT:    or a0, a0, a2
; RV64I-NEXT:    srliw a2, a0, 4
; RV64I-NEXT:    or a0, a0, a2
; RV64I-NEXT:    srliw a2, a0, 8
; RV64I-NEXT:    or a0, a0, a2
; RV64I-NEXT:    srliw a2, a0, 16
; RV64I-NEXT:    or a0, a0, a2
; RV64I-NEXT:    not a0, a0
; RV64I-NEXT:    srli a2, a0, 1
; RV64I-NEXT:    and a1, a2, a1
; RV64I-NEXT:    lui a2, 209715
; RV64I-NEXT:    addi a2, a2, 819
; RV64I-NEXT:    sub a0, a0, a1
; RV64I-NEXT:    and a1, a0, a2
; RV64I-NEXT:    srli a0, a0, 2
; RV64I-NEXT:    and a0, a0, a2
; RV64I-NEXT:    lui a2, 61681
; RV64I-NEXT:    add a0, a1, a0
; RV64I-NEXT:    srli a1, a0, 4
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    addi a1, a2, -241
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    slli a1, a0, 8
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    slli a1, a0, 16
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    srliw a0, a0, 24
; RV64I-NEXT:    ret
; RV64I-NEXT:  .LBB4_2:
; RV64I-NEXT:    li a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: ctlz_lshr_i32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    srliw a0, a0, 1
; RV64ZBB-NEXT:    clzw a0, a0
; RV64ZBB-NEXT:    ret
  %1 = lshr i32 %a, 1
  %2 = call i32 @llvm.ctlz.i32(i32 %1, i1 false)
  ret i32 %2
}

declare i64 @llvm.ctlz.i64(i64, i1)

define i64 @ctlz_i64(i64 %a) nounwind {
; RV64I-LABEL: ctlz_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    beqz a0, .LBB5_2
; RV64I-NEXT:  # %bb.1: # %cond.false
; RV64I-NEXT:    srli a1, a0, 1
; RV64I-NEXT:    lui a2, 349525
; RV64I-NEXT:    lui a3, 209715
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    addi a1, a2, 1365
; RV64I-NEXT:    addi a2, a3, 819
; RV64I-NEXT:    srli a3, a0, 2
; RV64I-NEXT:    or a0, a0, a3
; RV64I-NEXT:    slli a3, a1, 32
; RV64I-NEXT:    add a1, a1, a3
; RV64I-NEXT:    slli a3, a2, 32
; RV64I-NEXT:    add a2, a2, a3
; RV64I-NEXT:    srli a3, a0, 4
; RV64I-NEXT:    or a0, a0, a3
; RV64I-NEXT:    srli a3, a0, 8
; RV64I-NEXT:    or a0, a0, a3
; RV64I-NEXT:    srli a3, a0, 16
; RV64I-NEXT:    or a0, a0, a3
; RV64I-NEXT:    srli a3, a0, 32
; RV64I-NEXT:    or a0, a0, a3
; RV64I-NEXT:    not a0, a0
; RV64I-NEXT:    srli a3, a0, 1
; RV64I-NEXT:    and a1, a3, a1
; RV64I-NEXT:    lui a3, 61681
; RV64I-NEXT:    addi a3, a3, -241
; RV64I-NEXT:    sub a0, a0, a1
; RV64I-NEXT:    and a1, a0, a2
; RV64I-NEXT:    srli a0, a0, 2
; RV64I-NEXT:    and a0, a0, a2
; RV64I-NEXT:    slli a2, a3, 32
; RV64I-NEXT:    add a0, a1, a0
; RV64I-NEXT:    srli a1, a0, 4
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    add a2, a3, a2
; RV64I-NEXT:    and a0, a0, a2
; RV64I-NEXT:    slli a1, a0, 8
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    slli a1, a0, 16
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    srli a0, a0, 56
; RV64I-NEXT:    ret
; RV64I-NEXT:  .LBB5_2:
; RV64I-NEXT:    li a0, 64
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: ctlz_i64:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    clz a0, a0
; RV64ZBB-NEXT:    ret
  %1 = call i64 @llvm.ctlz.i64(i64 %a, i1 false)
  ret i64 %1
}

declare i32 @llvm.cttz.i32(i32, i1)

define signext i32 @cttz_i32(i32 signext %a) nounwind {
; RV64I-LABEL: cttz_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    beqz a0, .LBB6_2
; RV64I-NEXT:  # %bb.1: # %cond.false
; RV64I-NEXT:    negw a1, a0
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    slli a1, a0, 6
; RV64I-NEXT:    slli a2, a0, 8
; RV64I-NEXT:    slli a3, a0, 10
; RV64I-NEXT:    slli a4, a0, 12
; RV64I-NEXT:    add a1, a1, a2
; RV64I-NEXT:    slli a2, a0, 16
; RV64I-NEXT:    subw a3, a3, a4
; RV64I-NEXT:    slli a4, a0, 18
; RV64I-NEXT:    subw a2, a2, a4
; RV64I-NEXT:    slli a4, a0, 4
; RV64I-NEXT:    subw a4, a0, a4
; RV64I-NEXT:    add a1, a4, a1
; RV64I-NEXT:    slli a4, a0, 14
; RV64I-NEXT:    subw a3, a3, a4
; RV64I-NEXT:    slli a4, a0, 23
; RV64I-NEXT:    subw a2, a2, a4
; RV64I-NEXT:    slli a0, a0, 27
; RV64I-NEXT:    add a1, a1, a3
; RV64I-NEXT:    add a0, a2, a0
; RV64I-NEXT:    add a0, a1, a0
; RV64I-NEXT:    srliw a0, a0, 27
; RV64I-NEXT:    lui a1, %hi(.LCPI6_0)
; RV64I-NEXT:    addi a1, a1, %lo(.LCPI6_0)
; RV64I-NEXT:    add a0, a1, a0
; RV64I-NEXT:    lbu a0, 0(a0)
; RV64I-NEXT:    ret
; RV64I-NEXT:  .LBB6_2:
; RV64I-NEXT:    li a0, 32
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: cttz_i32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    ctzw a0, a0
; RV64ZBB-NEXT:    ret
  %1 = call i32 @llvm.cttz.i32(i32 %a, i1 false)
  ret i32 %1
}

define signext i32 @cttz_zero_undef_i32(i32 signext %a) nounwind {
; RV64I-LABEL: cttz_zero_undef_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    negw a1, a0
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    slli a1, a0, 6
; RV64I-NEXT:    slli a2, a0, 8
; RV64I-NEXT:    slli a3, a0, 10
; RV64I-NEXT:    slli a4, a0, 12
; RV64I-NEXT:    add a1, a1, a2
; RV64I-NEXT:    slli a2, a0, 16
; RV64I-NEXT:    subw a3, a3, a4
; RV64I-NEXT:    slli a4, a0, 18
; RV64I-NEXT:    subw a2, a2, a4
; RV64I-NEXT:    slli a4, a0, 4
; RV64I-NEXT:    subw a4, a0, a4
; RV64I-NEXT:    add a1, a4, a1
; RV64I-NEXT:    slli a4, a0, 14
; RV64I-NEXT:    subw a3, a3, a4
; RV64I-NEXT:    slli a4, a0, 23
; RV64I-NEXT:    subw a2, a2, a4
; RV64I-NEXT:    slli a0, a0, 27
; RV64I-NEXT:    add a1, a1, a3
; RV64I-NEXT:    add a0, a2, a0
; RV64I-NEXT:    add a0, a1, a0
; RV64I-NEXT:    srliw a0, a0, 27
; RV64I-NEXT:    lui a1, %hi(.LCPI7_0)
; RV64I-NEXT:    addi a1, a1, %lo(.LCPI7_0)
; RV64I-NEXT:    add a0, a1, a0
; RV64I-NEXT:    lbu a0, 0(a0)
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: cttz_zero_undef_i32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    ctzw a0, a0
; RV64ZBB-NEXT:    ret
  %1 = call i32 @llvm.cttz.i32(i32 %a, i1 true)
  ret i32 %1
}

define signext i32 @findFirstSet_i32(i32 signext %a) nounwind {
; RV64I-LABEL: findFirstSet_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    negw a1, a0
; RV64I-NEXT:    and a1, a0, a1
; RV64I-NEXT:    slli a2, a1, 6
; RV64I-NEXT:    slli a3, a1, 8
; RV64I-NEXT:    slli a4, a1, 10
; RV64I-NEXT:    slli a5, a1, 12
; RV64I-NEXT:    add a2, a2, a3
; RV64I-NEXT:    slli a3, a1, 16
; RV64I-NEXT:    subw a4, a4, a5
; RV64I-NEXT:    slli a5, a1, 18
; RV64I-NEXT:    subw a3, a3, a5
; RV64I-NEXT:    slli a5, a1, 4
; RV64I-NEXT:    subw a5, a1, a5
; RV64I-NEXT:    add a2, a5, a2
; RV64I-NEXT:    slli a5, a1, 14
; RV64I-NEXT:    subw a4, a4, a5
; RV64I-NEXT:    slli a5, a1, 23
; RV64I-NEXT:    subw a3, a3, a5
; RV64I-NEXT:    slli a1, a1, 27
; RV64I-NEXT:    add a2, a2, a4
; RV64I-NEXT:    add a1, a3, a1
; RV64I-NEXT:    add a1, a2, a1
; RV64I-NEXT:    srliw a1, a1, 27
; RV64I-NEXT:    lui a2, %hi(.LCPI8_0)
; RV64I-NEXT:    addi a2, a2, %lo(.LCPI8_0)
; RV64I-NEXT:    add a1, a2, a1
; RV64I-NEXT:    lbu a1, 0(a1)
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: findFirstSet_i32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    ctzw a1, a0
; RV64ZBB-NEXT:    snez a0, a0
; RV64ZBB-NEXT:    addi a0, a0, -1
; RV64ZBB-NEXT:    or a0, a0, a1
; RV64ZBB-NEXT:    ret
  %1 = call i32 @llvm.cttz.i32(i32 %a, i1 true)
  %2 = icmp eq i32 %a, 0
  %3 = select i1 %2, i32 -1, i32 %1
  ret i32 %3
}

define signext i32 @ffs_i32(i32 signext %a) nounwind {
; RV64I-LABEL: ffs_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    negw a1, a0
; RV64I-NEXT:    and a1, a0, a1
; RV64I-NEXT:    slli a2, a1, 6
; RV64I-NEXT:    slli a3, a1, 8
; RV64I-NEXT:    slli a4, a1, 10
; RV64I-NEXT:    slli a5, a1, 12
; RV64I-NEXT:    add a2, a2, a3
; RV64I-NEXT:    slli a3, a1, 16
; RV64I-NEXT:    subw a4, a4, a5
; RV64I-NEXT:    slli a5, a1, 18
; RV64I-NEXT:    subw a3, a3, a5
; RV64I-NEXT:    slli a5, a1, 4
; RV64I-NEXT:    subw a5, a1, a5
; RV64I-NEXT:    add a2, a5, a2
; RV64I-NEXT:    slli a5, a1, 14
; RV64I-NEXT:    subw a4, a4, a5
; RV64I-NEXT:    slli a5, a1, 23
; RV64I-NEXT:    subw a3, a3, a5
; RV64I-NEXT:    add a2, a2, a4
; RV64I-NEXT:    lui a4, %hi(.LCPI9_0)
; RV64I-NEXT:    addi a4, a4, %lo(.LCPI9_0)
; RV64I-NEXT:    slli a1, a1, 27
; RV64I-NEXT:    add a1, a3, a1
; RV64I-NEXT:    add a1, a2, a1
; RV64I-NEXT:    srliw a1, a1, 27
; RV64I-NEXT:    add a1, a4, a1
; RV64I-NEXT:    lbu a1, 0(a1)
; RV64I-NEXT:    seqz a0, a0
; RV64I-NEXT:    addi a1, a1, 1
; RV64I-NEXT:    addi a0, a0, -1
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: ffs_i32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    ctzw a1, a0
; RV64ZBB-NEXT:    seqz a0, a0
; RV64ZBB-NEXT:    addi a1, a1, 1
; RV64ZBB-NEXT:    addi a0, a0, -1
; RV64ZBB-NEXT:    and a0, a0, a1
; RV64ZBB-NEXT:    ret
  %1 = call i32 @llvm.cttz.i32(i32 %a, i1 true)
  %2 = add i32 %1, 1
  %3 = icmp eq i32 %a, 0
  %4 = select i1 %3, i32 0, i32 %2
  ret i32 %4
}

declare i64 @llvm.cttz.i64(i64, i1)

define i64 @cttz_i64(i64 %a) nounwind {
; RV64I-LABEL: cttz_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    beqz a0, .LBB10_2
; RV64I-NEXT:  # %bb.1: # %cond.false
; RV64I-NEXT:    addi sp, sp, -16
; RV64I-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    neg a1, a0
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    lui a1, %hi(.LCPI10_0)
; RV64I-NEXT:    ld a1, %lo(.LCPI10_0)(a1)
; RV64I-NEXT:    call __muldi3
; RV64I-NEXT:    srli a0, a0, 58
; RV64I-NEXT:    lui a1, %hi(.LCPI10_1)
; RV64I-NEXT:    addi a1, a1, %lo(.LCPI10_1)
; RV64I-NEXT:    add a0, a1, a0
; RV64I-NEXT:    lbu a0, 0(a0)
; RV64I-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 16
; RV64I-NEXT:    ret
; RV64I-NEXT:  .LBB10_2:
; RV64I-NEXT:    li a0, 64
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: cttz_i64:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    ctz a0, a0
; RV64ZBB-NEXT:    ret
  %1 = call i64 @llvm.cttz.i64(i64 %a, i1 false)
  ret i64 %1
}

declare i32 @llvm.ctpop.i32(i32)

define signext i32 @ctpop_i32(i32 signext %a) nounwind {
; RV64I-LABEL: ctpop_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srli a1, a0, 1
; RV64I-NEXT:    lui a2, 349525
; RV64I-NEXT:    addi a2, a2, 1365
; RV64I-NEXT:    and a1, a1, a2
; RV64I-NEXT:    lui a2, 209715
; RV64I-NEXT:    addi a2, a2, 819
; RV64I-NEXT:    sub a0, a0, a1
; RV64I-NEXT:    and a1, a0, a2
; RV64I-NEXT:    srli a0, a0, 2
; RV64I-NEXT:    and a0, a0, a2
; RV64I-NEXT:    lui a2, 61681
; RV64I-NEXT:    add a0, a1, a0
; RV64I-NEXT:    srli a1, a0, 4
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    addi a1, a2, -241
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    slli a1, a0, 8
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    slli a1, a0, 16
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    srliw a0, a0, 24
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: ctpop_i32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    cpopw a0, a0
; RV64ZBB-NEXT:    ret
  %1 = call i32 @llvm.ctpop.i32(i32 %a)
  ret i32 %1
}

define i1 @ctpop_i32_ult_two(i32 signext %a) nounwind {
; RV64I-LABEL: ctpop_i32_ult_two:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addiw a1, a0, -1
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    seqz a0, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: ctpop_i32_ult_two:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    cpopw a0, a0
; RV64ZBB-NEXT:    sltiu a0, a0, 2
; RV64ZBB-NEXT:    ret
  %1 = call i32 @llvm.ctpop.i32(i32 %a)
  %2 = icmp ult i32 %1, 2
  ret i1 %2
}

define i1 @ctpop_i32_ugt_one(i32 signext %a) nounwind {
; RV64I-LABEL: ctpop_i32_ugt_one:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addiw a1, a0, -1
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: ctpop_i32_ugt_one:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    cpopw a0, a0
; RV64ZBB-NEXT:    sltiu a0, a0, 2
; RV64ZBB-NEXT:    xori a0, a0, 1
; RV64ZBB-NEXT:    ret
  %1 = call i32 @llvm.ctpop.i32(i32 %a)
  %2 = icmp ugt i32 %1, 1
  ret i1 %2
}

define i1 @ctpop_i32_eq_one(i32 signext %a) nounwind {
; RV64I-LABEL: ctpop_i32_eq_one:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addiw a1, a0, -1
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    sltu a0, a1, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: ctpop_i32_eq_one:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    cpopw a0, a0
; RV64ZBB-NEXT:    addi a0, a0, -1
; RV64ZBB-NEXT:    seqz a0, a0
; RV64ZBB-NEXT:    ret
  %1 = call i32 @llvm.ctpop.i32(i32 %a)
  %2 = icmp eq i32 %1, 1
  ret i1 %2
}

define i1 @ctpop_i32_ne_one(i32 signext %a) nounwind {
; RV64I-LABEL: ctpop_i32_ne_one:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addiw a1, a0, -1
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    sltu a0, a1, a0
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: ctpop_i32_ne_one:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    cpopw a0, a0
; RV64ZBB-NEXT:    addi a0, a0, -1
; RV64ZBB-NEXT:    snez a0, a0
; RV64ZBB-NEXT:    ret
  %1 = call i32 @llvm.ctpop.i32(i32 %a)
  %2 = icmp ne i32 %1, 1
  ret i1 %2
}

define signext i32 @ctpop_i32_load(ptr %p) nounwind {
; RV64I-LABEL: ctpop_i32_load:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lw a0, 0(a0)
; RV64I-NEXT:    lui a1, 349525
; RV64I-NEXT:    addi a1, a1, 1365
; RV64I-NEXT:    srli a2, a0, 1
; RV64I-NEXT:    and a1, a2, a1
; RV64I-NEXT:    lui a2, 209715
; RV64I-NEXT:    addi a2, a2, 819
; RV64I-NEXT:    sub a0, a0, a1
; RV64I-NEXT:    and a1, a0, a2
; RV64I-NEXT:    srli a0, a0, 2
; RV64I-NEXT:    and a0, a0, a2
; RV64I-NEXT:    lui a2, 61681
; RV64I-NEXT:    add a0, a1, a0
; RV64I-NEXT:    srli a1, a0, 4
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    addi a1, a2, -241
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    slli a1, a0, 8
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    slli a1, a0, 16
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    srliw a0, a0, 24
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: ctpop_i32_load:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    lwu a0, 0(a0)
; RV64ZBB-NEXT:    cpopw a0, a0
; RV64ZBB-NEXT:    ret
  %a = load i32, ptr %p
  %1 = call i32 @llvm.ctpop.i32(i32 %a)
  ret i32 %1
}

declare <2 x i32> @llvm.ctpop.v2i32(<2 x i32>)

define <2 x i32> @ctpop_v2i32(<2 x i32> %a) nounwind {
; RV64I-LABEL: ctpop_v2i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srli a2, a0, 1
; RV64I-NEXT:    lui a3, 349525
; RV64I-NEXT:    lui a4, 209715
; RV64I-NEXT:    srli a5, a1, 1
; RV64I-NEXT:    addi a3, a3, 1365
; RV64I-NEXT:    and a2, a2, a3
; RV64I-NEXT:    and a3, a5, a3
; RV64I-NEXT:    lui a5, 61681
; RV64I-NEXT:    addi a4, a4, 819
; RV64I-NEXT:    addi a5, a5, -241
; RV64I-NEXT:    sub a0, a0, a2
; RV64I-NEXT:    sub a1, a1, a3
; RV64I-NEXT:    and a2, a0, a4
; RV64I-NEXT:    srli a0, a0, 2
; RV64I-NEXT:    and a3, a1, a4
; RV64I-NEXT:    srli a1, a1, 2
; RV64I-NEXT:    and a0, a0, a4
; RV64I-NEXT:    and a1, a1, a4
; RV64I-NEXT:    add a0, a2, a0
; RV64I-NEXT:    add a1, a3, a1
; RV64I-NEXT:    srli a2, a0, 4
; RV64I-NEXT:    srli a3, a1, 4
; RV64I-NEXT:    add a0, a0, a2
; RV64I-NEXT:    add a1, a1, a3
; RV64I-NEXT:    and a0, a0, a5
; RV64I-NEXT:    and a1, a1, a5
; RV64I-NEXT:    slli a2, a0, 8
; RV64I-NEXT:    slli a3, a1, 8
; RV64I-NEXT:    add a0, a0, a2
; RV64I-NEXT:    add a1, a1, a3
; RV64I-NEXT:    slli a2, a0, 16
; RV64I-NEXT:    slli a3, a1, 16
; RV64I-NEXT:    add a0, a0, a2
; RV64I-NEXT:    add a1, a1, a3
; RV64I-NEXT:    srliw a0, a0, 24
; RV64I-NEXT:    srliw a1, a1, 24
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: ctpop_v2i32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    cpopw a0, a0
; RV64ZBB-NEXT:    cpopw a1, a1
; RV64ZBB-NEXT:    ret
  %1 = call <2 x i32> @llvm.ctpop.v2i32(<2 x i32> %a)
  ret <2 x i32> %1
}

define <2 x i1> @ctpop_v2i32_ult_two(<2 x i32> %a) nounwind {
; RV64I-LABEL: ctpop_v2i32_ult_two:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi a2, a0, -1
; RV64I-NEXT:    addi a3, a1, -1
; RV64I-NEXT:    and a1, a1, a3
; RV64I-NEXT:    and a0, a0, a2
; RV64I-NEXT:    sext.w a1, a1
; RV64I-NEXT:    sext.w a0, a0
; RV64I-NEXT:    seqz a0, a0
; RV64I-NEXT:    seqz a1, a1
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: ctpop_v2i32_ult_two:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    cpopw a1, a1
; RV64ZBB-NEXT:    cpopw a0, a0
; RV64ZBB-NEXT:    sltiu a0, a0, 2
; RV64ZBB-NEXT:    sltiu a1, a1, 2
; RV64ZBB-NEXT:    ret
  %1 = call <2 x i32> @llvm.ctpop.v2i32(<2 x i32> %a)
  %2 = icmp ult <2 x i32> %1, <i32 2, i32 2>
  ret <2 x i1> %2
}

define <2 x i1> @ctpop_v2i32_ugt_one(<2 x i32> %a) nounwind {
; RV64I-LABEL: ctpop_v2i32_ugt_one:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi a2, a0, -1
; RV64I-NEXT:    addi a3, a1, -1
; RV64I-NEXT:    and a1, a1, a3
; RV64I-NEXT:    and a0, a0, a2
; RV64I-NEXT:    sext.w a1, a1
; RV64I-NEXT:    sext.w a0, a0
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    snez a1, a1
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: ctpop_v2i32_ugt_one:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    cpopw a1, a1
; RV64ZBB-NEXT:    cpopw a0, a0
; RV64ZBB-NEXT:    sltiu a0, a0, 2
; RV64ZBB-NEXT:    sltiu a1, a1, 2
; RV64ZBB-NEXT:    xori a0, a0, 1
; RV64ZBB-NEXT:    xori a1, a1, 1
; RV64ZBB-NEXT:    ret
  %1 = call <2 x i32> @llvm.ctpop.v2i32(<2 x i32> %a)
  %2 = icmp ugt <2 x i32> %1, <i32 1, i32 1>
  ret <2 x i1> %2
}

define <2 x i1> @ctpop_v2i32_eq_one(<2 x i32> %a) nounwind {
; RV64I-LABEL: ctpop_v2i32_eq_one:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addiw a2, a0, -1
; RV64I-NEXT:    addiw a3, a1, -1
; RV64I-NEXT:    xor a1, a1, a3
; RV64I-NEXT:    xor a0, a0, a2
; RV64I-NEXT:    sext.w a1, a1
; RV64I-NEXT:    sext.w a0, a0
; RV64I-NEXT:    sltu a0, a2, a0
; RV64I-NEXT:    sltu a1, a3, a1
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: ctpop_v2i32_eq_one:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    cpopw a1, a1
; RV64ZBB-NEXT:    cpopw a0, a0
; RV64ZBB-NEXT:    addi a0, a0, -1
; RV64ZBB-NEXT:    addi a1, a1, -1
; RV64ZBB-NEXT:    seqz a0, a0
; RV64ZBB-NEXT:    seqz a1, a1
; RV64ZBB-NEXT:    ret
  %1 = call <2 x i32> @llvm.ctpop.v2i32(<2 x i32> %a)
  %2 = icmp eq <2 x i32> %1, <i32 1, i32 1>
  ret <2 x i1> %2
}

define <2 x i1> @ctpop_v2i32_ne_one(<2 x i32> %a) nounwind {
; RV64I-LABEL: ctpop_v2i32_ne_one:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addiw a2, a0, -1
; RV64I-NEXT:    addiw a3, a1, -1
; RV64I-NEXT:    xor a1, a1, a3
; RV64I-NEXT:    xor a0, a0, a2
; RV64I-NEXT:    sext.w a1, a1
; RV64I-NEXT:    sext.w a0, a0
; RV64I-NEXT:    sltu a0, a2, a0
; RV64I-NEXT:    sltu a1, a3, a1
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    xori a1, a1, 1
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: ctpop_v2i32_ne_one:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    cpopw a1, a1
; RV64ZBB-NEXT:    cpopw a0, a0
; RV64ZBB-NEXT:    addi a0, a0, -1
; RV64ZBB-NEXT:    addi a1, a1, -1
; RV64ZBB-NEXT:    snez a0, a0
; RV64ZBB-NEXT:    snez a1, a1
; RV64ZBB-NEXT:    ret
  %1 = call <2 x i32> @llvm.ctpop.v2i32(<2 x i32> %a)
  %2 = icmp ne <2 x i32> %1, <i32 1, i32 1>
  ret <2 x i1> %2
}

declare i64 @llvm.ctpop.i64(i64)

define i64 @ctpop_i64(i64 %a) nounwind {
; RV64I-LABEL: ctpop_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 349525
; RV64I-NEXT:    lui a2, 209715
; RV64I-NEXT:    addi a1, a1, 1365
; RV64I-NEXT:    addi a2, a2, 819
; RV64I-NEXT:    slli a3, a1, 32
; RV64I-NEXT:    add a1, a1, a3
; RV64I-NEXT:    slli a3, a2, 32
; RV64I-NEXT:    add a2, a2, a3
; RV64I-NEXT:    srli a3, a0, 1
; RV64I-NEXT:    and a1, a3, a1
; RV64I-NEXT:    lui a3, 61681
; RV64I-NEXT:    addi a3, a3, -241
; RV64I-NEXT:    sub a0, a0, a1
; RV64I-NEXT:    and a1, a0, a2
; RV64I-NEXT:    srli a0, a0, 2
; RV64I-NEXT:    and a0, a0, a2
; RV64I-NEXT:    slli a2, a3, 32
; RV64I-NEXT:    add a0, a1, a0
; RV64I-NEXT:    srli a1, a0, 4
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    add a2, a3, a2
; RV64I-NEXT:    and a0, a0, a2
; RV64I-NEXT:    slli a1, a0, 8
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    slli a1, a0, 16
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    slli a1, a0, 32
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    srli a0, a0, 56
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: ctpop_i64:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    cpop a0, a0
; RV64ZBB-NEXT:    ret
  %1 = call i64 @llvm.ctpop.i64(i64 %a)
  ret i64 %1
}

define i1 @ctpop_i64_ugt_two(i64 %a) nounwind {
; RV64I-LABEL: ctpop_i64_ugt_two:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi a1, a0, -1
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    seqz a0, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: ctpop_i64_ugt_two:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    cpop a0, a0
; RV64ZBB-NEXT:    sltiu a0, a0, 2
; RV64ZBB-NEXT:    ret
  %1 = call i64 @llvm.ctpop.i64(i64 %a)
  %2 = icmp ult i64 %1, 2
  ret i1 %2
}

define i1 @ctpop_i64_ugt_one(i64 %a) nounwind {
; RV64I-LABEL: ctpop_i64_ugt_one:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi a1, a0, -1
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: ctpop_i64_ugt_one:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    cpop a0, a0
; RV64ZBB-NEXT:    sltiu a0, a0, 2
; RV64ZBB-NEXT:    xori a0, a0, 1
; RV64ZBB-NEXT:    ret
  %1 = call i64 @llvm.ctpop.i64(i64 %a)
  %2 = icmp ugt i64 %1, 1
  ret i1 %2
}

define i1 @ctpop_i64_eq_one(i64 %a) nounwind {
; RV64I-LABEL: ctpop_i64_eq_one:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi a1, a0, -1
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    sltu a0, a1, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: ctpop_i64_eq_one:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    cpop a0, a0
; RV64ZBB-NEXT:    addi a0, a0, -1
; RV64ZBB-NEXT:    seqz a0, a0
; RV64ZBB-NEXT:    ret
  %1 = call i64 @llvm.ctpop.i64(i64 %a)
  %2 = icmp eq i64 %1, 1
  ret i1 %2
}

define i1 @ctpop_i64_ne_one(i64 %a) nounwind {
; RV64I-LABEL: ctpop_i64_ne_one:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi a1, a0, -1
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    sltu a0, a1, a0
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: ctpop_i64_ne_one:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    cpop a0, a0
; RV64ZBB-NEXT:    addi a0, a0, -1
; RV64ZBB-NEXT:    snez a0, a0
; RV64ZBB-NEXT:    ret
  %1 = call i64 @llvm.ctpop.i64(i64 %a)
  %2 = icmp ne i64 %1, 1
  ret i1 %2
}

declare <2 x i64> @llvm.ctpop.v2i64(<2 x i64>)

define <2 x i64> @ctpop_v2i64(<2 x i64> %a) nounwind {
; RV64I-LABEL: ctpop_v2i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srli a2, a0, 1
; RV64I-NEXT:    lui a3, 349525
; RV64I-NEXT:    lui a4, 209715
; RV64I-NEXT:    lui a5, 61681
; RV64I-NEXT:    addi a3, a3, 1365
; RV64I-NEXT:    addi a4, a4, 819
; RV64I-NEXT:    addi a5, a5, -241
; RV64I-NEXT:    slli a6, a3, 32
; RV64I-NEXT:    add a3, a3, a6
; RV64I-NEXT:    slli a6, a4, 32
; RV64I-NEXT:    add a4, a4, a6
; RV64I-NEXT:    slli a6, a5, 32
; RV64I-NEXT:    add a5, a5, a6
; RV64I-NEXT:    srli a6, a1, 1
; RV64I-NEXT:    and a2, a2, a3
; RV64I-NEXT:    and a3, a6, a3
; RV64I-NEXT:    sub a0, a0, a2
; RV64I-NEXT:    sub a1, a1, a3
; RV64I-NEXT:    and a2, a0, a4
; RV64I-NEXT:    srli a0, a0, 2
; RV64I-NEXT:    and a3, a1, a4
; RV64I-NEXT:    srli a1, a1, 2
; RV64I-NEXT:    and a0, a0, a4
; RV64I-NEXT:    and a1, a1, a4
; RV64I-NEXT:    add a0, a2, a0
; RV64I-NEXT:    add a1, a3, a1
; RV64I-NEXT:    srli a2, a0, 4
; RV64I-NEXT:    srli a3, a1, 4
; RV64I-NEXT:    add a0, a0, a2
; RV64I-NEXT:    add a1, a1, a3
; RV64I-NEXT:    and a0, a0, a5
; RV64I-NEXT:    and a1, a1, a5
; RV64I-NEXT:    slli a2, a0, 8
; RV64I-NEXT:    slli a3, a1, 8
; RV64I-NEXT:    add a0, a0, a2
; RV64I-NEXT:    add a1, a1, a3
; RV64I-NEXT:    slli a2, a0, 16
; RV64I-NEXT:    slli a3, a1, 16
; RV64I-NEXT:    add a0, a0, a2
; RV64I-NEXT:    add a1, a1, a3
; RV64I-NEXT:    slli a2, a0, 32
; RV64I-NEXT:    slli a3, a1, 32
; RV64I-NEXT:    add a0, a0, a2
; RV64I-NEXT:    add a1, a1, a3
; RV64I-NEXT:    srli a0, a0, 56
; RV64I-NEXT:    srli a1, a1, 56
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: ctpop_v2i64:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    cpop a0, a0
; RV64ZBB-NEXT:    cpop a1, a1
; RV64ZBB-NEXT:    ret
  %1 = call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %a)
  ret <2 x i64> %1
}

define <2 x i1> @ctpop_v2i64_ult_two(<2 x i64> %a) nounwind {
; RV64I-LABEL: ctpop_v2i64_ult_two:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi a2, a0, -1
; RV64I-NEXT:    addi a3, a1, -1
; RV64I-NEXT:    and a1, a1, a3
; RV64I-NEXT:    and a0, a0, a2
; RV64I-NEXT:    seqz a0, a0
; RV64I-NEXT:    seqz a1, a1
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: ctpop_v2i64_ult_two:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    cpop a1, a1
; RV64ZBB-NEXT:    cpop a0, a0
; RV64ZBB-NEXT:    sltiu a0, a0, 2
; RV64ZBB-NEXT:    sltiu a1, a1, 2
; RV64ZBB-NEXT:    ret
  %1 = call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %a)
  %2 = icmp ult <2 x i64> %1, <i64 2, i64 2>
  ret <2 x i1> %2
}

define <2 x i1> @ctpop_v2i64_ugt_one(<2 x i64> %a) nounwind {
; RV64I-LABEL: ctpop_v2i64_ugt_one:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi a2, a0, -1
; RV64I-NEXT:    addi a3, a1, -1
; RV64I-NEXT:    and a1, a1, a3
; RV64I-NEXT:    and a0, a0, a2
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    snez a1, a1
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: ctpop_v2i64_ugt_one:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    cpop a1, a1
; RV64ZBB-NEXT:    cpop a0, a0
; RV64ZBB-NEXT:    sltiu a0, a0, 2
; RV64ZBB-NEXT:    sltiu a1, a1, 2
; RV64ZBB-NEXT:    xori a0, a0, 1
; RV64ZBB-NEXT:    xori a1, a1, 1
; RV64ZBB-NEXT:    ret
  %1 = call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %a)
  %2 = icmp ugt <2 x i64> %1, <i64 1, i64 1>
  ret <2 x i1> %2
}

define <2 x i1> @ctpop_v2i64_eq_one(<2 x i64> %a) nounwind {
; RV64I-LABEL: ctpop_v2i64_eq_one:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi a2, a0, -1
; RV64I-NEXT:    addi a3, a1, -1
; RV64I-NEXT:    xor a1, a1, a3
; RV64I-NEXT:    xor a0, a0, a2
; RV64I-NEXT:    sltu a0, a2, a0
; RV64I-NEXT:    sltu a1, a3, a1
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: ctpop_v2i64_eq_one:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    cpop a1, a1
; RV64ZBB-NEXT:    cpop a0, a0
; RV64ZBB-NEXT:    addi a0, a0, -1
; RV64ZBB-NEXT:    addi a1, a1, -1
; RV64ZBB-NEXT:    seqz a0, a0
; RV64ZBB-NEXT:    seqz a1, a1
; RV64ZBB-NEXT:    ret
  %1 = call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %a)
  %2 = icmp eq <2 x i64> %1, <i64 1, i64 1>
  ret <2 x i1> %2
}

define <2 x i1> @ctpop_v2i64_ne_one(<2 x i64> %a) nounwind {
; RV64I-LABEL: ctpop_v2i64_ne_one:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi a2, a0, -1
; RV64I-NEXT:    addi a3, a1, -1
; RV64I-NEXT:    xor a1, a1, a3
; RV64I-NEXT:    xor a0, a0, a2
; RV64I-NEXT:    sltu a0, a2, a0
; RV64I-NEXT:    sltu a1, a3, a1
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    xori a1, a1, 1
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: ctpop_v2i64_ne_one:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    cpop a1, a1
; RV64ZBB-NEXT:    cpop a0, a0
; RV64ZBB-NEXT:    addi a0, a0, -1
; RV64ZBB-NEXT:    addi a1, a1, -1
; RV64ZBB-NEXT:    snez a0, a0
; RV64ZBB-NEXT:    snez a1, a1
; RV64ZBB-NEXT:    ret
  %1 = call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %a)
  %2 = icmp ne <2 x i64> %1, <i64 1, i64 1>
  ret <2 x i1> %2
}

define signext i32 @sextb_i32(i32 signext %a) nounwind {
; RV64I-LABEL: sextb_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slli a0, a0, 56
; RV64I-NEXT:    srai a0, a0, 56
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: sextb_i32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    sext.b a0, a0
; RV64ZBB-NEXT:    ret
  %shl = shl i32 %a, 24
  %shr = ashr exact i32 %shl, 24
  ret i32 %shr
}

define i64 @sextb_i64(i64 %a) nounwind {
; RV64I-LABEL: sextb_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slli a0, a0, 56
; RV64I-NEXT:    srai a0, a0, 56
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: sextb_i64:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    sext.b a0, a0
; RV64ZBB-NEXT:    ret
  %shl = shl i64 %a, 56
  %shr = ashr exact i64 %shl, 56
  ret i64 %shr
}

define signext i32 @sexth_i32(i32 signext %a) nounwind {
; RV64I-LABEL: sexth_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srai a0, a0, 48
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: sexth_i32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    sext.h a0, a0
; RV64ZBB-NEXT:    ret
  %shl = shl i32 %a, 16
  %shr = ashr exact i32 %shl, 16
  ret i32 %shr
}

define i64 @sexth_i64(i64 %a) nounwind {
; RV64I-LABEL: sexth_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srai a0, a0, 48
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: sexth_i64:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    sext.h a0, a0
; RV64ZBB-NEXT:    ret
  %shl = shl i64 %a, 48
  %shr = ashr exact i64 %shl, 48
  ret i64 %shr
}

define signext i32 @min_i32(i32 signext %a, i32 signext %b) nounwind {
; RV64I-LABEL: min_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    blt a0, a1, .LBB36_2
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:  .LBB36_2:
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: min_i32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    min a0, a0, a1
; RV64ZBB-NEXT:    ret
  %cmp = icmp slt i32 %a, %b
  %cond = select i1 %cmp, i32 %a, i32 %b
  ret i32 %cond
}

define i64 @min_i64(i64 %a, i64 %b) nounwind {
; RV64I-LABEL: min_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    blt a0, a1, .LBB37_2
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:  .LBB37_2:
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: min_i64:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    min a0, a0, a1
; RV64ZBB-NEXT:    ret
  %cmp = icmp slt i64 %a, %b
  %cond = select i1 %cmp, i64 %a, i64 %b
  ret i64 %cond
}

define signext i32 @max_i32(i32 signext %a, i32 signext %b) nounwind {
; RV64I-LABEL: max_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    blt a1, a0, .LBB38_2
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:  .LBB38_2:
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: max_i32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    max a0, a0, a1
; RV64ZBB-NEXT:    ret
  %cmp = icmp sgt i32 %a, %b
  %cond = select i1 %cmp, i32 %a, i32 %b
  ret i32 %cond
}

define i64 @max_i64(i64 %a, i64 %b) nounwind {
; RV64I-LABEL: max_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    blt a1, a0, .LBB39_2
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:  .LBB39_2:
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: max_i64:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    max a0, a0, a1
; RV64ZBB-NEXT:    ret
  %cmp = icmp sgt i64 %a, %b
  %cond = select i1 %cmp, i64 %a, i64 %b
  ret i64 %cond
}

define signext i32 @minu_i32(i32 signext %a, i32 signext %b) nounwind {
; RV64I-LABEL: minu_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    bltu a0, a1, .LBB40_2
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:  .LBB40_2:
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: minu_i32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    minu a0, a0, a1
; RV64ZBB-NEXT:    ret
  %cmp = icmp ult i32 %a, %b
  %cond = select i1 %cmp, i32 %a, i32 %b
  ret i32 %cond
}

define i64 @minu_i64(i64 %a, i64 %b) nounwind {
; RV64I-LABEL: minu_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    bltu a0, a1, .LBB41_2
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:  .LBB41_2:
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: minu_i64:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    minu a0, a0, a1
; RV64ZBB-NEXT:    ret
  %cmp = icmp ult i64 %a, %b
  %cond = select i1 %cmp, i64 %a, i64 %b
  ret i64 %cond
}

define signext i32 @maxu_i32(i32 signext %a, i32 signext %b) nounwind {
; RV64I-LABEL: maxu_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    bltu a1, a0, .LBB42_2
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:  .LBB42_2:
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: maxu_i32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    maxu a0, a0, a1
; RV64ZBB-NEXT:    ret
  %cmp = icmp ugt i32 %a, %b
  %cond = select i1 %cmp, i32 %a, i32 %b
  ret i32 %cond
}

define i64 @maxu_i64(i64 %a, i64 %b) nounwind {
; RV64I-LABEL: maxu_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    bltu a1, a0, .LBB43_2
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:  .LBB43_2:
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: maxu_i64:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    maxu a0, a0, a1
; RV64ZBB-NEXT:    ret
  %cmp = icmp ugt i64 %a, %b
  %cond = select i1 %cmp, i64 %a, i64 %b
  ret i64 %cond
}

declare i32 @llvm.abs.i32(i32, i1 immarg)

define i32 @abs_i32(i32 %x) {
; RV64I-LABEL: abs_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sraiw a1, a0, 31
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    subw a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: abs_i32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    sext.w a0, a0
; RV64ZBB-NEXT:    negw a1, a0
; RV64ZBB-NEXT:    max a0, a0, a1
; RV64ZBB-NEXT:    ret
  %abs = tail call i32 @llvm.abs.i32(i32 %x, i1 true)
  ret i32 %abs
}

define signext i32 @abs_i32_sext(i32 signext %x) {
; RV64I-LABEL: abs_i32_sext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sraiw a1, a0, 31
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    subw a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: abs_i32_sext:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    negw a1, a0
; RV64ZBB-NEXT:    max a0, a0, a1
; RV64ZBB-NEXT:    ret
  %abs = tail call i32 @llvm.abs.i32(i32 %x, i1 true)
  ret i32 %abs
}

declare i64 @llvm.abs.i64(i64, i1 immarg)

define i64 @abs_i64(i64 %x) {
; RV64I-LABEL: abs_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srai a1, a0, 63
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    sub a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: abs_i64:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    neg a1, a0
; RV64ZBB-NEXT:    max a0, a0, a1
; RV64ZBB-NEXT:    ret
  %abs = tail call i64 @llvm.abs.i64(i64 %x, i1 true)
  ret i64 %abs
}

define i32 @zexth_i32(i32 %a) nounwind {
; RV64I-LABEL: zexth_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: zexth_i32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    zext.h a0, a0
; RV64ZBB-NEXT:    ret
  %and = and i32 %a, 65535
  ret i32 %and
}

define i64 @zexth_i64(i64 %a) nounwind {
; RV64I-LABEL: zexth_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: zexth_i64:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    zext.h a0, a0
; RV64ZBB-NEXT:    ret
  %and = and i64 %a, 65535
  ret i64 %and
}

declare i32 @llvm.bswap.i32(i32)

define signext i32 @bswap_i32(i32 signext %a) nounwind {
; RV64I-LABEL: bswap_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srli a1, a0, 8
; RV64I-NEXT:    lui a2, 16
; RV64I-NEXT:    srliw a3, a0, 24
; RV64I-NEXT:    addi a2, a2, -256
; RV64I-NEXT:    and a1, a1, a2
; RV64I-NEXT:    and a2, a0, a2
; RV64I-NEXT:    or a1, a1, a3
; RV64I-NEXT:    slli a2, a2, 8
; RV64I-NEXT:    slliw a0, a0, 24
; RV64I-NEXT:    or a0, a0, a2
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: bswap_i32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    rev8 a0, a0
; RV64ZBB-NEXT:    srai a0, a0, 32
; RV64ZBB-NEXT:    ret
  %1 = tail call i32 @llvm.bswap.i32(i32 %a)
  ret i32 %1
}

; Similar to bswap_i32 but the result is not sign extended.
define void @bswap_i32_nosext(i32 signext %a, ptr %x) nounwind {
; RV64I-LABEL: bswap_i32_nosext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srli a2, a0, 8
; RV64I-NEXT:    lui a3, 16
; RV64I-NEXT:    srliw a4, a0, 24
; RV64I-NEXT:    addi a3, a3, -256
; RV64I-NEXT:    and a2, a2, a3
; RV64I-NEXT:    and a3, a0, a3
; RV64I-NEXT:    or a2, a2, a4
; RV64I-NEXT:    slli a3, a3, 8
; RV64I-NEXT:    slli a0, a0, 24
; RV64I-NEXT:    or a0, a0, a3
; RV64I-NEXT:    or a0, a0, a2
; RV64I-NEXT:    sw a0, 0(a1)
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: bswap_i32_nosext:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    rev8 a0, a0
; RV64ZBB-NEXT:    srli a0, a0, 32
; RV64ZBB-NEXT:    sw a0, 0(a1)
; RV64ZBB-NEXT:    ret
  %1 = tail call i32 @llvm.bswap.i32(i32 %a)
  store i32 %1, ptr %x
  ret void
}

declare i64 @llvm.bswap.i64(i64)

define i64 @bswap_i64(i64 %a) {
; RV64I-LABEL: bswap_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srli a1, a0, 40
; RV64I-NEXT:    lui a2, 16
; RV64I-NEXT:    srli a3, a0, 56
; RV64I-NEXT:    srli a4, a0, 24
; RV64I-NEXT:    lui a5, 4080
; RV64I-NEXT:    addi a2, a2, -256
; RV64I-NEXT:    and a1, a1, a2
; RV64I-NEXT:    or a1, a1, a3
; RV64I-NEXT:    srli a3, a0, 8
; RV64I-NEXT:    and a4, a4, a5
; RV64I-NEXT:    srliw a3, a3, 24
; RV64I-NEXT:    slli a3, a3, 24
; RV64I-NEXT:    or a3, a3, a4
; RV64I-NEXT:    srliw a4, a0, 24
; RV64I-NEXT:    and a5, a0, a5
; RV64I-NEXT:    and a2, a0, a2
; RV64I-NEXT:    slli a0, a0, 56
; RV64I-NEXT:    slli a4, a4, 32
; RV64I-NEXT:    slli a5, a5, 24
; RV64I-NEXT:    or a4, a5, a4
; RV64I-NEXT:    slli a2, a2, 40
; RV64I-NEXT:    or a1, a3, a1
; RV64I-NEXT:    or a0, a0, a2
; RV64I-NEXT:    or a0, a0, a4
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: bswap_i64:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    rev8 a0, a0
; RV64ZBB-NEXT:    ret
  %1 = call i64 @llvm.bswap.i64(i64 %a)
  ret i64 %1
}

define i16 @orc_b_i16(i16 %a) {
; RV64I-LABEL: orc_b_i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    andi a0, a0, 257
; RV64I-NEXT:    slli a1, a0, 8
; RV64I-NEXT:    sub a0, a1, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: orc_b_i16:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    andi a0, a0, 257
; RV64ZBB-NEXT:    orc.b a0, a0
; RV64ZBB-NEXT:    ret
  %1 = and i16 %a, 257
  %2 = mul nuw i16 %1, 255
  ret i16 %2
}

define i32 @orc_b_i32(i32 %a) {
; RV64I-LABEL: orc_b_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 4112
; RV64I-NEXT:    addi a1, a1, 257
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    slli a1, a0, 8
; RV64I-NEXT:    subw a0, a1, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: orc_b_i32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    lui a1, 4112
; RV64ZBB-NEXT:    addi a1, a1, 257
; RV64ZBB-NEXT:    and a0, a0, a1
; RV64ZBB-NEXT:    orc.b a0, a0
; RV64ZBB-NEXT:    ret
  %1 = and i32 %a, 16843009
  %2 = mul nuw i32 %1, 255
  ret i32 %2
}

define i64 @orc_b_i64(i64 %a) {
; RV64I-LABEL: orc_b_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 4112
; RV64I-NEXT:    addi a1, a1, 257
; RV64I-NEXT:    slli a2, a1, 32
; RV64I-NEXT:    add a1, a1, a2
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    slli a1, a0, 8
; RV64I-NEXT:    sub a0, a1, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: orc_b_i64:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    lui a1, 4112
; RV64ZBB-NEXT:    addi a1, a1, 257
; RV64ZBB-NEXT:    slli a2, a1, 32
; RV64ZBB-NEXT:    add a1, a1, a2
; RV64ZBB-NEXT:    and a0, a0, a1
; RV64ZBB-NEXT:    orc.b a0, a0
; RV64ZBB-NEXT:    ret
  %1 = and i64 %a, 72340172838076673
  %2 = mul nuw i64 %1, 255
  ret i64 %2
}

define i64 @srai_slli(i16 signext %0) {
; CHECK-LABEL: srai_slli:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slli a0, a0, 57
; CHECK-NEXT:    srai a0, a0, 63
; CHECK-NEXT:    ret
  %2 = shl i16 %0, 9
  %sext = ashr i16 %2, 15
  %3 = sext i16 %sext to i64
  ret i64 %3
}

define i64 @srai_slli2(i16 signext %0) {
; CHECK-LABEL: srai_slli2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slli a0, a0, 57
; CHECK-NEXT:    srai a0, a0, 62
; CHECK-NEXT:    ret
  %2 = shl i16 %0, 9
  %sext = ashr i16 %2, 14
  %3 = sext i16 %sext to i64
  ret i64 %3
}

define signext i32 @func0000000000000001(i32 signext %0, i8 signext %1) #0 {
; CHECK-LABEL: func0000000000000001:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    slli a1, a1, 59
; CHECK-NEXT:    srai a1, a1, 63
; CHECK-NEXT:    addw a0, a1, a0
; CHECK-NEXT:    ret
entry:
  %2 = shl i8 %1, 3
  %3 = ashr i8 %2, 7
  %4 = sext i8 %3 to i32
  %5 = add nsw i32 %4, %0
  ret i32 %5
}

define i1 @ctpop32_eq_one_nonzero(i32 %x) {
; RV64I-LABEL: ctpop32_eq_one_nonzero:
; RV64I:       # %bb.0: # %entry
; RV64I-NEXT:    addi a1, a0, -1
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    sext.w a0, a0
; RV64I-NEXT:    seqz a0, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: ctpop32_eq_one_nonzero:
; RV64ZBB:       # %bb.0: # %entry
; RV64ZBB-NEXT:    cpopw a0, a0
; RV64ZBB-NEXT:    sltiu a0, a0, 2
; RV64ZBB-NEXT:    ret
entry:
  %popcnt = call range(i32 1, 33) i32 @llvm.ctpop.i32(i32 %x)
  %cmp = icmp eq i32 %popcnt, 1
  ret i1 %cmp
}

define i1 @ctpop32_ne_one_nonzero(i32 %x) {
; RV64I-LABEL: ctpop32_ne_one_nonzero:
; RV64I:       # %bb.0: # %entry
; RV64I-NEXT:    addi a1, a0, -1
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    sext.w a0, a0
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: ctpop32_ne_one_nonzero:
; RV64ZBB:       # %bb.0: # %entry
; RV64ZBB-NEXT:    cpopw a0, a0
; RV64ZBB-NEXT:    sltiu a0, a0, 2
; RV64ZBB-NEXT:    xori a0, a0, 1
; RV64ZBB-NEXT:    ret
entry:
  %popcnt = tail call range(i32 1, 33) i32 @llvm.ctpop.i32(i32 %x)
  %cmp = icmp ne i32 %popcnt, 1
  ret i1 %cmp
}

define i1 @ctpop64_eq_one_nonzero(i64 %x) {
; RV64I-LABEL: ctpop64_eq_one_nonzero:
; RV64I:       # %bb.0: # %entry
; RV64I-NEXT:    addi a1, a0, -1
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    seqz a0, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: ctpop64_eq_one_nonzero:
; RV64ZBB:       # %bb.0: # %entry
; RV64ZBB-NEXT:    cpop a0, a0
; RV64ZBB-NEXT:    sltiu a0, a0, 2
; RV64ZBB-NEXT:    ret
entry:
  %popcnt = call range(i64 1, 65) i64 @llvm.ctpop.i64(i64 %x)
  %cmp = icmp eq i64 %popcnt, 1
  ret i1 %cmp
}

define i1 @ctpop32_eq_one_maybezero(i32 %x) {
; RV64I-LABEL: ctpop32_eq_one_maybezero:
; RV64I:       # %bb.0: # %entry
; RV64I-NEXT:    addiw a1, a0, -1
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    sext.w a0, a0
; RV64I-NEXT:    sltu a0, a1, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: ctpop32_eq_one_maybezero:
; RV64ZBB:       # %bb.0: # %entry
; RV64ZBB-NEXT:    cpopw a0, a0
; RV64ZBB-NEXT:    addi a0, a0, -1
; RV64ZBB-NEXT:    seqz a0, a0
; RV64ZBB-NEXT:    ret
entry:
  %popcnt = call range(i32 0, 16) i32 @llvm.ctpop.i32(i32 %x)
  %cmp = icmp eq i32 %popcnt, 1
  ret i1 %cmp
}

define i8 @sub_if_uge_i8(i8 %x, i8 %y) {
; RV64I-LABEL: sub_if_uge_i8:
; RV64I:       # %bb.0:
; RV64I-NEXT:    zext.b a2, a1
; RV64I-NEXT:    zext.b a3, a0
; RV64I-NEXT:    sltu a2, a3, a2
; RV64I-NEXT:    addi a2, a2, -1
; RV64I-NEXT:    and a1, a2, a1
; RV64I-NEXT:    sub a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: sub_if_uge_i8:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    zext.b a2, a0
; RV64ZBB-NEXT:    subw a0, a0, a1
; RV64ZBB-NEXT:    zext.b a0, a0
; RV64ZBB-NEXT:    minu a0, a2, a0
; RV64ZBB-NEXT:    ret
  %cmp = icmp ult i8 %x, %y
  %select = select i1 %cmp, i8 0, i8 %y
  %sub = sub nuw i8 %x, %select
  ret i8 %sub
}

define i16 @sub_if_uge_i16(i16 %x, i16 %y) {
; RV64I-LABEL: sub_if_uge_i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a2, 16
; RV64I-NEXT:    addi a2, a2, -1
; RV64I-NEXT:    and a3, a1, a2
; RV64I-NEXT:    and a2, a0, a2
; RV64I-NEXT:    sltu a2, a2, a3
; RV64I-NEXT:    addi a2, a2, -1
; RV64I-NEXT:    and a1, a2, a1
; RV64I-NEXT:    sub a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: sub_if_uge_i16:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    zext.h a2, a0
; RV64ZBB-NEXT:    subw a0, a0, a1
; RV64ZBB-NEXT:    zext.h a0, a0
; RV64ZBB-NEXT:    minu a0, a2, a0
; RV64ZBB-NEXT:    ret
  %cmp = icmp ult i16 %x, %y
  %select = select i1 %cmp, i16 0, i16 %y
  %sub = sub nuw i16 %x, %select
  ret i16 %sub
}

define i32 @sub_if_uge_i32(i32 %x, i32 %y) {
; RV64I-LABEL: sub_if_uge_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sext.w a2, a1
; RV64I-NEXT:    sext.w a3, a0
; RV64I-NEXT:    sltu a2, a3, a2
; RV64I-NEXT:    addi a2, a2, -1
; RV64I-NEXT:    and a1, a2, a1
; RV64I-NEXT:    subw a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: sub_if_uge_i32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    sext.w a2, a0
; RV64ZBB-NEXT:    subw a0, a0, a1
; RV64ZBB-NEXT:    minu a0, a2, a0
; RV64ZBB-NEXT:    ret
  %cmp = icmp ult i32 %x, %y
  %select = select i1 %cmp, i32 0, i32 %y
  %sub = sub nuw i32 %x, %select
  ret i32 %sub
}

define i64 @sub_if_uge_i64(i64 %x, i64 %y) {
; RV64I-LABEL: sub_if_uge_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltu a2, a0, a1
; RV64I-NEXT:    addi a2, a2, -1
; RV64I-NEXT:    and a1, a2, a1
; RV64I-NEXT:    sub a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: sub_if_uge_i64:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    sub a1, a0, a1
; RV64ZBB-NEXT:    minu a0, a0, a1
; RV64ZBB-NEXT:    ret
  %cmp = icmp ult i64 %x, %y
  %select = select i1 %cmp, i64 0, i64 %y
  %sub = sub nuw i64 %x, %select
  ret i64 %sub
}

define i128 @sub_if_uge_i128(i128 %x, i128 %y) {
; CHECK-LABEL: sub_if_uge_i128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    beq a1, a3, .LBB66_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    sltu a4, a1, a3
; CHECK-NEXT:    j .LBB66_3
; CHECK-NEXT:  .LBB66_2:
; CHECK-NEXT:    sltu a4, a0, a2
; CHECK-NEXT:  .LBB66_3:
; CHECK-NEXT:    addi a4, a4, -1
; CHECK-NEXT:    and a3, a4, a3
; CHECK-NEXT:    and a2, a4, a2
; CHECK-NEXT:    sltu a4, a0, a2
; CHECK-NEXT:    sub a1, a1, a3
; CHECK-NEXT:    sub a1, a1, a4
; CHECK-NEXT:    sub a0, a0, a2
; CHECK-NEXT:    ret
  %cmp = icmp ult i128 %x, %y
  %select = select i1 %cmp, i128 0, i128 %y
  %sub = sub nuw i128 %x, %select
  ret i128 %sub
}

define i32 @sub_if_uge_multiuse_select_i32(i32 %x, i32 %y) {
; CHECK-LABEL: sub_if_uge_multiuse_select_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sext.w a2, a1
; CHECK-NEXT:    sext.w a3, a0
; CHECK-NEXT:    sltu a2, a3, a2
; CHECK-NEXT:    addi a2, a2, -1
; CHECK-NEXT:    and a1, a2, a1
; CHECK-NEXT:    subw a0, a0, a1
; CHECK-NEXT:    sllw a0, a0, a1
; CHECK-NEXT:    ret
  %cmp = icmp ult i32 %x, %y
  %select = select i1 %cmp, i32 0, i32 %y
  %sub = sub nuw i32 %x, %select
  %shl = shl i32 %sub, %select
  ret i32 %shl
}

define i32 @sub_if_uge_multiuse_cmp_i32(i32 %x, i32 %y) {
; RV64I-LABEL: sub_if_uge_multiuse_cmp_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sext.w a2, a1
; RV64I-NEXT:    sext.w a3, a0
; RV64I-NEXT:    sltu a4, a3, a2
; RV64I-NEXT:    addi a4, a4, -1
; RV64I-NEXT:    and a1, a4, a1
; RV64I-NEXT:    subw a0, a0, a1
; RV64I-NEXT:    bltu a3, a2, .LBB68_2
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    li a1, 4
; RV64I-NEXT:    sllw a0, a0, a1
; RV64I-NEXT:    ret
; RV64I-NEXT:  .LBB68_2:
; RV64I-NEXT:    li a1, 2
; RV64I-NEXT:    sllw a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: sub_if_uge_multiuse_cmp_i32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    sext.w a2, a1
; RV64ZBB-NEXT:    sext.w a3, a0
; RV64ZBB-NEXT:    subw a0, a0, a1
; RV64ZBB-NEXT:    minu a0, a3, a0
; RV64ZBB-NEXT:    bltu a3, a2, .LBB68_2
; RV64ZBB-NEXT:  # %bb.1:
; RV64ZBB-NEXT:    li a1, 4
; RV64ZBB-NEXT:    sllw a0, a0, a1
; RV64ZBB-NEXT:    ret
; RV64ZBB-NEXT:  .LBB68_2:
; RV64ZBB-NEXT:    li a1, 2
; RV64ZBB-NEXT:    sllw a0, a0, a1
; RV64ZBB-NEXT:    ret
  %cmp = icmp ult i32 %x, %y
  %select = select i1 %cmp, i32 0, i32 %y
  %sub = sub nuw i32 %x, %select
  %select2 = select i1 %cmp, i32 2, i32 4
  %shl = shl i32 %sub, %select2
  ret i32 %shl
}

define i32 @sub_if_uge_multiuse_cmp_store_i32(i32 signext %x, i32 signext %y, ptr %z) {
; RV64I-LABEL: sub_if_uge_multiuse_cmp_store_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltu a3, a0, a1
; RV64I-NEXT:    xori a4, a3, 1
; RV64I-NEXT:    addi a3, a3, -1
; RV64I-NEXT:    and a1, a3, a1
; RV64I-NEXT:    subw a0, a0, a1
; RV64I-NEXT:    sw a4, 0(a2)
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: sub_if_uge_multiuse_cmp_store_i32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    sltu a3, a0, a1
; RV64ZBB-NEXT:    subw a1, a0, a1
; RV64ZBB-NEXT:    xori a3, a3, 1
; RV64ZBB-NEXT:    minu a0, a0, a1
; RV64ZBB-NEXT:    sw a3, 0(a2)
; RV64ZBB-NEXT:    ret
  %cmp = icmp uge i32 %x, %y
  %conv = zext i1 %cmp to i32
  store i32 %conv, ptr %z, align 4
  %select = select i1 %cmp, i32 %y, i32 0
  %sub = sub nuw i32 %x, %select
  ret i32 %sub
}

define i8 @sub_if_uge_C_i8(i8 zeroext %x) {
; RV64I-LABEL: sub_if_uge_C_i8:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltiu a1, a0, 13
; RV64I-NEXT:    addi a1, a1, -1
; RV64I-NEXT:    andi a1, a1, -13
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: sub_if_uge_C_i8:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    addi a1, a0, -13
; RV64ZBB-NEXT:    zext.b a1, a1
; RV64ZBB-NEXT:    minu a0, a1, a0
; RV64ZBB-NEXT:    ret
  %cmp = icmp ugt i8 %x, 12
  %sub = add i8 %x, -13
  %conv4 = select i1 %cmp, i8 %sub, i8 %x
  ret i8 %conv4
}

define i16 @sub_if_uge_C_i16(i16 zeroext %x) {
; RV64I-LABEL: sub_if_uge_C_i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltiu a1, a0, 251
; RV64I-NEXT:    addi a1, a1, -1
; RV64I-NEXT:    andi a1, a1, -251
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: sub_if_uge_C_i16:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    addi a1, a0, -251
; RV64ZBB-NEXT:    zext.h a1, a1
; RV64ZBB-NEXT:    minu a0, a1, a0
; RV64ZBB-NEXT:    ret
  %cmp = icmp ugt i16 %x, 250
  %sub = add i16 %x, -251
  %conv4 = select i1 %cmp, i16 %sub, i16 %x
  ret i16 %conv4
}

define i32 @sub_if_uge_C_i32(i32 signext %x) {
; RV64I-LABEL: sub_if_uge_C_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 16
; RV64I-NEXT:    lui a2, 1048560
; RV64I-NEXT:    addi a1, a1, -16
; RV64I-NEXT:    sltu a1, a1, a0
; RV64I-NEXT:    negw a1, a1
; RV64I-NEXT:    addi a2, a2, 15
; RV64I-NEXT:    and a1, a1, a2
; RV64I-NEXT:    addw a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: sub_if_uge_C_i32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    lui a1, 1048560
; RV64ZBB-NEXT:    addi a1, a1, 15
; RV64ZBB-NEXT:    addw a1, a0, a1
; RV64ZBB-NEXT:    minu a0, a1, a0
; RV64ZBB-NEXT:    ret
  %cmp = icmp ugt i32 %x, 65520
  %sub = add i32 %x, -65521
  %cond = select i1 %cmp, i32 %sub, i32 %x
  ret i32 %cond
}

define i64 @sub_if_uge_C_i64(i64 %x) {
; RV64I-LABEL: sub_if_uge_C_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 298
; RV64I-NEXT:    lui a2, 1046192
; RV64I-NEXT:    addi a1, a1, 95
; RV64I-NEXT:    addi a2, a2, -761
; RV64I-NEXT:    slli a1, a1, 12
; RV64I-NEXT:    addi a1, a1, 511
; RV64I-NEXT:    sltu a1, a1, a0
; RV64I-NEXT:    neg a1, a1
; RV64I-NEXT:    slli a2, a2, 9
; RV64I-NEXT:    and a1, a1, a2
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: sub_if_uge_C_i64:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    lui a1, 1046192
; RV64ZBB-NEXT:    addi a1, a1, -761
; RV64ZBB-NEXT:    slli a1, a1, 9
; RV64ZBB-NEXT:    add a1, a0, a1
; RV64ZBB-NEXT:    minu a0, a1, a0
; RV64ZBB-NEXT:    ret
  %cmp = icmp ugt i64 %x, 4999999999
  %sub = add i64 %x, -5000000000
  %cond = select i1 %cmp, i64 %sub, i64 %x
  ret i64 %cond
}

define i32 @sub_if_uge_C_multiuse_cmp_i32(i32 signext %x, ptr %z) {
; RV64I-LABEL: sub_if_uge_C_multiuse_cmp_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a2, 16
; RV64I-NEXT:    lui a3, 1048560
; RV64I-NEXT:    addi a2, a2, -16
; RV64I-NEXT:    sltu a2, a2, a0
; RV64I-NEXT:    negw a4, a2
; RV64I-NEXT:    addi a3, a3, 15
; RV64I-NEXT:    and a3, a4, a3
; RV64I-NEXT:    addw a0, a0, a3
; RV64I-NEXT:    sw a2, 0(a1)
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: sub_if_uge_C_multiuse_cmp_i32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    lui a2, 16
; RV64ZBB-NEXT:    lui a3, 1048560
; RV64ZBB-NEXT:    addi a2, a2, -16
; RV64ZBB-NEXT:    addi a3, a3, 15
; RV64ZBB-NEXT:    sltu a2, a2, a0
; RV64ZBB-NEXT:    addw a3, a0, a3
; RV64ZBB-NEXT:    minu a0, a3, a0
; RV64ZBB-NEXT:    sw a2, 0(a1)
; RV64ZBB-NEXT:    ret
  %cmp = icmp ugt i32 %x, 65520
  %conv = zext i1 %cmp to i32
  store i32 %conv, ptr %z, align 4
  %sub = add i32 %x, -65521
  %cond = select i1 %cmp, i32 %sub, i32 %x
  ret i32 %cond
}

define i32 @sub_if_uge_C_multiuse_sub_i32(i32 signext %x, ptr %z) {
; RV64I-LABEL: sub_if_uge_C_multiuse_sub_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a2, 1048560
; RV64I-NEXT:    lui a3, 16
; RV64I-NEXT:    addi a2, a2, 15
; RV64I-NEXT:    addw a2, a0, a2
; RV64I-NEXT:    addi a3, a3, -16
; RV64I-NEXT:    sw a2, 0(a1)
; RV64I-NEXT:    bltu a3, a0, .LBB75_2
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    mv a2, a0
; RV64I-NEXT:  .LBB75_2:
; RV64I-NEXT:    mv a0, a2
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: sub_if_uge_C_multiuse_sub_i32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    lui a2, 1048560
; RV64ZBB-NEXT:    addi a2, a2, 15
; RV64ZBB-NEXT:    addw a2, a0, a2
; RV64ZBB-NEXT:    minu a0, a2, a0
; RV64ZBB-NEXT:    sw a2, 0(a1)
; RV64ZBB-NEXT:    ret
  %sub = add i32 %x, -65521
  store i32 %sub, ptr %z, align 4
  %cmp = icmp ugt i32 %x, 65520
  %cond = select i1 %cmp, i32 %sub, i32 %x
  ret i32 %cond
}

define i32 @sub_if_uge_C_swapped_i32(i32 signext %x) {
; RV64I-LABEL: sub_if_uge_C_swapped_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 16
; RV64I-NEXT:    lui a2, 1048560
; RV64I-NEXT:    addi a1, a1, -15
; RV64I-NEXT:    sltu a1, a0, a1
; RV64I-NEXT:    addi a1, a1, -1
; RV64I-NEXT:    addi a2, a2, 15
; RV64I-NEXT:    and a1, a1, a2
; RV64I-NEXT:    addw a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: sub_if_uge_C_swapped_i32:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    lui a1, 1048560
; RV64ZBB-NEXT:    addi a1, a1, 15
; RV64ZBB-NEXT:    addw a1, a0, a1
; RV64ZBB-NEXT:    minu a0, a0, a1
; RV64ZBB-NEXT:    ret
  %cmp = icmp ult i32 %x, 65521
  %sub = add i32 %x, -65521
  %cond = select i1 %cmp, i32 %x, i32 %sub
  ret i32 %cond
}

define i7 @sub_if_uge_C_nsw_i7(i7 %a) {
; RV64I-LABEL: sub_if_uge_C_nsw_i7:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ori a0, a0, 51
; RV64I-NEXT:    andi a1, a0, 127
; RV64I-NEXT:    sltiu a1, a1, 111
; RV64I-NEXT:    addi a1, a1, -1
; RV64I-NEXT:    andi a1, a1, 17
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: sub_if_uge_C_nsw_i7:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    ori a0, a0, 51
; RV64ZBB-NEXT:    andi a1, a0, 127
; RV64ZBB-NEXT:    addi a0, a0, 17
; RV64ZBB-NEXT:    andi a0, a0, 92
; RV64ZBB-NEXT:    minu a0, a0, a1
; RV64ZBB-NEXT:    ret
  %x = or i7 %a, 51
  %c = icmp ugt i7 %x, -18
  %add = add nsw i7 %x, 17
  %s = select i1 %c, i7 %add, i7 %x
  ret i7 %s
}

define i7 @sub_if_uge_C_swapped_nsw_i7(i7 %a) {
; RV64I-LABEL: sub_if_uge_C_swapped_nsw_i7:
; RV64I:       # %bb.0:
; RV64I-NEXT:    ori a0, a0, 51
; RV64I-NEXT:    andi a1, a0, 127
; RV64I-NEXT:    sltiu a1, a1, 111
; RV64I-NEXT:    addi a1, a1, -1
; RV64I-NEXT:    andi a1, a1, 17
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBB-LABEL: sub_if_uge_C_swapped_nsw_i7:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    ori a0, a0, 51
; RV64ZBB-NEXT:    andi a1, a0, 127
; RV64ZBB-NEXT:    addi a0, a0, 17
; RV64ZBB-NEXT:    andi a0, a0, 92
; RV64ZBB-NEXT:    minu a0, a1, a0
; RV64ZBB-NEXT:    ret
  %x = or i7 %a, 51
  %c = icmp ult i7 %x, -17
  %add = add nsw i7 %x, 17
  %s = select i1 %c, i7 %x, i7 %add
  ret i7 %s
}
