; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 < %s | FileCheck -check-prefixes=GFX9,GFX900 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx90a < %s | FileCheck -check-prefixes=GFX9,GFX90APLUS,GFX90A %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx942 < %s | FileCheck -check-prefixes=GFX9,GFX90APLUS,GFX942 %s


define void @v_shuffle_v4bf16_v3bf16__u_u_u_u(ptr addrspace(1) inreg %ptr) {
; GFX9-LABEL: v_shuffle_v4bf16_v3bf16__u_u_u_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> poison
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__0_u_u_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__0_u_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__0_u_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__0_u_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 0, i32 poison, i32 poison, i32 poison>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__1_u_u_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__1_u_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    v_alignbit_b32 v0, s4, v0, 16
; GFX900-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__1_u_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_alignbit_b32 v0, s4, v0, 16
; GFX90A-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__1_u_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    v_alignbit_b32 v0, s0, v0, 16
; GFX942-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 1, i32 poison, i32 poison, i32 poison>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__2_u_u_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__2_u_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v1
; GFX900-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__2_u_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__2_u_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v1
; GFX942-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 2, i32 poison, i32 poison, i32 poison>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__3_u_u_u(ptr addrspace(1) inreg %ptr) {
; GFX9-LABEL: v_shuffle_v4bf16_v3bf16__3_u_u_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 3, i32 poison, i32 poison, i32 poison>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__4_u_u_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__4_u_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    v_alignbit_b32 v0, s4, v0, 16
; GFX900-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__4_u_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_alignbit_b32 v0, s4, v0, 16
; GFX90A-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__4_u_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    v_alignbit_b32 v0, s0, v0, 16
; GFX942-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 4, i32 poison, i32 poison, i32 poison>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_u_u_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_u_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v1
; GFX900-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_u_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_u_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v1
; GFX942-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 poison, i32 poison, i32 poison>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_0_u_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_0_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_perm_b32 v0, v0, v2, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_0_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v0, v0, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_0_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v0, v0, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 0, i32 poison, i32 poison>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_1_u_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_1_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0xffff
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_bfi_b32 v0, s4, v2, v0
; GFX900-NEXT:    global_store_dwordx2 v3, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_1_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_bfi_b32 v0, s4, v3, v0
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_1_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0xffff
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_bfi_b32 v0, s2, v3, v0
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 1, i32 poison, i32 poison>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_2_u_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_2_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_perm_b32 v0, v1, v3, s4
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_2_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v0, v1, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_2_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v0, v1, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 2, i32 poison, i32 poison>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_3_u_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_3_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    v_perm_b32 v0, v0, v1, s4
; GFX900-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_3_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_perm_b32 v0, v0, v1, s4
; GFX90A-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_3_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    v_perm_b32 v0, v0, v1, s2
; GFX942-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 3, i32 poison, i32 poison>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_4_u_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_4_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0xffff
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    v_bfi_b32 v0, s4, v1, v0
; GFX900-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_4_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_bfi_b32 v0, s4, v1, v0
; GFX90A-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_4_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0xffff
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    v_bfi_b32 v0, s2, v1, v0
; GFX942-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 4, i32 poison, i32 poison>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_u_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    v_perm_b32 v0, v1, v1, s4
; GFX900-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_perm_b32 v0, v1, v1, s4
; GFX90A-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    v_perm_b32 v0, v1, v1, s2
; GFX942-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 poison, i32 poison>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_0_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_0_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v1, v2, v2, s4
; GFX900-NEXT:    v_mov_b32_e32 v2, v0
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_0_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v2, v3, v3, s4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v0
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_0_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_perm_b32 v2, v3, v3, s2
; GFX942-NEXT:    v_mov_b32_e32 v3, v0
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 0, i32 poison>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_1_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_1_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_alignbit_b32 v1, s4, v0, 16
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v0, v2, v2, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_1_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_alignbit_b32 v1, s4, v0, 16
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_1_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_alignbit_b32 v1, s0, v0, 16
; GFX942-NEXT:    v_perm_b32 v0, v3, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 1, i32 poison>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_2_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_2_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_2_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_2_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v0, v3, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 2, i32 poison>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_3_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_3_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX900-NEXT:    v_mov_b32_e32 v2, v0
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_3_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v2, v1, v1, s4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v0
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_3_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v2, v1, v1, s2
; GFX942-NEXT:    v_mov_b32_e32 v3, v0
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 3, i32 poison>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_4_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_4_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_alignbit_b32 v2, s4, v0, 16
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_4_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_alignbit_b32 v3, s4, v0, 16
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_perm_b32 v2, v1, v1, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_4_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_alignbit_b32 v3, s0, v0, 16
; GFX942-NEXT:    v_perm_b32 v2, v1, v1, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 4, i32 poison>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_5_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_5_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    v_perm_b32 v0, v1, v1, s4
; GFX900-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_5_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_perm_b32 v0, v1, v1, s4
; GFX90A-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_5_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    v_perm_b32 v0, v1, v1, s2
; GFX942-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 5, i32 poison>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_5_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_5_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v1, v0, v2, s4
; GFX900-NEXT:    v_perm_b32 v0, v2, v2, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_5_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v1, v0, v3, s4
; GFX90A-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_5_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v1, v0, v3, s2
; GFX942-NEXT:    v_perm_b32 v0, v3, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 5, i32 0>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_5_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_5_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0xffff
; GFX900-NEXT:    v_bfi_b32 v1, s4, v2, v0
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v0, v2, v2, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_5_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_bfi_b32 v1, s4, v3, v0
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_5_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0xffff
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_bfi_b32 v1, s2, v3, v0
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_perm_b32 v0, v3, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 5, i32 1>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_5_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_5_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_perm_b32 v1, v1, v3, s4
; GFX900-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_5_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v1, v1, v3, s4
; GFX90A-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_5_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v1, v1, v3, s2
; GFX942-NEXT:    v_perm_b32 v0, v3, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 5, i32 2>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_5_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_5_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v2, v0, v1, s4
; GFX900-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_5_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v3, v0, v1, s4
; GFX90A-NEXT:    v_perm_b32 v2, v1, v1, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_5_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v3, v0, v1, s2
; GFX942-NEXT:    v_perm_b32 v2, v1, v1, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 5, i32 3>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_5_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_5_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_mov_b32 s4, 0xffff
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_bfi_b32 v2, s4, v1, v0
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_5_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_bfi_b32 v3, s4, v1, v0
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_perm_b32 v2, v1, v1, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_5_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_mov_b32 s2, 0xffff
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_bfi_b32 v3, s2, v1, v0
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_perm_b32 v2, v1, v1, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 5, i32 4>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_5_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_perm_b32 v0, v1, v1, s4
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v0
; GFX900-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_perm_b32 v0, v1, v1, s4
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v0
; GFX90A-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_perm_b32 v0, v1, v1, s2
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v0
; GFX942-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 5, i32 5>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__u_0_0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__u_0_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    v_perm_b32 v1, v0, v0, s4
; GFX900-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX900-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__u_0_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_perm_b32 v1, v0, v0, s4
; GFX90A-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX90A-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__u_0_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    v_perm_b32 v1, v0, v0, s2
; GFX942-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX942-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 poison, i32 0, i32 0, i32 0>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__0_0_0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__0_0_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_perm_b32 v0, v0, v0, s4
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v0
; GFX900-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__0_0_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_perm_b32 v0, v0, v0, s4
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v0
; GFX90A-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__0_0_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_perm_b32 v0, v0, v0, s2
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v0
; GFX942-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> zeroinitializer
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__1_0_0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__1_0_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    v_perm_b32 v1, v0, v0, s4
; GFX900-NEXT:    v_alignbit_b32 v0, v0, v0, 16
; GFX900-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__1_0_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_perm_b32 v1, v0, v0, s4
; GFX90A-NEXT:    v_alignbit_b32 v0, v0, v0, 16
; GFX90A-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__1_0_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    v_perm_b32 v1, v0, v0, s2
; GFX942-NEXT:    v_alignbit_b32 v0, v0, v0, 16
; GFX942-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 1, i32 0, i32 0, i32 0>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__2_0_0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__2_0_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v1, v0, v1, s4
; GFX900-NEXT:    v_perm_b32 v2, v0, v0, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__2_0_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v2, v0, v1, s4
; GFX90A-NEXT:    v_perm_b32 v3, v0, v0, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__2_0_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v2, v0, v1, s2
; GFX942-NEXT:    v_perm_b32 v3, v0, v0, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 2, i32 0, i32 0, i32 0>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__3_0_0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__3_0_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    v_perm_b32 v1, v0, v0, s4
; GFX900-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX900-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__3_0_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_perm_b32 v1, v0, v0, s4
; GFX90A-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX90A-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__3_0_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    v_perm_b32 v1, v0, v0, s2
; GFX942-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX942-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 3, i32 0, i32 0, i32 0>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__4_0_0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__4_0_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v2, v0, v0, s4
; GFX900-NEXT:    v_alignbit_b32 v1, v0, v1, 16
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__4_0_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v1, v0, v0, s4
; GFX90A-NEXT:    v_alignbit_b32 v0, v0, v2, 16
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__4_0_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_perm_b32 v1, v0, v0, s2
; GFX942-NEXT:    v_alignbit_b32 v0, v0, v2, 16
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 4, i32 0, i32 0, i32 0>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_0_0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_0_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v1, v0, v2, s4
; GFX900-NEXT:    v_perm_b32 v2, v0, v0, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_0_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v2, v0, v3, s4
; GFX90A-NEXT:    v_perm_b32 v3, v0, v0, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_0_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v2, v0, v3, s2
; GFX942-NEXT:    v_perm_b32 v3, v0, v0, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 0, i32 0, i32 0>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_u_0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_u_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v1, v0, v0, s4
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    global_store_dwordx2 v3, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_u_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v1, v0, v0, s4
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_u_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_perm_b32 v1, v0, v0, s2
; GFX942-NEXT:    v_mov_b32_e32 v0, v3
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 poison, i32 0, i32 0>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_1_0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_1_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0xffff
; GFX900-NEXT:    v_bfi_b32 v1, s4, v2, v0
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v2, v0, v0, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_1_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_bfi_b32 v2, s4, v3, v0
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_perm_b32 v3, v0, v0, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_1_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0xffff
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_bfi_b32 v2, s2, v3, v0
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_perm_b32 v3, v0, v0, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 1, i32 0, i32 0>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_2_0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_2_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_perm_b32 v1, v1, v3, s4
; GFX900-NEXT:    v_perm_b32 v2, v0, v0, s4
; GFX900-NEXT:    global_store_dwordx2 v4, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_2_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v2, v1, v3, s4
; GFX90A-NEXT:    v_perm_b32 v3, v0, v0, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_2_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v2, v1, v3, s2
; GFX942-NEXT:    v_perm_b32 v3, v0, v0, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 2, i32 0, i32 0>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_3_0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_3_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v1, v1, v2, s4
; GFX900-NEXT:    v_perm_b32 v2, v0, v0, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_3_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v2, v2, v3, s4
; GFX90A-NEXT:    v_perm_b32 v3, v0, v0, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_3_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_perm_b32 v2, v2, v3, s2
; GFX942-NEXT:    v_perm_b32 v3, v0, v0, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 3, i32 0, i32 0>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_4_0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_4_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0xffff
; GFX900-NEXT:    v_bfi_b32 v1, s4, v2, v1
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v2, v0, v0, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_4_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_bfi_b32 v2, s4, v3, v2
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v3, v0, v0, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_4_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0xffff
; GFX942-NEXT:    v_bfi_b32 v2, s2, v3, v2
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v3, v0, v0, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 4, i32 0, i32 0>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v1, v0, v0, s4
; GFX900-NEXT:    v_perm_b32 v0, v2, v2, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v1, v0, v0, s4
; GFX90A-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_perm_b32 v1, v0, v0, s2
; GFX942-NEXT:    v_perm_b32 v0, v3, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 0, i32 0>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_u_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_u_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v1, v2, v2, s4
; GFX900-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_u_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v2, v3, v3, s4
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_u_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_perm_b32 v2, v3, v3, s2
; GFX942-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 poison, i32 0>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_1_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_1_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_alignbit_b32 v1, v0, v0, 16
; GFX900-NEXT:    v_perm_b32 v0, v2, v2, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_1_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_alignbit_b32 v1, v0, v0, 16
; GFX90A-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_1_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_alignbit_b32 v1, v0, v0, 16
; GFX942-NEXT:    v_perm_b32 v0, v3, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 1, i32 0>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_2_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_2_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_perm_b32 v1, v0, v1, s4
; GFX900-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_2_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v1, v0, v1, s4
; GFX90A-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_2_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_perm_b32 v1, v0, v1, s2
; GFX942-NEXT:    v_perm_b32 v0, v3, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 2, i32 0>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_3_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_3_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v1, v0, v1, s4
; GFX900-NEXT:    v_perm_b32 v0, v2, v2, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_3_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v1, v0, v2, s4
; GFX90A-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_3_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v1, v0, v2, s2
; GFX942-NEXT:    v_perm_b32 v0, v3, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 3, i32 0>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_4_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_4_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_alignbit_b32 v1, v0, v1, 16
; GFX900-NEXT:    v_perm_b32 v0, v2, v2, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_4_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_alignbit_b32 v1, v0, v2, 16
; GFX90A-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_4_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_alignbit_b32 v1, v0, v2, 16
; GFX942-NEXT:    v_perm_b32 v0, v3, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 4, i32 0>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__u_1_1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__u_1_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x7060302
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    v_perm_b32 v1, v0, v0, s4
; GFX900-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__u_1_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x7060302
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_perm_b32 v1, v0, v0, s4
; GFX90A-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__u_1_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x7060302
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    v_perm_b32 v1, v0, v0, s2
; GFX942-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 poison, i32 1, i32 1, i32 1>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__0_1_1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__0_1_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x7060302
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    v_perm_b32 v1, v0, v0, s4
; GFX900-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__0_1_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x7060302
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_perm_b32 v1, v0, v0, s4
; GFX90A-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__0_1_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x7060302
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    v_perm_b32 v1, v0, v0, s2
; GFX942-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 0, i32 1, i32 1, i32 1>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__1_1_1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__1_1_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x7060302
; GFX900-NEXT:    v_perm_b32 v0, v0, v0, s4
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v0
; GFX900-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__1_1_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x7060302
; GFX90A-NEXT:    v_perm_b32 v0, v0, v0, s4
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v0
; GFX90A-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__1_1_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x7060302
; GFX942-NEXT:    v_perm_b32 v0, v0, v0, s2
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v0
; GFX942-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 1, i32 1, i32 1, i32 1>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__2_1_1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__2_1_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0xffff
; GFX900-NEXT:    v_bfi_b32 v1, s4, v1, v0
; GFX900-NEXT:    s_mov_b32 s4, 0x7060302
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v2, v0, v0, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__2_1_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_bfi_b32 v2, s4, v1, v0
; GFX90A-NEXT:    s_mov_b32 s4, 0x7060302
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_perm_b32 v3, v0, v0, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__2_1_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_mov_b32 s2, 0xffff
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_bfi_b32 v2, s2, v1, v0
; GFX942-NEXT:    s_mov_b32 s2, 0x7060302
; GFX942-NEXT:    v_perm_b32 v3, v0, v0, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 2, i32 1, i32 1, i32 1>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__3_1_1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__3_1_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x7060302
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    v_perm_b32 v1, v0, v0, s4
; GFX900-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__3_1_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x7060302
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_perm_b32 v1, v0, v0, s4
; GFX90A-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__3_1_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x7060302
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    v_perm_b32 v1, v0, v0, s2
; GFX942-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 3, i32 1, i32 1, i32 1>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__4_1_1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__4_1_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x7060302
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v1, v0, v1, s4
; GFX900-NEXT:    v_perm_b32 v2, v0, v0, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__4_1_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x7060302
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v2, v0, v2, s4
; GFX90A-NEXT:    v_perm_b32 v3, v0, v0, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__4_1_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x7060302
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v2, v0, v2, s2
; GFX942-NEXT:    v_perm_b32 v3, v0, v0, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 4, i32 1, i32 1, i32 1>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_1_1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_1_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0xffff
; GFX900-NEXT:    v_bfi_b32 v1, s4, v2, v0
; GFX900-NEXT:    s_mov_b32 s4, 0x7060302
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v2, v0, v0, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_1_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_bfi_b32 v2, s4, v3, v0
; GFX90A-NEXT:    s_mov_b32 s4, 0x7060302
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_perm_b32 v3, v0, v0, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_1_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0xffff
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_bfi_b32 v2, s2, v3, v0
; GFX942-NEXT:    s_mov_b32 s2, 0x7060302
; GFX942-NEXT:    v_perm_b32 v3, v0, v0, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 1, i32 1, i32 1>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_u_1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_u_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x7060302
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v1, v0, v0, s4
; GFX900-NEXT:    v_mov_b32_e32 v0, v2
; GFX900-NEXT:    global_store_dwordx2 v3, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_u_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x7060302
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v1, v0, v0, s4
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_u_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x7060302
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_perm_b32 v1, v0, v0, s2
; GFX942-NEXT:    v_mov_b32_e32 v0, v3
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 poison, i32 1, i32 1>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_0_1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_0_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_perm_b32 v1, v0, v2, s4
; GFX900-NEXT:    s_mov_b32 s4, 0x7060302
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v2, v0, v0, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_0_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v2, v0, v3, s4
; GFX90A-NEXT:    s_mov_b32 s4, 0x7060302
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_perm_b32 v3, v0, v0, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_0_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_perm_b32 v2, v0, v3, s2
; GFX942-NEXT:    s_mov_b32 s2, 0x7060302
; GFX942-NEXT:    v_perm_b32 v3, v0, v0, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 0, i32 1, i32 1>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_2_1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_2_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_perm_b32 v1, v1, v3, s4
; GFX900-NEXT:    s_mov_b32 s4, 0x7060302
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_perm_b32 v2, v0, v0, s4
; GFX900-NEXT:    global_store_dwordx2 v4, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_2_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v2, v1, v3, s4
; GFX90A-NEXT:    s_mov_b32 s4, 0x7060302
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_perm_b32 v3, v0, v0, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_2_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_perm_b32 v2, v1, v3, s2
; GFX942-NEXT:    s_mov_b32 s2, 0x7060302
; GFX942-NEXT:    v_perm_b32 v3, v0, v0, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 2, i32 1, i32 1>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_3_1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_3_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_perm_b32 v1, v1, v2, s4
; GFX900-NEXT:    s_mov_b32 s4, 0x7060302
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v2, v0, v0, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_3_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_perm_b32 v2, v2, v3, s4
; GFX90A-NEXT:    s_mov_b32 s4, 0x7060302
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v3, v0, v0, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_3_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_perm_b32 v2, v2, v3, s2
; GFX942-NEXT:    s_mov_b32 s2, 0x7060302
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v3, v0, v0, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 3, i32 1, i32 1>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_4_1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_4_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0xffff
; GFX900-NEXT:    v_bfi_b32 v1, s4, v2, v1
; GFX900-NEXT:    s_mov_b32 s4, 0x7060302
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v2, v0, v0, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_4_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_bfi_b32 v2, s4, v3, v2
; GFX90A-NEXT:    s_mov_b32 s4, 0x7060302
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v3, v0, v0, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_4_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0xffff
; GFX942-NEXT:    v_bfi_b32 v2, s2, v3, v2
; GFX942-NEXT:    s_mov_b32 s2, 0x7060302
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v3, v0, v0, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 4, i32 1, i32 1>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x7060302
; GFX900-NEXT:    v_perm_b32 v1, v0, v0, s4
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v0, v2, v2, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x7060302
; GFX90A-NEXT:    v_perm_b32 v1, v0, v0, s4
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x7060302
; GFX942-NEXT:    v_perm_b32 v1, v0, v0, s2
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v0, v3, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 1, i32 1>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_u_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_u_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v1, v2, v2, s4
; GFX900-NEXT:    v_mov_b32_e32 v2, v0
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_u_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v2, v3, v3, s4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v0
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_u_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_perm_b32 v2, v3, v3, s2
; GFX942-NEXT:    v_mov_b32_e32 v3, v0
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 poison, i32 1>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_0_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_0_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v1, v2, v2, s4
; GFX900-NEXT:    v_mov_b32_e32 v2, v0
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_0_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v2, v3, v3, s4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v0
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_0_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_perm_b32 v2, v3, v3, s2
; GFX942-NEXT:    v_mov_b32_e32 v3, v0
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 0, i32 1>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_2_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_2_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0xffff
; GFX900-NEXT:    v_bfi_b32 v1, s4, v1, v0
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_2_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_bfi_b32 v1, s4, v1, v0
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_2_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0xffff
; GFX942-NEXT:    v_bfi_b32 v1, s2, v1, v0
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v0, v3, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 2, i32 1>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_3_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_3_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0xffff
; GFX900-NEXT:    v_bfi_b32 v1, s4, v1, v0
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v0, v2, v2, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_3_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_bfi_b32 v1, s4, v2, v0
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_3_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0xffff
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_bfi_b32 v1, s2, v2, v0
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_perm_b32 v0, v3, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 3, i32 1>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_4_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_4_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x7060302
; GFX900-NEXT:    v_perm_b32 v1, v0, v1, s4
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v0, v2, v2, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_4_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x7060302
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v1, v0, v2, s4
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_4_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x7060302
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_perm_b32 v1, v0, v2, s2
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_perm_b32 v0, v3, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 4, i32 1>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__u_2_2_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__u_2_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v2, v1, v1, s4
; GFX900-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__u_2_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v3, v1, v1, s4
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__u_2_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v3, v1, v1, s2
; GFX942-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 poison, i32 2, i32 2, i32 2>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__0_2_2_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__0_2_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX900-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX900-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__0_2_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX90A-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX90A-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__0_2_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    v_perm_b32 v0, v1, v0, s2
; GFX942-NEXT:    v_perm_b32 v1, v1, v1, s2
; GFX942-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 0, i32 2, i32 2, i32 2>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__1_2_2_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__1_2_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v2, v1, v1, s4
; GFX900-NEXT:    v_alignbit_b32 v1, v1, v0, 16
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__1_2_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v3, v1, v1, s4
; GFX90A-NEXT:    v_alignbit_b32 v2, v1, v0, 16
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__1_2_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v3, v1, v1, s2
; GFX942-NEXT:    v_alignbit_b32 v2, v1, v0, 16
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 1, i32 2, i32 2, i32 2>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__2_2_2_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__2_2_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_perm_b32 v0, v1, v1, s4
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v0
; GFX900-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__2_2_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_perm_b32 v0, v1, v1, s4
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v0
; GFX90A-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__2_2_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_perm_b32 v0, v1, v1, s2
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v0
; GFX942-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 2, i32 2, i32 2, i32 2>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__3_2_2_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__3_2_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v2, v1, v1, s4
; GFX900-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__3_2_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v3, v1, v1, s4
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__3_2_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v3, v1, v1, s2
; GFX942-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 3, i32 2, i32 2, i32 2>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__4_2_2_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__4_2_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_perm_b32 v3, v1, v1, s4
; GFX900-NEXT:    v_alignbit_b32 v2, v1, v2, 16
; GFX900-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__4_2_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v3, v1, v1, s4
; GFX90A-NEXT:    v_alignbit_b32 v2, v1, v2, 16
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__4_2_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v3, v1, v1, s2
; GFX942-NEXT:    v_alignbit_b32 v2, v1, v2, 16
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 4, i32 2, i32 2, i32 2>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_2_2_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_2_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_perm_b32 v0, v1, v3, s4
; GFX900-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_2_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v0, v1, v3, s4
; GFX90A-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_2_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v0, v1, v3, s2
; GFX942-NEXT:    v_perm_b32 v1, v1, v1, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 2, i32 2, i32 2>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_u_2_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_u_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX900-NEXT:    v_mov_b32_e32 v0, v3
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_u_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX90A-NEXT:    v_mov_b32_e32 v0, v3
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_u_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_perm_b32 v1, v1, v1, s2
; GFX942-NEXT:    v_mov_b32_e32 v0, v3
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 poison, i32 2, i32 2>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_0_2_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_0_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_perm_b32 v0, v0, v3, s4
; GFX900-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_0_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v0, v0, v3, s4
; GFX90A-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_0_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_perm_b32 v1, v1, v1, s2
; GFX942-NEXT:    v_perm_b32 v0, v0, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 0, i32 2, i32 2>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_1_2_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_1_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0xffff
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_bfi_b32 v0, s4, v3, v0
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_1_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_bfi_b32 v0, s4, v3, v0
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_1_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0xffff
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_bfi_b32 v0, s2, v3, v0
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_perm_b32 v1, v1, v1, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 1, i32 2, i32 2>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_3_2_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_3_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_perm_b32 v0, v2, v3, s4
; GFX900-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_3_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v0, v2, v3, s4
; GFX90A-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_3_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_perm_b32 v1, v1, v1, s2
; GFX942-NEXT:    v_perm_b32 v0, v2, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 3, i32 2, i32 2>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_4_2_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_4_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0xffff
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_bfi_b32 v0, s4, v3, v2
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_4_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_bfi_b32 v0, s4, v3, v2
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_4_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0xffff
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_bfi_b32 v0, s2, v3, v2
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_perm_b32 v1, v1, v1, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 4, i32 2, i32 2>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_2_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX900-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX90A-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_perm_b32 v1, v1, v1, s2
; GFX942-NEXT:    v_perm_b32 v0, v3, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 2, i32 2>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_u_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_u_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX900-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_u_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX90A-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_u_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX942-NEXT:    v_perm_b32 v0, v3, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 poison, i32 2>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_0_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_0_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_perm_b32 v1, v1, v0, s4
; GFX900-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_0_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v1, v1, v0, s4
; GFX90A-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_0_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_perm_b32 v1, v1, v0, s2
; GFX942-NEXT:    v_perm_b32 v0, v3, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 0, i32 2>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_1_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_1_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_alignbit_b32 v1, v1, v0, 16
; GFX900-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_1_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_alignbit_b32 v1, v1, v0, 16
; GFX90A-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_1_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_alignbit_b32 v1, v1, v0, 16
; GFX942-NEXT:    v_perm_b32 v0, v3, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 1, i32 2>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_3_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_3_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_perm_b32 v1, v1, v2, s4
; GFX900-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_3_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v1, v1, v2, s4
; GFX90A-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_3_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v1, v1, v2, s2
; GFX942-NEXT:    v_perm_b32 v0, v3, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 3, i32 2>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_4_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_4_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_alignbit_b32 v1, v1, v2, 16
; GFX900-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_4_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_alignbit_b32 v1, v1, v2, 16
; GFX90A-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_4_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_alignbit_b32 v1, v1, v2, 16
; GFX942-NEXT:    v_perm_b32 v0, v3, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 4, i32 2>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__u_3_3_3(ptr addrspace(1) inreg %ptr) {
; GFX9-LABEL: v_shuffle_v4bf16_v3bf16__u_3_3_3:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 poison, i32 3, i32 3, i32 3>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__0_3_3_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__0_3_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__0_3_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__0_3_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 0, i32 3, i32 3, i32 3>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__1_3_3_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__1_3_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    v_alignbit_b32 v0, s4, v0, 16
; GFX900-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__1_3_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_alignbit_b32 v0, s4, v0, 16
; GFX90A-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__1_3_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    v_alignbit_b32 v0, s0, v0, 16
; GFX942-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 1, i32 3, i32 3, i32 3>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__2_3_3_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__2_3_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v1
; GFX900-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__2_3_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v1
; GFX90A-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__2_3_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    v_mov_b32_e32 v0, v1
; GFX942-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 2, i32 3, i32 3, i32 3>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__3_3_3_3(ptr addrspace(1) inreg %ptr) {
; GFX9-LABEL: v_shuffle_v4bf16_v3bf16__3_3_3_3:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__4_3_3_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__4_3_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    v_perm_b32 v1, v0, v0, s4
; GFX900-NEXT:    v_alignbit_b32 v0, v0, v0, 16
; GFX900-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__4_3_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_perm_b32 v1, v0, v0, s4
; GFX90A-NEXT:    v_alignbit_b32 v0, v0, v0, 16
; GFX90A-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__4_3_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    v_perm_b32 v1, v0, v0, s2
; GFX942-NEXT:    v_alignbit_b32 v0, v0, v0, 16
; GFX942-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 4, i32 3, i32 3, i32 3>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_3_3_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_3_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v1, v0, v1, s4
; GFX900-NEXT:    v_perm_b32 v2, v0, v0, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_3_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v2, v0, v1, s4
; GFX90A-NEXT:    v_perm_b32 v3, v0, v0, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_3_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v2, v0, v1, s2
; GFX942-NEXT:    v_perm_b32 v3, v0, v0, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 3, i32 3, i32 3>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_u_3_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_u_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_perm_b32 v2, v0, v0, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_u_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v3, v0, v0, s4
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_u_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v3, v0, v0, s2
; GFX942-NEXT:    v_mov_b32_e32 v2, v1
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 poison, i32 3, i32 3>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_0_3_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_0_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v0, v0, v2, s4
; GFX900-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_0_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v0, v0, v3, s4
; GFX90A-NEXT:    v_perm_b32 v1, v2, v2, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_0_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v0, v0, v3, s2
; GFX942-NEXT:    v_perm_b32 v1, v2, v2, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 0, i32 3, i32 3>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_1_3_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_1_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0xffff
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_bfi_b32 v0, s4, v2, v0
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_1_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_bfi_b32 v0, s4, v3, v0
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_perm_b32 v1, v2, v2, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_1_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0xffff
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_bfi_b32 v0, s2, v3, v0
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_perm_b32 v1, v2, v2, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 1, i32 3, i32 3>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_2_3_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_2_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_perm_b32 v0, v1, v3, s4
; GFX900-NEXT:    v_perm_b32 v1, v2, v2, s4
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_2_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v0, v1, v3, s4
; GFX90A-NEXT:    v_perm_b32 v1, v2, v2, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_2_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v0, v1, v3, s2
; GFX942-NEXT:    v_perm_b32 v1, v2, v2, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 2, i32 3, i32 3>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_4_3_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_4_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0xffff
; GFX900-NEXT:    v_bfi_b32 v1, s4, v1, v0
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v2, v0, v0, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_4_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_bfi_b32 v2, s4, v1, v0
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_perm_b32 v3, v0, v0, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_4_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_mov_b32 s2, 0xffff
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_bfi_b32 v2, s2, v1, v0
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_perm_b32 v3, v0, v0, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 4, i32 3, i32 3>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_3_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v2, v0, v0, s4
; GFX900-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v3, v0, v0, s4
; GFX90A-NEXT:    v_perm_b32 v2, v1, v1, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v3, v0, v0, s2
; GFX942-NEXT:    v_perm_b32 v2, v1, v1, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 3, i32 3>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_u_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_u_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX900-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_u_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v2, v1, v1, s4
; GFX90A-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_u_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v2, v1, v1, s2
; GFX942-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 poison, i32 3>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_0_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_0_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v1, v1, v0, s4
; GFX900-NEXT:    v_perm_b32 v0, v2, v2, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_0_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v1, v2, v0, s4
; GFX90A-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_0_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v1, v2, v0, s2
; GFX942-NEXT:    v_perm_b32 v0, v3, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 0, i32 3>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_1_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_1_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_alignbit_b32 v1, v1, v0, 16
; GFX900-NEXT:    v_perm_b32 v0, v2, v2, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_1_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; GFX90A-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_1_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; GFX942-NEXT:    v_perm_b32 v0, v3, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 1, i32 3>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_2_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_2_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_perm_b32 v1, v2, v1, s4
; GFX900-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_2_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v1, v2, v1, s4
; GFX90A-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_2_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v1, v2, v1, s2
; GFX942-NEXT:    v_perm_b32 v0, v3, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 2, i32 3>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_4_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_4_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_alignbit_b32 v2, v0, v0, 16
; GFX900-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_4_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_alignbit_b32 v3, v0, v0, 16
; GFX90A-NEXT:    v_perm_b32 v2, v1, v1, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_4_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_alignbit_b32 v3, v0, v0, 16
; GFX942-NEXT:    v_perm_b32 v2, v1, v1, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 4, i32 3>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__u_4_4_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__u_4_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x7060302
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    v_perm_b32 v1, v0, v0, s4
; GFX900-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__u_4_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x7060302
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_perm_b32 v1, v0, v0, s4
; GFX90A-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__u_4_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x7060302
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    v_perm_b32 v1, v0, v0, s2
; GFX942-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 poison, i32 4, i32 4, i32 4>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__0_4_4_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__0_4_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0xffff
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_bfi_b32 v0, s4, v0, v1
; GFX900-NEXT:    s_mov_b32 s4, 0x7060302
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__0_4_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_bfi_b32 v0, s4, v0, v2
; GFX90A-NEXT:    s_mov_b32 s4, 0x7060302
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_perm_b32 v1, v2, v2, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__0_4_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0xffff
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_bfi_b32 v0, s2, v0, v2
; GFX942-NEXT:    s_mov_b32 s2, 0x7060302
; GFX942-NEXT:    v_perm_b32 v1, v2, v2, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 0, i32 4, i32 4, i32 4>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__1_4_4_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__1_4_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x7060302
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX900-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__1_4_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x7060302
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v0, v2, v0, s4
; GFX90A-NEXT:    v_perm_b32 v1, v2, v2, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__1_4_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x7060302
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v0, v2, v0, s2
; GFX942-NEXT:    v_perm_b32 v1, v2, v2, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 1, i32 4, i32 4, i32 4>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__2_4_4_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__2_4_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0xffff
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_bfi_b32 v0, s4, v1, v2
; GFX900-NEXT:    s_mov_b32 s4, 0x7060302
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_perm_b32 v1, v2, v2, s4
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__2_4_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_bfi_b32 v0, s4, v1, v2
; GFX90A-NEXT:    s_mov_b32 s4, 0x7060302
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_perm_b32 v1, v2, v2, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__2_4_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0xffff
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_bfi_b32 v0, s2, v1, v2
; GFX942-NEXT:    s_mov_b32 s2, 0x7060302
; GFX942-NEXT:    v_perm_b32 v1, v2, v2, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 2, i32 4, i32 4, i32 4>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__3_4_4_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__3_4_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x7060302
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    v_perm_b32 v1, v0, v0, s4
; GFX900-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__3_4_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x7060302
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_perm_b32 v1, v0, v0, s4
; GFX90A-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__3_4_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x7060302
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    v_perm_b32 v1, v0, v0, s2
; GFX942-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 3, i32 4, i32 4, i32 4>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__4_4_4_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__4_4_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x7060302
; GFX900-NEXT:    v_perm_b32 v0, v0, v0, s4
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    v_mov_b32_e32 v1, v0
; GFX900-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__4_4_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x7060302
; GFX90A-NEXT:    v_perm_b32 v0, v0, v0, s4
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_mov_b32_e32 v1, v0
; GFX90A-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__4_4_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x7060302
; GFX942-NEXT:    v_perm_b32 v0, v0, v0, s2
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    v_mov_b32_e32 v1, v0
; GFX942-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 4, i32 4, i32 4, i32 4>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_4_4_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_4_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0xffff
; GFX900-NEXT:    v_bfi_b32 v1, s4, v1, v0
; GFX900-NEXT:    s_mov_b32 s4, 0x7060302
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v2, v0, v0, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_4_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_bfi_b32 v2, s4, v1, v0
; GFX90A-NEXT:    s_mov_b32 s4, 0x7060302
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_perm_b32 v3, v0, v0, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_4_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_mov_b32 s2, 0xffff
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_bfi_b32 v2, s2, v1, v0
; GFX942-NEXT:    s_mov_b32 s2, 0x7060302
; GFX942-NEXT:    v_perm_b32 v3, v0, v0, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 4, i32 4, i32 4>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_u_4_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_u_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_mov_b32 s4, 0x7060302
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_perm_b32 v2, v0, v0, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_u_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b32 s4, 0x7060302
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v3, v0, v0, s4
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_u_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_mov_b32 s2, 0x7060302
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v3, v0, v0, s2
; GFX942-NEXT:    v_mov_b32_e32 v2, v1
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 poison, i32 4, i32 4>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_0_4_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_0_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_perm_b32 v0, v0, v2, s4
; GFX900-NEXT:    s_mov_b32 s4, 0x7060302
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_0_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v0, v0, v3, s4
; GFX90A-NEXT:    s_mov_b32 s4, 0x7060302
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_perm_b32 v1, v2, v2, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_0_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_perm_b32 v0, v0, v3, s2
; GFX942-NEXT:    s_mov_b32 s2, 0x7060302
; GFX942-NEXT:    v_perm_b32 v1, v2, v2, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 0, i32 4, i32 4>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_1_4_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_1_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0xffff
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_bfi_b32 v0, s4, v2, v0
; GFX900-NEXT:    s_mov_b32 s4, 0x7060302
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_1_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_bfi_b32 v0, s4, v3, v0
; GFX90A-NEXT:    s_mov_b32 s4, 0x7060302
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_perm_b32 v1, v2, v2, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_1_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0xffff
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_bfi_b32 v0, s2, v3, v0
; GFX942-NEXT:    s_mov_b32 s2, 0x7060302
; GFX942-NEXT:    v_perm_b32 v1, v2, v2, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 1, i32 4, i32 4>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_2_4_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_2_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_perm_b32 v0, v1, v3, s4
; GFX900-NEXT:    s_mov_b32 s4, 0x7060302
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_perm_b32 v1, v2, v2, s4
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_2_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v0, v1, v3, s4
; GFX90A-NEXT:    s_mov_b32 s4, 0x7060302
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_perm_b32 v1, v2, v2, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_2_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_perm_b32 v0, v1, v3, s2
; GFX942-NEXT:    s_mov_b32 s2, 0x7060302
; GFX942-NEXT:    v_perm_b32 v1, v2, v2, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 2, i32 4, i32 4>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_3_4_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_3_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_perm_b32 v1, v0, v1, s4
; GFX900-NEXT:    s_mov_b32 s4, 0x7060302
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v2, v0, v0, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_3_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v2, v0, v1, s4
; GFX90A-NEXT:    s_mov_b32 s4, 0x7060302
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_perm_b32 v3, v0, v0, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_3_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_perm_b32 v2, v0, v1, s2
; GFX942-NEXT:    s_mov_b32 s2, 0x7060302
; GFX942-NEXT:    v_perm_b32 v3, v0, v0, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 3, i32 4, i32 4>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_4_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_mov_b32 s4, 0x7060302
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_perm_b32 v2, v0, v0, s4
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b32 s4, 0x7060302
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v3, v0, v0, s4
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_perm_b32 v2, v1, v1, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_mov_b32 s2, 0x7060302
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_perm_b32 v3, v0, v0, s2
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_perm_b32 v2, v1, v1, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 4, i32 4>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_u_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_u_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX900-NEXT:    v_mov_b32_e32 v2, v0
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_u_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v2, v1, v1, s4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v0
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_u_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v2, v1, v1, s2
; GFX942-NEXT:    v_mov_b32_e32 v3, v0
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 poison, i32 4>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_0_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_0_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0xffff
; GFX900-NEXT:    v_bfi_b32 v1, s4, v0, v1
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v0, v2, v2, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_0_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_bfi_b32 v1, s4, v0, v2
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_0_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0xffff
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_bfi_b32 v1, s2, v0, v2
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_perm_b32 v0, v3, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 0, i32 4>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_1_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_1_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x7060302
; GFX900-NEXT:    v_perm_b32 v1, v1, v0, s4
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v0, v2, v2, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_1_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x7060302
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v1, v2, v0, s4
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_1_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x7060302
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_perm_b32 v1, v2, v0, s2
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_perm_b32 v0, v3, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 1, i32 4>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_2_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_2_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0xffff
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_bfi_b32 v1, s4, v1, v2
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_2_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_bfi_b32 v1, s4, v1, v2
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_2_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0xffff
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_bfi_b32 v1, s2, v1, v2
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_perm_b32 v0, v3, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 2, i32 4>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_3_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_3_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX900-NEXT:    v_mov_b32_e32 v2, v0
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_3_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v2, v1, v1, s4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v0
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_3_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v2, v1, v1, s2
; GFX942-NEXT:    v_mov_b32_e32 v3, v0
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 3, i32 4>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__u_5_5_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__u_5_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v2, v1, v1, s4
; GFX900-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__u_5_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v3, v1, v1, s4
; GFX90A-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__u_5_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v3, v1, v1, s2
; GFX942-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 poison, i32 5, i32 5, i32 5>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__0_5_5_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__0_5_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v0, v2, v0, s4
; GFX900-NEXT:    v_perm_b32 v1, v2, v2, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__0_5_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v0, v3, v0, s4
; GFX90A-NEXT:    v_perm_b32 v1, v3, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__0_5_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v0, v3, v0, s2
; GFX942-NEXT:    v_perm_b32 v1, v3, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 0, i32 5, i32 5, i32 5>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__1_5_5_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__1_5_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v1, v2, v2, s4
; GFX900-NEXT:    v_alignbit_b32 v0, v2, v0, 16
; GFX900-NEXT:    global_store_dwordx2 v3, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__1_5_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v1, v3, v3, s4
; GFX90A-NEXT:    v_alignbit_b32 v0, v3, v0, 16
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__1_5_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v1, v3, v3, s2
; GFX942-NEXT:    v_alignbit_b32 v0, v3, v0, 16
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 1, i32 5, i32 5, i32 5>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__2_5_5_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__2_5_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_perm_b32 v0, v3, v1, s4
; GFX900-NEXT:    v_perm_b32 v1, v3, v3, s4
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__2_5_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v0, v3, v1, s4
; GFX90A-NEXT:    v_perm_b32 v1, v3, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__2_5_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v0, v3, v1, s2
; GFX942-NEXT:    v_perm_b32 v1, v3, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 2, i32 5, i32 5, i32 5>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__3_5_5_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__3_5_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX900-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX900-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__3_5_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_perm_b32 v0, v1, v0, s4
; GFX90A-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX90A-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__3_5_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    v_perm_b32 v0, v1, v0, s2
; GFX942-NEXT:    v_perm_b32 v1, v1, v1, s2
; GFX942-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 3, i32 5, i32 5, i32 5>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__4_5_5_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__4_5_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v2, v1, v1, s4
; GFX900-NEXT:    v_alignbit_b32 v1, v1, v0, 16
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__4_5_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v3, v1, v1, s4
; GFX90A-NEXT:    v_alignbit_b32 v2, v1, v0, 16
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__4_5_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v3, v1, v1, s2
; GFX942-NEXT:    v_alignbit_b32 v2, v1, v0, 16
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 4, i32 5, i32 5, i32 5>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_u_5_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_u_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_perm_b32 v2, v1, v1, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_u_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v3, v1, v1, s4
; GFX90A-NEXT:    v_mov_b32_e32 v2, v1
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_u_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v3, v1, v1, s2
; GFX942-NEXT:    v_mov_b32_e32 v2, v1
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 poison, i32 5, i32 5>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_0_5_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_0_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v0, v0, v2, s4
; GFX900-NEXT:    v_perm_b32 v1, v2, v2, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_0_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v0, v0, v3, s4
; GFX90A-NEXT:    v_perm_b32 v1, v3, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_0_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v0, v0, v3, s2
; GFX942-NEXT:    v_perm_b32 v1, v3, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 0, i32 5, i32 5>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_1_5_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_1_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0xffff
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_bfi_b32 v0, s4, v2, v0
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v1, v2, v2, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_1_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_bfi_b32 v0, s4, v3, v0
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    v_perm_b32 v1, v3, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_1_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0xffff
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    v_bfi_b32 v0, s2, v3, v0
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_perm_b32 v1, v3, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 1, i32 5, i32 5>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_2_5_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_2_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_perm_b32 v0, v1, v3, s4
; GFX900-NEXT:    v_perm_b32 v1, v3, v3, s4
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_2_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v0, v1, v3, s4
; GFX90A-NEXT:    v_perm_b32 v1, v3, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_2_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v0, v1, v3, s2
; GFX942-NEXT:    v_perm_b32 v1, v3, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 2, i32 5, i32 5>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_3_5_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_3_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    v_perm_b32 v0, v0, v1, s4
; GFX900-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX900-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_3_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_perm_b32 v0, v0, v1, s4
; GFX90A-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX90A-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_3_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    v_perm_b32 v0, v0, v1, s2
; GFX942-NEXT:    v_perm_b32 v1, v1, v1, s2
; GFX942-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 3, i32 5, i32 5>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_4_5_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_4_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0xffff
; GFX900-NEXT:    v_bfi_b32 v0, s4, v1, v0
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX900-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_4_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0xffff
; GFX90A-NEXT:    v_bfi_b32 v0, s4, v1, v0
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX90A-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_4_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0xffff
; GFX942-NEXT:    v_bfi_b32 v0, s2, v1, v0
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    v_perm_b32 v1, v1, v1, s2
; GFX942-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 4, i32 5, i32 5>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_u_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_u_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v2, 0
; GFX900-NEXT:    v_perm_b32 v0, v1, v1, s4
; GFX900-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX900-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_u_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v2, 0
; GFX90A-NEXT:    v_perm_b32 v0, v1, v1, s4
; GFX90A-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX90A-NEXT:    global_store_dwordx2 v2, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_u_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-NEXT:    v_perm_b32 v0, v1, v1, s2
; GFX942-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX942-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 poison, i32 5>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_0_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_0_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v1, v2, v0, s4
; GFX900-NEXT:    v_perm_b32 v0, v2, v2, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_0_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v1, v3, v0, s4
; GFX90A-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_0_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v1, v3, v0, s2
; GFX942-NEXT:    v_perm_b32 v0, v3, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 0, i32 5>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_1_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_1_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[1:2]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; GFX900-NEXT:    v_perm_b32 v0, v2, v2, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_1_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_alignbit_b32 v1, v3, v0, 16
; GFX90A-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_1_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_alignbit_b32 v1, v3, v0, 16
; GFX942-NEXT:    v_perm_b32 v0, v3, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 1, i32 5>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_2_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_2_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v4, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:3]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_perm_b32 v1, v3, v1, s4
; GFX900-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX900-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_2_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:3]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v1, v3, v1, s4
; GFX90A-NEXT:    v_perm_b32 v0, v3, v3, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[0:1], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_2_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v1, v3, v1, s2
; GFX942-NEXT:    v_perm_b32 v0, v3, v3, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 2, i32 5>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_3_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_3_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_perm_b32 v2, v1, v0, s4
; GFX900-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_3_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_perm_b32 v3, v1, v0, s4
; GFX90A-NEXT:    v_perm_b32 v2, v1, v1, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_3_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_perm_b32 v3, v1, v0, s2
; GFX942-NEXT:    v_perm_b32 v2, v1, v1, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 3, i32 5>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @v_shuffle_v4bf16_v3bf16__5_5_4_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v4bf16_v3bf16__5_5_4_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:1]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_mov_b32_e32 v3, 0
; GFX900-NEXT:    v_alignbit_b32 v2, v1, v0, 16
; GFX900-NEXT:    v_perm_b32 v1, v1, v1, s4
; GFX900-NEXT:    global_store_dwordx2 v3, v[1:2], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v4bf16_v3bf16__5_5_4_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    s_mov_b32 s4, 0x5040100
; GFX90A-NEXT:    v_mov_b32_e32 v4, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:1]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_alignbit_b32 v3, v1, v0, 16
; GFX90A-NEXT:    v_perm_b32 v2, v1, v1, s4
; GFX90A-NEXT:    global_store_dwordx2 v4, v[2:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: v_shuffle_v4bf16_v3bf16__5_5_4_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_mov_b32 s2, 0x5040100
; GFX942-NEXT:    v_mov_b32_e32 v4, 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def v[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    v_alignbit_b32 v3, v1, v0, 16
; GFX942-NEXT:    v_perm_b32 v2, v1, v1, s2
; GFX942-NEXT:    global_store_dwordx2 v4, v[2:3], s[0:1]
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=v"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=v"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 4, i32 5>
  store <4 x bfloat> %shuf, ptr addrspace(1) %ptr, align 8
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__u_u_u_u() {
; GFX9-LABEL: s_shuffle_v4bf16_v3bf16__u_u_u_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> poison
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__0_u_u_u() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__0_u_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__0_u_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__0_u_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 0, i32 poison, i32 poison, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__1_u_u_u() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__1_u_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s8, s4, 16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__1_u_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s8, s4, 16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__1_u_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s8, s0, 16
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 1, i32 poison, i32 poison, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__2_u_u_u() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__2_u_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__2_u_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__2_u_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 2, i32 poison, i32 poison, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__3_u_u_u() {
; GFX9-LABEL: s_shuffle_v4bf16_v3bf16__3_u_u_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 3, i32 poison, i32 poison, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__4_u_u_u() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__4_u_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s8, s4, 16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__4_u_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s8, s4, 16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__4_u_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s8, s0, 16
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 4, i32 poison, i32 poison, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_u_u_u() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_u_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_u_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_u_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 poison, i32 poison, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_0_u_u() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_0_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_0_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_0_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 0, i32 poison, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_1_u_u() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_1_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_1_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_1_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 1, i32 poison, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_2_u_u() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_2_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_2_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_2_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 2, i32 poison, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_3_u_u() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_3_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_3_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_3_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s1, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 3, i32 poison, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_4_u_u() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_4_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_4_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_4_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s1, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 4, i32 poison, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_u_u() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_u_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_u_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_u_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s1, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 poison, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_0_u() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_0_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_0_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_0_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s3
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 0, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_1_u() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_1_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s9, s4, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_1_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s9, s4, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_1_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s9, s0, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 1, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_2_u() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_2_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_2_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_2_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s1, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 2, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_3_u() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_3_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s5
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_3_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s5
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_3_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s1, s1
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 3, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_4_u() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_4_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s9, s4, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_4_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s9, s4, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_4_u:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s9, s0, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s1, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 4, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_5_u() {
; GFX9-LABEL: s_shuffle_v4bf16_v3bf16__5_5_5_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_pack_ll_b32_b16 s8, s9, s9
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 5, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_5_0() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_5_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s7, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_5_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s7, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_5_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s3, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 5, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_5_1() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_5_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s7, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_5_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s7, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_5_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s3, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 5, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_5_2() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_5_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s7, s5
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_5_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s7, s5
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_5_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s3, s1
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 5, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_5_3() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_5_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s5, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_5_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s5, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_5_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s1, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s1, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 5, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_5_4() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_5_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s5, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_5_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s5, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_5_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s1, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s1, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 5, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_5_5() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s5
; GFX900-NEXT:    s_mov_b32 s9, s8
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s5
; GFX90A-NEXT:    s_mov_b32 s9, s8
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s1, s1
; GFX942-NEXT:    s_mov_b32 s9, s8
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 5, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__u_0_0_0() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__u_0_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    s_lshl_b32 s8, s4, 16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__u_0_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    s_lshl_b32 s8, s4, 16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__u_0_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    s_lshl_b32 s8, s0, 16
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 poison, i32 0, i32 0, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__0_0_0_0() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__0_0_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s4, s4
; GFX900-NEXT:    s_mov_b32 s9, s8
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__0_0_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s4, s4
; GFX90A-NEXT:    s_mov_b32 s9, s8
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__0_0_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s0, s0
; GFX942-NEXT:    s_mov_b32 s9, s8
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> zeroinitializer
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__1_0_0_0() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__1_0_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s5, s4, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__1_0_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s5, s4, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__1_0_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s1, s0, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s1, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 1, i32 0, i32 0, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__2_0_0_0() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__2_0_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__2_0_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__2_0_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s1, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 2, i32 0, i32 0, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__3_0_0_0() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__3_0_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    s_lshl_b32 s8, s4, 16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__3_0_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    s_lshl_b32 s8, s4, 16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__3_0_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    s_lshl_b32 s8, s0, 16
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 3, i32 0, i32 0, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__4_0_0_0() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__4_0_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s5, s6, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__4_0_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s5, s6, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__4_0_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s1, s2, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s1, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 4, i32 0, i32 0, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_0_0_0() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_0_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_0_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_0_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 0, i32 0, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_u_0_0() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_u_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_u_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_u_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    s_mov_b32 s8, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 poison, i32 0, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_1_0_0() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_1_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s5, s4, 16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s5
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_1_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s5, s4, 16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s5
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_1_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s1, s0, 16
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s1
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 1, i32 0, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_2_0_0() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_2_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s5
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_2_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s5
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_2_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s1
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 2, i32 0, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_3_0_0() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_3_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s6
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_3_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s6
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_3_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s2
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 3, i32 0, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_4_0_0() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_4_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s5, s6, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s5
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_4_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s5, s6, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s5
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_4_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s1, s2, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s1
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 4, i32 0, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_0_0() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_0_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 0, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_u_0() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_u_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshl_b32 s9, s4, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_u_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshl_b32 s9, s4, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_u_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshl_b32 s9, s0, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 poison, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_1_0() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_1_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s5, s4, 16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s5, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_1_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s5, s4, 16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s5, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_1_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s1, s0, 16
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s1, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 1, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_2_0() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_2_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s5, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_2_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s5, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_2_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s1, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 2, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_3_0() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_3_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s6, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_3_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s6, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_3_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s2, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 3, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_4_0() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_4_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s5, s6, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s5, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_4_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s5, s6, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s5, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_4_0:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s1, s2, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s1, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 4, i32 0>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__u_1_1_1() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__u_1_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s8, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__u_1_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s8, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__u_1_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s8, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 poison, i32 1, i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__0_1_1_1() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__0_1_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s8, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__0_1_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s8, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__0_1_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s8, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 0, i32 1, i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__1_1_1_1() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__1_1_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s4, s4
; GFX900-NEXT:    s_mov_b32 s9, s8
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__1_1_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s4, s4
; GFX90A-NEXT:    s_mov_b32 s9, s8
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__1_1_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s0, s0
; GFX942-NEXT:    s_mov_b32 s9, s8
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 1, i32 1, i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__2_1_1_1() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__2_1_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__2_1_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__2_1_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s1, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 2, i32 1, i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__3_1_1_1() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__3_1_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s8, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__3_1_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s8, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__3_1_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s8, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 3, i32 1, i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__4_1_1_1() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__4_1_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    s_lshr_b32 s5, s6, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__4_1_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    s_lshr_b32 s5, s6, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__4_1_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    s_lshr_b32 s1, s2, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s1, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 4, i32 1, i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_1_1_1() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_1_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_1_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_1_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 1, i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_u_1_1() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_u_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_u_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_u_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    s_mov_b32 s8, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 poison, i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_0_1_1() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_0_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s4
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_0_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s4
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_0_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s0
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 0, i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_2_1_1() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_2_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s5
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_2_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s5
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_2_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s1
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 2, i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_3_1_1() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_3_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s6
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_3_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s6
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_3_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s2
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 3, i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_4_1_1() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_4_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s5, s6, 16
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s5
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_4_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s5, s6, 16
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s5
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_4_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s1, s2, 16
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s1
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 4, i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_1_1() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_1_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_u_1() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_u_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_u_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_u_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s3
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 poison, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_0_1() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_0_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_0_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_0_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s3
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 0, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_2_1() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_2_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s5, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_2_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s5, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_2_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s1, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 2, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_3_1() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_3_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s6, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_3_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s6, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_3_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s2, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 3, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_4_1() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_4_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    s_lshr_b32 s5, s6, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s5, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_4_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    s_lshr_b32 s5, s6, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s5, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_4_1:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    s_lshr_b32 s1, s2, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s1, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 4, i32 1>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__u_2_2_2() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__u_2_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX900-NEXT:    s_lshl_b32 s8, s5, 16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__u_2_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX90A-NEXT:    s_lshl_b32 s8, s5, 16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__u_2_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s1, s1
; GFX942-NEXT:    s_lshl_b32 s8, s1, 16
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 poison, i32 2, i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__0_2_2_2() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__0_2_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s4, s5
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__0_2_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s4, s5
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__0_2_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s0, s1
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s1, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 0, i32 2, i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__1_2_2_2() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__1_2_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s4, s5
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__1_2_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s4, s5
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__1_2_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s0, s1
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s1, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 1, i32 2, i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__2_2_2_2() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__2_2_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s5
; GFX900-NEXT:    s_mov_b32 s9, s8
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__2_2_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s5
; GFX90A-NEXT:    s_mov_b32 s9, s8
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__2_2_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s1, s1
; GFX942-NEXT:    s_mov_b32 s9, s8
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 2, i32 2, i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__3_2_2_2() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__3_2_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX900-NEXT:    s_lshl_b32 s8, s5, 16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__3_2_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX90A-NEXT:    s_lshl_b32 s8, s5, 16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__3_2_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s1, s1
; GFX942-NEXT:    s_lshl_b32 s8, s1, 16
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 3, i32 2, i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__4_2_2_2() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__4_2_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s6, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s4, s5
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__4_2_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s6, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s4, s5
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__4_2_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s2, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s0, s1
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s1, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 4, i32 2, i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_2_2_2() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_2_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s5
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_2_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s5
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_2_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s1
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s1, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 2, i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_u_2_2() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_u_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX900-NEXT:    s_mov_b32 s8, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_u_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX90A-NEXT:    s_mov_b32 s8, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_u_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s1, s1
; GFX942-NEXT:    s_mov_b32 s8, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 poison, i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_0_2_2() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_0_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_0_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_0_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s1, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 0, i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_1_2_2() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_1_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_1_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_1_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s1, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 1, i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_3_2_2() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_3_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s6
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_3_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s6
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_3_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s2
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s1, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 3, i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_4_2_2() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_4_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s6, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_4_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s6, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_4_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s2, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s1, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 4, i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_2_2() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_2_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s1, s1
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_u_2() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_u_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshl_b32 s9, s5, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_u_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshl_b32 s9, s5, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_u_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshl_b32 s9, s1, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 poison, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_0_2() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_0_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s5
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_0_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s5
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_0_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s1
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 0, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_1_2() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_1_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s5
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_1_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s5
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_1_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s1
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 1, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_3_2() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_3_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s6, s5
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_3_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s6, s5
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_3_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s2, s1
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 3, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_4_2() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_4_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s6, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s5
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_4_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s6, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s5
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_4_2:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s2, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s1
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 4, i32 2>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__u_3_3_3() {
; GFX9-LABEL: s_shuffle_v4bf16_v3bf16__u_3_3_3:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 poison, i32 3, i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__0_3_3_3() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__0_3_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__0_3_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__0_3_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_nop 0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 0, i32 3, i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__1_3_3_3() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__1_3_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s8, s4, 16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__1_3_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s8, s4, 16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__1_3_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s8, s0, 16
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 1, i32 3, i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__2_3_3_3() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__2_3_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__2_3_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__2_3_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 2, i32 3, i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__3_3_3_3() {
; GFX9-LABEL: s_shuffle_v4bf16_v3bf16__3_3_3_3:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:9]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> poison, <4 x i32> <i32 3, i32 3, i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__4_3_3_3() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__4_3_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s5, s4, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__4_3_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s5, s4, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__4_3_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s1, s0, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s1, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 4, i32 3, i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_3_3_3() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_3_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_3_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_3_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s1, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 3, i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_u_3_3() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_u_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_u_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_u_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 poison, i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_0_3_3() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_0_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s6, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_0_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s6, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_0_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s2, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 0, i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_1_3_3() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_1_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s6, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_1_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s6, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_1_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s2, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 1, i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_2_3_3() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_2_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s5
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s6, s6
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_2_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s5
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s6, s6
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_2_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s1
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s2, s2
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 2, i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_4_3_3() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_4_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s6, s4, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s6
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_4_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s6, s4, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s6
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_4_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s2, s0, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s1, s2
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 4, i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_3_3() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_3_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s1, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_u_3() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_u_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshl_b32 s9, s4, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_u_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshl_b32 s9, s4, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_u_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshl_b32 s9, s0, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s1, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 poison, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_0_3() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_0_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s6
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_0_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s6
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_0_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s2
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 0, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_1_3() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_1_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s6
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_1_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s6
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_1_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s2
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 1, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_2_3() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_2_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s5, s6
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_2_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s5, s6
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_2_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s1, s2
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 2, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_4_3() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_4_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s6, s4, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s6, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_4_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s6, s4, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s6, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_4_3:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s2, s0, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s2, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s1, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 4, i32 3>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__u_4_4_4() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__u_4_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s8, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__u_4_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s8, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__u_4_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s8, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 poison, i32 4, i32 4, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__0_4_4_4() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__0_4_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s5, s6, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s4, s5
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__0_4_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s5, s6, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s4, s5
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__0_4_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s1, s2, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s0, s1
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s1, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 0, i32 4, i32 4, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__1_4_4_4() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__1_4_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s5, s6, 16
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s4, s5
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__1_4_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s5, s6, 16
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s4, s5
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__1_4_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s1, s2, 16
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s0, s1
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s1, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 1, i32 4, i32 4, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__2_4_4_4() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__2_4_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s6, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__2_4_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s6, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__2_4_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s2, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s1, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 2, i32 4, i32 4, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__3_4_4_4() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__3_4_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s8, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__3_4_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s8, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__3_4_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s8, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 3, i32 4, i32 4, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__4_4_4_4() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__4_4_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s4, s4
; GFX900-NEXT:    s_mov_b32 s9, s8
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__4_4_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s4, s4
; GFX90A-NEXT:    s_mov_b32 s9, s8
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__4_4_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s0, s0
; GFX942-NEXT:    s_mov_b32 s9, s8
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 4, i32 4, i32 4, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_4_4_4() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_4_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_4_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_4_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s1, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 4, i32 4, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_u_4_4() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_u_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_u_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_u_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 poison, i32 4, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_0_4_4() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_0_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s4
; GFX900-NEXT:    s_lshr_b32 s4, s6, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_0_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s4
; GFX90A-NEXT:    s_lshr_b32 s4, s6, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_0_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s0
; GFX942-NEXT:    s_lshr_b32 s0, s2, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 0, i32 4, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_1_4_4() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_1_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s4
; GFX900-NEXT:    s_lshr_b32 s4, s6, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_1_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s4
; GFX90A-NEXT:    s_lshr_b32 s4, s6, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_1_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s0
; GFX942-NEXT:    s_lshr_b32 s0, s2, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 1, i32 4, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_2_4_4() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_2_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s6, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s5
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_2_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s6, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s5
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_2_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s2, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s1
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 2, i32 4, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_3_4_4() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_3_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_3_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_3_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s1, s0
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 3, i32 4, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_4_4() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_4_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_4_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_4_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s1, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 4, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_u_4() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_u_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s5
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_u_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s5
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_u_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s1, s1
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 poison, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_0_4() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_0_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s5, s6, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s5
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_0_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s5, s6, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s5
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_0_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s1, s2, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s1
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 0, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_1_4() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_1_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s5, s6, 16
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s5
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_1_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s5, s6, 16
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s5
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_1_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s1, s2, 16
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s1
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 1, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_2_4() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_2_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s6, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s5, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_2_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s6, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s5, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_2_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s2, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s1, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 2, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_3_4() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_3_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s5
; GFX900-NEXT:    s_mov_b32 s9, s4
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_3_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s5
; GFX90A-NEXT:    s_mov_b32 s9, s4
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_3_4:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s1, s1
; GFX942-NEXT:    s_mov_b32 s9, s0
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 3, i32 4>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__u_5_5_5() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__u_5_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX900-NEXT:    s_lshl_b32 s8, s5, 16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__u_5_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX90A-NEXT:    s_lshl_b32 s8, s5, 16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__u_5_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s1, s1
; GFX942-NEXT:    s_lshl_b32 s8, s1, 16
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 poison, i32 5, i32 5, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__0_5_5_5() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__0_5_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s4, s7
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__0_5_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s4, s7
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__0_5_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s0, s3
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 0, i32 5, i32 5, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__1_5_5_5() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__1_5_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s4, s7
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__1_5_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s4, s7
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__1_5_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s0, s3
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 1, i32 5, i32 5, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__2_5_5_5() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__2_5_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s7
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__2_5_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s7
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__2_5_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s1, s3
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 2, i32 5, i32 5, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__3_5_5_5() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__3_5_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s4, s5
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__3_5_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s4, s5
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__3_5_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s0, s1
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s1, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 3, i32 5, i32 5, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__4_5_5_5() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__4_5_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s4, s5
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__4_5_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s4, s5
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__4_5_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s0, s1
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s1, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 4, i32 5, i32 5, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_u_5_5() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_u_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX900-NEXT:    s_mov_b32 s8, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_u_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX90A-NEXT:    s_mov_b32 s8, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_u_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s1, s1
; GFX942-NEXT:    s_mov_b32 s8, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 poison, i32 5, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_0_5_5() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_0_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_0_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_0_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 0, i32 5, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_1_5_5() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_1_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_1_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_1_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 1, i32 5, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_2_5_5() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_2_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s5
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_2_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s5
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_2_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s1
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 2, i32 5, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_3_5_5() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_3_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_3_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_3_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s1, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s1, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 3, i32 5, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_4_5_5() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_4_5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_4_5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s4
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s5, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_4_5_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s1, s0
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s1, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 4, i32 5, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_u_5() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_u_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshl_b32 s9, s5, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_u_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshl_b32 s9, s5, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_u_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshl_b32 s9, s1, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s1, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 poison, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_0_5() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_0_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s7
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_0_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s7
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_0_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s3
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 0, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_1_5() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_1_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s7
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_1_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s7
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_1_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s3
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 1, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_2_5() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_2_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[6:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s5, s7
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_2_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[6:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s5, s7
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s7, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_2_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[2:3]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s1, s3
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s3, s3
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 2, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_3_5() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_3_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s5
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_3_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s5
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_3_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s1
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s1, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 3, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}

define void @s_shuffle_v4bf16_v3bf16__5_5_4_5() {
; GFX900-LABEL: s_shuffle_v4bf16_v3bf16__5_5_4_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:5]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_lshr_b32 s4, s4, 16
; GFX900-NEXT:    s_pack_ll_b32_b16 s9, s4, s5
; GFX900-NEXT:    s_pack_ll_b32_b16 s8, s5, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v4bf16_v3bf16__5_5_4_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:5]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_lshr_b32 s4, s4, 16
; GFX90A-NEXT:    s_pack_ll_b32_b16 s9, s4, s5
; GFX90A-NEXT:    s_pack_ll_b32_b16 s8, s5, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: s_shuffle_v4bf16_v3bf16__5_5_4_5:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; def s[0:1]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_lshr_b32 s0, s0, 16
; GFX942-NEXT:    s_pack_ll_b32_b16 s9, s0, s1
; GFX942-NEXT:    s_pack_ll_b32_b16 s8, s1, s1
; GFX942-NEXT:    ;;#ASMSTART
; GFX942-NEXT:    ; use s[8:9]
; GFX942-NEXT:    ;;#ASMEND
; GFX942-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x bfloat> asm "; def $0", "=s"()
  %vec1 = call <4 x bfloat> asm "; def $0", "=s"()
  %extract3 = shufflevector <4 x bfloat> %vec0, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %extract31 = shufflevector <4 x bfloat> %vec1, <4 x bfloat> poison, <3 x i32> <i32 0, i32 1, i32 2>
  %shuf = shufflevector <3 x bfloat> %extract3, <3 x bfloat> %extract31, <4 x i32> <i32 5, i32 5, i32 4, i32 5>
  call void asm sideeffect "; use $0", "{s[8:9]}"(<4 x bfloat> %shuf)
  ret void
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GFX90APLUS: {{.*}}
