// Copyright 2018, OpenCensus Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This package describes the Metrics data model. It is currently experimental
// but may eventually become the wire format for metrics. Please see
// https://github.com/census-instrumentation/opencensus-specs/blob/master/stats/Metrics.md
// for more details.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.17.3
// source: opencensus/proto/metrics/v1/metrics.proto

package v1

import (
	v1 "github.com/census-instrumentation/opencensus-proto/gen-go/resource/v1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The kind of metric. It describes how the data is reported.
//
// A gauge is an instantaneous measurement of a value.
//
// A cumulative measurement is a value accumulated over a time interval. In
// a time series, cumulative measurements should have the same start time,
// increasing values and increasing end times, until an event resets the
// cumulative value to zero and sets a new start time for the following
// points.
type MetricDescriptor_Type int32

const (
	// Do not use this default value.
	MetricDescriptor_UNSPECIFIED MetricDescriptor_Type = 0
	// Integer gauge. The value can go both up and down.
	MetricDescriptor_GAUGE_INT64 MetricDescriptor_Type = 1
	// Floating point gauge. The value can go both up and down.
	MetricDescriptor_GAUGE_DOUBLE MetricDescriptor_Type = 2
	// Distribution gauge measurement. The count and sum can go both up and
	// down. Recorded values are always >= 0.
	// Used in scenarios like a snapshot of time the current items in a queue
	// have spent there.
	MetricDescriptor_GAUGE_DISTRIBUTION MetricDescriptor_Type = 3
	// Integer cumulative measurement. The value cannot decrease, if resets
	// then the start_time should also be reset.
	MetricDescriptor_CUMULATIVE_INT64 MetricDescriptor_Type = 4
	// Floating point cumulative measurement. The value cannot decrease, if
	// resets then the start_time should also be reset. Recorded values are
	// always >= 0.
	MetricDescriptor_CUMULATIVE_DOUBLE MetricDescriptor_Type = 5
	// Distribution cumulative measurement. The count and sum cannot decrease,
	// if resets then the start_time should also be reset.
	MetricDescriptor_CUMULATIVE_DISTRIBUTION MetricDescriptor_Type = 6
	// Some frameworks implemented Histograms as a summary of observations
	// (usually things like request durations and response sizes). While it
	// also provides a total count of observations and a sum of all observed
	// values, it calculates configurable percentiles over a sliding time
	// window. This is not recommended, since it cannot be aggregated.
	MetricDescriptor_SUMMARY MetricDescriptor_Type = 7
)

// Enum value maps for MetricDescriptor_Type.
var (
	MetricDescriptor_Type_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "GAUGE_INT64",
		2: "GAUGE_DOUBLE",
		3: "GAUGE_DISTRIBUTION",
		4: "CUMULATIVE_INT64",
		5: "CUMULATIVE_DOUBLE",
		6: "CUMULATIVE_DISTRIBUTION",
		7: "SUMMARY",
	}
	MetricDescriptor_Type_value = map[string]int32{
		"UNSPECIFIED":             0,
		"GAUGE_INT64":             1,
		"GAUGE_DOUBLE":            2,
		"GAUGE_DISTRIBUTION":      3,
		"CUMULATIVE_INT64":        4,
		"CUMULATIVE_DOUBLE":       5,
		"CUMULATIVE_DISTRIBUTION": 6,
		"SUMMARY":                 7,
	}
)

func (x MetricDescriptor_Type) Enum() *MetricDescriptor_Type {
	p := new(MetricDescriptor_Type)
	*p = x
	return p
}

func (x MetricDescriptor_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetricDescriptor_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_opencensus_proto_metrics_v1_metrics_proto_enumTypes[0].Descriptor()
}

func (MetricDescriptor_Type) Type() protoreflect.EnumType {
	return &file_opencensus_proto_metrics_v1_metrics_proto_enumTypes[0]
}

func (x MetricDescriptor_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetricDescriptor_Type.Descriptor instead.
func (MetricDescriptor_Type) EnumDescriptor() ([]byte, []int) {
	return file_opencensus_proto_metrics_v1_metrics_proto_rawDescGZIP(), []int{1, 0}
}

// Defines a Metric which has one or more timeseries.
type Metric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The descriptor of the Metric.
	// TODO(issue #152): consider only sending the name of descriptor for
	// optimization.
	MetricDescriptor *MetricDescriptor `protobuf:"bytes,1,opt,name=metric_descriptor,json=metricDescriptor,proto3" json:"metric_descriptor,omitempty"`
	// One or more timeseries for a single metric, where each timeseries has
	// one or more points.
	Timeseries []*TimeSeries `protobuf:"bytes,2,rep,name=timeseries,proto3" json:"timeseries,omitempty"`
	// The resource for the metric. If unset, it may be set to a default value
	// provided for a sequence of messages in an RPC stream.
	Resource *v1.Resource `protobuf:"bytes,3,opt,name=resource,proto3" json:"resource,omitempty"`
}

func (x *Metric) Reset() {
	*x = Metric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Metric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Metric) ProtoMessage() {}

func (x *Metric) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Metric.ProtoReflect.Descriptor instead.
func (*Metric) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_metrics_v1_metrics_proto_rawDescGZIP(), []int{0}
}

func (x *Metric) GetMetricDescriptor() *MetricDescriptor {
	if x != nil {
		return x.MetricDescriptor
	}
	return nil
}

func (x *Metric) GetTimeseries() []*TimeSeries {
	if x != nil {
		return x.Timeseries
	}
	return nil
}

func (x *Metric) GetResource() *v1.Resource {
	if x != nil {
		return x.Resource
	}
	return nil
}

// Defines a metric type and its schema.
type MetricDescriptor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The metric type, including its DNS name prefix. It must be unique.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A detailed description of the metric, which can be used in documentation.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// The unit in which the metric value is reported. Follows the format
	// described by http://unitsofmeasure.org/ucum.html.
	Unit string                `protobuf:"bytes,3,opt,name=unit,proto3" json:"unit,omitempty"`
	Type MetricDescriptor_Type `protobuf:"varint,4,opt,name=type,proto3,enum=opencensus.proto.metrics.v1.MetricDescriptor_Type" json:"type,omitempty"`
	// The label keys associated with the metric descriptor.
	LabelKeys []*LabelKey `protobuf:"bytes,5,rep,name=label_keys,json=labelKeys,proto3" json:"label_keys,omitempty"`
}

func (x *MetricDescriptor) Reset() {
	*x = MetricDescriptor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MetricDescriptor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetricDescriptor) ProtoMessage() {}

func (x *MetricDescriptor) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetricDescriptor.ProtoReflect.Descriptor instead.
func (*MetricDescriptor) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_metrics_v1_metrics_proto_rawDescGZIP(), []int{1}
}

func (x *MetricDescriptor) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MetricDescriptor) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *MetricDescriptor) GetUnit() string {
	if x != nil {
		return x.Unit
	}
	return ""
}

func (x *MetricDescriptor) GetType() MetricDescriptor_Type {
	if x != nil {
		return x.Type
	}
	return MetricDescriptor_UNSPECIFIED
}

func (x *MetricDescriptor) GetLabelKeys() []*LabelKey {
	if x != nil {
		return x.LabelKeys
	}
	return nil
}

// Defines a label key associated with a metric descriptor.
type LabelKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The key for the label.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// A human-readable description of what this label key represents.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *LabelKey) Reset() {
	*x = LabelKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LabelKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelKey) ProtoMessage() {}

func (x *LabelKey) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabelKey.ProtoReflect.Descriptor instead.
func (*LabelKey) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_metrics_v1_metrics_proto_rawDescGZIP(), []int{2}
}

func (x *LabelKey) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *LabelKey) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// A collection of data points that describes the time-varying values
// of a metric.
type TimeSeries struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Must be present for cumulative metrics. The time when the cumulative value
	// was reset to zero. Exclusive. The cumulative value is over the time interval
	// (start_timestamp, timestamp]. If not specified, the backend can use the
	// previous recorded value.
	StartTimestamp *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_timestamp,json=startTimestamp,proto3" json:"start_timestamp,omitempty"`
	// The set of label values that uniquely identify this timeseries. Applies to
	// all points. The order of label values must match that of label keys in the
	// metric descriptor.
	LabelValues []*LabelValue `protobuf:"bytes,2,rep,name=label_values,json=labelValues,proto3" json:"label_values,omitempty"`
	// The data points of this timeseries. Point.value type MUST match the
	// MetricDescriptor.type.
	Points []*Point `protobuf:"bytes,3,rep,name=points,proto3" json:"points,omitempty"`
}

func (x *TimeSeries) Reset() {
	*x = TimeSeries{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimeSeries) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimeSeries) ProtoMessage() {}

func (x *TimeSeries) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimeSeries.ProtoReflect.Descriptor instead.
func (*TimeSeries) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_metrics_v1_metrics_proto_rawDescGZIP(), []int{3}
}

func (x *TimeSeries) GetStartTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTimestamp
	}
	return nil
}

func (x *TimeSeries) GetLabelValues() []*LabelValue {
	if x != nil {
		return x.LabelValues
	}
	return nil
}

func (x *TimeSeries) GetPoints() []*Point {
	if x != nil {
		return x.Points
	}
	return nil
}

type LabelValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The value for the label.
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// If false the value field is ignored and considered not set.
	// This is used to differentiate a missing label from an empty string.
	HasValue bool `protobuf:"varint,2,opt,name=has_value,json=hasValue,proto3" json:"has_value,omitempty"`
}

func (x *LabelValue) Reset() {
	*x = LabelValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LabelValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelValue) ProtoMessage() {}

func (x *LabelValue) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabelValue.ProtoReflect.Descriptor instead.
func (*LabelValue) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_metrics_v1_metrics_proto_rawDescGZIP(), []int{4}
}

func (x *LabelValue) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *LabelValue) GetHasValue() bool {
	if x != nil {
		return x.HasValue
	}
	return false
}

// A timestamped measurement.
type Point struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The moment when this point was recorded. Inclusive.
	// If not specified, the timestamp will be decided by the backend.
	Timestamp *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// The actual point value.
	//
	// Types that are assignable to Value:
	//	*Point_Int64Value
	//	*Point_DoubleValue
	//	*Point_DistributionValue
	//	*Point_SummaryValue
	Value isPoint_Value `protobuf_oneof:"value"`
}

func (x *Point) Reset() {
	*x = Point{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Point) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Point) ProtoMessage() {}

func (x *Point) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Point.ProtoReflect.Descriptor instead.
func (*Point) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_metrics_v1_metrics_proto_rawDescGZIP(), []int{5}
}

func (x *Point) GetTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.Timestamp
	}
	return nil
}

func (m *Point) GetValue() isPoint_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *Point) GetInt64Value() int64 {
	if x, ok := x.GetValue().(*Point_Int64Value); ok {
		return x.Int64Value
	}
	return 0
}

func (x *Point) GetDoubleValue() float64 {
	if x, ok := x.GetValue().(*Point_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

func (x *Point) GetDistributionValue() *DistributionValue {
	if x, ok := x.GetValue().(*Point_DistributionValue); ok {
		return x.DistributionValue
	}
	return nil
}

func (x *Point) GetSummaryValue() *SummaryValue {
	if x, ok := x.GetValue().(*Point_SummaryValue); ok {
		return x.SummaryValue
	}
	return nil
}

type isPoint_Value interface {
	isPoint_Value()
}

type Point_Int64Value struct {
	// A 64-bit integer.
	Int64Value int64 `protobuf:"varint,2,opt,name=int64_value,json=int64Value,proto3,oneof"`
}

type Point_DoubleValue struct {
	// A 64-bit double-precision floating-point number.
	DoubleValue float64 `protobuf:"fixed64,3,opt,name=double_value,json=doubleValue,proto3,oneof"`
}

type Point_DistributionValue struct {
	// A distribution value.
	DistributionValue *DistributionValue `protobuf:"bytes,4,opt,name=distribution_value,json=distributionValue,proto3,oneof"`
}

type Point_SummaryValue struct {
	// A summary value. This is not recommended, since it cannot be aggregated.
	SummaryValue *SummaryValue `protobuf:"bytes,5,opt,name=summary_value,json=summaryValue,proto3,oneof"`
}

func (*Point_Int64Value) isPoint_Value() {}

func (*Point_DoubleValue) isPoint_Value() {}

func (*Point_DistributionValue) isPoint_Value() {}

func (*Point_SummaryValue) isPoint_Value() {}

// Distribution contains summary statistics for a population of values. It
// optionally contains a histogram representing the distribution of those
// values across a set of buckets.
type DistributionValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of values in the population. Must be non-negative. This value
	// must equal the sum of the values in bucket_counts if a histogram is
	// provided.
	Count int64 `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	// The sum of the values in the population. If count is zero then this field
	// must be zero.
	Sum float64 `protobuf:"fixed64,2,opt,name=sum,proto3" json:"sum,omitempty"`
	// The sum of squared deviations from the mean of the values in the
	// population. For values x_i this is:
	//
	//     Sum[i=1..n]((x_i - mean)^2)
	//
	// Knuth, "The Art of Computer Programming", Vol. 2, page 323, 3rd edition
	// describes Welford's method for accumulating this sum in one pass.
	//
	// If count is zero then this field must be zero.
	SumOfSquaredDeviation float64 `protobuf:"fixed64,3,opt,name=sum_of_squared_deviation,json=sumOfSquaredDeviation,proto3" json:"sum_of_squared_deviation,omitempty"`
	// Don't change bucket boundaries within a TimeSeries if your backend doesn't
	// support this.
	// TODO(issue #152): consider not required to send bucket options for
	// optimization.
	BucketOptions *DistributionValue_BucketOptions `protobuf:"bytes,4,opt,name=bucket_options,json=bucketOptions,proto3" json:"bucket_options,omitempty"`
	// If the distribution does not have a histogram, then omit this field.
	// If there is a histogram, then the sum of the values in the Bucket counts
	// must equal the value in the count field of the distribution.
	Buckets []*DistributionValue_Bucket `protobuf:"bytes,5,rep,name=buckets,proto3" json:"buckets,omitempty"`
}

func (x *DistributionValue) Reset() {
	*x = DistributionValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DistributionValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DistributionValue) ProtoMessage() {}

func (x *DistributionValue) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DistributionValue.ProtoReflect.Descriptor instead.
func (*DistributionValue) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_metrics_v1_metrics_proto_rawDescGZIP(), []int{6}
}

func (x *DistributionValue) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

func (x *DistributionValue) GetSum() float64 {
	if x != nil {
		return x.Sum
	}
	return 0
}

func (x *DistributionValue) GetSumOfSquaredDeviation() float64 {
	if x != nil {
		return x.SumOfSquaredDeviation
	}
	return 0
}

func (x *DistributionValue) GetBucketOptions() *DistributionValue_BucketOptions {
	if x != nil {
		return x.BucketOptions
	}
	return nil
}

func (x *DistributionValue) GetBuckets() []*DistributionValue_Bucket {
	if x != nil {
		return x.Buckets
	}
	return nil
}

// The start_timestamp only applies to the count and sum in the SummaryValue.
type SummaryValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The total number of recorded values since start_time. Optional since
	// some systems don't expose this.
	Count *wrapperspb.Int64Value `protobuf:"bytes,1,opt,name=count,proto3" json:"count,omitempty"`
	// The total sum of recorded values since start_time. Optional since some
	// systems don't expose this. If count is zero then this field must be zero.
	// This field must be unset if the sum is not available.
	Sum *wrapperspb.DoubleValue `protobuf:"bytes,2,opt,name=sum,proto3" json:"sum,omitempty"`
	// Values calculated over an arbitrary time window.
	Snapshot *SummaryValue_Snapshot `protobuf:"bytes,3,opt,name=snapshot,proto3" json:"snapshot,omitempty"`
}

func (x *SummaryValue) Reset() {
	*x = SummaryValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SummaryValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SummaryValue) ProtoMessage() {}

func (x *SummaryValue) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SummaryValue.ProtoReflect.Descriptor instead.
func (*SummaryValue) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_metrics_v1_metrics_proto_rawDescGZIP(), []int{7}
}

func (x *SummaryValue) GetCount() *wrapperspb.Int64Value {
	if x != nil {
		return x.Count
	}
	return nil
}

func (x *SummaryValue) GetSum() *wrapperspb.DoubleValue {
	if x != nil {
		return x.Sum
	}
	return nil
}

func (x *SummaryValue) GetSnapshot() *SummaryValue_Snapshot {
	if x != nil {
		return x.Snapshot
	}
	return nil
}

// A Distribution may optionally contain a histogram of the values in the
// population. The bucket boundaries for that histogram are described by
// BucketOptions.
//
// If bucket_options has no type, then there is no histogram associated with
// the Distribution.
type DistributionValue_BucketOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Type:
	//	*DistributionValue_BucketOptions_Explicit_
	Type isDistributionValue_BucketOptions_Type `protobuf_oneof:"type"`
}

func (x *DistributionValue_BucketOptions) Reset() {
	*x = DistributionValue_BucketOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DistributionValue_BucketOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DistributionValue_BucketOptions) ProtoMessage() {}

func (x *DistributionValue_BucketOptions) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DistributionValue_BucketOptions.ProtoReflect.Descriptor instead.
func (*DistributionValue_BucketOptions) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_metrics_v1_metrics_proto_rawDescGZIP(), []int{6, 0}
}

func (m *DistributionValue_BucketOptions) GetType() isDistributionValue_BucketOptions_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *DistributionValue_BucketOptions) GetExplicit() *DistributionValue_BucketOptions_Explicit {
	if x, ok := x.GetType().(*DistributionValue_BucketOptions_Explicit_); ok {
		return x.Explicit
	}
	return nil
}

type isDistributionValue_BucketOptions_Type interface {
	isDistributionValue_BucketOptions_Type()
}

type DistributionValue_BucketOptions_Explicit_ struct {
	// Bucket with explicit bounds.
	Explicit *DistributionValue_BucketOptions_Explicit `protobuf:"bytes,1,opt,name=explicit,proto3,oneof"`
}

func (*DistributionValue_BucketOptions_Explicit_) isDistributionValue_BucketOptions_Type() {}

type DistributionValue_Bucket struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of values in each bucket of the histogram, as described in
	// bucket_bounds.
	Count int64 `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	// If the distribution does not have a histogram, then omit this field.
	Exemplar *DistributionValue_Exemplar `protobuf:"bytes,2,opt,name=exemplar,proto3" json:"exemplar,omitempty"`
}

func (x *DistributionValue_Bucket) Reset() {
	*x = DistributionValue_Bucket{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DistributionValue_Bucket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DistributionValue_Bucket) ProtoMessage() {}

func (x *DistributionValue_Bucket) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DistributionValue_Bucket.ProtoReflect.Descriptor instead.
func (*DistributionValue_Bucket) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_metrics_v1_metrics_proto_rawDescGZIP(), []int{6, 1}
}

func (x *DistributionValue_Bucket) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

func (x *DistributionValue_Bucket) GetExemplar() *DistributionValue_Exemplar {
	if x != nil {
		return x.Exemplar
	}
	return nil
}

// Exemplars are example points that may be used to annotate aggregated
// Distribution values. They are metadata that gives information about a
// particular value added to a Distribution bucket.
type DistributionValue_Exemplar struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value of the exemplar point. It determines which bucket the exemplar
	// belongs to.
	Value float64 `protobuf:"fixed64,1,opt,name=value,proto3" json:"value,omitempty"`
	// The observation (sampling) time of the above value.
	Timestamp *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Contextual information about the example value.
	Attachments map[string]string `protobuf:"bytes,3,rep,name=attachments,proto3" json:"attachments,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *DistributionValue_Exemplar) Reset() {
	*x = DistributionValue_Exemplar{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DistributionValue_Exemplar) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DistributionValue_Exemplar) ProtoMessage() {}

func (x *DistributionValue_Exemplar) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DistributionValue_Exemplar.ProtoReflect.Descriptor instead.
func (*DistributionValue_Exemplar) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_metrics_v1_metrics_proto_rawDescGZIP(), []int{6, 2}
}

func (x *DistributionValue_Exemplar) GetValue() float64 {
	if x != nil {
		return x.Value
	}
	return 0
}

func (x *DistributionValue_Exemplar) GetTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.Timestamp
	}
	return nil
}

func (x *DistributionValue_Exemplar) GetAttachments() map[string]string {
	if x != nil {
		return x.Attachments
	}
	return nil
}

// Specifies a set of buckets with arbitrary upper-bounds.
// This defines size(bounds) + 1 (= N) buckets. The boundaries for bucket
// index i are:
//
// [0, bucket_bounds[i]) for i == 0
// [bucket_bounds[i-1], bucket_bounds[i]) for 0 < i < N-1
// [bucket_bounds[i], +infinity) for i == N-1
type DistributionValue_BucketOptions_Explicit struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The values must be strictly increasing and > 0.
	Bounds []float64 `protobuf:"fixed64,1,rep,packed,name=bounds,proto3" json:"bounds,omitempty"`
}

func (x *DistributionValue_BucketOptions_Explicit) Reset() {
	*x = DistributionValue_BucketOptions_Explicit{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DistributionValue_BucketOptions_Explicit) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DistributionValue_BucketOptions_Explicit) ProtoMessage() {}

func (x *DistributionValue_BucketOptions_Explicit) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DistributionValue_BucketOptions_Explicit.ProtoReflect.Descriptor instead.
func (*DistributionValue_BucketOptions_Explicit) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_metrics_v1_metrics_proto_rawDescGZIP(), []int{6, 0, 0}
}

func (x *DistributionValue_BucketOptions_Explicit) GetBounds() []float64 {
	if x != nil {
		return x.Bounds
	}
	return nil
}

// The values in this message can be reset at arbitrary unknown times, with
// the requirement that all of them are reset at the same time.
type SummaryValue_Snapshot struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of values in the snapshot. Optional since some systems don't
	// expose this.
	Count *wrapperspb.Int64Value `protobuf:"bytes,1,opt,name=count,proto3" json:"count,omitempty"`
	// The sum of values in the snapshot. Optional since some systems don't
	// expose this. If count is zero then this field must be zero or not set
	// (if not supported).
	Sum *wrapperspb.DoubleValue `protobuf:"bytes,2,opt,name=sum,proto3" json:"sum,omitempty"`
	// A list of values at different percentiles of the distribution calculated
	// from the current snapshot. The percentiles must be strictly increasing.
	PercentileValues []*SummaryValue_Snapshot_ValueAtPercentile `protobuf:"bytes,3,rep,name=percentile_values,json=percentileValues,proto3" json:"percentile_values,omitempty"`
}

func (x *SummaryValue_Snapshot) Reset() {
	*x = SummaryValue_Snapshot{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SummaryValue_Snapshot) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SummaryValue_Snapshot) ProtoMessage() {}

func (x *SummaryValue_Snapshot) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SummaryValue_Snapshot.ProtoReflect.Descriptor instead.
func (*SummaryValue_Snapshot) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_metrics_v1_metrics_proto_rawDescGZIP(), []int{7, 0}
}

func (x *SummaryValue_Snapshot) GetCount() *wrapperspb.Int64Value {
	if x != nil {
		return x.Count
	}
	return nil
}

func (x *SummaryValue_Snapshot) GetSum() *wrapperspb.DoubleValue {
	if x != nil {
		return x.Sum
	}
	return nil
}

func (x *SummaryValue_Snapshot) GetPercentileValues() []*SummaryValue_Snapshot_ValueAtPercentile {
	if x != nil {
		return x.PercentileValues
	}
	return nil
}

// Represents the value at a given percentile of a distribution.
type SummaryValue_Snapshot_ValueAtPercentile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The percentile of a distribution. Must be in the interval
	// (0.0, 100.0].
	Percentile float64 `protobuf:"fixed64,1,opt,name=percentile,proto3" json:"percentile,omitempty"`
	// The value at the given percentile of a distribution.
	Value float64 `protobuf:"fixed64,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *SummaryValue_Snapshot_ValueAtPercentile) Reset() {
	*x = SummaryValue_Snapshot_ValueAtPercentile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SummaryValue_Snapshot_ValueAtPercentile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SummaryValue_Snapshot_ValueAtPercentile) ProtoMessage() {}

func (x *SummaryValue_Snapshot_ValueAtPercentile) ProtoReflect() protoreflect.Message {
	mi := &file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SummaryValue_Snapshot_ValueAtPercentile.ProtoReflect.Descriptor instead.
func (*SummaryValue_Snapshot_ValueAtPercentile) Descriptor() ([]byte, []int) {
	return file_opencensus_proto_metrics_v1_metrics_proto_rawDescGZIP(), []int{7, 0, 0}
}

func (x *SummaryValue_Snapshot_ValueAtPercentile) GetPercentile() float64 {
	if x != nil {
		return x.Percentile
	}
	return 0
}

func (x *SummaryValue_Snapshot_ValueAtPercentile) GetValue() float64 {
	if x != nil {
		return x.Value
	}
	return 0
}

var File_opencensus_proto_metrics_v1_metrics_proto protoreflect.FileDescriptor

var file_opencensus_proto_metrics_v1_metrics_proto_rawDesc = []byte{
	0x0a, 0x29, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x6f, 0x70, 0x65,
	0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70,
	0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x6f, 0x70, 0x65, 0x6e, 0x63,
	0x65, 0x6e, 0x73, 0x75, 0x73, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf1, 0x01, 0x0a, 0x06, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x12, 0x5a, 0x0a, 0x11, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x6f,
	0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x52, 0x10, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x12, 0x47, 0x0a,
	0x0a, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x27, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x0a, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x42, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63,
	0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x96, 0x03, 0x0a, 0x10, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65,
	0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x44, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x44, 0x0a, 0x0a, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73,
	0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x4b, 0x65, 0x79, 0x52, 0x09, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x4b, 0x65, 0x79, 0x73, 0x22, 0xa9, 0x01, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x47, 0x41, 0x55, 0x47, 0x45, 0x5f, 0x49, 0x4e, 0x54, 0x36, 0x34,
	0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x47, 0x41, 0x55, 0x47, 0x45, 0x5f, 0x44, 0x4f, 0x55, 0x42,
	0x4c, 0x45, 0x10, 0x02, 0x12, 0x16, 0x0a, 0x12, 0x47, 0x41, 0x55, 0x47, 0x45, 0x5f, 0x44, 0x49,
	0x53, 0x54, 0x52, 0x49, 0x42, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x12, 0x14, 0x0a, 0x10,
	0x43, 0x55, 0x4d, 0x55, 0x4c, 0x41, 0x54, 0x49, 0x56, 0x45, 0x5f, 0x49, 0x4e, 0x54, 0x36, 0x34,
	0x10, 0x04, 0x12, 0x15, 0x0a, 0x11, 0x43, 0x55, 0x4d, 0x55, 0x4c, 0x41, 0x54, 0x49, 0x56, 0x45,
	0x5f, 0x44, 0x4f, 0x55, 0x42, 0x4c, 0x45, 0x10, 0x05, 0x12, 0x1b, 0x0a, 0x17, 0x43, 0x55, 0x4d,
	0x55, 0x4c, 0x41, 0x54, 0x49, 0x56, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x52, 0x49, 0x42, 0x55,
	0x54, 0x49, 0x4f, 0x4e, 0x10, 0x06, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x55, 0x4d, 0x4d, 0x41, 0x52,
	0x59, 0x10, 0x07, 0x22, 0x3e, 0x0a, 0x08, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x4b, 0x65, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0xd9, 0x01, 0x0a, 0x0a, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69,
	0x65, 0x73, 0x12, 0x43, 0x0a, 0x0f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x4a, 0x0a, 0x0c, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0b, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x12, 0x3a, 0x0a, 0x06, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x22,
	0x3f, 0x0a, 0x0a, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x68, 0x61, 0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x68, 0x61, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x22, 0xc5, 0x02, 0x0a, 0x05, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x38, 0x0a, 0x09, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x12, 0x21, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x0a, 0x69, 0x6e, 0x74,
	0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x23, 0x0a, 0x0c, 0x64, 0x6f, 0x75, 0x62, 0x6c,
	0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52,
	0x0b, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x5f, 0x0a, 0x12,
	0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63,
	0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x48, 0x00, 0x52, 0x11, 0x64, 0x69, 0x73, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x50, 0x0a,
	0x0d, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x48,
	0x00, 0x52, 0x0c, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42,
	0x07, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xcb, 0x06, 0x0a, 0x11, 0x44, 0x69, 0x73,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x75, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x01, 0x52, 0x03, 0x73, 0x75, 0x6d, 0x12, 0x37, 0x0a, 0x18, 0x73, 0x75, 0x6d, 0x5f, 0x6f, 0x66,
	0x5f, 0x73, 0x71, 0x75, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x15, 0x73, 0x75, 0x6d, 0x4f, 0x66, 0x53,
	0x71, 0x75, 0x61, 0x72, 0x65, 0x64, 0x44, 0x65, 0x76, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x63, 0x0a, 0x0e, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65,
	0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0d, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4f, 0x0a, 0x07, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73,
	0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x07, 0x62, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x73, 0x1a, 0xa0, 0x01, 0x0a, 0x0d, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x63, 0x0a, 0x08, 0x65, 0x78, 0x70, 0x6c, 0x69,
	0x63, 0x69, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x6f, 0x70, 0x65, 0x6e,
	0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74,
	0x48, 0x00, 0x52, 0x08, 0x65, 0x78, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x1a, 0x22, 0x0a, 0x08,
	0x45, 0x78, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x62, 0x6f, 0x75, 0x6e,
	0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x01, 0x52, 0x06, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x73,
	0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x1a, 0x73, 0x0a, 0x06, 0x42, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x53, 0x0a, 0x08, 0x65, 0x78, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x6f, 0x70, 0x65,
	0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x45, 0x78, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x72, 0x52, 0x08, 0x65, 0x78, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x72, 0x1a, 0x86, 0x02,
	0x0a, 0x08, 0x45, 0x78, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x38, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x6a, 0x0a, 0x0b, 0x61, 0x74,
	0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x48, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69,
	0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x2e,
	0x45, 0x78, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x72, 0x2e, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x61, 0x74, 0x74, 0x61, 0x63,
	0x68, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xef, 0x03, 0x0a, 0x0c, 0x53, 0x75, 0x6d, 0x6d, 0x61,
	0x72, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x31, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2e, 0x0a, 0x03, 0x73, 0x75,
	0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x03, 0x73, 0x75, 0x6d, 0x12, 0x4e, 0x0a, 0x08, 0x73, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x6f,
	0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61,
	0x72, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x2e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74,
	0x52, 0x08, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x1a, 0xab, 0x02, 0x0a, 0x08, 0x53,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x31, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2e, 0x0a, 0x03, 0x73, 0x75,
	0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x03, 0x73, 0x75, 0x6d, 0x12, 0x71, 0x0a, 0x11, 0x70, 0x65,
	0x72, 0x63, 0x65, 0x6e, 0x74, 0x69, 0x6c, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73,
	0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x2e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x41,
	0x74, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x69, 0x6c, 0x65, 0x52, 0x10, 0x70, 0x65, 0x72,
	0x63, 0x65, 0x6e, 0x74, 0x69, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0x49, 0x0a,
	0x11, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x41, 0x74, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x69,
	0x6c, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x69, 0x6c, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0a, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x69,
	0x6c, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x01, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x97, 0x01, 0x0a, 0x1e, 0x69, 0x6f, 0x2e,
	0x6f, 0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x0c, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x44, 0x67, 0x69, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2d, 0x69,
	0x6e, 0x73, 0x74, 0x72, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x6f,
	0x70, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x2d, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x67, 0x65, 0x6e, 0x2d, 0x67, 0x6f, 0x2f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2f, 0x76,
	0x31, 0xea, 0x02, 0x1e, 0x4f, 0x70, 0x65, 0x6e, 0x43, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x3a, 0x3a,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x3a, 0x3a, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x3a,
	0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_opencensus_proto_metrics_v1_metrics_proto_rawDescOnce sync.Once
	file_opencensus_proto_metrics_v1_metrics_proto_rawDescData = file_opencensus_proto_metrics_v1_metrics_proto_rawDesc
)

func file_opencensus_proto_metrics_v1_metrics_proto_rawDescGZIP() []byte {
	file_opencensus_proto_metrics_v1_metrics_proto_rawDescOnce.Do(func() {
		file_opencensus_proto_metrics_v1_metrics_proto_rawDescData = protoimpl.X.CompressGZIP(file_opencensus_proto_metrics_v1_metrics_proto_rawDescData)
	})
	return file_opencensus_proto_metrics_v1_metrics_proto_rawDescData
}

var file_opencensus_proto_metrics_v1_metrics_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_opencensus_proto_metrics_v1_metrics_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_opencensus_proto_metrics_v1_metrics_proto_goTypes = []interface{}{
	(MetricDescriptor_Type)(0),                       // 0: opencensus.proto.metrics.v1.MetricDescriptor.Type
	(*Metric)(nil),                                   // 1: opencensus.proto.metrics.v1.Metric
	(*MetricDescriptor)(nil),                         // 2: opencensus.proto.metrics.v1.MetricDescriptor
	(*LabelKey)(nil),                                 // 3: opencensus.proto.metrics.v1.LabelKey
	(*TimeSeries)(nil),                               // 4: opencensus.proto.metrics.v1.TimeSeries
	(*LabelValue)(nil),                               // 5: opencensus.proto.metrics.v1.LabelValue
	(*Point)(nil),                                    // 6: opencensus.proto.metrics.v1.Point
	(*DistributionValue)(nil),                        // 7: opencensus.proto.metrics.v1.DistributionValue
	(*SummaryValue)(nil),                             // 8: opencensus.proto.metrics.v1.SummaryValue
	(*DistributionValue_BucketOptions)(nil),          // 9: opencensus.proto.metrics.v1.DistributionValue.BucketOptions
	(*DistributionValue_Bucket)(nil),                 // 10: opencensus.proto.metrics.v1.DistributionValue.Bucket
	(*DistributionValue_Exemplar)(nil),               // 11: opencensus.proto.metrics.v1.DistributionValue.Exemplar
	(*DistributionValue_BucketOptions_Explicit)(nil), // 12: opencensus.proto.metrics.v1.DistributionValue.BucketOptions.Explicit
	nil,                           // 13: opencensus.proto.metrics.v1.DistributionValue.Exemplar.AttachmentsEntry
	(*SummaryValue_Snapshot)(nil), // 14: opencensus.proto.metrics.v1.SummaryValue.Snapshot
	(*SummaryValue_Snapshot_ValueAtPercentile)(nil), // 15: opencensus.proto.metrics.v1.SummaryValue.Snapshot.ValueAtPercentile
	(*v1.Resource)(nil),                             // 16: opencensus.proto.resource.v1.Resource
	(*timestamppb.Timestamp)(nil),                   // 17: google.protobuf.Timestamp
	(*wrapperspb.Int64Value)(nil),                   // 18: google.protobuf.Int64Value
	(*wrapperspb.DoubleValue)(nil),                  // 19: google.protobuf.DoubleValue
}
var file_opencensus_proto_metrics_v1_metrics_proto_depIdxs = []int32{
	2,  // 0: opencensus.proto.metrics.v1.Metric.metric_descriptor:type_name -> opencensus.proto.metrics.v1.MetricDescriptor
	4,  // 1: opencensus.proto.metrics.v1.Metric.timeseries:type_name -> opencensus.proto.metrics.v1.TimeSeries
	16, // 2: opencensus.proto.metrics.v1.Metric.resource:type_name -> opencensus.proto.resource.v1.Resource
	0,  // 3: opencensus.proto.metrics.v1.MetricDescriptor.type:type_name -> opencensus.proto.metrics.v1.MetricDescriptor.Type
	3,  // 4: opencensus.proto.metrics.v1.MetricDescriptor.label_keys:type_name -> opencensus.proto.metrics.v1.LabelKey
	17, // 5: opencensus.proto.metrics.v1.TimeSeries.start_timestamp:type_name -> google.protobuf.Timestamp
	5,  // 6: opencensus.proto.metrics.v1.TimeSeries.label_values:type_name -> opencensus.proto.metrics.v1.LabelValue
	6,  // 7: opencensus.proto.metrics.v1.TimeSeries.points:type_name -> opencensus.proto.metrics.v1.Point
	17, // 8: opencensus.proto.metrics.v1.Point.timestamp:type_name -> google.protobuf.Timestamp
	7,  // 9: opencensus.proto.metrics.v1.Point.distribution_value:type_name -> opencensus.proto.metrics.v1.DistributionValue
	8,  // 10: opencensus.proto.metrics.v1.Point.summary_value:type_name -> opencensus.proto.metrics.v1.SummaryValue
	9,  // 11: opencensus.proto.metrics.v1.DistributionValue.bucket_options:type_name -> opencensus.proto.metrics.v1.DistributionValue.BucketOptions
	10, // 12: opencensus.proto.metrics.v1.DistributionValue.buckets:type_name -> opencensus.proto.metrics.v1.DistributionValue.Bucket
	18, // 13: opencensus.proto.metrics.v1.SummaryValue.count:type_name -> google.protobuf.Int64Value
	19, // 14: opencensus.proto.metrics.v1.SummaryValue.sum:type_name -> google.protobuf.DoubleValue
	14, // 15: opencensus.proto.metrics.v1.SummaryValue.snapshot:type_name -> opencensus.proto.metrics.v1.SummaryValue.Snapshot
	12, // 16: opencensus.proto.metrics.v1.DistributionValue.BucketOptions.explicit:type_name -> opencensus.proto.metrics.v1.DistributionValue.BucketOptions.Explicit
	11, // 17: opencensus.proto.metrics.v1.DistributionValue.Bucket.exemplar:type_name -> opencensus.proto.metrics.v1.DistributionValue.Exemplar
	17, // 18: opencensus.proto.metrics.v1.DistributionValue.Exemplar.timestamp:type_name -> google.protobuf.Timestamp
	13, // 19: opencensus.proto.metrics.v1.DistributionValue.Exemplar.attachments:type_name -> opencensus.proto.metrics.v1.DistributionValue.Exemplar.AttachmentsEntry
	18, // 20: opencensus.proto.metrics.v1.SummaryValue.Snapshot.count:type_name -> google.protobuf.Int64Value
	19, // 21: opencensus.proto.metrics.v1.SummaryValue.Snapshot.sum:type_name -> google.protobuf.DoubleValue
	15, // 22: opencensus.proto.metrics.v1.SummaryValue.Snapshot.percentile_values:type_name -> opencensus.proto.metrics.v1.SummaryValue.Snapshot.ValueAtPercentile
	23, // [23:23] is the sub-list for method output_type
	23, // [23:23] is the sub-list for method input_type
	23, // [23:23] is the sub-list for extension type_name
	23, // [23:23] is the sub-list for extension extendee
	0,  // [0:23] is the sub-list for field type_name
}

func init() { file_opencensus_proto_metrics_v1_metrics_proto_init() }
func file_opencensus_proto_metrics_v1_metrics_proto_init() {
	if File_opencensus_proto_metrics_v1_metrics_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Metric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MetricDescriptor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LabelKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimeSeries); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LabelValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Point); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DistributionValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SummaryValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DistributionValue_BucketOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DistributionValue_Bucket); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DistributionValue_Exemplar); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DistributionValue_BucketOptions_Explicit); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SummaryValue_Snapshot); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SummaryValue_Snapshot_ValueAtPercentile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*Point_Int64Value)(nil),
		(*Point_DoubleValue)(nil),
		(*Point_DistributionValue)(nil),
		(*Point_SummaryValue)(nil),
	}
	file_opencensus_proto_metrics_v1_metrics_proto_msgTypes[8].OneofWrappers = []interface{}{
		(*DistributionValue_BucketOptions_Explicit_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_opencensus_proto_metrics_v1_metrics_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_opencensus_proto_metrics_v1_metrics_proto_goTypes,
		DependencyIndexes: file_opencensus_proto_metrics_v1_metrics_proto_depIdxs,
		EnumInfos:         file_opencensus_proto_metrics_v1_metrics_proto_enumTypes,
		MessageInfos:      file_opencensus_proto_metrics_v1_metrics_proto_msgTypes,
	}.Build()
	File_opencensus_proto_metrics_v1_metrics_proto = out.File
	file_opencensus_proto_metrics_v1_metrics_proto_rawDesc = nil
	file_opencensus_proto_metrics_v1_metrics_proto_goTypes = nil
	file_opencensus_proto_metrics_v1_metrics_proto_depIdxs = nil
}
