------------------------------------------------------------------------------
--                               GNAT Studio                                --
--                                                                          --
--                        Copyright (C) 2020-2023, AdaCore                  --
--                                                                          --
-- This is free software;  you can redistribute it  and/or modify it  under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion.  This software is distributed in the hope  that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License for  more details.  You should have  received  a copy of the GNU --
-- General  Public  License  distributed  with  this  software;   see  file --
-- COPYING3.  If not, go to http://www.gnu.org/licenses for a complete copy --
-- of the license.                                                          --
------------------------------------------------------------------------------

with LSP.JSON_Streams;

with GPS.LSP_Client.Utilities;

package body GPS.LSP_Client.Requests.Completion is

   ------------
   -- Method --
   ------------

   overriding function Method
     (Self : Abstract_Completion_Request) return VSS.Strings.Virtual_String
   is
      pragma Unreferenced (Self);

   begin
      return "textDocument/completion";
   end Method;

   -----------------------
   -- On_Result_Message --
   -----------------------

   overriding procedure On_Result_Message
     (Self   : in out Abstract_Completion_Request;
      Stream : not null access LSP.JSON_Streams.JSON_Stream'Class)
   is
      List : LSP.Messages.CompletionList;
   begin
      LSP.Messages.CompletionList'Read (Stream, List);
      Abstract_Completion_Request'Class (Self).On_Result_Message
        (List);
   end On_Result_Message;

   ------------
   -- Params --
   ------------

   function Params
     (Self : Abstract_Completion_Request)
      return LSP.Messages.CompletionParams is
   begin
      return
        (textDocument =>
           (uri => GPS.LSP_Client.Utilities.To_URI (Self.Text_Document)),
         position     => Self.Position,
         context      => (Is_Set => True, Value => Self.Context),
         others       => <>);
   end Params;

   --------------------------
   -- Is_Request_Supported --
   --------------------------

   overriding function Is_Request_Supported
     (Self    : Abstract_Completion_Request;
      Options : LSP.Messages.ServerCapabilities)
      return Boolean is
   begin
      return Options.completionProvider.Is_Set;
   end Is_Request_Supported;

   ------------
   -- Params --
   ------------

   overriding procedure Params
     (Self   : Abstract_Completion_Request;
      Stream : not null access LSP.JSON_Streams.JSON_Stream'Class) is
   begin
      LSP.Messages.CompletionParams'Write (Stream, Self.Params);
   end Params;

   ------------
   -- Method --
   ------------

   overriding function Method
     (Self : Abstract_CompletionItem_Resolve_Request)
      return VSS.Strings.Virtual_String is
   pragma Unreferenced (Self);

   begin
      return "completionItem/resolve";
   end Method;

   ------------
   -- Params --
   ------------

   function Params
     (Self : Abstract_CompletionItem_Resolve_Request)
      return LSP.Messages.CompletionItem is
   begin
      return Self.Item;
   end Params;

   ------------
   -- Params --
   ------------

   overriding procedure Params
     (Self   : Abstract_CompletionItem_Resolve_Request;
      Stream : not null access LSP.JSON_Streams.JSON_Stream'Class) is
   begin
      LSP.Messages.CompletionItem'Write (Stream, Self.Params);
   end Params;

   --------------------------
   -- Is_Request_Supported --
   --------------------------

   overriding function Is_Request_Supported
     (Self    : Abstract_CompletionItem_Resolve_Request;
      Options : LSP.Messages.ServerCapabilities)
      return Boolean is
   begin
      return Options.completionProvider.Is_Set
        and then Options.completionProvider.Value.resolveProvider.Is_Set
        and then Options.completionProvider.Value.resolveProvider.Value;
   end Is_Request_Supported;

   -----------------------
   -- On_Result_Message --
   -----------------------

   overriding procedure On_Result_Message
     (Self   : in out Abstract_CompletionItem_Resolve_Request;
      Stream : not null access LSP.JSON_Streams.JSON_Stream'Class)
   is
      Item : LSP.Messages.CompletionItem;
   begin
      LSP.Messages.CompletionItem'Read (Stream, Item);
      Abstract_CompletionItem_Resolve_Request'Class (Self).On_Result_Message
        (Item);
   end On_Result_Message;

end GPS.LSP_Client.Requests.Completion;
