---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

<!--
This documentation is auto generated by a script.
Please do not edit this file directly. Run `make gen-docs` instead.
-->

# `glab token create`

Creates user, group, or project access tokens.

## Synopsis

Creates a new access token for a user, group, or project. Defaults to a
project access token, unless user or group name is specified.

The expiration date of the token is calculated by adding the duration
(default: 30 days) to the current date. You can specify a different duration,
or an explicit end date.

The name of the token must be unique. The token is printed to stdout.

Administrators can create full-featured personal access tokens for themselves and for other users.
Non-administrators can create personal access tokens only for themselves (@me) with the scope 'k8s_proxy'.

```plaintext
glab token create <name> [flags]
```

## Aliases

```plaintext
create
new
```

## Examples

```plaintext
# Create project access token for current project
glab token create --access-level developer --scope read_repository --scope read_registry my-project-token

# Create project access token for a specific project
glab token create --repo user/my-repo --access-level owner --scope api my-project-token

# Create a group access token
glab token create --group group/sub-group --access-level owner --scope api my-group-token

# Create a personal access token for current user
glab token create --user @me --scope k8s_proxy my-personal-token

# (administrator only) Create a personal access token for another user
glab token create --user johndoe --scope api johns-personal-token


```

## Options

```plaintext
  -A, --access-level AccessLevel   Access level of the token: one of 'guest', 'reporter', 'developer', 'maintainer', 'owner'. (default no)
  -D, --duration duration          Sets the token duration, in hours. Maximum of 8760. Examples: 24h, 168h, 504w. (default 720h0m0s)
  -E, --expires-at DATE            Sets the token's expiration date and time, in YYYY-MM-DD format. If not specified, --duration is used. (default 0001-01-01)
  -g, --group string               Create a group access token. Ignored if a user or repository argument is set.
  -F, --output string              Format output as 'text' for the token value, 'json' for the actual API token structure. (default "text")
  -R, --repo OWNER/REPO            Select another repository. Can use either OWNER/REPO or `GROUP/NAMESPACE/REPO` format. Also accepts full URL or Git URL.
  -S, --scope strings              Scopes for the token. For a list, see https://docs.gitlab.com/ee/user/profile/personal_access_tokens.html#personal-access-token-scopes. (default [read_repository])
  -U, --user string                Create a personal access token. For the current user, use @me.
```

## Options inherited from parent commands

```plaintext
      --help   Show help for this command.
```
