---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

<!--
This documentation is auto generated by a script.
Please do not edit this file directly. Run `make gen-docs` instead.
-->

# `glab cluster agent bootstrap`

Bootstrap a GitLab Agent for Kubernetes in a project.

## Synopsis

Bootstrap a GitLab Agent for Kubernetes (agentk) in a project.

The first argument must be the name of the agent.

It requires the kubectl and flux commands to be accessible via $PATH.

This command consists of multiple idempotent steps:

1. Register the agent with the project.
2. Create a token for the agent.
    - If the agent has reached the maximum amount of tokens,
      the one that has not been used the longest is revoked
      and a new one is created.
    - If the agent has not reached the maximum amount of tokens,
      a new one is created.
3. Push the Kubernetes Secret that contains the token to the cluster.
4. Create Flux HelmRepository and HelmRelease resource.
5. Commit and Push the created Flux Helm resources to the manifest path.
6. Trigger Flux reconciliation of GitLab Agent HelmRelease.

```plaintext
glab cluster agent bootstrap agent-name [flags]
```

## Aliases

```plaintext
bs
```

## Examples

```plaintext

# Bootstrap "my-agent" to root of Git project in CWD and trigger reconciliation
glab cluster agent bootstrap my-agent

# Bootstrap "my-agent" to "manifests/" of Git project in CWD and trigger reconciliation
glab cluster agent bootstrap my-agent --manifest-path manifests/

# Bootstrap "my-agent" to "manifests/" of Git project in CWD and do not manually trigger a reconilication
glab cluster agent bootstrap my-agent --manifest-path manifests/ --no-reconcile

```

## Options

```plaintext
      --flux-source-name string                 Flux source name. (default "flux-system")
      --flux-source-namespace string            Flux source namespace. (default "flux-system")
      --flux-source-type string                 Source type of the flux-system, e.g. git, oci, helm, ... (default "git")
      --gitlab-agent-token-secret-name string   Name of the Secret where the token for the GitLab Agent is stored. The helm-release-target-namespace is implied for the namespace of the Secret. (default "gitlab-agent-token")
      --helm-release-filepath string            Filepath within the GitLab Agent project to commit the Flux HelmRelease to. (default "gitlab-agent-helm-release.yaml")
      --helm-release-name string                Name of the Flux HelmRelease manifest. (default "gitlab-agent")
      --helm-release-namespace string           Namespace of the Flux HelmRelease manifest. (default "flux-system")
      --helm-release-target-namespace string    Namespace of the GitLab Agent deployment. (default "gitlab-agent")
      --helm-repository-filepath string         Filepath within the GitLab Agent project to commit the Flux HelmRepository to. (default "gitlab-helm-repository.yaml")
      --helm-repository-name string             Name of the Flux HelmRepository manifest. (default "gitlab")
      --helm-repository-namespace string        Namespace of the Flux HelmRepository manifest. (default "flux-system")
  -b, --manifest-branch string                  Branch to commit the Flux Manifests to. (default to the project default branch)
  -p, --manifest-path string                    Location of directory in Git repository for storing the GitLab Agent for Kubernetes Helm resources.
      --no-reconcile                            Do not trigger Flux reconciliation for GitLab Agent for Kubernetes Flux resource.
```

## Options inherited from parent commands

```plaintext
      --help              Show help for this command.
  -R, --repo OWNER/REPO   Select another repository. Can use either OWNER/REPO or `GROUP/NAMESPACE/REPO` format. Also accepts full URL or Git URL.
```
