///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcStmt.cc  
// ---------------
// Cego procedure statement super class implementation               
//                                                         
// Design and Implementation by Bjoern Lemke
//               
// (C)opyright 2000-2019 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoProcStmt
// 
// Description: Super class for all stored procedure statements
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// cego includes
#include "CegoProcStmt.h"

CegoProcStmt::CegoProcStmt(CegoProcBlock* pBlock)
{
    _pBlock=pBlock;
    _isDebug=false;
}

CegoProcStmt::~CegoProcStmt()
{
}

CegoFieldValue CegoProcStmt::getValue(const Chain& varName) const
{
    return _pBlock->getValue(varName);
}

void CegoProcStmt::setValue(const Chain& varName, const CegoFieldValue& fv)
{
    _pBlock->setValue(varName, fv);
}

CegoProcBlock* CegoProcStmt::getParentBlock()
{
    return _pBlock;
}
