///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcCond.cc  
// ---------------
// Cego procedure condition class implementation
//                                                         
// Design and Implementation by Bjoern Lemke               
//     
// (C)opyright 2000-2019 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoProcCond
//
// Description: Stored procedure block condition ( if and while )
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Exception.h>
#include <lfcbase/Tokenizer.h>
// CEGO INCLUDES
#include "CegoProcCond.h"
#include "CegoDatabaseFormater.h"

CegoProcCond::CegoProcCond()
{
}

CegoProcCond::CegoProcCond(CegoProcCond *pCond, CegoProcPred *pPred, CegoProcCond::ConditionMode mode)
{
    _mode = mode;
    _pCond = pCond;
    _pPred = pPred;
}

CegoProcCond::CegoProcCond(CegoProcPred *pPred)
{
    _mode = PRED;
    _pCond = 0;
    _pPred = pPred;
}

CegoProcCond::~CegoProcCond()  
{
    if ( _pCond )
	delete _pCond;
    if ( _pPred )
	delete _pPred;
}

void CegoProcCond::setBlock(CegoProcBlock *pBlock)
{
    if ( _pCond ) 
	_pCond->setBlock(pBlock);
    if ( _pPred )
	_pPred->setBlock(pBlock);	
}

bool CegoProcCond::eval() const
{
    switch ( _mode )
    {
    case AND:
    {
	return _pCond->eval() && _pPred->eval();
	break;
    }
    case OR:
    {
	return _pCond->eval() || _pPred->eval();
	break;
    }
    case PRED:
	return _pPred->eval();
	break;
    }
}

CegoProcCond& CegoProcCond::operator = (const CegoProcCond& c)
{
    _mode = c._mode;
    _pCond = c._pCond;
    _pPred = c._pPred;
    return (*this);
}

Chain CegoProcCond::toChain() const
{
    Chain s;

    switch ( _mode )
    {
    case CegoProcCond::AND:
    {
	s = _pCond->toChain() + " and " + _pPred->toChain();
	break;
    }
    case CegoProcCond::OR:
    {
	s = _pCond->toChain() + " or " + _pPred->toChain();
	break;
    }
    case CegoProcCond::PRED:
    {
	s = _pPred->toChain();
    }
    }
    
    return s;
}

Chain CegoProcCond::dbFormat(CegoDatabaseFormater *pForm) const
{
    return pForm->formatProcCond(_mode, _pCond, _pPred);
}

ostream& operator << (ostream& s, const CegoProcCond& e)
{
    switch ( e._mode )
    {
    case CegoProcCond::AND:
    {
	s << *(e._pCond) << " and " << *(e._pPred);
	break;
    }
    case CegoProcCond::OR:
    {
	s << *(e._pCond) << " or " << *(e._pPred);
	break;
    }
    case CegoProcCond::PRED:
    {
	s << *(e._pPred);
    }
    }
    return s;
}
