///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcAssignStmt.cc  
// ---------------------                                                     
// Cego procedure assign statement implementation
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2019 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoProcAssignStmt
//
// Description: Stored procedure assignment statement 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Exception.h>
#include <lfcbase/Tokenizer.h>
#include <lfcbase/Datetime.h>

// CEGO INCLUDES
#include "CegoProcAssignStmt.h"
#include "CegoDatabaseFormater.h"

CegoProcAssignStmt::CegoProcAssignStmt(CegoExpr *pExpr,
				       CegoProcBlock *pBlock) : CegoProcStmt(pBlock)
{
    _mode = EXPR2NULL;
    _pExpr = pExpr;
    _pExpr->setBlock(pBlock);
}

CegoProcAssignStmt::CegoProcAssignStmt(const Chain& paramName,
				       CegoExpr *pExpr,
				       CegoProcBlock *pBlock) : CegoProcStmt(pBlock)
{
    _mode = EXPR2PARAM;
    _paramName = paramName;
    _pExpr = pExpr;
    _pExpr->setBlock(pBlock);
}

CegoProcAssignStmt::~CegoProcAssignStmt()  
{
    if ( _pExpr )
    {
	delete _pExpr;    
    }
}

CegoException CegoProcAssignStmt::execute()
{
    try
    {
	ListT<CegoField> *pFL = getParentBlock()->getTriggerValueList();
	
	if ( pFL )
	{
	    CegoField *pF = pFL->First();
	    while ( pF )
	    {
		pF = pFL->Next();
	    }
	}
	
	_pExpr->setFieldListArray(getParentBlock()->getTriggerValueList());
	
	switch ( _mode )
	{
	case CegoProcAssignStmt::EXPR2NULL:
	{
	    CegoFieldValue fv;
	    fv = _pExpr->evalFieldValue();
	    break;
	}
	case CegoProcAssignStmt::EXPR2PARAM:
	{
	    setValue(_paramName, _pExpr->evalFieldValue());
	    break;
	}
	}
	return NONE_EXCEP;
    }
    catch ( Exception e )
    {
	Chain excepMsg;
	e.pop(excepMsg);
	getParentBlock()->setExceptionMsg(excepMsg);
	return COREOP_EXCEP;
    }
}

Chain CegoProcAssignStmt::toChain(const Chain& indent) const
{
    Chain s;
	
    switch ( _mode )
    {
    case CegoProcAssignStmt::EXPR2NULL:
    {
	s =  indent + _pExpr->toChain(indent);
	break;
    }
    case CegoProcAssignStmt::EXPR2PARAM:
    {
	Chain prefix = Chain(":")  + _paramName + Chain(" = ");
	Chain addIndent;
	for ( int i=0; i<prefix.length(); i++ )
	    addIndent += Chain(" ");
	s = indent + prefix + _pExpr->toChain(indent + addIndent);
	break;
    }
    }

    return s;
}

Chain CegoProcAssignStmt::dbFormat(CegoDatabaseFormater *pForm) const
{
    return pForm->formatProcAssignStmt(_mode, _paramName, _pExpr);
}
