//
// File: CegoAdm.cc
// This code was produced by the dragon parser generator
//
#include "CegoAdm.h"
#include <lfcbase/Exception.h>
#include <lfcbase/StackT.h>

CegoAdm::ScannerStateEntry::ScannerStateEntry()
{
}

CegoAdm::ScannerStateEntry::ScannerStateEntry(int state, ScannerStateType type)
{
   _state = state;
   _type = type;
}

CegoAdm::ScannerStateEntry& CegoAdm::ScannerStateEntry::operator = (const CegoAdm::ScannerStateEntry& s)
{
   _state = s._state;
   _type = s._type;
   return(*this);
}

bool CegoAdm::ScannerStateEntry::operator == (const CegoAdm::ScannerStateEntry& s)
{
   if ( _state == s._state )
      return true;
   return false;
}

CegoAdm::ScannerStateType CegoAdm::ScannerStateEntry::getType()
{
   return _type;
}
int CegoAdm::ScannerStateEntry::getState()
{
   return _state;
}


CegoAdm::ScannerTransEntry::ScannerTransEntry()
{
}

CegoAdm::ScannerTransEntry::ScannerTransEntry(int state, char c)
{
   _state = state;
   _c = c;
}

CegoAdm::ScannerTransEntry::ScannerTransEntry(int state, char c, int fstate)
{
   _state = state;
   _c = c;
   _fstate = fstate;
}

CegoAdm::ScannerTransEntry& CegoAdm::ScannerTransEntry::operator = (const CegoAdm::ScannerTransEntry& s)
{
   _state = s._state;
   _c = s._c;
   _fstate = s._fstate;
   return(*this);
}

bool CegoAdm::ScannerTransEntry::operator == (const CegoAdm::ScannerTransEntry& s)
{
   if ( _state == s._state && _c == s._c)
      return true;
   return false;
}

int CegoAdm::ScannerTransEntry::getFState()
{
   return _fstate;
}


CegoAdm::Scanner::Scanner()
{
}


CegoAdm::Scanner::Scanner(Token t)
{
   _token = t;
}

CegoAdm::Token CegoAdm::Scanner::getToken()
{
   return _token;
}

void CegoAdm::Scanner::addState(ScannerStateEntry s)
{
   _stateList.Insert(s);
}

void CegoAdm::Scanner::addTransition(ScannerTransEntry t)
{
   _transList.Insert(t);
}

bool CegoAdm::Scanner::checkPattern(const Chain& p)
{
   unsigned long state = 0;
   ScannerStateEntry* pS = _stateList.First();
   while (pS)
   {
      if (pS->getType() == START || pS->getType() == ANY)
      {
         state = pS->getState();
         pS = 0;
      }
      else
      {
         pS = _stateList.Next();
      }
   }
   unsigned long i = 0;
   ScannerTransEntry* pT = 
   _transList.Find(ScannerTransEntry(state, p[i]));
   while (pT)
   {
      ScannerStateEntry* pS = _stateList.Find(ScannerStateEntry(pT->getFState())); 
      if (pS)
      {
         if ( ( i == p.length()-2 ) && ( pS->getType() == FINAL || pS->getType() == ANY))
         {
            return true;
         }
         else
         {
            state = pT->getFState();
         }
      }
      else
      {
         return false;
      }
      i++;
      pT = _transList.Find(ScannerTransEntry(state, p[i]));
   }
   return false;
}
CegoAdm::StackEntry::StackEntry()
{
   _symbol = NONE;
}

CegoAdm::StackEntry::StackEntry(Symbol symbol, int num, int state, Chain tval)
{
   _symbol=symbol;
   _num=num;
   _state=state;
   _tval=tval;
}

CegoAdm::StackEntry& CegoAdm::StackEntry::operator = (const CegoAdm::StackEntry& se)
{
   _symbol=se._symbol;
   _num=se._num;
   _state=se._state;
   _tval=se._tval;
   return(*this);
}

int CegoAdm::StackEntry::getState()
{
   return _state;
}
CegoAdm::Symbol CegoAdm::StackEntry::getSymbol()
{
   return _symbol;
}
Chain& CegoAdm::StackEntry::getTval()
{
   return _tval;
}

CegoAdm::ActionEntry::ActionEntry()
{
   _action=NULLACTION;
}

CegoAdm::ActionEntry::ActionEntry(Action action , int num)
{
   _action=action;
   _num=num;
}

bool CegoAdm::ActionEntry::operator == (const CegoAdm::ActionEntry& ae)
{
   if (_action == ae._action && _num == ae._num)
      return true;
   return false;
}

CegoAdm::ActionEntry& CegoAdm::ActionEntry::operator = (const CegoAdm::ActionEntry& ae)
{
   _action=ae._action;
   _num=ae._num;
   return(*this);
}

CegoAdm::Action CegoAdm::ActionEntry::getAction()
{
   return _action;
}

int CegoAdm::ActionEntry::getNum()
{
   return _num;
}

CegoAdm::ProdEntry::ProdEntry()
{
}

CegoAdm::ProdEntry::ProdEntry(int id)
{
   _id = id;
}

CegoAdm::ProdEntry::ProdEntry(int id, Production prod, int numSymbol)
{
   _id = id;
   _prod = prod;
   _numSymbol = numSymbol;
}

bool CegoAdm::ProdEntry::operator == (const CegoAdm::ProdEntry& pe)
{
   if (_id == pe._id)
      return true;
   return false;
}

CegoAdm::ProdEntry& CegoAdm::ProdEntry::operator = (const CegoAdm::ProdEntry& pe)
{
   _id = pe._id;
   _prod = pe._prod;
   _numSymbol = pe._numSymbol;
   return(*this);
}


int CegoAdm::ProdEntry::getId()
{
   return _id;
}

CegoAdm::Production CegoAdm::ProdEntry::getProd()
{
   return _prod;
}

int CegoAdm::ProdEntry::getNumSymbol()
{
   return _numSymbol;
}
void CegoAdm::loadScanner()
{
   Scanner s0(ABORT);
   s0.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s0.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s0.addState(ScannerStateEntry(2 ,START));
   s0.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s0.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s0.addState(ScannerStateEntry(5 ,FINAL));
   s0.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s0.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s0.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s0.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s0.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s0);

   Scanner s1(ADD);
   s1.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s1.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s1.addState(ScannerStateEntry(2 ,START));
   s1.addState(ScannerStateEntry(3 ,FINAL));
   s1.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s1.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s1.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s1);

   Scanner s2(ADM);
   s2.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s2.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s2.addState(ScannerStateEntry(2 ,START));
   s2.addState(ScannerStateEntry(3 ,FINAL));
   s2.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s2.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s2.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s2);

   Scanner s3(APPSIZE);
   s3.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(2 ,START));
   s3.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(7 ,FINAL));
   s3.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s3.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s3.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s3.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s3.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s3.addTransition(ScannerTransEntry(5 ,'z' ,6));
   s3.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s3);

   Scanner s4(ARCHLOG);
   s4.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(2 ,START));
   s4.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(7 ,FINAL));
   s4.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s4.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s4.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s4.addTransition(ScannerTransEntry(3 ,'h' ,4));
   s4.addTransition(ScannerTransEntry(4 ,'l' ,5));
   s4.addTransition(ScannerTransEntry(5 ,'o' ,6));
   s4.addTransition(ScannerTransEntry(6 ,'g' ,7));
   _scannerList.Insert(s4);

   Scanner s5(ASSIGN);
   s5.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(2 ,START));
   s5.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(6 ,FINAL));
   s5.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s5.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s5.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s5.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s5.addTransition(ScannerTransEntry(4 ,'g' ,5));
   s5.addTransition(ScannerTransEntry(5 ,'n' ,6));
   _scannerList.Insert(s5);

   Scanner s6(AUTOCORRECT);
   s6.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(2 ,START));
   s6.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(10 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(11 ,FINAL));
   s6.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s6.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s6.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s6.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s6.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s6.addTransition(ScannerTransEntry(5 ,'o' ,6));
   s6.addTransition(ScannerTransEntry(6 ,'r' ,7));
   s6.addTransition(ScannerTransEntry(7 ,'r' ,8));
   s6.addTransition(ScannerTransEntry(8 ,'e' ,9));
   s6.addTransition(ScannerTransEntry(9 ,'c' ,10));
   s6.addTransition(ScannerTransEntry(10 ,'t' ,11));
   _scannerList.Insert(s6);

   Scanner s7(BACKUP);
   s7.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(2 ,START));
   s7.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(6 ,FINAL));
   s7.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s7.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s7.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s7.addTransition(ScannerTransEntry(3 ,'k' ,4));
   s7.addTransition(ScannerTransEntry(4 ,'u' ,5));
   s7.addTransition(ScannerTransEntry(5 ,'p' ,6));
   _scannerList.Insert(s7);

   Scanner s8(BACKUPMNG);
   s8.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(2 ,START));
   s8.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(9 ,FINAL));
   s8.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s8.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s8.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s8.addTransition(ScannerTransEntry(3 ,'k' ,4));
   s8.addTransition(ScannerTransEntry(4 ,'u' ,5));
   s8.addTransition(ScannerTransEntry(5 ,'p' ,6));
   s8.addTransition(ScannerTransEntry(6 ,'m' ,7));
   s8.addTransition(ScannerTransEntry(7 ,'n' ,8));
   s8.addTransition(ScannerTransEntry(8 ,'g' ,9));
   _scannerList.Insert(s8);

   Scanner s9(BEGIN_TOKEN);
   s9.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(2 ,START));
   s9.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(5 ,FINAL));
   s9.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s9.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s9.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s9.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s9.addTransition(ScannerTransEntry(4 ,'n' ,5));
   _scannerList.Insert(s9);

   Scanner s10(BINARY);
   s10.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(2 ,START));
   s10.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(6 ,FINAL));
   s10.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s10.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s10.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s10.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s10.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s10.addTransition(ScannerTransEntry(5 ,'y' ,6));
   _scannerList.Insert(s10);

   Scanner s11(BUFILE);
   s11.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(2 ,START));
   s11.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(6 ,FINAL));
   s11.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s11.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s11.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s11.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s11.addTransition(ScannerTransEntry(4 ,'l' ,5));
   s11.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s11);

   Scanner s12(BUSTAT);
   s12.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(2 ,START));
   s12.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(6 ,FINAL));
   s12.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s12.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s12.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s12.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s12.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s12.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s12);

   Scanner s13(TSTICKET);
   s13.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(2 ,START));
   s13.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(8 ,FINAL));
   s13.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s13.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s13.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s13.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s13.addTransition(ScannerTransEntry(5 ,'k' ,6));
   s13.addTransition(ScannerTransEntry(6 ,'e' ,7));
   s13.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s13);

   Scanner s14(BY);
   s14.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(1 ,FINAL));
   s14.addState(ScannerStateEntry(2 ,START));
   s14.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s14.addTransition(ScannerTransEntry(2 ,'b' ,0));
   _scannerList.Insert(s14);

   Scanner s15(CHECK);
   s15.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(2 ,START));
   s15.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(5 ,FINAL));
   s15.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s15.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s15.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s15.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s15.addTransition(ScannerTransEntry(4 ,'k' ,5));
   _scannerList.Insert(s15);

   Scanner s16(CHECKPOINT);
   s16.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(2 ,START));
   s16.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(10 ,FINAL));
   s16.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s16.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s16.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s16.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s16.addTransition(ScannerTransEntry(4 ,'k' ,5));
   s16.addTransition(ScannerTransEntry(5 ,'p' ,6));
   s16.addTransition(ScannerTransEntry(6 ,'o' ,7));
   s16.addTransition(ScannerTransEntry(7 ,'i' ,8));
   s16.addTransition(ScannerTransEntry(8 ,'n' ,9));
   s16.addTransition(ScannerTransEntry(9 ,'t' ,10));
   _scannerList.Insert(s16);

   Scanner s17(CLEAN);
   s17.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(2 ,START));
   s17.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(5 ,FINAL));
   s17.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s17.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s17.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s17.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s17.addTransition(ScannerTransEntry(4 ,'n' ,5));
   _scannerList.Insert(s17);

   Scanner s18(CLEANUP);
   s18.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(2 ,START));
   s18.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(7 ,FINAL));
   s18.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s18.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s18.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s18.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s18.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s18.addTransition(ScannerTransEntry(5 ,'u' ,6));
   s18.addTransition(ScannerTransEntry(6 ,'p' ,7));
   _scannerList.Insert(s18);

   Scanner s19(CLOSE);
   s19.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(2 ,START));
   s19.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(5 ,FINAL));
   s19.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s19.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s19.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s19.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s19.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s19);

   Scanner s20(CONNECT);
   s20.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(2 ,START));
   s20.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(7 ,FINAL));
   s20.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s20.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s20.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s20.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s20.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s20.addTransition(ScannerTransEntry(5 ,'c' ,6));
   s20.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s20);

   Scanner s21(COPY);
   s21.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s21.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s21.addState(ScannerStateEntry(2 ,START));
   s21.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s21.addState(ScannerStateEntry(4 ,FINAL));
   s21.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s21.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s21.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s21.addTransition(ScannerTransEntry(3 ,'y' ,4));
   _scannerList.Insert(s21);

   Scanner s22(CORRECT);
   s22.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(2 ,START));
   s22.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(7 ,FINAL));
   s22.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s22.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s22.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s22.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s22.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s22.addTransition(ScannerTransEntry(5 ,'c' ,6));
   s22.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s22);

   Scanner s23(CPDUMP);
   s23.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(2 ,START));
   s23.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(6 ,FINAL));
   s23.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s23.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s23.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s23.addTransition(ScannerTransEntry(3 ,'u' ,4));
   s23.addTransition(ScannerTransEntry(4 ,'m' ,5));
   s23.addTransition(ScannerTransEntry(5 ,'p' ,6));
   _scannerList.Insert(s23);

   Scanner s24(CREATE);
   s24.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(2 ,START));
   s24.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(6 ,FINAL));
   s24.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s24.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s24.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s24.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s24.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s24.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s24);

   Scanner s25(DATAFILE);
   s25.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(2 ,START));
   s25.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(8 ,FINAL));
   s25.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s25.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s25.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s25.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s25.addTransition(ScannerTransEntry(4 ,'f' ,5));
   s25.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s25.addTransition(ScannerTransEntry(6 ,'l' ,7));
   s25.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s25);

   Scanner s26(DB);
   s26.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(1 ,FINAL));
   s26.addState(ScannerStateEntry(2 ,START));
   s26.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s26.addTransition(ScannerTransEntry(2 ,'d' ,0));
   _scannerList.Insert(s26);

   Scanner s27(DEFINE);
   s27.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(2 ,START));
   s27.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(6 ,FINAL));
   s27.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s27.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s27.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s27.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s27.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s27.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s27);

   Scanner s28(DISABLE);
   s28.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(2 ,START));
   s28.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(7 ,FINAL));
   s28.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s28.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s28.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s28.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s28.addTransition(ScannerTransEntry(4 ,'b' ,5));
   s28.addTransition(ScannerTransEntry(5 ,'l' ,6));
   s28.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s28);

   Scanner s29(DROP);
   s29.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(2 ,START));
   s29.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(4 ,FINAL));
   s29.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s29.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s29.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s29.addTransition(ScannerTransEntry(3 ,'p' ,4));
   _scannerList.Insert(s29);

   Scanner s30(DUMP);
   s30.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(2 ,START));
   s30.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(4 ,FINAL));
   s30.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s30.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s30.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s30.addTransition(ScannerTransEntry(3 ,'p' ,4));
   _scannerList.Insert(s30);

   Scanner s31(ENABLE);
   s31.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(2 ,START));
   s31.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(6 ,FINAL));
   s31.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s31.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s31.addTransition(ScannerTransEntry(2 ,'e' ,0));
   s31.addTransition(ScannerTransEntry(3 ,'b' ,4));
   s31.addTransition(ScannerTransEntry(4 ,'l' ,5));
   s31.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s31);

   Scanner s32(END_TOKEN);
   s32.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(2 ,START));
   s32.addState(ScannerStateEntry(3 ,FINAL));
   s32.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s32.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s32.addTransition(ScannerTransEntry(2 ,'e' ,0));
   _scannerList.Insert(s32);

   Scanner s33(ENTRY);
   s33.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(2 ,START));
   s33.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(5 ,FINAL));
   s33.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s33.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s33.addTransition(ScannerTransEntry(2 ,'e' ,0));
   s33.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s33.addTransition(ScannerTransEntry(4 ,'y' ,5));
   _scannerList.Insert(s33);

   Scanner s34(EXPORT);
   s34.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(2 ,START));
   s34.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(6 ,FINAL));
   s34.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s34.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s34.addTransition(ScannerTransEntry(2 ,'e' ,0));
   s34.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s34.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s34.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s34);

   Scanner s35(FILE);
   s35.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(2 ,START));
   s35.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(4 ,FINAL));
   s35.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s35.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s35.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s35.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s35);

   Scanner s36(FILTER);
   s36.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(2 ,START));
   s36.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(6 ,FINAL));
   s36.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s36.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s36.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s36.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s36.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s36.addTransition(ScannerTransEntry(5 ,'r' ,6));
   _scannerList.Insert(s36);

   Scanner s37(FOR);
   s37.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(2 ,START));
   s37.addState(ScannerStateEntry(3 ,FINAL));
   s37.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s37.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s37.addTransition(ScannerTransEntry(2 ,'f' ,0));
   _scannerList.Insert(s37);

   Scanner s38(FORCELOAD);
   s38.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(2 ,START));
   s38.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(9 ,FINAL));
   s38.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s38.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s38.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s38.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s38.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s38.addTransition(ScannerTransEntry(5 ,'l' ,6));
   s38.addTransition(ScannerTransEntry(6 ,'o' ,7));
   s38.addTransition(ScannerTransEntry(7 ,'a' ,8));
   s38.addTransition(ScannerTransEntry(8 ,'d' ,9));
   _scannerList.Insert(s38);

   Scanner s39(FROM);
   s39.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(2 ,START));
   s39.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(4 ,FINAL));
   s39.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s39.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s39.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s39.addTransition(ScannerTransEntry(3 ,'m' ,4));
   _scannerList.Insert(s39);

   Scanner s40(GETDBSPEC);
   s40.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(2 ,START));
   s40.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(9 ,FINAL));
   s40.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s40.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s40.addTransition(ScannerTransEntry(2 ,'g' ,0));
   s40.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s40.addTransition(ScannerTransEntry(4 ,'b' ,5));
   s40.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s40.addTransition(ScannerTransEntry(6 ,'p' ,7));
   s40.addTransition(ScannerTransEntry(7 ,'e' ,8));
   s40.addTransition(ScannerTransEntry(8 ,'c' ,9));
   _scannerList.Insert(s40);

   Scanner s41(GETTSLIST);
   s41.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(2 ,START));
   s41.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(9 ,FINAL));
   s41.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s41.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s41.addTransition(ScannerTransEntry(2 ,'g' ,0));
   s41.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s41.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s41.addTransition(ScannerTransEntry(5 ,'l' ,6));
   s41.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s41.addTransition(ScannerTransEntry(7 ,'s' ,8));
   s41.addTransition(ScannerTransEntry(8 ,'t' ,9));
   _scannerList.Insert(s41);

   Scanner s42(GETNODELIST);
   s42.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(2 ,START));
   s42.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(10 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(11 ,FINAL));
   s42.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s42.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s42.addTransition(ScannerTransEntry(2 ,'g' ,0));
   s42.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s42.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s42.addTransition(ScannerTransEntry(5 ,'d' ,6));
   s42.addTransition(ScannerTransEntry(6 ,'e' ,7));
   s42.addTransition(ScannerTransEntry(7 ,'l' ,8));
   s42.addTransition(ScannerTransEntry(8 ,'i' ,9));
   s42.addTransition(ScannerTransEntry(9 ,'s' ,10));
   s42.addTransition(ScannerTransEntry(10 ,'t' ,11));
   _scannerList.Insert(s42);

   Scanner s43(GETDBINFO);
   s43.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(2 ,START));
   s43.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(9 ,FINAL));
   s43.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s43.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s43.addTransition(ScannerTransEntry(2 ,'g' ,0));
   s43.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s43.addTransition(ScannerTransEntry(4 ,'b' ,5));
   s43.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s43.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s43.addTransition(ScannerTransEntry(7 ,'f' ,8));
   s43.addTransition(ScannerTransEntry(8 ,'o' ,9));
   _scannerList.Insert(s43);

   Scanner s44(IMPORT);
   s44.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(2 ,START));
   s44.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(6 ,FINAL));
   s44.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s44.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s44.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s44.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s44.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s44.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s44);

   Scanner s45(INITFILE);
   s45.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(2 ,START));
   s45.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(8 ,FINAL));
   s45.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s45.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s45.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s45.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s45.addTransition(ScannerTransEntry(4 ,'f' ,5));
   s45.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s45.addTransition(ScannerTransEntry(6 ,'l' ,7));
   s45.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s45);

   Scanner s46(KEEP);
   s46.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(2 ,START));
   s46.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(4 ,FINAL));
   s46.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s46.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s46.addTransition(ScannerTransEntry(2 ,'k' ,0));
   s46.addTransition(ScannerTransEntry(3 ,'p' ,4));
   _scannerList.Insert(s46);

   Scanner s47(LIST);
   s47.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(2 ,START));
   s47.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(4 ,FINAL));
   s47.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s47.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s47.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s47.addTransition(ScannerTransEntry(3 ,'t' ,4));
   _scannerList.Insert(s47);

   Scanner s48(LOCK);
   s48.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(2 ,START));
   s48.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(4 ,FINAL));
   s48.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s48.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s48.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s48.addTransition(ScannerTransEntry(3 ,'k' ,4));
   _scannerList.Insert(s48);

   Scanner s49(LOCKSTAT);
   s49.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(2 ,START));
   s49.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(8 ,FINAL));
   s49.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s49.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s49.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s49.addTransition(ScannerTransEntry(3 ,'k' ,4));
   s49.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s49.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s49.addTransition(ScannerTransEntry(6 ,'a' ,7));
   s49.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s49);

   Scanner s50(LOG);
   s50.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(2 ,START));
   s50.addState(ScannerStateEntry(3 ,FINAL));
   s50.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s50.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s50.addTransition(ScannerTransEntry(2 ,'l' ,0));
   _scannerList.Insert(s50);

   Scanner s51(LOGFILE);
   s51.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(2 ,START));
   s51.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(7 ,FINAL));
   s51.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s51.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s51.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s51.addTransition(ScannerTransEntry(3 ,'f' ,4));
   s51.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s51.addTransition(ScannerTransEntry(5 ,'l' ,6));
   s51.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s51);

   Scanner s52(LOGMNG);
   s52.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(2 ,START));
   s52.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(6 ,FINAL));
   s52.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s52.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s52.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s52.addTransition(ScannerTransEntry(3 ,'m' ,4));
   s52.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s52.addTransition(ScannerTransEntry(5 ,'g' ,6));
   _scannerList.Insert(s52);

   Scanner s53(LOGNUM);
   s53.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(2 ,START));
   s53.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(6 ,FINAL));
   s53.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s53.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s53.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s53.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s53.addTransition(ScannerTransEntry(4 ,'u' ,5));
   s53.addTransition(ScannerTransEntry(5 ,'m' ,6));
   _scannerList.Insert(s53);

   Scanner s54(LOGSIZE);
   s54.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(2 ,START));
   s54.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(7 ,FINAL));
   s54.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s54.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s54.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s54.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s54.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s54.addTransition(ScannerTransEntry(5 ,'z' ,6));
   s54.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s54);

   Scanner s55(LOGUSER);
   s55.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(2 ,START));
   s55.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(7 ,FINAL));
   s55.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s55.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s55.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s55.addTransition(ScannerTransEntry(3 ,'u' ,4));
   s55.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s55.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s55.addTransition(ScannerTransEntry(6 ,'r' ,7));
   _scannerList.Insert(s55);

   Scanner s56(IDENTIFIED);
   s56.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(2 ,START));
   s56.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(10 ,FINAL));
   s56.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s56.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s56.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s56.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s56.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s56.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s56.addTransition(ScannerTransEntry(6 ,'f' ,7));
   s56.addTransition(ScannerTransEntry(7 ,'i' ,8));
   s56.addTransition(ScannerTransEntry(8 ,'e' ,9));
   s56.addTransition(ScannerTransEntry(9 ,'d' ,10));
   _scannerList.Insert(s56);

   Scanner s57(UINDEX);
   s57.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s57.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s57.addState(ScannerStateEntry(2 ,START));
   s57.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s57.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s57.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s57.addState(ScannerStateEntry(6 ,FINAL));
   s57.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s57.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s57.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s57.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s57.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s57.addTransition(ScannerTransEntry(5 ,'x' ,6));
   _scannerList.Insert(s57);

   Scanner s58(MEDIATOR);
   s58.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(2 ,START));
   s58.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(8 ,FINAL));
   s58.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s58.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s58.addTransition(ScannerTransEntry(2 ,'m' ,0));
   s58.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s58.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s58.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s58.addTransition(ScannerTransEntry(6 ,'o' ,7));
   s58.addTransition(ScannerTransEntry(7 ,'r' ,8));
   _scannerList.Insert(s58);

   Scanner s59(MESSAGE);
   s59.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(2 ,START));
   s59.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(7 ,FINAL));
   s59.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s59.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s59.addTransition(ScannerTransEntry(2 ,'m' ,0));
   s59.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s59.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s59.addTransition(ScannerTransEntry(5 ,'g' ,6));
   s59.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s59);

   Scanner s60(NODE);
   s60.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(2 ,START));
   s60.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(4 ,FINAL));
   s60.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s60.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s60.addTransition(ScannerTransEntry(2 ,'n' ,0));
   s60.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s60);

   Scanner s61(NOINIT);
   s61.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(2 ,START));
   s61.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(6 ,FINAL));
   s61.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s61.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s61.addTransition(ScannerTransEntry(2 ,'n' ,0));
   s61.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s61.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s61.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s61);

   Scanner s62(OBJECT);
   s62.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(2 ,START));
   s62.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(6 ,FINAL));
   s62.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s62.addTransition(ScannerTransEntry(1 ,'j' ,3));
   s62.addTransition(ScannerTransEntry(2 ,'o' ,0));
   s62.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s62.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s62.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s62);

   Scanner s63(OFF);
   s63.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(2 ,START));
   s63.addState(ScannerStateEntry(3 ,FINAL));
   s63.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s63.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s63.addTransition(ScannerTransEntry(2 ,'o' ,0));
   _scannerList.Insert(s63);

   Scanner s64(ON);
   s64.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(1 ,FINAL));
   s64.addState(ScannerStateEntry(2 ,START));
   s64.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s64.addTransition(ScannerTransEntry(2 ,'o' ,0));
   _scannerList.Insert(s64);

   Scanner s65(PARAMETER);
   s65.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(2 ,START));
   s65.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(9 ,FINAL));
   s65.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s65.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s65.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s65.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s65.addTransition(ScannerTransEntry(4 ,'m' ,5));
   s65.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s65.addTransition(ScannerTransEntry(6 ,'t' ,7));
   s65.addTransition(ScannerTransEntry(7 ,'e' ,8));
   s65.addTransition(ScannerTransEntry(8 ,'r' ,9));
   _scannerList.Insert(s65);

   Scanner s66(PATH);
   s66.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(2 ,START));
   s66.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(4 ,FINAL));
   s66.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s66.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s66.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s66.addTransition(ScannerTransEntry(3 ,'h' ,4));
   _scannerList.Insert(s66);

   Scanner s67(PASSWD);
   s67.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(2 ,START));
   s67.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(6 ,FINAL));
   s67.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s67.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s67.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s67.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s67.addTransition(ScannerTransEntry(4 ,'w' ,5));
   s67.addTransition(ScannerTransEntry(5 ,'d' ,6));
   _scannerList.Insert(s67);

   Scanner s68(PERMISSION);
   s68.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(2 ,START));
   s68.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(10 ,FINAL));
   s68.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s68.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s68.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s68.addTransition(ScannerTransEntry(3 ,'m' ,4));
   s68.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s68.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s68.addTransition(ScannerTransEntry(6 ,'s' ,7));
   s68.addTransition(ScannerTransEntry(7 ,'i' ,8));
   s68.addTransition(ScannerTransEntry(8 ,'o' ,9));
   s68.addTransition(ScannerTransEntry(9 ,'n' ,10));
   _scannerList.Insert(s68);

   Scanner s69(PLAIN);
   s69.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s69.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s69.addState(ScannerStateEntry(2 ,START));
   s69.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s69.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s69.addState(ScannerStateEntry(5 ,FINAL));
   s69.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s69.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s69.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s69.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s69.addTransition(ScannerTransEntry(4 ,'n' ,5));
   _scannerList.Insert(s69);

   Scanner s70(POOL);
   s70.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(2 ,START));
   s70.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(4 ,FINAL));
   s70.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s70.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s70.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s70.addTransition(ScannerTransEntry(3 ,'l' ,4));
   _scannerList.Insert(s70);

   Scanner s71(PRIMARY);
   s71.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(2 ,START));
   s71.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(7 ,FINAL));
   s71.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s71.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s71.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s71.addTransition(ScannerTransEntry(3 ,'m' ,4));
   s71.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s71.addTransition(ScannerTransEntry(5 ,'r' ,6));
   s71.addTransition(ScannerTransEntry(6 ,'y' ,7));
   _scannerList.Insert(s71);

   Scanner s72(QUERYCACHE);
   s72.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(2 ,START));
   s72.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(10 ,FINAL));
   s72.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s72.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s72.addTransition(ScannerTransEntry(2 ,'q' ,0));
   s72.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s72.addTransition(ScannerTransEntry(4 ,'y' ,5));
   s72.addTransition(ScannerTransEntry(5 ,'c' ,6));
   s72.addTransition(ScannerTransEntry(6 ,'a' ,7));
   s72.addTransition(ScannerTransEntry(7 ,'c' ,8));
   s72.addTransition(ScannerTransEntry(8 ,'h' ,9));
   s72.addTransition(ScannerTransEntry(9 ,'e' ,10));
   _scannerList.Insert(s72);

   Scanner s73(QUIT);
   s73.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(2 ,START));
   s73.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(4 ,FINAL));
   s73.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s73.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s73.addTransition(ScannerTransEntry(2 ,'q' ,0));
   s73.addTransition(ScannerTransEntry(3 ,'t' ,4));
   _scannerList.Insert(s73);

   Scanner s74(RAWMODE);
   s74.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(2 ,START));
   s74.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(7 ,FINAL));
   s74.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s74.addTransition(ScannerTransEntry(1 ,'w' ,3));
   s74.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s74.addTransition(ScannerTransEntry(3 ,'m' ,4));
   s74.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s74.addTransition(ScannerTransEntry(5 ,'d' ,6));
   s74.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s74);

   Scanner s75(RELOCATE);
   s75.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(2 ,START));
   s75.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(8 ,FINAL));
   s75.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s75.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s75.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s75.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s75.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s75.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s75.addTransition(ScannerTransEntry(6 ,'t' ,7));
   s75.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s75);

   Scanner s76(REMOVE);
   s76.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(2 ,START));
   s76.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(6 ,FINAL));
   s76.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s76.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s76.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s76.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s76.addTransition(ScannerTransEntry(4 ,'v' ,5));
   s76.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s76);

   Scanner s77(RECOVER);
   s77.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(2 ,START));
   s77.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(7 ,FINAL));
   s77.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s77.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s77.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s77.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s77.addTransition(ScannerTransEntry(4 ,'v' ,5));
   s77.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s77.addTransition(ScannerTransEntry(6 ,'r' ,7));
   _scannerList.Insert(s77);

   Scanner s78(RESET);
   s78.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(2 ,START));
   s78.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(5 ,FINAL));
   s78.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s78.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s78.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s78.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s78.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s78);

   Scanner s79(RESTORE);
   s79.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(2 ,START));
   s79.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(7 ,FINAL));
   s79.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s79.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s79.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s79.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s79.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s79.addTransition(ScannerTransEntry(5 ,'r' ,6));
   s79.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s79);

   Scanner s80(RETRIEVE);
   s80.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(2 ,START));
   s80.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(8 ,FINAL));
   s80.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s80.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s80.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s80.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s80.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s80.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s80.addTransition(ScannerTransEntry(6 ,'v' ,7));
   s80.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s80);

   Scanner s81(RIGHT);
   s81.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(2 ,START));
   s81.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(5 ,FINAL));
   s81.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s81.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s81.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s81.addTransition(ScannerTransEntry(3 ,'h' ,4));
   s81.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s81);

   Scanner s82(ROLE);
   s82.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(2 ,START));
   s82.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(4 ,FINAL));
   s82.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s82.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s82.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s82.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s82);

   Scanner s83(SECONDARY);
   s83.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(2 ,START));
   s83.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(9 ,FINAL));
   s83.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s83.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s83.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s83.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s83.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s83.addTransition(ScannerTransEntry(5 ,'d' ,6));
   s83.addTransition(ScannerTransEntry(6 ,'a' ,7));
   s83.addTransition(ScannerTransEntry(7 ,'r' ,8));
   s83.addTransition(ScannerTransEntry(8 ,'y' ,9));
   _scannerList.Insert(s83);

   Scanner s84(SESSION);
   s84.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(2 ,START));
   s84.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(7 ,FINAL));
   s84.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s84.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s84.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s84.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s84.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s84.addTransition(ScannerTransEntry(5 ,'o' ,6));
   s84.addTransition(ScannerTransEntry(6 ,'n' ,7));
   _scannerList.Insert(s84);

   Scanner s85(SET);
   s85.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(2 ,START));
   s85.addState(ScannerStateEntry(3 ,FINAL));
   s85.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s85.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s85.addTransition(ScannerTransEntry(2 ,'s' ,0));
   _scannerList.Insert(s85);

   Scanner s86(SETTSNODEINFO);
   s86.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(2 ,START));
   s86.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(10 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(11 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(12 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(13 ,FINAL));
   s86.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s86.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s86.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s86.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s86.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s86.addTransition(ScannerTransEntry(5 ,'n' ,6));
   s86.addTransition(ScannerTransEntry(6 ,'o' ,7));
   s86.addTransition(ScannerTransEntry(7 ,'d' ,8));
   s86.addTransition(ScannerTransEntry(8 ,'e' ,9));
   s86.addTransition(ScannerTransEntry(9 ,'i' ,10));
   s86.addTransition(ScannerTransEntry(10 ,'n' ,11));
   s86.addTransition(ScannerTransEntry(11 ,'f' ,12));
   s86.addTransition(ScannerTransEntry(12 ,'o' ,13));
   _scannerList.Insert(s86);

   Scanner s87(SIZE);
   s87.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(2 ,START));
   s87.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(4 ,FINAL));
   s87.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s87.addTransition(ScannerTransEntry(1 ,'z' ,3));
   s87.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s87.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s87);

   Scanner s88(SORTAREASIZE);
   s88.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(2 ,START));
   s88.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(10 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(11 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(12 ,FINAL));
   s88.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s88.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s88.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s88.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s88.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s88.addTransition(ScannerTransEntry(5 ,'r' ,6));
   s88.addTransition(ScannerTransEntry(6 ,'e' ,7));
   s88.addTransition(ScannerTransEntry(7 ,'a' ,8));
   s88.addTransition(ScannerTransEntry(8 ,'s' ,9));
   s88.addTransition(ScannerTransEntry(9 ,'i' ,10));
   s88.addTransition(ScannerTransEntry(10 ,'z' ,11));
   s88.addTransition(ScannerTransEntry(11 ,'e' ,12));
   _scannerList.Insert(s88);

   Scanner s89(STRUCTURE);
   s89.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(2 ,START));
   s89.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(9 ,FINAL));
   s89.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s89.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s89.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s89.addTransition(ScannerTransEntry(3 ,'u' ,4));
   s89.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s89.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s89.addTransition(ScannerTransEntry(6 ,'u' ,7));
   s89.addTransition(ScannerTransEntry(7 ,'r' ,8));
   s89.addTransition(ScannerTransEntry(8 ,'e' ,9));
   _scannerList.Insert(s89);

   Scanner s90(SHOW);
   s90.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(2 ,START));
   s90.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(4 ,FINAL));
   s90.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s90.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s90.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s90.addTransition(ScannerTransEntry(3 ,'w' ,4));
   _scannerList.Insert(s90);

   Scanner s91(START_TOK);
   s91.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(2 ,START));
   s91.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(5 ,FINAL));
   s91.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s91.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s91.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s91.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s91.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s91);

   Scanner s92(STOP_TOK);
   s92.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(2 ,START));
   s92.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(4 ,FINAL));
   s92.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s92.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s92.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s92.addTransition(ScannerTransEntry(3 ,'p' ,4));
   _scannerList.Insert(s92);

   Scanner s93(SWITCH);
   s93.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(2 ,START));
   s93.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(6 ,FINAL));
   s93.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s93.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s93.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s93.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s93.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s93.addTransition(ScannerTransEntry(5 ,'h' ,6));
   _scannerList.Insert(s93);

   Scanner s94(SYNC);
   s94.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(2 ,START));
   s94.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(4 ,FINAL));
   s94.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s94.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s94.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s94.addTransition(ScannerTransEntry(3 ,'c' ,4));
   _scannerList.Insert(s94);

   Scanner s95(SYSSIZE);
   s95.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(2 ,START));
   s95.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(7 ,FINAL));
   s95.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s95.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s95.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s95.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s95.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s95.addTransition(ScannerTransEntry(5 ,'z' ,6));
   s95.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s95);

   Scanner s96(TABLE);
   s96.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(2 ,START));
   s96.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(5 ,FINAL));
   s96.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s96.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s96.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s96.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s96.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s96);

   Scanner s97(TABLECACHE);
   s97.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(2 ,START));
   s97.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(10 ,FINAL));
   s97.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s97.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s97.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s97.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s97.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s97.addTransition(ScannerTransEntry(5 ,'c' ,6));
   s97.addTransition(ScannerTransEntry(6 ,'a' ,7));
   s97.addTransition(ScannerTransEntry(7 ,'c' ,8));
   s97.addTransition(ScannerTransEntry(8 ,'h' ,9));
   s97.addTransition(ScannerTransEntry(9 ,'e' ,10));
   _scannerList.Insert(s97);

   Scanner s98(TABLESET);
   s98.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(2 ,START));
   s98.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(8 ,FINAL));
   s98.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s98.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s98.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s98.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s98.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s98.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s98.addTransition(ScannerTransEntry(6 ,'e' ,7));
   s98.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s98);

   Scanner s99(TIMEOUT);
   s99.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(2 ,START));
   s99.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(7 ,FINAL));
   s99.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s99.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s99.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s99.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s99.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s99.addTransition(ScannerTransEntry(5 ,'u' ,6));
   s99.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s99);

   Scanner s100(THREAD);
   s100.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(2 ,START));
   s100.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(6 ,FINAL));
   s100.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s100.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s100.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s100.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s100.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s100.addTransition(ScannerTransEntry(5 ,'d' ,6));
   _scannerList.Insert(s100);

   Scanner s101(THREADINFO);
   s101.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(2 ,START));
   s101.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(10 ,FINAL));
   s101.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s101.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s101.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s101.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s101.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s101.addTransition(ScannerTransEntry(5 ,'d' ,6));
   s101.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s101.addTransition(ScannerTransEntry(7 ,'n' ,8));
   s101.addTransition(ScannerTransEntry(8 ,'f' ,9));
   s101.addTransition(ScannerTransEntry(9 ,'o' ,10));
   _scannerList.Insert(s101);

   Scanner s102(TMPSIZE);
   s102.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(2 ,START));
   s102.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(7 ,FINAL));
   s102.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s102.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s102.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s102.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s102.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s102.addTransition(ScannerTransEntry(5 ,'z' ,6));
   s102.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s102);

   Scanner s103(TO);
   s103.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(1 ,FINAL));
   s103.addState(ScannerStateEntry(2 ,START));
   s103.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s103.addTransition(ScannerTransEntry(2 ,'t' ,0));
   _scannerList.Insert(s103);

   Scanner s104(TRACE);
   s104.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(2 ,START));
   s104.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(5 ,FINAL));
   s104.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s104.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s104.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s104.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s104);

   Scanner s105(TRANSACTION);
   s105.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(2 ,START));
   s105.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(10 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(11 ,FINAL));
   s105.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s105.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s105.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s105.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s105.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s105.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s105.addTransition(ScannerTransEntry(6 ,'c' ,7));
   s105.addTransition(ScannerTransEntry(7 ,'t' ,8));
   s105.addTransition(ScannerTransEntry(8 ,'i' ,9));
   s105.addTransition(ScannerTransEntry(9 ,'o' ,10));
   s105.addTransition(ScannerTransEntry(10 ,'n' ,11));
   _scannerList.Insert(s105);

   Scanner s106(TSROOT);
   s106.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(2 ,START));
   s106.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(6 ,FINAL));
   s106.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s106.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s106.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s106.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s106.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s106.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s106);

   Scanner s107(USER);
   s107.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s107.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s107.addState(ScannerStateEntry(2 ,START));
   s107.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s107.addState(ScannerStateEntry(4 ,FINAL));
   s107.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s107.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s107.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s107.addTransition(ScannerTransEntry(3 ,'r' ,4));
   _scannerList.Insert(s107);

   Scanner s108(VERIFY);
   s108.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(2 ,START));
   s108.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(6 ,FINAL));
   s108.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s108.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s108.addTransition(ScannerTransEntry(2 ,'v' ,0));
   s108.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s108.addTransition(ScannerTransEntry(4 ,'f' ,5));
   s108.addTransition(ScannerTransEntry(5 ,'y' ,6));
   _scannerList.Insert(s108);

   Scanner s109(WITH);
   s109.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s109.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s109.addState(ScannerStateEntry(2 ,START));
   s109.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s109.addState(ScannerStateEntry(4 ,FINAL));
   s109.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s109.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s109.addTransition(ScannerTransEntry(2 ,'w' ,0));
   s109.addTransition(ScannerTransEntry(3 ,'h' ,4));
   _scannerList.Insert(s109);

   Scanner s110(XML);
   s110.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s110.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s110.addState(ScannerStateEntry(2 ,START));
   s110.addState(ScannerStateEntry(3 ,FINAL));
   s110.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s110.addTransition(ScannerTransEntry(2 ,'x' ,0));
   _scannerList.Insert(s110);

   Scanner s111(KSEP);
   s111.addState(ScannerStateEntry(0 ,START));
   s111.addState(ScannerStateEntry(1 ,FINAL));
   s111.addTransition(ScannerTransEntry(0 ,',' ,1));
   _scannerList.Insert(s111);

   Scanner s112(SEMICOLON);
   s112.addState(ScannerStateEntry(0 ,START));
   s112.addState(ScannerStateEntry(1 ,FINAL));
   s112.addTransition(ScannerTransEntry(0 ,';' ,1));
   _scannerList.Insert(s112);

   Scanner s113(EQU);
   s113.addState(ScannerStateEntry(0 ,START));
   s113.addState(ScannerStateEntry(1 ,FINAL));
   s113.addTransition(ScannerTransEntry(0 ,'=' ,1));
   _scannerList.Insert(s113);

   Scanner s114(INTVAL);
   s114.addState(ScannerStateEntry(0 ,START));
   s114.addState(ScannerStateEntry(1 ,FINAL));
   s114.addState(ScannerStateEntry(2 ,FINAL));
   s114.addTransition(ScannerTransEntry(0 ,'1' ,1));
   s114.addTransition(ScannerTransEntry(0 ,'2' ,1));
   s114.addTransition(ScannerTransEntry(0 ,'3' ,1));
   s114.addTransition(ScannerTransEntry(0 ,'4' ,1));
   s114.addTransition(ScannerTransEntry(0 ,'5' ,1));
   s114.addTransition(ScannerTransEntry(0 ,'6' ,1));
   s114.addTransition(ScannerTransEntry(0 ,'7' ,1));
   s114.addTransition(ScannerTransEntry(0 ,'8' ,1));
   s114.addTransition(ScannerTransEntry(0 ,'9' ,1));
   s114.addTransition(ScannerTransEntry(0 ,'0' ,2));
   s114.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s114.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s114.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s114.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s114.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s114.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s114.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s114.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s114.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s114.addTransition(ScannerTransEntry(1 ,'9' ,1));
   _scannerList.Insert(s114);

   Scanner s115(IDENTIFIER);
   s115.addState(ScannerStateEntry(0 ,START));
   s115.addState(ScannerStateEntry(1 ,FINAL));
   s115.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'C' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'G' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'J' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'K' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'Q' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'W' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'Z' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'c' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'g' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'j' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'k' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'q' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'z' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'A' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'B' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'C' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'D' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'E' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'F' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'G' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'H' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'I' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'J' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'K' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'L' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'M' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'N' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'O' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'P' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'Q' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'R' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'S' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'T' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'U' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'V' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'W' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'X' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'Y' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'Z' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'_' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'a' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'b' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'c' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'d' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'e' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'f' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'g' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'h' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'i' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'j' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'k' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'l' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'m' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'n' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'o' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'p' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'q' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'r' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'s' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'t' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'u' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'v' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'w' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'x' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'y' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'z' ,1));
   _scannerList.Insert(s115);

}
void CegoAdm::loadParser0()
{
   _actionMap[420][SEMICOLON] = ActionEntry(REDUCE, 41);
   _actionMap[421][SEMICOLON] = ActionEntry(REDUCE, 103);
   _actionMap[422][SEMICOLON] = ActionEntry(REDUCE, 106);
   _actionMap[400][SEMICOLON] = ActionEntry(REDUCE, 66);
   _actionMap[401][IDENTIFIER] = ActionEntry(SHIFT, 420);
   _actionMap[402][SEMICOLON] = ActionEntry(REDUCE, 135);
   _actionMap[402][PRIMARY] = ActionEntry(REDUCE, 135);
   _actionMap[402][SECONDARY] = ActionEntry(REDUCE, 135);
   _actionMap[402][SYSSIZE] = ActionEntry(REDUCE, 135);
   _actionMap[402][TMPSIZE] = ActionEntry(REDUCE, 135);
   _actionMap[402][LOGSIZE] = ActionEntry(REDUCE, 135);
   _actionMap[402][LOGNUM] = ActionEntry(REDUCE, 135);
   _actionMap[402][APPSIZE] = ActionEntry(REDUCE, 135);
   _actionMap[402][SORTAREASIZE] = ActionEntry(REDUCE, 135);
   _actionMap[402][TSROOT] = ActionEntry(REDUCE, 135);
   _actionMap[403][SEMICOLON] = ActionEntry(REDUCE, 134);
   _actionMap[403][PRIMARY] = ActionEntry(REDUCE, 134);
   _actionMap[403][SECONDARY] = ActionEntry(REDUCE, 134);
   _actionMap[403][SYSSIZE] = ActionEntry(REDUCE, 134);
   _actionMap[403][TMPSIZE] = ActionEntry(REDUCE, 134);
   _actionMap[403][LOGSIZE] = ActionEntry(REDUCE, 134);
   _actionMap[403][LOGNUM] = ActionEntry(REDUCE, 134);
   _actionMap[403][APPSIZE] = ActionEntry(REDUCE, 134);
   _actionMap[403][SORTAREASIZE] = ActionEntry(REDUCE, 134);
   _actionMap[403][TSROOT] = ActionEntry(REDUCE, 134);
   _actionMap[404][SEMICOLON] = ActionEntry(REDUCE, 133);
   _actionMap[404][PRIMARY] = ActionEntry(REDUCE, 133);
   _actionMap[404][SECONDARY] = ActionEntry(REDUCE, 133);
   _actionMap[404][SYSSIZE] = ActionEntry(REDUCE, 133);
   _actionMap[404][TMPSIZE] = ActionEntry(REDUCE, 133);
   _actionMap[404][LOGSIZE] = ActionEntry(REDUCE, 133);
   _actionMap[404][LOGNUM] = ActionEntry(REDUCE, 133);
   _actionMap[404][APPSIZE] = ActionEntry(REDUCE, 133);
   _actionMap[404][SORTAREASIZE] = ActionEntry(REDUCE, 133);
   _actionMap[404][TSROOT] = ActionEntry(REDUCE, 133);
   _actionMap[405][SEMICOLON] = ActionEntry(REDUCE, 129);
   _actionMap[405][PRIMARY] = ActionEntry(REDUCE, 129);
   _actionMap[405][SECONDARY] = ActionEntry(REDUCE, 129);
   _actionMap[405][SYSSIZE] = ActionEntry(REDUCE, 129);
   _actionMap[405][TMPSIZE] = ActionEntry(REDUCE, 129);
   _actionMap[405][LOGSIZE] = ActionEntry(REDUCE, 129);
   _actionMap[405][LOGNUM] = ActionEntry(REDUCE, 129);
   _actionMap[405][APPSIZE] = ActionEntry(REDUCE, 129);
   _actionMap[405][SORTAREASIZE] = ActionEntry(REDUCE, 129);
   _actionMap[405][TSROOT] = ActionEntry(REDUCE, 129);
   _actionMap[406][SEMICOLON] = ActionEntry(REDUCE, 130);
   _actionMap[406][PRIMARY] = ActionEntry(REDUCE, 130);
   _actionMap[406][SECONDARY] = ActionEntry(REDUCE, 130);
   _actionMap[406][SYSSIZE] = ActionEntry(REDUCE, 130);
   _actionMap[406][TMPSIZE] = ActionEntry(REDUCE, 130);
}
void CegoAdm::loadParser1()
{
   _actionMap[406][LOGSIZE] = ActionEntry(REDUCE, 130);
   _actionMap[406][LOGNUM] = ActionEntry(REDUCE, 130);
   _actionMap[406][APPSIZE] = ActionEntry(REDUCE, 130);
   _actionMap[406][SORTAREASIZE] = ActionEntry(REDUCE, 130);
   _actionMap[406][TSROOT] = ActionEntry(REDUCE, 130);
   _actionMap[407][SEMICOLON] = ActionEntry(REDUCE, 136);
   _actionMap[407][PRIMARY] = ActionEntry(REDUCE, 136);
   _actionMap[407][SECONDARY] = ActionEntry(REDUCE, 136);
   _actionMap[407][SYSSIZE] = ActionEntry(REDUCE, 136);
   _actionMap[407][TMPSIZE] = ActionEntry(REDUCE, 136);
   _actionMap[407][LOGSIZE] = ActionEntry(REDUCE, 136);
   _actionMap[407][LOGNUM] = ActionEntry(REDUCE, 136);
   _actionMap[407][APPSIZE] = ActionEntry(REDUCE, 136);
   _actionMap[407][SORTAREASIZE] = ActionEntry(REDUCE, 136);
   _actionMap[407][TSROOT] = ActionEntry(REDUCE, 136);
   _actionMap[408][SEMICOLON] = ActionEntry(REDUCE, 131);
   _actionMap[408][PRIMARY] = ActionEntry(REDUCE, 131);
   _actionMap[408][SECONDARY] = ActionEntry(REDUCE, 131);
   _actionMap[408][SYSSIZE] = ActionEntry(REDUCE, 131);
   _actionMap[408][TMPSIZE] = ActionEntry(REDUCE, 131);
   _actionMap[408][LOGSIZE] = ActionEntry(REDUCE, 131);
   _actionMap[408][LOGNUM] = ActionEntry(REDUCE, 131);
   _actionMap[408][APPSIZE] = ActionEntry(REDUCE, 131);
   _actionMap[408][SORTAREASIZE] = ActionEntry(REDUCE, 131);
   _actionMap[408][TSROOT] = ActionEntry(REDUCE, 131);
   _actionMap[409][SEMICOLON] = ActionEntry(REDUCE, 132);
   _actionMap[409][PRIMARY] = ActionEntry(REDUCE, 132);
   _actionMap[409][SECONDARY] = ActionEntry(REDUCE, 132);
   _actionMap[409][SYSSIZE] = ActionEntry(REDUCE, 132);
   _actionMap[409][TMPSIZE] = ActionEntry(REDUCE, 132);
   _actionMap[409][LOGSIZE] = ActionEntry(REDUCE, 132);
   _actionMap[409][LOGNUM] = ActionEntry(REDUCE, 132);
   _actionMap[409][APPSIZE] = ActionEntry(REDUCE, 132);
   _actionMap[409][SORTAREASIZE] = ActionEntry(REDUCE, 132);
   _actionMap[409][TSROOT] = ActionEntry(REDUCE, 132);
   _actionMap[410][SEMICOLON] = ActionEntry(REDUCE, 137);
   _actionMap[410][PRIMARY] = ActionEntry(REDUCE, 137);
   _actionMap[410][SECONDARY] = ActionEntry(REDUCE, 137);
   _actionMap[410][SYSSIZE] = ActionEntry(REDUCE, 137);
   _actionMap[410][TMPSIZE] = ActionEntry(REDUCE, 137);
   _actionMap[410][LOGSIZE] = ActionEntry(REDUCE, 137);
   _actionMap[410][LOGNUM] = ActionEntry(REDUCE, 137);
   _actionMap[410][APPSIZE] = ActionEntry(REDUCE, 137);
   _actionMap[410][SORTAREASIZE] = ActionEntry(REDUCE, 137);
   _actionMap[410][TSROOT] = ActionEntry(REDUCE, 137);
   _actionMap[411][STRINGVAL] = ActionEntry(SHIFT, 421);
   _actionMap[412][SEMICOLON] = ActionEntry(REDUCE, 105);
   _actionMap[413][STRINGVAL] = ActionEntry(SHIFT, 422);
   _actionMap[414][SEMICOLON] = ActionEntry(REDUCE, 108);
   _actionMap[415][SEMICOLON] = ActionEntry(REDUCE, 55);
}
void CegoAdm::loadParser2()
{
   _actionMap[416][KSEP] = ActionEntry(REDUCE, 56);
   _actionMap[416][FOR] = ActionEntry(REDUCE, 56);
   _actionMap[417][KSEP] = ActionEntry(REDUCE, 59);
   _actionMap[417][FOR] = ActionEntry(REDUCE, 59);
   _actionMap[418][KSEP] = ActionEntry(REDUCE, 60);
   _actionMap[418][FOR] = ActionEntry(REDUCE, 60);
   _actionMap[419][KSEP] = ActionEntry(REDUCE, 58);
   _actionMap[419][FOR] = ActionEntry(REDUCE, 58);
   _actionMap[368][IDENTIFIER] = ActionEntry(SHIFT, 400);
   _actionMap[369][SEMICOLON] = ActionEntry(REDUCE, 45);
   _actionMap[370][TO] = ActionEntry(SHIFT, 401);
   _actionMap[371][INTVAL] = ActionEntry(SHIFT, 402);
   _actionMap[372][INTVAL] = ActionEntry(SHIFT, 403);
   _actionMap[373][INTVAL] = ActionEntry(SHIFT, 404);
   _actionMap[374][STRINGVAL] = ActionEntry(SHIFT, 405);
   _actionMap[375][STRINGVAL] = ActionEntry(SHIFT, 406);
   _actionMap[376][INTVAL] = ActionEntry(SHIFT, 407);
   _actionMap[377][INTVAL] = ActionEntry(SHIFT, 408);
   _actionMap[378][INTVAL] = ActionEntry(SHIFT, 409);
   _actionMap[379][STRINGVAL] = ActionEntry(SHIFT, 410);
   _actionMap[380][SEMICOLON] = ActionEntry(REDUCE, 109);
   _actionMap[381][TO] = ActionEntry(SHIFT, 411);
   _actionMap[382][STRINGVAL] = ActionEntry(SHIFT, 412);
   _actionMap[383][SEMICOLON] = ActionEntry(REDUCE, 104);
   _actionMap[384][FROM] = ActionEntry(SHIFT, 413);
   _actionMap[385][STRINGVAL] = ActionEntry(SHIFT, 414);
   _actionMap[386][SEMICOLON] = ActionEntry(REDUCE, 107);
   _actionMap[387][SEMICOLON] = ActionEntry(REDUCE, 48);
   _actionMap[388][SEMICOLON] = ActionEntry(REDUCE, 37);
   _actionMap[389][SEMICOLON] = ActionEntry(REDUCE, 36);
   _actionMap[390][IDENTIFIER] = ActionEntry(SHIFT, 415);
   _actionMap[391][TABLESET] = ActionEntry(SHIFT, 352);
   _actionMap[391][FILTER] = ActionEntry(SHIFT, 350);
   _actionMap[391][RIGHT] = ActionEntry(SHIFT, 351);
   _jumpMap[391][PermEntry] = 416;
   _actionMap[392][STRINGVAL] = ActionEntry(SHIFT, 417);
   _actionMap[393][IDENTIFIER] = ActionEntry(SHIFT, 418);
   _actionMap[394][IDENTIFIER] = ActionEntry(SHIFT, 419);
   _actionMap[395][SEMICOLON] = ActionEntry(REDUCE, 97);
   _actionMap[396][SEMICOLON] = ActionEntry(REDUCE, 98);
   _actionMap[397][SEMICOLON] = ActionEntry(REDUCE, 101);
   _actionMap[398][SEMICOLON] = ActionEntry(REDUCE, 102);
   _actionMap[399][MESSAGE] = ActionEntry(REDUCE, 111);
   _actionMap[399][KEEP] = ActionEntry(REDUCE, 111);
   _actionMap[399][SEMICOLON] = ActionEntry(REDUCE, 111);
   _actionMap[306][TO] = ActionEntry(SHIFT, 368);
   _actionMap[307][STRINGVAL] = ActionEntry(SHIFT, 369);
   _actionMap[308][INTVAL] = ActionEntry(SHIFT, 370);
   _actionMap[309][SEMICOLON] = ActionEntry(REDUCE, 49);
   _actionMap[310][KEEP] = ActionEntry(REDUCE, 115);
}
void CegoAdm::loadParser3()
{
   _actionMap[310][SEMICOLON] = ActionEntry(REDUCE, 115);
   _actionMap[311][SEMICOLON] = ActionEntry(REDUCE, 68);
   _actionMap[312][SEMICOLON] = ActionEntry(REDUCE, 127);
   _actionMap[312][PRIMARY] = ActionEntry(REDUCE, 127);
   _actionMap[312][SECONDARY] = ActionEntry(REDUCE, 127);
   _actionMap[312][SYSSIZE] = ActionEntry(REDUCE, 127);
   _actionMap[312][TMPSIZE] = ActionEntry(REDUCE, 127);
   _actionMap[312][LOGSIZE] = ActionEntry(REDUCE, 127);
   _actionMap[312][LOGNUM] = ActionEntry(REDUCE, 127);
   _actionMap[312][APPSIZE] = ActionEntry(REDUCE, 127);
   _actionMap[312][SORTAREASIZE] = ActionEntry(REDUCE, 127);
   _actionMap[312][TSROOT] = ActionEntry(REDUCE, 127);
   _actionMap[313][EQU] = ActionEntry(SHIFT, 371);
   _actionMap[314][EQU] = ActionEntry(SHIFT, 372);
   _actionMap[315][EQU] = ActionEntry(SHIFT, 373);
   _actionMap[316][EQU] = ActionEntry(SHIFT, 374);
   _actionMap[317][EQU] = ActionEntry(SHIFT, 375);
   _actionMap[318][EQU] = ActionEntry(SHIFT, 376);
   _actionMap[319][EQU] = ActionEntry(SHIFT, 377);
   _actionMap[320][EQU] = ActionEntry(SHIFT, 378);
   _actionMap[321][EQU] = ActionEntry(SHIFT, 379);
   _actionMap[322][SEMICOLON] = ActionEntry(REDUCE, 145);
   _actionMap[323][SEMICOLON] = ActionEntry(REDUCE, 144);
   _actionMap[324][SEMICOLON] = ActionEntry(REDUCE, 70);
   _actionMap[325][KEEP] = ActionEntry(SHIFT, 326);
   _actionMap[325][SEMICOLON] = ActionEntry(REDUCE, 110);
   _jumpMap[325][KeepTicketOpt] = 324;
   _actionMap[326][TSTICKET] = ActionEntry(SHIFT, 380);
   _actionMap[327][IDENTIFIER] = ActionEntry(SHIFT, 381);
   _actionMap[328][TO] = ActionEntry(SHIFT, 382);
   _actionMap[329][STRINGVAL] = ActionEntry(SHIFT, 383);
   _actionMap[330][IDENTIFIER] = ActionEntry(SHIFT, 384);
   _actionMap[331][FROM] = ActionEntry(SHIFT, 385);
   _actionMap[332][STRINGVAL] = ActionEntry(SHIFT, 386);
   _actionMap[333][STRINGVAL] = ActionEntry(SHIFT, 387);
   _actionMap[334][STRINGVAL] = ActionEntry(SHIFT, 388);
   _actionMap[335][STRINGVAL] = ActionEntry(SHIFT, 389);
   _actionMap[336][SEMICOLON] = ActionEntry(REDUCE, 67);
   _actionMap[337][SEMICOLON] = ActionEntry(REDUCE, 61);
   _actionMap[338][SEMICOLON] = ActionEntry(REDUCE, 50);
   _actionMap[339][SEMICOLON] = ActionEntry(REDUCE, 138);
   _actionMap[340][SEMICOLON] = ActionEntry(REDUCE, 73);
   _actionMap[341][SEMICOLON] = ActionEntry(REDUCE, 83);
   _actionMap[342][SEMICOLON] = ActionEntry(REDUCE, 80);
   _actionMap[343][SEMICOLON] = ActionEntry(REDUCE, 79);
   _actionMap[344][MESSAGE] = ActionEntry(REDUCE, 113);
   _actionMap[344][KEEP] = ActionEntry(REDUCE, 113);
   _actionMap[344][SEMICOLON] = ActionEntry(REDUCE, 113);
   _actionMap[345][SEMICOLON] = ActionEntry(REDUCE, 85);
   _actionMap[346][SEMICOLON] = ActionEntry(REDUCE, 86);
}
void CegoAdm::loadParser4()
{
   _actionMap[347][SEMICOLON] = ActionEntry(REDUCE, 88);
   _actionMap[348][FOR] = ActionEntry(SHIFT, 390);
   _actionMap[348][KSEP] = ActionEntry(SHIFT, 391);
   _actionMap[349][KSEP] = ActionEntry(REDUCE, 57);
   _actionMap[349][FOR] = ActionEntry(REDUCE, 57);
   _actionMap[350][EQU] = ActionEntry(SHIFT, 392);
   _actionMap[351][EQU] = ActionEntry(SHIFT, 393);
   _actionMap[352][EQU] = ActionEntry(SHIFT, 394);
   _actionMap[353][IDENTIFIER] = ActionEntry(SHIFT, 395);
   _actionMap[354][IDENTIFIER] = ActionEntry(SHIFT, 396);
   _actionMap[355][SEMICOLON] = ActionEntry(REDUCE, 87);
   _actionMap[356][SEMICOLON] = ActionEntry(REDUCE, 81);
   _actionMap[357][IDENTIFIER] = ActionEntry(SHIFT, 397);
   _actionMap[358][IDENTIFIER] = ActionEntry(SHIFT, 398);
   _actionMap[359][SEMICOLON] = ActionEntry(REDUCE, 82);
   _actionMap[360][SEMICOLON] = ActionEntry(REDUCE, 84);
   _actionMap[361][SEMICOLON] = ActionEntry(REDUCE, 142);
   _actionMap[362][SEMICOLON] = ActionEntry(REDUCE, 117);
   _actionMap[362][CLEANUP] = ActionEntry(REDUCE, 117);
   _actionMap[362][FORCELOAD] = ActionEntry(REDUCE, 117);
   _actionMap[362][CPDUMP] = ActionEntry(REDUCE, 117);
   _actionMap[362][NOINIT] = ActionEntry(REDUCE, 117);
   _actionMap[363][SEMICOLON] = ActionEntry(REDUCE, 119);
   _actionMap[363][CLEANUP] = ActionEntry(REDUCE, 119);
   _actionMap[363][FORCELOAD] = ActionEntry(REDUCE, 119);
   _actionMap[363][CPDUMP] = ActionEntry(REDUCE, 119);
   _actionMap[363][NOINIT] = ActionEntry(REDUCE, 119);
   _actionMap[364][SEMICOLON] = ActionEntry(REDUCE, 121);
   _actionMap[364][CLEANUP] = ActionEntry(REDUCE, 121);
   _actionMap[364][FORCELOAD] = ActionEntry(REDUCE, 121);
   _actionMap[364][CPDUMP] = ActionEntry(REDUCE, 121);
   _actionMap[364][NOINIT] = ActionEntry(REDUCE, 121);
   _actionMap[365][SEMICOLON] = ActionEntry(REDUCE, 120);
   _actionMap[365][CLEANUP] = ActionEntry(REDUCE, 120);
   _actionMap[365][FORCELOAD] = ActionEntry(REDUCE, 120);
   _actionMap[365][CPDUMP] = ActionEntry(REDUCE, 120);
   _actionMap[365][NOINIT] = ActionEntry(REDUCE, 120);
   _actionMap[366][SEMICOLON] = ActionEntry(REDUCE, 122);
   _actionMap[366][CLEANUP] = ActionEntry(REDUCE, 122);
   _actionMap[366][FORCELOAD] = ActionEntry(REDUCE, 122);
   _actionMap[366][CPDUMP] = ActionEntry(REDUCE, 122);
   _actionMap[366][NOINIT] = ActionEntry(REDUCE, 122);
   _actionMap[367][TIMEOUT] = ActionEntry(SHIFT, 284);
   _actionMap[367][MESSAGE] = ActionEntry(REDUCE, 114);
   _actionMap[367][KEEP] = ActionEntry(REDUCE, 114);
   _actionMap[367][SEMICOLON] = ActionEntry(REDUCE, 114);
   _jumpMap[367][TimeoutOpt] = 399;
   _actionMap[231][SEMICOLON] = ActionEntry(REDUCE, 26);
   _actionMap[232][STRINGVAL] = ActionEntry(SHIFT, 306);
   _actionMap[233][BY] = ActionEntry(SHIFT, 307);
}
void CegoAdm::loadParser5()
{
   _actionMap[234][SIZE] = ActionEntry(SHIFT, 308);
   _actionMap[235][IDENTIFIER] = ActionEntry(SHIFT, 309);
   _actionMap[236][SEMICOLON] = ActionEntry(REDUCE, 69);
   _actionMap[237][STRINGVAL] = ActionEntry(SHIFT, 310);
   _actionMap[238][MESSAGE] = ActionEntry(SHIFT, 237);
   _actionMap[238][SEMICOLON] = ActionEntry(REDUCE, 116);
   _jumpMap[238][MsgOption] = 311;
   _actionMap[239][SEMICOLON] = ActionEntry(REDUCE, 96);
   _actionMap[240][SEMICOLON] = ActionEntry(REDUCE, 100);
   _actionMap[241][SEMICOLON] = ActionEntry(REDUCE, 28);
   _actionMap[241][PRIMARY] = ActionEntry(SHIFT, 316);
   _actionMap[241][SECONDARY] = ActionEntry(SHIFT, 317);
   _actionMap[241][SYSSIZE] = ActionEntry(SHIFT, 319);
   _actionMap[241][TMPSIZE] = ActionEntry(SHIFT, 320);
   _actionMap[241][LOGSIZE] = ActionEntry(SHIFT, 315);
   _actionMap[241][LOGNUM] = ActionEntry(SHIFT, 314);
   _actionMap[241][APPSIZE] = ActionEntry(SHIFT, 313);
   _actionMap[241][SORTAREASIZE] = ActionEntry(SHIFT, 318);
   _actionMap[241][TSROOT] = ActionEntry(SHIFT, 321);
   _jumpMap[241][Attr] = 312;
   _actionMap[242][SEMICOLON] = ActionEntry(REDUCE, 65);
   _actionMap[243][SEMICOLON] = ActionEntry(REDUCE, 90);
   _actionMap[244][SEMICOLON] = ActionEntry(REDUCE, 94);
   _actionMap[245][SEMICOLON] = ActionEntry(REDUCE, 92);
   _actionMap[246][IDENTIFIER] = ActionEntry(SHIFT, 322);
   _actionMap[247][IDENTIFIER] = ActionEntry(SHIFT, 323);
   _actionMap[248][SEMICOLON] = ActionEntry(REDUCE, 64);
   _actionMap[249][SEMICOLON] = ActionEntry(REDUCE, 89);
   _actionMap[250][SEMICOLON] = ActionEntry(REDUCE, 93);
   _actionMap[251][SEMICOLON] = ActionEntry(REDUCE, 91);
   _actionMap[252][MESSAGE] = ActionEntry(SHIFT, 237);
   _actionMap[252][KEEP] = ActionEntry(REDUCE, 116);
   _actionMap[252][SEMICOLON] = ActionEntry(REDUCE, 116);
   _jumpMap[252][MsgOption] = 325;
   _jumpMap[252][KeepTicketOpt] = 324;
   _actionMap[253][FROM] = ActionEntry(SHIFT, 327);
   _actionMap[254][IDENTIFIER] = ActionEntry(SHIFT, 328);
   _actionMap[255][TO] = ActionEntry(SHIFT, 329);
   _actionMap[256][TO] = ActionEntry(SHIFT, 330);
   _actionMap[257][IDENTIFIER] = ActionEntry(SHIFT, 331);
   _actionMap[258][FROM] = ActionEntry(SHIFT, 332);
   _actionMap[259][SEMICOLON] = ActionEntry(REDUCE, 10);
   _actionMap[260][SEMICOLON] = ActionEntry(REDUCE, 71);
   _actionMap[261][SEMICOLON] = ActionEntry(REDUCE, 15);
   _actionMap[262][SEMICOLON] = ActionEntry(REDUCE, 16);
   _actionMap[263][SEMICOLON] = ActionEntry(REDUCE, 9);
   _actionMap[264][SEMICOLON] = ActionEntry(REDUCE, 11);
   _actionMap[265][SEMICOLON] = ActionEntry(REDUCE, 12);
   _actionMap[266][SEMICOLON] = ActionEntry(REDUCE, 95);
   _actionMap[267][SEMICOLON] = ActionEntry(REDUCE, 99);
}
void CegoAdm::loadParser6()
{
   _actionMap[268][SEMICOLON] = ActionEntry(REDUCE, 25);
   _actionMap[269][BY] = ActionEntry(SHIFT, 333);
   _actionMap[270][TO] = ActionEntry(SHIFT, 334);
   _actionMap[271][TO] = ActionEntry(SHIFT, 335);
   _actionMap[272][IDENTIFIER] = ActionEntry(SHIFT, 336);
   _actionMap[273][IDENTIFIER] = ActionEntry(SHIFT, 337);
   _actionMap[274][IDENTIFIER] = ActionEntry(SHIFT, 338);
   _actionMap[275][SEMICOLON] = ActionEntry(REDUCE, 74);
   _actionMap[276][STRINGVAL] = ActionEntry(SHIFT, 339);
   _actionMap[277][SEMICOLON] = ActionEntry(REDUCE, 17);
   _actionMap[278][STRINGVAL] = ActionEntry(SHIFT, 340);
   _actionMap[279][SEMICOLON] = ActionEntry(REDUCE, 27);
   _actionMap[280][IDENTIFIER] = ActionEntry(SHIFT, 341);
   _actionMap[281][IDENTIFIER] = ActionEntry(SHIFT, 342);
   _actionMap[282][IDENTIFIER] = ActionEntry(SHIFT, 343);
   _actionMap[283][SEMICOLON] = ActionEntry(REDUCE, 75);
   _actionMap[284][INTVAL] = ActionEntry(SHIFT, 344);
   _actionMap[285][IDENTIFIER] = ActionEntry(SHIFT, 345);
   _actionMap[286][IDENTIFIER] = ActionEntry(SHIFT, 346);
   _actionMap[287][IDENTIFIER] = ActionEntry(SHIFT, 347);
   _actionMap[288][TABLESET] = ActionEntry(SHIFT, 352);
   _actionMap[288][FILTER] = ActionEntry(SHIFT, 350);
   _actionMap[288][RIGHT] = ActionEntry(SHIFT, 351);
   _jumpMap[288][PermEntry] = 349;
   _jumpMap[288][PermList] = 348;
   _actionMap[289][FOR] = ActionEntry(SHIFT, 353);
   _actionMap[290][FOR] = ActionEntry(SHIFT, 354);
   _actionMap[291][IDENTIFIER] = ActionEntry(SHIFT, 355);
   _actionMap[292][IDENTIFIER] = ActionEntry(SHIFT, 356);
   _actionMap[293][FOR] = ActionEntry(SHIFT, 357);
   _actionMap[294][FOR] = ActionEntry(SHIFT, 358);
   _actionMap[295][IDENTIFIER] = ActionEntry(SHIFT, 359);
   _actionMap[296][IDENTIFIER] = ActionEntry(SHIFT, 360);
   _actionMap[297][IDENTIFIER] = ActionEntry(SHIFT, 361);
   _actionMap[298][SEMICOLON] = ActionEntry(REDUCE, 30);
   _actionMap[298][CLEANUP] = ActionEntry(SHIFT, 363);
   _actionMap[298][FORCELOAD] = ActionEntry(SHIFT, 365);
   _actionMap[298][CPDUMP] = ActionEntry(SHIFT, 364);
   _actionMap[298][NOINIT] = ActionEntry(SHIFT, 366);
   _jumpMap[298][StartOpt] = 362;
   _actionMap[299][SEMICOLON] = ActionEntry(REDUCE, 35);
   _actionMap[300][SEMICOLON] = ActionEntry(REDUCE, 34);
   _actionMap[301][MESSAGE] = ActionEntry(SHIFT, 237);
   _actionMap[301][SEMICOLON] = ActionEntry(REDUCE, 116);
   _jumpMap[301][MsgOption] = 302;
   _actionMap[302][SEMICOLON] = ActionEntry(REDUCE, 72);
   _actionMap[303][STRINGVAL] = ActionEntry(SHIFT, 367);
   _actionMap[304][SEMICOLON] = ActionEntry(REDUCE, 63);
   _actionMap[305][SEMICOLON] = ActionEntry(REDUCE, 62);
   _actionMap[144][INTVAL] = ActionEntry(SHIFT, 231);
}
void CegoAdm::loadParser7()
{
   _actionMap[145][PATH] = ActionEntry(SHIFT, 232);
   _actionMap[146][IDENTIFIED] = ActionEntry(SHIFT, 233);
   _actionMap[147][STRINGVAL] = ActionEntry(SHIFT, 234);
   _actionMap[148][TO] = ActionEntry(SHIFT, 235);
   _actionMap[149][MESSAGE] = ActionEntry(SHIFT, 237);
   _actionMap[149][SEMICOLON] = ActionEntry(REDUCE, 116);
   _jumpMap[149][MsgOption] = 236;
   _actionMap[150][IDENTIFIER] = ActionEntry(SHIFT, 238);
   _actionMap[151][SEMICOLON] = ActionEntry(REDUCE, 42);
   _actionMap[152][IDENTIFIER] = ActionEntry(SHIFT, 239);
   _actionMap[153][IDENTIFIER] = ActionEntry(SHIFT, 240);
   _actionMap[154][SEMICOLON] = ActionEntry(REDUCE, 143);
   _actionMap[155][SEMICOLON] = ActionEntry(REDUCE, 32);
   _actionMap[156][SEMICOLON] = ActionEntry(REDUCE, 44);
   _actionMap[157][SEMICOLON] = ActionEntry(REDUCE, 53);
   _actionMap[158][SEMICOLON] = ActionEntry(REDUCE, 29);
   _actionMap[159][PRIMARY] = ActionEntry(REDUCE, 128);
   _actionMap[159][SECONDARY] = ActionEntry(REDUCE, 128);
   _actionMap[159][SYSSIZE] = ActionEntry(REDUCE, 128);
   _actionMap[159][TMPSIZE] = ActionEntry(REDUCE, 128);
   _actionMap[159][LOGSIZE] = ActionEntry(REDUCE, 128);
   _actionMap[159][LOGNUM] = ActionEntry(REDUCE, 128);
   _actionMap[159][APPSIZE] = ActionEntry(REDUCE, 128);
   _actionMap[159][SORTAREASIZE] = ActionEntry(REDUCE, 128);
   _actionMap[159][TSROOT] = ActionEntry(REDUCE, 128);
   _actionMap[159][SEMICOLON] = ActionEntry(REDUCE, 128);
   _jumpMap[159][AttrList] = 241;
   _actionMap[160][IDENTIFIER] = ActionEntry(SHIFT, 242);
   _actionMap[161][IDENTIFIER] = ActionEntry(SHIFT, 243);
   _actionMap[162][IDENTIFIER] = ActionEntry(SHIFT, 244);
   _actionMap[163][IDENTIFIER] = ActionEntry(SHIFT, 245);
   _actionMap[164][SEMICOLON] = ActionEntry(REDUCE, 54);
   _actionMap[165][SEMICOLON] = ActionEntry(REDUCE, 38);
   _actionMap[166][SEMICOLON] = ActionEntry(REDUCE, 47);
   _actionMap[167][FOR] = ActionEntry(SHIFT, 246);
   _actionMap[168][FOR] = ActionEntry(SHIFT, 247);
   _actionMap[169][IDENTIFIER] = ActionEntry(SHIFT, 248);
   _actionMap[170][IDENTIFIER] = ActionEntry(SHIFT, 249);
   _actionMap[171][IDENTIFIER] = ActionEntry(SHIFT, 250);
   _actionMap[172][IDENTIFIER] = ActionEntry(SHIFT, 251);
   _actionMap[173][IDENTIFIER] = ActionEntry(SHIFT, 252);
   _actionMap[174][IDENTIFIER] = ActionEntry(SHIFT, 253);
   _actionMap[175][IDENTIFIER] = ActionEntry(SHIFT, 255);
   _actionMap[175][STRUCTURE] = ActionEntry(SHIFT, 254);
   _actionMap[176][IDENTIFIER] = ActionEntry(SHIFT, 256);
   _actionMap[177][IDENTIFIER] = ActionEntry(SHIFT, 258);
   _actionMap[177][STRUCTURE] = ActionEntry(SHIFT, 257);
   _actionMap[178][IDENTIFIER] = ActionEntry(SHIFT, 259);
   _actionMap[179][IDENTIFIER] = ActionEntry(SHIFT, 260);
   _actionMap[180][IDENTIFIER] = ActionEntry(SHIFT, 261);
}
void CegoAdm::loadParser8()
{
   _actionMap[181][IDENTIFIER] = ActionEntry(SHIFT, 262);
   _actionMap[182][IDENTIFIER] = ActionEntry(SHIFT, 263);
   _actionMap[183][IDENTIFIER] = ActionEntry(SHIFT, 264);
   _actionMap[184][IDENTIFIER] = ActionEntry(SHIFT, 265);
   _actionMap[185][IDENTIFIER] = ActionEntry(SHIFT, 266);
   _actionMap[186][IDENTIFIER] = ActionEntry(SHIFT, 267);
   _actionMap[187][IDENTIFIER] = ActionEntry(SHIFT, 268);
   _actionMap[188][SEMICOLON] = ActionEntry(REDUCE, 7);
   _actionMap[189][IDENTIFIED] = ActionEntry(SHIFT, 269);
   _actionMap[190][IDENTIFIER] = ActionEntry(SHIFT, 270);
   _actionMap[191][IDENTIFIER] = ActionEntry(SHIFT, 271);
   _actionMap[192][FROM] = ActionEntry(SHIFT, 272);
   _actionMap[193][FROM] = ActionEntry(SHIFT, 273);
   _actionMap[194][FROM] = ActionEntry(SHIFT, 274);
   _actionMap[195][SEMICOLON] = ActionEntry(REDUCE, 39);
   _actionMap[196][TO] = ActionEntry(SHIFT, 276);
   _actionMap[196][SEMICOLON] = ActionEntry(REDUCE, 139);
   _jumpMap[196][PitOption] = 275;
   _actionMap[197][IDENTIFIER] = ActionEntry(SHIFT, 277);
   _actionMap[198][SEMICOLON] = ActionEntry(REDUCE, 40);
   _actionMap[199][FROM] = ActionEntry(SHIFT, 278);
   _actionMap[200][STRINGVAL] = ActionEntry(SHIFT, 279);
   _actionMap[201][FOR] = ActionEntry(SHIFT, 280);
   _actionMap[202][SEMICOLON] = ActionEntry(REDUCE, 76);
   _actionMap[203][FOR] = ActionEntry(SHIFT, 281);
   _actionMap[204][FOR] = ActionEntry(SHIFT, 282);
   _actionMap[205][TIMEOUT] = ActionEntry(SHIFT, 284);
   _actionMap[205][SEMICOLON] = ActionEntry(REDUCE, 114);
   _jumpMap[205][TimeoutOpt] = 283;
   _actionMap[206][FOR] = ActionEntry(SHIFT, 285);
   _actionMap[207][FOR] = ActionEntry(SHIFT, 286);
   _actionMap[208][FOR] = ActionEntry(SHIFT, 287);
   _actionMap[209][WITH] = ActionEntry(SHIFT, 288);
   _actionMap[210][INTVAL] = ActionEntry(SHIFT, 289);
   _actionMap[211][INTVAL] = ActionEntry(SHIFT, 290);
   _actionMap[212][FOR] = ActionEntry(SHIFT, 291);
   _actionMap[213][FOR] = ActionEntry(SHIFT, 292);
   _actionMap[214][INTVAL] = ActionEntry(SHIFT, 293);
   _actionMap[215][INTVAL] = ActionEntry(SHIFT, 294);
   _actionMap[216][FOR] = ActionEntry(SHIFT, 295);
   _actionMap[217][FOR] = ActionEntry(SHIFT, 296);
   _actionMap[218][IDENTIFIER] = ActionEntry(SHIFT, 297);
   _actionMap[219][SEMICOLON] = ActionEntry(REDUCE, 52);
   _actionMap[220][SEMICOLON] = ActionEntry(REDUCE, 3);
   _actionMap[221][CLEANUP] = ActionEntry(REDUCE, 118);
   _actionMap[221][FORCELOAD] = ActionEntry(REDUCE, 118);
   _actionMap[221][CPDUMP] = ActionEntry(REDUCE, 118);
   _actionMap[221][NOINIT] = ActionEntry(REDUCE, 118);
   _actionMap[221][SEMICOLON] = ActionEntry(REDUCE, 118);
   _jumpMap[221][StartOptList] = 298;
}
void CegoAdm::loadParser9()
{
   _actionMap[222][SEMICOLON] = ActionEntry(REDUCE, 31);
   _actionMap[223][IDENTIFIER] = ActionEntry(SHIFT, 299);
   _actionMap[224][IDENTIFIER] = ActionEntry(SHIFT, 300);
   _actionMap[225][SEMICOLON] = ActionEntry(REDUCE, 33);
   _actionMap[226][WITH] = ActionEntry(SHIFT, 303);
   _actionMap[226][MESSAGE] = ActionEntry(REDUCE, 112);
   _actionMap[226][KEEP] = ActionEntry(REDUCE, 112);
   _actionMap[226][SEMICOLON] = ActionEntry(REDUCE, 112);
   _jumpMap[226][MsgOption] = 302;
   _jumpMap[226][SyncCmdOption] = 301;
   _actionMap[227][SEMICOLON] = ActionEntry(REDUCE, 21);
   _actionMap[228][IDENTIFIER] = ActionEntry(SHIFT, 304);
   _actionMap[229][IDENTIFIER] = ActionEntry(SHIFT, 305);
   _actionMap[230][SEMICOLON] = ActionEntry(REDUCE, 43);
   _actionMap[42][ENDTOKEN] = ActionEntry(ACCEPT, 0);
   _actionMap[43][THREAD] = ActionEntry(SHIFT, 144);
   _actionMap[44][IDENTIFIER] = ActionEntry(SHIFT, 145);
   _actionMap[45][IDENTIFIER] = ActionEntry(SHIFT, 146);
   _actionMap[46][DATAFILE] = ActionEntry(SHIFT, 147);
   _actionMap[47][IDENTIFIER] = ActionEntry(SHIFT, 148);
   _actionMap[48][IDENTIFIER] = ActionEntry(SHIFT, 149);
   _actionMap[49][FOR] = ActionEntry(SHIFT, 150);
   _actionMap[50][IDENTIFIER] = ActionEntry(SHIFT, 151);
   _actionMap[51][FOR] = ActionEntry(SHIFT, 152);
   _actionMap[52][FOR] = ActionEntry(SHIFT, 153);
   _actionMap[53][STRINGVAL] = ActionEntry(SHIFT, 154);
   _actionMap[54][IDENTIFIER] = ActionEntry(SHIFT, 155);
   _actionMap[55][IDENTIFIER] = ActionEntry(SHIFT, 156);
   _actionMap[56][IDENTIFIER] = ActionEntry(SHIFT, 157);
   _actionMap[57][IDENTIFIER] = ActionEntry(SHIFT, 158);
   _actionMap[58][IDENTIFIER] = ActionEntry(SHIFT, 159);
   _actionMap[59][FOR] = ActionEntry(SHIFT, 160);
   _actionMap[60][FOR] = ActionEntry(SHIFT, 161);
   _actionMap[61][FOR] = ActionEntry(SHIFT, 162);
   _actionMap[62][FOR] = ActionEntry(SHIFT, 163);
   _actionMap[63][IDENTIFIER] = ActionEntry(SHIFT, 164);
   _actionMap[64][IDENTIFIER] = ActionEntry(SHIFT, 165);
   _actionMap[65][IDENTIFIER] = ActionEntry(SHIFT, 166);
   _actionMap[66][IDENTIFIER] = ActionEntry(SHIFT, 167);
   _actionMap[67][IDENTIFIER] = ActionEntry(SHIFT, 168);
   _actionMap[68][FOR] = ActionEntry(SHIFT, 169);
   _actionMap[69][FOR] = ActionEntry(SHIFT, 170);
   _actionMap[70][FOR] = ActionEntry(SHIFT, 171);
   _actionMap[71][FOR] = ActionEntry(SHIFT, 172);
   _actionMap[72][FOR] = ActionEntry(SHIFT, 173);
   _actionMap[73][TABLESET] = ActionEntry(SHIFT, 175);
   _actionMap[73][TABLE] = ActionEntry(SHIFT, 174);
   _actionMap[74][TABLESET] = ActionEntry(REDUCE, 124);
   _actionMap[74][TABLE] = ActionEntry(REDUCE, 124);
   _actionMap[75][TABLESET] = ActionEntry(REDUCE, 125);
}
void CegoAdm::loadParser10()
{
   _actionMap[75][TABLE] = ActionEntry(REDUCE, 125);
   _actionMap[76][TABLESET] = ActionEntry(REDUCE, 123);
   _actionMap[76][TABLE] = ActionEntry(REDUCE, 123);
   _actionMap[77][TABLESET] = ActionEntry(SHIFT, 177);
   _actionMap[77][TABLE] = ActionEntry(SHIFT, 176);
   _actionMap[78][FOR] = ActionEntry(SHIFT, 178);
   _actionMap[79][FOR] = ActionEntry(SHIFT, 179);
   _actionMap[80][FOR] = ActionEntry(SHIFT, 180);
   _actionMap[81][FOR] = ActionEntry(SHIFT, 181);
   _actionMap[82][SEMICOLON] = ActionEntry(REDUCE, 24);
   _actionMap[83][FOR] = ActionEntry(SHIFT, 182);
   _actionMap[84][FOR] = ActionEntry(SHIFT, 183);
   _actionMap[85][SEMICOLON] = ActionEntry(REDUCE, 13);
   _actionMap[86][FOR] = ActionEntry(SHIFT, 184);
   _actionMap[87][SEMICOLON] = ActionEntry(REDUCE, 4);
   _actionMap[88][FOR] = ActionEntry(SHIFT, 185);
   _actionMap[89][SEMICOLON] = ActionEntry(REDUCE, 51);
   _actionMap[90][SEMICOLON] = ActionEntry(REDUCE, 14);
   _actionMap[91][FOR] = ActionEntry(SHIFT, 186);
   _actionMap[92][SEMICOLON] = ActionEntry(REDUCE, 8);
   _actionMap[93][FOR] = ActionEntry(SHIFT, 187);
   _actionMap[94][SEMICOLON] = ActionEntry(REDUCE, 46);
   _actionMap[95][LOCK] = ActionEntry(SHIFT, 188);
   _actionMap[96][IDENTIFIER] = ActionEntry(SHIFT, 189);
   _actionMap[97][SEMICOLON] = ActionEntry(REDUCE, 6);
   _actionMap[98][SEMICOLON] = ActionEntry(REDUCE, 5);
   _actionMap[99][FOR] = ActionEntry(SHIFT, 190);
   _actionMap[100][FOR] = ActionEntry(SHIFT, 191);
   _actionMap[101][IDENTIFIER] = ActionEntry(SHIFT, 192);
   _actionMap[102][IDENTIFIER] = ActionEntry(SHIFT, 193);
   _actionMap[103][IDENTIFIER] = ActionEntry(SHIFT, 194);
   _actionMap[104][IDENTIFIER] = ActionEntry(SHIFT, 195);
   _actionMap[105][IDENTIFIER] = ActionEntry(SHIFT, 196);
   _actionMap[106][FOR] = ActionEntry(SHIFT, 197);
   _actionMap[107][IDENTIFIER] = ActionEntry(SHIFT, 198);
   _actionMap[108][IDENTIFIER] = ActionEntry(SHIFT, 199);
   _actionMap[109][FROM] = ActionEntry(SHIFT, 200);
   _actionMap[110][INTVAL] = ActionEntry(SHIFT, 201);
   _actionMap[111][STRINGVAL] = ActionEntry(SHIFT, 202);
   _actionMap[112][INTVAL] = ActionEntry(SHIFT, 203);
   _actionMap[113][STRINGVAL] = ActionEntry(SHIFT, 204);
   _actionMap[114][STRINGVAL] = ActionEntry(SHIFT, 205);
   _actionMap[115][INTVAL] = ActionEntry(SHIFT, 206);
   _actionMap[116][INTVAL] = ActionEntry(SHIFT, 207);
   _actionMap[117][IDENTIFIER] = ActionEntry(SHIFT, 208);
   _actionMap[118][IDENTIFIER] = ActionEntry(SHIFT, 209);
   _actionMap[119][SIZE] = ActionEntry(SHIFT, 211);
   _actionMap[119][ENTRY] = ActionEntry(SHIFT, 210);
   _actionMap[120][INTVAL] = ActionEntry(SHIFT, 212);
   _actionMap[121][INTVAL] = ActionEntry(SHIFT, 213);
}
void CegoAdm::loadParser11()
{
   _actionMap[122][SIZE] = ActionEntry(SHIFT, 215);
   _actionMap[122][ENTRY] = ActionEntry(SHIFT, 214);
   _actionMap[123][INTVAL] = ActionEntry(SHIFT, 216);
   _actionMap[124][STRINGVAL] = ActionEntry(SHIFT, 217);
   _actionMap[125][IDENTIFIER] = ActionEntry(SHIFT, 218);
   _actionMap[126][SEMICOLON] = ActionEntry(REDUCE, 78);
   _actionMap[127][SEMICOLON] = ActionEntry(REDUCE, 77);
   _actionMap[128][SEMICOLON] = ActionEntry(REDUCE, 2);
   _actionMap[129][SEMICOLON] = ActionEntry(REDUCE, 1);
   _actionMap[130][IDENTIFIER] = ActionEntry(SHIFT, 219);
   _actionMap[131][IDENTIFIER] = ActionEntry(SHIFT, 220);
   _actionMap[132][IDENTIFIER] = ActionEntry(SHIFT, 221);
   _actionMap[133][IDENTIFIER] = ActionEntry(SHIFT, 222);
   _actionMap[134][FOR] = ActionEntry(SHIFT, 223);
   _actionMap[135][FOR] = ActionEntry(SHIFT, 224);
   _actionMap[136][IDENTIFIER] = ActionEntry(SHIFT, 225);
   _actionMap[137][IDENTIFIER] = ActionEntry(SHIFT, 226);
   _actionMap[138][SEMICOLON] = ActionEntry(REDUCE, 22);
   _actionMap[139][INTVAL] = ActionEntry(SHIFT, 227);
   _actionMap[139][SEMICOLON] = ActionEntry(REDUCE, 20);
   _actionMap[140][SEMICOLON] = ActionEntry(REDUCE, 23);
   _actionMap[141][USER] = ActionEntry(SHIFT, 228);
   _actionMap[142][USER] = ActionEntry(SHIFT, 229);
   _actionMap[143][IDENTIFIER] = ActionEntry(SHIFT, 230);
   _actionMap[1][SEMICOLON] = ActionEntry(SHIFT, 42);
   _actionMap[2][DB] = ActionEntry(SHIFT, 43);
   _actionMap[3][IDENTIFIER] = ActionEntry(SHIFT, 46);
   _actionMap[3][USER] = ActionEntry(SHIFT, 45);
   _actionMap[3][ARCHLOG] = ActionEntry(SHIFT, 44);
   _actionMap[4][ROLE] = ActionEntry(SHIFT, 47);
   _actionMap[5][TABLESET] = ActionEntry(SHIFT, 48);
   _actionMap[6][BACKUP] = ActionEntry(SHIFT, 49);
   _actionMap[7][TABLESET] = ActionEntry(SHIFT, 50);
   _actionMap[8][QUERYCACHE] = ActionEntry(SHIFT, 51);
   _actionMap[8][TABLECACHE] = ActionEntry(SHIFT, 52);
   _actionMap[9][TABLESET] = ActionEntry(SHIFT, 54);
   _actionMap[9][FILE] = ActionEntry(SHIFT, 53);
   _actionMap[10][TABLESET] = ActionEntry(SHIFT, 55);
   _actionMap[11][TABLESET] = ActionEntry(SHIFT, 57);
   _actionMap[11][ROLE] = ActionEntry(SHIFT, 56);
   _actionMap[12][TABLESET] = ActionEntry(SHIFT, 58);
   _actionMap[13][ARCHLOG] = ActionEntry(SHIFT, 59);
   _actionMap[13][AUTOCORRECT] = ActionEntry(SHIFT, 60);
   _actionMap[13][TABLECACHE] = ActionEntry(SHIFT, 62);
   _actionMap[13][QUERYCACHE] = ActionEntry(SHIFT, 61);
   _actionMap[14][TABLESET] = ActionEntry(SHIFT, 64);
   _actionMap[14][USER] = ActionEntry(SHIFT, 65);
   _actionMap[14][ROLE] = ActionEntry(SHIFT, 63);
   _actionMap[15][TABLE] = ActionEntry(SHIFT, 67);
   _actionMap[15][UINDEX] = ActionEntry(SHIFT, 66);
}
void CegoAdm::loadParser12()
{
   _actionMap[16][ARCHLOG] = ActionEntry(SHIFT, 68);
   _actionMap[16][AUTOCORRECT] = ActionEntry(SHIFT, 69);
   _actionMap[16][TABLECACHE] = ActionEntry(SHIFT, 71);
   _actionMap[16][QUERYCACHE] = ActionEntry(SHIFT, 70);
   _actionMap[17][BACKUP] = ActionEntry(SHIFT, 72);
   _actionMap[18][XML] = ActionEntry(SHIFT, 76);
   _actionMap[18][BINARY] = ActionEntry(SHIFT, 74);
   _actionMap[18][PLAIN] = ActionEntry(SHIFT, 75);
   _actionMap[18][TABLE] = ActionEntry(REDUCE, 126);
   _actionMap[18][TABLESET] = ActionEntry(REDUCE, 126);
   _jumpMap[18][XPMode] = 73;
   _actionMap[19][SEMICOLON] = ActionEntry(REDUCE, 140);
   _actionMap[20][SEMICOLON] = ActionEntry(REDUCE, 141);
   _actionMap[21][XML] = ActionEntry(SHIFT, 76);
   _actionMap[21][BINARY] = ActionEntry(SHIFT, 74);
   _actionMap[21][PLAIN] = ActionEntry(SHIFT, 75);
   _actionMap[21][TABLE] = ActionEntry(REDUCE, 126);
   _actionMap[21][TABLESET] = ActionEntry(REDUCE, 126);
   _jumpMap[21][XPMode] = 77;
   _actionMap[22][POOL] = ActionEntry(SHIFT, 87);
   _actionMap[22][IDENTIFIER] = ActionEntry(SHIFT, 95);
   _actionMap[22][TABLESET] = ActionEntry(SHIFT, 92);
   _actionMap[22][DATAFILE] = ActionEntry(SHIFT, 83);
   _actionMap[22][ARCHLOG] = ActionEntry(SHIFT, 78);
   _actionMap[22][LOGFILE] = ActionEntry(SHIFT, 84);
   _actionMap[22][OBJECT] = ActionEntry(SHIFT, 86);
   _actionMap[22][NODE] = ActionEntry(SHIFT, 85);
   _actionMap[22][SESSION] = ActionEntry(SHIFT, 90);
   _actionMap[22][BUFILE] = ActionEntry(SHIFT, 80);
   _actionMap[22][BUSTAT] = ActionEntry(SHIFT, 81);
   _actionMap[22][COPY] = ActionEntry(SHIFT, 82);
   _actionMap[22][TRANSACTION] = ActionEntry(SHIFT, 93);
   _actionMap[22][USER] = ActionEntry(SHIFT, 94);
   _actionMap[22][ROLE] = ActionEntry(SHIFT, 89);
   _actionMap[22][BACKUP] = ActionEntry(SHIFT, 79);
   _actionMap[22][QUERYCACHE] = ActionEntry(SHIFT, 88);
   _actionMap[22][TABLECACHE] = ActionEntry(SHIFT, 91);
   _actionMap[23][SEMICOLON] = ActionEntry(REDUCE, 19);
   _actionMap[24][USER] = ActionEntry(SHIFT, 96);
   _actionMap[25][ON] = ActionEntry(SHIFT, 98);
   _actionMap[25][OFF] = ActionEntry(SHIFT, 97);
   _actionMap[26][SECONDARY] = ActionEntry(SHIFT, 100);
   _actionMap[26][MEDIATOR] = ActionEntry(SHIFT, 99);
   _actionMap[27][TABLESET] = ActionEntry(SHIFT, 104);
   _actionMap[27][ROLE] = ActionEntry(SHIFT, 103);
   _actionMap[27][PERMISSION] = ActionEntry(SHIFT, 102);
   _actionMap[27][ARCHLOG] = ActionEntry(SHIFT, 101);
   _actionMap[28][TABLESET] = ActionEntry(SHIFT, 105);
   _actionMap[29][BUSTAT] = ActionEntry(SHIFT, 106);
   _actionMap[29][TABLESET] = ActionEntry(SHIFT, 107);
}
void CegoAdm::loadParser13()
{
   _actionMap[30][TABLESET] = ActionEntry(SHIFT, 108);
   _actionMap[31][TABLESET] = ActionEntry(SHIFT, 109);
   _actionMap[32][PERMISSION] = ActionEntry(SHIFT, 118);
   _actionMap[32][LOGMNG] = ActionEntry(SHIFT, 114);
   _actionMap[32][BACKUPMNG] = ActionEntry(SHIFT, 111);
   _actionMap[32][INITFILE] = ActionEntry(SHIFT, 113);
   _actionMap[32][CHECKPOINT] = ActionEntry(SHIFT, 112);
   _actionMap[32][SYSSIZE] = ActionEntry(SHIFT, 121);
   _actionMap[32][TMPSIZE] = ActionEntry(SHIFT, 123);
   _actionMap[32][APPSIZE] = ActionEntry(SHIFT, 110);
   _actionMap[32][TSROOT] = ActionEntry(SHIFT, 124);
   _actionMap[32][LOGNUM] = ActionEntry(SHIFT, 115);
   _actionMap[32][LOGSIZE] = ActionEntry(SHIFT, 116);
   _actionMap[32][SORTAREASIZE] = ActionEntry(SHIFT, 120);
   _actionMap[32][LOGUSER] = ActionEntry(SHIFT, 117);
   _actionMap[32][QUERYCACHE] = ActionEntry(SHIFT, 119);
   _actionMap[32][TABLECACHE] = ActionEntry(SHIFT, 122);
   _actionMap[33][IDENTIFIER] = ActionEntry(SHIFT, 125);
   _actionMap[34][POOL] = ActionEntry(SHIFT, 129);
   _actionMap[34][PARAMETER] = ActionEntry(SHIFT, 128);
   _actionMap[34][TABLESET] = ActionEntry(SHIFT, 131);
   _actionMap[34][ROLE] = ActionEntry(SHIFT, 130);
   _actionMap[34][LOGMNG] = ActionEntry(SHIFT, 127);
   _actionMap[34][BACKUPMNG] = ActionEntry(SHIFT, 126);
   _actionMap[35][TABLESET] = ActionEntry(SHIFT, 132);
   _actionMap[36][TABLESET] = ActionEntry(SHIFT, 133);
   _actionMap[37][TABLESET] = ActionEntry(SHIFT, 136);
   _actionMap[37][SECONDARY] = ActionEntry(SHIFT, 135);
   _actionMap[37][MEDIATOR] = ActionEntry(SHIFT, 134);
   _actionMap[38][TABLESET] = ActionEntry(SHIFT, 137);
   _actionMap[39][SEMICOLON] = ActionEntry(REDUCE, 18);
   _actionMap[39][DB] = ActionEntry(SHIFT, 139);
   _actionMap[39][ADM] = ActionEntry(SHIFT, 138);
   _actionMap[39][LOG] = ActionEntry(SHIFT, 140);
   _actionMap[40][ON] = ActionEntry(SHIFT, 142);
   _actionMap[40][OFF] = ActionEntry(SHIFT, 141);
   _actionMap[41][TABLESET] = ActionEntry(SHIFT, 143);
   _actionMap[0][SHOW] = ActionEntry(SHIFT, 34);
   _actionMap[0][LIST] = ActionEntry(SHIFT, 22);
   _actionMap[0][RAWMODE] = ActionEntry(SHIFT, 25);
   _actionMap[0][RESET] = ActionEntry(SHIFT, 29);
   _actionMap[0][THREADINFO] = ActionEntry(SHIFT, 39);
   _actionMap[0][LOCKSTAT] = ActionEntry(SHIFT, 23);
   _actionMap[0][ABORT] = ActionEntry(SHIFT, 2);
   _actionMap[0][RETRIEVE] = ActionEntry(SHIFT, 31);
   _actionMap[0][DEFINE] = ActionEntry(SHIFT, 12);
   _actionMap[0][CREATE] = ActionEntry(SHIFT, 11);
   _actionMap[0][START_TOK] = ActionEntry(SHIFT, 35);
   _actionMap[0][STOP_TOK] = ActionEntry(SHIFT, 36);
   _actionMap[0][COPY] = ActionEntry(SHIFT, 9);
}
void CegoAdm::loadParser14()
{
   _actionMap[0][SWITCH] = ActionEntry(SHIFT, 37);
   _actionMap[0][RELOCATE] = ActionEntry(SHIFT, 26);
   _actionMap[0][DROP] = ActionEntry(SHIFT, 14);
   _actionMap[0][REMOVE] = ActionEntry(SHIFT, 27);
   _actionMap[0][ADD] = ActionEntry(SHIFT, 3);
   _actionMap[0][CHECK] = ActionEntry(SHIFT, 7);
   _actionMap[0][VERIFY] = ActionEntry(SHIFT, 41);
   _actionMap[0][CORRECT] = ActionEntry(SHIFT, 10);
   _actionMap[0][PASSWD] = ActionEntry(SHIFT, 24);
   _actionMap[0][ASSIGN] = ActionEntry(SHIFT, 4);
   _actionMap[0][SET] = ActionEntry(SHIFT, 32);
   _actionMap[0][TRACE] = ActionEntry(SHIFT, 40);
   _actionMap[0][ENABLE] = ActionEntry(SHIFT, 16);
   _actionMap[0][DISABLE] = ActionEntry(SHIFT, 13);
   _actionMap[0][BEGIN_TOKEN] = ActionEntry(SHIFT, 6);
   _actionMap[0][BACKUP] = ActionEntry(SHIFT, 5);
   _actionMap[0][END_TOKEN] = ActionEntry(SHIFT, 17);
   _actionMap[0][SYNC] = ActionEntry(SHIFT, 38);
   _actionMap[0][RESTORE] = ActionEntry(SHIFT, 30);
   _actionMap[0][RECOVER] = ActionEntry(SHIFT, 28);
   _actionMap[0][CLEAN] = ActionEntry(SHIFT, 8);
   _actionMap[0][EXPORT] = ActionEntry(SHIFT, 18);
   _actionMap[0][IMPORT] = ActionEntry(SHIFT, 21);
   _actionMap[0][GETDBSPEC] = ActionEntry(SHIFT, 19);
   _actionMap[0][GETDBINFO] = ActionEntry(SHIFT, 20);
   _actionMap[0][SETTSNODEINFO] = ActionEntry(SHIFT, 33);
   _actionMap[0][DUMP] = ActionEntry(SHIFT, 15);
   _jumpMap[0][Statement] = 1;
}
void CegoAdm::loadParser15()
{
   _prodInfo.Insert(ProdEntry(145, Statement, 5));
   _prodInfo.Insert(ProdEntry(144, Statement, 5));
   _prodInfo.Insert(ProdEntry(143, Statement, 3));
   _prodInfo.Insert(ProdEntry(142, Statement, 5));
   _prodInfo.Insert(ProdEntry(141, Statement, 1));
   _prodInfo.Insert(ProdEntry(140, Statement, 1));
   _prodInfo.Insert(ProdEntry(139, PitOption, 0));
   _prodInfo.Insert(ProdEntry(138, PitOption, 2));
   _prodInfo.Insert(ProdEntry(137, Attr, 3));
   _prodInfo.Insert(ProdEntry(136, Attr, 3));
   _prodInfo.Insert(ProdEntry(135, Attr, 3));
   _prodInfo.Insert(ProdEntry(134, Attr, 3));
   _prodInfo.Insert(ProdEntry(133, Attr, 3));
   _prodInfo.Insert(ProdEntry(132, Attr, 3));
   _prodInfo.Insert(ProdEntry(131, Attr, 3));
   _prodInfo.Insert(ProdEntry(130, Attr, 3));
   _prodInfo.Insert(ProdEntry(129, Attr, 3));
   _prodInfo.Insert(ProdEntry(128, AttrList, 0));
   _prodInfo.Insert(ProdEntry(127, AttrList, 2));
   _prodInfo.Insert(ProdEntry(126, XPMode, 0));
   _prodInfo.Insert(ProdEntry(125, XPMode, 1));
   _prodInfo.Insert(ProdEntry(124, XPMode, 1));
   _prodInfo.Insert(ProdEntry(123, XPMode, 1));
   _prodInfo.Insert(ProdEntry(122, StartOpt, 1));
   _prodInfo.Insert(ProdEntry(121, StartOpt, 1));
   _prodInfo.Insert(ProdEntry(120, StartOpt, 1));
   _prodInfo.Insert(ProdEntry(119, StartOpt, 1));
   _prodInfo.Insert(ProdEntry(118, StartOptList, 0));
   _prodInfo.Insert(ProdEntry(117, StartOptList, 2));
   _prodInfo.Insert(ProdEntry(116, MsgOption, 0));
   _prodInfo.Insert(ProdEntry(115, MsgOption, 2));
   _prodInfo.Insert(ProdEntry(114, TimeoutOpt, 0));
   _prodInfo.Insert(ProdEntry(113, TimeoutOpt, 2));
   _prodInfo.Insert(ProdEntry(112, SyncCmdOption, 0));
   _prodInfo.Insert(ProdEntry(111, SyncCmdOption, 3));
   _prodInfo.Insert(ProdEntry(110, KeepTicketOpt, 0));
   _prodInfo.Insert(ProdEntry(109, KeepTicketOpt, 2));
   _prodInfo.Insert(ProdEntry(108, Statement, 7));
   _prodInfo.Insert(ProdEntry(107, Statement, 6));
   _prodInfo.Insert(ProdEntry(106, Statement, 8));
   _prodInfo.Insert(ProdEntry(105, Statement, 7));
   _prodInfo.Insert(ProdEntry(104, Statement, 6));
   _prodInfo.Insert(ProdEntry(103, Statement, 8));
   _prodInfo.Insert(ProdEntry(102, Statement, 6));
   _prodInfo.Insert(ProdEntry(101, Statement, 6));
   _prodInfo.Insert(ProdEntry(100, Statement, 4));
   _prodInfo.Insert(ProdEntry(99, Statement, 4));
   _prodInfo.Insert(ProdEntry(98, Statement, 6));
   _prodInfo.Insert(ProdEntry(97, Statement, 6));
   _prodInfo.Insert(ProdEntry(96, Statement, 4));
   _prodInfo.Insert(ProdEntry(95, Statement, 4));
   _prodInfo.Insert(ProdEntry(94, Statement, 4));
   _prodInfo.Insert(ProdEntry(93, Statement, 4));
   _prodInfo.Insert(ProdEntry(92, Statement, 4));
   _prodInfo.Insert(ProdEntry(91, Statement, 4));
   _prodInfo.Insert(ProdEntry(90, Statement, 4));
   _prodInfo.Insert(ProdEntry(89, Statement, 4));
   _prodInfo.Insert(ProdEntry(88, Statement, 5));
   _prodInfo.Insert(ProdEntry(87, Statement, 5));
   _prodInfo.Insert(ProdEntry(86, Statement, 5));
   _prodInfo.Insert(ProdEntry(85, Statement, 5));
   _prodInfo.Insert(ProdEntry(84, Statement, 5));
   _prodInfo.Insert(ProdEntry(83, Statement, 5));
   _prodInfo.Insert(ProdEntry(82, Statement, 5));
   _prodInfo.Insert(ProdEntry(81, Statement, 5));
   _prodInfo.Insert(ProdEntry(80, Statement, 5));
   _prodInfo.Insert(ProdEntry(79, Statement, 5));
   _prodInfo.Insert(ProdEntry(78, Statement, 2));
   _prodInfo.Insert(ProdEntry(77, Statement, 2));
   _prodInfo.Insert(ProdEntry(76, Statement, 3));
   _prodInfo.Insert(ProdEntry(75, Statement, 4));
   _prodInfo.Insert(ProdEntry(74, Statement, 4));
   _prodInfo.Insert(ProdEntry(73, Statement, 5));
   _prodInfo.Insert(ProdEntry(72, Statement, 5));
   _prodInfo.Insert(ProdEntry(71, Statement, 4));
   _prodInfo.Insert(ProdEntry(70, Statement, 6));
   _prodInfo.Insert(ProdEntry(69, Statement, 4));
   _prodInfo.Insert(ProdEntry(68, Statement, 5));
   _prodInfo.Insert(ProdEntry(67, Statement, 5));
   _prodInfo.Insert(ProdEntry(66, Statement, 7));
   _prodInfo.Insert(ProdEntry(65, Statement, 4));
   _prodInfo.Insert(ProdEntry(64, Statement, 4));
   _prodInfo.Insert(ProdEntry(63, Statement, 4));
   _prodInfo.Insert(ProdEntry(62, Statement, 4));
   _prodInfo.Insert(ProdEntry(61, Statement, 5));
   _prodInfo.Insert(ProdEntry(60, PermEntry, 3));
   _prodInfo.Insert(ProdEntry(59, PermEntry, 3));
   _prodInfo.Insert(ProdEntry(58, PermEntry, 3));
   _prodInfo.Insert(ProdEntry(57, PermList, 1));
   _prodInfo.Insert(ProdEntry(56, PermList, 3));
   _prodInfo.Insert(ProdEntry(55, Statement, 7));
   _prodInfo.Insert(ProdEntry(54, Statement, 3));
   _prodInfo.Insert(ProdEntry(53, Statement, 3));
   _prodInfo.Insert(ProdEntry(52, Statement, 3));
   _prodInfo.Insert(ProdEntry(51, Statement, 2));
   _prodInfo.Insert(ProdEntry(50, Statement, 5));
   _prodInfo.Insert(ProdEntry(49, Statement, 5));
   _prodInfo.Insert(ProdEntry(48, Statement, 6));
   _prodInfo.Insert(ProdEntry(47, Statement, 3));
   _prodInfo.Insert(ProdEntry(46, Statement, 2));
   _prodInfo.Insert(ProdEntry(45, Statement, 6));
   _prodInfo.Insert(ProdEntry(44, Statement, 3));
   _prodInfo.Insert(ProdEntry(43, Statement, 3));
   _prodInfo.Insert(ProdEntry(42, Statement, 3));
   _prodInfo.Insert(ProdEntry(41, Statement, 8));
   _prodInfo.Insert(ProdEntry(40, Statement, 3));
   _prodInfo.Insert(ProdEntry(39, Statement, 3));
   _prodInfo.Insert(ProdEntry(38, Statement, 3));
   _prodInfo.Insert(ProdEntry(37, Statement, 6));
   _prodInfo.Insert(ProdEntry(36, Statement, 6));
   _prodInfo.Insert(ProdEntry(35, Statement, 4));
   _prodInfo.Insert(ProdEntry(34, Statement, 4));
   _prodInfo.Insert(ProdEntry(33, Statement, 3));
   _prodInfo.Insert(ProdEntry(32, Statement, 3));
   _prodInfo.Insert(ProdEntry(31, Statement, 3));
   _prodInfo.Insert(ProdEntry(30, Statement, 4));
   _prodInfo.Insert(ProdEntry(29, Statement, 3));
   _prodInfo.Insert(ProdEntry(28, Statement, 4));
   _prodInfo.Insert(ProdEntry(27, Statement, 4));
   _prodInfo.Insert(ProdEntry(26, Statement, 4));
   _prodInfo.Insert(ProdEntry(25, Statement, 4));
   _prodInfo.Insert(ProdEntry(24, Statement, 2));
   _prodInfo.Insert(ProdEntry(23, Statement, 2));
   _prodInfo.Insert(ProdEntry(22, Statement, 2));
   _prodInfo.Insert(ProdEntry(21, Statement, 3));
   _prodInfo.Insert(ProdEntry(20, Statement, 2));
   _prodInfo.Insert(ProdEntry(19, Statement, 1));
   _prodInfo.Insert(ProdEntry(18, Statement, 1));
   _prodInfo.Insert(ProdEntry(17, Statement, 4));
   _prodInfo.Insert(ProdEntry(16, Statement, 4));
   _prodInfo.Insert(ProdEntry(15, Statement, 4));
   _prodInfo.Insert(ProdEntry(14, Statement, 2));
   _prodInfo.Insert(ProdEntry(13, Statement, 2));
   _prodInfo.Insert(ProdEntry(12, Statement, 4));
   _prodInfo.Insert(ProdEntry(11, Statement, 4));
   _prodInfo.Insert(ProdEntry(10, Statement, 4));
   _prodInfo.Insert(ProdEntry(9, Statement, 4));
   _prodInfo.Insert(ProdEntry(8, Statement, 2));
   _prodInfo.Insert(ProdEntry(7, Statement, 3));
   _prodInfo.Insert(ProdEntry(6, Statement, 2));
   _prodInfo.Insert(ProdEntry(5, Statement, 2));
   _prodInfo.Insert(ProdEntry(4, Statement, 2));
   _prodInfo.Insert(ProdEntry(3, Statement, 3));
   _prodInfo.Insert(ProdEntry(2, Statement, 2));
   _prodInfo.Insert(ProdEntry(1, Statement, 2));
   _prodInfo.Insert(ProdEntry(0, Start, 2));
}

CegoAdm::CegoAdm()
{
   loadScanner();
   for ( int i=0; i < 423; i++)
   {
      int j;
      for ( j = 0; j < 118; j++)
         _actionMap[i][j] = ActionEntry();
      for ( j = 0; j < 15; j++)
         _jumpMap[i][j] = -1;
   }
   loadParser0();
   loadParser1();
   loadParser2();
   loadParser3();
   loadParser4();
   loadParser5();
   loadParser6();
   loadParser7();
   loadParser8();
   loadParser9();
   loadParser10();
   loadParser11();
   loadParser12();
   loadParser13();
   loadParser14();
   loadParser15();
   _isReserved = false;
}

CegoAdm::~CegoAdm()
{
}

void CegoAdm::parse()
{
   StackT<StackEntry> s;
   StackEntry se(NONE, 0, 0);
   s.Push(se);
   _isReserved = false;
   if ( shiftToken() == false )
   {
      Chain msg = "Parse error at token <" + Chain(_tokenVal) + ">.";
      throw Exception(EXLOC, msg);
   }
   while ( true )
   {
      Action a;
      int num;
      if ( getAction(s.getTop()->getState(), _token, a, num) )
      {
         switch (a)
         {
            case SHIFT:
            {
               StackEntry se(TOKEN, _token, num, _tokenVal);
               s.Push(se);
               if ( shiftToken() == false )
               {
                  Chain msg = "Parse error at token <" + Chain(_tokenVal) + ">.";
                  throw Exception(EXLOC, msg);
               }
               break;
            }
            case REDUCE:
            {
               _tokenList.Empty();
               ProdEntry* pPE = _prodInfo.Find(num);
               for (int i=0; i<pPE->getNumSymbol();i++)
               {
                  StackEntry se;
                  s.Pop(se);
                  if (se.getSymbol() == TOKEN)
                     _tokenList.Insert(se.getTval());
               }
               int fstate;
               if (getJump(s.getTop()->getState(), pPE->getProd(), fstate))
               {
                  StackEntry se(PROD, pPE->getId(), fstate, _tokenVal);
                  s.Push(se);
               }
               else
               {
                  Chain msg = "Cannot reduce after token <" + Chain(_tokenVal) + ">.";
                  throw Exception(EXLOC, msg);
               }
               switch (num)
               {
                  case 145:
                     dumpUIndex();
                     break;
                  case 144:
                     dumpTable();
                     break;
                  case 143:
                     copyFileAction();
                     break;
                  case 142:
                     setTableSetNodeAction();
                     break;
                  case 141:
                     getDbInfoAction();
                     break;
                  case 140:
                     getDbSpecAction();
                     break;
                  case 138:
                     storePit();
                     break;
                  case 137:
                     storeTSRootAttr();
                     break;
                  case 136:
                     storeSortAreaAttr();
                     break;
                  case 135:
                     storeAppSizeAttr();
                     break;
                  case 134:
                     storeLogNumAttr();
                     break;
                  case 133:
                     storeLogSizeAttr();
                     break;
                  case 132:
                     storeTmpSizeAttr();
                     break;
                  case 131:
                     storeSysSizeAttr();
                     break;
                  case 130:
                     storeSecondaryAttr();
                     break;
                  case 129:
                     storePrimaryAttr();
                     break;
                  case 125:
                     plainModeAction();
                     break;
                  case 124:
                     binModeAction();
                     break;
                  case 123:
                     xmlModeAction();
                     break;
                  case 122:
                     noInitAction();
                     break;
                  case 121:
                     cpDumpAction();
                     break;
                  case 120:
                     forceloadAction();
                     break;
                  case 119:
                     cleanupAction();
                     break;
                  case 115:
                     msgAction();
                     break;
                  case 113:
                     timeoutAction();
                     break;
                  case 111:
                     syncCmdAction();
                     break;
                  case 109:
                     keepTicketAction();
                     break;
                  case 108:
                     importTableSetStructureAction();
                     break;
                  case 107:
                     importTableSetAction();
                     break;
                  case 106:
                     importTableAction();
                     break;
                  case 105:
                     exportTableSetStructureAction();
                     break;
                  case 104:
                     exportTableSetAction();
                     break;
                  case 103:
                     exportTableAction();
                     break;
                  case 102:
                     setTableCacheSizeAction();
                     break;
                  case 101:
                     setTableCacheEntryAction();
                     break;
                  case 100:
                     cleanTableCacheAction();
                     break;
                  case 99:
                     listTableCacheAction();
                     break;
                  case 98:
                     setQueryCacheSizeAction();
                     break;
                  case 97:
                     setQueryCacheEntryAction();
                     break;
                  case 96:
                     cleanQueryCacheAction();
                     break;
                  case 95:
                     listQueryCacheAction();
                     break;
                  case 94:
                     disableQueryCacheAction();
                     break;
                  case 93:
                     enableQueryCacheAction();
                     break;
                  case 92:
                     disableTableCacheAction();
                     break;
                  case 91:
                     enableTableCacheAction();
                     break;
                  case 90:
                     disableAutoCorrectAction();
                     break;
                  case 89:
                     enableAutoCorrectAction();
                     break;
                  case 88:
                     setTSLogUserAction();
                     break;
                  case 87:
                     setTSSortAreaSizeAction();
                     break;
                  case 86:
                     setTSLogSizeAction();
                     break;
                  case 85:
                     setTSLogNumAction();
                     break;
                  case 84:
                     setTSRootPathAction();
                     break;
                  case 83:
                     setTSAppSizeAction();
                     break;
                  case 82:
                     setTSTmpSizeAction();
                     break;
                  case 81:
                     setTSSysSizeAction();
                     break;
                  case 80:
                     setCheckpointAction();
                     break;
                  case 79:
                     setTSInitFileAction();
                     break;
                  case 78:
                     showBackupMngAction();
                     break;
                  case 77:
                     showLogMngAction();
                     break;
                  case 76:
                     setBackupMngAction();
                     break;
                  case 75:
                     setLogMngAction();
                     break;
                  case 74:
                     recoverTableSetAction();
                     break;
                  case 73:
                     restoreTableSetAction();
                     break;
                  case 72:
                     syncTableSetAction();
                     break;
                  case 71:
                     listBackupAction();
                     break;
                  case 70:
                     endBackupAction();
                     break;
                  case 69:
                     executeBackupAction();
                     break;
                  case 68:
                     beginBackupAction();
                     break;
                  case 67:
                     removeArchLogAction();
                     break;
                  case 66:
                     addArchLogAction();
                     break;
                  case 65:
                     disableArchLogAction();
                     break;
                  case 64:
                     enableArchLogAction();
                     break;
                  case 63:
                     traceOffAction();
                     break;
                  case 62:
                     traceOnAction();
                     break;
                  case 61:
                     removePermAction();
                     break;
                  case 60:
                     setRightPerm();
                     break;
                  case 59:
                     setFilterPerm();
                     break;
                  case 58:
                     setTableSetPerm();
                     break;
                  case 55:
                     setPermAction();
                     break;
                  case 54:
                     dropRoleAction();
                     break;
                  case 53:
                     createRoleAction();
                     break;
                  case 52:
                     showRoleAction();
                     break;
                  case 51:
                     listRoleAction();
                     break;
                  case 50:
                     removeRoleAction();
                     break;
                  case 49:
                     assignRoleAction();
                     break;
                  case 48:
                     changePwdAction();
                     break;
                  case 47:
                     removeUserAction();
                     break;
                  case 46:
                     listUserAction();
                     break;
                  case 45:
                     addUserAction();
                     break;
                  case 44:
                     correctTableSetAction();
                     break;
                  case 43:
                     verifyTableSetAction();
                     break;
                  case 42:
                     checkTableSetAction();
                     break;
                  case 41:
                     addDataFileAction();
                     break;
                  case 40:
                     resetTableSetAction();
                     break;
                  case 39:
                     removeTableSetAction();
                     break;
                  case 38:
                     dropTableSetAction();
                     break;
                  case 37:
                     relocateMediatorAction();
                     break;
                  case 36:
                     relocateSecondaryAction();
                     break;
                  case 35:
                     switchMediatorAction();
                     break;
                  case 34:
                     switchSecondaryAction();
                     break;
                  case 33:
                     switchTableSetAction();
                     break;
                  case 32:
                     copyTableSetAction();
                     break;
                  case 31:
                     stopTableSetAction();
                     break;
                  case 30:
                     startTableSetAction();
                     break;
                  case 29:
                     createTableSetAction();
                     break;
                  case 28:
                     defineTableSetAction();
                     break;
                  case 27:
                     retrieveTableSetAction();
                     break;
                  case 26:
                     abortDbThreadAction();
                     break;
                  case 25:
                     transactionInfoAction();
                     break;
                  case 24:
                     copyInfoAction();
                     break;
                  case 23:
                     logThreadInfoAction();
                     break;
                  case 22:
                     admThreadInfoAction();
                     break;
                  case 21:
                     dbThreadLastQueryAction();
                     break;
                  case 20:
                     dbThreadInfoAction();
                     break;
                  case 19:
                     lockStatAction();
                     break;
                  case 18:
                     threadInfoAction();
                     break;
                  case 17:
                     buStatResetAction();
                     break;
                  case 16:
                     buStatInfoAction();
                     break;
                  case 15:
                     buFileInfoAction();
                     break;
                  case 14:
                     dbSessionInfoAction();
                     break;
                  case 13:
                     listNodeAction();
                     break;
                  case 12:
                     objInfoAction();
                     break;
                  case 11:
                     logInfoAction();
                     break;
                  case 10:
                     archLogInfoAction();
                     break;
                  case 9:
                     dataFileInfoAction();
                     break;
                  case 8:
                     listTableSetAction();
                     break;
                  case 7:
                     lockInfoAction();
                     break;
                  case 6:
                     rawModeOff();
                     break;
                  case 5:
                     rawModeOn();
                     break;
                  case 4:
                     poolEntryListAction();
                     break;
                  case 3:
                     tableSetInfoAction();
                     break;
                  case 2:
                     parameterInfoAction();
                     break;
                  case 1:
                     poolInfoAction();
                     break;
               }
               break;
            }
            case ACCEPT:
            {
               statementAction();
               return;
            }
            case NULLACTION:
               break;
         }
      }
      else
      {
         Chain msg = "Parse error at token <" + Chain(_tokenVal) + ">.";
         throw Exception(EXLOC, msg);
      }
   }
}


bool CegoAdm::getAction(int state, CegoAdm::Token token, CegoAdm::Action& a, int& num)
{
    if (_actionMap[state][token].getAction() != NULLACTION )
    {
	a = _actionMap[state][token].getAction();
	num = _actionMap[state][token].getNum();
	return true;
    }
    else
    {
	return false;
    }
}

bool CegoAdm::getJump(int state, Production prod, int& fstate)
{
    if ( _jumpMap[state][prod] > 0 )
    {
       fstate = _jumpMap[state][prod];
	    return true;
    }
    else
    {
	    return false;
    }
}

bool CegoAdm::isSepSign(char c)
{
   if (c == '.') return true;
   if (c == ';') return true;
   if (c == ',') return true;
   if (c == '=') return true;
   if (c == '<') return true;
   if (c == '>') return true;
   if (c == ')') return true;
   if (c == '(') return true;
   if (c == '[') return true;
   if (c == ']') return true;
   if (c == '*') return true;
   if (c == '/') return true;
   if (c == '+') return true;
   if (c == '-') return true;
   if (c == '|') return true;
   return false;
}
bool CegoAdm::isSepIgnore(char c)
{
   if (c == '\t') return true;
   if (c == ' ') return true;
   return false;
}
bool CegoAdm::shiftToken()
{
   unsigned long i=0;
   char c;
   while ( isSepIgnore(c = nextChar()) && ! _isReserved );
   if ( _isReserved )
   {
      _token = _reservedToken;
      _isReserved = false;
      return true;
   }
   if (c == 0)
   {
      _token = ENDTOKEN;
      return true;
   }
   if (isSepSign(c))
   {
      _tokenVal[i]=c;
       i++;
   }
   else
   {
      while (c && ! isSepIgnore(c) && ! ( isSepSign(c) && i>0 ) )
      {
         _tokenVal[i]=c;
         i++;
         c = nextChar();
      }
      if (isSepSign(c)) backChar();
   }
   _tokenVal[i]=0;
   Scanner* pS = _scannerList.First();
   while (pS)
   {
      if (pS->checkPattern(_tokenVal))
      {
         _token = pS->getToken();
         return true;
      }
      pS=_scannerList.Next();
   }
   return false;
}
void CegoAdm::setReserved(Token t)
{
   _reservedToken = t;
   _isReserved = true;
}
