# -*- Autoconf -*-
#
# Copyright (C) 2005-2025 ABINIT Group (Yann Pouillon)
#
# This file is part of the ABINIT software package. For license information,
# please see the COPYING file in the top-level directory of the ABINIT source
# distribution.
#

# Generated by make-macros-options on 2025/09/05 19:42:00 +0000

#
# Command-line options for the "configure" script
#

#
# IMPORTANT NOTE
#
# This file has been automatically generated by the make-macros-options
# script. If you try to edit it, your changes will systematically be
# overwritten.
#



# ABI_OPTIONS_DEFINE()
# --------------------
#
# Declares command-line arguments for the "configure" script.
#
AC_DEFUN([ABI_OPTIONS_DEFINE],[
  # Count use of deprecated options
  abi_opt_deprecated_count=0
  abi_opt_deprecated_used=""


  #
  # --enable arguments
  #

  AC_ARG_ENABLE(avx-safe-mode,
    AS_HELP_STRING([--enable-avx-safe-mode],
      [Disable vectorization in problematic procedures (default: no)]),
    [abi_avx_safe_mode_enable="${enableval}"; abi_avx_safe_mode_init="yon"],
    [abi_avx_safe_mode_enable="no"; abi_avx_safe_mode_init="def"])
  AC_SUBST(enable_avx_safe_mode)
  AC_SUBST(abi_avx_safe_mode_enable)

  AC_ARG_ENABLE(cclock,
    AS_HELP_STRING([--enable-cclock],
      [Use C clock for timings (default: no)]),
    [abi_cclock_enable="${enableval}"; abi_cclock_init="yon"],
    [abi_cclock_enable="no"; abi_cclock_init="def"])
  AC_SUBST(enable_cclock)
  AC_SUBST(abi_cclock_enable)

  AC_ARG_ENABLE(crpa-optim,
    AS_HELP_STRING([--enable-crpa-optim],
      [Enable optimize cRPA calculations for ifort <= 17.0 (default: no)]),
    [abi_crpa_optim_enable="${enableval}"; abi_crpa_optim_init="yon"],
    [abi_crpa_optim_enable="no"; abi_crpa_optim_init="def"])
  AC_SUBST(enable_crpa_optim)
  AC_SUBST(abi_crpa_optim_enable)

  AC_ARG_ENABLE(fc-wrapper,
    AS_HELP_STRING([--enable-fc-wrapper],
      [Wrap Fortran compiler calls (default: no)]),
    [abi_fc_wrapper_enable="${enableval}"; abi_fc_wrapper_init="yon"],
    [abi_fc_wrapper_enable="no"; abi_fc_wrapper_init="def"])
  AC_SUBST(enable_fc_wrapper)
  AC_SUBST(abi_fc_wrapper_enable)

  AC_ARG_ENABLE(gpu-nvidia-unified-memory,
    AS_HELP_STRING([--enable-gpu-nvidia-unified-memory],
      [Activate use of NVIDIA unified memory (requires NVHPC as compiler and OpenMP offload) (default: no)]),
    [abi_gpu_nvidia_unified_memory_enable="${enableval}"; abi_gpu_nvidia_unified_memory_init="yon"],
    [abi_gpu_nvidia_unified_memory_enable="no"; abi_gpu_nvidia_unified_memory_init="def"])
  AC_SUBST(enable_gpu_nvidia_unified_memory)
  AC_SUBST(abi_gpu_nvidia_unified_memory_enable)

  AC_ARG_ENABLE(gw-dpc,
    AS_HELP_STRING([--enable-gw-dpc],
      [Activate double-precision GW calculations (default: no)]),
    [abi_gw_dpc_enable="${enableval}"; abi_gw_dpc_init="yon"],
    [abi_gw_dpc_enable="no"; abi_gw_dpc_init="def"])
  AC_SUBST(enable_gw_dpc)
  AC_SUBST(abi_gw_dpc_enable)

  AC_ARG_ENABLE(hints,
    AS_HELP_STRING([--enable-hints],
      [Automatically adjust build flags to the current configuration (default: yes)]),
    [abi_hints_enable="${enableval}"; abi_hints_init="yon"],
    [abi_hints_enable="yes"; abi_hints_init="def"])
  AC_SUBST(enable_hints)
  AC_SUBST(abi_hints_enable)

  AC_ARG_ENABLE(libtetra,
    AS_HELP_STRING([--enable-libtetra],
      [Activate internal support for libtetra(hedron) in ABINIT (default: yes)]),
    [abi_libtetra_enable="${enableval}"; abi_libtetra_init="yon"],
    [abi_libtetra_enable="yes"; abi_libtetra_init="def"])
  AC_SUBST(enable_libtetra)
  AC_SUBST(abi_libtetra_enable)

  AC_ARG_ENABLE(lotf,
    AS_HELP_STRING([--enable-lotf],
      [Activate LOTF functionality (UNMAINTAINED) (default: no)]),
    [abi_lotf_enable="${enableval}"; abi_lotf_init="yon"],
    [abi_lotf_enable="no"; abi_lotf_init="def"])
  AC_SUBST(enable_lotf)
  AC_SUBST(abi_lotf_enable)

  AC_ARG_ENABLE(memory-profiling,
    AS_HELP_STRING([--enable-memory-profiling],
      [Enable memory profiling (default: no)]),
    [abi_memory_profiling_enable="${enableval}"; abi_memory_profiling_init="yon"],
    [abi_memory_profiling_enable="no"; abi_memory_profiling_init="def"])
  AC_SUBST(enable_memory_profiling)
  AC_SUBST(abi_memory_profiling_enable)

  AC_ARG_ENABLE(mpi-gpu-aware,
    AS_HELP_STRING([--enable-mpi-gpu-aware],
      [Assume support for passing GPU buffers to MPI (default: no)]),
    [abi_mpi_gpu_aware_enable="${enableval}"; abi_mpi_gpu_aware_init="yon"],
    [abi_mpi_gpu_aware_enable="no"; abi_mpi_gpu_aware_init="def"])
  AC_SUBST(enable_mpi_gpu_aware)
  AC_SUBST(abi_mpi_gpu_aware_enable)

  AC_ARG_ENABLE(mpi-inplace,
    AS_HELP_STRING([--enable-mpi-inplace],
      [Activate support for MPI_IN_PLACE (default: auto)]),
    [abi_mpi_inplace_enable="${enableval}"; abi_mpi_inplace_init="yon"],
    [abi_mpi_inplace_enable="auto"; abi_mpi_inplace_init="def"])
  AC_SUBST(enable_mpi_inplace)
  AC_SUBST(abi_mpi_inplace_enable)

  AC_ARG_ENABLE(mpi-interfaces-bugfix,
    AS_HELP_STRING([--enable-mpi-interfaces-bugfix],
      [Activate workaround for buggy MPI interfaces (not having interfaces for scalars) (default: auto)]),
    [abi_mpi_interfaces_bugfix_enable="${enableval}"; abi_mpi_interfaces_bugfix_init="yon"],
    [abi_mpi_interfaces_bugfix_enable="auto"; abi_mpi_interfaces_bugfix_init="def"])
  AC_SUBST(enable_mpi_interfaces_bugfix)
  AC_SUBST(abi_mpi_interfaces_bugfix_enable)

  AC_ARG_ENABLE(mpi-io,
    AS_HELP_STRING([--enable-mpi-io],
      [Enable MPI I/O (default: auto)]),
    [abi_mpi_io_enable="${enableval}"; abi_mpi_io_init="yon"],
    [abi_mpi_io_enable="auto"; abi_mpi_io_init="def"])
  AC_SUBST(enable_mpi_io)
  AC_SUBST(abi_mpi_io_enable)

  AC_ARG_ENABLE(mpi-io-default,
    AS_HELP_STRING([--enable-mpi-io-default],
      [Use MPI I/O as default I/O library (maintainer-only option) (default: no)]),
    [abi_mpi_io_default_enable="${enableval}"; abi_mpi_io_default_init="yon"],
    [abi_mpi_io_default_enable="no"; abi_mpi_io_default_init="def"])
  AC_SUBST(enable_mpi_io_default)
  AC_SUBST(abi_mpi_io_default_enable)

  AC_ARG_ENABLE(netcdf-default,
    AS_HELP_STRING([--enable-netcdf-default],
      [Use NetCDF as default I/O library (maintainer-only option) (default: no)]),
    [abi_netcdf_default_enable="${enableval}"; abi_netcdf_default_init="yon"],
    [abi_netcdf_default_enable="no"; abi_netcdf_default_init="def"])
  AC_SUBST(enable_netcdf_default)
  AC_SUBST(abi_netcdf_default_enable)

  AC_ARG_ENABLE(openmp,
    AS_HELP_STRING([--enable-openmp],
      [Activate support for OpenMP (default: no)]),
    [abi_openmp_enable="${enableval}"; abi_openmp_init="yon"],
    [abi_openmp_enable="no"; abi_openmp_init="def"])
  AC_SUBST(enable_openmp)
  AC_SUBST(abi_openmp_enable)

  AC_ARG_ENABLE(openmp-offload,
    AS_HELP_STRING([--enable-openmp-offload],
      [Activate support for OpenMP GPU offload capabilities (default: no)]),
    [abi_openmp_offload_enable="${enableval}"; abi_openmp_offload_init="yon"],
    [abi_openmp_offload_enable="no"; abi_openmp_offload_init="def"])
  AC_SUBST(enable_openmp_offload)
  AC_SUBST(abi_openmp_offload_enable)

  AC_ARG_ENABLE(python-invocation,
    AS_HELP_STRING([--enable-python-invocation],
      [Activate possibility to call python scripts externally by invoking a python interpreter (default: no)]),
    [abi_python_invocation_enable="${enableval}"; abi_python_invocation_init="yon"],
    [abi_python_invocation_enable="no"; abi_python_invocation_init="def"])
  AC_SUBST(enable_python_invocation)
  AC_SUBST(abi_python_invocation_enable)

  AC_ARG_ENABLE(source-debug,
    AS_HELP_STRING([--enable-source-debug],
      [Build debugging instructions present in the source code (default: no)]),
    [abi_source_debug_enable="${enableval}"; abi_source_debug_init="yon"],
    [abi_source_debug_enable="no"; abi_source_debug_init="def"])
  AC_SUBST(enable_source_debug)
  AC_SUBST(abi_source_debug_enable)

  AC_ARG_ENABLE(stdin,
    AS_HELP_STRING([--enable-stdin],
      [Tell ABINIT to read file lists from standard input (default: yes)]),
    [abi_stdin_enable="${enableval}"; abi_stdin_init="yon"],
    [abi_stdin_enable="yes"; abi_stdin_init="def"])
  AC_SUBST(enable_stdin)
  AC_SUBST(abi_stdin_enable)

  AC_ARG_ENABLE(timer,
    AS_HELP_STRING([--enable-timer],
      [Activate support for the internal ABINIT timer (default: yes)]),
    [abi_timer_enable="${enableval}"; abi_timer_init="yon"],
    [abi_timer_enable="yes"; abi_timer_init="def"])
  AC_SUBST(enable_timer)
  AC_SUBST(abi_timer_enable)

  AC_ARG_ENABLE(triqs-complex,
    AS_HELP_STRING([--enable-triqs-complex],
      [Activate support for complex version of TRIQS (default: no)]),
    [abi_triqs_complex_enable="${enableval}"; abi_triqs_complex_init="yon"],
    [abi_triqs_complex_enable="no"; abi_triqs_complex_init="def"])
  AC_SUBST(enable_triqs_complex)
  AC_SUBST(abi_triqs_complex_enable)

  AC_ARG_ENABLE(triqs-v1-4,
    AS_HELP_STRING([--enable-triqs-v1-4],
      [Activate internal support for TRIQS 1.4 (default: no)]),
    [abi_triqs_v1_4_enable="${enableval}"; abi_triqs_v1_4_init="yon"],
    [abi_triqs_v1_4_enable="no"; abi_triqs_v1_4_init="def"])
  AC_SUBST(enable_triqs_v1_4)
  AC_SUBST(abi_triqs_v1_4_enable)

  AC_ARG_ENABLE(triqs-v2-0,
    AS_HELP_STRING([--enable-triqs-v2-0],
      [Activate internal support for TRIQS 2.0 (This option is dominant over the others versions) (default: no)]),
    [abi_triqs_v2_0_enable="${enableval}"; abi_triqs_v2_0_init="yon"],
    [abi_triqs_v2_0_enable="no"; abi_triqs_v2_0_init="def"])
  AC_SUBST(enable_triqs_v2_0)
  AC_SUBST(abi_triqs_v2_0_enable)

  AC_ARG_ENABLE(zdot-bugfix,
    AS_HELP_STRING([--enable-zdot-bugfix],
      [Activate workaround for bugged ZDOTC and ZDOTU (default: auto)]),
    [abi_zdot_bugfix_enable="${enableval}"; abi_zdot_bugfix_init="yon"],
    [abi_zdot_bugfix_enable="auto"; abi_zdot_bugfix_init="def"])
  AC_SUBST(enable_zdot_bugfix)
  AC_SUBST(abi_zdot_bugfix_enable)

  #
  # --with arguments
  #

  AC_ARG_WITH(config_file,
    AS_HELP_STRING([--with-config-file],
      [Specify config file to read options from (default: '')]),
    [ abi_config_file="${withval}"
      case "${withval}" in
        no|yes)
          abi_config_file_init="yon"
          ;;
        *)
          abi_config_file_init="kwd"
          ;;
      esac],
    [ abi_config_file_init="def"; abi_config_file=""])
  AC_SUBST(with_config_file)

  AC_ARG_WITH(debug_flavor,
    AS_HELP_STRING([--with-debug-flavor],
      [Set debug level (default: 'basic')]),
    [ abi_debug_flavor="${withval}"
      case "${withval}" in
        no|yes)
          abi_debug_flavor_init="yon"
          ;;
        *)
          abi_debug_flavor_init="kwd"
          ;;
      esac],
    [ abi_debug_flavor_init="def"; abi_debug_flavor="basic"])
  AC_SUBST(with_debug_flavor)

  AC_ARG_WITH(fallbacks,
    AS_HELP_STRING([--with-fallbacks],
      [Installation prefix of the ABINIT Fallbacks (default: '')]),
    [ abi_fallbacks="${withval}"
      case "${withval}" in
        no|yes)
          abi_fallbacks_init="yon"
          ;;
        *)
          abi_fallbacks_init="dir"
          ;;
      esac],
    [ abi_fallbacks_init="def"; abi_fallbacks=""])
  AC_SUBST(with_fallbacks)

  AC_ARG_WITH(fc_vendor,
    AS_HELP_STRING([--with-fc-vendor],
      [Fortran compiler vendor to be used by the build system (default: '')]),
    [ abi_fc_vendor="${withval}"
      case "${withval}" in
        no|yes)
          abi_fc_vendor_init="yon"
          ;;
        *)
          abi_fc_vendor_init="kwd"
          ;;
      esac],
    [ abi_fc_vendor_init="def"; abi_fc_vendor=""])
  AC_SUBST(with_fc_vendor)

  AC_ARG_WITH(fc_version,
    AS_HELP_STRING([--with-fc-version],
      [Fortran compiler version to be used by the build system (default: '')]),
    [ abi_fc_version="${withval}"
      case "${withval}" in
        no|yes)
          abi_fc_version_init="yon"
          ;;
        *)
          abi_fc_version_init="kwd"
          ;;
      esac],
    [ abi_fc_version_init="def"; abi_fc_version=""])
  AC_SUBST(with_fc_version)

  AC_ARG_WITH(libxml2,
    AS_HELP_STRING([--with-libxml2],
      [Enable support for the C XML library (default: '')]),
    [ abi_libxml2="${withval}"
      case "${withval}" in
        no|yes)
          abi_libxml2_init="yon"
          ;;
        *)
          abi_libxml2_init="dir"
          ;;
      esac],
    [ abi_libxml2_init="def"; abi_libxml2=""])
  AC_SUBST(with_libxml2)

  AC_ARG_WITH(mpi_level,
    AS_HELP_STRING([--with-mpi-level],
      [level of the MPI standard to use (default: '2')]),
    [ abi_mpi_level="${withval}"
      case "${withval}" in
        no|yes)
          abi_mpi_level_init="yon"
          ;;
        *)
          abi_mpi_level_init="kwd"
          ;;
      esac],
    [ abi_mpi_level_init="def"; abi_mpi_level="2"])
  AC_SUBST(with_mpi_level)

  AC_ARG_WITH(optim_flavor,
    AS_HELP_STRING([--with-optim-flavor],
      [Set optimization level (default: 'standard')]),
    [ abi_optim_flavor="${withval}"
      case "${withval}" in
        no|yes)
          abi_optim_flavor_init="yon"
          ;;
        *)
          abi_optim_flavor_init="kwd"
          ;;
      esac],
    [ abi_optim_flavor_init="def"; abi_optim_flavor="standard"])
  AC_SUBST(with_optim_flavor)
]) # ABI_OPTIONS_DEFINE



# ABI_OPTIONS_SETUP()
# -------------------
#
# Sets the default values of command-line arguments.
#
AC_DEFUN([ABI_OPTIONS_SETUP],[

  #
  # --enable arguments
  #

  if test "${enable_avx_safe_mode}" = ""; then
    abi_avx_safe_mode_enable="no"
  fi
  if test "${enable_cclock}" = ""; then
    abi_cclock_enable="no"
  fi
  if test "${enable_crpa_optim}" = ""; then
    abi_crpa_optim_enable="no"
  fi
  if test "${enable_fc_wrapper}" = ""; then
    abi_fc_wrapper_enable="no"
  fi
  if test "${enable_gpu_nvidia_unified_memory}" = ""; then
    abi_gpu_nvidia_unified_memory_enable="no"
  fi
  if test "${enable_gw_dpc}" = ""; then
    abi_gw_dpc_enable="no"
  fi
  if test "${enable_hints}" = ""; then
    abi_hints_enable="yes"
  fi
  if test "${enable_libtetra}" = ""; then
    abi_libtetra_enable="yes"
  fi
  if test "${enable_lotf}" = ""; then
    abi_lotf_enable="no"
  fi
  if test "${enable_memory_profiling}" = ""; then
    abi_memory_profiling_enable="no"
  fi
  if test "${enable_mpi_gpu_aware}" = ""; then
    abi_mpi_gpu_aware_enable="no"
  fi
  if test "${enable_mpi_inplace}" = ""; then
    abi_mpi_inplace_enable="auto"
  fi
  if test "${enable_mpi_interfaces_bugfix}" = ""; then
    abi_mpi_interfaces_bugfix_enable="auto"
  fi
  if test "${enable_mpi_io}" = ""; then
    abi_mpi_io_enable="auto"
  fi
  if test "${enable_mpi_io_default}" = ""; then
    abi_mpi_io_default_enable="no"
  fi
  if test "${enable_netcdf_default}" = ""; then
    abi_netcdf_default_enable="no"
  fi
  if test "${enable_openmp}" = ""; then
    abi_openmp_enable="no"
  fi
  if test "${enable_openmp_offload}" = ""; then
    abi_openmp_offload_enable="no"
  fi
  if test "${enable_python_invocation}" = ""; then
    abi_python_invocation_enable="no"
  fi
  if test "${enable_source_debug}" = ""; then
    abi_source_debug_enable="no"
  fi
  if test "${enable_stdin}" = ""; then
    abi_stdin_enable="yes"
  fi
  if test "${enable_timer}" = ""; then
    abi_timer_enable="yes"
  fi
  if test "${enable_triqs_complex}" = ""; then
    abi_triqs_complex_enable="no"
  fi
  if test "${enable_triqs_v1_4}" = ""; then
    abi_triqs_v1_4_enable="no"
  fi
  if test "${enable_triqs_v2_0}" = ""; then
    abi_triqs_v2_0_enable="no"
  fi
  if test "${enable_zdot_bugfix}" = ""; then
    abi_zdot_bugfix_enable="auto"
  fi

  #
  # --with arguments
  #

  if test "${with_config_file}" = "no"; then
    abi_config_file=""
  fi
  if test "${with_debug_flavor}" = ""; then
    abi_debug_flavor="basic"
  fi
  if test "${with_debug_flavor}" = "no"; then
    abi_debug_flavor="none"
  fi
  if test "${with_fallbacks}" = "no"; then
    abi_fallbacks=""
  fi
  if test "${with_fc_vendor}" = "no"; then
    abi_fc_vendor="generic"
  fi
  if test "${with_fc_version}" = "no"; then
    abi_fc_version="0.0"
  fi
  if test "${with_libxml2}" = "no"; then
    abi_libxml2=""
  fi
  if test "${with_mpi_level}" = ""; then
    abi_mpi_level="2"
  fi
  if test "${with_mpi_level}" = "no"; then
    abi_mpi_level=""
  fi
  if test "${with_optim_flavor}" = ""; then
    abi_optim_flavor="standard"
  fi
  if test "${with_optim_flavor}" = "no"; then
    abi_optim_flavor="none"
  fi
]) # ABI_OPTIONS_SETUP



# ABI_OPTIONS_BACKUP()
# --------------------
#
# Saves all command-line arguments.
#
AC_DEFUN([ABI_OPTIONS_BACKUP],[

  #
  # --enable arguments
  #
  cmd_enable_avx_safe_mode="${enable_avx_safe_mode}"
  cmd_enable_cclock="${enable_cclock}"
  cmd_enable_crpa_optim="${enable_crpa_optim}"
  cmd_enable_fc_wrapper="${enable_fc_wrapper}"
  cmd_enable_gpu_nvidia_unified_memory="${enable_gpu_nvidia_unified_memory}"
  cmd_enable_gw_dpc="${enable_gw_dpc}"
  cmd_enable_hints="${enable_hints}"
  cmd_enable_libtetra="${enable_libtetra}"
  cmd_enable_lotf="${enable_lotf}"
  cmd_enable_memory_profiling="${enable_memory_profiling}"
  cmd_enable_mpi_gpu_aware="${enable_mpi_gpu_aware}"
  cmd_enable_mpi_inplace="${enable_mpi_inplace}"
  cmd_enable_mpi_interfaces_bugfix="${enable_mpi_interfaces_bugfix}"
  cmd_enable_mpi_io="${enable_mpi_io}"
  cmd_enable_mpi_io_default="${enable_mpi_io_default}"
  cmd_enable_netcdf_default="${enable_netcdf_default}"
  cmd_enable_openmp="${enable_openmp}"
  cmd_enable_openmp_offload="${enable_openmp_offload}"
  cmd_enable_python_invocation="${enable_python_invocation}"
  cmd_enable_source_debug="${enable_source_debug}"
  cmd_enable_stdin="${enable_stdin}"
  cmd_enable_timer="${enable_timer}"
  cmd_enable_triqs_complex="${enable_triqs_complex}"
  cmd_enable_triqs_v1_4="${enable_triqs_v1_4}"
  cmd_enable_triqs_v2_0="${enable_triqs_v2_0}"
  cmd_enable_zdot_bugfix="${enable_zdot_bugfix}"

  #
  # --with arguments
  #
  cmd_with_config_file="${with_config_file}"
  cmd_with_debug_flavor="${with_debug_flavor}"
  cmd_with_fallbacks="${with_fallbacks}"
  cmd_with_fc_vendor="${with_fc_vendor}"
  cmd_with_fc_version="${with_fc_version}"
  cmd_with_libxml2="${with_libxml2}"
  cmd_with_mpi_level="${with_mpi_level}"
  cmd_with_optim_flavor="${with_optim_flavor}"
  cmd_with_abinit_common="${with_abinit_common}"
  cmd_with_bigdft="${with_bigdft}"
  cmd_with_cuda="${with_cuda}"
  cmd_with_fft="${with_fft}"
  cmd_with_fft_flavor="${with_fft_flavor}"
  cmd_with_fftw3="${with_fftw3}"
  cmd_with_gpu="${with_gpu}"
  cmd_with_gpu_flavor="${with_gpu_flavor}"
  cmd_with_hdf5="${with_hdf5}"
  cmd_with_kokkos="${with_kokkos}"
  cmd_with_levmar="${with_levmar}"
  cmd_with_libpaw="${with_libpaw}"
  cmd_with_libpsml="${with_libpsml}"
  cmd_with_libxc="${with_libxc}"
  cmd_with_linalg="${with_linalg}"
  cmd_with_linalg_flavor="${with_linalg_flavor}"
  cmd_with_mpi="${with_mpi}"
  cmd_with_mpi_flavor="${with_mpi_flavor}"
  cmd_with_netcdf="${with_netcdf}"
  cmd_with_netcdf_fortran="${with_netcdf_fortran}"
  cmd_with_papi="${with_papi}"
  cmd_with_pfft="${with_pfft}"
  cmd_with_rocm="${with_rocm}"
  cmd_with_triqs="${with_triqs}"
  cmd_with_wannier90="${with_wannier90}"
  cmd_with_xmlf90="${with_xmlf90}"
  cmd_with_yakl="${with_yakl}"

  #
  # Prefix
  #
  if test "${prefix}" != "NONE"; then
    cmd_prefix="${prefix}"
  fi
]) # ABI_OPTIONS_BACKUP



# ABI_OPTIONS_CFG_TRANSFER()
# --------------------------
#
# Transfer options from the config file to internal variables.
#
AC_DEFUN([ABI_OPTIONS_CFG_TRANSFER],[

  #
  # --enable arguments
  #

  if test "${enable_avx_safe_mode}" != ""; then
    abi_avx_safe_mode_enable="${enable_avx_safe_mode}"
  fi

  if test "${enable_cclock}" != ""; then
    abi_cclock_enable="${enable_cclock}"
  fi

  if test "${enable_crpa_optim}" != ""; then
    abi_crpa_optim_enable="${enable_crpa_optim}"
  fi

  if test "${enable_fc_wrapper}" != ""; then
    abi_fc_wrapper_enable="${enable_fc_wrapper}"
  fi

  if test "${enable_gpu_nvidia_unified_memory}" != ""; then
    abi_gpu_nvidia_unified_memory_enable="${enable_gpu_nvidia_unified_memory}"
  fi

  if test "${enable_gw_dpc}" != ""; then
    abi_gw_dpc_enable="${enable_gw_dpc}"
  fi

  if test "${enable_hints}" != ""; then
    abi_hints_enable="${enable_hints}"
  fi

  if test "${enable_libtetra}" != ""; then
    abi_libtetra_enable="${enable_libtetra}"
  fi

  if test "${enable_lotf}" != ""; then
    abi_lotf_enable="${enable_lotf}"
  fi

  if test "${enable_memory_profiling}" != ""; then
    abi_memory_profiling_enable="${enable_memory_profiling}"
  fi

  if test "${enable_mpi_gpu_aware}" != ""; then
    abi_mpi_gpu_aware_enable="${enable_mpi_gpu_aware}"
  fi

  if test "${enable_mpi_inplace}" != ""; then
    abi_mpi_inplace_enable="${enable_mpi_inplace}"
  fi

  if test "${enable_mpi_interfaces_bugfix}" != ""; then
    abi_mpi_interfaces_bugfix_enable="${enable_mpi_interfaces_bugfix}"
  fi

  if test "${enable_mpi_io}" != ""; then
    abi_mpi_io_enable="${enable_mpi_io}"
  fi

  if test "${enable_mpi_io_default}" != ""; then
    abi_mpi_io_default_enable="${enable_mpi_io_default}"
  fi

  if test "${enable_netcdf_default}" != ""; then
    abi_netcdf_default_enable="${enable_netcdf_default}"
  fi

  if test "${enable_openmp}" != ""; then
    abi_openmp_enable="${enable_openmp}"
  fi

  if test "${enable_openmp_offload}" != ""; then
    abi_openmp_offload_enable="${enable_openmp_offload}"
  fi

  if test "${enable_python_invocation}" != ""; then
    abi_python_invocation_enable="${enable_python_invocation}"
  fi

  if test "${enable_source_debug}" != ""; then
    abi_source_debug_enable="${enable_source_debug}"
  fi

  if test "${enable_stdin}" != ""; then
    abi_stdin_enable="${enable_stdin}"
  fi

  if test "${enable_timer}" != ""; then
    abi_timer_enable="${enable_timer}"
  fi

  if test "${enable_triqs_complex}" != ""; then
    abi_triqs_complex_enable="${enable_triqs_complex}"
  fi

  if test "${enable_triqs_v1_4}" != ""; then
    abi_triqs_v1_4_enable="${enable_triqs_v1_4}"
  fi

  if test "${enable_triqs_v2_0}" != ""; then
    abi_triqs_v2_0_enable="${enable_triqs_v2_0}"
  fi

  if test "${enable_zdot_bugfix}" != ""; then
    abi_zdot_bugfix_enable="${enable_zdot_bugfix}"
  fi

  #
  # --with arguments
  #

  if test "${with_config_file}" != ""; then
    abi_config_file="${with_config_file}"
  fi

  if test "${with_debug_flavor}" != ""; then
    abi_debug_flavor="${with_debug_flavor}"
  fi

  if test "${with_fallbacks}" != ""; then
    abi_fallbacks="${with_fallbacks}"
  fi

  if test "${with_fc_vendor}" != ""; then
    abi_fc_vendor="${with_fc_vendor}"
  fi

  if test "${with_fc_version}" != ""; then
    abi_fc_version="${with_fc_version}"
  fi

  if test "${with_libxml2}" != ""; then
    abi_libxml2="${with_libxml2}"
  fi

  if test "${with_mpi_level}" != ""; then
    abi_mpi_level="${with_mpi_level}"
  fi

  if test "${with_optim_flavor}" != ""; then
    abi_optim_flavor="${with_optim_flavor}"
  fi

]) # ABI_OPTIONS_CFG_TRANSFER



# ABI_OPTIONS_RECALL()
# --------------------
#
# Restores all previously-saved command-line arguments.
#
AC_DEFUN([ABI_OPTIONS_RECALL],[

  #
  # --enable arguments
  #
  if test "${cmd_enable_avx_safe_mode}" != ""; then
    abi_avx_safe_mode_enable="${cmd_enable_avx_safe_mode}"
  fi
  if test "${cmd_enable_cclock}" != ""; then
    abi_cclock_enable="${cmd_enable_cclock}"
  fi
  if test "${cmd_enable_crpa_optim}" != ""; then
    abi_crpa_optim_enable="${cmd_enable_crpa_optim}"
  fi
  if test "${cmd_enable_fc_wrapper}" != ""; then
    abi_fc_wrapper_enable="${cmd_enable_fc_wrapper}"
  fi
  if test "${cmd_enable_gpu_nvidia_unified_memory}" != ""; then
    abi_gpu_nvidia_unified_memory_enable="${cmd_enable_gpu_nvidia_unified_memory}"
  fi
  if test "${cmd_enable_gw_dpc}" != ""; then
    abi_gw_dpc_enable="${cmd_enable_gw_dpc}"
  fi
  if test "${cmd_enable_hints}" != ""; then
    abi_hints_enable="${cmd_enable_hints}"
  fi
  if test "${cmd_enable_libtetra}" != ""; then
    abi_libtetra_enable="${cmd_enable_libtetra}"
  fi
  if test "${cmd_enable_lotf}" != ""; then
    abi_lotf_enable="${cmd_enable_lotf}"
  fi
  if test "${cmd_enable_memory_profiling}" != ""; then
    abi_memory_profiling_enable="${cmd_enable_memory_profiling}"
  fi
  if test "${cmd_enable_mpi_gpu_aware}" != ""; then
    abi_mpi_gpu_aware_enable="${cmd_enable_mpi_gpu_aware}"
  fi
  if test "${cmd_enable_mpi_inplace}" != ""; then
    abi_mpi_inplace_enable="${cmd_enable_mpi_inplace}"
  fi
  if test "${cmd_enable_mpi_interfaces_bugfix}" != ""; then
    abi_mpi_interfaces_bugfix_enable="${cmd_enable_mpi_interfaces_bugfix}"
  fi
  if test "${cmd_enable_mpi_io}" != ""; then
    abi_mpi_io_enable="${cmd_enable_mpi_io}"
  fi
  if test "${cmd_enable_mpi_io_default}" != ""; then
    abi_mpi_io_default_enable="${cmd_enable_mpi_io_default}"
  fi
  if test "${cmd_enable_netcdf_default}" != ""; then
    abi_netcdf_default_enable="${cmd_enable_netcdf_default}"
  fi
  if test "${cmd_enable_openmp}" != ""; then
    abi_openmp_enable="${cmd_enable_openmp}"
  fi
  if test "${cmd_enable_openmp_offload}" != ""; then
    abi_openmp_offload_enable="${cmd_enable_openmp_offload}"
  fi
  if test "${cmd_enable_python_invocation}" != ""; then
    abi_python_invocation_enable="${cmd_enable_python_invocation}"
  fi
  if test "${cmd_enable_source_debug}" != ""; then
    abi_source_debug_enable="${cmd_enable_source_debug}"
  fi
  if test "${cmd_enable_stdin}" != ""; then
    abi_stdin_enable="${cmd_enable_stdin}"
  fi
  if test "${cmd_enable_timer}" != ""; then
    abi_timer_enable="${cmd_enable_timer}"
  fi
  if test "${cmd_enable_triqs_complex}" != ""; then
    abi_triqs_complex_enable="${cmd_enable_triqs_complex}"
  fi
  if test "${cmd_enable_triqs_v1_4}" != ""; then
    abi_triqs_v1_4_enable="${cmd_enable_triqs_v1_4}"
  fi
  if test "${cmd_enable_triqs_v2_0}" != ""; then
    abi_triqs_v2_0_enable="${cmd_enable_triqs_v2_0}"
  fi
  if test "${cmd_enable_zdot_bugfix}" != ""; then
    abi_zdot_bugfix_enable="${cmd_enable_zdot_bugfix}"
  fi

  #
  # --with arguments
  #
  if test "${cmd_with_config_file}" != ""; then
    with_config_file="${cmd_with_config_file}"
  fi
  if test "${cmd_with_debug_flavor}" != ""; then
    with_debug_flavor="${cmd_with_debug_flavor}"
  fi
  if test "${cmd_with_fallbacks}" != ""; then
    with_fallbacks="${cmd_with_fallbacks}"
  fi
  if test "${cmd_with_fc_vendor}" != ""; then
    with_fc_vendor="${cmd_with_fc_vendor}"
  fi
  if test "${cmd_with_fc_version}" != ""; then
    with_fc_version="${cmd_with_fc_version}"
  fi
  if test "${cmd_with_libxml2}" != ""; then
    with_libxml2="${cmd_with_libxml2}"
  fi
  if test "${cmd_with_mpi_level}" != ""; then
    with_mpi_level="${cmd_with_mpi_level}"
  fi
  if test "${cmd_with_optim_flavor}" != ""; then
    with_optim_flavor="${cmd_with_optim_flavor}"
  fi
  if test "${cmd_with_abinit_common}" != ""; then
    with_abinit_common="${cmd_with_abinit_common}"
  fi
  if test "${cmd_with_bigdft}" != ""; then
    with_bigdft="${cmd_with_bigdft}"
  fi
  if test "${cmd_with_cuda}" != ""; then
    with_cuda="${cmd_with_cuda}"
  fi
  if test "${cmd_with_fft}" != ""; then
    with_fft="${cmd_with_fft}"
  fi
  if test "${cmd_with_fft_flavor}" != ""; then
    with_fft_flavor="${cmd_with_fft_flavor}"
  fi
  if test "${cmd_with_fftw3}" != ""; then
    with_fftw3="${cmd_with_fftw3}"
  fi
  if test "${cmd_with_gpu}" != ""; then
    with_gpu="${cmd_with_gpu}"
  fi
  if test "${cmd_with_gpu_flavor}" != ""; then
    with_gpu_flavor="${cmd_with_gpu_flavor}"
  fi
  if test "${cmd_with_hdf5}" != ""; then
    with_hdf5="${cmd_with_hdf5}"
  fi
  if test "${cmd_with_kokkos}" != ""; then
    with_kokkos="${cmd_with_kokkos}"
  fi
  if test "${cmd_with_levmar}" != ""; then
    with_levmar="${cmd_with_levmar}"
  fi
  if test "${cmd_with_libpaw}" != ""; then
    with_libpaw="${cmd_with_libpaw}"
  fi
  if test "${cmd_with_libpsml}" != ""; then
    with_libpsml="${cmd_with_libpsml}"
  fi
  if test "${cmd_with_libxc}" != ""; then
    with_libxc="${cmd_with_libxc}"
  fi
  if test "${cmd_with_linalg}" != ""; then
    with_linalg="${cmd_with_linalg}"
  fi
  if test "${cmd_with_linalg_flavor}" != ""; then
    with_linalg_flavor="${cmd_with_linalg_flavor}"
  fi
  if test "${cmd_with_mpi}" != ""; then
    with_mpi="${cmd_with_mpi}"
  fi
  if test "${cmd_with_mpi_flavor}" != ""; then
    with_mpi_flavor="${cmd_with_mpi_flavor}"
  fi
  if test "${cmd_with_netcdf}" != ""; then
    with_netcdf="${cmd_with_netcdf}"
  fi
  if test "${cmd_with_netcdf_fortran}" != ""; then
    with_netcdf_fortran="${cmd_with_netcdf_fortran}"
  fi
  if test "${cmd_with_papi}" != ""; then
    with_papi="${cmd_with_papi}"
  fi
  if test "${cmd_with_pfft}" != ""; then
    with_pfft="${cmd_with_pfft}"
  fi
  if test "${cmd_with_rocm}" != ""; then
    with_rocm="${cmd_with_rocm}"
  fi
  if test "${cmd_with_triqs}" != ""; then
    with_triqs="${cmd_with_triqs}"
  fi
  if test "${cmd_with_wannier90}" != ""; then
    with_wannier90="${cmd_with_wannier90}"
  fi
  if test "${cmd_with_xmlf90}" != ""; then
    with_xmlf90="${cmd_with_xmlf90}"
  fi
  if test "${cmd_with_yakl}" != ""; then
    with_yakl="${cmd_with_yakl}"
  fi

  #
  # Prefix
  #
  if test "${cmd_prefix}" != ""; then
    prefix="${cmd_prefix}"
  fi
]) # ABI_OPTIONS_RECALL



# ABI_INFO_OPTIONS_CHANGED()
# --------------------------
#
# Display changes of user interface between versions and warns about
# obsolete uses.
#
AC_DEFUN([ABI_INFO_OPTIONS_CHANGED],[
  AC_MSG_NOTICE([])
  AC_MSG_NOTICE([no change in user interface to report])
]) # ABI_INFO_OPTIONS_CHANGED



# ABI_OPTIONS_PARSE()
# -------------------
#
# Parses command-line arguments.
#
AC_DEFUN([ABI_OPTIONS_PARSE],[
  AC_REQUIRE([AC_PROG_EGREP])
  AC_MSG_NOTICE([parsing command-line options])

  # Parse enable_avx_safe_mode
  if test "${abi_avx_safe_mode_enable}" != ""; then
    for v in `echo "${abi_avx_safe_mode_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_avx_safe_mode = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_avx_safe_mode = ${v}])
    fi
  fi

  # Parse enable_cclock
  if test "${abi_cclock_enable}" != ""; then
    for v in `echo "${abi_cclock_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_cclock = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_cclock = ${v}])
    fi
  fi

  # Parse enable_crpa_optim
  if test "${abi_crpa_optim_enable}" != ""; then
    for v in `echo "${abi_crpa_optim_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_crpa_optim = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_crpa_optim = ${v}])
    fi
  fi

  # Parse enable_fc_wrapper
  if test "${abi_fc_wrapper_enable}" != ""; then
    for v in `echo "${abi_fc_wrapper_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_fc_wrapper = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_fc_wrapper = ${v}])
    fi
  fi

  # Parse enable_gpu_nvidia_unified_memory
  if test "${abi_gpu_nvidia_unified_memory_enable}" != ""; then
    for v in `echo "${abi_gpu_nvidia_unified_memory_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_gpu_nvidia_unified_memory = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_gpu_nvidia_unified_memory = ${v}])
    fi
  fi

  # Parse enable_gw_dpc
  if test "${abi_gw_dpc_enable}" != ""; then
    for v in `echo "${abi_gw_dpc_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_gw_dpc = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_gw_dpc = ${v}])
    fi
  fi

  # Parse enable_hints
  if test "${abi_hints_enable}" != ""; then
    for v in `echo "${abi_hints_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_hints = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_hints = ${v}])
    fi
  fi

  # Parse enable_libtetra
  if test "${abi_libtetra_enable}" != ""; then
    for v in `echo "${abi_libtetra_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_libtetra = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_libtetra = ${v}])
    fi
  fi

  # Parse enable_lotf
  if test "${abi_lotf_enable}" != ""; then
    for v in `echo "${abi_lotf_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_lotf = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_lotf = ${v}])
    fi
  fi

  # Parse enable_memory_profiling
  if test "${abi_memory_profiling_enable}" != ""; then
    for v in `echo "${abi_memory_profiling_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_memory_profiling = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_memory_profiling = ${v}])
    fi
  fi

  # Parse enable_mpi_gpu_aware
  if test "${abi_mpi_gpu_aware_enable}" != ""; then
    for v in `echo "${abi_mpi_gpu_aware_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_mpi_gpu_aware = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_mpi_gpu_aware = ${v}])
    fi
  fi

  # Parse enable_mpi_inplace
  if test "${abi_mpi_inplace_enable}" != ""; then
    for v in `echo "${abi_mpi_inplace_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes auto; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_mpi_inplace = (no|yes|auto)])
      AC_MSG_ERROR([invalid option: enable_mpi_inplace = ${v}])
    fi
  fi

  # Parse enable_mpi_interfaces_bugfix
  if test "${abi_mpi_interfaces_bugfix_enable}" != ""; then
    for v in `echo "${abi_mpi_interfaces_bugfix_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes auto; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_mpi_interfaces_bugfix = (no|yes|auto)])
      AC_MSG_ERROR([invalid option: enable_mpi_interfaces_bugfix = ${v}])
    fi
  fi

  # Parse enable_mpi_io
  if test "${abi_mpi_io_enable}" != ""; then
    for v in `echo "${abi_mpi_io_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes auto; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_mpi_io = (no|yes|auto)])
      AC_MSG_ERROR([invalid option: enable_mpi_io = ${v}])
    fi
  fi

  # Parse enable_mpi_io_default
  if test "${abi_mpi_io_default_enable}" != ""; then
    for v in `echo "${abi_mpi_io_default_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_mpi_io_default = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_mpi_io_default = ${v}])
    fi
  fi

  # Parse enable_netcdf_default
  if test "${abi_netcdf_default_enable}" != ""; then
    for v in `echo "${abi_netcdf_default_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_netcdf_default = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_netcdf_default = ${v}])
    fi
  fi

  # Parse enable_openmp
  if test "${abi_openmp_enable}" != ""; then
    for v in `echo "${abi_openmp_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_openmp = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_openmp = ${v}])
    fi
  fi

  # Parse enable_openmp_offload
  if test "${abi_openmp_offload_enable}" != ""; then
    for v in `echo "${abi_openmp_offload_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_openmp_offload = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_openmp_offload = ${v}])
    fi
  fi

  # Parse enable_python_invocation
  if test "${abi_python_invocation_enable}" != ""; then
    for v in `echo "${abi_python_invocation_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_python_invocation = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_python_invocation = ${v}])
    fi
  fi

  # Parse enable_source_debug
  if test "${abi_source_debug_enable}" != ""; then
    for v in `echo "${abi_source_debug_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_source_debug = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_source_debug = ${v}])
    fi
  fi

  # Parse enable_stdin
  if test "${abi_stdin_enable}" != ""; then
    for v in `echo "${abi_stdin_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_stdin = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_stdin = ${v}])
    fi
  fi

  # Parse enable_timer
  if test "${abi_timer_enable}" != ""; then
    for v in `echo "${abi_timer_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_timer = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_timer = ${v}])
    fi
  fi

  # Parse enable_triqs_complex
  if test "${abi_triqs_complex_enable}" != ""; then
    for v in `echo "${abi_triqs_complex_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_triqs_complex = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_triqs_complex = ${v}])
    fi
  fi

  # Parse enable_triqs_v1_4
  if test "${abi_triqs_v1_4_enable}" != ""; then
    for v in `echo "${abi_triqs_v1_4_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_triqs_v1_4 = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_triqs_v1_4 = ${v}])
    fi
  fi

  # Parse enable_triqs_v2_0
  if test "${abi_triqs_v2_0_enable}" != ""; then
    for v in `echo "${abi_triqs_v2_0_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_triqs_v2_0 = (no|yes)])
      AC_MSG_ERROR([invalid option: enable_triqs_v2_0 = ${v}])
    fi
  fi

  # Parse enable_zdot_bugfix
  if test "${abi_zdot_bugfix_enable}" != ""; then
    for v in `echo "${abi_zdot_bugfix_enable}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in no yes auto; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([enable_zdot_bugfix = (no|yes|auto)])
      AC_MSG_ERROR([invalid option: enable_zdot_bugfix = ${v}])
    fi
  fi

  # Parse with_debug_flavor
  if test "${abi_debug_flavor}" != ""; then
    for v in `echo "${abi_debug_flavor}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in none custom basic verbose enhanced paranoid naughty; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([with_debug_flavor = (none|custom|basic|verbose|enhanced|paranoid|naughty)])
      AC_MSG_ERROR([invalid option: with_debug_flavor = ${v}])
    fi
  fi

  # Parse with_fallbacks
 if test "${with_fallbacks}" != ""; then
    opt_ok="yes"
    if test "${with_fallbacks}" != "no" -a "${with_fallbacks}" != "yes"; then
      if test \! -d "${with_fallbacks}" -o \! -r "${with_fallbacks}"; then
        opt_ok="no"
        break
      fi
    fi
  fi

  # Parse with_libxml2
 if test "${with_libxml2}" != ""; then
    opt_ok="yes"
    if test "${with_libxml2}" != "no" -a "${with_libxml2}" != "yes"; then
      if test \! -d "${with_libxml2}" -o \! -r "${with_libxml2}"; then
        opt_ok="no"
        break
      fi
    fi
  fi

  # Parse with_mpi_level
  if test "${abi_mpi_level}" != ""; then
    for v in `echo "${abi_mpi_level}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in 2 3; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([with_mpi_level = (2|3)])
      AC_MSG_ERROR([invalid option: with_mpi_level = ${v}])
    fi
  fi

  # Parse with_optim_flavor
  if test "${abi_optim_flavor}" != ""; then
    for v in `echo "${abi_optim_flavor}" | sed -e 's/+/ /g'`; do
      opt_ok="no"
      for r in none custom safe standard aggressive; do
        if test "${v}" = "${r}";then
          opt_ok="yes"
          break
        fi
      done
      test "${opt_ok}" = "no" && break
    done
    if test "${opt_ok}" = "no"; then
      AC_MSG_WARN([with_optim_flavor = (none|custom|safe|standard|aggressive)])
      AC_MSG_ERROR([invalid option: with_optim_flavor = ${v}])
    fi
  fi

]) # ABI_OPTIONS_PARSE



# ABI_OPTIONS_CPP_DEFINES()
# -------------------------
#
# Set switches associated to 'enable_*' options (AC_DEFINE and
# AM_CONDTIONAL).
#
AC_DEFUN([ABI_OPTIONS_CPP_DEFINES],[
  AC_MSG_NOTICE([setting build switches associated to command-line options])


  # Triggers for enable_avx_safe_mode
  AC_MSG_CHECKING([whether to disable vectorization in problematic procedures])
  AC_MSG_RESULT([${abi_avx_safe_mode_enable}])

  if test "${abi_avx_safe_mode_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_AVX_SAFE_MODE' preprocessing macro])
    AC_DEFINE([HAVE_AVX_SAFE_MODE], 1,
      [Define to 1 if you want to disable vectorization in problematic procedures.])
  fi

  # Triggers for enable_crpa_optim
  AC_MSG_CHECKING([whether to enable optimize cRPA calculations for ifort <= 17.0])
  AC_MSG_RESULT([${abi_crpa_optim_enable}])

  if test "${abi_crpa_optim_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_CRPA_OPTIM' preprocessing macro])
    AC_DEFINE([HAVE_CRPA_OPTIM], 1,
      [Define to 1 if you want to enable optimize cRPA calculations for ifort <= 17.0.])
  fi

  # Triggers for enable_gw_dpc
  AC_MSG_CHECKING([whether to activate double-precision GW calculations])
  AC_MSG_RESULT([${abi_gw_dpc_enable}])

  if test "${abi_gw_dpc_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_GW_DPC' preprocessing macro])
    AC_DEFINE([HAVE_GW_DPC], 1,
      [Define to 1 if you want to activate double-precision GW calculations.])
  fi

  # Triggers for enable_libtetra
  AC_MSG_CHECKING([whether to activate internal support for libtetra(hedron) in ABINIT])
  AC_MSG_RESULT([${abi_libtetra_enable}])

  if test "${abi_libtetra_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_LIBTETRA_ABINIT' preprocessing macro])
    AC_DEFINE([HAVE_LIBTETRA_ABINIT], 1,
      [Define to 1 if you want to activate internal support for libtetra(hedron) in ABINIT.])
  fi

  # Triggers for enable_lotf
  AC_MSG_CHECKING([whether to activate LOTF functionality (UNMAINTAINED)])
  AC_MSG_RESULT([${abi_lotf_enable}])

  if test "${abi_lotf_enable}" = "yes"; then
    AC_MSG_NOTICE([triggering the 'DO_BUILD_65_LOTF_BASE' conditional])
  fi
  AM_CONDITIONAL([DO_BUILD_65_LOTF_BASE],[test "${abi_lotf_enable}" = "yes"])
  if test "${abi_lotf_enable}" = "yes"; then
    AC_MSG_NOTICE([triggering the 'DO_BUILD_68_LOTF' conditional])
  fi
  AM_CONDITIONAL([DO_BUILD_68_LOTF],[test "${abi_lotf_enable}" = "yes"])
  if test "${abi_lotf_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_LOTF' preprocessing macro])
    AC_DEFINE([HAVE_LOTF], 1,
      [Define to 1 if you want to activate LOTF functionality (UNMAINTAINED).])
  fi

  # Triggers for enable_memory_profiling
  AC_MSG_CHECKING([whether to enable memory profiling])
  AC_MSG_RESULT([${abi_memory_profiling_enable}])

  if test "${abi_memory_profiling_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_MEM_PROFILING' preprocessing macro])
    AC_DEFINE([HAVE_MEM_PROFILING], 1,
      [Define to 1 if you want to enable memory profiling.])
  fi

  # Triggers for enable_mpi_gpu_aware
  AC_MSG_CHECKING([whether to assume support for passing GPU buffers to MPI])
  AC_MSG_RESULT([${abi_mpi_gpu_aware_enable}])

  if test "${abi_mpi_gpu_aware_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_GPU_MPI' preprocessing macro])
    AC_DEFINE([HAVE_GPU_MPI], 1,
      [Define to 1 if you want to assume support for passing GPU buffers to MPI.])
  fi

  # Triggers for enable_mpi_inplace
  AC_MSG_CHECKING([whether to activate support for MPI_IN_PLACE])
  AC_MSG_RESULT([${abi_mpi_inplace_enable}])

  if test "${abi_mpi_inplace_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_MPI2_INPLACE' preprocessing macro])
    AC_DEFINE([HAVE_MPI2_INPLACE], 1,
      [Define to 1 if you want to activate support for MPI_IN_PLACE.])
  fi

  # Triggers for enable_mpi_interfaces_bugfix
  AC_MSG_CHECKING([whether to activate workaround for buggy MPI interfaces (not having interfaces for scalars)])
  AC_MSG_RESULT([${abi_mpi_interfaces_bugfix_enable}])

  if test "${abi_mpi_interfaces_bugfix_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_MPI_BUGGY_INTERFACES' preprocessing macro])
    AC_DEFINE([HAVE_MPI_BUGGY_INTERFACES], 1,
      [Define to 1 if you want to activate workaround for buggy MPI interfaces (not having interfaces for scalars).])
  fi

  # Triggers for enable_mpi_io_default
  AC_MSG_CHECKING([whether to use MPI I/O as default I/O library (maintainer-only option)])
  AC_MSG_RESULT([${abi_mpi_io_default_enable}])

  if test "${abi_mpi_io_default_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_MPI_IO_DEFAULT' preprocessing macro])
    AC_DEFINE([HAVE_MPI_IO_DEFAULT], 1,
      [Define to 1 if you want to use MPI I/O as default I/O library (maintainer-only option).])
  fi

  # Triggers for enable_netcdf_default
  AC_MSG_CHECKING([whether to use NetCDF as default I/O library (maintainer-only option)])
  AC_MSG_RESULT([${abi_netcdf_default_enable}])

  if test "${abi_netcdf_default_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_NETCDF_DEFAULT' preprocessing macro])
    AC_DEFINE([HAVE_NETCDF_DEFAULT], 1,
      [Define to 1 if you want to use NetCDF as default I/O library (maintainer-only option).])
  fi

  # Triggers for enable_openmp
  AC_MSG_CHECKING([whether to activate support for OpenMP])
  AC_MSG_RESULT([${abi_openmp_enable}])

  if test "${abi_openmp_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_OPENMP' preprocessing macro])
    AC_DEFINE([HAVE_OPENMP], 1,
      [Define to 1 if you want to activate support for OpenMP.])
  fi

  # Triggers for enable_openmp_offload
  AC_MSG_CHECKING([whether to activate support for OpenMP GPU offload capabilities])
  AC_MSG_RESULT([${abi_openmp_offload_enable}])

  if test "${abi_openmp_offload_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_OPENMP_OFFLOAD' preprocessing macro])
    AC_DEFINE([HAVE_OPENMP_OFFLOAD], 1,
      [Define to 1 if you want to activate support for OpenMP GPU offload capabilities.])
  fi
  if test "${abi_openmp_offload_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_OPENMP' preprocessing macro])
    AC_DEFINE([HAVE_OPENMP], 1,
      [Define to 1 if you want to activate support for OpenMP GPU offload capabilities.])
  fi

  # Triggers for enable_python_invocation
  AC_MSG_CHECKING([whether to activate possibility to call python scripts externally by invoking a python interpreter])
  AC_MSG_RESULT([${abi_python_invocation_enable}])

  if test "${abi_python_invocation_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_PYTHON_INVOCATION' preprocessing macro])
    AC_DEFINE([HAVE_PYTHON_INVOCATION], 1,
      [Define to 1 if you want to activate possibility to call python scripts externally by invoking a python interpreter.])
  fi

  # Triggers for enable_stdin
  AC_MSG_CHECKING([whether to tell ABINIT to read file lists from standard input])
  AC_MSG_RESULT([${abi_stdin_enable}])

  if test "${abi_stdin_enable}" = "no"; then
    AC_MSG_NOTICE([defining the 'READ_FROM_FILE' preprocessing macro])
    AC_DEFINE([READ_FROM_FILE], 1,
      [Define to 1 if you want to tell ABINIT to read file lists from standard input.])
  fi

  # Triggers for enable_triqs_complex
  AC_MSG_CHECKING([whether to activate support for complex version of TRIQS])
  AC_MSG_RESULT([${abi_triqs_complex_enable}])

  if test "${abi_triqs_complex_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_TRIQS_COMPLEX' preprocessing macro])
    AC_DEFINE([HAVE_TRIQS_COMPLEX], 1,
      [Define to 1 if you want to activate support for complex version of TRIQS.])
  fi
  if test "${abi_triqs_complex_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HYBRIDISATION_IS_COMPLEX' preprocessing macro])
    AC_DEFINE([HYBRIDISATION_IS_COMPLEX], 1,
      [Define to 1 if you want to activate support for complex version of TRIQS.])
  fi
  if test "${abi_triqs_complex_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'LOCAL_HAMILTONIAN_IS_COMPLEX' preprocessing macro])
    AC_DEFINE([LOCAL_HAMILTONIAN_IS_COMPLEX], 1,
      [Define to 1 if you want to activate support for complex version of TRIQS.])
  fi

  # Triggers for enable_triqs_v1_4
  AC_MSG_CHECKING([whether to activate internal support for TRIQS 1.4])
  AC_MSG_RESULT([${abi_triqs_v1_4_enable}])

  if test "${abi_triqs_v1_4_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_TRIQS_v1_4' preprocessing macro])
    AC_DEFINE([HAVE_TRIQS_v1_4], 1,
      [Define to 1 if you want to activate internal support for TRIQS 1.4.])
  fi

  # Triggers for enable_triqs_v2_0
  AC_MSG_CHECKING([whether to activate internal support for TRIQS 2.0 (This option is dominant over the others versions)])
  AC_MSG_RESULT([${abi_triqs_v2_0_enable}])

  if test "${abi_triqs_v2_0_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_TRIQS_v2_0' preprocessing macro])
    AC_DEFINE([HAVE_TRIQS_v2_0], 1,
      [Define to 1 if you want to activate internal support for TRIQS 2.0 (This option is dominant over the others versions).])
  fi

  # Triggers for enable_zdot_bugfix
  AC_MSG_CHECKING([whether to activate workaround for bugged ZDOTC and ZDOTU])
  AC_MSG_RESULT([${abi_zdot_bugfix_enable}])

  if test "${abi_zdot_bugfix_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_LINALG_ZDOTC_BUG' preprocessing macro])
    AC_DEFINE([HAVE_LINALG_ZDOTC_BUG], 1,
      [Define to 1 if you want to activate workaround for bugged ZDOTC and ZDOTU.])
  fi
  if test "${abi_zdot_bugfix_enable}" = "yes"; then
    AC_MSG_NOTICE([defining the 'HAVE_LINALG_ZDOTU_BUG' preprocessing macro])
    AC_DEFINE([HAVE_LINALG_ZDOTU_BUG], 1,
      [Define to 1 if you want to activate workaround for bugged ZDOTC and ZDOTU.])
  fi
]) # ABI_OPTIONS_CPP_DEFINES
