/* File:      ret_attv.P
** Author(s): Baoqiu Cui
** 
** $Id: ret_attv.P,v 1.6 2011-10-16 19:26:50 tswift Exp $
*/

:- import put_attr/3, get_attr/3 from machine.

/* uses get_calls, so abstraction changes results (as expected) */
:- set_prolog_flag(max_table_subgoal_size,20).

test :-
	test_get_calls,
	writeln('Passed ret_attv!').

% In this test, no attv interrupt is triggered.
% --------------------------------------------

%verify_attr(Var, Value) :-
%	write('  -- verify: '), writeln(Var-Value),
%	attv_unify(Var, Value).

:- table p/2.

p(X,Y) :-
	get_attr(Y, ret, VY),
	VY == v(1),
	X = 123,
	put_attr(Y, ret, v(2)).

test_get_calls :-
	put_attr(Y, ret, v(1)),
	p(_X, Y),
	fail.
test_get_calls :-
	get_calls(p(_X, _Y), Cs, Ret),
%	writeln(Ret),
	Ret = ret(_A, B),
	get_attr(B, ret, VB),
	writeln(VB),
	VB == v(1),
	get_returns(Cs, Ret),
%	 writeln(Ret),
	Ret = ret(A2, B2),
	A2 = 123,
	get_attr(B2, ret, VB2),
	writeln(VB2),
	VB2 == v(2).
