%feature("docstring") OT::TriangularFactory
"Triangular factory.

Notes
-----
The parameters are estimated by method of moments:

.. math::
    :nowrap:

    \\begin{eqnarray*}
      \\displaystyle\\Hat{a}_n=(1-\\mathrm{sign}(x_{(1,n)})/(2+n))x_{(1,n)}\\\\
      \\displaystyle\\Hat{b}_n=(1+\\mathrm{sign}(x_{(n,n)})/(2+n))x_{(n,n)}\\\\
      \\displaystyle\\Hat{m}_n=3\\bar{x}_n-\\Hat{a}_n-\\Hat{b}_n
    \\end{eqnarray*}

See also
--------
DistributionFactory, Triangular"

// ---------------------------------------------------------------------

%feature("docstring") OT::TriangularFactory::buildAsTriangular
"Estimate the distribution as native distribution.

**Available usages**:

    buildAsTriangular()

    buildAsTriangular(*sample*)

    buildAsTriangular(*param*)

Parameters
----------
sample : 2-d sequence of float
    Data.
param : sequence of float
    The parameters of the :class:`~openturns.Triangular`.

Returns
-------
dist : :class:`~openturns.Triangular`
    The estimated distribution as a Triangular.
    
    In the first usage, the default Triangular distribution is built."

