#ifndef __ETHERBADGE_H_
#define __ETHERBADGE_H_

#include "icsneo/device/device.h"
#include "icsneo/device/devicetype.h"
#include "icsneo/communication/packetizer.h"
#include "icsneo/communication/decoder.h"
#include "icsneo/platform/stm32.h"

namespace icsneo {

class EtherBADGE : public Device {
public:
	// Serial numbers start with EB
	static constexpr DeviceType::Enum DEVICE_TYPE = DeviceType::EtherBADGE;
	static constexpr const uint16_t PRODUCT_ID = 0x1107;
	static constexpr const char* SERIAL_START = "EB";

	static std::vector<std::shared_ptr<Device>> Find() {
		std::vector<std::shared_ptr<Device>> found;

		for(auto neodevice : STM32::FindByProduct(PRODUCT_ID))
			found.emplace_back(new EtherBADGE(neodevice));

		return found;
	}

	static const std::vector<Network>& GetSupportedNetworks() {
		static std::vector<Network> supportedNetworks = {
			Network::NetID::HSCAN,

			Network::NetID::LIN,
			
			Network::NetID::OP_Ethernet1
		};
		return supportedNetworks;
	}

	EtherBADGE(neodevice_t neodevice) : Device(neodevice) {
		getWritableNeoDevice().type = DEVICE_TYPE;
		productId = PRODUCT_ID;
		initialize<STM32>();
	}

protected:
	virtual void setupEncoder(Encoder& encoder) override {
		Device::setupEncoder(encoder);
		encoder.supportCANFD = true;
	}

	virtual void setupSupportedRXNetworks(std::vector<Network>& rxNetworks) override {
		for(auto& netid : GetSupportedNetworks())
			rxNetworks.emplace_back(netid);
	}

	// The supported TX networks are the same as the supported RX networks for this device
	virtual void setupSupportedTXNetworks(std::vector<Network>& txNetworks) override { setupSupportedRXNetworks(txNetworks); }
};

}

#endif