%feature("docstring") OT::TruncatedDistribution
"Truncated distribution.

Available constructors:
    TruncatedDistribution(*distribution, lowerBound, upperBound, threshold=0.5*)

    TruncatedDistribution(*distribution, bound, side=ot.TruncatedDistribution.LOWER, threshold=0.5*)

    TruncatedDistribution(*distribution, truncationInterval, threshold=0.5*)

Parameters
----------
distribution : :class:`~openturns.Distribution`
    The distribution to be truncated.
lowerBound, upperBound : float
    Define a new distribution range :math:`[lowerBound, upperBound]` with
    finite bounds. The upper bound must be strictly greater than the lower
    bound.
bound : float
    Scalar used when one of the bounds of the distribution is not finite.

    If *side = ot.TruncatedDistribution.LOWER*: the interval
    :math:`[bound, +\\infty)` is used to bound the distribution.

    If *side = ot.TruncatedDistribution.UPPER*: the interval
    :math:`(-\\infty, bound]` is used to bound the distribution.
side : int, optional
    Integer used when one of the bounds of the distribution is not finite.
    (Amongst ot.TruncatedDistribution.LOWER and ot.TruncatedDistribution.UPPER).
truncationInterval : :class:`~openturns.Interval`
    Define a new distribution range :math:`[lowerBound, upperBound]` with
    finite bounds.
threshold : float, :math:`\\tau \\in [0, 1]`
    This threshold is used when generating an evaluation of the distribution.
    We note :math:`F` the CDF of the non truncated distribution:

    If :math:`F(upperBound)-F(lowerBound)<\\tau`: a CDF inversion is performed.

    If :math:`F(upperBound)-F(lowerBound)>\\tau`: rejection.

Notes
-----
Assuming a random variable *X* is truncated with two bounds *a* and *b*,
its probability density function is defined as:

.. math::

      \\forall y \\in \\Rset, p_Y(y) =
      \\begin{array}{|ll}
        0 &  \\mbox{for } y \\geq b  \\mbox{ or }  y \\leq a\\\\
        \\displaystyle \\frac{1}{F_X(b) - F_X(a)}\\, p_X(y) & \\mbox{for } y\\in[a,b]
      \\end{array}

and its cumulative density function is defined as:

.. math::

    \\forall y \\in \\Rset, F_Y(y) = \\Prob{X<y\\, / \\, X\\in[a,b]} =
    \\begin{array}{|ll}
      1 & \\mbox{for } y \\geq b, \\\\
      0 & \\mbox{for } y \\leq a, \\\\
      \\displaystyle \\frac{F_X(y) - F_X(a)}{F_X(b) - F_X(a)} & \\mbox{for } y\\in[a,b]
    \\end{array}

Examples
--------
>>> import openturns as ot
>>> distribution = ot.TruncatedDistribution(ot.Normal(2.0, 1.5), 1.0, 4.0)

Draw a sample:

>>> sample = distribution.getSample(5)"

// ---------------------------------------------------------------------

%feature("docstring") OT::TruncatedDistribution::getDistribution
"Get the distribution.

Returns
-------
distribution : :class:`~openturns.Distribution`
    The distribution to be truncated."

// ---------------------------------------------------------------------

%feature("docstring") OT::TruncatedDistribution::setDistribution
"Set the distribution.

Parameters
----------
distribution : :class:`~openturns.Distribution`
    The distribution to be truncated."

// ---------------------------------------------------------------------

%feature("docstring") OT::TruncatedDistribution::setBounds
"Set the bounds.

Parameters
----------
bounds : :class:`~openturns.Interval`
    Truncation bounds."

// ---------------------------------------------------------------------

%feature("docstring") OT::TruncatedDistribution::getBounds
"Set the bounds.

Returns
-------
bounds : :class:`~openturns.Interval`
    Truncation bounds."

// ---------------------------------------------------------------------

%feature("docstring") OT::TruncatedDistribution::getThresholdRealization
"Get the threshold used when generating an evaluation of the distribution.

Returns
-------
threshold : float, :math:`\\tau \\in [0, 1]`
    This threshold is used when generating an evaluation of the distribution.
    We note :math:`F` the CDF of the non truncated distribution:

    If :math:`F(upperBound)-F(lowerBound)<\\tau`: a CDF inversion is performed.

    If :math:`F(upperBound)-F(lowerBound)>\\tau`: rejection."

// ---------------------------------------------------------------------

%feature("docstring") OT::TruncatedDistribution::setThresholdRealization
"Set the threshold used when generating an evaluation of the distribution.

Parameters
----------
threshold : float, :math:`\\tau \\in [0, 1]`
    This threshold is used when generating an evaluation of the distribution.
    We note :math:`F` the CDF of the non truncated distribution:

    If :math:`F(upperBound)-F(lowerBound)<\\tau`: a CDF inversion is performed.

    If :math:`F(upperBound)-F(lowerBound)>\\tau`: rejection."
