%feature("docstring") OT::LogUniformFactory
"Log Uniform factory.

Available constructor:
    LogUniformFactory()

The parameters are estimated by method of moments:

.. math::
    :nowrap:

    \\begin{eqnarray*}
      \\displaystyle\\Hat{a}_n=(1-1/(2+n))x_{(1,n)}\\\\
      \\displaystyle\\Hat{b}_n=(1+1/(2+n))x_{(n,n)}
    \\end{eqnarray*}

See also
--------
DistributionFactory, LogUniform"

// ---------------------------------------------------------------------

%define OT_DistributionFactory_buildAsLogUniform_doc
"Build the LogUniform distribution.

**Available usages**:

    buildAsLogUniform(*sample*)

    buildAsLogUniform(*param*)

Parameters
----------
sample : 2-d sequence of float
    Sample from which the distribution parameters are estimated.
param : Collection of :class:`~openturns.PointWithDescription`
    A vector of parameters of the distribution.

Returns
-------
dist : :class:`~openturns.LogUniform`
    The built distribution."
%enddef
%feature("docstring") OT::LogUniformFactory::buildAsLogUniform
OT_DistributionFactory_buildAsLogUniform_doc

