%feature("docstring") OT::Histogram
"Histogram distribution.

Available constructors:
    Histogram(*first, width, height*)

    Histogram(*ticks, frequencies*)

Parameters
----------
first : float
    Lower bound of the range.
width : positive sequence of float
    :math:`w_i` is the width of the class :math:`i` for :math:`1 \\leq i \\leq n`.
height : positive sequence of float
    :math:`h_i` is the density of the class :math:`i` for :math:`1 \\leq i \\leq n`.
    The :math:`h_i` are automatically normalized such that :math:`\\sum_{i=1}^n h_iw_i=1`.
ticks : increasing sequence of float
    :math:`t_0` is the lower bound of the first class and :math:`t_i` is the upper bound of the class :math:`i` for :math:`1 \\leq i \\leq n`
frequencies : positive sequence of float
    :math:`f_i` is the probability of the class :math:`i` for :math:`1 \\leq i \\leq n`.
    The :math:`f_i` are automatically normalized such that :math:`\\sum_{i=1}^n f_i=1`.

Notes
-----
Its probability density function is defined as:

.. math::

    f_X(x) = \\sum_{i=1}^{n}h_i\\;\\boldsymbol{1}_{[x_{i-1},x_i]}(x)

where the class :math:`i` is :math:`[x_{i-1},x_i]` and :math:`w_i = x_i - x_{i-1}`.
The values :math:`h_i` are such that :math:`\\sum_{i=1}^n h_iw_i=1`.
The relation between the two parameterizations are:

.. math::
    :nowrap:

    \\begin{eqnarray*}
        first & = & t_0 \\\\
        w_i & = & x_i - x_{i-1} \\\\
        h_i & = & f_i / w_i
    \\end{eqnarray*}

Its first moments are:

.. math::
    :nowrap:

    \\begin{eqnarray*}
        \\Expect{X} & = & \\frac{1}{2}
                         \\sum_{i=1}^n h_i\\,w_i (x_{i+1} + x_i)\\\\
        \\Var{X} & = & \\frac{1}{3}
                      \\sum_{i=1}^n h_i\\,w_i (x_{i+1}^2 + x_i\\,x_{i+1} + x_i^2)
    \\end{eqnarray*}

Examples
--------
Create a distribution:

>>> import openturns as ot
>>> l = [1.0, 0.7, 1.2, 0.9]
>>> h = [0.5, 1.5, 3.5, 2.5]
>>> distribution = ot.Histogram(-1.5, l, h)"

// ---------------------------------------------------------------------

%feature("docstring") OT::Histogram::getFirst
"Accessor to the distribution's lower bound.

Returns
-------
first : float
    Lower bound."

// ---------------------------------------------------------------------

%feature("docstring") OT::Histogram::getWidth
"Accessor to the width.

Returns
-------
width : :class:`~openturns.Point`
    The collection of :math:`\\ell_i`, the width of class `i`."
// ---------------------------------------------------------------------

%feature("docstring") OT::Histogram::getHeight
"Accessor to the height.

Returns
-------
height : :class:`~openturns.Point`
    The collection of :math:`h_i`, the height of class `i`."

// ---------------------------------------------------------------------

%feature("docstring") OT::Histogram::setFirst
"Accessor to the lower bound.

Parameters
----------
first : float
    Lower bound."

// ---------------------------------------------------------------------

%feature("docstring") OT::Histogram::setData
"Accessor to the widths and heights.

Parameters
----------
width : :class:`~openturns.Point`
    The collection of :math:`\\ell_i`, the width of class `i`.
height : :class:`~openturns.Point`
    The collection of :math:`h_i`, the height of class `i`."
