%feature("docstring") OT::GumbelFactory
"Gumbel factory.

The parameters are estimated by method of moments:

.. math::
    :nowrap:

    \\begin{eqnarray*}
      \\displaystyle\\Hat{\\beta} = \\frac{\\sqrt{6}}{\\pi}\\Hat{\\sigma}_x\\\\
      \\displaystyle\\Hat{\\gamma} = \\bar{x}_n - \\frac{\\gamma_e \\sqrt{6}}{\\pi}\\Hat{\\sigma}_x\\\\
    \\end{eqnarray*}

with :math:`\\gamma_e \\simeq 0.57721` as Euler's constant.

See also
--------
DistributionFactory, Gumbel"

// ---------------------------------------------------------------------

%define OT_DistributionFactory_buildAsGumbel_doc
"Build the Gumbel distribution.

**Available usages**:

    buildAsGumbel(*sample*)

    buildAsGumbel(*param*)

Parameters
----------
sample : 2-d sequence of float
    Sample from which the distribution parameters are estimated.
param : Collection of :class:`~openturns.PointWithDescription`
    A vector of parameters of the distribution.

Returns
-------
dist : :class:`~openturns.Gumbel`
    The built distribution."
%enddef
%feature("docstring") OT::GumbelFactory::buildAsGumbel
OT_DistributionFactory_buildAsGumbel_doc

