%feature("docstring") OT::GeneralizedExtremeValueFactory
"GeneralizedExtremeValue factory.


See also
--------
DistributionFactory, GeneralizedExtremeValue, FrechetFactory, GumbelFactory, WeibullMaxFactory"

// ---------------------------------------------------------------------

%feature("docstring") OT::GeneralizedExtremeValueFactory::build
"Estimate the distribution as a :class:`~openturns.Frechet`, :class:`~openturns.Gumbel` or :class:`~openturns.WeibullMax` distribution.

**Available usages**:

    build(*sample*)

    build(*param*)

Parameters
----------
sample : 2-d sequence of float
    The block maxima sample of dimension 1.
param : Collection of :class:`~openturns.PointWithDescription`
    A vector of parameters of the distribution.

Returns
-------
distribution : :class:`~openturns.GeneralizedExtremeValue`
    The estimated distribution.

Notes
-----
The strategy consists in fitting the three models :class:`~openturns.Frechet`, :class:`~openturns.Gumbel` and :class:`~openturns.WeibullMax` on the data. Then, the three models are classified with respect to the BIC criterion. The best one is returned."

// ----------------------------------------------------------------------------

%feature("docstring") OT::GeneralizedExtremeValueFactory::buildAsGeneralizedExtremeValue
"Estimate the distribution as a :class:`~openturns.Frechet`, :class:`~openturns.Gumbel` or :class:`~openturns.WeibullMax` distribution.

Same as :meth:`build`.
"

// ----------------------------------------------------------------------------

%feature("docstring") OT::GeneralizedExtremeValueFactory::buildMethodOfProfileLikelihoodMaximization
"Estimate the distribution with the profile likelihood.


The estimator :math:`(\\hat{\\mu}, \\hat{\\sigma}, \\hat{\\xi})` is defined using a nested numerical optimization of the log-likelihood:

.. math::

    \\ell_p (\\xi) = \\max_{(\\mu, \\sigma)} \\ell (\\mu, \\sigma, \\xi)

where :math:`\\ell (\\mu, \\sigma, \\xi)` is detailed in equations :eq:`llR1` and :eq:`llR2` with :math:`r=1`.

The estimator  is given by:

.. math::
    :nowrap:

    \\begin{align*}
    \\hat{\\xi} & =  \\argmax_{\\xi} \\ell_p(\\xi)\\\\
    (\\hat{\\mu}, \\hat{\\sigma}) & =  \\argmax_{(\\mu, \\sigma)} \\ell(\\mu, \\sigma, \\hat{\\xi})
    \\end{align*}
    
Parameters
----------
sample : 2-d sequence of float
    The block maxima sample of dimension 1.

Returns
-------
distribution : :class:`~openturns.GeneralizedExtremeValue`
    The estimated distribution.

Notes
-----
The starting point of the optimization is initialized from the probability weighted moments method, see [diebolt2008]_."

// ----------------------------------------------------------------------------

%feature("docstring") OT::GeneralizedExtremeValueFactory::buildMethodOfProfileLikelihoodMaximizationEstimator
"Estimate the distribution and the parameter distribution with the profile likelihood.


The estimators are defined in :meth:`buildMethodOfProfileLikelihoodMaximization`.

The result class produced by the method provides:

- the GEV distribution associated to :math:`(\\hat{\\mu}, \\hat{\\sigma}, \\hat{\\xi})`,
- the asymptotic distribution of :math:`(\\hat{\\mu}, \\hat{\\sigma}, \\hat{\\xi})`,
- the profile log-likelihood function :math:`\\xi \\mapsto \\ell_p(\\xi)`,
- the optimal profile log-likelihood value :math:`\\ell_p(\\hat{\\xi})`,
- confidence intervals of level :math:`(1-\\alpha)` of :math:`\\xi`.

Parameters
----------
sample : 2-d sequence of float
    The block maxima sample of dimension 1.

Returns
-------
result : :class:`~openturns.ProfileLikelihoodResult`
    The result class."

// ----------------------------------------------------------------------------

%feature("docstring") OT::GeneralizedExtremeValueFactory::buildMethodOfLikelihoodMaximization
"Estimate the distribution from the :math:`r` largest order statistics.

Let us suppose we have a series of independent and identically distributed variables and that data are grouped
into :math:`n` blocks. In each block, the largest :math:`R` observations are recorded.

We define the series
:math:`M_i^{(R)} = (z_i^{(1)}, \\hdots, z_i^{(R)})` for :math:`1 \\leq i \\leq n` where the values are sorted
in decreasing order.

The estimator of :math:`(\\mu, \\sigma, \\xi)` maximizes  the log-likelihood built from the :math:`r` largest order statisctics, with :math:`1 \\leq r \\leq R` defined as:

If :math:`\\xi \\neq 0`, then:

.. math::
    :label: llR1

    \\ell(\\mu, \\sigma, \\xi) = -nr \\log \\sigma - \\sum_{i=1}^n   \\biggl[ 1 + \\xi \\Bigl( \\frac{z_i^{(r)} - \\mu }{\\sigma} \\Bigr) \\biggr]^{-1/\\xi}  -\\left(\\dfrac{1}{\\xi} +1 \\right)  \\sum_{i=1}^n \\sum_{k=1}^r  \\log \\biggl[ 1 + \\xi \\Bigl( \\frac{z_i^{(k)} - \\mu }{\\sigma} \\Bigr) \\biggr] 


defined on :math:`(\\mu, \\sigma, \\xi)` such that :math:`1+\\xi \\left( \\frac{z_i^{(k)} - \\mu}{\\sigma} \\right) > 0` for all :math:`1 \\leq i \\leq m` and :math:`1 \\leq k \\leq r`.

If :math:`\\xi = 0`, then:

.. math::
    :label: llR2

    \\ell(\\mu, \\sigma, \\xi) = -nr \\log \\sigma - \\sum_{i=1}^n   \\exp \\biggl[ - \\Bigl( \\frac{z_i^{(r)} - \\mu }{\\sigma} \\Bigr) \\biggr] - \\sum_{i=1}^n \\sum_{k=1}^r  \\Bigl( \\frac{z_i^{(k)} - \\mu }{\\sigma} \\Bigr) 



Parameters
----------
sample : 2-d sequence of float
    Block maxima grouped in a sample of size :math:`n` and dimension :math:`R`.
r : int, :math:`1 \\leq r \\leq R`, 
    Number of largest order statistics taken into account among the :math:`R` stored ones.
    
    By default, :math:`r=0` which means that all the maxima are used.
    
    

Returns
-------
distribution : :class:`~openturns.GeneralizedExtremeValue`
    The estimated distribution."

// ----------------------------------------------------------------------------

%feature("docstring") OT::GeneralizedExtremeValueFactory::buildMethodOfLikelihoodMaximizationEstimator
"Estimate the distribution and the parameter distribution with the R-maxima method.

The estimators are defined using the profile log-likelihood  as detailed in
:meth:`buildMethodOfLikelihoodMaximization`.

The result class produced by the method provides:

- the GEV distribution associated to :math:`(\\hat{\\mu}, \\hat{\\sigma}, \\hat{\\xi})`,
- the asymptotic distribution of :math:`(\\hat{\\mu}, \\hat{\\sigma}, \\hat{\\xi})`.

Parameters
----------
sampleM : 2-d sequence of float
    Block maxima  grouped in a sample of size :math:`n` and dimension :math:`R`.
r : int, :math:`1 \\leq r \\leq R`, optional
    Number of order statistics taken into account among the :math:`R` stored ones.
    
    By default, :math:`r=0` which means that all the maxima are used.

Returns
-------
result : :class:`~openturns.DistributionFactoryLikelihoodResult`
    The result class."

// ----------------------------------------------------------------------------

%feature("docstring") OT::GeneralizedExtremeValueFactory::buildTimeVarying
"Estimate a non stationary GEV.

We consider a non stationary GEV model to describe the distribution of :math:`Z_t`:

.. math::

    Z_t \\sim \\mbox{GEV}(\\mu(t), \\sigma(t), \\xi(t))

We have the values of :math:`Z_t` on the time stamps :math:`(t_1, \\dots, t_n)`.

For numerical reasons, it is recommended to normalize the time stamps. OpenTURNS applies the following mapping:

.. math::

    \\tau(t) = \\dfrac{t-c}{d}

and with three ways of defining :math:`(c,d)`:

- the *CenterReduce* method where :math:`c = \\dfrac{1}{n} \\sum_{i=1}^n t_i` is the mean time stamps
  and :math:`d = \\sqrt{\\dfrac{1}{n} \\sum_{i=1}^n (t_i-c)^2}` is the standard deviation of the time stamps;
- the *MinMax* method where :math:`c = t_1` is the first time and :math:`d = t_n-t_1` the range of the time stamps;
- the *None* method where :math:`c = 0` and :math:`d = 1`: in that case, data are not normalized.


Each of :math:`\\mu(t), \\sigma(t), \\xi(t)`  has an expression in terms of a parameter vector and time functions:

.. math::

    \\theta(t)  = h\\left(\\sum_{i=1}^{d_{\\theta}} \\beta_i^{\\theta} \\varphi_i^{\\theta}(\\tau(t))\\right)

where:

- :math:`h: \\Rset \\mapsto \\Rset` is usually referred to as the *inverse-link function*. The function :math:`\\theta(t)` denotes
  either :math:`\\mu(t)`, :math:`\\sigma(t)` or :math:`\\xi(t)`,
- each :math:`\\varphi_i^{\\theta}` is a scalar function :math:`\\Rset \\mapsto \\Rset`,
- each :math:`\\beta_i^{j} \\in \\Rset`.


We denote by :math:`d_{\\mu}`, :math:`d_{\\sigma}` and :math:`d_{\\xi}` the size of the functional basis of
:math:`\\mu`, :math:`\\sigma` and :math:`\\xi` respectively. We denote by
:math:`\\vect{\\beta} = (\\beta_1^{\\mu}, \\dots, \\beta_{d_{\\mu}}^{\\mu}, \\beta_1^{\\sigma}, \\dots, \\beta_{d_{\\sigma}}^{\\sigma}, \\beta_1^{\\xi}, \\dots, \\beta_{d_{\\xi}}^{\\xi})`
the complete vector of parameters.

The estimator of  :math:`\\vect{\\beta}` maximizes  the likelihood of the non stationary model which is defined by:

.. math::

    L(\\vect{\\beta}) = \\prod_{t=1}^{n} g(z_{t};\\mu(t), \\sigma(t), \\xi(t))

where :math:`g(z_{t};\\mu(t), \\sigma(t), \\xi(t))` denotes the GEV density function with parameters
:math:`\\mu(t), \\sigma(t), \\xi(t)` evaluated at :math:`z_t`.

Then, if none of the :math:`\\xi(t)` is zero, the log-likelihood is defined by:

.. math::

    \\ell (\\vect{\\beta}) = -\\sum_{t=1}^{n} \\left\\{ \\log(\\sigma(t)) + (1 + 1 / \\xi(t) ) \\log\\left[ 1+\\xi(t) \\left( \\frac{z_t - \\mu(t)}{\\sigma(t)}\\right) \\right] + \\left[ 1 + \\xi(t) \\left( \\frac{z_t- \\mu(t)}{\\sigma(t)} \\right) \\right]^{-1 / \\xi(t)} \\right\\}

defined on :math:`(\\mu, \\sigma, \\xi)` such that :math:`1+\\xi \\left( \\frac{z_t - \\mu}{\\sigma} \\right) > 0`
for all :math:`t`.

And if any of the :math:`\\xi(t)` is equal to 0, the log-likelihood is defined as:

.. math::

    \\ell (\\vect{\\beta}) = -\\sum_{t=1}^{n} \\left\\{ \\log(\\sigma(t)) + \\frac{z_t - \\mu(t)}{\\sigma(t)} + \\exp \\left\\{ - \\frac{z_t - \\mu(t)}{\\sigma(t)} \\right\\} \\right\\}

The initialization of the optimization problem is crucial. OpenTURNS proposes two initial points :math:`(\\mu_0, \\sigma_0, \\xi_0)`:

- the *Gumbel* initial point: in that case, we assume that the GEV is a stationary Gumbel distribution and we deduce 
  :math:`(\\mu_0, \\sigma_0)` from the mean :math:`\\hat{M}` and standard variation :math:`\\hat{\\sigma}` of the data:
  :math:`\\sigma_0 = \\dfrac{\\sqrt{6}}{\\pi} \\hat{\\sigma}` and :math:`\\mu_0 = \\hat{M} - \\gamma \\sigma_0` where
  :math:`\\gamma` is Euler's constant;
- the *Static* initial point: in that case, we assume that the GEV is stationary and :math:`(\\mu_0, \\sigma_0, \\xi_0)`
  is the maximum likelihood estimate resulting from that assumption.


The result class produced by the method provides:

- the estimator :math:`\\hat{\\vect{\\beta}}`,
- the asymptotic distribution of :math:`\\hat{\\vect{\\beta}}`,
- the parameter functions :math:`t \\mapsto \\vect{\\theta}(t)`,
- the normalizing function :math:`t \\mapsto \\tau(t)`,
- the optimal log-likelihood value :math:`\\hat{\\vect{\\beta}}`,
- the GEV distribution at time :math:`t`,
- the quantile functions of order :math:`p`:  :math:`t \\mapsto q_p(\\mbox{GEV}(\\hat{\\mu}(t), \\hat{\\sigma}(t), \\hat{\\xi}(t))`.


Parameters
----------
sample : 2-d sequence of float
    The block maxima grouped in a sample of size :math:`m` and one dimension.
timeStamps : 2-d sequence of float
    Values of :math:`t`.
basisCollection : sequence of class:`~openturns.Basis`
    Collection of three functional basis respectively for :math:`\\mu(t)`, :math:`\\sigma(t)` and :math:`\\xi(t)`.
inverseLinkFunction : :class:`~openturns.Function`, optional
    The :math:`h` function.
initializationMethod : str, optional
    The initialization method for the optimization problem: *Gumbel* or *Static*.

    By default, the *Gumbel* initial point is used.
normalizationMethod : str, optional
    The data normalization method: *CenterReduce*, *MinMax* or *None*.

    By default, the *MinMax* method is used.

Returns
-------
result : :class:`~openturns.TimeVaryingResult`
    The result class."

// ----------------------------------------------------------------------------

%feature("docstring") OT::GeneralizedExtremeValueFactory::buildReturnLevelEstimator
"Estimate a return level and its distribution from the GEV parameters.

The :math:`m`-return level :math:`z_m` is the level exceeded on average once every :math:`m` blocks. The parameter :math:`m` is referred to as the *return period*. For example, if the GEV distribution is the distribution of the annual maxima, then :math:`z_{100}` is the 100-year return period and is exceeded on average once in every century.

The  :math:`m`-return level is defined as the quantile of order :math:`1-p=1-1/m` of the GEV distribution.


If :math:`\\xi \\neq 0`:

.. math::
    :label: zm1

    z_m = \\mu - \\frac{\\sigma}{\\xi} \\left[ 1- (-\\log(1-p))^{-\\xi}\\right]

If :math:`\\xi = 0`:

.. math::
    :label: zm2

    z_m = \\mu - \\sigma \\log(-\\log(1-p))

The estimator :math:`\\hat{z}_m` of :math:`z_m` is deduced from the estimator :math:`(\\hat{\\mu}, \\hat{\\sigma}, \\hat{\\xi})` of :math:`(\\mu, \\sigma, \\xi)`. 

The asymptotic distribution of :math:`\\hat{z_m}` is obtained by the Delta method from the asymptotic distribution of
:math:`(\\hat{\\mu}, \\hat{\\sigma}, \\hat{\\xi})`. It is a normal distribution with mean :math:`\\hat{z}_m` and variance:

.. math::

    \\Var{z_m} = (\\nabla z_m)^T \\mat{V}_n \\nabla z_m

where :math:`\\nabla z_m = (\\frac{\\partial z_m}{\\partial \\mu}, \\frac{\\partial z_m}{\\partial \\sigma}, \\frac{\\partial z_m}{\\partial \\xi})` and :math:`\\mat{V}_n` is the asymptotic covariance of :math:`(\\hat{\\mu}, \\hat{\\sigma}, \\hat{\\xi})`.
    
Parameters
----------
result : :class:`~openturns.DistributionFactoryResult`
    Likelihood estimation result of a :class:`~openturns.GeneralizedExtremeValue`
m : float
    The return period expressed in terms of number of blocks.

Returns
-------
distribution : :class:`~openturns.Distribution`
    The asymptotic distribution of :math:`\\hat{z}_m`."

// ----------------------------------------------------------------------------

%feature("docstring") OT::GeneralizedExtremeValueFactory::buildReturnLevelProfileLikelihoodEstimator
"Estimate :math:`(z_m, \\sigma, \\xi)` and its distribution with the profile likelihood.


The estimators are defined in :meth:`buildReturnLevelProfileLikelihood`.

The parameter estimates  are given by:

.. math::
    :nowrap:

    \\begin{align*}
    \\hat{z}_m = \\argmax_{z_m} \\ell_p(z_m)\\\\
    (\\hat{\\sigma}, \\hat{\\xi}) = \\argmax_{(\\sigma, \\xi)} \\ell(\\hat{z}_m, \\sigma, \\xi)
    \\end{align*}

The result class produced by the method provides:

- the GEV distribution associated to :math:`(\\hat{z}_m, \\hat{\\sigma}, \\hat{\\xi})`,
- the asymptotic distribution of :math:`(\\hat{z}_m, \\hat{\\sigma}, \\hat{\\xi})`,
- the profile log-likelihood function :math:`z_m \\mapsto \\ell_p(z_m)`,
- the optimal profile log-likelihood value :math:`\\ell_p(\\hat{z}_m)`,
- confidence intervals of level :math:`(1-\\alpha)` of :math:`\\hat{z}_m`.

Parameters
----------
sample : 2-d sequence of float
    The block maxima sample of dimension 1.
m : float
    The return period, defines the level of the quantile as :math:`1-1/m`.
    
Returns
-------
result : :class:`~openturns.ProfileLikelihoodResult`
    The result class."

// ----------------------------------------------------------------------------

%feature("docstring") OT::GeneralizedExtremeValueFactory::buildReturnLevelProfileLikelihood
"Estimate a return level and its distribution with the profile likelihood.

The estimator is defined using a nested numerical optimization of the log-likelihood:

.. math::

    \\ell_p (z_m) = \\max_{(\\mu, \\sigma)} \\ell (z_m, \\sigma, \\xi)

where :math:`\\ell (z_m, \\sigma, \\xi)` is the log-likelihood detailed in :eq:`llR1` and :eq:`llR2` with :math:`r=1` and where we substitued
:math:`\\mu` for :math:`z_m` using equations :eq:`zm1` or :eq:`zm2`.

The estimator :math:`\\hat{z}_m` of :math:`z_m` is defined by:

.. math::
    
    \\hat{z}_m = \\argmax_{z_m} \\ell_p(z_m)
    
The asymptotic distribution of :math:`\\hat{z}_m` is normal.

Parameters
----------
sample : 2-d sequence of float
    The block maxima sample of dimension 1.

Returns
-------
distribution : :class:`~openturns.Normal`
    The asymptotic distribution of :math:`\\hat{z}_m`.

Notes
-----
The starting point of the optimization is initialized from the regular maximum likelihood method."
