%feature("docstring") OT::FarlieGumbelMorgensternCopula
"FarlieGumbelMorgenstern copula.

Parameters
----------
theta : float
    Parameter :math:`\\theta`, :math:`-1 \\leq \\theta \\leq 1`. Default is :math:`\\theta=0.5`.

Notes
-----
The FarlieGumbelMorgenstern copula is defined by:

.. math::

    C(u_1, u_2) = u_1 u_2 (1 + \\theta (1 - u_1)(1 - u_2))

for :math:`(u_1, u_2) \\in [0, 1]^2`

See also
--------
Distribution

Examples
--------
Create a distribution:

>>> import openturns as ot
>>> copula = ot.FarlieGumbelMorgensternCopula(0.7)

Draw a sample:

>>> sample = copula.getSample(5)"
