%feature("docstring") OT::ExponentialFactory
"Exponential factory.

Available constructor:
    ExponentialFactory()

The parameters are estimated by method of moments:

.. math::
    :nowrap:

    \\begin{eqnarray*}
      \\displaystyle \\Hat{\\gamma}_n = x_{(1,n)} - \\frac{|x_{(1,n)}|}{2+n}\\\\
      \\displaystyle \\Hat{\\lambda}_n= \\frac{1}{\\bar{x}_n-\\Hat{\\gamma}_n}
    \\end{eqnarray*}

See also
--------
DistributionFactory, Exponential"

// ---------------------------------------------------------------------

%define OT_DistributionFactory_buildAsExponential_doc
"Build the Exponential distribution.

**Available usages**:

    buildAsExponential(*sample*)

    buildAsExponential(*param*)

Parameters
----------
sample : 2-d sequence of float
    Sample from which the distribution parameters are estimated.
param : Collection of :class:`~openturns.PointWithDescription`
    A vector of parameters of the distribution.

Returns
-------
dist : :class:`~openturns.Exponential`
    The built distribution."
%enddef
%feature("docstring") OT::ExponentialFactory::buildAsExponential
OT_DistributionFactory_buildAsExponential_doc

