%feature("docstring") OT::ChiFactory
"Chi factory.

Available constructor:
    ChiFactory()

The parameters are estimated by method of moments:

.. math::
    :nowrap:

    \\begin{eqnarray*}
      \\displaystyle \\Hat{\\nu}_n=\\bar{x^2}_n
    \\end{eqnarray*}

See also
--------
DistributionFactory, Chi"

// ---------------------------------------------------------------------

%define OT_DistributionFactory_buildAsChi_doc
"Build the Chi distribution.

**Available usages**:

    buildAsChi(*sample*)

    buildAsChi(*param*)

Parameters
----------
sample : 2-d sequence of float
    Sample from which the distribution parameters are estimated.
param : Collection of :class:`~openturns.PointWithDescription`
    A vector of parameters of the distribution.

Returns
-------
dist : :class:`~openturns.Chi`
    The built distribution."
%enddef
%feature("docstring") OT::ChiFactory::buildAsChi
OT_DistributionFactory_buildAsChi_doc

