%feature("docstring") OT::BinomialFactory
"Binomial factory.

Available constructor:
    BinomialFactory()

Notes
-----
The estimation is done by maximizing the likelihood of the sample.

| We initialize the value of :math:`(n,p_n)` to
  :math:`\\displaystyle\\left(\\left\\lceil\\frac{\\Hat{x}_n^2}{\\Hat{x}_n-\\Hat{\\sigma}_n^2}\\right\\rceil, \\frac{\\Hat{x}_n}{n}\\right)`
  where :math:`\\Hat{x}_n` is the empirical mean of the sample
  :math:`(x_1, \\hdots, x_n)`, and :math:`\\Hat{\\sigma}_n^2` its unbiaised
  empirical variance.
| Then, we evaluate the likelihood of the sample with respect to the
  Binomial distribution parameterized with
  :math:`\\displaystyle\\left(\\left\\lceil\\frac{\\Hat{x}_n^2}{\\Hat{x}_n-\\Hat{\\sigma}_n^2}\\right\\rceil, \\frac{\\Hat{x}_n}{n}\\right)`.
  By testing successively :math:`n+1` and :math:`n-1` instead of
  :math:`n`, we determine the variation of the likelihood of the sample
  with respect to the Binomial distribution parameterized with
  :math:`(n+1,p_{n+1})` and :math:`(n-1,p_{n-1})`. We then iterate in
  the direction that makes the likelihood decrease, until the likelihood
  stops decreasing. The last couple is the one selected.

See also
--------
DistributionFactory, Binomial"
