%feature("docstring") OT::BetaMuSigma
"Beta distribution parameters.

Parameters
----------
mu : float
    Mean.
sigma : float
    Standard deviation :math:`\\sigma > 0`.
a : float
    Lower bound.
b : float, :math:`b > a`
    Upper bound.

Notes
-----
The native parameters  :math:`(\\alpha, \\beta, a, b)` are defined as follows:

.. math::
    :nowrap:

    \\begin{eqnarray*}
        \\alpha & = & \\left(\\dfrac{\\mu-a}{b-a}\\right) \\left( \\dfrac{(b-\\mu)(\\mu-a)}{\\sigma^2}-1\\right) \\\\
        \\beta & = &  \\left( \\dfrac{b-\\mu}{\\mu-a}\\right) \\alpha
    \\end{eqnarray*}

See also
--------
Beta

Examples
--------
Create the parameters  :math:`(\\mu, \\sigma, a, b)` of the Beta distribution:

>>> import openturns as ot
>>> parameters = ot.BetaMuSigma(0.2, 0.6, -1, 2)

Convert parameters into the native parameters :math:`(\\alpha, \\beta, a, b)`:

>>> print(parameters.evaluate())
[2,3,-1,2]"
