%feature("docstring") OT::Arcsine
"Arcsine distribution.

Available constructors:
    Arcsine(*a=-1.0, b=1.0*)

Parameters
----------
a : float
    lower bound.
b : float
    upper bound, :math:`b > a`

Notes
-----
Its probability density function is defined as:

.. math::

    f_X(x) = \\frac{1}{\\pi \\sqrt{(x - a)(b - x)}},
             \\quad x \\in [a, b]

with :math:`a < b`.

Its first moments are:

.. math::
    :nowrap:

    \\begin{eqnarray*}
        \\Expect{X} & = & \\frac{a + b}{2} \\\\
        \\Var{X} & = & \\frac{(b - a)^2}{8}
    \\end{eqnarray*}

It is possible to create an Arcsine distribution from the alternative parametrization :math:`(\\mu, \\sigma)`: see  :class:`~openturns.ArcsineMuSigma`. In that case, all the results are presented in that new parametrization.

In order to use the alternative  parametrization :math:`(\\mu, \\sigma)` only to create the distribution, see the example below: all the results will be presented in the native parametrization :math:`(a, b)`

Examples
--------
Create a distribution from its native parameters :math:`(a, b)`:

>>> import openturns as ot
>>> myDist = ot.Arcsine(2.0, 3.0)

Create a it from the alternative parametrization :math:`(\\mu, \\sigma)`:

>>> myDist2 = ot.Arcsine()
>>> myDist2.setParameter(ot.ArcsineMuSigma()([2.5, 0.35]))

Create it from :math:`(\\mu, \\sigma)` and keep that parametrization for the remaining study: 

>>> myParam = ot.ArcsineMuSigma(2.5, 0.35)
>>> myDist3 = ot.ParametrizedDistribution(myParam)

Draw a sample:

>>> sample = myDist.getSample(5)"

// ---------------------------------------------------------------------

%feature("docstring") OT::Arcsine::getA
"Accessor to the distribution's lower bound.

Returns
-------
a : float
    Lower bound."

// ---------------------------------------------------------------------

%feature("docstring") OT::Arcsine::getB
"Accessor to the distribution's upper bound.

Returns
-------
b : float
    Upper bound."

// ---------------------------------------------------------------------

%feature("docstring") OT::Arcsine::getMu
"Accessor to the distribution's mean.

Returns
-------
mu : float
    Mean."

// ---------------------------------------------------------------------

%feature("docstring") OT::Arcsine::getSigma
"Accessor to the distribution's standard deviation.

Returns
-------
sigma : float
    Standard deviation."

// ---------------------------------------------------------------------

%feature("docstring") OT::Arcsine::setA
"Accessor to the distribution's lower bound.

Parameters
----------
a : float, :math:`a < b`
    Lower bound."

// ---------------------------------------------------------------------

%feature("docstring") OT::Arcsine::setB
"Accessor to the distribution's upper bound.

Parameters
----------
b : float, :math:`a < b`
    Upper bound."

// ---------------------------------------------------------------------

%feature("docstring") OT::Arcsine::setMu
"Accessor to the distribution's mean.

Parameters
----------
mu : float
    Mean."

// ---------------------------------------------------------------------

%feature("docstring") OT::Arcsine::setSigma
"Accessor to the distribution's standard deviation.

Parameters
----------
sigma : float, :math:`\\sigma > 0`
    Standard deviation."
