// C++/WinRT v2.0.250303.1

// SPDX-License-Identifier: MIT OR Apache-2.0
// SPDX-FileCopyrightText: Copyright (c) Microsoft Corporation
//
// Generated using .winmd files from https://github.com/microsoft/windows-rs
//

#pragma once
#ifndef WINRT_Windows_Devices_Adc_Provider_H
#define WINRT_Windows_Devices_Adc_Provider_H
#include "winrt/base.h"
static_assert(winrt::check_version(CPPWINRT_VERSION, "2.0.250303.1"), "Mismatched C++/WinRT headers.");
#define CPPWINRT_VERSION "2.0.250303.1"
#include "winrt/Windows.Devices.Adc.h"
#include "winrt/impl/Windows.Foundation.Collections.2.h"
#include "winrt/impl/Windows.Devices.Adc.Provider.2.h"
namespace winrt::impl
{
    template <typename D> auto consume_Windows_Devices_Adc_Provider_IAdcControllerProvider<D>::ChannelCount() const
    {
        int32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ChannelCount(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider>**)this;
            check_hresult(_winrt_abi_type->get_ChannelCount(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_Adc_Provider_IAdcControllerProvider<D>::ResolutionInBits() const
    {
        int32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ResolutionInBits(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider>**)this;
            check_hresult(_winrt_abi_type->get_ResolutionInBits(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_Adc_Provider_IAdcControllerProvider<D>::MinValue() const
    {
        int32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MinValue(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider>**)this;
            check_hresult(_winrt_abi_type->get_MinValue(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_Adc_Provider_IAdcControllerProvider<D>::MaxValue() const
    {
        int32_t value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_MaxValue(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider>**)this;
            check_hresult(_winrt_abi_type->get_MaxValue(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_Adc_Provider_IAdcControllerProvider<D>::ChannelMode() const
    {
        winrt::Windows::Devices::Adc::Provider::ProviderAdcChannelMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ChannelMode(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider>**)this;
            check_hresult(_winrt_abi_type->get_ChannelMode(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Devices_Adc_Provider_IAdcControllerProvider<D>::ChannelMode(winrt::Windows::Devices::Adc::Provider::ProviderAdcChannelMode const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_ChannelMode(static_cast<int32_t>(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider>**)this;
            check_hresult(_winrt_abi_type->put_ChannelMode(static_cast<int32_t>(value)));
        }
    }
    template <typename D> auto consume_Windows_Devices_Adc_Provider_IAdcControllerProvider<D>::IsChannelModeSupported(winrt::Windows::Devices::Adc::Provider::ProviderAdcChannelMode const& channelMode) const
    {
        bool result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->IsChannelModeSupported(static_cast<int32_t>(channelMode), &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider>**)this;
            check_hresult(_winrt_abi_type->IsChannelModeSupported(static_cast<int32_t>(channelMode), &result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_Devices_Adc_Provider_IAdcControllerProvider<D>::AcquireChannel(int32_t channel) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->AcquireChannel(channel));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider>**)this;
            check_hresult(_winrt_abi_type->AcquireChannel(channel));
        }
    }
    template <typename D> auto consume_Windows_Devices_Adc_Provider_IAdcControllerProvider<D>::ReleaseChannel(int32_t channel) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReleaseChannel(channel));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider>**)this;
            check_hresult(_winrt_abi_type->ReleaseChannel(channel));
        }
    }
    template <typename D> auto consume_Windows_Devices_Adc_Provider_IAdcControllerProvider<D>::ReadValue(int32_t channelNumber) const
    {
        int32_t result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ReadValue(channelNumber, &result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider>**)this;
            check_hresult(_winrt_abi_type->ReadValue(channelNumber, &result));
        }
        return result;
    }
    template <typename D> auto consume_Windows_Devices_Adc_Provider_IAdcProvider<D>::GetControllers() const
    {
        void* result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Devices::Adc::Provider::IAdcProvider>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Devices::Adc::Provider::IAdcProvider, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Adc::Provider::IAdcProvider>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetControllers(&result));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Devices::Adc::Provider::IAdcProvider>**)this;
            check_hresult(_winrt_abi_type->GetControllers(&result));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider>{ result, take_ownership_from_abi };
    }
    template <typename D>
    struct produce<D, winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider> : produce_base<D, winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider>
    {
        int32_t __stdcall get_ChannelCount(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<int32_t>(this->shim().ChannelCount());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ResolutionInBits(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<int32_t>(this->shim().ResolutionInBits());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MinValue(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<int32_t>(this->shim().MinValue());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_MaxValue(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<int32_t>(this->shim().MaxValue());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_ChannelMode(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Devices::Adc::Provider::ProviderAdcChannelMode>(this->shim().ChannelMode());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_ChannelMode(int32_t value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ChannelMode(*reinterpret_cast<winrt::Windows::Devices::Adc::Provider::ProviderAdcChannelMode const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall IsChannelModeSupported(int32_t channelMode, bool* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<bool>(this->shim().IsChannelModeSupported(*reinterpret_cast<winrt::Windows::Devices::Adc::Provider::ProviderAdcChannelMode const*>(&channelMode)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall AcquireChannel(int32_t channel) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().AcquireChannel(channel);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ReleaseChannel(int32_t channel) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().ReleaseChannel(channel);
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ReadValue(int32_t channelNumber, int32_t* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<int32_t>(this->shim().ReadValue(channelNumber));
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
    template <typename D>
    struct produce<D, winrt::Windows::Devices::Adc::Provider::IAdcProvider> : produce_base<D, winrt::Windows::Devices::Adc::Provider::IAdcProvider>
    {
        int32_t __stdcall GetControllers(void** result) noexcept final try
        {
            clear_abi(result);
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Foundation::Collections::IVectorView<winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider>>(this->shim().GetControllers());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
}
WINRT_EXPORT namespace winrt::Windows::Devices::Adc::Provider
{
}
namespace std
{
#ifndef WINRT_LEAN_AND_MEAN
    template<> struct hash<winrt::Windows::Devices::Adc::Provider::IAdcControllerProvider> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Devices::Adc::Provider::IAdcProvider> : winrt::impl::hash_base {};
#endif
#ifdef __cpp_lib_format
#endif
}
#endif
