/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.cms.utils;

import it.actalis.ellips.capi.core.Base64EncoderOutputStream;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSSignedDataStreamGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.io.Streams;

public class CAdESUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void bundleP7Signature(InputStream inputStream, InputStream inputStream2, OutputStream outputStream, boolean bl) throws CapiException {
        block29: {
            OutputStream outputStream2 = null;
            try {
                Object object;
                Object object2;
                if (bl) {
                    object2 = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray("qualsiasi".getBytes()), inputStream);
                } else {
                    object = null;
                    try {
                        object = Streams.readAll((InputStream)inputStream);
                        object2 = Base64.decode((byte[])object);
                        object2 = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray("qualsiasi".getBytes()), object2);
                    }
                    catch (Exception exception) {
                        object = new PEMParser((Reader)new StringReader(new String((byte[])object)));
                        try {
                            ContentInfo contentInfo = (ContentInfo)object.readObject();
                            object = contentInfo;
                            if (contentInfo == null) {
                                throw new CapiException("Envelope format unknown or not implemented", 50021, (Throwable)exception);
                            }
                            if (!object.getContentType().equals((ASN1Primitive)PKCSObjectIdentifiers.signedData)) {
                                throw new CapiException("Not a valid PKCS#7 signed-data object - wrong header " + object.getContentType().getId(), 50021, (Throwable)exception);
                            }
                            object2 = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray("qualsiasi".getBytes()), (ContentInfo)object);
                        }
                        catch (Exception exception2) {
                            throw new CapiException("Envelope format unknown or not implemented", 50021, (Throwable)exception2);
                        }
                    }
                }
                CMSSignedDataStreamGenerator cMSSignedDataStreamGenerator = new CMSSignedDataStreamGenerator();
                object = cMSSignedDataStreamGenerator;
                cMSSignedDataStreamGenerator.addSigners(object2.getSignerInfos());
                object.addCertificates(object2.getCertificates());
                outputStream2 = object.open(outputStream, true);
                Streams.pipeAll((InputStream)inputStream2, (OutputStream)outputStream2);
                if (outputStream2 == null) break block29;
            }
            catch (Exception exception) {
                try {
                    throw new CapiException(exception.getMessage(), 1003, (Throwable)exception);
                }
                catch (Throwable throwable) {
                    if (outputStream2 != null) {
                        try {
                            outputStream2.close();
                        }
                        catch (IOException iOException) {}
                    }
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        inputStream2.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        outputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                outputStream2.close();
            }
            catch (IOException iOException) {}
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        try {
            inputStream2.close();
        }
        catch (IOException iOException) {}
        try {
            outputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unbundleP7Signature(InputStream inputStream, OutputStream outputStream, OutputStream outputStream2, boolean bl) throws CapiException {
        try {
            Object object;
            CMSSignedData cMSSignedData;
            Object object2 = Streams.readAll((InputStream)inputStream);
            if (bl) {
                cMSSignedData = new CMSSignedData(object2);
            } else {
                try {
                    object = Base64.decode((byte[])object2);
                    cMSSignedData = new CMSSignedData(object);
                }
                catch (Exception exception) {
                    object2 = new PEMParser((Reader)new StringReader(new String((byte[])object2)));
                    try {
                        cMSSignedData = (ContentInfo)object2.readObject();
                        if (cMSSignedData == null) {
                            throw new CapiException("Envelope format unknown or not implemented", 50021, (Throwable)exception);
                        }
                        if (!cMSSignedData.getContentType().equals((ASN1Primitive)PKCSObjectIdentifiers.signedData)) {
                            throw new CapiException("Not a valid PKCS#7 signed-data object - wrong header " + cMSSignedData.getContentType().getId(), 50021, (Throwable)exception);
                        }
                        cMSSignedData = new CMSSignedData((ContentInfo)cMSSignedData);
                    }
                    catch (Exception exception2) {
                        throw new CapiException("Envelope format unknown or not implemented", 50021, (Throwable)exception2);
                    }
                }
            }
            CMSTypedData cMSTypedData = cMSSignedData.getSignedContent();
            object = cMSTypedData;
            cMSTypedData.write(outputStream2);
            CMSSignedDataGenerator cMSSignedDataGenerator = new CMSSignedDataGenerator();
            object2 = cMSSignedDataGenerator;
            cMSSignedDataGenerator.addSigners(cMSSignedData.getSignerInfos());
            object2.addCertificates(cMSSignedData.getCertificates());
            cMSSignedData = object2.generate((CMSTypedData)object, false);
            outputStream.write(cMSSignedData.getEncoded());
        }
        catch (Exception exception) {
            try {
                throw new CapiException(exception.getMessage(), 1003, (Throwable)exception);
            }
            catch (Throwable throwable) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
                try {
                    outputStream2.close();
                }
                catch (IOException iOException) {}
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            outputStream.close();
        }
        catch (IOException iOException) {}
        try {
            outputStream2.close();
        }
        catch (IOException iOException) {}
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    /*
     * Loose catch block
     */
    public static void unbundleStreamP7Signature(InputStream inputStream, OutputStream outputStream, OutputStream outputStream2, boolean bl) throws CapiException {
        block42: {
            EllipsLogger ellipsLogger = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
            if (inputStream == null) {
                throw new CapiException("Null data", 1001);
            }
            try {
                DigestCalculatorProvider digestCalculatorProvider = new JcaDigestCalculatorProviderBuilder().setProvider(ProvUtils.bcProvider).build();
                digestCalculatorProvider = new CMSSignedDataParser(digestCalculatorProvider, inputStream);
                ellipsLogger.debug("parsed implicit signed data ok");
                CMSTypedStream cMSTypedStream = digestCalculatorProvider.getSignedContent();
                if (cMSTypedStream == null) {
                    ellipsLogger.debug("no content found into envelope... is detached...");
                    throw new CapiException("Envelope is detached", 50000);
                }
                InputStream inputStream2 = cMSTypedStream.getContentStream();
                if (inputStream2 == null) {
                    ellipsLogger.debug("no content found into envelope... is detached...");
                    throw new CapiException("Envelope is detached", 50000);
                }
                if (outputStream2 != null) {
                    ellipsLogger.debug("parsed implicit: copying data...");
                    Streams.pipeAll((InputStream)inputStream2, (OutputStream)outputStream2);
                } else {
                    cMSTypedStream.drain();
                    ellipsLogger.debug("parsed implicit: skipping data...");
                }
                ellipsLogger.debug("parsed implicit: data ok");
                ellipsLogger.debug("saving envelope ...");
                inputStream2 = null;
                try {
                    cMSTypedStream = new CMSSignedDataStreamGenerator();
                    if (digestCalculatorProvider.getSignerInfos().size() <= 0) {
                        throw new CapiException("Error parsing envelope: no signers", 50022);
                    }
                    cMSTypedStream.addSigners(digestCalculatorProvider.getSignerInfos());
                    cMSTypedStream.addCertificates(digestCalculatorProvider.getCertificates());
                }
                catch (Exception exception) {
                    ellipsLogger.debug(exception.getMessage(), (Throwable)exception);
                    throw new CapiException("Error parsing signed envelope", 50040);
                }
                if (!bl) {
                    inputStream2 = new Base64EncoderOutputStream(outputStream, true);
                }
                OutputStream outputStream3 = cMSTypedStream.open((OutputStream)(!bl ? inputStream2 : outputStream), false);
                outputStream3.close();
                ellipsLogger.debug("Envelope saved.");
                try {
                    if (inputStream2 != null) {
                        ((OutputStream)((Object)inputStream2)).close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
                break block42;
                catch (Exception exception) {
                    try {
                        ellipsLogger.debug(exception.getMessage(), (Throwable)exception);
                        throw new CapiException("Error encoding signed envelope", 50040);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream2 != null) {
                                ((OutputStream)((Object)inputStream2)).close();
                            }
                        }
                        catch (IOException iOException) {}
                        try {
                            outputStream.close();
                        }
                        catch (Exception exception2) {}
                        throw throwable;
                    }
                }
            }
            catch (CapiException capiException) {
                ellipsLogger.debug(capiException.getMessage(), (Throwable)capiException);
                throw capiException;
            }
            catch (CMSException cMSException) {
                ellipsLogger.debug(cMSException.getMessage(), (Throwable)cMSException);
                throw new CapiException("Envelope format unknown or not implemented", 50023);
            }
            catch (IOException iOException) {
                ellipsLogger.debug(iOException.getMessage(), (Throwable)iOException);
                throw new CapiException("Error writing envelope content", 50025);
            }
            catch (Exception exception) {
                ellipsLogger.debug(exception.getMessage(), (Throwable)exception);
                throw new CapiException("Internal error", 50050);
            }
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {}
        try {
            if (outputStream2 != null) {
                outputStream2.close();
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
        catch (CapiException capiException) {
            try {
                CapiException capiException2 = capiException;
                throw capiException;
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
                try {
                    if (outputStream2 != null) {
                        outputStream2.close();
                    }
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
    }
}

