/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop.dom;

import esecurity.desktop.JsUtils;
import esecurity.desktop.View;
import esecurity.desktop.dom.DOMElement;
import esecurity.desktop.dom.TableCell;
import java.util.ArrayList;
import java.util.List;

public class TableRow<T extends TableCell>
extends DOMElement {
    private List<T> cells = new ArrayList<T>();

    public TableRow(String id, String parentId, View view) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        this.createElementWithIDAndAppendIt("tr", id, parentId);
    }

    public TableRow(String id, DOMElement parent, View view) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        this.createElementWithIDAndAppendIt("tr", id, parent.getId());
    }

    public void addCell(T cell) {
        this.cells.add(cell);
    }

    public List<T> getCells() {
        return this.cells;
    }

    public void delete() {
        for (TableCell cell : this.cells) {
            cell.delete();
        }
        this.remove();
        this.cells.clear();
    }
}

