/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.utils;

import com.sun.jna.Platform;
import esecurity.crypto.gui.properties.ClientProperties;
import esecurity.crypto.gui.properties.UserProperties;
import esecurity.crypto.gui.utils.ProcessStreamLogger;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.logging.LoggerLevel;
import it.actalis.ellips.util.TmpFileUtils;
import it.actalis.vol.utils.Constants;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import org.ini4j.Ini;
import org.ini4j.IniPreferences;
import org.slf4j.Logger;

public class OfficeToolWrapper {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static AppStatus b = AppStatus.UNKNOWN;
    private static AppStatus c = AppStatus.UNKNOWN;
    private static AppStatus d = AppStatus.UNKNOWN;

    public static boolean saveStatus(File file) {
        try {
            Object object;
            StringBuilder stringBuilder;
            Closeable closeable = new BufferedReader(new FileReader(file));
            Throwable throwable = null;
            try {
                stringBuilder = new StringBuilder();
                while ((object = ((BufferedReader)closeable).readLine()) != null) {
                    if (((String)object).contains("wordStatus")) {
                        object = "wordStatus = " + b.ordinal();
                    } else if (((String)object).contains("excelStatus")) {
                        object = "excelStatus = " + c.ordinal();
                    } else if (((String)object).contains("powerPointStatus")) {
                        object = "powerPointStatus = " + d.ordinal();
                    }
                    stringBuilder.append((String)object).append(System.getProperty("line.separator"));
                }
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (throwable != null) {
                        try {
                            ((BufferedReader)closeable).close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ((BufferedReader)closeable).close();
                    }
                    throw throwable4;
                }
            }
            ((BufferedReader)closeable).close();
            closeable = new FileWriter(file);
            throwable = null;
            try {
                ((Writer)closeable).write(stringBuilder.toString());
                ((OutputStreamWriter)closeable).flush();
            }
            catch (Throwable throwable6) {
                try {
                    object = throwable6;
                    throwable = throwable6;
                    throw object;
                }
                catch (Throwable throwable7) {
                    if (throwable != null) {
                        try {
                            ((OutputStreamWriter)closeable).close();
                        }
                        catch (Throwable throwable8) {
                            throwable.addSuppressed(throwable8);
                        }
                    } else {
                        ((OutputStreamWriter)closeable).close();
                    }
                    throw throwable7;
                }
            }
            ((OutputStreamWriter)closeable).close();
        }
        catch (IOException iOException) {
            a.error("error writing status: " + iOException.getMessage());
            return false;
        }
        return true;
    }

    public static void loadStatus(ClientProperties clientProperties) {
        switch (Integer.parseInt(clientProperties.get(UserProperties.WORD_STATUS, ""))) {
            case 2: {
                b = AppStatus.INSTALLED;
                break;
            }
            case 3: {
                b = AppStatus.INSTALLED_AND_SUPPORTED;
                break;
            }
            default: {
                b = AppStatus.NOT_INSTALLED;
            }
        }
        switch (Integer.parseInt(clientProperties.get(UserProperties.EXCEL_STATUS, ""))) {
            case 2: {
                c = AppStatus.INSTALLED;
                break;
            }
            case 3: {
                c = AppStatus.INSTALLED_AND_SUPPORTED;
                break;
            }
            default: {
                c = AppStatus.NOT_INSTALLED;
            }
        }
        switch (Integer.parseInt(clientProperties.get(UserProperties.POWERPOINT_STATUS, ""))) {
            case 2: {
                d = AppStatus.INSTALLED;
                return;
            }
            case 3: {
                d = AppStatus.INSTALLED_AND_SUPPORTED;
                return;
            }
        }
        d = AppStatus.NOT_INSTALLED;
    }

    public static boolean loadStatus(File object) {
        try {
            object = new IniPreferences(new Ini((File)object));
            object = ((Preferences)object).node("officeTool");
            int n = ((Preferences)object).getInt("wordStatus", 1);
            int n2 = ((Preferences)object).getInt("excelStatus", 1);
            int n3 = ((Preferences)object).getInt("powerPointStatus", 1);
            switch (n) {
                case 2: {
                    b = AppStatus.INSTALLED;
                    break;
                }
                case 3: {
                    b = AppStatus.INSTALLED_AND_SUPPORTED;
                    break;
                }
                default: {
                    b = AppStatus.NOT_INSTALLED;
                }
            }
            switch (n2) {
                case 2: {
                    c = AppStatus.INSTALLED;
                    break;
                }
                case 3: {
                    c = AppStatus.INSTALLED_AND_SUPPORTED;
                    break;
                }
                default: {
                    c = AppStatus.NOT_INSTALLED;
                }
            }
            switch (n3) {
                case 2: {
                    d = AppStatus.INSTALLED;
                    break;
                }
                case 3: {
                    d = AppStatus.INSTALLED_AND_SUPPORTED;
                    break;
                }
                default: {
                    d = AppStatus.NOT_INSTALLED;
                    break;
                }
            }
        }
        catch (IOException iOException) {
            a.error("error reading status: " + iOException.getMessage());
            return false;
        }
        return true;
    }

    public static synchronized AppStatus isAppReady() {
        if (b != AppStatus.UNKNOWN) {
            return b;
        }
        a.debug("checking if MS Word is available on system...");
        b = OfficeToolWrapper.detect(MSApps.WORD);
        c = OfficeToolWrapper.detect(MSApps.EXCEL);
        d = OfficeToolWrapper.detect(MSApps.POWERPOINT);
        if (b != AppStatus.INSTALLED) {
            a.debug("MS Word status is " + b.name());
            return b;
        }
        b = OfficeToolWrapper.verify(MSApps.WORD, b);
        if (c == AppStatus.INSTALLED) {
            c = b;
        }
        if (d == AppStatus.INSTALLED) {
            d = b;
        }
        a.debug("MS Word status is " + b.name());
        return b;
    }

    public static AppStatus detect(MSApps object) {
        Object object2 = System.getProperty("user.dir") + File.separator + "OfficeTool.exe";
        if (!new File((String)object2).exists()) {
            a.error("OfficeTool not found on " + (String)object2);
            return AppStatus.UNKNOWN;
        }
        a.debug("start OfficeTool " + (String)object2 + " to detect " + ((Enum)object).name());
        object = new ProcessBuilder(new String[]{object2, "detect", ((Enum)object).name().toLowerCase()});
        object2 = null;
        int n = -1;
        try {
            object2 = ((ProcessBuilder)object).start();
            OfficeToolWrapper.a(((Process)object2).getInputStream(), ((Process)object2).getErrorStream());
            n = ((Process)object2).waitFor();
        }
        catch (Exception exception) {
            a.error(exception.getMessage());
        }
        finally {
            ((Process)object2).destroy();
        }
        a.debug("OfficeTool exit code: " + n);
        if (n == 0) {
            return AppStatus.INSTALLED;
        }
        if (n == 1 || n == 2) {
            return AppStatus.UNKNOWN;
        }
        if (n == 3) {
            return AppStatus.NOT_INSTALLED;
        }
        return AppStatus.UNKNOWN;
    }

    public static AppStatus verify(MSApps object, AppStatus appStatus) {
        Object object2 = System.getProperty("user.dir") + File.separator + "OfficeTool.exe";
        if (!new File((String)object2).exists()) {
            a.error("OfficeTool not found on " + (String)object2);
            return AppStatus.UNKNOWN;
        }
        a.debug("start OfficeTool " + (String)object2 + " to verify " + ((Enum)object).name());
        object = new ProcessBuilder(new String[]{object2, "verify", ((Enum)object).name().toLowerCase()});
        object2 = null;
        int n = -1;
        try {
            object2 = ((ProcessBuilder)object).start();
            OfficeToolWrapper.a(((Process)object2).getInputStream(), ((Process)object2).getErrorStream());
            n = ((Process)object2).waitFor();
        }
        catch (Exception exception) {
            a.error(exception.getMessage());
        }
        finally {
            ((Process)object2).destroy();
        }
        a.debug("OfficeTool exit code: " + n);
        if (n == 0) {
            return AppStatus.INSTALLED_AND_SUPPORTED;
        }
        return appStatus;
    }

    public static File convert(File file) throws IOException {
        it.actalis.ellips.util.File file2 = TmpFileUtils.createTempFile((String)"TMP", (String)".pdf");
        if (OfficeToolWrapper.convert(file, (File)file2)) {
            return file2;
        }
        return null;
    }

    public static boolean convert(File object, File object2) {
        String string = System.getProperty("user.dir") + File.separator + "OfficeTool.exe";
        if (!new File(string).exists()) {
            a.error("OfficeTool not found on " + string);
            return false;
        }
        a.debug("start office tool " + string + " to convert " + ((File)object).getName());
        object = new ProcessBuilder(string, "convert", ((File)object).getAbsolutePath(), ((File)object2).getAbsolutePath());
        object2 = null;
        int n = -1;
        try {
            object2 = ((ProcessBuilder)object).start();
            OfficeToolWrapper.a(((Process)object2).getInputStream(), ((Process)object2).getErrorStream());
            n = ((Process)object2).waitFor();
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
        }
        finally {
            ((Process)object2).destroy();
        }
        a.debug("OfficeTool exit code: " + n);
        return n == 0;
    }

    public static boolean isConvertibleToPDF(String string) {
        if (!Platform.isWindows()) {
            return false;
        }
        string = string.toUpperCase();
        Object object = new ArrayList<String>();
        if (OfficeToolWrapper.isAppReady() == AppStatus.INSTALLED_AND_SUPPORTED) {
            object.add(".DOC");
            object.add(".DOCX");
            object.add(".XLS");
            object.add(".XLSX");
        }
        object = object.iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            if (!string.endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public static AppStatus getWord_status() {
        return b;
    }

    public static AppStatus getExcel_status() {
        return c;
    }

    public static AppStatus getPpt_status() {
        return d;
    }

    private static void a(InputStream object, InputStream object2) {
        object2 = new ProcessStreamLogger((InputStream)object2, LoggerLevel.ERROR);
        ((Thread)object2).start();
        object = new ProcessStreamLogger((InputStream)object, LoggerLevel.INFO);
        ((Thread)object).start();
    }

    public static enum AppStatus {
        UNKNOWN,
        NOT_INSTALLED,
        INSTALLED,
        INSTALLED_AND_SUPPORTED;

    }

    public static enum Methods {
        DETECT,
        VERIFY,
        CONVERT;

    }

    public static enum MSApps {
        WORD,
        EXCEL,
        POWERPOINT;

    }
}

