/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.http.arubautils;

import com.github.markusbernhardt.proxy.ProxySearch;
import com.github.markusbernhardt.proxy.selector.misc.BufferedProxySelector;
import it.actalis.ellips.capi.http.arubautils.InternalAutenticator;
import it.actalis.ellips.capi.http.arubautils.ProxyAutenticator;
import java.net.Authenticator;
import java.net.ProxySelector;
import java.net.URI;
import java.security.KeyStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkConfig
implements KeyStore.LoadStoreParameter {
    private String proxyType = "direct";
    private String proxy = "";
    private String proxyPort = "";
    private String userProxy = "";
    private String passwordProxy = "";
    private String ldapProxyType = "direct";
    private String ldapProxy = "";
    private String ldapProxyPort = "";
    private String ldapUserProxy = "";
    private String ldapPasswordProxy = "";
    private String connectionTimeOut = "20000";
    private String readTimeOut = "25000";
    private String enforceMode = "S";
    private boolean preferBasic = true;
    private static final InternalAutenticator auth = new InternalAutenticator();
    private Logger logger = null;
    private String defaultSchema = null;
    private ProxyAutenticator proxyauthenticator;
    private boolean automaticProxyDiscover = false;
    private ProxySelector defaultproxyselector = null;
    private boolean proxyselectorinprogress = false;
    private String providername;
    private String[] proxynohosts = null;
    private boolean changed = false;
    private boolean followRedirect = true;

    public NetworkConfig() {
        this(null, false);
    }

    public NetworkConfig(Logger logger, boolean usedefaultautenticator) {
        this(logger, usedefaultautenticator, null);
    }

    public NetworkConfig(Logger log, boolean usedefaultautenticator, String provider) {
        if (provider == null) {
            provider = System.getProperty("esecurity.urlutils.defaultprovider");
        }
        this.logger = log == null ? LoggerFactory.getLogger(NetworkConfig.class) : log;
        this.providername = provider;
        if (!usedefaultautenticator) {
            auth.setLogger(this.logger);
            Authenticator.setDefault(auth);
        }
        try {
            this.defaultSchema = System.getProperty("http.auth.preference");
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public ProxySelector getDefaultproxyselector() {
        for (int maxRetry = 20; this.proxyselectorinprogress && maxRetry > 0; --maxRetry) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.defaultproxyselector;
    }

    public synchronized boolean isAutomaticProxyDiscovery() {
        return this.automaticProxyDiscover;
    }

    public synchronized void setAutomaticProxyDiscovery(boolean automaticProxyDiscover) {
        if (automaticProxyDiscover) {
            this.proxyselectorinprogress = true;
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ProxySearch proxySearch = ProxySearch.getDefaultProxySearch();
                        proxySearch.setPacCacheSettings(32, 300000L, BufferedProxySelector.CacheScope.CACHE_SCOPE_HOST);
                        NetworkConfig.this.defaultproxyselector = proxySearch.getProxySelector();
                    }
                    finally {
                        NetworkConfig.this.proxyselectorinprogress = false;
                    }
                }
            });
            thread.start();
        } else {
            this.defaultproxyselector = null;
            this.proxyselectorinprogress = false;
        }
        this.automaticProxyDiscover = automaticProxyDiscover;
    }

    public ProxyAutenticator getProxyauthenticator() {
        return this.proxyauthenticator;
    }

    public void setProxyauthenticator(ProxyAutenticator proxyauthenticator) {
        this.proxyauthenticator = proxyauthenticator;
    }

    public boolean isPreferBasic() {
        return this.preferBasic;
    }

    public void setPreferBasic(boolean preferBasic) {
        if (this.providername == null || this.providername.endsWith("HTTPUrlConnectionProvider")) {
            try {
                if (preferBasic) {
                    System.setProperty("http.auth.preference", "BASIC");
                } else {
                    System.setProperty("http.auth.preference", this.defaultSchema);
                }
                this.preferBasic = preferBasic;
            }
            catch (Exception ex) {
                this.logger.error(null, (Throwable)ex);
                this.preferBasic = false;
            }
        }
    }

    public InternalAutenticator getAuth() {
        return auth;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getEnforceMode() {
        return this.enforceMode;
    }

    public void setEnforceMode(String enforceMode) {
        this.enforceMode = enforceMode;
    }

    public String getConnectionTimeOut() {
        return this.connectionTimeOut;
    }

    public void setConnectionTimeOut(String connectionTimeOut) {
        this.connectionTimeOut = connectionTimeOut;
    }

    public String getReadTimeOut() {
        return this.readTimeOut;
    }

    public void setReadTimeOut(String readTimeOut) {
        this.readTimeOut = readTimeOut;
    }

    public String getLdapPasswordProxy() {
        return this.ldapPasswordProxy;
    }

    public void setLdapPasswordProxy(String socksPasswordProxy) {
        this.ldapPasswordProxy = socksPasswordProxy;
    }

    public String getLdapProxy() {
        return this.ldapProxy;
    }

    public void setLdapProxy(String ldapProxy) {
        if (ldapProxy != null && !ldapProxy.isEmpty() && (ldapProxy.startsWith("http") || ldapProxy.startsWith("socks"))) {
            String type = ldapProxy.substring(0, ldapProxy.indexOf(":"));
            ldapProxy = ldapProxy.substring(ldapProxy.indexOf("//") + 2);
            this.setLdapProxyType(type);
        }
        this.ldapProxy = ldapProxy;
    }

    public String getLdapProxyPort() {
        return this.ldapProxyPort;
    }

    public void setLdapProxyPort(String socksProxyPort) {
        this.ldapProxyPort = socksProxyPort;
    }

    public String getLdapUserProxy() {
        return this.ldapUserProxy;
    }

    public void setLdapUserProxy(String socksUserProxy) {
        this.ldapUserProxy = socksUserProxy;
    }

    public String getPasswordProxy() {
        return this.passwordProxy;
    }

    public void setPasswordProxy(String passwordProxy) {
        this.passwordProxy = passwordProxy;
    }

    public String getProxy() {
        return this.proxy;
    }

    public void setProxy(String proxy) {
        if (proxy != null && !proxy.isEmpty() && (proxy.startsWith("http") || proxy.startsWith("socks"))) {
            String type = proxy.substring(0, proxy.indexOf(":"));
            proxy = proxy.substring(proxy.indexOf("//") + 2);
            this.setProxyType(type);
        }
        this.proxy = proxy;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getUserProxy() {
        return this.userProxy;
    }

    public void setUserProxy(String userProxy) {
        this.userProxy = userProxy;
    }

    @Override
    public KeyStore.ProtectionParameter getProtectionParameter() {
        return null;
    }

    boolean isProxyselectorinprogress() {
        return this.proxyselectorinprogress;
    }

    public String getProvidername() {
        return this.providername;
    }

    public void setProvidername(String providername) {
        this.providername = providername;
    }

    public String[] getProxynohosts() {
        return this.proxynohosts;
    }

    public void setProxynohosts(String[] proxynohosts) {
        this.proxynohosts = proxynohosts;
    }

    public boolean isProxyHost(String url) {
        if (this.proxynohosts != null) {
            boolean ret = true;
            try {
                this.logger.debug("isProxyHost URL: " + url);
                URI u = new URI(url);
                String host = u.getHost();
                this.logger.debug("URL host:" + host);
                for (int i = 0; i < this.proxynohosts.length; ++i) {
                    if (!host.equalsIgnoreCase(this.proxynohosts[i])) continue;
                    this.logger.debug("nonProxyHost:" + host);
                    return false;
                }
            }
            catch (Exception e) {
                this.logger.debug(null, (Throwable)e);
            }
            return ret;
        }
        return true;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public String getProxyType() {
        return this.proxyType;
    }

    public void setProxyType(String proxyType) {
        if (proxyType == null || proxyType.isEmpty()) {
            return;
        }
        this.proxyType = (proxyType = proxyType.toLowerCase()).startsWith("socks") ? "socks" : (proxyType.startsWith("http") ? "http" : "direct");
    }

    public String getLdapProxyType() {
        return this.ldapProxyType;
    }

    public void setLdapProxyType(String proxyType) {
        if (proxyType == null || proxyType.isEmpty()) {
            return;
        }
        this.ldapProxyType = (proxyType = proxyType.toLowerCase()).startsWith("http") ? "http" : (proxyType.startsWith("socks") ? "socks" : "direct");
    }

    public boolean isSameProxy() {
        if (this.proxy != null && this.proxyPort != null && this.ldapProxy != null && this.ldapProxyPort != null) {
            return this.proxy.equals(this.ldapProxy) && this.proxyPort.equals(this.ldapProxyPort);
        }
        return false;
    }

    public boolean isFollowRedirect() {
        return this.followRedirect;
    }

    public void setFollowRedirect(boolean followRedirect) {
        this.followRedirect = followRedirect;
    }
}

