/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.signature;

import it.actalis.ellips.capi.signature.DigestAlgorithm;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;

public enum SignatureAlgorithm {
    SHA1withRSAEncryption("RSA", PKCSObjectIdentifiers.sha1WithRSAEncryption.getId(), "http://www.w3.org/2000/09/xmldsig#rsa-sha1", DigestAlgorithm.SHA1),
    SHA224withRSAEncryption("RSA", PKCSObjectIdentifiers.sha224WithRSAEncryption.getId(), "http://www.w3.org/2001/04/xmldsig-more#rsa-sha224", DigestAlgorithm.SHA224),
    SHA256withRSAEncryption("RSA", PKCSObjectIdentifiers.sha256WithRSAEncryption.getId(), "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", DigestAlgorithm.SHA256),
    SHA384withRSAEncryption("RSA", PKCSObjectIdentifiers.sha384WithRSAEncryption.getId(), "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384", DigestAlgorithm.SHA384),
    SHA512withRSAEncryption("RSA", PKCSObjectIdentifiers.sha512WithRSAEncryption.getId(), "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", DigestAlgorithm.SHA512),
    SHA3_224withRSAEncryption("RSA", NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_224.getId(), "http://www.w3.org/2007/05/xmldsig-more#sha3-224-rsa-MGF1", DigestAlgorithm.SHA3_224),
    SHA3_256withRSAEncryption("RSA", NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_256.getId(), "http://www.w3.org/2007/05/xmldsig-more#sha3-256-rsa-MGF1", DigestAlgorithm.SHA3_256),
    SHA3_384withRSAEncryption("RSA", NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_384.getId(), "http://www.w3.org/2007/05/xmldsig-more#sha3-384-rsa-MGF1", DigestAlgorithm.SHA3_384),
    SHA3_512withRSAEncryption("RSA", NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_512.getId(), "http://www.w3.org/2007/05/xmldsig-more#sha3-512-rsa-MGF1", DigestAlgorithm.SHA3_512),
    SHA1withECDSA("EC", X9ObjectIdentifiers.ecdsa_with_SHA1.getId(), "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1", DigestAlgorithm.SHA1),
    SHA224withECDSA("EC", X9ObjectIdentifiers.ecdsa_with_SHA224.getId(), "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224", DigestAlgorithm.SHA224),
    SHA256withECDSA("EC", X9ObjectIdentifiers.ecdsa_with_SHA256.getId(), "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256", DigestAlgorithm.SHA256),
    SHA384withECDSA("EC", X9ObjectIdentifiers.ecdsa_with_SHA384.getId(), "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384", DigestAlgorithm.SHA384),
    SHA512withECDSA("EC", X9ObjectIdentifiers.ecdsa_with_SHA512.getId(), "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512", DigestAlgorithm.SHA512),
    SHA3_224withECDSA("EC", NISTObjectIdentifiers.id_ecdsa_with_sha3_224.getId(), "", DigestAlgorithm.SHA3_224),
    SHA3_256withECDSA("EC", NISTObjectIdentifiers.id_ecdsa_with_sha3_256.getId(), "", DigestAlgorithm.SHA3_256),
    SHA3_384withECDSA("EC", NISTObjectIdentifiers.id_ecdsa_with_sha3_384.getId(), "", DigestAlgorithm.SHA3_384),
    SHA3_512withECDSA("EC", NISTObjectIdentifiers.id_ecdsa_with_sha3_512.getId(), "", DigestAlgorithm.SHA3_512);

    private String a;
    private String b;
    private String c;
    private DigestAlgorithm d;

    private SignatureAlgorithm(String string2, String string3, String string4, DigestAlgorithm digestAlgorithm) {
        this.a = string2;
        this.b = string3;
        this.c = string4;
        this.d = digestAlgorithm;
    }

    public final String getSignatureAlgo() {
        return this.a;
    }

    public final String getJavaName() {
        String string = "";
        switch (this.d) {
            case SHA1: {
                string = "SHA1with";
                break;
            }
            case SHA224: {
                string = "SHA224with";
                break;
            }
            case SHA256: {
                string = "SHA256with";
                break;
            }
            case SHA384: {
                string = "SHA384with";
                break;
            }
            case SHA512: {
                string = "SHA512with";
                break;
            }
            case SHA3_224: {
                string = "SHA3-224with";
                break;
            }
            case SHA3_256: {
                string = "SHA3-256with";
                break;
            }
            case SHA3_384: {
                string = "SHA3-384with";
                break;
            }
            case SHA3_512: {
                string = "SHA3-512with";
            }
        }
        if (string.isEmpty()) {
            string = this.d.name() + "with";
        }
        string = this.a.equalsIgnoreCase("RSA") ? string + "RSAEncryption" : string + "ECDSA";
        return string;
    }

    public final String getOid() {
        return this.b;
    }

    public final String getXadesName() {
        return this.c;
    }

    public final DigestAlgorithm getDigestAlgo() {
        return this.d;
    }
}

