/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.signature;

import esecurity.tsl.CertChain;
import esecurity.tsl.CertDb;
import esecurity.tsl.ChainEntry;
import esecurity.validator.ValidatorConfig;
import esecurity.validator.x509status.crl.CRLUtils;
import esecurity.validator.x509status.ocsp.HttpOCSPClient;
import esecurity.validator.x509status.ocsp.OCSPResponse;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.http.HTTP;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.signature.LTResource;
import it.actalis.vol.utils.Constants;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.x509.extension.X509ExtensionUtil;
import org.slf4j.Logger;

public class LTResourceResolver {
    private NetworkConfig a = HTTP.defaultConfig;
    private Logger b;
    private CertDb c;

    public LTResourceResolver(NetworkConfig networkConfig, Logger logger, CertDb certDb) {
        if (networkConfig != null) {
            this.a = networkConfig;
        }
        this.b = logger == null ? EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME) : logger;
        this.c = certDb;
    }

    public LTResource resolve(Certificate certificate) throws CapiException, IOException, CertificateException {
        return this.resolve(certificate, null);
    }

    public LTResource resolve(Certificate certificate, Date date) throws CapiException, IOException, CertificateException {
        LTResource lTResource = new LTResource();
        Object object = this.c.retrieveCertificateChain(certificate);
        if (((CertChain)object).getStartEntry().getParent() == null) {
            throw new CapiException("Unable to resolve the certificate chain for cert " + certificate.getSubjectDN(), 1003);
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
        simpleDateFormat.setTimeZone(Constants.DEFAULT_TIMEZONE);
        object = ((CertChain)object).iterator();
        while (object.hasNext()) {
            int n;
            Object object2;
            int n2;
            Object object3 = (ChainEntry)object.next();
            if (((ChainEntry)object3).getCert().equals(certificate)) continue;
            lTResource.addCert(((ChainEntry)object3).getCert());
            Iterator<ChainEntry> iterator = null;
            for (n2 = 0; n2 < 2 && (iterator = this.a(certificate, ((ChainEntry)object3).getCert())) != null; ++n2) {
                if (((OCSPResponse)((Object)iterator)).getBasicOcspResponse().getCerts() == null || ((OCSPResponse)((Object)iterator)).getBasicOcspResponse().getCerts().length == 0) {
                    this.b.debug("OCSP response for certificate " + certificate.getSubjectDN() + " has not certificate itself. Try with CRL...");
                    iterator = null;
                    break;
                }
                object2 = "";
                n = 1;
                if (date != null && ((OCSPResponse)((Object)iterator)).getProducedAt().before(date)) {
                    object2 = String.format("OCSP response date (%s) produced before than time stamp (%s)", simpleDateFormat.format(((OCSPResponse)((Object)iterator)).getProducedAt()), simpleDateFormat.format(date));
                    this.b.debug("trial " + (n2 + 1) + ": " + (String)object2);
                    n = 0;
                }
                if (n != 0) break;
                if (n2 == 2) {
                    throw new CapiException((String)object2, 1003);
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {}
            }
            if (iterator != null) {
                lTResource.addOcspResponse((OCSPResponse)((Object)iterator));
                object2 = ((OCSPResponse)((Object)iterator)).getBasicOcspResponse().getCerts();
                n = ((X509CertificateHolder[])object2).length;
                for (n2 = 0; n2 < n; ++n2) {
                    iterator = object2[n2];
                    iterator = new Certificate(new JcaX509CertificateConverter().setProvider(ProvUtils.bcProvider).getCertificate((X509CertificateHolder)iterator));
                    lTResource.addCert((Certificate)((Object)iterator));
                    try {
                        ((Certificate)((Object)iterator)).getInternalCert().verify(((ChainEntry)object3).getCert().getPublicKey());
                        continue;
                    }
                    catch (Exception exception) {
                        iterator = this.c.retrieveCertificateChain((Certificate)((Object)iterator));
                        if (((CertChain)((Object)iterator)).getStartEntry().getParent() == null) continue;
                        iterator = ((CertChain)((Object)iterator)).iterator();
                        while (iterator.hasNext()) {
                            ChainEntry chainEntry = iterator.next();
                            lTResource.addCert(chainEntry.getCert());
                        }
                    }
                }
                continue;
            }
            Certificate certificate2 = certificate;
            object3 = this;
            iterator = new UrlClient(((LTResourceResolver)object3).a);
            object2 = new ValidatorConfig();
            object2.setElement("verify.mode", "CRLONLY");
            object2 = CRLUtils.getCrlForCertificate((UrlClient)iterator, (ValidatorConfig)object2, certificate2, new Date(), ((LTResourceResolver)object3).c);
            if (object2 == null) {
                throw new CapiException("Unable to get revocation status for certificate " + certificate.getSubjectDN(), 30005);
            }
            lTResource.addCrl((CRL)object2);
        }
        if (!lTResource.isResolved()) {
            throw new CapiException("Unable to resolve LT resources for certificate " + certificate.getSubjectDN(), 1003);
        }
        return lTResource;
    }

    private OCSPResponse a(Certificate certificate, Certificate certificate2) {
        try {
            HttpOCSPClient httpOCSPClient = new HttpOCSPClient(this.a, this.b, this.c);
            if (this.a(certificate) != null) {
                return httpOCSPClient.sendOCSPRequest(this.a(certificate), certificate, certificate2);
            }
        }
        catch (CapiException capiException) {
            this.b.error("unable to call OCSP: " + capiException.getMessage() + " " + capiException.getErrorCode(), (Throwable)capiException);
        }
        catch (OCSPException oCSPException) {
            this.b.error("unable to call OCSP: " + oCSPException.getMessage(), (Throwable)oCSPException);
        }
        catch (Exception exception) {
            this.b.error("unable to call OCSP: " + exception.getMessage(), (Throwable)exception);
        }
        return null;
    }

    private String a(Certificate dERTaggedObject) {
        try {
            byte[] byArray = dERTaggedObject.getInternalCert().getExtensionValue(Extension.authorityInfoAccess.getId());
            dERTaggedObject = (DERTaggedObject)byArray;
            if (byArray != null) {
                dERTaggedObject = X509ExtensionUtil.fromExtensionValue((byte[])dERTaggedObject);
                dERTaggedObject = AuthorityInformationAccess.getInstance((Object)((ASN1Sequence)dERTaggedObject));
                dERTaggedObject = dERTaggedObject.getAccessDescriptions();
                int n = ((AccessDescription[])dERTaggedObject).length;
                for (int i = 0; i < n; ++i) {
                    AccessDescription accessDescription = dERTaggedObject[i];
                    if (!accessDescription.getAccessMethod().equals((ASN1Primitive)AccessDescription.id_ad_ocsp)) continue;
                    dERTaggedObject = (DERTaggedObject)accessDescription.getAccessLocation().toASN1Primitive();
                    dERTaggedObject = dERTaggedObject.getObjectParser(6, true).toASN1Primitive();
                    return dERTaggedObject.toString();
                }
            }
        }
        catch (Exception exception) {
            this.b.error(exception.getMessage(), (Throwable)exception);
            return null;
        }
        return null;
    }
}

