/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.container;

import it.actalis.ellips.capi.container.ContainerGeneratorOptions;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.signature.BaseGenerator;
import it.actalis.ellips.capi.signature.SignatureOptions;

public abstract class ContainerGenerator<T extends ContainerGeneratorOptions<K>, K extends SignatureOptions>
extends BaseGenerator<T> {
    protected final void validateEntryOptions(K k) throws CapiException {
        if (k == null) {
            throw new CapiException("Entry options are null.", 1001);
        }
        this.specificValidateEntryOptions(k);
    }

    public final void pack(T t) throws CapiException {
        this.generate(t);
    }

    public void update(K k) throws CapiException {
        this.innerUpdate(k);
    }

    protected abstract void innerUpdate(K var1) throws CapiException;

    protected abstract void specificValidateOptions(T var1) throws CapiException;

    protected abstract void specificValidateEntryOptions(K var1) throws CapiException;

    protected abstract void specificPreProcessEntries(T var1) throws CapiException;

    protected abstract void specificPackEntry(K var1) throws CapiException;

    protected abstract void specificPostProcessEntries(T var1) throws CapiException;

    @Override
    public final void validateOptions(T object) throws CapiException {
        if (object == null) {
            throw new CapiException("Options are null.", 1001);
        }
        if (((ContainerGeneratorOptions)object).getSignEntriesOptions() == null) {
            throw new CapiException("ASiC options: list of signing entries is null.", 1001);
        }
        if (((ContainerGeneratorOptions)object).getSignEntriesOptions().isEmpty()) {
            throw new CapiException("ASiC options: list of signing entries is empty.", 1002);
        }
        this.specificValidateOptions(object);
        for (SignatureOptions signatureOptions : ((ContainerGeneratorOptions)object).getSignEntriesOptions()) {
            this.validateEntryOptions(signatureOptions);
        }
    }

    @Override
    protected void doGenerate() throws CapiException {
        ContainerGenerator containerGenerator = this;
        containerGenerator.specificPreProcessEntries((ContainerGeneratorOptions)containerGenerator.options);
        for (SignatureOptions signatureOptions : ((ContainerGeneratorOptions)this.options).getSignEntriesOptions()) {
            this.specificPackEntry(signatureOptions);
        }
        ContainerGenerator containerGenerator2 = this;
        containerGenerator2.specificPostProcessEntries((ContainerGeneratorOptions)containerGenerator2.options);
    }
}

