/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core;

import esecurity.dts.TimeStampToken;
import esecurity.tsl.CertChain;
import esecurity.tsl.ChainEntry;
import esecurity.tsl.ServiceDbItem;
import esecurity.validator.DateSource;
import esecurity.validator.ValidationDate;
import esecurity.validator.bean.LevelValidation;
import esecurity.validator.constants.SignatureFormat;
import esecurity.validator.steps.SignatureValidationStep;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.annotations.StepOrder;
import esecurity.validator.utils.LevelValidationUtils;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.signature.SignatureLevel;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.cms.CMSException;

@StepOrder(order=0)
public class StepValidationLevel
extends SignatureValidationStep {
    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> object, ValidationContextParameters object2) {
        object = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
        ((DateFormat)object).setTimeZone(((ValidationContextParameters)object2).getTimeZone());
        if (((ValidationContextParameters)object2).getSignature() == null) {
            return null;
        }
        try {
            if (((ValidationContextParameters)object2).getSignature().getFormat().equals((Object)SignatureFormat.TST)) {
                ValidationContextParameters validationContextParameters = object2;
                object2 = object;
                object = validationContextParameters;
                if (validationContextParameters.getSignerCertificate() != null && ((ValidationContextParameters)object).getSignature().getSignatureDate() != null) {
                    object2 = new ValidationDate(((DateFormat)object2).parse(((ValidationContextParameters)object).getSignature().getSignatureDate()), DateSource.TIMESTAMP);
                    ((ValidationContextParameters)object).setCalculatedValidationDate((ValidationDate)object2);
                } else if (((ValidationContextParameters)object).getValidationDate() != null) {
                    Object object3 = object;
                    ((ValidationContextParameters)object3).setCalculatedValidationDate(((ValidationContextParameters)object3).getValidationDate());
                } else {
                    object2 = new ValidationDate(new Date(), DateSource.SYSTEM);
                    ((ValidationContextParameters)object).setCalculatedValidationDate((ValidationDate)object2);
                }
                return null;
            }
            if (((ValidationContextParameters)object2).getSignature().getTimeStampTokens() != null && !((ValidationContextParameters)object2).getSignature().getTimeStampTokens().isEmpty()) {
                if (((ValidationContextParameters)object2).getSignature().getTimeStampTokens().get(0) != null) {
                    object = new TimeStampToken(((ValidationContextParameters)object2).getSignature().getTimeStampTokens().get(0).getSignatureInfo());
                    Object object4 = ((TimeStampToken)object).getTSACert();
                    if (object4 == null) {
                        if (((ValidationContextParameters)object2).getValidationDate() == null) {
                            ValidationDate validationDate = new ValidationDate(new Date(), DateSource.SYSTEM);
                            ((ValidationContextParameters)object2).setCalculatedValidationDate(validationDate);
                            return null;
                        }
                        Object object5 = object2;
                        ((ValidationContextParameters)object5).setCalculatedValidationDate(((ValidationContextParameters)object5).getValidationDate());
                        return null;
                    }
                    Object object6 = null;
                    try {
                        object6 = ((ValidationContextParameters)object2).getSignerCertificate().getCert();
                    }
                    catch (Exception exception) {}
                    object4 = LevelValidationUtils.validateLevelByRefCRL(((TimeStampToken)object).getDate(), (Certificate)object6, (Certificate)object4, ((ValidationContextParameters)object2).getLstCert(), ((ValidationContextParameters)object2).getLstOcsp(), ((ValidationContextParameters)object2).getDoc().getCrls(), this.logger, ((ValidationContextParameters)object2).getConfig().getNetConfiguration());
                    if (object4 != null) {
                        if (((LevelValidation)object4).getSignerChain() != null) {
                            this.a((LevelValidation)object4, (ValidationContextParameters)object2);
                        }
                        ((ValidationContextParameters)object2).setLevelValidation((LevelValidation)object4);
                        if (((LevelValidation)object4).getLevel().compareTo(SignatureLevel.T) >= 0) {
                            boolean bl = false;
                            if (((ValidationContextParameters)object2).getValidationDate() != null) {
                                try {
                                    object6 = ((ValidationContextParameters)object2).getValidationDate().getDate();
                                    Date date = ((TimeStampToken)object).getDate();
                                    if (date.after((Date)object6)) {
                                        Object object7 = object2;
                                        ((ValidationContextParameters)object7).setCalculatedValidationDate(((ValidationContextParameters)object7).getValidationDate());
                                        bl = true;
                                    }
                                }
                                catch (Exception exception) {
                                    this.logger.debug(exception.getMessage());
                                }
                            }
                            if (!bl) {
                                object6 = new ValidationDate(((TimeStampToken)object).getDate(), DateSource.TIMESTAMP);
                                ((ValidationContextParameters)object2).setCalculatedValidationDate((ValidationDate)object6);
                            }
                        }
                    }
                }
                StepValidationLevel.a((ValidationContextParameters)object2);
                return null;
            }
            if (((ValidationContextParameters)object2).getSignerCertificate() != null && ((ValidationContextParameters)object2).getSignerCertificate().isRsVerified()) {
                object = ((ValidationContextParameters)object2).getSignature().getSignerInfoData().getSignerInfo();
                Time time = StepValidationLevel.a((SignerInfo)object);
                ValidationDate validationDate = new ValidationDate(time.getDate(), DateSource.RSVERIFIED);
                ((ValidationContextParameters)object2).setCalculatedValidationDate(validationDate);
            }
            StepValidationLevel.a((ValidationContextParameters)object2);
        }
        catch (Throwable throwable) {
            this.logger.error(throwable.getMessage());
        }
        return null;
    }

    private static void a(ValidationContextParameters validationContextParameters) {
        if (validationContextParameters.getCalculatedValidationDate() != null) {
            return;
        }
        if (validationContextParameters.getValidationDate() == null) {
            ValidationDate validationDate = new ValidationDate(new Date(), DateSource.SYSTEM);
            validationContextParameters.setCalculatedValidationDate(validationDate);
            return;
        }
        ValidationContextParameters validationContextParameters2 = validationContextParameters;
        validationContextParameters2.setCalculatedValidationDate(validationContextParameters2.getValidationDate());
    }

    private void a(LevelValidation levelValidation, ValidationContextParameters object) {
        Object object2;
        LinkedList<ChainEntry> linkedList = new LinkedList<ChainEntry>();
        for (int i = 0; i < ((ValidationContextParameters)object).getLstCert().size(); ++i) {
            object2 = ((ValidationContextParameters)object).getLstCert().get(i);
            boolean bl = ((ValidationContextParameters)object).getCertDB().containsCertificate((Certificate)object2);
            if (!bl) continue;
            Object object3 = ((ValidationContextParameters)object).getCertDB().queryServiceItems((Certificate)object2);
            linkedList.add(new ChainEntry((List<ServiceDbItem>)object3));
        }
        Object object4 = null;
        object2 = null;
        for (Object object3 : levelValidation.getSignerChain()) {
            object = StepValidationLevel.a(linkedList, (ChainEntry)object3);
            if (object2 == null) {
                object4 = object;
                object2 = object;
                continue;
            }
            ((ChainEntry)object2).setParent((ChainEntry)object);
            object2 = object;
        }
        CertChain certChain = new CertChain((ChainEntry)object4);
        levelValidation.setSignerChain(certChain);
    }

    private static ChainEntry a(LinkedList<ChainEntry> linkedList, ChainEntry chainEntry) {
        for (int i = 0; i < linkedList.size(); ++i) {
            if (!chainEntry.getCert().equals(linkedList.get(i).getCert())) continue;
            return linkedList.get(i);
        }
        return chainEntry;
    }

    private static Time a(SignerInfo signerInfo) throws CMSException {
        ASN1Primitive aSN1Primitive;
        SignerInfo signerInfo2 = signerInfo;
        String string = "signing-time";
        signerInfo = CMSAttributes.signingTime;
        AttributeTable attributeTable = null;
        if (signerInfo2.getUnauthenticatedAttributes() != null) {
            attributeTable = new AttributeTable(signerInfo2.getUnauthenticatedAttributes());
        }
        if (attributeTable != null && attributeTable.getAll((ASN1ObjectIdentifier)signerInfo).size() > 0) {
            throw new CMSException("The " + string + " attribute MUST NOT be an unsigned attribute");
        }
        attributeTable = null;
        if (signerInfo2.getAuthenticatedAttributes() != null) {
            attributeTable = new AttributeTable(signerInfo2.getAuthenticatedAttributes());
        }
        if (attributeTable == null) {
            aSN1Primitive = null;
        } else {
            signerInfo = attributeTable.getAll((ASN1ObjectIdentifier)signerInfo);
            switch (signerInfo.size()) {
                case 0: {
                    aSN1Primitive = null;
                    break;
                }
                case 1: {
                    signerInfo = (Attribute)signerInfo.get(0);
                    signerInfo = signerInfo.getAttrValues();
                    if (signerInfo.size() != 1) {
                        throw new CMSException("A " + string + " attribute MUST have a single attribute value");
                    }
                    aSN1Primitive = signerInfo.getObjectAt(0).toASN1Primitive();
                    break;
                }
                default: {
                    throw new CMSException("The SignedAttributes in a signerInfo MUST NOT include multiple instances of the " + string + " attribute");
                }
            }
        }
        signerInfo = aSN1Primitive;
        if (aSN1Primitive == null) {
            return null;
        }
        try {
            return Time.getInstance((Object)signerInfo);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException("signing-time attribute value not a valid 'Time' structure");
        }
    }
}

